/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalSorter
extends Expression {
    private Expression condition;
    private DocumentSorter documentSorter;

    public ConditionalSorter(Expression condition, DocumentSorter sorter) {
        this.condition = condition;
        this.documentSorter = sorter;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public DocumentSorter getDocumentSorter() {
        return this.documentSorter;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.condition = visitor.typeCheck(this.condition, contextItemType);
        Expression sorter = visitor.typeCheck(this.documentSorter, contextItemType);
        if (sorter instanceof DocumentSorter) {
            this.documentSorter = (DocumentSorter)sorter;
            return this;
        }
        return sorter;
    }

    @Override
    public int getCardinality() {
        return this.documentSorter.getCardinality();
    }

    @Override
    protected int computeSpecialProperties() {
        return this.condition.getSpecialProperties() | 0x20000;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator<Expression>(this.condition, this.documentSorter);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.condition == original) {
            this.condition = replacement;
            found = true;
        }
        if (this.documentSorter == original) {
            this.documentSorter = (DocumentSorter)replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression expr1 = visitor.optimize(this.condition, contextItemType);
        if (this.condition != expr1) {
            this.condition = expr1;
            this.resetLocalStaticProperties();
        }
        if (Literal.isConstantBoolean(this.condition, true)) {
            return this.documentSorter;
        }
        if (Literal.isConstantBoolean(this.condition, false)) {
            return this.documentSorter.getBaseExpression();
        }
        return this;
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public Expression copy() {
        return new ConditionalSorter(this.condition.copy(), (DocumentSorter)this.documentSorter.copy());
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("conditionalSort");
        this.condition.explain(out);
        this.documentSorter.explain(out);
        out.endElement();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.documentSorter.getItemType(th);
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.condition = this.doPromotion(this.condition, offer);
        Expression e = this.doPromotion(this.documentSorter, offer);
        if (e instanceof DocumentSorter) {
            return this;
        }
        return e;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        boolean b = this.condition.effectiveBooleanValue(context);
        if (b) {
            return this.documentSorter.iterate(context);
        }
        return this.documentSorter.getBaseExpression().iterate(context);
    }
}

