## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Ka v1.1.8;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Ka::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=for stopwords CTAN Ipenburg Ka

=head1 NAME

TeX::Hyphen::Pattern::Ka - class for hyphenation in locale Ka

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 COPYRIGHT

=begin text

title: Hyphenation patterns for Georgian
copyright: Copyright (C) 2013 Levan Shoshiashvili
notice: This file is part of the hyph-utf8 package.
    See http://www.hyphenation.org/tex for more information.
source: http://tex.tsu.ge
language:
    name: Georgian
    tag: ka
version: 0.3 (April 2013)
authors:
  -
    name: Levan Shoshiashvili
    contact: shoshia (at) hotmail.com
licence:
    name: LPPL
    version: 1.3
    or_later: true
    url: http://www.latex-project.org/lppl.txt
hyphenmins:
    typesetting:
        left: 1
        right: 2
changes:
    - 2013-04-15, version 0.3 Patterns regenerated with lefthyphenmin=1
    - 2013-03-01, version 0.2 Hyphenation patterns are regenerated from new wordlist
          (bigger wordlist, 150K words total, some words are fixed)
    - 2013-02-25, version 0.1 First release
texlive:
    encoding: t8m
    babelname: georgian
    message: Georgian hyphenation patterns
    description: Hyphenation patterns for Georgian in T8M, T8K and UTF-8 encodings.
==========================================
Generated using patgen2.

=end text

=cut

__DATA__
\patterns{
.ავ4რწყა
.აი2ა
.ერ2თხ
.ერ2ტ
.ირ2ტ
.ურ2ტ
.უფრ2
.ფრ2
ა1ა
ა1ბ
აბ3ლდ
აბ3ნვ
აბ3რკ
აბრ3წ
აბ3სკ
აბ3სტ
ა1გ
აგ3გვ
აგ3გზ
აგ3ვბ
აგ3ვდ
აგ3ვთ
აგ3ვკ
აგ3ვლ
აგ3ვმ
აგ3ვნ
აგ3ვრ
აგ3ვს
აგ3ვქ
აგ3ვყ
აგ3ვშ
აგ3ვჩ
აგ3ვც
აგ3ვძ
აგ3ვწ
აგ3ვჭ
აგ3ვხ
აგ3ზლ
აგ3ზნ
ა2გ1ლ
ა2გ1მ
აგ3მნ
აგ3რჩ
აგ3სვ
აგ3სმ
აგ3სხ
აგ3ყვ
ა2გშ
აგ3ში
აგ3ცდ
აგ3ძვ
აგ3ძრ
აგ3ჭრ
აგ3ხვ
აგ3ხს
ა1დ
ად3გნ
ა2დ1ზ
ად3ლმ
ად3ლფ
ად3მყ
ა2დ1ნ
ა1ე
ა1ვ
ავ3ბნ
ავ3ბრ
ავ3გზ
ავ3დგ
ავ3ზვ
ავ3ზშ
ავ3თბ
ავ3თმ
ავ3კმ
ავ3კრ
ავ3ლდ
ავ3ლნ
ავ3მდ
ავ3მს
ავ3მშ
ავ3მჯ
ავ3ნდ
ავ3ნძ
ავ3რბ
ავ3რდ
ავ3რთ
ავ3რკ
ავ3რმ
ავ3რჩ
ავ3რც
ავ3რწ
ავ3სდ
ავ3სვ
ავ3სთ
ავ3სკ
ავ3სმ
ავ3სტ
ავ3სძ
ავ3სწ
ავ3სხ
ავ3სჯ
ავ3ტვ
ავ3ყვ
ავ3ყრ
ავ3შვ
ავ3შლ
ავ3შნ
ავ3შრ
ავ3შტ
ავ3ცდ
ავ3ცლ
ავ3ცნ
ავ3ძვ
ავ3ძრ
ავ3წვ
ავ3ჭრ
ავ3ხდ
ავ3ხვ
ავ3ხს
ავ3ხტ
ავ3ჯდ
ა1ზ
აზ3რდ
აზ3რზ
აზ3რთ
აზ3რმ
აზ3სკ
ა1თ
1ათას
ათ3გვ
ათ3გრ
ა2თ1ვ
ათ3ვლ
ათ3ვრ
ათ3კვ
ა2თ1ლ
ათ3მფ
ათ3მყ
ათ3რგ
ა3თ2ქო
ა1ი
ა1კ
აკარ4გს.
ა2კბ
აკ3ბე
აკ1დ
აკ3ვდ
აკ3ვთ
აკ3ვლ
აკ3ვნ
აკ3ვრ
აკ3ლდ
აკ3ლთ
აკ3რთ
ა1ლ
ალ3გვ
ალ3გზ
ალ3დშ
ალ3თმ
ალ3მდ
ალ3მხ
ალ3სკ
ალ3სტ
ალ3ტბ
ალ3ტრ
ალ3ღრ
ალ3ყზ
ალ3შვ
ალ3ცრ
ალ3წვ
ალ3ხზ
ალ3ხთ
ალ3ხს
ალ3ხშ
ა1მ
2ამბავი.
ამ3ბლ
ამ3ბნ
ამ3ბრ
ამ3გვ
ამ3გზ
ამ3გრ
ამ3დგ
ამ3დვ
ამ3ვლ
ამ3ზრ
ამ3თრ
ამ3თქ
ამ3კვ
ამ3კლ
ამ3კრ
ამ3ლზ
ამ3ნთ
ამ3პლ
ამ3რგ
ამ3რთ
ამ3რტ
ამ3რღ
ამ3რჩ
ამ3რჯ
ამ3სგ
ამ3სვ
ამ3სტ
ამ3სწ
ამ3სჭ
ამ3სხ
ამ3სჯ
ამ3ტვ
ამ3ტრ
ამ3ფლ
ამ3ფს
ამ3ღვ
ამ3ღლ
ამ3ყვ
ამ3ყნ
ამ3ყრ
ამ3შვ
ამ3შლ
ამ3შრ
ამ3ჩნ
ამ3ცდ
ამ3ცვ
ამ3ცთ
ამ3ცნ
ამ3ძლ
ამ3წვ
ამ3წკ
ამ3ჭრ
ამ3ხდ
ამ3ხვ
ამ3ხნ
ამ3ხრ
ამ3ხს
ამ3ჯდ
ა1ნ
ან3გვ
ან3გთ
ან3გრ
ან3გჯ
ან3დგ
ან3დვ
ან3დლ
ან3დმ
ან3დრ
ან3დს
ან3დშ
ან3ვთ
ან3ვლ
ან3ვმ
ან3ვრ
ან3ვს
ან3ვც
ან3ზრ
ან3თრ
ან3თქ
ან3კმ
ან3კშ
ან3მგ
ან3მდ
ან3მზ
ან3მრ
ან3მს
ან3მტ
ან3მხ
ან3მჯ
ან3სვ
ან3სმ
ან3სპ
ან3სშ
ან3სც
ან3სწ
ან3სხ
ან3სჯ
ან3ტვ
ან3ტთ
ან3ტმ
ან3ღვ
ან3ყრ
ან3შტ
ან3ცდ
ან3ცვ
ან3ცლ
ან3ცმ
ან3ძლ
ან3ძრ
ან3ჭვ
ან3ჭნ
ან3ხვ
ან3ხლ
ან3ხრ
ან3ჯგ
ან3ჯდ
ა1ო
ა1პ
ა1ჟ
აჟ3რჟ
ა2ჟღ
ა1რ
არახ2ვ
არ3ბდ
არ3ბშ
არ3გბ
არ3გდ
არ3გვ
არ3გზ
არ3გნ
არ3გს
არ3გძ
არ3დგ
არ3დვ
არ3დთ
არ3დლ
არ3დმ
არ3დშ
ა2რ1ერ
არ3ვლ
არ3ვყ
არ3ვწ
არ3ზნ
არ3თზ
არ3თთ
არ3თმ
არ3თნ
არ3თქ
არ3თშ
არ3კვ
არ3კლ
არ3კმ
არ3მთ
არ3მყ
არ3სდ
არ3სკ
არ3სტ
არ3ტვ
არ3ტმ
არ3ტრ
არ3ფლ
არ3ღვ
არ3ღნ
არ3ყვ
არ3შვ
არ3შრ
არ3ჩნ
არ3ცვ
არ3ცთ
არ3ცმ
ა2რ1ძ
არ3ძლ
არ3ხვ
არ3ხნ
ა1ს
ას1ასი
ასახ4ლს.
ას3გვ
ას3გზ
ას3დგ
ას3დრ
ას1ექ
ას3ვთ
ას3ვლ
ას3ვრ
ას3თმ
ას3თრ
ას3თქ
ას3კდ
ას3კვ
ას3კნ
ას3მე
ა2ს1ნ
ას3პშ
ას3რვ
ას3რშ
ას3სთ
ას3ტზ
ას3ტრ
ას3შტ
ას3ცდ
ას3ცლ
ას3ცნ
ას3ძლ
ას3ძრ
ას3წვ
ას3ჭრ
ას3ხდ
ას3ხვ
ას3ხლ
ას3ხრ
ა1ტ
ატ1ვ
ატ3ვრ
ა2ტ1კ
ატ3კნ
ატ3კრ
ატ1რ
ატ3რლ
ატ3რფ
ატ3რშ
ატ3სკ
ა2ტფ
ატ3ფო
ა2ტშ
ატ3ში
ა1უ
ა1ფ
აფ3თრ
აფ3ლწ
აფ3რდ
აფ3რქ
აქ1ვ
აქ3ვდ
აქ3ვნ
აქ3მნ
აქ3რნ
აქ3ტზ
აქ3ტმ
ა1ღ
აღ3გზ
აღ3დგ
აღ1ვ
აღ3ვლ
აღ3ვნ
აღ3ვრ
აღ3ვშ
აღ3ზრ
აღ3თქ
აღ3კვ
აღ3ლდ
აღ3ლთ
აღ3ლმ
აღ3მგ
აღ3მდ
აღ3მზ
აღ3მკ
აღ3მრ
აღ3მძ
აღ3მწ
აღ3მხ
აღ3რმ
აღ3რღ
აღ3სდ
აღ3სრ
აღ3ფრ
აღ3ძვ
აღ3ძრ
ა1ყ
აყ1დ
აყ3დრ
აყ3ვზ
აყ3ვლ
აყ1რ
აყ3რდ
ა1შ
აშ3ვრ
ა2შზ
აშ3ლზ
აშ3ტრ
ა2შფ
აშ3ფა
აშ3ფო
ა1ჩ
აჩ3ნდ
აჩ3რდ
ა1ც
აც3ვლ
აც3თმ
აც3მლ
ა2ც1ქ
აც3ქე
აც3ქვ
ა1ძ
აძარ4ცვ.
აძ3ვრ
აძ3რწ
ა1წ
აწ3ვდ
აწ3ვნ
აწ3ვრ
ა2წლ
ა2წმ
აწ3მყ
ა2წ1რ
აწ3რთ
ა1ჭ
აჭ3ვზ
აჭ3ვრ
აჭ3მლ
ა1ხ
ახ1ვ
ახ3ვდ
ახ3ვრ
ახ1ზ
ახ3ლდ
ახ3ლთ
ახ3ლკ
ახ3ლმ
ახ3ლს
ახ3ლშ
ა2ხ1მ
ახ1რ
ახ3რჩ
ახ3რწ
ახ3სრ
ახ3ტზ
ახ3ტნ
ახ3ტრ
ახ3შთ
ახ3შმ
ა1ჯ
ა2ჯ1ვ
ა2ჯმ
აჰ3კვ
აჰ3კრ
აჰ3ყვ
აჰ3ყრ
აჰ3ხვ
აჰ3ხს
1ბა
ბა3თ2ვ
2ბ1გ
2ბ1დ
1ბე
2ბ1ვ2
2ბ1ზ2
2ბ1თ2
1ბი
2ბ1ლ2
2ბ1მ
2ბ1ნ2
1ბო
ბო3თ2ქ
2ბ1ჟ
2ბ1რ2
2ბ1ს2
1ბუ
2ბ1ქ
1ბღ2
2ბ1შ
2ბ1ჩ
2ბ1ც
2ბ1ჭ
2ბ1ჯ
2გ1ბ
2გ1გ2
2გ1დ
2გ1ვ2
გ3ვთა
2გ1ზ2
2გ1თ2
გიერ4თს.
გი2მო
2გ1კ2
გ1ლე
3გლეჯვ
გმ2
2გ1ნ
2გ1პ
2გ1ჟ
2გ1რ2
2გ1ს2
2გ1ტ
1გუ
2გ1ღ
2გ1ყ2
გ2შ2
გ1შრ
2გ1ჩ
2გ1ც2
2გ1ძ2
2გ1წ
2გ1ჭ2
2გ1ხ2
2გ1ჯ
2დ1ბ
2დ1გ2
2დ1დ
დე3რი
დეღ2
დე3ღრ
2დ1ვ
2დ1თ2
2დიღბალმ
2დიღბლის
2დ1კ
2დ1ლ2
2დ1მ2
1დნ
დ1ნა
2დ1პ
2დ1ჟ
2დ1რ2
დ3რსა
2დ2ს2
დ2ფ
2დ1ქ
დღ2
2დ1ყ
2დ1შ2
2დ1ჩ
2დ1წ
2დ1ხ
2დ1ჯ
2დ1ჰ2
ე1ა
ეარა3
ე1ბ
ებ3სვ
ებ3სთ
ებ3სმ
ე1გ
ეგ3ვკ
ეგ3ვპ
ეგ3ვრ
ეგ3ვშ
ეგ3ვწ
ეგ3ვჭ
ეგ3ვხ
ე2გლ
ე2გ1მ
ეგ3მვ
ეგ3რჩ
ეგ3ყვ
ე2გშ
ეგ3ში
ეგ3შრ
ეგ3ცდ
ეგ3ძლ
ეგ3ხვ
ე1დ
ე2დ1ზ
ე2დ1ნ
ედ3რდ
ედ3რკ
ედ3სა
ე1ე
2ეეტ
ე1ვ
ევ3ბრ
ევ3დგ
ევ3თმ
ევ3კრ
ევ3ლთ
ევ3ლმ
ევ3ლშ
ევ3ლჩ
ევ3მც
ევ3რგ
ევ3რდ
ევ3რზ
ევ3რკ
ევ3რმ
ევ3რნ
ევ3რს
ევ3რჩ
ევ3რც
ევ3რჯ
ევ3სკ
ევ3სრ
ევ3სწ
ევ3სხ
ევ3ყვ
ევ3ცდ
ევ3ცვ
ევ3ძვ
ევ3ძლ
ევ3ხვ
ევ3ხტ
ევ3ჯდ
ე1ზ
ეზ3რბ
ეზ3რდ
ე1თ
ე2თ1ვ
ეთ3ვლ
ეთ3ვრ
ე2თ1ლ
ეთ3რგ
ეთ3რვ
ეთ3რს
ეთ3რწ
ეთ3ქლ
ე1ი
ე1კ
ეკ1დ
ეკ3ვრ
ეკ3რთ
ე1ლ
ელ3გვ
ელ3დშ
ელ3ვყ
ელ3მყ
ელ3მძ
ელ3მწ
ელ3მხ
ელ3ყვ
ელ3წვ
ე1მ
ემა4სმეთ
ემ3ბრ
ემ3გზ
ემ3დგ
ემ3დრ
ემ3კვ
ემ3კრ
ემ3ლდ
ემ3ლმ
ემ3პმ
ემ3რჩ
ემ3რც
ემ3სგ
ემ3სკ
ემ3სრ
ემ3სყ
ემ3სწ
ემ3სჯ
ემ3შვ
ემ3შლ
ემ3ჩნ
ემ3ცბ
ემ3ცდ
ემ3ცვ
ემ3ძვ
ემ3ძლ
ემ3წვ
ემ3ჭმ
ემ3ხვ
ემ3ხრ
ე1ნ
ენ3დდ
ენ3დრ
ენ3დს
ენ3თქ
ენ3სკ
ენ3სმ
ენ3ტთ
ენ3ტმ
ენ3ტრ
ენ3ჩვ
ე1ო
ე1პ
ე1რ
ე2რ1არ
ერ3გზ
ერ3დგ
ერ3დშ
ერ3ვლ
ერ3თბ
ერ3თგ
ერ3თდ
ერ3თზ
ერ3თთ
ერ3თკ
ერ3თმ
ერ3თნ
ერ3თს
ერ3თფ
ერ3თშ
ერ2თხა
ერ3კვ
ერ3მკ
ერ1ოფ
ერ3პლ
ერ3სზ
ერ3სმ
ერ3სპ
ერ3სტ
ერ3ტბ
ერ3ტზ
ერ3ტმ
ერ3ფლ
ერ3ფმ
ერ3ღვ
ერ3შლ
ერ3ჩხ
ერ3ცვ
ე2რ1ძ
ერ3ძნ
ერ3წვ
ერ3წკ
ერ3ხდ
ერ3ხვ
ერ3ხზ
ერ3ხთ
ერ3ხს
ე1ს
ეს3დგ
ეს3ვგ
ეს3ვლ
ეს3ვმ
ეს3ვრ
ეს3თქ
ეს3კნ
ეს3კრ
ეს3ლმ
ე2სნ
ეს3ტმ
ეს3ტნ
ეს3ძლ
ეს3ძრ
ეს3ხდ
ეს3ხვ
ეს3ხზ
ე1ტ
ეტ3გვ
ე2ტ1კ
ეტ3ლთ
ეტ3ლმ
ეტ3ლშ
ეტ1რ
ეტ3რფ
ე2ტშ
ეტ3ში
ეტ3ჩვ
ეტ3ხნ
ე1უ
ე1ფ
ექ1ვ
ექ3ვთ
ექ3ვს
ექ3მნ
ექ3რთ
ექ3სკ
ექ3სპ
ექ3სტ
ექ3სც
ექ3ტზ
ექ3ტმ
ექ3ცნ
ე1ღ
ეღ1ვ
ე1ყ
ეყ1ნ
ეყ3ნდ
ეყ1რ
ეყ3რდ
ე1შ
ეშ3ვნ
ეშ3ტრ
ე2შფ
ეშ3ფო
ე1ჩ
ე1ც
ეც3ვლ
ე2ცქ
ეც3ქე
ეც3ქი
ე1ძ
ეძ3ვრ
ე1წ
ეწ3ვზ
ეწ3კვ
ე2წმ
ე2წ1რ
ეჭ3ვდ
ეჭ3ვმ
ე1ხ
ეხ3დგ
ეხ1ვ
ეხ3ვდ
ეხ3ვზ
ეხ1ზ
ე2ხ1მ
ეხ3მძ
ეხ3ტნ
ეხ1ყ
ეხ1ჰ
ე1ჯ
ეჯ1გ
ეჯ3გვ
ე2ჯ1ვ
ე2ჯნ
ეჰ3კრ
ეჰ3ყვ
2ვ1ბ2
2ვ1გ2
2ვ1დ2
2ვ1ვ2
2ვ1ზ2
2ვ1თ2
ვი2რუ
2ვ1კ2
ვკარ4გს.
2ვ1ლ2
2ვ1მ2
2ვ1ნ2
2ვ1ოხ
2ვ1პ
ვჟ2
2ვ1რ2
ვ3რსა
2ვ1ს2
ვს3თხ
2ვ1ტ2
1ვუ
2ვ1ფ2
2ვ1ქ2
2ვ1ღ
2ვ1ყ2
2ვ1შ2
2ვ1ჩ
2ვ1ც2
2ვ1ძ2
2ვ1წ2
2ვ1ჭ2
2ვ1ხ2
2ვ1ჯ2
2ზ1ბ
2ზ1გ
2ზ1დ
2ზ1ვ2
2ზ1ზ
2ზ1თ
2ზ1ლ2
2ზ1მ2
2ზ1ნ
2ზ1რ2
ზ3რსა
2ზ1ს2
ზღ2
2ზ1შ
თა2სათ
თა2სე
2თ1ბ
2თ1გ2
2თ1დ2
თვ2
თ1ვა
თ1ვო
თ1ვრ
2თ1ზ
2თ1თ
თ2თხ
2თ1იქ
2თ1კ2
თლ2
თ1ლდ
2თ1მ2
2თ1ნ
2თ1ოცდაა
2თ1რ2
2თ1ს2
2თ1ფ2
2თ1ქ2
2თ1ღ
2თ1შ
2თ1ც2
თხ2
2თხ.
2თხს
3თხსა
2თ1ჯ
ი1ა
ია3მ2ზ
ი1ბ
იბ3ვლ
იბ3რზ
იბ3რტ
იბ3რჭ
იბ3რჯ
ი1გ
იგ3ვრ
იგ3ვყ
ი2გ1ლ
ი2გმ
იგ3რგ
ი2გშ
იგ3ში
ი1დ
იდ3გვ
იდ3გნ
ი2დ1ზ
იდ3მნ
იდ3მპ
ი2დ1ნ
იდ3რდ
იდ3რვ
იდ3რნ
იდ3სა
იდ3შვ
ი1ე
ი1ვ
ივ3ბრ
ივ3დგ
ივ3თთ
ივ3ლდ
ი2ვჟ
ივ3რბ
ივ3რდ
ივ3რზ
ივ3რშ
ივ3რც
ივ3სღ
ივ3ფს
ივ3ყვ
ივ3ძლ
ივ3წვ
ივ3ხვ
ივ3ჯდ
ი1ზ
იზ3ვნ
იზ3ლდ
იზ3მზ
იზ3მთ
იზ3მმ
იზ3მრ
იზ3მშ
იზ3რდ
ი1თ
ი2თ1ვ
ით3ვლ
ით3ვრ
ი2თ1ლ
ით3ლდ
ით3მკ
ით3მმ
ით3მპ
ით3რგ
ით3რდ
ით3რმ
ით3ფლ
ით3ცნ
ი1ი
ი1კ
იკ3ბი
იკ1დ
იკ3ვდ
იკ3ვლ
იკ3ვნ
ი1ლ
ილ3მს
ილ3ტვ
ილ3ღვ
ილ3შვ
ილ3ხვ
ი1მ
იმ3გზ
იმ3დგ
იმ3დრ
იმ3კვ
იმ3ნდ
იმ3რბ
იმ3რთ
იმ3სვ
იმ3სხ
იმ3სჯ
იმ3ტვ
იმ3ყნ
იმ3ყრ
იმ3შვ
იმ3შნ
იმ3შრ
იმ3ჩნ
იმ3ძლ
იმ3ხდ
იმ3ხნ
ი1ნ
ინ3გრ
ინ3დბ
ინ3დდ
ინ3დვ
ინ3დთ
ინ3დრ
ინ3დშ
ინ3თზ
ინ3თქ
ინ3კვ
ინ3კლ
ინ3კრ
ინ3სკ
ინ3სპ
ინ3სტ
ინ3სც
ინ3სწ
ინ3ტლ
ინ3ტრ
ინ3ქლ
ინ3ღლ
ინ3ცდ
ინ3ცლ
ინ3ძლ
ინ3ძმ
ინ3ძრ
ინ3წვ
ინ3ხვ
ი1ო
ი1პ
ი1ჟ
ი2ჟღ
ი1რ
ირ3გვ
ირ3თმ
ირ3კვ
ირ3კშ
ირ3მშ
ირ3სთ
ირ3სმ
ირ3სს
ირ3სშ
ირ1უნ
ირ3ღვ
ირ3ყვ
ირ3ხშ
ის3დგ
ის3დრ
ის3ვლ
ის3ვმ
ის3ვრ
ის3თქ
ის3კდ
ის3კვ
ის3კზ
ის3კრ
ის3კშ
ის3მგ
ის3მს
ის3მტ
ის3მქ
ის3მყ
ის3მშ
ის3მც
ის3მძ
ის1ნ
ის3ტდ
ის3ტვ
ის3ტთ
ის3ტმ
ის3ტრ
ის3ფრ
ის3შვ
ის3ცვ
ის3წვ
ის3ხდ
ის3ხვ
ის3ხლ
ი1ტ
იტ1ვ
იტ3ვლ
ი2ტ1კ
იტ3მშ
იტ1რ
ი1უ
ი1ფ
იფ3რდ
იფ3რქ
იფ3შვ
იქ1ვ
იქ3ვნ
იქ3მნ
იქ3ნგ
იქ3ნმ
იქ3რდ
იქ3რთ
იქ3რმ
იქ3რს
იქ3რშ
იქ3ცვ
იქ3ცნ
ი1ღ
1იღბალმ
იღ3ბლ
1იღბლის
იღ1ვ
იღ3ვრ
იღ3ვწ
იღ3რმ
იღ3რჭ
ი1ყ
იყ3ვდ
იყ3ვნ
იშ3ვლ
იშ3ვნ
იშ3კრ
იშ3ფო
იშ3ხლ
ი1ჩ
ი2ჩლ
იჩ3ნდ
იჩ3რდ
ი1ც
იც3ვლ
იც3ვნ
ი2ცქ
იც3ქე
იც3ქნ
ი1ძ
იძ3გნ
იძ3ვრ
იძ3ლშ
იძ3რნ
ი1წ
იწ3ვდ
იწ3ვნ
იწ3ვრ
იწ3კნ
იწ3კრ
ი2წმ
ი2წ1რ
იწ3რთ
ი1ჭ
იჭ3ვრ
ი2ჭ1ზ
ი1ხ
იხ1ვ
იხ3ვდ
იხ3ვნ
ი2ხ1მ
იხ1რ
იხ3რჩ
იხ3რწ
ი1ჯ
ი2ჯ1ზ
ი2ჯ1ნ
იჰ3გვ
იჰ3კრ
იჰ3ყვ
1კ2ბ
2კდ
კ1დი
კ1დო
1კე
2კ1ვ2
2კ1ზ
2კ1თ
2კ1ლ2
2კ1მ2
2კ1ნ
კო3მ2ს
2კპ
2კ1რ2
2კ1ს
2კ1ქ
2კ1შ
2კ1ჰ
1ლა
ლა3მ2ჭ
2ლ1ბ
ლბრ3ტ
ლბრ3ჭ
2ლ1გ2
2ლ1დ2
ლ3დსა
2ლეხ
2ლეჯვ
2ლ1ვ2
2ლ1ზ
2ლ1თ2
ლი3თ2ქ
2ლ1კ
2ლ1ლ
2ლ1მ2
2ლ1ნ2
ლო1
2ლ1პ
2ლ1ჟ
2ლ1რ
2ლ1ს2
2ლ1ტ2
1ლუ
2ლ1ფ
2ლ1ქ2
2ლ1ღ2
2ლ1ყ2
2ლ1შ2
2ლ1ჩ2
2ლ1ც2
2ლ1ძ
2ლ1წ2
2ლ1ხ2
2ლ1ჯ
2ლ1ჰ2
1მა
მა3ს2მ
მა3ყ2ლ
მახ3ვ
2მ1ბ2
2მ1გ2
2მ1დ2
მ2დღ
2მ1ვ2
2მ1ზ2
2მ1თ2
1მი
მის4ტრს.
2მ1კ2
2მ1ლ2
2მ1მ
2მ1ნ2
2მ1ოთხს
2მ1პ2
2მ1ჟ
2მ1რ2
2მ1ს2
2მ1ტ2
მუ3სო
2მ1ფ2
2მ1ქ2
2მ1ღ2
2მ1ყ2
2მ1შ2
2მ1ჩ2
2მ1ც2
2მ1ძ2
2მ1წ2
2მ1ჭ2
2მ1ხ2
2მ1ჯ2
2ნ1ბ
2ნ1გ2
2ნ1დ2
ნდე2რ
2ნ1ვ2
2ნ1ზ2
2ნ1თ2
1ნი
ნია3შტ
ნი3თ2ქ
ნის4ტრს.
2ნ1კ2
2ნ1ლ
2ნ1მ2
2ნ1ნ
2ნ1პ
2ნ1ჟ
2ნ1რ
2ნ1ს2
2ნ1ტ2
ნ3ტსა
ნ3ტსტ
1ნუ
2ნ1ფ2
2ნ1ქ2
2ნ1ღ2
2ნ1ყ2
2ნ1შ2
2ნ1ჩ2
2ნ1ც2
2ნ1ძ2
2ნ1წ2
2ნ1ჭ2
2ნ1ხ2
2ნ1ჯ2
ო1ა
ო1ბ
ობ3თმ
ობ3ლდ
ობ3რდ
ობ3რმ
ობ3რშ
ობ3რჭ
ო1გ
ოგ3ვბ
ოგ3ვგ
ოგ3ვდ
ოგ3ვვ
ოგვ3თხ
ოგ3ვკ
ოგ3ვლ
ოგ3ვმ
ოგ3ვნ
ოგ3ვრ
ოგ3ვს
ოგ3ვყ
ოგ3ვშ
ოგ3ვც
ოგ3ვძ
ოგ3ვწ
ოგ3ვხ
ოგ3კლ
ოგ3კრ
ო2გ1ლ
ო2გმ
ოგ3სვ
ოგ3ყვ
ო2გშ
ოგ3ში
ოგ3წვ
ოგ3ხვ
ო1დ
ოდ3გნ
ო2დ1ზ
ო2დ1ნ
ო1ე
ო1ვ
ოვ3ბრ
ოვ3დგ
ოვ3ზს
ოვ3ზშ
ოვ3თქ
ოვ3კვ
ოვ3კლ
ოვ3ლბ
ოვ3ლზ
ოვ3მც
ოვ3ნდ
ოვ3რდ
ოვ3რთ
ოვ3რჩ
ოვ3სვ
ოვ3სკ
ოვ3სპ
ოვ3სხ
ოვ3ყვ
ოვ3შვ
ოვ3ჩნ
ოვ3ცდ
ოვ3ცვ
ოვ3ცნ
ოვ3ძვ
ოვ3წვ
ოვ3ჭრ
ოვ3ხვ
ოვ3ხტ
ოვ3ჯდ
ო1ზ
ოზ3ვრ
ოზ3რდ
ო1თ
ო2თვ
ოთ3ვლ
ოთ3ვრ
ო2თ1ლ
ოთ3ლშ
ო1ი
ო1კ
ოკ1დ
ოკ3ვდ
ოკ3ვლ
ოკ3ვნ
ოკ3ვრ
ოკ3ლდ
ო1ლ
ოლ3დშ
ოლ3სკ
ოლ3შვ
ო1მ
ომ3ბრ
ომ3გდ
ომ3გვ
ომ3გზ
ომ3გრ
ომ3დგ
ომ3ვლ
ომ3კვ
ომ3კლ
ომ3კრ
ომ3პლ
ომ3პრ
ომ3რთ
ომ3რჩ
ომ3სვ
ომ3სკ
ომ3სპ
ომ3სხ
ომ3ტრ
ომ3ღვ
ომ3ყვ
ომ3შვ
ომ3ცდ
ომ3ცვ
ომ3ძვ
ომ3წვ
ომ3ხდ
ომ3ხვ
ომ3ხრ
ომ3ჯდ
ო1ნ
ონ3გრ
ონ3დრ
ონ3კრ
ონ3მდ
ონ3სკ
ონ3სპ
ონ3სტ
ონ3ტრ
ონ3ფლ
ონ3ხლ
ო1ო
ო1პ
ო1რ
ორ3ბლ
ორ3თმ
ორ3თქ
ორ3კვ
ორ3მხ
ორ3სმ
ორ3ტმ
ორ3ტრ
ორ3ტს
ორ3ჩნ
ორ3ცდ
ორ3ცვ
ორ3ცზ
ორ3ცმ
ორ3ცნ
ორ3ცშ
ო2რ1ძ
ო1ს
ოს3დგ
ოს3ვლ
ოს3ვრ
ოს3თქ
ოს3კდ
ო2ს1ნ
ოს3ტლ
ოს3ტრ
ოს3ფრ
ოს3ცდ
ოს3ცვ
ოს3ცრ
ოს3ძვ
ოს3წვ
ოს3ჭრ
ოს3ხდ
ო1ტ
ო2ტ1კ
ოტ1რ
ოტ3რდ
ო2ტშ
ოტ3ში
ო1უ
ო1ფ
ოფ3ლმ
ო2ქ1ვ
ოქ3მზ
ოქ3მნ
ოქ3მშ
ოქ3რთ
ოქ3სთ
ოქ3ტრ
ო1ღ
ოღ1ვ
ოღ3ვრ
1ოღლ
ო1ყა
ო1ყე
ოყ3ვნ
ო1ყო
ოყ1რ
ო1ყუ
ო1შ
ოშ3კზ
ო1ჩ
ოჩ3ნდ
ო1ც
ოც3ვლ
ო2ცქ
ოც3ქრ
ო1ძ
ოძ3ვრ
ო1წ
ოწ3ვდ
ოწ3ვნ
ოწ3ვრ
ო2წმ
ოწ3მდ
ო2წრ
ოჭ1ლ
ო1ხ
ოხ1ვ
ოხ3ვდ
ოხ3ვნ
ო2ხმ
ოხ1რ
ოხ3რჩ
ოხ3ტნ
ო1ჯ
ოჰ3გვ
ოჰ3კვ
ოჰ3კლ
ოჰ3კრ
ოჰ3ყვ
ოჰ3ხვ
2პ1დ
2პ1ვ
2პ1ზ
პ1კ
2პ1ლ2
2პ1მ
2პ1ნ
2პ1რ2
2პს
2პ1ტ
პყ2
2პ1შ
2პ1ჩ
2პ1წ2
2ჟ1ბ
2ჟ1დ
2ჟ1ვ
2ჟ1ზ
2ჟ1თ
1ჟი
2ჟ1კ
2ჟ1ლ
3ჟ2ლეტა
2ჟ1მ
1ჟო
2ჟ1რ2
2ჟს
ჟ1ღე
2ჟ1შ
2რ1ამბ
3რამბავი.
2რ1აჩა
2რ1ბ2
2რ1გ2
რ3გსა
2რ1დ2
რ3დსა
2რ1ეკო
რ1ეფე
2რ1ვ2
2რ1ზ2
2რ1თ2
რთერ4თს.
რ3თსა
რ3თხმ
1რი
რი2ბღ
რი3მღ
2რ1კ2
2რ1ლ
2რ1მ
რმ2თ
რმ2ყ
2რ1ნ
რო1
2როფ
2რ1პ2
2რ1ჟ
2რ1ს2
2რ1ტ2
1რუ
რუ3სო
2რ1ფ2
2რ1ქ2
2რ1ღ2
2რ1ყ2
2რ1შ2
2რ1ჩ2
რ2ჩხ
რ3ჩხე
2რ1ც2
რძ2
რ1ძლ
2რ1წ2
2რ1ჭ
2რ1ხ2
2რ1ჯ2
2რ1ჰ2
1სა
2ს1ბ
2ს1გ2
2ს1დ2
1სე
2ს1ვ2
2ს1ზ
2ს1თ2
1სი
სი3რ2ვ
2ს1კ2
2ს1ლ2
2ს1მ2
ს1ნო
1სო
2ს1ორა
ს1ოღ
2ს1პ2
2ს1რ2
2ს1ს
2ს1ტ2
1სუ
2ს1ფ2
ს1ქ
2ს1ღ
2ს1ყ
2ს1შ2
2ს1ჩ
2ს1ც2
2ს1ძ2
2ს1წ2
2ს1ჭ2
2ს1ხ2
2ს1ჯ
ტა3ჯგ
2ტ1ბ
2ტ1გ2
2ტ1დ
ტექ4სტს.
2ტვ2
ტ1ვა
2ტ1ზ
2ტ1თ
ტკ2
ტ1კუ
2ტ1ლ2
2ტ1მ2
2ტ1ნ
2ტ1პ
2ტრ2
ტ1რო
ტ1რფ
2ტ1ს2
2ტ1ტ
ტ2ფ
ტყ2
ტ2შ
2ტ1ჩ2
2ტ1ც
2ტ1წ
2ტ1ხ2
2ტ1ჯ
უ1ა
უ2აა
უბ3ლზ
უბ3ლშ
უბ3რკ
უბ3რყ
უ1გ
უ2გმ
უგ3რნ
უ1დ
უდ3გნ
უდ3გრ
უ2დ1ზ
უდ3რტ
უდ3სა
უ1ე
უ1ვ
უ1ზ
უზ3რდ
უ1თ
უ2თ1ექ
უ2თ1ვ
უთ3ვლ
უთ3ვნ
უთ3სვ
უ1ი
უი2ა
უ1კ
უკ3ვდ
უკ3ლდ
უ1ლ
უ2ლ1აფ
ულ3გრ
ულ3დგ
უ2ლ1ეკ
ულ3თბ
ულ3თნ
ულ3მკ
ულ3მხ
ულ3ნდ
ულ3ღვ
ულ3ჩვ
უ1მ
უმ3დგ
უმ3კვ
უმ3სგ
უმ3სხ
უმ2ტყ
უმ3ღვ
უმ3შვ
უმ3ჩნ
უმ3ცრ
უ1ნ
უნ3გდ
უნ3გრ
უნ3დგ
უნ3დმ
უნ3დრ
უნ3თქ
უნ3კლ
უნ3ტრ
უნ3ღრ
უნ3ძზ
უნ3ძმ
უნ3ძრ
უნ3ხრ
უ1ო
უ1პ
უპ3რშ
უ1ჟ
უ1რ
ურ3ბლ
ურ3ბნ
ურ3გზ
ურ3დთ
ურ3დს
ურ3ვლ
ურ3თბ
ურ3თმ
ურ3კვ
ურ3კლ
ურ3კრ
ურ3სზ
ურ3სმ
ურ3სშ
ურ3ტლ
ურ3ფს
ურ3ღვ
ურ3ჩქ
ურ3ცლ
ურ3ჯდ
უს3ვლ
უს3ვმ
უს3ვრ
უს3კდ
უს3კრ
უ2სო
უს3რვ
უს3რნ
უს3ტდ
უს3ტვ
უს3ტმ
უს3ხდ
უს3ხვ
უ1ტ
უ2ტ1კ
უტ1რ
უ1უ
უფ3ლდ
უფ3ჯგ
უქ1ვ
უქ1თ
უქ3მდ
უქ3მნ
უქ3მრ
უქ3სვ
უ1ღ
უღ3რმ
უ1ყ
უყ1დ
უ1შ
უშ3ვრ
უშ3ტმ
უშ3ტრ
უ1ჩ
უჩ3ნდ
უ1ც
უც3ვლ
უ2ცქ
უც3ქდ
უც3ქი
უც3ქუ
უ1ძა
უ1ძე
უძ3ვლ
უძ3ვრ
უ1წ
უწ3ვდ
უწ3ვრ
უ2წშ
უ1ჭ
უჭ3ვრ
უჭ3კვ
უ2ჭშ
უ1ხ
უხ1ვ
უხ3ვდ
უხ3ლზ
უხ3ლმ
უხ3ლშ
უ2ხ1მ
უხ1რ
უხ3რჩ
უხ3ტვ
უ1ჯ
უ2ჯლ
უჯ3რა
უჯ3რი
უ1ჰ
1ფა
2ფ1ბ
2ფ1დ
1ფე
2ფ1ვ
2ფ1ზ
2ფ1თ2
1ფი
2ფ1იარ
2ფ1კ
2ფ1ლ2
2ფ1მ
2ფ1ნ
1ფო
2ფ1რ
ფრ2დ
ფრ2ქ
2ფ1ს2
2ფ1ტ
1ფუ
2ფ1ქ
2ფ1შ2
2ფ1ჩ
2ფ1ც
ფხ2
ფ1ჯ2
1ქა
ქ1გ
ქ1დ
1ქე
ქვ2
ქ1ვდ
ქ3ვთო
ქ3ვსმ
ქ3ვსო
ქ1ზ
1ქი
2ქლ2
ქ1ლე
ქ1ლო
ქ1მ2
ქ1ნ2
1ქო
ქ1ჟ
ქ1რ2
ქ1ს2
ქ1ტ2
1ქუ
ქ1ქ
ქ1ღ
ქ1შ
ქ1ც2
1ღატ
2ღ1ბ2
ღ1გ
2ღ1დ2
2ღვ2
ღ1ვი
ღ1ვშ
2ღ1ზ
2ღ1თ2
ღ1კ2
2ღ1ლ2
2ღ1მ2
2ღ1ნ
2ღ1რ2
2ღ1ს2
ღ1ტ
ღ2ტყ
ღ1ფ
ღფრ2
ღ1ქ2
2ღ1შ
ღ1ძ2
2ღ1წ
ღ1ჭ
2ყ1ბ
2ყდ2
2ყ1ვ2
2ყ1ზ
2ყ1თ
2ყლ2
2ყ1მ2
2ყნ2
ყ1ნე
ყ1ნო
2ყრ2
ყ1რე
2ყს
2ყ1შ
1შა
შა3ხვ
შ1გ
2შ1დ
1შე
2შ1ვ2
შ1ზ
2შ1თ
1ში
შია3თ2
2შ1კ2
2შ1ლ2
2შ1მ
2შ1ნ
1შო
2შ1პ
2შ1რ
2შ1ს
2შ1ტ2
შ2ტერი
შ2ტერო
1შუ
შ2ფ
2შ1ქ2
2შ1შ
2შ1ჩ
2შ1ხ2
2შ1ჯ
2ჩ1ბ
2ჩ1დ
2ჩ1ვ2
2ჩ1ზ
2ჩ1თ
2ჩ1მ
2ჩ1ნ2
ჩო1
2ჩ1რ2
2ჩს
2ჩ1ქ2
2ჩ1შ
ჩხ2
2ც1ბ
2ც1დ
2ც1ვ2
2ც1ზ
2ც1თ2
2ც1კ
2ც1ლ
2ც1მ2
2ც1ნ
2ც1რ
2ც1ს
ც2ქ2
ც1ქდ
ც1ქნ
ც1ქრ
2ც1ღ
2ც1შ
ცხ2
ძარ4ცვს.
2ძ1გ2
2ძ1ვ2
2ძ1ზ
2ძთ
1ძი
2ძ1ლ2
2ძ1მ
2ძნ
ძ1ნე
2ძ1რ2
2ძს
1ძუ
1ძღ2
ძ2ჭ
წა3გლ
2წ1ბ
2წ1გ
2წ1ვ2
2წ1კ2
წ1ლი
წმ2
წ1მდ
წ1მე
წ1მო
წ1მყ
2წ1ნ
წრ2
წ1რთ
წყ2
1ჭა
2ჭ1დ
1ჭე
2ჭ1ვ2
1ჭი
ჭ1კ2
ჭ1ლო
2ჭ1მ2
2ჭ1ნ
1ჭო
2ჭ1რ
1ჭუ
ჭყ2
ხა2ლ1ახ
2ხ1ბ
ხგ2
2ხ1დ2
2ხვ2
ხ1ვე
ხ1ვი
ხ1ვრ
2ხზ2
2ხ1თ
2ხ1ლ2
ხმ2
2ხ1ნ
2ხ1პ
2ხრ2
2ხ1ს2
2ხ1ტ2
2ხ1ქ
2ხყ
2ხ1შ2
2ხ1ჩ
2ხ1ც
2ხ1წ
2ხ1ხ
2ხჰ2
2ჯგ2
2ჯ1დ
ჯვ2
2ჯ1თ
ჯო2რ1
ჯო3რი
ჯ2რ
ჯ1რა
2ჯ1ს
ჯ2შ
1ჰა
ჰ1გ2
1ჰე
1ჰი
ჰ1კ2
ჰ1მ
ჰ1პ
ჰ1რ
ჰ1ს
ჰ1ფ
ჰ1ქ
ჰ1ღ
ჰ1ყ2
ჰ1ხ2
}

