package Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Blue;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  'blue' => 0x64640000, # 100,100,0,0
  'aquamarine' => 0x33000003, # 51,0,0,3
  'blue' => 0x64320000, # 100,50,0,0
  'blue' => 0x55250014, # 85,37,0,20
  'clear blue' => 0x340e0005, # 52,14,0,5
  'azurin' => 0x21340000, # 33,52,0,0
  'steel blue' => 0x4518001b, # 69,24,0,27
  'slate blue' => 0x1a15002d, # 26,21,0,45
  'cornflower blue' => 0x34220020, # 52,34,0,32
  'blue cornflower' => 0x34220020, # 52,34,0,32
  'blue jumped' => 0x6412001d, # 100,18,0,29
  'heavenly blue' => 0x54110007, # 84,17,0,7
  'cerulean' => 0x5e200009, # 94,32,0,9
  'cerulean blue' => 0x4721001c, # 71,33,0,28
  'blue wagon' => 0x1c120016, # 28,18,0,22
  'wheelwright blue' => 0x52130033, # 82,19,0,51
  'wheelwright blue' => 0x1c120016, # 28,18,0,22
  'blue sky' => 0x351d0000, # 53,29,0,0
  'cobalt blue' => 0x492f0033, # 73,47,0,51
  'berlin blue' => 0x3d1a0040, # 61,26,0,64
  'bleu de france' => 0x4f270009, # 79,39,0,9
  'midnight blue' => 0x6432003c, # 100,50,0,60
  'prussian blue' => 0x3d1a0040, # 61,26,0,64
  'denim blue' => 0x60380000, # 96,56,0,0
  'blue south sea' => 0x64000014, # 100,0,0,20
  'lozenge blue' => 0x0d050000, # 13,5,0,0
  'egyptian blue' => 0x5a450023, # 90,69,0,35
  'electric blue' => 0x53360000, # 83,54,0,0
  'blue woad' => 0x2c190028, # 44,25,0,40
  'blue horizon' => 0x170e0023, # 23,14,0,35
  'majorelle blue' => 0x3840000e, # 56,64,0,14
  'navy' => 0x60370046, # 96,55,0,70
  'maya blue' => 0x36170002, # 54,23,0,2
  'mineral blue' => 0x3d1a0040, # 61,26,0,64
  'midnight blue' => 0x565f003a, # 86,95,0,58
  'ultramarine' => 0x64640203, # 100,100,2,3
  'ultramarine' => 0x48640028, # 72,100,0,40
  'peacock' => 0x6011002c, # 96,17,0,44
  'persian blue' => 0x3c640000, # 60,100,0,0
  'oil blue' => 0x400b0044, # 64,11,0,68
  'royal blue' => 0x4f270009, # 79,39,0,9
  'sapphire blue' => 0x6349001d, # 99,73,0,29
  'teal' => 0x6400002c, # 100,0,0,44
  'smalt blue' => 0x64430028, # 100,67,0,40
  'tiffany blue' => 0x4a052600, # 74,5,38,0
  'turquin blue' => 0x3422002e, # 52,34,0,46
  'caeruleum' => 0x54110007, # 84,17,0,7
  'duck' => 0x610a0028, # 97,10,0,40
  'cerulean' => 0x340e0005, # 52,14,0,5
  'cyan' => 0x34000d00, # 52,0,13,0
  'cyan' => 0x53000002, # 83,0,0,2
  'fumes' => 0x1107000c, # 17,7,0,12
  'frosted' => 0x26000012, # 38,0,0,18
  'indigo' => 0x33590003, # 51,89,0,3
  'indigo' => 0x3964003a, # 57,100,0,58
  'indigo web' => 0x2a640031, # 42,100,0,49
  'klein 1' => 0x64570000, # 100,87,0,0
  'klein 2' => 0x4a520033, # 74,82,0,51
  'lapis lazuli' => 0x4c260027, # 76,38,0,39
  'lavender' => 0x242c0007, # 36,44,0,7
  'pastel' => 0x2c190028, # 44,25,0,40
  'pervenche' => 0x14140000, # 20,20,0,0
  'turquoise' => 0x55000801, # 85,0,8,1
};


1;
# ABSTRACT: CMYK colors from http://toutes-les-couleurs.com/ (blue)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Blue - CMYK colors from http://toutes-les-couleurs.com/ (blue)

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Blue (from Perl distribution Graphics-ColorNamesCMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::ToutesLesCoulersCom::*> modules.

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
