/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileHeightFixed;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileFactoryDelegatorCreateSplit
extends FtileFactoryDelegator {
    private final double spaceArroundBlackBar = 20.0;
    private final double barHeight = 6.0;
    private final double xMargin = 14.0;
    private final Rose rose = new Rose();

    public FtileFactoryDelegatorCreateSplit(FtileFactory ftileFactory, ISkinParam iSkinParam) {
        super(ftileFactory, iSkinParam);
    }

    @Override
    public Ftile createSplit(List<Ftile> list) {
        HtmlColor htmlColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow);
        FtileGeometry ftileGeometry = super.createSplit(list).calculateDimension(this.getStringBounder());
        double d = ((Dimension2D)ftileGeometry).getHeight() + 40.0;
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (Ftile object2 : list) {
            arrayList.add(new FtileHeightFixed(new FtileMarged(object2, 14.0), d));
        }
        Object object3 = super.createSplit(arrayList);
        ArrayList<Connection> arrayList2 = new ArrayList<Connection>();
        double d2 = 0.0;
        for (Ftile ftile : arrayList) {
            FtileGeometry ftileGeometry2 = ftile.calculateDimension(this.getStringBounder());
            arrayList2.add(new ConnectionIn(ftile, d2, htmlColor));
            arrayList2.add(new ConnectionOut(ftile, d2, htmlColor, d));
            d2 += ((Dimension2D)ftileGeometry2).getWidth();
        }
        double d3 = object3.calculateDimension(this.getStringBounder()).getWidth();
        arrayList2.add(new ConnectionHline2((Ftile)object3, htmlColor, 0.0, arrayList, d3));
        arrayList2.add(new ConnectionHline2((Ftile)object3, htmlColor, d, arrayList, d3));
        object3 = FtileUtils.addConnection((Ftile)object3, arrayList2);
        return object3;
    }

    static class ConnectionOut
    extends AbstractConnection {
        private final double x;
        private final HtmlColor arrowColor;
        private final double height;

        public ConnectionOut(Ftile ftile, double d, HtmlColor htmlColor, double d2) {
            super(ftile, null);
            this.x = d;
            this.arrowColor = htmlColor;
            this.height = d2;
        }

        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(uGraphic.getStringBounder());
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(ftileGeometry.getLeft(), ftileGeometry.getOutY());
            snake.addPoint(ftileGeometry.getLeft(), this.height);
            uGraphic.draw(snake);
        }
    }

    static class ConnectionIn
    extends AbstractConnection {
        private final double x;
        private final HtmlColor arrowColor;

        public ConnectionIn(Ftile ftile, double d, HtmlColor htmlColor) {
            super(null, ftile);
            this.x = d;
            this.arrowColor = htmlColor;
        }

        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(uGraphic.getStringBounder());
            double d = ftileGeometry.getLeft();
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(d, 0.0);
            snake.addPoint(d, ftileGeometry.getInY());
            uGraphic.draw(snake);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionHline2
    extends AbstractConnection {
        private final Ftile inner;
        private final double y;
        private final HtmlColor arrowColor;
        private final List<Ftile> list;
        private final double totalWidth;

        public ConnectionHline2(Ftile ftile, HtmlColor htmlColor, double d, List<Ftile> list, double d2) {
            super(null, null);
            this.inner = ftile;
            this.y = d;
            this.arrowColor = htmlColor;
            this.list = list;
            this.totalWidth = d2;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            double d = Double.MAX_VALUE;
            double d2 = 0.0;
            StringBounder stringBounder = uGraphic.getStringBounder();
            for (Ftile ftile : this.list) {
                if (this.y > 0.0 && ftile.isKilled()) continue;
                UTranslate uTranslate = this.inner.getTranslateFor(ftile, stringBounder);
                double d3 = ftile.calculateDimension(stringBounder).translate(uTranslate).getLeft();
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            if (d > this.totalWidth / 2.0) {
                d = this.totalWidth / 2.0;
            }
            if (d2 < this.totalWidth / 2.0) {
                d2 = this.totalWidth / 2.0;
            }
            Snake snake = new Snake(this.arrowColor);
            snake.addPoint(d, this.y);
            snake.addPoint(d2, this.y);
            uGraphic.draw(snake);
        }
    }
}

