######################################################################
#
# 0304_add_mapping-jips-2.13.6.18.t
#
# Copyright (c) 2021 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ['𠀋', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xA3"],
        ['𠆢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xBE"],
        ['𠑊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xE7"],
        ['𠦝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xBE"],
        ['𠮟', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB5\xC0"],
        ['𡉴', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xD7"],
        ['𡋤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xE4"],
        ['𡌛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD1\xB5"],
        ['𡌶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xF0"],
        ['𡍄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xEF"],
        ['𡶜', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xA1"],
        ['𡶡', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xA2"],
        ['𡶷', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xAE"],
        ['𡸴', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xB2"],
        ['𡽶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xD6"],
        ['𢰤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xD1"],
        ['𣇃', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xD2"],
        ['𣇄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xDF"],
        ['𣖔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xC7"],
        ['𣗄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xC6"],
        ['𣘸', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xE3"],
        ['𣘺', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xDC"],
        ['𣱿', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xDA"],
        ['𣳾', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xB1"],
        ['𤴔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC5\xBA"],
        ['𥧄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xE9"],
        ['𥮲', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xBE"],
        ['𥱋', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xCE"],
        ['𥶡', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xD6"],
        ['𥼣', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xF2"],
        ['𥽜', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xF4"],
        ['𦉰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xE5"],
        ['𦙾', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xB6"],
        ['𦥑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xD4"],
        ['𧜎', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xAF"],
        ['𧾷', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xCD"],
        ['𨑕', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xF8"],
        ['𨪙', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD2\xD7"],
        ['𨫍', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD2\xD6"],
        ['𨿸', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xC6"],
        ['𩙿', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xB0"],
        ['𩸽', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xA7"],
        ['𩺊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xB2"],
        ['𪀯', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xCB"],
        ['㐂', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xA8"],
        ['㐮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xA2"],
        ['㑪', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xA9"],
        ['㒵', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xF3"],
        ['㓁', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xE2"],
        ['㓇', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xFC"],
        ['㓛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xAF"],
        ['㔟', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xD2"],
        ['㕝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB5\xB9"],
        ['㚙', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xC9"],
        ['㞍', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xE6"],
        ['㟁', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xFC"],
        ['㟢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xB7"],
        ['㟽', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xC8"],
        ['㠀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xC3"],
        ['㠯', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xC1"],
        ['㣺', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBA\xEF"],
        ['㤗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBB\xA7"],
        ['㫖', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xB0"],
        ['㫪', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xCB"],
        ['㬚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xAD"],
        ['㬜', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xA6"],
        ['㬢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xAF"],
        ['㮈', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xB4"],
        ['㰏', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xAD"],
        ['㳃', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xEE"],
        ['㴞', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xEC"],
        ['㷀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xAB"],
        ['㷔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xBF"],
        ['䂓', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xA9"],
        ['䄅', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xF9"],
        ['䅈', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xC3"],
        ['䆴', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xED"],
        ['䇮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xAC"],
        ['䈎', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xC3"],
        ['䉤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xD5"],
        ['䋆', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xA1"],
        ['䌫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xDA"],
        ['䏮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xB9"],
        ['䑓', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB5\xF5"],
        ['䑛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xD8"],
        ['䑺', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xE2"],
        ['䒳', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xCD"],
        ['䓔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xDF"],
        ['䔈', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xC8"],
        ['䔥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xD3"],
        ['䕃', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xE2"],
        ['䙥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xB2"],
        ['䡎', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xE2"],
        ['䯂', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xD9"],
        ['䯨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xDD"],
        ['䰗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xE8"],
        ['丏', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xA4"],
        ['丬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xDD"],
        ['亻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xBD"],
        ['伃', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xCE"],
        ['伋', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xC6"],
        ['佽', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xE4"],
        ['侠', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xE2"],
        ['俠', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x36\x22"],
        ['俦', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xF3"],
        ['俱', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['倂', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xFC"],
        ['倐', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xF2"],
        ['傜', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBA\xE4"],
        ['僙', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xD9"],
        ['兠', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xEF"],
        ['养', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xF1"],
        ['凃', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xA5"],
        ['刓', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xB1"],
        ['刕', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xB4"],
        ['剝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\x6D"],
        ['剥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xBC"],
        ['勻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xE7"],
        ['卧', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xCD"],
        ['卺', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xDF"],
        ['卽', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB5\xA9"],
        ['吞', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['呕', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB5\xC6"],
        ['唖', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xA1"],
        ['喝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB5\xED"],
        ['噓', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xAA"],
        ['噛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xAE"],
        ['嚙', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x33\x7A"],
        ['嚢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xF2"],
        ['囶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xC5"],
        ['圡', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xCB"],
        ['埇', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xE6"],
        ['埞', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xEE"],
        ['埶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xEA"],
        ['填', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xE6"],
        ['墊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xA1"],
        ['墝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xCA"],
        ['增', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xA8"],
        ['壠', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xB5"],
        ['复', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xBB"],
        ['奟', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xD0"],
        ['奼', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xD9"],
        ['姣', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xE8"],
        ['姸', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['媄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xFC"],
        ['媢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xF9"],
        ['媵', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xA3"],
        ['嫚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xAA"],
        ['嫰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xA9"],
        ['宬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xC3"],
        ['寖', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xD1"],
        ['寬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xD4"],
        ['尣', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xE4"],
        ['屏', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xE7"],
        ['屛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\x22"],
        ['屡', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xE8"],
        ['屼', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xED"],
        ['岧', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xF6"],
        ['岭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xFA"],
        ['峐', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xA6"],
        ['崐', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xAF"],
        ['崠', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xB3"],
        ['嵇', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xBB"],
        ['嵭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xC0"],
        ['嶲', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xC7"],
        ['巑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xDB"],
        ['巗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xDC"],
        ['巢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xFA"],
        ['幷', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xF9"],
        ['庬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB5\xAF"],
        ['廹', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBA\xB5"],
        ['廽', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBA\xB6"],
        ['开', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xB5"],
        ['彣', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBA\xCE"],
        ['徤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBA\xE7"],
        ['徵', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBA\xEB"],
        ['德', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBA\xEC"],
        ['忢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBA\xF8"],
        ['悾', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBB\xBB"],
        ['惝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBB\xC0"],
        ['慼', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBB\xDF"],
        ['戾', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xA2"],
        ['扚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xAA"],
        ['抅', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xAB"],
        ['挼', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xC1"],
        ['掴', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xE2"],
        ['掻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xD4"],
        ['揫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xCF"],
        ['揭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xCB"],
        ['搔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\x5F"],
        ['擄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xE3"],
        ['擊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xDE"],
        ['擤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xE7"],
        ['攅', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xE9"],
        ['攲', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xED"],
        ['斅', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xBA"],
        ['昺', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xC5"],
        ['晈', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC5\xD4"],
        ['晚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xDA"],
        ['晣', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xD8"],
        ['曆', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xA7"],
        ['曬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xB5"],
        ['曻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xD0"],
        ['朙', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xDB"],
        ['杈', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xC4"],
        ['杻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xCD"],
        ['极', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xCA"],
        ['柀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xE8"],
        ['桉', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xF3"],
        ['桵', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xA8"],
        ['梥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xA1"],
        ['椵', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xC3"],
        ['楗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xBE"],
        ['榀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xC4"],
        ['榒', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xD6"],
        ['槀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xCB"],
        ['槩', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xDA"],
        ['槪', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xD9"],
        ['槶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xDE"],
        ['橫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xE6"],
        ['檞', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xF3"],
        ['櫔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xFD"],
        ['櫝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xA3"],
        ['步', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xC1"],
        ['歷', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xC4"],
        ['歺', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xC5"],
        ['殾', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xCB"],
        ['每', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xCD"],
        ['毗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xCE"],
        ['毮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xC9"],
        ['氺', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xD7"],
        ['汭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xE6"],
        ['汴', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xE9"],
        ['汶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xE8"],
        ['沄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xE3"],
        ['沗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xF0"],
        ['泻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xF9"],
        ['洴', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xD2"],
        ['涁', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xC3"],
        ['涉', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xC0"],
        ['涊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xB9"],
        ['涜', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xEC"],
        ['淚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xC9"],
        ['渚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xE3"],
        ['渴', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xE4"],
        ['湗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xEF"],
        ['溌', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xED"],
        ['溓', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xA3"],
        ['溫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xFD"],
        ['溿', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xA8"],
        ['滙', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xF1"],
        ['漥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xBA"],
        ['潑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\x2E"],
        ['潚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xD6"],
        ['澍', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xC9"],
        ['澘', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xD7"],
        ['瀨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xF1"],
        ['炗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xEB"],
        ['焏', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xA8"],
        ['焔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xA8"],
        ['焮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xAD"],
        ['焰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x31\x6B"],
        ['煨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xBE"],
        ['熖', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xC5"],
        ['熳', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xCD"],
        ['爕', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB5\xBF"],
        ['爫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xD8"],
        ['爸', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xDA"],
        ['爹', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xDB"],
        ['牕', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xEA"],
        ['犰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xE9"],
        ['犾', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xEE"],
        ['狀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xEC"],
        ['玊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xAB"],
        ['玟', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xB1"],
        ['玨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xB4"],
        ['琓', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xCE"],
        ['琢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xC8"],
        ['璣', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xF8"],
        ['甁', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC5\xAC"],
        ['畬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC5\xB5"],
        ['畾', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC5\xB8"],
        ['痩', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xD5"],
        ['瘦', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\x69"],
        ['皛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC5\xDB"],
        ['皡', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC5\xDC"],
        ['盔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC5\xE8"],
        ['瞩', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xA4"],
        ['硏', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xB3"],
        ['礮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xD8"],
        ['祷', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xFB"],
        ['秌', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xB9"],
        ['穝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xD7"],
        ['穠', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xB1"],
        ['窊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xE3"],
        ['窳', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xEB"],
        ['窻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xEC"],
        ['笻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xA7"],
        ['筲', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xB1"],
        ['筿', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xB2"],
        ['箪', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xDB"],
        ['篰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xD1"],
        ['簞', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\x3D"],
        ['粠', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xE5"],
        ['粦', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xB0"],
        ['糙', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xF1"],
        ['綆', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xAF"],
        ['綠', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xB6"],
        ['緖', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xBD"],
        ['緣', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xBF"],
        ['繋', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xB6"],
        ['繍', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xD3"],
        ['繫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x37\x52"],
        ['耂', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xA3"],
        ['耎', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xCC"],
        ['胵', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xBB"],
        ['舄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xD5"],
        ['艉', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xE0"],
        ['艗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xE3"],
        ['艿', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xE8"],
        ['芎', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xEE"],
        ['芨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xF2"],
        ['芮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xF6"],
        ['苆', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xFB"],
        ['茇', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xAC"],
        ['茈', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xAB"],
        ['茛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xC7"],
        ['茝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xCF"],
        ['茢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xC0"],
        ['茭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xB9"],
        ['茰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xC4"],
        ['荃', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xBB"],
        ['荇', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xB8"],
        ['荑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xBE"],
        ['荔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xBF"],
        ['荗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xC1"],
        ['莒', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xD6"],
        ['莘', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xD8"],
        ['莛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xE2"],
        ['莝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xD7"],
        ['莩', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xD9"],
        ['莱', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xE3"],
        ['菡', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xE5"],
        ['萁', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xE6"],
        ['萊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\x69"],
        ['葚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xB7"],
        ['葟', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xAC"],
        ['葳', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xA3"],
        ['葸', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xA4"],
        ['蒋', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xC7"],
        ['蒞', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xB1"],
        ['蓀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xBC"],
        ['蓂', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xBD"],
        ['蓏', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xBE"],
        ['蓧', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xCF"],
        ['蔞', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xDA"],
        ['蔴', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xD7"],
        ['蕑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xDE"],
        ['蕤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xE1"],
        ['薆', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xF0"],
        ['薝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xF2"],
        ['薭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xA1"],
        ['薰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xA9"],
        ['虓', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xC5"],
        ['虛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xC9"],
        ['蚉', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xCF"],
        ['蝉', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xDC"],
        ['蝋', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD7\xB3"],
        ['蟬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x40\x66"],
        ['蟵', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xE1"],
        ['蠆', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xE4"],
        ['蠋', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xE3"],
        ['裒', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xFA"],
        ['褲', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xBC"],
        ['覀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xB4"],
        ['覐', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xB9"],
        ['觔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xA1"],
        ['讜', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xA2"],
        ['貓', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xA2"],
        ['賱', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xBD"],
        ['賴', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xBB"],
        ['賸', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xC0"],
        ['贛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xC3"],
        ['趯', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xCC"],
        ['躯', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xDC"],
        ['躶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xAB"],
        ['軀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x36\x6D"],
        ['郞', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD0\xEC"],
        ['鄕', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD0\xF3"],
        ['酆', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD0\xFC"],
        ['醗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD1\xAC"],
        ['醤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xC8"],
        ['醬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x3E\x5F"],
        ['醱', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\x30"],
        ['鈗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD1\xCF"],
        ['鉂', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD1\xD8"],
        ['鋌', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD1\xF2"],
        ['鋓', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD1\xF4"],
        ['錄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD2\xAD"],
        ['鍊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD2\xBA"],
        ['鍫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD2\xBC"],
        ['鎋', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD2\xCC"],
        ['鎺', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD2\xD1"],
        ['鑲', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD2\xF9"],
        ['閍', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xA1"],
        ['閬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xA3"],
        ['雯', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xCF"],
        ['霳', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xD4"],
        ['霻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xD5"],
        ['靏', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xDB"],
        ['鞚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xE5"],
        ['頬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xF7"],
        ['頰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\x4B"],
        ['頲', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xF9"],
        ['頻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xFB"],
        ['顛', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xA3"],
        ['飇', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xAC"],
        ['飠', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xAE"],
        ['飡', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xB1"],
        ['饘', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xBF"],
        ['騤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xCF"],
        ['騨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xD1"],
        ['驒', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\x4D"],
        ['鬭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xE9"],
        ['魦', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xF1"],
        ['魵', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD4\xF0"],
        ['鯁', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xA2"],
        ['鰀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xAF"],
        ['鱏', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xB8"],
        ['鱣', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xBB"],
        ['鳦', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xC0"],
        ['鴎', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xC3"],
        ['鴞', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xC4"],
        ['鵒', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xD0"],
        ['鵢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xCF"],
        ['鵰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xC9"],
        ['鶖', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xD7"],
        ['鹸', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xDF"],
        ['麵', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\x4D"],
        ['麹', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xBB"],
        ['麺', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD7\xA7"],
        ['麽', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB9\xFC"],
        ['黃', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xE8"],
        ['黑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD5\xEB"],
        ['欄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xAF"],
        ['廊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBA\xA9"],
        ['朗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xBE"],
        ['虜', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xCA"],
        ['殺', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xCA"],
        ['類', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xFE"],
        ['隆', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xB9"],
        ['塚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\x4D"],
        ['猪', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xF8"],
        ['神', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xEB"],
        ['祥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xF7"],
        ['福', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xA6"],
        ['諸', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xEA"],
        ['都', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD0\xF2"],
        ['侮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB2\xED"],
        ['僧', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xD0"],
        ['免', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xEA"],
        ['勉', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xCD"],
        ['勤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xD9"],
        ['卑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xF7"],
        ['喝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x33\x65"],
        ['嘆', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB5\xFD"],
        ['器', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xB1"],
        ['塀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xA7"],
        ['墨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB7\xA9"],
        ['層', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB8\xEA"],
        ['悔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBB\xB0"],
        ['慨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBB\xE4"],
        ['憎', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBB\xE5"],
        ['懲', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBB\xF2"],
        ['敏', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBC\xEF"],
        ['既', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xAE"],
        ['暑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBD\xF0"],
        ['梅', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBE\xF8"],
        ['海', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC1\xB5"],
        ['渚', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x3D\x6D"],
        ['漢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xB2"],
        ['煮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xB6"],
        ['爫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xD9"],
        ['琢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\x76"],
        ['碑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xBF"],
        ['社', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xE0"],
        ['祉', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xE4"],
        ['祈', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xE3"],
        ['祐', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xED"],
        ['祖', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xEC"],
        ['祝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC6\xEA"],
        ['禎', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xA4"],
        ['穀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xCF"],
        ['突', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xE2"],
        ['節', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xBF"],
        ['練', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xBE"],
        ['繁', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xCE"],
        ['署', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xEA"],
        ['者', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xA4"],
        ['臭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCA\xCF"],
        ['著', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCC\xB1"],
        ['褐', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xA5"],
        ['視', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xBB"],
        ['謁', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xE9"],
        ['謹', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCE\xF2"],
        ['賓', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xB6"],
        ['贈', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xC1"],
        ['辶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCF\xEF"],
        ['逸', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD0\xB3"],
        ['難', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xCA"],
        ['響', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD3\xF0"],
        ['頻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\x51"],
        ['¶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xF0"],
        ['―', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x21\x3D"],
        ['†', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xEE"],
        ['‡', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xEF"],
        ['‰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA4\xFE"],
        ['Å', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA4\xDF"],
        ['⇒', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xF6"],
        ['⇔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xF7"],
        ['∀', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xE7"],
        ['∂', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xCA"],
        ['∃', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xE8"],
        ['∇', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xF9"],
        ['∈', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xD4"],
        ['∋', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xD5"],
        ['∑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x74"],
        ['√', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x75"],
        ['∝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xDC"],
        ['∟', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x78"],
        ['∠', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x77"],
        ['∥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x21\x42"],
        ['∧', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xD0"],
        ['∨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xD1"],
        ['∩', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x7B"],
        ['∪', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x7C"],
        ['∫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x72"],
        ['∬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xFA"],
        ['∮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x73"],
        ['∵', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x7A"],
        ['∽', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xDD"],
        ['≒', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x70"],
        ['≡', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x71"],
        ['≪', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xE1"],
        ['≫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xE2"],
        ['⊂', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xD2"],
        ['⊃', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA5\xD3"],
        ['⊆', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xF4"],
        ['⊇', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xF5"],
        ['⊥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x76"],
        ['⊿', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x79"],
        ['⌒', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xF8"],
        ['①', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x21"],
        ['②', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x22"],
        ['③', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x23"],
        ['④', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x24"],
        ['⑤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x25"],
        ['⑥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x26"],
        ['⑦', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x27"],
        ['⑧', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x28"],
        ['⑨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x29"],
        ['⑩', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x2A"],
        ['⑪', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x2B"],
        ['⑫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x2C"],
        ['⑬', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x2D"],
        ['⑭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x2E"],
        ['⑮', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x2F"],
        ['⑯', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x30"],
        ['⑰', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x31"],
        ['⑱', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x32"],
        ['⑲', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x33"],
        ['⑳', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x34"],
        ['◯', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xFE"],
        ['♂', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x21\x69"],
        ['♪', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xFD"],
        ['♭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xFC"],
        ['♯', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xA6\xFB"],
        ['〇', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x21\x3B"],
        ['〝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x60"],
        ['〟', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x61"],
        ['㈲', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x6B"],
        ['㈹', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x6C"],
        ['㊤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x65"],
        ['㊥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x66"],
        ['㊦', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x67"],
        ['㊧', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x68"],
        ['㊨', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x69"],
        ['㌃', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x46"],
        ['㌍', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x4A"],
        ['㌔', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x41"],
        ['㌘', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x44"],
        ['㌢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x42"],
        ['㌣', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x4C"],
        ['㌦', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x4B"],
        ['㌧', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x45"],
        ['㌫', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x4D"],
        ['㌶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x47"],
        ['㌻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x4F"],
        ['㍉', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x40"],
        ['㍊', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x4E"],
        ['㍍', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x43"],
        ['㍑', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x48"],
        ['㍗', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x49"],
        ['㍻', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x5F"],
        ['㍼', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x6F"],
        ['㍽', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x6E"],
        ['㍾', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x6D"],
        ['㎎', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x53"],
        ['㎏', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x54"],
        ['㎜', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x50"],
        ['㎝', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x51"],
        ['㎞', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x52"],
        ['㎡', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x56"],
        ['㏄', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x55"],
        ['㏍', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x2D\x63"],
        ['凜', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB4\xA8"],
        ['堯', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x36\x46"],
        ['尭', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xDA"],
        ['槇', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\x6A"],
        ['槙', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xBF\xCE"],
        ['熙', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xBA"],
        ['瑤', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\x76"],
        ['瑶', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xE8"],
        ['遙', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\x5A"],
        ['遥', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD0\xC4"],
        ['－', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x21\x5D"],
        ['￢', 'jipsj', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    $option->{'GETA'} = "\x00\x00";
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'},}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'},}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]},} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]},}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$give $INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__DATA__
