#!/usr/bin/perl

package eBay::API::XML::Call::GetDescriptionTemplates::GetDescriptionTemplatesResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetDescriptionTemplatesResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetDescriptionTemplates::GetDescriptionTemplatesResponseType

=head1 DESCRIPTION

Returned after calling GetDescriptionTemplatesRequest.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetDescriptionTemplates::GetDescriptionTemplatesResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::DescriptionTemplateType;
use eBay::API::XML::DataType::ThemeGroupType;


my @gaProperties = ( [ 'DescriptionTemplate', 'ns:DescriptionTemplateType', '1'
	     ,'eBay::API::XML::DataType::DescriptionTemplateType', '1' ]
	, [ 'LayoutTotal', 'xs:int', '', '', '' ]
	, [ 'ObsoleteLayoutID', 'xs:int', '1', '', '' ]
	, [ 'ObsoleteThemeID', 'xs:int', '1', '', '' ]
	, [ 'ThemeGroup', 'ns:ThemeGroupType', '1'
	     ,'eBay::API::XML::DataType::ThemeGroupType', '1' ]
	, [ 'ThemeTotal', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDescriptionTemplate()

The information for one Theme or one Layout. There
can be multiple DescriptionTemplates.

#    Argument: reference to an array  
                      of 'ns:DescriptionTemplateType'

=cut

sub setDescriptionTemplate {
  my $self = shift;
  $self->{'DescriptionTemplate'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getDescriptionTemplate()

  Returned: Always
#    Returns: reference to an array  
                      of 'ns:DescriptionTemplateType'

=cut

sub getDescriptionTemplate {
  my $self = shift;
  return $self->_getDataTypeArray('DescriptionTemplate');
}


=head2 setLayoutTotal()

The number of Layout templates returned (that is, the
number of DescriptionTemplates for which Type is "Layout").

#    Argument: 'xs:int'

=cut

sub setLayoutTotal {
  my $self = shift;
  $self->{'LayoutTotal'} = shift
}

=head2 getLayoutTotal()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getLayoutTotal {
  my $self = shift;
  return $self->{'LayoutTotal'};
}


=head2 setObsoleteLayoutID()

The ID of a returned layout that is obsolete. There can be zero or more IDs.

#    Argument: reference to an array  
                      of 'xs:int'

=cut

sub setObsoleteLayoutID {
  my $self = shift;
  $self->{'ObsoleteLayoutID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getObsoleteLayoutID()

  Returned: Conditionally
#    Returns: reference to an array  
                      of 'xs:int'

=cut

sub getObsoleteLayoutID {
  my $self = shift;
  return $self->_getDataTypeArray('ObsoleteLayoutID');
}


=head2 setObsoleteThemeID()

The ID of a returned theme that is obsolete. There can be zero or more IDs.

#    Argument: reference to an array  
                      of 'xs:int'

=cut

sub setObsoleteThemeID {
  my $self = shift;
  $self->{'ObsoleteThemeID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getObsoleteThemeID()

  Returned: Conditionally
#    Returns: reference to an array  
                      of 'xs:int'

=cut

sub getObsoleteThemeID {
  my $self = shift;
  return $self->_getDataTypeArray('ObsoleteThemeID');
}


=head2 setThemeGroup()

Data for one theme group. There can be multiple
ThemeGroups in the response.

#    Argument: reference to an array  
                      of 'ns:ThemeGroupType'

=cut

sub setThemeGroup {
  my $self = shift;
  $self->{'ThemeGroup'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getThemeGroup()

  Returned: Conditionally
#    Returns: reference to an array  
                      of 'ns:ThemeGroupType'

=cut

sub getThemeGroup {
  my $self = shift;
  return $self->_getDataTypeArray('ThemeGroup');
}


=head2 setThemeTotal()

The number of Theme templates returned (that is, the number
of DescriptionTemplates for which Type is "Theme").

#    Argument: 'xs:int'

=cut

sub setThemeTotal {
  my $self = shift;
  $self->{'ThemeTotal'} = shift
}

=head2 getThemeTotal()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getThemeTotal {
  my $self = shift;
  return $self->{'ThemeTotal'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
