#!/usr/bin/perl

package eBay::API::XML::DataType::AbstractResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AbstractResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AbstractResponseType

=head1 DESCRIPTION

Base type definition of a response payload that can carry any
type of payload content with following optional elements:<br>
- timestamp of response message<br>
- application-level acknowledgement<br>
- application-level (business-level) errors and warnings



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AbstractResponseType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::BotBlockResponseType;
use eBay::API::XML::DataType::DuplicateInvocationDetailsType;
use eBay::API::XML::DataType::ErrorType;
use eBay::API::XML::DataType::Enum::AckCodeType;


my @gaProperties = ( [ 'Ack', 'ns:AckCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AckCodeType', '' ]
	, [ 'BotBlock', 'ns:BotBlockResponseType', ''
	     ,'eBay::API::XML::DataType::BotBlockResponseType', '1' ]
	, [ 'Build', 'xs:string', '', '', '' ]
	, [ 'CorrelationID', 'xs:string', '', '', '' ]
	, [ 'DuplicateInvocationDetails', 'ns:DuplicateInvocationDetailsType', ''
	     ,'eBay::API::XML::DataType::DuplicateInvocationDetailsType', '1' ]
	, [ 'EIASToken', 'xs:string', '', '', '' ]
	, [ 'Errors', 'ns:ErrorType', '1'
	     ,'eBay::API::XML::DataType::ErrorType', '1' ]
	, [ 'HardExpirationWarning', 'xs:string', '', '', '' ]
	, [ 'Message', 'xs:string', '', '', '' ]
	, [ 'NotificationEventName', 'xs:string', '', '', '' ]
	, [ 'NotificationSignature', 'xs:string', '', '', '' ]
	, [ 'RecipientUserID', 'xs:string', '', '', '' ]
	, [ 'Timestamp', 'xs:dateTime', '', '', '' ]
	, [ 'Version', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAck()

A token representing the application-level acknowledgement code that indicates
the response status (e.g., success). The AckCodeType list specifies
the possible values for Ack.

#    Argument: 'ns:AckCodeType'

=cut

sub setAck {
  my $self = shift;
  $self->{'Ack'} = shift
}

=head2 getAck()

  Calls:   Returned: Always
  AllCallsExcept: CompleteSale, GetPopularKeywords
  AllValuesExcept: PartialFailure

  Calls: CompleteSale
         GetPopularKeywords
  Returned: Always

#    Returns: 'ns:AckCodeType'

=cut

sub getAck {
  my $self = shift;
  return $self->{'Ack'};
}


=head2 setBotBlock()

Container of token, image URL and audio URL.

#    Argument: 'ns:BotBlockResponseType'

=cut

sub setBotBlock {
  my $self = shift;
  $self->{'BotBlock'} = shift
}

=head2 getBotBlock()

  Calls: PlaceOffer
  Returned: Conditionally

#    Returns: 'ns:BotBlockResponseType'

=cut

sub getBotBlock {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BotBlock'
		,'eBay::API::XML::DataType::BotBlockResponseType');
}


=head2 setBuild()

This refers to the specific software build that eBay used when processing the request
and generating the response. This includes the version number plus additional
information. eBay Developer Support may request the build information
when helping you resolve technical issues.

#    Argument: 'xs:string'

=cut

sub setBuild {
  my $self = shift;
  $self->{'Build'} = shift
}

=head2 getBuild()

  Calls:   Returned: Always
  AllCalls: 

#    Returns: 'xs:string'

=cut

sub getBuild {
  my $self = shift;
  return $self->{'Build'};
}


=head2 setCorrelationID()

In most cases, all calls support a MessageID element in the request
and a CorrelationID element in the response. If you pass a message
ID in a request, we will return the same value in CorrelationID in
the response. You can use this for tracking that a response is
returned for every request and to match particular responses to
particular requests. If you do not pass MessageID in the request,
CorrelationID is not returned.<br>
<br>
<span class="tablenote"><b>Note:</b>
GetCategories, GetAttributesCS, GetCategory2CS, GetAttributesXSL,
GetProductFinder, GetProductFinderXSL, and GetProductSearchPage
are designed to retrieve very large sets of metadata
that change once a day or less often. To improve performance,
these calls return cached responses when you request all available data
(with no filters). When this occurs, the MessageID and CorrelationID
fields aren't applicable.
However, if you specify an input filter to reduce the amount of data
returned, the calls retrieve the latest data (not cached).
When this occurs, MessageID and CorrelationID are applicable.
</span>

#    Argument: 'xs:string'

=cut

sub setCorrelationID {
  my $self = shift;
  $self->{'CorrelationID'} = shift
}

=head2 getCorrelationID()

  Calls:   Returned: Conditionally
  AllCalls: 

#    Returns: 'xs:string'

=cut

sub getCorrelationID {
  my $self = shift;
  return $self->{'CorrelationID'};
}


=head2 setDuplicateInvocationDetails()

Information that explains a failure due to a duplicate InvocationID being
passed in.

#    Argument: 'ns:DuplicateInvocationDetailsType'

=cut

sub setDuplicateInvocationDetails {
  my $self = shift;
  $self->{'DuplicateInvocationDetails'} = shift
}

=head2 getDuplicateInvocationDetails()

  Calls: AddItem
         AddLiveAuctionItem
         AddOrder
         AddSecondChanceItem
         AddToItemDescription
         PlaceOffer
         RelistItem
         ReviseCheckoutStatus
         ReviseItem
         ReviseLiveAuctionItem
  Returned: Conditionally

#    Returns: 'ns:DuplicateInvocationDetailsType'

=cut

sub getDuplicateInvocationDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DuplicateInvocationDetails'
		,'eBay::API::XML::DataType::DuplicateInvocationDetailsType');
}


=head2 setEIASToken()

Unique Identifier of Recipient user ID of the notification. Only returned by
Platform Notifications (not for regular API call responses).

#    Argument: 'xs:string'

=cut

sub setEIASToken {
  my $self = shift;
  $self->{'EIASToken'} = shift
}

=head2 getEIASToken()

#    Returns: 'xs:string'

=cut

sub getEIASToken {
  my $self = shift;
  return $self->{'EIASToken'};
}


=head2 setErrors()

A list of application-level errors (if any) that occurred when eBay
processed the request.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ErrorHandling
Title: Error Handling

#    Argument: reference to an array  
                      of 'ns:ErrorType'

=cut

sub setErrors {
  my $self = shift;
  $self->{'Errors'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getErrors()

  Calls:   Returned: Conditionally
  AllCalls: 

#    Returns: reference to an array  
                      of 'ns:ErrorType'

=cut

sub getErrors {
  my $self = shift;
  return $self->_getDataTypeArray('Errors');
}


=head2 setHardExpirationWarning()

Expiration date of the user's authentication token. Only returned
within the 7-day period prior to a token's expiration. To ensure
that user authentication tokens are secure and to help avoid a
user's token being compromised, tokens have a limited life span. A
token is only valid for a period of time (set by eBay). After this
amount of time has passed, the token expires and must be replaced
with a new token.

#    Argument: 'xs:string'

=cut

sub setHardExpirationWarning {
  my $self = shift;
  $self->{'HardExpirationWarning'} = shift
}

=head2 getHardExpirationWarning()

  Calls:   Returned: Conditionally
  AllCallsExcept: FetchToken

#    Returns: 'xs:string'

=cut

sub getHardExpirationWarning {
  my $self = shift;
  return $self->{'HardExpirationWarning'};
}


=head2 setMessage()

Supplemental information from eBay, if applicable. May elaborate on errors or
provide useful hints for the seller. This data can accompany the call's normal
data result set or a result set that contains only errors. The string can
return HTML, including TABLE, IMG, and HREF elements. In this case, an HTML-
based application should be able to include the HTML as-is in the HTML page
that displays the results. A non-HTML application would need to parse the HTML
and convert the table elements and image references into UI elements
particular to the programming language used. Because this data is returned as
a string, the HTML markup elements are escaped with character entity
references (e.g.,&lt;table&gt;&lt;tr&gt;...). See the
appendices in the eBay Web Services guide for general information about string
data types.

#    Argument: 'xs:string'

=cut

sub setMessage {
  my $self = shift;
  $self->{'Message'} = shift
}

=head2 getMessage()

  Calls: AddItem
         AddLiveAuctionItem
         AddToItemDescription
         EndItem
         PlaceOffer
         RelistItem
         RespondToWantItNowPost
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getMessage {
  my $self = shift;
  return $self->{'Message'};
}


=head2 setNotificationEventName()

Event name of the notification. Only returned by Platform Notifications.

#    Argument: 'xs:string'

=cut

sub setNotificationEventName {
  my $self = shift;
  $self->{'NotificationEventName'} = shift
}

=head2 getNotificationEventName()

#    Returns: 'xs:string'

=cut

sub getNotificationEventName {
  my $self = shift;
  return $self->{'NotificationEventName'};
}


=head2 setNotificationSignature()

A Base64-encoded MD5 hash that allows the recipient of a Platform
Notification to verify this is a valid Platform Notification sent by
eBay.

#    Argument: 'xs:string'

=cut

sub setNotificationSignature {
  my $self = shift;
  $self->{'NotificationSignature'} = shift
}

=head2 getNotificationSignature()

#    Returns: 'xs:string'

=cut

sub getNotificationSignature {
  my $self = shift;
  return $self->{'NotificationSignature'};
}


=head2 setRecipientUserID()

Recipient user ID of the notification. Only returned by Platform Notifications.

#    Argument: 'xs:string'

=cut

sub setRecipientUserID {
  my $self = shift;
  $self->{'RecipientUserID'} = shift
}

=head2 getRecipientUserID()

#    Returns: 'xs:string'

=cut

sub getRecipientUserID {
  my $self = shift;
  return $self->{'RecipientUserID'};
}


=head2 setTimestamp()

This value represents the date and time when eBay processed the
request. The time zone of this value is GMT and the format is the
ISO 8601 date and time format (YYYY-MM-DDTHH:MM:SS.SSSZ). See Time
Values in the eBay Web Services guide for information about this
time format and converting to and from the GMT time zone. <br>
<br>
<span class="tablenote"><b>Note:</b>
GetCategories, GetAttributesCS, GetCategory2CS, GetAttributesXSL,
GetProductFinder, GetProductFinderXSL, and GetProductSearchPage
are designed to retrieve very large sets of metadata
that change once a day or less often. To improve performance,
these calls return cached responses when you request all available data
(with no filters). When this occurs, this time value reflects the
time the cached response was created. Thus, this value is not
necessarily when the request was processed.
However, if you specify an input filter to reduce the amount of data
returned, the calls retrieve the latest data (not cached).
When this occurs, this time value does reflect when the request
was processed.</span>

#    Argument: 'xs:dateTime'

=cut

sub setTimestamp {
  my $self = shift;
  $self->{'Timestamp'} = shift
}

=head2 getTimestamp()

  Calls:   Returned: Always
  AllCalls: 

#    Returns: 'xs:dateTime'

=cut

sub getTimestamp {
  my $self = shift;
  return $self->{'Timestamp'};
}


=head2 setVersion()

The version of the response payload schema. Indicates the version of the
schema that eBay used to process the request.
See "Standard Data for All Calls" in the eBay Web Services Guide for information
on using the response version when troubleshooting "CustomCode" values that appear
in the response.

#    Argument: 'xs:string'

=cut

sub setVersion {
  my $self = shift;
  $self->{'Version'} = shift
}

=head2 getVersion()

  Calls:   Returned: Always
  AllCalls: 

#    Returns: 'xs:string'

=cut

sub getVersion {
  my $self = shift;
  return $self->{'Version'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
