######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT 7
package Geo::Location::TimeZone::G;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude 97.5 to 112.5
	"7" => {
		# Grid 7:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"365" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,4",
				"p" => [[97.5138320922852,-82.5],[97.5138320922852,-90],[97.5,-90],[97.5,-82.5],[97.5138320922852,-82.5],],
			},
		},
		# Grid 7:-5 ; 2 records
		"-5" => {
			"def_z" => "Antartica/Vostok",
			"366" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,4",
				"p" => [[97.5,-67.5],[97.5138320922852,-67.5],[97.5138320922852,-82.5],[97.5,-82.5],[97.5,-67.5],],
			},
		},
		# Grid 7:-4 ; 2 records
		"-4" => {
			"def_z" => "Antartica/Casey",
			"367" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,4",
				"p" => [[97.5138320922852,-52.5],[97.5138320922852,-67.5],[97.5,-67.5],[97.5,-52.5],[97.5138320922852,-52.5],],
			},
		},
		# Grid 7:-3 ; 1 records
		"-3" => {
			"368" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,4",
				"p" => [[97.5138320922852,-37.5],[97.5138320922852,-52.5],[97.5,-52.5],[97.5,-37.5],[97.5138320922852,-37.5],],
			},
		},
		# Grid 7:-2 ; 1 records
		"-2" => {
			"369" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,4",
				"p" => [[97.5138320922852,-22.5],[97.5138320922852,-37.5],[97.5,-37.5],[97.5,-22.5],[97.5138320922852,-22.5],],
			},
		},
		# Grid 7:-1 ; 2 records
		"-1" => {
			"def_z" => "Etc/GMT+6",
			"409" => {
				"z" => "Indian/Cocos",
				"c" => "ESRI",
				"s" => "25,2",
				"p" => [[97.5138320922852,-11.2594985961914],[97.5138320922852,-13.935341835022],[97.5,-13.9353294279578],[97.5,-11.2594985961914],[97.5138320922852,-11.2594985961914],],
			},
		},
		# Grid 7:0 ; 3 records
		"0" => {
			"def_z1" => "99.7833333,2.45,Asia/Makassar",
			"def_z0" => "106.8294444,-6.1744444,Asia/Jakarta",
			"128" => {
				"z1" => "103.8558333,1.2930556,Asia/Singapore",
				"z0" => "109.3333333,-0.0333333,Asia/Pontianak",
				"z2" => "101.7,3.1666667,Asia/Kuala_Lumpur",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[108.352478027344,7.5],[112.5,7.5],[112.5,-3.47976858525807],[112.2021484375,-3.4866955280304],[111.946502685547,-3.62872266769409],[111.790267944336,-3.60031723976135],[111.733459472656,-3.53640508651733],[111.790267944336,-3.38727641105652],[111.776069641113,-3.07481646537781],[111.335784912109,-3.03220820426941],[111.016220092773,-3.12452602386475],[110.909698486328,-3.13872861862183],[110.781875610352,-3.10322165489197],[110.675354003906,-3.13872861862183],[110.504920959473,-2.99670124053955],[110.306083679199,-3.06061363220215],[110.171157836914,-3.03220820426941],[110.064636230469,-2.92568778991699],[110.114349365234,-2.49960589408875],[110.071739196777,-2.25815916061401],[110.093040466309,-2.0309157371521],[110.050437927246,-1.95280075073242],[109.929710388184,-1.91729390621185],[109.872901916504,-1.83917891979218],[109.894203186035,-1.74686121940613],[109.986518859863,-1.68294882774353],[110.043334960938,-1.36338746547699],[109.766380310059,-1.20715749263763],[109.46102142334,-1.34918475151062],[109.390007019043,-1.28527247905731],[109.425514221191,-1.02252197265625],[109.262184143066,-0.901798844337463],[109.10595703125,-0.546730577945709],[109.020736694336,-0.248473301529884],[109.113052368164,0.0284799318760633],[109.077545166016,0.234419584274292],[108.892913818359,0.291230350732803],[108.829002380371,0.475865840911865],[108.658569335938,0.745717704296112],[108.665672302246,0.852238297462463],[108.743782043457,0.859339475631714],[108.907112121582,1.08658337593079],[108.907112121582,1.17890095710754],[109.027839660645,1.36353671550751],[109.027839660645,1.49136090278625],[109.077545166016,1.57657754421234],[109.240882873535,1.72570621967316],[109.323677062988,1.96657240390778],[109.323677062988,4.8696436882019],[105.119094848633,4.86964416503906],[105.131950378418,2.0022988319397],[104.31224822998,1.3465381860733],[103.92650604248,1.25653195381165],[103.756141662598,1.1858127117157],[103.531120300293,1.23403036594391],[103.412185668945,1.30153512954712],[103.241813659668,1.45583164691925],[103.209671020508,1.58441209793091],[102.946083068848,1.71942162513733],[102.817504882812,1.83192956447601],[102.692138671875,1.83192956447601],[102.537841796875,2.01194214820862],[102.341751098633,2.13409376144409],[102.148880004883,2.20802760124207],[101.930297851562,2.39125466346741],[101.84992980957,2.36232399940491],[101.837074279785,2.44268679618835],[101.756713867188,2.5616238117218],[101.518836975098,2.65484476089478],[101.415969848633,2.78663969039917],[101.29061126709,2.81557035446167],[101.203819274902,2.93129277229309],[101.216674804688,3.04058599472046],[101.287391662598,3.11451983451843],[101.178100585938,3.34596467018127],[100.949867248535,3.65777230262756],[100.503051757812,3.97600913047791],[100.567344665527,4.66391468048096],[100.509483337402,4.82464027404785],[100.419471740723,4.90178871154785],[100.331123352051,5.07478809356689],[100.168769836426,5.26112699508667],[100.166839599609,5.3750786781311],[99.7235870361328,6.1640510559082],[99.6492309570312,6.35236120223999],[99.6308822631836,6.42768526077271],[99.8423690795898,6.47983312606812],[100.127113342285,6.42494678497314],[100.171356201172,6.47666549682617],[100.19580078125,6.70249938964844],[100.293853759766,6.70388793945312],[100.334411621094,6.58694362640381],[100.387481689453,6.53610992431641],[100.498863220215,6.52305507659912],[100.661087036133,6.4474983215332],[100.754150390625,6.50194358825684],[100.765533447266,6.45194339752197],[100.833587646484,6.41944313049316],[100.857467651367,6.23444366455078],[100.951370239258,6.23972129821777],[100.989692687988,6.27749919891357],[101.033309936523,6.24388790130615],[101.115516662598,6.24888801574707],[101.121627807617,6.18722057342529],[101.075531005859,6.15055465698242],[101.119956970215,6.09833240509033],[101.119422912598,5.98444366455078],[101.101356506348,5.9269437789917],[101.035797119141,5.89611053466797],[100.990249633789,5.78805446624756],[101.145812988281,5.63111019134521],[101.256088256836,5.70583248138428],[101.289688110352,5.81055450439453],[101.351638793945,5.8083324432373],[101.569976806641,5.91666603088379],[101.65885925293,5.86055469512939],[101.69164276123,5.76361083984375],[101.762481689453,5.7888879776001],[101.833862304688,5.74333190917969],[101.94384765625,5.86194324493408],[101.948303222656,5.96944332122803],[102.091636657715,6.11055469512939],[102.095230102539,6.23613834381104],[112.5,6.22286039684103],[112.5,7.5],[110.863876342773,7.5],[108.352478027344,7.5],],
			},
			"371" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,4",
				"p" => [[97.5,-0.543522631776275],[97.5138320922852,-0.562850534915924],[97.5138320922852,-7.5],[97.5,-7.5],[97.5,7.5],[97.5,-0.543522631776275],],
			},
		},
		# Grid 7:1 ; 3 records
		"1" => {
			"def_z1" => "102.6,17.9666667,Asia/Vientiane",
			"def_z0" => "104.9166667,11.55,Asia/Phnom_Penh",
			"def_z2" => "100.5166667,13.75,Asia/Bangkok",
			"def_z3" => "106.6666667,10.75,Asia/Saigon",
			"129" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[108.352478027344,22.5],[112.5,22.5],[112.5,7.5],[112.5,14.7117328643799],[110.148902893066,14.7117328643799],[107.986541748047,18.504487991333],[107.989326477051,21.3862037658691],[108.003799438477,21.4467639923096],[108.082405090332,21.4917335510254],[107.990020751953,21.5424118041992],[107.948028564453,21.5419425964355],[107.858596801758,21.6508293151855],[107.783050537109,21.6669387817383],[107.536102294922,21.5863838195801],[107.485809326172,21.5977745056152],[107.457763671875,21.6583290100098],[107.362731933594,21.6052627563477],[107.301376342773,21.7311058044434],[107.220832824707,21.7083282470703],[107.020263671875,21.8224983215332],[107.04914855957,21.9072189331055],[107.029159545898,21.9366607666016],[106.932746887207,21.9274940490723],[106.901657104492,21.9705505371094],[106.80859375,21.9736061096191],[106.755256652832,22.0152740478516],[106.679428100586,21.9738845825195],[106.703323364258,22.0897178649902],[106.665267944336,22.1994400024414],[106.695823669434,22.2224960327148],[106.658332824707,22.3244400024414],[106.565536499023,22.3458290100098],[106.551712036133,22.4568214416504],[106.567674266887,22.5],[103.966034777723,22.5],[103.964431762695,22.4991111755371],[103.963462057695,22.5],[103.079358616342,22.5],[103.076103210449,22.4983291625977],[103.072486877441,22.4474945068359],[103.030548095703,22.4355506896973],[102.928588867188,22.4819374084473],[102.918634915799,22.5],[102.278190619657,22.5],[102.269706726074,22.4916610717773],[102.253326416016,22.4147186279297],[102.186653137207,22.4299964904785],[102.140747070312,22.3962860107422],[102.114700317383,22.4338836669922],[102.030822753906,22.4552726745605],[101.919982910156,22.436107635498],[101.875526428223,22.3830528259277],[101.799987792969,22.4894371032715],[101.738037109375,22.496940612793],[101.671920776367,22.4463844299316],[101.680541992188,22.3791618347168],[101.626922607422,22.281665802002],[101.56999206543,22.2791633605957],[101.538879394531,22.2441596984863],[101.596939086914,22.1616630554199],[101.574432373047,22.1091613769531],[101.625526428223,21.9719390869141],[101.708602905273,21.928882598877],[101.784713745117,21.8249969482422],[101.752487182617,21.724437713623],[101.783050537109,21.6508293151855],[101.833053588867,21.6213836669922],[101.763046264648,21.5783309936523],[101.777481079102,21.5149993896484],[101.748870849609,21.4819374084473],[101.739151000977,21.3163871765137],[101.851379394531,21.2491607666016],[101.838043212891,21.2111053466797],[101.782211303711,21.2069396972656],[101.787200927734,21.1441612243652],[101.72998046875,21.1397171020508],[101.669982910156,21.1997184753418],[101.607482910156,21.1802749633789],[101.615257263184,21.228328704834],[101.568603515625,21.2474937438965],[101.281936645508,21.1802749633789],[101.228317260742,21.3122177124023],[101.265266418457,21.376106262207],[101.193588256836,21.4127731323242],[101.216377258301,21.5455513000488],[101.148239135742,21.5726356506348],[101.168586730957,21.6302757263184],[101.105262756348,21.7713851928711],[100.886657714844,21.6833305358887],[100.666656494141,21.4794387817383],[100.484992980957,21.4583282470703],[100.429977416992,21.5286102294922],[100.378860473633,21.5388870239258],[100.203918457031,21.4353561401367],[100.123870849609,21.5047187805176],[100.106086730957,21.5833320617676],[100.171920776367,21.6538848876953],[100.124977111816,21.6905517578125],[100.002212524414,21.6961059570312],[99.9736022949219,21.7338829040527],[99.9419250488281,21.8249969482422],[99.9905395507812,21.9583282470703],[99.9680480957031,22.0502738952637],[99.8805541992188,22.0614471435547],[99.8438720703125,22.0233306884766],[99.7491455078125,22.0752754211426],[99.7091522216797,22.0397186279297],[99.6444396972656,22.0991630554199],[99.5216522216797,22.0999984741211],[99.4655456542969,22.1358299255371],[99.3594207763672,22.0930519104004],[99.2324829101562,22.1144409179688],[99.1627655029297,22.1591606140137],[99.2005462646484,22.1733283996582],[99.1822052001953,22.194995880127],[99.2705383300781,22.3477745056152],[99.2608184814453,22.3911056518555],[99.3801694862576,22.5],[110.863876342773,22.5],[108.352478027344,22.5],],
			},
			"406" => {
				"z" => "Indian/Cocos",
				"c" => "ESRI",
				"s" => "25,1",
				"p" => [[97.5,22.5],[99.3801694862576,22.5],[99.2608184814453,22.3911056518555],[99.2705383300781,22.3477745056152],[99.1822052001953,22.194995880127],[99.2005462646484,22.1733283996582],[99.1627655029297,22.1591606140137],[99.2324829101562,22.1144409179688],[99.3594207763672,22.0930519104004],[99.4655456542969,22.1358299255371],[99.5216522216797,22.0999984741211],[99.6444396972656,22.0991630554199],[99.7091522216797,22.0397186279297],[99.7491455078125,22.0752754211426],[99.8438720703125,22.0233306884766],[99.8805541992188,22.0614471435547],[99.9680480957031,22.0502738952637],[99.9905395507812,21.9583282470703],[99.9419250488281,21.8249969482422],[99.9736022949219,21.7338829040527],[100.002212524414,21.6961059570312],[100.124977111816,21.6905517578125],[100.171920776367,21.6538848876953],[100.106086730957,21.5833320617676],[100.123870849609,21.5047187805176],[100.203918457031,21.4353561401367],[100.378860473633,21.5388870239258],[100.429977416992,21.5286102294922],[100.484992980957,21.4583282470703],[100.666656494141,21.4794387817383],[100.886657714844,21.6833305358887],[101.105262756348,21.7713851928711],[101.168586730957,21.6302757263184],[101.148239135742,21.5726356506348],[101.161651611328,21.5305519104004],[100.997482299805,21.3958282470703],[100.834716796875,21.3024978637695],[100.722602844238,21.3077087402344],[100.671920776367,21.1280517578125],[100.621368408203,21.0516624450684],[100.545532226562,21.025276184082],[100.519989013672,20.9494400024414],[100.525543212891,20.8711090087891],[100.633613586426,20.8915405273438],[100.647216796875,20.8705520629883],[100.531936645508,20.8052749633789],[100.368873596191,20.8269424438477],[100.253883361816,20.745548248291],[100.175262451172,20.6352729797363],[100.091369628906,20.3486061096191],[99.9591522216797,20.4552726745605],[99.8699798583984,20.4272193908691],[99.8091430664062,20.3363838195801],[99.6735992431641,20.3108291625977],[99.4561004638672,20.3886070251465],[99.5552520751953,20.2066612243652],[99.5388793945312,20.1494407653809],[99.3255462646484,20.0661087036133],[99.1838684082031,20.1280517578125],[99.0763854980469,20.0974960327148],[99.0408172607422,20.0372200012207],[99.0297088623047,19.8288841247559],[98.9138793945312,19.7463836669922],[98.8369293212891,19.8163871765137],[98.7755432128906,19.7588882446289],[98.6491546630859,19.7419395446777],[98.5616455078125,19.6752738952637],[98.5097198486328,19.7124938964844],[98.2536010742188,19.6730499267578],[98.2385864257812,19.7222175598145],[98.0499877929688,19.8074989318848],[98.0349884033203,19.6438865661621],[97.8690795898438,19.5701751708984],[97.8766479492188,19.4952735900879],[97.79248046875,19.4019393920898],[97.8372039794922,19.298885345459],[97.7883148193359,19.2769432067871],[97.8418121337891,19.2070999145508],[97.8363800048828,19.1011085510254],[97.6772003173828,18.9341621398926],[97.7477569580078,18.865550994873],[97.7747039794922,18.569995880127],[97.6241455078125,18.554443359375],[97.5269317626953,18.4891624450684],[97.5,18.4917303290363],[97.5,18.2806280847848],[97.5358123779297,18.2686080932617],[97.5635986328125,18.3277740478516],[97.6430511474609,18.2902755737305],[97.6180419921875,18.2313842773438],[97.6866455078125,18.1466636657715],[97.6913604736328,18.0580520629883],[97.7519378662109,17.9722175598145],[97.6866455078125,17.8644409179688],[97.7744293212891,17.7508316040039],[97.7783203125,17.7033271789551],[98.0147094726562,17.5063858032227],[98.0530395507812,17.415828704834],[98.1155395507812,17.376106262207],[98.1188659667969,17.3138847351074],[98.2424774169922,17.2186050415039],[98.3358154296875,17.0555534362793],[98.4235992431641,17.0533294677734],[98.4883117675781,16.9819374084473],[98.5499877929688,16.8547172546387],[98.5197143554688,16.8677749633789],[98.5466461181641,16.8077735900879],[98.4777679443359,16.734992980957],[98.5335998535156,16.6416625976562],[98.5802764892578,16.6202735900879],[98.5899810791016,16.5533294677734],[98.6624908447266,16.4602737426758],[98.689697265625,16.2849960327148],[98.7158203125,16.2763862609863],[98.8144226074219,16.3758277893066],[98.8608093261719,16.4752731323242],[98.8674774169922,16.4341621398926],[98.9263763427734,16.3911056518555],[98.9185943603516,16.2686080932617],[98.8633117675781,16.2147178649902],[98.8527679443359,16.134162902832],[98.8080291748047,16.1030502319336],[98.6927490234375,16.1283302307129],[98.6380462646484,16.0472183227539],[98.5724945068359,16.0516624450684],[98.6174774169922,15.9699974060059],[98.5905456542969,15.9238872528076],[98.6099853515625,15.8669414520264],[98.5652618408203,15.7227754592896],[98.5755767822266,15.6618795394897],[98.5963745117188,15.4583320617676],[98.5699920654297,15.3366641998291],[98.4974822998047,15.3877773284912],[98.4224853515625,15.3599967956543],[98.4136047363281,15.2599983215332],[98.3102569580078,15.3030529022217],[98.2663879394531,15.2355537414551],[98.2013854980469,15.2208309173584],[98.2172088623047,15.1774978637695],[98.1844177246094,15.0991649627686],[98.2344207763672,15.0469436645508],[98.2138824462891,15.0033321380615],[98.2549896240234,14.9208316802979],[98.2599945068359,14.8166656494141],[98.44775390625,14.6058311462402],[98.4772033691406,14.52805519104],[98.5022125244141,14.5313873291016],[98.6169281005859,14.319164276123],[98.7310943603516,14.2777767181396],[98.7597198486328,14.2174968719482],[98.9716491699219,14.0836086273193],[99.0327606201172,13.9377765655518],[99.1194305419922,13.8786087036133],[99.1277618408203,13.773609161377],[99.1805419921875,13.7124977111816],[99.1705322265625,13.5711097717285],[99.2172088623047,13.4058322906494],[99.2127685546875,13.2161083221436],[99.1208190917969,13.1758308410645],[99.1121978759766,13.0558319091797],[99.191650390625,12.9744415283203],[99.1785888671875,12.9174976348877],[99.2452545166016,12.7236080169678],[99.4362335205078,12.5744342803955],[99.4124908447266,12.4663867950439],[99.4997100830078,12.1883316040039],[99.4733123779297,12.1338882446289],[99.5733184814453,12.1366653442383],[99.5452575683594,12.0455532073975],[99.5944366455078,11.9969434738159],[99.5894317626953,11.8724975585938],[99.6616516113281,11.8269424438477],[99.6358184814453,11.7336082458496],[99.5619201660156,11.6305522918701],[99.4677581787109,11.6097202301025],[99.4688720703125,11.519998550415],[99.4047088623047,11.4516639709473],[99.4005432128906,11.3841648101807],[99.3302764892578,11.3222198486328],[99.2374877929688,11.1094417572021],[99.1066436767578,11.0099983215332],[99.0816650390625,10.9513874053955],[99.020263671875,10.9633312225342],[99.0069427490234,10.8319416046143],[98.9130401611328,10.809720993042],[98.7872009277344,10.6822204589844],[98.7738800048828,10.6169414520264],[98.8238830566406,10.5166664123535],[98.7427520751953,10.3486080169678],[98.5525360107422,9.9831075668335],[98.5312957763672,9.91836643218994],[98.4547271728516,9.95847511291504],[98.1921920776367,9.91107368469238],[98.1119766235352,9.6886510848999],[97.9478988647461,9.59020137786865],[97.9953002929688,9.81991672515869],[98.1010360717773,9.93295097351074],[98.1630249023438,10.0605707168579],[98.1411514282227,10.1152648925781],[98.0791625976562,10.1079721450806],[97.9734191894531,10.0204620361328],[97.9333114624023,10.0715103149414],[97.9697723388672,10.3194561004639],[97.8749694824219,10.37779712677],[97.8822631835938,10.5054168701172],[97.9369583129883,10.5710496902466],[98.2067794799805,10.6986694335938],[98.1484375,10.8408737182617],[98.09375,10.8189964294434],[97.9588317871094,10.8518123626709],[97.86767578125,10.8153495788574],[97.8713226318359,10.8992137908936],[97.8968505859375,10.9429693222046],[98.290641784668,11.0414190292358],[98.1958389282227,11.3003044128418],[98.1156234741211,11.3695831298828],[97.9588317871094,11.3951072692871],[97.9588317871094,11.4680328369141],[98.0463409423828,11.6175298690796],[97.9880065917969,11.6941022872925],[97.9770660400391,11.8326606750488],[97.5,11.751980820613],[97.5,11.9115874010405],[97.7145309448242,12.1918182373047],[97.7582855224609,12.2939138412476],[97.8020477294922,12.4579963684082],[97.8202743530273,12.8262701034546],[98.2432403564453,12.9812364578247],[98.0609283447266,13.725076675415],[97.8932037353516,13.7651863098145],[97.8895568847656,13.9474992752075],[97.7655792236328,14.1626300811768],[97.7911071777344,14.2282629013062],[97.7509994506836,14.4069299697876],[97.9077835083008,14.5327262878418],[97.7874603271484,14.846305847168],[97.7509994506836,15.2072877883911],[97.7035980224609,15.2875051498413],[97.7145309448242,15.4005403518677],[97.6379623413086,15.4880504608154],[97.6306686401367,15.5937929153442],[97.6963043212891,15.6995344161987],[97.6890106201172,15.8836717605591],[97.5686798095703,15.982120513916],[97.5686798095703,16.1571426391602],[97.5,16.2546271734531],[97.5,15.6849498748779],[97.5,22.5],],
			},
		},
		# Grid 7:2 ; 2 records
		"2" => {
			"def_z" => "Asia/Chongqing",
			"407" => {
				"z" => "Indian/Cocos",
				"c" => "ESRI",
				"s" => "25,1",
				"p" => [[97.8690795898438,22.5],[97.5,22.5],[97.5,28.4377828565855],[97.5694427490234,28.548885345459],[97.6313629150391,28.4841613769531],[97.7113800048828,28.5169410705566],[97.7969360351562,28.3491630554199],[97.9088745117188,28.3763847351074],[98.0188751220703,28.2783317565918],[98.0130462646484,28.2147178649902],[98.0694427490234,28.2113838195801],[98.1362152099609,28.1563148498535],[98.1577606201172,28.1133308410645],[98.1308135986328,27.9691619873047],[98.2038726806641,27.9163856506348],[98.1669311523438,27.8705520629883],[98.2324829101562,27.8247184753418],[98.2269287109375,27.7347183227539],[98.3163757324219,27.5419425964355],[98.3688659667969,27.5294418334961],[98.4085998535156,27.5574989318848],[98.4324798583984,27.6894378662109],[98.5216522216797,27.6466636657715],[98.5510864257812,27.6669387817383],[98.5947113037109,27.5997200012207],[98.6680450439453,27.619441986084],[98.7047119140625,27.5824966430664],[98.6855316162109,27.4661064147949],[98.7366485595703,27.3291625976562],[98.691650390625,27.2019386291504],[98.7069396972656,27.0977745056152],[98.76220703125,27.0644416809082],[98.7397003173828,26.8641624450684],[98.7777709960938,26.7916641235352],[98.7555541992188,26.7241630554199],[98.7755432128906,26.6058311462402],[98.7374877929688,26.3869400024414],[98.6658172607422,26.260555267334],[98.7010955810547,26.2519416809082],[98.7305450439453,26.1772193908691],[98.6644287109375,26.098331451416],[98.6488800048828,26.1516609191895],[98.5680541992188,26.1230506896973],[98.6052551269531,25.9886054992676],[98.6416625976562,25.9844398498535],[98.7163848876953,25.8774948120117],[98.6319274902344,25.8011093139648],[98.5308227539062,25.8455505371094],[98.3916625976562,25.6566619873047],[98.3830413818359,25.5919418334961],[98.32666015625,25.5516624450684],[98.1652679443359,25.6227722167969],[98.1680450439453,25.5502738952637],[98.1249847412109,25.5058326721191],[98.1385955810547,25.3869400024414],[98.1074676513672,25.3872222900391],[98.0694427490234,25.3144416809082],[97.9410858154297,25.2141609191895],[97.8333282470703,25.259162902832],[97.7894287109375,25.1374969482422],[97.7233123779297,25.0694427490234],[97.7258148193359,25.0647201538086],[97.7366485595703,24.9188842773438],[97.8002624511719,24.8513870239258],[97.6894226074219,24.8344421386719],[97.5524749755859,24.743049621582],[97.5624847412109,24.5711097717285],[97.5308227539062,24.4474945068359],[97.6652679443359,24.4441604614258],[97.7177581787109,24.3583297729492],[97.6688690185547,24.3416633605957],[97.6647033691406,24.3061027526855],[97.7416534423828,24.2902717590332],[97.7599945068359,24.257495880127],[97.7274780273438,24.2249946594238],[97.7497100830078,24.169994354248],[97.7247009277344,24.1180534362793],[97.536376953125,23.9505500793457],[97.6499786376953,23.8517036437988],[97.7883148193359,23.9488830566406],[97.8524780273438,23.9583282470703],[97.9124908447266,24.0266609191895],[98.0644836425781,24.0890960693359],[98.2207794189453,24.1253051757812],[98.3573150634766,24.1031951904297],[98.4465942382812,24.1349563598633],[98.5446166992188,24.1256980895996],[98.5970306396484,24.0764846801758],[98.8907318115234,24.1600685119629],[98.8939056396484,24.0979461669922],[98.6772003173828,23.9680519104004],[98.7038726806641,23.9513854980469],[98.6885833740234,23.8013877868652],[98.8155364990234,23.767219543457],[98.8191528320312,23.7055511474609],[98.8858184814453,23.6133308410645],[98.8060913085938,23.5416641235352],[98.82470703125,23.480827331543],[98.8799743652344,23.4836044311523],[98.9147033691406,23.4172172546387],[98.9185943603516,23.3647193908691],[98.8788604736328,23.329719543457],[98.9402618408203,23.3136100769043],[98.8813629150391,23.1880493164062],[99.0588684082031,23.1674957275391],[99.0613708496094,23.123607635498],[99.1110992431641,23.1019401550293],[99.3563690185547,23.1349945068359],[99.5038757324219,23.0897178649902],[99.5663757324219,22.9380493164062],[99.51416015625,22.9122161865234],[99.4455261230469,22.9497184753418],[99.4405364990234,22.8649978637695],[99.3280487060547,22.7447166442871],[99.3849945068359,22.603328704834],[99.3844299316406,22.5038871765137],[99.3801694862576,22.5],[99.5552520751953,22.5],[97.8690795898438,22.5],],
			},
		},
		# Grid 7:3 ; 2 records
		"3" => {
			"def_z1" => "102.1666667,44.6666667,Asia/Hovd",
			"def_z0" => "104.3333333,52.2666667,Asia/Irkutsk",
			"def_z2" => "106.9166667,47.9166667,Asia/Ulaanbaatar",
			"149" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,1",
				"p" => [[112.5,50.3452682495117],[112.5,49.540152359918],[112.491653442383,49.5413818359375],[111.963882446289,49.4069366455078],[111.68221282959,49.4066543579102],[111.498031616211,49.3491592407227],[111.371368408203,49.3741607666016],[110.981086730957,49.2008285522461],[110.788589477539,49.1494369506836],[110.630256652832,49.1524887084961],[110.401092529297,49.254997253418],[110.236923217773,49.1694412231445],[109.850273132324,49.1899871826172],[109.739433288574,49.234992980957],[109.544143676758,49.2324905395508],[109.351928710938,49.3369369506836],[109.206939697266,49.3602752685547],[108.65104675293,49.3317337036133],[108.527481079102,49.3455429077148],[108.358871459961,49.4452667236328],[108.271926879883,49.5355529785156],[108.137496948242,49.5580444335938],[108.041931152344,49.6108245849609],[108.031936645508,49.6747131347656],[107.947479248047,49.6833267211914],[107.989151000977,49.7449951171875],[107.955261230469,49.8516616821289],[107.98055267334,49.9408264160156],[107.81330871582,49.948600769043],[107.753593444824,49.9795455932617],[107.798866271973,50.0299911499023],[107.800811767578,50.0916595458984],[107.761932373047,50.1047134399414],[107.773612976074,50.1574935913086],[107.820541381836,50.206657409668],[107.893600463867,50.1924896240234],[107.937477111816,50.2222137451172],[107.985527038574,50.3372116088867],[108.076103210449,50.3533248901367],[108.132476806641,50.3144378662109],[108.204162597656,50.4111022949219],[108.338592529297,50.4044342041016],[108.436920166016,50.4624938964844],[108.603866577148,50.4522171020508],[108.685256958008,50.5041656494141],[108.658332824707,50.5377731323242],[108.544708251953,50.5277709960938],[108.416656494141,50.6136093139648],[108.179428100586,50.6591567993164],[108.065536499023,50.7580490112305],[108.251457214355,50.8339385986328],[108.332206726074,51.0488815307617],[108.499710083008,51.0591583251953],[108.57470703125,51.1152725219727],[108.454162597656,51.2277679443359],[108.352478027344,51.2652740478516],[108.473602294922,51.3449935913086],[108.546943664551,51.4752655029297],[108.620819091797,51.513053894043],[108.743041992188,51.4458236694336],[108.944976806641,51.4399871826172],[109.063598632812,51.5086059570312],[109.252212524414,51.3622131347656],[109.338592529297,51.3913803100586],[109.37996673584,51.3466567993164],[109.428863525391,51.4160995483398],[109.678863525391,51.4630508422852],[110.04914855957,51.619987487793],[110.394706726074,51.5794372558594],[110.420532226562,51.522216796875],[110.544708251953,51.4947128295898],[110.696090698242,51.5027770996094],[110.781661987305,51.5747146606445],[110.863876342773,51.5922164916992],[110.841369628906,51.6691589355469],[111.001937866211,51.7222137451172],[111.014999389648,51.7822113037109],[111.139709472656,51.8352661132812],[111.198028564453,51.8236083984375],[111.607757568359,51.9277725219727],[112.060806274414,52.2783279418945],[112.168319702148,52.3038787841797],[112.208877563477,52.2405471801758],[112.296371459961,52.2527770996094],[112.402206420898,52.2069396972656],[112.492477416992,52.25],[112.5,52.2661657612483],[112.5,52.5],[112.5,52.5],[112.5,50.3452682495117],],
			},
		},
		# Grid 7:4 ; 2 records
		"4" => {
			"def_z" => "Asia/Kamchatka",
			"150" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,1",
				"p" => [[112.5,56.9565505981445],[112.5,58.8702736572386],[112.446090698242,58.9280471801758],[112.459991455078,59.1616592407227],[112.5,59.2003806053861],[112.5,59.3240672005056],[112.438026428223,59.3302764892578],[112.283866882324,59.3030471801758],[112.307479858398,59.3366546630859],[112.272773742676,59.3649978637695],[112.33415222168,59.4169387817383],[112.271377563477,59.4663848876953],[112.273880004883,59.5044403076172],[112.221366882324,59.5036087036133],[111.993316650391,59.3447113037109],[111.941932678223,59.2711029052734],[111.768051147461,59.2780456542969],[111.646102905273,59.2061004638672],[111.435256958008,59.2738800048828],[111.304153442383,59.2569427490234],[111.18221282959,59.1833267211914],[111.083053588867,59.2394332885742],[110.996932983398,59.2080459594727],[110.692749023438,59.2577743530273],[110.578872680664,59.1916580200195],[110.591659545898,59.131103515625],[110.54248046875,59.1055526733398],[110.538589477539,59.0622100830078],[110.48193359375,59.033332824707],[110.352203369141,59.0358276367188],[110.2783203125,58.98193359375],[109.935531616211,59.009162902832],[109.820266723633,58.9797134399414],[109.741088867188,59.0719375610352],[109.640548706055,59.0616607666016],[109.628593444824,59.1511001586914],[109.528053283691,59.1802749633789],[109.540542602539,59.2208251953125],[109.517211914062,59.2308197021484],[109.516662597656,59.2919387817383],[109.260536193848,59.3169403076172],[109.244979858398,59.3630523681641],[109.355819702148,59.4166641235352],[109.259429931641,59.4511032104492],[109.533866882324,59.6455459594727],[109.484153747559,59.6872100830078],[109.49471282959,59.7502746582031],[109.651382446289,59.8619384765625],[109.619979858398,59.9030456542969],[109.769439697266,60.0288772583008],[109.716377258301,60.0522155761719],[109.693588256836,60.1119384765625],[109.726379394531,60.2260971069336],[109.806930541992,60.2544403076172],[109.805541992188,60.3130493164062],[109.878860473633,60.3380432128906],[109.861099243164,60.3741607666016],[109.951927185059,60.4036026000977],[109.916381835938,60.4588851928711],[110.021926879883,60.5169372558594],[110.038879394531,60.5583267211914],[110.117752075195,60.579719543457],[110.122207641602,60.6241607666016],[110.039978027344,60.6691589355469],[110.267761230469,60.6919326782227],[110.270263671875,60.7622146606445],[110.294708251953,60.7699890136719],[110.224990844727,60.7961044311523],[110.22998046875,60.8191604614258],[110.448028564453,60.976936340332],[110.457489013672,61.0366592407227],[110.52082824707,61.0813827514648],[110.483047485352,61.1597137451172],[110.397216796875,61.1811065673828],[110.321113586426,61.1463851928711],[110.179702758789,61.156379699707],[110.090270996094,61.2702713012695],[109.855262756348,61.2913818359375],[109.787490844727,61.3272171020508],[109.849151611328,61.430549621582],[109.82470703125,61.4774856567383],[109.865257263184,61.493049621582],[109.874153137207,61.533332824707],[109.706100463867,61.6480484008789],[109.716087341309,61.6766586303711],[109.612632751465,61.7139358520508],[109.638893127441,61.7608261108398],[109.585823059082,61.7744369506836],[109.586380004883,61.8233261108398],[109.61164855957,61.8927688598633],[109.818267822266,62.0036239624023],[109.903587341309,62.1130523681641],[109.999710083008,62.1636047363281],[109.933319091797,62.2347183227539],[110,62.2822113037109],[109.959991455078,62.3163833618164],[109.962768554688,62.3224945068359],[109.891098022461,62.3533248901367],[109.924697875977,62.397216796875],[109.903587341309,62.4138793945312],[109.544143676758,62.4324951171875],[109.471099853516,62.4049911499023],[109.420532226562,62.4583282470703],[109.315811157227,62.4755477905273],[109.26416015625,62.523323059082],[109.244430541992,62.5727691650391],[109.386932373047,62.5830535888672],[109.374977111816,62.6458282470703],[109.456100463867,62.6663818359375],[109.503883361816,62.7752685546875],[109.650543212891,62.8244400024414],[109.61580657959,62.8760986328125],[109.468322753906,62.9338760375977],[109.481086730957,62.9961013793945],[109.455261230469,62.9997177124023],[109.481086730957,63.0277709960938],[109.447196960449,63.0361099243164],[109.464706420898,63.0774917602539],[109.431663513184,63.0936050415039],[109.459991455078,63.1505432128906],[109.406097412109,63.1827697753906],[109.456382751465,63.2185974121094],[109.375259399414,63.2552719116211],[109.391662597656,63.3247146606445],[109.363037109375,63.3619384765625],[109.27165222168,63.3472137451172],[109.228866577148,63.4402694702148],[109.043319702148,63.5541610717773],[108.856643676758,63.5358276367188],[108.55859375,63.5997161865234],[108.131362915039,63.5677719116211],[108.11637878418,63.6224899291992],[108.270263671875,63.6788787841797],[108.288589477539,63.8080444335938],[108.371643066406,63.8263854980469],[108.466087341309,63.789436340332],[108.60555267334,63.8074951171875],[108.648880004883,63.7858276367188],[108.771926879883,63.8647155761719],[108.683868408203,63.9085998535156],[108.738311767578,63.9808197021484],[108.489967346191,64.1147003173828],[108.544143676758,64.1746978759766],[108.476928710938,64.2008209228516],[108.539428710938,64.2324829101562],[108.461380004883,64.2858123779297],[108.35693359375,64.3008117675781],[108.307479858398,64.2491455078125],[108.139976501465,64.26220703125],[108.026542663574,64.2234649658203],[107.993316650391,64.1697082519531],[107.850807189941,64.1805419921875],[107.594711303711,64.2991485595703],[107.334426879883,64.2444305419922],[107.23664855957,64.2869262695312],[107.234153747559,64.3313751220703],[107.102203369141,64.3369293212891],[106.886383056641,64.4160919189453],[106.753326416016,64.4119262695312],[106.673309326172,64.4980316162109],[106.604156494141,64.5133209228516],[106.565536499023,64.4958190917969],[106.585823059082,64.4444274902344],[106.394439697266,64.4433135986328],[106.186653137207,64.3963775634766],[106.066093444824,64.4208221435547],[106.147491455078,64.4852600097656],[106.038879394531,64.5160980224609],[105.79248046875,64.4780426025391],[105.804153442383,64.5305480957031],[105.726089477539,64.5722198486328],[105.749420166016,64.6144256591797],[105.703872680664,64.6588745117188],[105.877197265625,64.6580352783203],[105.828872680664,64.7419281005859],[105.847213745117,64.7916564941406],[105.898040771484,64.8213806152344],[106.009719848633,64.8180541992188],[105.949142456055,64.8949890136719],[106.040817260742,64.9047088623047],[106.105819702148,64.8591461181641],[106.22331237793,64.8572082519531],[105.974807739258,65.0030517578125],[105.998596191406,65.0391540527344],[106.165817260742,65.0902709960938],[106.19246673584,65.1285858154297],[106.291091918945,65.1388854980469],[106.373596191406,65.2049865722656],[106.511657714844,65.2038726806641],[106.426933288574,65.2613830566406],[106.442199707031,65.3088684082031],[106.61164855957,65.3927612304688],[106.841369628906,65.3760833740234],[106.876083374023,65.4410858154297],[106.964706420898,65.5044403076172],[106.698867797852,65.5510864257812],[106.714996337891,65.5930480957031],[106.621917724609,65.6105346679688],[106.643882751465,65.6322021484375],[106.421371459961,65.6669311523438],[106.415267944336,65.7013854980469],[106.471099853516,65.7410888671875],[106.448028564453,65.7741546630859],[106.476379394531,65.8044281005859],[106.448318481445,65.8213806152344],[106.49609375,65.8949890136719],[106.466659545898,65.9319305419922],[106.488876342773,66.0047149658203],[106.353042602539,66.1508178710938],[106.183319091797,66.1555480957031],[106.11580657959,66.1985931396484],[106.148880004883,66.2577667236328],[106.100807189941,66.3780364990234],[106.326927185059,66.4755401611328],[106.293869018555,66.5022125244141],[106.305816650391,66.5535888671875],[106.241653442383,66.5816650390625],[106.227203369141,66.6605377197266],[106.259986877441,66.6994171142578],[106.146102905273,66.7269287109375],[106.136108398438,66.756103515625],[106.19970703125,66.7833251953125],[106.187477111816,66.8024749755859],[105.988876342773,66.7977600097656],[106.074996948242,66.8608093261719],[106.068328857422,66.895263671875],[105.868591308594,66.9180450439453],[105.818878173828,66.9485931396484],[105.643600463867,66.9466400146484],[105.5283203125,67.022216796875],[105.905258178711,67.0455322265625],[105.995529174805,67.0788726806641],[106.053863525391,67.1680450439453],[106.232482910156,67.1849822998047],[106.503601074219,67.286376953125],[106.667762756348,67.2438659667969],[106.798866271973,67.3383178710938],[106.82385110394,67.5],[112.5,67.5],[112.5,52.5],[112.5,52.5],[112.5,56.9565505981445],],
			},
		},
		# Grid 7:5 ; 1 records
		"5" => {
			"151" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,1",
				"p" => [[112.5,67.5],[106.82385110394,67.5],[106.876647949219,67.8416595458984],[106.890823364258,68.8602600097656],[106.136657714844,69.4197082519531],[106.285263061523,69.4583282470703],[106.454711914062,69.5724945068359],[106.591087341309,69.5166625976562],[106.814697265625,69.5136108398438],[107.605262756348,69.6636047363281],[107.902206420898,69.6749877929688],[108.018051147461,69.7074890136719],[108.053588867188,69.7797088623047],[108.23664855957,69.8544311523438],[108.872482299805,69.8410949707031],[108.953872680664,69.7852630615234],[109.226089477539,69.7716522216797],[109.364433288574,69.8383178710938],[109.421096801758,69.8927612304688],[109.383613586426,69.9294281005859],[109.543869018555,70.0349884033203],[109.381088256836,70.0794372558594],[109.382751464844,70.1194305419922],[109.305541992188,70.1777648925781],[109.320541381836,70.2188720703125],[109.569442749023,70.2649993896484],[109.633041381836,70.3197174072266],[109.581672668457,70.3552551269531],[109.641662597656,70.3849945068359],[110.272491455078,70.4172058105469],[110.303588867188,70.4494171142578],[110.140548706055,70.4785919189453],[110.146102905273,70.5238800048828],[110.098876953125,70.5577545166016],[110.15941619873,70.5524749755859],[110.162490844727,70.5655364990234],[110.123596191406,70.6361083984375],[110.323608398438,70.7047119140625],[110.513610839844,70.7169342041016],[110.503051757812,70.7708282470703],[110.538307189941,70.7972106933594],[110.722351074219,70.8216552734375],[110.880813598633,70.7963714599609],[111.005661010742,70.8436584472656],[111.362487792969,70.8552551269531],[111.464752197266,70.9386444091797],[111.977203369141,70.9827575683594],[112.077476501465,71.0616455078125],[112.256103515625,71],[112.384986877441,71.064697265625],[112.5,71.0863512639267],[112.5,71.2713242548798],[112.333038330078,71.3433227539062],[112.011093139648,71.4069366455078],[112.01220703125,72.1333312988281],[111.77498626709,72.1449890136719],[111.743591308594,72.2072143554688],[111.624153137207,72.2136077880859],[111.668586730957,72.2658233642578],[111.580551147461,72.3194427490234],[111.359153747559,72.3169403076172],[111.088317871094,72.3722076416016],[111.075820922852,72.4060974121094],[111.303588867188,72.4783172607422],[111.315536499023,72.5127716064453],[110.889976501465,72.5811004638672],[110.924987792969,72.6319274902344],[110.730270385742,72.6447143554688],[110.632202148438,72.7866516113281],[110.731658935547,72.8299865722656],[110.659713745117,72.8530426025391],[110.64665222168,72.8955383300781],[110.875526428223,72.9485931396484],[110.815536499023,72.9535980224609],[110.777770996094,73.0005493164062],[110.941650390625,73.0388793945312],[110.858322143555,73.0780487060547],[110.797760009766,73.1730346679688],[110.423027038574,73.1899719238281],[110.627197265625,73.2688751220703],[110.566673278809,73.3194427490234],[110.164428710938,73.4024810791016],[110.564147949219,73.4063720703125],[110.803588867188,73.5083312988281],[110.848327636719,73.5655364990234],[111.054702758789,73.5716552734375],[111.117752075195,73.5935974121094],[111.143333435059,73.6377716064453],[111.080276489258,73.6585998535156],[110.914321899414,73.6966857910156],[110.877471923828,73.7285919189453],[110.916931152344,73.7602691650391],[110.893371582031,73.7654113769531],[111.294158935547,73.8593444824219],[111.637893676758,73.9354476928711],[111.682579040527,74.0695190429688],[111.339958190918,74.278076171875],[111.384643554688,74.4270401000977],[112.5,74.7288425114212],[112.5,67.5],[107.753593444824,67.5],[112.5,67.5],],
			},
		},
		# Grid 7:6 ; 1 records
		"6" => {
			"357" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,1",
				"p" => [[97.5,90],[97.5239639282227,90],[97.5239639282227,83.3941879272461],[97.5,83.3941632710458],[97.5,82.5],[97.5,90],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
