### base class of several features of the one pass algorithm, a list of functors

### NOTE : This is set as a parent : 'BagElement1'

use 'GFX-Tools-Buffer::toolsarray';

sub new {
    my ($class, $ElementClass) = @_; ### $ElementClass e.g. BagElement1.pm

    $self = SUPER::$ElementClass->new;
    $self->{functors} = toolsarray->new;
    
    bless $self, $class;
}

### functor is a OnePassFunctor
sub addFunctor {
    my ($self, $f) = @_;

    $self->{functors}->add($f);

    return len($self->{functors}->len - 1); ### returns last index of functor list
}

sub indexFunctor {
    my ($self, $index) = @_;

    return $self->{functors}->indexOf($index);
}

### iterates over functors and executes them in the list order
### 1. the bitmaparg gets set every cycle as all functors update the previous one
sub executeAllFunctors {
    my ($self, $bitmaparg) = @_;
 
    my $iter = toolsarray->new($self->{functors});

    while ($iter->hasNext) {

	my $resultbitmap = $iter->next->do($bitmaparg); ### FIXME next ?
	$iter->current->setResult($resultbitmap);

	$bitmaparg = $resultbitmap; ### update bitmap further in the list
    }
    
    return 0; ### NOTE C lang
}

1;
