# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Audio-BASSXS.t'

#########################

# change 'tests => 2' to 'tests => last_test_to_print';

use Test::More tests => 2;
BEGIN { use_ok('Audio::BASSXS') };


my $fail = 0;
foreach my $constname (qw(
	BASS_3DALG_DEFAULT BASS_3DALG_FULL BASS_3DALG_LIGHT BASS_3DALG_OFF
	BASS_3DMODE_NORMAL BASS_3DMODE_OFF BASS_3DMODE_RELATIVE
	BASS_ACTIVE_PAUSED BASS_ACTIVE_PLAYING BASS_ACTIVE_STALLED
	BASS_ACTIVE_STOPPED BASS_CONFIG_3DALGORITHM BASS_CONFIG_BUFFER
	BASS_CONFIG_CURVE_PAN BASS_CONFIG_CURVE_VOL BASS_CONFIG_FLOATDSP
	BASS_CONFIG_GVOL_MUSIC BASS_CONFIG_GVOL_SAMPLE BASS_CONFIG_GVOL_STREAM
	BASS_CONFIG_MAXVOL BASS_CONFIG_NET_BUFFER BASS_CONFIG_NET_TIMEOUT
	BASS_CONFIG_UPDATEPERIOD BASS_CTYPE_MUSIC_IT BASS_CTYPE_MUSIC_MO3
	BASS_CTYPE_MUSIC_MOD BASS_CTYPE_MUSIC_MTM BASS_CTYPE_MUSIC_S3M
	BASS_CTYPE_MUSIC_XM BASS_CTYPE_RECORD BASS_CTYPE_SAMPLE
	BASS_CTYPE_STREAM BASS_CTYPE_STREAM_MP1 BASS_CTYPE_STREAM_MP2
	BASS_CTYPE_STREAM_MP3 BASS_CTYPE_STREAM_OGG BASS_CTYPE_STREAM_WAV
	BASS_DATA_AVAILABLE BASS_DATA_FFT1024 BASS_DATA_FFT2048
	BASS_DATA_FFT4096 BASS_DATA_FFT512 BASS_DATA_FFT_INDIVIDUAL
	BASS_DATA_FFT_NOWINDOW BASS_DEVICE_3D BASS_DEVICE_8BITS
	BASS_DEVICE_LATENCY BASS_DEVICE_MONO BASS_DEVICE_SPEAKERS
	BASS_ERROR_ALREADY BASS_ERROR_BUFLOST BASS_ERROR_CREATE
	BASS_ERROR_DECODE BASS_ERROR_DEVICE BASS_ERROR_DRIVER BASS_ERROR_DX
	BASS_ERROR_EMPTY BASS_ERROR_FILEFORM BASS_ERROR_FILEOPEN
	BASS_ERROR_FORMAT BASS_ERROR_FREQ BASS_ERROR_HANDLE BASS_ERROR_ILLPARAM
	BASS_ERROR_ILLTYPE BASS_ERROR_INIT BASS_ERROR_MEM BASS_ERROR_NO3D
	BASS_ERROR_NOCHAN BASS_ERROR_NOEAX BASS_ERROR_NOFX BASS_ERROR_NOHW
	BASS_ERROR_NONET BASS_ERROR_NOPAUSE BASS_ERROR_NOPLAY
	BASS_ERROR_NOTAVAIL BASS_ERROR_NOTFILE BASS_ERROR_PLAYING
	BASS_ERROR_POSITION BASS_ERROR_SPEAKER BASS_ERROR_START
	BASS_ERROR_TIMEOUT BASS_ERROR_UNKNOWN BASS_FILEPOS_DECODE
	BASS_FILEPOS_DOWNLOAD BASS_FILEPOS_END BASS_FILE_CLOSE BASS_FILE_LEN
	BASS_FILE_QUERY BASS_FILE_READ BASS_FILE_SEEK BASS_FX_PHASE_180
	BASS_FX_PHASE_90 BASS_FX_PHASE_NEG_180 BASS_FX_PHASE_NEG_90
	BASS_FX_PHASE_ZERO BASS_INPUT_LEVEL BASS_INPUT_OFF BASS_INPUT_ON
	BASS_INPUT_TYPE_ANALOG BASS_INPUT_TYPE_AUX BASS_INPUT_TYPE_CD
	BASS_INPUT_TYPE_DIGITAL BASS_INPUT_TYPE_LINE BASS_INPUT_TYPE_MASK
	BASS_INPUT_TYPE_MIC BASS_INPUT_TYPE_PHONE BASS_INPUT_TYPE_SPEAKER
	BASS_INPUT_TYPE_SYNTH BASS_INPUT_TYPE_UNDEF BASS_INPUT_TYPE_WAVE
	BASS_MP3_SETPOS BASS_MUSIC_3D BASS_MUSIC_AUTOFREE BASS_MUSIC_CALCLEN
	BASS_MUSIC_DECODE BASS_MUSIC_FLOAT BASS_MUSIC_FT2MOD BASS_MUSIC_FX
	BASS_MUSIC_LOOP BASS_MUSIC_MONO BASS_MUSIC_NONINTER BASS_MUSIC_NOSAMPLE
	BASS_MUSIC_POSRESET BASS_MUSIC_PT1MOD BASS_MUSIC_RAMP BASS_MUSIC_RAMPS
	BASS_MUSIC_STOPBACK BASS_MUSIC_SURROUND BASS_MUSIC_SURROUND2
	BASS_OBJECT_DS BASS_OBJECT_DS3DL BASS_OK BASS_RECORD_PAUSE
	BASS_SAMPLE_3D BASS_SAMPLE_8BITS BASS_SAMPLE_FLOAT BASS_SAMPLE_FX
	BASS_SAMPLE_LOOP BASS_SAMPLE_MONO BASS_SAMPLE_MUTEMAX
	BASS_SAMPLE_OVER_DIST BASS_SAMPLE_OVER_POS BASS_SAMPLE_OVER_VOL
	BASS_SAMPLE_SOFTWARE BASS_SAMPLE_VAM BASS_SLIDE_FREQ BASS_SLIDE_PAN
	BASS_SLIDE_VOL BASS_SPEAKER_CENLFE BASS_SPEAKER_CENTER
	BASS_SPEAKER_FRONT BASS_SPEAKER_FRONTLEFT BASS_SPEAKER_FRONTRIGHT
	BASS_SPEAKER_LEFT BASS_SPEAKER_LFE BASS_SPEAKER_REAR BASS_SPEAKER_REAR2
	BASS_SPEAKER_REAR2LEFT BASS_SPEAKER_REAR2RIGHT BASS_SPEAKER_REARLEFT
	BASS_SPEAKER_REARRIGHT BASS_SPEAKER_RIGHT BASS_STREAMPROC_END
	BASS_STREAM_AUTOFREE BASS_STREAM_BLOCK BASS_STREAM_DECODE
	BASS_STREAM_META BASS_STREAM_RESTRATE BASS_SYNC_DOWNLOAD BASS_SYNC_END
	BASS_SYNC_MESSAGE BASS_SYNC_META BASS_SYNC_MIXTIME BASS_SYNC_MUSICFX
	BASS_SYNC_MUSICINST BASS_SYNC_MUSICPOS BASS_SYNC_ONETIME BASS_SYNC_POS
	BASS_SYNC_SLIDE BASS_SYNC_STALL BASS_TAG_HTTP BASS_TAG_ICY BASS_TAG_ID3
	BASS_TAG_ID3V2 BASS_TAG_META BASS_TAG_OGG BASS_UNICODE
	BASS_VAM_HARDWARE BASS_VAM_SOFTWARE BASS_VAM_TERM_DIST
	BASS_VAM_TERM_PRIO BASS_VAM_TERM_TIME DSCAPS_CERTIFIED
	DSCAPS_CONTINUOUSRATE DSCAPS_EMULDRIVER DSCAPS_SECONDARY16BIT
	DSCAPS_SECONDARY8BIT DSCAPS_SECONDARYMONO DSCAPS_SECONDARYSTEREO
	DSCCAPS_CERTIFIED DSCCAPS_EMULDRIVER EAX_PRESET_ALLEY EAX_PRESET_ARENA
	EAX_PRESET_AUDITORIUM EAX_PRESET_BATHROOM EAX_PRESET_CARPETEDHALLWAY
	EAX_PRESET_CAVE EAX_PRESET_CITY EAX_PRESET_CONCERTHALL EAX_PRESET_DIZZY
	EAX_PRESET_DRUGGED EAX_PRESET_FOREST EAX_PRESET_GENERIC
	EAX_PRESET_HALLWAY EAX_PRESET_HANGAR EAX_PRESET_LIVINGROOM
	EAX_PRESET_MOUNTAINS EAX_PRESET_PADDEDCELL EAX_PRESET_PARKINGLOT
	EAX_PRESET_PLAIN EAX_PRESET_PSYCHOTIC EAX_PRESET_QUARRY EAX_PRESET_ROOM
	EAX_PRESET_SEWERPIPE EAX_PRESET_STONECORRIDOR EAX_PRESET_STONEROOM
	EAX_PRESET_UNDERWATER WAVE_FORMAT_1M08 WAVE_FORMAT_1M16
	WAVE_FORMAT_1S08 WAVE_FORMAT_1S16 WAVE_FORMAT_2M08 WAVE_FORMAT_2M16
	WAVE_FORMAT_2S08 WAVE_FORMAT_2S16 WAVE_FORMAT_4M08 WAVE_FORMAT_4M16
	WAVE_FORMAT_4S08 WAVE_FORMAT_4S16)) {
  next if (eval "my \$a = $constname; 1");
  if ($@ =~ /^Your vendor has not defined Audio::BASSXS macro $constname/) {
    print "# pass: $@";
  } else {
    print "# fail: $@";
    $fail = 1;
  }

}

ok( $fail == 0 , 'Constants' );
#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

