BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Exporter IO::Socket::INET MIME::Base64 experimental lib strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use v5.20.0; 1}) {
    print "Perl v5.20.0 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.77.
use strict;
use warnings;
use 5.020000;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Read structured data from __DATA__",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "Data-Section-Pluggable",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.020000",
  "NAME"             => "Data::Section::Pluggable",
  "PM"               => {
    "lib/Data/Section/Pluggable.pm"                             => "\$(INST_LIB)/Data/Section/Pluggable.pm",
    "lib/Data/Section/Pluggable/Plugin/Json.pm"                 => "\$(INST_LIB)/Data/Section/Pluggable/Plugin/Json.pm",
    "lib/Data/Section/Pluggable/Plugin/Trim.pm"                 => "\$(INST_LIB)/Data/Section/Pluggable/Plugin/Trim.pm",
    "lib/Data/Section/Pluggable/Role/ContentProcessorPlugin.pm" => "\$(INST_LIB)/Data/Section/Pluggable/Role/ContentProcessorPlugin.pm"
  },
  "PREREQ_PM" => {
    "Class::Tiny"   => 0,
    "JSON::MaybeXS" => 0,
    "Path::Tiny"    => 0,
    "Ref::Util"     => 0,
    "Role::Tiny"    => "1.003001",
    "stable"        => 0,
    "true"          => 0
  },
  "TEST_REQUIRES" => {
    "Test2::V0"    => "0.000121",
    "Test::More"   => "0.98",
    "Test::Script" => 0
  },
  "VERSION" => "0.04",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Class::Tiny"   => 0,
  "JSON::MaybeXS" => 0,
  "Path::Tiny"    => 0,
  "Ref::Util"     => 0,
  "Role::Tiny"    => "1.003001",
  "Test2::V0"     => "0.000121",
  "Test::More"    => "0.98",
  "Test::Script"  => 0,
  "stable"        => 0,
  "true"          => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);