package Acme::CPANModules::Import::CPANRatings::User::stevenharyanto;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-10-29'; # DATE
our $DIST = 'Acme-CPANModules-Import-CPANRatings-User-stevenharyanto'; # DIST
our $VERSION = '0.002'; # VERSION

our $LIST = {description=>"This list is generated by scraping CPANRatings (cpanratings.perl.org) user page.",entries=>[{description=>"\n(REMOVED)\n",module=>"Log::Any",rating=>undef},{description=>"\nProvides a thin/lightweight OO interface for \$?, much like what Time::Piece does for localtime()/gmtime() or File::Stat for stat(). Of course, Real(TM) programmers shift and fiddle bits by themselves, but for the rest of us this module is a nice convenience.\n",module=>"Process::Status",rating=>10},{description=>"\nNice idea, but the API needs to richer to be more useful (otherwise one will still need to go to individual Archive::Tar, Archive::Zip, etc). Currently the API provided are: listing files and extracting all files. We can't: create archive, add more files, extract some files only, find files, and so on.\n",module=>"Archive::Any",rating=>8},{description=>"\nVery nifty, it's like Carp::Always but with much more options/features (so you don't need a separate Carp::Always::Color, Carp::Always::Dump, and so on).\n",module=>"Devel::Confess",rating=>10},{description=>"\nThe concept is truly cool, unfortunately the parser is currently flaky/buggy: one SQL query might work but another valid and seemingly simple SQL would fail with weird error message. See distribution's RT queue.\r<br>\n\n",module=>"SQL::Statement",rating=>6},{description=>"\nInstead of just printing some info, why not make it an Acme::PM or Acme::PerlMongers like Acme::CPANAuthors? Various stats can then be produced about the various Perl Mongers.\r<br>\n\n",module=>"PerlMongers::Hannover",rating=>undef},{description=>"\nNote that File::Which can also search for all matches too if you use it in a list context, e.g. \@paths = which('foo'). File::Which also comes with a pwhich CLI utility which also accepts multiple arguments and has the -a switch to print all matches. The output format is slightly different than 'multiwhich' though.\r<br><br>In fact, the Unix 'which' command (or at least its Debian variant) also sports the -a switch.\n",module=>"App::multiwhich",rating=>undef},{description=>"\nNice idea. Some notes: 1) to be widely used, it really needs to be very efficient; 2) if the goal is simply to objectify a hash, perhaps Hash::Objectify or Object::From::Hash or Hash::To::Object (or Data::Objectify and so on) is a more descriptive name.\r<br>\n\n",module=>"Object::Anon",rating=>undef},{description=>"\nThe &quot;extremely fast and efficient&quot; claim currently doesn't hold, as this module creates a *whole* flattened tree for *every* search operation.\r<br><br>A simple benchmark:\r<br><br>###\r<br>\nuse Benchmark qw(timethese);\r<br>\nuse Data::Seek;\r<br>\nuse Data::DPath qw(dpath);\r<br>\nuse JSON::Path;\r<br><br>my \$data = { map { \$_ =&gt; {map {\$_=&gt;[1..4]} 1..20} } &quot;a&quot;..&quot;z&quot; };\r<br><br>timethese(-0.25, {\r<br><br>dseek =&gt; sub { \$ds = Data::Seek-&gt;new(data=&gt;\$data); \$ds-&gt;search(&quot;j.1.\\\@&quot;)-&gt;data }, \r<br><br>dseek_cacheobj=&gt;sub{ state \$ds=Data::Seek-&gt;new(data=&gt;\$data); \$ds-&gt;search(&quot;j.1.\\\@&quot;)-&gt;data },\r<br><br>dpath=&gt;sub{ dpath(&quot;/j/1/*&quot;)-&gt;match(\$data) }, \r<br><br>jpath=&gt;sub{ JSON::Path-&gt;new(q[\$.j.1.[*]])-&gt;values(\$data) },\r<br>\n});\r<br>\n###\r<br><br>###\r<br>\nBenchmark: running dpath, dseek, dseek_cacheobj, jpath for at least 0.25 CPU seconds...\r<br><br>dpath:  1 wallclock secs ( 0.27 usr +  0.00 sys =  0.27 CPU) \@ 8292.59/s (n=2239)\r<br><br>(warning: too few iterations for a reliable count)\r<br><br>dseek:  1 wallclock secs ( 0.29 usr +  0.00 sys =  0.29 CPU) \@ 37.93/s (n=11)\r<br><br>(warning: too few iterations for a reliable count)\r<br>\ndseek_cacheobj:  0 wallclock secs ( 0.33 usr +  0.00 sys =  0.33 CPU) \@ 42.42/s (n=14)\r<br><br>(warning: too few iterations for a reliable count)\r<br><br>jpath:  0 wallclock secs ( 0.27 usr +  0.00 sys =  0.27 CPU) \@ 11711.11/s (n=3162)\r<br><br>(warning: too few iterations for a reliable count)\r<br>\n###\r<br><br>Also: 1) the syntax is rather inconsistent: ':n' for array index access, but '.\@' (instead of ':\@') for grabbing all elements. 2) currently cannot select subtree (must always select leaf node).\r<br><br>As alternatives, I recommend the much simpler JSON::Path, or the more powerful Data::DPath.\r<br>\n\n",module=>"Data::Seek",rating=>undef},{description=>"\nMy favorite 2048 implementation (it's text-mode, written in Perl, uses my module Color::ANSI::Util, and what else... oh yeah, it's the only implementation where I've reached 2048 :-) ).\r<br><br>One tip: enlarge the fonts of your terminal emulator (e.g. Ctrl-+ on Konsole) until it's big and convenient enough.\n",module=>"Games::2048",rating=>10},{description=>"\nAs an alternative, one can also do:\r<br><br>alias d='\r<br><br>TZ=UTC date; # show date in UTC\r<br><br>date       ; # show date in local timezone\r<br><br>cal -3     ; # show monthly calendar for curmon-1, curmon, curmon+1\r<br>\n'\r<br><br>\n",module=>"App::D",rating=>undef},{description=>"\nHaving worked for quite some time with option processing and several other similar modules, I have to say that most of the time you probably want to use Getopt::Long instead of the other alternatives. Or at least pick the alternatives which are based on Getopt::Long, instead of those that reinvent the wheel and do their own option parsing.\r<br><br>Most other modules that reinvent option parsing either don't bother to do short option bundling (-abc instead of -a -b -c), or abbreviation (--long-o instead --long-option-name), or the choice to (dis)allow mix-mashing options and arguments, or support '--' to end option processing, or respect ordering, or support multiple options (--verbose --verbose), or support '--foo=val' *as well as* '--foo val', and so on. These are features and conveniences that are taken for granted by people working daily in Unix command-line.\r<br>\n\n",module=>"Getopt::Long",rating=>10},{description=>"\nVery fast, several times faster than Text::TabularDisplay or Text::Table (and many times faster than the other slower table-generator modules). It uses sprintf() to format a whole row instead of formatting each cell separately using sprintf() and joining cells together with join().\r<br><br>I did a comparison in: <a href=\"http://blogs.perl.org/users/steven_haryanto/2014/07/benchmarking-several-ascii-table-generator-modules.html\" rel=\"nofollow\">blogs.perl.org/users/steven_haryanto/...</a>\n",module=>"Text::Table::Tiny",rating=>10},{description=>"\nA great alternative when Moo is a bit too much for you. Useful for scripts that must start really fast. Mind you, Moo loads about 5K lines of code and more than a dozen files, all of which takes +- 10ms on my computer. Mo on the other hand is only a single line of +-500 characters, and it's inlinable. It loads in under 1ms. If a script must be executed thousands of times a day, that 9ms difference will matter more.\r<br><br>I use this for a very lightweight parent class. A richer subclass then uses Moo.\r<br><br>Isn't it great that we have the choices and upgrade path from the very minimal Mo, to Moo for normal cases, to Moos and Moose for even richer (but heavier) alternatives. Truly TIMTOWTDI!\r<br>\n\n",module=>"Mo",rating=>10},{description=>"\nGiven that the name of this module/app is &quot;change shebang&quot; (instead of &quot;change shebang to samedir perl&quot;) perhaps this app can be made more generic? For example, I've had to change all shebangs from &quot;#!/usr/bin/env perl&quot; to &quot;#!perl&quot; and vice versa. Perhaps this module/app can become a tool to easily switch between shebangs.\r<br>\n\n",module=>"App::ChangeShebang",rating=>undef},{description=>"\nOverall looks ok, with the exception that it does not look and feel like a regular Perl hash at all. Now someone just needs to create a tie interface on top of this :)\r<br>\n\n",module=>"Hash::Ordered",rating=>undef},{description=>"\nFrom the description: &quot;App::whatthecommit is just another lazy-to-lazy line command utility.&quot; I'd thought the definition of laziness would be something like 'alias gc=git commit --allow-empty-message'. This is more like hubris. Or whatever. :)\r<br>\n\n",module=>"App::whatthecommit",rating=>undef},{description=>"\nVery nifty for short scripts and some clever design inside (all options are stored as arrayref, but there is some overloading to make getting boolean/flag and normal scalar value convenient).\r<br><br>For more &quot;proper&quot; scripts though (anything above say 20-30 lines) I'd recommend using something like Getopt::Long with a real spec. Some of the features I like in G::L not in Opt::Imistic: the ability to get --noOPT for free for flag options, the ability to configure permute/no_permute (mix mashing options with arguments), some data validation, and of course: autoabbreviation of long option names, which requires a spec after all.\n",module=>"Opt::Imistic",rating=>10},{description=>"\nThe doc looks promising, it really looks like it could be the &quot;strace for Perl functions&quot;, but the usage is awkward (you have to open two terminals, one for running your program and producing trace file, and another for reading this file). And I'm probably an idiot, but I can't get this module to work for me.\r<br><br>One alternative if you're looking for a similar module is Debug::LTrace.\r<br><br>\n",module=>"Devel::STrace",rating=>undef},{description=>"\nFor an alternative, try Debug::LTrace, which roughly provides the same basic feature but is more convenient to use from the command-line and give extra information like timing.\r<br><br>\n",module=>"Devel::TraceSubs",rating=>undef},{description=>"\nMight be powerful and flexible, but not convenient to use especially from command-line. (I was searching for something like &quot;strace for Perl function&quot;).\r<br>\n\n",module=>"Devel::TraceCalls",rating=>undef},{description=>"\nOne of the more convenient and usable subroutine tracing modules on CPAN. If you're looking for something like &quot;strace for Perl functions&quot;, try this.\r<br>\n\n",module=>"Debug::LTrace",rating=>10},{description=>"\nGood module, but try its derivative Debug::LTrace instead. Debug::Trace doesn't fake caller() yet so traced/wrapped subroutines get caller() results that are &quot;off-by-1&quot; (see Hook::LexWrap). Plus, Debug::LTrace gives more information like timing.\r<br><br>\n",module=>"Debug::Trace",rating=>undef},{description=>"\nThe name and abstract is slightly inaccurate/misleading. This module is supposed to be a general logging framework instead of just subroutine entry/exit tracer. For alternative subroutine tracer, I'd recommend Devel::TraceSubs or Devel::TraceCalls (or even Devel::Trace + variants).\r<br><br>Not very convenient to use. It still requires you to put 'if \$App::Trace' clause everytime. For general logging that can be switched on/off upon runtime, I'd recommend using Log::Any instead.\r<br><br>Lastly, this module is tied to App::Options and thus only really usable if you use both.\n",module=>"App::Trace",rating=>undef},{description=>"\nHash::Identity has a use case of convenience when embedding expression in double-quote strings. I fail to see the point of Tie::Hash::Identity though. Can't you just say:\r<br><br>'abc' eq 'abc'; # true\r<br><br>(1+2+3) eq '6'; # true\r<br>\n\n",module=>"Tie::Hash::Identity",rating=>undef},{description=>"\nAt first I thought, hey, cute trick. But then Perl already has:\r<br><br>print &quot;You could use expr like this: \${\\(2**3)}.\\n&quot;;\r<br><br>print &quot;Or you could use ident \${\\( 'a' . 'b' )} as well.\\n&quot;;\r<br><br>So you're trading a backslash and a couple of parentheses against having to depend on a non-core module and making your code reader raise her eyebrow when she first sees your code. Pick your poison :-)\r<br><br>I wonder if this belongs in Acme::\r<br><br>On the other hand and slightly off-topic, a module that can do Perl6-style interpolation (lexically) would be cool, I think:\r<br><br>\$s = &quot;perl\${\\(6-1)}-style interpolation&quot;;\r<br>\n{\r<br><br>use v6str;\r<br><br>\$s = &quot;perl{ 5+1 }-style interpolation&quot;;\r<br>\n}\r<br>\n\n",module=>"Hash::Identity",rating=>undef},{description=>"\n\@Tom Browder: If you just need unblessing, there's also another module Acme::Damn which is more minimalist. You can also create a shallow copy to unbless a reference, if you want to do it without the help of any module (Both Acme::Damn and Data::Structure::Util are XS modules, JFYI).\r<br><br>Re Data::Structure::Util: nifty module that provides speedy alternative for several things like checking for circular references, weaken them, unblessing a reference, etc. You can do many of the routines in pure Perl. This module lets you do them in C.\r<br>\n\n",module=>"Data::Structure::Util",rating=>10},{description=>"\nAn interesting tool that has been developed since 1991 (which is roughly around the time the WWW and Linux was born, whew). Kudos to the author for the dedication and consistency.\r<br><br>Since nowadays SQL is pretty much ubiquitous, users might also want to check out an alternative tool, App::fsql. For example (taking a similar example from the module's doc), to select entries in /etc/passwd where UID is between 1000 and 2000:\r<br><br>\$ ( echo -e &quot;login\\tpassword\\tuid\\tgid\\tgecos\\thome\\tshell&quot;; sed 's/:/\\t/g' /etc/passwd ) | fsql --add-tsv - 'SELECT * FROM stdin WHERE uid &gt;= 1000 AND uid &lt;= 2000' --format text --aoh\n",module=>"Fsdb",rating=>undef},{description=>"\nCool, but personally I'd rather have something like JavaScript's properties (since Perl does have lvalue subroutine support): \r<br><br>\$date-&gt;year = 2014;\r<br>\n\n",module=>"Date::Tie",rating=>undef},{description=>"\nMore effort needs to be made with regards to documentation, especially for File::Slurp users looking for alternatives. Why is this module needed? What are the differences with File::Slurp? How do the functions behave on I/O errors (since err_mode option is not supported)?\r<br>\n\n",module=>"File::Slurp::Tiny",rating=>undef},{description=>"\nThanks for providing a pure-Perl alternative for deep cloning. Otherwise we are stuck with core module Storable's dclone, which cannot handle Regexp objects out of the box, must use deparse to handle coderefs, and not to mention is not as fast as it should be because it's a marshall+unmarshall algrorithm (ab)used for deep cloning.\r<br><br>Of course, there are faster XS-based cloning modules on CPAN (all currently non-core, believe it or not there are no core modules for cloning except Storable). I'd recommend Data::Clone. But it's nice to have a pure-Perl implementation, e.g. for creating a dependency-free script using App::FatPacker.\n",module=>"Clone::PP",rating=>10},{description=>"\nThis is a well-designed module with a good interface. The core system()'s behavior of whether to invoke shell or not depending on the number of arguments is ... unfortunate. This module fixes that.\r<br><br>However, the previous review's comparing of IPC::System::Simple with IPC::Run or IPC::Simple is rather misguided. They focus on different things: IPC::System::Simple focuses on providing shell/no-shell versions of invoking commands and making a command's result easier to parse. It does not support feeding text to STDIN, handlers for STDOUT/STDERR, timeouts, or the other features that IPC::{Run,Cmd} support.\n",module=>"IPC::System::Simple",rating=>undef},{description=>"\nIPC::Cmd does its job, but the interface is inconsistent, probably because a different author wrote run_forked() (and didn't follow the same convention). run() accepts a hash of arguments, but run_forked() accepts a scalar + hashref. run() returns a list, but run_forked() returns a hashref. Command in run_forked() cannot be an arrayref, but in run() it can be.\n",module=>"IPC::Cmd",rating=>undef},{description=>"\nPlease consider a simpler non-OO interface instead, a la File::chdir:\r<br><br>use File::Umask; # or whatever, the &quot;Local&quot; thing is redundant\r<br>\n{\r<br><br>local \$UMASK = 0077;\r<br><br>open(...);\r<br><br>copy(...);\r<br>\n}\r<br>\n# previous umask is restored\r<br><br>which is arguably better (to me at least) than the current:\r<br><br>use Umask::Local;\r<br>\n{\r<br><br>my \$umask_local = Umask::Local-&gt;new(0077);\r<br><br>open(...);\r<br><br>copy(...);\r<br>\n}\r<br>\n# previous umask is restored\r<br>\n\n",module=>"Umask::Local",rating=>undef},{description=>"\nNo file locking is currently done to the PID file to avoid race condition. Look at Proc::PID::File for a more proper implementation.\r<br><br>\n",module=>"Proc::PidUtil",rating=>undef},{description=>"\nUnnecessary. Data::Dumper does have the option to sort hash keys (\$Sortkeys, look for 'sort' in 'perldoc Data::Dumper').\r<br><br>This module also does not handle circular refs yet (and probably lacks other features of Data::Dumper too).\r<br><br>Also the choice of returning error (&quot;\$Var00 = not a reference&quot; when given Dumper(1) for example) as result is arguably unwise.\r<br>\n\n",module=>"Data::Dumper::Sorted",rating=>undef},{description=>"\nI would personally pick a non-OO, no-nonsense interface based on File::Find, like:\r<br><br>use File::Find::Archive qw(find); # or find_archive\r<br>\nfind(sub { ... }, &quot;some.tar.gz&quot;);\r<br><br>instead of the multiline, tedious setup just to search a file.\r<br>\n\n",module=>"Archive::Probe",rating=>undef},{description=>"\nA nice, minimalistic, terminal-based user interface for browsing your database and tables. Might be useful for simple cases.\r<br><br>It would be *much* more useful if usernames/passwords, queries, and other settings can be saved in a config/session file.\r<br>\n\n",module=>"App::DBBrowser",rating=>undef},{description=>"\nUsers might want to check out this article on why one should perhaps use Locale::TextDomain instead of Locale::Maketext: <a href=\"http://www.perladvent.org/2013/2013-12-09.html\" rel=\"nofollow\">www.perladvent.org/2013/2013-12-09.html</a>\n",module=>"Locale::Maketext",rating=>undef},{description=>"\nNice effort, but one might also want to look at Tickit, which is not curses-based and looks more promising. Being based on Curses, this module still suffers from the many bugs and limitations of curses. The lack of Shift-Tab support, for one.\r<br><br>See also: <a href=\"http://www.perlmonks.org/?node_id=1059926\" rel=\"nofollow\">www.perlmonks.org/?node_id=1059926</a>\r<br><br>As I explore doing TUI more, I will update the reviews.\r<br>\n\n",module=>"Curses::Toolkit",rating=>undef},{description=>"\nGreat idea! I've been bitten and annoyed by strictures on more than one occasion. It has its uses, but users should have a choice on how to react to warnings.\r<br>\n\n",module=>"Moo::Lax",rating=>10},{description=>"\nThis module is based on WWW::YouTube::Download but its documentation does not yet explain how it differs from WWW::YouTube::Download. From what I see at a glance, App::YTDL supports downloading a video from a playlist and setting download speed limit, but perhaps the author should do the mode detailed explaining to help users when to choose between the two.\r<br>\n\n",module=>"App::YTDL",rating=>undef},{description=>"\nAt the current form, simply too simplistic to be an alternative to Data::Dump or Data::Dumper. No support for blessed refs, filehandle/globs, circular references, and so on. Changes numbers to stringy numbers or vice versa.\r<br><br>Currently also contains some bugs like for -1 (changes it to string), &quot;\\\\&quot; (produces invalid dump, does not handle backslash yet currently), \r<br><br>And Data::Dump's dump of {} and [] are currently more compact ;-)\r<br><br>Need to be improved significantly first. But keep up the effort.\n",module=>"Data::CompactDump",rating=>undef},{description=>"\nI personally don't mind the namespace choice. There are other single-letter CPAN modules too like B, L, U, V. If you have a beef with regard to namespace, don't single out P and perhaps downvote the other modules too.\r<br><br>Having said that, I would like to comment on the design and implementation of this module.\r<br><br>1) The choice of Unicode character U+2204 as representation of undef. Unless one does something like 'binmode STDOUT, &quot;:utf8&quot;', with 'say P undef' I am just trading one warning (&quot;Use of uninitialized value&quot;) with another (&quot;Wide character in say/print&quot;). The wide character warning is avoided if you do 'P &quot;%s&quot;, undef' though, which means...\r<br><br>2) P loads utf8 by default. For ultra-lightweight cases, this is sometimes not desirable. There is currently no way to turn this off.\r<br><br>3) The arbitrary choice of three levels deep when printing references. This can be customized but with an unusual syntax. But again, the arbitrary choice of three.\r<br><br>4) The &quot;complex&quot; rules of newline printing. p() is like puts, it can optionally add a newline. But unlike puts, the doc says it can also remove newlines. The behavior can also change if the string to be printed ends with 0x83.\r<br><br>I might use P for a sprintf/printf replacement, but for debugging values, I'd prefer something &quot;dumber&quot; like Data::Dump::Color (or Data::Printer, if that's your thing).\n",module=>"P",rating=>undef},{description=>"\nA couple of comments. First, if you want to import the default exports *as well as* some additional others, you can use Exporter's feature (the :DEFAULT tag):\r<br><br>use SomeModule qw(:DEFAULT a b c);\r<br><br>or you can also &quot;use&quot; twice:\r<br><br>use SomeModule;           # imports default exports\r<br><br>use SomeModule qw(a b c); # import a, b, c\r<br><br>Second, if you use Xporter, your module will behave unlike most CPAN modules out there, because a majority of modules use Exporter. When people see this Perl code:\r<br><br>use SomeModule qw(a b c);\r<br><br>normally they will expect only a, b, and c are exported. If SomeModule uses Xporter, it will also by default export the default exports.\r<br><br>Basically Xporter is just Exporter with a different default (not arguably better or more user-friendly). For the sake of minimizing surprise to my users, I would avoid the use of Xporter.\r<br><br>UPDATE 2014-01-24: some edits. I appreciate the effort of the author to defend her module, though I am not convinced by her arguments.\n",module=>"Xporter",rating=>undef},{description=>"\nNice tool that lets you type dzil commands like 'build', 'test', etc while sending all the other unknown commands like 'ls -l', 'man Foo' to the underlying shell. Also lets you avoid multiple startup overhead of dzil :-)\n",module=>"Dist::Zilla::Shell",rating=>10},{description=>"\nUnmaintained. Installs but no longer runs.\n",module=>"CPANPLUS::Shell::Curses",rating=>2},{description=>"\nIf you peek into its Makefile.PL, you'll see a seemingly random/heterogenous collection of modules to install (instead of just WWW::Mechanize). This is probably a Task::BeLike::\$AUTHOR in disguise.\r<br><br>\n",module=>"Task::Mechanistic",rating=>undef},{description=>"\nSo far the best of the bunch. \r<br><br>FAST: much faster than Storable, roughly the same speed as (sometimes slightly faster than) Data::Clone for cloning. \r<br><br>FEATUREFUL: Can handle circular references, Regexp objects (trips out-of-the-box Storable), JSON::{PP,XS}::Boolean objects (trips Data::Clone). \r<br><br>COMPACT: definitely more compact (up to several times) than Storable. \r<br><br>I'm sold. What more do you want? Le Storable est mort, vive le Sereal!\n",module=>"Sereal",rating=>10},{description=>"\nIf you write test functions, you need this. It's like the &quot;Test::More&quot; for &quot;Test::More&quot;. However, it currently does not work out of the box with subtests (submitted as wishlist to RT).\r<br><br>PS: Thanks to Toby Inkster for pointing this module out.\r<br><br>\n",module=>"Test::Tester",rating=>10},{description=>"\nIt's faster than Unicode::GCString-&gt;new(\$str)-&gt;columns, but it gives wrong answers to lots of characters, e.g. control characters like &quot;\\n&quot;, &quot;\\t&quot;, etc are currently assumed to have width of -1 character. You're better off with Unicode::GCString.\n",module=>"Text::CharWidth",rating=>2},{description=>"\n2010-10-13:\r<br><br>I admit, this is not the most flexible configuration framework out there as it enforces some convention. And I don't/can't use it on every project. But it's certainly one of the easiest. You can slap a few lines of options declaration in your code and voila, your script suddenly can accept command line arguments, has --help message et al, read from config files (in several preset locations).\r<br><br>There are still a few annoyances (I submitted them in the RT), but in general, this is a very handy module to use for lazy coders who just want to accept configuration/options from outside the code.\r<br><br>&lt;shameless plug&gt;I'm trying to do somewhat the same with Config::Tree, but as of now the module is not really done yet.&lt;/shameless plug&gt;\r<br><br>UPDATE 2013-08-15:\r<br><br>I'm reducing the ratings from 5 to 2. I've now avoided using this module due to two lingering issue since 2010: 1) App::Options does not accept '--opt val', only '--opt=val' which is incompatible with how most command-line programs work, causing confusion for some of my users. 2) 'perl -c' doesn't work under this module, it will still trigger command-line processing.\r<br><br>I'm now using Perinci::CmdLine as replacement, but I cannot recommend it in general, as the two modules are not equivalent.\n",module=>"App::Options",rating=>4},{description=>"\nIt's rather unfortunate that currently the choice for general purpose cross-platform filesystem notification modules on CPAN falls between this module (FNS) or File::ChangeNotify (F::CN). The other CPAN modules are either OS-/framework-specific.\r<br><br>FNS has a simple API but is perhaps too simple for some uses, while F::CN uses Moose and has a big startup overhead. \r<br><br>If you simply want to check from time to time whether a change has occured, you need to wrap the wait() method with alarm(). And I found on my Linux PC that I need a timeout of at least 3 seconds for this to work reliably.\n",module=>"Filesys::Notify::Simple",rating=>8},{description=>"\nVote +1 to add this to core. Please make coding in Perl 5 relatively painless.\n",module=>"experimental",rating=>10},{description=>"\nVery straightforward to use (I needed to send a URL/webpage as HTML email with embedded images/objects). With this module I can finish my job with only a few lines of Perl in 3-5 minutes (searching for this module in CPAN takes more than that! searching using &quot;mail web&quot; or &quot;email url&quot; at first didn't get results).\r<br><br>Blackberry is having trouble displaying the resulting email though. No problem with Gmail or Thunderbird/Icedove.\n",module=>"MIME::Lite::HTML",rating=>10},{description=>"\n5-year old bug like RT#38594 still present. Use one of the alternate implementations like Term::Size::{Unix,Win32,ReadKey}.\r<br>\n\n",module=>"Term::Size",rating=>2},{description=>"\nWhile it doesn't cover as much phrases as DateTime::Format::Natural, at least it's simpler to translate (and the dist already includes a couple of translations). BTW, I think like in the POD of DateTime::Format::Natural, it needs to list which phrases it supports. And probably add more :-)\r<br><br>\n",module=>"DateTime::Format::Flexible",rating=>8},{description=>"\nI'm giving DateTime::Format::Natural 3 stars because while it's great for English (it covers more phrases than DateTime::Format::Flexible), it's also hard to translate. Look at the source code for DateTime::Format::Natural::Lang::EN: lots of Englishisms and weird structures (%grammars). Wonder why so far there has not been any translations to another language?\r<br>\n\n",module=>"DateTime::Format::Natural",rating=>6},{description=>"\nThanks, just what I needed. (I was hoping cpanm would accept my --download patch, but this is just as well).\r<br><br>It still uses CPAN.pm and thus downloads the relatively big 01mailrc.txt.gz and 02packages.details.txt.gz file, thus slowing the first use. If you use cpanm exclusively, this is rather annoying especially if you're on a slow link.\n",module=>"App::sourcepan",rating=>8},{description=>"\nThe method of determining visual width of Chinese characters is rather hackish. Text::ASCIITable should perhaps use Text::CharWidth (which can be used to determine visual width of text in other languages e.g. Japanese, etc) thus rendering this module unnecessary.\r<br>\n\n",module=>"Text::ASCIITable::TW",rating=>undef},{description=>"\nAlso look at Text::CharWidth for an alternative that can be used with text in other languages (Chinese, etc).\r<br>\n\n",module=>"Text::VisualWidth",rating=>undef},{description=>"\nAlso look at Text::CharWidth for an alternative that can be used with text in other languages (Chinese, etc).\r<br>\n\n",module=>"Text::VisualWidth::PP",rating=>undef},{description=>"\nNice idea. Perl should really have included something like this (analogous to warnings.pm for -w).\r<br><br>However, for something as security-related as tainting, I personally think the interface is a bit too complex and not robust enough. There are too many pitfalls where one can fail to turn on tainting properly.\r<br><br>* First, user must remember to import \$TAINT, or doing '\$TAINT = 1' has no effect. There's no error/warning for this mistake.\r<br><br>* Then, if one also forgets to import taint_start or taint_start, then doing 'taint_start' or 'taint_env' (without parentheses) will do nothing. Also does not produce an error/warning except under strict mode.\r<br><br>* One must remember to 'taint_env' _after_ 'taint_start'. There's no warning/error if one does the opposite.\r<br><br>I'd rather have something like this:\r<br><br>{\r<br><br>use tainting;\r<br><br>... code is running in taint mode ...\r<br>\n}\r<br><br>use tainting;\r<br>\n{\r<br><br>no tainting;\r<br><br>... code is running without taint mode ...\r<br>\n}\r<br><br>No functions, no variables to set, no exports. Tainting of %ENV etc should be done automatically just like -T.\r<br><br>EDIT: I wrote tainting and uploaded it to CPAN as proof of concept.\n",module=>"Taint::Runtime",rating=>8},{description=>"\nReinvents Class::Autouse (written 12 years ago). But at least L is much simpler and shorter to type (the equivalent of -ML is -MClass::Autouse=:superloader).\r<br><br>BTW, there's also Module::AutoLoad, Module::AutoINC, and lib::xi which can automatically install modules from CPAN and load them upon first use. \n",module=>"L",rating=>undef},{description=>"\nPerl is not Ruby != everything Ruby does is horrible. This module has its uses.\n",module=>"UNIVERSAL::moniker",rating=>undef},{description=>"\nA wrapper around Perl's alarm()/\$SIG{ALRM}, so it has the same limitations, e.g. you cannot use this to properly timeout external programs started by system()/backtick. For the latter, you might want to try IPC::Cmd (run() or run_forked()), or some simpler interface for it like System::Timeout.\r<br><br>\n",module=>"Time::Out",rating=>undef},{description=>"\nA wrapper around Perl's alarm()/\$SIG{ALRM}, so it has the same limitations, e.g. you cannot use this to properly timeout external programs started by system()/backtick. For the latter, you might want to try IPC::Cmd (run() or run_forked()), or some simpler interface for it like System::Timeout.\r<br><br>\n",module=>"Util::Timeout",rating=>undef},{description=>"\nThis is a thin wrapper over IPC::Cmd's run(). I'd personally use run() directly, it's not much harder or longer to type. Plus, IPC::Cmd is a core module.\r<br><br>\n",module=>"System::Timeout",rating=>undef},{description=>"\nWouldn't a function like load_module(&quot;Math::Module&quot;)-&gt;new(42) be more obvious? Is there a specific goal for using custom quote operator (which requires Devel::Declare, and thus a C compiler to build)?\r<br>\n\n",module=>"Module::Quote",rating=>undef},{description=>"\nWouldn't a function like load_module(&quot;Math::Module&quot;)-&gt;new(42) be more obvious? Is there a specific goal for using a tied hash (since there is already %INC)?\n",module=>"Module::Hash",rating=>undef},{description=>"\n5-star for its documentation.\r<br>\n\n",module=>"Promises",rating=>10},{description=>"\nDoes the author care to explain the sudden influx of Lingua::&lt;3-letter-code&gt;:: modules (which look like mostly just repackaging of their corresponding Lingua::&lt;2-letter-code&gt;:: modules with no mention of purpose in the PODs)? The original modules are not orphaned either (for example, I still maintain Lingua::ID::*).\r<br><br>No Changes file. Versioning synchronized for all 3-letter modules with no indication of what version of the 2-letter-code module is used. For example, Lingua::ITA::Numbers' doc still says &quot;decimals don't work properly&quot;, while Lingua::IT::Numbers' doesn't (however, needless use of Regexp::Common does gets removed).\n",module=>"Lingua::ITA::Numbers",rating=>undef},{description=>"\n\@zaxon: I'm not sure if it's a bug with HTTP::Headers, more like a workaround for Storable. See the FAQ in the updated v0.03 for more details.\r<br>\n\n",module=>"HTTP::Headers::Patch::DontUseStorable",rating=>undef},{description=>"\nBalancing previous glowing reviews. Storable has it faults, for example historically its track record for file format backwards compatibility is poor, making programs fail when loading Storable files after the module is upgraded.\r<br><br>Also, more importantly, add builtin support for Regexp object already! It's almost 2013, Regexp object has been around for, what, more than a decade? I can understand not supporting serializing filehandle or coderef, but Regexp object?\n",module=>"Storable",rating=>2},{description=>"\nWorks for me too ATM. I've tried several command-line scripts (most of them Python-based, like youtube-dl, tubenick, etc). Sometimes they work, sometimes they broke. It's the nature of this kind of script. The quality comes from persistence. This module has been maintained since 2009, through several YouTube's changes. I commend the author, good job, and thanks!\n",module=>"WWW::YouTube::Download",rating=>10},{description=>"\nFrom the module's POD: &quot;The number zero and undef are difficult to determine in Perl.&quot;\r<br><br>Are they?\r<br><br>say !defined(\$data) ? &quot;undef&quot; : &quot;not undef&quot;;\r<br><br>say defined(\$data) &amp;&amp; \$data==0 ? &quot;zero&quot; : &quot;not zero&quot;; # yes, warn if non-numeric\r<br><br>use Scalar::Util 'looks_like_number';\r<br>\nsay looks_like_number(\$data) &amp;&amp; \$data==0 ? &quot;zero&quot; : &quot;not zero&quot;;\r<br><br>Though I understand the need for a convenient &quot;is_zero&quot; function if you need to test for zero in a program a lot.\n",module=>"Number::Zero",rating=>undef},{description=>"\nIMO, currently the only usable (read: non-crap) code syntax highlighting library on CPAN. Cons: you'll need to install GNU Source-highlight (and its development library/header) which pulls over 100MB of packages on my Debian.\r<br>\n\n",module=>"Syntax::SourceHighlight",rating=>8},{description=>"\nHighlighter engine doesn't seem updated (for example, defined-or is not yet interpreted correctly by this module but already correctly by Kate itself). Does not provide default theme (must specify all colors). Seem to be very slow (takes 1.5s for a 18K Perl .pm file while Pygments only takes 0.2s).\r<br><br>\n",module=>"Syntax::Highlight::Engine::Kate",rating=>2},{description=>"\nNo documentation. Combines formatting and syntax-highlighting, so you cannot preserve original formatting. Only outputs to HTML and no default &quot;theme&quot; (CSS) provided.\r<br>\n\n",module=>"Syntax::Highlight::JSON",rating=>2},{description=>"\nOutput looks decent. However, it currently only formats to HTML/CSS (no ANSI, LaTeX, etc). Also, it needs more languages support.\r<br>\n\n",module=>"Syntax::Highlight::Engine::Simple",rating=>6},{description=>"\nOnly targets (X)HTML (i.e. no alternative output like ANSI or LaTeX). Supposedly slow. But it doesn't matter because code no longer builds (last updated in 2005).\n",module=>"Syntax::Highlight::Universal",rating=>2},{description=>"\nOutdated (no longer updated), poor capability (even for some simple Perl code, the output is atrocious), few languages supported. A far cry from Pygments or coderay.\n",module=>"text::highlight",rating=>2},{description=>"\nGood for semantic versioning scheme like 1.2.3 vs 1.2.3alpha vs 1.2.3rc (1.2.3 should be the latest, not the alpha or rc). However, does not accept e.g. 1.0beta (at least three components are needed). Perhaps relax this requirement?\r<br><br>Also take a look at Debian::Dpkg::Version.\r<br>\n\n",module=>"SemVer",rating=>undef},{description=>"\nGood for Perl-style versioning scheme (1.2.3) but does not work as people expect for semantic versioning scheme like 1.2.3 vs 1.2.3alpha vs 1.2.3rc (1.2.3 should be the latest, not the alpha or rc). For handling the latter case, use SemVer. Also take a look at Debian::Dpkg::Version.\n",module=>"Sort::Versions",rating=>undef},{description=>"\nNice idea, though I'd probably just write a shell function for this.\r<br>\n\n",module=>"App::Countdown",rating=>8},{description=>"\nPros: handle hashes as well as arrays, handle nested and cyclic structure, plugins.\r<br><br>Cons: No cmp-like functionality (returning -1, 0, 1), slow (even slower than Array::Compare).\r<br><br>See also: Array::Compare, JSON/YAML/Storable.\r<br>\n\n",module=>"Data::Compare",rating=>6},{description=>"\nPros: has a perm() function to check whether the two arrays contain the same things but in different order (although you can simply just run sort() over the arrays first). Allow skipping some elements from comparison.\r<br><br>Cons: no cmp-like functionality (returning -1, 0, 1), slow (for equality test, you might as well compare the json_encode() result of the arrays, which is way faster), no nested comparison. No procedural interface.\r<br><br>See also: Data::Compare, JSON/YAML/Storable.\n",module=>"Array::Compare",rating=>4},{description=>"\nNo longer builds (tested on a current Debian). A pity, since drop-in replacements for WWW::Mechanize (using different backend like curl, IE, Mozilla, Chrome, etc) might be handy.\r<br><br>\n",module=>"Mozilla::Mechanize",rating=>undef},{description=>"\nThose looking for LWP drop-in replacement might want to take a look at the recently released LWP::Protocol::Net::Curl instead, which supports WWW::Mechanize.\r<br><br>\n",module=>"LWP::Curl",rating=>undef},{description=>"\nShows great promise. I personally need this for HTTPS proxy support. After testing, the module still doesn't work to login to my internet banking sites. But I'll still check in from time to time.\r<br>\n\n",module=>"LWP::Protocol::Net::Curl",rating=>10},{description=>"\nWow, just wow. Hopefully now that we can use this tool to know how big things are, we are encouraged to create leaner, faster, more efficient Perl modules.\n",module=>"Devel::SizeMe",rating=>10},{description=>"\nA reinvention of Perl testing modules (it even comes with an equivalent for 'prove' command), with probably no added features and some added quirks. (Nested) topic can already be done using Test::More's subtests. Filtering and setup/teardown can be done with Test::Class. And I am supposed to replace specific assertion functions (with specific, helpful error messages) like is(), isnt(), like(), is_deeply(), etc with just OK()?\r<br>\n\n",module=>"Oktest",rating=>4},{description=>"\nStill a bit slower than PHP's htmlspecialchars(), but in the same ballpark. An order of magnitude faster than HTML::Entities. Does not provide unescaping, but it's okay since escaping is the majority of use cases.\n",module=>"HTML::Escape",rating=>10},{description=>"\nCasual benchmarking on my PC shows that Data::Clone is up to twice faster than this.\n",module=>"Clone::Fast",rating=>6},{description=>"\nBalancing previous unhelpful review. Slowish (can't complain, PPI-based) but works and comes with a command-line utility.\r<br><br>Beware though that the command-line utility modifies file in place without backup, without warning, and without option to create backup.\r<br>\n\n",module=>"Perl::Strip",rating=>8},{description=>"\nHave failed to build for 1.5 years (reported bug RT#66958 left untouched, users need to install Module::Install first). No usage documentation.\r<br><br>\n",module=>"Perl::Squish",rating=>2},{description=>"\nNice collection of perl shortcuts. Today I forgot about the name for &quot;x!!&quot; and nicely found it in this module.\n",module=>"perlsecret",rating=>10},{description=>"\nCute idea as always, though I'd rather use comments rather than taking multiple sub calls hit.\n",module=>"PerlX::ArraySkip",rating=>undef},{description=>"\nA timesaver. Using it on a daily basis (aliased to &quot;pod&quot;). Thanks, Marcel!\n",module=>"App::perlfind",rating=>10},{description=>"\nA nice syntax addition for avoiding passing or writing a bunch of undefs. More convenient to write than using ternary operator or grep. I'm beginning to adore syntax modules like this (as long as it adds negligible overhead).\r<br><br>\n",module=>"PerlX::Maybe",rating=>10},{description=>"\nI like the concept, but do not like the overly short names mk() and rm(). Instead of mk(), how about mkdir_p() or mkpath() like in File::Path. Instead of rm(), how about rm_r() or rmtree() like in File::Path.\r<br>\n\n",module=>"File::Path::Tiny",rating=>6},{description=>"\n2011-10-04: I am now using Exporter::Lite exclusively instead of Exporter. Got bit once by Exporter when using for an OO module due to clash of assigning to \@ISA vs 'use base'. +1 for putting it into core.\r<br><br>EDIT 2012-08-08: Nowadays I revert back to Exporter most of the time because Exporter is core. To avoid \@ISA issue, one simply needs to import import() instead setting \@ISA:\r<br><br>use Exporter qw(import);\r<br>\n\n",module=>"Exporter::Lite",rating=>undef},{description=>"\nTo be fair, in my experience YAML::Syck is not &quot;much more buggy&quot; than ::XS. It even sometimes works with my YAML data while ::XS crashes. Go figure.\n",module=>"YAML::Syck",rating=>undef},{description=>"\nIMO the module should explain in the POD, in what cases using \$^X is not enough or how it is different from Probe::Perl.\r<br><br>Anyway, quoting CPAN Testers' CPAN Authors FAQ, \$^X is not enough when:\r<br>\n1) perl was executed with a relative path and the script has chdir()ed; 2) because \$^X originates in C's argv[0] (in the main() function) it is possible for the calling program to exec() in such a way that argv[0] isn't the path to the interpreter; 3) HP/UX can do weird stuff in scripts that use #!; 4) VMS. (Not clear about #4 though :) ).\n",module=>"Devel::FindPerl",rating=>undef},{description=>"\nIMO this is the best module to deal with tainting. BTW there are several other modules like Taint (only provides taint + tainted, no untaint), Untaint (only provides untaint with awkward interface, like \$v = untaint(qr/.../, \$v)), Scalar::Util (only provides tainted), Test::Taint (does not provide untaint but provides taint_deeply and test predicates), and several others.\n",module=>"Taint::Util",rating=>10},{description=>"\nI use Markdown::Pod for my module Perinci::To::POD.\r<br><br>This module does not output proper POD for many (not so) edge cases, like:\r<br><br>`&gt;` and the likes are not yet escaped, producing C&lt;&gt;&gt; when it should have been C&lt;&lt; &gt; &gt;&gt; or C&lt;E&lt;gt&gt;&gt;.\r<br><br>Ordered list numbering does not yet work, e.g. &quot;2. ...\\n3. ...\\n&quot; produces &quot;=item 1. ... =item 1. ...&quot;\r<br><br>Ordered list with item numbered other than 1 does not work (see above). This should be supported in POD because POD allows us to write the bullets/numbers for each item.\r<br><br>Inline markup is not smart enough to differentiate word_with_underscore. So &quot;foo_bar and foo_baz&quot; becomes &quot;fooI&lt;bar and foo&gt;baz&quot;.\r<br><br>Plus it segfaults sometimes (might be my perl though).\n",module=>"Markdown::Pod",rating=>4},{description=>"\nAs previous reviewer noted, this module is actually just a front-end to the author's web service. Plus license is specifically BSD (which allows this module to be included in closed source projects), this is rather ironic to me.\r<br>\n\n",module=>"Lingua::Metadata",rating=>undef},{description=>"\nSimple, no-fuss interface, recommended. As mentioned in the doc, the alternatives have some downsides: Finance::Currency::Convert::Yahoo is based on web scraping while ::XE has usage limits.\r<br>\n\n",module=>"Finance::Currency::Convert::WebserviceX",rating=>10},{description=>"\nLike Carp::Always? Want something better? Here it is.\r<br>\n\n",module=>"Carp::Always::Color",rating=>10},{description=>"\nThe DBI of caching. Stop reinventing your caching framework and just use this.\r<br><br>UPDATE 2013-01-16: unfortunately, the use of Moose reduces the usefulness of CHI for command-line scripts (0.2s/146 files/53k lines startup overhead just to initialize a File cache). So 4 stars instead of 5. Let's hope the author migrates to Moo someday.\r<br>\n\n",module=>"CHI",rating=>8},{description=>"\nCompared to several other monkey-patching modules (like Sub::Monkey or Class::Monkey) I prefer this one because the interface is simplest and the documentation is the most straightforward. Plus it can do stacked patching and unordered restore, which is cool.\r<br><br>\n",module=>"Monkey::Patch",rating=>10},{description=>"\nThis module is simple and to the point. Unfortunately, if you're a user of Log4perl or other logging framework, you'll have to switch just for a single feature (autodumping).\r<br><br>An alternative is to use Log::Any, which also features autodumping (via \$log-&gt;debugf(&quot;%s&quot;, \$complex), \$log-&gt;warnf(), and friends), while still allowing you to use Log4perl and other frameworks supported by Log::Any.\r<br><br>\n",module=>"Log::AutoDump",rating=>undef},{description=>"\nTwo nice and possibly very useful functions. But IMO the names 'mapp' and 'grepp' are two similar to 'map' and 'grep', making it prone to typos and misreading. Perhaps consider 'map2' and 'grep2'?\n",module=>"List::Pairwise",rating=>undef},{description=>"\nModule name should perhaps be Log::Log4perl::Appender::File::RoundRobin to make it clearer that the backend is File::RoundRobin.\r<br>\n\n",module=>"Log::Log4perl::Appender::File::FixedSize",rating=>undef},{description=>"\nWhy exclude Moo?\r<br><br>Also the issue with any Any::* (or Any::*) modules is that there should be a mechanism (preferably a common one) to adjust the ordering. Sometimes I prefer Moose first, for full capability or compatibility or whatever. Sometimes I prefer Mouse or Moo, for quick startup (but don't mind Moose if those are not available). This also happens to me for YAML::Any: in some cases I prefer YAML::Syck, in others YAML::XS, this depends on the data that I'm handling.\r<br>\n\n",module=>"Any::Mo",rating=>undef},{description=>"\nI personally don't see much value of this syntactic sugar since Perl already allows us to express clearly. Pick one:\r<br><br>for (\$foo) { say \$_ if defined }\r<br><br>for (grep {defined} \$foo) { say \$_ }\r<br><br>do { say \$_ if defined } for \$foo\r<br><br>say \$_ for grep {defined} \$foo\r<br><br>And save yourself from having to remember whether we should add a comma or not before &quot;wherever&quot;.\r<br>\n\n",module=>"PerlX::Perform",rating=>undef},{description=>"\nI have nothing against bundles like this, but beware that adding 'use TOBYINK::PerlX::A' will cause Perl to load 460 files and compile +- 160k lines (takes 1s on my Core i5 machine and 8s on my Atom netbook).\n",module=>"TOBYINK::PerlX::A",rating=>undef},{description=>"\nJust adding a note that this module is unmaintained (as expressed by the author) and has stopped working for some time. If you are looking for alternatives, try REST::Google (which includes REST::Google::Search::Images). The latter has been working OK for me.\n",module=>"WWW::Google::Images",rating=>undef},{description=>"\n5 stars for cute metaphor (there's also Acme::Holy by the same author, but that is just another implementation of Scalar::Util's blessed()) and for prompt support from the author.\r<br><br>I'm sure there exists a real use case to move this out of Acme::, however obscure that might be. Can't come up with any right now, all I can think of is reblessing, which can be handled with bless() from the start.\r<br><br>UPDATE 2013-09-11: I found a real use-case for it! Cleaning up data to be sent to JSON. BTW, Data::Structure::Util also has an unbless() function, but Acme::Damn is smaller and faster. Data::Structure::Util also currently doesn't build on Windows.\r<br>\n\n",module=>"Acme::Damn",rating=>10},{description=>"\n\@Justin Case: The name is unfortunate, but it's already proper (WWW:: followed by website or company name). HTTP client libraries are in LWP::. But VM:: is also an apt choice.\r<br>\n\n",module=>"WWW::Parallels::Agent",rating=>undef},{description=>"\nI don't know why Sawyer X's review is marked as unhelpful (2 out of 8), but I agree with him. This is *not* an Acme module, it's a port of a JavaScript library of the same name.\r<br>\n\n",module=>"Underscore",rating=>undef},{description=>"\nSorry to have to rate with 1 star. I don't have problem with the interface/documentation. The 1-star rating is just to warn people that the data used by this module is not up to date. And that YEARS-old bugs are not being fixed.\r<br><br>At the time of this writing, this module still uses ISO 3166-2:1998 (first edition) + the newsletters (minor updates) up to 2006. When it should be updated to ISO 3166-2:2007 (second edition) + all the newsletters. For example, this module does not report 3 newer provinces in Indonesia.\r<br><br>Sadly we live in a world where countries and subcountries change all the time.\n",module=>"Locale::Geocode",rating=>2},{description=>"\nUPDATE 2012-08-30: I am not sure if the module is now fully compliant to the new ISO 2007, but bug reports are certainly being responded and resolved now. Updating rating from 1-star to 4-star. Thanks, Kim.\r<br><br>2012-02-17: Review to version 1.47:\r<br><br>Sorry to have to rate with 1 star. I don't have problem with the interface/documentation. The 1-star rating is just to warn people that the data used by this module is not up to date. And that months-old bugs are not being fixed.\r<br><br>At the time of this writing, this module still uses ISO 3166-2:1998 (first edition) when it should be updated to ISO 3166-2:2007 (second edition) + all the newsletters (minor updates). For example, this module does not report 3 newer provinces in Indonesia.\r<br><br>Sadly we live in a world where countries and subcountries change all the time.\r<br><br>EDIT: Ok, so I was not being clear that I was not talking about my own bug report (posted at about the same time of this review). And bugs were certainly being resolved up to about 7 months ago.\r<br>\n\n",module=>"Locale::SubCountry",rating=>8},{description=>"\nA very handy utility, sort of like s/// on your nested data structure instead of just strings. One nitpick: no coderef support. I needed to replace all coderefs inside a data structure into a string, since I want to pass it to JSON encoder. None of the rmap_*() functions seem to let me get to the coderefs. (RT wishlist ticket added.)\r<br><br>UPDATE 2011-12-30: The author (Brad) quickly responded to my RT ticket and added rmap_code. Upgrading from 4- to 5-star :) Regexp support is not there yet though, and I have suggested the ability to get all kinds of Perl-specific and weird objects, because one of the main uses of Data::Rmap for me is to &quot;clean&quot; a data structure to pass to non-Perl systems.\r<br>\n\n",module=>"Data::Rmap",rating=>10},{description=>"\nThe abstract for this module is a bit strange. What does this have to do with 'test fixtures'? Also the documentation doesn't say much, e.g. What will happen if a hash key contains funny characters (or arrays, etc)?\r<br><br>A similar module in spirit is Data::Hive. I think &quot;providing convenient chained method access to hierarchical data&quot; should be refactored out. So perhaps Data::Properties::{JSON,YAML,...} should just be a convenient shortcut for {JSON,YAML,...} parser + Data::Hive.\n",module=>"Data::Properties::JSON",rating=>undef},{description=>"\nI discourage module authors from exporting like this because it's simply too impolite/intrusive for module users. If the module author is lazy, there is already Exporter::NoWork which offers a few options for module users. This module, on the other hand, gives no control at all for users (so they'll have to resort to 'use Module ();').\r<br><br>Let me remind all again by quoting from Exporter's POD: &quot;Do *not* export anything else by default without a good reason! Exports pollute the namespace of the module user.&quot;\n",module=>"Exporter::Auto",rating=>undef},{description=>"\nInterface to web services should be put under WWW::*, not Net::*\n",module=>"Net::Douban",rating=>undef},{description=>"\nShould probably be put under Test::*?\n",module=>"HTML::Form::XSS",rating=>undef},{description=>"\nWhen I saw the perlmonks thread yesterday, I thought &quot;well, someone should package it and put it on CPAN&quot;. And then someone did :) Thanks.\r<br>\n\n",module=>"Thread::IID",rating=>undef},{description=>"\nThis is just a reimplementation of Test::More. But I thank the author for writing a short description of why this module is written, how it is different from others, and suggestion of what modules users should use. There are a lot of wheels being reinvented on CPAN, and that's okay, I just wish more people would document the reason.\n",module=>"Test::Lite",rating=>undef},{description=>"\nSince the first release, there are 13 subsequent releases in total. What are the changes between releases? No idea, the author doesn't bother to update Changes (and no public repo is listed). Apparently all his other modules are also like this. Not very user-friendly.\r<br><br>UPDATE 2011-11-22: I see that this has been rectified by the author, there is now Changes entry for each new release. Cool, thanks.\r<br>\n\n",module=>"Sub::Mage",rating=>undef},{description=>"\nDocumentation is placed in README.md, so it's inaccessible from perldoc et al. Why? This is not a Python library.\n",module=>"relative_lib",rating=>undef},{description=>"\nJust found out about it, despite having used CPAN::Mini for over a year. Helps *a lot*. More people should know this (e.g. mention from CPAN::Mini POD).\n",module=>"CPAN::Mini::Webserver",rating=>10},{description=>"\nI don't use this module since I'm not on Windows. But why another module? File::Which also handles Win32 (probably not the &quot;the current directory is explored before PATH&quot; thing, but you should consider submitting a patch).\r<br><br>At least the documentation should state why this module is necessary. It complicates scripts by having to select between two 'which' implementations.\n",module=>"Win32::App::which",rating=>undef},{description=>"\nI knew CPAN wouldn't let me down. Now I can discard my own OS/platform detecting code (which probably is buggier and not nearly as extensive) and rely on Devel::Platform::Info instead.\r<br><br>Devel::Platform::Info gives information not only about the OS but also architecture, kernel type &amp; version, etc. In my case I need to detect distro name, its version, and its codename. All of those are provided.\r<br><br>This module is so new though (started in 2010) so I wonder whether this need has never come up before.\r<br>\n\n",module=>"Devel::Platform::Info",rating=>10},{description=>"\nLess boilerplate please!\n",module=>"Package::Builder",rating=>2},{description=>"\nAfter comparing against File::MMagic, File::MMagic::XS, File::Type, I ended up choosing File::LibMagic because it has the least problems and looks like being the most maintained (although it would be nice if the author cleans up the RT queue).\r<br><br>For those stuck without a C compiler, File::Type or File::Magic can be an alternative.\n",module=>"File::LibMagic",rating=>8},{description=>"\nLast time I checked, still can't parse system magic database, e.g. /usr/share/file/magic (bug first filed in RT 4 years ago).\r<br><br>The currently recommended module in this area seems to be File::LibMagic. Other alternatives include File::MMagic (slow and buggy, no longer maintained), Media::Type::Simple (only maps MIME type from/to file extension).\n",module=>"File::MMagic::XS",rating=>4},{description=>"\nWorks for basic usage, but has quite a few problems. Plus it is not very performant. Doesn't seem to be maintained anymore.\r<br><br>The currently recommended module in this area seems to be File::LibMagic. Other alternatives include File::Type (gives less useful results), File::MMagic::XS (also not actively maintained? long standing bugs like failure to parse system magic file still persists), Media::Type::Simple (only maps MIME type from/to file extension).\r<br>\n\n",module=>"File::MMagic",rating=>4},{description=>"\nAs another reviewer has said, this module tends to conclude &quot;application/octet-stream&quot; for many kinds of files, making it not very useful.\r<br><br>The currently recommended module in this area seems to be File::LibMagic. Other alternatives include File::MMagic (slow, has quite a few bugs, no longer maintained), File::MMagic::XS (also not actively maintained? long standing bug like failure to parse system magic file still persists), Media::Type::Simple (only maps MIME type from/to file extension).\r<br>\n\n",module=>"File::Type",rating=>2},{description=>"\nBalancing previous 1 rating by \@Ingo.\r<br><br>To Ingo: You said module's documentation is okay, one feature you use works okay, and other features you don't use. Why only 1 star then?\r<br><br>This module is a worthy alternative to Test::MockTime. It offers extra features such as working across forks, mocking Time::HiRes (eventually), and speeding/slowing down time.\n",module=>"Time::Mock",rating=>10},{description=>"\nRelease early, release often indeed. First you release nothing but boilerplate :)\n",module=>"Sakai::Stats",rating=>2},{description=>"\nGood documentation. All modules' documentation should similarly strive to contain at least: rationale for existence, pointer to alternatives, and task-oriented organization.\n",module=>"Spreadsheet::Perl",rating=>undef},{description=>"\nLess-than-descriptive name (module's main function seems to be sorting entries, can't be guessed from the name). No unit tests. Doesn't handle /etc/shadow. Also, it might be useful to explain why one needs to sort entries in passwd file.\r<br>\n\n",module=>"Unix::PasswdFileOps",rating=>4},{description=>"\nYes, simple and gets the job done. Though I'm a bit curious with the implementation. If the interface is only to get number of deleted and added items (instead of positions of deletion/insertion), why depend on Algorithm::Diff (or use the name 'diff', for that matter).\r<br>\n\n",module=>"Array::Diff",rating=>10},{description=>"\nWhy do we need this uploaded to CPAN?\n",module=>"DZ1",rating=>2},{description=>"\nNo tests. No detailed error status, only true/false (yes, there is a 'warnings' parameter on constructor, but this doesn't give out warnings on all operations, only some). No locking (although there is backup, but still).\r<br><br>Also, some weird choices, why use bzip2 when creating backup? Or, why still require running as root (checking \$() if we are allowing custom database file location?\r<br><br>Between this and Unix::ConfigFile, I'm seriously considering using Unix commands instead (useradd, userdel, gpasswd, et al).\r<br><br>UPDATE 2011-04-21: I created a fork of Passwd::Unix 0.52 called Passwd::Unix::Alt instead, which add some tests and modifications. Try it out if your needs are also not met by Passwd::Unix.\r<br><br>UPDATE 2012-08-30: I created a new module called Unix::Passwd::File. Try it out if your needs are also not met by Passwd::Unix.\n",module=>"Passwd::Unix",rating=>2},{description=>"\nOutdated module that doesn't handle /etc/shadow and /etc/gshadow.\n",module=>"Unix::ConfigFile",rating=>2},{description=>"\nHandy module for installing dependencies. There are previous efforts, but the arrival of cpanm makes autoinstall process less tedious, so hats off also to the creator of cpanm.\r<br>\n\n",module=>"lib::xi",rating=>10},{description=>"\nIndispensable. Provides nice enhancement to Capture::Tiny (particularly the real-time teeing).\r<br>\n\n",module=>"Capture::Tiny::Extended",rating=>10},{description=>"\nImproperly packaged, improper POD formatting, bot messages hardcoded in script, and yes... idiotic license. Basically a &quot;trial&quot; script to bait users into consultation gig. CPAN is not a place for this kind of thing. Please try again.\r<br>\n\n",module=>"google_talk_bot",rating=>2},{description=>"\nUsing Clone::Any nowadays is more trouble than it's worth.\r<br><br>First, there are annoying incompatibilities between cloning modules. Most notably Storable, which is the default cloning module if Clone is not available, *still* doesn't support storing Regexp objects out-of-the-box after all these years.\r<br><br>Second, this module has not been updated for a long time and newer alternatives like the fast Data::Clone is not recognized.\r<br><br>Right now I'm replacing all code from using Clone::Any code to Data::Clone.\r<br><br>\n",module=>"Clone::Any",rating=>4},{description=>"\nFun module to play with, especially for those among us infected with a bit of PHP envy (me, never!).\r<br>\n\n",module=>"Array::OrdHash",rating=>10},{description=>"\nClean code, plugin interface simple to use, but implementation needs to be improved. For example, parsing \$ENV{COMP_LINE} &amp; \$ENV{COMP_POINT} into \@argv is done simplistically using split(/\\h+/), without regard to shell's quotes/escapes. (Getopt::Complete's way is somewhat better by invoking shell, but it also has its problems. I guess in this regard external programs are second-class citizens to shell functions because they don't get the equivalents of COMP_WORDS/COMP_CWORD). \r<br>\n\n",module=>"Bash::Completion",rating=>6},{description=>"\nCool, except that with cpanm I often install local distribution (cpanm Foo-Bar-1.23.tar.gz). Perhaps the completion can look in the filesystem first before firing API request. Also, might be nice if there is some caching because it seems to be slow (at least from where I am).\r<br>\n\n",module=>"Bash::Completion::Plugins::cpanm",rating=>8},{description=>"\nWith all due respect to the author, Switch is no longer necessary in 5.10+ as 5.10+ already introduced smart matching and given(). given() is superior because it doesn't introduce compile-time overhead, doesn't mess line numbers, and should be faster (simply because smart match is fast, and Switch is not utilizing it).\r<br><br>You have been using 5.10+, right? (Since 5.8 is no longer officially supported)\r<br>\n\n",module=>"Switch",rating=>undef},{description=>"\nLast week I ported an application from Mouse (Any::Moose) to Moo. Went without a hitch (well I did replace &quot;with 'X', 'Y', 'Z';&quot; to &quot;with 'X'; with 'Y'; with 'Z';&quot; as instructed in the Moo documentation). Startup time decreased significantly. Planning to move every Moose apps to Moo. Splendid!\r<br>\n\n",module=>"Moo",rating=>10},{description=>"\nCool idea, if a bit extreme.\r<br><br>If computing a value is expensive, there's Memoize for the caller. On the callee side, you can cache the result (there's state variable in 5.10+ so it's dead simple to use).\r<br><br>So I believe Sub::StopCalls is only necessary if you find the overhead of the sub call itself to be a bottleneck. And if that is the case, perhaps you should refactor the calling code anyway.\n",module=>"Sub::StopCalls",rating=>8},{description=>"\n5 stars solely for the idea (I'm beginning to love the ::Tiny movement more and more these days). Haven't actually tried it though, but I bet many Log4perl users, me included, mostly only use easy_init. As much as Log4perl is mature and fairly optimized, it's still a relatively &quot;huge&quot; library. Nice to know there's a drop-in ::Tiny replacement.\n",module=>"Log::Log4perl::Tiny",rating=>10},{description=>"\nRe: Blue. I guess I shouldn't release this. I need something quick to fix our application, so this is not really something meant for public use. Will be purging this from PAUSE.\r<br>\n\n",module=>"SHARYANTO::YAML::Any",rating=>undef},{description=>"\nIIRC, there has also previous similar attempt like this. Modules like these are not necessary, as DBI already has something equivalent (and even better): selectrow_{array,hashref,arrayref} and selectall_{array,hash}ref.\r<br>\n\n",module=>"SQL::Easy",rating=>2},{description=>"\nCool, will definitely try this out the next time I write another form processing CGI script. Although the module is named CGI::, there's nothing CGI-specific about it, and that's good. So this module is basically a &quot;path-expander&quot; for hash values.\r<br><br>Btw, one thing I use rather often in PHP is naming parameter as &quot;foo[]&quot; which will automatically add elements to the \$_REQUEST['foo'] array. Perhaps this feature can be considered too.\n",module=>"CGI::Struct",rating=>10},{description=>"\nJust tried it. It works, but the module/dist is not in the best shape:\r<br><br>* Test fails (pod-coverage, error in POD)\r<br><br>* dependency on Class::MethodMaker not yet specified\r<br><br>* Documentation: Synopsis contains mistake (class name is DateTime::BusinessHours not BusinessHours), the name '\$testing' is not very suitable, there are typos.\r<br><br>* Style-wise, method naming is &quot;joinedwords&quot;, while in DateTime families it's &quot;separated_words&quot; (not a big deal though).\r<br><br>\n",module=>"DateTime::BusinessHours",rating=>6},{description=>"\nEvery once in a while everyone of us encounters a programmer that disregards existing reusable code and creates his/her own &quot;standard library&quot; for everything, from trimming string to creating random number to cleaning the kitchen sink. We all might have been one too, at one time or another. I'm not saying that this bundle is a case of the above, but it's giving me a similar feeling. :-)\r<br><br>A commendable effort, David. But there really are a lot of wheels being reinvented here.\n",module=>"Bundle::Dpchrist",rating=>undef},{description=>"\nI mass download stuffs by putting a bunch of torrent files in a directory on the server and let rtorrent takes care of them. With this module I can quickly whip up a short script to calculate the total size of the downloadable files so I can be pretty sure that when I leave my server for days/weeks, I don't run out of disk space because I put in too many torrent files.\r<br>\n\n",module=>"Net::BitTorrent::File",rating=>10},{description=>"\nWow, I was thinking the same exact &quot;godsend&quot; too and turns out some other reviewer already said so. Very very helpful to assist deployment and pick modules to use. I personally made a couple of command-line scripts like pm-in-core or core-since-when to save some typing.\r<br>\n\n",module=>"Module::CoreList",rating=>10},{description=>"\nWWW::Mechanize is of course one of the indispensable tools for any web programmer or admin. The current problem is the proliferation of 3rd party subclasses, the functionalities of which cannot be used together. So you want a polite Mechanize which does self-rate-limiting and uses the Firefox or IE engine? A subclass exists for each feature, but how do you use them together? WWW::Mechanize needs to be more role/plugin-oriented instead of inheritance-oriented.\r<br>\n\n",module=>"WWW::Mechanize",rating=>10},{description=>"\nI used Mail::Sendmail and a few others &quot;older&quot; modules back from the days when it didn't support setting envelope sender different from RFC From, and when the test hung on some dead host.\r<br><br>If it's still working for you, great. I personally have moved on to other modules like Email::Sender::Simple, which abstracts sending mechanism (transport) and support SMTP auth, for two. Also, many of the guide/documentation for Mail::Sendmail are not quite up to date in style (though they still might work), for example the low level way of building HTML email. Also, the Changelog file doesn't seem to be maintained?\n",module=>"Mail::Sendmail",rating=>6},{description=>"\nI started using autodie in almost all of my applications a few months ago. It's somewhat of a mixed blessing. For existing applications, it can break things and making things less robust, solely because old code are not built with autodie in mind.\r<br><br>But the best thing about it is that it's lexically scoped, so for sections of code that you're not sure about, just sprinkle 'no autodie' to get the old behaviour.\r<br><br>It should be used on probably 95% of code out there. For the rest of the cases, where you need to report the status of each I/O operation, it's obviously more convenient to check \$? instead of trapping exception everytime.\r<br><br>+1 for getting it into core.\r<br>\n\n",module=>"autodie",rating=>10},{description=>"\nDisclaimer: I maintain a &quot;competitor&quot; module, App::perlmv. Apparently a lot of people, like me, likes to rename files using Perl. And the examples in the documentation are about renaming movie files too, something which I do a lot :)\r<br><br>I applaud Stirling Westrup for taking a legacy script and improving it. May we have a lot of ideas to borrow from each other.\r<br><br>This is an early release, there are quite a few things I find lacking. Most importantly, I suggest adding a test suite as soon as possible. The filesystem differences can be tricky, and CPAN Testers can help providing feedback.\r<br><br>Keep up the good work.\n",module=>"App::FileTools::BulkRename",rating=>8},{description=>"\nNice idea, straight and simple interface. A better name could perhaps be chosen? Documentation should be expanded, e.g. to warn users about security, since Data::Dumper a.k.a. eval() is used to load variable content. Also, the implementation does not yet consider file locking.\n",module=>"Script::State",rating=>10},{description=>"\nI guess File::Spec's API is sane enough, but I suspect not a lot of people are using it because there's not enough incentive for it. When 99% population of the world use Unix/Linux/Windows (even Macs been technically Unix for a number of years), &quot;/&quot; works everywhere and using File::Spec does not gain you anything except lots of typing exercise.\r<br><br>That's why I think Path::Class might have a better chance of succeeding. It gives niceties like a few more convenience methods, a shortcut of getting dir &amp; file object from each other, etc. It gives users more incentive of using a proper path manipulation library because it gives extra stuff along with that. It should also be in core to accompany File::Spec.\n",module=>"PathTools",rating=>8},{description=>"\nI've been using File::Slurp for years and is generally satisfied with it. However reading the negative reviews today and looking at its RT queue, I realize that this module is broken for many and is effectively abandoned by the maintainer (no new releases for almost 3 years now despite several RT items labeled as critical). So I suggest others checking out the alternatives.\n",module=>"File::Slurp",rating=>2},{description=>"\nIt's a very mature and an excellent logging framework. However, some of the common minor complaints are: 1) It's too complex. I agree: it should not be this hard to get started. 2) Configuration is too verbose. Agreed: but well, what can you do, most things from Java is a bit overengineered and verbose anyway. At least you can do almost anything with the configuration. 3) It's not very Perlish. Also agreed. 4) Performance. My note: speed is not an issue in majority of the cases and Log4perl's performance is adequate for most of the rest of the cases. For faster/leaner alternatives you might want to take a look at Log::Fast, but a lot of Log4perl's features are missing.\r<br><br>One of the main strengths of Log4perl is its sublogger/subcategory feature, which few other frameworks seem to have.\r<br><br>For other alternatives, also take a look at: Log::Handler, Log::Any. And of course Log::Message too.\r<br>\n\n",module=>"Log::Log4perl",rating=>10},{description=>"\nThis review mostly compares Log::Handler with Log4perl, which is a mature and one of the most popular logging frameworks.\r<br><br>I think Log::Handler's interface is much simpler, nicer, more Perlish than Log4perl. It's a bit similar to Log::Any::App, which I created just because I hate Log4perl configuration.\r<br><br>There is a unique concept of maxlevel not normally found in other frameworks, though it can be emulated in other frameworks using filters.\r<br><br>At a quick glance, the speed is around twice that of Log::Log4perl, so I'll say it's on the low-end side (there are other much faster logging modules, but anyway speed is not an issue to most people).\r<br><br>It currently lacks sublogger (hierarchical categorization and adjustable/automatic appending of subcategory to its parent), so it cannot be used to replace Log4perl in most cases as that's one of the main feature of Log4perl. Which is a pity because I would otherwise switch.\n",module=>"Log::Handler",rating=>8},{description=>"\nThis logging framework is also minimalistic: no categories/hierarchiecal loggers, no custom levels, no config file, or other whistles and bells. And the interface &amp; default levels are rather syslog-oriented. But it's fast alright. The POD doesn't mention a comparison to Log::Log4perl, but a casual benchmark shows that it's at least 10x faster.\r<br><br>So this module will certainly come handy if you have a performance critical application.\r<br><br>Btw, note that the benchmarks are done for actual logging to output. For log statements that do not actually get logged (e.g. because the level is below the desired output level), I don't find that extreme  differences in overhead between logging frameworks. For example, on my Athlon64 X2 5600+ PC, Log::Fast's overhead is roughly around 3mils/sec, while Log::Log4perl is around 1,5mils/sec.\n",module=>"Log::Fast",rating=>10},{description=>"\nLog::Minimal's slogan is &quot;minimal but customizable&quot;. It's minimal alright, probably only suitable for simple scripts as the moment you organize your application/library into separate modules, you'll want/need categories instead of just level, which is not provided by Log::Minimal.\r<br><br>Also, only formats is customizable, there is currently no way to customize level. And the levels are &quot;not standard&quot; (not that there is an official authoritative standard, but the popular convention is TRACE/DEBUG/INFO/WARN/ERROR/FATAL and NONE). Log::Minimal's levels are \r<br>\nDEBUG/INFO/WARN/CRITICAL and NONE). Surely most people would expect another level between WARN and CRITICAL, for non-critical errors? But that is actually just a matter of taste.\r<br>\n\n",module=>"Log::Minimal",rating=>4},{description=>"\nLog::Fine is touted as a framework for those who &quot;need a fine-grained logging mechanism in their program(s)&quot;. But apart from the emphasis on custom levels, to me there is nothing extra fine-grained about it. The other thing it provides is categories/namespace, which is also supported by a lot of other frameworks. So I fail to see the benefit/uniqueness of Log::Fine.\r<br><br>Btw regarding custom levels, this practice is long deprecated by log4j (and thus also by Log4perl, although Log4perl can do custom levels). I can understand this decision as I sometimes already have trouble managing the popular convention of 6 levels (FATAL/ERROR/WARN/INFO/DEBUG/TRACE) as it is, much less with custom levels!\n",module=>"Log::Fine",rating=>6},{description=>"\nThis module has been developed for more than a decade and seen different maintainers over the years. The codebase is indeed showing these, with different capitalization and indentation styles, among other things.\r<br><br>However, among more than a dozen or so of INI modules in CPAN, ironically there seems to be few other choices if you go beyond the most basic feature set. Some INI modules can only simplistically rewrite/dump the whole INI structure and thus lose comments/orders, while others can't even write INI files.\r<br><br>Config::IniFiles by far offers the most options and features, like dealing with line continuation, case sensitivity, default section, multiline/array, deltas, etc. So for now, despite all of its quirks, this module is still hard to beat.\r<br><br>There's another nice little INI module that can do read/set/delete/unset (instead of just read/dump): Prima::IniFile, but it is included in a totally unrelated distribution.\n",module=>"Config::IniFiles",rating=>8},{description=>"\nAmidst all the glowing reviews may I add a reminder that, as with everything, there's a catch: runtime performance. On my PC, the speed of creating a DateTime object is just around 6000/sec. If you use DateTime intensively, it can quickly add up.\r<br><br>Imagine serving a web page that fetches 50 rows from database, where for convenience you convert each date column to a DateTime object, and you have 120 requests/sec coming in... That's already 6000 objects (an extra second!).\r<br><br>Which is unfortunate because DateTime is so wonderful, convenient, correct, complete and all that. So one approach you can use might be to delay converting to DateTime object until necessary.\n",module=>"DateTime",rating=>undef},{description=>"\nWow, there are surely a lot of negative reviews ...\r<br><br>First of all, Date::Manip has a long history. I used this module back in 2001-2002, IIRC. Back then it was *the* swiss army of date/time manipulation, something you use when you want the most flexible/complete thing in Perl. True, it's slow, but it works.\r<br><br>But then things change. DateTime project was started, and now it is somewhat the de facto standard. It's more modern and far more modular than the monolithic Date::Manip (every timezone and language support and parsing/formatting modules shipped in one single distribution).\r<br><br>And then there's the 5.x -&gt; 6.x debacle. As someone who also sprinkle Perl 5.10 requirements to his CPAN modules, I can feel for the author. But the difference is, most of my modules are not that widely used/known, and also many start its life already requiring 5.10 right from its first released version. While in Date::Manip's case, this happens to a very widely used module. Surely backwards compatibility should be considered more.\r<br><br>All in all, you are free to use or not use Date::Manip. There are other alternatives. Pick wisely.\r<br>\n\n",module=>"Date::Manip",rating=>6},{description=>"\nOne would wonder why CPAN clients still don't have this crucial feature Though you see Miyagawa listed in the Credits so maybe cpanminus or its sister will end up having this functionality? One can only hope. At 0.06, some things are not working flawlessly (submitted in RT). Keep up the good work!\r<br><br>\n",module=>"App::pmuninstall",rating=>10},{description=>"\nI guess this app is still useful, since &quot;cp -sR&quot; still doesn't work as many would expect, and there are Windows users out there (yes, newer NTFS does support symlinks; though I don't know whether this module supports creating symlinks on NTFS).\r<br><br>A minor comment would be on the name, maybe lnstree can be considered instead (since &quot;ln&quot; indicates hardlink, at least for me). Btw, there's also a free software called &quot;lns&quot; to do the exact same thing.\r<br><br>\n",module=>"App::lntree",rating=>10},{description=>"\nI've never encountered difficulty in cloning data structures in Perl, usually I just use Clone or sometimes Storable's freeze + thaw (the later does not yet support cloning Regexp objects out of the box).\r<br><br>However, I like Data::Clone for its speed! It's several times faster than Clone or freeze+thaw. So hats up. Planning to use Data::Clone in future projects.\r<br><br>Now if we can convince Goro to write a fast serializer/deserializer with compact output (essentially, a faster version of Storable), that would be even nicer :-)\r<br><br>\n",module=>"Data::Clone",rating=>10},{description=>"\nWith due respect to the author, I fail to see the practical point of Pond. Pond (Perl-based open notation for data) is the Perl counterpart of JSON, except that implementation is currently only available in Perl (CMIIW), and &quot;Pond represents fewer data types directly&quot;.\r<br><br>Pond is pitched against Data::Dumper + eval, which is dangerous, but Data::Dumper + eval is by far not the only method available for serialization. Perl can do Storable, JSON, YAML, even PHP serialization format.\r<br><br>The documentation does not show what Pond looks like.\r<br><br>One cute thing about Pond is that you can check Pond syntax using a single regex. But apart from that, there's nothing compelling in using Pond to serialize data.\n",module=>"Data::Pond",rating=>4},{description=>"\nYou can always count on CPAN to have prewritten modules for various things, including this one. I've never bothered before about portability and just rely on the &quot;which&quot; command, but for one reason there's a time when I just couldn't do that.\r<br><br>Btw, there's also File::Which::Cached.\n",module=>"File::Which",rating=>10},{description=>"\nI admit it. Ever since I know about escapeshellarg() and escapeshellcmd() in PHP, I've been reimplementing this function in Perl  literally a million of times (mostly because of laziness and because it only takes a couple of lines in Perl). Only a few months ago after the millionth time I said enough is enough and started to look around in CPAN, and found this module.\r<br><br>The only problem for this module is lack of visibility. Before I've never read articles or blog posts mentioning this module, ever. Yes, we have system() that can bypass the shell, but qx() can't. So yes, this module needs to be marketed more!\r<br>\n\n",module=>"String::ShellQuote",rating=>10},{description=>"\nAnother very handy little module that takes the hassle out of figuring the various mechanisms of capturing output.\r<br><br>Nice interface, great documentation, very easy to use. But....\r<br><br>Currently it cannot just capture stdout *ONLY* or stderr *ONLY* (while leaving the other alone). I believe this is one of the most commonly requested feature (already in RT). If that feature is implemented, this module deservers a 7-star rating.\n",module=>"Capture::Tiny",rating=>8},{description=>"\nThis is a handy little module, with a simple and nice interface. One of the more common bugs encountered in my scripts is forgetting to track the current working directory after doing chdir() in subroutines. By localizing \$CWD, I don't have to worry that subroutines mess up current working directory anymore.\n",module=>"File::chdir",rating=>10}],summary=>"List of modules mentioned by CPANRatings user stevenharyanto"};

1;
# ABSTRACT: List of modules mentioned by CPANRatings user stevenharyanto

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANModules::Import::CPANRatings::User::stevenharyanto - List of modules mentioned by CPANRatings user stevenharyanto

=head1 VERSION

This document describes version 0.002 of Acme::CPANModules::Import::CPANRatings::User::stevenharyanto (from Perl distribution Acme-CPANModules-Import-CPANRatings-User-stevenharyanto), released on 2023-10-29.

=head1 DESCRIPTION

This list is generated by scraping CPANRatings (cpanratings.perl.org) user page.

This list is generated by scraping CPANRatings (cpanratings.perl.org) user page.

=head1 ACME::CPANMODULES ENTRIES

=over

=item L<Log::Any>

Author: L<PREACTION|https://metacpan.org/author/PREACTION>

(REMOVED)


=item L<Process::Status>

Author: L<RJBS|https://metacpan.org/author/RJBS>

Provides a thin/lightweight OO interface for $?, much like what Time::Piece does for localtime()/gmtime() or File::Stat for stat(). Of course, Real(TM) programmers shift and fiddle bits by themselves, but for the rest of us this module is a nice convenience.


=item L<Archive::Any>

Author: L<OALDERS|https://metacpan.org/author/OALDERS>

Nice idea, but the API needs to richer to be more useful (otherwise one will still need to go to individual Archive::Tar, Archive::Zip, etc). Currently the API provided are: listing files and extracting all files. We can't: create archive, add more files, extract some files only, find files, and so on.


Rating: 8/10

=item L<Devel::Confess>

Author: L<HAARG|https://metacpan.org/author/HAARG>

Very nifty, it's like Carp::Always but with much more options/features (so you don't need a separate Carp::Always::Color, Carp::Always::Dump, and so on).


=item L<SQL::Statement>

Author: L<REHSACK|https://metacpan.org/author/REHSACK>

The concept is truly cool, unfortunately the parser is currently flaky/buggy: one SQL query might work but another valid and seemingly simple SQL would fail with weird error message. See distribution's RT queue.
<br>


Rating: 6/10

=item L<PerlMongers::Hannover>

Author: L<PTC|https://metacpan.org/author/PTC>

Instead of just printing some info, why not make it an Acme::PM or Acme::PerlMongers like Acme::CPANAuthors? Various stats can then be produced about the various Perl Mongers.
<br>


=item L<App::multiwhich>

Note that File::Which can also search for all matches too if you use it in a list context, e.g. @paths = which('foo'). File::Which also comes with a pwhich CLI utility which also accepts multiple arguments and has the -a switch to print all matches. The output format is slightly different than 'multiwhich' though.
<br><br>In fact, the Unix 'which' command (or at least its Debian variant) also sports the -a switch.


=item L<Object::Anon>

Author: L<ROBN|https://metacpan.org/author/ROBN>

Nice idea. Some notes: 1) to be widely used, it really needs to be very efficient; 2) if the goal is simply to objectify a hash, perhaps Hash::Objectify or Object::From::Hash or Hash::To::Object (or Data::Objectify and so on) is a more descriptive name.
<br>


=item L<Data::Seek>

The &quot;extremely fast and efficient&quot; claim currently doesn't hold, as this module creates a I<whole> flattened tree for I<every> search operation.
<br><br>A simple benchmark:
<br><br>###
<br>
use Benchmark qw(timethese);
<br>
use Data::Seek;
<br>
use Data::DPath qw(dpath);
<br>
use JSON::Path;
<br><br>my $data = { map { $_ =&gt; {map {$I<< =&gt;[1..4]} 1..20} } &quot;a&quot;..&quot;z&quot; };
<br><br>timethese(-0.25, {
<br><br>dseek =&gt; sub { $ds = Data::Seek-&gt;new(data=&gt;$data); $ds-&gt;search(&quot;j.1.\@&quot;)-&gt;data }, 
<br><br>dseek >>cacheobj=&gt;sub{ state $ds=Data::Seek-&gt;new(data=&gt;$data); $ds-&gt;search(&quot;j.1.\@&quot;)-&gt;data },
<br><br>dpath=&gt;sub{ dpath(&quot;/j/1/I<< &quot;)-&gt;match($data) }, 
<br><br>jpath=&gt;sub{ JSON::Path-&gt;new(q[$.j.1.[ >>]])-&gt;values($data) },
<br>
});
<br>
=head2 #

<br><br>###
<br>
Benchmark: running dpath, dseek, dseek_cacheobj, jpath for at least 0.25 CPU seconds...
<br><br>dpath:  1 wallclock secs ( 0.27 usr +  0.00 sys =  0.27 CPU) @ 8292.59/s (n=2239)
<br><br>(warning: too few iterations for a reliable count)
<br><br>dseek:  1 wallclock secs ( 0.29 usr +  0.00 sys =  0.29 CPU) @ 37.93/s (n=11)
<br><br>(warning: too few iterations for a reliable count)
<br>
dseek_cacheobj:  0 wallclock secs ( 0.33 usr +  0.00 sys =  0.33 CPU) @ 42.42/s (n=14)
<br><br>(warning: too few iterations for a reliable count)
<br><br>jpath:  0 wallclock secs ( 0.27 usr +  0.00 sys =  0.27 CPU) @ 11711.11/s (n=3162)
<br><br>(warning: too few iterations for a reliable count)
<br>
=head2 #

<br><br>Also: 1) the syntax is rather inconsistent: ':n' for array index access, but '.@' (instead of ':@') for grabbing all elements. 2) currently cannot select subtree (must always select leaf node).
<br><br>As alternatives, I recommend the much simpler JSON::Path, or the more powerful Data::DPath.
<br>


=item L<Games::2048>

Author: L<BLAIZER|https://metacpan.org/author/BLAIZER>

My favorite 2048 implementation (it's text-mode, written in Perl, uses my module Color::ANSI::Util, and what else... oh yeah, it's the only implementation where I've reached 2048 :-) ).
<br><br>One tip: enlarge the fonts of your terminal emulator (e.g. Ctrl-+ on Konsole) until it's big and convenient enough.


=item L<App::D>

Author: L<BESSARABV|https://metacpan.org/author/BESSARABV>

As an alternative, one can also do:
<br><br>alias d='
<br><br>TZ=UTC date; # show date in UTC
<br><br>date       ; # show date in local timezone
<br><br>cal -3     ; # show monthly calendar for curmon-1, curmon, curmon+1
<br>
'
<br><br>


=item L<Getopt::Long>

Author: L<JV|https://metacpan.org/author/JV>

Having worked for quite some time with option processing and several other similar modules, I have to say that most of the time you probably want to use Getopt::Long instead of the other alternatives. Or at least pick the alternatives which are based on Getopt::Long, instead of those that reinvent the wheel and do their own option parsing.
<br><br>Most other modules that reinvent option parsing either don't bother to do short option bundling (-abc instead of -a -b -c), or abbreviation (--long-o instead --long-option-name), or the choice to (dis)allow mix-mashing options and arguments, or support '--' to end option processing, or respect ordering, or support multiple options (--verbose --verbose), or support '--foo=val' I<as well as> '--foo val', and so on. These are features and conveniences that are taken for granted by people working daily in Unix command-line.
<br>


=item L<Text::Table::Tiny>

Author: L<NEILB|https://metacpan.org/author/NEILB>

Very fast, several times faster than Text::TabularDisplay or Text::Table (and many times faster than the other slower table-generator modules). It uses sprintf() to format a whole row instead of formatting each cell separately using sprintf() and joining cells together with join().
<br><br>I did a comparison in: <a href="http://blogs.perl.org/users/steven_haryanto/2014/07/benchmarking-several-ascii-table-generator-modules.html" rel="nofollow">blogs.perl.org/users/steven_haryanto/...</a>


=item L<Mo>

Author: L<TINITA|https://metacpan.org/author/TINITA>

A great alternative when Moo is a bit too much for you. Useful for scripts that must start really fast. Mind you, Moo loads about 5K lines of code and more than a dozen files, all of which takes +- 10ms on my computer. Mo on the other hand is only a single line of +-500 characters, and it's inlinable. It loads in under 1ms. If a script must be executed thousands of times a day, that 9ms difference will matter more.
<br><br>I use this for a very lightweight parent class. A richer subclass then uses Moo.
<br><br>Isn't it great that we have the choices and upgrade path from the very minimal Mo, to Moo for normal cases, to Moos and Moose for even richer (but heavier) alternatives. Truly TIMTOWTDI!
<br>


=item L<App::ChangeShebang>

Author: L<SKAJI|https://metacpan.org/author/SKAJI>

Given that the name of this module/app is &quot;change shebang&quot; (instead of &quot;change shebang to samedir perl&quot;) perhaps this app can be made more generic? For example, I've had to change all shebangs from &quot;#!/usr/bin/env perl&quot; to &quot;#!perl&quot; and vice versa. Perhaps this module/app can become a tool to easily switch between shebangs.
<br>


=item L<Hash::Ordered>

Author: L<DAGOLDEN|https://metacpan.org/author/DAGOLDEN>

Overall looks ok, with the exception that it does not look and feel like a regular Perl hash at all. Now someone just needs to create a tie interface on top of this :)
<br>


=item L<App::whatthecommit>

Author: L<MUDLER|https://metacpan.org/author/MUDLER>

From the description: &quot;App::whatthecommit is just another lazy-to-lazy line command utility.&quot; I'd thought the definition of laziness would be something like 'alias gc=git commit --allow-empty-message'. This is more like hubris. Or whatever. :)
<br>


=item L<Opt::Imistic>

Author: L<ALTREUS|https://metacpan.org/author/ALTREUS>

Very nifty for short scripts and some clever design inside (all options are stored as arrayref, but there is some overloading to make getting boolean/flag and normal scalar value convenient).
<br><br>For more &quot;proper&quot; scripts though (anything above say 20-30 lines) I'd recommend using something like Getopt::Long with a real spec. Some of the features I like in G::L not in Opt::Imistic: the ability to get --noOPT for free for flag options, the ability to configure permute/no_permute (mix mashing options with arguments), some data validation, and of course: autoabbreviation of long option names, which requires a spec after all.


=item L<Devel::STrace>

Author: L<DARNOLD|https://metacpan.org/author/DARNOLD>

The doc looks promising, it really looks like it could be the &quot;strace for Perl functions&quot;, but the usage is awkward (you have to open two terminals, one for running your program and producing trace file, and another for reading this file). And I'm probably an idiot, but I can't get this module to work for me.
<br><br>One alternative if you're looking for a similar module is Debug::LTrace.
<br><br>


=item L<Devel::TraceSubs>

Author: L<PARTICLE|https://metacpan.org/author/PARTICLE>

For an alternative, try Debug::LTrace, which roughly provides the same basic feature but is more convenient to use from the command-line and give extra information like timing.
<br><br>


=item L<Devel::TraceCalls>

Author: L<COSIMO|https://metacpan.org/author/COSIMO>

Might be powerful and flexible, but not convenient to use especially from command-line. (I was searching for something like &quot;strace for Perl function&quot;).
<br>


=item L<Debug::LTrace>

Author: L<KOORCHIK|https://metacpan.org/author/KOORCHIK>

One of the more convenient and usable subroutine tracing modules on CPAN. If you're looking for something like &quot;strace for Perl functions&quot;, try this.
<br>


=item L<Debug::Trace>

Author: L<JV|https://metacpan.org/author/JV>

Good module, but try its derivative Debug::LTrace instead. Debug::Trace doesn't fake caller() yet so traced/wrapped subroutines get caller() results that are &quot;off-by-1&quot; (see Hook::LexWrap). Plus, Debug::LTrace gives more information like timing.
<br><br>


=item L<App::Trace>

Author: L<SPADKINS|https://metacpan.org/author/SPADKINS>

The name and abstract is slightly inaccurate/misleading. This module is supposed to be a general logging framework instead of just subroutine entry/exit tracer. For alternative subroutine tracer, I'd recommend Devel::TraceSubs or Devel::TraceCalls (or even Devel::Trace + variants).
<br><br>Not very convenient to use. It still requires you to put 'if $App::Trace' clause everytime. For general logging that can be switched on/off upon runtime, I'd recommend using Log::Any instead.
<br><br>Lastly, this module is tied to App::Options and thus only really usable if you use both.


=item L<Tie::Hash::Identity>

Author: L<CINDY|https://metacpan.org/author/CINDY>

Hash::Identity has a use case of convenience when embedding expression in double-quote strings. I fail to see the point of Tie::Hash::Identity though. Can't you just say:
<br><br>'abc' eq 'abc'; # true
<br><br>(1+2+3) eq '6'; # true
<br>


=item L<Hash::Identity>

Author: L<CINDY|https://metacpan.org/author/CINDY>

At first I thought, hey, cute trick. But then Perl already has:
<br><br>print &quot;You could use expr like this: ${(2**3)}.\n&quot;;
<br><br>print &quot;Or you could use ident ${( 'a' . 'b' )} as well.\n&quot;;
<br><br>So you're trading a backslash and a couple of parentheses against having to depend on a non-core module and making your code reader raise her eyebrow when she first sees your code. Pick your poison :-)
<br><br>I wonder if this belongs in Acme::
<br><br>On the other hand and slightly off-topic, a module that can do Perl6-style interpolation (lexically) would be cool, I think:
<br><br>$s = &quot;perl${(6-1)}-style interpolation&quot;;
<br>
{
<br><br>use v6str;
<br><br>$s = &quot;perl{ 5+1 }-style interpolation&quot;;
<br>
}
<br>


=item L<Data::Structure::Util>

Author: L<ANDYA|https://metacpan.org/author/ANDYA>

@Tom Browder: If you just need unblessing, there's also another module Acme::Damn which is more minimalist. You can also create a shallow copy to unbless a reference, if you want to do it without the help of any module (Both Acme::Damn and Data::Structure::Util are XS modules, JFYI).
<br><br>Re Data::Structure::Util: nifty module that provides speedy alternative for several things like checking for circular references, weaken them, unblessing a reference, etc. You can do many of the routines in pure Perl. This module lets you do them in C.
<br>


=item L<Fsdb>

Author: L<JOHNH|https://metacpan.org/author/JOHNH>

An interesting tool that has been developed since 1991 (which is roughly around the time the WWW and Linux was born, whew). Kudos to the author for the dedication and consistency.
<br><br>Since nowadays SQL is pretty much ubiquitous, users might also want to check out an alternative tool, App::fsql. For example (taking a similar example from the module's doc), to select entries in /etc/passwd where UID is between 1000 and 2000:
<br><br>$ ( echo -e &quot;login\tpassword\tuid\tgid\tgecos\thome\tshell&quot;; sed 's/:/\t/g' /etc/passwd ) | fsql --add-tsv - 'SELECT * FROM stdin WHERE uid &gt;= 1000 AND uid &lt;= 2000' --format text --aoh


=item L<Date::Tie>

Author: L<FGLOCK|https://metacpan.org/author/FGLOCK>

Cool, but personally I'd rather have something like JavaScript's properties (since Perl does have lvalue subroutine support): 
<br><br>$date-&gt;year = 2014;
<br>


=item L<File::Slurp::Tiny>

Author: L<LEONT|https://metacpan.org/author/LEONT>

More effort needs to be made with regards to documentation, especially for File::Slurp users looking for alternatives. Why is this module needed? What are the differences with File::Slurp? How do the functions behave on I/O errors (since err_mode option is not supported)?
<br>


=item L<Clone::PP>

Author: L<NEILB|https://metacpan.org/author/NEILB>

Thanks for providing a pure-Perl alternative for deep cloning. Otherwise we are stuck with core module Storable's dclone, which cannot handle Regexp objects out of the box, must use deparse to handle coderefs, and not to mention is not as fast as it should be because it's a marshall+unmarshall algrorithm (ab)used for deep cloning.
<br><br>Of course, there are faster XS-based cloning modules on CPAN (all currently non-core, believe it or not there are no core modules for cloning except Storable). I'd recommend Data::Clone. But it's nice to have a pure-Perl implementation, e.g. for creating a dependency-free script using App::FatPacker.


=item L<IPC::System::Simple>

Author: L<JKEENAN|https://metacpan.org/author/JKEENAN>

This is a well-designed module with a good interface. The core system()'s behavior of whether to invoke shell or not depending on the number of arguments is ... unfortunate. This module fixes that.
<br><br>However, the previous review's comparing of IPC::System::Simple with IPC::Run or IPC::Simple is rather misguided. They focus on different things: IPC::System::Simple focuses on providing shell/no-shell versions of invoking commands and making a command's result easier to parse. It does not support feeding text to STDIN, handlers for STDOUT/STDERR, timeouts, or the other features that IPC::{Run,Cmd} support.


=item L<IPC::Cmd>

Author: L<BINGOS|https://metacpan.org/author/BINGOS>

IPC::Cmd does its job, but the interface is inconsistent, probably because a different author wrote run_forked() (and didn't follow the same convention). run() accepts a hash of arguments, but run_forked() accepts a scalar + hashref. run() returns a list, but run_forked() returns a hashref. Command in run_forked() cannot be an arrayref, but in run() it can be.


=item L<Umask::Local>

Author: L<ROUZIER|https://metacpan.org/author/ROUZIER>

Please consider a simpler non-OO interface instead, a la File::chdir:
<br><br>use File::Umask; # or whatever, the &quot;Local&quot; thing is redundant
<br>
{
<br><br>local $UMASK = 0077;
<br><br>open(...);
<br><br>copy(...);
<br>
}
<br>
=head1 previous umask is restored

<br><br>which is arguably better (to me at least) than the current:
<br><br>use Umask::Local;
<br>
{
<br><br>my $umask_local = Umask::Local-&gt;new(0077);
<br><br>open(...);
<br><br>copy(...);
<br>
}
<br>
=head1 previous umask is restored

<br>


=item L<Proc::PidUtil>

Author: L<MIKER|https://metacpan.org/author/MIKER>

No file locking is currently done to the PID file to avoid race condition. Look at Proc::PID::File for a more proper implementation.
<br><br>


=item L<Data::Dumper::Sorted>

Author: L<MIKER|https://metacpan.org/author/MIKER>

Unnecessary. Data::Dumper does have the option to sort hash keys ($Sortkeys, look for 'sort' in 'perldoc Data::Dumper').
<br><br>This module also does not handle circular refs yet (and probably lacks other features of Data::Dumper too).
<br><br>Also the choice of returning error (&quot;$Var00 = not a reference&quot; when given Dumper(1) for example) as result is arguably unwise.
<br>


=item L<Archive::Probe>

Author: L<FGZ|https://metacpan.org/author/FGZ>

I would personally pick a non-OO, no-nonsense interface based on File::Find, like:
<br><br>use File::Find::Archive qw(find); # or find_archive
<br>
find(sub { ... }, &quot;some.tar.gz&quot;);
<br><br>instead of the multiline, tedious setup just to search a file.
<br>


=item L<App::DBBrowser>

Author: L<KUERBIS|https://metacpan.org/author/KUERBIS>

A nice, minimalistic, terminal-based user interface for browsing your database and tables. Might be useful for simple cases.
<br><br>It would be I<much> more useful if usernames/passwords, queries, and other settings can be saved in a config/session file.
<br>


=item L<Locale::Maketext>

Author: L<TODDR|https://metacpan.org/author/TODDR>

Users might want to check out this article on why one should perhaps use Locale::TextDomain instead of Locale::Maketext: <a href="http://www.perladvent.org/2013/2013-12-09.html" rel="nofollow">www.perladvent.org/2013/2013-12-09.html</a>


=item L<Curses::Toolkit>

Nice effort, but one might also want to look at Tickit, which is not curses-based and looks more promising. Being based on Curses, this module still suffers from the many bugs and limitations of curses. The lack of Shift-Tab support, for one.
<br><br>See also: <a href="http://www.perlmonks.org/?node_id=1059926" rel="nofollow">www.perlmonks.org/?node_id=1059926</a>
<br><br>As I explore doing TUI more, I will update the reviews.
<br>


=item L<Moo::Lax>

Author: L<DAMS|https://metacpan.org/author/DAMS>

Great idea! I've been bitten and annoyed by strictures on more than one occasion. It has its uses, but users should have a choice on how to react to warnings.
<br>


=item L<App::YTDL>

This module is based on WWW::YouTube::Download but its documentation does not yet explain how it differs from WWW::YouTube::Download. From what I see at a glance, App::YTDL supports downloading a video from a playlist and setting download speed limit, but perhaps the author should do the mode detailed explaining to help users when to choose between the two.
<br>


=item L<Data::CompactDump>

Author: L<MILSO|https://metacpan.org/author/MILSO>

At the current form, simply too simplistic to be an alternative to Data::Dump or Data::Dumper. No support for blessed refs, filehandle/globs, circular references, and so on. Changes numbers to stringy numbers or vice versa.
<br><br>Currently also contains some bugs like for -1 (changes it to string), &quot;\&quot; (produces invalid dump, does not handle backslash yet currently), 
<br><br>And Data::Dump's dump of {} and [] are currently more compact ;-)
<br><br>Need to be improved significantly first. But keep up the effort.


=item L<P>

Author: L<LAWALSH|https://metacpan.org/author/LAWALSH>

I personally don't mind the namespace choice. There are other single-letter CPAN modules too like B, L, U, V. If you have a beef with regard to namespace, don't single out P and perhaps downvote the other modules too.
<br><br>Having said that, I would like to comment on the design and implementation of this module.
<br><br>1) The choice of Unicode character U+2204 as representation of undef. Unless one does something like 'binmode STDOUT, &quot;:utf8&quot;', with 'say P undef' I am just trading one warning (&quot;Use of uninitialized value&quot;) with another (&quot;Wide character in say/print&quot;). The wide character warning is avoided if you do 'P &quot;%s&quot;, undef' though, which means...
<br><br>2) P loads utf8 by default. For ultra-lightweight cases, this is sometimes not desirable. There is currently no way to turn this off.
<br><br>3) The arbitrary choice of three levels deep when printing references. This can be customized but with an unusual syntax. But again, the arbitrary choice of three.
<br><br>4) The &quot;complex&quot; rules of newline printing. p() is like puts, it can optionally add a newline. But unlike puts, the doc says it can also remove newlines. The behavior can also change if the string to be printed ends with 0x83.
<br><br>I might use P for a sprintf/printf replacement, but for debugging values, I'd prefer something &quot;dumber&quot; like Data::Dump::Color (or Data::Printer, if that's your thing).


=item L<Xporter>

Author: L<LAWALSH|https://metacpan.org/author/LAWALSH>

A couple of comments. First, if you want to import the default exports I<as well as> some additional others, you can use Exporter's feature (the :DEFAULT tag):
<br><br>use SomeModule qw(:DEFAULT a b c);
<br><br>or you can also &quot;use&quot; twice:
<br><br>use SomeModule;           # imports default exports
<br><br>use SomeModule qw(a b c); # import a, b, c
<br><br>Second, if you use Xporter, your module will behave unlike most CPAN modules out there, because a majority of modules use Exporter. When people see this Perl code:
<br><br>use SomeModule qw(a b c);
<br><br>normally they will expect only a, b, and c are exported. If SomeModule uses Xporter, it will also by default export the default exports.
<br><br>Basically Xporter is just Exporter with a different default (not arguably better or more user-friendly). For the sake of minimizing surprise to my users, I would avoid the use of Xporter.
<br><br>UPDATE 2014-01-24: some edits. I appreciate the effort of the author to defend her module, though I am not convinced by her arguments.


=item L<Dist::Zilla::Shell>

Author: L<DOLMEN|https://metacpan.org/author/DOLMEN>

Nice tool that lets you type dzil commands like 'build', 'test', etc while sending all the other unknown commands like 'ls -l', 'man Foo' to the underlying shell. Also lets you avoid multiple startup overhead of dzil :-)


=item L<CPANPLUS::Shell::Curses>

Author: L<MARCUS|https://metacpan.org/author/MARCUS>

Unmaintained. Installs but no longer runs.


Rating: 2/10

=item L<Task::Mechanistic>

If you peek into its Makefile.PL, you'll see a seemingly random/heterogenous collection of modules to install (instead of just WWW::Mechanize). This is probably a Task::BeLike::$AUTHOR in disguise.
<br><br>


=item L<Sereal>

Author: L<YVES|https://metacpan.org/author/YVES>

So far the best of the bunch. 
<br><br>FAST: much faster than Storable, roughly the same speed as (sometimes slightly faster than) Data::Clone for cloning. 
<br><br>FEATUREFUL: Can handle circular references, Regexp objects (trips out-of-the-box Storable), JSON::{PP,XS}::Boolean objects (trips Data::Clone). 
<br><br>COMPACT: definitely more compact (up to several times) than Storable. 
<br><br>I'm sold. What more do you want? Le Storable est mort, vive le Sereal!


=item L<Test::Tester>

Author: L<EXODIST|https://metacpan.org/author/EXODIST>

If you write test functions, you need this. It's like the &quot;Test::More&quot; for &quot;Test::More&quot;. However, it currently does not work out of the box with subtests (submitted as wishlist to RT).
<br><br>PS: Thanks to Toby Inkster for pointing this module out.
<br><br>


=item L<Text::CharWidth>

Author: L<KUBOTA|https://metacpan.org/author/KUBOTA>

It's faster than Unicode::GCString-&gt;new($str)-&gt;columns, but it gives wrong answers to lots of characters, e.g. control characters like &quot;\n&quot;, &quot;\t&quot;, etc are currently assumed to have width of -1 character. You're better off with Unicode::GCString.


Rating: 2/10

=item L<App::Options>

Author: L<SPADKINS|https://metacpan.org/author/SPADKINS>

2010-10-13:
<br><br>I admit, this is not the most flexible configuration framework out there as it enforces some convention. And I don't/can't use it on every project. But it's certainly one of the easiest. You can slap a few lines of options declaration in your code and voila, your script suddenly can accept command line arguments, has --help message et al, read from config files (in several preset locations).
<br><br>There are still a few annoyances (I submitted them in the RT), but in general, this is a very handy module to use for lazy coders who just want to accept configuration/options from outside the code.
<br><br>&lt;shameless plug&gt;I'm trying to do somewhat the same with Config::Tree, but as of now the module is not really done yet.&lt;/shameless plug&gt;
<br><br>UPDATE 2013-08-15:
<br><br>I'm reducing the ratings from 5 to 2. I've now avoided using this module due to two lingering issue since 2010: 1) App::Options does not accept '--opt val', only '--opt=val' which is incompatible with how most command-line programs work, causing confusion for some of my users. 2) 'perl -c' doesn't work under this module, it will still trigger command-line processing.
<br><br>I'm now using Perinci::CmdLine as replacement, but I cannot recommend it in general, as the two modules are not equivalent.


Rating: 4/10

=item L<Filesys::Notify::Simple>

Author: L<MIYAGAWA|https://metacpan.org/author/MIYAGAWA>

It's rather unfortunate that currently the choice for general purpose cross-platform filesystem notification modules on CPAN falls between this module (FNS) or File::ChangeNotify (F::CN). The other CPAN modules are either OS-/framework-specific.
<br><br>FNS has a simple API but is perhaps too simple for some uses, while F::CN uses Moose and has a big startup overhead. 
<br><br>If you simply want to check from time to time whether a change has occured, you need to wrap the wait() method with alarm(). And I found on my Linux PC that I need a timeout of at least 3 seconds for this to work reliably.


Rating: 8/10

=item L<experimental>

Author: L<LEONT|https://metacpan.org/author/LEONT>

Vote +1 to add this to core. Please make coding in Perl 5 relatively painless.


=item L<MIME::Lite::HTML>

Author: L<ALIAN|https://metacpan.org/author/ALIAN>

Very straightforward to use (I needed to send a URL/webpage as HTML email with embedded images/objects). With this module I can finish my job with only a few lines of Perl in 3-5 minutes (searching for this module in CPAN takes more than that! searching using &quot;mail web&quot; or &quot;email url&quot; at first didn't get results).
<br><br>Blackberry is having trouble displaying the resulting email though. No problem with Gmail or Thunderbird/Icedove.


=item L<Term::Size>

Author: L<FERREIRA|https://metacpan.org/author/FERREIRA>

5-year old bug like RT#38594 still present. Use one of the alternate implementations like Term::Size::{Unix,Win32,ReadKey}.
<br>


Rating: 2/10

=item L<DateTime::Format::Flexible>

Author: L<THINC|https://metacpan.org/author/THINC>

While it doesn't cover as much phrases as DateTime::Format::Natural, at least it's simpler to translate (and the dist already includes a couple of translations). BTW, I think like in the POD of DateTime::Format::Natural, it needs to list which phrases it supports. And probably add more :-)
<br><br>


Rating: 8/10

=item L<DateTime::Format::Natural>

Author: L<SCHUBIGER|https://metacpan.org/author/SCHUBIGER>

I'm giving DateTime::Format::Natural 3 stars because while it's great for English (it covers more phrases than DateTime::Format::Flexible), it's also hard to translate. Look at the source code for DateTime::Format::Natural::Lang::EN: lots of Englishisms and weird structures (%grammars). Wonder why so far there has not been any translations to another language?
<br>


Rating: 6/10

=item L<App::sourcepan>

Author: L<PEVANS|https://metacpan.org/author/PEVANS>

Thanks, just what I needed. (I was hoping cpanm would accept my --download patch, but this is just as well).
<br><br>It still uses CPAN.pm and thus downloads the relatively big 01mailrc.txt.gz and 02packages.details.txt.gz file, thus slowing the first use. If you use cpanm exclusively, this is rather annoying especially if you're on a slow link.


Rating: 8/10

=item L<Text::ASCIITable::TW>

The method of determining visual width of Chinese characters is rather hackish. Text::ASCIITable should perhaps use Text::CharWidth (which can be used to determine visual width of text in other languages e.g. Japanese, etc) thus rendering this module unnecessary.
<br>


=item L<Text::VisualWidth>

Author: L<NANZOU|https://metacpan.org/author/NANZOU>

Also look at Text::CharWidth for an alternative that can be used with text in other languages (Chinese, etc).
<br>


=item L<Text::VisualWidth::PP>

Author: L<TOKUHIROM|https://metacpan.org/author/TOKUHIROM>

Also look at Text::CharWidth for an alternative that can be used with text in other languages (Chinese, etc).
<br>


=item L<Taint::Runtime>

Author: L<RHANDOM|https://metacpan.org/author/RHANDOM>

Nice idea. Perl should really have included something like this (analogous to warnings.pm for -w).
<br><br>However, for something as security-related as tainting, I personally think the interface is a bit too complex and not robust enough. There are too many pitfalls where one can fail to turn on tainting properly.
<br><br>* First, user must remember to import $TAINT, or doing '$TAINT = 1' has no effect. There's no error/warning for this mistake.
<br><br>* Then, if one also forgets to import taint_start or taint_start, then doing 'taint_start' or 'taint_env' (without parentheses) will do nothing. Also does not produce an error/warning except under strict mode.
<br><br>* One must remember to 'taint_env' I<after> 'taint_start'. There's no warning/error if one does the opposite.
<br><br>I'd rather have something like this:
<br><br>{
<br><br>use tainting;
<br><br>... code is running in taint mode ...
<br>
}
<br><br>use tainting;
<br>
{
<br><br>no tainting;
<br><br>... code is running without taint mode ...
<br>
}
<br><br>No functions, no variables to set, no exports. Tainting of %ENV etc should be done automatically just like -T.
<br><br>EDIT: I wrote tainting and uploaded it to CPAN as proof of concept.


Rating: 8/10

=item L<L>

Author: L<SONGMU|https://metacpan.org/author/SONGMU>

Reinvents Class::Autouse (written 12 years ago). But at least L is much simpler and shorter to type (the equivalent of -ML is -MClass::Autouse=:superloader).
<br><br>BTW, there's also Module::AutoLoad, Module::AutoINC, and lib::xi which can automatically install modules from CPAN and load them upon first use. 


=item L<UNIVERSAL::moniker>

Author: L<KASEI|https://metacpan.org/author/KASEI>

Perl is not Ruby != everything Ruby does is horrible. This module has its uses.


=item L<Time::Out>

Author: L<PATL|https://metacpan.org/author/PATL>

A wrapper around Perl's alarm()/$SIG{ALRM}, so it has the same limitations, e.g. you cannot use this to properly timeout external programs started by system()/backtick. For the latter, you might want to try IPC::Cmd (run() or run_forked()), or some simpler interface for it like System::Timeout.
<br><br>


=item L<Util::Timeout>

Author: L<NOTBENH|https://metacpan.org/author/NOTBENH>

A wrapper around Perl's alarm()/$SIG{ALRM}, so it has the same limitations, e.g. you cannot use this to properly timeout external programs started by system()/backtick. For the latter, you might want to try IPC::Cmd (run() or run_forked()), or some simpler interface for it like System::Timeout.
<br><br>


=item L<System::Timeout>

Author: L<CHENGANG|https://metacpan.org/author/CHENGANG>

This is a thin wrapper over IPC::Cmd's run(). I'd personally use run() directly, it's not much harder or longer to type. Plus, IPC::Cmd is a core module.
<br><br>


=item L<Module::Quote>

Author: L<TOBYINK|https://metacpan.org/author/TOBYINK>

Wouldn't a function like load_module(&quot;Math::Module&quot;)-&gt;new(42) be more obvious? Is there a specific goal for using custom quote operator (which requires Devel::Declare, and thus a C compiler to build)?
<br>


=item L<Module::Hash>

Author: L<TOBYINK|https://metacpan.org/author/TOBYINK>

Wouldn't a function like load_module(&quot;Math::Module&quot;)-&gt;new(42) be more obvious? Is there a specific goal for using a tied hash (since there is already %INC)?


=item L<Promises>

Author: L<YANICK|https://metacpan.org/author/YANICK>

5-star for its documentation.
<br>


=item L<Lingua::ITA::Numbers>

Author: L<PETAMEM|https://metacpan.org/author/PETAMEM>

Does the author care to explain the sudden influx of Lingua::&lt;3-letter-code&gt;:: modules (which look like mostly just repackaging of their corresponding Lingua::&lt;2-letter-code&gt;:: modules with no mention of purpose in the PODs)? The original modules are not orphaned either (for example, I still maintain Lingua::ID::*).
<br><br>No Changes file. Versioning synchronized for all 3-letter modules with no indication of what version of the 2-letter-code module is used. For example, Lingua::ITA::Numbers' doc still says &quot;decimals don't work properly&quot;, while Lingua::IT::Numbers' doesn't (however, needless use of Regexp::Common does gets removed).


=item L<HTTP::Headers::Patch::DontUseStorable>

Author: L<PERLANCAR|https://metacpan.org/author/PERLANCAR>

@zaxon: I'm not sure if it's a bug with HTTP::Headers, more like a workaround for Storable. See the FAQ in the updated v0.03 for more details.
<br>


=item L<Storable>

Author: L<NWCLARK|https://metacpan.org/author/NWCLARK>

Balancing previous glowing reviews. Storable has it faults, for example historically its track record for file format backwards compatibility is poor, making programs fail when loading Storable files after the module is upgraded.
<br><br>Also, more importantly, add builtin support for Regexp object already! It's almost 2013, Regexp object has been around for, what, more than a decade? I can understand not supporting serializing filehandle or coderef, but Regexp object?


Rating: 2/10

=item L<WWW::YouTube::Download>

Author: L<OALDERS|https://metacpan.org/author/OALDERS>

Works for me too ATM. I've tried several command-line scripts (most of them Python-based, like youtube-dl, tubenick, etc). Sometimes they work, sometimes they broke. It's the nature of this kind of script. The quality comes from persistence. This module has been maintained since 2009, through several YouTube's changes. I commend the author, good job, and thanks!


=item L<Number::Zero>

From the module's POD: &quot;The number zero and undef are difficult to determine in Perl.&quot;
<br><br>Are they?
<br><br>say !defined($data) ? &quot;undef&quot; : &quot;not undef&quot;;
<br><br>say defined($data) &amp;&amp; $data==0 ? &quot;zero&quot; : &quot;not zero&quot;; # yes, warn if non-numeric
<br><br>use Scalar::Util 'looks_like_number';
<br>
say looks_like_number($data) &amp;&amp; $data==0 ? &quot;zero&quot; : &quot;not zero&quot;;
<br><br>Though I understand the need for a convenient &quot;is_zero&quot; function if you need to test for zero in a program a lot.


=item L<Syntax::SourceHighlight>

Author: L<MATLIB|https://metacpan.org/author/MATLIB>

IMO, currently the only usable (read: non-crap) code syntax highlighting library on CPAN. Cons: you'll need to install GNU Source-highlight (and its development library/header) which pulls over 100MB of packages on my Debian.
<br>


Rating: 8/10

=item L<Syntax::Highlight::Engine::Kate>

Author: L<MANWAR|https://metacpan.org/author/MANWAR>

Highlighter engine doesn't seem updated (for example, defined-or is not yet interpreted correctly by this module but already correctly by Kate itself). Does not provide default theme (must specify all colors). Seem to be very slow (takes 1.5s for a 18K Perl .pm file while Pygments only takes 0.2s).
<br><br>


Rating: 2/10

=item L<Syntax::Highlight::JSON>

Author: L<MART|https://metacpan.org/author/MART>

No documentation. Combines formatting and syntax-highlighting, so you cannot preserve original formatting. Only outputs to HTML and no default &quot;theme&quot; (CSS) provided.
<br>


Rating: 2/10

=item L<Syntax::Highlight::Engine::Simple>

Author: L<AKHUETTEL|https://metacpan.org/author/AKHUETTEL>

Output looks decent. However, it currently only formats to HTML/CSS (no ANSI, LaTeX, etc). Also, it needs more languages support.
<br>


Rating: 6/10

=item L<Syntax::Highlight::Universal>

Author: L<PALANT|https://metacpan.org/author/PALANT>

Only targets (X)HTML (i.e. no alternative output like ANSI or LaTeX). Supposedly slow. But it doesn't matter because code no longer builds (last updated in 2005).


Rating: 2/10

=item L<text::highlight>

Outdated (no longer updated), poor capability (even for some simple Perl code, the output is atrocious), few languages supported. A far cry from Pygments or coderay.


Rating: 2/10

=item L<SemVer>

Author: L<DWHEELER|https://metacpan.org/author/DWHEELER>

Good for semantic versioning scheme like 1.2.3 vs 1.2.3alpha vs 1.2.3rc (1.2.3 should be the latest, not the alpha or rc). However, does not accept e.g. 1.0beta (at least three components are needed). Perhaps relax this requirement?
<br><br>Also take a look at Debian::Dpkg::Version.
<br>


=item L<Sort::Versions>

Author: L<NEILB|https://metacpan.org/author/NEILB>

Good for Perl-style versioning scheme (1.2.3) but does not work as people expect for semantic versioning scheme like 1.2.3 vs 1.2.3alpha vs 1.2.3rc (1.2.3 should be the latest, not the alpha or rc). For handling the latter case, use SemVer. Also take a look at Debian::Dpkg::Version.


=item L<App::Countdown>

Author: L<SHLOMIF|https://metacpan.org/author/SHLOMIF>

Nice idea, though I'd probably just write a shell function for this.
<br>


Rating: 8/10

=item L<Data::Compare>

Author: L<DCANTRELL|https://metacpan.org/author/DCANTRELL>

Pros: handle hashes as well as arrays, handle nested and cyclic structure, plugins.
<br><br>Cons: No cmp-like functionality (returning -1, 0, 1), slow (even slower than Array::Compare).
<br><br>See also: Array::Compare, JSON/YAML/Storable.
<br>


Rating: 6/10

=item L<Array::Compare>

Author: L<DAVECROSS|https://metacpan.org/author/DAVECROSS>

Pros: has a perm() function to check whether the two arrays contain the same things but in different order (although you can simply just run sort() over the arrays first). Allow skipping some elements from comparison.
<br><br>Cons: no cmp-like functionality (returning -1, 0, 1), slow (for equality test, you might as well compare the json_encode() result of the arrays, which is way faster), no nested comparison. No procedural interface.
<br><br>See also: Data::Compare, JSON/YAML/Storable.


Rating: 4/10

=item L<Mozilla::Mechanize>

Author: L<SLANNING|https://metacpan.org/author/SLANNING>

No longer builds (tested on a current Debian). A pity, since drop-in replacements for WWW::Mechanize (using different backend like curl, IE, Mozilla, Chrome, etc) might be handy.
<br><br>


=item L<LWP::Curl>

Author: L<LORN|https://metacpan.org/author/LORN>

Those looking for LWP drop-in replacement might want to take a look at the recently released LWP::Protocol::Net::Curl instead, which supports WWW::Mechanize.
<br><br>


=item L<LWP::Protocol::Net::Curl>

Author: L<SYP|https://metacpan.org/author/SYP>

Shows great promise. I personally need this for HTTPS proxy support. After testing, the module still doesn't work to login to my internet banking sites. But I'll still check in from time to time.
<br>


=item L<Devel::SizeMe>

Author: L<TIMB|https://metacpan.org/author/TIMB>

Wow, just wow. Hopefully now that we can use this tool to know how big things are, we are encouraged to create leaner, faster, more efficient Perl modules.


=item L<Oktest>

Author: L<KWATCH|https://metacpan.org/author/KWATCH>

A reinvention of Perl testing modules (it even comes with an equivalent for 'prove' command), with probably no added features and some added quirks. (Nested) topic can already be done using Test::More's subtests. Filtering and setup/teardown can be done with Test::Class. And I am supposed to replace specific assertion functions (with specific, helpful error messages) like is(), isnt(), like(), is_deeply(), etc with just OK()?
<br>


Rating: 4/10

=item L<HTML::Escape>

Author: L<TOKUHIROM|https://metacpan.org/author/TOKUHIROM>

Still a bit slower than PHP's htmlspecialchars(), but in the same ballpark. An order of magnitude faster than HTML::Entities. Does not provide unescaping, but it's okay since escaping is the majority of use cases.


=item L<Clone::Fast>

Casual benchmarking on my PC shows that Data::Clone is up to twice faster than this.


Rating: 6/10

=item L<Perl::Strip>

Author: L<MLEHMANN|https://metacpan.org/author/MLEHMANN>

Balancing previous unhelpful review. Slowish (can't complain, PPI-based) but works and comes with a command-line utility.
<br><br>Beware though that the command-line utility modifies file in place without backup, without warning, and without option to create backup.
<br>


Rating: 8/10

=item L<Perl::Squish>

Author: L<ADAMK|https://metacpan.org/author/ADAMK>

Have failed to build for 1.5 years (reported bug RT#66958 left untouched, users need to install Module::Install first). No usage documentation.
<br><br>


Rating: 2/10

=item L<perlsecret>

Author: L<BOOK|https://metacpan.org/author/BOOK>

Nice collection of perl shortcuts. Today I forgot about the name for &quot;x!!&quot; and nicely found it in this module.


=item L<PerlX::ArraySkip>

Author: L<TOBYINK|https://metacpan.org/author/TOBYINK>

Cute idea as always, though I'd rather use comments rather than taking multiple sub calls hit.


=item L<App::perlfind>

Author: L<MARCEL|https://metacpan.org/author/MARCEL>

A timesaver. Using it on a daily basis (aliased to &quot;pod&quot;). Thanks, Marcel!


=item L<PerlX::Maybe>

Author: L<TOBYINK|https://metacpan.org/author/TOBYINK>

A nice syntax addition for avoiding passing or writing a bunch of undefs. More convenient to write than using ternary operator or grep. I'm beginning to adore syntax modules like this (as long as it adds negligible overhead).
<br><br>


=item L<File::Path::Tiny>

Author: L<DMUEY|https://metacpan.org/author/DMUEY>

I like the concept, but do not like the overly short names mk() and rm(). Instead of mk(), how about mkdir_p() or mkpath() like in File::Path. Instead of rm(), how about rm_r() or rmtree() like in File::Path.
<br>


Rating: 6/10

=item L<Exporter::Lite>

Author: L<NEILB|https://metacpan.org/author/NEILB>

2011-10-04: I am now using Exporter::Lite exclusively instead of Exporter. Got bit once by Exporter when using for an OO module due to clash of assigning to @ISA vs 'use base'. +1 for putting it into core.
<br><br>EDIT 2012-08-08: Nowadays I revert back to Exporter most of the time because Exporter is core. To avoid @ISA issue, one simply needs to import import() instead setting @ISA:
<br><br>use Exporter qw(import);
<br>


=item L<YAML::Syck>

Author: L<TODDR|https://metacpan.org/author/TODDR>

To be fair, in my experience YAML::Syck is not &quot;much more buggy&quot; than ::XS. It even sometimes works with my YAML data while ::XS crashes. Go figure.


=item L<Devel::FindPerl>

Author: L<LEONT|https://metacpan.org/author/LEONT>

IMO the module should explain in the POD, in what cases using $^X is not enough or how it is different from Probe::Perl.
<br><br>Anyway, quoting CPAN Testers' CPAN Authors FAQ, $^X is not enough when:
<br>
1) perl was executed with a relative path and the script has chdir()ed; 2) because $^X originates in C's argv[0] (in the main() function) it is possible for the calling program to exec() in such a way that argv[0] isn't the path to the interpreter; 3) HP/UX can do weird stuff in scripts that use #!; 4) VMS. (Not clear about #4 though :) ).


=item L<Taint::Util>

Author: L<AVAR|https://metacpan.org/author/AVAR>

IMO this is the best module to deal with tainting. BTW there are several other modules like Taint (only provides taint + tainted, no untaint), Untaint (only provides untaint with awkward interface, like $v = untaint(qr/.../, $v)), Scalar::Util (only provides tainted), Test::Taint (does not provide untaint but provides taint_deeply and test predicates), and several others.


=item L<Markdown::Pod>

Author: L<KEEDI|https://metacpan.org/author/KEEDI>

I use Markdown::Pod for my module Perinci::To::POD.
<br><br>This module does not output proper POD for many (not so) edge cases, like:
<br><br>C<&gt;> and the likes are not yet escaped, producing C&lt;&gt;&gt; when it should have been C&lt;&lt; &gt; &gt;&gt; or C&lt;E&lt;gt&gt;&gt;.
<br><br>Ordered list numbering does not yet work, e.g. &quot;2. ...\n3. ...\n&quot; produces &quot;=item 1. ... =item 1. ...&quot;
<br><br>Ordered list with item numbered other than 1 does not work (see above). This should be supported in POD because POD allows us to write the bullets/numbers for each item.
<br><br>Inline markup is not smart enough to differentiate word_with_underscore. So &quot;foo_bar and foo_baz&quot; becomes &quot;fooI&lt;bar and foo&gt;baz&quot;.
<br><br>Plus it segfaults sometimes (might be my perl though).


Rating: 4/10

=item L<Lingua::Metadata>

Author: L<MAJLIS|https://metacpan.org/author/MAJLIS>

As previous reviewer noted, this module is actually just a front-end to the author's web service. Plus license is specifically BSD (which allows this module to be included in closed source projects), this is rather ironic to me.
<br>


=item L<Finance::Currency::Convert::WebserviceX>

Author: L<CLACO|https://metacpan.org/author/CLACO>

Simple, no-fuss interface, recommended. As mentioned in the doc, the alternatives have some downsides: Finance::Currency::Convert::Yahoo is based on web scraping while ::XE has usage limits.
<br>


=item L<Carp::Always::Color>

Author: L<DOY|https://metacpan.org/author/DOY>

Like Carp::Always? Want something better? Here it is.
<br>


=item L<CHI>

Author: L<ASB|https://metacpan.org/author/ASB>

The DBI of caching. Stop reinventing your caching framework and just use this.
<br><br>UPDATE 2013-01-16: unfortunately, the use of Moose reduces the usefulness of CHI for command-line scripts (0.2s/146 files/53k lines startup overhead just to initialize a File cache). So 4 stars instead of 5. Let's hope the author migrates to Moo someday.
<br>


Rating: 8/10

=item L<Monkey::Patch>

Author: L<FRODWITH|https://metacpan.org/author/FRODWITH>

Compared to several other monkey-patching modules (like Sub::Monkey or Class::Monkey) I prefer this one because the interface is simplest and the documentation is the most straightforward. Plus it can do stacked patching and unordered restore, which is cool.
<br><br>


=item L<Log::AutoDump>

Author: L<CAGAO|https://metacpan.org/author/CAGAO>

This module is simple and to the point. Unfortunately, if you're a user of Log4perl or other logging framework, you'll have to switch just for a single feature (autodumping).
<br><br>An alternative is to use Log::Any, which also features autodumping (via $log-&gt;debugf(&quot;%s&quot;, $complex), $log-&gt;warnf(), and friends), while still allowing you to use Log4perl and other frameworks supported by Log::Any.
<br><br>


=item L<List::Pairwise>

Author: L<TDRUGEON|https://metacpan.org/author/TDRUGEON>

Two nice and possibly very useful functions. But IMO the names 'mapp' and 'grepp' are two similar to 'map' and 'grep', making it prone to typos and misreading. Perhaps consider 'map2' and 'grep2'?


=item L<Log::Log4perl::Appender::File::FixedSize>

Author: L<HOREA|https://metacpan.org/author/HOREA>

Module name should perhaps be Log::Log4perl::Appender::File::RoundRobin to make it clearer that the backend is File::RoundRobin.
<br>


=item L<Any::Mo>

Why exclude Moo?
<br><br>Also the issue with any Any::* (or Any::*) modules is that there should be a mechanism (preferably a common one) to adjust the ordering. Sometimes I prefer Moose first, for full capability or compatibility or whatever. Sometimes I prefer Mouse or Moo, for quick startup (but don't mind Moose if those are not available). This also happens to me for YAML::Any: in some cases I prefer YAML::Syck, in others YAML::XS, this depends on the data that I'm handling.
<br>


=item L<PerlX::Perform>

Author: L<TOBYINK|https://metacpan.org/author/TOBYINK>

I personally don't see much value of this syntactic sugar since Perl already allows us to express clearly. Pick one:
<br><br>for ($foo) { say $_ if defined }
<br><br>for (grep {defined} $foo) { say $_ }
<br><br>do { say $_ if defined } for $foo
<br><br>say $_ for grep {defined} $foo
<br><br>And save yourself from having to remember whether we should add a comma or not before &quot;wherever&quot;.
<br>


=item L<TOBYINK::PerlX::A>

I have nothing against bundles like this, but beware that adding 'use TOBYINK::PerlX::A' will cause Perl to load 460 files and compile +- 160k lines (takes 1s on my Core i5 machine and 8s on my Atom netbook).


=item L<WWW::Google::Images>

Just adding a note that this module is unmaintained (as expressed by the author) and has stopped working for some time. If you are looking for alternatives, try REST::Google (which includes REST::Google::Search::Images). The latter has been working OK for me.


=item L<Acme::Damn>

Author: L<IBB|https://metacpan.org/author/IBB>

5 stars for cute metaphor (there's also Acme::Holy by the same author, but that is just another implementation of Scalar::Util's blessed()) and for prompt support from the author.
<br><br>I'm sure there exists a real use case to move this out of Acme::, however obscure that might be. Can't come up with any right now, all I can think of is reblessing, which can be handled with bless() from the start.
<br><br>UPDATE 2013-09-11: I found a real use-case for it! Cleaning up data to be sent to JSON. BTW, Data::Structure::Util also has an unbless() function, but Acme::Damn is smaller and faster. Data::Structure::Util also currently doesn't build on Windows.
<br>


=item L<WWW::Parallels::Agent>

@Justin Case: The name is unfortunate, but it's already proper (WWW:: followed by website or company name). HTTP client libraries are in LWP::. But VM:: is also an apt choice.
<br>


=item L<Underscore>

I don't know why Sawyer X's review is marked as unhelpful (2 out of 8), but I agree with him. This is I<not> an Acme module, it's a port of a JavaScript library of the same name.
<br>


=item L<Locale::Geocode>

Author: L<DIZ|https://metacpan.org/author/DIZ>

Sorry to have to rate with 1 star. I don't have problem with the interface/documentation. The 1-star rating is just to warn people that the data used by this module is not up to date. And that YEARS-old bugs are not being fixed.
<br><br>At the time of this writing, this module still uses ISO 3166-2:1998 (first edition) + the newsletters (minor updates) up to 2006. When it should be updated to ISO 3166-2:2007 (second edition) + all the newsletters. For example, this module does not report 3 newer provinces in Indonesia.
<br><br>Sadly we live in a world where countries and subcountries change all the time.


Rating: 2/10

=item L<Locale::SubCountry>

Author: L<KIMRYAN|https://metacpan.org/author/KIMRYAN>

UPDATE 2012-08-30: I am not sure if the module is now fully compliant to the new ISO 2007, but bug reports are certainly being responded and resolved now. Updating rating from 1-star to 4-star. Thanks, Kim.
<br><br>2012-02-17: Review to version 1.47:
<br><br>Sorry to have to rate with 1 star. I don't have problem with the interface/documentation. The 1-star rating is just to warn people that the data used by this module is not up to date. And that months-old bugs are not being fixed.
<br><br>At the time of this writing, this module still uses ISO 3166-2:1998 (first edition) when it should be updated to ISO 3166-2:2007 (second edition) + all the newsletters (minor updates). For example, this module does not report 3 newer provinces in Indonesia.
<br><br>Sadly we live in a world where countries and subcountries change all the time.
<br><br>EDIT: Ok, so I was not being clear that I was not talking about my own bug report (posted at about the same time of this review). And bugs were certainly being resolved up to about 7 months ago.
<br>


Rating: 8/10

=item L<Data::Rmap>

Author: L<BOWMANBS|https://metacpan.org/author/BOWMANBS>

A very handy utility, sort of like s/// on your nested data structure instead of just strings. One nitpick: no coderef support. I needed to replace all coderefs inside a data structure into a string, since I want to pass it to JSON encoder. None of the rmap_*() functions seem to let me get to the coderefs. (RT wishlist ticket added.)
<br><br>UPDATE 2011-12-30: The author (Brad) quickly responded to my RT ticket and added rmap_code. Upgrading from 4- to 5-star :) Regexp support is not there yet though, and I have suggested the ability to get all kinds of Perl-specific and weird objects, because one of the main uses of Data::Rmap for me is to &quot;clean&quot; a data structure to pass to non-Perl systems.
<br>


=item L<Data::Properties::JSON>

Author: L<JOHND|https://metacpan.org/author/JOHND>

The abstract for this module is a bit strange. What does this have to do with 'test fixtures'? Also the documentation doesn't say much, e.g. What will happen if a hash key contains funny characters (or arrays, etc)?
<br><br>A similar module in spirit is Data::Hive. I think &quot;providing convenient chained method access to hierarchical data&quot; should be refactored out. So perhaps Data::Properties::{JSON,YAML,...} should just be a convenient shortcut for {JSON,YAML,...} parser + Data::Hive.


=item L<Exporter::Auto>

Author: L<NEILB|https://metacpan.org/author/NEILB>

I discourage module authors from exporting like this because it's simply too impolite/intrusive for module users. If the module author is lazy, there is already Exporter::NoWork which offers a few options for module users. This module, on the other hand, gives no control at all for users (so they'll have to resort to 'use Module ();').
<br><br>Let me remind all again by quoting from Exporter's POD: &quot;Do I<not> export anything else by default without a good reason! Exports pollute the namespace of the module user.&quot;


=item L<Net::Douban>

Interface to web services should be put under WWW::I<, not Net::>


=item L<HTML::Form::XSS>

Author: L<DUMB|https://metacpan.org/author/DUMB>

Should probably be put under Test::*?


=item L<Thread::IID>

Author: L<WROG|https://metacpan.org/author/WROG>

When I saw the perlmonks thread yesterday, I thought &quot;well, someone should package it and put it on CPAN&quot;. And then someone did :) Thanks.
<br>


=item L<Test::Lite>

Author: L<BRADH|https://metacpan.org/author/BRADH>

This is just a reimplementation of Test::More. But I thank the author for writing a short description of why this module is written, how it is different from others, and suggestion of what modules users should use. There are a lot of wheels being reinvented on CPAN, and that's okay, I just wish more people would document the reason.


=item L<Sub::Mage>

Author: L<BRADH|https://metacpan.org/author/BRADH>

Since the first release, there are 13 subsequent releases in total. What are the changes between releases? No idea, the author doesn't bother to update Changes (and no public repo is listed). Apparently all his other modules are also like this. Not very user-friendly.
<br><br>UPDATE 2011-11-22: I see that this has been rectified by the author, there is now Changes entry for each new release. Cool, thanks.
<br>


=item L<relative_lib>

Documentation is placed in README.md, so it's inaccessible from perldoc et al. Why? This is not a Python library.


=item L<CPAN::Mini::Webserver>

Author: L<MITHALDU|https://metacpan.org/author/MITHALDU>

Just found out about it, despite having used CPAN::Mini for over a year. Helps I<a lot>. More people should know this (e.g. mention from CPAN::Mini POD).


=item L<Win32::App::which>

Author: L<DOLMEN|https://metacpan.org/author/DOLMEN>

I don't use this module since I'm not on Windows. But why another module? File::Which also handles Win32 (probably not the &quot;the current directory is explored before PATH&quot; thing, but you should consider submitting a patch).
<br><br>At least the documentation should state why this module is necessary. It complicates scripts by having to select between two 'which' implementations.


=item L<Devel::Platform::Info>

Author: L<BARBIE|https://metacpan.org/author/BARBIE>

I knew CPAN wouldn't let me down. Now I can discard my own OS/platform detecting code (which probably is buggier and not nearly as extensive) and rely on Devel::Platform::Info instead.
<br><br>Devel::Platform::Info gives information not only about the OS but also architecture, kernel type &amp; version, etc. In my case I need to detect distro name, its version, and its codename. All of those are provided.
<br><br>This module is so new though (started in 2010) so I wonder whether this need has never come up before.
<br>


=item L<Package::Builder>

Author: L<DRAUONER|https://metacpan.org/author/DRAUONER>

Less boilerplate please!


Rating: 2/10

=item L<File::LibMagic>

Author: L<DROLSKY|https://metacpan.org/author/DROLSKY>

After comparing against File::MMagic, File::MMagic::XS, File::Type, I ended up choosing File::LibMagic because it has the least problems and looks like being the most maintained (although it would be nice if the author cleans up the RT queue).
<br><br>For those stuck without a C compiler, File::Type or File::Magic can be an alternative.


Rating: 8/10

=item L<File::MMagic::XS>

Author: L<DMAKI|https://metacpan.org/author/DMAKI>

Last time I checked, still can't parse system magic database, e.g. /usr/share/file/magic (bug first filed in RT 4 years ago).
<br><br>The currently recommended module in this area seems to be File::LibMagic. Other alternatives include File::MMagic (slow and buggy, no longer maintained), Media::Type::Simple (only maps MIME type from/to file extension).


Rating: 4/10

=item L<File::MMagic>

Author: L<KNOK|https://metacpan.org/author/KNOK>

Works for basic usage, but has quite a few problems. Plus it is not very performant. Doesn't seem to be maintained anymore.
<br><br>The currently recommended module in this area seems to be File::LibMagic. Other alternatives include File::Type (gives less useful results), File::MMagic::XS (also not actively maintained? long standing bugs like failure to parse system magic file still persists), Media::Type::Simple (only maps MIME type from/to file extension).
<br>


Rating: 4/10

=item L<File::Type>

Author: L<PMISON|https://metacpan.org/author/PMISON>

As another reviewer has said, this module tends to conclude &quot;application/octet-stream&quot; for many kinds of files, making it not very useful.
<br><br>The currently recommended module in this area seems to be File::LibMagic. Other alternatives include File::MMagic (slow, has quite a few bugs, no longer maintained), File::MMagic::XS (also not actively maintained? long standing bug like failure to parse system magic file still persists), Media::Type::Simple (only maps MIME type from/to file extension).
<br>


Rating: 2/10

=item L<Time::Mock>

Author: L<EWILHELM|https://metacpan.org/author/EWILHELM>

Balancing previous 1 rating by @Ingo.
<br><br>To Ingo: You said module's documentation is okay, one feature you use works okay, and other features you don't use. Why only 1 star then?
<br><br>This module is a worthy alternative to Test::MockTime. It offers extra features such as working across forks, mocking Time::HiRes (eventually), and speeding/slowing down time.


=item L<Sakai::Stats>

Release early, release often indeed. First you release nothing but boilerplate :)


Rating: 2/10

=item L<Spreadsheet::Perl>

Author: L<NKH|https://metacpan.org/author/NKH>

Good documentation. All modules' documentation should similarly strive to contain at least: rationale for existence, pointer to alternatives, and task-oriented organization.


=item L<Unix::PasswdFileOps>

Author: L<BMAYNARD|https://metacpan.org/author/BMAYNARD>

Less-than-descriptive name (module's main function seems to be sorting entries, can't be guessed from the name). No unit tests. Doesn't handle /etc/shadow. Also, it might be useful to explain why one needs to sort entries in passwd file.
<br>


Rating: 4/10

=item L<Array::Diff>

Author: L<NEILB|https://metacpan.org/author/NEILB>

Yes, simple and gets the job done. Though I'm a bit curious with the implementation. If the interface is only to get number of deleted and added items (instead of positions of deletion/insertion), why depend on Algorithm::Diff (or use the name 'diff', for that matter).
<br>


=item L<DZ1>

Why do we need this uploaded to CPAN?


Rating: 2/10

=item L<Passwd::Unix>

Author: L<STRZELEC|https://metacpan.org/author/STRZELEC>

No tests. No detailed error status, only true/false (yes, there is a 'warnings' parameter on constructor, but this doesn't give out warnings on all operations, only some). No locking (although there is backup, but still).
<br><br>Also, some weird choices, why use bzip2 when creating backup? Or, why still require running as root (checking $() if we are allowing custom database file location?
<br><br>Between this and Unix::ConfigFile, I'm seriously considering using Unix commands instead (useradd, userdel, gpasswd, et al).
<br><br>UPDATE 2011-04-21: I created a fork of Passwd::Unix 0.52 called Passwd::Unix::Alt instead, which add some tests and modifications. Try it out if your needs are also not met by Passwd::Unix.
<br><br>UPDATE 2012-08-30: I created a new module called Unix::Passwd::File. Try it out if your needs are also not met by Passwd::Unix.


Rating: 2/10

=item L<Unix::ConfigFile>

Author: L<SSNODGRA|https://metacpan.org/author/SSNODGRA>

Outdated module that doesn't handle /etc/shadow and /etc/gshadow.


Rating: 2/10

=item L<lib::xi>

Author: L<GFUJI|https://metacpan.org/author/GFUJI>

Handy module for installing dependencies. There are previous efforts, but the arrival of cpanm makes autoinstall process less tedious, so hats off also to the creator of cpanm.
<br>


=item L<Capture::Tiny::Extended>

Author: L<MITHALDU|https://metacpan.org/author/MITHALDU>

Indispensable. Provides nice enhancement to Capture::Tiny (particularly the real-time teeing).
<br>


=item L<google_talk_bot>

Improperly packaged, improper POD formatting, bot messages hardcoded in script, and yes... idiotic license. Basically a &quot;trial&quot; script to bait users into consultation gig. CPAN is not a place for this kind of thing. Please try again.
<br>


Rating: 2/10

=item L<Clone::Any>

Author: L<EVO|https://metacpan.org/author/EVO>

Using Clone::Any nowadays is more trouble than it's worth.
<br><br>First, there are annoying incompatibilities between cloning modules. Most notably Storable, which is the default cloning module if Clone is not available, I<still> doesn't support storing Regexp objects out-of-the-box after all these years.
<br><br>Second, this module has not been updated for a long time and newer alternatives like the fast Data::Clone is not recognized.
<br><br>Right now I'm replacing all code from using Clone::Any code to Data::Clone.
<br><br>


Rating: 4/10

=item L<Array::OrdHash>

Author: L<WOWASURIN|https://metacpan.org/author/WOWASURIN>

Fun module to play with, especially for those among us infected with a bit of PHP envy (me, never!).
<br>


=item L<Bash::Completion>

Author: L<MELO|https://metacpan.org/author/MELO>

Clean code, plugin interface simple to use, but implementation needs to be improved. For example, parsing $ENV{COMP_LINE} &amp; $ENV{COMP_POINT} into @argv is done simplistically using split(/\h+/), without regard to shell's quotes/escapes. (Getopt::Complete's way is somewhat better by invoking shell, but it also has its problems. I guess in this regard external programs are second-class citizens to shell functions because they don't get the equivalents of COMP_WORDS/COMP_CWORD). 
<br>


Rating: 6/10

=item L<Bash::Completion::Plugins::cpanm>

Author: L<PERLER|https://metacpan.org/author/PERLER>

Cool, except that with cpanm I often install local distribution (cpanm Foo-Bar-1.23.tar.gz). Perhaps the completion can look in the filesystem first before firing API request. Also, might be nice if there is some caching because it seems to be slow (at least from where I am).
<br>


Rating: 8/10

=item L<Switch>

Author: L<CHORNY|https://metacpan.org/author/CHORNY>

With all due respect to the author, Switch is no longer necessary in 5.10+ as 5.10+ already introduced smart matching and given(). given() is superior because it doesn't introduce compile-time overhead, doesn't mess line numbers, and should be faster (simply because smart match is fast, and Switch is not utilizing it).
<br><br>You have been using 5.10+, right? (Since 5.8 is no longer officially supported)
<br>


=item L<Moo>

Author: L<HAARG|https://metacpan.org/author/HAARG>

Last week I ported an application from Mouse (Any::Moose) to Moo. Went without a hitch (well I did replace &quot;with 'X', 'Y', 'Z';&quot; to &quot;with 'X'; with 'Y'; with 'Z';&quot; as instructed in the Moo documentation). Startup time decreased significantly. Planning to move every Moose apps to Moo. Splendid!
<br>


=item L<Sub::StopCalls>

Author: L<RUZ|https://metacpan.org/author/RUZ>

Cool idea, if a bit extreme.
<br><br>If computing a value is expensive, there's Memoize for the caller. On the callee side, you can cache the result (there's state variable in 5.10+ so it's dead simple to use).
<br><br>So I believe Sub::StopCalls is only necessary if you find the overhead of the sub call itself to be a bottleneck. And if that is the case, perhaps you should refactor the calling code anyway.


Rating: 8/10

=item L<Log::Log4perl::Tiny>

Author: L<POLETTIX|https://metacpan.org/author/POLETTIX>

5 stars solely for the idea (I'm beginning to love the ::Tiny movement more and more these days). Haven't actually tried it though, but I bet many Log4perl users, me included, mostly only use easy_init. As much as Log4perl is mature and fairly optimized, it's still a relatively &quot;huge&quot; library. Nice to know there's a drop-in ::Tiny replacement.


=item L<SHARYANTO::YAML::Any>

Re: Blue. I guess I shouldn't release this. I need something quick to fix our application, so this is not really something meant for public use. Will be purging this from PAUSE.
<br>


=item L<SQL::Easy>

Author: L<BESSARABV|https://metacpan.org/author/BESSARABV>

IIRC, there has also previous similar attempt like this. Modules like these are not necessary, as DBI already has something equivalent (and even better): selectrow_{array,hashref,arrayref} and selectall_{array,hash}ref.
<br>


Rating: 2/10

=item L<CGI::Struct>

Author: L<FULLERMD|https://metacpan.org/author/FULLERMD>

Cool, will definitely try this out the next time I write another form processing CGI script. Although the module is named CGI::, there's nothing CGI-specific about it, and that's good. So this module is basically a &quot;path-expander&quot; for hash values.
<br><br>Btw, one thing I use rather often in PHP is naming parameter as &quot;foo[]&quot; which will automatically add elements to the $_REQUEST['foo'] array. Perhaps this feature can be considered too.


=item L<DateTime::BusinessHours>

Author: L<BRICAS|https://metacpan.org/author/BRICAS>

Just tried it. It works, but the module/dist is not in the best shape:
<br><br>* Test fails (pod-coverage, error in POD)
<br><br>* dependency on Class::MethodMaker not yet specified
<br><br>* Documentation: Synopsis contains mistake (class name is DateTime::BusinessHours not BusinessHours), the name '$testing' is not very suitable, there are typos.
<br><br>* Style-wise, method naming is &quot;joinedwords&quot;, while in DateTime families it's &quot;separated_words&quot; (not a big deal though).
<br><br>


Rating: 6/10

=item L<Bundle::Dpchrist>

Every once in a while everyone of us encounters a programmer that disregards existing reusable code and creates his/her own &quot;standard library&quot; for everything, from trimming string to creating random number to cleaning the kitchen sink. We all might have been one too, at one time or another. I'm not saying that this bundle is a case of the above, but it's giving me a similar feeling. :-)
<br><br>A commendable effort, David. But there really are a lot of wheels being reinvented here.


=item L<Net::BitTorrent::File>

Author: L<ORCLEV|https://metacpan.org/author/ORCLEV>

I mass download stuffs by putting a bunch of torrent files in a directory on the server and let rtorrent takes care of them. With this module I can quickly whip up a short script to calculate the total size of the downloadable files so I can be pretty sure that when I leave my server for days/weeks, I don't run out of disk space because I put in too many torrent files.
<br>


=item L<Module::CoreList>

Author: L<BINGOS|https://metacpan.org/author/BINGOS>

Wow, I was thinking the same exact &quot;godsend&quot; too and turns out some other reviewer already said so. Very very helpful to assist deployment and pick modules to use. I personally made a couple of command-line scripts like pm-in-core or core-since-when to save some typing.
<br>


=item L<WWW::Mechanize>

Author: L<SIMBABQUE|https://metacpan.org/author/SIMBABQUE>

WWW::Mechanize is of course one of the indispensable tools for any web programmer or admin. The current problem is the proliferation of 3rd party subclasses, the functionalities of which cannot be used together. So you want a polite Mechanize which does self-rate-limiting and uses the Firefox or IE engine? A subclass exists for each feature, but how do you use them together? WWW::Mechanize needs to be more role/plugin-oriented instead of inheritance-oriented.
<br>


=item L<Mail::Sendmail>

Author: L<NEILB|https://metacpan.org/author/NEILB>

I used Mail::Sendmail and a few others &quot;older&quot; modules back from the days when it didn't support setting envelope sender different from RFC From, and when the test hung on some dead host.
<br><br>If it's still working for you, great. I personally have moved on to other modules like Email::Sender::Simple, which abstracts sending mechanism (transport) and support SMTP auth, for two. Also, many of the guide/documentation for Mail::Sendmail are not quite up to date in style (though they still might work), for example the low level way of building HTML email. Also, the Changelog file doesn't seem to be maintained?


Rating: 6/10

=item L<autodie>

Author: L<TODDR|https://metacpan.org/author/TODDR>

I started using autodie in almost all of my applications a few months ago. It's somewhat of a mixed blessing. For existing applications, it can break things and making things less robust, solely because old code are not built with autodie in mind.
<br><br>But the best thing about it is that it's lexically scoped, so for sections of code that you're not sure about, just sprinkle 'no autodie' to get the old behaviour.
<br><br>It should be used on probably 95% of code out there. For the rest of the cases, where you need to report the status of each I/O operation, it's obviously more convenient to check $? instead of trapping exception everytime.
<br><br>+1 for getting it into core.
<br>


=item L<App::FileTools::BulkRename>

Disclaimer: I maintain a &quot;competitor&quot; module, App::perlmv. Apparently a lot of people, like me, likes to rename files using Perl. And the examples in the documentation are about renaming movie files too, something which I do a lot :)
<br><br>I applaud Stirling Westrup for taking a legacy script and improving it. May we have a lot of ideas to borrow from each other.
<br><br>This is an early release, there are quite a few things I find lacking. Most importantly, I suggest adding a test suite as soon as possible. The filesystem differences can be tricky, and CPAN Testers can help providing feedback.
<br><br>Keep up the good work.


Rating: 8/10

=item L<Script::State>

Author: L<MOTEMEN|https://metacpan.org/author/MOTEMEN>

Nice idea, straight and simple interface. A better name could perhaps be chosen? Documentation should be expanded, e.g. to warn users about security, since Data::Dumper a.k.a. eval() is used to load variable content. Also, the implementation does not yet consider file locking.


=item L<PathTools>

I guess File::Spec's API is sane enough, but I suspect not a lot of people are using it because there's not enough incentive for it. When 99% population of the world use Unix/Linux/Windows (even Macs been technically Unix for a number of years), &quot;/&quot; works everywhere and using File::Spec does not gain you anything except lots of typing exercise.
<br><br>That's why I think Path::Class might have a better chance of succeeding. It gives niceties like a few more convenience methods, a shortcut of getting dir &amp; file object from each other, etc. It gives users more incentive of using a proper path manipulation library because it gives extra stuff along with that. It should also be in core to accompany File::Spec.


Rating: 8/10

=item L<File::Slurp>

Author: L<CAPOEIRAB|https://metacpan.org/author/CAPOEIRAB>

I've been using File::Slurp for years and is generally satisfied with it. However reading the negative reviews today and looking at its RT queue, I realize that this module is broken for many and is effectively abandoned by the maintainer (no new releases for almost 3 years now despite several RT items labeled as critical). So I suggest others checking out the alternatives.


Rating: 2/10

=item L<Log::Log4perl>

Author: L<ETJ|https://metacpan.org/author/ETJ>

It's a very mature and an excellent logging framework. However, some of the common minor complaints are: 1) It's too complex. I agree: it should not be this hard to get started. 2) Configuration is too verbose. Agreed: but well, what can you do, most things from Java is a bit overengineered and verbose anyway. At least you can do almost anything with the configuration. 3) It's not very Perlish. Also agreed. 4) Performance. My note: speed is not an issue in majority of the cases and Log4perl's performance is adequate for most of the rest of the cases. For faster/leaner alternatives you might want to take a look at Log::Fast, but a lot of Log4perl's features are missing.
<br><br>One of the main strengths of Log4perl is its sublogger/subcategory feature, which few other frameworks seem to have.
<br><br>For other alternatives, also take a look at: Log::Handler, Log::Any. And of course Log::Message too.
<br>


=item L<Log::Handler>

Author: L<BLOONIX|https://metacpan.org/author/BLOONIX>

This review mostly compares Log::Handler with Log4perl, which is a mature and one of the most popular logging frameworks.
<br><br>I think Log::Handler's interface is much simpler, nicer, more Perlish than Log4perl. It's a bit similar to Log::Any::App, which I created just because I hate Log4perl configuration.
<br><br>There is a unique concept of maxlevel not normally found in other frameworks, though it can be emulated in other frameworks using filters.
<br><br>At a quick glance, the speed is around twice that of Log::Log4perl, so I'll say it's on the low-end side (there are other much faster logging modules, but anyway speed is not an issue to most people).
<br><br>It currently lacks sublogger (hierarchical categorization and adjustable/automatic appending of subcategory to its parent), so it cannot be used to replace Log4perl in most cases as that's one of the main feature of Log4perl. Which is a pity because I would otherwise switch.


Rating: 8/10

=item L<Log::Fast>

Author: L<POWERMAN|https://metacpan.org/author/POWERMAN>

This logging framework is also minimalistic: no categories/hierarchiecal loggers, no custom levels, no config file, or other whistles and bells. And the interface &amp; default levels are rather syslog-oriented. But it's fast alright. The POD doesn't mention a comparison to Log::Log4perl, but a casual benchmark shows that it's at least 10x faster.
<br><br>So this module will certainly come handy if you have a performance critical application.
<br><br>Btw, note that the benchmarks are done for actual logging to output. For log statements that do not actually get logged (e.g. because the level is below the desired output level), I don't find that extreme  differences in overhead between logging frameworks. For example, on my Athlon64 X2 5600+ PC, Log::Fast's overhead is roughly around 3mils/sec, while Log::Log4perl is around 1,5mils/sec.


=item L<Log::Minimal>

Author: L<KAZEBURO|https://metacpan.org/author/KAZEBURO>

Log::Minimal's slogan is &quot;minimal but customizable&quot;. It's minimal alright, probably only suitable for simple scripts as the moment you organize your application/library into separate modules, you'll want/need categories instead of just level, which is not provided by Log::Minimal.
<br><br>Also, only formats is customizable, there is currently no way to customize level. And the levels are &quot;not standard&quot; (not that there is an official authoritative standard, but the popular convention is TRACE/DEBUG/INFO/WARN/ERROR/FATAL and NONE). Log::Minimal's levels are 
<br>
DEBUG/INFO/WARN/CRITICAL and NONE). Surely most people would expect another level between WARN and CRITICAL, for non-critical errors? But that is actually just a matter of taste.
<br>


Rating: 4/10

=item L<Log::Fine>

Author: L<CFUHRMAN|https://metacpan.org/author/CFUHRMAN>

Log::Fine is touted as a framework for those who &quot;need a fine-grained logging mechanism in their program(s)&quot;. But apart from the emphasis on custom levels, to me there is nothing extra fine-grained about it. The other thing it provides is categories/namespace, which is also supported by a lot of other frameworks. So I fail to see the benefit/uniqueness of Log::Fine.
<br><br>Btw regarding custom levels, this practice is long deprecated by log4j (and thus also by Log4perl, although Log4perl can do custom levels). I can understand this decision as I sometimes already have trouble managing the popular convention of 6 levels (FATAL/ERROR/WARN/INFO/DEBUG/TRACE) as it is, much less with custom levels!


Rating: 6/10

=item L<Config::IniFiles>

Author: L<SHLOMIF|https://metacpan.org/author/SHLOMIF>

This module has been developed for more than a decade and seen different maintainers over the years. The codebase is indeed showing these, with different capitalization and indentation styles, among other things.
<br><br>However, among more than a dozen or so of INI modules in CPAN, ironically there seems to be few other choices if you go beyond the most basic feature set. Some INI modules can only simplistically rewrite/dump the whole INI structure and thus lose comments/orders, while others can't even write INI files.
<br><br>Config::IniFiles by far offers the most options and features, like dealing with line continuation, case sensitivity, default section, multiline/array, deltas, etc. So for now, despite all of its quirks, this module is still hard to beat.
<br><br>There's another nice little INI module that can do read/set/delete/unset (instead of just read/dump): Prima::IniFile, but it is included in a totally unrelated distribution.


Rating: 8/10

=item L<DateTime>

Author: L<DROLSKY|https://metacpan.org/author/DROLSKY>

Amidst all the glowing reviews may I add a reminder that, as with everything, there's a catch: runtime performance. On my PC, the speed of creating a DateTime object is just around 6000/sec. If you use DateTime intensively, it can quickly add up.
<br><br>Imagine serving a web page that fetches 50 rows from database, where for convenience you convert each date column to a DateTime object, and you have 120 requests/sec coming in... That's already 6000 objects (an extra second!).
<br><br>Which is unfortunate because DateTime is so wonderful, convenient, correct, complete and all that. So one approach you can use might be to delay converting to DateTime object until necessary.


=item L<Date::Manip>

Author: L<SBECK|https://metacpan.org/author/SBECK>

Wow, there are surely a lot of negative reviews ...
<br><br>First of all, Date::Manip has a long history. I used this module back in 2001-2002, IIRC. Back then it was I<the> swiss army of date/time manipulation, something you use when you want the most flexible/complete thing in Perl. True, it's slow, but it works.
<br><br>But then things change. DateTime project was started, and now it is somewhat the de facto standard. It's more modern and far more modular than the monolithic Date::Manip (every timezone and language support and parsing/formatting modules shipped in one single distribution).
<br><br>And then there's the 5.x -&gt; 6.x debacle. As someone who also sprinkle Perl 5.10 requirements to his CPAN modules, I can feel for the author. But the difference is, most of my modules are not that widely used/known, and also many start its life already requiring 5.10 right from its first released version. While in Date::Manip's case, this happens to a very widely used module. Surely backwards compatibility should be considered more.
<br><br>All in all, you are free to use or not use Date::Manip. There are other alternatives. Pick wisely.
<br>


Rating: 6/10

=item L<App::pmuninstall>

Author: L<XAICRON|https://metacpan.org/author/XAICRON>

One would wonder why CPAN clients still don't have this crucial feature Though you see Miyagawa listed in the Credits so maybe cpanminus or its sister will end up having this functionality? One can only hope. At 0.06, some things are not working flawlessly (submitted in RT). Keep up the good work!
<br><br>


=item L<App::lntree>

Author: L<ROKR|https://metacpan.org/author/ROKR>

I guess this app is still useful, since &quot;cp -sR&quot; still doesn't work as many would expect, and there are Windows users out there (yes, newer NTFS does support symlinks; though I don't know whether this module supports creating symlinks on NTFS).
<br><br>A minor comment would be on the name, maybe lnstree can be considered instead (since &quot;ln&quot; indicates hardlink, at least for me). Btw, there's also a free software called &quot;lns&quot; to do the exact same thing.
<br><br>


=item L<Data::Clone>

Author: L<GFUJI|https://metacpan.org/author/GFUJI>

I've never encountered difficulty in cloning data structures in Perl, usually I just use Clone or sometimes Storable's freeze + thaw (the later does not yet support cloning Regexp objects out of the box).
<br><br>However, I like Data::Clone for its speed! It's several times faster than Clone or freeze+thaw. So hats up. Planning to use Data::Clone in future projects.
<br><br>Now if we can convince Goro to write a fast serializer/deserializer with compact output (essentially, a faster version of Storable), that would be even nicer :-)
<br><br>


=item L<Data::Pond>

Author: L<ZEFRAM|https://metacpan.org/author/ZEFRAM>

With due respect to the author, I fail to see the practical point of Pond. Pond (Perl-based open notation for data) is the Perl counterpart of JSON, except that implementation is currently only available in Perl (CMIIW), and &quot;Pond represents fewer data types directly&quot;.
<br><br>Pond is pitched against Data::Dumper + eval, which is dangerous, but Data::Dumper + eval is by far not the only method available for serialization. Perl can do Storable, JSON, YAML, even PHP serialization format.
<br><br>The documentation does not show what Pond looks like.
<br><br>One cute thing about Pond is that you can check Pond syntax using a single regex. But apart from that, there's nothing compelling in using Pond to serialize data.


Rating: 4/10

=item L<File::Which>

Author: L<PLICEASE|https://metacpan.org/author/PLICEASE>

You can always count on CPAN to have prewritten modules for various things, including this one. I've never bothered before about portability and just rely on the &quot;which&quot; command, but for one reason there's a time when I just couldn't do that.
<br><br>Btw, there's also File::Which::Cached.


=item L<String::ShellQuote>

Author: L<ROSCH|https://metacpan.org/author/ROSCH>

I admit it. Ever since I know about escapeshellarg() and escapeshellcmd() in PHP, I've been reimplementing this function in Perl  literally a million of times (mostly because of laziness and because it only takes a couple of lines in Perl). Only a few months ago after the millionth time I said enough is enough and started to look around in CPAN, and found this module.
<br><br>The only problem for this module is lack of visibility. Before I've never read articles or blog posts mentioning this module, ever. Yes, we have system() that can bypass the shell, but qx() can't. So yes, this module needs to be marketed more!
<br>


=item L<Capture::Tiny>

Author: L<DAGOLDEN|https://metacpan.org/author/DAGOLDEN>

Another very handy little module that takes the hassle out of figuring the various mechanisms of capturing output.
<br><br>Nice interface, great documentation, very easy to use. But....
<br><br>Currently it cannot just capture stdout I<ONLY> or stderr I<ONLY> (while leaving the other alone). I believe this is one of the most commonly requested feature (already in RT). If that feature is implemented, this module deservers a 7-star rating.


Rating: 8/10

=item L<File::chdir>

Author: L<DAGOLDEN|https://metacpan.org/author/DAGOLDEN>

This is a handy little module, with a simple and nice interface. One of the more common bugs encountered in my scripts is forgetting to track the current working directory after doing chdir() in subroutines. By localizing $CWD, I don't have to worry that subroutines mess up current working directory anymore.


=back

=head1 FAQ

=head2 What is an Acme::CPANModules::* module?

An Acme::CPANModules::* module, like this module, contains just a list of module
names that share a common characteristics. It is a way to categorize modules and
document CPAN. See L<Acme::CPANModules> for more details.

=head2 What are ways to use this Acme::CPANModules module?

Aside from reading this Acme::CPANModules module's POD documentation, you can
install all the listed modules (entries) using L<cpanm-cpanmodules> script (from
L<App::cpanm::cpanmodules> distribution):

 % cpanm-cpanmodules -n Import::CPANRatings::User::stevenharyanto

Alternatively you can use the L<cpanmodules> CLI (from L<App::cpanmodules>
distribution):

    % cpanmodules ls-entries Import::CPANRatings::User::stevenharyanto | cpanm -n

or L<Acme::CM::Get>:

    % perl -MAcme::CM::Get=Import::CPANRatings::User::stevenharyanto -E'say $_->{module} for @{ $LIST->{entries} }' | cpanm -n

or directly:

    % perl -MAcme::CPANModules::Import::CPANRatings::User::stevenharyanto -E'say $_->{module} for @{ $Acme::CPANModules::Import::CPANRatings::User::stevenharyanto::LIST->{entries} }' | cpanm -n

This Acme::CPANModules module also helps L<lcpan> produce a more meaningful
result for C<lcpan related-mods> command when it comes to finding related
modules for the modules listed in this Acme::CPANModules module.
See L<App::lcpan::Cmd::related_mods> for more details on how "related modules"
are found.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANModules-Import-CPANRatings-User-stevenharyanto>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANModules-Import-CPANRatings-User-stevenharyanto>.

=head1 SEE ALSO

L<Acme::CPANModules> - about the Acme::CPANModules namespace

L<cpanmodules> - CLI tool to let you browse/view the lists

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2018 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANModules-Import-CPANRatings-User-stevenharyanto>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
