# -*- mode: perl; coding: utf-8; tab-width: 4; -*-

package Cv::Constant;
use lib qw(blib/lib blib/arch);

use 5.008000;
use strict;
use warnings;
use Carp;
use Scalar::Util qw(blessed);
use Data::Dumper;

BEGIN {
	$Data::Dumper::Terse = 1;
}

require Exporter;

our @ISA = qw(Exporter);

use constant {
	CV_16S => 3,
	CV_16SC1 => 3,
	CV_16SC2 => 11,
	CV_16SC3 => 19,
	CV_16SC4 => 27,
	CV_16U => 2,
	CV_16UC1 => 2,
	CV_16UC2 => 10,
	CV_16UC3 => 18,
	CV_16UC4 => 26,
	CV_32F => 5,
	CV_32FC1 => 5,
	CV_32FC2 => 13,
	CV_32FC3 => 21,
	CV_32FC4 => 29,
	CV_32S => 4,
	CV_32SC1 => 4,
	CV_32SC2 => 12,
	CV_32SC3 => 20,
	CV_32SC4 => 28,
	CV_64F => 6,
	CV_64FC1 => 6,
	CV_64FC2 => 14,
	CV_64FC3 => 22,
	CV_64FC4 => 30,
	CV_8S => 1,
	CV_8SC1 => 1,
	CV_8SC2 => 9,
	CV_8SC3 => 17,
	CV_8SC4 => 25,
	CV_8U => 0,
	CV_8UC1 => 0,
	CV_8UC2 => 8,
	CV_8UC3 => 16,
	CV_8UC4 => 24,
	CV_AA => 16,
	CV_ADAPTIVE_THRESH_GAUSSIAN_C => 1,
	CV_ADAPTIVE_THRESH_MEAN_C => 0,
	CV_ARRAY => 2,
	CV_AUTOSTEP => 2147483647,
	CV_AUTO_STEP => 2147483647,
	CV_BACK => 0,
	CV_BGFG_FGD_ALPHA_1 => 0,
	CV_BGFG_FGD_ALPHA_2 => 0,
	CV_BGFG_FGD_ALPHA_3 => 0,
	CV_BGFG_FGD_BG_UPDATE_TRESH => 0,
	CV_BGFG_FGD_DELTA => 2,
	CV_BGFG_FGD_LC => 128,
	CV_BGFG_FGD_LCC => 64,
	CV_BGFG_FGD_MINAREA => 15,
	CV_BGFG_FGD_N1C => 15,
	CV_BGFG_FGD_N1CC => 25,
	CV_BGFG_FGD_N2C => 25,
	CV_BGFG_FGD_N2CC => 40,
	CV_BGFG_FGD_T => 0,
	CV_BGFG_MOG_BACKGROUND_THRESHOLD => 0,
	CV_BGFG_MOG_MAX_NGAUSSIANS => 500,
	CV_BGFG_MOG_MINAREA => 15,
	CV_BGFG_MOG_NCOLORS => 3,
	CV_BGFG_MOG_NGAUSSIANS => 5,
	CV_BGFG_MOG_SIGMA_INIT => 30,
	CV_BGFG_MOG_STD_THRESHOLD => 2,
	CV_BGFG_MOG_WEIGHT_INIT => 0,
	CV_BGFG_MOG_WINDOW_SIZE => 200,
	CV_BGR2BGR555 => 22,
	CV_BGR2BGR565 => 12,
	CV_BGR2BGRA => 0,
	CV_BGR2GRAY => 6,
	CV_BGR2HLS => 52,
	CV_BGR2HSV => 40,
	CV_BGR2Lab => 44,
	CV_BGR2Luv => 50,
	CV_BGR2RGB => 4,
	CV_BGR2RGBA => 2,
	CV_BGR2XYZ => 32,
	CV_BGR2YCrCb => 36,
	CV_BGR5552BGR => 24,
	CV_BGR5552BGRA => 28,
	CV_BGR5552GRAY => 31,
	CV_BGR5552RGB => 25,
	CV_BGR5552RGBA => 29,
	CV_BGR5652BGR => 14,
	CV_BGR5652BGRA => 18,
	CV_BGR5652GRAY => 21,
	CV_BGR5652RGB => 15,
	CV_BGR5652RGBA => 19,
	CV_BGRA2BGR => 1,
	CV_BGRA2BGR555 => 26,
	CV_BGRA2BGR565 => 16,
	CV_BGRA2GRAY => 10,
	CV_BGRA2RGB => 3,
	CV_BGRA2RGBA => 5,
	CV_BG_MODEL_FGD => 0,
	CV_BG_MODEL_FGD_SIMPLE => 2,
	CV_BG_MODEL_MOG => 1,
	CV_BILATERAL => 4,
	CV_BLUR => 1,
	CV_BLUR_NO_SCALE => 0,
	CV_BadAlign => -21,
	CV_BadAlphaChannel => -18,
	CV_BadCOI => -24,
	CV_BadCallBack => -22,
	CV_BadDataPtr => -12,
	CV_BadDepth => -17,
	CV_BadImageSize => -10,
	CV_BadModelOrChSeq => -14,
	CV_BadNumChannel1U => -16,
	CV_BadNumChannels => -15,
	CV_BadOffset => -11,
	CV_BadOrder => -19,
	CV_BadOrigin => -20,
	CV_BadROISize => -25,
	CV_BadStep => -13,
	CV_BadTileSize => -23,
	CV_BayerBG2BGR => 46,
	CV_BayerBG2RGB => 48,
	CV_BayerGB2BGR => 47,
	CV_BayerGB2RGB => 49,
	CV_BayerGR2BGR => 49,
	CV_BayerGR2RGB => 47,
	CV_BayerRG2BGR => 48,
	CV_BayerRG2RGB => 46,
	CV_C => 1,
	CV_CALIB_CB_ADAPTIVE_THRESH => 1,
	CV_CALIB_CB_FILTER_QUADS => 4,
	CV_CALIB_CB_NORMALIZE_IMAGE => 2,
	CV_CALIB_FIX_ASPECT_RATIO => 2,
	CV_CALIB_FIX_FOCAL_LENGTH => 16,
	CV_CALIB_FIX_INTRINSIC => 256,
	CV_CALIB_FIX_K1 => 32,
	CV_CALIB_FIX_K2 => 64,
	CV_CALIB_FIX_K3 => 128,
	CV_CALIB_FIX_PRINCIPAL_POINT => 4,
	CV_CALIB_SAME_FOCAL_LENGTH => 512,
	CV_CALIB_USE_INTRINSIC_GUESS => 1,
	CV_CALIB_ZERO_DISPARITY => 1024,
	CV_CALIB_ZERO_TANGENT_DIST => 8,
	CV_CAMERA_TO_WARP => 1,
	CV_CANNY_L2_GRADIENT => -2147483648,
	CV_CAP_ANY => 0,
	CV_CAP_CMU1394 => 300,
	CV_CAP_DC1394 => 300,
	CV_CAP_DSHOW => 700,
	CV_CAP_FIREWARE => 300,
	CV_CAP_FIREWIRE => 300,
	CV_CAP_IEEE1394 => 300,
	CV_CAP_MIL => 100,
	CV_CAP_PROP_BRIGHTNESS => 10,
	CV_CAP_PROP_CONTRAST => 11,
	CV_CAP_PROP_CONVERT_RGB => 15,
	CV_CAP_PROP_FORMAT => 8,
	CV_CAP_PROP_FOURCC => 6,
	CV_CAP_PROP_FPS => 5,
	CV_CAP_PROP_FRAME_COUNT => 7,
	CV_CAP_PROP_FRAME_HEIGHT => 4,
	CV_CAP_PROP_FRAME_WIDTH => 3,
	CV_CAP_PROP_GAIN => 14,
	CV_CAP_PROP_HUE => 13,
	CV_CAP_PROP_MODE => 9,
	CV_CAP_PROP_POS_AVI_RATIO => 2,
	CV_CAP_PROP_POS_FRAMES => 1,
	CV_CAP_PROP_POS_MSEC => 0,
	CV_CAP_PROP_SATURATION => 12,
	CV_CAP_QT => 500,
	CV_CAP_STEREO => 400,
	CV_CAP_TYZX => 400,
	CV_CAP_UNICAP => 600,
	CV_CAP_V4L => 200,
	CV_CAP_V4L2 => 200,
	CV_CAP_VFW => 200,
	CV_CHAIN_APPROX_NONE => 1,
	CV_CHAIN_APPROX_SIMPLE => 2,
	CV_CHAIN_APPROX_TC89_KCOS => 4,
	CV_CHAIN_APPROX_TC89_L1 => 3,
	CV_CHAIN_CODE => 0,
	CV_CHECK_QUIET => 2,
	CV_CHECK_RANGE => 1,
	CV_CLOCKWISE => 1,
	CV_CMP_EQ => 0,
	CV_CMP_GE => 2,
	CV_CMP_GT => 1,
	CV_CMP_LE => 4,
	CV_CMP_LT => 3,
	CV_CMP_NE => 5,
	CV_CN_MAX => 64,
	CV_CN_SHIFT => 3,
	CV_COLORCVT_MAX => 100,
	CV_COMP_BHATTACHARYYA => 3,
	CV_COMP_CHISQR => 1,
	CV_COMP_CORREL => 0,
	CV_COMP_INTERSECT => 2,
	CV_CONTOURS_MATCH_I1 => 1,
	CV_CONTOURS_MATCH_I2 => 2,
	CV_CONTOURS_MATCH_I3 => 3,
	CV_CONTOUR_TREES_MATCH_I1 => 1,
	CV_COUNTER_CLOCKWISE => 2,
	CV_COVAR_COLS => 16,
	CV_COVAR_NORMAL => 1,
	CV_COVAR_ROWS => 8,
	CV_COVAR_SCALE => 4,
	CV_COVAR_SCRAMBLED => 0,
	CV_COVAR_USE_AVG => 2,
	CV_CVTIMG_FLIP => 1,
	CV_CVTIMG_SWAP_RB => 2,
	CV_DEPTH_MAX => 8,
	CV_DIFF => 16,
	CV_DIFF_C => 17,
	CV_DIFF_L1 => 18,
	CV_DIFF_L2 => 20,
	CV_DISPARITY_BIRCHFIELD => 0,
	CV_DIST_C => 3,
	CV_DIST_FAIR => 5,
	CV_DIST_HUBER => 7,
	CV_DIST_L1 => 1,
	CV_DIST_L12 => 4,
	CV_DIST_L2 => 2,
	CV_DIST_MASK_3 => 3,
	CV_DIST_MASK_5 => 5,
	CV_DIST_MASK_PRECISE => 0,
	CV_DIST_USER => -1,
	CV_DIST_WELSCH => 6,
	CV_DOMINANT_IPAN => 1,
	CV_DXT_FORWARD => 0,
	CV_DXT_INVERSE => 1,
	CV_DXT_INVERSE_SCALE => 3,
	CV_DXT_INV_SCALE => 3,
	CV_DXT_MUL_CONJ => 8,
	CV_DXT_ROWS => 4,
	CV_DXT_SCALE => 2,
	CV_EIGOBJ_BOTH_CALLBACK => 3,
	CV_EIGOBJ_INPUT_CALLBACK => 1,
	CV_EIGOBJ_NO_CALLBACK => 0,
	CV_EIGOBJ_OUTPUT_CALLBACK => 2,
	CV_EVENT_FLAG_ALTKEY => 32,
	CV_EVENT_FLAG_CTRLKEY => 8,
	CV_EVENT_FLAG_LBUTTON => 1,
	CV_EVENT_FLAG_MBUTTON => 4,
	CV_EVENT_FLAG_RBUTTON => 2,
	CV_EVENT_FLAG_SHIFTKEY => 16,
	CV_EVENT_LBUTTONDBLCLK => 7,
	CV_EVENT_LBUTTONDOWN => 1,
	CV_EVENT_LBUTTONUP => 4,
	CV_EVENT_MBUTTONDBLCLK => 9,
	CV_EVENT_MBUTTONDOWN => 3,
	CV_EVENT_MBUTTONUP => 6,
	CV_EVENT_MOUSEMOVE => 0,
	CV_EVENT_RBUTTONDBLCLK => 8,
	CV_EVENT_RBUTTONDOWN => 2,
	CV_EVENT_RBUTTONUP => 5,
	CV_ErrModeLeaf => 0,
	CV_ErrModeParent => 1,
	CV_ErrModeSilent => 2,
	CV_FILLED => -1,
	CV_FLOODFILL_FIXED_RANGE => 65536,
	CV_FLOODFILL_MASK_ONLY => 131072,
	CV_FM_7POINT => 1,
	CV_FM_8POINT => 2,
	CV_FM_LMEDS => 4,
	CV_FM_LMEDS_ONLY => 4,
	CV_FM_RANSAC => 8,
	CV_FM_RANSAC_ONLY => 8,
	CV_FONT_HERSHEY_COMPLEX => 3,
	CV_FONT_HERSHEY_COMPLEX_SMALL => 5,
	CV_FONT_HERSHEY_DUPLEX => 2,
	CV_FONT_HERSHEY_PLAIN => 1,
	CV_FONT_HERSHEY_SCRIPT_COMPLEX => 7,
	CV_FONT_HERSHEY_SCRIPT_SIMPLEX => 6,
	CV_FONT_HERSHEY_SIMPLEX => 0,
	CV_FONT_HERSHEY_TRIPLEX => 4,
	CV_FONT_ITALIC => 16,
	CV_FONT_VECTOR0 => 0,
	CV_FOURCC_DEFAULT => -1,
	CV_FOURCC_PROMPT => -1,
	CV_FRONT => 1,
	CV_GAUSSIAN => 2,
	CV_GEMM_A_T => 1,
	CV_GEMM_B_T => 2,
	CV_GEMM_C_T => 4,
	CV_GLCMDESC_CLUSTERSHADE => 5,
	CV_GLCMDESC_CLUSTERTENDENCY => 4,
	CV_GLCMDESC_CONTRAST => 3,
	CV_GLCMDESC_CORRELATION => 6,
	CV_GLCMDESC_CORRELATIONINFO1 => 7,
	CV_GLCMDESC_CORRELATIONINFO2 => 8,
	CV_GLCMDESC_ENERGY => 1,
	CV_GLCMDESC_ENTROPY => 0,
	CV_GLCMDESC_HOMOGENITY => 2,
	CV_GLCMDESC_MAXIMUMPROBABILITY => 9,
	CV_GLCMDESC_OPTIMIZATION_ALLOWDOUBLENEST => 10,
	CV_GLCMDESC_OPTIMIZATION_ALLOWTRIPLENEST => 11,
	CV_GLCMDESC_OPTIMIZATION_HISTOGRAM => 4,
	CV_GLCM_ALL => 0,
	CV_GLCM_DESC => 2,
	CV_GLCM_GLCM => 1,
	CV_GLCM_OPTIMIZATION_HISTOGRAM => 0,
	CV_GLCM_OPTIMIZATION_LUT => -1,
	CV_GLCM_OPTIMIZATION_NONE => -2,
	CV_GRAPH => 1536,
	CV_GRAPH_ALL_ITEMS => -1,
	CV_GRAPH_ANY_EDGE => 30,
	CV_GRAPH_BACKTRACKING => 64,
	CV_GRAPH_BACK_EDGE => 4,
	CV_GRAPH_CROSS_EDGE => 16,
	CV_GRAPH_FLAG_ORIENTED => 4096,
	CV_GRAPH_FORWARD_EDGE => 8,
	CV_GRAPH_FORWARD_EDGE_FLAG => 268435456,
	CV_GRAPH_ITEM_VISITED_FLAG => 1073741824,
	CV_GRAPH_NEW_TREE => 32,
	CV_GRAPH_OVER => -1,
	CV_GRAPH_SEARCH_TREE_NODE_FLAG => 536870912,
	CV_GRAPH_TREE_EDGE => 2,
	CV_GRAPH_VERTEX => 1,
	CV_GRAY2BGR => 8,
	CV_GRAY2BGR555 => 30,
	CV_GRAY2BGR565 => 20,
	CV_GRAY2BGRA => 9,
	CV_GRAY2RGB => 8,
	CV_GRAY2RGBA => 9,
	CV_HAAR_DO_CANNY_PRUNING => 1,
	CV_HAAR_DO_ROUGH_SEARCH => 8,
	CV_HAAR_FEATURE_MAX => 3,
	CV_HAAR_FIND_BIGGEST_OBJECT => 4,
	CV_HAAR_MAGIC_VAL => 1112539136,
	CV_HAAR_SCALE_IMAGE => 2,
	CV_HIST_ARRAY => 0,
	CV_HIST_MAGIC_VAL => 1111818240,
	CV_HIST_RANGES_FLAG => 2048,
	CV_HIST_SPARSE => 1,
	CV_HIST_TREE => 1,
	CV_HIST_UNIFORM => 1,
	CV_HIST_UNIFORM_FLAG => 1024,
	CV_HLS2BGR => 60,
	CV_HLS2RGB => 61,
	CV_HOUGH_GRADIENT => 3,
	CV_HOUGH_MULTI_SCALE => 2,
	CV_HOUGH_PROBABILISTIC => 1,
	CV_HOUGH_STANDARD => 0,
	CV_HSV2BGR => 54,
	CV_HSV2RGB => 55,
	CV_HeaderIsNull => -9,
	CV_IDP_BIRCHFIELD_PARAM1 => 25,
	CV_IDP_BIRCHFIELD_PARAM2 => 5,
	CV_IDP_BIRCHFIELD_PARAM3 => 12,
	CV_IDP_BIRCHFIELD_PARAM4 => 15,
	CV_IDP_BIRCHFIELD_PARAM5 => 25,
	CV_INPAINT_NS => 0,
	CV_INPAINT_TELEA => 1,
	CV_INTER_AREA => 3,
	CV_INTER_CUBIC => 2,
	CV_INTER_LINEAR => 1,
	CV_INTER_NN => 0,
	CV_L1 => 2,
	CV_L2 => 4,
	CV_LINK_RUNS => 5,
	CV_LKFLOW_GET_MIN_EIGENVALS => 8,
	CV_LKFLOW_INITIAL_GUESSES => 4,
	CV_LKFLOW_PYR_A_READY => 1,
	CV_LKFLOW_PYR_B_READY => 2,
	CV_LMEDS => 4,
	CV_LOAD_IMAGE_ANYCOLOR => 4,
	CV_LOAD_IMAGE_ANYDEPTH => 2,
	CV_LOAD_IMAGE_COLOR => 1,
	CV_LOAD_IMAGE_GRAYSCALE => 0,
	CV_LOAD_IMAGE_UNCHANGED => -1,
	CV_LOG2 => 0.69314718055994530941723212145818,
	CV_LSQ => 8,
	CV_LU => 0,
	CV_Lab2BGR => 56,
	CV_Lab2RGB => 57,
	CV_Luv2BGR => 58,
	CV_Luv2RGB => 59,
	CV_MAGIC_MASK => 4294901760,
	#CV_MAJOR_VERSION => 1,
	CV_MAT32F => 5,
	CV_MAT3x1_32F => 5,
	CV_MAT3x1_64D => 6,
	CV_MAT3x3_32F => 5,
	CV_MAT3x3_64D => 6,
	CV_MAT4x1_32F => 5,
	CV_MAT4x1_64D => 6,
	CV_MAT4x4_32F => 5,
	CV_MAT4x4_64D => 6,
	CV_MAT64D => 6,
	CV_MATND_MAGIC_VAL => 1111687168,
	CV_MAT_CN_MASK => 504,
	CV_MAT_CONT_FLAG => 16384,
	CV_MAT_CONT_FLAG_SHIFT => 14,
	CV_MAT_DEPTH_MASK => 7,
	CV_MAT_MAGIC_VAL => 1111621632,
	CV_MAT_TEMP_FLAG => 32768,
	CV_MAT_TEMP_FLAG_SHIFT => 15,
	CV_MAT_TYPE_MASK => 511,
	CV_MAX_ARR => 10,
	CV_MAX_DIM => 32,
	CV_MAX_DIM_HEAP => 65536,
	CV_MAX_SOBEL_KSIZE => 7,
	CV_MEDIAN => 3,
	CV_MINMAX => 32,
	#CV_MINOR_VERSION => 1,
	CV_MOP_BLACKHAT => 6,
	CV_MOP_CLOSE => 3,
	CV_MOP_GRADIENT => 4,
	CV_MOP_OPEN => 2,
	CV_MOP_TOPHAT => 5,
	CV_MaskIsTiled => -26,
	CV_NODE_EMPTY => 32,
	CV_NODE_FLOAT => 2,
	CV_NODE_FLOW => 8,
	CV_NODE_INT => 1,
	CV_NODE_INTEGER => 1,
	CV_NODE_MAP => 6,
	CV_NODE_NAMED => 64,
	CV_NODE_NONE => 0,
	CV_NODE_REAL => 2,
	CV_NODE_REF => 4,
	CV_NODE_SEQ => 5,
	CV_NODE_SEQ_SIMPLE => 256,
	CV_NODE_STR => 3,
	CV_NODE_STRING => 3,
	CV_NODE_TYPE_MASK => 7,
	CV_NODE_USER => 16,
	CV_NORM_MASK => 7,
	CV_NO_CN_CHECK => 2,
	CV_NO_DEPTH_CHECK => 1,
	CV_NO_SIZE_CHECK => 4,
	CV_NUM_FACE_ELEMENTS => 3,
	CV_ORIENTED_GRAPH => 5632,
	CV_PCA_DATA_AS_COL => 1,
	CV_PCA_DATA_AS_ROW => 0,
	CV_PCA_USE_AVG => 2,
	CV_PI => 3.1415926535897932384626433832795,
	CV_POLY_APPROX_DP => 0,
	CV_RAND_NORMAL => 1,
	CV_RAND_UNI => 0,
	CV_RANSAC => 8,
	CV_REDUCE_AVG => 1,
	CV_REDUCE_MAX => 2,
	CV_REDUCE_MIN => 3,
	CV_REDUCE_SUM => 0,
	CV_RELATIVE => 8,
	CV_RELATIVE_C => 9,
	CV_RELATIVE_L1 => 10,
	CV_RELATIVE_L2 => 12,
	CV_RETR_CCOMP => 2,
	CV_RETR_EXTERNAL => 0,
	CV_RETR_LIST => 1,
	CV_RETR_TREE => 3,
	CV_RGB2BGR => 4,
	CV_RGB2BGR555 => 23,
	CV_RGB2BGR565 => 13,
	CV_RGB2BGRA => 2,
	CV_RGB2GRAY => 7,
	CV_RGB2HLS => 53,
	CV_RGB2HSV => 41,
	CV_RGB2Lab => 45,
	CV_RGB2Luv => 51,
	CV_RGB2RGBA => 0,
	CV_RGB2XYZ => 33,
	CV_RGB2YCrCb => 37,
	CV_RGBA2BGR => 3,
	CV_RGBA2BGR555 => 27,
	CV_RGBA2BGR565 => 17,
	CV_RGBA2BGRA => 5,
	CV_RGBA2GRAY => 11,
	CV_RGBA2RGB => 1,
	CV_RODRIGUES_M2V => 0,
	CV_RODRIGUES_V2M => 1,
	CV_SCHARR => -1,
	CV_SEQ_CHAIN => 512,
	CV_SEQ_CHAIN_CONTOUR => 4608,
	CV_SEQ_CONNECTED_COMP => 0,
	CV_SEQ_CONTOUR => 4620,
	CV_SEQ_ELTYPE_BITS => 9,
	CV_SEQ_ELTYPE_CODE => 0,
	CV_SEQ_ELTYPE_CONNECTED_COMP => 0,
	CV_SEQ_ELTYPE_GENERIC => 0,
	CV_SEQ_ELTYPE_GRAPH_EDGE => 0,
	CV_SEQ_ELTYPE_GRAPH_VERTEX => 0,
	CV_SEQ_ELTYPE_INDEX => 4,
	CV_SEQ_ELTYPE_MASK => 511,
	CV_SEQ_ELTYPE_POINT => 12,
	CV_SEQ_ELTYPE_POINT3D => 21,
	CV_SEQ_ELTYPE_PPOINT => 7,
	CV_SEQ_ELTYPE_PTR => 7,
	CV_SEQ_ELTYPE_TRIAN_ATR => 0,
	CV_SEQ_FLAG_CLOSED => 4096,
	CV_SEQ_FLAG_CONVEX => 16384,
	CV_SEQ_FLAG_HOLE => 32768,
	CV_SEQ_FLAG_SHIFT => 12,
	CV_SEQ_FLAG_SIMPLE => 8192,
	CV_SEQ_INDEX => 4,
	CV_SEQ_KIND_BIN_TREE => 1024,
	CV_SEQ_KIND_BITS => 3,
	CV_SEQ_KIND_CURVE => 512,
	CV_SEQ_KIND_GENERIC => 0,
	CV_SEQ_KIND_GRAPH => 1536,
	CV_SEQ_KIND_MASK => 3584,
	CV_SEQ_KIND_SUBDIV2D => 2048,
	CV_SEQ_MAGIC_VAL => 1117323264,
	CV_SEQ_POINT3D_SET => 21,
	CV_SEQ_POINT_SET => 12,
	CV_SEQ_POLYGON => 4620,
	CV_SEQ_POLYGON_TREE => 1024,
	CV_SEQ_POLYLINE => 524,
	CV_SEQ_SIMPLE_POLYGON => 12812,
	CV_SET_ELEM_FREE_FLAG => -2147483648,
	CV_SET_ELEM_IDX_MASK => 67108863,
	CV_SET_MAGIC_VAL => 1117257728,
	CV_SHAPE_CROSS => 1,
	CV_SHAPE_CUSTOM => 100,
	CV_SHAPE_ELLIPSE => 2,
	CV_SHAPE_RECT => 0,
	CV_SHIFT_DOWN => 10,
	CV_SHIFT_LD => 9,
	CV_SHIFT_LEFT => 1,
	CV_SHIFT_LU => 5,
	CV_SHIFT_NONE => 2,
	CV_SHIFT_RD => 11,
	CV_SHIFT_RIGHT => 3,
	CV_SHIFT_RU => 7,
	CV_SHIFT_UP => 6,
	CV_SORT_ASCENDING => 0,
	CV_SORT_DESCENDING => 16,
	CV_SORT_EVERY_COLUMN => 1,
	CV_SORT_EVERY_ROW => 0,
	CV_SPARSE_MAT_MAGIC_VAL => 1111752704,
	CV_SSE2 => 0,
	CV_STEREO_BM_BASIC => 0,
	CV_STEREO_BM_FISH_EYE => 1,
	CV_STEREO_BM_NARROW => 2,
	CV_STEREO_BM_NORMALIZED_RESPONSE => 0,
	CV_STEREO_GC_OCCLUDED => 32767,
	CV_STORAGE_APPEND => 2,
	CV_STORAGE_MAGIC_VAL => 1116274688,
	CV_STORAGE_READ => 0,
	CV_STORAGE_WRITE => 1,
	CV_STORAGE_WRITE_BINARY => 1,
	CV_STORAGE_WRITE_TEXT => 1,
	CV_SUBDIV2D_VIRTUAL_POINT_FLAG => 1073741824,
	#CV_SUBMINOR_VERSION => 0,
	CV_SVD => 1,
	CV_SVD_MODIFY_A => 1,
	CV_SVD_SYM => 2,
	CV_SVD_U_T => 2,
	CV_SVD_V_T => 4,
	CV_StsAutoTrace => -8,
	CV_StsBackTrace => -1,
	CV_StsBadArg => -5,
	CV_StsBadFlag => -206,
	CV_StsBadFunc => -6,
	CV_StsBadMask => -208,
	CV_StsBadMemBlock => -214,
	CV_StsBadPoint => -207,
	CV_StsBadSize => -201,
	CV_StsDivByZero => -202,
	CV_StsError => -2,
	CV_StsFilterOffsetErr => -31,
	CV_StsFilterStructContentErr => -29,
	CV_StsInplaceNotSupported => -203,
	CV_StsInternal => -3,
	CV_StsKernelStructContentErr => -30,
	CV_StsNoConv => -7,
	CV_StsNoMem => -4,
	CV_StsNotImplemented => -213,
	CV_StsNullPtr => -27,
	CV_StsObjectNotFound => -204,
	CV_StsOk => 0,
	CV_StsOutOfRange => -211,
	CV_StsParseError => -212,
	CV_StsUnmatchedFormats => -205,
	CV_StsUnmatchedSizes => -209,
	CV_StsUnsupportedFormat => -210,
	CV_StsVecLengthErr => -28,
	CV_TERMCRIT_EPS => 2,
	CV_TERMCRIT_ITER => 1,
	CV_TERMCRIT_NUMBER => 1,
	CV_THRESH_BINARY => 0,
	CV_THRESH_BINARY_INV => 1,
	CV_THRESH_MASK => 7,
	CV_THRESH_OTSU => 8,
	CV_THRESH_TOZERO => 3,
	CV_THRESH_TOZERO_INV => 4,
	CV_THRESH_TRUNC => 2,
	CV_TM_CCOEFF => 4,
	CV_TM_CCOEFF_NORMED => 5,
	CV_TM_CCORR => 2,
	CV_TM_CCORR_NORMED => 3,
	CV_TM_SQDIFF => 0,
	CV_TM_SQDIFF_NORMED => 1,
	CV_TYZX_COLOR => 402,
	CV_TYZX_LEFT => 400,
	CV_TYZX_RIGHT => 401,
	CV_TYZX_Z => 403,
	CV_UNDEF_SC_PARAM => 12345,
	CV_USRTYPE1 => 7,
	CV_VALUE => 1,
	CV_WARP_FILL_OUTLIERS => 8,
	CV_WARP_INVERSE_MAP => 16,
	CV_WARP_TO_CAMERA => 2,
	CV_WHOLE_SEQ_END_INDEX => 1073741823,
	CV_WINDOW_AUTOSIZE => 1,
	CV_XYZ2BGR => 34,
	CV_XYZ2RGB => 35,
	CV_YCrCb2BGR => 38,
	CV_YCrCb2RGB => 39,
	IPL_ALIGN_16BYTES => 16,
	IPL_ALIGN_32BYTES => 32,
	IPL_ALIGN_4BYTES => 4,
	IPL_ALIGN_8BYTES => 8,
	IPL_ALIGN_DWORD => 4,
	IPL_ALIGN_QWORD => 8,
	IPL_BORDER_CONSTANT => 0,
	IPL_BORDER_REFLECT => 2,
	IPL_BORDER_REFLECT_101 => 4,
	IPL_BORDER_REPLICATE => 1,
	IPL_BORDER_WRAP => 3,
	IPL_DATA_ORDER_PIXEL => 0,
	IPL_DATA_ORDER_PLANE => 1,
	IPL_DEPTH_16S => 2147483664,
	IPL_DEPTH_16U => 16,
	IPL_DEPTH_1U => 1,
	IPL_DEPTH_32F => 32,
	IPL_DEPTH_32S => 2147483680,
	IPL_DEPTH_64F => 64,
	IPL_DEPTH_8S => 2147483656,
	IPL_DEPTH_8U => 8,
	IPL_DEPTH_SIGN => 2147483648,
	IPL_GAUSSIAN_5x5 => 7,
	IPL_IMAGE_DATA => 2,
	IPL_IMAGE_HEADER => 1,
	IPL_IMAGE_MAGIC_VAL => 112,
	IPL_IMAGE_ROI => 4,
	IPL_ORIGIN_BL => 1,
	IPL_ORIGIN_TL => 0,
};

use constant {
	CV_WHOLE_SEQ => [ 0, CV_WHOLE_SEQ_END_INDEX ],
	CV_GAUSSIAN_5x5 => 7,

	# enum CvSubdiv2DPointLocation
    CV_PTLOC_ERROR => -2,
    CV_PTLOC_OUTSIDE_RECT => -1,
    CV_PTLOC_INSIDE => 0,
    CV_PTLOC_VERTEX => 1,
    CV_PTLOC_ON_EDGE => 2,

	# enum CvNextEdgeType
    CV_NEXT_AROUND_ORG   => 0x00,
    CV_NEXT_AROUND_DST   => 0x22,
    CV_PREV_AROUND_ORG   => 0x11,
    CV_PREV_AROUND_DST   => 0x33,
    CV_NEXT_AROUND_LEFT  => 0x13,
    CV_NEXT_AROUND_RIGHT => 0x31,
    CV_PREV_AROUND_LEFT  => 0x20,
    CV_PREV_AROUND_RIGHT => 0x02,
};


our @EXPORT = ( qw(

	CV_16S
	CV_16SC1
	CV_16SC2
	CV_16SC3
	CV_16SC4
	CV_16U
	CV_16UC1
	CV_16UC2
	CV_16UC3
	CV_16UC4
	CV_32F
	CV_32FC1
	CV_32FC2
	CV_32FC3
	CV_32FC4
	CV_32S
	CV_32SC1
	CV_32SC2
	CV_32SC3
	CV_32SC4
	CV_64F
	CV_64FC1
	CV_64FC2
	CV_64FC3
	CV_64FC4
	CV_8S
	CV_8SC1
	CV_8SC2
	CV_8SC3
	CV_8SC4
	CV_8U
	CV_8UC1
	CV_8UC2
	CV_8UC3
	CV_8UC4
	CV_AA
	CV_ADAPTIVE_THRESH_GAUSSIAN_C
	CV_ADAPTIVE_THRESH_MEAN_C
	CV_ARRAY
	CV_AUTOSTEP
	CV_AUTO_STEP
	CV_BACK
	CV_BGFG_FGD_ALPHA_1
	CV_BGFG_FGD_ALPHA_2
	CV_BGFG_FGD_ALPHA_3
	CV_BGFG_FGD_BG_UPDATE_TRESH
	CV_BGFG_FGD_DELTA
	CV_BGFG_FGD_LC
	CV_BGFG_FGD_LCC
	CV_BGFG_FGD_MINAREA
	CV_BGFG_FGD_N1C
	CV_BGFG_FGD_N1CC
	CV_BGFG_FGD_N2C
	CV_BGFG_FGD_N2CC
	CV_BGFG_FGD_T
	CV_BGFG_MOG_BACKGROUND_THRESHOLD
	CV_BGFG_MOG_MAX_NGAUSSIANS
	CV_BGFG_MOG_MINAREA
	CV_BGFG_MOG_NCOLORS
	CV_BGFG_MOG_NGAUSSIANS
	CV_BGFG_MOG_SIGMA_INIT
	CV_BGFG_MOG_STD_THRESHOLD
	CV_BGFG_MOG_WEIGHT_INIT
	CV_BGFG_MOG_WINDOW_SIZE
	CV_BGR2BGR555
	CV_BGR2BGR565
	CV_BGR2BGRA
	CV_BGR2GRAY
	CV_BGR2HLS
	CV_BGR2HSV
	CV_BGR2Lab
	CV_BGR2Luv
	CV_BGR2RGB
	CV_BGR2RGBA
	CV_BGR2XYZ
	CV_BGR2YCrCb
	CV_BGR5552BGR
	CV_BGR5552BGRA
	CV_BGR5552GRAY
	CV_BGR5552RGB
	CV_BGR5552RGBA
	CV_BGR5652BGR
	CV_BGR5652BGRA
	CV_BGR5652GRAY
	CV_BGR5652RGB
	CV_BGR5652RGBA
	CV_BGRA2BGR
	CV_BGRA2BGR555
	CV_BGRA2BGR565
	CV_BGRA2GRAY
	CV_BGRA2RGB
	CV_BGRA2RGBA
	CV_BG_MODEL_FGD
	CV_BG_MODEL_FGD_SIMPLE
	CV_BG_MODEL_MOG
	CV_BILATERAL
	CV_BLUR
	CV_BLUR_NO_SCALE
	CV_BadAlign
	CV_BadAlphaChannel
	CV_BadCOI
	CV_BadCallBack
	CV_BadDataPtr
	CV_BadDepth
	CV_BadImageSize
	CV_BadModelOrChSeq
	CV_BadNumChannel1U
	CV_BadNumChannels
	CV_BadOffset
	CV_BadOrder
	CV_BadOrigin
	CV_BadROISize
	CV_BadStep
	CV_BadTileSize
	CV_BayerBG2BGR
	CV_BayerBG2RGB
	CV_BayerGB2BGR
	CV_BayerGB2RGB
	CV_BayerGR2BGR
	CV_BayerGR2RGB
	CV_BayerRG2BGR
	CV_BayerRG2RGB
	CV_C
	CV_CALIB_CB_ADAPTIVE_THRESH
	CV_CALIB_CB_FILTER_QUADS
	CV_CALIB_CB_NORMALIZE_IMAGE
	CV_CALIB_FIX_ASPECT_RATIO
	CV_CALIB_FIX_FOCAL_LENGTH
	CV_CALIB_FIX_INTRINSIC
	CV_CALIB_FIX_K1
	CV_CALIB_FIX_K2
	CV_CALIB_FIX_K3
	CV_CALIB_FIX_PRINCIPAL_POINT
	CV_CALIB_SAME_FOCAL_LENGTH
	CV_CALIB_USE_INTRINSIC_GUESS
	CV_CALIB_ZERO_DISPARITY
	CV_CALIB_ZERO_TANGENT_DIST
	CV_CAMERA_TO_WARP
	CV_CANNY_L2_GRADIENT
	CV_CAP_ANY
	CV_CAP_CMU1394
	CV_CAP_DC1394
	CV_CAP_DSHOW
	CV_CAP_FIREWARE
	CV_CAP_FIREWIRE
	CV_CAP_IEEE1394
	CV_CAP_MIL
	CV_CAP_PROP_BRIGHTNESS
	CV_CAP_PROP_CONTRAST
	CV_CAP_PROP_CONVERT_RGB
	CV_CAP_PROP_FORMAT
	CV_CAP_PROP_FOURCC
	CV_CAP_PROP_FPS
	CV_CAP_PROP_FRAME_COUNT
	CV_CAP_PROP_FRAME_HEIGHT
	CV_CAP_PROP_FRAME_WIDTH
	CV_CAP_PROP_GAIN
	CV_CAP_PROP_HUE
	CV_CAP_PROP_MODE
	CV_CAP_PROP_POS_AVI_RATIO
	CV_CAP_PROP_POS_FRAMES
	CV_CAP_PROP_POS_MSEC
	CV_CAP_PROP_SATURATION
	CV_CAP_QT
	CV_CAP_STEREO
	CV_CAP_TYZX
	CV_CAP_UNICAP
	CV_CAP_V4L
	CV_CAP_V4L2
	CV_CAP_VFW
	CV_CHAIN_APPROX_NONE
	CV_CHAIN_APPROX_SIMPLE
	CV_CHAIN_APPROX_TC89_KCOS
	CV_CHAIN_APPROX_TC89_L1
	CV_CHAIN_CODE
	CV_CHECK_QUIET
	CV_CHECK_RANGE
	CV_CLOCKWISE
	CV_CMP_EQ
	CV_CMP_GE
	CV_CMP_GT
	CV_CMP_LE
	CV_CMP_LT
	CV_CMP_NE
	CV_CN_MAX
	CV_CN_SHIFT
	CV_COLORCVT_MAX
	CV_COMP_BHATTACHARYYA
	CV_COMP_CHISQR
	CV_COMP_CORREL
	CV_COMP_INTERSECT
	CV_CONTOURS_MATCH_I1
	CV_CONTOURS_MATCH_I2
	CV_CONTOURS_MATCH_I3
	CV_CONTOUR_TREES_MATCH_I1
	CV_COUNTER_CLOCKWISE
	CV_COVAR_COLS
	CV_COVAR_NORMAL
	CV_COVAR_ROWS
	CV_COVAR_SCALE
	CV_COVAR_SCRAMBLED
	CV_COVAR_USE_AVG
	CV_CVTIMG_FLIP
	CV_CVTIMG_SWAP_RB
	CV_DEPTH_MAX
	CV_DIFF
	CV_DIFF_C
	CV_DIFF_L1
	CV_DIFF_L2
	CV_DISPARITY_BIRCHFIELD
	CV_DIST_C
	CV_DIST_FAIR
	CV_DIST_HUBER
	CV_DIST_L1
	CV_DIST_L12
	CV_DIST_L2
	CV_DIST_MASK_3
	CV_DIST_MASK_5
	CV_DIST_MASK_PRECISE
	CV_DIST_USER
	CV_DIST_WELSCH
	CV_DOMINANT_IPAN
	CV_DXT_FORWARD
	CV_DXT_INVERSE
	CV_DXT_INVERSE_SCALE
	CV_DXT_INV_SCALE
	CV_DXT_MUL_CONJ
	CV_DXT_ROWS
	CV_DXT_SCALE
	CV_EIGOBJ_BOTH_CALLBACK
	CV_EIGOBJ_INPUT_CALLBACK
	CV_EIGOBJ_NO_CALLBACK
	CV_EIGOBJ_OUTPUT_CALLBACK
	CV_EVENT_FLAG_ALTKEY
	CV_EVENT_FLAG_CTRLKEY
	CV_EVENT_FLAG_LBUTTON
	CV_EVENT_FLAG_MBUTTON
	CV_EVENT_FLAG_RBUTTON
	CV_EVENT_FLAG_SHIFTKEY
	CV_EVENT_LBUTTONDBLCLK
	CV_EVENT_LBUTTONDOWN
	CV_EVENT_LBUTTONUP
	CV_EVENT_MBUTTONDBLCLK
	CV_EVENT_MBUTTONDOWN
	CV_EVENT_MBUTTONUP
	CV_EVENT_MOUSEMOVE
	CV_EVENT_RBUTTONDBLCLK
	CV_EVENT_RBUTTONDOWN
	CV_EVENT_RBUTTONUP
	CV_ErrModeLeaf
	CV_ErrModeParent
	CV_ErrModeSilent
	CV_FILLED
	CV_FLOODFILL_FIXED_RANGE
	CV_FLOODFILL_MASK_ONLY
	CV_FM_7POINT
	CV_FM_8POINT
	CV_FM_LMEDS
	CV_FM_LMEDS_ONLY
	CV_FM_RANSAC
	CV_FM_RANSAC_ONLY
	CV_FONT_HERSHEY_COMPLEX
	CV_FONT_HERSHEY_COMPLEX_SMALL
	CV_FONT_HERSHEY_DUPLEX
	CV_FONT_HERSHEY_PLAIN
	CV_FONT_HERSHEY_SCRIPT_COMPLEX
	CV_FONT_HERSHEY_SCRIPT_SIMPLEX
	CV_FONT_HERSHEY_SIMPLEX
	CV_FONT_HERSHEY_TRIPLEX
	CV_FONT_ITALIC
	CV_FONT_VECTOR0
	CV_FOURCC_DEFAULT
	CV_FOURCC_PROMPT
	CV_FRONT
	CV_GAUSSIAN
	CV_GAUSSIAN_5x5
	CV_GEMM_A_T
	CV_GEMM_B_T
	CV_GEMM_C_T
	CV_GLCMDESC_CLUSTERSHADE
	CV_GLCMDESC_CLUSTERTENDENCY
	CV_GLCMDESC_CONTRAST
	CV_GLCMDESC_CORRELATION
	CV_GLCMDESC_CORRELATIONINFO1
	CV_GLCMDESC_CORRELATIONINFO2
	CV_GLCMDESC_ENERGY
	CV_GLCMDESC_ENTROPY
	CV_GLCMDESC_HOMOGENITY
	CV_GLCMDESC_MAXIMUMPROBABILITY
	CV_GLCMDESC_OPTIMIZATION_ALLOWDOUBLENEST
	CV_GLCMDESC_OPTIMIZATION_ALLOWTRIPLENEST
	CV_GLCMDESC_OPTIMIZATION_HISTOGRAM
	CV_GLCM_ALL
	CV_GLCM_DESC
	CV_GLCM_GLCM
	CV_GLCM_OPTIMIZATION_HISTOGRAM
	CV_GLCM_OPTIMIZATION_LUT
	CV_GLCM_OPTIMIZATION_NONE
	CV_GRAPH
	CV_GRAPH_ALL_ITEMS
	CV_GRAPH_ANY_EDGE
	CV_GRAPH_BACKTRACKING
	CV_GRAPH_BACK_EDGE
	CV_GRAPH_CROSS_EDGE
	CV_GRAPH_FLAG_ORIENTED
	CV_GRAPH_FORWARD_EDGE
	CV_GRAPH_FORWARD_EDGE_FLAG
	CV_GRAPH_ITEM_VISITED_FLAG
	CV_GRAPH_NEW_TREE
	CV_GRAPH_OVER
	CV_GRAPH_SEARCH_TREE_NODE_FLAG
	CV_GRAPH_TREE_EDGE
	CV_GRAPH_VERTEX
	CV_GRAY2BGR
	CV_GRAY2BGR555
	CV_GRAY2BGR565
	CV_GRAY2BGRA
	CV_GRAY2RGB
	CV_GRAY2RGBA
	CV_HAAR_DO_CANNY_PRUNING
	CV_HAAR_DO_ROUGH_SEARCH
	CV_HAAR_FEATURE_MAX
	CV_HAAR_FIND_BIGGEST_OBJECT
	CV_HAAR_MAGIC_VAL
	CV_HAAR_SCALE_IMAGE
	CV_HIST_ARRAY
	CV_HIST_MAGIC_VAL
	CV_HIST_RANGES_FLAG
	CV_HIST_SPARSE
	CV_HIST_TREE
	CV_HIST_UNIFORM
	CV_HIST_UNIFORM_FLAG
	CV_HLS2BGR
	CV_HLS2RGB
	CV_HOUGH_GRADIENT
	CV_HOUGH_MULTI_SCALE
	CV_HOUGH_PROBABILISTIC
	CV_HOUGH_STANDARD
	CV_HSV2BGR
	CV_HSV2RGB
	CV_HeaderIsNull
	CV_IDP_BIRCHFIELD_PARAM1
	CV_IDP_BIRCHFIELD_PARAM2
	CV_IDP_BIRCHFIELD_PARAM3
	CV_IDP_BIRCHFIELD_PARAM4
	CV_IDP_BIRCHFIELD_PARAM5
	CV_INPAINT_NS
	CV_INPAINT_TELEA
	CV_INTER_AREA
	CV_INTER_CUBIC
	CV_INTER_LINEAR
	CV_INTER_NN
	CV_L1
	CV_L2
	CV_LINK_RUNS
	CV_LKFLOW_GET_MIN_EIGENVALS
	CV_LKFLOW_INITIAL_GUESSES
	CV_LKFLOW_PYR_A_READY
	CV_LKFLOW_PYR_B_READY
	CV_LMEDS
	CV_LOAD_IMAGE_ANYCOLOR
	CV_LOAD_IMAGE_ANYDEPTH
	CV_LOAD_IMAGE_COLOR
	CV_LOAD_IMAGE_GRAYSCALE
	CV_LOAD_IMAGE_UNCHANGED
	CV_LOG2
	CV_LSQ
	CV_LU
	CV_Lab2BGR
	CV_Lab2RGB
	CV_Luv2BGR
	CV_Luv2RGB
	CV_MAGIC_MASK
	CV_MAT32F
	CV_MAT3x1_32F
	CV_MAT3x1_64D
	CV_MAT3x3_32F
	CV_MAT3x3_64D
	CV_MAT4x1_32F
	CV_MAT4x1_64D
	CV_MAT4x4_32F
	CV_MAT4x4_64D
	CV_MAT64D
	CV_MATND_MAGIC_VAL
	CV_MAT_CN_MASK
	CV_MAT_CONT_FLAG
	CV_MAT_CONT_FLAG_SHIFT
	CV_MAT_DEPTH_MASK
	CV_MAT_MAGIC_VAL
	CV_MAT_TEMP_FLAG
	CV_MAT_TEMP_FLAG_SHIFT
	CV_MAT_TYPE_MASK
	CV_MAX_ARR
	CV_MAX_DIM
	CV_MAX_DIM_HEAP
	CV_MAX_SOBEL_KSIZE
	CV_MEDIAN
	CV_MINMAX
	CV_MOP_BLACKHAT
	CV_MOP_CLOSE
	CV_MOP_GRADIENT
	CV_MOP_OPEN
	CV_MOP_TOPHAT
	CV_MaskIsTiled
	CV_NODE_EMPTY
	CV_NODE_FLOAT
	CV_NODE_FLOW
	CV_NODE_INT
	CV_NODE_INTEGER
	CV_NODE_MAP
	CV_NODE_NAMED
	CV_NODE_NONE
	CV_NODE_REAL
	CV_NODE_REF
	CV_NODE_SEQ
	CV_NODE_SEQ_SIMPLE
	CV_NODE_STR
	CV_NODE_STRING
	CV_NODE_TYPE_MASK
	CV_NODE_USER
	CV_NORM_MASK
	CV_NO_CN_CHECK
	CV_NO_DEPTH_CHECK
	CV_NO_SIZE_CHECK
	CV_NUM_FACE_ELEMENTS
	CV_ORIENTED_GRAPH
	CV_PCA_DATA_AS_COL
	CV_PCA_DATA_AS_ROW
	CV_PCA_USE_AVG
	CV_PI
	CV_POLY_APPROX_DP
	CV_RAND_NORMAL
	CV_RAND_UNI
	CV_RANSAC
	CV_REDUCE_AVG
	CV_REDUCE_MAX
	CV_REDUCE_MIN
	CV_REDUCE_SUM
	CV_RELATIVE
	CV_RELATIVE_C
	CV_RELATIVE_L1
	CV_RELATIVE_L2
	CV_RETR_CCOMP
	CV_RETR_EXTERNAL
	CV_RETR_LIST
	CV_RETR_TREE
	CV_RGB2BGR
	CV_RGB2BGR555
	CV_RGB2BGR565
	CV_RGB2BGRA
	CV_RGB2GRAY
	CV_RGB2HLS
	CV_RGB2HSV
	CV_RGB2Lab
	CV_RGB2Luv
	CV_RGB2RGBA
	CV_RGB2XYZ
	CV_RGB2YCrCb
	CV_RGBA2BGR
	CV_RGBA2BGR555
	CV_RGBA2BGR565
	CV_RGBA2BGRA
	CV_RGBA2GRAY
	CV_RGBA2RGB
	CV_RODRIGUES_M2V
	CV_RODRIGUES_V2M
	CV_SCHARR
	CV_SEQ_CHAIN
	CV_SEQ_CHAIN_CONTOUR
	CV_SEQ_CONNECTED_COMP
	CV_SEQ_CONTOUR
	CV_SEQ_ELTYPE_BITS
	CV_SEQ_ELTYPE_CODE
	CV_SEQ_ELTYPE_CONNECTED_COMP
	CV_SEQ_ELTYPE_GENERIC
	CV_SEQ_ELTYPE_GRAPH_EDGE
	CV_SEQ_ELTYPE_GRAPH_VERTEX
	CV_SEQ_ELTYPE_INDEX
	CV_SEQ_ELTYPE_MASK
	CV_SEQ_ELTYPE_POINT
	CV_SEQ_ELTYPE_POINT3D
	CV_SEQ_ELTYPE_PPOINT
	CV_SEQ_ELTYPE_PTR
	CV_SEQ_ELTYPE_TRIAN_ATR
	CV_SEQ_FLAG_CLOSED
	CV_SEQ_FLAG_CONVEX
	CV_SEQ_FLAG_HOLE
	CV_SEQ_FLAG_SHIFT
	CV_SEQ_FLAG_SIMPLE
	CV_SEQ_INDEX
	CV_SEQ_KIND_BIN_TREE
	CV_SEQ_KIND_BITS
	CV_SEQ_KIND_CURVE
	CV_SEQ_KIND_GENERIC
	CV_SEQ_KIND_GRAPH
	CV_SEQ_KIND_MASK
	CV_SEQ_KIND_SUBDIV2D
	CV_SEQ_MAGIC_VAL
	CV_SEQ_POINT3D_SET
	CV_SEQ_POINT_SET
	CV_SEQ_POLYGON
	CV_SEQ_POLYGON_TREE
	CV_SEQ_POLYLINE
	CV_SEQ_SIMPLE_POLYGON
	CV_SET_ELEM_FREE_FLAG
	CV_SET_ELEM_IDX_MASK
	CV_SET_MAGIC_VAL
	CV_SHAPE_CROSS
	CV_SHAPE_CUSTOM
	CV_SHAPE_ELLIPSE
	CV_SHAPE_RECT
	CV_SHIFT_DOWN
	CV_SHIFT_LD
	CV_SHIFT_LEFT
	CV_SHIFT_LU
	CV_SHIFT_NONE
	CV_SHIFT_RD
	CV_SHIFT_RIGHT
	CV_SHIFT_RU
	CV_SHIFT_UP
	CV_SORT_ASCENDING
	CV_SORT_DESCENDING
	CV_SORT_EVERY_COLUMN
	CV_SORT_EVERY_ROW
	CV_SPARSE_MAT_MAGIC_VAL
	CV_SSE2
	CV_STEREO_BM_BASIC
	CV_STEREO_BM_FISH_EYE
	CV_STEREO_BM_NARROW
	CV_STEREO_BM_NORMALIZED_RESPONSE
	CV_STEREO_GC_OCCLUDED
	CV_STORAGE_APPEND
	CV_STORAGE_MAGIC_VAL
	CV_STORAGE_READ
	CV_STORAGE_WRITE
	CV_STORAGE_WRITE_BINARY
	CV_STORAGE_WRITE_TEXT
	CV_SUBDIV2D_VIRTUAL_POINT_FLAG
	CV_SVD
	CV_SVD_MODIFY_A
	CV_SVD_SYM
	CV_SVD_U_T
	CV_SVD_V_T
	CV_StsAutoTrace
	CV_StsBackTrace
	CV_StsBadArg
	CV_StsBadFlag
	CV_StsBadFunc
	CV_StsBadMask
	CV_StsBadMemBlock
	CV_StsBadPoint
	CV_StsBadSize
	CV_StsDivByZero
	CV_StsError
	CV_StsFilterOffsetErr
	CV_StsFilterStructContentErr
	CV_StsInplaceNotSupported
	CV_StsInternal
	CV_StsKernelStructContentErr
	CV_StsNoConv
	CV_StsNoMem
	CV_StsNotImplemented
	CV_StsNullPtr
	CV_StsObjectNotFound
	CV_StsOk
	CV_StsOutOfRange
	CV_StsParseError
	CV_StsUnmatchedFormats
	CV_StsUnmatchedSizes
	CV_StsUnsupportedFormat
	CV_StsVecLengthErr
	CV_TERMCRIT_EPS
	CV_TERMCRIT_ITER
	CV_TERMCRIT_NUMBER
	CV_THRESH_BINARY
	CV_THRESH_BINARY_INV
	CV_THRESH_MASK
	CV_THRESH_OTSU
	CV_THRESH_TOZERO
	CV_THRESH_TOZERO_INV
	CV_THRESH_TRUNC
	CV_TM_CCOEFF
	CV_TM_CCOEFF_NORMED
	CV_TM_CCORR
	CV_TM_CCORR_NORMED
	CV_TM_SQDIFF
	CV_TM_SQDIFF_NORMED
	CV_TYZX_COLOR
	CV_TYZX_LEFT
	CV_TYZX_RIGHT
	CV_TYZX_Z
	CV_UNDEF_SC_PARAM
	CV_USRTYPE1
	CV_VALUE
	CV_WARP_FILL_OUTLIERS
	CV_WARP_INVERSE_MAP
	CV_WARP_TO_CAMERA
	CV_WHOLE_SEQ
	CV_WHOLE_SEQ_END_INDEX
	CV_WINDOW_AUTOSIZE
	CV_XYZ2BGR
	CV_XYZ2RGB
	CV_YCrCb2BGR
	CV_YCrCb2RGB
	IPL_ALIGN_16BYTES
	IPL_ALIGN_32BYTES
	IPL_ALIGN_4BYTES
	IPL_ALIGN_8BYTES
	IPL_ALIGN_DWORD
	IPL_ALIGN_QWORD
	IPL_BORDER_CONSTANT
	IPL_BORDER_REFLECT
	IPL_BORDER_REFLECT_101
	IPL_BORDER_REPLICATE
	IPL_BORDER_WRAP
	IPL_DATA_ORDER_PIXEL
	IPL_DATA_ORDER_PLANE
	IPL_DEPTH_16S
	IPL_DEPTH_16U
	IPL_DEPTH_1U
	IPL_DEPTH_32F
	IPL_DEPTH_32S
	IPL_DEPTH_64F
	IPL_DEPTH_8S
	IPL_DEPTH_8U
	IPL_DEPTH_SIGN
	IPL_GAUSSIAN_5x5
	IPL_IMAGE_DATA
	IPL_IMAGE_HEADER
	IPL_IMAGE_MAGIC_VAL
	IPL_IMAGE_ROI
	IPL_ORIGIN_BL
	IPL_ORIGIN_TL

    CV_PTLOC_ERROR
    CV_PTLOC_OUTSIDE_RECT
    CV_PTLOC_INSIDE
    CV_PTLOC_VERTEX
    CV_PTLOC_ON_EDGE

    CV_NEXT_AROUND_ORG
    CV_NEXT_AROUND_DST
    CV_PREV_AROUND_ORG
    CV_PREV_AROUND_DST
    CV_NEXT_AROUND_LEFT
    CV_NEXT_AROUND_RIGHT
    CV_PREV_AROUND_LEFT
    CV_PREV_AROUND_RIGHT

));

our %EXPORT_TAGS = ( 'all' => [ @EXPORT, qw(

) ] );

our @EXPORT_OK = (
	@{ $EXPORT_TAGS{'all'} },
	);

our $VERSION = '0.02';

# Preloaded methods go here.


1;
