
use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker 6.30;

use File::ShareDir::Install;
install_share module => "Dist::Zilla::MintingProfile::Author::YAKEX", "profiles";


my %WriteMakefileArgs = (
  "ABSTRACT" => "Dist::Zilla configuration the way YAKEX does it",
  "AUTHOR" => "Yasutaka ATARASHI <yakex\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30",
    "File::ShareDir::Install" => "0.03"
  },
  "DISTNAME" => "Dist-Zilla-PluginBundle-Author-YAKEX",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Dist::Zilla::PluginBundle::Author::YAKEX",
  "PREREQ_PM" => {
    "Dist::Zilla" => 0,
    "Dist::Zilla::Plugin::Bootstrap::lib" => 0,
    "Dist::Zilla::Plugin::CheckVersionIncrement" => 0,
    "Dist::Zilla::Plugin::GithubMeta" => 0,
    "Dist::Zilla::Plugin::MetaJSON" => 0,
    "Dist::Zilla::Plugin::MinimumPerl" => 0,
    "Dist::Zilla::Plugin::NextRelease" => 0,
    "Dist::Zilla::Plugin::OurPkgVersion" => 0,
    "Dist::Zilla::Plugin::PodWeaver" => 0,
    "Dist::Zilla::Plugin::ReadmeAnyFromPod" => 0,
    "Dist::Zilla::Plugin::Test::Compile" => "2.033",
    "Dist::Zilla::Plugin::Test::Kwalitee::Extra" => "v0.2.0",
    "Dist::Zilla::Plugin::Test::Perl::Critic" => 0,
    "Dist::Zilla::Plugin::Twitter" => 0,
    "Dist::Zilla::PluginBundle::Git" => 0,
    "Dist::Zilla::Role::PluginBundle::PluginRemover" => 0,
    "Moose" => 0,
    "Pod::Elemental::Transformer::List" => 0,
    "Pod::Weaver::Section::AllowOverride" => 0
  },
  "TEST_REQUIRES" => {
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::More" => 0
  },
  "VERSION" => "v0.1.2",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Dist::Zilla" => 0,
  "Dist::Zilla::Plugin::Bootstrap::lib" => 0,
  "Dist::Zilla::Plugin::CheckVersionIncrement" => 0,
  "Dist::Zilla::Plugin::GithubMeta" => 0,
  "Dist::Zilla::Plugin::MetaJSON" => 0,
  "Dist::Zilla::Plugin::MinimumPerl" => 0,
  "Dist::Zilla::Plugin::NextRelease" => 0,
  "Dist::Zilla::Plugin::OurPkgVersion" => 0,
  "Dist::Zilla::Plugin::PodWeaver" => 0,
  "Dist::Zilla::Plugin::ReadmeAnyFromPod" => 0,
  "Dist::Zilla::Plugin::Test::Compile" => "2.033",
  "Dist::Zilla::Plugin::Test::Kwalitee::Extra" => "v0.2.0",
  "Dist::Zilla::Plugin::Test::Perl::Critic" => 0,
  "Dist::Zilla::Plugin::Twitter" => 0,
  "Dist::Zilla::PluginBundle::Git" => 0,
  "Dist::Zilla::Role::PluginBundle::PluginRemover" => 0,
  "File::Spec" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Moose" => 0,
  "Pod::Elemental::Transformer::List" => 0,
  "Pod::Weaver::Section::AllowOverride" => 0,
  "Test::More" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}


