NAME
====

Matrix::Bot

AUTHOR
======

Patrick Spek <p.spek@tyil.work>

VERSION
=======

0.0.0

Description
===========

A framework for writing Matrix bots

Installation
============

Install this module through [zef](https://github.com/ugexe/zef):

```sh
zef install Matrix::Bot
```

Usage
=====

Configuring the bot
-------------------

First off, you have to instantiate the bot correctly. For this, a few arguments must be passed to `new`.

    use Matrix::Bot;

    my $bot = Matrix::Bot.new(
	    home-server => "https://matrix.org",
	    username => %*ENV<USER>,
	    password => "",
	    access-token => "",
	    plugins => [],
    );

    $bot.run;

You must specify a password or access-token. If you supply both, the password will be ignored, and the access-token will be used directly. The list of plugins has to be filled with classes which implement `Matrix::Bot::Plugin`.

The `run` call starts the bots event loop. It will connect to Matrix, and start retrieving new messages on the channels it is joined in.

Plugins
-------

The simplest usage of the module would be using the `handle-room-text` method in a plugin. For instance, to repond to `"ping"` messages with a `"pong"`, you can write a plugin as follows.

    use Matrix::Bot::Plugin;

    class Local::Matrix::Plugin is Matrix::Bot::Plugin {
	    multi method handle-room-text ($e where * eq "ping") {
		    "pong"
	    }
    }

Logging
-------

There is some logging available in the module, through [`LogP6`](https://modules.perl6.org/dist/LogP6:cpan:ATROXAPER). You can make these visible using a `cliche`. For instance, to show all messages that the bot has received, you can use this simple `cliche`.

    cliche(
	    name => "messages",
	    matcher => "Matrix::Bot/message",
	    grooves => (
		    writer(
			    pattern => "%msg",
			    handle => $*OUT,
			    filter(level => $info),
		    ),
	    ),
    );

More information on how to use cliches can be found in the `LogP6` documentation.

The following traits are used throughout `Matrix::Bot`:

  * `Matrix::Bot`

  * `Matrix::Bot/message`

  * `Matrix::Bot/plugin($name)` (The `$name` corresponds to the name of the plugin)

License
=======

This module is distributed under the terms of the AGPL-3.0.

