/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.parameter.UninitializedParameter;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.ReferenceIdentifier;

final class ParameterValueList
extends AbstractList<GeneralParameterValue>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = -7446077551686135264L;
    final ParameterDescriptorGroup descriptor;
    private GeneralParameterValue[] values;
    private int size;

    ParameterValueList(ParameterDescriptorGroup parameterDescriptorGroup) {
        this.descriptor = parameterDescriptorGroup;
        List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
        this.values = new GeneralParameterValue[list.size()];
        this.initialize(list);
    }

    ParameterValueList(ParameterValueList parameterValueList) {
        this.descriptor = parameterValueList.descriptor;
        this.size = parameterValueList.size;
        this.values = new GeneralParameterValue[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = parameterValueList.values[i].clone();
        }
    }

    private void initialize(List<GeneralParameterDescriptor> list) {
        for (GeneralParameterDescriptor generalParameterDescriptor : list) {
            int n = generalParameterDescriptor.getMinimumOccurs();
            while (--n >= 0) {
                this.addUnchecked(new UninitializedParameter(generalParameterDescriptor));
            }
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, 0, this.size, null);
        this.size = 0;
        this.initialize(this.descriptor.descriptors());
    }

    @Override
    public int size() {
        return this.size;
    }

    final GeneralParameterDescriptor descriptor(int n) {
        return this.values[n].getDescriptor();
    }

    @Override
    public GeneralParameterValue get(int n) {
        ArgumentChecks.ensureValidIndex(this.size, n);
        GeneralParameterValue generalParameterValue = this.values[n];
        if (generalParameterValue instanceof UninitializedParameter) {
            this.values[n] = generalParameterValue = generalParameterValue.getDescriptor().createValue();
        }
        return generalParameterValue;
    }

    @Override
    public GeneralParameterValue set(int n, GeneralParameterValue generalParameterValue) {
        ArgumentChecks.ensureValidIndex(this.size, n);
        GeneralParameterValue generalParameterValue2 = this.values[n];
        ArgumentChecks.ensureNonNull("parameter", generalParameterValue);
        GeneralParameterDescriptor generalParameterDescriptor = generalParameterValue.getDescriptor();
        if (!generalParameterValue2.getDescriptor().equals(generalParameterDescriptor)) {
            this.ensureDescriptorExists(generalParameterDescriptor);
            this.ensureCanRemove(generalParameterDescriptor);
            this.ensureCanAdd(generalParameterDescriptor);
        }
        this.values[n] = generalParameterValue;
        return generalParameterValue2;
    }

    @Override
    public boolean add(GeneralParameterValue generalParameterValue) {
        int n;
        ArgumentChecks.ensureNonNull("parameter", generalParameterValue);
        GeneralParameterDescriptor generalParameterDescriptor = generalParameterValue.getDescriptor();
        this.ensureDescriptorExists(generalParameterDescriptor);
        ReferenceIdentifier referenceIdentifier = generalParameterDescriptor.getName();
        int n2 = 0;
        for (n = 0; n < this.size; ++n) {
            GeneralParameterValue generalParameterValue2 = this.values[n];
            if (!referenceIdentifier.equals(generalParameterValue2.getDescriptor().getName())) continue;
            if (generalParameterValue2 instanceof UninitializedParameter) {
                this.values[n] = generalParameterValue;
                return true;
            }
            ++n2;
        }
        n = generalParameterDescriptor.getMaximumOccurs();
        if (n2 >= n) {
            throw new InvalidParameterCardinalityException(Errors.format((short)130, n, referenceIdentifier), referenceIdentifier.getCode());
        }
        this.addUnchecked(generalParameterValue);
        ++this.modCount;
        return true;
    }

    final void addUnchecked(GeneralParameterValue generalParameterValue) {
        if (this.size == this.values.length) {
            this.values = Arrays.copyOf(this.values, this.size * 2);
        }
        this.values[this.size++] = generalParameterValue;
    }

    final void ensureDescriptorExists(GeneralParameterDescriptor generalParameterDescriptor) {
        List<GeneralParameterDescriptor> list = this.descriptor.descriptors();
        if (!list.contains(generalParameterDescriptor)) {
            ReferenceIdentifier referenceIdentifier = generalParameterDescriptor.getName();
            String string = referenceIdentifier.getCode();
            for (GeneralParameterDescriptor generalParameterDescriptor2 : list) {
                if (!IdentifiedObjects.isHeuristicMatchForName(generalParameterDescriptor2, string)) continue;
                throw new IllegalArgumentException(Resources.format((short)35, referenceIdentifier));
            }
            throw new InvalidParameterNameException(Resources.format((short)61, Verifier.getDisplayName(this.descriptor), referenceIdentifier), string);
        }
    }

    private void ensureCanAdd(GeneralParameterDescriptor generalParameterDescriptor) {
        int n;
        ReferenceIdentifier referenceIdentifier = generalParameterDescriptor.getName();
        int n2 = 0;
        for (n = 0; n < this.size; ++n) {
            if (!referenceIdentifier.equals(this.values[n].getDescriptor().getName())) continue;
            ++n2;
        }
        n = generalParameterDescriptor.getMaximumOccurs();
        if (n2 >= n) {
            throw new InvalidParameterCardinalityException(Errors.format((short)130, n, referenceIdentifier), referenceIdentifier.getCode());
        }
    }

    private void ensureCanRemove(GeneralParameterDescriptor generalParameterDescriptor) {
        int n = generalParameterDescriptor.getMinimumOccurs();
        if (n != 0) {
            ReferenceIdentifier referenceIdentifier = generalParameterDescriptor.getName();
            int n2 = 0;
            for (int i = 0; i < this.size; ++i) {
                if (!referenceIdentifier.equals(this.values[i].getDescriptor().getName()) || ++n2 <= n) continue;
                return;
            }
            throw new InvalidParameterCardinalityException(Errors.format((short)128, n, referenceIdentifier), referenceIdentifier.getCode());
        }
    }

    @Override
    public GeneralParameterValue remove(int n) {
        ArgumentChecks.ensureValidIndex(this.size, n);
        GeneralParameterValue generalParameterValue = this.values[n];
        this.ensureCanRemove(generalParameterValue.getDescriptor());
        System.arraycopy(this.values, n + 1, this.values, n, --this.size - n);
        this.values[this.size] = null;
        ++this.modCount;
        return generalParameterValue;
    }

    public GeneralParameterValue[] toArray() {
        return Arrays.copyOf(this.values, this.size);
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        String string = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.values[i]).append(string);
        }
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.values = ArraysExt.resize(this.values, this.size);
        objectOutputStream.defaultWriteObject();
    }
}

