/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.metadata.sql.MetadataSource;

final class IdentifierGenerator
implements AutoCloseable {
    static final char SEPARATOR = '-';
    private final PreparedStatement statement;
    private final SQLBuilder buffer;
    private int parseAt;
    private int maximalSequenceNumber;
    private int freeSequenceNumber;

    IdentifierGenerator(MetadataSource metadataSource, String string, String string2, String string3, SQLBuilder sQLBuilder) throws SQLException {
        assert (Thread.holdsLock(metadataSource));
        this.buffer = sQLBuilder;
        sQLBuilder.clear().append("SELECT DISTINCT ").appendIdentifier(string3).append(" FROM ").appendIdentifier(string, string2).append(" WHERE ").appendIdentifier(string3).append(" LIKE ? ORDER BY ").appendIdentifier(string3);
        this.statement = metadataSource.connection().prepareStatement(sQLBuilder.toString());
    }

    final String identifier(String string) throws SQLException {
        this.statement.setString(1, this.buffer.clear().appendEscaped(string).append('%').toString());
        try (ResultSet resultSet = this.statement.executeQuery();){
            String string2;
            if (resultSet.next() && (string2 = resultSet.getString(1)).equals(string)) {
                int n;
                this.parseAt = string.length() + 1;
                this.freeSequenceNumber = 0;
                this.maximalSequenceNumber = 0;
                int n2 = 0;
                block9: while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                    assert (string2.startsWith(string)) : string2;
                    while (string2.length() > this.parseAt && (n = string2.codePointBefore(this.parseAt)) >= 45) {
                        String string3;
                        if (n > 45) break block9;
                        n = string2.codePointAt(this.parseAt);
                        if (n < 49) continue block9;
                        if (n <= 57 && (string2 = this.search(resultSet, string2, string3 = string2.substring(0, this.parseAt), ++n2)) != null) continue;
                        break block9;
                    }
                }
                if ((n = this.freeSequenceNumber) == 0) {
                    n = this.maximalSequenceNumber + 1;
                }
                string = string + '-' + n;
            }
        }
        return string;
    }

    private String search(ResultSet resultSet, String string, String string2, int n) throws SQLException {
        assert (string.startsWith(string2));
        assert (string.length() > string2.length()) : string;
        do {
            int n2;
            try {
                n2 = Integer.parseInt(string.substring(this.parseAt));
            }
            catch (NumberFormatException numberFormatException) {
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                    continue;
                }
                return null;
            }
            if (n2 > n) {
                this.freeSequenceNumber = n;
                return null;
            }
            if (n2 != n) {
                throw new SQLNonTransientException(string);
            }
            ++n;
            if (n2 > this.maximalSequenceNumber) {
                this.maximalSequenceNumber = n2;
            }
            if (!resultSet.next()) {
                return null;
            }
            String string3 = string.substring(0, string2.length() + 1);
            string = resultSet.getString(1);
            if (!string.startsWith(string3) || (string = this.search(resultSet, string, string3, n2 * 10)) != null) continue;
            return null;
        } while (string.startsWith(string2));
        return string;
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }
}

