/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model.textproperties;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.util.LittleEndian;

public class TabStopPropCollection
extends TextProp {
    private List<TabStop> tabStops = new ArrayList<TabStop>();

    public TabStopPropCollection() {
        super(0, 0x100000, "tabStops");
    }

    public void parseProperty(byte[] data, int offset) {
        int count = LittleEndian.getUShort(data, offset);
        int off = offset + 2;
        for (int i = 0; i < count; ++i) {
            short position = LittleEndian.getShort(data, off);
            short recVal = LittleEndian.getShort(data, off += 2);
            TabStopType type = TabStopType.fromRecordVal(recVal);
            off += 2;
            this.tabStops.add(new TabStop(position, type));
        }
    }

    @Override
    public int getSize() {
        return 2 + this.tabStops.size() * 4;
    }

    @Override
    public TabStopPropCollection clone() {
        TabStopPropCollection other = (TabStopPropCollection)super.clone();
        other.tabStops = new ArrayList<TabStop>();
        for (TabStop ts : this.tabStops) {
            TabStop tso = new TabStop(ts.getPosition(), ts.getType());
            other.tabStops.add(tso);
        }
        return other;
    }

    public static class TabStop {
        private int position;
        private TabStopType type;

        public TabStop(int position, TabStopType type) {
            this.position = position;
            this.type = type;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public TabStopType getType() {
            return this.type;
        }

        public void setType(TabStopType type) {
            this.type = type;
        }
    }

    public static enum TabStopType {
        LEFT(0),
        CENTER(1),
        RIGHT(2),
        DECIMAL(3);

        private final int val;

        private TabStopType(int val) {
            this.val = val;
        }

        public static TabStopType fromRecordVal(int val) {
            for (TabStopType tst : TabStopType.values()) {
                if (tst.val != val) continue;
                return tst;
            }
            return LEFT;
        }
    }
}

