/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.ThreddsXmlParserIssue;
import thredds.util.HttpUriResolver;
import thredds.util.HttpUriResolverFactory;

class StaxThreddsXmlParserUtils {
    private static Logger log = LoggerFactory.getLogger(StaxThreddsXmlParserUtils.class);

    private StaxThreddsXmlParserUtils() {
    }

    static boolean isEventStartOrEndElementWithMatchingName(XMLEvent event, QName elementName) {
        if (event == null) {
            throw new IllegalArgumentException("Event may not be null.");
        }
        QName eventElementName = null;
        if (event.isStartElement()) {
            eventElementName = event.asStartElement().getName();
        } else if (event.isEndElement()) {
            eventElementName = event.asEndElement().getName();
        } else {
            return false;
        }
        return eventElementName.equals(elementName);
    }

    public static StartElement readNextEventCheckItIsStartElementWithExpectedName(XMLEventReader xmlEventReader, QName startElementName) throws ThreddsXmlParserException {
        if (!xmlEventReader.hasNext()) {
            throw new IllegalStateException("XMLEventReader has no further events.");
        }
        StartElement startElement = null;
        try {
            XMLEvent event = xmlEventReader.peek();
            if (!event.isStartElement()) {
                throw new IllegalStateException("Next event must be StartElement.");
            }
            if (!event.asStartElement().getName().equals(startElementName)) {
                throw new IllegalStateException("Start element must be an '" + startElementName.getLocalPart() + "' element.");
            }
            startElement = xmlEventReader.nextEvent().asStartElement();
        }
        catch (XMLStreamException e) {
            String msg = "Problem reading XML stream.";
            log.warn("readNextEventCheckItIsStartElementWithExpectedName(): " + msg, e);
            throw new ThreddsXmlParserException(new ThreddsXmlParserIssue(ThreddsXmlParserIssue.Severity.FATAL, msg, null, e));
        }
        return startElement;
    }

    public static void readNextEventCheckItIsEndElementWithExpectedName(XMLEventReader xmlEventReader, QName elementName) throws ThreddsXmlParserException {
        if (!xmlEventReader.hasNext()) {
            throw new IllegalStateException("XMLEventReader has no further events.");
        }
        try {
            XMLEvent event = xmlEventReader.peek();
            if (!event.isEndElement()) {
                throw new IllegalStateException("Next event must be EndElement.");
            }
            if (!event.asEndElement().getName().equals(elementName)) {
                throw new IllegalStateException("End element must be an '" + elementName.getLocalPart() + "' element.");
            }
            xmlEventReader.nextEvent();
        }
        catch (XMLStreamException e) {
            String msg = "Problem reading XML stream.";
            log.warn("readNextEventCheckItIsEndElementWithExpectedName(): " + msg, e);
            throw new ThreddsXmlParserException(new ThreddsXmlParserIssue(ThreddsXmlParserIssue.Severity.FATAL, msg, null, e));
        }
    }

    static String getLocationInfo(XMLEventReader xmlEventReader) {
        Location location = StaxThreddsXmlParserUtils.getLocation(xmlEventReader);
        StringBuilder sb = new StringBuilder().append("Location: SysId[").append(location.getSystemId()).append("] line[").append(location.getLineNumber()).append("] column[").append(location.getColumnNumber()).append("] charOffset[").append(location.getCharacterOffset()).append("].");
        return sb.toString();
    }

    static Location getLocation(XMLEventReader xmlEventReader) {
        if (xmlEventReader == null) {
            throw new IllegalArgumentException("XMLEventReader may not be null.");
        }
        if (!xmlEventReader.hasNext()) {
            throw new IllegalArgumentException("XMLEventReader must have next event.");
        }
        XMLEvent nextEvent = null;
        try {
            nextEvent = xmlEventReader.peek();
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException("Could not peek() next event.");
        }
        return nextEvent.getLocation();
    }

    static ThreddsXmlParserIssue createIssueForException(String message, XMLEventReader xmlEventReader, Exception e) throws ThreddsXmlParserException {
        String locationInfo = StaxThreddsXmlParserUtils.getLocationInfo(xmlEventReader);
        String msg = message + ":\n    " + locationInfo + ": " + e.getMessage();
        log.debug("createIssueForException(): " + msg);
        return new ThreddsXmlParserIssue(ThreddsXmlParserIssue.Severity.WARNING, msg, null, e);
    }

    static ThreddsXmlParserIssue createIssueForUnexpectedElement(String message, XMLEventReader xmlEventReader) throws ThreddsXmlParserException {
        String locationInfo = StaxThreddsXmlParserUtils.getLocationInfo(xmlEventReader);
        String unexpectedElemAsString = StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(xmlEventReader);
        String msg = message + ":\n    " + locationInfo + ":\n" + unexpectedElemAsString;
        log.debug("createIssueForUnexpectedElement(): " + msg);
        return new ThreddsXmlParserIssue(ThreddsXmlParserIssue.Severity.WARNING, msg, null, null);
    }

    static ThreddsXmlParserIssue createIssueForUnexpectedEvent(String message, ThreddsXmlParserIssue.Severity severity, XMLEventReader xmlEventReader, XMLEvent event) throws ThreddsXmlParserException {
        String locationInfo = StaxThreddsXmlParserUtils.getLocationInfo(xmlEventReader);
        String msg = message + " [" + severity.toString() + "]:\n    " + locationInfo + ":\n";
        log.debug("createIssueForUnexpectedElement(): " + msg);
        return new ThreddsXmlParserIssue(severity, msg, null, null);
    }

    static String consumeElementAndConvertToXmlString(XMLEventReader xmlEventReader) throws ThreddsXmlParserException {
        String resultString;
        if (xmlEventReader == null) {
            throw new IllegalArgumentException("XMLEventReader may not be null.");
        }
        StringWriter writer = new StringWriter();
        Location startLocation = null;
        try {
            XMLEvent event = xmlEventReader.peek();
            if (!event.isStartElement()) {
                throw new IllegalArgumentException("Next event in reader must be start element.");
            }
            startLocation = event.getLocation();
            XMLOutputFactory oFactory = XMLOutputFactory.newFactory();
            oFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            if (oFactory.isPropertySupported("javax.xml.stream.isPrefixDefaulting")) {
                oFactory.setProperty("javax.xml.stream.isPrefixDefaulting", Boolean.TRUE);
            }
            XMLEventWriter eventWriter = oFactory.createXMLEventWriter(writer);
            ArrayList<QName> nameList = new ArrayList<QName>();
            while (xmlEventReader.hasNext()) {
                event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    nameList.add(event.asStartElement().getName());
                } else if (event.isEndElement()) {
                    QName endElemName = event.asEndElement().getName();
                    QName lastName = (QName)nameList.get(nameList.size() - 1);
                    if (lastName.equals(endElemName)) {
                        nameList.remove(nameList.size() - 1);
                    } else {
                        String msg = "Badly formed XML? End element [" + endElemName.getLocalPart() + "] doesn't match expected start element [" + lastName.getLocalPart() + "].";
                        log.error("consumeElementAndConvertToXmlString(): " + msg);
                        throw new ThreddsXmlParserException("FATAL? " + msg);
                    }
                }
                eventWriter.add(event);
                if (!nameList.isEmpty()) continue;
            }
            eventWriter.flush();
            eventWriter.close();
            resultString = writer.toString();
        }
        catch (XMLStreamException e) {
            throw new ThreddsXmlParserException("Problem reading unknown element [" + startLocation + "]. Underlying cause: " + e.getMessage(), e);
        }
        return resultString;
    }

    static String getCharacterContent(XMLEventReader xmlEventReader, QName containingElementName) throws ThreddsXmlParserException {
        if (xmlEventReader == null) {
            throw new IllegalArgumentException("XMLEventReader may not be null.");
        }
        if (containingElementName == null) {
            throw new IllegalArgumentException("Containing element name may not be null.");
        }
        if (!xmlEventReader.hasNext()) {
            throw new IllegalStateException("XMLEventReader must have next.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        Location location = null;
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.peek();
                location = event.getLocation();
                if (event.isCharacters()) {
                    event = xmlEventReader.nextEvent();
                    stringBuilder.append(event.asCharacters().getData());
                    continue;
                }
                if (event.isEndElement()) {
                    if (event.asEndElement().getName().equals(containingElementName)) {
                        return stringBuilder.toString().trim();
                    }
                    throw new IllegalStateException("Badly formed XML? Unexpected end element [" + event.asEndElement().getName().getLocalPart() + "][" + location + "] doesn't match expected start element [" + containingElementName.getLocalPart() + "].");
                }
                if (event.isStartElement()) {
                    throw new IllegalStateException("Badly formed XML? Unexpected start element [" + event.asStartElement().getName().getLocalPart() + "][" + location + "] when characters expected.");
                }
                xmlEventReader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new ThreddsXmlParserException("Problem reading unknown event [" + location + "]. Underlying cause: " + e.getMessage(), e);
        }
        throw new ThreddsXmlParserException("Unexpected end of XMLEventReader.");
    }

    static Source getSourceFromUri(URI documentUri) throws ThreddsXmlParserException {
        HttpUriResolver httpUriResolver = HttpUriResolverFactory.getDefaultHttpUriResolver(documentUri);
        InputStream is = null;
        try {
            httpUriResolver.makeRequest();
            is = httpUriResolver.getResponseBodyAsInputStream();
        }
        catch (IOException e) {
            throw new ThreddsXmlParserException("Problem accessing resource [" + documentUri.toString() + "].", e);
        }
        return new StreamSource(is, documentUri.toString());
    }

    static Source getSourceFromFile(File file, URI docBaseUri) throws ThreddsXmlParserException {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null.");
        }
        StreamSource source = null;
        if (docBaseUri == null) {
            source = new StreamSource(file);
        } else {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                String message = "Couldn't find file [" + file.getPath() + "].";
                log.error("parseIntoBuilder(): " + message, e);
                throw new ThreddsXmlParserException(message, e);
            }
            source = new StreamSource(is, docBaseUri.toString());
        }
        return source;
    }

    static XMLEventReader getEventReaderFromSource(Source source, XMLInputFactory factory) throws ThreddsXmlParserException {
        XMLEventReader reader;
        try {
            reader = factory.createXMLEventReader(source);
        }
        catch (XMLStreamException e) {
            String message = "Problems reading stream [" + source.getSystemId() + "].";
            log.error("getEventReaderFromSource(): " + message, e);
            throw new ThreddsXmlParserException(message, e);
        }
        return reader;
    }
}

