package Net::Async::Redis::Commands;

use strict;
use warnings;

our $VERSION = '1.004'; # VERSION

=head1 NAME

Net::Async::Redis::Commands - mixin that defines the Redis commands available

=head1 DESCRIPTION

This is autogenerated from the list of commands available in L<https://redis.io/commands>.

It is intended to be loaded by L<Net::Async::Redis> to provide methods
for each available Redis command.

=cut

=head1 METHODS - Cluster

=head2 cluster_addslots

Assign new hash slots to receiving node.

=over 4

=item * slot [slot ...]

=back

L<https://redis.io/commands/cluster-addslots>

=cut

sub cluster_addslots : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER ADDSLOTS) => @args)
}

=head2 cluster_count_failure_reports

Return the number of failure reports active for a given node.

=over 4

=item * node-id

=back

L<https://redis.io/commands/cluster-count-failure-reports>

=cut

sub cluster_count_failure_reports : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER COUNT-FAILURE-REPORTS) => @args)
}

=head2 cluster_countkeysinslot

Return the number of local keys in the specified hash slot.

=over 4

=item * slot

=back

L<https://redis.io/commands/cluster-countkeysinslot>

=cut

sub cluster_countkeysinslot : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER COUNTKEYSINSLOT) => @args)
}

=head2 cluster_delslots

Set hash slots as unbound in receiving node.

=over 4

=item * slot [slot ...]

=back

L<https://redis.io/commands/cluster-delslots>

=cut

sub cluster_delslots : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER DELSLOTS) => @args)
}

=head2 cluster_failover

Forces a slave to perform a manual failover of its master.

=over 4

=item * [FORCE|TAKEOVER]

=back

L<https://redis.io/commands/cluster-failover>

=cut

sub cluster_failover : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER FAILOVER) => @args)
}

=head2 cluster_forget

Remove a node from the nodes table.

=over 4

=item * node-id

=back

L<https://redis.io/commands/cluster-forget>

=cut

sub cluster_forget : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER FORGET) => @args)
}

=head2 cluster_getkeysinslot

Return local key names in the specified hash slot.

=over 4

=item * slot

=item * count

=back

L<https://redis.io/commands/cluster-getkeysinslot>

=cut

sub cluster_getkeysinslot : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER GETKEYSINSLOT) => @args)
}

=head2 cluster_info

Provides info about Redis Cluster node state.

L<https://redis.io/commands/cluster-info>

=cut

sub cluster_info : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER INFO) => @args)
}

=head2 cluster_keyslot

Returns the hash slot of the specified key.

=over 4

=item * key

=back

L<https://redis.io/commands/cluster-keyslot>

=cut

sub cluster_keyslot : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER KEYSLOT) => @args)
}

=head2 cluster_meet

Force a node cluster to handshake with another node.

=over 4

=item * ip

=item * port

=back

L<https://redis.io/commands/cluster-meet>

=cut

sub cluster_meet : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER MEET) => @args)
}

=head2 cluster_nodes

Get Cluster config for the node.

L<https://redis.io/commands/cluster-nodes>

=cut

sub cluster_nodes : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER NODES) => @args)
}

=head2 cluster_replicate

Reconfigure a node as a slave of the specified master node.

=over 4

=item * node-id

=back

L<https://redis.io/commands/cluster-replicate>

=cut

sub cluster_replicate : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER REPLICATE) => @args)
}

=head2 cluster_reset

Reset a Redis Cluster node.

=over 4

=item * [HARD|SOFT]

=back

L<https://redis.io/commands/cluster-reset>

=cut

sub cluster_reset : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER RESET) => @args)
}

=head2 cluster_saveconfig

Forces the node to save cluster state on disk.

L<https://redis.io/commands/cluster-saveconfig>

=cut

sub cluster_saveconfig : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER SAVECONFIG) => @args)
}

=head2 cluster_set_config_epoch

Set the configuration epoch in a new node.

=over 4

=item * config-epoch

=back

L<https://redis.io/commands/cluster-set-config-epoch>

=cut

sub cluster_set_config_epoch : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER SET-CONFIG-EPOCH) => @args)
}

=head2 cluster_setslot

Bind a hash slot to a specific node.

=over 4

=item * slot

=item * IMPORTING|MIGRATING|STABLE|NODE

=item * [node-id]

=back

L<https://redis.io/commands/cluster-setslot>

=cut

sub cluster_setslot : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER SETSLOT) => @args)
}

=head2 cluster_slaves

List slave nodes of the specified master node.

=over 4

=item * node-id

=back

L<https://redis.io/commands/cluster-slaves>

=cut

sub cluster_slaves : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER SLAVES) => @args)
}

=head2 cluster_slots

Get array of Cluster slot to node mappings.

L<https://redis.io/commands/cluster-slots>

=cut

sub cluster_slots : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLUSTER SLOTS) => @args)
}

=head2 readonly

Enables read queries for a connection to a cluster slave node.

L<https://redis.io/commands/readonly>

=cut

sub readonly : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(READONLY) => @args)
}

=head2 readwrite

Disables read queries for a connection to a cluster slave node.

L<https://redis.io/commands/readwrite>

=cut

sub readwrite : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(READWRITE) => @args)
}

=head1 METHODS - Connection

=head2 auth

Authenticate to the server.

=over 4

=item * password

=back

L<https://redis.io/commands/auth>

=cut

sub auth : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(AUTH) => @args)
}

=head2 echo

Echo the given string.

=over 4

=item * message

=back

L<https://redis.io/commands/echo>

=cut

sub echo : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ECHO) => @args)
}

=head2 ping

Ping the server.

=over 4

=item * [message]

=back

L<https://redis.io/commands/ping>

=cut

sub ping : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PING) => @args)
}

=head2 quit

Close the connection.

L<https://redis.io/commands/quit>

=cut

sub quit : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(QUIT) => @args)
}

=head2 select

Change the selected database for the current connection.

=over 4

=item * index

=back

L<https://redis.io/commands/select>

=cut

sub select : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SELECT) => @args)
}

=head2 swapdb

Swaps two Redis databases.

=over 4

=item * index

=item * index

=back

L<https://redis.io/commands/swapdb>

=cut

sub swapdb : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SWAPDB) => @args)
}

=head1 METHODS - Generic

=head2 del

Delete a key.

=over 4

=item * key [key ...]

=back

L<https://redis.io/commands/del>

=cut

sub del : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(DEL) => @args)
}

=head2 dump

Return a serialized version of the value stored at the specified key.

=over 4

=item * key

=back

L<https://redis.io/commands/dump>

=cut

sub dump : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(DUMP) => @args)
}

=head2 exists

Determine if a key exists.

=over 4

=item * key [key ...]

=back

L<https://redis.io/commands/exists>

=cut

sub exists : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(EXISTS) => @args)
}

=head2 expire

Set a key's time to live in seconds.

=over 4

=item * key

=item * seconds

=back

L<https://redis.io/commands/expire>

=cut

sub expire : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(EXPIRE) => @args)
}

=head2 expireat

Set the expiration for a key as a UNIX timestamp.

=over 4

=item * key

=item * timestamp

=back

L<https://redis.io/commands/expireat>

=cut

sub expireat : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(EXPIREAT) => @args)
}

=head2 keys

Find all keys matching the given pattern.

=over 4

=item * pattern

=back

L<https://redis.io/commands/keys>

=cut

sub keys : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(KEYS) => @args)
}

=head2 migrate

Atomically transfer a key from a Redis instance to another one.

=over 4

=item * host

=item * port

=item * key|""

=item * destination-db

=item * timeout

=item * [COPY]

=item * [REPLACE]

=item * [KEYS key [key ...]]

=back

L<https://redis.io/commands/migrate>

=cut

sub migrate : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(MIGRATE) => @args)
}

=head2 move

Move a key to another database.

=over 4

=item * key

=item * db

=back

L<https://redis.io/commands/move>

=cut

sub move : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(MOVE) => @args)
}

=head2 object

Inspect the internals of Redis objects.

=over 4

=item * subcommand

=item * [arguments [arguments ...]]

=back

L<https://redis.io/commands/object>

=cut

sub object : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(OBJECT) => @args)
}

=head2 persist

Remove the expiration from a key.

=over 4

=item * key

=back

L<https://redis.io/commands/persist>

=cut

sub persist : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PERSIST) => @args)
}

=head2 pexpire

Set a key's time to live in milliseconds.

=over 4

=item * key

=item * milliseconds

=back

L<https://redis.io/commands/pexpire>

=cut

sub pexpire : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PEXPIRE) => @args)
}

=head2 pexpireat

Set the expiration for a key as a UNIX timestamp specified in milliseconds.

=over 4

=item * key

=item * milliseconds-timestamp

=back

L<https://redis.io/commands/pexpireat>

=cut

sub pexpireat : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PEXPIREAT) => @args)
}

=head2 pttl

Get the time to live for a key in milliseconds.

=over 4

=item * key

=back

L<https://redis.io/commands/pttl>

=cut

sub pttl : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PTTL) => @args)
}

=head2 randomkey

Return a random key from the keyspace.

L<https://redis.io/commands/randomkey>

=cut

sub randomkey : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(RANDOMKEY) => @args)
}

=head2 rename

Rename a key.

=over 4

=item * key

=item * newkey

=back

L<https://redis.io/commands/rename>

=cut

sub rename : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(RENAME) => @args)
}

=head2 renamenx

Rename a key, only if the new key does not exist.

=over 4

=item * key

=item * newkey

=back

L<https://redis.io/commands/renamenx>

=cut

sub renamenx : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(RENAMENX) => @args)
}

=head2 restore

Create a key using the provided serialized value, previously obtained using DUMP.

=over 4

=item * key

=item * ttl

=item * serialized-value

=item * [REPLACE]

=back

L<https://redis.io/commands/restore>

=cut

sub restore : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(RESTORE) => @args)
}

=head2 sort

Sort the elements in a list, set or sorted set.

=over 4

=item * key

=item * [BY pattern]

=item * [LIMIT offset count]

=item * [GET pattern [GET pattern ...]]

=item * [ASC|DESC]

=item * [ALPHA]

=item * [STORE destination]

=back

L<https://redis.io/commands/sort>

=cut

sub sort : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SORT) => @args)
}

=head2 touch

Alters the last access time of a key(s). Returns the number of existing keys specified.

=over 4

=item * key [key ...]

=back

L<https://redis.io/commands/touch>

=cut

sub touch : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(TOUCH) => @args)
}

=head2 ttl

Get the time to live for a key.

=over 4

=item * key

=back

L<https://redis.io/commands/ttl>

=cut

sub ttl : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(TTL) => @args)
}

=head2 type

Determine the type stored at key.

=over 4

=item * key

=back

L<https://redis.io/commands/type>

=cut

sub type : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(TYPE) => @args)
}

=head2 unlink

Delete a key asynchronously in another thread. Otherwise it is just as DEL, but non blocking.

=over 4

=item * key [key ...]

=back

L<https://redis.io/commands/unlink>

=cut

sub unlink : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(UNLINK) => @args)
}

=head2 wait

Wait for the synchronous replication of all the write commands sent in the context of the current connection.

=over 4

=item * numslaves

=item * timeout

=back

L<https://redis.io/commands/wait>

=cut

sub wait : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(WAIT) => @args)
}

=head2 scan

Incrementally iterate the keys space.

=over 4

=item * cursor

=item * [MATCH pattern]

=item * [COUNT count]

=back

L<https://redis.io/commands/scan>

=cut

sub scan : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SCAN) => @args)
}

=head1 METHODS - Geo

=head2 geoadd

Add one or more geospatial items in the geospatial index represented using a sorted set.

=over 4

=item * key

=item * longitude latitude member [longitude latitude member ...]

=back

L<https://redis.io/commands/geoadd>

=cut

sub geoadd : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(GEOADD) => @args)
}

=head2 geohash

Returns members of a geospatial index as standard geohash strings.

=over 4

=item * key

=item * member [member ...]

=back

L<https://redis.io/commands/geohash>

=cut

sub geohash : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(GEOHASH) => @args)
}

=head2 geopos

Returns longitude and latitude of members of a geospatial index.

=over 4

=item * key

=item * member [member ...]

=back

L<https://redis.io/commands/geopos>

=cut

sub geopos : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(GEOPOS) => @args)
}

=head2 geodist

Returns the distance between two members of a geospatial index.

=over 4

=item * key

=item * member1

=item * member2

=item * [unit]

=back

L<https://redis.io/commands/geodist>

=cut

sub geodist : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(GEODIST) => @args)
}

=head2 georadius

Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a point.

=over 4

=item * key

=item * longitude

=item * latitude

=item * radius

=item * m|km|ft|mi

=item * [WITHCOORD]

=item * [WITHDIST]

=item * [WITHHASH]

=item * [COUNT count]

=item * [ASC|DESC]

=item * [STORE key]

=item * [STOREDIST key]

=back

L<https://redis.io/commands/georadius>

=cut

sub georadius : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(GEORADIUS) => @args)
}

=head2 georadiusbymember

Query a sorted set representing a geospatial index to fetch members matching a given maximum distance from a member.

=over 4

=item * key

=item * member

=item * radius

=item * m|km|ft|mi

=item * [WITHCOORD]

=item * [WITHDIST]

=item * [WITHHASH]

=item * [COUNT count]

=item * [ASC|DESC]

=item * [STORE key]

=item * [STOREDIST key]

=back

L<https://redis.io/commands/georadiusbymember>

=cut

sub georadiusbymember : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(GEORADIUSBYMEMBER) => @args)
}

=head1 METHODS - Hash

=head2 hdel

Delete one or more hash fields.

=over 4

=item * key

=item * field [field ...]

=back

L<https://redis.io/commands/hdel>

=cut

sub hdel : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HDEL) => @args)
}

=head2 hexists

Determine if a hash field exists.

=over 4

=item * key

=item * field

=back

L<https://redis.io/commands/hexists>

=cut

sub hexists : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HEXISTS) => @args)
}

=head2 hget

Get the value of a hash field.

=over 4

=item * key

=item * field

=back

L<https://redis.io/commands/hget>

=cut

sub hget : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HGET) => @args)
}

=head2 hgetall

Get all the fields and values in a hash.

=over 4

=item * key

=back

L<https://redis.io/commands/hgetall>

=cut

sub hgetall : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HGETALL) => @args)
}

=head2 hincrby

Increment the integer value of a hash field by the given number.

=over 4

=item * key

=item * field

=item * increment

=back

L<https://redis.io/commands/hincrby>

=cut

sub hincrby : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HINCRBY) => @args)
}

=head2 hincrbyfloat

Increment the float value of a hash field by the given amount.

=over 4

=item * key

=item * field

=item * increment

=back

L<https://redis.io/commands/hincrbyfloat>

=cut

sub hincrbyfloat : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HINCRBYFLOAT) => @args)
}

=head2 hkeys

Get all the fields in a hash.

=over 4

=item * key

=back

L<https://redis.io/commands/hkeys>

=cut

sub hkeys : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HKEYS) => @args)
}

=head2 hlen

Get the number of fields in a hash.

=over 4

=item * key

=back

L<https://redis.io/commands/hlen>

=cut

sub hlen : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HLEN) => @args)
}

=head2 hmget

Get the values of all the given hash fields.

=over 4

=item * key

=item * field [field ...]

=back

L<https://redis.io/commands/hmget>

=cut

sub hmget : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HMGET) => @args)
}

=head2 hmset

Set multiple hash fields to multiple values.

=over 4

=item * key

=item * field value [field value ...]

=back

L<https://redis.io/commands/hmset>

=cut

sub hmset : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HMSET) => @args)
}

=head2 hset

Set the string value of a hash field.

=over 4

=item * key

=item * field

=item * value

=back

L<https://redis.io/commands/hset>

=cut

sub hset : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HSET) => @args)
}

=head2 hsetnx

Set the value of a hash field, only if the field does not exist.

=over 4

=item * key

=item * field

=item * value

=back

L<https://redis.io/commands/hsetnx>

=cut

sub hsetnx : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HSETNX) => @args)
}

=head2 hstrlen

Get the length of the value of a hash field.

=over 4

=item * key

=item * field

=back

L<https://redis.io/commands/hstrlen>

=cut

sub hstrlen : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HSTRLEN) => @args)
}

=head2 hvals

Get all the values in a hash.

=over 4

=item * key

=back

L<https://redis.io/commands/hvals>

=cut

sub hvals : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HVALS) => @args)
}

=head2 hscan

Incrementally iterate hash fields and associated values.

=over 4

=item * key

=item * cursor

=item * [MATCH pattern]

=item * [COUNT count]

=back

L<https://redis.io/commands/hscan>

=cut

sub hscan : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(HSCAN) => @args)
}

=head1 METHODS - Hyperloglog

=head2 pfadd

Adds the specified elements to the specified HyperLogLog.

=over 4

=item * key

=item * element [element ...]

=back

L<https://redis.io/commands/pfadd>

=cut

sub pfadd : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PFADD) => @args)
}

=head2 pfcount

Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).

=over 4

=item * key [key ...]

=back

L<https://redis.io/commands/pfcount>

=cut

sub pfcount : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PFCOUNT) => @args)
}

=head2 pfmerge

Merge N different HyperLogLogs into a single one.

=over 4

=item * destkey

=item * sourcekey [sourcekey ...]

=back

L<https://redis.io/commands/pfmerge>

=cut

sub pfmerge : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PFMERGE) => @args)
}

=head1 METHODS - List

=head2 blpop

Remove and get the first element in a list, or block until one is available.

=over 4

=item * key [key ...]

=item * timeout

=back

L<https://redis.io/commands/blpop>

=cut

sub blpop : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(BLPOP) => @args)
}

=head2 brpop

Remove and get the last element in a list, or block until one is available.

=over 4

=item * key [key ...]

=item * timeout

=back

L<https://redis.io/commands/brpop>

=cut

sub brpop : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(BRPOP) => @args)
}

=head2 brpoplpush

Pop a value from a list, push it to another list and return it; or block until one is available.

=over 4

=item * source

=item * destination

=item * timeout

=back

L<https://redis.io/commands/brpoplpush>

=cut

sub brpoplpush : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(BRPOPLPUSH) => @args)
}

=head2 lindex

Get an element from a list by its index.

=over 4

=item * key

=item * index

=back

L<https://redis.io/commands/lindex>

=cut

sub lindex : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LINDEX) => @args)
}

=head2 linsert

Insert an element before or after another element in a list.

=over 4

=item * key

=item * BEFORE|AFTER

=item * pivot

=item * value

=back

L<https://redis.io/commands/linsert>

=cut

sub linsert : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LINSERT) => @args)
}

=head2 llen

Get the length of a list.

=over 4

=item * key

=back

L<https://redis.io/commands/llen>

=cut

sub llen : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LLEN) => @args)
}

=head2 lpop

Remove and get the first element in a list.

=over 4

=item * key

=back

L<https://redis.io/commands/lpop>

=cut

sub lpop : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LPOP) => @args)
}

=head2 lpush

Prepend one or multiple values to a list.

=over 4

=item * key

=item * value [value ...]

=back

L<https://redis.io/commands/lpush>

=cut

sub lpush : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LPUSH) => @args)
}

=head2 lpushx

Prepend a value to a list, only if the list exists.

=over 4

=item * key

=item * value

=back

L<https://redis.io/commands/lpushx>

=cut

sub lpushx : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LPUSHX) => @args)
}

=head2 lrange

Get a range of elements from a list.

=over 4

=item * key

=item * start

=item * stop

=back

L<https://redis.io/commands/lrange>

=cut

sub lrange : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LRANGE) => @args)
}

=head2 lrem

Remove elements from a list.

=over 4

=item * key

=item * count

=item * value

=back

L<https://redis.io/commands/lrem>

=cut

sub lrem : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LREM) => @args)
}

=head2 lset

Set the value of an element in a list by its index.

=over 4

=item * key

=item * index

=item * value

=back

L<https://redis.io/commands/lset>

=cut

sub lset : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LSET) => @args)
}

=head2 ltrim

Trim a list to the specified range.

=over 4

=item * key

=item * start

=item * stop

=back

L<https://redis.io/commands/ltrim>

=cut

sub ltrim : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LTRIM) => @args)
}

=head2 rpop

Remove and get the last element in a list.

=over 4

=item * key

=back

L<https://redis.io/commands/rpop>

=cut

sub rpop : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(RPOP) => @args)
}

=head2 rpoplpush

Remove the last element in a list, prepend it to another list and return it.

=over 4

=item * source

=item * destination

=back

L<https://redis.io/commands/rpoplpush>

=cut

sub rpoplpush : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(RPOPLPUSH) => @args)
}

=head2 rpush

Append one or multiple values to a list.

=over 4

=item * key

=item * value [value ...]

=back

L<https://redis.io/commands/rpush>

=cut

sub rpush : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(RPUSH) => @args)
}

=head2 rpushx

Append a value to a list, only if the list exists.

=over 4

=item * key

=item * value

=back

L<https://redis.io/commands/rpushx>

=cut

sub rpushx : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(RPUSHX) => @args)
}

=head1 METHODS - Pubsub

=head2 psubscribe

Listen for messages published to channels matching the given patterns.

=over 4

=item * pattern [pattern ...]

=back

L<https://redis.io/commands/psubscribe>

=cut

sub psubscribe : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PSUBSCRIBE) => @args)
}

=head2 pubsub

Inspect the state of the Pub/Sub subsystem.

=over 4

=item * subcommand

=item * [argument [argument ...]]

=back

L<https://redis.io/commands/pubsub>

=cut

sub pubsub : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PUBSUB) => @args)
}

=head2 publish

Post a message to a channel.

=over 4

=item * channel

=item * message

=back

L<https://redis.io/commands/publish>

=cut

sub publish : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PUBLISH) => @args)
}

=head2 punsubscribe

Stop listening for messages posted to channels matching the given patterns.

=over 4

=item * [pattern [pattern ...]]

=back

L<https://redis.io/commands/punsubscribe>

=cut

sub punsubscribe : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PUNSUBSCRIBE) => @args)
}

=head2 subscribe

Listen for messages published to the given channels.

=over 4

=item * channel [channel ...]

=back

L<https://redis.io/commands/subscribe>

=cut

sub subscribe : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SUBSCRIBE) => @args)
}

=head2 unsubscribe

Stop listening for messages posted to the given channels.

=over 4

=item * [channel [channel ...]]

=back

L<https://redis.io/commands/unsubscribe>

=cut

sub unsubscribe : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(UNSUBSCRIBE) => @args)
}

=head1 METHODS - Scripting

=head2 eval

Execute a Lua script server side.

=over 4

=item * script

=item * numkeys

=item * key [key ...]

=item * arg [arg ...]

=back

L<https://redis.io/commands/eval>

=cut

sub eval : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(EVAL) => @args)
}

=head2 evalsha

Execute a Lua script server side.

=over 4

=item * sha1

=item * numkeys

=item * key [key ...]

=item * arg [arg ...]

=back

L<https://redis.io/commands/evalsha>

=cut

sub evalsha : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(EVALSHA) => @args)
}

=head2 script_debug

Set the debug mode for executed scripts.

=over 4

=item * YES|SYNC|NO

=back

L<https://redis.io/commands/script-debug>

=cut

sub script_debug : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SCRIPT DEBUG) => @args)
}

=head2 script_exists

Check existence of scripts in the script cache.

=over 4

=item * sha1 [sha1 ...]

=back

L<https://redis.io/commands/script-exists>

=cut

sub script_exists : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SCRIPT EXISTS) => @args)
}

=head2 script_flush

Remove all the scripts from the script cache.

L<https://redis.io/commands/script-flush>

=cut

sub script_flush : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SCRIPT FLUSH) => @args)
}

=head2 script_kill

Kill the script currently in execution.

L<https://redis.io/commands/script-kill>

=cut

sub script_kill : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SCRIPT KILL) => @args)
}

=head2 script_load

Load the specified Lua script into the script cache.

=over 4

=item * script

=back

L<https://redis.io/commands/script-load>

=cut

sub script_load : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SCRIPT LOAD) => @args)
}

=head1 METHODS - Server

=head2 bgrewriteaof

Asynchronously rewrite the append-only file.

L<https://redis.io/commands/bgrewriteaof>

=cut

sub bgrewriteaof : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(BGREWRITEAOF) => @args)
}

=head2 bgsave

Asynchronously save the dataset to disk.

L<https://redis.io/commands/bgsave>

=cut

sub bgsave : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(BGSAVE) => @args)
}

=head2 client_kill

Kill the connection of a client.

=over 4

=item * [ip:port]

=item * [ID client-id]

=item * [TYPE normal|master|slave|pubsub]

=item * [ADDR ip:port]

=item * [SKIPME yes/no]

=back

L<https://redis.io/commands/client-kill>

=cut

sub client_kill : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLIENT KILL) => @args)
}

=head2 client_list

Get the list of client connections.

L<https://redis.io/commands/client-list>

=cut

sub client_list : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLIENT LIST) => @args)
}

=head2 client_getname

Get the current connection name.

L<https://redis.io/commands/client-getname>

=cut

sub client_getname : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLIENT GETNAME) => @args)
}

=head2 client_pause

Stop processing commands from clients for some time.

=over 4

=item * timeout

=back

L<https://redis.io/commands/client-pause>

=cut

sub client_pause : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLIENT PAUSE) => @args)
}

=head2 client_reply

Instruct the server whether to reply to commands.

=over 4

=item * ON|OFF|SKIP

=back

L<https://redis.io/commands/client-reply>

=cut

sub client_reply : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLIENT REPLY) => @args)
}

=head2 client_setname

Set the current connection name.

=over 4

=item * connection-name

=back

L<https://redis.io/commands/client-setname>

=cut

sub client_setname : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CLIENT SETNAME) => @args)
}

=head2 command

Get array of Redis command details.

L<https://redis.io/commands/command>

=cut

sub command : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(COMMAND) => @args)
}

=head2 command_count

Get total number of Redis commands.

L<https://redis.io/commands/command-count>

=cut

sub command_count : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(COMMAND COUNT) => @args)
}

=head2 command_getkeys

Extract keys given a full Redis command.

L<https://redis.io/commands/command-getkeys>

=cut

sub command_getkeys : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(COMMAND GETKEYS) => @args)
}

=head2 command_info

Get array of specific Redis command details.

=over 4

=item * command-name [command-name ...]

=back

L<https://redis.io/commands/command-info>

=cut

sub command_info : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(COMMAND INFO) => @args)
}

=head2 config_get

Get the value of a configuration parameter.

=over 4

=item * parameter

=back

L<https://redis.io/commands/config-get>

=cut

sub config_get : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CONFIG GET) => @args)
}

=head2 config_rewrite

Rewrite the configuration file with the in memory configuration.

L<https://redis.io/commands/config-rewrite>

=cut

sub config_rewrite : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CONFIG REWRITE) => @args)
}

=head2 config_set

Set a configuration parameter to the given value.

=over 4

=item * parameter

=item * value

=back

L<https://redis.io/commands/config-set>

=cut

sub config_set : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CONFIG SET) => @args)
}

=head2 config_resetstat

Reset the stats returned by INFO.

L<https://redis.io/commands/config-resetstat>

=cut

sub config_resetstat : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(CONFIG RESETSTAT) => @args)
}

=head2 dbsize

Return the number of keys in the selected database.

L<https://redis.io/commands/dbsize>

=cut

sub dbsize : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(DBSIZE) => @args)
}

=head2 debug_object

Get debugging information about a key.

=over 4

=item * key

=back

L<https://redis.io/commands/debug-object>

=cut

sub debug_object : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(DEBUG OBJECT) => @args)
}

=head2 debug_segfault

Make the server crash.

L<https://redis.io/commands/debug-segfault>

=cut

sub debug_segfault : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(DEBUG SEGFAULT) => @args)
}

=head2 flushall

Remove all keys from all databases.

=over 4

=item * [ASYNC]

=back

L<https://redis.io/commands/flushall>

=cut

sub flushall : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(FLUSHALL) => @args)
}

=head2 flushdb

Remove all keys from the current database.

=over 4

=item * [ASYNC]

=back

L<https://redis.io/commands/flushdb>

=cut

sub flushdb : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(FLUSHDB) => @args)
}

=head2 info

Get information and statistics about the server.

=over 4

=item * [section]

=back

L<https://redis.io/commands/info>

=cut

sub info : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(INFO) => @args)
}

=head2 lastsave

Get the UNIX time stamp of the last successful save to disk.

L<https://redis.io/commands/lastsave>

=cut

sub lastsave : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(LASTSAVE) => @args)
}

=head2 monitor

Listen for all requests received by the server in real time.

L<https://redis.io/commands/monitor>

=cut

sub monitor : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(MONITOR) => @args)
}

=head2 role

Return the role of the instance in the context of replication.

L<https://redis.io/commands/role>

=cut

sub role : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ROLE) => @args)
}

=head2 save

Synchronously save the dataset to disk.

L<https://redis.io/commands/save>

=cut

sub save : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SAVE) => @args)
}

=head2 shutdown

Synchronously save the dataset to disk and then shut down the server.

=over 4

=item * [NOSAVE|SAVE]

=back

L<https://redis.io/commands/shutdown>

=cut

sub shutdown : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SHUTDOWN) => @args)
}

=head2 slaveof

Make the server a slave of another instance, or promote it as master.

=over 4

=item * host

=item * port

=back

L<https://redis.io/commands/slaveof>

=cut

sub slaveof : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SLAVEOF) => @args)
}

=head2 slowlog

Manages the Redis slow queries log.

=over 4

=item * subcommand

=item * [argument]

=back

L<https://redis.io/commands/slowlog>

=cut

sub slowlog : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SLOWLOG) => @args)
}

=head2 sync

Internal command used for replication.

L<https://redis.io/commands/sync>

=cut

sub sync : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SYNC) => @args)
}

=head2 time

Return the current server time.

L<https://redis.io/commands/time>

=cut

sub time : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(TIME) => @args)
}

=head1 METHODS - Set

=head2 sadd

Add one or more members to a set.

=over 4

=item * key

=item * member [member ...]

=back

L<https://redis.io/commands/sadd>

=cut

sub sadd : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SADD) => @args)
}

=head2 scard

Get the number of members in a set.

=over 4

=item * key

=back

L<https://redis.io/commands/scard>

=cut

sub scard : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SCARD) => @args)
}

=head2 sdiff

Subtract multiple sets.

=over 4

=item * key [key ...]

=back

L<https://redis.io/commands/sdiff>

=cut

sub sdiff : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SDIFF) => @args)
}

=head2 sdiffstore

Subtract multiple sets and store the resulting set in a key.

=over 4

=item * destination

=item * key [key ...]

=back

L<https://redis.io/commands/sdiffstore>

=cut

sub sdiffstore : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SDIFFSTORE) => @args)
}

=head2 sinter

Intersect multiple sets.

=over 4

=item * key [key ...]

=back

L<https://redis.io/commands/sinter>

=cut

sub sinter : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SINTER) => @args)
}

=head2 sinterstore

Intersect multiple sets and store the resulting set in a key.

=over 4

=item * destination

=item * key [key ...]

=back

L<https://redis.io/commands/sinterstore>

=cut

sub sinterstore : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SINTERSTORE) => @args)
}

=head2 sismember

Determine if a given value is a member of a set.

=over 4

=item * key

=item * member

=back

L<https://redis.io/commands/sismember>

=cut

sub sismember : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SISMEMBER) => @args)
}

=head2 smembers

Get all the members in a set.

=over 4

=item * key

=back

L<https://redis.io/commands/smembers>

=cut

sub smembers : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SMEMBERS) => @args)
}

=head2 smove

Move a member from one set to another.

=over 4

=item * source

=item * destination

=item * member

=back

L<https://redis.io/commands/smove>

=cut

sub smove : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SMOVE) => @args)
}

=head2 spop

Remove and return one or multiple random members from a set.

=over 4

=item * key

=item * [count]

=back

L<https://redis.io/commands/spop>

=cut

sub spop : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SPOP) => @args)
}

=head2 srandmember

Get one or multiple random members from a set.

=over 4

=item * key

=item * [count]

=back

L<https://redis.io/commands/srandmember>

=cut

sub srandmember : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SRANDMEMBER) => @args)
}

=head2 srem

Remove one or more members from a set.

=over 4

=item * key

=item * member [member ...]

=back

L<https://redis.io/commands/srem>

=cut

sub srem : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SREM) => @args)
}

=head2 sunion

Add multiple sets.

=over 4

=item * key [key ...]

=back

L<https://redis.io/commands/sunion>

=cut

sub sunion : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SUNION) => @args)
}

=head2 sunionstore

Add multiple sets and store the resulting set in a key.

=over 4

=item * destination

=item * key [key ...]

=back

L<https://redis.io/commands/sunionstore>

=cut

sub sunionstore : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SUNIONSTORE) => @args)
}

=head2 sscan

Incrementally iterate Set elements.

=over 4

=item * key

=item * cursor

=item * [MATCH pattern]

=item * [COUNT count]

=back

L<https://redis.io/commands/sscan>

=cut

sub sscan : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SSCAN) => @args)
}

=head1 METHODS - Sorted_set

=head2 zadd

Add one or more members to a sorted set, or update its score if it already exists.

=over 4

=item * key

=item * [NX|XX]

=item * [CH]

=item * [INCR]

=item * score member [score member ...]

=back

L<https://redis.io/commands/zadd>

=cut

sub zadd : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZADD) => @args)
}

=head2 zcard

Get the number of members in a sorted set.

=over 4

=item * key

=back

L<https://redis.io/commands/zcard>

=cut

sub zcard : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZCARD) => @args)
}

=head2 zcount

Count the members in a sorted set with scores within the given values.

=over 4

=item * key

=item * min

=item * max

=back

L<https://redis.io/commands/zcount>

=cut

sub zcount : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZCOUNT) => @args)
}

=head2 zincrby

Increment the score of a member in a sorted set.

=over 4

=item * key

=item * increment

=item * member

=back

L<https://redis.io/commands/zincrby>

=cut

sub zincrby : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZINCRBY) => @args)
}

=head2 zinterstore

Intersect multiple sorted sets and store the resulting sorted set in a new key.

=over 4

=item * destination

=item * numkeys

=item * key [key ...]

=item * [WEIGHTS weight [weight ...]]

=item * [AGGREGATE SUM|MIN|MAX]

=back

L<https://redis.io/commands/zinterstore>

=cut

sub zinterstore : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZINTERSTORE) => @args)
}

=head2 zlexcount

Count the number of members in a sorted set between a given lexicographical range.

=over 4

=item * key

=item * min

=item * max

=back

L<https://redis.io/commands/zlexcount>

=cut

sub zlexcount : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZLEXCOUNT) => @args)
}

=head2 zrange

Return a range of members in a sorted set, by index.

=over 4

=item * key

=item * start

=item * stop

=item * [WITHSCORES]

=back

L<https://redis.io/commands/zrange>

=cut

sub zrange : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZRANGE) => @args)
}

=head2 zrangebylex

Return a range of members in a sorted set, by lexicographical range.

=over 4

=item * key

=item * min

=item * max

=item * [LIMIT offset count]

=back

L<https://redis.io/commands/zrangebylex>

=cut

sub zrangebylex : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZRANGEBYLEX) => @args)
}

=head2 zrevrangebylex

Return a range of members in a sorted set, by lexicographical range, ordered from higher to lower strings.

=over 4

=item * key

=item * max

=item * min

=item * [LIMIT offset count]

=back

L<https://redis.io/commands/zrevrangebylex>

=cut

sub zrevrangebylex : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZREVRANGEBYLEX) => @args)
}

=head2 zrangebyscore

Return a range of members in a sorted set, by score.

=over 4

=item * key

=item * min

=item * max

=item * [WITHSCORES]

=item * [LIMIT offset count]

=back

L<https://redis.io/commands/zrangebyscore>

=cut

sub zrangebyscore : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZRANGEBYSCORE) => @args)
}

=head2 zrank

Determine the index of a member in a sorted set.

=over 4

=item * key

=item * member

=back

L<https://redis.io/commands/zrank>

=cut

sub zrank : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZRANK) => @args)
}

=head2 zrem

Remove one or more members from a sorted set.

=over 4

=item * key

=item * member [member ...]

=back

L<https://redis.io/commands/zrem>

=cut

sub zrem : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZREM) => @args)
}

=head2 zremrangebylex

Remove all members in a sorted set between the given lexicographical range.

=over 4

=item * key

=item * min

=item * max

=back

L<https://redis.io/commands/zremrangebylex>

=cut

sub zremrangebylex : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZREMRANGEBYLEX) => @args)
}

=head2 zremrangebyrank

Remove all members in a sorted set within the given indexes.

=over 4

=item * key

=item * start

=item * stop

=back

L<https://redis.io/commands/zremrangebyrank>

=cut

sub zremrangebyrank : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZREMRANGEBYRANK) => @args)
}

=head2 zremrangebyscore

Remove all members in a sorted set within the given scores.

=over 4

=item * key

=item * min

=item * max

=back

L<https://redis.io/commands/zremrangebyscore>

=cut

sub zremrangebyscore : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZREMRANGEBYSCORE) => @args)
}

=head2 zrevrange

Return a range of members in a sorted set, by index, with scores ordered from high to low.

=over 4

=item * key

=item * start

=item * stop

=item * [WITHSCORES]

=back

L<https://redis.io/commands/zrevrange>

=cut

sub zrevrange : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZREVRANGE) => @args)
}

=head2 zrevrangebyscore

Return a range of members in a sorted set, by score, with scores ordered from high to low.

=over 4

=item * key

=item * max

=item * min

=item * [WITHSCORES]

=item * [LIMIT offset count]

=back

L<https://redis.io/commands/zrevrangebyscore>

=cut

sub zrevrangebyscore : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZREVRANGEBYSCORE) => @args)
}

=head2 zrevrank

Determine the index of a member in a sorted set, with scores ordered from high to low.

=over 4

=item * key

=item * member

=back

L<https://redis.io/commands/zrevrank>

=cut

sub zrevrank : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZREVRANK) => @args)
}

=head2 zscore

Get the score associated with the given member in a sorted set.

=over 4

=item * key

=item * member

=back

L<https://redis.io/commands/zscore>

=cut

sub zscore : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZSCORE) => @args)
}

=head2 zunionstore

Add multiple sorted sets and store the resulting sorted set in a new key.

=over 4

=item * destination

=item * numkeys

=item * key [key ...]

=item * [WEIGHTS weight [weight ...]]

=item * [AGGREGATE SUM|MIN|MAX]

=back

L<https://redis.io/commands/zunionstore>

=cut

sub zunionstore : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZUNIONSTORE) => @args)
}

=head2 zscan

Incrementally iterate sorted sets elements and associated scores.

=over 4

=item * key

=item * cursor

=item * [MATCH pattern]

=item * [COUNT count]

=back

L<https://redis.io/commands/zscan>

=cut

sub zscan : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(ZSCAN) => @args)
}

=head1 METHODS - String

=head2 append

Append a value to a key.

=over 4

=item * key

=item * value

=back

L<https://redis.io/commands/append>

=cut

sub append : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(APPEND) => @args)
}

=head2 bitcount

Count set bits in a string.

=over 4

=item * key

=item * [start end]

=back

L<https://redis.io/commands/bitcount>

=cut

sub bitcount : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(BITCOUNT) => @args)
}

=head2 bitfield

Perform arbitrary bitfield integer operations on strings.

=over 4

=item * key

=item * [GET type offset]

=item * [SET type offset value]

=item * [INCRBY type offset increment]

=item * [OVERFLOW WRAP|SAT|FAIL]

=back

L<https://redis.io/commands/bitfield>

=cut

sub bitfield : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(BITFIELD) => @args)
}

=head2 bitop

Perform bitwise operations between strings.

=over 4

=item * operation

=item * destkey

=item * key [key ...]

=back

L<https://redis.io/commands/bitop>

=cut

sub bitop : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(BITOP) => @args)
}

=head2 bitpos

Find first bit set or clear in a string.

=over 4

=item * key

=item * bit

=item * [start]

=item * [end]

=back

L<https://redis.io/commands/bitpos>

=cut

sub bitpos : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(BITPOS) => @args)
}

=head2 decr

Decrement the integer value of a key by one.

=over 4

=item * key

=back

L<https://redis.io/commands/decr>

=cut

sub decr : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(DECR) => @args)
}

=head2 decrby

Decrement the integer value of a key by the given number.

=over 4

=item * key

=item * decrement

=back

L<https://redis.io/commands/decrby>

=cut

sub decrby : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(DECRBY) => @args)
}

=head2 get

Get the value of a key.

=over 4

=item * key

=back

L<https://redis.io/commands/get>

=cut

sub get : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(GET) => @args)
}

=head2 getbit

Returns the bit value at offset in the string value stored at key.

=over 4

=item * key

=item * offset

=back

L<https://redis.io/commands/getbit>

=cut

sub getbit : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(GETBIT) => @args)
}

=head2 getrange

Get a substring of the string stored at a key.

=over 4

=item * key

=item * start

=item * end

=back

L<https://redis.io/commands/getrange>

=cut

sub getrange : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(GETRANGE) => @args)
}

=head2 getset

Set the string value of a key and return its old value.

=over 4

=item * key

=item * value

=back

L<https://redis.io/commands/getset>

=cut

sub getset : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(GETSET) => @args)
}

=head2 incr

Increment the integer value of a key by one.

=over 4

=item * key

=back

L<https://redis.io/commands/incr>

=cut

sub incr : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(INCR) => @args)
}

=head2 incrby

Increment the integer value of a key by the given amount.

=over 4

=item * key

=item * increment

=back

L<https://redis.io/commands/incrby>

=cut

sub incrby : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(INCRBY) => @args)
}

=head2 incrbyfloat

Increment the float value of a key by the given amount.

=over 4

=item * key

=item * increment

=back

L<https://redis.io/commands/incrbyfloat>

=cut

sub incrbyfloat : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(INCRBYFLOAT) => @args)
}

=head2 mget

Get the values of all the given keys.

=over 4

=item * key [key ...]

=back

L<https://redis.io/commands/mget>

=cut

sub mget : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(MGET) => @args)
}

=head2 mset

Set multiple keys to multiple values.

=over 4

=item * key value [key value ...]

=back

L<https://redis.io/commands/mset>

=cut

sub mset : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(MSET) => @args)
}

=head2 msetnx

Set multiple keys to multiple values, only if none of the keys exist.

=over 4

=item * key value [key value ...]

=back

L<https://redis.io/commands/msetnx>

=cut

sub msetnx : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(MSETNX) => @args)
}

=head2 psetex

Set the value and expiration in milliseconds of a key.

=over 4

=item * key

=item * milliseconds

=item * value

=back

L<https://redis.io/commands/psetex>

=cut

sub psetex : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(PSETEX) => @args)
}

=head2 set

Set the string value of a key.

=over 4

=item * key

=item * value

=item * [EX seconds]

=item * [PX milliseconds]

=item * [NX|XX]

=back

L<https://redis.io/commands/set>

=cut

sub set : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SET) => @args)
}

=head2 setbit

Sets or clears the bit at offset in the string value stored at key.

=over 4

=item * key

=item * offset

=item * value

=back

L<https://redis.io/commands/setbit>

=cut

sub setbit : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SETBIT) => @args)
}

=head2 setex

Set the value and expiration of a key.

=over 4

=item * key

=item * seconds

=item * value

=back

L<https://redis.io/commands/setex>

=cut

sub setex : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SETEX) => @args)
}

=head2 setnx

Set the value of a key, only if the key does not exist.

=over 4

=item * key

=item * value

=back

L<https://redis.io/commands/setnx>

=cut

sub setnx : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SETNX) => @args)
}

=head2 setrange

Overwrite part of a string at key starting at the specified offset.

=over 4

=item * key

=item * offset

=item * value

=back

L<https://redis.io/commands/setrange>

=cut

sub setrange : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(SETRANGE) => @args)
}

=head2 strlen

Get the length of the value stored in a key.

=over 4

=item * key

=back

L<https://redis.io/commands/strlen>

=cut

sub strlen : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(STRLEN) => @args)
}

=head1 METHODS - Transactions

=head2 discard

Discard all commands issued after MULTI.

L<https://redis.io/commands/discard>

=cut

sub discard : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(DISCARD) => @args)
}

=head2 exec

Execute all commands issued after MULTI.

L<https://redis.io/commands/exec>

=cut

sub exec : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(EXEC) => @args)
}

=head2 multi

Mark the start of a transaction block.

L<https://redis.io/commands/multi>

=cut

sub multi : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(MULTI) => @args)
}

=head2 unwatch

Forget about all watched keys.

L<https://redis.io/commands/unwatch>

=cut

sub unwatch : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(UNWATCH) => @args)
}

=head2 watch

Watch the given keys to determine execution of the MULTI/EXEC block.

=over 4

=item * key [key ...]

=back

L<https://redis.io/commands/watch>

=cut

sub watch : method {
    my ($self, @args) = @_;
    $self->execute_command(qw(WATCH) => @args)
}

1;

__END__

=head1 AUTHOR

Tom Molesworth <TEAM@cpan.org>

=head1 LICENSE

Copyright Tom Molesworth 2015-2017. Licensed under the same terms as Perl itself.

