package Google::Ads::AdWords::v201809::RemarketingSettings;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/mcm/v201809' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %snippet_of :ATTR(:get<snippet>);
my %googleGlobalSiteTag_of :ATTR(:get<googleGlobalSiteTag>);

__PACKAGE__->_factory(
    [ qw(        snippet
        googleGlobalSiteTag

    ) ],
    {
        'snippet' => \%snippet_of,
        'googleGlobalSiteTag' => \%googleGlobalSiteTag_of,
    },
    {
        'snippet' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'googleGlobalSiteTag' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'snippet' => 'snippet',
        'googleGlobalSiteTag' => 'googleGlobalSiteTag',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201809::RemarketingSettings

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RemarketingSettings from the namespace https://adwords.google.com/api/adwords/mcm/v201809.

Customer-wide settings related to AdWords remarketing. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * snippet


=item * googleGlobalSiteTag




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

