#!/usr/bin/env perl
# Copyright (C) 2015 Rocky Bernstein <rocky@cpan.org>
package Devel::Trepan::Deparse;
our $VERSION='2.0.0';
"All of the real action is in Devel::Trepan::CmdProcessor::Command::Deparse.pm";
__END__

=pod

=for comment
This file is shared by both Deparse.pod and Deparse.pm after
its __END__
Deparse.pod is useful in the Github wiki:
https://github.com/rocky/Perl-Devel-Trepan-Deparse/wiki
where we can immediately see the results and others can contribute.

=for comment
The version Deparse.pm however is what is seen at
https://metacpan.org/module/Devel::Trepan::Deparse and when folks
download this file.

=head1 NAME

Perl Deparse plugin for L<Devel::Trepan> via L<B::DeparseTree>

=head1 SUMMARY

This adds a I<deparse> command to the L<Devel::Trepan> debugger.

=head1 DESCRIPTION

=head1 AUTHORS

Rocky Bernstein

=head1 COPYRIGHT

Copyright (C) 2015 Rocky Bernstein <rocky@cpan.org>

This program is distributed WITHOUT ANY WARRANTY, including but not
limited to the implied warranties of merchantability or fitness for a
particular purpose.

The program is free software. You may distribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation (either version 2 or any later version) and
the Perl Artistic License as published by O'Reilly Media, Inc. Please
open the files named gpl-2.0.txt and Artistic for a copy of these
licenses.

=cut
