#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 2;
use Test::Deep;
use Test::MockModule;

use Git::Wrapper::More;

my @dum_ret = (
    'commit 7bb3fbb155453fc46af866feb58dfe3008356635',
    'Author: A User <auser@domain.net>',
    'Date:   Mon Mar 2 23:22:53 2019 -0600',
    '', 'Tidy', '',
);

my $mgwm = Test::MockModule->new('Git::Wrapper');
$mgwm->mock(
    'show',
    sub {
        my $self = shift;
        return @dum_ret;
    },
);

my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir' );

my @ret = $gwm->showcommit('7bb3fbb155453fc46af866feb58dfe3008356635');

is( scalar @ret, 6, 'dummy commit is 6 lines long' );
cmp_deeply( \@ret, \@dum_ret, 'show returns a commit (array of lines) from Git::Wrapper show' );

exit;

__END__
