#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 505_Slurm-SAAssoc-parse.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);
#use Data::Dumper;

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::Event;

my $testDir = dirname(abs_path($0));
my $num_tests_run = 0; 

#Set up expected results
my @fakedata =
(	
	{ testname=>'event 1',
		cluster=>'yottascale', 
		clusternodes=>'compute-0', nodename=>'compute-0.umd.edu',
		cpus=>20, 
		event=>'Node', eventraw=>2, state=>'DRAIN', stateraw=>514,
		start=>'2016-01-01T00:00:00', end=>'2016-01-01T18:00:00', duration=>'18:00:00',
		user=>'payerle', reason=>'bad powersupply',
	},
	{ testname=>'event 2',
		cluster=>'yottascale', 
		clusternodes=>'compute-[11-20]', nodename=>undef,
		cpus=>200, 
		event=>'Cluster', eventraw=>1, state=>'DRAIN', stateraw=>514,
		start=>'2016-01-05T00:00:00', end=>'2016-01-05T19:00:00', duration=>'19:00:00',
		user=>'root', reason=>'bad nw card in switch',
	},
	{ testname=>'event 3',
		cluster=>'test1', 
		clusternodes=>'test-0', nodename=>'test-0',
		cpus=>2, 
		event=>'Node', eventraw=>2, state=>'DRAIN', stateraw=>514,
		start=>'2016-02-05T00:00:00', end=>'2016-02-05T13:00:00', duration=>'13:00:00',
		user=>'payerle', reason=>'no reason',
	},
);
my @fake_data = ();
foreach my $fakedatum (@fakedata)
{	my $tstname = delete $fakedatum->{testname};
	my $obj = new_ok('Slurm::Sacctmgr::Event' => 
		[ %$fakedatum ],
		"$tstname" );
	$num_tests_run++;

	push @fake_data, $obj;
}
#Make sure @fake_data is alphabetically by 
#@fake_data = sort { $a->eventiation cmp $b->eventiation } @fake_data;

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/fake_sacctmgr_event");
my $saevent = 'Slurm::Sacctmgr::Event';

my $results;
my $args;
my $temp;
my $val;
my @temp;

#Test various commands with echo sacctmgr
#$sa->verbose(1);

$results = $saevent->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all events');
$num_tests_run++;

$val = 'yottascale';
@temp = ( cluster => $val );
$temp = [ grep { $_->cluster eq $val } @fake_data ];
$results = $saevent->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list event by cluster (yottascale)');
$num_tests_run++;

$val = 'test1';
@temp = ( cluster => $val );
$temp = [ grep { $_->cluster eq $val } @fake_data ];
$results = $saevent->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list event by cluster (test1)');
$num_tests_run++;

$val = 'yottascale';
@temp = ( cluster => $val );
$temp = [ grep { $_->cluster eq $val } @fake_data ];
$val = 'payerle';
push @temp, ( user => $val );
$temp = [ grep { $_->user && $_->user eq $val } @$temp ];
$results = $saevent->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list event by yottascale/payerle');
$num_tests_run++;

#Test for match failing
$val = 'zzz';
@temp = ( user => $val );
$temp = [ grep { $_->user && $_->user eq $val } @fake_data ];
$results = $saevent->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list event by user (no match)');
$num_tests_run++;

#Test that still works when in dryrun mode
$sa->dryrun(1);
$results = $saevent->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all events (dryrun)');
$num_tests_run++;

done_testing($num_tests_run);

