#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 510_Slurm-SACluster-parse.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::Cluster;

my $testDir = dirname(abs_path($0));
my $num_tests_run = 0; 

#Set up expected results
my @fakedata =
(	
	{ cluster=>'yottascale', classification=>'imaginary', controlhost=>'ys-master1',
		controlport=>6817, flags=>'virtual', rpc=>7168,
		nodecount=>1000000, nodenames=>'compute-[0-99999]', cpucount=>20000000,
		pluginidselect=>1,
	},
	{ cluster=>'test1', classification=>'test', controlhost=>'test1-master',
		controlport=>6817, flags=>'debug', rpc=>7168,
		nodecount=>2, nodenames=>'test-[0-1]', cpucount=>4,
		pluginidselect=>1,
	},
);
my @fake_data = ();
foreach my $fakedatum (@fakedata)
{	my $cname = $fakedatum->{cluster};

	my $uobj = new_ok('Slurm::Sacctmgr::Cluster' => 
		[ %$fakedatum ],
		"$cname" );
	$num_tests_run++;

	push @fake_data, $uobj;
}
#Make sure @fake_data is alphabetically by clustername
#@fake_data = sort { $a->cluster cmp $b->cluster } @fake_data;

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/fake_sacctmgr_cluster");
my $sacluster = 'Slurm::Sacctmgr::Cluster';

my $results;
my $args;
my $temp;
my $val;
my @temp;

#Test various commands with echo sacctmgr
#$sa->verbose(1);

$results = $sacluster->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all clusters');
$num_tests_run++;

$val = 'yottascale';
@temp = ( name => $val );
$temp = [ grep { $_->cluster eq $val } @fake_data ];
$results = $sacluster->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list cluster by name (yottascale)');
$num_tests_run++;

$val = 'test1';
@temp = ( name => $val );
$temp = [ grep { $_->cluster eq $val } @fake_data ];
$results = $sacluster->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list cluster by name (test1)');
$num_tests_run++;

#Test for match failing
$val = 'zzz';
@temp = ( name => $val );
$temp = [ grep { $_->cluster eq $val } @fake_data ];
$results = $sacluster->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list cluster by name (no match)');
$num_tests_run++;

#Test that still works when in dryrun mode
$sa->dryrun(1);
$results = $sacluster->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all clusters (dryrun)');
$num_tests_run++;

done_testing($num_tests_run);

