/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public abstract class CollatingFunction
extends SystemFunction {
    protected StringCollator stringCollator = null;
    private String absoluteCollationURI = null;
    private URI expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.stringCollator == null) {
            StaticContext env = visitor.getStaticContext();
            if (this.expressionBaseURI == null) {
                this.expressionBaseURI = ExpressionTool.getBaseURI(env, this, false);
            }
            this.preEvaluateCollation(env);
        }
        super.checkArguments(visitor);
    }

    public URI getExpressionBaseURI() {
        return this.expressionBaseURI;
    }

    public StringCollator getStringCollator() {
        return this.stringCollator;
    }

    public String getAbsoluteCollationURI() {
        return this.absoluteCollationURI;
    }

    private void preEvaluateCollation(StaticContext env) throws XPathException {
        if (this.getNumberOfArguments() == this.getDetails().maxArguments) {
            Value collationVal;
            Expression collationExp = this.argument[this.getNumberOfArguments() - 1];
            Value value = collationVal = collationExp instanceof Literal ? ((Literal)collationExp).getValue() : null;
            if (collationVal instanceof AtomicValue) {
                String collationName = collationVal.getStringValue();
                try {
                    URI collationURI = new URI(collationName);
                    if (!collationURI.isAbsolute()) {
                        if (this.expressionBaseURI == null) {
                            this.expressionBaseURI = ExpressionTool.getBaseURI(env, this, true);
                        }
                        if (this.expressionBaseURI == null) {
                            XPathException err = new XPathException("The collation name is a relative URI, but the base URI is unknown");
                            err.setErrorCode("XPST0001");
                            err.setIsStaticError(true);
                            err.setLocator(this);
                            throw err;
                        }
                        URI base = this.expressionBaseURI;
                        collationURI = base.resolve(collationURI);
                        collationName = collationURI.toString();
                    }
                }
                catch (URISyntaxException e) {
                    XPathException err = new XPathException("Collation name '" + collationName + "' is not a valid URI");
                    err.setErrorCode("FOCH0002");
                    err.setIsStaticError(true);
                    err.setLocator(this);
                    throw err;
                }
                StringCollator comp = env.getCollation(collationName);
                if (comp == null) {
                    XPathException err = new XPathException("Unknown collation " + Err.wrap(collationName, 7));
                    err.setErrorCode("FOCH0002");
                    err.setIsStaticError(true);
                    err.setLocator(this);
                    throw err;
                }
                this.stringCollator = comp;
            }
        } else {
            String uri = env.getDefaultCollationName();
            this.stringCollator = env.getCollation(uri);
        }
    }

    public Expression copy() {
        CollatingFunction d = (CollatingFunction)super.copy();
        d.expressionBaseURI = this.expressionBaseURI;
        d.absoluteCollationURI = this.absoluteCollationURI;
        d.stringCollator = this.stringCollator;
        return d;
    }

    public boolean equals(Object o) {
        return o instanceof CollatingFunction && super.equals(o) && CollatingFunction.equalOrNull(this.expressionBaseURI, ((CollatingFunction)o).expressionBaseURI) && CollatingFunction.equalOrNull(this.absoluteCollationURI, ((CollatingFunction)o).absoluteCollationURI) && CollatingFunction.equalOrNull(this.stringCollator, ((CollatingFunction)o).stringCollator);
    }

    private static boolean equalOrNull(Object x, Object y) {
        if (x == null) {
            return y == null;
        }
        return y != null && x.equals(y);
    }

    protected GenericAtomicComparer getAtomicComparer(int arg, XPathContext context) throws XPathException {
        return new GenericAtomicComparer(this.getCollator(arg, context), context);
    }

    protected StringCollator getCollator(int arg, XPathContext context) throws XPathException {
        if (this.stringCollator != null) {
            return this.stringCollator;
        }
        int numargs = this.argument.length;
        if (numargs > arg) {
            AtomicValue av = (AtomicValue)this.argument[arg].evaluateItem(context);
            StringValue collationValue = (StringValue)av;
            String collationName = collationValue.getStringValue();
            try {
                collationName = CollatingFunction.expandCollationURI(collationName, this.expressionBaseURI, context);
            }
            catch (XPathException err) {
                err.setLocator(this);
            }
            return context.getCollation(collationName);
        }
        return CodepointCollator.getInstance();
    }

    public static String expandCollationURI(String collationName, URI expressionBaseURI, XPathContext context) throws XPathException {
        try {
            URI collationURI = new URI(collationName);
            if (!collationURI.isAbsolute()) {
                if (expressionBaseURI == null) {
                    XPathException err = new XPathException("Cannot resolve relative collation URI '" + collationName + "': unknown or invalid base URI");
                    err.setErrorCode("FOCH0002");
                    err.setXPathContext(context);
                    throw err;
                }
                collationURI = expressionBaseURI.resolve(collationURI);
                collationName = collationURI.toString();
            }
        }
        catch (URISyntaxException e) {
            XPathException err = new XPathException("Collation name '" + collationName + "' is not a valid URI");
            err.setErrorCode("FOCH0002");
            err.setXPathContext(context);
            throw err;
        }
        return collationName;
    }
}

