use Test::More;
use strict;
use warnings;
use FindBin;

use Crypt::CCM;
eval "use Crypt::Rijndael";
if ($@) {
    plan skip_all => 'Crypt::Rijndael not installed';
}
else {
    plan tests => 24;
}

while (defined(my $t = each_test_data())) {
    last if !exists $t->{K};
    my $c = Crypt::CCM->new(-key => $t->{K}, -cipher => 'Crypt::Rijndael');
    $c->set_tag_length($t->{TL}/8);
    $c->set_nonce($t->{N});
    $c->set_aad($t->{A});
    if ($t->{M} eq 'E') {
        my $ct = $t->{A}. $c->encrypt($t->{PT});
        ok($ct eq $t->{CT});
    }
    else {
        my $pt = $c->decrypt($t->{CT});
        ok($pt eq $t->{PT});
    }
}

sub each_test_data {
    my %result;
    for (my $i = 0; $i < 7; $i++) {
        no warnings;
        my $l = scalar <DATA>;
        chomp $l;
        my ($key, $value) = split /\s+/, $l;
        $result{$key} = $value;
        next if $key eq 'M';
        next if $key eq 'TL';
        if ($value =~ /^file:(.+)/) {
            my $path = sprintf '%s/%s', $FindBin::Bin, $1;
            open my $f, $path or die $!;
            $result{$key} = '';
            while (read $f, my $buff, 1024*8) {
                $result{$key} .= $buff;
            }
            close $f;
        }
        else {
            $result{$key} = pack 'H*', $value;
        }
    }
    return undef if !exists $result{K};
    return \%result;
}

# Test Vector from RFC 3610
__DATA__
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
TL 64
N  00000003020100A0A1A2A3A4A5
A  0001020304050607
PT 08090A0B0C0D0E0F101112131415161718191A1B1C1D1E
CT 0001020304050607588C979A61C663D2F066D0C2C0F989806D5F6B61DAC38417E8D12CFDF926E0
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
TL 64
N  00000004030201A0A1A2A3A4A5
A  0001020304050607
PT 08090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F
CT 000102030405060772C91A36E135F8CF291CA894085C87E3CC15C439C9E43A3BA091D56E10400916
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
TL 64
N  00000005040302A0A1A2A3A4A5
A  0001020304050607
PT 08090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F20
CT 000102030405060751B1E5F44A197D1DA46B0F8E2D282AE871E838BB64DA8596574ADAA76FBD9FB0C5
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
TL 64
N  00000006050403A0A1A2A3A4A5
A  000102030405060708090A0B
PT 0C0D0E0F101112131415161718191A1B1C1D1E
CT 000102030405060708090A0BA28C6865939A9A79FAAA5C4C2A9D4A91CDAC8C96C861B9C9E61EF1
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
TL 64
N  00000007060504A0A1A2A3A4A5
A  000102030405060708090A0B
PT 0C0D0E0F101112131415161718191A1B1C1D1E1F
CT 000102030405060708090A0BDCF1FB7B5D9E23FB9D4E131253658AD86EBDCA3E51E83F077D9C2D93
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
N  00000008070605A0A1A2A3A4A5
TL 64
A  000102030405060708090A0B
PT 0C0D0E0F101112131415161718191A1B1C1D1E1F20
CT 000102030405060708090A0B6FC1B011F006568B5171A42D953D469B2570A4BD87405A0443AC91CB94
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
N  00000009080706A0A1A2A3A4A5
TL 80
A  0001020304050607
PT 08090A0B0C0D0E0F101112131415161718191A1B1C1D1E
CT 00010203040506070135D1B2C95F41D5D1D4FEC185D166B8094E999DFED96C048C56602C97ACBB7490
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
N  0000000A090807A0A1A2A3A4A5
TL 80
A  0001020304050607
PT 08090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F
CT 00010203040506077B75399AC0831DD2F0BBD75879A2FD8F6CAE6B6CD9B7DB24C17B4433F434963F34B4
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
N  0000000B0A0908A0A1A2A3A4A5
TL 80
A  0001020304050607
PT 08090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F20
CT 000102030405060782531A60CC24945A4B8279181AB5C84DF21CE7F9B73F42E197EA9C07E56B5EB17E5F4E
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
N  0000000C0B0A09A0A1A2A3A4A5
A  000102030405060708090A0B
TL 80
PT 0C0D0E0F101112131415161718191A1B1C1D1E
CT 000102030405060708090A0B07342594157785152B074098330ABB141B947B566AA9406B4D999988DD
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
N  0000000D0C0B0AA0A1A2A3A4A5
TL 80
A  000102030405060708090A0B
PT 0C0D0E0F101112131415161718191A1B1C1D1E1F
CT 000102030405060708090A0B676BB20380B0E301E8AB79590A396DA78B834934F53AA2E9107A8B6C022C
M  E
K  C0C1C2C3C4C5C6C7C8C9CACBCCCDCECF
N  0000000E0D0C0BA0A1A2A3A4A5
TL 80
A  000102030405060708090A0B
PT 0C0D0E0F101112131415161718191A1B1C1D1E1F20
CT 000102030405060708090A0BC0FFA0D6F05BDB67F24D43A4338D2AA4BED7B20E43CD1AA31662E7AD65D6DB
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  00412B4EA9CDBE3C9696766CFA
TL 64
A  0BE1A88BACE018B1
PT 08E8CF97D820EA258460E96AD9CF5289054D895CEAC47C
CT 0BE1A88BACE018B14CB97F86A2A4689A877947AB8091EF5386A6FFBDD080F8E78CF7CB0CDDD7B3
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  0033568EF7B2633C9696766CFA
TL 64
A  63018F76DC8A1BCB
PT 9020EA6F91BDD85AFA0039BA4BAFF9BFB79C7028949CD0EC
CT 63018F76DC8A1BCB4CCB1E7CA981BEFAA0726C55D378061298C85C92814ABC33C52EE81D7D77C08A
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  00103FE41336713C9696766CFA
TL 64
A  AA6CFA36CAE86B40
PT B916E0EACC1C00D7DCEC68EC0B3BBB1A02DE8A2D1AA346132E
CT AA6CFA36CAE86B40B1D23A2220DDC0AC900D9AA03C61FCF4A559A4417767089708A776796EDB723506
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  00764C63B8058E3C9696766CFA
A  D0D0735C531E1BECF049C244
TL 64
PT 12DAAC5630EFA5396F770CE1A66B21F7B2101C
CT D0D0735C531E1BECF049C24414D253C3967B70609B7CBB7C499160283245269A6F49975BCADEAF
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  00F8B678094E3B3C9696766CFA
TL 64
A  77B60F011C03E1525899BCAE
PT E88B6A46C78D63E52EB8C546EFB5DE6F75E9CC0D
CT 77B60F011C03E1525899BCAE5545FF1A085EE2EFBF52B2E04BEE1E2336C73E3F762C0C7744FE7E3C
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  00D560912D3F703C9696766CFA
TL 64
A  CD9044D2B71FDB8120EA60C0
PT 6435ACBAFB11A82E2F071D7CA4A5EBD93A803BA87F
CT CD9044D2B71FDB8120EA60C0009769ECABDF48625594C59251E6035722675E04C847099E5AE0704551
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  0042FFF8F1951C3C9696766CFA
TL 80
A  D85BC7E69F944FB8
PT 8A19B950BCF71A018E5E6701C91787659809D67DBEDD18
CT D85BC7E69F944FB8BC218DAA947427B6DB386A99AC1AEF23ADE0B52939CB6A637CF9BEC2408897C6BA
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  00920F40E56CDC3C9696766CFA
TL 80
A  74A0EBC9069F5B37
PT 1761433C37C5A35FC1F39F406302EB907C6163BE38C98437
CT 74A0EBC9069F5B375810E6FD25874022E80361A478E3E9CF484AB04F447EFFF6F0A477CC2FC9BF548944
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  0027CA0C7120BC3C9696766CFA
TL 80
A  44A3AA3AAE6475CA
PT A434A8E58500C6E41530538862D686EA9E81301B5AE4226BFA
CT 44A3AA3AAE6475CAF2BEED7BC5098E83FEB5B31608F8E29C38819A89C8E776F1544D4151A4ED3A8B87B9CE
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  005B8CCBCD9AF83C9696766CFA
TL 80
A  EC46BB63B02520C33C49FD70
PT B96B49E21D621741632875DB7F6C9243D2D7C2
CT EC46BB63B02520C33C49FD7031D750A09DA3ED7FDDD49A2032AABF17EC8EBF7D22C8088C666BE5C197
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  003EBE94044B9A3C9696766CFA
TL 80
A  47A65AC78B3D594227E85E71
PT E2FCFBB880442C731BF95167C8FFD7895E337076
CT 47A65AC78B3D594227E85E71E882F1DBD38CE3EDA7C23F04DD65071EB41342ACDF7E00DCCEC7AE52987D
M  E
K  D7828D13B2B0BDC325A76236DF93CC6B
N  008D493B30AE8B3C9696766CFA
TL 80
A  6E37A6EF546D955D34AB6059
PT ABF21C0B02FEB88F856DF4A37381BCE3CC128517D4
CT 6E37A6EF546D955D34AB6059F32905B88A641B04B9C9FFB58CC390900F3DA12AB16DCE9E82EFA16DA62059

