/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef H_CFCBINDFILE
#define H_CFCBINDFILE

/** Clownfish::CFC::Binding::Core::File - Generate core C code for a Clownfish file.
 *
 * This module is the companion to Clownfish::CFC::Model::File, generating the
 * C code needed to implement the file's specification.
 *
 * There is a one-to-one mapping between Clownfish header files and
 * autogenerated .h and .c files.  If Foo.cfh includes both Foo and
 * Foo::FooJr, then it is necessary to pound-include "Foo.h" in order to get
 * FooJr's interface -- not "Foo/FooJr.h", which won't exist.
 */

#ifdef __cplusplus
extern "C" {
#endif

struct CFCFile;

/** Generate a C header file containing all class declarations and literal C
 * blocks.
 *
 * @param file A Clownfish::CFC::Model::File.
 * @param dest The directory under which autogenerated files are being
 * written.
 * @param header Text which will be prepended to each generated C file --
 * typically, an "autogenerated file" warning.
 * @param footer Text to be appended to the end of each generated C file --
 * typically copyright information.
 */
void
CFCBindFile_write_h(struct CFCFile *file, const char *dest,
                    const char *header, const char *footer);

#ifdef __cplusplus
}
#endif

#endif /* H_CFCBINDFILE */


