package   Datatypes::v1_0::NSMap;

use strict;
use warnings;
use version;our $VERSION = qv("v1.0");

=head1 NAME

Datatypes::v1_0::NSMap - element names to namespace prefix mapper

=head1 DESCRIPTION

this class designed to map element localname to registered namespace, the object of this
class is supposed to be member of the each PXB binded object in order to allow propagation of the
registered namespaces throughout the API

=head1 SYNOPSIS

        use Datatypes::v1_0::NSMap;
	
	my $nsmap =  Datatypes::v1_0::NSMap->new();
	$nsmap->mapname($ELEMENT_LOCALNAME, 'ns_prefix');

=head1 METHODS

=head2 new({})

 new  - constructor, accepts single paramter - hashref with the hash of:
 
 <element_name> =>  <URI>,..., <element_name> =>  <URI>  #  mapped element on ns hashref
 
 the namespace registry track relation between namespace URI and used prefix

=cut

use Data::Dumper;
use Readonly;
use Log::Log4perl qw(get_logger);
use fields qw(nsmap);

Readonly::Scalar our $CLASSPATH => 'Datatypes::v1_0::NSMap';
our $LOGGER =  get_logger($CLASSPATH);

sub new {
    my ($class, $param) = @_;
    $class = ref($class) || $class;
    my $self = fields::new($class);
    if ($param) {
        unless( ref($param) eq 'HASH') {
            $LOGGER->logdie("ONLY hash ref accepted as param and not: " . Dumper $param );
        }  
        foreach my $key (keys %{$param}) {
            $self->mapname($key => $param->{$key});
        }
    } else {
        $self->{nsmap} = {}; 
    }
    return $self;
}


=head2 mapname()

    maps localname on the prefix
    accepts:
        with single paramter ( element name ) it will return
       namespace prefix  and with two parameters it will map  namespace prefix
    to specific element name
    and without parameters it will return the whole namespaces hashref

=cut


sub mapname {
    my ($self, $element, $nsid) = @_;
    if ($element && $nsid) {
        $self->{nsmap}->{$element}  =  $nsid;
    return $self;
    } elsif($element && $self->{nsmap}->{$element} && !$nsid) {
        return $self->{nsmap}->{$element};
    } elsif(!$nsid && !$element) {
        return $self->{nsmap};
    }
    return;
}




=head2 get_nsmap

 accessor  for nsmap, assumes hash based class

=cut

sub get_nsmap {
    my($self) = @_;
    return $self->{nsmap};
}

=head2 set_nsmap

mutator for nsmap, assumes hash based class

=cut

sub set_nsmap {
    my($self,$value) = @_;
    if($value) {
        $self->{nsmap} = $value;
    }
    return   $self->{nsmap};
}



1;

__END__


=head1  SEE ALSO

Automatically generated by L<XML::RelaxNG::Compact::PXB> 

=head1 AUTHOR

Joe Doe

=head1 COPYRIGHT

Copyright (c) 2008, Joe Doe. All rights reserved.

=head1 LICENSE

This program is free software.
You can redistribute it and/or modify it under the same terms as Perl itself.

=cut


