use v6;
use lib 't', 'lib';

use Test;

use Test-support;

use BSON;
use BSON::Document;

use MongoDB;
use MongoDB::ServerPool::Server;
#use MongoDB::Client;
#use MongoDB::Database;
#use MongoDB::Header;
use MongoDB::Uri;

use Base64;
use OpenSSL::Digest;

#-------------------------------------------------------------------------------
drop-send-to('mongodb');
drop-send-to('screen');
#modify-send-to( 'screen', :level(MongoDB::MdbLoglevels::Info));
my $handle = "xt/Log/160-Server.log".IO.open( :mode<wo>, :create, :truncate);
add-send-to( 'mdb', :to($handle), :min-level(MongoDB::MdbLoglevels::Trace));
#set-filter(|<ObserverEmitter Timer Socket>);
set-filter(|<Timer Monitor Client >);

info-message("Test $?FILE start");

#-------------------------------------------------------------------------------
my MongoDB::Test-support $ts .= new;
my Hash $clients = $ts.create-clients;
my Str $host = $clients<s1>.uri-obj.servers[0]<host>;
my Int $port = $clients<s1>.uri-obj.servers[0]<port>.Int;
#my Str $client-key = sha256("s1 $host $port".encode)>>.fmt('%02X').join;

my MongoDB::ServerPool::Server $server;

#-------------------------------------------------------------------------------
subtest "Server creation", {
#  $server .= new( :$client-key, :$host, :$port);
  $server .= new( :$host, :$port);
  isa-ok $server, MongoDB::ServerPool::Server,
    '.new( :client-key, :host, :port)';
  is $server.name, "$host:$port", '.name() = ' ~ $server.name();
  is $server.host, $host, '.host() = ' ~ $server.host();
  is $server.port, $port, '.port() = ' ~ $server.port();
  ok $server.server-is-registered, '.server-is-registered()';
}

#-------------------------------------------------------------------------------
subtest "Server manipulations", {
  is $server.get-data('status'), ST-Unknown, '.get-data() one item';
  my $h = $server.get-data(<status is-master non-exist-item>);
  is $h.keys.elems, 2, '.get-data() 2 items';
  is-deeply $h, %(:status(ST-Unknown), :!is-master), '.get-data() data';

  $server.set-data( :new-item1(10) :new-item2(11));
  is $server.get-data('new-item1'), 10, '.set-data()';
  $h = $server.get-data;
  is $h.keys.elems, 5, '.get-data() all items';
}

#-------------------------------------------------------------------------------
subtest "Socket manipulations", {
  my MongoDB::Uri $uri-obj .= new(:uri("mongodb://$server.name()"));
  my MongoDB::SocketPool::Socket $socket = $server.get-socket(
    :$uri-obj#, :!authenticate
  );
  isa-ok $socket, MongoDB::SocketPool::Socket;
}

#`{{
#-------------------------------------------------------------------------------
subtest "Socket manipulations", {
  my MongoDB::Header $header .= new;

  ( my Buf $encoded-query, my Int $request-id) = $header.encode-query(
    'admin.$cmd', $monitor-command, :number-to-return(1)
  );

  $socket.send($encoded-query);
  my Buf $size-bytes = $socket.receive-check(4);
  my Int $response-size = $size-bytes.read-int32( 0, LittleEndian) - 4;
  my Buf $server-reply = $size-bytes ~ $socket.receive-check($response-size);
  my BSON::Document $result = $header.decode-reply($server-reply);
  is $result<number-returned>, 1, '.send() / .receive-check()';
  is $result<documents>[0]<ok>, 1, 'document is ok';

  ok $socket.check-open, '.check-open()';

  my MongoDB::Client $client = $clients{$clients.keys[0]};
  my MongoDB::Database $database = $client.database('test');

#note $result.perl;
}
}}

#-------------------------------------------------------------------------------
info-message("Test $?FILE stop");
done-testing();
