use v6.d;

#unit class Test::Diehard;

use Test::Diehard::Craps;
use Test::Diehard::Runs;

use MersenneTwister::MT;

sub MAIN (UInt :$crap_games, UInt :$sequence_length, Bool :$log = False) {
    my $mt = MersenneTwister::MT.new(
	w => 32,
	n => 624,
	m => 397,
	r => 31,
	a => 0x9908B0DF,
	u => 11,
	d => 0xFFFFFFFF,
	s => 7,
	b => 0x9D2C5680,
	t => 15,
	c => 0xEFC60000,
	l => 18,
	f => 1812433253,
    );

    my @craps_result = Test::Diehard::Craps::test($crap_games, $mt.clone(), $mt.clone(), log => $log);
    my Bool $runs_result = Test::Diehard::Runs::test($mt.clone(), $sequence_length, log => $log);

}
    =begin pod

    =head1 Test::Diehard

    =head2 Test procedure
    =for defn :numbered
		   Birthday spacings
		   Overlapping permutations
		   Ranks of matrices
		   Monkey tests
		   Count the 1s
		   Parking lot test
		   Minimum distance test
		   Random spheres test
		   The squeeze test
		   Overlapping sums test
		   Runs test
		   The craps test ✔

    =end pod
