/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.logging.RedirectOutputHandler;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JavaUtilLoggingAdaptor {
    private static boolean addedRedwoodHandler = false;

    public static void adapt() {
        Logger topLogger = Logger.getLogger("");
        Handler oldConsoleHandler = null;
        for (Handler handler : topLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler) || handler instanceof RedwoodHandler) continue;
            oldConsoleHandler = handler;
            break;
        }
        if (oldConsoleHandler != null) {
            topLogger.removeHandler(oldConsoleHandler);
        }
        if (!addedRedwoodHandler) {
            RedwoodHandler redwoodHandler = new RedwoodHandler();
            topLogger.addHandler(redwoodHandler);
            addedRedwoodHandler = true;
        }
        Redwood.addLoggingClass(JavaUtilLoggingAdaptor.class.getCanonicalName());
        Redwood.addLoggingClass("java.util.logging");
    }

    public static void main(String[] args) {
        Logger topLogger = Logger.getLogger("global");
        Redwood.log("Hello from Redwood!");
        RedwoodConfiguration.empty().rootHandler(RedirectOutputHandler.fromJavaUtilLogging(topLogger)).apply();
        Redwood.log("Hello from Redwood -> Java!");
        Redwood.log("Hello from Redwood -> Java again!");
        Redwood.startTrack("a track");
        Redwood.log("Inside a track");
        Redwood.endTrack("a track");
    }

    public static class RedwoodHandler
    extends ConsoleHandler {
        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            String message = record.getMessage();
            Level level = record.getLevel();
            Redwood.Flag tag = null;
            if (level == Level.WARNING) {
                tag = Redwood.WARN;
            } else if (level == Level.SEVERE) {
                tag = Redwood.ERR;
            } else if (level.intValue() <= Level.FINE.intValue()) {
                tag = Redwood.DBG;
            }
            if (tag == null) {
                Redwood.log(message);
            } else {
                Redwood.log(new Object[]{tag, message});
            }
        }
    }
}

