# Generated by default/object.tt
package Paws::EMR::NotebookExecution;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has EditorId => (is => 'ro', isa => 'Str');
  has EndTime => (is => 'ro', isa => 'Str');
  has ExecutionEngine => (is => 'ro', isa => 'Paws::EMR::ExecutionEngineConfig');
  has LastStateChangeReason => (is => 'ro', isa => 'Str');
  has NotebookExecutionId => (is => 'ro', isa => 'Str');
  has NotebookExecutionName => (is => 'ro', isa => 'Str');
  has NotebookInstanceSecurityGroupId => (is => 'ro', isa => 'Str');
  has NotebookParams => (is => 'ro', isa => 'Str');
  has OutputNotebookURI => (is => 'ro', isa => 'Str');
  has StartTime => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::EMR::Tag]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMR::NotebookExecution

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMR::NotebookExecution object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMR::NotebookExecution object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

A notebook execution. An execution is a specific instance that an EMR
Notebook is run using the C<StartNotebookExecution> action.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the notebook execution.


=head2 EditorId => Str

The unique identifier of the EMR Notebook that is used for the notebook
execution.


=head2 EndTime => Str

The timestamp when notebook execution ended.


=head2 ExecutionEngine => L<Paws::EMR::ExecutionEngineConfig>

The execution engine, such as an EMR cluster, used to run the EMR
notebook and perform the notebook execution.


=head2 LastStateChangeReason => Str

The reason for the latest status change of the notebook execution.


=head2 NotebookExecutionId => Str

The unique identifier of a notebook execution.


=head2 NotebookExecutionName => Str

A name for the notebook execution.


=head2 NotebookInstanceSecurityGroupId => Str

The unique identifier of the EC2 security group associated with the EMR
Notebook instance. For more information see Specifying EC2 Security
Groups for EMR Notebooks
(https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html)
in the I<EMR Management Guide>.


=head2 NotebookParams => Str

Input parameters in JSON format passed to the EMR Notebook at runtime
for execution.


=head2 OutputNotebookURI => Str

The location of the notebook execution's output file in Amazon S3.


=head2 StartTime => Str

The timestamp when notebook execution started.


=head2 Status => Str

The status of the notebook execution.

=over

=item *

C<START_PENDING> indicates that the cluster has received the execution
request but execution has not begun.

=item *

C<STARTING> indicates that the execution is starting on the cluster.

=item *

C<RUNNING> indicates that the execution is being processed by the
cluster.

=item *

C<FINISHING> indicates that execution processing is in the final
stages.

=item *

C<FINISHED> indicates that the execution has completed without error.

=item *

C<FAILING> indicates that the execution is failing and will not finish
successfully.

=item *

C<FAILED> indicates that the execution failed.

=item *

C<STOP_PENDING> indicates that the cluster has received a
C<StopNotebookExecution> request and the stop is pending.

=item *

C<STOPPING> indicates that the cluster is in the process of stopping
the execution as a result of a C<StopNotebookExecution> request.

=item *

C<STOPPED> indicates that the execution stopped because of a
C<StopNotebookExecution> request.

=back



=head2 Tags => ArrayRef[L<Paws::EMR::Tag>]

A list of tags associated with a notebook execution. Tags are
user-defined key-value pairs that consist of a required key string with
a maximum of 128 characters and an optional value string with a maximum
of 256 characters.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMR>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

