package Apache::Navbar;
use strict vars;
use Apache::Constants ':common';
use Apache::File;
use Apache::URI;
use IO::File;
use vars qw($VERSION $mod_time $hours $link $header);
my ($nav_handle, $header_handle, @header_links, $f, $url);
my $conf_file; 
my %BARS = ();
$VERSION = '0.01';
my $path = "/var/www/conf";
my $nav_file = $path . "/navigation.cnf";
my $header_file = $path . "/header.cnf";
my $footer_file = $path . "/footer.cnf";
my $tableatts = "border=0 width=100%";
$link = qq(<title>sirfsup.com</title><link rel=stylesheet type="text/css" href="http://www.sirfsup.com/mystil.css"> <META http-equiv=Content-Type content="text/html"> <META name="keywords" content="perl, c, cgi, shell, java, web programming scripts in searchable directories, organized by a mod_perl backend"> <META name="description" content="perl, cgi, c, shell, java, web programming, server-side, server side programming, apache server programming, IIS server programming, mod_perl programming, networking tutorials">);
        

        
sub handler {
    my $r = shift;
    return DECLINED unless $r->content_type() eq 'text/html';
    my $file = $r->filename;
    my $fh;
      unless ($fh = Apache::File->new($file)) {
	$r->log_error("Couldn't open $file for reading $!; this fileis the requested page");
	return SERVER_ERROR;
    }

    $r->send_http_header;
    
    my $parsed_header_file = read_configuration($r, $header_file);

    my $parsed_nav_file = read_configuration($r, $nav_file);

    my @end_stuff;
    unless ($f = Apache::File->new("$footer_file")) {
	$r->log_error("Couldn't open $footer_file for reading $! (footer.cnf)");
	return SERVER_ERROR;
    }
    while (<$f>) {
	push(@end_stuff, $_);
    }
    $f->close;
    
    my @nav_links;     
    my @header_links;     
    my $td_count=$parsed_header_file->label(LINECOUNT);

    # nav_links is its own table
    push(@nav_links, qq(<center><table><tr><td align=center>));
    for $url ($parsed_header_file->urls)  {
	my $cell;
	my $label = $parsed_header_file->label($url);
	$cell = qq(<a href="http://www.sirfsup.com/$url" class="nav1">$label</a>);
	push(@nav_links, qq([$cell]\n));
    }
    for $url ($parsed_nav_file->urls)  {
	my $label = $parsed_nav_file->label($url);
#	if ($url =~ /lt/) {
#	    push(@nav_links, qq([<a href="http://lt.sirfsup.com/"
#	    class="nav1">$label</a>]\n));
#	    next;
#	} 
	if ($url =~ /8080/) {
	    push(@nav_links, qq([<a href="http://www.sirfsup.com:8080/index.html"
	    class="nav1">$label</a>]\n));
	    next;
	} 

	push(@nav_links, qq([<a href="http://www.sirfsup.com/$url"
	class="nav1">$label</a>]\n));
    }
    push(@nav_links, qw(</td></tr>));
	push(@nav_links, qw(<tr><td ><center><table align="center" border="0" cellpadding="2">
<form method="get" action="/cgi-bin/search/search.pl">
<tr>
	<td align="center"> Match <select name="Match" id="fdse_Match"><option value="1">All</option><option selected="selected" value="0">Any</option></select> <input type="hidden" value="sirfsup.com">
	<td valign="middle" align="right" style="font-weight:bold"><label for="fdse_Terms">Keywords:</label></td>
	<td valign="middle"><tt><input value="" name="Terms" size="25" style="font-family:monospace" id="fdse_Terms" /></tt></td>
	<td valign="middle" align="left"><input type="submit" class="submit" value="Search" /></td>
</tr>
</table></td></tr></table>
</center></td></tr></table></center>)); 
    my $ref=\@nav_links;
    my $footer_ref = \@end_stuff;
    while (<$fh>) {
	s!<LINK REL=STYLESHEET      HREF="mystil.css"      TYPE="text/css">!!oi;
	s!http://.*mystil.css!http://www.sirfsup.com/mystil.css!oi;
	s!(</head>)!$link$1!oi;   
	s!(<body.*>)!$1@$ref!oi;   
	s!(</BODY>)!@$footer_ref$1!oi;
	print;
    }
    return OK;
}

sub read_configuration {
    my $r = shift;
    my $conf_file = shift;
    unless (my $handle = Apache::File->new("$conf_file")) {
#	$r->log_error("Couldn't open $conf_file for reading $!");
	return SERVER_ERROR;
    }
    $mod_time = localtime((stat _)[9]);    
    return $BARS{$conf_file} if $BARS{$conf_file} && $BARS{$conf_file}->modified >= $mod_time;
    return $BARS{$conf_file} = NavBar->new($conf_file);
}


package NavBar;

sub new {
    my ($class, $conf_file) = @_;
    my (%hash, @c);
    my $line_count=0;
    my $rec = {};
    my $fh = new IO::File;
    $fh->open("$conf_file") or die "Cannot open \$conf_file";
    while (<$fh>) {
	chomp;
	s/^\s+//; s/\s+$//;  #fold leading and trailing white spaces
	if (/^#/ || /^$/) {    #skip comments and empty lines
	    next;
	}
	my($url, $label) = split /=/, $_;
	push @c, $url;
	$hash{$url} = $label;
	$line_count++;
    }
    $hash{LINECOUNT} = $line_count;
    return bless {'urls' => \@c,
		  'labels' => \%hash,
                  'modified' => (stat $conf_file)[9]},  $class;
}

#return the modification date of the configuration file
sub modified {return $_[0]->{'modified'}; }

#return ordered list of all the keys
sub urls { return @{shift->{'urls'}}; }

#return the value for a key ; $_[1] represents the argument, which could be any key, for example the URL or the LINECOUNT
sub label {return $_[0]->{'labels'}->{$_[1]} || $_[1];}


1;


__END__

=head1 NAME

B<Apache::Navbar> - Apache mod_perl PerlHandler for displaying header and footer.  

=head1 SYNOPSIS

You must be using mod_perl and Apache-1.3.x. 

Find and adjust the path and modify any extraneous stuff you don't need.  The following is the modification to httpd.conf

<Directory "/var/www">   # is my DocumentRoot
    Options Indexes FollowSymLinks MultiViews
	<Files ~ "\.(htm|html)$">
		SetHandler perl-script	
		PerlHandler Apache::Navbar  # hence it applies to all html docs under server root
	</Files>
    AllowOverride None
    Order allow,deny
    Allow from all
</Directory>

=head1 DESCRIPTION

adds a header and footer

This has not been ported to Apache2.  


=head1 CONFIGURATION DIRECTIVES

none


=head1 SEE ALSO

Apache-NavBarDD, perl(1), mod_perl(3), Apache(3)

=head1 THANKS

Roman Kosenko for a module submission template.
The eagle book for its 'class1' code used in the file.  
Chris Winters for writing clean(er) code.

=head1 AUTHOR

Joseph Speigle

=head2 Contact info

E-mail:	joe@jklh.us

Home page: http://www.sirfsup.com

=head2 Copyright

Copyright (c) 2003 Joseph Speigle
All rights reserved.  This package is free software; 
you can redistribute it and/or modify it under the same 
terms as Perl itself.






