# Generated by default/object.tt
package Paws::Macie2::Finding;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str', request_name => 'accountId', traits => ['NameInRequest']);
  has Archived => (is => 'ro', isa => 'Bool', request_name => 'archived', traits => ['NameInRequest']);
  has Category => (is => 'ro', isa => 'Str', request_name => 'category', traits => ['NameInRequest']);
  has ClassificationDetails => (is => 'ro', isa => 'Paws::Macie2::ClassificationDetails', request_name => 'classificationDetails', traits => ['NameInRequest']);
  has Count => (is => 'ro', isa => 'Int', request_name => 'count', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Partition => (is => 'ro', isa => 'Str', request_name => 'partition', traits => ['NameInRequest']);
  has PolicyDetails => (is => 'ro', isa => 'Paws::Macie2::PolicyDetails', request_name => 'policyDetails', traits => ['NameInRequest']);
  has Region => (is => 'ro', isa => 'Str', request_name => 'region', traits => ['NameInRequest']);
  has ResourcesAffected => (is => 'ro', isa => 'Paws::Macie2::ResourcesAffected', request_name => 'resourcesAffected', traits => ['NameInRequest']);
  has Sample => (is => 'ro', isa => 'Bool', request_name => 'sample', traits => ['NameInRequest']);
  has SchemaVersion => (is => 'ro', isa => 'Str', request_name => 'schemaVersion', traits => ['NameInRequest']);
  has Severity => (is => 'ro', isa => 'Paws::Macie2::Severity', request_name => 'severity', traits => ['NameInRequest']);
  has Title => (is => 'ro', isa => 'Str', request_name => 'title', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);
  has UpdatedAt => (is => 'ro', isa => 'Str', request_name => 'updatedAt', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::Finding

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::Finding object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., UpdatedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::Finding object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Provides the details of a finding.

=head1 ATTRIBUTES


=head2 AccountId => Str

The unique identifier for the Amazon Web Services account that the
finding applies to. This is typically the account that owns the
affected resource.


=head2 Archived => Bool

Specifies whether the finding is archived (suppressed).


=head2 Category => Str

The category of the finding. Possible values are: CLASSIFICATION, for a
sensitive data finding; and, POLICY, for a policy finding.


=head2 ClassificationDetails => L<Paws::Macie2::ClassificationDetails>

The details of a sensitive data finding. This value is null for a
policy finding.


=head2 Count => Int

The total number of occurrences of the finding. For sensitive data
findings, this value is always 1. All sensitive data findings are
considered new (unique) because they derive from individual
classification jobs.


=head2 CreatedAt => Str

The date and time, in UTC and extended ISO 8601 format, when the
finding was created.


=head2 Description => Str

The description of the finding.


=head2 Id => Str

The unique identifier for the finding. This is a random string that
Amazon Macie generates and assigns to a finding when it creates the
finding.


=head2 Partition => Str

The Amazon Web Services partition that Amazon Macie created the finding
in.


=head2 PolicyDetails => L<Paws::Macie2::PolicyDetails>

The details of a policy finding. This value is null for a sensitive
data finding.


=head2 Region => Str

The Amazon Web Services Region that Amazon Macie created the finding
in.


=head2 ResourcesAffected => L<Paws::Macie2::ResourcesAffected>

The resources that the finding applies to.


=head2 Sample => Bool

Specifies whether the finding is a sample finding. A I<sample finding>
is a finding that uses example data to demonstrate what a finding might
contain.


=head2 SchemaVersion => Str

The version of the schema that was used to define the data structures
in the finding.


=head2 Severity => L<Paws::Macie2::Severity>

The severity level and score for the finding.


=head2 Title => Str

The brief description of the finding.


=head2 Type => Str

The type of the finding.


=head2 UpdatedAt => Str

The date and time, in UTC and extended ISO 8601 format, when the
finding was last updated. For sensitive data findings, this value is
the same as the value for the createdAt property. All sensitive data
findings are considered new (unique) because they derive from
individual classification jobs.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

