# Generated by default/object.tt
package Paws::MediaPackage::EncryptionContractConfiguration;
  use Moose;
  has PresetSpeke20Audio => (is => 'ro', isa => 'Str', request_name => 'presetSpeke20Audio', traits => ['NameInRequest'], required => 1);
  has PresetSpeke20Video => (is => 'ro', isa => 'Str', request_name => 'presetSpeke20Video', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaPackage::EncryptionContractConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaPackage::EncryptionContractConfiguration object:

  $service_obj->Method(Att1 => { PresetSpeke20Audio => $value, ..., PresetSpeke20Video => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaPackage::EncryptionContractConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->PresetSpeke20Audio

=head1 DESCRIPTION

Use encryptionContractConfiguration to configure one or more content
encryption keys for your endpoints that use SPEKE 2.0. The encryption
contract defines which content keys are used to encrypt the audio and
video tracks in your stream. To configure the encryption contract,
specify which audio and video encryption presets to use. Note the
following considerations when using encryptionContractConfiguration:
encryptionContractConfiguration can be used for DASH endpoints that use
SPEKE 2.0. SPEKE 2.0 relies on the CPIX 2.3 specification. You must
disable key rotation for this endpoint by setting
keyRotationIntervalSeconds to 0.

=head1 ATTRIBUTES


=head2 B<REQUIRED> PresetSpeke20Audio => Str

A collection of audio encryption presets.


=head2 B<REQUIRED> PresetSpeke20Video => Str

A collection of video encryption presets.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaPackage>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

