package Daje::Workflow::Database;
use Mojo::Base -base, -signatures;


# NAME
# ====
#
# Daje::Workflow::Database - It's the database plugin for Daje::Workflow
#
# SYNOPSIS
# ========
#
#    use Daje::Workflow::Database;
#    my $database = Daje::Workflow::Database->new(
#         pg            => $pg,
#         db            => $db,
#         workflow      => $workflowname,
#         workflow_pkey => 0,
#         context       => $context,
#         wfl_data      => $wfl_data,
#     );
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Database is the Database plugin for Daje::Workflow
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Mojo::Pg;
use Daje::Workflow::Database::Connector;

our $VERSION = "0.04";

has 'pg';
has 'db';
has 'workflow_pkey';
has 'workflow';
has 'connector';
has 'context';
has 'wfl_data';

sub start($self) {
    my $connector = Daje::Workflow::Database::Connector->new(
        workflow_pkey => $self->workflow_pkey(),
        workflow      => $self->workflow(),
        pg            => $self->pg,
        db            => $self->db,
        context       => $self->context,
    );
    $self->connector($connector);
    return $self->connector->start();
}

sub stop($self, $workflow_data, $context_data) {
    $self->connector->stop($workflow_data, $context_data);
}






1;
__END__











#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Database - It's the database plugin for Daje::Workflow



=head1 SYNOPSIS


   use Daje::Workflow::Database;
   my $database = Daje::Workflow::Database->new(
        pg            => $pg,
        db            => $db,
        workflow      => $workflowname,
        workflow_pkey => 0,
        context       => $context,
        wfl_data      => $wfl_data,
    );



=head1 DESCRIPTION


Daje::Workflow::Database is the Database plugin for Daje::Workflow



=head1 REQUIRES

L<Daje::Workflow::Database::Connector> 

L<Mojo::Pg> 

L<Mojo::Base> 


=head1 METHODS

=head2 start($self)

 start($self)();

=head2 stop($self,

 stop($self,();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

