#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include <string.h>
#ifndef WIN
#ifdef MAC_MEMORY
#include <malloc/malloc.h>
#else
#include <malloc.h>
#endif
#endif /* WIN */

typedef struct node {
	int value;
	struct node* left;
	struct node* right;
} Node, *NodePtr;

typedef struct massWithAAC {
	double mass;
	char *AAC;
} MassWithAAC, *MassWithAACPtr;

MassWithAAC massWithAACs[] = {
	57.02146, "G",
	71.03711, "A",
	87.03203, "S",
	97.05276, "P",
	99.06841, "V",
	101.04768, "T",
	103.00918, "C",
	113.08406, "X",
	114.04293, "GG",
	114.04293, "N",
	115.02694, "D",
	128.05858, "AG",
	128.05858, "Q",
	128.09496, "K",
	129.04259, "E",
	131.04048, "M",
	137.05891, "H",
	142.07423, "AA",
	144.05349, "GS",
	147.06841, "F",
	154.07423, "GP",
	156.08988, "GV",
	156.10111, "R",
	158.06914, "AS",
	158.06914, "GT",
	160.03065, "CG",
	163.06333, "Y",
	168.08988, "AP",
	170.10553, "AV",
	170.10553, "GX",
	171.06439, "GGG",
	171.06439, "GN",
	172.04841, "DG",
	172.08479, "AT",
	174.04630, "AC",
	174.06406, "SS",
	184.08479, "PS",
	184.12118, "AX",
	185.08004, "AGG",
	185.08004, "AN",
	185.08004, "GQ",
	185.11643, "GK",
	186.06406, "AD",
	186.06406, "EG",
	186.07931, "W",
	186.10044, "SV",
	188.06195, "GM",
	188.07971, "ST",
	190.04121, "CS",
	194.08038, "GH",
	194.10553, "PP",
	196.12118, "PV",
	198.10044, "PT",
	198.13683, "VV",
	199.09569, "AAG",
	199.09569, "AQ",
	199.13208, "AK",
	200.06195, "CP",
	200.07971, "AE",
	200.11609, "SX",
	200.11609, "TV",
	201.07496, "GGS",
	201.07496, "NS",
	202.05897, "DS",
	202.07760, "AM",
	202.07760, "CV",
	202.09536, "TT",
	204.05686, "CT",
	204.08988, "FG",
	206.01837, "CC",
	208.09603, "AH",
	210.13683, "PX",
	211.09569, "GGP",
	211.09569, "NP",
	212.07971, "DP",
	212.15248, "VX",
	213.11134, "AAA",
	213.11134, "GGV",
	213.11134, "NV",
	213.12257, "GR",
	214.09536, "DV",
	214.13174, "TX",
	215.09061, "AGS",
	215.09061, "GGT",
	215.09061, "NT",
	215.09061, "QS",
	215.12699, "KS",
	216.07462, "DT",
	216.07462, "ES",
	216.09325, "CX",
	217.05211, "CGG",
	217.05211, "CN",
	218.03613, "CD",
	218.07251, "MS",
	218.10553, "AF",
	220.08479, "GY",
	224.09094, "HS",
	225.11134, "AGP",
	225.11134, "PQ",
	225.14773, "KP",
	226.09536, "EP",
	226.16813, "XX",
	227.12699, "AGV",
	227.12699, "GGX",
	227.12699, "NX",
	227.12699, "QV",
	227.13822, "AR",
	227.16338, "KV",
	228.08585, "GGGG",
	228.08585, "GGN",
	228.08585, "NN",
	228.09325, "MP",
	228.11101, "DX",
	228.11101, "EV",
	229.06987, "DGG",
	229.06987, "DN",
	229.10626, "AAS",
	229.10626, "AGT",
	229.10626, "QT",
	229.14264, "KT",
	230.05389, "DD",
	230.09027, "ET",
	230.10890, "MV",
	231.06776, "ACG",
	231.06776, "CQ",
	231.08552, "GSS",
	231.10415, "CK",
	232.05178, "CE",
	232.08816, "MT",
	234.04967, "CM",
	234.10044, "AY",
	234.10044, "FS",
	234.11168, "HP",
	236.12733, "HV",
	238.10659, "HT",
	239.12699, "AAP",
	240.06810, "CH",
	241.10626, "GPS",
	241.14264, "AAV",
	241.14264, "AGX",
	241.14264, "QX",
	241.17903, "KX",
	242.10150, "AGGG",
	242.10150, "AGN",
	242.10150, "GGQ",
	242.10150, "NQ",
	242.12666, "EX",
	242.13789, "GGK",
	242.13789, "KN",
	243.08552, "ADG",
	243.08552, "DQ",
	243.08552, "EGG",
	243.08552, "EN",
	243.10078, "GW",
	243.12191, "AAT",
	243.12191, "DK",
	243.12191, "GSV",
	243.13314, "RS",
	244.06954, "DE",
	244.12118, "FP",
	244.12455, "MX",
	245.08341, "AAC",
	245.08341, "GGM",
	245.08341, "MN",
	245.10117, "ASS",
	245.10117, "GST",
	246.06743, "DM",
	246.13683, "FV",
	247.06268, "CGS",
	248.11609, "FT",
	250.07760, "CF",
	250.09536, "SY",
	250.14298, "HX",
	251.10184, "GGH",
	251.10184, "HN",
	251.12699, "GPP",
	252.08585, "DH",
	253.14264, "GPV",
	253.15387, "PR",
	255.12191, "APS",
	255.12191, "GPT",
	255.15829, "AAX",
	255.15829, "GVV",
	255.16952, "RV",
	256.11716, "AAGG",
	256.11716, "AAN",
	256.11716, "AGQ",
	256.11716, "QQ",
	256.15354, "AGK",
	256.15354, "KQ",
	256.18993, "KK",
	257.08341, "CGP",
	257.10117, "AAD",
	257.10117, "AEG",
	257.10117, "EQ",
	257.11643, "AW",
	257.13756, "ASV",
	257.13756, "EK",
	257.13756, "GSX",
	257.13756, "GTV",
	257.14879, "RT",
	258.08519, "EE",
	258.09642, "GGGS",
	258.09642, "GNS",
	259.08044, "DGS",
	259.09906, "AGM",
	259.09906, "CGV",
	259.09906, "MQ",
	259.11030, "CR",
	259.11682, "AST",
	259.11682, "GTT",
	259.13545, "KM",
	260.08308, "EM",
	260.11609, "PY",
	260.15248, "FX",
	261.07833, "ACS",
	261.07833, "CGT",
	261.09609, "SSS",
	261.11134, "FGG",
	261.11134, "FN",
	262.08097, "MM",
	262.09536, "DF",
	262.13174, "VY",
	263.03983, "CCG",
	264.11101, "TY",
	265.11749, "AGH",
	265.11749, "HQ",
	265.14264, "APP",
	265.15387, "HK",
	266.07251, "CY",
	266.10150, "EH",
	267.15829, "APV",
	267.15829, "GPX",
	268.09940, "HM",
	268.11716, "GGGP",
	268.11716, "GNP",
	269.10117, "DGP",
	269.13756, "APT",
	269.17394, "AVV",
	269.17394, "GVX",
	269.18518, "RX",
	270.13281, "AAAG",
	270.13281, "AAQ",
	270.13281, "GGGV",
	270.13281, "GNV",
	270.14404, "GGR",
	270.14404, "NR",
	270.16919, "AAK",
	271.09906, "ACP",
	271.11682, "AAE",
	271.11682, "DGV",
	271.11682, "PSS",
	271.12805, "DR",
	271.15321, "ASX",
	271.15321, "ATV",
	271.15321, "GTX",
	272.11207, "AGGS",
	272.11207, "ANS",
	272.11207, "GGGT",
	272.11207, "GNT",
	272.11207, "GQS",
	272.14846, "GKS",
	273.09609, "ADS",
	273.09609, "DGT",
	273.09609, "EGS",
	273.11134, "SW",
	273.11471, "AAM",
	273.11471, "ACV",
	273.11471, "CGX",
	273.13247, "ATT",
	273.13247, "SSV",
	274.07358, "CGGG",
	274.07358, "CGN",
	274.11782, "HH",
	275.05759, "CDG",
	275.09398, "ACT",
	275.09398, "GMS",
	275.11174, "SST",
	275.12699, "AFG",
	275.12699, "FQ",
	275.16338, "FK",
	276.11101, "EF",
	276.14739, "XY",
	277.05548, "ACC",
	277.07324, "CSS",
	277.10626, "GGY",
	277.10626, "NY",
	278.09027, "DY",
	278.10890, "FM",
	279.13314, "AAH",
	281.11240, "GHS",
	281.13756, "PPS",
	281.17394, "APX",
	282.13281, "AGGP",
	282.13281, "ANP",
	282.13281, "GPQ",
	282.16919, "GKP",
	283.11682, "ADP",
	283.11682, "EGP",
	283.13208, "PW",
	283.15321, "PSV",
	283.18959, "AVX",
	283.18959, "GXX",
	284.12733, "FH",
	284.14846, "AAAA",
	284.14846, "AGGV",
	284.14846, "ANV",
	284.14846, "GGGX",
	284.14846, "GNX",
	284.14846, "GQV",
	284.15969, "AGR",
	284.15969, "QR",
	284.18484, "GKV",
	284.19607, "KR",
	285.10732, "GGGN",
	285.10732, "GNN",
	285.11471, "GMP",
	285.13247, "ADV",
	285.13247, "DGX",
	285.13247, "EGV",
	285.13247, "PST",
	285.14370, "ER",
	285.14773, "VW",
	285.16886, "ATX",
	285.16886, "SVV",
	286.09133, "DGGG",
	286.09133, "DGN",
	286.12772, "AAGS",
	286.12772, "AGGT",
	286.12772, "ANT",
	286.12772, "AQS",
	286.12772, "GQT",
	286.16411, "AKS",
	286.16411, "GKT",
	287.07535, "DDG",
	287.09398, "CPS",
	287.11174, "ADT",
	287.11174, "AES",
	287.11174, "EGT",
	287.12699, "TW",
	287.13036, "ACX",
	287.13036, "GMV",
	287.14160, "MR",
	287.14812, "SSX",
	287.14812, "STV",
	288.08923, "ACGG",
	288.08923, "ACN",
	288.08923, "CGQ",
	288.10698, "GGSS",
	288.10698, "NSS",
	288.12561, "CGK",
	289.07324, "ACD",
	289.07324, "CEG",
	289.08850, "CW",
	289.09100, "DSS",
	289.10963, "AMS",
	289.10963, "CSV",
	289.10963, "GMT",
	289.12739, "STT",
	289.14264, "AAF",
	291.07113, "CGM",
	291.08889, "CST",
	291.12191, "AGY",
	291.12191, "FGS",
	291.12191, "QY",
	291.13314, "GHP",
	291.15829, "KY",
	291.15829, "PPP",
	292.10592, "EY",
	293.05040, "CCS",
	293.14879, "GHV",
	293.16002, "HR",
	293.17394, "PPV",
	294.10381, "MY",
	294.13683, "FF",
	295.12805, "AHS",
	295.12805, "GHT",
	295.15321, "PPT",
	295.18959, "PVV",
	296.14846, "AAGP",
	296.14846, "APQ",
	296.18484, "AKP",
	297.08956, "CGH",
	297.11471, "CPP",
	297.13247, "AEP",
	297.16886, "PSX",
	297.16886, "PTV",
	297.20524, "AXX",
	297.20524, "VVV",
	298.12772, "GGPS",
	298.12772, "NPS",
	298.16411, "AAGV",
	298.16411, "AGGX",
	298.16411, "ANX",
	298.16411, "AQV",
	298.16411, "GQX",
	298.17534, "AAR",
	298.20049, "AKV",
	298.20049, "GKX",
	299.11174, "DPS",
	299.12297, "AGGN",
	299.12297, "ANN",
	299.12297, "GGGQ",
	299.12297, "GNQ",
	299.13036, "AMP",
	299.13036, "CPV",
	299.14812, "ADX",
	299.14812, "AEV",
	299.14812, "EGX",
	299.14812, "PTT",
	299.15935, "GGGK",
	299.15935, "GKN",
	299.16338, "WX",
	299.18451, "SVX",
	299.18451, "TVV",
	300.10698, "ADGG",
	300.10698, "ADN",
	300.10698, "DGQ",
	300.10698, "EGGG",
	300.10698, "EGN",
	300.12224, "GGW",
	300.12224, "HY",
	300.12224, "NW",
	300.14337, "AAAS",
	300.14337, "AAGT",
	300.14337, "AQT",
	300.14337, "DGK",
	300.14337, "GGSV",
	300.14337, "NSV",
	300.15460, "GRS",
	300.17976, "AKT",
	301.09100, "ADD",
	301.09100, "DEG",
	301.10626, "DW",
	301.10963, "CPT",
	301.12739, "AET",
	301.12739, "DSV",
	301.14264, "FGP",
	301.14601, "AMV",
	301.14601, "CVV",
	301.14601, "GMX",
	301.16377, "STX",
	301.16377, "TTV",
	302.10488, "AACG",
	302.10488, "ACQ",
	302.10488, "GGGM",
	302.10488, "GMN",
	302.12263, "AGSS",
	302.12263, "GGST",
	302.12263, "NST",
	302.12263, "QSS",
	302.14126, "ACK",
	302.15902, "KSS",
	303.07113, "CCP",
	303.08889, "ACE",
	303.08889, "DGM",
	303.10665, "DST",
	303.10665, "ESS",
	303.12528, "AMT",
	303.12528, "CSX",
	303.12528, "CTV",
	303.14304, "TTT",
	303.15829, "FGV",
	303.16952, "FR",
	304.08414, "CGGS",
	304.08414, "CNS",
	305.06816, "CDS",
	305.08678, "ACM",
	305.08678, "CCV",
	305.10454, "CTT",
	305.10454, "MSS",
	305.13756, "AAY",
	305.13756, "AFS",
	305.13756, "FGT",
	305.14879, "AHP",
	307.06605, "CCT",
	307.09906, "CFG",
	307.11682, "GSY",
	307.16444, "AHV",
	307.16444, "GHX",
	307.18959, "PPX",
	308.12330, "GGGH",
	308.12330, "GHN",
	308.14846, "GGPP",
	308.14846, "NPP",
	309.02755, "CCC",
	309.10732, "DGH",
	309.13247, "DPP",
	309.14370, "AHT",
	309.20524, "PVX",
	310.13174, "FY",
	310.16411, "AAAP",
	310.16411, "GGPV",
	310.16411, "NPV",
	310.17534, "GPR",
	311.10521, "ACH",
	311.12297, "HSS",
	311.14812, "DPV",
	311.18451, "PTX",
	311.22089, "VVX",
	312.14337, "AGPS",
	312.14337, "GGPT",
	312.14337, "NPT",
	312.14337, "PQS",
	312.17976, "AAAV",
	312.17976, "AAGX",
	312.17976, "AQX",
	312.17976, "GGVV",
	312.17976, "KPS",
	312.17976, "NVV",
	312.19099, "GRV",
	312.20222, "RR",
	312.21614, "AKX",
	313.12739, "DPT",
	313.12739, "EPS",
	313.13862, "AAGN",
	313.13862, "AGGQ",
	313.13862, "ANQ",
	313.13862, "GQQ",
	313.14601, "CPX",
	313.16377, "AEX",
	313.16377, "DVV",
	313.17500, "AGGK",
	313.17500, "AKN",
	313.17500, "GKQ",
	313.20016, "SXX",
	313.20016, "TVX",
	313.21139, "GKK",
	314.10488, "CGGP",
	314.10488, "CNP",
	314.12263, "AADG",
	314.12263, "ADQ",
	314.12263, "AEGG",
	314.12263, "AEN",
	314.12263, "EGQ",
	314.13789, "AGW",
	314.13789, "QW",
	314.15902, "AAAT",
	314.15902, "ADK",
	314.15902, "AGSV",
	314.15902, "EGK",
	314.15902, "GGSX",
	314.15902, "GGTV",
	314.15902, "NSX",
	314.15902, "NTV",
	314.15902, "QSV",
	314.17025, "ARS",
	314.17025, "GRT",
	314.17428, "KW",
	314.19541, "KSV",
	315.08889, "CDP",
	315.10665, "ADE",
	315.10665, "EEG",
	315.11788, "GGNS",
	315.11788, "NNS",
	315.12191, "EW",
	315.12528, "MPS",
	315.14304, "DSX",
	315.14304, "DTV",
	315.14304, "ESV",
	315.15829, "AFP",
	315.16166, "AMX",
	315.16166, "CVX",
	315.17942, "TTX",
	316.10190, "DGGS",
	316.10190, "DNS",
	316.12053, "AAAC",
	316.12053, "AGGM",
	316.12053, "AMN",
	316.12053, "CGGV",
	316.12053, "CNV",
	316.12053, "GMQ",
	316.13176, "CGR",
	316.13828, "AASS",
	316.13828, "AGST",
	316.13828, "GGTT",
	316.13828, "NTT",
	316.13828, "QST",
	316.15691, "GKM",
	316.17467, "KST",
	317.08591, "DDS",
	317.10454, "ADM",
	317.10454, "CDV",
	317.10454, "EGM",
	317.11980, "MW",
	317.12230, "DTT",
	317.12230, "EST",
	317.13756, "GPY",
	317.14093, "CTX",
	317.14093, "MSV",
	317.17394, "AFV",
	317.17394, "FGX",
	318.09979, "ACGS",
	318.09979, "CGGT",
	318.09979, "CNT",
	318.09979, "CQS",
	318.11755, "GSSS",
	318.13281, "FGGG",
	318.13281, "FGN",
	318.13618, "CKS",
	319.08381, "CDT",
	319.08381, "CES",
	319.10243, "CCX",
	319.10243, "GMM",
	319.11682, "DFG",
	319.12019, "MST",
	319.15321, "AFT",
	319.15321, "GVY",
	319.16444, "RY",
	320.06130, "CCGG",
	320.06130, "CCN",
	321.04531, "CCD",
	321.08170, "CMS",
	321.11471, "ACF",
	321.13247, "ASY",
	321.13247, "FSS",
	321.13247, "GTY",
	321.14370, "HPS",
	321.18009, "AHX",
	322.13895, "AGGH",
	322.13895, "AHN",
	322.13895, "GHQ",
	322.16411, "AGPP",
	322.16411, "PPQ",
	322.17534, "GHK",
	322.20049, "KPP",
	323.09398, "CGY",
	323.12297, "ADH",
	323.12297, "EGH",
	323.13822, "HW",
	323.14812, "EPP",
	323.15935, "HSV",
	323.22089, "PXX",
	324.17976, "AGPV",
	324.17976, "GGPX",
	324.17976, "NPX",
	324.17976, "PQV",
	324.19099, "APR",
	324.21614, "KPV",
	325.12086, "GHM",
	325.13862, "GGNP",
	325.13862, "HST",
	325.13862, "NNP",
	325.14601, "MPP",
	325.16377, "DPX",
	325.16377, "EPV",
	325.23654, "VXX",
	326.12263, "DGGP",
	326.12263, "DNP",
	326.12666, "YY",
	326.15902, "AAPS",
	326.15902, "AGPT",
	326.15902, "PQT",
	326.19541, "AAAX",
	326.19541, "AGVV",
	326.19541, "GGVX",
	326.19541, "KPT",
	326.19541, "NVX",
	326.19541, "QVV",
	326.20664, "ARV",
	326.20664, "GRX",
	326.23179, "KVV",
	327.10012, "CHS",
	327.10665, "DDP",
	327.14304, "EPT",
	327.15427, "AAAN",
	327.15427, "AAGQ",
	327.15427, "AQQ",
	327.15427, "GGNV",
	327.15427, "NNV",
	327.16166, "MPV",
	327.16550, "GGGR",
	327.16550, "GNR",
	327.17942, "DVX",
	327.17942, "EVV",
	327.19065, "AAGK",
	327.19065, "AKQ",
	327.21581, "TXX",
	327.22704, "AKK",
	328.12053, "ACGP",
	328.12053, "CPQ",
	328.13828, "AAAD",
	328.13828, "AAEG",
	328.13828, "AEQ",
	328.13828, "DGGV",
	328.13828, "DNV",
	328.13828, "GPSS",
	328.14952, "DGR",
	328.15354, "AAW",
	328.15691, "CKP",
	328.17467, "AASV",
	328.17467, "AEK",
	328.17467, "AGSX",
	328.17467, "AGTV",
	328.17467, "GGTX",
	328.17467, "NTX",
	328.17467, "QSX",
	328.17467, "QTV",
	328.18590, "ART",
	328.21106, "KSX",
	328.21106, "KTV",
	329.10454, "CEP",
	329.12230, "AEE",
	329.12230, "DDV",
	329.13353, "AGNS",
	329.13353, "GGNT",
	329.13353, "GGQS",
	329.13353, "NNT",
	329.13353, "NQS",
	329.14093, "MPT",
	329.15869, "DTX",
	329.15869, "ESX",
	329.15869, "ETV",
	329.16992, "GGKS",
	329.16992, "KNS",
	329.17731, "CXX",
	329.17731, "MVV",
	330.11755, "ADGS",
	330.11755, "DGGT",
	330.11755, "DNT",
	330.11755, "DQS",
	330.11755, "EGGS",
	330.11755, "ENS",
	330.13281, "GSW",
	330.13618, "AAGM",
	330.13618, "ACGV",
	330.13618, "AMQ",
	330.13618, "CGGX",
	330.13618, "CNX",
	330.13618, "CQV",
	330.14741, "ACR",
	330.15393, "AAST",
	330.15393, "AGTT",
	330.15393, "DKS",
	330.15393, "GSSV",
	330.15393, "QTT",
	330.16517, "RSS",
	330.17256, "AKM",
	330.17256, "CKV",
	330.19032, "KTT",
	331.09504, "CGGN",
	331.09504, "CNN",
	331.10156, "DDT",
	331.10156, "DES",
	331.10243, "CMP",
	331.12019, "AEM",
	331.12019, "CDX",
	331.12019, "CEV",
	331.13795, "ETT",
	331.13929, "GHH",
	331.15321, "APY",
	331.15321, "FPS",
	331.15658, "MSX",
	331.15658, "MTV",
	331.16444, "HPP",
	331.18959, "AFX",
	332.07905, "CDGG",
	332.07905, "CDN",
	332.11544, "AACS",
	332.11544, "ACGT",
	332.11544, "CQT",
	332.11544, "GGMS",
	332.11544, "MNS",
	332.13320, "ASSS",
	332.13320, "GSST",
	332.14846, "AFGG",
	332.14846, "AFN",
	332.14846, "FGQ",
	332.15183, "CKT",
	332.18484, "FGK",
	333.06307, "CDD",
	333.09946, "CET",
	333.09946, "DMS",
	333.11808, "AMM",
	333.11808, "CMV",
	333.13247, "ADF",
	333.13247, "EFG",
	333.13584, "MTT",
	333.14773, "FW",
	333.16886, "AVY",
	333.16886, "FSV",
	333.16886, "GXY",
	333.18009, "HPV",
	334.07695, "ACCG",
	334.07695, "CCQ",
	334.09471, "CGSS",
	334.11333, "CCK",
	334.12772, "GGGY",
	334.12772, "GNY",
	335.06096, "CCE",
	335.09735, "CMT",
	335.11174, "DGY",
	335.13036, "FGM",
	335.14812, "ATY",
	335.14812, "FST",
	335.15935, "HPT",
	335.19574, "HVV",
	336.15460, "AAGH",
	336.15460, "AHQ",
	336.17976, "AAPP",
	336.19099, "AHK",
	337.05885, "CCM",
	337.10963, "ACY",
	337.10963, "CFS",
	337.12086, "CHP",
	337.12739, "SSY",
	337.13862, "AEH",
	337.17500, "HSX",
	337.17500, "HTV",
	338.13387, "GGHS",
	338.13387, "HNS",
	338.15902, "GPPS",
	338.19541, "AAPV",
	338.19541, "AGPX",
	338.19541, "PQX",
	338.23179, "KPX",
	339.11788, "DHS",
	339.13651, "AHM",
	339.13651, "CHV",
	339.15427, "AGNP",
	339.15427, "GGPQ",
	339.15427, "HTT",
	339.15427, "NPQ",
	339.17942, "EPX",
	339.19065, "GGKP",
	339.19065, "KNP",
	339.25219, "XXX",
	340.13828, "ADGP",
	340.13828, "DPQ",
	340.13828, "EGGP",
	340.13828, "ENP",
	340.15354, "GPW",
	340.17467, "AAPT",
	340.17467, "DKP",
	340.17467, "GPSV",
	340.18590, "PRS",
	340.21106, "AAVV",
	340.21106, "AGVX",
	340.21106, "GGXX",
	340.21106, "NXX",
	340.21106, "QVX",
	340.22229, "ARX",
	340.24744, "KVX",
	341.11577, "CHT",
	341.12230, "DEP",
	341.14879, "FGH",
	341.16992, "AAAQ",
	341.16992, "AGNV",
	341.16992, "GGNX",
	341.16992, "GGQV",
	341.16992, "NNX",
	341.16992, "NQV",
	341.17394, "FPP",
	341.17731, "MPX",
	341.18115, "AGGR",
	341.18115, "ANR",
	341.18115, "GQR",
	341.19507, "DXX",
	341.19507, "EVX",
	341.20630, "AAAK",
	341.20630, "GGKV",
	341.20630, "KNV",
	341.21754, "GKR",
	342.12878, "GGNN",
	342.12878, "NNN",
	342.13618, "AACP",
	342.13618, "GGMP",
	342.13618, "MNP",
	342.15393, "AAAE",
	342.15393, "ADGV",
	342.15393, "APSS",
	342.15393, "DGGX",
	342.15393, "DNX",
	342.15393, "DQV",
	342.15393, "EGGV",
	342.15393, "ENV",
	342.15393, "GPST",
	342.16517, "ADR",
	342.16517, "EGR",
	342.16919, "GVW",
	342.18042, "RW",
	342.19032, "AASX",
	342.19032, "AATV",
	342.19032, "AGTX",
	342.19032, "DKV",
	342.19032, "GSVV",
	342.19032, "QTX",
	342.20155, "RSV",
	342.22671, "KTX",
	343.07728, "CCH",
	343.11280, "DGGN",
	343.11280, "DNN",
	343.12019, "DMP",
	343.13795, "DDX",
	343.13795, "DEV",
	343.14918, "AANS",
	343.14918, "AGNT",
	343.14918, "AGQS",
	343.14918, "GGQT",
	343.14918, "NQT",
	343.14918, "QQS",
	343.17434, "ETX",
	343.18557, "AGKS",
	343.18557, "GGKT",
	343.18557, "KNT",
	343.18557, "KQS",
	343.18959, "FPV",
	343.19296, "MVX",
	343.22195, "KKS",
	344.09681, "DDGG",
	344.09681, "DDN",
	344.11544, "CGPS",
	344.13320, "AADS",
	344.13320, "ADGT",
	344.13320, "AEGS",
	344.13320, "DQT",
	344.13320, "EGGT",
	344.13320, "ENT",
	344.13320, "EQS",
	344.14846, "ASW",
	344.14846, "GTW",
	344.15183, "AAAM",
	344.15183, "AACV",
	344.15183, "ACGX",
	344.15183, "CQX",
	344.15183, "GGMV",
	344.15183, "MNV",
	344.16306, "GMR",
	344.16958, "AATT",
	344.16958, "ASSV",
	344.16958, "DKT",
	344.16958, "EKS",
	344.16958, "GSSX",
	344.16958, "GSTV",
	344.18082, "RST",
	344.18821, "CKX",
	345.08083, "DDD",
	345.11069, "ACGN",
	345.11069, "CGGQ",
	345.11069, "CNQ",
	345.11721, "DET",
	345.11721, "EES",
	345.12845, "GNSS",
	345.13584, "CEX",
	345.13584, "DMV",
	345.14707, "CGGK",
	345.14707, "CKN",
	345.15494, "AHH",
	345.16886, "FPT",
	345.17223, "MTX",
	345.20524, "FVV",
	346.09471, "ACDG",
	346.09471, "CDQ",
	346.09471, "CEGG",
	346.09471, "CEN",
	346.10996, "CGW",
	346.11246, "DGSS",
	346.13109, "AACT",
	346.13109, "AGMS",
	346.13109, "CDK",
	346.13109, "CGSV",
	346.13109, "GGMT",
	346.13109, "MNT",
	346.13109, "MQS",
	346.14232, "CRS",
	346.14885, "ASST",
	346.14885, "GSTT",
	346.16411, "AAFG",
	346.16411, "AFQ",
	346.16748, "KMS",
	346.20049, "AFK",
	347.07872, "CDE",
	347.11511, "DMT",
	347.11511, "EMS",
	347.13036, "CFP",
	347.13373, "CMX",
	347.14812, "AEF",
	347.14812, "PSY",
	347.18451, "AXY",
	347.18451, "FSX",
	347.18451, "FTV",
	347.19574, "HPX",
	348.09260, "AACC",
	348.09260, "CGGM",
	348.09260, "CMN",
	348.11036, "ACSS",
	348.11036, "CGST",
	348.12811, "SSSS",
	348.14337, "AGGY",
	348.14337, "ANY",
	348.14337, "FGGS",
	348.14337, "FNS",
	348.14337, "GQY",
	348.15460, "GGHP",
	348.15460, "HNP",
	348.17976, "GKY",
	348.17976, "GPPP",
	349.07661, "CDM",
	349.11300, "MMS",
	349.12739, "ADY",
	349.12739, "DFS",
	349.12739, "EGY",
	349.13862, "DHP",
	349.14264, "WY",
	349.14601, "AFM",
	349.14601, "CFV",
	349.16377, "FTT",
	349.16377, "SVY",
	349.21139, "HVX",
	350.07186, "CCGS",
	350.17025, "AAAH",
	350.17025, "GGHV",
	350.17025, "HNV",
	350.18149, "GHR",
	350.19541, "GPPV",
	350.20664, "PPR",
	351.12528, "CFT",
	351.12528, "GMY",
	351.14304, "STY",
	351.15427, "DHV",
	351.15829, "FFG",
	351.19065, "HTX",
	352.14952, "AGHS",
	352.14952, "GGHT",
	352.14952, "HNT",
	352.14952, "HQS",
	352.17467, "APPS",
	352.17467, "GPPT",
	352.18590, "HKS",
	352.21106, "AAPX",
	352.21106, "GPVV",
	352.22229, "PRV",
	353.08678, "CCF",
	353.10454, "CSY",
	353.13353, "DHT",
	353.13353, "EHS",
	353.15216, "CHX",
	353.16992, "AANP",
	353.16992, "AGPQ",
	353.16992, "PQQ",
	353.20630, "AGKP",
	353.20630, "KPQ",
	353.24269, "KKP",
	354.11102, "CGGH",
	354.11102, "CHN",
	354.13618, "CGPP",
	354.15393, "AADP",
	354.15393, "AEGP",
	354.15393, "EPQ",
	354.16919, "APW",
	354.19032, "APSV",
	354.19032, "EKP",
	354.19032, "GPSX",
	354.19032, "GPTV",
	354.20155, "PRT",
	354.22671, "AAVX",
	354.22671, "AGXX",
	354.22671, "GVVV",
	354.22671, "QXX",
	354.23794, "RVV",
	354.26309, "KXX",
	355.09504, "CDH",
	355.13142, "HMS",
	355.13795, "EEP",
	355.14918, "GNPS",
	355.16444, "AFH",
	355.18557, "AANV",
	355.18557, "AGNX",
	355.18557, "AGQV",
	355.18557, "GGQX",
	355.18557, "NQX",
	355.18557, "QQV",
	355.19680, "AAGR",
	355.19680, "AQR",
	355.21072, "EXX",
	355.22195, "AGKV",
	355.22195, "GGKX",
	355.22195, "KNX",
	355.22195, "KQV",
	355.23319, "AKR",
	355.25834, "KKV",
	356.13320, "DGPS",
	356.14443, "AGNN",
	356.14443, "GGNQ",
	356.14443, "NNQ",
	356.15183, "AGMP",
	356.15183, "CGPV",
	356.15183, "MPQ",
	356.16306, "CPR",
	356.16958, "AADV",
	356.16958, "ADGX",
	356.16958, "AEGV",
	356.16958, "APST",
	356.16958, "DQX",
	356.16958, "EGGX",
	356.16958, "ENX",
	356.16958, "EQV",
	356.16958, "GPTT",
	356.18082, "AER",
	356.18082, "GGKN",
	356.18082, "KNN",
	356.18484, "AVW",
	356.18484, "GWX",
	356.18821, "KMP",
	356.20597, "AATX",
	356.20597, "ASVV",
	356.20597, "DKX",
	356.20597, "EKV",
	356.20597, "GSVX",
	356.20597, "GTVV",
	356.21720, "RSX",
	356.21720, "RTV",
	357.12845, "ADGN",
	357.12845, "DGGQ",
	357.12845, "DNQ",
	357.12845, "EGGN",
	357.12845, "ENN",
	357.13584, "EMP",
	357.14370, "GGGW",
	357.14370, "GHY",
	357.14370, "GNW",
	357.15360, "DEX",
	357.15360, "EEV",
	357.16483, "AANT",
	357.16483, "AAQS",
	357.16483, "AGQT",
	357.16483, "DGGK",
	357.16483, "DKN",
	357.16483, "GNSV",
	357.16483, "QQT",
	357.16886, "PPY",
	357.17607, "GGRS",
	357.17607, "NRS",
	357.20122, "AAKS",
	357.20122, "AGKT",
	357.20122, "KQT",
	357.20524, "FPX",
	357.20861, "MXX",
	357.23760, "KKT",
	358.11246, "ADDG",
	358.11246, "DDQ",
	358.11246, "DEGG",
	358.11246, "DEN",
	358.12772, "DGW",
	358.13109, "ACPS",
	358.13109, "CGPT",
	358.14885, "AADT",
	358.14885, "AAES",
	358.14885, "AEGT",
	358.14885, "DDK",
	358.14885, "DGSV",
	358.14885, "EQT",
	358.14885, "PSSS",
	358.16008, "DRS",
	358.16411, "ATW",
	358.16411, "FGGP",
	358.16411, "FNP",
	358.16748, "AACX",
	358.16748, "AGMV",
	358.16748, "CGVV",
	358.16748, "GGMX",
	358.16748, "MNX",
	358.16748, "MQV",
	358.17871, "AMR",
	358.17871, "CRV",
	358.18523, "ASSX",
	358.18523, "ASTV",
	358.18523, "EKT",
	358.18523, "GSTX",
	358.18523, "GTTV",
	358.19647, "RTT",
	358.20386, "KMV",
	359.09648, "DDE",
	359.12634, "AACN",
	359.12634, "ACGQ",
	359.12634, "CQQ",
	359.12634, "GGMN",
	359.12634, "MNN",
	359.13286, "EET",
	359.13373, "MMP",
	359.14410, "ANSS",
	359.14410, "GNST",
	359.14410, "GQSS",
	359.14812, "DFP",
	359.15149, "DMX",
	359.15149, "EMV",
	359.16273, "ACGK",
	359.16273, "CKQ",
	359.18048, "GKSS",
	359.18451, "PVY",
	359.19911, "CKK",
	359.22089, "FVX",
	360.09260, "CCGP",
	360.11036, "AACD",
	360.11036, "ACEG",
	360.11036, "CEQ",
	360.11036, "DGGM",
	360.11036, "DMN",
	360.12561, "ACW",
	360.12811, "ADSS",
	360.12811, "DGST",
	360.12811, "EGSS",
	360.14337, "SSW",
	360.14674, "AAMS",
	360.14674, "ACSV",
	360.14674, "AGMT",
	360.14674, "CEK",
	360.14674, "CGSX",
	360.14674, "CGTV",
	360.14674, "MQT",
	360.15797, "CRT",
	360.16450, "ASTT",
	360.16450, "GTTT",
	360.16450, "SSSV",
	360.17976, "AAAF",
	360.17976, "FGGV",
	360.17976, "FNV",
	360.18313, "KMT",
	360.19099, "FGR",
	361.09437, "CEE",
	361.09437, "DDM",
	361.10560, "CGNS",
	361.13076, "EMT",
	361.14938, "MMV",
	361.14985, "HHS",
	361.16377, "DFV",
	361.16377, "PTY",
	361.20016, "FTX",
	361.20016, "VVY",
	362.08962, "CDGS",
	362.10825, "ACGM",
	362.10825, "CCGV",
	362.10825, "CMQ",
	362.11948, "CCR",
	362.12601, "ACST",
	362.12601, "CGTT",
	362.12601, "GMSS",
	362.14376, "SSST",
	362.14463, "CKM",
	362.15902, "AAGY",
	362.15902, "AFGS",
	362.15902, "AQY",
	362.15902, "FGGT",
	362.15902, "FNT",
	362.15902, "FQS",
	362.17025, "AGHP",
	362.17025, "HPQ",
	362.19541, "AKY",
	362.19541, "APPP",
	362.19541, "FKS",
	362.20664, "HKP",
	363.09226, "CEM",
	363.12528, "CPY",
	363.12865, "MMT",
	363.14304, "AEY",
	363.14304, "DFT",
	363.14304, "EFS",
	363.15427, "EHP",
	363.16166, "CFX",
	363.17942, "SXY",
	363.17942, "TVY",
	363.22704, "HXX",
	364.08751, "ACCS",
	364.08751, "CCGT",
	364.10527, "CSSS",
	364.12053, "CFGG",
	364.12053, "CFN",
	364.13828, "GGSY",
	364.13828, "NSY",
	364.18590, "AGHV",
	364.18590, "GGHX",
	364.18590, "HNX",
	364.18590, "HQV",
	364.19714, "AHR",
	364.21106, "APPV",
	364.21106, "GPPX",
	364.22229, "HKV",
	365.09015, "CMM",
	365.10454, "CDF",
	365.12230, "DSY",
	365.14093, "AMY",
	365.14093, "CVY",
	365.14093, "FMS",
	365.14477, "GGHN",
	365.14477, "HNN",
	365.15216, "HMP",
	365.15869, "TTY",
	365.16992, "DHX",
	365.16992, "EHV",
	365.16992, "GNPP",
	365.17394, "AFF",
	366.04902, "CCCG",
	366.12878, "DGGH",
	366.12878, "DHN",
	366.15393, "DGPP",
	366.16517, "AAHS",
	366.16517, "AGHT",
	366.16517, "HQT",
	366.19032, "APPT",
	366.20155, "HKT",
	366.22671, "APVV",
	366.22671, "GPVX",
	366.23794, "PRX",
	367.11280, "DDH",
	367.12019, "CTY",
	367.14918, "EHT",
	367.15321, "FGY",
	367.16781, "HMV",
	367.18557, "AAPQ",
	367.18557, "GNPV",
	367.19680, "GGPR",
	367.19680, "NPR",
	367.22195, "AAKP",
	368.12667, "ACGH",
	368.12667, "CHQ",
	368.14443, "GHSS",
	368.15183, "ACPP",
	368.16306, "CHK",
	368.16958, "AAEP",
	368.16958, "DGPV",
	368.16958, "PPSS",
	368.18082, "DPR",
	368.20597, "APSX",
	368.20597, "APTV",
	368.20597, "GPTX",
	368.24236, "AAXX",
	368.24236, "AVVV",
	368.24236, "GVVX",
	368.25359, "RVX",
	369.08170, "CCY",
	369.11069, "CEH",
	369.14707, "HMT",
	369.16483, "ANPS",
	369.16483, "GNPT",
	369.16483, "GPQS",
	369.20122, "AANX",
	369.20122, "AAQV",
	369.20122, "AGQX",
	369.20122, "GKPS",
	369.20122, "GNVV",
	369.20122, "QQX",
	369.21245, "AAAR",
	369.21245, "GGRV",
	369.21245, "NRV",
	369.22369, "GRR",
	369.23760, "AAKV",
	369.23760, "AGKX",
	369.23760, "KQX",
	369.27399, "KKX",
	370.14885, "ADPS",
	370.14885, "DGPT",
	370.14885, "EGPS",
	370.16008, "AANN",
	370.16008, "AGNQ",
	370.16008, "GGQQ",
	370.16008, "NQQ",
	370.16411, "PSW",
	370.16748, "AAMP",
	370.16748, "ACPV",
	370.16748, "CGPX",
	370.18523, "AADX",
	370.18523, "AAEV",
	370.18523, "AEGX",
	370.18523, "APTT",
	370.18523, "DGVV",
	370.18523, "EQX",
	370.18523, "PSSV",
	370.19647, "AGKN",
	370.19647, "DRV",
	370.19647, "GGKQ",
	370.19647, "KNQ",
	370.20049, "AWX",
	370.22162, "ASVX",
	370.22162, "ATVV",
	370.22162, "EKX",
	370.22162, "GSXX",
	370.22162, "GTVX",
	370.23285, "GGKK",
	370.23285, "KKN",
	370.23285, "RTX",
	371.10858, "CHM",
	371.12634, "CGNP",
	371.14410, "AADN",
	371.14410, "ADGQ",
	371.14410, "AEGN",
	371.14410, "DQQ",
	371.14410, "EGGQ",
	371.14410, "ENQ",
	371.15935, "AGGW",
	371.15935, "AHY",
	371.15935, "ANW",
	371.15935, "FHS",
	371.15935, "GQW",
	371.16925, "EEX",
	371.17059, "HHP",
	371.18048, "AAQT",
	371.18048, "ADGK",
	371.18048, "ANSV",
	371.18048, "DKQ",
	371.18048, "EGGK",
	371.18048, "EKN",
	371.18048, "GNSX",
	371.18048, "GNTV",
	371.18048, "GQSV",
	371.19172, "AGRS",
	371.19172, "GGRT",
	371.19172, "NRT",
	371.19172, "QRS",
	371.19574, "GKW",
	371.21687, "AAKT",
	371.21687, "DKK",
	371.21687, "GKSV",
	371.22810, "KRS",
	372.11036, "CDGP",
	372.12811, "AADD",
	372.12811, "ADEG",
	372.12811, "DEQ",
	372.12811, "EEGG",
	372.12811, "EEN",
	372.13935, "GNNS",
	372.14337, "ADW",
	372.14337, "EGW",
	372.14674, "ACPT",
	372.14674, "GMPS",
	372.15863, "WW",
	372.16450, "AAET",
	372.16450, "ADSV",
	372.16450, "DEK",
	372.16450, "DGSX",
	372.16450, "DGTV",
	372.16450, "EGSV",
	372.16450, "PSST",
	372.17573, "DRT",
	372.17573, "ERS",
	372.17976, "AFGP",
	372.17976, "FPQ",
	372.17976, "SVW",
	372.18313, "AAMV",
	372.18313, "ACVV",
	372.18313, "AGMX",
	372.18313, "CGVX",
	372.18313, "MQX",
	372.19436, "CRX",
	372.20088, "ASTX",
	372.20088, "ATTV",
	372.20088, "GTTX",
	372.20088, "SSVV",
	372.21614, "FKP",
	372.21951, "KMX",
	373.11213, "DEE",
	373.12336, "DGNS",
	373.14199, "AACQ",
	373.14199, "AGMN",
	373.14199, "CGNV",
	373.14199, "GGMQ",
	373.14199, "MNQ",
	373.15322, "CGGR",
	373.15322, "CNR",
	373.15975, "ANST",
	373.15975, "AQSS",
	373.15975, "GNTT",
	373.15975, "GQST",
	373.16377, "EFP",
	373.16714, "EMX",
	373.17838, "AACK",
	373.17838, "GGKM",
	373.17838, "KMN",
	373.18624, "HHV",
	373.19613, "AKSS",
	373.19613, "GKST",
	373.20016, "PXY",
	373.23654, "FXX",
	374.10738, "DDGS",
	374.10825, "ACCP",
	374.12601, "AACE",
	374.12601, "ADGM",
	374.12601, "CDGV",
	374.12601, "CPSS",
	374.12601, "DMQ",
	374.12601, "EGGM",
	374.12601, "EMN",
	374.13724, "CDR",
	374.14126, "GMW",
	374.14376, "ADST",
	374.14376, "AESS",
	374.14376, "DGTT",
	374.14376, "EGST",
	374.15902, "GGPY",
	374.15902, "NPY",
	374.15902, "STW",
	374.16239, "AAMT",
	374.16239, "ACSX",
	374.16239, "ACTV",
	374.16239, "CGTX",
	374.16239, "DKM",
	374.16239, "GMSV",
	374.17362, "MRS",
	374.18015, "ATTT",
	374.18015, "SSSX",
	374.18015, "SSTV",
	374.19541, "AFGV",
	374.19541, "FGGX",
	374.19541, "FNX",
	374.19541, "FQV",
	374.20664, "AFR",
	374.23179, "FKV",
	375.11002, "DEM",
	375.12125, "ACNS",
	375.12125, "CGNT",
	375.12125, "CGQS",
	375.13901, "NSSS",
	375.14304, "DPY",
	375.15427, "FGGN",
	375.15427, "FNN",
	375.15764, "CGKS",
	375.16166, "FMP",
	375.16503, "MMX",
	375.16550, "HHT",
	375.17942, "DFX",
	375.17942, "EFV",
	375.21581, "VXY",
	376.10527, "ACDS",
	376.10527, "CDGT",
	376.10527, "CEGS",
	376.12053, "CSW",
	376.12303, "DSSS",
	376.12390, "AACM",
	376.12390, "ACCV",
	376.12390, "CCGX",
	376.12390, "GGMM",
	376.12390, "MMN",
	376.13828, "DFGG",
	376.13828, "DFN",
	376.14166, "ACTT",
	376.14166, "AMSS",
	376.14166, "CSSV",
	376.14166, "GMST",
	376.15941, "SSTT",
	376.17467, "AAAY",
	376.17467, "AAFS",
	376.17467, "AFGT",
	376.17467, "FQT",
	376.17467, "GGVY",
	376.17467, "NVY",
	376.18590, "AAHP",
	376.18590, "GRY",
	376.21106, "FKT",
	377.08276, "CCGN",
	377.10791, "DMM",
	377.12230, "DDF",
	377.12701, "CHH",
	377.15869, "DVY",
	377.15869, "EFT",
	377.17731, "FMV",
	377.19507, "TXY",
	378.06678, "CCDG",
	378.10316, "ACCT",
	378.10316, "CGMS",
	378.12092, "CSST",
	378.13618, "ACFG",
	378.13618, "CFQ",
	378.15393, "AGSY",
	378.15393, "FGSS",
	378.15393, "GGTY",
	378.15393, "NTY",
	378.15393, "QSY",
	378.16517, "GHPS",
	378.17256, "CFK",
	378.19032, "KSY",
	378.19032, "PPPS",
	378.20155, "AAHV",
	378.20155, "AGHX",
	378.20155, "HQX",
	378.22671, "APPX",
	378.23794, "HKX",
	379.12019, "CEF",
	379.13795, "DTY",
	379.13795, "ESY",
	379.15658, "CXY",
	379.15658, "FMT",
	379.16042, "AGHN",
	379.16042, "GGHQ",
	379.16042, "HNQ",
	379.18557, "ANPP",
	379.18557, "EHX",
	379.18557, "GPPQ",
	379.19680, "GGHK",
	379.19680, "HKN",
	379.22195, "GKPP",
	380.06467, "ACCC",
	380.08243, "CCSS",
	380.11544, "CGGY",
	380.11544, "CNY",
	380.14443, "ADGH",
	380.14443, "DHQ",
	380.14443, "EGGH",
	380.14443, "EHN",
	380.15969, "GHW",
	380.16958, "ADPP",
	380.16958, "EGPP",
	380.18082, "AAHT",
	380.18082, "DHK",
	380.18082, "GHSV",
	380.18484, "PPW",
	380.19205, "HRS",
	380.20597, "PPSV",
	380.24236, "APVX",
	380.24236, "GPXX",
	381.09946, "CDY",
	381.11808, "CFM",
	381.12845, "DEH",
	381.13584, "MSY",
	381.16886, "AFY",
	381.16886, "FFS",
	381.18009, "FHP",
	381.18346, "HMX",
	381.20122, "ANPV",
	381.20122, "GNPX",
	381.20122, "GPQV",
	381.21245, "AGPR",
	381.21245, "PQR",
	381.23760, "GKPV",
	381.24884, "KPR",
	382.14232, "AACH",
	382.14232, "GGHM",
	382.14232, "HMN",
	382.16008, "AHSS",
	382.16008, "GHST",
	382.16008, "GNNP",
	382.16748, "GMPP",
	382.18523, "ADPV",
	382.18523, "DGPX",
	382.18523, "EGPV",
	382.18523, "PPST",
	382.19647, "EPR",
	382.20049, "PVW",
	382.22162, "APTX",
	382.22162, "PSVV",
	382.25801, "AVVX",
	382.25801, "GVXX",
	382.26924, "RXX",
	383.12634, "DHM",
	383.14410, "DGNP",
	383.14812, "GYY",
	383.18048, "ANPT",
	383.18048, "APQS",
	383.18048, "GPQT",
	383.19574, "FHV",
	383.21687, "AAQX",
	383.21687, "AKPS",
	383.21687, "ANVV",
	383.21687, "GKPT",
	383.21687, "GNVX",
	383.21687, "GQVV",
	383.22810, "AGRV",
	383.22810, "GGRX",
	383.22810, "NRX",
	383.22810, "QRV",
	383.23934, "ARR",
	383.25325, "AAKX",
	383.25325, "GKVV",
	383.26449, "KRV",
	384.12159, "CGHS",
	384.12811, "DDGP",
	384.14674, "CPPS",
	384.16450, "ADPT",
	384.16450, "AEPS",
	384.16450, "EGPT",
	384.17573, "AANQ",
	384.17573, "AGQQ",
	384.17573, "GNNV",
	384.17573, "QQQ",
	384.17976, "PTW",
	384.18313, "ACPX",
	384.18313, "GMPV",
	384.18697, "GGNR",
	384.18697, "NNR",
	384.19436, "MPR",
	384.20088, "AAEX",
	384.20088, "ADVV",
	384.20088, "DGVX",
	384.20088, "EGVV",
	384.20088, "PSSX",
	384.20088, "PSTV",
	384.21212, "AAKN",
	384.21212, "AGKQ",
	384.21212, "DRX",
	384.21212, "ERV",
	384.21212, "KQQ",
	384.21614, "VVW",
	384.23727, "ASXX",
	384.23727, "ATVX",
	384.23727, "GTXX",
	384.23727, "SVVV",
	384.24850, "AGKK",
	384.24850, "KKQ",
	384.28489, "KKK",
	385.14199, "ACNP",
	385.14199, "CGPQ",
	385.15975, "AADQ",
	385.15975, "AAEN",
	385.15975, "AEGQ",
	385.15975, "DGNV",
	385.15975, "EQQ",
	385.15975, "NPSS",
	385.17098, "DGGR",
	385.17098, "DNR",
	385.17500, "AAGW",
	385.17500, "AQW",
	385.17500, "FHT",
	385.17838, "CGKP",
	385.19613, "AADK",
	385.19613, "AEGK",
	385.19613, "ANSX",
	385.19613, "ANTV",
	385.19613, "AQSV",
	385.19613, "EKQ",
	385.19613, "GNTX",
	385.19613, "GQSX",
	385.19613, "GQTV",
	385.20737, "AARS",
	385.20737, "AGRT",
	385.20737, "QRT",
	385.21139, "AKW",
	385.23252, "AKSV",
	385.23252, "EKK",
	385.23252, "GKSX",
	385.23252, "GKTV",
	385.24375, "KRT",
	386.12601, "ACDP",
	386.12601, "CEGP",
	386.14126, "CPW",
	386.14376, "AADE",
	386.14376, "AEEG",
	386.14376, "DDGV",
	386.14376, "DPSS",
	386.14376, "EEQ",
	386.15500, "ANNS",
	386.15500, "DDR",
	386.15500, "GNNT",
	386.15500, "GNQS",
	386.15902, "AEW",
	386.16239, "AMPS",
	386.16239, "CPSV",
	386.16239, "GMPT",
	386.18015, "ADSX",
	386.18015, "ADTV",
	386.18015, "AESV",
	386.18015, "DGTX",
	386.18015, "EEK",
	386.18015, "EGSX",
	386.18015, "EGTV",
	386.18015, "PSTT",
	386.19138, "ERT",
	386.19138, "GKNS",
	386.19541, "AAFP",
	386.19541, "SWX",
	386.19541, "TVW",
	386.19878, "AAMX",
	386.19878, "ACVX",
	386.19878, "CGXX",
	386.19878, "GMVV",
	386.21001, "MRV",
	386.21653, "ATTX",
	386.21653, "SSVX",
	386.21653, "STVV",
	387.12778, "EEE",
	387.13651, "CFH",
	387.13901, "ADNS",
	387.13901, "DGNT",
	387.13901, "DGQS",
	387.13901, "EGNS",
	387.15427, "GGSW",
	387.15427, "HSY",
	387.15427, "NSW",
	387.15764, "AAMN",
	387.15764, "ACNV",
	387.15764, "AGMQ",
	387.15764, "CGNX",
	387.15764, "CGQV",
	387.15764, "MQQ",
	387.16887, "ACGR",
	387.16887, "CQR",
	387.17540, "ANTT",
	387.17540, "AQST",
	387.17540, "DGKS",
	387.17540, "GQTT",
	387.17540, "NSSV",
	387.18663, "GRSS",
	387.19403, "AGKM",
	387.19403, "CGKV",
	387.19403, "KMQ",
	387.20189, "HHX",
	387.20526, "CKR",
	387.21178, "AKST",
	387.21178, "GKTT",
	387.23041, "KKM",
	388.11650, "CGNN",
	388.12303, "ADDS",
	388.12303, "DDGT",
	388.12303, "DEGS",
	388.12390, "CGMP",
	388.13828, "DSW",
	388.14166, "AADM",
	388.14166, "ACDV",
	388.14166, "AEGM",
	388.14166, "CDGX",
	388.14166, "CEGV",
	388.14166, "CPST",
	388.14166, "EMQ",
	388.15289, "CER",
	388.15691, "AMW",
	388.15691, "CVW",
	388.15941, "ADTT",
	388.15941, "AEST",
	388.15941, "DSSV",
	388.15941, "EGTT",
	388.16075, "GGHH",
	388.16075, "HHN",
	388.17467, "AGPY",
	388.17467, "FGPS",
	388.17467, "PQY",
	388.17467, "TTW",
	388.17804, "ACTX",
	388.17804, "AMSV",
	388.17804, "CSVV",
	388.17804, "EKM",
	388.17804, "GMSX",
	388.17804, "GMTV",
	388.18590, "GHPP",
	388.18927, "MRT",
	388.19580, "SSTX",
	388.19580, "STTV",
	388.21106, "AAFV",
	388.21106, "AFGX",
	388.21106, "FQX",
	388.21106, "KPY",
	388.21106, "PPPP",
	388.24744, "FKX",
	389.10052, "CDGN",
	389.12567, "EEM",
	389.13690, "ACNT",
	389.13690, "ACQS",
	389.13690, "CGQT",
	389.13690, "GMNS",
	389.14477, "DHH",
	389.15466, "NSST",
	389.15466, "QSSS",
	389.15869, "EPY",
	389.16992, "AFGN",
	389.16992, "FGGQ",
	389.16992, "FNQ",
	389.17329, "ACKS",
	389.17329, "CGKT",
	389.19105, "KSSS",
	389.19507, "EFX",
	389.20630, "FGGK",
	389.20630, "FKN",
	389.23146, "XXY",
	390.08453, "CDDG",
	390.10316, "CCPS",
	390.12092, "ACDT",
	390.12092, "ACES",
	390.12092, "CEGT",
	390.12092, "DGMS",
	390.13618, "CTW",
	390.13868, "DSST",
	390.13868, "ESSS",
	390.13955, "ACCX",
	390.13955, "AGMM",
	390.13955, "CGMV",
	390.13955, "MMQ",
	390.15078, "CMR",
	390.15393, "ADFG",
	390.15393, "DFQ",
	390.15393, "EFGG",
	390.15393, "EFN",
	390.15731, "AMST",
	390.15731, "CSSX",
	390.15731, "CSTV",
	390.15731, "GMTT",
	390.16919, "FGW",
	390.17506, "STTT",
	390.17593, "KMM",
	390.19032, "AAFT",
	390.19032, "AGVY",
	390.19032, "DFK",
	390.19032, "FGSV",
	390.19032, "GGXY",
	390.19032, "NXY",
	390.19032, "QVY",
	390.20155, "ARY",
	390.20155, "FRS",
	390.20155, "GHPV",
	390.21279, "HPR",
	390.22671, "KVY",
	390.22671, "PPPV",
	391.09841, "ACCN",
	391.09841, "CCGQ",
	391.11617, "CNSS",
	391.12356, "EMM",
	391.13480, "CCGK",
	391.13795, "DEF",
	391.14918, "GGNY",
	391.14918, "NNY",
	391.15658, "MPY",
	391.17434, "DXY",
	391.17434, "EVY",
	391.18959, "FFP",
	391.19296, "FMX",
	392.08243, "ACCD",
	392.08243, "CCEG",
	392.09768, "CCW",
	392.10018, "CDSS",
	392.11881, "ACMS",
	392.11881, "CCSV",
	392.11881, "CGMT",
	392.13320, "DGGY",
	392.13320, "DNY",
	392.13657, "CSTT",
	392.13657, "MSSS",
	392.15183, "AACF",
	392.15183, "FGGM",
	392.15183, "FMN",
	392.16958, "AASY",
	392.16958, "AFSS",
	392.16958, "AGTY",
	392.16958, "FGST",
	392.16958, "QTY",
	392.18082, "AHPS",
	392.18082, "GHPT",
	392.20597, "KTY",
	392.20597, "PPPT",
	392.21720, "AAHX",
	392.21720, "GHVV",
	392.22844, "HRV",
	392.24236, "PPVV",
	393.11721, "DDY",
	393.12145, "MMM",
	393.13584, "DFM",
	393.15360, "ETY",
	393.17223, "MVY",
	393.17607, "AAHN",
	393.17607, "AGHQ",
	393.17607, "HQQ",
	393.20122, "APPQ",
	393.20524, "FFV",
	393.21245, "AGHK",
	393.21245, "HKQ",
	393.23760, "AKPP",
	393.24884, "HKK",
	394.08032, "CCGM",
	394.09808, "CCST",
	394.13109, "ACGY",
	394.13109, "CFGS",
	394.13109, "CQY",
	394.14232, "CGHP",
	394.14885, "GSSY",
	394.16008, "AADH",
	394.16008, "AEGH",
	394.16008, "EHQ",
	394.16748, "CKY",
	394.16748, "CPPP",
	394.17534, "AHW",
	394.18523, "AEPP",
	394.19647, "AHSV",
	394.19647, "EHK",
	394.19647, "GHSX",
	394.19647, "GHTV",
	394.20770, "HRT",
	394.22162, "PPSX",
	394.22162, "PPTV",
	394.25801, "APXX",
	394.25801, "PVVV",
	395.11511, "CEY",
	395.14410, "EEH",
	395.15149, "MTY",
	395.15533, "GHNS",
	395.18048, "NPPS",
	395.18451, "FFT",
	395.21687, "ANPX",
	395.21687, "APQV",
	395.21687, "GPQX",
	395.22810, "AAPR",
	395.25325, "AKPV",
	395.25325, "GKPX",
	396.05958, "CCCS",
	396.13935, "DGHS",
	396.15797, "AGHM",
	396.15797, "CGHV",
	396.15797, "HMQ",
	396.16450, "DPPS",
	396.16921, "CHR",
	396.17573, "AHST",
	396.17573, "ANNP",
	396.17573, "GHTT",
	396.17573, "GNPQ",
	396.18313, "AMPP",
	396.18313, "CPPV",
	396.19436, "HKM",
	396.20088, "ADPX",
	396.20088, "AEPV",
	396.20088, "EGPX",
	396.20088, "PPTT",
	396.21212, "GKNP",
	396.21614, "PWX",
	396.23727, "PSVX",
	396.23727, "PTVV",
	396.27366, "AVXX",
	396.27366, "GXXX",
	396.27366, "VVVV",
	397.11300, "CMY",
	397.14199, "EHM",
	397.14601, "CFF",
	397.15975, "ADNP",
	397.15975, "DGPQ",
	397.15975, "EGNP",
	397.16377, "AYY",
	397.16377, "FSY",
	397.17500, "GGPW",
	397.17500, "HPY",
	397.17500, "NPW",
	397.19613, "APQT",
	397.19613, "DGKP",
	397.19613, "NPSV",
	397.20737, "GPRS",
	397.21139, "FHX",
	397.23252, "AKPT",
	397.23252, "ANVX",
	397.23252, "AQVV",
	397.23252, "GNXX",
	397.23252, "GQVX",
	397.24375, "AARV",
	397.24375, "AGRX",
	397.24375, "QRX",
	397.26890, "AKVV",
	397.26890, "GKVX",
	397.28014, "KRX",
	398.13724, "ACHS",
	398.13724, "CGHT",
	398.14376, "ADDP",
	398.14376, "DEGP",
	398.15500, "HSSS",
	398.15902, "DPW",
	398.16239, "CPPT",
	398.17025, "FGGH",
	398.17025, "FHN",
	398.18015, "AEPT",
	398.18015, "DPSV",
	398.19138, "AAQQ",
	398.19138, "ANNV",
	398.19138, "GNNX",
	398.19138, "GNQV",
	398.19541, "FGPP",
	398.19878, "AMPV",
	398.19878, "CPVV",
	398.19878, "GMPX",
	398.20262, "AGNR",
	398.20262, "GGQR",
	398.20262, "NQR",
	398.21653, "ADVX",
	398.21653, "AEVV",
	398.21653, "DGXX",
	398.21653, "EGVX",
	398.21653, "PSTX",
	398.21653, "PTTV",
	398.22777, "AAKQ",
	398.22777, "ERX",
	398.22777, "GKNV",
	398.23179, "VWX",
	398.23900, "GGKR",
	398.23900, "KNR",
	398.25292, "ATXX",
	398.25292, "SVVX",
	398.25292, "TVVV",
	398.26415, "AAKK",
	399.13988, "HMM",
	399.15025, "GNNN",
	399.15427, "DFH",
	399.15764, "ACPQ",
	399.15764, "GMNP",
	399.17540, "AAEQ",
	399.17540, "ADNV",
	399.17540, "DGNX",
	399.17540, "DGQV",
	399.17540, "EGNV",
	399.17540, "NPST",
	399.17540, "PQSS",
	399.18663, "ADGR",
	399.18663, "DQR",
	399.18663, "EGGR",
	399.18663, "ENR",
	399.19065, "AAAW",
	399.19065, "GGVW",
	399.19065, "HVY",
	399.19065, "NVW",
	399.19403, "ACKP",
	399.20189, "GRW",
	399.21178, "AAEK",
	399.21178, "ANTX",
	399.21178, "AQSX",
	399.21178, "AQTV",
	399.21178, "DGKV",
	399.21178, "GQTX",
	399.21178, "KPSS",
	399.21178, "NSVV",
	399.22302, "AART",
	399.22302, "DKR",
	399.22302, "GRSV",
	399.23425, "RRS",
	399.24817, "AKSX",
	399.24817, "AKTV",
	399.24817, "GKTX",
	400.09874, "CCGH",
	400.12390, "CCPP",
	400.13426, "DGNN",
	400.14166, "ACEP",
	400.14166, "DGMP",
	400.15941, "AAEE",
	400.15941, "ADDV",
	400.15941, "DDGX",
	400.15941, "DEGV",
	400.15941, "DPST",
	400.15941, "EPSS",
	400.17065, "ANNT",
	400.17065, "ANQS",
	400.17065, "DER",
	400.17065, "GNQT",
	400.17065, "GQQS",
	400.17467, "DVW",
	400.17804, "AMPT",
	400.17804, "CPSX",
	400.17804, "CPTV",
	400.19580, "ADTX",
	400.19580, "AESX",
	400.19580, "AETV",
	400.19580, "DSVV",
	400.19580, "EGTX",
	400.19580, "PTTT",
	400.20703, "AKNS",
	400.20703, "GKNT",
	400.20703, "GKQS",
	400.21106, "FGPV",
	400.21106, "TWX",
	400.21443, "ACXX",
	400.21443, "AMVV",
	400.21443, "CVVV",
	400.21443, "GMVX",
	400.22229, "FPR",
	400.22566, "MRX",
	400.23218, "SSXX",
	400.23218, "STVX",
	400.23218, "TTVV",
	400.24342, "GKKS",
	401.11828, "DDGN",
	401.13690, "CNPS",
	401.15466, "ADNT",
	401.15466, "ADQS",
	401.15466, "AENS",
	401.15466, "DGQT",
	401.15466, "EGNT",
	401.15466, "EGQS",
	401.16992, "AGSW",
	401.16992, "GGTW",
	401.16992, "HTY",
	401.16992, "NTW",
	401.16992, "QSW",
	401.17329, "AAMQ",
	401.17329, "ACNX",
	401.17329, "ACQV",
	401.17329, "CGQX",
	401.17329, "GMNV",
	401.18452, "AACR",
	401.18452, "GGMR",
	401.18452, "MNR",
	401.19105, "ADKS",
	401.19105, "AQTT",
	401.19105, "DGKT",
	401.19105, "EGKS",
	401.19105, "NSSX",
	401.19105, "NSTV",
	401.19105, "QSSV",
	401.20228, "ARSS",
	401.20228, "GRST",
	401.20630, "KSW",
	401.20968, "AAKM",
	401.20968, "ACKV",
	401.20968, "CGKX",
	401.22743, "AKTT",
	401.22743, "KSSV",
	402.10229, "DDDG",
	402.12092, "CDPS",
	402.13215, "ACNN",
	402.13215, "CGNQ",
	402.13868, "ADDT",
	402.13868, "ADES",
	402.13868, "DEGT",
	402.13868, "EEGS",
	402.13955, "ACMP",
	402.13955, "CCPV",
	402.14991, "NNSS",
	402.15393, "DTW",
	402.15393, "ESW",
	402.15731, "AAEM",
	402.15731, "ACDX",
	402.15731, "ACEV",
	402.15731, "CEGX",
	402.15731, "CPTT",
	402.15731, "DGMV",
	402.15731, "MPSS",
	402.16854, "CGKN",
	402.16854, "DMR",
	402.17256, "CWX",
	402.17506, "AETT",
	402.17506, "DSSX",
	402.17506, "DSTV",
	402.17506, "ESSV",
	402.17640, "AGHH",
	402.17640, "HHQ",
	402.19032, "AAPY",
	402.19032, "AFPS",
	402.19032, "FGPT",
	402.19369, "AMSX",
	402.19369, "AMTV",
	402.19369, "CSVX",
	402.19369, "CTVV",
	402.19369, "GMTX",
	402.20155, "AHPP",
	402.21145, "STTX",
	402.21145, "TTTV",
	402.21279, "HHK",
	402.22671, "AAFX",
	402.22671, "FGVV",
	402.23794, "FRV",
	403.11617, "ACDN",
	403.11617, "CDGQ",
	403.11617, "CEGN",
	403.13142, "CGGW",
	403.13142, "CHY",
	403.13142, "CNW",
	403.13393, "DNSS",
	403.15255, "ACQT",
	403.15255, "AMNS",
	403.15255, "CDGK",
	403.15255, "CNSV",
	403.15255, "GMNT",
	403.15255, "GMQS",
	403.16042, "EHH",
	403.16379, "CGRS",
	403.17031, "NSTT",
	403.17031, "QSST",
	403.18557, "AAFN",
	403.18557, "AFGQ",
	403.18557, "FQQ",
	403.18894, "ACKT",
	403.18894, "GKMS",
	403.20670, "KSST",
	403.22195, "AFGK",
	403.22195, "FKQ",
	403.25834, "FKK",
	404.10018, "ACDD",
	404.10018, "CDEG",
	404.11544, "CDW",
	404.11794, "DDSS",
	404.11881, "CCPT",
	404.13657, "ACET",
	404.13657, "ADMS",
	404.13657, "CDSV",
	404.13657, "DGMT",
	404.13657, "EGMS",
	404.15183, "CFGP",
	404.15183, "MSW",
	404.15433, "DSTT",
	404.15433, "ESST",
	404.15520, "AAMM",
	404.15520, "ACMV",
	404.15520, "CCVV",
	404.15520, "CGMX",
	404.16958, "AADF",
	404.16958, "AEFG",
	404.16958, "EFQ",
	404.16958, "GPSY",
	404.17296, "AMTT",
	404.17296, "CSTX",
	404.17296, "CTTV",
	404.17296, "MSSV",
	404.18484, "AFW",
	404.19071, "TTTT",
	404.20597, "AAVY",
	404.20597, "AFSV",
	404.20597, "AGXY",
	404.20597, "EFK",
	404.20597, "FGSX",
	404.20597, "FGTV",
	404.20597, "QXY",
	404.21720, "AHPV",
	404.21720, "FRT",
	404.21720, "GHPX",
	404.24236, "KXY",
	404.24236, "PPPX",
	405.11406, "ACCQ",
	405.11406, "CGMN",
	405.13182, "CNST",
	405.13182, "CQSS",
	405.15045, "ACCK",
	405.15360, "EEF",
	405.15831, "HHM",
	405.16483, "AGNY",
	405.16483, "FGNS",
	405.16483, "GGQY",
	405.16483, "NQY",
	405.16820, "CKSS",
	405.17607, "GHNP",
	405.18999, "EXY",
	405.20122, "GGKY",
	405.20122, "KNY",
	405.20122, "NPPP",
	406.08032, "CCCP",
	406.09808, "ACCE",
	406.09808, "CDGM",
	406.11583, "CDST",
	406.11583, "CESS",
	406.13446, "ACMT",
	406.13446, "CCSX",
	406.13446, "CCTV",
	406.13446, "GMMS",
	406.14885, "ADGY",
	406.14885, "DFGS",
	406.14885, "DQY",
	406.14885, "EGGY",
	406.14885, "ENY",
	406.15222, "CTTT",
	406.15222, "MSST",
	406.16008, "DGHP",
	406.16411, "GWY",
	406.16748, "AFGM",
	406.16748, "CFGV",
	406.16748, "FMQ",
	406.17871, "CFR",
	406.18523, "AATY",
	406.18523, "AFST",
	406.18523, "DKY",
	406.18523, "DPPP",
	406.18523, "FGTT",
	406.18523, "GSVY",
	406.19647, "AHPT",
	406.19647, "RSY",
	406.20386, "FKM",
	406.23285, "AHVV",
	406.23285, "GHVX",
	406.24409, "HRX",
	406.25801, "PPVX",
	407.09332, "CCNS",
	407.13286, "DEY",
	407.15149, "EFM",
	407.18451, "FPY",
	407.18788, "MXY",
	407.19172, "AAHQ",
	407.19172, "GHNV",
	407.20295, "GGHR",
	407.20295, "HNR",
	407.21687, "NPPV",
	407.22089, "FFX",
	407.22810, "AAHK",
	407.22810, "GPPR",
	408.07734, "CCDS",
	408.09597, "ACCM",
	408.09597, "CCCV",
	408.11373, "CCTT",
	408.11373, "CMSS",
	408.14674, "AACY",
	408.14674, "ACFS",
	408.14674, "CFGT",
	408.14674, "GGMY",
	408.14674, "MNY",
	408.15797, "ACHP",
	408.16450, "ASSY",
	408.16450, "FSSS",
	408.16450, "GSTY",
	408.17573, "AAEH",
	408.17573, "DGHV",
	408.17573, "HPSS",
	408.17976, "FFGG",
	408.17976, "FFN",
	408.18697, "DHR",
	408.20088, "DPPV",
	408.21212, "AHSX",
	408.21212, "AHTV",
	408.21212, "GHTX",
	408.23727, "PPTX",
	408.27366, "PVVX",
	409.13076, "DMY",
	409.14938, "FMM",
	409.16377, "DFF",
	409.17098, "AHNS",
	409.17098, "GHNT",
	409.17098, "GHQS",
	409.19613, "NPPT",
	409.19613, "PPQS",
	409.20016, "FVY",
	409.20737, "GHKS",
	409.23252, "APQX",
	409.23252, "KPPS",
	409.23252, "NPVV",
	409.24375, "GPRV",
	409.25499, "PRR",
	409.26890, "AKPX",
	410.07523, "CCCT",
	410.10825, "CCFG",
	410.12601, "CGSY",
	410.15500, "ADHS",
	410.15500, "DGHT",
	410.15500, "EGHS",
	410.17025, "HSW",
	410.17362, "AAHM",
	410.17362, "ACHV",
	410.17362, "CGHX",
	410.18015, "DPPT",
	410.18015, "EPPS",
	410.19138, "AHTT",
	410.19138, "ANPQ",
	410.19138, "GPQQ",
	410.19138, "HSSV",
	410.19878, "CPPX",
	410.21653, "AEPX",
	410.21653, "DPVV",
	410.22777, "AKNP",
	410.22777, "GKPQ",
	410.25292, "PSXX",
	410.25292, "PTVX",
	410.26415, "GKKP",
	410.28931, "AXXX",
	410.28931, "VVVX",
	411.13249, "CGHN",
	411.15764, "CNPP",
	411.17540, "ADPQ",
	411.17540, "AENP",
	411.17540, "EGPQ",
	411.17674, "HHH",
	411.17942, "FTY",
	411.19065, "AGPW",
	411.19065, "PQW",
	411.21178, "ADKP",
	411.21178, "EGKP",
	411.21178, "NPSX",
	411.21178, "NPTV",
	411.21178, "PQSV",
	411.22302, "APRS",
	411.22302, "GPRT",
	411.22704, "KPW",
	411.24817, "ANXX",
	411.24817, "AQVX",
	411.24817, "GQXX",
	411.24817, "KPSV",
	411.24817, "NVVV",
	411.25940, "AARX",
	411.25940, "GRVV",
	411.27064, "RRV",
	411.28455, "AKVX",
	411.28455, "GKXX",
	412.03674, "CCCC",
	412.11650, "CDGH",
	412.14166, "CDPP",
	412.15289, "ACHT",
	412.15289, "GHMS",
	412.15941, "ADEP",
	412.15941, "EEGP",
	412.17065, "HSST",
	412.17065, "NNPS",
	412.17467, "EPW",
	412.17804, "MPPS",
	412.18590, "AFGH",
	412.18590, "FHQ",
	412.19580, "DPSX",
	412.19580, "DPTV",
	412.19580, "EPSV",
	412.20703, "ANNX",
	412.20703, "ANQV",
	412.20703, "GNQX",
	412.20703, "GQQV",
	412.21106, "AFPP",
	412.21443, "AMPX",
	412.21443, "CPVX",
	412.21827, "AANR",
	412.21827, "AGQR",
	412.21827, "QQR",
	412.22229, "FHK",
	412.23218, "ADXX",
	412.23218, "AEVX",
	412.23218, "DVVV",
	412.23218, "EGXX",
	412.23218, "PTTX",
	412.24342, "AKNV",
	412.24342, "GKNX",
	412.24342, "GKQV",
	412.24744, "WXX",
	412.25465, "AGKR",
	412.25465, "KQR",
	412.26857, "SVXX",
	412.26857, "TVVX",
	412.27980, "GKKV",
	412.29104, "KKR",
	413.14093, "CFY",
	413.15466, "DNPS",
	413.15869, "SYY",
	413.16590, "ANNN",
	413.16590, "GNNQ",
	413.16992, "EFH",
	413.17329, "AMNP",
	413.17329, "CNPV",
	413.17329, "GMPQ",
	413.18452, "CGPR",
	413.19105, "ADNX",
	413.19105, "ADQV",
	413.19105, "AENV",
	413.19105, "DGQX",
	413.19105, "EGNX",
	413.19105, "EGQV",
	413.19105, "NPTT",
	413.19105, "PQST",
	413.20228, "AADR",
	413.20228, "AEGR",
	413.20228, "EQR",
	413.20228, "GKNN",
	413.20630, "AGVW",
	413.20630, "GGWX",
	413.20630, "HXY",
	413.20630, "NWX",
	413.20630, "QVW",
	413.20968, "GKMP",
	413.21754, "ARW",
	413.22743, "ADKV",
	413.22743, "AQTX",
	413.22743, "DGKX",
	413.22743, "EGKV",
	413.22743, "KPST",
	413.22743, "NSVX",
	413.22743, "NTVV",
	413.22743, "QSVV",
	413.23867, "ARSV",
	413.23867, "EKR",
	413.23867, "GRSX",
	413.23867, "GRTV",
	413.24269, "KVW",
	413.24990, "RRT",
	413.26382, "AKTX",
	413.26382, "KSVV",
	414.11439, "ACCH",
	414.13215, "CHSS",
	414.13868, "DDPS",
	414.14991, "ADNN",
	414.14991, "DGNQ",
	414.14991, "EGNN",
	414.15731, "ADMP",
	414.15731, "CDPV",
	414.15731, "EGMP",
	414.16517, "GGHY",
	414.16517, "GGNW",
	414.16517, "HNY",
	414.16517, "NNW",
	414.17256, "MPW",
	414.17506, "ADDX",
	414.17506, "ADEV",
	414.17506, "DEGX",
	414.17506, "DPTT",
	414.17506, "EEGV",
	414.17506, "EPST",
	414.18630, "ANQT",
	414.18630, "AQQS",
	414.18630, "DGKN",
	414.18630, "EER",
	414.18630, "GQQT",
	414.18630, "NNSV",
	414.19032, "DWX",
	414.19032, "EVW",
	414.19032, "GPPY",
	414.19369, "CPTX",
	414.19369, "MPSV",
	414.19753, "GNRS",
	414.21145, "AETX",
	414.21145, "DSVX",
	414.21145, "DTVV",
	414.21145, "ESVV",
	414.22268, "AKNT",
	414.22268, "AKQS",
	414.22268, "GKQT",
	414.22671, "AFPV",
	414.22671, "FGPX",
	414.23008, "AMVX",
	414.23008, "CVVX",
	414.23008, "GMXX",
	414.24783, "STXX",
	414.24783, "TTVX",
	414.25907, "AKKS",
	414.25907, "GKKT",
	415.13393, "ADDN",
	415.13393, "DDGQ",
	415.13393, "DEGN",
	415.14918, "DGGW",
	415.14918, "DHY",
	415.14918, "DNW",
	415.15255, "CNPT",
	415.15255, "CPQS",
	415.16781, "FHM",
	415.17031, "ADQT",
	415.17031, "AENT",
	415.17031, "AEQS",
	415.17031, "DDGK",
	415.17031, "DNSV",
	415.17031, "EGQT",
	415.18155, "DGRS",
	415.18557, "AASW",
	415.18557, "AGTW",
	415.18557, "FGNP",
	415.18557, "QTW",
	415.18894, "ACQX",
	415.18894, "AMNV",
	415.18894, "CKPS",
	415.18894, "CNVV",
	415.18894, "GMNX",
	415.18894, "GMQV",
	415.20017, "AGMR",
	415.20017, "CGRV",
	415.20017, "MQR",
	415.20670, "ADKT",
	415.20670, "AEKS",
	415.20670, "EGKT",
	415.20670, "NSTX",
	415.20670, "NTTV",
	415.20670, "QSSX",
	415.20670, "QSTV",
	415.21141, "CRR",
	415.21793, "ARST",
	415.21793, "GRTT",
	415.22195, "KTW",
	415.22533, "ACKX",
	415.22533, "GKMV",
	415.23656, "KMR",
	415.24308, "KSSX",
	415.24308, "KSTV",
	416.11794, "ADDD",
	416.11794, "DDEG",
	416.13320, "DDW",
	416.13657, "CDPT",
	416.13657, "CEPS",
	416.14780, "ACNQ",
	416.14780, "CGQQ",
	416.14780, "GMNN",
	416.15433, "ADET",
	416.15433, "AEES",
	416.15433, "DDSV",
	416.15433, "EEGT",
	416.15520, "CCPX",
	416.15520, "GMMP",
	416.16556, "NNST",
	416.16556, "NQSS",
	416.16958, "DFGP",
	416.16958, "ETW",
	416.17296, "ACEX",
	416.17296, "ADMV",
	416.17296, "CDVV",
	416.17296, "DGMX",
	416.17296, "EGMV",
	416.17296, "MPST",
	416.18419, "ACKN",
	416.18419, "CGKQ",
	416.18419, "EMR",
	416.18821, "MVW",
	416.19071, "DSTX",
	416.19071, "DTTV",
	416.19071, "ESSX",
	416.19071, "ESTV",
	416.19205, "AAHH",
	416.20195, "KNSS",
	416.20597, "AFPT",
	416.20597, "GPVY",
	416.20934, "AMTX",
	416.20934, "CSXX",
	416.20934, "CTVX",
	416.20934, "MSVV",
	416.21720, "PRY",
	416.22057, "CGKK",
	416.22710, "TTTX",
	416.24236, "AFVV",
	416.24236, "FGVX",
	416.25359, "FRX",
	417.11406, "CCNP",
	417.13182, "ACDQ",
	417.13182, "ACEN",
	417.13182, "CEGQ",
	417.13182, "DGMN",
	417.14707, "ACGW",
	417.14707, "CQW",
	417.14958, "DNST",
	417.14958, "DQSS",
	417.14958, "ENSS",
	417.16483, "GSSW",
	417.16820, "ACDK",
	417.16820, "AMNT",
	417.16820, "AMQS",
	417.16820, "CEGK",
	417.16820, "CNSX",
	417.16820, "CNTV",
	417.16820, "CQSV",
	417.16820, "GMQT",
	417.17944, "ACRS",
	417.17944, "CGRT",
	417.18346, "CKW",
	417.18596, "DKSS",
	417.18596, "NTTT",
	417.18596, "QSTT",
	417.19720, "RSSS",
	417.20122, "AAFQ",
	417.20122, "FGNV",
	417.20459, "AKMS",
	417.20459, "CKSV",
	417.20459, "GKMT",
	417.21245, "FGGR",
	417.21245, "FNR",
	417.22235, "KSTT",
	417.23760, "AAFK",
	418.09808, "CCDP",
	418.11583, "ACDE",
	418.11583, "CEEG",
	418.11583, "DDGM",
	418.12707, "CNNS",
	418.13109, "CEW",
	418.13359, "DDST",
	418.13359, "DESS",
	418.13446, "CMPS",
	418.15222, "ADMT",
	418.15222, "AEMS",
	418.15222, "CDSX",
	418.15222, "CDTV",
	418.15222, "CESV",
	418.15222, "EGMT",
	418.16748, "ACFP",
	418.16748, "MTW",
	418.16998, "DTTT",
	418.16998, "ESTT",
	418.17085, "ACMX",
	418.17085, "CCVX",
	418.17085, "GMMV",
	418.17132, "GHHS",
	418.18208, "MMR",
	418.18523, "AAEF",
	418.18523, "APSY",
	418.18523, "DFGV",
	418.18523, "FPSS",
	418.18523, "GPTY",
	418.18861, "CTTX",
	418.18861, "MSSX",
	418.18861, "MSTV",
	418.19647, "DFR",
	418.19647, "HPPS",
	418.22162, "AAXY",
	418.22162, "AFSX",
	418.22162, "AFTV",
	418.22162, "FGTX",
	418.22162, "GVVY",
	418.23285, "AHPX",
	418.23285, "RVY",
	419.11108, "CDNS",
	419.12971, "ACMN",
	419.12971, "CCNV",
	419.12971, "CGMQ",
	419.14094, "CCGR",
	419.14747, "CNTT",
	419.14747, "CQST",
	419.14747, "MNSS",
	419.16610, "CGKM",
	419.18048, "AANY",
	419.18048, "AFNS",
	419.18048, "AGQY",
	419.18048, "FGNT",
	419.18048, "FGQS",
	419.18048, "QQY",
	419.18385, "CKST",
	419.19172, "AHNP",
	419.19172, "GHPQ",
	419.21687, "AGKY",
	419.21687, "FGKS",
	419.21687, "KQY",
	419.21687, "PPPQ",
	419.22810, "GHKP",
	419.25325, "KKY",
	419.25325, "KPPP",
	420.09510, "CDDS",
	420.11373, "ACDM",
	420.11373, "CCDV",
	420.11373, "CEGM",
	420.12898, "CMW",
	420.13148, "CDTT",
	420.13148, "CEST",
	420.13148, "DMSS",
	420.14674, "CGPY",
	420.15011, "AMMS",
	420.15011, "CCTX",
	420.15011, "CMSV",
	420.15011, "GMMT",
	420.16450, "AADY",
	420.16450, "ADFS",
	420.16450, "AEGY",
	420.16450, "DFGT",
	420.16450, "EFGS",
	420.16450, "EQY",
	420.16787, "MSTT",
	420.17573, "ADHP",
	420.17573, "EGHP",
	420.17976, "AWY",
	420.17976, "FSW",
	420.18313, "AAFM",
	420.18313, "ACFV",
	420.18313, "CFGX",
	420.19099, "HPW",
	420.20088, "AFTT",
	420.20088, "ASVY",
	420.20088, "EKY",
	420.20088, "EPPP",
	420.20088, "FSSV",
	420.20088, "GSXY",
	420.20088, "GTVY",
	420.21212, "HPSV",
	420.21212, "RTY",
	420.24850, "AHVX",
	420.24850, "GHXX",
	420.27366, "PPXX",
	421.10897, "CCNT",
	421.10897, "CCQS",
	421.14199, "CFGN",
	421.14536, "CCKS",
	421.14851, "EEY",
	421.15975, "GNSY",
	421.18624, "FHH",
	421.20737, "AHNV",
	421.20737, "GHNX",
	421.20737, "GHQV",
	421.21860, "AGHR",
	421.21860, "HQR",
	421.23252, "NPPX",
	421.23252, "PPQV",
	421.24375, "APPR",
	421.24375, "GHKV",
	421.25499, "HKR",
	421.26890, "KPPV",
	422.09299, "CCDT",
	422.09299, "CCES",
	422.11162, "CCCX",
	422.11162, "CGMM",
	422.12601, "CDFG",
	422.12938, "CMST",
	422.14376, "DGSY",
	422.16239, "ACFT",
	422.16239, "AGMY",
	422.16239, "CGVY",
	422.16239, "FGMS",
	422.16239, "MQY",
	422.16623, "GHNN",
	422.17362, "CRY",
	422.17362, "GHMP",
	422.18015, "ASTY",
	422.18015, "FSST",
	422.18015, "GTTY",
	422.19138, "ADHV",
	422.19138, "DGHX",
	422.19138, "EGHV",
	422.19138, "HPST",
	422.19138, "NNPP",
	422.19541, "AFFG",
	422.19541, "FFQ",
	422.19878, "KMY",
	422.19878, "MPPP",
	422.20262, "EHR",
	422.20664, "HVW",
	422.21653, "DPPX",
	422.21653, "EPPV",
	422.22777, "AHTX",
	422.22777, "HSVV",
	422.23179, "FFK",
	422.28931, "PVXX",
	423.07048, "CCCN",
	423.14641, "EMY",
	423.15025, "DGHN",
	423.17540, "DNPP",
	423.17942, "EFF",
	423.17942, "PYY",
	423.18663, "AHNT",
	423.18663, "AHQS",
	423.18663, "GHQT",
	423.21178, "PPQT",
	423.21581, "FXY",
	423.22302, "AHKS",
	423.22302, "GHKT",
	423.24817, "KPPT",
	423.24817, "NPVX",
	423.24817, "PQVV",
	423.25940, "APRV",
	423.25940, "GPRX",
	423.28455, "KPVV",
	424.05450, "CCCD",
	424.09088, "CCMS",
	424.12390, "ACCF",
	424.13426, "DDGH",
	424.14166, "ACSY",
	424.14166, "CFSS",
	424.14166, "CGTY",
	424.15289, "CHPS",
	424.15941, "DDPP",
	424.15941, "SSSY",
	424.17065, "ADHT",
	424.17065, "AEHS",
	424.17065, "EGHT",
	424.17467, "FGGY",
	424.17467, "FNY",
	424.18590, "HTW",
	424.18927, "ACHX",
	424.18927, "GHMV",
	424.19580, "EPPT",
	424.20051, "HMR",
	424.20703, "APQQ",
	424.20703, "HSSX",
	424.20703, "HSTV",
	424.20703, "NNPV",
	424.21443, "MPPV",
	424.21827, "GNPR",
	424.23218, "DPVX",
	424.23218, "EPVV",
	424.24342, "AKPQ",
	424.26857, "PTXX",
	424.27980, "AKKP",
	424.30496, "VVXX",
	425.14430, "MMY",
	425.14814, "ACHN",
	425.14814, "CGHQ",
	425.15869, "DFY",
	425.16590, "HNSS",
	425.17329, "CPPQ",
	425.17731, "FFM",
	425.18452, "CGHK",
	425.19105, "AEPQ",
	425.19105, "DNPV",
	425.19507, "VYY",
	425.20228, "DGPR",
	425.20630, "AAPW",
	425.20968, "CKPP",
	425.22743, "AEKP",
	425.22743, "NPTX",
	425.22743, "PQSX",
	425.22743, "PQTV",
	425.23867, "APRT",
	425.26382, "AQXX",
	425.26382, "KPSX",
	425.26382, "KPTV",
	425.26382, "NVVX",
	425.26382, "QVVV",
	425.27505, "ARVV",
	425.27505, "GRVX",
	425.28629, "RRX",
	425.30020, "AKXX",
	425.30020, "KVVV",
	426.10316, "CCGY",
	426.13215, "ACDH",
	426.13215, "CEGH",
	426.14741, "CHW",
	426.14991, "DHSS",
	426.15731, "CEPP",
	426.16854, "AHMS",
	426.16854, "CHSV",
	426.16854, "GHMT",
	426.17506, "AEEP",
	426.17506, "DDPV",
	426.18630, "HSTT",
	426.18630, "NNPT",
	426.18630, "NPQS",
	426.19369, "MPPT",
	426.20155, "AAFH",
	426.21145, "DPTX",
	426.21145, "EPSX",
	426.21145, "EPTV",
	426.22268, "ANQX",
	426.22268, "AQQV",
	426.22268, "GQQX",
	426.22268, "KNPS",
	426.22268, "NNVV",
	426.23008, "CPXX",
	426.23008, "MPVV",
	426.23392, "AAQR",
	426.23392, "GNRV",
	426.24515, "GGRR",
	426.24515, "NRR",
	426.24783, "AEXX",
	426.24783, "DVVX",
	426.24783, "EVVV",
	426.25907, "AKNX",
	426.25907, "AKQV",
	426.25907, "GKQX",
	426.27030, "AAKR",
	426.28422, "SXXX",
	426.28422, "TVXX",
	426.29545, "AKKV",
	426.29545, "GKKX",
	427.17031, "DNPT",
	427.17031, "DPQS",
	427.17031, "ENPS",
	427.17434, "TYY",
	427.18155, "ANNQ",
	427.18155, "GNQQ",
	427.18557, "GPSW",
	427.18894, "AMPQ",
	427.18894, "CNPX",
	427.18894, "CPQV",
	427.20017, "ACPR",
	427.20670, "ADQX",
	427.20670, "AENX",
	427.20670, "AEQV",
	427.20670, "DKPS",
	427.20670, "DNVV",
	427.20670, "EGQX",
	427.20670, "PQTT",
	427.21793, "AAER",
	427.21793, "AKNN",
	427.21793, "DGRV",
	427.21793, "GKNQ",
	427.21793, "PRSS",
	427.22195, "AAVW",
	427.22195, "AGWX",
	427.22195, "QWX",
	427.22533, "AKMP",
	427.22533, "CKPV",
	427.22917, "DRR",
	427.24308, "ADKX",
	427.24308, "AEKV",
	427.24308, "EGKX",
	427.24308, "KPTT",
	427.24308, "NSXX",
	427.24308, "NTVX",
	427.24308, "QSVX",
	427.24308, "QTVV",
	427.25432, "ARSX",
	427.25432, "ARTV",
	427.25432, "GKKN",
	427.25432, "GRTX",
	427.25834, "KWX",
	427.27947, "KSVX",
	427.27947, "KTVV",
	428.13004, "CGHM",
	428.14780, "CHST",
	428.14780, "CNNP",
	428.15433, "DDPT",
	428.15433, "DEPS",
	428.15520, "CMPP",
	428.16556, "ADNQ",
	428.16556, "AENN",
	428.16556, "DGQQ",
	428.16556, "EGNQ",
	428.17296, "AEMP",
	428.17296, "CDPX",
	428.17296, "CEPV",
	428.18082, "AGHY",
	428.18082, "AGNW",
	428.18082, "FGHS",
	428.18082, "GGQW",
	428.18082, "HQY",
	428.18082, "NQW",
	428.19071, "ADEX",
	428.19071, "AEEV",
	428.19071, "DDVV",
	428.19071, "EEGX",
	428.19071, "EPTT",
	428.19205, "GHHP",
	428.20195, "ADKN",
	428.20195, "AQQT",
	428.20195, "DGKQ",
	428.20195, "EGKN",
	428.20195, "NNSX",
	428.20195, "NNTV",
	428.20195, "NQSV",
	428.20597, "APPY",
	428.20597, "EWX",
	428.20597, "FPPS",
	428.20934, "MPSX",
	428.20934, "MPTV",
	428.21318, "ANRS",
	428.21318, "GNRT",
	428.21318, "GQRS",
	428.21720, "GGKW",
	428.21720, "HKY",
	428.21720, "HPPP",
	428.21720, "KNW",
	428.22710, "DSXX",
	428.22710, "DTVX",
	428.22710, "ESVX",
	428.22710, "ETVV",
	428.23833, "AKQT",
	428.23833, "DGKK",
	428.23833, "KNSV",
	428.24236, "AFPX",
	428.24573, "AMXX",
	428.24573, "CVXX",
	428.24573, "MVVV",
	428.24957, "GKRS",
	428.26348, "TTXX",
	428.27472, "AKKT",
	429.13182, "CDNP",
	429.13584, "CYY",
	429.14958, "ADDQ",
	429.14958, "ADEN",
	429.14958, "DEGQ",
	429.14958, "EEGN",
	429.16081, "NNNS",
	429.16483, "ADGW",
	429.16483, "DQW",
	429.16483, "EGGW",
	429.16483, "EHY",
	429.16483, "ENW",
	429.16820, "CPQT",
	429.16820, "MNPS",
	429.18009, "GWW",
	429.18596, "ADDK",
	429.18596, "AEQT",
	429.18596, "DEGK",
	429.18596, "DNSX",
	429.18596, "DNTV",
	429.18596, "DQSV",
	429.18596, "ENSV",
	429.19720, "ADRS",
	429.19720, "DGRT",
	429.19720, "EGRS",
	429.20122, "AATW",
	429.20122, "AFNP",
	429.20122, "DKW",
	429.20122, "FGPQ",
	429.20122, "GSVW",
	429.20459, "AMNX",
	429.20459, "AMQV",
	429.20459, "CKPT",
	429.20459, "CNVX",
	429.20459, "CQVV",
	429.20459, "GMQX",
	429.21245, "RSW",
	429.21582, "AAMR",
	429.21582, "ACRV",
	429.21582, "CGRX",
	429.22235, "AEKT",
	429.22235, "DKSV",
	429.22235, "NTTX",
	429.22235, "QSTX",
	429.22235, "QTTV",
	429.23358, "ARTT",
	429.23358, "RSSV",
	429.23760, "FGKP",
	429.24098, "AKMV",
	429.24098, "CKVV",
	429.24098, "GKMX",
	429.25873, "KSTX",
	429.25873, "KTTV",
	430.10931, "CCHS",
	430.11583, "CDDP",
	430.13359, "ADDE",
	430.13359, "DEEG",
	430.14483, "DNNS",
	430.14885, "DEW",
	430.15222, "CEPT",
	430.15222, "DMPS",
	430.16345, "ACQQ",
	430.16345, "AMNN",
	430.16345, "CNNV",
	430.16345, "GMNQ",
	430.16998, "AEET",
	430.16998, "DDSX",
	430.16998, "DDTV",
	430.16998, "DESV",
	430.17085, "AMMP",
	430.17085, "CMPV",
	430.17469, "CGNR",
	430.18121, "NNTT",
	430.18121, "NQST",
	430.18121, "QQSS",
	430.18523, "ADFP",
	430.18523, "EFGP",
	430.18861, "ADMX",
	430.18861, "AEMV",
	430.18861, "CDVX",
	430.18861, "CEVV",
	430.18861, "EGMX",
	430.18861, "MPTT",
	430.19984, "ACKQ",
	430.19984, "GKMN",
	430.20049, "FPW",
	430.20386, "MWX",
	430.20636, "DTTX",
	430.20636, "ESTX",
	430.20636, "ETTV",
	430.20770, "GHHV",
	430.21760, "KNST",
	430.21760, "KQSS",
	430.21893, "HHR",
	430.22162, "APVY",
	430.22162, "FPSV",
	430.22162, "GPXY",
	430.22499, "CTXX",
	430.22499, "MSVX",
	430.22499, "MTVV",
	430.23285, "HPPV",
	430.23622, "ACKK",
	430.25398, "KKSS",
	430.25801, "AFVX",
	430.25801, "FGXX",
	431.12884, "DDNS",
	431.12971, "CCPQ",
	431.14747, "ACEQ",
	431.14747, "ADMN",
	431.14747, "CDNV",
	431.14747, "DGMQ",
	431.14747, "EGMN",
	431.15870, "CDGR",
	431.16273, "AACW",
	431.16273, "GGMW",
	431.16273, "HMY",
	431.16273, "MNW",
	431.16523, "DNTT",
	431.16523, "DQST",
	431.16523, "ENST",
	431.16523, "EQSS",
	431.16610, "CCKP",
	431.18048, "ASSW",
	431.18048, "GNPY",
	431.18048, "GSTW",
	431.18385, "ACEK",
	431.18385, "AMQT",
	431.18385, "CNTX",
	431.18385, "CQSX",
	431.18385, "CQTV",
	431.18385, "DGKM",
	431.18385, "MNSV",
	431.19509, "ACRT",
	431.19509, "GMRS",
	431.19574, "FFH",
	431.20161, "DKST",
	431.20161, "EKSS",
	431.20161, "QTTT",
	431.21285, "RSST",
	431.21687, "AFNV",
	431.21687, "FGNX",
	431.21687, "FGQV",
	431.22024, "AKMT",
	431.22024, "CKSX",
	431.22024, "CKTV",
	431.22810, "AFGR",
	431.22810, "FQR",
	431.23800, "KTTT",
	431.25325, "FGKV",
	431.26449, "FKR",
	432.11286, "DDDS",
	432.11373, "CCEP",
	432.13148, "ACEE",
	432.13148, "ADDM",
	432.13148, "CDDV",
	432.13148, "DEGM",
	432.14272, "CNNT",
	432.14272, "CNQS",
	432.14674, "DMW",
	432.14924, "DDTT",
	432.14924, "DEST",
	432.14924, "EESS",
	432.15011, "CMPT",
	432.16450, "DGPY",
	432.16787, "AEMT",
	432.16787, "CDTX",
	432.16787, "CESX",
	432.16787, "CETV",
	432.16787, "DMSV",
	432.17573, "FGNN",
	432.17910, "CKNS",
	432.18313, "FGMP",
	432.18563, "ETTT",
	432.18650, "AMMV",
	432.18650, "CCXX",
	432.18650, "CMVV",
	432.18650, "GMMX",
	432.18697, "AHHS",
	432.18697, "GHHT",
	432.20088, "ADFV",
	432.20088, "APTY",
	432.20088, "DFGX",
	432.20088, "EFGV",
	432.20088, "FPST",
	432.20426, "MSTX",
	432.20426, "MTTV",
	432.21212, "EFR",
	432.21212, "HPPT",
	432.21614, "FVW",
	432.23727, "AFTX",
	432.23727, "AVVY",
	432.23727, "FSVV",
	432.23727, "GVXY",
	432.24850, "HPVV",
	432.24850, "RXY",
	433.12673, "CDNT",
	433.12673, "CDQS",
	433.12673, "CENS",
	433.14199, "CGSW",
	433.14536, "ACMQ",
	433.14536, "CCNX",
	433.14536, "CCQV",
	433.14536, "GMMN",
	433.15659, "ACCR",
	433.15975, "DFGN",
	433.16312, "CDKS",
	433.16312, "CQTT",
	433.16312, "MNST",
	433.16312, "MQSS",
	433.17435, "CRSS",
	433.18175, "ACKM",
	433.18175, "CCKV",
	433.19613, "AAQY",
	433.19613, "AFNT",
	433.19613, "AFQS",
	433.19613, "FGQT",
	433.19613, "GNVY",
	433.19950, "CKTT",
	433.19950, "KMSS",
	433.20737, "AHPQ",
	433.20737, "GGRY",
	433.20737, "NRY",
	433.23252, "AAKY",
	433.23252, "AFKS",
	433.23252, "FGKT",
	433.24375, "AHKP",
	434.10422, "CCNN",
	434.11075, "CDDT",
	434.11075, "CDES",
	434.11162, "CCMP",
	434.12938, "ACEM",
	434.12938, "CCDX",
	434.12938, "CCEV",
	434.12938, "DGMM",
	434.14376, "DDFG",
	434.14713, "CETT",
	434.14713, "DMST",
	434.14713, "EMSS",
	434.14847, "CGHH",
	434.16239, "ACPY",
	434.16239, "CFPS",
	434.16576, "AMMT",
	434.16576, "CMSX",
	434.16576, "CMTV",
	434.17362, "CHPP",
	434.18015, "AAEY",
	434.18015, "ADFT",
	434.18015, "AEFS",
	434.18015, "DGVY",
	434.18015, "EFGT",
	434.18015, "PSSY",
	434.18352, "MTTT",
	434.19138, "AEHP",
	434.19138, "DRY",
	434.19541, "FTW",
	434.19878, "ACFX",
	434.19878, "FGMV",
	434.21001, "FMR",
	434.21653, "ASXY",
	434.21653, "ATVY",
	434.21653, "FSSX",
	434.21653, "FSTV",
	434.21653, "GTXY",
	434.22777, "HPSX",
	434.22777, "HPTV",
	434.26415, "AHXX",
	434.26415, "HVVV",
	435.08824, "CCDN",
	435.12462, "CCQT",
	435.12462, "CMNS",
	435.15764, "ACFN",
	435.15764, "CFGQ",
	435.16101, "CCKT",
	435.17540, "ANSY",
	435.17540, "FNSS",
	435.17540, "GNTY",
	435.17540, "GQSY",
	435.18663, "HNPS",
	435.19403, "CFGK",
	435.21178, "GKSY",
	435.22302, "AHNX",
	435.22302, "AHQV",
	435.22302, "GHQX",
	435.23425, "AAHR",
	435.24817, "PPQX",
	435.25940, "AHKV",
	435.25940, "GHKX",
	435.28455, "KPPX",
	436.07226, "CCDD",
	436.10864, "CCET",
	436.10864, "CDMS",
	436.12727, "ACMM",
	436.12727, "CCMV",
	436.14166, "ACDF",
	436.14166, "CEFG",
	436.14503, "CMTT",
	436.14503, "MMSS",
	436.15691, "CFW",
	436.15941, "ADSY",
	436.15941, "DFSS",
	436.15941, "DGTY",
	436.15941, "EGSY",
	436.17065, "DHPS",
	436.17467, "SWY",
	436.17804, "AAMY",
	436.17804, "ACVY",
	436.17804, "AFMS",
	436.17804, "CFSV",
	436.17804, "CGXY",
	436.17804, "FGMT",
	436.18188, "AHNN",
	436.18188, "GHNQ",
	436.18927, "AHMP",
	436.18927, "CHPV",
	436.19580, "ATTY",
	436.19580, "FSTT",
	436.19580, "SSVY",
	436.20703, "ADHX",
	436.20703, "AEHV",
	436.20703, "EGHX",
	436.20703, "HPTT",
	436.20703, "NPPQ",
	436.21106, "AAFF",
	436.21827, "GHKN",
	436.22229, "HWX",
	436.23218, "EPPX",
	436.24342, "HSVX",
	436.24342, "HTVV",
	436.24342, "KNPP",
	436.30496, "PXXX",
	437.08613, "CCCQ",
	437.12252, "CCCK",
	437.13690, "CGNY",
	437.16590, "ADHN",
	437.16590, "DGHQ",
	437.16590, "EGHN",
	437.18115, "GGHW",
	437.18115, "HHY",
	437.18115, "HNW",
	437.19105, "DPPQ",
	437.19105, "ENPP",
	437.20228, "AHQT",
	437.20228, "DGHK",
	437.20228, "HNSV",
	437.20630, "GPPW",
	437.21352, "GHRS",
	437.22743, "DKPP",
	437.23867, "AHKT",
	437.23867, "PPRS",
	437.26382, "NPXX",
	437.26382, "PQVX",
	437.27505, "APRX",
	437.30020, "KPVX",
	438.07015, "CCCE",
	438.10653, "CCMT",
	438.12092, "CDGY",
	438.13955, "CFGM",
	438.14991, "ADDH",
	438.14991, "DEGH",
	438.15731, "ACTY",
	438.15731, "CFST",
	438.15731, "GMSY",
	438.16517, "DHW",
	438.16854, "CHPT",
	438.17506, "DEPP",
	438.17506, "SSTY",
	438.18630, "AEHT",
	438.18630, "DHSV",
	438.19032, "AFGY",
	438.19032, "FFGS",
	438.19032, "FQY",
	438.20155, "FGHP",
	438.20492, "AHMV",
	438.20492, "CHVV",
	438.20492, "GHMX",
	438.22268, "HSTX",
	438.22268, "HTTV",
	438.22268, "NNPX",
	438.22268, "NPQV",
	438.22671, "FKY",
	438.22671, "FPPP",
	438.23008, "MPPX",
	438.23392, "ANPR",
	438.23392, "GPQR",
	438.24783, "DPXX",
	438.24783, "EPVX",
	438.25907, "KNPV",
	438.27030, "GKPR",
	438.32061, "VXXX",
	439.16379, "ACHQ",
	439.16379, "GHMN",
	439.17434, "EFY",
	439.18155, "HNST",
	439.18155, "HQSS",
	439.18155, "NNNP",
	439.18894, "MNPP",
	439.20017, "ACHK",
	439.20670, "DNPX",
	439.20670, "DPQV",
	439.20670, "ENPV",
	439.21072, "XYY",
	439.21793, "ADPR",
	439.21793, "EGPR",
	439.21793, "HKSS",
	439.22195, "GPVW",
	439.23319, "PRW",
	439.24308, "DKPV",
	439.24308, "PQTX",
	439.25432, "PRSV",
	439.27947, "KPTX",
	439.27947, "NVXX",
	439.27947, "QVVX",
	439.29070, "ARVX",
	439.29070, "GRXX",
	439.31585, "KVVX",
	440.06804, "CCCM",
	440.11881, "ACCY",
	440.11881, "CCFS",
	440.13004, "CCHP",
	440.13657, "CSSY",
	440.14780, "ACEH",
	440.14780, "DGHM",
	440.16556, "DHST",
	440.16556, "DNNP",
	440.16556, "EHSS",
	440.16958, "GGYY",
	440.16958, "NYY",
	440.17296, "DMPP",
	440.18419, "AHMT",
	440.18419, "CHSX",
	440.18419, "CHTV",
	440.19071, "DDPX",
	440.19071, "DEPV",
	440.20195, "HTTT",
	440.20195, "NPQT",
	440.20195, "PQQS",
	440.21720, "FGHV",
	440.22710, "EPTX",
	440.22844, "FHR",
	440.23833, "AQQX",
	440.23833, "KNPT",
	440.23833, "KPQS",
	440.23833, "NNVX",
	440.23833, "NQVV",
	440.24236, "FPPV",
	440.24573, "MPVX",
	440.24957, "ANRV",
	440.24957, "GNRX",
	440.24957, "GQRV",
	440.26080, "AGRR",
	440.26080, "QRR",
	440.26348, "DVXX",
	440.26348, "EVVX",
	440.27472, "AKQX",
	440.27472, "KKPS",
	440.27472, "KNVV",
	440.28595, "GKRV",
	440.29719, "KRR",
	440.29987, "TXXX",
	440.31110, "AKKX",
	441.14305, "CHNS",
	441.14958, "DDNP",
	441.15360, "DYY",
	441.17223, "FMY",
	441.18596, "DPQT",
	441.18596, "ENPT",
	441.18596, "EPQS",
	441.19720, "ANQQ",
	441.19720, "GQQQ",
	441.19720, "NNNV",
	441.20122, "APSW",
	441.20122, "GPTW",
	441.20459, "CPQX",
	441.20459, "MNPV",
	441.20524, "FFF",
	441.20843, "GNNR",
	441.21582, "GMPR",
	441.22235, "AEQX",
	441.22235, "DKPT",
	441.22235, "DNVX",
	441.22235, "DQVV",
	441.22235, "EKPS",
	441.22235, "ENVV",
	441.23358, "ADRV",
	441.23358, "AKNQ",
	441.23358, "DGRX",
	441.23358, "EGRV",
	441.23358, "GKQQ",
	441.23358, "PRST",
	441.23760, "AAWX",
	441.23760, "GVVW",
	441.24098, "CKPX",
	441.24482, "ERR",
	441.24884, "RVW",
	441.25873, "AEKX",
	441.25873, "DKVV",
	441.25873, "NTXX",
	441.25873, "QSXX",
	441.25873, "QTVX",
	441.26997, "AKKN",
	441.26997, "ARTX",
	441.26997, "GKKQ",
	441.26997, "RSVV",
	441.29512, "KSXX",
	441.29512, "KTVX",
	441.30635, "GKKK",
	442.12707, "CDHS",
	442.13359, "DDDP",
	442.14569, "ACHM",
	442.14569, "CCHV",
	442.16345, "CHTT",
	442.16345, "CNPQ",
	442.16345, "HMSS",
	442.16998, "DEPT",
	442.16998, "EEPS",
	442.18121, "ADQQ",
	442.18121, "AENQ",
	442.18121, "DNNV",
	442.18121, "EGQQ",
	442.18861, "CEPX",
	442.18861, "DMPV",
	442.19245, "DGNR",
	442.19647, "AAHY",
	442.19647, "AANW",
	442.19647, "AFHS",
	442.19647, "AGQW",
	442.19647, "FGHT",
	442.19647, "QQW",
	442.19984, "CKNP",
	442.20636, "AEEX",
	442.20636, "DDVX",
	442.20636, "DEVV",
	442.20770, "AHHP",
	442.21760, "ADKQ",
	442.21760, "AEKN",
	442.21760, "EGKQ",
	442.21760, "NNTX",
	442.21760, "NQSX",
	442.21760, "NQTV",
	442.21760, "QQSV",
	442.22162, "FPPT",
	442.22499, "MPTX",
	442.22883, "ANRT",
	442.22883, "AQRS",
	442.22883, "GQRT",
	442.23285, "AGKW",
	442.23285, "KQW",
	442.24275, "DTXX",
	442.24275, "ESXX",
	442.24275, "ETVX",
	442.25398, "ADKK",
	442.25398, "EGKK",
	442.25398, "KNSX",
	442.25398, "KNTV",
	442.25398, "KQSV",
	442.25801, "FPVV",
	442.26138, "CXXX",
	442.26138, "MVVX",
	442.26522, "AKRS",
	442.26522, "GKRT",
	442.26924, "KKW",
	442.29037, "KKSV",
	443.14747, "CDPQ",
	443.14747, "CENP",
	443.16273, "CGPW",
	443.16523, "ADEQ",
	443.16523, "AEEN",
	443.16523, "DDNV",
	443.16523, "EEGQ",
	443.17646, "DDGR",
	443.17646, "NNNT",
	443.17646, "NNQS",
	443.18048, "AADW",
	443.18048, "AEGW",
	443.18048, "EQW",
	443.18385, "CDKP",
	443.18385, "MNPT",
	443.18385, "MPQS",
	443.19509, "CPRS",
	443.19574, "AWW",
	443.20161, "ADEK",
	443.20161, "DNTX",
	443.20161, "DQSX",
	443.20161, "DQTV",
	443.20161, "EEGK",
	443.20161, "ENSX",
	443.20161, "ENTV",
	443.20161, "EQSV",
	443.21285, "ADRT",
	443.21285, "AERS",
	443.21285, "EGRT",
	443.21285, "KNNS",
	443.21687, "AFPQ",
	443.21687, "ASVW",
	443.21687, "EKW",
	443.21687, "GSWX",
	443.21687, "GTVW",
	443.22024, "AMQX",
	443.22024, "CNXX",
	443.22024, "CQVX",
	443.22024, "KMPS",
	443.22024, "MNVV",
	443.22810, "RTW",
	443.23147, "ACRX",
	443.23147, "GMRV",
	443.23800, "DKSX",
	443.23800, "DKTV",
	443.23800, "EKSV",
	443.23800, "QTTX",
	443.24271, "MRR",
	443.24923, "RSSX",
	443.24923, "RSTV",
	443.25325, "AFKP",
	443.25663, "AKMX",
	443.25663, "CKVX",
	443.27438, "KTTX",
	444.12496, "CCHT",
	444.13148, "CDEP",
	444.14924, "ADEE",
	444.14924, "DDDV",
	444.14924, "EEEG",
	444.15797, "CFGH",
	444.16048, "DNNT",
	444.16048, "DNQS",
	444.16048, "ENNS",
	444.16450, "EEW",
	444.16787, "DMPT",
	444.16787, "EMPS",
	444.17573, "GHSY",
	444.17573, "GNSW",
	444.17910, "AMNQ",
	444.17910, "CNNX",
	444.17910, "CNQV",
	444.17910, "GMQQ",
	444.18313, "CFPP",
	444.18563, "DDTX",
	444.18563, "DESX",
	444.18563, "DETV",
	444.18563, "EESV",
	444.18650, "CMPX",
	444.19034, "ACNR",
	444.19034, "CGQR",
	444.19686, "DKNS",
	444.19686, "NQTT",
	444.19686, "QQST",
	444.20088, "AEFP",
	444.20088, "PPSY",
	444.20426, "AEMX",
	444.20426, "CDXX",
	444.20426, "CEVX",
	444.20426, "DMVV",
	444.20810, "NRSS",
	444.21549, "AKMN",
	444.21549, "CKNV",
	444.21549, "GKMQ",
	444.22201, "ETTX",
	444.22335, "AHHV",
	444.22335, "GHHX",
	444.22672, "CGKR",
	444.23325, "KNTT",
	444.23325, "KQST",
	444.23727, "APXY",
	444.23727, "FPSX",
	444.23727, "FPTV",
	444.24064, "MSXX",
	444.24064, "MTVX",
	444.24850, "HPPX",
	444.25187, "GKKM",
	444.26963, "KKST",
	444.27366, "AFXX",
	444.27366, "FVVV",
	445.13797, "CNNN",
	445.14449, "DDNT",
	445.14449, "DDQS",
	445.14449, "DENS",
	445.14536, "CMNP",
	445.15975, "DGSW",
	445.16312, "ADMQ",
	445.16312, "AEMN",
	445.16312, "CDNX",
	445.16312, "CDQV",
	445.16312, "CENV",
	445.16312, "EGMQ",
	445.17435, "ACDR",
	445.17435, "CEGR",
	445.17838, "AGMW",
	445.17838, "CGVW",
	445.17838, "MQW",
	445.18088, "DDKS",
	445.18088, "DQTT",
	445.18088, "ENTT",
	445.18088, "EQST",
	445.18221, "GHHN",
	445.18961, "CRW",
	445.19211, "DRSS",
	445.19613, "ANPY",
	445.19613, "ASTW",
	445.19613, "FNPS",
	445.19613, "GPQY",
	445.19613, "GTTW",
	445.19950, "ADKM",
	445.19950, "CDKV",
	445.19950, "CQTX",
	445.19950, "EGKM",
	445.19950, "MNSX",
	445.19950, "MNTV",
	445.19950, "MQSV",
	445.20737, "HNPP",
	445.21074, "AMRS",
	445.21074, "CRSV",
	445.21074, "GMRT",
	445.21476, "KMW",
	445.21726, "DKTT",
	445.21726, "EKST",
	445.22850, "RSTT",
	445.23252, "AFNX",
	445.23252, "AFQV",
	445.23252, "FGQX",
	445.23252, "GKPY",
	445.23589, "CKTX",
	445.23589, "KMSV",
	445.24375, "AAFR",
	445.26890, "AFKV",
	445.26890, "FGKX",
	446.08647, "CCCH",
	446.12198, "CDNN",
	446.12851, "DDDT",
	446.12851, "DDES",
	446.12938, "CDMP",
	446.14713, "ADEM",
	446.14713, "CDDX",
	446.14713, "CDEV",
	446.14713, "EEGM",
	446.15837, "CNQT",
	446.15837, "CQQS",
	446.15837, "MNNS",
	446.16239, "EMW",
	446.16489, "DETT",
	446.16489, "EEST",
	446.16576, "MMPS",
	446.16623, "DGHH",
	446.18015, "ADPY",
	446.18015, "DFPS",
	446.18015, "EGPY",
	446.18352, "CETX",
	446.18352, "DMSX",
	446.18352, "DMTV",
	446.18352, "EMSV",
	446.19138, "AFNN",
	446.19138, "DHPP",
	446.19138, "FGNQ",
	446.19475, "CKNT",
	446.19475, "CKQS",
	446.19541, "PWY",
	446.19878, "AFMP",
	446.19878, "CFPV",
	446.20215, "AMMX",
	446.20215, "CMVX",
	446.20262, "AHHT",
	446.21653, "ADFX",
	446.21653, "AEFV",
	446.21653, "EFGX",
	446.21653, "FPTT",
	446.21653, "PSVY",
	446.21991, "MTTX",
	446.22777, "FGKN",
	446.23114, "CKKS",
	446.23179, "FWX",
	446.25292, "AVXY",
	446.25292, "FSVX",
	446.25292, "FTVV",
	446.25292, "GXXY",
	446.26415, "HPVX",
	447.10600, "CDDN",
	447.14238, "CDQT",
	447.14238, "CENT",
	447.14238, "CEQS",
	447.14238, "DMNS",
	447.15764, "ACSW",
	447.15764, "CGTW",
	447.16101, "AMMN",
	447.16101, "CCQX",
	447.16101, "CMNV",
	447.16101, "GMMQ",
	447.17224, "CGMR",
	447.17540, "ADFN",
	447.17540, "DFGQ",
	447.17540, "EFGN",
	447.17540, "SSSW",
	447.17877, "CDKT",
	447.17877, "CEKS",
	447.17877, "MNTT",
	447.17877, "MQST",
	447.19000, "CRST",
	447.19065, "FGGW",
	447.19065, "FHY",
	447.19065, "FNW",
	447.19740, "CCKX",
	447.19740, "GKMM",
	447.21178, "AFQT",
	447.21178, "ANVY",
	447.21178, "DFGK",
	447.21178, "FNSV",
	447.21178, "GNXY",
	447.21178, "GQVY",
	447.21515, "KMST",
	447.22302, "AGRY",
	447.22302, "FGRS",
	447.22302, "HNPV",
	447.22302, "QRY",
	447.23425, "GHPR",
	447.24817, "AFKT",
	447.24817, "GKVY",
	447.25940, "KRY",
	447.25940, "PPPR",
	448.09001, "CDDD",
	448.11987, "CCNQ",
	448.12640, "CDET",
	448.12640, "CEES",
	448.12640, "DDMS",
	448.14503, "ADMM",
	448.14503, "CCEX",
	448.14503, "CDMV",
	448.14503, "EGMM",
	448.15626, "CCKN",
	448.15941, "ADDF",
	448.15941, "DEFG",
	448.16028, "MMW",
	448.16278, "DMTT",
	448.16278, "EMST",
	448.16412, "ACHH",
	448.17065, "GNNY",
	448.17467, "DFW",
	448.17804, "CFPT",
	448.17804, "GMPY",
	448.18141, "CMTX",
	448.18141, "MMSV",
	448.18188, "HHSS",
	448.19580, "ADVY",
	448.19580, "AEFT",
	448.19580, "DFSV",
	448.19580, "DGXY",
	448.19580, "EGVY",
	448.19580, "PSTY",
	448.20703, "DHPV",
	448.20703, "ERY",
	448.21106, "FFGP",
	448.21106, "VWY",
	448.21443, "AFMV",
	448.21443, "CFVV",
	448.21443, "FGMX",
	448.23218, "ATXY",
	448.23218, "FSTX",
	448.23218, "FTTV",
	448.23218, "SVVY",
	448.24342, "HPTX",
	448.27980, "HVVX",
	449.10389, "CCDQ",
	449.10389, "CCEN",
	449.11915, "CCGW",
	449.14028, "CCDK",
	449.14028, "CMNT",
	449.14028, "CMQS",
	449.15151, "CCRS",
	449.15466, "DGNY",
	449.17329, "ACFQ",
	449.17329, "FGMN",
	449.17666, "CKMS",
	449.19105, "ANTY",
	449.19105, "AQSY",
	449.19105, "FNST",
	449.19105, "FQSS",
	449.19105, "GQTY",
	449.20228, "HNPT",
	449.20228, "HPQS",
	449.20968, "ACFK",
	449.22743, "AKSY",
	449.22743, "FKSS",
	449.22743, "GKTY",
	449.23867, "AHQX",
	449.23867, "HKPS",
	449.23867, "HNVV",
	449.24990, "GHRV",
	449.26113, "HRR",
	449.27505, "AHKX",
	449.27505, "PPRV",
	450.08791, "CCDE",
	450.12429, "CDMT",
	450.12429, "CEMS",
	450.13868, "DDGY",
	450.13955, "CCFP",
	450.14292, "CCMX",
	450.14292, "GMMM",
	450.15731, "ACEF",
	450.15731, "CPSY",
	450.15731, "DFGM",
	450.16068, "MMST",
	450.17506, "ADTY",
	450.17506, "AESY",
	450.17506, "DFST",
	450.17506, "EFSS",
	450.17506, "EGTY",
	450.18630, "DHPT",
	450.18630, "EHPS",
	450.19032, "TWY",
	450.19369, "ACXY",
	450.19369, "AFMT",
	450.19369, "CFSX",
	450.19369, "CFTV",
	450.19369, "GMVY",
	450.19753, "AHNQ",
	450.19753, "GHQQ",
	450.20492, "CHPX",
	450.20492, "MRY",
	450.21145, "FTTT",
	450.21145, "SSXY",
	450.21145, "STVY",
	450.22268, "AEHX",
	450.22268, "DHVV",
	450.22268, "PPQQ",
	450.22671, "FFGV",
	450.23392, "AHKN",
	450.23392, "GHKQ",
	450.23794, "FFR",
	450.25907, "HSXX",
	450.25907, "HTVX",
	450.25907, "KPPQ",
	450.27030, "GHKK",
	450.29545, "KKPP",
	451.10178, "CCMN",
	451.15255, "ACNY",
	451.15255, "CFNS",
	451.15255, "CGQY",
	451.16379, "CHNP",
	451.17031, "NSSY",
	451.18155, "ADHQ",
	451.18155, "AEHN",
	451.18155, "EGHQ",
	451.18894, "CGKY",
	451.19680, "AGHW",
	451.19680, "HQW",
	451.20670, "EPPQ",
	451.21793, "ADHK",
	451.21793, "EGHK",
	451.21793, "HNSX",
	451.21793, "HNTV",
	451.21793, "HQSV",
	451.22195, "APPW",
	451.22917, "AHRS",
	451.22917, "GHRT",
	451.23319, "HKW",
	451.24308, "EKPP",
	451.25432, "HKSV",
	451.25432, "PPRT",
	451.27947, "PQXX",
	451.29070, "PRVV",
	451.31585, "KPXX",
	452.08580, "CCDM",
	452.12218, "CMMS",
	452.13657, "ACDY",
	452.13657, "CDFS",
	452.13657, "CEGY",
	452.14780, "CDHP",
	452.15183, "CWY",
	452.15433, "DSSY",
	452.15520, "ACFM",
	452.15520, "CCFV",
	452.16556, "ADEH",
	452.16556, "EEGH",
	452.17296, "AMSY",
	452.17296, "CFTT",
	452.17296, "CSVY",
	452.17296, "FMSS",
	452.17296, "GMTY",
	452.17680, "HNNS",
	452.18082, "EHW",
	452.18419, "HMPS",
	452.19071, "EEPP",
	452.19071, "STTY",
	452.20195, "DHSX",
	452.20195, "DHTV",
	452.20195, "EHSV",
	452.20597, "AAFY",
	452.20597, "AFFS",
	452.20597, "FFGT",
	452.21720, "AFHP",
	452.22057, "AHMX",
	452.22057, "CHVX",
	452.23833, "HTTX",
	452.23833, "NPQX",
	452.23833, "PQQV",
	452.24957, "APQR",
	452.26348, "EPXX",
	452.27472, "KNPX",
	452.27472, "KPQV",
	452.28595, "AKPR",
	452.31110, "KKPV",
	452.33626, "XXXX",
	453.16081, "DHNS",
	453.17944, "AHMN",
	453.17944, "CHNV",
	453.17944, "GHMQ",
	453.19067, "CGHR",
	453.19720, "HNTT",
	453.19720, "HQST",
	453.19720, "NNPQ",
	453.20459, "MPPQ",
	453.21582, "CPPR",
	453.21582, "GHKM",
	453.22235, "DPQX",
	453.22235, "ENPX",
	453.22235, "EPQV",
	453.23358, "AEPR",
	453.23358, "HKST",
	453.23358, "KNNP",
	453.23760, "APVW",
	453.23760, "GPWX",
	453.24098, "KMPP",
	453.25873, "DKPX",
	453.25873, "EKPV",
	453.26997, "PRSX",
	453.26997, "PRTV",
	453.29512, "NXXX",
	453.29512, "QVXX",
	453.30635, "ARXX",
	453.30635, "RVVV",
	453.33150, "KVXX",
	454.13446, "CCFT",
	454.13446, "CGMY",
	454.14483, "DDHS",
	454.15222, "CSTY",
	454.16345, "ADHM",
	454.16345, "CDHV",
	454.16345, "EGHM",
	454.16748, "CFFG",
	454.17871, "HMW",
	454.18121, "DHTT",
	454.18121, "DNPQ",
	454.18121, "EHST",
	454.18121, "ENNP",
	454.18523, "AGYY",
	454.18523, "FGSY",
	454.18523, "QYY",
	454.18861, "EMPP",
	454.19647, "GHPY",
	454.19647, "GNPW",
	454.19984, "CHTX",
	454.19984, "HMSV",
	454.20636, "DEPX",
	454.20636, "EEPV",
	454.21760, "DKNP",
	454.21760, "PQQT",
	454.22162, "KYY",
	454.22162, "PPPY",
	454.22883, "NPRS",
	454.23285, "AFHV",
	454.23285, "FGHX",
	454.25398, "KPQT",
	454.25398, "NNXX",
	454.25398, "NQVX",
	454.25398, "QQVV",
	454.25801, "FPPX",
	454.26138, "MPXX",
	454.26522, "ANRX",
	454.26522, "AQRV",
	454.26522, "GQRX",
	454.27645, "AARR",
	454.27913, "DXXX",
	454.27913, "EVXX",
	454.29037, "KKPT",
	454.29037, "KNVX",
	454.29037, "KQVV",
	454.30160, "AKRV",
	454.30160, "GKRX",
	454.32675, "KKVV",
	455.15870, "CHNT",
	455.15870, "CHQS",
	455.16523, "DDPQ",
	455.16523, "DENP",
	455.16925, "EYY",
	455.18048, "DGPW",
	455.19172, "FGHN",
	455.19509, "CHKS",
	455.20161, "DDKP",
	455.20161, "EPQT",
	455.21285, "AQQQ",
	455.21285, "DPRS",
	455.21285, "NNNX",
	455.21285, "NNQV",
	455.21687, "APTW",
	455.21687, "FNPP",
	455.22024, "MNPX",
	455.22024, "MPQV",
	455.22408, "ANNR",
	455.22408, "GNQR",
	455.23147, "AMPR",
	455.23147, "CPRV",
	455.23800, "DNXX",
	455.23800, "DQVX",
	455.23800, "EKPT",
	455.23800, "ENVX",
	455.23800, "EQVV",
	455.24923, "ADRX",
	455.24923, "AERV",
	455.24923, "AKQQ",
	455.24923, "EGRX",
	455.24923, "KNNV",
	455.24923, "PRTT",
	455.25325, "AVVW",
	455.25325, "GVWX",
	455.25663, "KMPV",
	455.26047, "GKNR",
	455.26449, "RWX",
	455.27438, "DKVX",
	455.27438, "EKVV",
	455.27438, "QTXX",
	455.28562, "AKKQ",
	455.28562, "RSVX",
	455.28562, "RTVV",
	455.31077, "KTXX",
	455.32200, "AKKK",
	456.09597, "CCCF",
	456.11373, "CCSY",
	456.14272, "CDHT",
	456.14272, "CEHS",
	456.14924, "DDEP",
	456.16134, "CCHX",
	456.16134, "GHMM",
	456.17171, "NNNN",
	456.17573, "DFGH",
	456.17910, "CPQQ",
	456.17910, "HMST",
	456.17910, "MNNP",
	456.18563, "EEPT",
	456.18650, "MMPP",
	456.19686, "AEQQ",
	456.19686, "DNNX",
	456.19686, "DNQV",
	456.19686, "ENNV",
	456.20088, "DFPP",
	456.20426, "DMPX",
	456.20426, "EMPV",
	456.20810, "ADNR",
	456.20810, "DGQR",
	456.20810, "EGNR",
	456.21212, "AAQW",
	456.21212, "AFHT",
	456.21212, "GHVY",
	456.21212, "GNVW",
	456.21549, "CKPQ",
	456.22201, "DDXX",
	456.22201, "DEVX",
	456.22201, "EEVV",
	456.22335, "GGRW",
	456.22335, "HRY",
	456.22335, "NRW",
	456.23325, "AEKQ",
	456.23325, "DKNV",
	456.23325, "NQTX",
	456.23325, "QQSX",
	456.23325, "QQTV",
	456.23727, "PPVY",
	456.24448, "AQRT",
	456.24448, "DGKR",
	456.24448, "NRSV",
	456.24850, "AAKW",
	456.25187, "CKKP",
	456.25571, "GRRS",
	456.25840, "ETXX",
	456.26963, "AEKK",
	456.26963, "KNTX",
	456.26963, "KQSX",
	456.26963, "KQTV",
	456.27366, "FPVX",
	456.27703, "MVXX",
	456.28087, "AKRT",
	456.30602, "KKSX",
	456.30602, "KKTV",
	457.12021, "CCHN",
	457.15573, "DNNN",
	457.16312, "CEPQ",
	457.16312, "DMNP",
	457.16714, "MYY",
	457.17838, "ACPW",
	457.18088, "AEEQ",
	457.18088, "DDNX",
	457.18088, "DDQV",
	457.18088, "DENV",
	457.19211, "ADDR",
	457.19211, "DEGR",
	457.19211, "NNQT",
	457.19211, "NQQS",
	457.19613, "AAEW",
	457.19613, "DGVW",
	457.19613, "PSSW",
	457.19950, "CEKP",
	457.19950, "MPQT",
	457.20016, "FFY",
	457.20737, "DRW",
	457.21074, "CPRT",
	457.21726, "AEEK",
	457.21726, "DDKV",
	457.21726, "DQTX",
	457.21726, "ENTX",
	457.21726, "EQSX",
	457.21726, "EQTV",
	457.22850, "AERT",
	457.22850, "DRSV",
	457.22850, "KNNT",
	457.22850, "KNQS",
	457.23252, "ASWX",
	457.23252, "ATVW",
	457.23252, "FNPV",
	457.23252, "GTWX",
	457.23589, "CQXX",
	457.23589, "KMPT",
	457.23589, "MNVX",
	457.23589, "MQVV",
	457.24375, "FGPR",
	457.24712, "AMRV",
	457.24712, "CRVV",
	457.24712, "GMRX",
	457.25365, "DKTX",
	457.25365, "EKSX",
	457.25365, "EKTV",
	457.26488, "KKNS",
	457.26488, "RSTX",
	457.26488, "RTTV",
	457.27228, "CKXX",
	457.27228, "KMVV",
	458.10422, "CCDH",
	458.13974, "DDNN",
	458.14061, "CHMS",
	458.14713, "CEEP",
	458.14713, "DDMP",
	458.16489, "AEEE",
	458.16489, "DDDX",
	458.16489, "DDEV",
	458.17362, "ACFH",
	458.17613, "DNQT",
	458.17613, "DQQS",
	458.17613, "ENNT",
	458.17613, "ENQS",
	458.18352, "EMPT",
	458.19138, "AHSY",
	458.19138, "ANSW",
	458.19138, "FHSS",
	458.19138, "GHTY",
	458.19138, "GNTW",
	458.19138, "GQSW",
	458.19475, "AMQQ",
	458.19475, "CNQX",
	458.19475, "CQQV",
	458.19475, "MNNV",
	458.20128, "DETX",
	458.20128, "EESX",
	458.20128, "EETV",
	458.20215, "MMPV",
	458.20262, "HHPS",
	458.20599, "ACQR",
	458.20599, "GMNR",
	458.21251, "DKNT",
	458.21251, "DKQS",
	458.21251, "EKNS",
	458.21251, "QQTT",
	458.21653, "DFPV",
	458.21653, "PPTY",
	458.21991, "CEXX",
	458.21991, "DMVX",
	458.21991, "EMVV",
	458.22375, "NRST",
	458.22375, "QRSS",
	458.22777, "GKSW",
	458.23114, "AKMQ",
	458.23114, "CKNX",
	458.23114, "CKQV",
	458.23900, "AHHX",
	458.24237, "ACKR",
	458.24890, "DKKS",
	458.24890, "KQTT",
	458.25292, "FPTX",
	458.25292, "PVVY",
	458.25629, "MTXX",
	458.26013, "KRSS",
	458.26752, "AKKM",
	458.26752, "CKKV",
	458.28528, "KKTT",
	458.28931, "FVVX",
	459.12376, "DDDN",
	459.15362, "CNNQ",
	459.16014, "DDQT",
	459.16014, "DENT",
	459.16014, "DEQS",
	459.16014, "EENS",
	459.16101, "CMPQ",
	459.17224, "CCPR",
	459.17540, "ADSW",
	459.17540, "DGTW",
	459.17540, "EGSW",
	459.17877, "AEMQ",
	459.17877, "CDQX",
	459.17877, "CENX",
	459.17877, "CEQV",
	459.17877, "DMNV",
	459.19000, "ACER",
	459.19000, "CKNN",
	459.19000, "DGMR",
	459.19065, "SWW",
	459.19403, "AAMW",
	459.19403, "ACVW",
	459.19403, "CGWX",
	459.19653, "DDKT",
	459.19653, "DEKS",
	459.19653, "EQTT",
	459.19740, "CKMP",
	459.19786, "AHHN",
	459.19786, "GHHQ",
	459.20776, "DRST",
	459.20776, "ERSS",
	459.21178, "APQY",
	459.21178, "ATTW",
	459.21178, "FNPT",
	459.21178, "FPQS",
	459.21178, "SSVW",
	459.21515, "AEKM",
	459.21515, "CDKX",
	459.21515, "CEKV",
	459.21515, "MNTX",
	459.21515, "MQSX",
	459.21515, "MQTV",
	459.22302, "HPPQ",
	459.22639, "AMRT",
	459.22639, "CRSX",
	459.22639, "CRTV",
	459.23291, "EKTT",
	459.23425, "GHHK",
	459.24415, "RTTT",
	459.24817, "AFQX",
	459.24817, "AKPY",
	459.24817, "FKPS",
	459.24817, "FNVV",
	459.25154, "KMSX",
	459.25154, "KMTV",
	459.25940, "FGRV",
	459.25940, "HKPP",
	459.27064, "FRR",
	459.28455, "AFKX",
	460.10777, "DDDD",
	460.13763, "CDNQ",
	460.13763, "CENN",
	460.14416, "DDET",
	460.14416, "DEES",
	460.14503, "CEMP",
	460.15289, "CGHY",
	460.15289, "CGNW",
	460.16278, "AEEM",
	460.16278, "CDEX",
	460.16278, "CEEV",
	460.16278, "DDMV",
	460.17402, "CDKN",
	460.17402, "CQQT",
	460.17402, "MNNT",
	460.17402, "MNQS",
	460.17804, "CPPY",
	460.18054, "EETT",
	460.18141, "MMPT",
	460.18188, "ADHH",
	460.18188, "EGHH",
	460.18525, "CNRS",
	460.19580, "AEPY",
	460.19580, "DFPT",
	460.19580, "EFPS",
	460.19714, "HHW",
	460.19917, "DMTX",
	460.19917, "EMSX",
	460.19917, "EMTV",
	460.20703, "AFNQ",
	460.20703, "EHPP",
	460.20703, "FGQQ",
	460.21040, "CKQT",
	460.21040, "KMNS",
	460.21443, "CFPX",
	460.21780, "CMXX",
	460.21780, "MMVV",
	460.21827, "HHSV",
	460.23218, "AEFX",
	460.23218, "DFVV",
	460.23218, "PSXY",
	460.23218, "PTVY",
	460.24342, "AFKN",
	460.24342, "FGKQ",
	460.24679, "CKKT",
	460.26857, "AXXY",
	460.26857, "FSXX",
	460.26857, "FTVX",
	460.26857, "VVVY",
	460.27980, "FGKK",
	460.27980, "HPXX",
	461.12165, "CDDQ",
	461.12165, "CDEN",
	461.13690, "CDGW",
	461.15803, "CDDK",
	461.15803, "CEQT",
	461.15803, "DMNT",
	461.15803, "DMQS",
	461.15803, "EMNS",
	461.16927, "CDRS",
	461.17329, "ACTW",
	461.17329, "CFNP",
	461.17329, "GMSW",
	461.17666, "AMMQ",
	461.17666, "CMNX",
	461.17666, "CMQV",
	461.18789, "ACMR",
	461.18789, "CCRV",
	461.19105, "ADFQ",
	461.19105, "AEFN",
	461.19105, "EFGQ",
	461.19105, "NPSY",
	461.19105, "SSTW",
	461.19442, "CEKT",
	461.19442, "DKMS",
	461.19442, "MQTT",
	461.20565, "CRTT",
	461.20565, "MRSS",
	461.20630, "AFGW",
	461.20630, "FQW",
	461.21305, "AKMM",
	461.21305, "CKMV",
	461.22743, "ADFK",
	461.22743, "ANXY",
	461.22743, "AQVY",
	461.22743, "EFGK",
	461.22743, "FNSX",
	461.22743, "FNTV",
	461.22743, "FQSV",
	461.22743, "GQXY",
	461.23080, "KMTT",
	461.23867, "AARY",
	461.23867, "AFRS",
	461.23867, "FGRT",
	461.23867, "HNPX",
	461.23867, "HPQV",
	461.24269, "FKW",
	461.24990, "AHPR",
	461.26382, "AKVY",
	461.26382, "FKSV",
	461.26382, "GKXY",
	461.27505, "HKPV",
	462.10566, "CDDE",
	462.13552, "CCQQ",
	462.13552, "CMNN",
	462.14205, "CEET",
	462.14205, "DDMT",
	462.14205, "DEMS",
	462.14292, "CMMP",
	462.15731, "CDFP",
	462.16068, "AEMM",
	462.16068, "CDMX",
	462.16068, "CEMV",
	462.17191, "CCKQ",
	462.17506, "ADEF",
	462.17506, "DPSY",
	462.17506, "EEFG",
	462.17843, "EMTT",
	462.17977, "GHHM",
	462.18630, "ANNY",
	462.18630, "FNNS",
	462.18630, "GNQY",
	462.19032, "EFW",
	462.19369, "AMPY",
	462.19369, "CPVY",
	462.19369, "FMPS",
	462.19706, "MMSX",
	462.19706, "MMTV",
	462.19753, "HHST",
	462.19753, "HNNP",
	462.20492, "HMPP",
	462.20829, "CCKK",
	462.21145, "ADXY",
	462.21145, "AEVY",
	462.21145, "DFSX",
	462.21145, "DFTV",
	462.21145, "EFSV",
	462.21145, "EGXY",
	462.21145, "PTTY",
	462.22268, "DHPX",
	462.22268, "EHPV",
	462.22268, "GKNY",
	462.22671, "AFFP",
	462.22671, "WXY",
	462.23008, "AFMX",
	462.23008, "CFVX",
	462.24783, "FTTX",
	462.24783, "SVXY",
	462.24783, "TVVY",
	462.29545, "HVXX",
	463.11954, "CCEQ",
	463.11954, "CDMN",
	463.13480, "ACCW",
	463.15255, "CSSW",
	463.15593, "CCEK",
	463.15593, "CMQT",
	463.15593, "MMNS",
	463.16716, "CCRT",
	463.17031, "ADNY",
	463.17031, "DFNS",
	463.17031, "DGQY",
	463.17031, "EGNY",
	463.18155, "DHNP",
	463.18557, "GGWY",
	463.18557, "HYY",
	463.18557, "NWY",
	463.18894, "AFMN",
	463.18894, "CFNV",
	463.18894, "FGMQ",
	463.19231, "CKMT",
	463.20017, "CFGR",
	463.20670, "AQTY",
	463.20670, "DGKY",
	463.20670, "FNTT",
	463.20670, "FQST",
	463.20670, "NSVY",
	463.21793, "GRSY",
	463.21793, "HPQT",
	463.22533, "FGKM",
	463.24308, "AKTY",
	463.24308, "FKST",
	463.25432, "HKPT",
	463.25432, "HNVX",
	463.25432, "HQVV",
	463.26555, "AHRV",
	463.26555, "GHRX",
	463.29070, "HKVV",
	463.29070, "PPRX",
	464.10356, "CCEE",
	464.10356, "CDDM",
	464.13994, "CEMT",
	464.13994, "DMMS",
	464.15433, "ADDY",
	464.15433, "DDFS",
	464.15433, "DEGY",
	464.15857, "AMMM",
	464.15857, "CMMV",
	464.15904, "CHHS",
	464.16556, "DDHP",
	464.16958, "DWY",
	464.17296, "ADFM",
	464.17296, "CDFV",
	464.17296, "CPTY",
	464.17296, "EFGM",
	464.17633, "MMTT",
	464.18821, "FMW",
	464.19071, "AETY",
	464.19071, "DFTT",
	464.19071, "DSVY",
	464.19071, "EFST",
	464.20195, "EHPT",
	464.20597, "FGPY",
	464.20934, "AMVY",
	464.20934, "CFTX",
	464.20934, "CVVY",
	464.20934, "FMSV",
	464.20934, "GMXY",
	464.21318, "AHQQ",
	464.21318, "HNNV",
	464.22057, "HMPV",
	464.22441, "GHNR",
	464.22710, "STXY",
	464.22710, "TTVY",
	464.23833, "DHVX",
	464.23833, "EHVV",
	464.24236, "AFFV",
	464.24236, "FFGX",
	464.24957, "AHKQ",
	464.24957, "NPPR",
	464.27472, "HTXX",
	464.28595, "AHKK",
	465.11743, "CCMQ",
	465.12866, "CCCR",
	465.15382, "CCKM",
	465.16820, "ACQY",
	465.16820, "CFNT",
	465.16820, "CFQS",
	465.16820, "GMNY",
	465.17944, "CHPQ",
	465.18596, "NSTY",
	465.18596, "QSSY",
	465.19720, "AEHQ",
	465.19720, "DHNV",
	465.20122, "FFGN",
	465.20459, "ACKY",
	465.20459, "CFKS",
	465.20843, "DGHR",
	465.21245, "AAHW",
	465.21582, "CHKP",
	465.22235, "KSSY",
	465.23358, "AEHK",
	465.23358, "DPPR",
	465.23358, "HNTX",
	465.23358, "HQSX",
	465.23358, "HQTV",
	465.24482, "AHRT",
	465.26997, "HKSX",
	465.26997, "HKTV",
	465.30635, "PRVX",
	466.10145, "CCEM",
	466.13446, "CCPY",
	466.13783, "CMMT",
	466.15222, "ACEY",
	466.15222, "CDFT",
	466.15222, "CEFS",
	466.15222, "DGMY",
	466.16345, "CEHP",
	466.16998, "DSTY",
	466.16998, "ESSY",
	466.17085, "CCFX",
	466.17085, "FGMM",
	466.18121, "AEEH",
	466.18121, "DDHV",
	466.18523, "DFFG",
	466.18861, "AMTY",
	466.18861, "CSXY",
	466.18861, "CTVY",
	466.18861, "FMST",
	466.19245, "HNNT",
	466.19245, "HNQS",
	466.19984, "HMPT",
	466.20636, "TTTY",
	466.21760, "DHTX",
	466.21760, "EHSX",
	466.21760, "EHTV",
	466.22162, "AFFT",
	466.22162, "FGVY",
	466.22883, "HKNS",
	466.23285, "FRY",
	466.23622, "CHXX",
	466.23622, "HMVV",
	466.25398, "PQQX",
	466.26522, "NPRV",
	466.27645, "GPRR",
	466.29037, "KPQX",
	466.32675, "KKPX",
	467.12971, "CCFN",
	467.14747, "CNSY",
	467.17646, "DHNT",
	467.17646, "DHQS",
	467.17646, "EHNS",
	467.19172, "GHSW",
	467.19509, "AHMQ",
	467.19509, "CHNX",
	467.19509, "CHQV",
	467.20632, "ACHR",
	467.21285, "DHKS",
	467.21285, "HQTT",
	467.21285, "NPQQ",
	467.21687, "PPSW",
	467.22408, "HRSS",
	467.23147, "AHKM",
	467.23147, "CHKV",
	467.23800, "EPQX",
	467.24923, "DPRV",
	467.24923, "HKTT",
	467.24923, "KNPQ",
	467.25325, "APWX",
	467.27438, "EKPX",
	467.28562, "KKNP",
	467.28562, "PRTX",
	467.31077, "QXXX",
	467.32200, "RVVX",
	467.34715, "KXXX",
	468.09934, "CCMM",
	468.11373, "CCDF",
	468.13148, "CDSY",
	468.15011, "ACMY",
	468.15011, "CCVY",
	468.15011, "CFMS",
	468.15395, "CHNN",
	468.16048, "DDHT",
	468.16048, "DEHS",
	468.16134, "CHMP",
	468.16787, "CTTY",
	468.16787, "MSSY",
	468.17910, "AEHM",
	468.17910, "CDHX",
	468.17910, "CEHV",
	468.18313, "ACFF",
	468.19686, "DPQQ",
	468.19686, "EHTT",
	468.19686, "ENPQ",
	468.19820, "GHHH",
	468.20088, "AAYY",
	468.20088, "AFSY",
	468.20088, "FFSS",
	468.20088, "FGTY",
	468.21212, "AHPY",
	468.21212, "ANPW",
	468.21212, "FHPS",
	468.21212, "GPQW",
	468.21549, "HMSX",
	468.21549, "HMTV",
	468.22201, "EEPX",
	468.22335, "HHPP",
	468.23325, "DKPQ",
	468.23325, "EKNP",
	468.24448, "NPRT",
	468.24448, "PQRS",
	468.24850, "AFHX",
	468.24850, "GKPW",
	468.26963, "DKKP",
	468.26963, "NQXX",
	468.26963, "QQVX",
	468.28087, "AQRX",
	468.28087, "KPRS",
	468.28087, "NRVV",
	468.29210, "GRRV",
	468.29479, "EXXX",
	468.30333, "RRR",
	468.30602, "KNXX",
	468.30602, "KQVX",
	468.31725, "AKRX",
	468.34240, "KKVX",
	469.13797, "CDHN",
	469.17435, "CHQT",
	469.17435, "HMNS",
	469.18088, "DEPQ",
	469.18088, "EENP",
	469.19613, "ADPW",
	469.19613, "EGPW",
	469.20737, "AFHN",
	469.20737, "FGHQ",
	469.21074, "CHKT",
	469.21139, "PWW",
	469.21726, "DEKP",
	469.22850, "DPRT",
	469.22850, "EPRS",
	469.22850, "NNQX",
	469.22850, "NQQV",
	469.23252, "FPPQ",
	469.23252, "PSVW",
	469.23589, "MPQX",
	469.23973, "ANQR",
	469.23973, "GQQR",
	469.24375, "FGHK",
	469.24712, "CPRX",
	469.25365, "DQXX",
	469.25365, "ENXX",
	469.25365, "EQVX",
	469.26488, "AERX",
	469.26488, "DRVV",
	469.26488, "KNNX",
	469.26488, "KNQV",
	469.26890, "AVWX",
	469.26890, "FKPP",
	469.26890, "GWXX",
	469.27228, "KMPX",
	469.27612, "AKNR",
	469.27612, "GKQR",
	469.29003, "DKXX",
	469.29003, "EKVX",
	469.30127, "KKNV",
	469.30127, "RSXX",
	469.30127, "RTVX",
	469.31250, "GKKR",
	470.12198, "CDDH",
	470.12938, "CCTY",
	470.15837, "CEHT",
	470.15837, "DHMS",
	470.16239, "CFGY",
	470.16489, "DEEP",
	470.17699, "AHMM",
	470.17699, "CHMV",
	470.18015, "GSYY",
	470.18736, "NNNQ",
	470.19138, "ADFH",
	470.19138, "EFGH",
	470.19475, "HMTT",
	470.19475, "MNPQ",
	470.20599, "CNPR",
	470.20664, "FHW",
	470.21251, "DNQX",
	470.21251, "DQQV",
	470.21251, "ENNX",
	470.21251, "ENQV",
	470.21653, "EFPP",
	470.21991, "EMPX",
	470.22375, "ADQR",
	470.22375, "AENR",
	470.22375, "EGQR",
	470.22375, "KNNN",
	470.22777, "AHVY",
	470.22777, "ANVW",
	470.22777, "FHSV",
	470.22777, "GHXY",
	470.22777, "GNWX",
	470.22777, "GQVW",
	470.23114, "KMNP",
	470.23766, "DEXX",
	470.23766, "EEVX",
	470.23900, "AGRW",
	470.23900, "HHPV",
	470.23900, "QRW",
	470.24890, "DKNX",
	470.24890, "DKQV",
	470.24890, "EKNV",
	470.24890, "QQTX",
	470.25292, "PPXY",
	470.26013, "ADKR",
	470.26013, "EGKR",
	470.26013, "NRSX",
	470.26013, "NRTV",
	470.26013, "QRSV",
	470.26415, "GKVW",
	470.27136, "ARRS",
	470.27136, "GRRT",
	470.27539, "KRW",
	470.28528, "DKKV",
	470.28528, "KQTX",
	470.28931, "FPXX",
	470.29268, "MXXX",
	470.29652, "KRSV",
	470.32167, "KKTX",
	471.13586, "CCHQ",
	471.17138, "DNNQ",
	471.17138, "ENNN",
	471.17224, "CCHK",
	471.17877, "DMPQ",
	471.17877, "EMNP",
	471.18663, "GHNY",
	471.18663, "GNNW",
	471.19000, "CDPR",
	471.19403, "GMPW",
	471.19653, "DDQX",
	471.19653, "DENX",
	471.19653, "DEQV",
	471.19653, "EENV",
	471.20776, "ADER",
	471.20776, "DKNN",
	471.20776, "EEGR",
	471.20776, "NQQT",
	471.20776, "QQQS",
	471.21178, "ADVW",
	471.21178, "DGWX",
	471.21178, "EGVW",
	471.21178, "NPPY",
	471.21178, "PSTW",
	471.21515, "DKMP",
	471.21899, "NNRS",
	471.22302, "ERW",
	471.22639, "MPRS",
	471.22704, "VWW",
	471.23291, "DDKX",
	471.23291, "DEKV",
	471.23291, "EQTX",
	471.24415, "DRSX",
	471.24415, "DRTV",
	471.24415, "ERSV",
	471.24415, "KNQT",
	471.24415, "KQQS",
	471.24817, "ATWX",
	471.24817, "FNPX",
	471.24817, "FPQV",
	471.24817, "SVVW",
	471.25154, "MNXX",
	471.25154, "MQVX",
	471.25940, "AFPR",
	471.26277, "AMRX",
	471.26277, "CRVX",
	471.26930, "EKTX",
	471.28053, "KKNT",
	471.28053, "KKQS",
	471.28053, "RTTX",
	471.28455, "FKPV",
	471.28793, "KMVX",
	471.31692, "KKKS",
	472.09088, "CCCY",
	472.11987, "CCEH",
	472.15539, "DDNQ",
	472.15539, "DENN",
	472.15626, "CHMT",
	472.16278, "DEMP",
	472.17065, "DGHY",
	472.17065, "DGNW",
	472.18054, "DDEX",
	472.18054, "DEEV",
	472.18927, "FGHM",
	472.19178, "DDKN",
	472.19178, "DQQT",
	472.19178, "ENQT",
	472.19178, "EQQS",
	472.19580, "DPPY",
	472.20301, "DNRS",
	472.20703, "AHTY",
	472.20703, "ANTW",
	472.20703, "AQSW",
	472.20703, "FHST",
	472.20703, "FNNP",
	472.20703, "GQTW",
	472.21040, "CQQX",
	472.21040, "MNNX",
	472.21040, "MNQV",
	472.21443, "FMPP",
	472.21693, "EETX",
	472.21780, "MMPX",
	472.21827, "HHPT",
	472.22164, "AMNR",
	472.22164, "CNRV",
	472.22164, "GMQR",
	472.22816, "DKQT",
	472.22816, "EKNT",
	472.22816, "EKQS",
	472.23218, "DFPX",
	472.23218, "EFPV",
	472.23287, "CGRR",
	472.23556, "DMXX",
	472.23556, "EMVX",
	472.23940, "NRTT",
	472.23940, "QRST",
	472.24342, "AKSW",
	472.24342, "GKTW",
	472.24679, "CKQX",
	472.24679, "KMNV",
	472.25465, "HHVV",
	472.25802, "GKMR",
	472.26455, "DKKT",
	472.26455, "EKKS",
	472.26857, "PVXY",
	472.27578, "KRST",
	472.28317, "CKKX",
	472.30496, "FVXX",
	473.13941, "DDDQ",
	473.13941, "DDEN",
	473.15466, "DDGW",
	473.16927, "CNQQ",
	473.16927, "MNNN",
	473.17329, "CPSW",
	473.17579, "DDDK",
	473.17579, "DEQT",
	473.17579, "EENT",
	473.17579, "EEQS",
	473.17666, "MMNP",
	473.18703, "DDRS",
	473.19105, "ADTW",
	473.19105, "AESW",
	473.19105, "DFNP",
	473.19105, "EGTW",
	473.19442, "CEQX",
	473.19442, "DMNX",
	473.19442, "DMQV",
	473.19442, "EMNV",
	473.19507, "FYY",
	473.20565, "ADMR",
	473.20565, "CDRV",
	473.20565, "CKNQ",
	473.20565, "EGMR",
	473.20630, "TWW",
	473.20968, "ACWX",
	473.20968, "GMVW",
	473.21218, "DEKT",
	473.21218, "EEKS",
	473.21352, "AHHQ",
	473.22091, "MRW",
	473.22341, "DRTT",
	473.22341, "ERST",
	473.22743, "FPQT",
	473.22743, "NPVY",
	473.22743, "SSWX",
	473.22743, "STVW",
	473.23080, "CEKX",
	473.23080, "DKMV",
	473.23080, "MQTX",
	473.23867, "GPRY",
	473.24204, "CKKN",
	473.24204, "CRTX",
	473.24204, "MRSV",
	473.24990, "AHHK",
	473.26382, "FKPT",
	473.26382, "FNVX",
	473.26382, "FQVV",
	473.26719, "KMTX",
	473.27505, "AFRV",
	473.27505, "FGRX",
	473.30020, "FKVV",
	474.11777, "CCHM",
	474.12342, "DDDE",
	474.15328, "CDQQ",
	474.15328, "CENQ",
	474.15328, "DMNN",
	474.15981, "DEET",
	474.15981, "EEES",
	474.16068, "DMMP",
	474.16854, "ACHY",
	474.16854, "ACNW",
	474.16854, "CFHS",
	474.16854, "CGQW",
	474.17506, "DDFP",
	474.17843, "CEEX",
	474.17843, "DDMX",
	474.17843, "DEMV",
	474.17977, "CHHP",
	474.18630, "HSSY",
	474.18630, "NSSW",
	474.18967, "CDKQ",
	474.18967, "CEKN",
	474.18967, "MNQT",
	474.18967, "MQQS",
	474.19753, "AEHH",
	474.20090, "CNRT",
	474.20090, "CQRS",
	474.20492, "CGKW",
	474.21145, "DPVY",
	474.21145, "EFPT",
	474.21482, "EMTX",
	474.22268, "AFQQ",
	474.22268, "FNNV",
	474.22605, "CDKK",
	474.22605, "KMNT",
	474.22605, "KMQS",
	474.23008, "FMPV",
	474.23345, "MMVX",
	474.23392, "FGNR",
	474.23392, "HHSX",
	474.23392, "HHTV",
	474.23729, "CKRS",
	474.24783, "DFVX",
	474.24783, "EFVV",
	474.24783, "PTXY",
	474.25907, "AFKQ",
	474.26244, "KKMS",
	474.28422, "FTXX",
	474.28422, "VVXY",
	474.29545, "AFKK",
	475.13730, "CDEQ",
	475.13730, "CEEN",
	475.13730, "DDMN",
	475.15255, "ACDW",
	475.15255, "CEGW",
	475.16781, "CWW",
	475.17031, "DSSW",
	475.17368, "CDEK",
	475.17368, "DMQT",
	475.17368, "EMNT",
	475.17368, "EMQS",
	475.18492, "CDRT",
	475.18492, "CERS",
	475.18894, "AMSW",
	475.18894, "CFPQ",
	475.18894, "CSVW",
	475.18894, "GMTW",
	475.19231, "CMQX",
	475.19231, "MMNV",
	475.19278, "HHNS",
	475.20354, "CCRX",
	475.20354, "GMMR",
	475.20670, "AEFQ",
	475.20670, "DFNV",
	475.20670, "NPTY",
	475.20670, "PQSY",
	475.20670, "STTW",
	475.21007, "DKMT",
	475.21007, "EKMS",
	475.21793, "DFGR",
	475.22130, "MRST",
	475.22195, "AAFW",
	475.22533, "CFKP",
	475.22870, "CKMX",
	475.24308, "AEFK",
	475.24308, "AQXY",
	475.24308, "FNTX",
	475.24308, "FQSX",
	475.24308, "FQTV",
	475.24308, "KPSY",
	475.24308, "NVVY",
	475.25432, "AFRT",
	475.25432, "GRVY",
	475.25432, "HPQX",
	475.26555, "RRY",
	475.27947, "AKXY",
	475.27947, "FKSX",
	475.27947, "FKTV",
	475.29070, "HKPX",
	476.12131, "CDEE",
	476.12131, "DDDM",
	476.15117, "CMNQ",
	476.15770, "DEMT",
	476.15770, "EEMS",
	476.16241, "CCNR",
	476.17296, "CEFP",
	476.17633, "CEMX",
	476.17633, "DMMV",
	476.17680, "DHHS",
	476.18756, "CKMN",
	476.19071, "AEEF",
	476.19071, "DDFV",
	476.19071, "DPTY",
	476.19071, "EPSY",
	476.19542, "AHHM",
	476.19542, "CHHV",
	476.20195, "ANQY",
	476.20195, "FNNT",
	476.20195, "FNQS",
	476.20195, "GQQY",
	476.20934, "CPXY",
	476.20934, "FMPT",
	476.21271, "MMTX",
	476.21318, "HHTT",
	476.21318, "HNPQ",
	476.22710, "AEXY",
	476.22710, "DFTX",
	476.22710, "DVVY",
	476.22710, "EFSX",
	476.22710, "EFTV",
	476.23833, "AKNY",
	476.23833, "EHPX",
	476.23833, "FKNS",
	476.23833, "GKQY",
	476.24573, "CFXX",
	476.24573, "FMVV",
	476.24957, "HKNP",
	476.26348, "SXXY",
	476.26348, "TVXY",
	476.27472, "GKKY",
	476.31110, "HXXX",
	477.13519, "CDMQ",
	477.13519, "CEMN",
	477.14642, "CCDR",
	477.15045, "CGMW",
	477.16820, "CNPY",
	477.16820, "CSTW",
	477.17158, "CDKM",
	477.17158, "MMNT",
	477.17158, "MMQS",
	477.18281, "CMRS",
	477.18596, "ADQY",
	477.18596, "AENY",
	477.18596, "DFNT",
	477.18596, "DFQS",
	477.18596, "EFNS",
	477.18596, "EGQY",
	477.19720, "DHPQ",
	477.19720, "EHNP",
	477.20122, "AGWY",
	477.20122, "FGSW",
	477.20122, "QWY",
	477.20459, "AFMQ",
	477.20459, "CFNX",
	477.20459, "CFQV",
	477.20796, "KMMS",
	477.21245, "GHPW",
	477.21582, "ACFR",
	477.22235, "ADKY",
	477.22235, "DFKS",
	477.22235, "EGKY",
	477.22235, "FQTT",
	477.22235, "NSXY",
	477.22235, "NTVY",
	477.22235, "QSVY",
	477.23358, "ARSY",
	477.23358, "DHKP",
	477.23358, "FRSS",
	477.23358, "GRTY",
	477.23760, "KWY",
	477.23760, "PPPW",
	477.24098, "AFKM",
	477.24098, "CFKV",
	477.24482, "HPRS",
	477.25873, "FKTT",
	477.25873, "KSVY",
	477.26997, "HNXX",
	477.26997, "HQVX",
	477.28120, "AHRX",
	477.30635, "HKVX",
	478.11921, "CDEM",
	478.15222, "CDPY",
	478.15559, "DMMT",
	478.15559, "EMMS",
	478.16345, "CFNN",
	478.16998, "ADEY",
	478.16998, "DDFT",
	478.16998, "DEFS",
	478.16998, "EEGY",
	478.17085, "CFMP",
	478.17422, "CMMX",
	478.17469, "CHHT",
	478.18121, "DEHP",
	478.18121, "NNSY",
	478.18523, "EWY",
	478.18861, "AEFM",
	478.18861, "CDFX",
	478.18861, "CEFV",
	478.18861, "MPSY",
	478.20636, "DSXY",
	478.20636, "DTVY",
	478.20636, "EFTT",
	478.20636, "ESVY",
	478.20770, "FGHH",
	478.22162, "AFPY",
	478.22162, "FFPS",
	478.22499, "AMXY",
	478.22499, "CVXY",
	478.22499, "FMSX",
	478.22499, "FMTV",
	478.22883, "HNNX",
	478.22883, "HNQV",
	478.23285, "FHPP",
	478.23622, "HMPX",
	478.24006, "AHNR",
	478.24006, "GHQR",
	478.24275, "TTXY",
	478.25398, "DHXX",
	478.25398, "EHVX",
	478.25801, "AFFX",
	478.26522, "HKNV",
	478.26522, "PPQR",
	478.27645, "GHKR",
	478.30160, "KPPR",
	479.12971, "CCSW",
	479.13308, "CMMN",
	479.14747, "CDFN",
	479.16523, "DNSY",
	479.18385, "AMNY",
	479.18385, "CFQT",
	479.18385, "CNVY",
	479.18385, "FMNS",
	479.18385, "GMQY",
	479.18769, "HNNN",
	479.19509, "CGRY",
	479.19509, "HMNP",
	479.20161, "NTTY",
	479.20161, "QSTY",
	479.21285, "DHNX",
	479.21285, "DHQV",
	479.21285, "EHNV",
	479.21687, "AFFN",
	479.21687, "FFGQ",
	479.22024, "CFKT",
	479.22024, "GKMY",
	479.22408, "ADHR",
	479.22408, "EGHR",
	479.22810, "GHVW",
	479.23800, "KSTY",
	479.23934, "HRW",
	479.24923, "DHKV",
	479.24923, "EPPR",
	479.24923, "HQTX",
	479.25325, "FFGK",
	479.25325, "PPVW",
	479.26047, "HRSV",
	479.28562, "HKTX",
	479.32200, "PRXX",
	480.11710, "CDMM",
	480.13148, "CDDF",
	480.13619, "CCHH",
	480.14924, "DDSY",
	480.15348, "MMMS",
	480.16787, "ADMY",
	480.16787, "CDVY",
	480.16787, "CEFT",
	480.16787, "DFMS",
	480.16787, "EGMY",
	480.17171, "DHNN",
	480.17910, "DHMP",
	480.18313, "MWY",
	480.18563, "DTTY",
	480.18563, "ESTY",
	480.18650, "AFMM",
	480.18650, "CFMV",
	480.19686, "DDHX",
	480.19686, "DEHV",
	480.20088, "ADFF",
	480.20088, "EFFG",
	480.20088, "GPYY",
	480.20426, "CTXY",
	480.20426, "FMTT",
	480.20426, "MSVY",
	480.20810, "HNQT",
	480.20810, "HQQS",
	480.21614, "FFW",
	480.23325, "EHTX",
	480.23727, "AFVY",
	480.23727, "FFSV",
	480.23727, "FGXY",
	480.24448, "HKNT",
	480.24448, "HKQS",
	480.24850, "FHPV",
	480.25187, "HMVX",
	480.28087, "HKKS",
	480.28087, "NPRX",
	480.28087, "PQRV",
	480.29210, "APRR",
	480.31725, "KPRV",
	481.14536, "CCFQ",
	481.15573, "DDHN",
	481.16312, "CNTY",
	481.16312, "CQSY",
	481.18175, "CCFK",
	481.19211, "DHQT",
	481.19211, "EHNT",
	481.19211, "EHQS",
	481.19613, "FGNY",
	481.19950, "CKSY",
	481.20737, "AHSW",
	481.20737, "GHTW",
	481.21074, "CHQX",
	481.21074, "HMNV",
	481.22197, "GHMR",
	481.22850, "DHKT",
	481.22850, "EHKS",
	481.22850, "PQQQ",
	481.23252, "PPTW",
	481.23973, "HRST",
	481.23973, "NNPR",
	481.24712, "CHKX",
	481.24712, "MPPR",
	481.26488, "DPRX",
	481.26488, "EPRV",
	481.26488, "KPQQ",
	481.26890, "PVVW",
	481.30127, "KKPQ",
	481.33765, "KKKP",
	481.33765, "RVXX",
	482.12938, "CCEF",
	482.13974, "DDDH",
	482.14713, "CDTY",
	482.14713, "CESY",
	482.16576, "CCXY",
	482.16576, "CFMT",
	482.16576, "GMMY",
	482.16960, "CHNQ",
	482.17613, "DEHT",
	482.17613, "EEHS",
	482.18015, "DFGY",
	482.18352, "MSTY",
	482.19475, "CEHX",
	482.19475, "DHMV",
	482.19878, "FFGM",
	482.20599, "CHKN",
	482.21251, "EPQQ",
	482.21385, "AHHH",
	482.21653, "AFTY",
	482.21653, "FFST",
	482.21653, "GVYY",
	482.22375, "DNPR",
	482.22777, "APQW",
	482.22777, "FHPT",
	482.22777, "RYY",
	482.23114, "HMTX",
	482.24890, "EKPQ",
	482.26013, "PQRT",
	482.26415, "AKPW",
	482.26415, "FHVV",
	482.28528, "EKKP",
	482.28528, "QQXX",
	482.29652, "KPRT",
	482.29652, "NRVX",
	482.29652, "QRVV",
	482.30775, "ARRV",
	482.30775, "GRRX",
	482.32167, "KQXX",
	482.33290, "KRVV",
	482.35805, "KKXX",
	483.12462, "CCNY",
	483.15362, "CDHQ",
	483.15362, "CEHN",
	483.16887, "CGHW",
	483.19000, "CDHK",
	483.19000, "HMNT",
	483.19000, "HMQS",
	483.19403, "CPPW",
	483.19653, "EEPQ",
	483.20124, "CHRS",
	483.20776, "DDPR",
	483.21178, "AEPW",
	483.22302, "AFHQ",
	483.22639, "HKMS",
	483.23291, "EEKP",
	483.24415, "EPRT",
	483.24415, "NQQX",
	483.24415, "QQQV",
	483.24817, "PSWX",
	483.24817, "PTVW",
	483.25538, "AQQR",
	483.25538, "NNRV",
	483.25940, "AFHK",
	483.26277, "MPRV",
	483.26661, "GNRR",
	483.26930, "EQXX",
	483.28053, "DRVX",
	483.28053, "ERVV",
	483.28053, "KNQX",
	483.28053, "KQQV",
	483.28455, "AWXX",
	483.28455, "VVVW",
	483.29177, "AKQR",
	483.30568, "EKXX",
	483.31692, "KKNX",
	483.31692, "KKQV",
	483.31692, "RTXX",
	483.32815, "AKKR",
	483.35330, "KKKV",
	484.10864, "CCDY",
	484.12727, "CCFM",
	484.13763, "CDEH",
	484.14503, "CMSY",
	484.17402, "DHMT",
	484.17402, "EHMS",
	484.17804, "ACFY",
	484.17804, "CFFS",
	484.18054, "EEEP",
	484.18927, "CFHP",
	484.19264, "CHMX",
	484.19580, "ASYY",
	484.19580, "FSSY",
	484.19580, "GTYY",
	484.20301, "NNQQ",
	484.20703, "AEFH",
	484.20703, "HPSY",
	484.20703, "NPSW",
	484.21040, "MPQQ",
	484.22164, "CPQR",
	484.22816, "DQQX",
	484.22816, "ENQX",
	484.22816, "EQQV",
	484.23940, "AEQR",
	484.23940, "DNRV",
	484.23940, "KNNQ",
	484.24342, "AHXY",
	484.24342, "ANWX",
	484.24342, "AQVW",
	484.24342, "FHSX",
	484.24342, "FHTV",
	484.24342, "GQWX",
	484.24679, "KMPQ",
	484.25063, "DGRR",
	484.25331, "EEXX",
	484.25465, "AARW",
	484.25465, "HHPX",
	484.25802, "CKPR",
	484.26455, "DKQX",
	484.26455, "EKNX",
	484.26455, "EKQV",
	484.27578, "AEKR",
	484.27578, "KKNN",
	484.27578, "NRTX",
	484.27578, "QRSX",
	484.27578, "QRTV",
	484.27980, "AKVW",
	484.27980, "GKWX",
	484.28317, "KKMP",
	484.28701, "ARRT",
	484.30093, "DKKX",
	484.30093, "EKKV",
	484.31217, "KRSX",
	484.31217, "KRTV",
	485.15151, "CHMN",
	485.18703, "DNQQ",
	485.18703, "ENNQ",
	485.19105, "DPSW",
	485.19442, "EMPQ",
	485.20228, "AHNY",
	485.20228, "ANNW",
	485.20228, "FHNS",
	485.20228, "GHQY",
	485.20228, "GNQW",
	485.20565, "CEPR",
	485.20968, "AMPW",
	485.20968, "CPVW",
	485.21218, "DEQX",
	485.21218, "EENX",
	485.21218, "EEQV",
	485.21352, "HHNP",
	485.22341, "AEER",
	485.22341, "DDRV",
	485.22341, "DKNQ",
	485.22341, "EKNN",
	485.22341, "QQQT",
	485.22743, "ADWX",
	485.22743, "AEVW",
	485.22743, "EGWX",
	485.22743, "PPQY",
	485.22743, "PTTW",
	485.23080, "EKMP",
	485.23464, "NNRT",
	485.23464, "NQRS",
	485.23867, "GHKY",
	485.23867, "GKNW",
	485.24204, "MPRT",
	485.24269, "WWX",
	485.24856, "DEKX",
	485.24856, "EEKV",
	485.25980, "DKKN",
	485.25980, "DRTX",
	485.25980, "ERSX",
	485.25980, "ERTV",
	485.25980, "KQQT",
	485.26382, "FPQX",
	485.26382, "KPPY",
	485.26382, "SVWX",
	485.26382, "TVVW",
	485.26719, "MQXX",
	485.27103, "KNRS",
	485.27842, "CRXX",
	485.27842, "MRVV",
	485.29618, "KKQT",
	485.30020, "FKPX",
	485.30358, "KMXX",
	485.33257, "KKKT",
	486.13552, "CDHM",
	486.15731, "CGYY",
	486.17104, "DDQQ",
	486.17104, "DENQ",
	486.17104, "EENN",
	486.17191, "HMMS",
	486.17843, "EEMP",
	486.18630, "ADHY",
	486.18630, "ADNW",
	486.18630, "DFHS",
	486.18630, "DGQW",
	486.18630, "EGHY",
	486.18630, "EGNW",
	486.19619, "DEEX",
	486.19619, "EEEV",
	486.19753, "DHHP",
	486.20155, "GGWW",
	486.20155, "HWY",
	486.20155, "NWW",
	486.20492, "AFHM",
	486.20492, "CFHV",
	486.20743, "DDKQ",
	486.20743, "DEKN",
	486.20743, "EQQT",
	486.21145, "EPPY",
	486.21866, "DNRT",
	486.21866, "DQRS",
	486.21866, "ENRS",
	486.22268, "AQTW",
	486.22268, "DGKW",
	486.22268, "FHTT",
	486.22268, "FNPQ",
	486.22268, "HSVY",
	486.22268, "NSVW",
	486.22605, "MNQX",
	486.22605, "MQQV",
	486.23392, "GRSW",
	486.23729, "AMQR",
	486.23729, "CNRX",
	486.23729, "CQRV",
	486.24381, "DDKK",
	486.24381, "EKQT",
	486.24783, "EFPX",
	486.24852, "ACRR",
	486.25121, "EMXX",
	486.25505, "DKRS",
	486.25505, "QRTT",
	486.25907, "AKTW",
	486.25907, "FKNP",
	486.26244, "KMNX",
	486.26244, "KMQV",
	486.26628, "RRSS",
	486.27030, "HHVX",
	486.27367, "AKMR",
	486.27367, "CKRV",
	486.28020, "EKKT",
	486.28422, "PXXY",
	486.29143, "KRTT",
	486.29882, "KKMV",
	486.32061, "FXXX",
	487.15506, "DDEQ",
	487.15506, "DEEN",
	487.17031, "ADDW",
	487.17031, "DEGW",
	487.18492, "CQQQ",
	487.18492, "MNNQ",
	487.18557, "DWW",
	487.18894, "CPTW",
	487.19144, "DDEK",
	487.19144, "EEQT",
	487.19231, "MMPQ",
	487.19615, "CNNR",
	487.20268, "DDRT",
	487.20268, "DERS",
	487.20354, "CMPR",
	487.20670, "AETW",
	487.20670, "DFPQ",
	487.20670, "DSVW",
	487.20670, "EFNP",
	487.21007, "DMQX",
	487.21007, "EMNX",
	487.21007, "EMQV",
	487.22130, "AEMR",
	487.22130, "CDRX",
	487.22130, "CERV",
	487.22130, "CKQQ",
	487.22130, "KMNN",
	487.22195, "FGPW",
	487.22533, "AMVW",
	487.22533, "CVVW",
	487.22533, "GMWX",
	487.22783, "EEKT",
	487.22870, "KMMP",
	487.22917, "HHNV",
	487.23906, "ERTT",
	487.24040, "GHHR",
	487.24308, "DFKP",
	487.24308, "NPXY",
	487.24308, "PQVY",
	487.24308, "STWX",
	487.24308, "TTVW",
	487.24645, "DKMX",
	487.24645, "EKMV",
	487.25432, "APRY",
	487.25432, "FPRS",
	487.25769, "CKKQ",
	487.25769, "MRSX",
	487.25769, "MRTV",
	487.26555, "HPPR",
	487.27947, "FNXX",
	487.27947, "FQVX",
	487.27947, "KPVY",
	487.29070, "AFRX",
	487.29407, "CKKK",
	487.31585, "FKVX",
	488.13907, "DDEE",
	488.16893, "CEQQ",
	488.16893, "DMNQ",
	488.16893, "EMNN",
	488.17546, "EEET",
	488.17633, "EMMP",
	488.18017, "CDNR",
	488.18419, "ACQW",
	488.18419, "CFHT",
	488.18419, "GHMY",
	488.18419, "GMNW",
	488.19071, "DEFP",
	488.19408, "DEMX",
	488.19408, "EEMV",
	488.20195, "HSTY",
	488.20195, "NNPY",
	488.20195, "NSTW",
	488.20195, "QSSW",
	488.20532, "CEKQ",
	488.20532, "DKMN",
	488.20532, "MQQT",
	488.20934, "MPPY",
	488.21318, "DHHV",
	488.21655, "CQRT",
	488.21655, "MNRS",
	488.21720, "FFGH",
	488.22057, "ACKW",
	488.22710, "DPXY",
	488.22710, "EPVY",
	488.23833, "FNNX",
	488.23833, "FNQV",
	488.23833, "KSSW",
	488.24170, "CEKK",
	488.24170, "KMQT",
	488.24236, "FFPP",
	488.24573, "FMPX",
	488.24910, "MMXX",
	488.24957, "AFNR",
	488.24957, "FGQR",
	488.24957, "HHTX",
	488.25294, "CKRT",
	488.26348, "DFXX",
	488.26348, "EFVX",
	488.27472, "FKNV",
	488.27809, "KKMT",
	488.28595, "FGKR",
	488.29987, "VXXY",
	489.15045, "CCPW",
	489.15295, "CEEQ",
	489.15295, "DDMQ",
	489.15295, "DEMN",
	489.16418, "CDDR",
	489.16820, "ACEW",
	489.16820, "DGMW",
	489.18596, "DNPY",
	489.18596, "DSTW",
	489.18596, "ESSW",
	489.18933, "CEEK",
	489.18933, "DDKM",
	489.18933, "EMQT",
	489.18999, "YYY",
	489.19720, "FNNN",
	489.20057, "CERT",
	489.20057, "DMRS",
	489.20459, "AMTW",
	489.20459, "CSWX",
	489.20459, "CTVW",
	489.20459, "FMNP",
	489.20796, "MMNX",
	489.20796, "MMQV",
	489.20843, "HHNT",
	489.20843, "HHQS",
	489.21919, "AMMR",
	489.21919, "CMRV",
	489.22235, "DFNX",
	489.22235, "DFQV",
	489.22235, "EFNV",
	489.22235, "PQTY",
	489.22235, "TTTW",
	489.22572, "EKMT",
	489.23358, "ADFR",
	489.23358, "EFGR",
	489.23695, "MRTT",
	489.23760, "FGVW",
	489.24435, "KMMV",
	489.24482, "HHKS",
	489.24884, "FRW",
	489.25873, "DFKV",
	489.25873, "FQTX",
	489.25873, "KPTY",
	489.25873, "NVXY",
	489.25873, "QVVY",
	489.26997, "ARVY",
	489.26997, "FRSV",
	489.26997, "GRXY",
	489.28120, "HPRV",
	489.29512, "FKTX",
	489.29512, "KVVY",
	490.13696, "CEEE",
	490.13696, "DDEM",
	490.14569, "CCFH",
	490.16345, "CHSY",
	490.16345, "CNSW",
	490.16682, "CMQQ",
	490.16682, "MMNN",
	490.16998, "DDPY",
	490.17335, "EEMT",
	490.17422, "MMMP",
	490.17806, "CCQR",
	490.18121, "DFNN",
	490.18861, "DFMP",
	490.19198, "DMMX",
	490.19198, "EMMV",
	490.19245, "DHHT",
	490.19245, "EHHS",
	490.20321, "CKMQ",
	490.20636, "DDFX",
	490.20636, "DEFV",
	490.20636, "EPTY",
	490.21107, "CHHX",
	490.21444, "CCKR",
	490.21760, "AQQY",
	490.21760, "FNQT",
	490.21760, "FQQS",
	490.21760, "NNVY",
	490.22499, "MPVY",
	490.22883, "GNRY",
	490.22883, "HPQQ",
	490.23960, "CKKM",
	490.24275, "DVXY",
	490.24275, "EFTX",
	490.24275, "EVVY",
	490.25398, "AKQY",
	490.25398, "FKNT",
	490.25398, "FKQS",
	490.25801, "FFPV",
	490.26138, "FMVX",
	490.26522, "HKPQ",
	490.27913, "TXXY",
	490.29037, "AKKY",
	490.29037, "FKKS",
	490.30160, "HKKP",
	491.14747, "CDSW",
	491.15084, "CEMQ",
	491.15084, "DMMN",
	491.16207, "CCER",
	491.16523, "DDFN",
	491.16610, "ACMW",
	491.16610, "CCVW",
	491.16994, "CHHN",
	491.18385, "CPQY",
	491.18385, "CTTW",
	491.18385, "MSSW",
	491.18723, "CEKM",
	491.18723, "MMQT",
	491.19846, "CMRT",
	491.20161, "AEQY",
	491.20161, "DFQT",
	491.20161, "DNVY",
	491.20161, "EFNT",
	491.20161, "EFQS",
	491.21285, "DGRY",
	491.21285, "EHPQ",
	491.21687, "AAWY",
	491.21687, "AFSW",
	491.21687, "FGTW",
	491.22024, "CFQX",
	491.22024, "CKPY",
	491.22024, "FMNV",
	491.22361, "KMMT",
	491.22810, "AHPW",
	491.23147, "FGMR",
	491.23800, "AEKY",
	491.23800, "DFKT",
	491.23800, "EFKS",
	491.23800, "NTXY",
	491.23800, "QSXY",
	491.23800, "QTVY",
	491.24923, "ARTY",
	491.24923, "EHKP",
	491.24923, "FRST",
	491.25663, "CFKX",
	491.26047, "HPRT",
	491.27438, "KSXY",
	491.27438, "KTVY",
	491.28562, "HQXX",
	491.29685, "HRVV",
	491.32200, "HKXX",
	492.13486, "CEEM",
	492.13486, "DDMM",
	492.14924, "DDDF",
	492.15395, "CDHH",
	492.16787, "CEPY",
	492.17124, "EMMT",
	492.17910, "CFNQ",
	492.18563, "AEEY",
	492.18563, "DDVY",
	492.18563, "DEFT",
	492.18563, "EEFS",
	492.18987, "MMMV",
	492.19034, "HHMS",
	492.19686, "EEHP",
	492.19686, "NNTY",
	492.19686, "NQSY",
	492.20426, "CEFX",
	492.20426, "DFMV",
	492.20426, "MPTY",
	492.21549, "CFKN",
	492.22201, "DTXY",
	492.22201, "ESXY",
	492.22201, "ETVY",
	492.22335, "AFHH",
	492.23325, "KNSY",
	492.23727, "FFPT",
	492.24064, "CXXY",
	492.24064, "FMTX",
	492.24064, "MVVY",
	492.24448, "HNQX",
	492.24448, "HQQV",
	492.25571, "AHQR",
	492.26963, "EHXX",
	492.27366, "FFVV",
	492.28087, "HKNX",
	492.28087, "HKQV",
	492.29210, "AHKR",
	492.31725, "HKKV",
	493.14536, "CCTW",
	493.14873, "CMMQ",
	493.15996, "CCMR",
	493.16312, "CDFQ",
	493.16312, "CEFN",
	493.17838, "CFGW",
	493.18088, "DNTY",
	493.18088, "DQSY",
	493.18088, "ENSY",
	493.18512, "CKMM",
	493.19613, "GSWY",
	493.19950, "AMQY",
	493.19950, "CDFK",
	493.19950, "CNXY",
	493.19950, "CQVY",
	493.19950, "FMNT",
	493.19950, "FMQS",
	493.20334, "HNNQ",
	493.21074, "ACRY",
	493.21074, "CFRS",
	493.21074, "HMPQ",
	493.21726, "DKSY",
	493.21726, "QTTY",
	493.22197, "CHPR",
	493.22850, "DHQX",
	493.22850, "EHNX",
	493.22850, "EHQV",
	493.22850, "RSSY",
	493.23252, "AFFQ",
	493.23589, "AKMY",
	493.23589, "CKVY",
	493.23589, "FKMS",
	493.23973, "AEHR",
	493.23973, "HKNN",
	493.24375, "AHVW",
	493.24375, "GHWX",
	493.24712, "HKMP",
	493.25365, "KTTY",
	493.26488, "DHKX",
	493.26488, "EHKV",
	493.26890, "AFFK",
	493.26890, "PPWX",
	493.27612, "HRSX",
	493.27612, "HRTV",
	494.13275, "CEMM",
	494.14713, "CDEF",
	494.15837, "CNNY",
	494.16489, "DDTY",
	494.16489, "DESY",
	494.16576, "CMPY",
	494.16913, "MMMT",
	494.18352, "AEMY",
	494.18352, "CDXY",
	494.18352, "CEVY",
	494.18352, "DFMT",
	494.18352, "EFMS",
	494.18736, "DHNQ",
	494.18736, "EHNN",
	494.19475, "EHMP",
	494.19878, "CFFP",
	494.20128, "ETTY",
	494.20215, "CFMX",
	494.20262, "GHHY",
	494.20262, "GHNW",
	494.21251, "DEHX",
	494.21251, "EEHV",
	494.21653, "AEFF",
	494.21653, "APYY",
	494.21653, "FPSY",
	494.21991, "MSXY",
	494.21991, "MTVY",
	494.22375, "DHKN",
	494.22375, "HQQT",
	494.22777, "HPPY",
	494.22777, "NPPW",
	494.23498, "HNRS",
	494.25292, "AFXY",
	494.25292, "FFSX",
	494.25292, "FFTV",
	494.26013, "HKQT",
	494.26415, "FHPX",
	494.26752, "HMXX",
	494.29652, "HKKT",
	494.29652, "PQRX",
	494.33290, "KPRX",
	495.10687, "CCCW",
	495.14238, "CDNY",
	495.16101, "CFMN",
	495.17138, "DDHQ",
	495.17138, "DEHN",
	495.17877, "CQTY",
	495.17877, "MNSY",
	495.18663, "DGHW",
	495.20776, "DDHK",
	495.20776, "EHQT",
	495.21178, "AFNY",
	495.21178, "DPPW",
	495.21178, "FFNS",
	495.21178, "FGQY",
	495.21515, "CKTY",
	495.21899, "DHRS",
	495.22302, "AHTW",
	495.22302, "FHNP",
	495.22639, "HMNX",
	495.22639, "HMQV",
	495.23762, "AHMR",
	495.23762, "CHRV",
	495.24415, "EHKT",
	495.24817, "FGKY",
	495.25538, "HRTT",
	495.25538, "NPQR",
	495.26277, "HKMV",
	495.28053, "EPRX",
	495.28455, "PVWX",
	495.29177, "KNPR",
	495.35330, "RXXX",
	496.12640, "CDDY",
	496.13064, "CMMM",
	496.14503, "CDFM",
	496.15539, "DDEH",
	496.16278, "CETY",
	496.16278, "DMSY",
	496.18141, "AMMY",
	496.18141, "CMVY",
	496.18141, "FMMS",
	496.18525, "CHQQ",
	496.18525, "HMNN",
	496.19178, "EEHT",
	496.19264, "HMMP",
	496.19580, "ADFY",
	496.19580, "DFFS",
	496.19580, "EFGY",
	496.19917, "MTTY",
	496.20703, "DFHP",
	496.21040, "DHMX",
	496.21040, "EHMV",
	496.21106, "FWY",
	496.21443, "AFFM",
	496.21443, "CFFV",
	496.22164, "CHKQ",
	496.23218, "AVYY",
	496.23218, "FFTT",
	496.23218, "FSVY",
	496.23218, "GXYY",
	496.23940, "DPQR",
	496.23940, "ENPR",
	496.24342, "HPVY",
	496.24342, "NPVW",
	496.25465, "GPRW",
	496.25802, "CHKK",
	496.27578, "DKPR",
	496.27980, "FHVX",
	496.28701, "PRRS",
	496.31217, "NRXX",
	496.31217, "QRVX",
	496.32340, "ARRX",
	496.34855, "KRVX",
	497.14028, "CCQY",
	497.16927, "CEHQ",
	497.16927, "DHMN",
	497.17666, "CCKY",
	497.18452, "ACHW",
	497.19105, "GNYY",
	497.20228, "HSSW",
	497.20565, "CEHK",
	497.20565, "HMQT",
	497.21689, "CHRT",
	497.22341, "DEPR",
	497.22743, "DPVW",
	497.23867, "FHNV",
	497.24204, "HKMT",
	497.24990, "FGHR",
	497.25980, "QQQX",
	497.26382, "PTWX",
	497.27103, "NNRX",
	497.27103, "NQRV",
	497.27505, "FPPR",
	497.27842, "MPRX",
	497.28226, "ANRR",
	497.28226, "GQRR",
	497.29618, "DRXX",
	497.29618, "ERVX",
	497.29618, "KQQX",
	497.30020, "VVWX",
	497.30742, "KNRV",
	497.31865, "GKRR",
	497.33257, "KKQX",
	497.36895, "KKKX",
	498.12429, "CCEY",
	498.15328, "CEEH",
	498.15328, "DDHM",
	498.16068, "CMTY",
	498.17506, "DGYY",
	498.18967, "EHMT",
	498.19369, "CFFT",
	498.19369, "FGMY",
	498.20829, "HMMV",
	498.20876, "HHHS",
	498.21145, "ATYY",
	498.21145, "FSTY",
	498.21866, "NQQQ",
	498.22268, "DFHV",
	498.22268, "HPTY",
	498.22268, "NPTW",
	498.22268, "PQSW",
	498.22671, "FFFG",
	498.22989, "NNNR",
	498.23729, "MNPR",
	498.24381, "EQQX",
	498.25505, "DNRX",
	498.25505, "DQRV",
	498.25505, "ENRV",
	498.25505, "KNQQ",
	498.25907, "AQWX",
	498.25907, "FHTX",
	498.25907, "HVVY",
	498.25907, "KPSW",
	498.25907, "NVVW",
	498.26628, "ADRR",
	498.26628, "EGRR",
	498.27030, "GRVW",
	498.28020, "EKQX",
	498.28154, "RRW",
	498.29143, "DKRV",
	498.29143, "KKNQ",
	498.29143, "QRTX",
	498.29545, "AKWX",
	498.30266, "RRSV",
	498.31658, "EKKX",
	498.32782, "KKKN",
	498.32782, "KRTX",
	499.16716, "CHMQ",
	499.17839, "CCHR",
	499.20268, "DQQQ",
	499.20268, "ENQQ",
	499.20354, "CHKM",
	499.20670, "DPTW",
	499.20670, "EPSW",
	499.21391, "DNNR",
	499.21793, "AHQY",
	499.21793, "ANQW",
	499.21793, "FHNT",
	499.21793, "FHQS",
	499.21793, "GQQW",
	499.22130, "DMPR",
	499.22533, "CPWX",
	499.22783, "EEQX",
	499.22917, "HHPQ",
	499.23906, "DDRX",
	499.23906, "DERV",
	499.23906, "DKQQ",
	499.23906, "EKNQ",
	499.24308, "AEWX",
	499.24308, "DVVW",
	499.25029, "NQRT",
	499.25029, "QQRS",
	499.25432, "AHKY",
	499.25432, "AKNW",
	499.25432, "FHKS",
	499.25432, "GKQW",
	499.26421, "EEKX",
	499.26555, "HHKP",
	499.27545, "DKKQ",
	499.27545, "EKKN",
	499.27545, "ERTX",
	499.27947, "SWXX",
	499.27947, "TVWX",
	499.28668, "KNRT",
	499.28668, "KQRS",
	499.29070, "FPRV",
	499.29070, "GKKW",
	499.29407, "MRVX",
	499.31183, "DKKK",
	499.32307, "KKRS",
	500.12218, "CCMY",
	500.15117, "CEHM",
	500.15520, "CCFF",
	500.17296, "ACYY",
	500.17296, "CFSY",
	500.18419, "CHPY",
	500.18419, "CNPW",
	500.18669, "DEQQ",
	500.18669, "EENQ",
	500.18756, "HMMT",
	500.19071, "SSYY",
	500.19792, "DDNR",
	500.20195, "ADQW",
	500.20195, "AEHY",
	500.20195, "AENW",
	500.20195, "DFHT",
	500.20195, "EFHS",
	500.20195, "EGQW",
	500.21184, "EEEX",
	500.21318, "EHHP",
	500.21720, "AGWW",
	500.21720, "QWW",
	500.22057, "CFHX",
	500.22308, "DEKQ",
	500.22308, "EEKN",
	500.23431, "DQRT",
	500.23431, "ENRT",
	500.23431, "EQRS",
	500.23833, "ADKW",
	500.23833, "EGKW",
	500.23833, "FPQQ",
	500.23833, "HSXY",
	500.23833, "HTVY",
	500.23833, "NSWX",
	500.23833, "NTVW",
	500.23833, "QSVW",
	500.24170, "MQQX",
	500.24957, "ARSW",
	500.24957, "GRTW",
	500.25294, "CQRX",
	500.25294, "MNRV",
	500.25359, "KWW",
	500.25946, "DEKK",
	500.26417, "GMRR",
	500.27070, "DKRT",
	500.27070, "EKRS",
	500.27472, "FKPQ",
	500.27472, "KSVW",
	500.27809, "KMQX",
	500.28193, "RRST",
	500.28595, "HHXX",
	500.28932, "CKRX",
	500.31110, "FKKP",
	500.31447, "KKMX",
	501.16820, "CDPW",
	501.17071, "DEEQ",
	501.17071, "EEEN",
	501.17944, "CFHN",
	501.18194, "DDDR",
	501.18596, "ADEW",
	501.18596, "EEGW",
	501.19720, "HNSY",
	501.19720, "NNSW",
	501.20057, "MNQQ",
	501.20122, "EWW",
	501.20459, "MPSW",
	501.20709, "DEEK",
	501.21180, "CNQR",
	501.21833, "DERT",
	501.21833, "EERS",
	501.22235, "DSWX",
	501.22235, "DTVW",
	501.22235, "EFPQ",
	501.22235, "ESVW",
	501.22572, "EMQX",
	501.23695, "CERX",
	501.23695, "DMRV",
	501.23695, "KMNQ",
	501.23760, "AFPW",
	501.24098, "AMWX",
	501.24098, "CVWX",
	501.24482, "HHNX",
	501.24482, "HHQV",
	501.24819, "CKNR",
	501.25605, "AHHR",
	501.25873, "EFKP",
	501.25873, "PQXY",
	501.25873, "TTWX",
	501.26210, "EKMX",
	501.26997, "FPRT",
	501.27334, "KKMN",
	501.27334, "MRTX",
	501.28120, "HHKV",
	501.29512, "FQXX",
	501.29512, "KPXY",
	501.30635, "FRVV",
	501.33150, "FKXX",
	502.14907, "CHMM",
	502.15472, "DEEE",
	502.16345, "CDFH",
	502.18121, "DHSY",
	502.18121, "DNSW",
	502.18458, "DMQQ",
	502.18458, "EMNQ",
	502.19582, "CDQR",
	502.19582, "CENR",
	502.19984, "AHMY",
	502.19984, "AMNW",
	502.19984, "CHVY",
	502.19984, "CNVW",
	502.19984, "FHMS",
	502.19984, "GMQW",
	502.20368, "HHNN",
	502.20636, "EEFP",
	502.20973, "EEMX",
	502.21107, "CGRW",
	502.21107, "HHMP",
	502.21760, "HTTY",
	502.21760, "NPQY",
	502.21760, "NTTW",
	502.21760, "QSTW",
	502.22097, "DKMQ",
	502.22097, "EKMN",
	502.22883, "DHHX",
	502.22883, "EHHV",
	502.23220, "CDKR",
	502.23220, "MNRT",
	502.23220, "MQRS",
	502.23285, "AFFH",
	502.23622, "GKMW",
	502.24275, "EPXY",
	502.24343, "CRRS",
	502.25398, "FNQX",
	502.25398, "FQQV",
	502.25398, "KNPY",
	502.25398, "KSTW",
	502.25735, "DKKM",
	502.26522, "AFQR",
	502.26859, "KMRS",
	502.27913, "EFXX",
	502.29037, "FKNX",
	502.29037, "FKQV",
	502.30160, "AFKR",
	502.31552, "XXXY",
	502.32675, "FKKV",
	503.16523, "DDSW",
	503.16860, "DEMQ",
	503.16860, "EEMN",
	503.17983, "CDER",
	503.18385, "ADMW",
	503.18385, "CDVW",
	503.18385, "EGMW",
	503.18769, "DHHN",
	503.19911, "MWW",
	503.20161, "DPQY",
	503.20161, "DTTW",
	503.20161, "ENPY",
	503.20161, "ESTW",
	503.20498, "DEKM",
	503.21285, "FNNQ",
	503.21622, "DMRT",
	503.21622, "EMRS",
	503.21687, "GPWY",
	503.22024, "CTWX",
	503.22024, "FMPQ",
	503.22024, "MSVW",
	503.22361, "MMQX",
	503.22408, "HHQT",
	503.23147, "CFPR",
	503.23484, "CMRX",
	503.23800, "DFQX",
	503.23800, "DKPY",
	503.23800, "EFNX",
	503.23800, "EFQV",
	503.24923, "AEFR",
	503.24923, "FKNN",
	503.24923, "PRSY",
	503.25325, "AFVW",
	503.25325, "FGWX",
	503.25663, "FKMP",
	503.26000, "KMMX",
	503.26047, "HHKT",
	503.27438, "DFKX",
	503.27438, "EFKV",
	503.27438, "NXXY",
	503.27438, "QVXY",
	503.28562, "ARXY",
	503.28562, "FRSX",
	503.28562, "FRTV",
	503.29685, "HPRX",
	503.31077, "KVXY",
	504.15261, "DEEM",
	504.17171, "DDHH",
	504.17910, "CHTY",
	504.17910, "CNTW",
	504.17910, "CQSW",
	504.18247, "MMNQ",
	504.18563, "DEPY",
	504.19371, "CMNR",
	504.19686, "DFNQ",
	504.19686, "EFNN",
	504.20426, "EFMP",
	504.20763, "EMMX",
	504.20810, "EHHT",
	504.21212, "FGHY",
	504.21212, "FGNW",
	504.21549, "CKSW",
	504.21886, "KMMN",
	504.22201, "DEFX",
	504.22201, "EEFV",
	504.22672, "HHMV",
	504.23325, "DFKN",
	504.23325, "FQQT",
	504.23325, "NNXY",
	504.23325, "NQVY",
	504.23727, "FPPY",
	504.24064, "MPXY",
	504.24448, "ANRY",
	504.24448, "FNRS",
	504.24448, "GQRY",
	504.25571, "HNPR",
	504.25840, "DXXY",
	504.25840, "EVXY",
	504.26963, "FKQT",
	504.26963, "KNVY",
	504.27366, "FFPX",
	504.27703, "FMXX",
	504.28087, "GKRY",
	504.30602, "FKKT",
	505.16312, "CDTW",
	505.16312, "CESW",
	505.16649, "DMMQ",
	505.16649, "EMMN",
	505.17772, "CDMR",
	505.18088, "DDFQ",
	505.18088, "DEFN",
	505.18175, "CCWX",
	505.18175, "GMMW",
	505.18559, "CHHQ",
	505.19211, "NNNY",
	505.19613, "DFGW",
	505.19950, "MNPY",
	505.19950, "MSTW",
	505.20288, "DKMM",
	505.21411, "MMRS",
	505.21726, "DDFK",
	505.21726, "DNXY",
	505.21726, "DQVY",
	505.21726, "EFQT",
	505.21726, "ENVY",
	505.22197, "CHHK",
	505.22850, "ADRY",
	505.22850, "DFRS",
	505.22850, "EGRY",
	505.23252, "AFTW",
	505.23252, "FFNP",
	505.23252, "GVWY",
	505.23589, "FMNX",
	505.23589, "FMQV",
	505.23973, "DHPR",
	505.24375, "RWY",
	505.24712, "AFMR",
	505.24712, "CFRV",
	505.25365, "DKVY",
	505.25365, "EFKT",
	505.25365, "QTXY",
	505.26488, "FRTT",
	505.26488, "RSVY",
	505.27228, "FKMV",
	505.29003, "KTXY",
	505.31250, "HRVX",
	506.14061, "CCHY",
	506.14061, "CCNW",
	506.15051, "DEMM",
	506.16489, "DDEF",
	506.16960, "CEHH",
	506.17613, "DNNY",
	506.18352, "DMPY",
	506.19475, "CFQQ",
	506.19475, "FMNN",
	506.20128, "DDXY",
	506.20128, "DEVY",
	506.20128, "EEFT",
	506.20215, "FMMP",
	506.20552, "MMMX",
	506.20599, "HHMT",
	506.21251, "NQTY",
	506.21251, "QQSY",
	506.21653, "DFFP",
	506.21991, "DFMX",
	506.21991, "EFMV",
	506.23114, "CFKQ",
	506.23766, "ETXY",
	506.24890, "KNTY",
	506.24890, "KQSY",
	506.25292, "FPVY",
	506.25629, "MVXY",
	506.26013, "HQQX",
	506.26752, "CFKK",
	506.27136, "HNRV",
	506.28260, "GHRR",
	506.28528, "KKSY",
	506.28931, "FFVX",
	506.29652, "HKQX",
	506.30775, "PPRR",
	506.33290, "HKKX",
	507.12462, "CCDW",
	507.16014, "DDNY",
	507.16101, "CMSW",
	507.16438, "MMMN",
	507.17877, "CEFQ",
	507.17877, "DFMN",
	507.19403, "ACFW",
	507.19653, "DQTY",
	507.19653, "ENTY",
	507.19653, "EQSY",
	507.21178, "ASWY",
	507.21178, "FSSW",
	507.21178, "GTWY",
	507.21515, "CEFK",
	507.21515, "CQXY",
	507.21515, "FMQT",
	507.21515, "MNVY",
	507.21899, "HNQQ",
	507.22302, "HPSW",
	507.22639, "CFRT",
	507.22639, "GMRY",
	507.23291, "DKTY",
	507.23291, "EKSY",
	507.24415, "EHQX",
	507.24415, "RSTY",
	507.24817, "FFNV",
	507.25154, "CKXY",
	507.25154, "FKMT",
	507.25538, "DHRV",
	507.25538, "HKNQ",
	507.25940, "AHWX",
	507.25940, "FFGR",
	507.28053, "EHKX",
	507.29177, "HKKN",
	507.29177, "HRTX",
	508.14416, "DDDY",
	508.14840, "DMMM",
	508.16278, "CEEF",
	508.16278, "DDFM",
	508.16749, "CHHM",
	508.17402, "CNQY",
	508.18054, "DETY",
	508.18054, "EESY",
	508.19917, "CEXY",
	508.19917, "DMVY",
	508.19917, "EFMT",
	508.20301, "DHQQ",
	508.20301, "EHNQ",
	508.21040, "CKNY",
	508.21780, "FMMV",
	508.21827, "AHHY",
	508.21827, "AHNW",
	508.21827, "FHHS",
	508.21827, "GHQW",
	508.22816, "EEHX",
	508.22950, "HHHP",
	508.23218, "DFFV",
	508.23218, "FPTY",
	508.23556, "MTXY",
	508.23940, "DHKQ",
	508.23940, "EHKN",
	508.24342, "PPQW",
	508.25063, "HNRT",
	508.25063, "HQRS",
	508.25465, "GHKW",
	508.26857, "FFTX",
	508.26857, "FVVY",
	508.27578, "DHKK",
	508.27980, "KPPW",
	508.28701, "HKRS",
	508.32340, "PRRV",
	509.15803, "CDQY",
	509.15803, "CENY",
	509.17329, "CGWY",
	509.17666, "CFMQ",
	509.18703, "DEHQ",
	509.18703, "EEHN",
	509.18789, "CCFR",
	509.19442, "CDKY",
	509.19442, "MNTY",
	509.19442, "MQSY",
	509.20228, "ADHW",
	509.20228, "EGHW",
	509.20565, "CRSY",
	509.21305, "CFKM",
	509.21754, "HWW",
	509.22341, "DEHK",
	509.22743, "AFQY",
	509.22743, "EPPW",
	509.22743, "FFNT",
	509.22743, "FFQS",
	509.23080, "KMSY",
	509.23464, "DHRT",
	509.23464, "EHRS",
	509.23867, "FHPQ",
	509.23867, "HSVW",
	509.24204, "HMQX",
	509.25327, "CHRX",
	509.26382, "AFKY",
	509.26382, "FFKS",
	509.27103, "PQQR",
	509.27505, "FHKP",
	509.27842, "HKMX",
	509.30020, "PWXX",
	509.30742, "KPQR",
	509.34380, "KKPR",
	510.14205, "CDEY",
	510.16068, "CEFM",
	510.17104, "DEEH",
	510.17843, "DMTY",
	510.17843, "EMSY",
	510.19369, "CFPY",
	510.19706, "CMXY",
	510.19706, "FMMT",
	510.20090, "HMNQ",
	510.21145, "AEFY",
	510.21145, "DFFT",
	510.21145, "EFFS",
	510.21145, "PSYY",
	510.21213, "CHNR",
	510.22268, "EFHP",
	510.22605, "EHMX",
	510.23008, "CFFX",
	510.23729, "HKMN",
	510.24515, "HHHV",
	510.24783, "AXYY",
	510.24783, "FSXY",
	510.24783, "FTVY",
	510.25505, "EPQR",
	510.25907, "HPXY",
	510.25907, "NPWX",
	510.25907, "PQVW",
	510.27030, "APRW",
	510.29143, "EKPR",
	510.29545, "FHXX",
	510.29545, "KPVW",
	510.30266, "PRRT",
	510.32782, "QRXX",
	510.33905, "RRVV",
	510.36420, "KRXX",
	511.15593, "CMNY",
	511.18492, "DHMQ",
	511.18492, "EHMN",
	511.18894, "CFFN",
	511.19615, "CDHR",
	511.20017, "GHMW",
	511.20670, "ANYY",
	511.20670, "FNSY",
	511.20670, "GQYY",
	511.21793, "HNPY",
	511.21793, "HSTW",
	511.21793, "NNPW",
	511.22130, "DHKM",
	511.22533, "MPPW",
	511.23254, "HMRS",
	511.23906, "EEPR",
	511.24308, "DPWX",
	511.24308, "EPVW",
	511.24308, "GKYY",
	511.25432, "FHNX",
	511.25432, "FHQV",
	511.26555, "AFHR",
	511.28668, "NQRX",
	511.28668, "QQRV",
	511.29070, "FHKV",
	511.29791, "AQRR",
	511.31183, "ERXX",
	511.31585, "VWXX",
	511.32307, "KNRX",
	511.32307, "KQRV",
	511.33430, "AKRR",
	511.35945, "KKRV",
	512.13994, "CDMY",
	512.15857, "CFMM",
	512.16893, "DEHM",
	512.17296, "CDFF",
	512.17633, "MMSY",
	512.19071, "ADYY",
	512.19071, "DFSY",
	512.19071, "EGYY",
	512.20195, "DHPY",
	512.20195, "DNPW",
	512.20597, "WYY",
	512.20934, "AFMY",
	512.20934, "CFVY",
	512.20934, "FFMS",
	512.21318, "FHNN",
	512.22057, "FHMP",
	512.22395, "HMMX",
	512.22441, "HHHT",
	512.22710, "FTTY",
	512.22710, "SVYY",
	512.23431, "QQQQ",
	512.23833, "DFHX",
	512.23833, "EFHV",
	512.23833, "PQTW",
	512.24236, "AFFF",
	512.24554, "NNQR",
	512.25294, "MPQR",
	512.26417, "CPRR",
	512.27070, "DQRX",
	512.27070, "ENRX",
	512.27070, "EQRV",
	512.27070, "KQQQ",
	512.27472, "HVXY",
	512.27472, "KPTW",
	512.27472, "NVWX",
	512.27472, "QVVW",
	512.28193, "AERR",
	512.28193, "KNNR",
	512.28595, "ARVW",
	512.28595, "GRWX",
	512.28932, "KMPR",
	512.30708, "DKRX",
	512.30708, "EKRV",
	512.30708, "KKQQ",
	512.31110, "KVVW",
	512.31831, "RRSX",
	512.31831, "RRTV",
	512.34347, "KKKQ",
	512.37985, "KKKK",
	513.17944, "CHSW",
	513.18281, "HMMN",
	513.18596, "DDPW",
	513.19720, "DFHN",
	513.21833, "EQQQ",
	513.22235, "EPTW",
	513.22956, "DNQR",
	513.22956, "ENNR",
	513.23358, "AQQW",
	513.23358, "FHQT",
	513.23358, "HNVY",
	513.23358, "NNVW",
	513.23695, "EMPR",
	513.24098, "MPVW",
	513.24482, "GHRY",
	513.24482, "GNRW",
	513.25471, "DERX",
	513.25471, "EERV",
	513.25471, "EKQQ",
	513.25873, "DVWX",
	513.25873, "EVVW",
	513.26594, "DKNR",
	513.26594, "QQRT",
	513.26997, "AKQW",
	513.26997, "FHKT",
	513.26997, "PPRY",
	513.27718, "NRRS",
	513.29110, "EKKQ",
	513.29512, "TWXX",
	513.30233, "KQRT",
	513.30635, "AKKW",
	513.30635, "FPRX",
	513.30972, "MRXX",
	513.32748, "EKKK",
	513.33872, "KKRT",
	514.16682, "DHMM",
	514.18121, "DDFH",
	514.18592, "CHHH",
	514.18861, "CFTY",
	514.18861, "GMYY",
	514.19984, "CPQW",
	514.20234, "EEQQ",
	514.20636, "STYY",
	514.21357, "DDQR",
	514.21357, "DENR",
	514.21760, "AEQW",
	514.21760, "DHVY",
	514.21760, "DNVW",
	514.21760, "EFHT",
	514.22162, "FFGY",
	514.22883, "DGRW",
	514.23285, "AAWW",
	514.23622, "CKPW",
	514.23622, "FHMV",
	514.23873, "EEKQ",
	514.24996, "DDKR",
	514.24996, "EQRT",
	514.25398, "AEKW",
	514.25398, "HTXY",
	514.25398, "NTWX",
	514.25398, "QSWX",
	514.25398, "QTVW",
	514.26119, "DRRS",
	514.26522, "ARTW",
	514.26522, "FNPR",
	514.26859, "MNRX",
	514.26859, "MQRV",
	514.27511, "EEKK",
	514.27982, "AMRR",
	514.27982, "CRRV",
	514.28635, "EKRT",
	514.29037, "KSWX",
	514.29037, "KTVW",
	514.29758, "RRTT",
	514.30497, "KMRV",
	515.18385, "CEPW",
	515.18636, "EEEQ",
	515.19509, "CFHQ",
	515.19759, "DDER",
	515.20161, "AEEW",
	515.20161, "DDVW",
	515.21285, "HNTY",
	515.21285, "HQSY",
	515.21285, "NNTW",
	515.21285, "NQSW",
	515.21622, "MQQQ",
	515.22024, "MPTW",
	515.22274, "EEEK",
	515.22745, "CQQR",
	515.22745, "MNNR",
	515.23147, "CFHK",
	515.23398, "EERT",
	515.23484, "MMPR",
	515.23800, "DTWX",
	515.23800, "ESWX",
	515.23800, "ETVW",
	515.24923, "DFPR",
	515.24923, "HKSY",
	515.24923, "KNSW",
	515.25260, "DMRX",
	515.25260, "EMRV",
	515.25260, "KMQQ",
	515.25663, "CWXX",
	515.25663, "MVVW",
	515.26047, "HHQX",
	515.26384, "CKQR",
	515.28562, "PRVY",
	515.28899, "KKMQ",
	515.29685, "HHKX",
	515.30022, "CKKR",
	515.32200, "FRVX",
	515.32537, "KKKM",
	516.15011, "CCFY",
	516.16787, "CSYY",
	516.17037, "EEEE",
	516.17910, "CEFH",
	516.19686, "DHTY",
	516.19686, "DNTW",
	516.19686, "DQSW",
	516.19686, "EHSY",
	516.19686, "ENSW",
	516.20023, "EMQQ",
	516.21147, "CEQR",
	516.21147, "DMNR",
	516.21212, "GSWW",
	516.21549, "AMQW",
	516.21549, "CHXY",
	516.21549, "CNWX",
	516.21549, "CQVW",
	516.21549, "FHMT",
	516.21933, "HHNQ",
	516.22672, "ACRW",
	516.23325, "DKSW",
	516.23325, "PQQY",
	516.23325, "QTTW",
	516.23662, "EKMQ",
	516.24448, "EHHX",
	516.24448, "RSSW",
	516.24785, "CEKR",
	516.24785, "MQRT",
	516.25187, "AKMW",
	516.25187, "CKVW",
	516.25571, "HHKN",
	516.25909, "CRRT",
	516.26963, "FQQX",
	516.26963, "KPQY",
	516.26963, "KTTW",
	516.27300, "EKKM",
	516.28087, "FNRV",
	516.28424, "KMRT",
	516.29210, "FGRR",
	516.30602, "FKQX",
	516.30602, "KKPY",
	516.34240, "FKKX",
	517.17435, "CHNY",
	517.17435, "CNNW",
	517.18088, "DDTW",
	517.18088, "DESW",
	517.18175, "CMPW",
	517.18425, "EEMQ",
	517.19548, "CEER",
	517.19548, "DDMR",
	517.19950, "AEMW",
	517.19950, "CDWX",
	517.19950, "CEVW",
	517.20334, "DHHQ",
	517.20334, "EHHN",
	517.21726, "EPQY",
	517.21726, "ETTW",
	517.21860, "GHHW",
	517.22063, "EEKM",
	517.22850, "FNQQ",
	517.23187, "EMRT",
	517.23252, "APWY",
	517.23252, "FPSW",
	517.23589, "MSWX",
	517.23589, "MTVW",
	517.23973, "DHHK",
	517.24375, "HPPW",
	517.25049, "MMRV",
	517.25096, "HHRS",
	517.25365, "EFQX",
	517.25365, "EKPY",
	517.26488, "DFRV",
	517.26488, "FKNQ",
	517.26488, "PRTY",
	517.26890, "AFWX",
	517.29003, "EFKX",
	517.29003, "QXXY",
	517.30127, "FKKN",
	517.30127, "FRTX",
	517.30127, "RVVY",
	517.32642, "KXXY",
	518.15837, "CDHY",
	518.15837, "CDNW",
	518.16826, "EEEM",
	518.17699, "CFHM",
	518.18736, "DEHH",
	518.19475, "CQTW",
	518.19475, "HMSY",
	518.19475, "MNSW",
	518.19812, "MMQQ",
	518.20128, "EEPY",
	518.20936, "CMQR",
	518.21251, "DFQQ",
	518.21251, "EFNQ",
	518.22059, "CCRR",
	518.22777, "AFHY",
	518.22777, "AFNW",
	518.22777, "FFHS",
	518.22777, "FGQW",
	518.23114, "CKTW",
	518.23451, "KMMQ",
	518.23766, "EEFX",
	518.23900, "FHHP",
	518.24237, "HHMX",
	518.24574, "CKMR",
	518.24890, "DFKQ",
	518.24890, "EFKN",
	518.24890, "NQXY",
	518.24890, "QQVY",
	518.26013, "AQRY",
	518.26013, "FNRT",
	518.26013, "FQRS",
	518.26415, "FGKW",
	518.27090, "KKMM",
	518.27136, "HPQR",
	518.27405, "EXXY",
	518.28528, "DFKK",
	518.28528, "KNXY",
	518.28528, "KQVY",
	518.29652, "AKRY",
	518.29652, "FKRS",
	518.30775, "HKPR",
	518.32167, "KKVY",
	519.14238, "CDDW",
	519.17877, "CETW",
	519.17877, "DMSW",
	519.18214, "EMMQ",
	519.19337, "CEMR",
	519.19653, "DEFQ",
	519.19653, "EEFN",
	519.19740, "AMMW",
	519.19740, "CMVW",
	519.20124, "HHMN",
	519.20776, "NNQY",
	519.21178, "ADFW",
	519.21178, "EFGW",
	519.21515, "MPQY",
	519.21515, "MTTW",
	519.21853, "EKMM",
	519.22639, "CPRY",
	519.22704, "FWW",
	519.22976, "MMRT",
	519.23291, "DEFK",
	519.23291, "DQXY",
	519.23291, "ENXY",
	519.23291, "EQVY",
	519.24415, "AERY",
	519.24415, "DFRT",
	519.24415, "EFRS",
	519.24415, "KNNY",
	519.24817, "AVWY",
	519.24817, "FFPQ",
	519.24817, "FSVW",
	519.24817, "GWXY",
	519.25154, "FMQX",
	519.25154, "KMPY",
	519.25538, "EHPR",
	519.25940, "HPVW",
	519.26277, "CFRX",
	519.26930, "DKXY",
	519.26930, "EKVY",
	519.28053, "RSXY",
	519.28053, "RTVY",
	519.28455, "FFKP",
	519.28793, "FKMX",
	519.32815, "HRXX",
	520.15626, "CCQW",
	520.16616, "EEMM",
	520.18054, "DEEF",
	520.18525, "DHHM",
	520.19178, "DNQY",
	520.19178, "ENNY",
	520.19264, "CCKW",
	520.19917, "EMPY",
	520.20703, "GHYY",
	520.20703, "GNWY",
	520.21040, "FMNQ",
	520.21693, "DEXY",
	520.21693, "EEVY",
	520.22164, "CFNR",
	520.22816, "DKNY",
	520.22816, "QQTY",
	520.23218, "EFFP",
	520.23218, "PPYY",
	520.23556, "EFMX",
	520.23940, "NRSY",
	520.24679, "FKMN",
	520.25465, "FHHV",
	520.26455, "KQTY",
	520.26857, "FPXY",
	520.27194, "MXXY",
	520.28701, "HNRX",
	520.28701, "HQRV",
	520.29825, "AHRR",
	520.30093, "KKTY",
	520.30496, "FFXX",
	520.32340, "HKRV",
	521.14028, "CCEW",
	521.17579, "DDQY",
	521.17579, "DENY",
	521.17666, "CMTW",
	521.18003, "MMMQ",
	521.19105, "DGWY",
	521.19126, "CMMR",
	521.19442, "DFMQ",
	521.19442, "EFMN",
	521.20565, "CDFR",
	521.20968, "FGMW",
	521.21218, "DDKY",
	521.21218, "EQTY",
	521.21642, "KMMM",
	521.22341, "DRSY",
	521.22743, "ATWY",
	521.22743, "FNPY",
	521.22743, "FSTW",
	521.23080, "DFKM",
	521.23080, "MNXY",
	521.23080, "MQVY",
	521.23464, "HQQQ",
	521.23867, "HPTW",
	521.24204, "AMRY",
	521.24204, "CRVY",
	521.24204, "FMRS",
	521.24588, "HNNR",
	521.24856, "EKTY",
	521.25327, "HMPR",
	521.25980, "RTTY",
	521.26382, "FFNX",
	521.26382, "FFQV",
	521.26719, "KMVY",
	521.27103, "DHRX",
	521.27103, "EHRV",
	521.27103, "HKQQ",
	521.27505, "AFFR",
	521.27505, "HVVW",
	521.30020, "FFKV",
	521.30742, "HKKQ",
	521.34380, "HKKK",
	522.15981, "DDEY",
	522.16405, "EMMM",
	522.17843, "DEFM",
	522.18967, "CQQY",
	522.18967, "MNNY",
	522.19619, "EETY",
	522.19706, "MMPY",
	522.21145, "DFPY",
	522.21482, "DMXY",
	522.21482, "EMVY",
	522.21866, "EHQQ",
	522.22268, "FFNN",
	522.22605, "CKQY",
	522.22989, "DHNR",
	522.23008, "FFMP",
	522.23345, "FMMX",
	522.23392, "AHQW",
	522.23392, "FHHT",
	522.24783, "DFFX",
	522.24783, "EFFV",
	522.24783, "PVYY",
	522.25505, "EHKQ",
	522.26244, "CKKY",
	522.26628, "HQRT",
	522.27030, "AHKW",
	522.28422, "FVXY",
	522.29143, "EHKK",
	522.30266, "HKRT",
	522.33905, "PRRX",
	523.13817, "CCMW",
	523.17368, "CEQY",
	523.17368, "DMNY",
	523.18894, "ACWY",
	523.18894, "CFSW",
	523.19231, "FMMN",
	523.20017, "CHPW",
	523.20268, "EEHQ",
	523.20670, "DFFN",
	523.20670, "SSWY",
	523.21007, "CEKY",
	523.21007, "MQTY",
	523.21391, "DDHR",
	523.21793, "AEHW",
	523.22130, "CRTY",
	523.23906, "EEHK",
	523.24308, "FFQT",
	523.24308, "FNVY",
	523.24645, "KMTY",
	523.25029, "EHRT",
	523.25432, "FGRY",
	523.25432, "HSWX",
	523.25432, "HTVW",
	523.26892, "HMRV",
	523.27947, "FFKT",
	523.29791, "NPRR",
	524.15770, "CEEY",
	524.15770, "DDMY",
	524.16194, "MMMM",
	524.17633, "DFMM",
	524.18669, "EEEH",
	524.19071, "DDFF",
	524.19408, "EMTY",
	524.19542, "CFHH",
	524.21271, "MMVY",
	524.21318, "HHSY",
	524.21318, "HNSW",
	524.21655, "HMQQ",
	524.22710, "DFVY",
	524.22710, "EFFT",
	524.22710, "PTYY",
	524.22778, "CHQR",
	524.24573, "FFMV",
	524.25294, "HKMQ",
	524.26080, "HHHX",
	524.26348, "FTXY",
	524.26348, "VVYY",
	524.26417, "CHKR",
	524.27472, "PQWX",
	524.28193, "DPRR",
	524.28932, "HKKM",
	524.31110, "KPWX",
	524.35470, "RRVX",
	525.17158, "CMQY",
	525.18281, "CCRY",
	525.19720, "DHSW",
	525.20057, "EHMQ",
	525.20459, "CFFQ",
	525.20796, "CKMY",
	525.21180, "CEHR",
	525.21582, "AHMW",
	525.21582, "CHVW",
	525.21966, "HHHN",
	525.22235, "AQYY",
	525.22235, "FNTY",
	525.22235, "FQSY",
	525.23358, "HPQY",
	525.23358, "HTTW",
	525.23358, "NPQW",
	525.23695, "EHKM",
	525.24098, "CFFK",
	525.24819, "HMRT",
	525.25873, "AKYY",
	525.25873, "EPWX",
	525.25873, "FKSY",
	525.26997, "FHQX",
	525.26997, "HKPY",
	525.26997, "KNPW",
	525.30233, "QQRX",
	525.30635, "FHKX",
	525.31356, "NRRV",
	525.32480, "GRRR",
	525.33150, "WXXX",
	525.33872, "KQRX",
	525.37510, "KKRX",
	526.15559, "CEMY",
	526.18458, "EEHM",
	526.18861, "CEFF",
	526.18861, "CPYY",
	526.19198, "MMTY",
	526.20368, "DHHH",
	526.20636, "AEYY",
	526.20636, "DFTY",
	526.20636, "EFSY",
	526.21760, "DPQW",
	526.21760, "EHPY",
	526.21760, "ENPW",
	526.22499, "CFXY",
	526.22499, "FFMT",
	526.22883, "FHNQ",
	526.23285, "GPWW",
	526.24275, "SXYY",
	526.24275, "TVYY",
	526.25398, "DKPW",
	526.25398, "EFHX",
	526.26119, "NQQR",
	526.26522, "FHKN",
	526.26522, "PRSW",
	526.28635, "EQRX",
	526.29037, "HXXY",
	526.29037, "NWXX",
	526.29037, "QVWX",
	526.29758, "DRRV",
	526.29758, "KNQR",
	526.30160, "ARWX",
	526.32273, "EKRX",
	526.32675, "KVWX",
	526.33396, "KKNR",
	526.33396, "RRTX",
	527.18385, "CFNY",
	527.19509, "CHTW",
	527.19846, "HMMQ",
	527.20161, "DEPW",
	527.20161, "NSYY",
	527.20969, "CHMR",
	527.21285, "DFHQ",
	527.21285, "EFHN",
	527.22810, "FGHW",
	527.23484, "HKMM",
	527.24521, "DQQR",
	527.24521, "ENQR",
	527.24923, "DFHK",
	527.24923, "HNXY",
	527.24923, "HQVY",
	527.24923, "NNWX",
	527.24923, "NQVW",
	527.25325, "FPPW",
	527.25663, "MPWX",
	527.26047, "AHRY",
	527.26047, "ANRW",
	527.26047, "FHRS",
	527.26047, "GQRW",
	527.27036, "EERX",
	527.27170, "HHPR",
	527.27438, "DWXX",
	527.27438, "EVWX",
	527.28159, "DKQR",
	527.28159, "EKNR",
	527.28562, "HKVY",
	527.28562, "KNVW",
	527.29283, "NRRT",
	527.29283, "QRRS",
	527.29685, "GKRW",
	527.31798, "DKKR",
	527.32921, "KRRS",
	528.15348, "CMMY",
	528.16787, "CDFY",
	528.18247, "EHMM",
	528.18563, "DSYY",
	528.18650, "CFFM",
	528.19686, "DEFH",
	528.20426, "AMYY",
	528.20426, "CVYY",
	528.20426, "FMSY",
	528.20810, "HNNY",
	528.20810, "NNNW",
	528.21549, "HMPY",
	528.21549, "MNPW",
	528.22201, "TTYY",
	528.22922, "DEQR",
	528.22922, "EENR",
	528.23325, "DHXY",
	528.23325, "DNWX",
	528.23325, "DQVW",
	528.23325, "EHVY",
	528.23325, "ENVW",
	528.23727, "AFFY",
	528.23727, "FFFS",
	528.24448, "ADRW",
	528.24448, "EGRW",
	528.24850, "FFHP",
	528.24850, "GVWW",
	528.25187, "FHMX",
	528.25974, "RWW",
	528.26561, "DEKR",
	528.26963, "DKVW",
	528.26963, "QTWX",
	528.27684, "DRRT",
	528.27684, "ERRS",
	528.28087, "FPQR",
	528.28087, "RSVW",
	528.28424, "MQRX",
	528.29547, "CRRX",
	528.30602, "KTWX",
	528.31725, "FKPR",
	528.32062, "KMRX",
	529.15659, "CCHW",
	529.19211, "DHNY",
	529.19211, "DNNW",
	529.19950, "DMPW",
	529.21074, "FHMN",
	529.21324, "DEER",
	529.21726, "DDWX",
	529.21726, "DEVW",
	529.22850, "HQTY",
	529.22850, "NQTW",
	529.22850, "QQSW",
	529.24310, "MNQR",
	529.25365, "ETWX",
	529.25433, "CNRR",
	529.26488, "EFPR",
	529.26488, "HKTY",
	529.26488, "KNTW",
	529.26488, "KQSW",
	529.26825, "EMRX",
	529.26890, "FPVW",
	529.27228, "MVWX",
	529.27949, "KMNR",
	529.28735, "HHRV",
	529.30127, "KKSW",
	529.30127, "PRXY",
	529.33765, "FRXX",
	530.17613, "DDHY",
	530.17613, "DDNW",
	530.18037, "HMMM",
	530.18352, "CTYY",
	530.19475, "DFHM",
	530.21251, "DQTW",
	530.21251, "EHTY",
	530.21251, "ENTW",
	530.21251, "EQSW",
	530.21653, "FGYY",
	530.22712, "DMQR",
	530.22712, "EMNR",
	530.22777, "ASWW",
	530.22777, "GTWW",
	530.23114, "CQWX",
	530.23114, "HMVY",
	530.23114, "MNVW",
	530.23498, "HHQQ",
	530.23835, "CDRR",
	530.24237, "GMRW",
	530.24890, "DKTW",
	530.24890, "EKSW",
	530.26013, "NPRY",
	530.26013, "RSTW",
	530.26350, "DKMR",
	530.26415, "FFHV",
	530.26752, "CKWX",
	530.27136, "HHKQ",
	530.27474, "MRRS",
	530.29652, "FNRX",
	530.29652, "FQRV",
	530.30775, "AFRR",
	530.30775, "HHKK",
	530.33290, "FKRV",
	531.16014, "DDDW",
	531.19000, "CHQY",
	531.19000, "CNQW",
	531.19653, "DETW",
	531.19653, "EESW",
	531.21113, "DEMR",
	531.21515, "CEWX",
	531.21515, "DMVW",
	531.21899, "EHHQ",
	531.22639, "CHKY",
	531.22639, "CKNW",
	531.23425, "AHHW",
	531.24415, "DPRY",
	531.24415, "FQQQ",
	531.24817, "FPTW",
	531.25154, "MTWX",
	531.25538, "EHHK",
	531.25538, "FNNR",
	531.26277, "FMPR",
	531.26614, "MMRX",
	531.26661, "HHRT",
	531.28053, "DFRX",
	531.28053, "EFRV",
	531.28053, "FKQQ",
	531.28455, "FVVW",
	531.31692, "FKKQ",
	531.31692, "RVXY",
	531.35330, "FKKK",
	532.14503, "CCYY",
	532.17402, "CDQW",
	532.17402, "CEHY",
	532.17402, "CENW",
	532.18927, "CGWW",
	532.20301, "EEHH",
	532.21040, "CDKW",
	532.21040, "HMTY",
	532.21040, "MNTW",
	532.21040, "MQSW",
	532.22164, "CRSW",
	532.22501, "MMNR",
	532.22816, "EFQQ",
	532.23940, "DFNR",
	532.24342, "AFQW",
	532.24342, "FFHT",
	532.24679, "KMSW",
	532.26455, "EFKQ",
	532.26455, "QQXY",
	532.27578, "FQRT",
	532.27578, "NRVY",
	532.27980, "AFKW",
	532.28701, "GRRY",
	532.30093, "EFKK",
	532.30093, "KQXY",
	532.31217, "FKRT",
	532.33732, "KKXY",
	533.15803, "CDEW",
	533.19442, "DMTW",
	533.19442, "EMSW",
	533.20902, "DMMR",
	533.20968, "CFPW",
	533.21218, "EEFQ",
	533.21305, "CMWX",
	533.21689, "HHMQ",
	533.22341, "DDFR",
	533.22341, "NQQY",
	533.22743, "AEFW",
	533.22743, "PSWY",
	533.22812, "CHHR",
	533.24856, "EEFK",
	533.24856, "EQXY",
	533.25327, "HHKM",
	533.25980, "DRVY",
	533.25980, "EFRT",
	533.25980, "KNQY",
	533.26382, "AWXY",
	533.26382, "FSWX",
	533.26382, "FTVW",
	533.27505, "HPWX",
	533.27842, "FMRV",
	533.28495, "EKXY",
	533.29618, "KKNY",
	533.29618, "RTXY",
	534.17191, "CHMY",
	534.17191, "CMNW",
	534.19619, "EEEF",
	534.20090, "EHHM",
	534.20492, "CFFH",
	534.20743, "DQQY",
	534.20743, "ENQY",
	534.22268, "AHYY",
	534.22268, "ANWY",
	534.22268, "FHSY",
	534.22268, "FNSW",
	534.22268, "GQWY",
	534.22605, "FMQQ",
	534.23258, "EEXY",
	534.23392, "HHPY",
	534.23392, "HNPW",
	534.23729, "CFQR",
	534.24381, "DKQY",
	534.24381, "EKNY",
	534.25505, "NRTY",
	534.25505, "QRSY",
	534.25907, "GKWY",
	534.26244, "FKMQ",
	534.27030, "FHHX",
	534.27367, "CFKR",
	534.28020, "DKKY",
	534.29143, "KRSY",
	534.29882, "FKKM",
	534.30266, "HQRX",
	534.33905, "HKRX",
	535.15593, "CDMW",
	535.19144, "DEQY",
	535.19144, "EENY",
	535.19231, "MMSW",
	535.20670, "ADWY",
	535.20670, "DFSW",
	535.20670, "EGWY",
	535.21007, "EFMQ",
	535.21793, "DHPW",
	535.22130, "CEFR",
	535.22195, "WWY",
	535.22533, "AFMW",
	535.22533, "CFVW",
	535.22783, "DEKY",
	535.22917, "FHHN",
	535.23906, "DRTY",
	535.23906, "ERSY",
	535.24308, "FPQY",
	535.24308, "FTTW",
	535.24308, "SVWY",
	535.24645, "EFKM",
	535.24645, "MQXY",
	535.25769, "CRXY",
	535.25769, "FMRT",
	535.26153, "HNQR",
	535.27947, "FFQX",
	535.27947, "FKPY",
	535.28284, "KMXY",
	535.28668, "EHRX",
	535.29070, "HVWX",
	535.29791, "HKNR",
	535.31585, "FFKX",
	536.17546, "DEEY",
	536.19408, "EEFM",
	536.19879, "HHMM",
	536.20532, "MNQY",
	536.21318, "DFHH",
	536.21655, "CNRY",
	536.22710, "EFPY",
	536.23047, "EMXY",
	536.23833, "FFNQ",
	536.24170, "KMNY",
	536.24554, "DHQR",
	536.24554, "EHNR",
	536.24957, "HHVY",
	536.24957, "HNVW",
	536.26080, "GHRW",
	536.26348, "EFFX",
	536.26348, "PXYY",
	536.27472, "FFKN",
	536.28193, "DHKR",
	536.28595, "PPRW",
	536.29316, "HRRS",
	536.29987, "FXXY",
	537.18933, "DMQY",
	537.18933, "EMNY",
	537.20057, "CDRY",
	537.20459, "CFTW",
	537.20459, "GMWY",
	537.20796, "FMMQ",
	537.21919, "CFMR",
	537.22235, "DFFQ",
	537.22235, "EFFN",
	537.22235, "NPYY",
	537.22235, "STWY",
	537.22572, "DKMY",
	537.22956, "DEHR",
	537.23358, "DHVW",
	537.23695, "MRSY",
	537.23760, "FFGW",
	537.24435, "FKMM",
	537.25873, "DFFK",
	537.25873, "FNXY",
	537.25873, "FQVY",
	537.26997, "AFRY",
	537.26997, "FFRS",
	537.26997, "HTWX",
	537.28120, "FHPR",
	537.28457, "HMRX",
	537.29512, "FKVY",
	537.31356, "PQRR",
	537.34995, "KPRR",
	538.17335, "DEMY",
	538.19198, "EFMM",
	538.20636, "DEFF",
	538.20636, "DPYY",
	538.21760, "FNNY",
	538.22499, "FMPY",
	538.22836, "MMXY",
	538.22883, "HHTY",
	538.22883, "HNTW",
	538.22883, "HQSW",
	538.24275, "DFXY",
	538.24275, "EFVY",
	538.24343, "HMNR",
	538.25801, "FFFP",
	538.26138, "FFMX",
	538.26522, "HKSW",
	538.27913, "VXYY",
	538.29758, "EPRR",
	538.30160, "PRVW",
	538.37035, "RRXX",
	539.16610, "CCFW",
	539.18385, "CSWY",
	539.18723, "MMNY",
	539.20161, "DFNY",
	539.21285, "DHTW",
	539.21285, "EHSW",
	539.22024, "FFMN",
	539.22745, "DHMR",
	539.23147, "CHWX",
	539.23531, "HHHQ",
	539.23800, "FQTY",
	539.23800, "NVYY",
	539.24923, "GRYY",
	539.24923, "PQQW",
	539.27170, "HHHK",
	539.27438, "FKTY",
	539.28562, "KPQW",
	539.29685, "FHRV",
	539.32200, "KKPW",
	539.32921, "NRRX",
	539.32921, "QRRV",
	539.34045, "ARRR",
	539.36560, "KRRV",
	540.17124, "DMMY",
	540.18563, "DDFY",
	540.18987, "FMMM",
	540.19034, "CHHY",
	540.19034, "CHNW",
	540.20426, "DFFM",
	540.21933, "EHHH",
	540.22201, "DVYY",
	540.22201, "EFTY",
	540.23325, "EPQW",
	540.24064, "FMVY",
	540.24448, "FHQQ",
	540.24850, "APWW",
	540.25840, "TXYY",
	540.26963, "EKPW",
	540.27366, "FFFV",
	540.27684, "QQQR",
	540.28087, "FHKQ",
	540.28087, "PRTW",
	540.28808, "NNRR",
	540.29547, "MPRR",
	540.30602, "QWXX",
	540.31323, "DRRX",
	540.31323, "ERRV",
	540.31323, "KQQR",
	540.31725, "FHKK",
	540.31725, "RVVW",
	540.34240, "KWXX",
	540.34961, "KKQR",
	540.38600, "KKKR",
	541.17435, "CDHW",
	541.19950, "CFQY",
	541.21074, "HMSW",
	541.21726, "EEPW",
	541.21726, "NTYY",
	541.21726, "QSYY",
	541.22850, "EFHQ",
	541.23589, "CFKY",
	541.24375, "AFHW",
	541.25365, "KSYY",
	541.26086, "EQQR",
	541.26488, "EFHK",
	541.26488, "HQXY",
	541.26488, "NQWX",
	541.26488, "QQVW",
	541.27209, "DNRR",
	541.27612, "AQRW",
	541.27612, "FHRT",
	541.29003, "EWXX",
	541.29724, "EKQR",
	541.30127, "HKXY",
	541.30127, "KNWX",
	541.30127, "KQVW",
	541.30848, "QRRT",
	541.31250, "AKRW",
	541.33363, "EKKR",
	541.33765, "KKVW",
	541.34486, "KRRT",
	542.18352, "CEFY",
	542.20128, "DTYY",
	542.20128, "ESYY",
	542.21251, "EEFH",
	542.21722, "HHHM",
	542.21991, "CXYY",
	542.21991, "FMTY",
	542.22375, "HNQY",
	542.22375, "NNQW",
	542.23114, "MPQW",
	542.24237, "CPRW",
	542.24487, "EEQR",
	542.24890, "DQWX",
	542.24890, "EHXY",
	542.24890, "ENWX",
	542.24890, "EQVW",
	542.25292, "FFFT",
	542.25611, "DDRR",
	542.26013, "AERW",
	542.26013, "HKNY",
	542.26013, "KNNW",
	542.26415, "AVWW",
	542.26415, "GWWX",
	542.26752, "KMPW",
	542.28126, "EEKR",
	542.28528, "DKWX",
	542.28528, "EKVW",
	542.29249, "ERRT",
	542.29652, "RSWX",
	542.29652, "RTVW",
	542.31112, "MRRV",
	543.17877, "CNYY",
	543.20776, "DHQY",
	543.20776, "DNQW",
	543.20776, "EHNY",
	543.20776, "ENNW",
	543.21515, "EMPW",
	543.22302, "GHWY",
	543.22302, "GNWW",
	543.22639, "FHMQ",
	543.22889, "EEER",
	543.23291, "DEWX",
	543.23291, "EEVW",
	543.23762, "CFHR",
	543.24415, "DHKY",
	543.24415, "DKNW",
	543.24415, "QQTW",
	543.24817, "PPWY",
	543.25538, "HRSY",
	543.25538, "NRSW",
	543.25875, "MQQR",
	543.26277, "FHKM",
	543.26998, "CQRR",
	543.28053, "KQTW",
	543.28455, "FPWX",
	543.28793, "MWXX",
	543.29514, "KMQR",
	543.30300, "HHRX",
	543.30637, "CKRR",
	543.31692, "KKTW",
	543.33152, "KKMR",
	544.16278, "CDYY",
	544.18141, "CFMY",
	544.19178, "DDQW",
	544.19178, "DEHY",
	544.19178, "DENW",
	544.19917, "MSYY",
	544.20703, "DGWW",
	544.21040, "EFHM",
	544.21443, "CFFF",
	544.22816, "DDKW",
	544.22816, "EQTW",
	544.23218, "AFYY",
	544.23218, "FFSY",
	544.23940, "DRSW",
	544.24277, "EMQR",
	544.24342, "ATWW",
	544.24342, "FHPY",
	544.24342, "FNPW",
	544.24679, "HMXY",
	544.24679, "MNWX",
	544.24679, "MQVW",
	544.25400, "CERR",
	544.25802, "AMRW",
	544.25802, "CRVW",
	544.26186, "HHNR",
	544.26455, "EKTW",
	544.27578, "PQRY",
	544.27578, "RTTW",
	544.27915, "EKMR",
	544.27980, "FFHX",
	544.28317, "KMVW",
	544.29039, "MRRT",
	544.31217, "FQRX",
	544.31217, "KPRY",
	544.34855, "FKRX",
	545.17579, "DDEW",
	545.20565, "CQQW",
	545.20565, "HMNY",
	545.20565, "MNNW",
	545.21218, "EETW",
	545.21305, "MMPW",
	545.22678, "EEMR",
	545.22743, "DFPW",
	545.23080, "DMWX",
	545.23080, "EMVW",
	545.23867, "FFHN",
	545.24204, "CKQW",
	545.24588, "DHHR",
	545.25980, "EPRY",
	545.26382, "PVWY",
	545.27103, "FNQR",
	545.27842, "CKKW",
	545.29618, "EFRX",
	545.30020, "FVWX",
	545.30742, "FKNR",
	545.33257, "RXXY",
	546.18967, "CEQW",
	546.18967, "DHMY",
	546.18967, "DMNW",
	546.20492, "ACWW",
	546.20829, "FHMM",
	546.21145, "GYYY",
	546.22268, "DFFH",
	546.22268, "SSWW",
	546.22605, "CEKW",
	546.22605, "MQTW",
	546.23729, "CRTW",
	546.24066, "MMQR",
	546.25189, "CMRR",
	546.25505, "DFQR",
	546.25505, "EFNR",
	546.25907, "FHVY",
	546.25907, "FNVW",
	546.26244, "KMTW",
	546.27030, "FGRW",
	546.27704, "KMMR",
	546.29143, "DFKR",
	546.29143, "NRXY",
	546.29143, "QRVY",
	546.30266, "ARRY",
	546.30266, "FRRS",
	546.31390, "HPRR",
	546.32782, "KRVY",
	547.17368, "CEEW",
	547.17368, "DDMW",
	547.21007, "EMTW",
	547.22467, "EMMR",
	547.22870, "MMVW",
	547.22917, "HHSW",
	547.23906, "DEFR",
	547.23906, "QQQY",
	547.24308, "DFVW",
	547.24308, "PTWY",
	547.25029, "NNRY",
	547.25769, "MPRY",
	547.27545, "DRXY",
	547.27545, "ERVY",
	547.27545, "KQQY",
	547.27947, "FTWX",
	547.27947, "VVWY",
	547.29070, "FFPR",
	547.29407, "FMRX",
	547.31183, "KKQY",
	547.34822, "KKKY",
	548.18756, "CMQW",
	548.19879, "CCRW",
	548.22308, "EQQY",
	548.22395, "CKMW",
	548.23431, "DNRY",
	548.23565, "HHHH",
	548.23833, "AQWY",
	548.23833, "FHTY",
	548.23833, "FNTW",
	548.23833, "FQSW",
	548.24957, "HPQW",
	548.25294, "FMNR",
	548.25946, "EKQY",
	548.27070, "QRTY",
	548.27472, "AKWY",
	548.27472, "FKSW",
	548.28595, "HKPW",
	548.29585, "EKKY",
	548.30708, "KRTY",
	548.32955, "HRRV",
	549.17158, "CEMW",
	549.20459, "CPWY",
	549.20709, "EEQY",
	549.20796, "MMTW",
	549.21833, "DDRY",
	549.22235, "AEWY",
	549.22235, "DFTW",
	549.22235, "EFSW",
	549.22256, "MMMR",
	549.23358, "EHPW",
	549.23695, "DFMR",
	549.24098, "CFWX",
	549.24348, "EEKY",
	549.24482, "FHHQ",
	549.25471, "ERTY",
	549.25873, "SWXY",
	549.25873, "TVWY",
	549.27334, "MRVY",
	549.27718, "HQQR",
	549.28120, "FHHK",
	549.30635, "FFRV",
	549.30635, "HWXX",
	549.31356, "HKQR",
	549.34995, "HKKR",
	550.19111, "EEEY",
	550.19984, "CFHY",
	550.19984, "CFNW",
	550.21760, "HSYY",
	550.21760, "NSWY",
	550.22097, "MQQY",
	550.22883, "EFHH",
	550.23220, "CQRY",
	550.25398, "FFQQ",
	550.25735, "KMQY",
	550.26119, "EHQR",
	550.26522, "HHXY",
	550.26522, "HNWX",
	550.26522, "HQVW",
	550.26859, "CKRY",
	550.27645, "AHRW",
	550.29037, "FFKQ",
	550.29374, "KKMY",
	550.29758, "EHKR",
	550.30160, "HKVW",
	550.30881, "HRRT",
	550.32675, "FFKK",
	551.16947, "CMMW",
	551.18385, "CDFW",
	551.20161, "DSWY",
	551.20498, "EMQY",
	551.21622, "CERY",
	551.22024, "AMWY",
	551.22024, "CVWY",
	551.22024, "FMSW",
	551.22408, "HHNY",
	551.22408, "HNNW",
	551.23147, "HMPW",
	551.23800, "EFFQ",
	551.23800, "PQYY",
	551.23800, "TTWY",
	551.24137, "EKMY",
	551.24521, "EEHR",
	551.24923, "DHWX",
	551.24923, "EHVW",
	551.25260, "MRTY",
	551.25325, "AFFW",
	551.27438, "EFFK",
	551.27438, "FQXY",
	551.27438, "KPYY",
	551.28562, "FFRT",
	551.31077, "FKXY",
	552.18900, "EEMY",
	552.20810, "DHHY",
	552.20810, "DHNW",
	552.22201, "EEFF",
	552.22201, "EPYY",
	552.22672, "FHHM",
	552.23325, "FNQY",
	552.24448, "HQTW",
	552.25840, "EFXY",
	552.25909, "HMQR",
	552.26963, "FKNY",
	552.27032, "CHRR",
	552.28087, "HKTW",
	552.29479, "XXYY",
	552.29547, "HKMR",
	552.31725, "PRWX",
	553.19211, "DDHW",
	553.19950, "CTWY",
	553.20288, "MMQY",
	553.21411, "CMRY",
	553.21726, "DFQY",
	553.21726, "EFNY",
	553.22850, "EHTW",
	553.23252, "FGWY",
	553.23589, "FFMQ",
	553.23926, "KMMY",
	553.24310, "EHMR",
	553.24712, "CFFR",
	553.24712, "HMVW",
	553.25365, "DFKY",
	553.25365, "NXYY",
	553.25365, "QVYY",
	553.26488, "ARYY",
	553.26488, "FRSY",
	553.27228, "FFKM",
	553.27612, "HPRY",
	553.27612, "NPRW",
	553.29003, "KVYY",
	553.31250, "FHRX",
	553.34486, "QRRX",
	553.38125, "KRRX",
	554.18689, "EMMY",
	554.20128, "DEFY",
	554.20599, "CHQW",
	554.21251, "NNYY",
	554.21991, "EFFM",
	554.21991, "MPYY",
	554.23766, "DXYY",
	554.23766, "EVYY",
	554.24237, "CHKW",
	554.25292, "FFPY",
	554.25629, "FMXY",
	554.26013, "DPRW",
	554.27136, "FHNR",
	554.28931, "FFFX",
	554.30373, "NQRR",
	554.32888, "ERRX",
	554.33290, "RVWX",
	554.34011, "KNRR",
	555.16101, "CCWY",
	555.19000, "CEHW",
	555.19653, "DNYY",
	555.21515, "FMNY",
	555.22639, "HMTW",
	555.23291, "QTYY",
	555.24099, "HMMR",
	555.24817, "FFFN",
	555.25538, "DFHR",
	555.26930, "KTYY",
	555.28053, "QQWX",
	555.28774, "DQRR",
	555.28774, "ENRR",
	555.29177, "HRVY",
	555.29177, "NRVW",
	555.30300, "GRRW",
	555.31692, "KQWX",
	555.32413, "DKRR",
	555.33536, "RRRS",
	555.35330, "KKWX",
	556.18054, "DDYY",
	556.18478, "MMMY",
	556.19917, "DFMY",
	556.21693, "ETYY",
	556.21780, "FFMM",
	556.23218, "DFFF",
	556.23556, "MVYY",
	556.23940, "HQQY",
	556.23940, "NQQW",
	556.24342, "PSWW",
	556.26455, "EQWX",
	556.26857, "FFVY",
	556.27176, "DERR",
	556.27578, "DRVW",
	556.27578, "HKQY",
	556.27578, "KNQW",
	556.27980, "AWWX",
	556.30093, "EKWX",
	556.31217, "HKKY",
	556.31217, "KKNW",
	556.31217, "RTWX",
	556.32340, "FPRR",
	556.32677, "MRRX",
	557.18789, "CHMW",
	557.19442, "CQYY",
	557.22341, "DQQW",
	557.22341, "EHQY",
	557.22341, "ENQW",
	557.23080, "CKYY",
	557.23867, "AHWY",
	557.23867, "ANWW",
	557.23867, "FHSW",
	557.23867, "GQWW",
	557.24856, "EEWX",
	557.24990, "HHPW",
	557.25980, "DKQW",
	557.25980, "EHKY",
	557.25980, "EKNW",
	557.27103, "HRTY",
	557.27103, "NRTW",
	557.27103, "QRSW",
	557.27505, "GKWW",
	557.28563, "MNRR",
	557.29618, "DKKW",
	557.30742, "KRSW",
	558.17843, "CEYY",
	558.20743, "DEQW",
	558.20743, "EEHY",
	558.20743, "EENW",
	558.21482, "MTYY",
	558.22268, "ADWW",
	558.22268, "EGWW",
	558.23794, "WWW",
	558.24381, "DEKW",
	558.24515, "FHHH",
	558.24783, "FFTY",
	558.25505, "DRTW",
	558.25505, "ERSW",
	558.25907, "FPQW",
	558.25907, "SVWW",
	558.26244, "MQWX",
	558.26965, "DMRR",
	558.27367, "CRWX",
	558.27751, "HHQR",
	558.29545, "FKPW",
	558.29882, "KMWX",
	558.31390, "HHKR",
	558.33905, "FRRV",
	559.19144, "DEEW",
	559.22130, "HMQY",
	559.22130, "MNQW",
	559.23254, "CHRY",
	559.23254, "CNRW",
	559.24308, "EFPW",
	559.24645, "EMWX",
	559.25432, "FFHQ",
	559.25769, "HKMY",
	559.25769, "KMNW",
	559.26153, "EHHR",
	559.26555, "HHVW",
	559.27947, "PWXY",
	559.28668, "FQQR",
	559.29070, "FFHK",
	559.31585, "FWXX",
	559.32307, "FKQR",
	559.35945, "FKKR",
	560.17633, "CMYY",
	560.20532, "DMQW",
	560.20532, "EHMY",
	560.20532, "EMNW",
	560.20934, "CFFY",
	560.21655, "CDRW",
	560.22057, "GMWW",
	560.22710, "AYYY",
	560.22710, "FSYY",
	560.23833, "EFFH",
	560.23833, "HPYY",
	560.23833, "NPWY",
	560.23833, "STWW",
	560.24170, "DKMW",
	560.25294, "MRSW",
	560.27070, "EFQR",
	560.27472, "FHXY",
	560.27472, "FNWX",
	560.27472, "FQVW",
	560.28595, "AFRW",
	560.30708, "EFKR",
	560.30708, "QRXY",
	560.31110, "FKVW",
	560.31831, "FRRT",
	560.34347, "KRXY",
	561.18933, "DEMW",
	561.22235, "DPWY",
	561.23358, "FHNY",
	561.23358, "FNNW",
	561.24098, "FMPW",
	561.24435, "MMWX",
	561.24482, "HHTW",
	561.25471, "EEFR",
	561.25873, "DFWX",
	561.25873, "EFVW",
	561.25942, "HHMR",
	561.26594, "NQRY",
	561.29110, "ERXY",
	561.29512, "VWXY",
	561.30233, "KNRY",
	562.19984, "CSWW",
	562.20321, "HMMY",
	562.20321, "MMNW",
	562.21760, "DFHY",
	562.21760, "DFNW",
	562.23622, "FFHM",
	562.24996, "DQRY",
	562.24996, "ENRY",
	562.25398, "FQTW",
	562.25398, "HVYY",
	562.25398, "NVWY",
	562.26522, "GRWY",
	562.26859, "FMQR",
	562.27982, "CFRR",
	562.28635, "DKRY",
	562.29037, "FKTW",
	562.29758, "RRSY",
	562.30497, "FKMR",
	562.34520, "HRRX",
	563.18723, "DMMW",
	563.20161, "DDFW",
	563.20632, "CHHW",
	563.23398, "DERY",
	563.23800, "DVWY",
	563.23800, "EFTW",
	563.25260, "EFMR",
	563.25663, "FMVW",
	563.27438, "TWXY",
	563.28562, "FPRY",
	563.28899, "MRXY",
	563.30406, "HNRR",
	563.32200, "FFRX",
	564.21549, "CFQW",
	564.23325, "HTYY",
	564.23325, "NTWY",
	564.23325, "QSWY",
	564.24785, "MNRY",
	564.25187, "CFKW",
	564.26963, "KSWY",
	564.28087, "FFNR",
	564.28087, "HQWX",
	564.28808, "DHRR",
	564.31725, "HKWX",
	565.19950, "CEFW",
	565.21726, "DTWY",
	565.21726, "ESWY",
	565.23187, "DMRY",
	565.23589, "CWXY",
	565.23589, "FMTW",
	565.23973, "HHQY",
	565.23973, "HNQW",
	565.25049, "FMMR",
	565.26488, "DFFR",
	565.26488, "EHWX",
	565.27612, "HHKY",
	565.27612, "HKNW",
	565.30127, "FRVY",
	565.35610, "PRRR",
	566.19475, "CHYY",
	566.19475, "CNWY",
	566.22375, "DHQW",
	566.22375, "EHHY",
	566.22375, "EHNW",
	566.23900, "GHWW",
	566.24890, "FQQY",
	566.26013, "DHKW",
	566.26415, "PPWW",
	566.27136, "HRSW",
	566.28528, "FKQY",
	566.32167, "FKKY",
	567.17877, "CDWY",
	567.19740, "CFMW",
	567.20776, "DEHW",
	567.21515, "MSWY",
	567.23291, "EFQY",
	567.24817, "AFWY",
	567.24817, "FFSW",
	567.25940, "FHPW",
	567.26277, "HMWX",
	567.26930, "EFKY",
	567.26930, "QXYY",
	567.27785, "HHHR",
	567.28053, "FRTY",
	567.29177, "PQRW",
	567.30568, "KXYY",
	567.32815, "KPRW",
	567.37175, "RRRV",
	568.21693, "EEFY",
	568.22164, "HHMY",
	568.22164, "HMNW",
	568.22816, "NQYY",
	568.25331, "EXYY",
	568.25465, "FFHH",
	568.26455, "KNYY",
	568.27578, "EPRW",
	568.27980, "PVWW",
	568.28701, "FHQR",
	568.31938, "QQRR",
	568.32340, "FHKR",
	568.34855, "RWXX",
	568.35576, "KQRR",
	568.39215, "KKRR",
	569.20565, "DHMW",
	569.21218, "DQYY",
	569.21218, "ENYY",
	569.22743, "GWYY",
	569.23080, "FMQY",
	569.24204, "CFRY",
	569.24856, "DKYY",
	569.25980, "RSYY",
	569.26382, "FFFQ",
	569.26719, "FKMY",
	569.27103, "EFHR",
	569.27505, "FHVW",
	569.30020, "FFFK",
	569.30339, "EQRR",
	569.30742, "HRXY",
	569.30742, "NRWX",
	569.30742, "QRVW",
	569.31865, "ARRW",
	569.33978, "EKRR",
	569.34380, "KRVW",
	569.35101, "RRRT",
	570.19619, "DEYY",
	570.21482, "EFMY",
	570.24783, "EFFF",
	570.24783, "FPYY",
	570.25121, "MXYY",
	570.25505, "QQQW",
	570.25907, "PTWW",
	570.26628, "HNRY",
	570.26628, "NNRW",
	570.27367, "MPRW",
	570.28422, "FFXY",
	570.28741, "EERR",
	570.29143, "DRWX",
	570.29143, "ERVW",
	570.29143, "KQQW",
	570.29545, "VVWW",
	570.32782, "KKQW",
	570.36420, "KKKW",
	571.21007, "MNYY",
	571.23906, "EQQW",
	571.24308, "FFNY",
	571.25029, "DHRY",
	571.25029, "DNRW",
	571.25432, "AQWW",
	571.25432, "FHTW",
	571.26892, "FHMR",
	571.27545, "EKQW",
	571.28668, "QRTW",
	571.29070, "AKWW",
	571.30128, "MQRR",
	571.31183, "EKKW",
	571.31252, "CRRR",
	571.32307, "KRTW",
	571.33767, "KMRR",
	572.19408, "DMYY",
	572.21271, "FMMY",
	572.22057, "CPWW",
	572.22308, "EEQW",
	572.22710, "DFFY",
	572.23431, "DDRW",
	572.23833, "AEWW",
	572.24573, "FFFM",
	572.25946, "EEKW",
	572.26348, "FVYY",
	572.27070, "ERTW",
	572.27472, "SWWX",
	572.27472, "TVWW",
	572.28530, "EMRR",
	572.28932, "MRVW",
	572.31831, "PRRY",
	572.35470, "FRRX",
	573.20709, "EEEW",
	573.21582, "CFHW",
	573.23358, "HSWY",
	573.23358, "NSWW",
	573.23695, "MQQW",
	573.24819, "CQRW",
	573.27334, "KMQW",
	573.28120, "HHWX",
	573.28457, "CKRW",
	573.30972, "KKMW",
	573.31356, "FNRR",
	574.21760, "DSWW",
	574.22097, "EMQW",
	574.23220, "CERW",
	574.23622, "AMWW",
	574.23622, "CVWW",
	574.24006, "HHHY",
	574.24006, "HHNW",
	574.24275, "FTYY",
	574.25398, "PQWY",
	574.25398, "TTWW",
	574.25735, "EKMW",
	574.26859, "MRTW",
	574.28319, "MMRR",
	574.29037, "FQWX",
	574.29037, "KPWY",
	574.29758, "DFRR",
	574.32675, "FKWX",
	574.33396, "RRVY",
	575.20498, "EEMW",
	575.22408, "DHHW",
	575.23800, "EPWY",
	575.24923, "FHQY",
	575.24923, "FNQW",
	575.27438, "EFWX",
	575.28159, "QQRY",
	575.28562, "FHKY",
	575.28562, "FKNW",
	575.31077, "WXXY",
	575.31798, "KQRY",
	575.35437, "KKRY",
	576.20426, "CFYY",
	576.21549, "CTWW",
	576.21886, "MMQW",
	576.22201, "SYYY",
	576.23009, "CMRW",
	576.23325, "DFQW",
	576.23325, "EFHY",
	576.23325, "EFNW",
	576.24850, "FGWW",
	576.25525, "KMMW",
	576.26561, "EQRY",
	576.26963, "DFKW",
	576.26963, "HXYY",
	576.26963, "NWXY",
	576.26963, "QVWY",
	576.28087, "ARWY",
	576.28087, "FRSW",
	576.29210, "HPRW",
	576.30200, "EKRY",
	576.30602, "KVWY",
	576.31323, "RRTY",
	577.20288, "EMMW",
	577.21726, "DEFW",
	577.22850, "HNYY",
	577.22850, "NNWY",
	577.23589, "MPWY",
	577.24963, "EERY",
	577.25365, "DWXY",
	577.25365, "EVWY",
	577.26890, "FFPW",
	577.27228, "FMWX",
	577.28735, "FHHR",
	577.31971, "HQRR",
	577.35610, "HKRR",
	578.17699, "CCWW",
	578.21251, "DHYY",
	578.21251, "DNWY",
	578.23114, "FHMY",
	578.23114, "FMNW",
	578.24890, "QTWY",
	578.26350, "MQRY",
	578.26415, "FFFH",
	578.27474, "CRRY",
	578.28528, "KTWY",
	578.29652, "FFQR",
	578.29989, "KMRY",
	578.30373, "EHRR",
	578.30775, "HRVW",
	578.33290, "FFKR",
	579.19653, "DDWY",
	579.20077, "MMMW",
	579.21515, "DFMW",
	579.23291, "ETWY",
	579.24752, "EMRY",
	579.25154, "MVWY",
	579.25538, "HQQW",
	579.28053, "EFFR",
	579.28053, "PRYY",
	579.28455, "FFVW",
	579.29177, "HKQW",
	579.31692, "FRXY",
	579.32815, "HKKW",
	580.21040, "CQWY",
	580.23940, "EHQW",
	580.24679, "CKWY",
	580.25465, "AHWW",
	580.27578, "EHKW",
	580.27578, "FNRY",
	580.28701, "HRTW",
	580.30162, "HMRR",
	581.19442, "CEWY",
	581.22341, "EEHW",
	581.23080, "MTWY",
	581.24541, "MMRY",
	581.25980, "DFRY",
	581.26382, "FFTW",
	581.27842, "FFMR",
	581.29618, "RVYY",
	581.38740, "RRRX",
	582.23729, "HMQW",
	582.24381, "QQYY",
	582.24852, "CHRW",
	582.27367, "HKMW",
	582.28020, "KQYY",
	582.29545, "PWWX",
	582.31658, "KKYY",
	582.34626, "NRRR",
	583.19231, "CMWY",
	583.22130, "EHMW",
	583.22533, "CFFW",
	583.22783, "EQYY",
	583.24308, "AWYY",
	583.24308, "FSWY",
	583.25432, "HPWY",
	583.25432, "NPWW",
	583.26421, "EKYY",
	583.27545, "RTYY",
	583.29070, "FHWX",
	583.32307, "QRWX",
	583.33028, "DRRR",
	583.35945, "KRWX",
	584.21184, "EEYY",
	584.23833, "DPWW",
	584.24957, "FHHY",
	584.24957, "FHNW",
	584.28193, "HQRY",
	584.28193, "NQRW",
	584.30708, "ERWX",
	584.31110, "VWWX",
	584.31831, "HKRY",
	584.31831, "KNRW",
	585.21919, "HMMW",
	585.22572, "MQYY",
	585.23358, "DFHW",
	585.23695, "CRYY",
	585.25873, "FFQY",
	585.26210, "KMYY",
	585.26594, "DQRW",
	585.26594, "EHRY",
	585.26594, "ENRW",
	585.26997, "HVWY",
	585.26997, "NVWW",
	585.28120, "GRWW",
	585.29512, "FFKY",
	585.30233, "DKRW",
	585.31356, "RRSW",
	586.20973, "EMYY",
	586.24275, "EFFY",
	586.24275, "PYYY",
	586.24996, "DERW",
	586.25398, "DVWW",
	586.27913, "FXYY",
	586.29037, "TWWX",
	586.30160, "FPRW",
	586.30497, "MRWX",
	586.32005, "HHRR",
	587.23800, "FNYY",
	587.24923, "HTWY",
	587.24923, "NTWW",
	587.24923, "QSWW",
	587.26384, "HMRY",
	587.26384, "MNRW",
	587.28562, "KSWW",
	587.29685, "FFHR",
	587.32921, "FQRR",
	587.36560, "FKRR",
	588.20763, "MMYY",
	588.22201, "DFYY",
	588.23325, "DTWW",
	588.23325, "ESWW",
	588.24064, "FFMY",
	588.24785, "DMRW",
	588.25187, "CWWX",
	588.25571, "HHQW",
	588.25840, "VYYY",
	588.27366, "FFFF",
	588.29210, "HHKW",
	588.31323, "EFRR",
	588.31725, "FRVW",
	588.34961, "RRXY",
	589.21074, "CHWY",
	589.21074, "CNWW",
	589.23973, "EHHW",
	589.26488, "FQQW",
	589.30127, "FKQW",
	589.30848, "NRRY",
	589.33765, "FKKW",
	590.19475, "CDWW",
	590.23114, "MSWW",
	590.23766, "TYYY",
	590.24890, "EFQW",
	590.26415, "AFWW",
	590.28528, "EFKW",
	590.28528, "QWXY",
	590.29249, "DRRY",
	590.29652, "FRTW",
	590.31112, "FMRR",
	590.32167, "KWXY",
	591.23291, "EEFW",
	591.23762, "HHMW",
	591.24415, "HQYY",
	591.24415, "NQWY",
	591.26930, "EWXY",
	591.28053, "HKYY",
	591.28053, "KNWY",
	592.19917, "CYYY",
	592.22816, "DQWY",
	592.22816, "EHYY",
	592.22816, "ENWY",
	592.24342, "GWWY",
	592.24679, "FMQW",
	592.25802, "CFRW",
	592.26455, "DKWY",
	592.27578, "RSWY",
	592.28317, "FKMW",
	592.32340, "HRWX",
	593.21218, "DEWY",
	593.23080, "EFMW",
	593.26382, "FPWY",
	593.26719, "MWXY",
	593.28226, "HHRY",
	593.28226, "HNRW",
	593.30020, "FFWX",
	594.22605, "HMYY",
	594.22605, "MNWY",
	594.25907, "FFHY",
	594.25907, "FFNW",
	594.26628, "DHRW",
	594.29143, "FQRY",
	594.32782, "FKRY",
	595.21007, "DMWY",
	595.22870, "FMMW",
	595.24308, "DFFW",
	595.27545, "EFRY",
	595.27947, "FVWY",
	595.31183, "RXYY",
	595.33430, "PRRW",
	596.24957, "HSWW",
	596.27070, "NRYY",
	596.32955, "FHRR",
	596.36191, "QRRR",
	596.39830, "KRRR",
	597.25471, "DRYY",
	597.25605, "HHHW",
	597.25873, "FTWY",
	597.26997, "PQWW",
	597.27334, "FMRY",
	597.30635, "FFFR",
	597.30635, "KPWW",
	597.34593, "ERRR",
	597.34995, "RRVW",
	598.25398, "EPWW",
	598.26522, "FHQW",
	598.29758, "QQRW",
	598.30160, "FHKW",
	598.32675, "WWXX",
	598.33396, "KQRW",
	598.37035, "KKRW",
	599.22024, "CFWY",
	599.23800, "SWYY",
	599.24923, "EFHW",
	599.28159, "EQRW",
	599.28562, "HWXY",
	599.28562, "NWWX",
	599.28562, "QVWW",
	599.29685, "ARWW",
	599.31798, "EKRW",
	599.32200, "KVWW",
	599.32921, "RRTW",
	599.34382, "MRRR",
	600.24448, "HHYY",
	600.24448, "HNWY",
	600.24448, "NNWW",
	600.25187, "MPWW",
	600.26561, "EERW",
	600.26963, "DWWX",
	600.26963, "EVWW",
	601.22850, "DHWY",
	601.22850, "DNWW",
	601.24712, "FHMW",
	601.25365, "FQYY",
	601.26488, "QTWW",
	601.27949, "MQRW",
	601.29003, "FKYY",
	601.29072, "CRRW",
	601.30127, "KTWW",
	601.31587, "KMRW",
	602.21251, "DDWW",
	602.23766, "EFYY",
	602.24890, "ETWW",
	602.26350, "EMRW",
	602.26752, "MVWW",
	602.27405, "XYYY",
	602.29652, "PRWY",
	602.33290, "FRWX",
	603.22639, "CQWW",
	603.23291, "NYYY",
	603.26277, "CKWW",
	603.29177, "FHRY",
	603.29177, "FNRW",
	603.32413, "QRRY",
	603.36051, "KRRY",
	604.21040, "CEWW",
	604.21693, "DYYY",
	604.23556, "FMYY",
	604.24679, "MTWW",
	604.26139, "MMRW",
	604.26857, "FFFY",
	604.27578, "DFRW",
	604.30814, "ERRY",
	604.31217, "RVWY",
	605.25980, "QQWY",
	605.29618, "KQWY",
	605.33257, "KKWY",
	605.36224, "HRRR",
	606.20829, "CMWW",
	606.24381, "EQWY",
	606.25907, "AWWY",
	606.25907, "FSWW",
	606.27030, "HPWW",
	606.28020, "EKWY",
	606.29143, "RTWY",
	606.30604, "MRRY",
	606.33905, "FFRR",
	607.22783, "EEWY",
	607.26555, "FHHW",
	607.29791, "HQRW",
	607.33430, "HKRW",
	608.24170, "MQWY",
	608.25294, "CRWY",
	608.27472, "FFQW",
	608.27809, "KMWY",
	608.28193, "EHRW",
	608.28595, "HVWW",
	608.31110, "FFKW",
	609.22572, "EMWY",
	609.25873, "EFFW",
	609.25873, "PWYY",
	609.29512, "FWXY",
	610.25398, "FHYY",
	610.25398, "FNWY",
	610.26522, "HTWW",
	610.27982, "HMRW",
	610.28635, "QRYY",
	610.32273, "KRYY",
	611.22361, "MMWY",
	611.23800, "DFWY",
	611.25663, "FFMW",
	611.27036, "ERYY",
	611.27438, "VWYY",
	611.36560, "RRWX",
	612.22672, "CHWW",
	612.32446, "HRRY",
	612.32446, "NRRW",
	613.25365, "TWYY",
	613.26825, "MRYY",
	613.30127, "FFRY",
	613.30127, "QWWX",
	613.30848, "DRRW",
	613.33765, "KWWX",
	614.26013, "HQWY",
	614.26013, "NQWW",
	614.28528, "EWWX",
	614.29652, "HKWY",
	614.29652, "KNWW",
	615.21515, "CWYY",
	615.24415, "DQWW",
	615.24415, "EHWY",
	615.24415, "ENWW",
	615.25940, "GWWW",
	615.28053, "DKWW",
	615.29177, "RSWW",
	615.37175, "FRRR",
	616.22816, "DEWW",
	616.27980, "FPWW",
	616.28317, "MWWX",
	616.29825, "HHRW",
	617.24204, "HMWY",
	617.24204, "MNWW",
	617.24856, "QYYY",
	617.27505, "FFHW",
	617.28495, "KYYY",
	617.30742, "FQRW",
	617.34380, "FKRW",
	618.22605, "DMWW",
	618.23258, "EYYY",
	618.29143, "EFRW",
	618.29545, "FVWW",
	618.32782, "RWXY",
	619.28668, "HRYY",
	619.28668, "NRWY",
	620.23047, "MYYY",
	620.26348, "FFYY",
	620.27070, "DRWY",
	620.27472, "FTWW",
	620.28932, "FMRW",
	622.23622, "CFWW",
	622.25398, "SWWY",
	622.30160, "HWWX",
	622.33396, "FRRY",
	623.26047, "HHWY",
	623.26047, "HNWW",
	624.24448, "DHWW",
	624.26963, "FQWY",
	624.30602, "FKWY",
	624.40444, "RRRR",
	625.25365, "EFWY",
	625.29003, "WXYY",
	625.31250, "PRWW",
	626.24890, "HYYY",
	626.24890, "NWYY",
	626.30775, "FHRW",
	626.34011, "QRRW",
	626.37650, "KRRW",
	627.23291, "DWYY",
	627.25154, "FMWY",
	627.28455, "FFFW",
	627.32413, "ERRW",
	627.32815, "RVWW",
	628.27578, "QQWW",
	628.31217, "KQWW",
	628.34855, "KKWW",
	629.25980, "EQWW",
	629.27505, "AWWW",
	629.29618, "EKWW",
	629.29618, "FRYY",
	629.30742, "RTWW",
	629.32202, "MRRW",
	630.24381, "EEWW",
	631.25769, "MQWW",
	631.26892, "CRWW",
	631.29407, "KMWW",
	631.36666, "RRRY",
	632.24170, "EMWW",
	632.27472, "PWWY",
	632.31110, "FWWX",
	633.26997, "FHWY",
	633.26997, "FNWW",
	633.30233, "QRWY",
	633.33872, "KRWY",
	634.23960, "MMWW",
	634.25398, "DFWW",
	634.28635, "ERWY",
	634.29037, "VWWY",
	635.34045, "HRRW",
	636.25840, "FYYY",
	636.26963, "TWWY",
	636.28424, "MRWY",
	636.31725, "FFRW",
	637.27612, "HQWW",
	637.31250, "HKWW",
	638.23114, "CWWY",
	638.26013, "EHWW",
	638.32888, "RRYY",
	640.25802, "HMWW",
	640.26455, "QWYY",
	640.30093, "KWYY",
	641.24856, "EWYY",
	641.34380, "RWWX",
	642.30266, "HRWY",
	642.30266, "NRWW",
	643.24645, "MWYY",
	643.27947, "FFWY",
	643.28668, "DRWW",
	645.26997, "SWWW",
	645.29110, "RYYY",
	645.34995, "FRRW",
	646.27645, "HHWW",
	647.28562, "FQWW",
	647.32200, "FKWW",
	648.26963, "EFWW",
	648.30602, "WWXY",
	649.26488, "HWYY",
	649.26488, "NWWY",
	650.24890, "DWWY",
	650.26752, "FMWW",
	652.25331, "YYYY",
	652.31217, "FRWY",
	654.38265, "RRRW",
	655.29070, "PWWW",
	656.28595, "FHWW",
	656.31831, "QRWW",
	656.35470, "KRWW",
	657.30233, "ERWW",
	657.30635, "VWWW",
	659.27438, "FWYY",
	659.28562, "TWWW",
	659.30022, "MRWW",
	661.24712, "CWWW",
	661.34486, "RRWY",
	663.28053, "QWWY",
	663.31692, "KWWY",
	664.26455, "EWWY",
	665.31865, "HRWW",
	666.26244, "MWWY",
	666.29545, "FFWW",
	668.30708, "RWYY",
	671.32200, "WWWX",
	672.28087, "HWWY",
	672.28087, "NWWW",
	673.26488, "DWWW",
	675.26930, "WYYY",
	675.32815, "FRWW",
	682.29037, "FWWY",
	684.36085, "RRWW",
	686.29652, "QWWW",
	686.33290, "KWWW",
	687.28053, "EWWW",
	689.27842, "MWWW",
	691.32307, "RWWY",
	695.29685, "HWWW",
	698.28528, "WWYY",
	705.30635, "FWWW",
	714.33905, "RWWW",
	721.30127, "WWWY",
	744.31725, "WWWW",
};


double lookup[128] = {
	0, /* 0  */
	0, /* 1  */
	0, /* 2  */
	0, /* 3  */
	0, /* 4  */
	0, /* 5  */
	0, /* 6  */
	0, /* 7  */
	0, /* 8  */
	0, /* 9  */
	0, /* 10  */
	0, /* 11  */
	0, /* 12  */
	0, /* 13  */
	0, /* 14  */
	0, /* 15  */
	0, /* 16  */
	0, /* 17  */
	0, /* 18  */
	0, /* 19  */
	0, /* 20  */
	0, /* 21  */
	0, /* 22  */
	0, /* 23  */
	0, /* 24  */
	0, /* 25  */
	0, /* 26  */
	0, /* 27  */
	0, /* 28  */
	0, /* 29  */
	0, /* 30  */
	0, /* 31  */
	0, /* 32  */
	0, /* 33  */
	0, /* 34  */
	0, /* 35  */
	0, /* 36  */
	0, /* 37  */
	0, /* 38  */
	0, /* 39  */
	0, /* 40  */
	0, /* 41  */
	0, /* 42  */
	0, /* 43  */
	0, /* 44  */
	0, /* 45  */
	0, /* 46  */
	0, /* 47  */
	0, /* 48  */
	0, /* 49  */
	0, /* 50  */
	0, /* 51  */
	0, /* 52  */
	0, /* 53  */
	0, /* 54  */
	0, /* 55  */
	0, /* 56  */
	0, /* 57  */
	0, /* 58  */
	0, /* 59  */
	0, /* 60  */
	0, /* 61  */
	0, /* 62  */
	0, /* 63  */
	0, /* 64  */
	71.0371137878, /* 65  A  */
	0, /* 66  */
	103.0091844778, /* 67  C  */
	115.026943032, /* 68  D  */
	129.0425930962, /* 69  E  */
	147.0684139162, /* 70  F  */
	57.0214637236, /* 71  G  */
	137.0589118624, /* 72  H  */
	0, /* 73  */
	0, /* 74  */
	128.0949630177, /* 75  K  */
	0, /* 76  */
	131.0404846062, /* 77  M  */
	114.0429274472, /* 78  N  */
	0, /* 79  */
	97.052763852, /* 80  P  */
	128.0585775114, /* 81  Q  */
	156.1011110281, /* 82  R  */
	87.0320284099, /* 83  S  */
	101.0476784741, /* 84  T  */
	0, /* 85  */
	99.0684139162, /* 86  V  */
	186.0793129535, /* 87  W  */
	113.0840639804, /* 88  X  */
	163.0633285383, /* 89  Y  */
	0, /* 90  */
	0, /* 91  */
	0, /* 92  */
	0, /* 93  */
	0, /* 94  */
	0, /* 95  */
	0, /* 96  */
	0, /* 97  */
	0, /* 98  */
	0, /* 99  */
	0, /* 100  */
	0, /* 101  */
	0, /* 102  */
	0, /* 103  */
	0, /* 104  */
	0, /* 105  */
	0, /* 106  */
	0, /* 107  */
	0, /* 108  */
	0, /* 109  */
	0, /* 110  */
	0, /* 111  */
	0, /* 112  */
	0, /* 113  */
	0, /* 114  */
	0, /* 115  */
	0, /* 116  */
	0, /* 117  */
	0, /* 118  */
	0, /* 119  */
	0, /* 120  */
	0, /* 121  */
	0, /* 122  */
	0, /* 123  */
	0, /* 124  */
	0, /* 125  */
	0, /* 126  */
	0 /* 127  */
};

int primeLookup[128] = {
	0, /* 0  */
	0, /* 1  */
	0, /* 2  */
	0, /* 3  */
	0, /* 4  */
	0, /* 5  */
	0, /* 6  */
	0, /* 7  */
	0, /* 8  */
	0, /* 9  */
	0, /* 10  */
	0, /* 11  */
	0, /* 12  */
	0, /* 13  */
	0, /* 14  */
	0, /* 15  */
	0, /* 16  */
	0, /* 17  */
	0, /* 18  */
	0, /* 19  */
	0, /* 20  */
	0, /* 21  */
	0, /* 22  */
	0, /* 23  */
	0, /* 24  */
	0, /* 25  */
	0, /* 26  */
	0, /* 27  */
	0, /* 28  */
	0, /* 29  */
	0, /* 30  */
	0, /* 31  */
	0, /* 32  */
	0, /* 33  */
	0, /* 34  */
	0, /* 35  */
	0, /* 36  */
	0, /* 37  */
	0, /* 38  */
	0, /* 39  */
	0, /* 40  */
	0, /* 41  */
	0, /* 42  */
	0, /* 43  */
	0, /* 44  */
	0, /* 45  */
	0, /* 46  */
	0, /* 47  */
	0, /* 48  */
	0, /* 49  */
	0, /* 50  */
	0, /* 51  */
	0, /* 52  */
	0, /* 53  */
	0, /* 54  */
	0, /* 55  */
	0, /* 56  */
	0, /* 57  */
	0, /* 58  */
	0, /* 59  */
	0, /* 60  */
	0, /* 61  */
	0, /* 62  */
	0, /* 63  */
	0, /* 64  */
	3, /* 65  A  */
	0, /* 66  */
	17, /* 67  C  */
	29, /* 68  D  */
	41, /* 69  E  */
	53, /* 70  F  */
	2, /* 71  G  */
	47, /* 72  H  */
	0, /* 73  */
	0, /* 74  */
	37, /* 75  K  */
	0, /* 76  */
	43, /* 77  M  */
	23, /* 78  N  */
	0, /* 79  */
	7, /* 80  P  */
	31, /* 81  Q  */
	59, /* 82  R  */
	5, /* 83  S  */
	13, /* 84  T  */
	0, /* 85  */
	11, /* 86  V  */
	67, /* 87  W  */
	19, /* 88  X  */
	61, /* 89  Y  */
	0, /* 90  */
	0, /* 91  */
	0, /* 92  */
	0, /* 93  */
	0, /* 94  */
	0, /* 95  */
	0, /* 96  */
	0, /* 97  */
	0, /* 98  */
	0, /* 99  */
	0, /* 100  */
	0, /* 101  */
	0, /* 102  */
	0, /* 103  */
	0, /* 104  */
	0, /* 105  */
	0, /* 106  */
	0, /* 107  */
	0, /* 108  */
	0, /* 109  */
	0, /* 110  */
	0, /* 111  */
	0, /* 112  */
	0, /* 113  */
	0, /* 114  */
	0, /* 115  */
	0, /* 116  */
	0, /* 117  */
	0, /* 118  */
	0, /* 119  */
	0, /* 120  */
	0, /* 121  */
	0, /* 122  */
	0, /* 123  */
	0, /* 124  */
	0, /* 125  */
	0, /* 126  */
	0 /* 127  */
};

#ifdef WIN
typedef unsigned long Uverylong;
#else
typedef unsigned long long Uverylong;
#endif /* WIN */

#define UVLONG_MAX_8    18446744073709551615UL
#define UVLONG_MAX_4    4294967295UL

#define UVLONG_MAX (sizeof(Uverylong) >= 8 ? UVLONG_MAX_8 : UVLONG_MAX_4)
#define DANGER_ZONE (UVLONG_MAX/67)


static
Uverylong static_computePrimeProduct(char *peptide)
{
	Uverylong retval = 1;
	Uverylong temp;
#ifdef OVERFLOW_DEBUG
char *origpeptide = peptide;
#endif

	while (*peptide) {
		if (retval < DANGER_ZONE) {
			retval *= primeLookup[*peptide++];
		} else {
#ifdef OVERFLOW_DEBUG
printf("In danger zone %s, residual :%s:\n", origpeptide, peptide);
#endif
			temp = primeLookup[*peptide++];
			if (retval >= (UVLONG_MAX/temp)) {
#ifdef OVERFLOW_DEBUG
printf("Hit overflow %s\n", origpeptide);
#endif
				return 0;
			}
			retval *= temp;
		}
	}

	return retval;
}

/* compute many prime multiples, but give up early if any of them fail, and return and non-positive value */
static
int
static_computeManyPrimeProducts(char *peptides[], Uverylong retvals[], int count)
{
	int i;
	Uverylong val;

	for (i = 0; i < count; i++) {
		val = static_computePrimeProduct(peptides[i]);
		if (val == 0) {
			return (-i);
		}
		retvals[i] = val;
	}

	return count;
}

static NodePtr newNode(int data){

	NodePtr node = (NodePtr) malloc(sizeof(Node));
	node->value = data;
	node->left = NULL;
	node->right = NULL;

	return(node);
}

static NodePtr root = NULL;
static char *aa_syms = "ACDEFGHKMNPQRSTVWXY";


MODULE = MassSpec::CUtilities		PACKAGE = MassSpec::CUtilities		
double
computePeptideMass(peptide)
	char *peptide
	CODE:
		RETVAL= 0.0;
	
		do {
			RETVAL += lookup[*peptide++];
		} while (*peptide);
	OUTPUT:
		RETVAL

int
initDecoderTree(Huffman_code,values)
	AV *Huffman_code
	AV *values
	CODE:
#ifdef WIN
{
#endif
		int i;
		char *p;
		int count;
		SV **hc;
		SV **hv;
		STRLEN len;
		NodePtr cptr;

		RETVAL = 0;

		root = newNode(-2);
		cptr = root;

		count = av_len(Huffman_code);

		for (i = 0; i <= count; i++) {
			hc = av_fetch(Huffman_code,i,0);
			p = SvPV(*hc,len);
			hv = av_fetch(values,i,0);
#ifdef CUTILITIES_DEBUG
printf("Huffman code %s, value %ld\n", p, (long) SvIV(*hv));
#endif
			for (; *p; p++) {
				if (*p == '0') {
					if (!cptr->left) cptr->left = newNode(-2);
					cptr = cptr->left;
				} else {
					if (!cptr->right) cptr->right = newNode(-2);
					cptr = cptr->right;
				}
			}
			cptr->value = SvIV(*hv);
			if (cptr->value == -1) RETVAL = 1; /* must see at least one -1 stop code */
			cptr = root;
		}
#ifdef WIN
}
#endif
	OUTPUT:
		RETVAL

char *
fast_decode(encoded,len)
	unsigned char *encoded
	int len
	CODE:
		unsigned char *byteptr = encoded;
		unsigned char *maxptr = encoded + len;
		int done, i;
		unsigned char thebyte;
		
		int alpha_index = 0;
		int k = 0;
		struct node* curptr = root;

		char answer[50];
		
		for (done = 0; byteptr < maxptr && !done; byteptr++) {
			 thebyte = *byteptr;
#ifdef CUTILITIES_DEBUG
printf("Thebyte: %x\n",thebyte);
#endif
			 for (i = 0; i < 8; i++, thebyte >>= 1) {
				   if (thebyte & 1) {
#ifdef CUTILITIES_DEBUG
printf("Right\n");
#endif
					     if (! curptr->right) {
							RETVAL = 0;
#ifdef CUTILITIES_DEBUG
printf("Right bomb:");
for (done = 0; done < len; done++) {
printf("%02x",encoded[done]);
}
printf(", %d chars decoded:",k);
for (done = 0; done < k; done++) {
printf("%c",answer[done]);
}
printf("\n");
#endif

							done = 1;
							break;
						}
					     curptr = curptr->right;
				   } else {
#ifdef CUTILITIES_DEBUG
printf("Left\n");
#endif
					     if (! curptr->left) {
							RETVAL = 0;
#ifdef CUTILITIES_DEBUG
printf("Left bomb:");
for (done = 0; done < len; done++) {
printf("%02x",encoded[done]);
}
printf(", %d chars decoded:",k);
for (done = 0; done < k; done++) {
printf("%c",answer[done]);
}
printf("\n");
#endif
							done = 1;
							break;
						}
					     curptr = curptr->left;
				   }
		
				   if (curptr->value >= 0) {
					     alpha_index += curptr->value;
					     /*printf("%d", alpha_index); */
#ifdef CUTILITIES_DEBUG
printf("Decoded value: %d, alpha_index = %d, char: %c\n", curptr->value,alpha_index,aa_syms[alpha_index]);
#endif
					     answer[k++] = aa_syms[alpha_index];
					     curptr = root; /* prepare to decode the next Huffman code */
				   } else {
					     if (curptr->value == -1) {
							 answer[k++] = '\0';
#ifdef CUTILITIES_DEBUG
printf("End of word, answer=%s\n",answer);
#endif
							 RETVAL = answer;
							 done = 1;
							 break;
					     }
				   }
			 }
		}
		
	OUTPUT:
		RETVAL
		
		
int
bitsAvailableForPrimeProducts()
	CODE:
		RETVAL = sizeof(Uverylong) * 8;
	OUTPUT:
		RETVAL

void
computePrimeProduct(peptide)
	char *peptide
	CODE:
		Uverylong m = static_computePrimeProduct(peptide);
		ST(0) = sv_newmortal();
		if (m > 0) {
			sv_setpvn(ST(0),(char *) &m, sizeof(m));
		} else {
			ST(0) = &PL_sv_undef;
		}

int
testManyPrimeProducts(product,peptides,multiples,answer)
	SV *product
	AV *peptides
	AV *multiples
	AV *answer

	CODE:
#ifdef WIN
{
#endif
		SV **sv;
		int i, count;
		STRLEN len;
		Uverylong u,divisor;
		char *p;
		int total = 0;

		av_clear(answer);
		p = SvPV(product,len);
		memcpy((char *) &divisor,p,len);
		count = av_len(peptides);
		for (i = 0; i <= count; i++) {
			sv = av_fetch(multiples,i,0);
			p = SvPV(*sv,len);
			memcpy(&u,p,len);
			if (!(divisor % u)) {
				sv = av_fetch(peptides,i,0);
				av_push(answer,*sv);
				SvREFCNT_inc(*sv);
				total++;
			}
		}
		RETVAL = total;
#ifdef WIN
}
#endif
	OUTPUT:
		RETVAL
		
int
computeManyPrimeProducts(peptides,multiples)
	AV *peptides
	AV *multiples
	CODE:
#ifdef WIN
{
#endif
		int i, count;
		Uverylong val;
		char *p;
		SV *sv;
		SV **pv;
		STRLEN len;

		count = av_len(peptides);
		av_extend(multiples,count);
		RETVAL = count+1;
		for (i = 0; i <= count; i++) {
			pv = av_fetch(peptides,i,0);
			p = SvPV(*pv,len);
			val = static_computePrimeProduct(p);
			if (val == 0) {
				RETVAL = -i;
				break;
			} else {
				sv = newSVpvn((char *) &val, sizeof(val));
				av_store(multiples,i,sv);
			}
		}
#ifdef WIN
}
#endif

	OUTPUT:
		RETVAL
		
void
encodeAsBitString(peptide)
	char *peptide
	CODE:
		int lastindex = -1;
		int thisindex;
		int unused = 0;
		int i;
		int bitcount;
		char *p;
		static int inited = 0;
		static char *revindex;
		static int bitmax[22];
		static int bitmaxcount = 0;
		static int outsize;
		static unsigned char *tempout;
		unsigned char *out;
		SV *mysv;
		STRLEN len;

		if (!inited) {
			int thesize = sizeof(lookup)/sizeof(lookup[0]);
			int bits;
			int j = 0;

			revindex = malloc(thesize * sizeof(revindex[0]));
			inited = 1;
			bitcount = 0;
			for (i = 0; i < thesize; i++) {
				if (lookup[i]) {
					revindex[i] = j++;
					bits = (int)(2000.0 / lookup[i]) + 1;
					bitmax[bitmaxcount++] = bits;
					bitcount += bits;
				} else {
					revindex[i] = -2;
				}
			}
			outsize = (bitcount+7)/8;
			tempout = malloc(outsize+2); /* a few extra bytes for good measure */
#define CUTILITIES_DEBUG 1
#ifdef CUTILITIES_DEBUG
printf("Running encodeAsBitString initialization code, bitmaxcount=%d,outsize=%d\n",bitmaxcount,outsize);
#endif /* CUTILITIES_DEBUG */
		}

		memset(tempout,'\0',outsize);
		mysv = newSVpvn(tempout,outsize);
		out = SvPV(mysv,len);
		bitcount = 0;
#ifdef CUTILITIES_DEBUG
printf("Setting %d zero bytes at %lx\n",outsize,(long) out);
#endif /* CUTILITIES_DEBUG */

		for (p = peptide; *p; p++) {
			if ((thisindex = revindex[*p]) < 0) {
#ifdef CUTILITIES_DEBUG
printf ("Error encoding bitstring for %s, char=%d\n",peptide,*p);
#endif /* CUTILITIES_DEBUG */
			}
			if (thisindex != lastindex) {
				for (i = lastindex; i < thisindex;) {
					/* extend bitstring here by #unused 0s */
					bitcount += unused;
					unused = bitmax[++i];
				}
				lastindex = thisindex;
			}
			/* append 1 to bitstring here */
			out[bitcount/8] |= (1 << (bitcount % 8));
#ifdef CUTILITIES_DEBUG
printf("Appending 1 at position %d for %s, output byte is now: %x\n",bitcount,peptide, out[bitcount/8]);
#endif /* CUTILITIES_DEBUG */
			bitcount++;
			unused--;
		}

		thisindex = bitmaxcount;
		for (i = lastindex; i < thisindex;) {
			/* extend bitstring here by #unused 0s */
			bitcount += unused;
			unused = bitmax[++i];
		}

		ST(0) = mysv;
#ifdef CUTILITIES_DEBUG
printf("Returning a %d byte string for %s\n",(bitcount+7)/8,peptide);
for (i = 0; i < outsize; i++) {
printf("%02x",out[i]);
}
printf("\n");
#endif /* CUTILITIES_DEBUG */

int
testManyBitStrings(encodedCandidate,peptides,bitstrings,answer)
	SV *encodedCandidate
	AV *peptides
	AV *bitstrings
	AV *answer

	CODE:
#ifdef WIN
{
#endif
		SV **sv;
		int i, count;
		STRLEN len;
#ifdef USE_VERYLONG
#define OURLONG Uverylong
#else
#define OURLONG unsigned long
#endif
		OURLONG u[20],v[20]; /* this may not work correctly if there are an odd # of 32-bit words */
		OURLONG *uPtr,*vPtr,*maxUPtr;
		OURLONG val;
		int longlongwordlen;
		char *p;
		int total = 0;
#ifdef CUTILITIES_DEBUG
int j;
#endif /* CUTILITIES_DEBUG */

		av_clear(answer);
		p = SvPV(encodedCandidate,len);
		memcpy((char *) v,p,len);
		longlongwordlen = (len+sizeof(u[0])-1)/sizeof(u[0]);
		u[longlongwordlen-1] = 0;
		v[longlongwordlen-1] = 0;
		count = av_len(peptides);
		maxUPtr = &u[longlongwordlen];
#ifdef CUTILITIES_DEBUG
printf("Len: %d, count: %d\n",len,count);
#endif /* CUTILITIES_DEBUG */
		for (i = 0; i <= count; i++) {
			sv = av_fetch(bitstrings,i,0);
			p = SvPV(*sv,len);
			memcpy(u,p,len);
#ifdef CUTILITIES_DEBUG
printf("iteration %d, fetched %d bytes\n",i,len);
j=0;
#endif /* CUTILITIES_DEBUG */
			for (uPtr = u, vPtr = v; uPtr < maxUPtr; uPtr++, vPtr++) {
				if ((val = ((*uPtr & *vPtr) ^ *uPtr))) {
#ifdef CUTILITIES_DEBUG
printf("D:%d,%lx,%lx,%lx\n",uPtr-u,*uPtr,*vPtr,val);
#endif /* CUTILITIES_DEBUG */
					break;
				}
#ifdef CUTILITIES_DEBUG
j++;
#endif /* CUTILITIES_DEBUG */
			}
#ifdef CUTILITIES_DEBUG
printf("j:%d ",j);
#endif /* CUTILITIES_DEBUG */
			if (! val) {
#ifdef CUTILITIES_DEBUG
printf("*");
#endif /* CUTILITIES_DEBUG */
				sv = av_fetch(peptides,i,0);
				av_push(answer,*sv);
				SvREFCNT_inc(*sv);
				total++;
			}
		}
		RETVAL = total;
#ifdef WIN
}
#endif
	OUTPUT:
		RETVAL


int
quickAACLookup(minmass, maxmass, ans)
	double minmass
	double maxmass
	AV *ans;

	CODE:
		int mid,low,high,maxindex,total;
		double val;
		AV *answer;
		int saveMid;
		int cnt = 0;

		low = 0;
		total = 0;
		maxindex = sizeof(massWithAACs) / sizeof(MassWithAAC);
		high = maxindex;
		av_clear(ans);

		while (low <= high) {
			mid = (low+high)/2;
			val = massWithAACs[mid].mass;
			if (minmass < val) 
				high = mid - 1;
			else
				low = mid + 1;
		}
		if (minmass > val) mid++;

		saveMid = mid;
		/* precompute the size of the return value */
		while (massWithAACs[mid].mass <= maxmass && mid < maxindex) {
			mid++;
			cnt++;
		}
		av_extend(ans,cnt);

		mid = saveMid;

		while (massWithAACs[mid].mass <= maxmass && mid < maxindex) {
 			av_push(ans,newSVpv((const char *) massWithAACs[mid].AAC,0));
			total++;
			mid++;
		}
		RETVAL = total;

	OUTPUT:
		RETVAL


int
binarySearchSpectrum(mass,extended_spectrum)
	double mass
	AV *extended_spectrum
	CODE:
#ifdef WIN
{
#endif
		int mid,low,high;
		double val;
		SV **sv;

		low = 0;
		high = av_len(extended_spectrum);
		while (low <= high) {
			mid = (low+high)/2;
			sv = av_fetch(extended_spectrum,mid,0);
			val = SvNV(*sv);
			if (mass < val) 
				high = mid - 1;
			else
				low = mid + 1;
		}
		if (mass > val) mid++;
		RETVAL = mid;
#ifdef WIN
}
#endif
	OUTPUT:
		RETVAL
