######################################################################
#
# 5119_cp00930_by_utf8_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xE3\x80\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x40\x40"],
        ["\x40\x40",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x80"],

        ["\xE3\x80\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x44"],
        ["\x43\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x81"],

        ["\xE3\x80\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x41"],
        ["\x43\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x82"],

        ["\xEF\xBC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6B"],
        ["\x42\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8C"],

        ["\xEF\xBC\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4B"],
        ["\x42\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8E"],

        ["\xE3\x83\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x45"],
        ["\x43\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBB"],

        ["\xEF\xBC\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x7A"],
        ["\x42\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9A"],

        ["\xEF\xBC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5E"],
        ["\x42\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9B"],

        ["\xEF\xBC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6F"],
        ["\x42\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9F"],

        ["\xEF\xBC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5A"],
        ["\x42\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x81"],

        ["\xE3\x82\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBE"],
        ["\x43\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9B"],

        ["\xE3\x82\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBF"],
        ["\x43\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9C"],

        ["\xC2\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x50"],
        ["\x44\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],

        ["\xEF\xBD\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x79"],
        ["\x42\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x80"],

        ["\xC2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x60"],
        ["\x44\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],

        ["\xEF\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x70"],
        ["\x44\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBE"],

        ["\xEF\xBF\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA1"],
        ["\x42\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA3"],

        ["\xEF\xBC\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6D"],
        ["\x42\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBF"],

        ["\xE3\x83\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xDC"],
        ["\x43\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBD"],

        ["\xE3\x83\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xDD"],
        ["\x43\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBE"],

        ["\xE3\x82\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xDC"],
        ["\x44\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9D"],

        ["\xE3\x82\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xDD"],
        ["\x44\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9E"],

        ["\xE3\x80\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5B"],
        ["\x44\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x83"],

        ["\xE4\xBB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5C"],
        ["\x44\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9D"],

        ["\xE3\x80\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5D"],
        ["\x44\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x85"],

        ["\xE3\x80\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5E"],
        ["\x44\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x86"],

        ["\xE3\x80\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5F"],
        ["\x44\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x87"],

        ["\xE3\x83\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x58"],
        ["\x43\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBC"],

        ["\xE2\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],
        ["\xDD\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x95"],

        ["\xE2\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x5A"],
        ["\x44\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x90"],

        ["\xEF\xBC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x61"],
        ["\x42\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8F"],

        ["\xEF\xBC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE0"],
        ["\x43\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBC"],

        ["\xE3\x80\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA1"],
        ["\x43\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9C"],

        ["\xE2\x88\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\xDF\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA5"],

        ["\xEF\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4F"],
        ["\x42\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9C"],

        ["\xE2\x80\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7F"],
        ["\x44\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA6"],

        ["\xE2\x80\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7E"],
        ["\x44\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA5"],

        ["\xE2\x80\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x61"],
        ["\x44\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x98"],

        ["\xE2\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x71"],
        ["\x44\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x99"],

        ["\xE2\x80\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x62"],
        ["\x44\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9C"],

        ["\xE2\x80\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x72"],
        ["\x44\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9D"],

        ["\xEF\xBC\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4D"],
        ["\x42\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x88"],

        ["\xEF\xBC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5D"],
        ["\x42\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x89"],

        ["\xE3\x80\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x63"],
        ["\x44\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x94"],

        ["\xE3\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x73"],
        ["\x44\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x95"],

        ["\xEF\xBC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x44"],
        ["\x44\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBB"],

        ["\xEF\xBC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x45"],
        ["\x44\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBD"],

        ["\xEF\xBD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC0"],
        ["\x42\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9B"],

        ["\xEF\xBD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD0"],
        ["\x42\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9D"],

        ["\xE3\x80\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x64"],
        ["\x44\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x88"],

        ["\xE3\x80\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x74"],
        ["\x44\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x89"],

        ["\xE3\x80\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x65"],
        ["\x44\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8A"],

        ["\xE3\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x75"],
        ["\x44\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8B"],

        ["\xE3\x80\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x42"],
        ["\x43\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8C"],

        ["\xE3\x80\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x43"],
        ["\x43\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8D"],

        ["\xE3\x80\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x42"],
        ["\x44\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8E"],

        ["\xE3\x80\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x43"],
        ["\x44\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8F"],

        ["\xE3\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x66"],
        ["\x44\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x90"],

        ["\xE3\x80\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x76"],
        ["\x44\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x91"],

        ["\xEF\xBC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4E"],
        ["\x42\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8B"],

        ["\xEF\xBC\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xE9\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8D"],

        ["\xC2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x4B"],
        ["\x44\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],

        ["\xC3\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7A"],
        ["\x44\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\x97"],

        ["\xC3\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7B"],
        ["\x44\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],

        ["\xEF\xBC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x7E"],
        ["\x42\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9D"],

        ["\xE2\x89\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x4C"],
        ["\x44\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA0"],

        ["\xEF\xBC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4C"],
        ["\x42\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9C"],

        ["\xEF\xBC\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6E"],
        ["\x42\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9E"],

        ["\xE2\x89\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x67"],
        ["\x44\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA6"],

        ["\xE2\x89\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x77"],
        ["\x44\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA7"],

        ["\xE2\x88\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x4D"],
        ["\x44\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9E"],

        ["\xE2\x88\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x68"],
        ["\x44\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB4"],

        ["\xE2\x99\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x69"],
        ["\x44\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x82"],

        ["\xE2\x99\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x79"],
        ["\x44\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x80"],

        ["\xC2\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xED"],
        ["\x44\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],

        ["\xE2\x80\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xEE"],
        ["\x44\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB2"],

        ["\xE2\x80\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xEF"],
        ["\x44\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB3"],

        ["\xE2\x84\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x4E"],
        ["\x44\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x83"],

        ["\xEF\xBF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5B"],
        ["\x42\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA5"],

        ["\xEF\xBC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE0"],
        ["\x42\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x84"],

        ["\xEF\xBF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4A"],
        ["\x43\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA0"],

        ["\xEF\xBF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x4A"],
        ["\x42\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA1"],

        ["\xEF\xBC\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x6C"],
        ["\x42\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x85"],

        ["\xEF\xBC\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x7B"],
        ["\x42\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x83"],

        ["\xEF\xBC\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x50"],
        ["\x42\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x86"],

        ["\xEF\xBC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5C"],
        ["\x42\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8A"],

        ["\xEF\xBC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x7C"],
        ["\x42\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA0"],

        ["\xC2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6A"],
        ["\x44\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],

        ["\xE2\x98\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE5"],
        ["\x44\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x86"],

        ["\xE2\x98\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE6"],
        ["\x44\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x85"],

        ["\xE2\x97\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE0"],
        ["\x44\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8B"],

        ["\xE2\x97\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE1"],
        ["\x44\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8F"],

        ["\xE2\x97\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE4"],
        ["\x44\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8E"],

        ["\xE2\x97\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE7"],
        ["\x44\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x87"],

        ["\xE2\x97\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE8"],
        ["\x44\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x86"],

        ["\xE2\x96\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE9"],
        ["\x44\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA1"],

        ["\xE2\x96\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xEA"],
        ["\x44\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA0"],

        ["\xE2\x96\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE2"],
        ["\x44\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB3"],

        ["\xE2\x96\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xE3"],
        ["\x44\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB2"],

        ["\xE2\x96\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xEB"],
        ["\x44\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBD"],

        ["\xE2\x96\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xEC"],
        ["\x44\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBC"],

        ["\xE2\x80\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6B"],
        ["\x44\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBB"],

        ["\xE3\x80\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6C"],
        ["\x44\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x92"],

        ["\xE2\x86\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xF0"],
        ["\x44\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x92"],

        ["\xE2\x86\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xF1"],
        ["\x44\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x90"],

        ["\xE2\x86\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xF2"],
        ["\x44\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x91"],

        ["\xE2\x86\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xF3"],
        ["\x44\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x93"],

        ["\xE3\x80\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x44\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],

        ["\xE2\x88\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x64"],
        ["\x43\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x88"],

        ["\xE2\x88\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x65"],
        ["\x43\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x8B"],

        ["\xE2\x8A\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x66"],
        ["\x43\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x86"],

        ["\xE2\x8A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x67"],
        ["\x43\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x87"],

        ["\xE2\x8A\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x68"],
        ["\x43\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x82"],

        ["\xE2\x8A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x69"],
        ["\x43\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x83"],

        ["\xE2\x88\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6A"],
        ["\x43\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAA"],

        ["\xE2\x88\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6B"],
        ["\x43\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA9"],

        ["\xE2\x88\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6C"],
        ["\x43\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA7"],

        ["\xE2\x88\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6D"],
        ["\x43\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA8"],

        ["\xEF\xBF\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x5F"],
        ["\x42\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA2"],

        ["\xE2\x87\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6E"],
        ["\x43\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x92"],

        ["\xE2\x87\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x6F"],
        ["\x43\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x94"],

        ["\xE2\x88\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x70"],
        ["\x43\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x80"],

        ["\xE2\x88\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x71"],
        ["\x43\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x83"],

        ["\xE2\x88\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4B"],
        ["\x43\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA0"],

        ["\xE2\x8A\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4C"],
        ["\x43\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xA5"],

        ["\xE2\x8C\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4D"],
        ["\x43\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x92"],

        ["\xE2\x88\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4E"],
        ["\x43\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x82"],

        ["\xE2\x88\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x4F"],
        ["\x43\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x87"],

        ["\xE2\x89\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5B"],
        ["\x43\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA1"],

        ["\xE2\x89\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5C"],
        ["\x43\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x92"],

        ["\xE2\x89\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5D"],
        ["\x43\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAA"],

        ["\xE2\x89\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5E"],
        ["\x43\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAB"],

        ["\xE2\x88\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5F"],
        ["\x43\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9A"],

        ["\xE2\x88\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x60"],
        ["\x43\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xBD"],

        ["\xE2\x88\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x61"],
        ["\x43\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9D"],

        ["\xE2\x88\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x78"],
        ["\x44\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB5"],

        ["\xE2\x88\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x62"],
        ["\x43\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAB"],

        ["\xE2\x88\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x63"],
        ["\x43\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAC"],

        ["\xE2\x84\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x72"],
        ["\x43\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xAB"],

        ["\xE2\x80\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x73"],
        ["\x43\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB0"],

        ["\xE2\x99\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x74"],
        ["\x43\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAF"],

        ["\xE2\x99\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x75"],
        ["\x43\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAD"],

        ["\xE2\x99\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x76"],
        ["\x43\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAA"],

        ["\xE2\x80\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x77"],
        ["\x43\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA0"],

        ["\xE2\x80\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x78"],
        ["\x43\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA1"],

        ["\xC2\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x79"],
        ["\x43\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],

        ["\xE2\x97\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x7A"],
        ["\x43\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\xAF"],

        ["\xEF\xBC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF0"],
        ["\x42\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x90"],

        ["\xEF\xBC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF1"],
        ["\x42\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x91"],

        ["\xEF\xBC\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF2"],
        ["\x42\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x92"],

        ["\xEF\xBC\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF3"],
        ["\x42\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x93"],

        ["\xEF\xBC\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF4"],
        ["\x42\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x94"],

        ["\xEF\xBC\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF5"],
        ["\x42\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x95"],

        ["\xEF\xBC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF6"],
        ["\x42\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x96"],

        ["\xEF\xBC\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF7"],
        ["\x42\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x97"],

        ["\xEF\xBC\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF8"],
        ["\x42\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x98"],

        ["\xEF\xBC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xF9"],
        ["\x42\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x99"],

        ["\xEF\xBC\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC1"],
        ["\x42\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA1"],

        ["\xEF\xBC\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC2"],
        ["\x42\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA2"],

        ["\xEF\xBC\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC3"],
        ["\x42\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA3"],

        ["\xEF\xBC\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC4"],
        ["\x42\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA4"],

        ["\xEF\xBC\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC5"],
        ["\x42\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA5"],

        ["\xEF\xBC\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC6"],
        ["\x42\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA6"],

        ["\xEF\xBC\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC7"],
        ["\x42\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA7"],

        ["\xEF\xBC\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC8"],
        ["\x42\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA8"],

        ["\xEF\xBC\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xC9"],
        ["\x42\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA9"],

        ["\xEF\xBC\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD1"],
        ["\x42\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAA"],

        ["\xEF\xBC\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD2"],
        ["\x42\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAB"],

        ["\xEF\xBC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD3"],
        ["\x42\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAC"],

        ["\xEF\xBC\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD4"],
        ["\x42\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAD"],

        ["\xEF\xBC\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD5"],
        ["\x42\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAE"],

        ["\xEF\xBC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD6"],
        ["\x42\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAF"],

        ["\xEF\xBC\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD7"],
        ["\x42\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB0"],

        ["\xEF\xBC\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD8"],
        ["\x42\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB1"],

        ["\xEF\xBC\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xD9"],
        ["\x42\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB2"],

        ["\xEF\xBC\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE2"],
        ["\x42\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB3"],

        ["\xEF\xBC\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE3"],
        ["\x42\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB4"],

        ["\xEF\xBC\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE4"],
        ["\x42\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB5"],

        ["\xEF\xBC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE5"],
        ["\x42\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB6"],

        ["\xEF\xBC\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE6"],
        ["\x42\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB7"],

        ["\xEF\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE7"],
        ["\x42\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB8"],

        ["\xEF\xBC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE8"],
        ["\x42\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB9"],

        ["\xEF\xBC\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xE9"],
        ["\x42\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBA"],

        ["\xEF\xBD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x81"],
        ["\x42\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x81"],

        ["\xEF\xBD\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x82"],
        ["\x42\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x82"],

        ["\xEF\xBD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x83"],
        ["\x42\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x83"],

        ["\xEF\xBD\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x84"],
        ["\x42\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x84"],

        ["\xEF\xBD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x85"],
        ["\x42\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x85"],

        ["\xEF\xBD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x86"],
        ["\x42\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x86"],

        ["\xEF\xBD\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x87"],
        ["\x42\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x87"],

        ["\xEF\xBD\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x88"],
        ["\x42\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x88"],

        ["\xEF\xBD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x89"],
        ["\x42\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x89"],

        ["\xEF\xBD\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x91"],
        ["\x42\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8A"],

        ["\xEF\xBD\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x92"],
        ["\x42\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8B"],

        ["\xEF\xBD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x93"],
        ["\x42\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8C"],

        ["\xEF\xBD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x94"],
        ["\x42\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8D"],

        ["\xEF\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x95"],
        ["\x42\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8E"],

        ["\xEF\xBD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x96"],
        ["\x42\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8F"],

        ["\xEF\xBD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x97"],
        ["\x42\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x90"],

        ["\xEF\xBD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x98"],
        ["\x42\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x91"],

        ["\xEF\xBD\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\x99"],
        ["\x42\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x92"],

        ["\xEF\xBD\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA2"],
        ["\x42\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x93"],

        ["\xEF\xBD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA3"],
        ["\x42\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x94"],

        ["\xEF\xBD\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA4"],
        ["\x42\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x95"],

        ["\xEF\xBD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA5"],
        ["\x42\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x96"],

        ["\xEF\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA6"],
        ["\x42\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x97"],

        ["\xEF\xBD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA7"],
        ["\x42\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x98"],

        ["\xEF\xBD\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA8"],
        ["\x42\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x99"],

        ["\xEF\xBD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x42\xA9"],
        ["\x42\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9A"],

        ["\xE3\x81\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x47"],
        ["\x44\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x81"],

        ["\xE3\x81\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x81"],
        ["\x44\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x82"],

        ["\xE3\x81\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x48"],
        ["\x44\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x83"],

        ["\xE3\x81\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x82"],
        ["\x44\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x84"],

        ["\xE3\x81\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x49"],
        ["\x44\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x85"],

        ["\xE3\x81\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x83"],
        ["\x44\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x86"],

        ["\xE3\x81\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x51"],
        ["\x44\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x87"],

        ["\xE3\x81\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x84"],
        ["\x44\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x88"],

        ["\xE3\x81\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x52"],
        ["\x44\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x89"],

        ["\xE3\x81\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x85"],
        ["\x44\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8A"],

        ["\xE3\x81\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x86"],
        ["\x44\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8B"],

        ["\xE3\x81\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC0"],
        ["\x44\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8C"],

        ["\xE3\x81\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x87"],
        ["\x44\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8D"],

        ["\xE3\x81\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC1"],
        ["\x44\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8E"],

        ["\xE3\x81\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x88"],
        ["\x44\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8F"],

        ["\xE3\x81\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC2"],
        ["\x44\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x90"],

        ["\xE3\x81\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x89"],
        ["\x44\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x91"],

        ["\xE3\x81\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC3"],
        ["\x44\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x92"],

        ["\xE3\x81\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x8A"],
        ["\x44\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x93"],

        ["\xE3\x81\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC4"],
        ["\x44\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x94"],

        ["\xE3\x81\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x8C"],
        ["\x44\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x95"],

        ["\xE3\x81\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC5"],
        ["\x44\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x96"],

        ["\xE3\x81\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x8D"],
        ["\x44\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x97"],

        ["\xE3\x81\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC6"],
        ["\x44\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x98"],

        ["\xE3\x81\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x8E"],
        ["\x44\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x99"],

        ["\xE3\x81\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC7"],
        ["\x44\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9A"],

        ["\xE3\x81\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x8F"],
        ["\x44\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9B"],

        ["\xE3\x81\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC8"],
        ["\x44\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9C"],

        ["\xE3\x81\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x90"],
        ["\x44\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9D"],

        ["\xE3\x81\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xC9"],
        ["\x44\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9E"],

        ["\xE3\x81\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x91"],
        ["\x44\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9F"],

        ["\xE3\x81\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCA"],
        ["\x44\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA0"],

        ["\xE3\x81\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x92"],
        ["\x44\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA1"],

        ["\xE3\x81\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCB"],
        ["\x44\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA2"],

        ["\xE3\x81\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x56"],
        ["\x44\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA3"],

        ["\xE3\x81\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x93"],
        ["\x44\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA4"],

        ["\xE3\x81\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCC"],
        ["\x44\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA5"],

        ["\xE3\x81\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x94"],
        ["\x44\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA6"],

        ["\xE3\x81\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCD"],
        ["\x44\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA7"],

        ["\xE3\x81\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x95"],
        ["\x44\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA8"],

        ["\xE3\x81\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCE"],
        ["\x44\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA9"],

        ["\xE3\x81\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x96"],
        ["\x44\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAA"],

        ["\xE3\x81\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x97"],
        ["\x44\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAB"],

        ["\xE3\x81\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x98"],
        ["\x44\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAC"],

        ["\xE3\x81\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x99"],
        ["\x44\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAD"],

        ["\xE3\x81\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x9A"],
        ["\x44\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAE"],

        ["\xE3\x81\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x9D"],
        ["\x44\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAF"],

        ["\xE3\x81\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xCF"],
        ["\x44\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB0"],

        ["\xE3\x81\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD5"],
        ["\x44\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB1"],

        ["\xE3\x81\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x9E"],
        ["\x44\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB2"],

        ["\xE3\x81\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD0"],
        ["\x44\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB3"],

        ["\xE3\x81\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD6"],
        ["\x44\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB4"],

        ["\xE3\x81\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x9F"],
        ["\x44\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB5"],

        ["\xE3\x81\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD1"],
        ["\x44\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB6"],

        ["\xE3\x81\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD7"],
        ["\x44\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB7"],

        ["\xE3\x81\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA2"],
        ["\x44\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB8"],

        ["\xE3\x81\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD2"],
        ["\x44\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB9"],

        ["\xE3\x81\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD8"],
        ["\x44\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBA"],

        ["\xE3\x81\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA3"],
        ["\x44\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBB"],

        ["\xE3\x81\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD3"],
        ["\x44\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBC"],

        ["\xE3\x81\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xD9"],
        ["\x44\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBD"],

        ["\xE3\x81\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA4"],
        ["\x44\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBE"],

        ["\xE3\x81\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA5"],
        ["\x44\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBF"],

        ["\xE3\x82\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA6"],
        ["\x44\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x80"],

        ["\xE3\x82\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA7"],
        ["\x44\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x81"],

        ["\xE3\x82\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA8"],
        ["\x44\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x82"],

        ["\xE3\x82\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x53"],
        ["\x44\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x83"],

        ["\xE3\x82\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xA9"],
        ["\x44\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x84"],

        ["\xE3\x82\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x54"],
        ["\x44\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x85"],

        ["\xE3\x82\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xAA"],
        ["\x44\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x86"],

        ["\xE3\x82\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x55"],
        ["\x44\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x87"],

        ["\xE3\x82\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xAC"],
        ["\x44\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x88"],

        ["\xE3\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xAD"],
        ["\x44\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x89"],

        ["\xE3\x82\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xAE"],
        ["\x44\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8A"],

        ["\xE3\x82\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xAF"],
        ["\x44\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8B"],

        ["\xE3\x82\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xBA"],
        ["\x44\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8C"],

        ["\xE3\x82\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xBB"],
        ["\x44\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8D"],

        ["\xE3\x82\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x57"],
        ["\x44\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8E"],

        ["\xE3\x82\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xBC"],
        ["\x44\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8F"],

        ["\xE3\x82\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xDA"],
        ["\x44\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x90"],

        ["\xE3\x82\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xDB"],
        ["\x44\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x91"],

        ["\xE3\x82\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x46"],
        ["\x44\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x92"],

        ["\xE3\x82\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\xBD"],
        ["\x44\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x93"],

        ["\xE3\x82\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x47"],
        ["\x43\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA1"],

        ["\xE3\x82\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x81"],
        ["\x43\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA2"],

        ["\xE3\x82\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x48"],
        ["\x43\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA3"],

        ["\xE3\x82\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x82"],
        ["\x43\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA4"],

        ["\xE3\x82\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x49"],
        ["\x43\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA5"],

        ["\xE3\x82\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x83"],
        ["\x43\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA6"],

        ["\xE3\x82\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x51"],
        ["\x43\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA7"],

        ["\xE3\x82\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x84"],
        ["\x43\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA8"],

        ["\xE3\x82\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x52"],
        ["\x43\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA9"],

        ["\xE3\x82\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x85"],
        ["\x43\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAA"],

        ["\xE3\x82\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x86"],
        ["\x43\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAB"],

        ["\xE3\x82\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC0"],
        ["\x43\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAC"],

        ["\xE3\x82\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x87"],
        ["\x43\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAD"],

        ["\xE3\x82\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC1"],
        ["\x43\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAE"],

        ["\xE3\x82\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x88"],
        ["\x43\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAF"],

        ["\xE3\x82\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC2"],
        ["\x43\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB0"],

        ["\xE3\x82\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x89"],
        ["\x43\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB1"],

        ["\xE3\x82\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC3"],
        ["\x43\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB2"],

        ["\xE3\x82\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x8A"],
        ["\x43\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB3"],

        ["\xE3\x82\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC4"],
        ["\x43\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB4"],

        ["\xE3\x82\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x8C"],
        ["\x43\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB5"],

        ["\xE3\x82\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC5"],
        ["\x43\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB6"],

        ["\xE3\x82\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x8D"],
        ["\x43\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB7"],

        ["\xE3\x82\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC6"],
        ["\x43\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB8"],

        ["\xE3\x82\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x8E"],
        ["\x43\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB9"],

        ["\xE3\x82\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC7"],
        ["\x43\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBA"],

        ["\xE3\x82\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x8F"],
        ["\x43\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBB"],

        ["\xE3\x82\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC8"],
        ["\x43\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBC"],

        ["\xE3\x82\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x90"],
        ["\x43\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBD"],

        ["\xE3\x82\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xC9"],
        ["\x43\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBE"],

        ["\xE3\x82\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x91"],
        ["\x43\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBF"],

        ["\xE3\x83\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCA"],
        ["\x43\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x80"],

        ["\xE3\x83\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x92"],
        ["\x43\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x81"],

        ["\xE3\x83\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCB"],
        ["\x43\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x82"],

        ["\xE3\x83\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x56"],
        ["\x43\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x83"],

        ["\xE3\x83\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x93"],
        ["\x43\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x84"],

        ["\xE3\x83\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCC"],
        ["\x43\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x85"],

        ["\xE3\x83\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x94"],
        ["\x43\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x86"],

        ["\xE3\x83\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCD"],
        ["\x43\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x87"],

        ["\xE3\x83\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x95"],
        ["\x43\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x88"],

        ["\xE3\x83\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCE"],
        ["\x43\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x89"],

        ["\xE3\x83\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x96"],
        ["\x43\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8A"],

        ["\xE3\x83\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x97"],
        ["\x43\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8B"],

        ["\xE3\x83\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x98"],
        ["\x43\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8C"],

        ["\xE3\x83\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x99"],
        ["\x43\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8D"],

        ["\xE3\x83\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x9A"],
        ["\x43\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8E"],

        ["\xE3\x83\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x9D"],
        ["\x43\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8F"],

        ["\xE3\x83\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xCF"],
        ["\x43\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x90"],

        ["\xE3\x83\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD5"],
        ["\x43\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x91"],

        ["\xE3\x83\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x9E"],
        ["\x43\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x92"],

        ["\xE3\x83\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD0"],
        ["\x43\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x93"],

        ["\xE3\x83\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD6"],
        ["\x43\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x94"],

        ["\xE3\x83\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x9F"],
        ["\x43\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x95"],

        ["\xE3\x83\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD1"],
        ["\x43\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x96"],

        ["\xE3\x83\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD7"],
        ["\x43\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x97"],

        ["\xE3\x83\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA2"],
        ["\x43\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x98"],

        ["\xE3\x83\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD2"],
        ["\x43\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x99"],

        ["\xE3\x83\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD8"],
        ["\x43\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9A"],

        ["\xE3\x83\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA3"],
        ["\x43\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9B"],

        ["\xE3\x83\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD3"],
        ["\x43\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9C"],

        ["\xE3\x83\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD9"],
        ["\x43\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9D"],

        ["\xE3\x83\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA4"],
        ["\x43\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9E"],

        ["\xE3\x83\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA5"],
        ["\x43\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9F"],

        ["\xE3\x83\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA6"],
        ["\x43\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA0"],

        ["\xE3\x83\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA7"],
        ["\x43\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA1"],

        ["\xE3\x83\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA8"],
        ["\x43\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA2"],

        ["\xE3\x83\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x53"],
        ["\x43\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA3"],

        ["\xE3\x83\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xA9"],
        ["\x43\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA4"],

        ["\xE3\x83\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x54"],
        ["\x43\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA5"],

        ["\xE3\x83\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xAA"],
        ["\x43\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA6"],

        ["\xE3\x83\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x55"],
        ["\x43\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA7"],

        ["\xE3\x83\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xAC"],
        ["\x43\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA8"],

        ["\xE3\x83\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xAD"],
        ["\x43\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA9"],

        ["\xE3\x83\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xAE"],
        ["\x43\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAA"],

        ["\xE3\x83\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xAF"],
        ["\x43\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAB"],

        ["\xE3\x83\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBA"],
        ["\x43\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAC"],

        ["\xE3\x83\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBB"],
        ["\x43\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAD"],

        ["\xE3\x83\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x57"],
        ["\x43\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAE"],

        ["\xE3\x83\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBC"],
        ["\x43\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAF"],

        ["\xE3\x83\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xDA"],
        ["\x43\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB0"],

        ["\xE3\x83\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xDB"],
        ["\x43\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB1"],

        ["\xE3\x83\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x46"],
        ["\x43\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB2"],

        ["\xE3\x83\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xBD"],
        ["\x43\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB3"],

        ["\xE3\x83\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xD4"],
        ["\x43\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB4"],

        ["\xE3\x83\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x59"],
        ["\x43\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB5"],

        ["\xE3\x83\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x5A"],
        ["\x43\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB6"],

        ["\xCE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x61"],
        ["\x41\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x91"],

        ["\xCE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x62"],
        ["\x41\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x92"],

        ["\xCE\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x63"],
        ["\x41\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x93"],

        ["\xCE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x64"],
        ["\x41\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x94"],

        ["\xCE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x65"],
        ["\x41\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x95"],

        ["\xCE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x66"],
        ["\x41\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x96"],

        ["\xCE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x67"],
        ["\x41\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x97"],

        ["\xCE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x68"],
        ["\x41\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x98"],

        ["\xCE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x69"],
        ["\x41\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x99"],

        ["\xCE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6A"],
        ["\x41\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9A"],

        ["\xCE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6B"],
        ["\x41\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9B"],

        ["\xCE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6C"],
        ["\x41\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9C"],

        ["\xCE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6D"],
        ["\x41\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9D"],

        ["\xCE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6E"],
        ["\x41\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9E"],

        ["\xCE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x6F"],
        ["\x41\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\x9F"],

        ["\xCE\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x70"],
        ["\x41\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA0"],

        ["\xCE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x71"],
        ["\x41\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],

        ["\xCE\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x72"],
        ["\x41\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],

        ["\xCE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x73"],
        ["\x41\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],

        ["\xCE\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x74"],
        ["\x41\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],

        ["\xCE\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x75"],
        ["\x41\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],

        ["\xCE\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x76"],
        ["\x41\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],

        ["\xCE\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x77"],
        ["\x41\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],

        ["\xCE\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x78"],
        ["\x41\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],

        ["\xCE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x41"],
        ["\x41\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],

        ["\xCE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x42"],
        ["\x41\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],

        ["\xCE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x43"],
        ["\x41\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],

        ["\xCE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x44"],
        ["\x41\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],

        ["\xCE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x45"],
        ["\x41\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],

        ["\xCE\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x46"],
        ["\x41\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],

        ["\xCE\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x47"],
        ["\x41\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],

        ["\xCE\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x48"],
        ["\x41\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],

        ["\xCE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x49"],
        ["\x41\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],

        ["\xCE\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4A"],
        ["\x41\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],

        ["\xCE\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4B"],
        ["\x41\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],

        ["\xCE\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4C"],
        ["\x41\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],

        ["\xCE\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4D"],
        ["\x41\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],

        ["\xCE\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4E"],
        ["\x41\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],

        ["\xCE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x4F"],
        ["\x41\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],

        ["\xCF\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x50"],
        ["\x41\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x80"],

        ["\xCF\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x51"],
        ["\x41\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x81"],

        ["\xCF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x52"],
        ["\x41\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x83"],

        ["\xCF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x53"],
        ["\x41\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x84"],

        ["\xCF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x54"],
        ["\x41\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x85"],

        ["\xCF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x55"],
        ["\x41\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x86"],

        ["\xCF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x56"],
        ["\x41\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x87"],

        ["\xCF\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x57"],
        ["\x41\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x88"],

        ["\xCF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x58"],
        ["\x41\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xCF\x89"],

        ["\xD0\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC0"],
        ["\x41\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x90"],

        ["\xD0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC1"],
        ["\x41\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x91"],

        ["\xD0\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC2"],
        ["\x41\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x92"],

        ["\xD0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC3"],
        ["\x41\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x93"],

        ["\xD0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC4"],
        ["\x41\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x94"],

        ["\xD0\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC5"],
        ["\x41\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x95"],

        ["\xD0\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC6"],
        ["\x41\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x81"],

        ["\xD0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC7"],
        ["\x41\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x96"],

        ["\xD0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC8"],
        ["\x41\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x97"],

        ["\xD0\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xC9"],
        ["\x41\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x98"],

        ["\xD0\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCA"],
        ["\x41\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x99"],

        ["\xD0\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCB"],
        ["\x41\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9A"],

        ["\xD0\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCC"],
        ["\x41\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9B"],

        ["\xD0\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCD"],
        ["\x41\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9C"],

        ["\xD0\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCE"],
        ["\x41\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9D"],

        ["\xD0\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xCF"],
        ["\x41\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9E"],

        ["\xD0\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD0"],
        ["\x41\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\x9F"],

        ["\xD0\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD1"],
        ["\x41\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA0"],

        ["\xD0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD2"],
        ["\x41\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],

        ["\xD0\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD3"],
        ["\x41\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],

        ["\xD0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD4"],
        ["\x41\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],

        ["\xD0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD5"],
        ["\x41\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],

        ["\xD0\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD6"],
        ["\x41\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],

        ["\xD0\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD7"],
        ["\x41\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],

        ["\xD0\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD8"],
        ["\x41\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],

        ["\xD0\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xD9"],
        ["\x41\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],

        ["\xD0\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDA"],
        ["\x41\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],

        ["\xD0\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDB"],
        ["\x41\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],

        ["\xD0\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDC"],
        ["\x41\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],

        ["\xD0\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDD"],
        ["\x41\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],

        ["\xD0\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDE"],
        ["\x41\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],

        ["\xD0\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xDF"],
        ["\x41\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],

        ["\xD0\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xE0"],
        ["\x41\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],

        ["\xD0\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x80"],
        ["\x41\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],

        ["\xD0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x81"],
        ["\x41\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],

        ["\xD0\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x82"],
        ["\x41\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],

        ["\xD0\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x83"],
        ["\x41\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],

        ["\xD0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x84"],
        ["\x41\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],

        ["\xD0\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x85"],
        ["\x41\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],

        ["\xD1\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x86"],
        ["\x41\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x91"],

        ["\xD0\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x87"],
        ["\x41\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],

        ["\xD0\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x88"],
        ["\x41\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],

        ["\xD0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x89"],
        ["\x41\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],

        ["\xD0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8A"],
        ["\x41\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],

        ["\xD0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8B"],
        ["\x41\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],

        ["\xD0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8C"],
        ["\x41\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],

        ["\xD0\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8D"],
        ["\x41\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],

        ["\xD0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8E"],
        ["\x41\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],

        ["\xD0\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x8F"],
        ["\x41\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],

        ["\xD0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x90"],
        ["\x41\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],

        ["\xD1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x91"],
        ["\x41\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x80"],

        ["\xD1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x92"],
        ["\x41\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x81"],

        ["\xD1\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x93"],
        ["\x41\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x82"],

        ["\xD1\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x94"],
        ["\x41\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x83"],

        ["\xD1\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x95"],
        ["\x41\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x84"],

        ["\xD1\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x96"],
        ["\x41\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x85"],

        ["\xD1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x97"],
        ["\x41\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x86"],

        ["\xD1\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x98"],
        ["\x41\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x87"],

        ["\xD1\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x99"],
        ["\x41\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x88"],

        ["\xD1\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9A"],
        ["\x41\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x89"],

        ["\xD1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9B"],
        ["\x41\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8A"],

        ["\xD1\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9C"],
        ["\x41\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8B"],

        ["\xD1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9D"],
        ["\x41\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8C"],

        ["\xD1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9E"],
        ["\x41\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8D"],

        ["\xD1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\x9F"],
        ["\x41\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8E"],

        ["\xD1\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xA0"],
        ["\x41\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xD1\x8F"],

        ["\xE2\x94\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x7C"],
        ["\x43\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x80"],

        ["\xE2\x94\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x7D"],
        ["\x43\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x82"],

        ["\xE2\x94\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x7E"],
        ["\x43\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8C"],

        ["\xE2\x94\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\x7F"],
        ["\x43\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x90"],

        ["\xE2\x94\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB0"],
        ["\x43\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x98"],

        ["\xE2\x94\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB1"],
        ["\x43\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x94"],

        ["\xE2\x94\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB2"],
        ["\x43\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9C"],

        ["\xE2\x94\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB3"],
        ["\x43\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAC"],

        ["\xE2\x94\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB4"],
        ["\x43\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA4"],

        ["\xE2\x94\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB5"],
        ["\x43\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB4"],

        ["\xE2\x94\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB6"],
        ["\x43\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBC"],

        ["\xE2\x94\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB7"],
        ["\x43\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x81"],

        ["\xE2\x94\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB8"],
        ["\x43\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x83"],

        ["\xE2\x94\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xB9"],
        ["\x43\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8F"],

        ["\xE2\x94\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE1"],
        ["\x43\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x93"],

        ["\xE2\x94\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE2"],
        ["\x43\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9B"],

        ["\xE2\x94\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE3"],
        ["\x43\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x97"],

        ["\xE2\x94\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE4"],
        ["\x43\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA3"],

        ["\xE2\x94\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE5"],
        ["\x43\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB3"],

        ["\xE2\x94\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE6"],
        ["\x43\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAB"],

        ["\xE2\x94\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE7"],
        ["\x43\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBB"],

        ["\xE2\x95\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE8"],
        ["\x43\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x8B"],

        ["\xE2\x94\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xE9"],
        ["\x43\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA0"],

        ["\xE2\x94\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xEA"],
        ["\x43\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAF"],

        ["\xE2\x94\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xEB"],
        ["\x43\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA8"],

        ["\xE2\x94\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xEC"],
        ["\x43\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB7"],

        ["\xE2\x94\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xED"],
        ["\x43\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBF"],

        ["\xE2\x94\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xEE"],
        ["\x43\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9D"],

        ["\xE2\x94\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xEF"],
        ["\x43\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB0"],

        ["\xE2\x94\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xF0"],
        ["\x43\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA5"],

        ["\xE2\x94\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xF1"],
        ["\x43\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB8"],

        ["\xE2\x95\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x43\xF2"],
        ["\x43\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x82"],

        ["\xE2\x91\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xE2\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA0"],

        ["\xE2\x91\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xE2\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA1"],

        ["\xE2\x91\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xE2\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA2"],

        ["\xE2\x91\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xE2\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA3"],

        ["\xE2\x91\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xE2\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA4"],

        ["\xE2\x91\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xE2\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA5"],

        ["\xE2\x91\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xE2\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA6"],

        ["\xE2\x91\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xE2\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA7"],

        ["\xE2\x91\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xE2\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA8"],

        ["\xE2\x91\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xE2\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA9"],

        ["\xE2\x91\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xE2\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAA"],

        ["\xE2\x91\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xE2\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAB"],

        ["\xE2\x91\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xE2\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAC"],

        ["\xE2\x91\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xE2\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAD"],

        ["\xE2\x91\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xE2\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAE"],

        ["\xE2\x91\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7F"],
        ["\xE2\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAF"],

        ["\xE2\x91\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xE2\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB0"],

        ["\xE2\x91\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\xE2\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB1"],

        ["\xE2\x91\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\xE2\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB2"],

        ["\xE2\x91\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\xE2\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB3"],

        ["\xE2\x85\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF1"],
        ["\x41\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA0"],

        ["\xE2\x85\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF2"],
        ["\x41\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA1"],

        ["\xE2\x85\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF3"],
        ["\x41\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA2"],

        ["\xE2\x85\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF4"],
        ["\x41\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA3"],

        ["\xE2\x85\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF5"],
        ["\x41\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA4"],

        ["\xE2\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF6"],
        ["\x41\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA5"],

        ["\xE2\x85\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF7"],
        ["\x41\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA6"],

        ["\xE2\x85\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF8"],
        ["\x41\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA7"],

        ["\xE2\x85\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xF9"],
        ["\x41\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA8"],

        ["\xE2\x85\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x41\xFA"],
        ["\x41\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA9"],

        ["\xE3\x8D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE8\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x89"],

        ["\xE3\x8C\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xE8\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x94"],

        ["\xE3\x8C\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\xE8\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA2"],

        ["\xE3\x8D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE8\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8D"],

        ["\xE3\x8C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xE8\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x98"],

        ["\xE3\x8C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\xE8\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA7"],

        ["\xE3\x8C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xE8\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x83"],

        ["\xE3\x8C\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\xE8\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xB6"],

        ["\xE3\x8D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE8\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x91"],

        ["\xE3\x8D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE8\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x97"],

        ["\xE3\x8C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xE8\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x8D"],

        ["\xE3\x8C\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\xE8\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA6"],

        ["\xE3\x8C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\xE8\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA3"],

        ["\xE3\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\xE8\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xAB"],

        ["\xE3\x8D\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE8\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8A"],

        ["\xE3\x8C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xE8\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xBB"],

        ["\xE3\x8E\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE8\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9C"],

        ["\xE3\x8E\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE8\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9D"],

        ["\xE3\x8E\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE8\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9E"],

        ["\xE3\x8E\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE8\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8E"],

        ["\xE3\x8E\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE8\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8F"],

        ["\xE3\x8F\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xE9\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x84"],

        ["\xE3\x8E\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\xE8\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\xA1"],

        ["\xE3\x8D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE8\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBB"],

        ["\xE3\x80\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE6\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9D"],

        ["\xE3\x80\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE6\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9F"],

        ["\xE2\x84\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6E"],
        ["\x44\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x96"],

        ["\xE3\x8F\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xE9\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8D"],

        ["\xE2\x84\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6F"],
        ["\x44\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xA1"],

        ["\xE3\x8A\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xE7\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA4"],

        ["\xE3\x8A\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xE7\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA5"],

        ["\xE3\x8A\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xE7\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA6"],

        ["\xE3\x8A\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xE7\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA7"],

        ["\xE3\x8A\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xE7\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA8"],

        ["\xE3\x88\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x44\x6D"],
        ["\x44\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB1"],

        ["\xE3\x88\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE6\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB2"],

        ["\xE3\x88\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE6\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB9"],

        ["\xE3\x8D\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE8\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBE"],

        ["\xE3\x8D\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE8\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBD"],

        ["\xE3\x8D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE8\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBC"],

        ["\xE2\x88\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\xDF\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAE"],

        ["\xE2\x88\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],
        ["\xDF\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x91"],

        ["\xE2\x88\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\xDF\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9F"],

        ["\xE2\x8A\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE0\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xBF"],

        ["\xE4\xBA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x67"],
        ["\x48\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9C"],

        ["\xE5\x94\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD4"],
        ["\x54\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x96"],

        ["\xE5\xA8\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7A"],
        ["\x55\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x83"],

        ["\xE9\x98\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAE"],
        ["\x46\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBF"],

        ["\xE5\x93\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF9"],
        ["\x4E\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x80"],

        ["\xE6\x84\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC6"],
        ["\x45\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9B"],

        ["\xE6\x8C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x81"],
        ["\x4F\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA8"],

        ["\xE5\xA7\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x79"],
        ["\x51\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xB6"],

        ["\xE9\x80\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCE"],
        ["\x4D\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA2"],

        ["\xE8\x91\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD9"],
        ["\x50\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB5"],

        ["\xE8\x8C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE2"],
        ["\x50\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9C"],

        ["\xE7\xA9\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9B"],
        ["\x50\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x90"],

        ["\xE6\x82\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x65"],
        ["\x49\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xAA"],

        ["\xE6\x8F\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x60"],
        ["\x4D\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA1"],

        ["\xE6\xB8\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x43"],
        ["\x4E\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA5"],

        ["\xE6\x97\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xEC"],
        ["\x47\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAD"],

        ["\xE8\x91\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x72"],
        ["\x4E\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA6"],

        ["\xE8\x8A\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDD"],
        ["\x4A\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA6"],

        ["\xE9\xAF\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xAA"],
        ["\x67\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB5"],

        ["\xE6\xA2\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDA"],
        ["\x50\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x93"],

        ["\xE5\x9C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x82"],
        ["\x47\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA7"],

        ["\xE6\x96\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x81"],
        ["\x55\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA1"],

        ["\xE6\x89\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],
        ["\x4C\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB1"],

        ["\xE5\xAE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAB"],
        ["\x50\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9B"],

        ["\xE5\xA7\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9C"],
        ["\x54\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x90"],

        ["\xE8\x99\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x44"],
        ["\x51\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xBB"],

        ["\xE9\xA3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x45"],
        ["\x52\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB4"],

        ["\xE7\xB5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF7"],
        ["\x4E\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA2"],

        ["\xE7\xB6\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDC"],
        ["\x49\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBE"],

        ["\xE9\xAE\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8E"],
        ["\x4F\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8E"],

        ["\xE6\x88\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7F"],
        ["\x4D\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x96"],

        ["\xE7\xB2\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xFB"],
        ["\x4B\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9F"],

        ["\xE8\xA2\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x48"],
        ["\x54\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB7"],

        ["\xE5\xAE\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA8"],
        ["\x45\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x89"],

        ["\xE5\xBA\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xEB"],
        ["\x4E\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB5"],

        ["\xE6\x8C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x89"],
        ["\x54\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x89"],

        ["\xE6\x9A\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE2"],
        ["\x4B\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x97"],

        ["\xE6\xA1\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF1"],
        ["\x48\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x88"],

        ["\xE9\x97\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x64"],
        ["\x53\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x87"],

        ["\xE9\x9E\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4C"],
        ["\x50\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8D"],

        ["\xE6\x9D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD0"],
        ["\x50\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8F"],

        ["\xE4\xBB\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF6"],
        ["\x46\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA5"],

        ["\xE4\xBC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB2"],
        ["\x45\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8A"],

        ["\xE4\xBD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC8"],
        ["\x47\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8D"],

        ["\xE4\xBE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9E"],
        ["\x4A\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9D"],

        ["\xE5\x81\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xFB"],
        ["\x4D\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x89"],

        ["\xE5\x9B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xFA"],
        ["\x4A\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB2"],

        ["\xE5\xA4\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x47"],
        ["\x51\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB7"],

        ["\xE5\xA7\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4F"],
        ["\x48\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x94"],

        ["\xE5\xA8\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],
        ["\x4C\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x81"],

        ["\xE5\xB0\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x89"],
        ["\x51\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x89"],

        ["\xE6\x83\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE0"],
        ["\x4F\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9F"],

        ["\xE6\x84\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x63"],
        ["\x47\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8F"],

        ["\xE6\x85\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAD"],
        ["\x4F\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB0"],

        ["\xE6\x98\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE9"],
        ["\x47\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x93"],

        ["\xE6\xA4\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF7"],
        ["\x4F\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x85"],

        ["\xE7\x82\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD7"],
        ["\x49\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBA"],

        ["\xE7\x95\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8F"],
        ["\x55\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8F"],

        ["\xE7\x95\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA9"],
        ["\x4A\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB0"],

        ["\xE7\xA7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x75"],
        ["\x49\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xBB"],

        ["\xE7\xB6\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x80"],
        ["\x48\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAD"],

        ["\xE7\xB7\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9A"],
        ["\x4E\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAF"],

        ["\xE8\x83\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF6"],
        ["\x4D\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x83"],

        ["\xE8\x90\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x82"],
        ["\x54\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8E"],

        ["\xE8\xA1\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xEA"],
        ["\x4A\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA3"],

        ["\xE8\xAC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x73"],
        ["\x55\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x82"],

        ["\xE9\x81\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBC"],
        ["\x49\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x95"],

        ["\xE9\x81\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDA"],
        ["\x4C\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBA"],

        ["\xE5\x8C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x87"],
        ["\x4A\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBB"],

        ["\xE4\xBA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6D"],
        ["\x45\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x95"],

        ["\xE4\xBA\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7F"],
        ["\x4F\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA5"],

        ["\xE5\x9F\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE9"],
        ["\x48\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9F"],

        ["\xE8\x82\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAC"],
        ["\x48\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB2"],

        ["\xE9\x83\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB3"],
        ["\x49\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x81"],

        ["\xE7\xA3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAA"],
        ["\x48\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAF"],

        ["\xE4\xB8\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x41"],
        ["\x45\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x80"],

        ["\xE5\xA3\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB0"],
        ["\x4E\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB1"],

        ["\xE6\xBA\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x71"],
        ["\x52\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA2"],

        ["\xE9\x80\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD6"],
        ["\x4A\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB8"],

        ["\xE7\xA8\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6A"],
        ["\x47\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB2"],

        ["\xE8\x8C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4C"],
        ["\x47\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA8"],

        ["\xE8\x8A\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9A"],
        ["\x51\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8B"],

        ["\xE9\xB0\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC8"],
        ["\x55\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAF"],

        ["\xE5\x85\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x91"],
        ["\x4C\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x81"],

        ["\xE5\x8D\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x99"],
        ["\x47\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB0"],

        ["\xE5\x92\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB1"],
        ["\x52\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBD"],

        ["\xE5\x93\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCB"],
        ["\x46\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA1"],

        ["\xE5\x9B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x49"],
        ["\x4A\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA0"],

        ["\xE5\xA7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB9"],
        ["\x52\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBB"],

        ["\xE5\xBC\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDA"],
        ["\x46\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x95"],

        ["\xE9\xA3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA3"],
        ["\x4B\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB2"],

        ["\xE6\xB7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4E"],
        ["\x55\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAB"],

        ["\xE8\x83\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE9"],
        ["\x4E\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA4"],

        ["\xE8\x94\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8B"],
        ["\x4E\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAD"],

        ["\xE9\x99\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD8"],
        ["\x49\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA2"],

        ["\xE9\x99\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD2"],
        ["\x4C\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB0"],

        ["\xE9\x9A\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAE"],
        ["\x4E\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA0"],

        ["\xE9\x9F\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x77"],
        ["\x55\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBB"],

        ["\xE5\x90\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBC"],
        ["\x55\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8B"],

        ["\xE5\x8F\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5A"],
        ["\x48\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB3"],

        ["\xE5\xAE\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD5"],
        ["\x46\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x87"],

        ["\xE7\x83\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x99"],
        ["\x50\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8F"],

        ["\xE7\xBE\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8F"],
        ["\x47\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xBD"],

        ["\xE8\xBF\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDF"],
        ["\x55\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x82"],

        ["\xE9\x9B\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDD"],
        ["\x49\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA8"],

        ["\xE5\x8D\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x82"],
        ["\x4C\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAF"],

        ["\xE9\xB5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE7"],
        ["\x4B\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9C"],

        ["\xE7\xAA\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9E"],
        ["\x55\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBA"],

        ["\xE4\xB8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xEC"],
        ["\x4D\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x91"],

        ["\xE7\xA2\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB1"],
        ["\x4F\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x93"],

        ["\xE8\x87\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x89"],
        ["\x4A\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBC"],

        ["\xE6\xB8\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA0"],
        ["\x51\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA6"],

        ["\xE5\x98\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF3"],
        ["\x50\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x98"],

        ["\xE5\x94\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDB"],
        ["\x4C\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x84"],

        ["\xE6\xAC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF7"],
        ["\x55\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9D"],

        ["\xE8\x94\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9A"],
        ["\x54\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9A"],

        ["\xE9\xB0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAB"],
        ["\x54\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBB"],

        ["\xE5\xA7\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x55"],
        ["\x52\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA5"],

        ["\xE5\x8E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x67"],
        ["\x53\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA9"],

        ["\xE6\xB5\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6B"],
        ["\x46\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA6"],

        ["\xE7\x93\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x64"],
        ["\x4E\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9C"],

        ["\xE9\x96\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5F"],
        ["\x54\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8F"],

        ["\xE5\x99\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9B"],
        ["\x52\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x82"],

        ["\xE4\xBA\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9D"],
        ["\x49\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x91"],

        ["\xE9\x81\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAB"],
        ["\x46\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8B"],

        ["\xE9\x9B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBC"],
        ["\x4A\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB2"],

        ["\xE8\x8D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5F"],
        ["\x51\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8F"],

        ["\xE9\xA4\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA7"],
        ["\x50\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8C"],

        ["\xE5\x8F\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x94"],
        ["\x51\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA1"],

        ["\xE5\x96\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD3"],
        ["\x48\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB6"],

        ["\xE5\xAC\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE8"],
        ["\x55\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB0"],

        ["\xE5\xBD\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5E"],
        ["\x49\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB1"],

        ["\xE6\x98\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAC"],
        ["\x47\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA0"],

        ["\xE6\x9B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBC"],
        ["\x4E\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB3"],

        ["\xE6\xA0\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xFA"],
        ["\x45\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x84"],

        ["\xE6\xB0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xFB"],
        ["\x45\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB8"],

        ["\xE6\xB3\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x57"],
        ["\x4F\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB3"],

        ["\xE6\xB4\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB7"],
        ["\x50\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA9"],

        ["\xE7\x91\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x52"],
        ["\x4F\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9B"],

        ["\xE7\x9B\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB5"],
        ["\x51\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x88"],

        ["\xE7\xA9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x54"],
        ["\x52\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8E"],

        ["\xE9\xA0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x76"],
        ["\x55\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB4"],

        ["\xE8\x8B\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xEE"],
        ["\x45\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB1"],

        ["\xE8\xA1\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x80"],
        ["\x47\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9B"],

        ["\xE8\xA9\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC1"],
        ["\x51\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA0"],

        ["\xE9\x8B\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6F"],
        ["\x4D\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAD"],

        ["\xE6\xB6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x45"],
        ["\x4A\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB2"],

        ["\xE7\x96\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCE"],
        ["\x50\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xAB"],

        ["\xE7\x9B\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x74"],
        ["\x47\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8A"],

        ["\xE9\xA7\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAC"],
        ["\x49\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x85"],

        ["\xE6\x82\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x73"],
        ["\x48\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA6"],

        ["\xE8\xAC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE5"],
        ["\x54\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x81"],

        ["\xE8\xB6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDF"],
        ["\x46\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x8A"],

        ["\xE9\x96\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x77"],
        ["\x51\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB2"],

        ["\xE6\xA6\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xEB"],
        ["\x49\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8E"],

        ["\xE5\x8E\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB7"],
        ["\x53\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAD"],

        ["\xE5\x86\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x45"],
        ["\x46\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x86"],

        ["\xE5\x9C\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE1"],
        ["\x47\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x92"],

        ["\xE5\xA0\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA4"],
        ["\x50\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB0"],

        ["\xE5\xA5\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF2"],
        ["\x52\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x84"],

        ["\xE5\xAE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x78"],
        ["\x50\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB4"],

        ["\xE5\xBB\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD0"],
        ["\x47\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB6"],

        ["\xE6\x80\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDE"],
        ["\x54\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA8"],

        ["\xE6\x8E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD0"],
        ["\x55\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA9"],

        ["\xE6\x8F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD5"],
        ["\x4A\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB4"],

        ["\xE6\xB2\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6F"],
        ["\x4E\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBF"],

        ["\xE6\xBC\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xED"],
        ["\x49\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x94"],

        ["\xE7\x82\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAD"],
        ["\x4D\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8E"],

        ["\xE7\x84\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xEE"],
        ["\x53\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x94"],

        ["\xE7\x85\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDD"],
        ["\x4B\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x99"],

        ["\xE7\x87\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x47"],
        ["\x50\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x95"],

        ["\xE7\x8C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],
        ["\x4C\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBF"],

        ["\xE7\xB8\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAA"],
        ["\x4B\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x81"],

        ["\xE8\x89\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x54"],
        ["\x4D\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB6"],

        ["\xE8\x8B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],
        ["\x50\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x91"],

        ["\xE8\x96\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xEC"],
        ["\x4C\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x97"],

        ["\xE9\x81\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE3"],
        ["\x46\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA0"],

        ["\xE9\x89\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD4"],
        ["\x49\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9B"],

        ["\xE9\xB4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC3"],
        ["\x52\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9B"],

        ["\xE5\xA1\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x43"],
        ["\x47\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA9"],

        ["\xE6\x96\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA4"],
        ["\x4D\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBC"],

        ["\xE6\xB1\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x82"],
        ["\x4E\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9A"],

        ["\xE7\x94\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD7"],
        ["\x55\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA5"],

        ["\xE5\x87\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE6"],
        ["\x50\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB9"],

        ["\xE5\xA4\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x92"],
        ["\x47\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAE"],

        ["\xE5\xA5\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE5"],
        ["\x46\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA5"],

        ["\xE5\xBE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xEA"],
        ["\x4C\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x80"],

        ["\xE5\xBF\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x95"],
        ["\x48\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9C"],

        ["\xE6\x8A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE1"],
        ["\x49\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBC"],

        ["\xE6\x97\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA3"],
        ["\x4F\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBA"],

        ["\xE6\xA8\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF2"],
        ["\x45\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAA"],

        ["\xE6\xAC\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA0"],
        ["\x4A\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA7"],

        ["\xE6\xAE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x59"],
        ["\x54\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB4"],

        ["\xE7\x8E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB1"],
        ["\x49\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x8B"],

        ["\xE7\xBF\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xFB"],
        ["\x4F\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x81"],

        ["\xE8\xA5\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6C"],
        ["\x54\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x96"],

        ["\xE9\xB4\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\xD0"],
        ["\x67\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAC"],

        ["\xE9\xB4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x64"],
        ["\x54\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8E"],

        ["\xE9\xBB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC6"],
        ["\x4A\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x84"],

        ["\xE5\xB2\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x72"],
        ["\x45\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA1"],

        ["\xE6\xB2\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xFD"],
        ["\x47\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x96"],

        ["\xE8\x8D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE0"],
        ["\x49\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBB"],

        ["\xE5\x84\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4E"],
        ["\x45\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x84"],

        ["\xE5\xB1\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE9"],
        ["\x45\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8B"],

        ["\xE6\x86\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6C"],
        ["\x4E\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB6"],

        ["\xE8\x87\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x74"],
        ["\x54\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x86"],

        ["\xE6\xA1\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x77"],
        ["\x4E\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB6"],

        ["\xE7\x89\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9A"],
        ["\x50\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA1"],

        ["\xE4\xB9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBD"],
        ["\x4B\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x99"],

        ["\xE4\xBF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x67"],
        ["\x4E\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBA"],

        ["\xE5\x8D\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x79"],
        ["\x4E\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB8"],

        ["\xE6\x81\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x81"],
        ["\x4C\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA9"],

        ["\xE6\xB8\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x50"],
        ["\x49\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA9"],

        ["\xE7\xA9\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB8"],
        ["\x50\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8F"],

        ["\xE9\x9F\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4D"],
        ["\x48\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB3"],

        ["\xE4\xB8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5F"],
        ["\x45\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8B"],

        ["\xE5\x8C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x90"],
        ["\x45\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x96"],

        ["\xE4\xBB\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x71"],
        ["\x4D\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAE"],

        ["\xE4\xBD\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x70"],
        ["\x47\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x95"],

        ["\xE4\xBC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x61"],
        ["\x54\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBD"],

        ["\xE4\xBE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5A"],
        ["\x47\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA1"],

        ["\xE4\xBD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x76"],
        ["\x48\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB3"],

        ["\xE5\x8A\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9F"],
        ["\x45\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA0"],

        ["\xE5\x8F\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC6"],
        ["\x47\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAF"],

        ["\xE5\x98\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7E"],
        ["\x47\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x89"],

        ["\xE5\xA4\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7E"],
        ["\x49\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8F"],

        ["\xE5\xAB\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x89"],
        ["\x4E\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x81"],

        ["\xE5\xAE\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x86"],
        ["\x46\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB6"],

        ["\xE5\xAF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB8"],
        ["\x52\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA1"],

        ["\xE7\xA7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xED"],
        ["\x48\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x91"],

        ["\xE6\x9A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x46"],
        ["\x4F\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x87"],

        ["\xE6\x9E\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB9"],
        ["\x47\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9C"],

        ["\xE6\x9E\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE8"],
        ["\x4E\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB6"],

        ["\xE6\xAD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF7"],
        ["\x46\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8C"],

        ["\xE6\xB2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5A"],
        ["\x46\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB3"],

        ["\xE7\x81\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x85"],
        ["\x47\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAB"],

        ["\xE7\x8F\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9A"],
        ["\x4C\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x82"],

        ["\xE7\xA6\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x86"],
        ["\x52\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8D"],

        ["\xE7\xA6\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x63"],
        ["\x54\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBE"],

        ["\xE7\xA8\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBE"],
        ["\x4D\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBC"],

        ["\xE7\xAE\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x51"],
        ["\x4F\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x87"],

        ["\xE8\x8A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD9"],
        ["\x46\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB1"],

        ["\xE8\x8B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x77"],
        ["\x53\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9B"],

        ["\xE8\x8C\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7A"],
        ["\x54\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x84"],

        ["\xE8\x8D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA1"],
        ["\x4B\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB7"],

        ["\xE8\x8F\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6C"],
        ["\x4B\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAF"],

        ["\xE8\x8F\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x51"],
        ["\x4C\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x93"],

        ["\xE8\x9D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC3"],
        ["\x51\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA6"],

        ["\xE8\xAA\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD6"],
        ["\x49\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB2"],

        ["\xE5\x98\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCA"],
        ["\x52\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xA9"],

        ["\xE8\xB2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xEB"],
        ["\x4A\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA8"],

        ["\xE8\xBF\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5D"],
        ["\x53\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA6"],

        ["\xE9\x81\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8D"],
        ["\x48\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8E"],

        ["\xE9\x9C\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE4"],
        ["\x4E\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9E"],

        ["\xE8\x9A\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAA"],
        ["\x4F\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8A"],

        ["\xE4\xBF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC7"],
        ["\x54\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x84"],

        ["\xE5\xB3\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9D"],
        ["\x4F\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA8"],

        ["\xE6\x88\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDE"],
        ["\x49\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x91"],

        ["\xE7\x89\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xFC"],
        ["\x53\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x99"],

        ["\xE7\x94\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x77"],
        ["\x46\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBB"],

        ["\xE8\x87\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8A"],
        ["\x53\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA5"],

        ["\xE8\x8A\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBA"],
        ["\x4E\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBD"],

        ["\xE8\x9B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x99"],
        ["\x55\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBE"],

        ["\xE8\xB3\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x41"],
        ["\x46\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x80"],

        ["\xE9\x9B\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x45"],
        ["\x47\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x85"],

        ["\xE9\xA4\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4B"],
        ["\x55\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x93"],

        ["\xE9\xA7\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBE"],
        ["\x53\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x95"],

        ["\xE4\xBB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4B"],
        ["\x48\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8B"],

        ["\xE4\xBC\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBD"],
        ["\x45\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9A"],

        ["\xE8\xA7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB7"],
        ["\x47\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA3"],

        ["\xE5\x9B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA9"],
        ["\x46\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9E"],

        ["\xE5\xA1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x53"],
        ["\x50\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8A"],

        ["\xE5\xA3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC8"],
        ["\x4E\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8A"],

        ["\xE5\xBB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAF"],
        ["\x4B\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBB"],

        ["\xE5\xBF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],
        ["\x4C\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAB"],

        ["\xE6\x80\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x71"],
        ["\x4E\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAA"],

        ["\xE6\x82\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x91"],
        ["\x50\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x94"],

        ["\xE6\x81\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x94"],
        ["\x55\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA2"],

        ["\xE6\x87\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF2"],
        ["\x4E\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x90"],

        ["\xE6\x88\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA0"],
        ["\x4D\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x92"],

        ["\xE6\x8B\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA2"],
        ["\x53\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x90"],

        ["\xE6\x94\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8F"],
        ["\x48\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB9"],

        ["\xE9\xAD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCB"],
        ["\x52\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x81"],

        ["\xE6\x99\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6D"],
        ["\x55\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA6"],

        ["\xE6\xA2\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x82"],
        ["\x46\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB0"],

        ["\xE6\xB5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA7"],
        ["\x45\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB7"],

        ["\xE7\x81\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF5"],
        ["\x4A\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB0"],

        ["\xE7\x95\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAE"],
        ["\x47\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8C"],

        ["\xE7\x9A\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB0"],
        ["\x4A\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x86"],

        ["\xE7\xB5\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE4"],
        ["\x4A\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB5"],

        ["\xE8\x8A\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7B"],
        ["\x4F\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA5"],

        ["\xE8\x9F\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x90"],
        ["\x50\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB9"],

        ["\xE9\x96\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCD"],
        ["\x46\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8B"],

        ["\xE9\x9A\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA9"],
        ["\x49\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8E"],

        ["\xE8\xB2\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xEA"],
        ["\x49\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9D"],

        ["\xE5\x87\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAC"],
        ["\x51\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB1"],

        ["\xE5\x8A\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6A"],
        ["\x55\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBE"],

        ["\xE5\xA4\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x94"],
        ["\x46\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x96"],

        ["\xE5\x92\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE9"],
        ["\x53\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB3"],

        ["\xE5\xAE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x68"],
        ["\x49\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB3"],

        ["\xE5\xB4\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x74"],
        ["\x50\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x96"],

        ["\xE6\x85\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8A"],
        ["\x52\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA8"],

        ["\xE6\xA6\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x42"],
        ["\x4C\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x82"],

        ["\xE6\xB6\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x91"],
        ["\x4F\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAF"],

        ["\xE7\xA2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x56"],
        ["\x53\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8D"],

        ["\xE8\x93\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6D"],
        ["\x4F\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8B"],

        ["\xE8\xA1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA5"],
        ["\x4B\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x97"],

        ["\xE8\xA9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8D"],
        ["\x4D\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB2"],

        ["\xE9\x8E\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6D"],
        ["\x54\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA7"],

        ["\xE9\xAA\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9C"],
        ["\x55\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB8"],

        ["\xE6\xB5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCC"],
        ["\x55\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAC"],

        ["\xE9\xA6\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x85"],
        ["\x4B\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA8"],

        ["\xE8\x9B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBB"],
        ["\x55\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x99"],

        ["\xE5\x9E\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCE"],
        ["\x47\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA3"],

        ["\xE6\x9F\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC1"],
        ["\x4A\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBF"],

        ["\xE8\x9B\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE1"],
        ["\x62\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8E"],

        ["\xE9\x88\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8F"],
        ["\x53\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8E"],

        ["\xE5\x8A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD6"],
        ["\x55\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x83"],

        ["\xE5\x9A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD8"],
        ["\x55\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x87"],

        ["\xE5\x90\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBA"],
        ["\x47\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x84"],

        ["\xE5\xBB\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAD"],
        ["\x54\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x93"],

        ["\xE6\x8B\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE5"],
        ["\x48\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA1"],

        ["\xE6\x92\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x52"],
        ["\x5B\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB9"],

        ["\xE6\xA0\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDE"],
        ["\x47\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBC"],

        ["\xE6\xA0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9E"],
        ["\x4B\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB8"],

        ["\xE6\xAE\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC0"],
        ["\x50\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBB"],

        ["\xE7\x8D\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x61"],
        ["\x4D\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB2"],

        ["\xE7\xA2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7A"],
        ["\x48\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBA"],

        ["\xE7\xA9\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5C"],
        ["\x4F\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAB"],

        ["\xE8\xA6\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],
        ["\x4A\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x9A"],

        ["\xE8\xA7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7D"],
        ["\x47\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x92"],

        ["\xE8\xB5\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCC"],
        ["\x53\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAB"],

        ["\xE8\xBC\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],
        ["\x4A\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x83"],

        ["\xE9\x83\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x62"],
        ["\x51\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAD"],

        ["\xE9\x96\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE9"],
        ["\x4A\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA3"],

        ["\xE9\x9A\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5A"],
        ["\x50\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x94"],

        ["\xE9\x9D\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA3"],
        ["\x4A\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA9"],

        ["\xE5\xAD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBE"],
        ["\x45\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA6"],

        ["\xE5\xB2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x46"],
        ["\x4D\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB3"],

        ["\xE6\xA5\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x61"],
        ["\x47\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBD"],

        ["\xE9\xA1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF1"],
        ["\x47\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8D"],

        ["\xE9\xA1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8E"],
        ["\x54\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8E"],

        ["\xE6\x8E\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE3"],
        ["\x4A\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9B"],

        ["\xE7\xAC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE0"],
        ["\x47\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA0"],

        ["\xE6\xA8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6F"],
        ["\x4B\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAB"],

        ["\xE6\xA9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB2"],
        ["\x4F\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBF"],

        ["\xE6\xA2\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAD"],
        ["\x49\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB6"],

        ["\xE9\xB0\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x71"],
        ["\x55\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8D"],

        ["\xE6\xBD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC2"],
        ["\x46\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9F"],

        ["\xE5\x89\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD6"],
        ["\x47\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB2"],

        ["\xE5\x96\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x75"],
        ["\x54\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9D"],

        ["\xE6\x81\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x84"],
        ["\x53\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB0"],

        ["\xE6\x8B\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC5"],
        ["\x4F\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAC"],

        ["\xE6\xB4\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB4"],
        ["\x47\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBB"],

        ["\xE6\xB8\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x41"],
        ["\x54\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x87"],

        ["\xE6\xBB\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA2"],
        ["\x4B\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x91"],

        ["\xE8\x91\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDF"],
        ["\x48\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9B"],

        ["\xE8\xA4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5E"],
        ["\x54\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x90"],

        ["\xE8\xBD\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xFE"],
        ["\x50\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x84"],

        ["\xE4\xB8\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x97"],
        ["\x4F\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x94"],

        ["\xE9\xB0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD5"],
        ["\x53\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB9"],

        ["\xE5\x8F\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x59"],
        ["\x4F\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB6"],

        ["\xE6\xA4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x63"],
        ["\x51\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9B"],

        ["\xE6\xA8\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x69"],
        ["\x4E\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBA"],

        ["\xE9\x9E\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x45"],
        ["\x54\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x84"],

        ["\xE6\xA0\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x56"],
        ["\x48\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAA"],

        ["\xE5\x85\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBE"],
        ["\x51\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9C"],

        ["\xE7\xAB\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x46"],
        ["\x60\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x83"],

        ["\xE8\x92\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB2"],
        ["\x49\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB2"],

        ["\xE9\x87\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCC"],
        ["\x4A\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9C"],

        ["\xE9\x8E\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x62"],
        ["\x49\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x8C"],

        ["\xE5\x99\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7D"],
        ["\x54\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x9B"],

        ["\xE9\xB4\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x54"],
        ["\x4C\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA8"],

        ["\xE6\xA0\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x42"],
        ["\x52\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA2"],

        ["\xE8\x8C\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD3"],
        ["\x4B\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x85"],

        ["\xE8\x90\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7C"],
        ["\x4F\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB1"],

        ["\xE7\xB2\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAB"],
        ["\x52\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA5"],

        ["\xE5\x88\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9B"],
        ["\x4B\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x88"],

        ["\xE8\x8B\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5D"],
        ["\x4E\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x85"],

        ["\xE7\x93\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC2"],
        ["\x49\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA6"],

        ["\xE4\xB9\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x70"],
        ["\x49\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xBE"],

        ["\xE4\xBE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x98"],
        ["\x4F\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x83"],

        ["\xE5\x86\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7B"],
        ["\x4E\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA0"],

        ["\xE5\xAF\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x81"],
        ["\x4B\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x92"],

        ["\xE5\x88\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD7"],
        ["\x4C\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8A"],

        ["\xE5\x8B\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9A"],
        ["\x4B\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x98"],

        ["\xE5\x8B\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],
        ["\x4C\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA7"],

        ["\xE5\xB7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x93"],
        ["\x48\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBB"],

        ["\xE5\x96\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB5"],
        ["\x52\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9A"],

        ["\xE5\xA0\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAC"],
        ["\x4F\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAA"],

        ["\xE5\xA7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDE"],
        ["\x55\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA6"],

        ["\xE5\xAE\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC5"],
        ["\x48\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8C"],

        ["\xE5\xAE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA2"],
        ["\x49\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x98"],

        ["\xE5\xAF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF8"],
        ["\x47\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9B"],

        ["\xE5\xB9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],
        ["\x4A\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB2"],

        ["\xE5\xB9\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDA"],
        ["\x48\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB9"],

        ["\xE6\x82\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xEB"],
        ["\x4D\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA3"],

        ["\xE6\x84\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF7"],
        ["\x47\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9F"],

        ["\xE6\x85\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD3"],
        ["\x4D\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA3"],

        ["\xE6\x86\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA5"],
        ["\x51\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBE"],

        ["\xE6\x8F\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAA"],
        ["\x49\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9B"],

        ["\xE6\x95\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCF"],
        ["\x4F\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA2"],

        ["\xE6\x9F\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC1"],
        ["\x4E\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x91"],

        ["\xE6\xA1\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6D"],
        ["\x53\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x93"],

        ["\xE6\xA3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB6"],
        ["\x55\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBA"],

        ["\xE6\xAC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xFB"],
        ["\x4E\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBE"],

        ["\xE6\xAD\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4E"],
        ["\x4D\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x93"],

        ["\xE6\xB1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC4"],
        ["\x4E\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x97"],

        ["\xE6\xBC\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x58"],
        ["\x4F\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA2"],

        ["\xE6\xBE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBA"],
        ["\x54\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x97"],

        ["\xE6\xBD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAA"],
        ["\x5D\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x85"],

        ["\xE7\x92\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB9"],
        ["\x4A\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB0"],

        ["\xE7\x94\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x55"],
        ["\x4B\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x98"],

        ["\xE7\x9B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE3"],
        ["\x49\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA3"],

        ["\xE7\x9C\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA2"],
        ["\x4D\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8B"],

        ["\xE7\xAB\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x87"],
        ["\x52\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBF"],

        ["\xE7\xAE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF2"],
        ["\x46\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xA1"],

        ["\xE7\xB0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xEC"],
        ["\x4B\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA1"],

        ["\xE7\xB7\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xFC"],
        ["\x4C\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA9"],

        ["\xE7\xBC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x84"],
        ["\x50\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB6"],

        ["\xE7\xBF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB6"],
        ["\x54\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB0"],

        ["\xE8\x82\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8C"],
        ["\x4C\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9D"],

        ["\xE8\x89\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],
        ["\x4C\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA6"],

        ["\xE8\x8E\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xEE"],
        ["\x51\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9E"],

        ["\xE8\xA6\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7E"],
        ["\x48\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB3"],

        ["\xE8\xAB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"],
        ["\x63\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8C"],

        ["\xE8\xB2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA1"],
        ["\x49\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAB"],

        ["\xE9\x82\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA9"],
        ["\x4D\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x84"],

        ["\xE9\x91\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4E"],
        ["\x4E\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x91"],

        ["\xE9\x96\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC1"],
        ["\x45\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x93"],

        ["\xE9\x96\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD9"],
        ["\x4D\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x91"],

        ["\xE9\x96\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC5"],
        ["\x45\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA2"],

        ["\xE9\x99\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xFE"],
        ["\x4F\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA5"],

        ["\xE9\x9F\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x75"],
        ["\x4E\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x93"],

        ["\xE9\xA4\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x62"],
        ["\x48\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA8"],

        ["\xE8\x88\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAA"],
        ["\x4C\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x98"],

        ["\xE4\xB8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7A"],
        ["\x46\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB8"],

        ["\xE5\x90\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCB"],
        ["\x49\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAB"],

        ["\xE5\xB2\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x48"],
        ["\x47\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB8"],

        ["\xE5\xB7\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCF"],
        ["\x49\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8C"],

        ["\xE7\x8E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4C"],
        ["\x4E\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA9"],

        ["\xE7\x99\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x47"],
        ["\x54\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x8C"],

        ["\xE7\x9C\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA5"],
        ["\x49\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBC"],

        ["\xE5\xB2\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBF"],
        ["\x45\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA9"],

        ["\xE7\xBF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8B"],
        ["\x55\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAB"],

        ["\xE8\xB4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x84"],
        ["\x55\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8B"],

        ["\xE9\x9B\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA4"],
        ["\x51\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x81"],

        ["\xE9\xA0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9D"],
        ["\x53\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x91"],

        ["\xE9\xA1\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB8"],
        ["\x48\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x94"],

        ["\xE9\xA1\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],
        ["\x4C\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x98"],

        ["\xE4\xBC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD2"],
        ["\x47\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x81"],

        ["\xE4\xBC\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9F"],
        ["\x4E\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8E"],

        ["\xE5\x8D\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x91"],
        ["\x4B\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB1"],

        ["\xE5\x96\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD1"],
        ["\x45\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9C"],

        ["\xE5\x99\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xFC"],
        ["\x45\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA8"],

        ["\xE5\x9F\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF1"],
        ["\x46\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBA"],

        ["\xE5\xA5\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x69"],
        ["\x4D\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x87"],

        ["\xE5\xAC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8B"],
        ["\x4F\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x89"],

        ["\xE5\xAF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDF"],
        ["\x49\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x84"],

        ["\xE5\xB2\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4A"],
        ["\x47\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x90"],

        ["\xE5\xB8\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB5"],
        ["\x4A\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8C"],

        ["\xE5\xB9\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x57"],
        ["\x4B\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBE"],

        ["\xE5\xBF\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x97"],
        ["\x50\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8C"],

        ["\xE6\x8F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF2"],
        ["\x4B\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAE"],

        ["\xE6\x9C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x96"],
        ["\x4D\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBA"],

        ["\xE6\x97\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAB"],
        ["\x4D\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x97"],

        ["\xE6\x97\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x77"],
        ["\x4B\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA2"],

        ["\xE6\x9C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8B"],
        ["\x46\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9F"],

        ["\xE6\xA3\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF1"],
        ["\x4E\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8B"],

        ["\xE6\xA3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB1"],
        ["\x4E\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x84"],

        ["\xE6\xA9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x79"],
        ["\x45\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x9F"],

        ["\xE5\xB8\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x82"],
        ["\x49\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB0"],

        ["\xE6\xAF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],
        ["\x4A\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x85"],

        ["\xE6\xB0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB9"],
        ["\x45\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x97"],

        ["\xE6\xB1\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4C"],
        ["\x49\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBD"],

        ["\xE7\x95\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD4"],
        ["\x50\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBF"],

        ["\xE7\xA5\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD8"],
        ["\x4E\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x88"],

        ["\xE5\xAD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xEC"],
        ["\x4A\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA3"],

        ["\xE7\xA8\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x64"],
        ["\x52\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x80"],

        ["\xE7\xB4\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDB"],
        ["\x46\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x80"],

        ["\xE5\xBE\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE0"],
        ["\x55\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBD"],

        ["\xE8\xA6\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xFB"],
        ["\x46\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8F"],

        ["\xE8\xA8\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x94"],
        ["\x47\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x98"],

        ["\xE8\xB2\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7F"],
        ["\x48\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB4"],

        ["\xE8\xB5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD0"],
        ["\x48\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB7"],

        ["\xE8\xBB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAA"],
        ["\x4D\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8C"],

        ["\xE8\xBC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x87"],
        ["\x47\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9D"],

        ["\xE9\xA3\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCE"],
        ["\x53\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA2"],

        ["\xE9\xA8\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x58"],
        ["\x50\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8E"],

        ["\xE9\xAC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC8"],
        ["\x4A\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBC"],

        ["\xE4\xBA\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC0"],
        ["\x47\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x80"],

        ["\xE5\x81\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x59"],
        ["\x50\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xBD"],

        ["\xE5\x84\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCA"],
        ["\x49\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x80"],

        ["\xE5\xA6\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x95"],
        ["\x53\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x93"],

        ["\xE5\xAE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8B"],
        ["\x4D\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9C"],

        ["\xE6\x88\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x92"],
        ["\x4F\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAF"],

        ["\xE6\x8A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF7"],
        ["\x48\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x80"],

        ["\xE6\x93\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCD"],
        ["\x4F\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAC"],

        ["\xE6\xAC\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7D"],
        ["\x51\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBA"],

        ["\xE7\x8A\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDC"],
        ["\x4F\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA0"],

        ["\xE7\x96\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB4"],
        ["\x4C\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x91"],

        ["\xE7\xA5\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x92"],
        ["\x51\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x87"],

        ["\xE7\xBE\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x98"],
        ["\x45\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA9"],

        ["\xE8\x9F\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC6"],
        ["\x51\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBB"],

        ["\xE8\xAA\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x65"],
        ["\x52\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBC"],

        ["\xE8\xAD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x81"],
        ["\x47\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB0"],

        ["\xE6\x8E\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x41"],
        ["\x55\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAC"],

        ["\xE8\x8F\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD7"],
        ["\x46\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8A"],

        ["\xE9\x9E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xED"],
        ["\x51\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA0"],

        ["\xE5\x90\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7E"],
        ["\x45\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x89"],

        ["\xE5\x90\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xEA"],
        ["\x55\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x83"],

        ["\xE5\x96\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6D"],
        ["\x4D\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAB"],

        ["\xE6\xA1\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4B"],
        ["\x53\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x94"],

        ["\xE6\xA9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC2"],
        ["\x4B\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x98"],

        ["\xE8\xA9\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5F"],
        ["\x4B\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB0"],

        ["\xE7\xA0\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x48"],
        ["\x52\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA7"],

        ["\xE6\x9D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA6"],
        ["\x4A\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB5"],

        ["\xE9\xBB\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAE"],
        ["\x55\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8D"],

        ["\xE5\x8D\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA4"],
        ["\x4A\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB4"],

        ["\xE5\xAE\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDE"],
        ["\x4A\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA2"],

        ["\xE8\x84\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5C"],
        ["\x4D\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9A"],

        ["\xE8\x99\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x60"],
        ["\x52\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x90"],

        ["\xE9\x80\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xFC"],
        ["\x4B\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x86"],

        ["\xE4\xB8\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x56"],
        ["\x4D\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x98"],

        ["\xE4\xB9\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8A"],
        ["\x45\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x85"],

        ["\xE4\xBB\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x85"],
        ["\x50\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x87"],

        ["\xE4\xBC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x81"],
        ["\x4A\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x91"],

        ["\xE5\x8F\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5C"],
        ["\x48\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8A"],

        ["\xE5\x90\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x98"],
        ["\x4B\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB8"],

        ["\xE5\xAE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x92"],
        ["\x45\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xAE"],

        ["\xE5\xBC\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x63"],
        ["\x4B\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x93"],

        ["\xE6\x80\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCC"],
        ["\x47\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA5"],

        ["\xE6\x95\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],
        ["\x4C\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x91"],

        ["\xE6\x9C\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF0"],
        ["\x50\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBD"],

        ["\xE6\xB1\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA0"],
        ["\x49\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x82"],

        ["\xE6\xB1\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC8"],
        ["\x50\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB2"],

        ["\xE6\xB3\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4B"],
        ["\x4D\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA3"],

        ["\xE7\x81\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x73"],
        ["\x54\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB8"],

        ["\xE7\x90\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDB"],
        ["\x48\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x83"],

        ["\xE7\xA9\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x86"],
        ["\x49\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB6"],

        ["\xE7\xAA\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAA"],
        ["\x50\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAE"],

        ["\xE7\xAC\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCF"],
        ["\x51\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x88"],

        ["\xE7\xB4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF3"],
        ["\x49\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9A"],

        ["\xE7\xB3\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xFE"],
        ["\x51\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBE"],

        ["\xE7\xB5\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x57"],
        ["\x47\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA6"],

        ["\xE6\x97\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],
        ["\x4C\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA7"],

        ["\xE7\x89\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x73"],
        ["\x49\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9B"],

        ["\xE5\x8E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCA"],
        ["\x4A\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xBB"],

        ["\xE5\xB1\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5E"],
        ["\x48\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x85"],

        ["\xE5\xB7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x52"],
        ["\x4A\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA8"],

        ["\xE6\x8B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x61"],
        ["\x4F\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x92"],

        ["\xE6\x8B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x77"],
        ["\x4D\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA0"],

        ["\xE6\x8C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x82"],
        ["\x4B\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x99"],

        ["\xE6\xB8\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7A"],
        ["\x52\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA0"],

        ["\xE8\x99\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x72"],
        ["\x4F\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9A"],

        ["\xE8\xA8\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9A"],
        ["\x4A\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB1"],

        ["\xE8\xB7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC2"],
        ["\x4D\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9D"],

        ["\xE9\x8B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE7"],
        ["\x51\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB8"],

        ["\xE6\xBC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x78"],
        ["\x4B\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x81"],

        ["\xE7\xA6\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAA"],
        ["\x55\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA6"],

        ["\xE9\xAD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xEE"],
        ["\x48\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x9A"],

        ["\xE4\xBA\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAC"],
        ["\x4B\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA8"],

        ["\xE4\xBA\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x73"],
        ["\x4B\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAB"],

        ["\xE4\xBA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x75"],
        ["\x45\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAC"],

        ["\xE4\xBE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBC"],
        ["\x48\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9B"],

        ["\xE4\xBE\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xEC"],
        ["\x52\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA0"],

        ["\xE5\x83\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAD"],
        ["\x55\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x91"],

        ["\xE5\x85\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5A"],
        ["\x55\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x87"],

        ["\xE7\xAB\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x71"],
        ["\x49\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB6"],

        ["\xE5\x85\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB3"],
        ["\x47\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB1"],

        ["\xE5\x87\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xEC"],
        ["\x51\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB6"],

        ["\xE5\x8D\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD7"],
        ["\x47\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x94"],

        ["\xE5\x8C\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4D"],
        ["\x4D\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA1"],

        ["\xE5\x8D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE2"],
        ["\x53\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBF"],

        ["\xE5\x8F\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD5"],
        ["\x4D\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAB"],

        ["\xE5\x96\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],
        ["\x4C\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAC"],

        ["\xE5\xA2\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x95"],
        ["\x4A\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x83"],

        ["\xE5\xB3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB3"],
        ["\x51\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA1"],

        ["\xE5\xBC\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD2"],
        ["\x46\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB7"],

        ["\xE5\xBD\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x85"],
        ["\x53\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8A"],

        ["\xE6\x80\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x42"],
        ["\x55\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAF"],

        ["\xE6\x81\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD5"],
        ["\x4B\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x90"],

        ["\xE6\x81\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4E"],
        ["\x49\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAD"],

        ["\xE6\x8C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB1"],
        ["\x55\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x9F"],

        ["\xE6\x95\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA5"],
        ["\x47\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x99"],

        ["\xE6\xA9\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x89"],
        ["\x45\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x8B"],

        ["\xE6\xB3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x58"],
        ["\x4A\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x81"],

        ["\xE7\x8B\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5A"],
        ["\x4E\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x82"],

        ["\xE7\x8B\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9E"],
        ["\x4C\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAD"],

        ["\xE7\x9F\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBB"],
        ["\x51\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAF"],

        ["\xE8\x83\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE3"],
        ["\x4B\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB8"],

        ["\xE8\x84\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x51"],
        ["\x50\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x85"],

        ["\xE8\x88\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6A"],
        ["\x46\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x88"],

        ["\xE8\x95\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x65"],
        ["\x55\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8E"],

        ["\xE9\x83\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x95"],
        ["\x49\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB7"],

        ["\xE9\x8F\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8D"],
        ["\x4A\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA1"],

        ["\xE9\x9F\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],
        ["\x4A\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBF"],

        ["\xE9\xA5\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD5"],
        ["\x51\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x97"],

        ["\xE9\xA9\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD5"],
        ["\x4C\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9A"],

        ["\xE4\xBB\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xED"],
        ["\x4D\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB0"],

        ["\xE5\x87\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD9"],
        ["\x4E\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9D"],

        ["\xE5\xB0\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x80"],
        ["\x68\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xAD"],

        ["\xE6\x9A\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x83"],
        ["\x4C\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x81"],

        ["\xE6\xA5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6B"],
        ["\x45\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAD"],

        ["\xE5\xB1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8B"],
        ["\x48\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x80"],

        ["\xE6\x9B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB6"],
        ["\x49\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB2"],

        ["\xE6\xA5\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB7"],
        ["\x49\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB5"],

        ["\xE7\x8E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xFD"],
        ["\x45\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x89"],

        ["\xE6\xA1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC0"],
        ["\x49\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x90"],

        ["\xE7\xB2\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE7"],
        ["\x55\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x81"],

        ["\xE5\x83\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC9"],
        ["\x4F\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x85"],

        ["\xE5\x8B\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9F"],
        ["\x49\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA4"],

        ["\xE5\x9D\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAE"],
        ["\x49\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x87"],

        ["\xE5\xB7\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],
        ["\x4A\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBE"],

        ["\xE9\x8C\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8E"],
        ["\x4B\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA6"],

        ["\xE6\x96\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCF"],
        ["\x54\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA4"],

        ["\xE6\xAC\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9D"],
        ["\x4B\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA3"],

        ["\xE6\xAC\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF8"],
        ["\x4C\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBD"],

        ["\xE7\x90\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD8"],
        ["\x4C\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB4"],

        ["\xE7\xA6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x75"],
        ["\x4D\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x81"],

        ["\xE7\xA6\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5D"],
        ["\x55\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBD"],

        ["\xE7\xAD\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8F"],
        ["\x4B\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8B"],

        ["\xE7\xB7\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x97"],
        ["\x4B\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8A"],

        ["\xE8\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD0"],
        ["\x4D\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB9"],

        ["\xE8\x8F\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],
        ["\x4C\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8C"],

        ["\xE8\xA1\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA7"],
        ["\x4A\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBF"],

        ["\xE8\xA5\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAF"],
        ["\x54\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9F"],

        ["\xE8\xAC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x87"],
        ["\x4D\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB9"],

        ["\xE8\xBF\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x73"],
        ["\x46\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x91"],

        ["\xE9\x87\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x86"],
        ["\x45\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x91"],

        ["\xE5\x90\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7A"],
        ["\x50\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9F"],

        ["\xE9\x8A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8C"],
        ["\x47\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x80"],

        ["\xE4\xB9\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x49"],
        ["\x45\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9D"],

        ["\xE5\x80\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x63"],
        ["\x4F\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB6"],

        ["\xE5\x8F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8B"],
        ["\x4C\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA5"],

        ["\xE5\x8C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x54"],
        ["\x45\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBA"],

        ["\xE7\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x74"],
        ["\x52\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x97"],

        ["\xE7\x8E\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE9"],
        ["\x4D\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x96"],

        ["\xE7\x9F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4D"],
        ["\x4E\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA9"],

        ["\xE8\x8B\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],
        ["\x4A\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA6"],

        ["\xE8\xBA\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x53"],
        ["\x53\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAF"],

        ["\xE9\xA7\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xFE"],
        ["\x4C\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x86"],

        ["\xE9\xA7\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x85"],
        ["\x4F\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x88"],

        ["\xE9\xA7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xFC"],
        ["\x49\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x92"],

        ["\xE5\x85\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAF"],
        ["\x47\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB7"],

        ["\xE6\x84\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB2"],
        ["\x52\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9A"],

        ["\xE8\x99\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x88"],
        ["\x55\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9E"],

        ["\xE5\x96\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB9"],
        ["\x4E\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB0"],

        ["\xE7\xA9\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8D"],
        ["\x47\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBA"],

        ["\xE5\x81\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC3"],
        ["\x50\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB6"],

        ["\xE5\xAF\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF4"],
        ["\x55\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x93"],

        ["\xE9\x81\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xEC"],
        ["\x49\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x87"],

        ["\xE9\x9A\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB9"],
        ["\x4B\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x85"],

        ["\xE4\xB8\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB8"],
        ["\x4C\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB2"],

        ["\xE6\xAB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA6"],
        ["\x4D\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9B"],

        ["\xE9\x87\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF0"],
        ["\x4B\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA7"],

        ["\xE5\xB1\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB2"],
        ["\x54\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x91"],

        ["\xE5\xB1\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x94"],
        ["\x4D\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x88"],

        ["\xE6\x8E\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x44"],
        ["\x4D\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x98"],

        ["\xE7\xAA\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA6"],
        ["\x50\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x9F"],

        ["\xE6\xB2\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF8"],
        ["\x4F\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x93"],

        ["\xE9\x9D\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF1"],
        ["\x4D\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB4"],

        ["\xE8\xBD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE1"],
        ["\x52\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA1"],

        ["\xE7\xAA\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],
        ["\x4A\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAA"],

        ["\xE7\x86\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7F"],
        ["\x46\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8A"],

        ["\xE9\x9A\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE5"],
        ["\x4C\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x88"],

        ["\xE7\xB2\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x85"],
        ["\x4E\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x82"],

        ["\xE6\xA0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9B"],
        ["\x47\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x97"],

        ["\xE7\xB9\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x69"],
        ["\x4B\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB0"],

        ["\xE6\xA1\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x79"],
        ["\x48\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x91"],

        ["\xE9\x8D\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x70"],
        ["\x4F\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAC"],

        ["\xE5\x8B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7A"],
        ["\x49\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB2"],

        ["\xE5\x90\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCF"],
        ["\x47\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9B"],

        ["\xE8\x96\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x98"],
        ["\x49\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAB"],

        ["\xE8\xA8\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC8"],
        ["\x4B\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x93"],

        ["\xE7\xBE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB1"],
        ["\x47\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA4"],

        ["\xE8\xBB\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x97"],
        ["\x48\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8D"],

        ["\xE9\x83\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9E"],
        ["\x49\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA1"],

        ["\xE5\x8D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDB"],
        ["\x53\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA6"],

        ["\xE8\xA2\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6A"],
        ["\x4F\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x88"],

        ["\xE7\xA5\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD2"],
        ["\x53\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x81"],

        ["\xE4\xBF\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x51"],
        ["\x48\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x82"],

        ["\xE5\x82\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x43"],
        ["\x4A\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBE"],

        ["\xE5\x88\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x52"],
        ["\x4C\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x91"],

        ["\xE5\x85\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE8"],
        ["\x4B\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x84"],

        ["\xE5\x95\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE4"],
        ["\x47\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x93"],

        ["\xE5\x9C\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE6"],
        ["\x49\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xAD"],

        ["\xE7\x8F\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB9"],
        ["\x4C\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAA"],

        ["\xE5\x9E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE6"],
        ["\x46\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x8B"],

        ["\xE5\xA5\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],
        ["\x4C\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x91"],

        ["\xE5\xBD\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x90"],
        ["\x46\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA2"],

        ["\xE5\xBE\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x60"],
        ["\x4E\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x84"],

        ["\xE6\x81\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x43"],
        ["\x46\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB5"],

        ["\xE6\x85\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA8"],
        ["\x48\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB6"],

        ["\xE6\x85\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB6"],
        ["\x4E\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA7"],

        ["\xE6\x86\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x75"],
        ["\x51\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA9"],

        ["\xE6\x8E\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC1"],
        ["\x4D\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB2"],

        ["\xE6\x90\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x49"],
        ["\x4E\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBA"],

        ["\xE6\x95\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB0"],
        ["\x47\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xAC"],

        ["\xE6\x99\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x93"],
        ["\x49\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAF"],

        ["\xE6\xA1\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAB"],
        ["\x49\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x82"],

        ["\xE6\xB8\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x98"],
        ["\x51\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x93"],

        ["\xE7\x95\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB4"],
        ["\x51\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA6"],

        ["\xE7\xA8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC7"],
        ["\x4F\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBD"],

        ["\xE7\xB3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xFA"],
        ["\x48\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBB"],

        ["\xE7\xB5\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x88"],
        ["\x46\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8C"],

        ["\xE7\xB6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],
        ["\x4A\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x99"],

        ["\xE7\xB9\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x73"],
        ["\x53\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8B"],

        ["\xE7\xBD\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xEF"],
        ["\x55\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAB"],

        ["\xE8\x8C\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC9"],
        ["\x4E\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x8E"],

        ["\xE8\x8D\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB3"],
        ["\x53\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8A"],

        ["\xE8\x9B\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF9"],
        ["\x4D\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8D"],

        ["\xE8\xA8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC9"],
        ["\x45\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x88"],

        ["\xE8\xA9\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xFB"],
        ["\x54\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA3"],

        ["\xE8\xAD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD7"],
        ["\x4A\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xA6"],

        ["\xE8\xBB\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA6"],
        ["\x48\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBD"],

        ["\xE9\xA0\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xC4"],
        ["\x66\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x9A"],

        ["\xE9\xB6\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8E"],
        ["\x4D\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8F"],

        ["\xE8\x8A\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x53"],
        ["\x49\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB8"],

        ["\xE8\xBF\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA9"],
        ["\x4B\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x8E"],

        ["\xE9\xAF\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x78"],
        ["\x4D\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA8"],

        ["\xE5\x8A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF0"],
        ["\x49\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x87"],

        ["\xE6\x88\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD9"],
        ["\x54\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9F"],

        ["\xE6\x92\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],
        ["\x4A\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x83"],

        ["\xE6\xBF\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD0"],
        ["\x4B\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x80"],

        ["\xE9\x9A\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC3"],
        ["\x53\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x99"],

        ["\xE6\xA1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD6"],
        ["\x50\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x81"],

        ["\xE5\x82\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC3"],
        ["\x4F\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x91"],

        ["\xE6\xAC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB5"],
        ["\x4C\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA0"],

        ["\xE6\xB1\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA4"],
        ["\x47\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBA"],

        ["\xE6\xBD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC2"],
        ["\x4A\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x94"],

        ["\xE7\xA9\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x86"],
        ["\x4B\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB4"],

        ["\xE7\xB5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBF"],
        ["\x46\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x90"],

        ["\xE8\xA1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x43"],
        ["\x4B\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x80"],

        ["\xE8\xA8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCC"],
        ["\x54\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA3"],

        ["\xE6\x9C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x61"],
        ["\x45\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x88"],

        ["\xE4\xBB\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB2"],
        ["\x48\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB6"],

        ["\xE5\x80\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xFA"],
        ["\x52\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB9"],

        ["\xE5\x80\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF1"],
        ["\x52\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA6"],

        ["\xE5\x81\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x81"],
        ["\x46\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA5"],

        ["\xE5\x85\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF4"],
        ["\x48\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xBC"],

        ["\xE5\x88\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6B"],
        ["\x4B\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB8"],

        ["\xE5\x89\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD3"],
        ["\x4C\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA3"],

        ["\xE5\x96\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD3"],
        ["\x4F\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA7"],

        ["\xE5\x9C\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x49"],
        ["\x4F\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8F"],

        ["\xE5\xA0\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE7"],
        ["\x4A\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x85"],

        ["\xE5\xAB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC3"],
        ["\x4E\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8C"],

        ["\xE5\xBB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x66"],
        ["\x46\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBA"],

        ["\xE6\x86\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBE"],
        ["\x47\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB2"],

        ["\xE6\x87\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC6"],
        ["\x4D\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB8"],

        ["\xE6\x8B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8D"],
        ["\x50\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB3"],

        ["\xE6\x8D\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x93"],
        ["\x54\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB2"],

        ["\xE6\xA4\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6D"],
        ["\x48\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9C"],

        ["\xE6\xA8\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDC"],
        ["\x48\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA9"],

        ["\xE7\x89\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8A"],
        ["\x54\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBD"],

        ["\xE7\x8A\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC5"],
        ["\x4A\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAC"],

        ["\xE7\x8C\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x45"],
        ["\x4F\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAE"],

        ["\xE7\xA0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD3"],
        ["\x46\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x94"],

        ["\xE7\xA1\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x69"],
        ["\x53\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAF"],

        ["\xE7\xB5\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF6"],
        ["\x49\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB9"],

        ["\xE7\x9C\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x52"],
        ["\x45\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8C"],

        ["\xE8\x82\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x79"],
        ["\x4B\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA9"],

        ["\xE8\xA6\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBB"],
        ["\x45\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8B"],

        ["\xE8\xAC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7C"],
        ["\x49\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x99"],

        ["\xE8\xB3\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE5"],
        ["\x47\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA2"],

        ["\xE8\xBB\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x55"],
        ["\x4E\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x92"],

        ["\xE9\x81\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC2"],
        ["\x4E\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA3"],

        ["\xE9\x8D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x45"],
        ["\x4E\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB5"],

        ["\xE9\x99\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],
        ["\x4A\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBA"],

        ["\xE9\xA1\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE5"],
        ["\x4A\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x95"],

        ["\xE9\xA8\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB4"],
        ["\x48\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x93"],

        ["\xE9\xB9\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],
        ["\x4C\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB8"],

        ["\xE5\x85\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x95"],
        ["\x46\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x83"],

        ["\xE5\x8E\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x74"],
        ["\x45\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9F"],

        ["\xE5\x8E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8E"],
        ["\x4C\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB3"],

        ["\xE5\xB9\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA2"],
        ["\x50\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBB"],

        ["\xE5\xBC\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x42"],
        ["\x4E\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA6"],

        ["\xE6\xB8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8A"],
        ["\x47\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9B"],

        ["\xE6\xBA\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xFC"],
        ["\x47\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x90"],

        ["\xE7\x8E\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],
        ["\x4C\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x84"],

        ["\xE7\x8F\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB7"],
        ["\x46\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xBE"],

        ["\xE7\xB5\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x63"],
        ["\x55\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x83"],

        ["\xE8\x88\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAC"],
        ["\x53\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB7"],

        ["\xE8\xA8\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9A"],
        ["\x47\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x80"],

        ["\xE8\xAB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAB"],
        ["\x55\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBA"],

        ["\xE9\x99\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAD"],
        ["\x48\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x90"],

        ["\xE4\xB9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA5"],
        ["\x54\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8E"],

        ["\xE5\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xFA"],
        ["\x49\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8B"],

        ["\xE5\x8F\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD4"],
        ["\x45\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA4"],

        ["\xE5\x91\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF6"],
        ["\x4A\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBC"],

        ["\xE5\x9B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x94"],
        ["\x4A\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBA"],

        ["\xE5\xA7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF2"],
        ["\x53\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x91"],

        ["\xE5\xAD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAF"],
        ["\x4E\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA4"],

        ["\xE5\xB7\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAD"],
        ["\x47\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB1"],

        ["\xE5\xBA\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF8"],
        ["\x45\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAB"],

        ["\xE5\xBC\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6B"],
        ["\x53\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA7"],

        ["\xE6\x88\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCF"],
        ["\x45\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB8"],

        ["\xE6\x95\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF7"],
        ["\x4A\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x85"],

        ["\xE6\x9E\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],
        ["\x50\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xAF"],

        ["\xE6\xB9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x52"],
        ["\x4D\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x96"],

        ["\xE7\x8B\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xDB"],
        ["\x51\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x90"],

        ["\xE7\xB3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x71"],
        ["\x54\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8A"],

        ["\xE8\xA2\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5A"],
        ["\x4F\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB4"],

        ["\xE8\x82\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC5"],
        ["\x4C\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA1"],

        ["\xE8\x83\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x63"],
        ["\x4D\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA1"],

        ["\xE8\x8F\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6D"],
        ["\x51\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB0"],

        ["\xE8\x99\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAB"],
        ["\x4A\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8E"],

        ["\xE8\xAA\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB4"],
        ["\x4E\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x87"],

        ["\xE8\xB7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCB"],
        ["\x55\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA8"],

        ["\xE9\x88\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBF"],
        ["\x55\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB7"],

        ["\xE9\x9B\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],
        ["\x4C\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x87"],

        ["\xE9\xA1\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xEE"],
        ["\x4E\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA7"],

        ["\xE9\xBC\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAF"],
        ["\x4F\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x93"],

        ["\xE4\xBA\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x45"],
        ["\x45\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x94"],

        ["\xE4\xBA\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x74"],
        ["\x4B\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x92"],

        ["\xE4\xBC\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x99"],
        ["\x4D\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8D"],

        ["\xE5\x8D\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDF"],
        ["\x45\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x88"],

        ["\xE5\x91\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xEE"],
        ["\x4A\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x89"],

        ["\xE5\x90\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF6"],
        ["\x47\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBE"],

        ["\xE5\xA8\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB5"],
        ["\x50\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xAF"],

        ["\xE5\xBE\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE5"],
        ["\x45\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8C"],

        ["\xE5\xBE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x98"],
        ["\x46\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA1"],

        ["\xE6\x82\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB1"],
        ["\x4A\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9F"],

        ["\xE6\xA2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD3"],
        ["\x52\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA7"],

        ["\xE6\xAA\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xEE"],
        ["\x55\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8E"],

        ["\xE7\x91\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF1"],
        ["\x53\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9A"],

        ["\xE7\xA2\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],
        ["\x4F\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x81"],

        ["\xE8\xAA\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE7"],
        ["\x48\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9E"],

        ["\xE8\xAA\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x91"],
        ["\x4D\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA4"],

        ["\xE8\xAD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDB"],
        ["\x49\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB7"],

        ["\xE9\x86\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x70"],
        ["\x51\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x90"],

        ["\xE4\xB9\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB5"],
        ["\x4E\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9E"],

        ["\xE9\xAF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC6"],
        ["\x4F\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x89"],

        ["\xE4\xBA\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8E"],
        ["\x47\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA4"],

        ["\xE4\xBD\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x62"],
        ["\x54\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBC"],

        ["\xE4\xBE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE3"],
        ["\x53\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAF"],

        ["\xE5\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAE"],
        ["\x4C\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x99"],

        ["\xE5\x80\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x43"],
        ["\x53\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x96"],

        ["\xE5\x85\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9E"],
        ["\x45\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x89"],

        ["\xE5\x85\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBB"],
        ["\x46\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAC"],

        ["\xE5\x8A\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x70"],
        ["\x48\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9F"],

        ["\xE5\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x78"],
        ["\x49\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB9"],

        ["\xE5\x8B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE9"],
        ["\x51\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBE"],

        ["\xE5\x8E\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x42"],
        ["\x49\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9A"],

        ["\xE5\x8F\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x88"],
        ["\x45\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA3"],

        ["\xE5\x90\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA5"],
        ["\x46\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x91"],

        ["\xE5\x90\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAF"],
        ["\x51\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8E"],

        ["\xE5\x96\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x53"],
        ["\x52\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x89"],

        ["\xE5\x9D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF3"],
        ["\x4E\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x91"],

        ["\xE5\x9E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x66"],
        ["\x54\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA2"],

        ["\xE5\xA5\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9E"],
        ["\x46\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xBD"],

        ["\xE5\xAD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD9"],
        ["\x4B\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x94"],

        ["\xE5\xAD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF4"],
        ["\x45\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9D"],

        ["\xE5\xAE\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC8"],
        ["\x46\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8F"],

        ["\xE5\xB7\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6A"],
        ["\x45\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA5"],

        ["\xE5\xB7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA3"],
        ["\x4C\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA7"],

        ["\xE5\xB7\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCB"],
        ["\x53\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB7"],

        ["\xE5\xB9\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA9"],
        ["\x45\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB8"],

        ["\xE5\xBA\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB7"],
        ["\x45\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x83"],

        ["\xE5\xBA\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5A"],
        ["\x51\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9A"],

        ["\xE5\xBA\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9A"],
        ["\x46\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB7"],

        ["\xE5\xBC\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD3"],
        ["\x45\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x98"],

        ["\xE6\x81\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC7"],
        ["\x47\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x92"],

        ["\xE6\x85\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8E"],
        ["\x53\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8C"],

        ["\xE6\x8A\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],
        ["\x4A\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x97"],

        ["\xE6\x8B\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x45"],
        ["\x50\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x98"],

        ["\xE6\x8E\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAC"],
        ["\x4C\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA7"],

        ["\xE6\x94\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC5"],
        ["\x4B\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBB"],

        ["\xE6\x98\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x99"],
        ["\x5B\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x82"],

        ["\xE6\x99\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB0"],
        ["\x48\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x83"],

        ["\xE6\x9B\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],
        ["\x4A\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB4"],

        ["\xE6\x9D\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8B"],
        ["\x50\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAD"],

        ["\xE6\xA0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBF"],
        ["\x48\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA1"],

        ["\xE6\xA2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCC"],
        ["\x52\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x97"],

        ["\xE6\xA7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x96"],
        ["\x47\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8B"],

        ["\xE6\xB1\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAD"],
        ["\x45\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9F"],

        ["\xE6\xB4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD4"],
        ["\x4F\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAA"],

        ["\xE6\xB5\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xEB"],
        ["\x46\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA9"],

        ["\xE6\xB8\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC6"],
        ["\x48\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAF"],

        ["\xE6\xBA\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],
        ["\x4A\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9D"],

        ["\xE7\x94\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA0"],
        ["\x48\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB2"],

        ["\xE7\x9A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBB"],
        ["\x4C\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x87"],

        ["\xE7\xA1\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xEF"],
        ["\x4A\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAC"],

        ["\xE7\xA8\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD5"],
        ["\x4F\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBF"],

        ["\xE7\xB3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4B"],
        ["\x51\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA0"],

        ["\xE7\xB4\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x67"],
        ["\x4B\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x85"],

        ["\xE7\xB4\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],
        ["\x4C\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x98"],

        ["\xE7\xB5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6D"],
        ["\x50\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9E"],

        ["\xE7\xB6\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCB"],
        ["\x48\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB1"],

        ["\xE8\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9A"],
        ["\x49\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x95"],

        ["\xE8\x80\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x60"],
        ["\x47\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x83"],

        ["\xE8\x82\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xEB"],
        ["\x50\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAF"],

        ["\xE8\x82\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD5"],
        ["\x52\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB1"],

        ["\xE8\x85\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x47"],
        ["\x52\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x94"],

        ["\xE8\x86\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD8"],
        ["\x51\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8F"],

        ["\xE8\x88\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9F"],
        ["\x48\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAA"],

        ["\xE8\x8D\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDC"],
        ["\x46\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x92"],

        ["\xE8\xA1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA4"],
        ["\x45\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8C"],

        ["\xE8\xA1\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xED"],
        ["\x4B\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA1"],

        ["\xE8\xAC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],
        ["\x4A\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9B"],

        ["\xE8\xB2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF1"],
        ["\x4A\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA2"],

        ["\xE8\xB3\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8F"],
        ["\x4E\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBC"],

        ["\xE9\x83\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x52"],
        ["\x50\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8A"],

        ["\xE9\x85\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x86"],
        ["\x4D\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB5"],

        ["\xE9\x89\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x63"],
        ["\x48\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB1"],

        ["\xE7\xA0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAF"],
        ["\x5F\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBF"],

        ["\xE9\x8B\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA1"],
        ["\x46\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBC"],

        ["\xE9\x96\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9B"],
        ["\x54\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA4"],

        ["\xE9\x99\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE5"],
        ["\x49\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8D"],

        ["\xE9\xA0\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x97"],
        ["\x4A\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x85"],

        ["\xE9\xA6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBD"],
        ["\x46\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x99"],

        ["\xE9\xAB\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x71"],
        ["\x45\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x98"],

        ["\xE9\xB4\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD6"],
        ["\x4D\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBB"],

        ["\xE5\x89\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC7"],
        ["\x49\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9B"],

        ["\xE5\x8A\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC6"],
        ["\x54\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAB"],

        ["\xE5\x8F\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE2"],
        ["\x48\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB7"],

        ["\xE5\x90\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA0"],
        ["\x45\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x88"],

        ["\xE5\xA3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB9"],
        ["\x55\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x95"],

        ["\xE6\x8B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB5"],
        ["\x55\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB7"],

        ["\xE6\xBF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x80"],
        ["\x53\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA0"],

        ["\xE8\xB1\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],
        ["\x4C\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAA"],

        ["\xE8\xBD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA9"],
        ["\x50\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9F"],

        ["\xE9\xBA\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x61"],
        ["\x52\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB9"],

        ["\xE5\x85\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9E"],
        ["\x47\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8B"],

        ["\xE5\x88\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF5"],
        ["\x4B\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBB"],

        ["\xE5\x91\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x54"],
        ["\x49\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8A"],

        ["\xE5\x9B\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8F"],
        ["\x45\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBD"],

        ["\xE7\xA9\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x94"],
        ["\x4E\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x80"],

        ["\xE9\x85\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xEB"],
        ["\x51\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB7"],

        ["\xE9\xB5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xFD"],
        ["\x50\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA0"],

        ["\xE9\xBB\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x79"],
        ["\x46\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x92"],

        ["\xE7\x8D\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x95"],
        ["\x4E\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x84"],

        ["\xE6\xBC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD0"],
        ["\x54\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x89"],

        ["\xE8\x85\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA4"],
        ["\x4B\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB0"],

        ["\xE7\x94\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x95"],
        ["\x54\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x91"],

        ["\xE5\xBF\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x56"],
        ["\x50\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBD"],

        ["\xE6\x83\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9D"],
        ["\x54\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9A"],

        ["\xE9\xAA\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA5"],
        ["\x4A\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xA8"],

        ["\xE7\x8B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDC"],
        ["\x50\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x9B"],

        ["\xE8\xBE\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x41"],
        ["\x48\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBC"],

        ["\xE6\xAD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4C"],
        ["\x4D\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA4"],

        ["\xE9\xA0\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x46"],
        ["\x49\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x83"],

        ["\xE4\xBB\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE0"],
        ["\x45\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8A"],

        ["\xE5\x9B\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x44"],
        ["\x4B\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB0"],

        ["\xE5\x9D\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA6"],
        ["\x53\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA4"],

        ["\xE5\xA2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x88"],
        ["\x54\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBE"],

        ["\xE5\xA9\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],
        ["\x4A\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x9A"],

        ["\xE6\x81\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB8"],
        ["\x53\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA8"],

        ["\xE6\x87\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA4"],
        ["\x4E\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x87"],

        ["\xE6\x98\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE8"],
        ["\x54\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8F"],

        ["\xE6\x98\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE7"],
        ["\x4F\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x86"],

        ["\xE6\xA0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x67"],
        ["\x46\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB9"],

        ["\xE6\xA2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x59"],
        ["\x53\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB1"],

        ["\xE6\xB7\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x46"],
        ["\x4B\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB7"],

        ["\xE7\x97\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xFD"],
        ["\x53\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x95"],

        ["\xE7\xB4\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBD"],
        ["\x4C\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBA"],

        ["\xE8\x89\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB4"],
        ["\x55\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAE"],

        ["\xE9\xAD\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA8"],
        ["\x50\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x82"],

        ["\xE4\xBA\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDC"],
        ["\x55\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9B"],

        ["\xE4\xBD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x76"],
        ["\x45\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x90"],

        ["\xE5\x8F\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA5"],
        ["\x50\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x89"],

        ["\xE5\x94\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB8"],
        ["\x51\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x86"],

        ["\xE5\xB5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD3"],
        ["\x4E\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAF"],

        ["\xE5\xB7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5B"],
        ["\x48\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA6"],

        ["\xE5\xB7\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8B"],
        ["\x49\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAE"],

        ["\xE6\x9F\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x73"],
        ["\x47\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBB"],

        ["\xE6\xB2\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAD"],
        ["\x4E\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x99"],

        ["\xE7\x91\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x88"],
        ["\x51\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB3"],

        ["\xE7\xA0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5B"],
        ["\x49\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x82"],

        ["\xE8\xA9\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x76"],
        ["\x51\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x90"],

        ["\xE9\x8E\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x70"],
        ["\x4D\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x96"],

        ["\xE8\xA3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8A"],
        ["\x4F\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9F"],

        ["\xE5\x9D\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8D"],
        ["\x4E\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x90"],

        ["\xE5\xBA\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB1"],
        ["\x48\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA7"],

        ["\xE6\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8F"],
        ["\x54\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAB"],

        ["\xE5\x82\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x58"],
        ["\x4B\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB5"],

        ["\xE5\x82\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x43"],
        ["\x4C\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAC"],

        ["\xE5\x86\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xEB"],
        ["\x48\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8D"],

        ["\xE6\x9C\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF5"],
        ["\x46\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x80"],

        ["\xE5\x93\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],
        ["\x4A\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x89"],

        ["\xE5\xA1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC1"],
        ["\x53\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9E"],

        ["\xE5\xA6\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA3"],
        ["\x49\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBB"],

        ["\xE5\xAE\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD4"],
        ["\x4E\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB0"],

        ["\xE5\xBD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCD"],
        ["\x4D\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA9"],

        ["\xE6\x89\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF1"],
        ["\x49\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8D"],

        ["\xE6\x8E\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4F"],
        ["\x4B\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA1"],

        ["\xE6\xA0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE0"],
        ["\x4D\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBD"],

        ["\xE6\xAD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE4"],
        ["\x48\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB3"],

        ["\xE6\xB8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x69"],
        ["\x47\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x88"],

        ["\xE7\x81\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBC"],
        ["\x4C\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBD"],

        ["\xE9\x87\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBF"],
        ["\x53\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x87"],

        ["\xE7\x8A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x54"],
        ["\x53\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x80"],

        ["\xE7\xA0\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC3"],
        ["\x4C\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x95"],

        ["\xE7\xA0\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB4"],
        ["\x54\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA6"],

        ["\xE7\xA5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],
        ["\x4C\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xAD"],

        ["\xE6\x96\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDB"],
        ["\x47\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8E"],

        ["\xE7\xB4\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x68"],
        ["\x47\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB0"],

        ["\xE8\x8F\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA8"],
        ["\x4B\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9C"],

        ["\xE8\xA3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBD"],
        ["\x49\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x81"],

        ["\xE8\xBC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6E"],
        ["\x4D\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x89"],

        ["\xE9\x9A\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x97"],
        ["\x47\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9B"],

        ["\xE5\x89\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x66"],
        ["\x47\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA4"],

        ["\xE5\x9C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCD"],
        ["\x47\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA8"],

        ["\xE6\x9D\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBC"],
        ["\x46\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x90"],

        ["\xE7\xBD\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],
        ["\x4C\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAA"],

        ["\xE8\xB2\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xAF"],
        ["\x49\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA1"],

        ["\xE5\x86\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC9"],
        ["\x50\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB4"],

        ["\xE5\x9D\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xEC"],
        ["\x45\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x82"],

        ["\xE9\x98\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x91"],
        ["\x45\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAA"],

        ["\xE5\xA0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],
        ["\x4A\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBA"],

        ["\xE6\xA6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x52"],
        ["\x4B\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8A"],

        ["\xE8\x82\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x51"],
        ["\x54\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB4"],

        ["\xE5\x92\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDE"],
        ["\x4C\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB2"],

        ["\xE5\xB4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7F"],
        ["\x45\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8E"],

        ["\xE5\x9F\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA3"],
        ["\x46\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBC"],

        ["\xE7\xA2\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD2"],
        ["\x52\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x95"],

        ["\xE9\xB7\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAF"],
        ["\x50\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBA"],

        ["\xE4\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x94"],
        ["\x45\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9C"],

        ["\xE5\x89\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x90"],
        ["\x4A\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8A"],

        ["\xE5\x92\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],
        ["\x4F\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8B"],

        ["\xE6\x90\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA3"],
        ["\x50\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBE"],

        ["\xE6\x98\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE8"],
        ["\x48\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA8"],

        ["\xE6\x9C\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA4"],
        ["\x4F\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x94"],

        ["\xE6\x9F\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF1"],
        ["\x51\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB5"],

        ["\xE7\xAA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x99"],
        ["\x54\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x84"],

        ["\xE7\xAD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC9"],
        ["\x46\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x96"],

        ["\xE7\xB4\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF4"],
        ["\x4C\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA2"],

        ["\xE9\x8C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB1"],
        ["\x50\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAF"],

        ["\xE6\xA1\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x71"],
        ["\x47\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9C"],

        ["\xE9\xAE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x91"],
        ["\x53\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAD"],

        ["\xE7\xAC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6E"],
        ["\x49\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB9"],

        ["\xE5\x8C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x57"],
        ["\x54\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x99"],

        ["\xE5\x86\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA1"],
        ["\x4E\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8A"],

        ["\xE5\x88\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCF"],
        ["\x48\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB7"],

        ["\xE5\xAF\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x93"],
        ["\x4B\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9F"],

        ["\xE6\x8B\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9E"],
        ["\x4F\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB6"],

        ["\xE6\x92\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],
        ["\x4C\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAE"],

        ["\xE6\x93\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD6"],
        ["\x4F\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA6"],

        ["\xE6\x9C\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF9"],
        ["\x48\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAD"],

        ["\xE6\xAE\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE9"],
        ["\x49\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBA"],

        ["\xE8\x96\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF1"],
        ["\x4C\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA9"],

        ["\xE9\x9B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8A"],
        ["\x4A\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x91"],

        ["\xE7\x9A\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA4"],
        ["\x52\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x90"],

        ["\xE9\xAF\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE4"],
        ["\x4F\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x96"],

        ["\xE6\x8D\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7D"],
        ["\x55\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8C"],

        ["\xE9\x8C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD2"],
        ["\x55\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x86"],

        ["\xE9\xAE\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB7"],
        ["\x4E\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAB"],

        ["\xE7\x9A\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC7"],
        ["\x4D\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBF"],

        ["\xE6\x99\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC3"],
        ["\x54\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x92"],

        ["\xE4\xB8\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x43"],
        ["\x45\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x89"],

        ["\xE5\x82\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9C"],
        ["\x50\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x98"],

        ["\xE5\x8F\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD2"],
        ["\x48\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x82"],

        ["\xE5\xB1\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x65"],
        ["\x45\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB1"],

        ["\xE6\x83\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6E"],
        ["\x50\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA8"],

        ["\xE6\x92\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDE"],
        ["\x53\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x92"],

        ["\xE6\x95\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC9"],
        ["\x4A\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA3"],

        ["\xE6\xA1\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF3"],
        ["\x51\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9F"],

        ["\xE7\x87\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCE"],
        ["\x54\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA6"],

        ["\xE7\x8F\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x99"],
        ["\x53\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8A"],

        ["\xE7\x94\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC0"],
        ["\x45\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA3"],

        ["\xE7\xAE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x43"],
        ["\x48\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x97"],

        ["\xE7\xBA\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xEB"],
        ["\x55\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x82"],

        ["\xE8\x9A\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5D"],
        ["\x4F\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x95"],

        ["\xE8\xAE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6B"],
        ["\x51\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x83"],

        ["\xE8\xB3\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xEE"],
        ["\x4D\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9B"],

        ["\xE9\x85\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x99"],
        ["\x48\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB8"],

        ["\xE9\xA4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB3"],
        ["\x55\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x90"],

        ["\xE6\x96\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xFC"],
        ["\x4E\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAC"],

        ["\xE6\x9A\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x93"],
        ["\x50\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAB"],

        ["\xE6\xAE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x92"],
        ["\x49\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8B"],

        ["\xE4\xBB\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB5"],
        ["\x48\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x95"],

        ["\xE4\xBB\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x65"],
        ["\x54\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x94"],

        ["\xE4\xBC\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8A"],
        ["\x50\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBA"],

        ["\xE4\xBD\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB6"],
        ["\x48\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBF"],

        ["\xE5\x88\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC0"],
        ["\x4B\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBA"],

        ["\xE5\x8F\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF0"],
        ["\x45\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB8"],

        ["\xE5\x8F\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD9"],
        ["\x47\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB2"],

        ["\xE5\x97\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5E"],
        ["\x4B\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA3"],

        ["\xE5\x9B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x44"],
        ["\x45\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9B"],

        ["\xE5\xA3\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7D"],
        ["\x46\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAB"],

        ["\xE5\xA7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x90"],
        ["\x49\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x8B"],

        ["\xE5\xA7\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC1"],
        ["\x4C\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x89"],

        ["\xE5\xA7\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x42"],
        ["\x4B\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBF"],

        ["\xE5\xAD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x64"],
        ["\x45\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x90"],

        ["\xE5\xB1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBA"],
        ["\x55\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8D"],

        ["\xE5\xB8\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x53"],
        ["\x45\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x82"],

        ["\xE5\xB8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x44"],
        ["\x4A\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAB"],

        ["\xE5\xBF\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x61"],
        ["\x46\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x97"],

        ["\xE6\x80\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAD"],
        ["\x46\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9D"],

        ["\xE6\x8C\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB6"],
        ["\x47\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x87"],

        ["\xE6\x94\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7B"],
        ["\x47\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAF"],

        ["\xE5\xAD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF2"],
        ["\x4F\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9C"],

        ["\xE6\x96\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA5"],
        ["\x4E\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAF"],

        ["\xE6\x96\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x88"],
        ["\x48\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBD"],

        ["\xE6\x97\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6A"],
        ["\x4D\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA8"],

        ["\xE6\x9E\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x72"],
        ["\x46\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9D"],

        ["\xE6\xAD\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD8"],
        ["\x48\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA2"],

        ["\xE6\xAD\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x99"],
        ["\x49\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBB"],

        ["\xE6\xB0\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8E"],
        ["\x48\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8F"],

        ["\xE7\x8D\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9F"],
        ["\x51\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x85"],

        ["\xE7\xA5\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xEB"],
        ["\x4F\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x89"],

        ["\xE7\xA7\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC3"],
        ["\x46\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x81"],

        ["\xE7\xB3\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC7"],
        ["\x46\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB8"],

        ["\xE7\xB4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x80"],
        ["\x46\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x99"],

        ["\xE7\xB4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF0"],
        ["\x4A\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAB"],

        ["\xE8\x82\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x82"],
        ["\x53\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA2"],

        ["\xE8\x84\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x74"],
        ["\x48\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x82"],

        ["\xE8\x87\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x48"],
        ["\x4A\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB3"],

        ["\xE8\xA6\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],
        ["\x4A\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x96"],

        ["\xE8\xA9\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x90"],
        ["\x4E\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9E"],

        ["\xE8\xA9\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB0"],
        ["\x4C\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA9"],

        ["\xE8\xA9\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x48"],
        ["\x49\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA6"],

        ["\xE8\xAA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x76"],
        ["\x4B\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8C"],

        ["\xE8\xAB\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9C"],
        ["\x4F\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAE"],

        ["\xE8\xB3\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x50"],
        ["\x46\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x87"],

        ["\xE8\xB3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x94"],
        ["\x4F\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9C"],

        ["\xE9\x9B\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB7"],
        ["\x52\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8C"],

        ["\xE9\xA3\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8F"],
        ["\x4A\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBC"],

        ["\xE6\xAD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9F"],
        ["\x4A\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAF"],

        ["\xE4\xBA\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCE"],
        ["\x45\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8B"],

        ["\xE4\xBC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBC"],
        ["\x4B\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBC"],

        ["\xE4\xBE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC2"],
        ["\x4F\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8D"],

        ["\xE5\x85\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9F"],
        ["\x46\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x90"],

        ["\xE5\xAD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF2"],
        ["\x48\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x97"],

        ["\xE5\xAF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA0"],
        ["\x46\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBA"],

        ["\xE6\x85\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBE"],
        ["\x4C\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x88"],

        ["\xE6\x8C\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD8"],
        ["\x46\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x81"],

        ["\xE6\x99\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x51"],
        ["\x46\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x82"],

        ["\xE6\xAC\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x97"],
        ["\x45\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA1"],

        ["\xE6\xBB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x57"],
        ["\x48\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8B"],

        ["\xE6\xB2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x84"],
        ["\x45\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBB"],

        ["\xE7\x88\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],
        ["\x4C\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBE"],

        ["\xE7\x92\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x49"],
        ["\x52\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBD"],

        ["\xE7\x97\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x82"],
        ["\x51\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x94"],

        ["\xE7\xA3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],
        ["\x4A\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x81"],

        ["\xE7\xA4\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x53"],
        ["\x48\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBA"],

        ["\xE8\x80\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE6"],
        ["\x51\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8C"],

        ["\xE8\x80\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAB"],
        ["\x4C\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB3"],

        ["\xE8\x87\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC3"],
        ["\x45\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAA"],

        ["\xE8\x92\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE3"],
        ["\x4F\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x94"],

        ["\xE8\xBE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x74"],
        ["\x4D\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9E"],

        ["\xE6\xB1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6A"],
        ["\x50\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x90"],

        ["\xE9\xB9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x97"],
        ["\x46\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBF"],

        ["\xE5\xBC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8F"],
        ["\x46\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8F"],

        ["\xE8\xAD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],
        ["\x4A\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x98"],

        ["\xE9\xB4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBA"],
        ["\x50\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAB"],

        ["\xE7\xAB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5C"],
        ["\x54\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBA"],

        ["\xE8\xBB\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA6"],
        ["\x4B\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xB8"],

        ["\xE5\xAE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],
        ["\x4C\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8D"],

        ["\xE9\x9B\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA5"],
        ["\x52\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAB"],

        ["\xE4\xB8\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x47"],
        ["\x45\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x83"],

        ["\xE5\x8F\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x42"],
        ["\x50\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB1"],

        ["\xE5\x9F\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x57"],
        ["\x4D\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB7"],

        ["\xE5\xA4\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x41"],
        ["\x49\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB1"],

        ["\xE5\xAB\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE0"],
        ["\x53\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x89"],

        ["\xE5\xAE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB8"],
        ["\x47\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA4"],

        ["\xE6\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x69"],
        ["\x54\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x89"],

        ["\xE6\xB9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x90"],
        ["\x4C\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBF"],

        ["\xE6\xBC\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAE"],
        ["\x4D\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x86"],

        ["\xE7\x96\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x42"],
        ["\x51\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBE"],

        ["\xE8\xB3\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xEC"],
        ["\x46\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAA"],

        ["\xE5\xAE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xED"],
        ["\x45\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9F"],

        ["\xE8\x94\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBD"],
        ["\x52\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x80"],

        ["\xE7\xAF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x75"],
        ["\x48\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA0"],

        ["\xE5\x81\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD2"],
        ["\x54\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB2"],

        ["\xE6\x9F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA7"],
        ["\x47\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB4"],

        ["\xE8\x8A\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x72"],
        ["\x49\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9D"],

        ["\xE5\xB1\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC0"],
        ["\x55\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA1"],

        ["\xE8\x95\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA6"],
        ["\x62\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8A"],

        ["\xE7\xB8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6B"],
        ["\x4F\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9E"],

        ["\xE8\x88\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x58"],
        ["\x4C\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8E"],

        ["\xE5\x86\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC4"],
        ["\x48\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x99"],

        ["\xE5\xB0\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8A"],
        ["\x49\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x84"],

        ["\xE6\x8D\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB3"],
        ["\x4B\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA8"],

        ["\xE8\xB5\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x51"],
        ["\x51\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA6"],

        ["\xE6\x96\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD1"],
        ["\x4B\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9C"],

        ["\xE7\x85\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],
        ["\x4C\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAE"],

        ["\xE7\xA4\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x63"],
        ["\x46\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBE"],

        ["\xE7\xB4\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x47"],
        ["\x4F\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x97"],

        ["\xE8\x80\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x70"],
        ["\x46\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x85"],

        ["\xE8\xAC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBB"],
        ["\x4D\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9D"],

        ["\xE8\xBB\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x53"],
        ["\x46\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8A"],

        ["\xE9\x81\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x58"],
        ["\x54\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAE"],

        ["\xE8\x9B\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xEA"],
        ["\x4F\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x87"],

        ["\xE9\x82\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB8"],
        ["\x4E\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAA"],

        ["\xE5\x80\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD0"],
        ["\x4A\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9F"],

        ["\xE5\x8B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x70"],
        ["\x54\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBA"],

        ["\xE5\xB0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],
        ["\x4C\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBA"],

        ["\xE6\x9D\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC1"],
        ["\x54\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x93"],

        ["\xE7\x81\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6A"],
        ["\x54\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBC"],

        ["\xE7\x88\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA9"],
        ["\x53\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB5"],

        ["\xE9\x85\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBB"],
        ["\x52\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8C"],

        ["\xE9\x87\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x79"],
        ["\x4D\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x88"],

        ["\xE9\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x57"],
        ["\x52\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAB"],

        ["\xE8\x8B\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD6"],
        ["\x46\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA5"],

        ["\xE5\xAF\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE9"],
        ["\x4F\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x82"],

        ["\xE5\xBC\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6E"],
        ["\x4B\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB1"],

        ["\xE6\x83\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x72"],
        ["\x54\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB9"],

        ["\xE4\xB8\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x62"],
        ["\x47\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBB"],

        ["\xE5\x8F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA6"],
        ["\x46\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x96"],

        ["\xE5\xAE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF0"],
        ["\x46\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x88"],

        ["\xE6\x89\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCB"],
        ["\x45\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8B"],

        ["\xE6\x9C\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x42"],
        ["\x4D\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB1"],

        ["\xE6\xAE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x65"],
        ["\x48\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8A"],

        ["\xE7\x8B\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],
        ["\x4A\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA9"],

        ["\xE7\x8F\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x99"],
        ["\x4B\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA0"],

        ["\xE7\xA8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x92"],
        ["\x46\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xAE"],

        ["\xE8\x85\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCE"],
        ["\x51\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAB"],

        ["\xE8\xB6\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xED"],
        ["\x4C\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA3"],

        ["\xE9\x85\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x58"],
        ["\x47\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x92"],

        ["\xE9\xA6\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBE"],
        ["\x49\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x96"],

        ["\xE5\x84\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6F"],
        ["\x54\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x92"],

        ["\xE5\x8F\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4C"],
        ["\x48\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x97"],

        ["\xE5\x91\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8D"],
        ["\x54\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAA"],

        ["\xE5\xAF\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB2"],
        ["\x46\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBF"],

        ["\xE6\x8E\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],
        ["\x4C\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x88"],

        ["\xE6\xA8\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCF"],
        ["\x46\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB9"],

        ["\xE7\xB6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA3"],
        ["\x51\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAC"],

        ["\xE9\x9C\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xFB"],
        ["\x47\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x80"],

        ["\xE5\x9B\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x65"],
        ["\x50\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9A"],

        ["\xE5\x8F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x91"],
        ["\x47\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8E"],

        ["\xE5\x91\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA1"],
        ["\x48\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA8"],

        ["\xE5\xAE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDD"],
        ["\x47\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x97"],

        ["\xE5\xB0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xEE"],
        ["\x4B\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB1"],

        ["\xE5\xB7\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x41"],
        ["\x47\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9E"],

        ["\xE4\xBF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDE"],
        ["\x46\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAE"],

        ["\xE6\x84\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x82"],
        ["\x52\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x81"],

        ["\xE6\x8B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD7"],
        ["\x4D\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBE"],

        ["\xE6\xB4\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x72"],
        ["\x4B\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB2"],

        ["\xE7\xA7\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF1"],
        ["\x45\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x80"],

        ["\xE7\xA7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x58"],
        ["\x46\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8B"],

        ["\xE7\xB5\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF4"],
        ["\x49\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x82"],

        ["\xE7\xB9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDA"],
        ["\x52\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8D"],

        ["\xE7\xBF\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],
        ["\x4A\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x92"],

        ["\xE8\x87\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB3"],
        ["\x4D\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAD"],

        ["\xE8\x88\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB8"],
        ["\x4B\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9F"],

        ["\xE8\x92\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x93"],
        ["\x4F\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x90"],

        ["\xE8\xA1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x88"],
        ["\x4B\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x86"],

        ["\xE8\xA5\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDF"],
        ["\x4D\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB2"],

        ["\xE8\xAE\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xFE"],
        ["\x53\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x90"],

        ["\xE8\xB9\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF6"],
        ["\x52\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB4"],

        ["\xE8\xBC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA6"],
        ["\x55\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAF"],

        ["\xE9\x80\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD3"],
        ["\x4A\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB1"],

        ["\xE9\x85\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x48"],
        ["\x55\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8B"],

        ["\xE9\x85\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x49"],
        ["\x51\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAC"],

        ["\xE9\x9B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA0"],
        ["\x47\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x86"],

        ["\xE9\x86\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6F"],
        ["\x53\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x9C"],

        ["\xE4\xBB\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD9"],
        ["\x53\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x80"],

        ["\xE4\xBD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE0"],
        ["\x46\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8F"],

        ["\xE5\x85\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC9"],
        ["\x48\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x85"],

        ["\xE5\x8D\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4A"],
        ["\x45\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x81"],

        ["\xE5\xBE\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xFB"],
        ["\x48\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x93"],

        ["\xE6\x88\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7F"],
        ["\x51\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8E"],

        ["\xE6\x9F\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xEA"],
        ["\x4D\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x94"],

        ["\xE6\xB1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x84"],
        ["\x4D\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x81"],

        ["\xE6\xB8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x92"],
        ["\x48\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8B"],

        ["\xE7\x8D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x65"],
        ["\x4F\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA3"],

        ["\xE7\xB8\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x93"],
        ["\x4E\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA6"],

        ["\xE9\x87\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA3"],
        ["\x45\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8D"],

        ["\xE9\x8A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE2"],
        ["\x4C\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x83"],

        ["\xE5\x8F\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA5"],
        ["\x4F\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x94"],

        ["\xE5\xA4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDD"],
        ["\x54\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x99"],

        ["\xE5\xAE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x82"],
        ["\x48\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xBF"],

        ["\xE6\xB7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBF"],
        ["\x4A\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x91"],

        ["\xE7\xA5\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xEB"],
        ["\x4C\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9D"],

        ["\xE7\xB8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF7"],
        ["\x49\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAE"],

        ["\xE7\xB2\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC8"],
        ["\x4F\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9B"],

        ["\xE5\xA1\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x79"],
        ["\x52\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xBE"],

        ["\xE7\x86\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBF"],
        ["\x4E\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x9F"],

        ["\xE5\x87\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9B"],
        ["\x45\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBA"],

        ["\xE8\xA1\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6C"],
        ["\x48\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x93"],

        ["\xE8\xBF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9C"],
        ["\x4A\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB0"],

        ["\xE4\xBF\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x60"],
        ["\x46\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8A"],

        ["\xE5\xB3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x72"],
        ["\x50\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBB"],

        ["\xE6\x98\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x62"],
        ["\x46\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA5"],

        ["\xE7\x9E\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB0"],
        ["\x4D\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAC"],

        ["\xE7\xAB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6B"],
        ["\x54\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA3"],

        ["\xE8\x88\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB8"],
        ["\x4F\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9C"],

        ["\xE9\xA7\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC0"],
        ["\x4C\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBF"],

        ["\xE5\x87\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x80"],
        ["\x4F\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x86"],

        ["\xE5\xBE\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF5"],
        ["\x4E\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAA"],

        ["\xE6\x97\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x67"],
        ["\x4D\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAC"],

        ["\xE6\xA5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAE"],
        ["\x4F\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAF"],

        ["\xE6\xAE\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA4"],
        ["\x53\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x89"],

        ["\xE6\xB7\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x94"],
        ["\x48\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB3"],

        ["\xE6\xBA\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCE"],
        ["\x46\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x96"],

        ["\xE6\xBD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD2"],
        ["\x4A\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA4"],

        ["\xE7\x9B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x82"],
        ["\x50\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBE"],

        ["\xE7\xB4\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA6"],
        ["\x47\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x94"],

        ["\xE5\xB7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x47"],
        ["\x4D\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA1"],

        ["\xE9\x81\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6E"],
        ["\x52\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB5"],

        ["\xE9\x86\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA9"],
        ["\x51\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x87"],

        ["\xE9\xA0\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB2"],
        ["\x47\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x86"],

        ["\xE5\x87\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE6"],
        ["\x48\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA6"],

        ["\xE5\x88\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4B"],
        ["\x47\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x9D"],

        ["\xE6\x89\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8C"],
        ["\x45\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x80"],

        ["\xE6\x9A\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBE"],
        ["\x4F\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x91"],

        ["\xE6\x9B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x52"],
        ["\x51\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x99"],

        ["\xE6\xB8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE4"],
        ["\x50\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9A"],

        ["\xE5\xBA\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC1"],
        ["\x50\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB6"],

        ["\xE7\xB7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9B"],
        ["\x4A\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x92"],

        ["\xE7\xBD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x99"],
        ["\x4C\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB2"],

        ["\xE6\x9B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9D"],
        ["\x47\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB8"],

        ["\xE8\x96\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF9"],
        ["\x53\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAF"],

        ["\xE8\x97\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE2"],
        ["\x55\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB7"],

        ["\xE8\xAB\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE2"],
        ["\x47\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB8"],

        ["\xE5\x8A\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x71"],
        ["\x46\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA9"],

        ["\xE5\x8F\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF5"],
        ["\x50\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x99"],

        ["\xE5\xA5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x99"],
        ["\x46\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB3"],

        ["\xE5\xBA\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4F"],
        ["\x4D\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8F"],

        ["\xE5\xBE\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB3"],
        ["\x50\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x90"],

        ["\xE6\x81\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x98"],
        ["\x52\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x95"],

        ["\xE9\x8B\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC0"],
        ["\x52\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA4"],

        ["\xE9\x99\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6D"],
        ["\x49\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA4"],

        ["\xE5\x82\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],
        ["\x4C\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB7"],

        ["\xE5\x84\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA2"],
        ["\x4A\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9F"],

        ["\xE5\x8B\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB5"],
        ["\x45\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9D"],

        ["\xE5\x8C\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6B"],
        ["\x4E\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA0"],

        ["\xE5\x8D\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x47"],
        ["\x4E\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x87"],

        ["\xE5\x8F\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x86"],
        ["\x4F\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAC"],

        ["\xE5\x93\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x68"],
        ["\x55\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA8"],

        ["\xE5\x95\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBE"],
        ["\x46\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x86"],

        ["\xE5\x94\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x43"],
        ["\x4D\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB1"],

        ["\xE5\x98\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xEC"],
        ["\x54\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x97"],

        ["\xE5\xA5\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCA"],
        ["\x4E\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA8"],

        ["\xE5\xA6\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAF"],
        ["\x53\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBE"],

        ["\xE5\xA8\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x98"],
        ["\x54\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xBC"],

        ["\xE5\xAE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xEF"],
        ["\x52\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB5"],

        ["\xE5\xB0\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x59"],
        ["\x49\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x86"],

        ["\xE5\xB0\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5D"],
        ["\x45\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8F"],

        ["\xE5\xB0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4A"],
        ["\x48\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x91"],

        ["\xE5\xB0\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x71"],
        ["\x48\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9A"],

        ["\xE5\xBA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x50"],
        ["\x48\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x84"],

        ["\xE5\xBA\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xED"],
        ["\x4A\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8A"],

        ["\xE5\xBB\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x62"],
        ["\x55\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA0"],

        ["\xE5\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x64"],
        ["\x49\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB0"],

        ["\xE6\x89\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x48"],
        ["\x4C\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBF"],

        ["\xE6\x8A\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC0"],
        ["\x4E\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x84"],

        ["\xE6\x8B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xFD"],
        ["\x4B\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9B"],

        ["\xE6\x8E\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xEC"],
        ["\x4E\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8C"],

        ["\xE6\x8D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8F"],
        ["\x4D\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB7"],

        ["\xE6\x98\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xFE"],
        ["\x46\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x87"],

        ["\xE6\x98\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD1"],
        ["\x46\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8C"],

        ["\xE6\x98\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB3"],
        ["\x45\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAD"],

        ["\xE6\x99\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF8"],
        ["\x4A\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB6"],

        ["\xE6\x9D\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x78"],
        ["\x45\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBE"],

        ["\xE6\xA2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAC"],
        ["\x50\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA2"],

        ["\xE6\xA8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9B"],
        ["\x53\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9F"],

        ["\xE6\xA8\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x85"],
        ["\x55\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB5"],

        ["\xE6\xB2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC6"],
        ["\x46\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBC"],

        ["\xE6\xB6\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6B"],
        ["\x48\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x88"],

        ["\xE6\xB8\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC0"],
        ["\x4A\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x89"],

        ["\xE6\xB9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x55"],
        ["\x51\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x98"],

        ["\xE7\x84\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x83"],
        ["\x49\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xBC"],

        ["\xE7\x84\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE6"],
        ["\x4D\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA6"],

        ["\xE7\x85\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x42"],
        ["\x47\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA7"],

        ["\xE7\x97\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4A"],
        ["\x4E\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x87"],

        ["\xE7\x9C\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x47"],
        ["\x48\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x81"],

        ["\xE7\xA1\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x76"],
        ["\x49\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x9D"],

        ["\xE7\xA4\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB0"],
        ["\x51\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x81"],

        ["\xE7\xA5\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF9"],
        ["\x49\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA5"],

        ["\xE7\xA7\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDF"],
        ["\x4B\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xB0"],

        ["\xE7\xAB\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6E"],
        ["\x47\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA0"],

        ["\xE7\xAC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB5"],
        ["\x49\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x91"],

        ["\xE7\xB2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD4"],
        ["\x4B\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA7"],

        ["\xE7\xB4\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE4"],
        ["\x4C\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB9"],

        ["\xE8\x82\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x67"],
        ["\x52\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x96"],

        ["\xE8\x8F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x80"],
        ["\x51\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x96"],

        ["\xE8\x92\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF8"],
        ["\x53\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x8B"],

        ["\xE8\x95\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA8"],
        ["\x53\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x89"],

        ["\xE8\xA1\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA5"],
        ["\x4D\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9D"],

        ["\xE8\xA3\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA8"],
        ["\x4F\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB3"],

        ["\xE8\xA8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xEF"],
        ["\x50\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9F"],

        ["\xE8\xA8\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBA"],
        ["\x49\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBC"],

        ["\xE8\xA9\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x88"],
        ["\x4F\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x94"],

        ["\xE8\xA9\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE7"],
        ["\x4D\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB3"],

        ["\xE8\xB1\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x94"],
        ["\x49\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA1"],

        ["\xE8\xB3\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAD"],
        ["\x4A\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9E"],

        ["\xE9\x86\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7F"],
        ["\x50\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA4"],

        ["\xE9\x89\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB4"],
        ["\x4F\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA6"],

        ["\xE9\x8D\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBD"],
        ["\x53\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBE"],

        ["\xE9\x90\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC8"],
        ["\x4C\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x98"],

        ["\xE9\x9A\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF9"],
        ["\x4B\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9C"],

        ["\xE9\x9E\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE7"],
        ["\x52\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x98"],

        ["\xE4\xB8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5E"],
        ["\x45\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8A"],

        ["\xE4\xB8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD3"],
        ["\x49\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x88"],

        ["\xE4\xB8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x62"],
        ["\x4F\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x9E"],

        ["\xE4\xB9\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x47"],
        ["\x49\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x97"],

        ["\xE5\x86\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7E"],
        ["\x52\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x97"],

        ["\xE5\x89\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x85"],
        ["\x4D\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB0"],

        ["\xE5\x9F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDB"],
        ["\x45\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8E"],

        ["\xE5\xA0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD9"],
        ["\x45\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB4"],

        ["\xE5\xA3\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x96"],
        ["\x51\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8C"],

        ["\xE5\xAC\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE4"],
        ["\x4D\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xA2"],

        ["\xE5\xB8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xEF"],
        ["\x46\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB8"],

        ["\xE6\x83\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5F"],
        ["\x48\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x85"],

        ["\xE6\x93\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF6"],
        ["\x55\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBE"],

        ["\xE6\x9D\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5E"],
        ["\x47\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA1"],

        ["\xE6\x9D\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF4"],
        ["\x50\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x96"],

        ["\xE6\xB5\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC9"],
        ["\x4C\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x84"],

        ["\xE7\x8A\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x52"],
        ["\x48\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB6"],

        ["\xE7\x95\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x54"],
        ["\x4E\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB3"],

        ["\xE7\xA9\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x98"],
        ["\x4E\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA3"],

        ["\xE8\x92\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBA"],
        ["\x4A\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB8"],

        ["\xE8\xAD\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7B"],
        ["\x4B\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB2"],

        ["\xE9\x86\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC2"],
        ["\x50\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB8"],

        ["\xE9\x8C\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x57"],
        ["\x4E\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA0"],

        ["\xE5\x98\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCA"],
        ["\x50\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB1"],

        ["\xE5\x9F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x48"],
        ["\x4F\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB4"],

        ["\xE9\xA3\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x57"],
        ["\x49\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBE"],

        ["\xE6\x8B\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE5"],
        ["\x4E\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAD"],

        ["\xE6\xA4\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC5"],
        ["\x47\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8D"],

        ["\xE6\xAE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x73"],
        ["\x4E\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x96"],

        ["\xE7\x87\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE6"],
        ["\x54\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAD"],

        ["\xE7\xB9\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9A"],
        ["\x48\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x94"],

        ["\xE8\x81\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD7"],
        ["\x48\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB7"],

        ["\xE8\x89\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC3"],
        ["\x47\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB2"],

        ["\xE8\xA7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD1"],
        ["\x4C\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA6"],

        ["\xE9\xA3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB8"],
        ["\x46\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9F"],

        ["\xE8\x9D\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x47"],
        ["\x53\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x95"],

        ["\xE8\xBE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE5"],
        ["\x52\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB1"],

        ["\xE5\xB0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCE"],
        ["\x49\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBB"],

        ["\xE4\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF4"],
        ["\x46\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB8"],

        ["\xE4\xBF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA5"],
        ["\x45\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA1"],

        ["\xE4\xBE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8C"],
        ["\x4F\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB5"],

        ["\xE5\x94\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x76"],
        ["\x4F\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x87"],

        ["\xE5\xA8\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4C"],
        ["\x52\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA0"],

        ["\xE5\xAF\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x59"],
        ["\x4B\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9D"],

        ["\xE5\xAF\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x87"],
        ["\x49\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA9"],

        ["\xE5\xBF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE7"],
        ["\x46\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x83"],

        ["\xE6\x85\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],
        ["\x4A\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8E"],

        ["\xE6\x8C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF6"],
        ["\x48\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAF"],

        ["\xE6\x96\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x87"],
        ["\x45\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB0"],

        ["\xE6\x99\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB2"],
        ["\x4B\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8B"],

        ["\xE6\xA3\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9D"],
        ["\x45\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAE"],

        ["\xE6\xA6\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7E"],
        ["\x4D\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9B"],

        ["\xE6\xB5\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x41"],
        ["\x4D\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB8"],

        ["\xE6\xB7\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x77"],
        ["\x47\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB1"],

        ["\xE7\x94\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x67"],
        ["\x49\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB3"],

        ["\xE7\x96\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE1"],
        ["\x54\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB9"],

        ["\xE7\x9C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x42"],
        ["\x46\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9F"],

        ["\xE7\xA5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA1"],
        ["\x45\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9E"],

        ["\xE7\xA7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8A"],
        ["\x4C\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA6"],

        ["\xE7\xB4\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x59"],
        ["\x4E\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB3"],

        ["\xE8\x87\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x47"],
        ["\x4A\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA3"],

        ["\xE8\x8A\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE5"],
        ["\x4F\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAF"],

        ["\xE8\x96\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5A"],
        ["\x54\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAA"],

        ["\xE8\xA6\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x85"],
        ["\x48\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAA"],

        ["\xE8\xA8\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x68"],
        ["\x4D\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBA"],

        ["\xE8\xBA\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9C"],
        ["\x47\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAB"],

        ["\xE8\xBE\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5E"],
        ["\x4D\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9B"],

        ["\xE9\x80\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x69"],
        ["\x46\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB2"],

        ["\xE9\x87\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x88"],
        ["\x49\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9D"],

        ["\xE9\x9C\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDE"],
        ["\x4D\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x87"],

        ["\xE4\xBA\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x93"],
        ["\x45\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBA"],

        ["\xE4\xBB\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x76"],
        ["\x47\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x81"],

        ["\xE5\x88\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x44"],
        ["\x4F\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x83"],

        ["\xE5\xA1\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x89"],
        ["\x4D\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB5"],

        ["\xE5\xA3\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4F"],
        ["\x51\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAC"],

        ["\xE5\xB0\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5F"],
        ["\x4D\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8B"],

        ["\xE7\x94\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x66"],
        ["\x4B\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9A"],

        ["\xE5\xB0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB9"],
        ["\x4F\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBD"],

        ["\xE8\x85\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC4"],
        ["\x52\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8E"],

        ["\xE8\xA8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF2"],
        ["\x50\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8A"],

        ["\xE8\xBF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x68"],
        ["\x50\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x85"],

        ["\xE9\x99\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x84"],
        ["\x4C\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA3"],

        ["\xE9\x9D\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"],
        ["\x66\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAD"],

        ["\xE7\xAC\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF4"],
        ["\x52\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA5"],

        ["\xE8\xAB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC1"],
        ["\x4B\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8F"],

        ["\xE9\xA0\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB0"],
        ["\x46\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x88"],

        ["\xE9\x85\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAE"],
        ["\x4B\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA2"],

        ["\xE5\x9B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC1"],
        ["\x47\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB3"],

        ["\xE5\x8E\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x78"],
        ["\x51\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA8"],

        ["\xE9\x80\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB3"],
        ["\x4F\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x97"],

        ["\xE5\x90\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC4"],
        ["\x49\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB9"],

        ["\xE5\x9E\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC9"],
        ["\x4B\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x82"],

        ["\xE5\xB8\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAF"],
        ["\x52\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xA5"],

        ["\xE6\x8E\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD5"],
        ["\x48\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA8"],

        ["\xE6\xB0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9C"],
        ["\x45\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB4"],

        ["\xE7\x82\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCB"],
        ["\x4F\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8A"],

        ["\xE7\x9D\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6C"],
        ["\x52\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA1"],

        ["\xE7\xB2\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCC"],
        ["\x4F\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8B"],

        ["\xE7\xBF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x69"],
        ["\x4F\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA0"],

        ["\xE8\xA1\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x54"],
        ["\x4F\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB0"],

        ["\xE9\x81\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF7"],
        ["\x4C\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x82"],

        ["\xE9\x85\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7C"],
        ["\x4E\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x94"],

        ["\xE9\x8C\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x90"],
        ["\x53\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x90"],

        ["\xE9\x8C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xEF"],
        ["\x54\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x98"],

        ["\xE9\x9A\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x76"],
        ["\x4E\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8F"],

        ["\xE7\x91\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5B"],
        ["\x4B\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9E"],

        ["\xE9\xAB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC5"],
        ["\x52\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x84"],

        ["\xE5\xB4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7F"],
        ["\x4C\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x87"],

        ["\xE5\xB5\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9E"],
        ["\x50\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA9"],

        ["\xE6\x95\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCC"],
        ["\x46\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB0"],

        ["\xE6\x9E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD0"],
        ["\x52\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA2"],

        ["\xE8\xB6\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x61"],
        ["\x55\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA8"],

        ["\xE9\x9B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xFB"],
        ["\x51\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9B"],

        ["\xE6\x8D\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD6"],
        ["\x4E\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAE"],

        ["\xE6\x9D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x68"],
        ["\x46\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x89"],

        ["\xE6\xA4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xED"],
        ["\x4F\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x99"],

        ["\xE8\x8F\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x53"],
        ["\x47\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x85"],

        ["\xE9\xA0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE4"],
        ["\x55\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x97"],

        ["\xE9\x9B\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x64"],
        ["\x4F\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x80"],

        ["\xE8\xA3\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8D"],
        ["\x4C\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBE"],

        ["\xE6\xBE\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x87"],
        ["\x48\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x84"],

        ["\xE6\x91\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xEF"],
        ["\x51\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xBA"],

        ["\xE5\xAF\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x60"],
        ["\x4B\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB8"],

        ["\xE4\xB8\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9B"],
        ["\x46\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x96"],

        ["\xE7\x80\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5B"],
        ["\x46\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xAC"],

        ["\xE7\x95\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x86"],
        ["\x50\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9D"],

        ["\xE6\x98\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBB"],
        ["\x4B\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAF"],

        ["\xE5\x87\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDC"],
        ["\x52\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x84"],

        ["\xE5\x88\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC4"],
        ["\x46\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB6"],

        ["\xE5\x8B\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xEE"],
        ["\x47\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA2"],

        ["\xE5\xA7\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF1"],
        ["\x4F\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x93"],

        ["\xE5\xBE\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],
        ["\x4A\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x81"],

        ["\xE6\x80\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6E"],
        ["\x46\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA7"],

        ["\xE6\x88\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBA"],
        ["\x45\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x90"],

        ["\xE6\x94\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC7"],
        ["\x45\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBF"],

        ["\xE6\x95\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7C"],
        ["\x47\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB4"],

        ["\xE6\x98\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA9"],
        ["\x47\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9F"],

        ["\xE6\x99\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x95"],
        ["\x47\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB4"],

        ["\xE6\xA3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x75"],
        ["\x53\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB2"],

        ["\xE6\xA0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCC"],
        ["\x4D\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x96"],

        ["\xE6\xAD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x77"],
        ["\x45\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA3"],

        ["\xE6\xB8\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x96"],
        ["\x45\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x85"],

        ["\xE7\x89\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x58"],
        ["\x51\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB2"],

        ["\xE7\x94\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x99"],
        ["\x45\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9F"],

        ["\xE7\x9B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x44"],
        ["\x48\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9B"],

        ["\xE7\xB2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6C"],
        ["\x46\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBE"],

        ["\xE8\x81\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB5"],
        ["\x4B\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x96"],

        ["\xE5\xA3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6C"],
        ["\x49\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB0"],

        ["\xE8\xA3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7B"],
        ["\x45\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBD"],

        ["\xE8\xA5\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x58"],
        ["\x45\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBF"],

        ["\xE8\xAA\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xFD"],
        ["\x46\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA0"],

        ["\xE8\xAA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA0"],
        ["\x4F\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x93"],

        ["\xE8\xAB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE8"],
        ["\x4A\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8B"],

        ["\xE9\x80\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB1"],
        ["\x53\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9D"],

        ["\xE9\x86\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x78"],
        ["\x53\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x92"],

        ["\xE9\x9D\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4C"],
        ["\x46\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x92"],

        ["\xE9\x9D\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x44"],
        ["\x46\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x99"],

        ["\xE6\x96\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8E"],
        ["\x46\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x89"],

        ["\xE7\xA8\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC4"],
        ["\x47\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8E"],

        ["\xE8\x84\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xEC"],
        ["\x55\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x86"],

        ["\xE9\x9A\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDA"],
        ["\x4F\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBB"],

        ["\xE5\xB8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x53"],
        ["\x4B\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAD"],

        ["\xE6\x83\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD7"],
        ["\x4E\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9C"],

        ["\xE6\x88\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x95"],
        ["\x55\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9A"],

        ["\xE6\x96\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x41"],
        ["\x51\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA5"],

        ["\xE6\x98\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],
        ["\x4C\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x94"],

        ["\xE6\x9E\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE2"],
        ["\x4A\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x90"],

        ["\xE7\x9F\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x80"],
        ["\x45\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB3"],

        ["\xE7\xA9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x91"],
        ["\x48\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8D"],

        ["\xE7\xB1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xFE"],
        ["\x4D\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8D"],

        ["\xE7\xB8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x66"],
        ["\x48\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBE"],

        ["\xE8\x84\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5E"],
        ["\x53\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x8A"],

        ["\xE8\xB2\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD2"],
        ["\x4B\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAC"],

        ["\xE8\xB5\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF9"],
        ["\x46\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA4"],

        ["\xE8\xB7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCD"],
        ["\x4C\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA1"],

        ["\xE8\xB9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x68"],
        ["\x53\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x9F"],

        ["\xE7\xA2\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],
        ["\x50\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA9"],

        ["\xE5\x88\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x65"],
        ["\x47\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x87"],

        ["\xE6\x8B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5C"],
        ["\x52\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x99"],

        ["\xE6\x8E\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA8"],
        ["\x47\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA5"],

        ["\xE6\x91\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8C"],
        ["\x4E\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x82"],

        ["\xE6\x8A\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8D"],
        ["\x49\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x98"],

        ["\xE8\xA8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE2"],
        ["\x45\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAD"],

        ["\xE7\xAA\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x69"],
        ["\x51\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x83"],

        ["\xE7\xAF\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA1"],
        ["\x47\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x80"],

        ["\xE8\xAA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x52"],
        ["\x49\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAC"],

        ["\xE9\x9B\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBB"],
        ["\x49\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAA"],

        ["\xE7\xB5\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF3"],
        ["\x4A\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB6"],

        ["\xE8\x88\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x94"],
        ["\x50\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8C"],

        ["\xE8\x9D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE8"],
        ["\x53\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x89"],

        ["\xE4\xBB\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA2"],
        ["\x48\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x99"],

        ["\xE5\x85\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA2"],
        ["\x47\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x88"],

        ["\xE5\x8D\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4C"],
        ["\x45\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x83"],

        ["\xE5\x8D\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xEE"],
        ["\x49\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA0"],

        ["\xE5\xAE\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8F"],
        ["\x49\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA3"],

        ["\xE5\xB0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xFB"],
        ["\x49\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x82"],

        ["\xE5\xB0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC0"],
        ["\x53\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x96"],

        ["\xE5\xB7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x67"],
        ["\x45\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9D"],

        ["\xE6\x88\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x64"],
        ["\x47\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA6"],

        ["\xE6\x89\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCA"],
        ["\x4D\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x87"],

        ["\xE6\x92\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x72"],
        ["\x53\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB0"],

        ["\xE6\xA0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE3"],
        ["\x50\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x93"],

        ["\xE6\xA0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDA"],
        ["\x55\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB4"],

        ["\xE6\xB3\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xEE"],
        ["\x46\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x89"],

        ["\xE6\xB5\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8D"],
        ["\x46\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x85"],

        ["\xE6\xB4\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],
        ["\x4A\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x97"],

        ["\xE6\x9F\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9B"],
        ["\x48\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x93"],

        ["\xE6\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC0"],
        ["\x4D\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9C"],

        ["\xE7\x85\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x90"],
        ["\x54\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8E"],

        ["\xE7\x85\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x90"],
        ["\x55\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xBD"],

        ["\xE6\x97\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7B"],
        ["\x4D\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8B"],

        ["\xE7\xA9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x91"],
        ["\x4E\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBF"],

        ["\xE7\xAE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8D"],
        ["\x51\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAD"],

        ["\xE7\xB7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x87"],
        ["\x46\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9A"],

        ["\xE7\xB9\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x68"],
        ["\x48\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8A"],

        ["\xE7\xBE\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x96"],
        ["\x55\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA8"],

        ["\xE8\x85\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6F"],
        ["\x52\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBA"],

        ["\xE8\x88\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC1"],
        ["\x4F\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9B"],

        ["\xE8\x88\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7B"],
        ["\x46\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB9"],

        ["\xE8\x96\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBF"],
        ["\x4F\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA6"],

        ["\xE8\xA9\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8E"],
        ["\x51\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAE"],

        ["\xE8\xB3\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],
        ["\x64\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8E"],

        ["\xE8\xB7\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD1"],
        ["\x50\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB5"],

        ["\xE9\x81\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x5D"],
        ["\x48\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB8"],

        ["\xE9\x81\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5B"],
        ["\x53\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB7"],

        ["\xE9\x8A\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x48"],
        ["\x4D\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xAD"],

        ["\xE9\x8A\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAD"],
        ["\x4C\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x91"],

        ["\xE9\x96\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9C"],
        ["\x51\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x83"],

        ["\xE9\xAE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE9"],
        ["\x4C\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAE"],

        ["\xE5\x89\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAF"],
        ["\x45\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8D"],

        ["\xE5\x96\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB3"],
        ["\x46\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x84"],

        ["\xE6\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x73"],
        ["\x4D\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB8"],

        ["\xE7\x84\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xEF"],
        ["\x47\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB6"],

        ["\xE5\x85\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB1"],
        ["\x46\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA8"],

        ["\xE7\xA6\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x87"],
        ["\x4F\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x85"],

        ["\xE7\xB9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD4"],
        ["\x51\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x95"],

        ["\xE8\x86\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x76"],
        ["\x50\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB3"],

        ["\xE7\xB3\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x60"],
        ["\x51\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8E"],

        ["\xE5\x99\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x62"],
        ["\x50\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8C"],

        ["\xE5\xA1\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC6"],
        ["\x4E\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x91"],

        ["\xE5\xB2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB9"],
        ["\x54\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA8"],

        ["\xE6\x8E\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],
        ["\x4A\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAA"],

        ["\xE6\x9B\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x66"],
        ["\x51\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBE"],

        ["\xE6\x9B\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5F"],
        ["\x49\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBD"],

        ["\xE6\xA5\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4C"],
        ["\x53\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9A"],

        ["\xE7\x8B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCF"],
        ["\x4E\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x99"],

        ["\xE7\x96\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB0"],
        ["\x55\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8F"],

        ["\xE7\x96\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x71"],
        ["\x51\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8E"],

        ["\xE7\xA4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9C"],
        ["\x4C\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x8E"],

        ["\xE7\xA5\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDC"],
        ["\x4C\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x96"],

        ["\xE7\xA7\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x83"],
        ["\x4D\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x9F"],

        ["\xE7\xB2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x59"],
        ["\x4D\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x97"],

        ["\xE7\xB4\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x9F"],
        ["\x47\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA0"],

        ["\xE7\xB5\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB9"],
        ["\x46\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x84"],

        ["\xE8\x98\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBF"],
        ["\x4C\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x87"],

        ["\xE8\xA8\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDF"],
        ["\x4C\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB4"],

        ["\xE9\x98\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xEF"],
        ["\x4F\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBB"],

        ["\xE9\x81\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4C"],
        ["\x54\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA1"],

        ["\xE9\xBC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCB"],
        ["\x50\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA0"],

        ["\xE5\x83\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x84"],
        ["\x4E\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA7"],

        ["\xE5\x89\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE1"],
        ["\x4B\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB5"],

        ["\xE5\x8F\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x71"],
        ["\x4B\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8C"],

        ["\xE5\x8F\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF5"],
        ["\x53\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA2"],

        ["\xE5\x80\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD6"],
        ["\x45\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x89"],

        ["\xE5\x96\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x68"],
        ["\x51\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAA"],

        ["\xE5\xA3\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9F"],
        ["\x4C\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAE"],

        ["\xE5\xA5\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x53"],
        ["\x4C\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8F"],

        ["\xE7\x88\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDD"],
        ["\x52\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBD"],

        ["\xE5\xAE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4D"],
        ["\x52\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8B"],

        ["\xE5\xB1\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8E"],
        ["\x4A\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA4"],

        ["\xE5\x8C\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB7"],
        ["\x51\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9D"],

        ["\xE6\x83\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x68"],
        ["\x4B\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA3"],

        ["\xE6\x83\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB3"],
        ["\x48\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB3"],

        ["\xE6\x8D\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDD"],
        ["\x4D\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x9C"],

        ["\xE6\x8E\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC3"],
        ["\x4D\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x83"],

        ["\xE6\x8C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x55"],
        ["\x55\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBF"],

        ["\xE6\x8E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA3"],
        ["\x54\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBB"],

        ["\xE6\x93\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9B"],
        ["\x49\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8D"],

        ["\xE6\x97\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE9"],
        ["\x46\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA9"],

        ["\xE6\x9B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD2"],
        ["\x4E\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB9"],

        ["\xE5\xB7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],
        ["\x4C\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA3"],

        ["\xE6\xA7\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDB"],
        ["\x52\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8D"],

        ["\xE6\xA7\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB7"],
        ["\x4D\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBD"],

        ["\xE6\xBC\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA1"],
        ["\x54\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x95"],

        ["\xE7\x87\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],
        ["\x4C\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA5"],

        ["\xE4\xBA\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x96"],
        ["\x48\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x89"],

        ["\xE7\x97\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA4"],
        ["\x54\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA9"],

        ["\xE7\x9B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x78"],
        ["\x46\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB8"],

        ["\xE7\xAA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE9"],
        ["\x4B\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x93"],

        ["\xE7\xB3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8C"],
        ["\x51\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9F"],

        ["\xE7\xB7\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x93"],
        ["\x47\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8F"],

        ["\xE7\xB6\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x70"],
        ["\x50\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9C"],

        ["\xE8\x81\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x89"],
        ["\x4B\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA1"],

        ["\xE8\x8D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x42"],
        ["\x48\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x89"],

        ["\xE8\x8D\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x62"],
        ["\x4B\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x98"],

        ["\xE8\x91\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x79"],
        ["\x4F\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAC"],

        ["\xE8\x92\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB9"],
        ["\x50\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBC"],

        ["\xE8\x97\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5F"],
        ["\x50\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBB"],

        ["\xE8\xA3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x98"],
        ["\x48\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x85"],

        ["\xE8\xB5\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAA"],
        ["\x4A\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB0"],

        ["\xE9\x80\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x44"],
        ["\x47\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x81"],

        ["\xE9\x81\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x43"],
        ["\x51\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAD"],

        ["\xE9\x8E\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x97"],
        ["\x51\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x97"],

        ["\xE9\x9C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE8"],
        ["\x4D\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9C"],

        ["\xE9\xA8\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD2"],
        ["\x4D\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x92"],

        ["\xE5\x83\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBA"],
        ["\x4B\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8F"],

        ["\xE5\xA2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4D"],
        ["\x46\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x97"],

        ["\xE6\x86\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],
        ["\x4F\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8E"],

        ["\xE8\x87\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBD"],
        ["\x4D\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x93"],

        ["\xE8\x94\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5E"],
        ["\x46\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB5"],

        ["\xE8\xB4\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],
        ["\x4C\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x88"],

        ["\xE9\x80\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB8"],
        ["\x45\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA0"],

        ["\xE4\xBF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],
        ["\x4A\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x83"],

        ["\xE5\x81\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x43"],
        ["\x49\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB4"],

        ["\xE5\x89\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4D"],
        ["\x47\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x87"],

        ["\xE5\x8D\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6D"],
        ["\x4B\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB3"],

        ["\xE6\x81\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB0"],
        ["\x4B\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAF"],

        ["\xE6\x8D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA0"],
        ["\x53\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x89"],

        ["\xE6\x9D\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4B"],
        ["\x4B\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9F"],

        ["\xE6\xB8\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x45"],
        ["\x49\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAC"],

        ["\xE8\xB6\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xFA"],
        ["\x46\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xB3"],

        ["\xE9\x80\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCD"],
        ["\x48\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9F"],

        ["\xE4\xBF\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x97"],
        ["\x4E\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x97"],

        ["\xE5\xB1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6D"],
        ["\x47\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9E"],

        ["\xE8\xB3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xFD"],
        ["\x4F\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8A"],

        ["\xE6\x97\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDC"],
        ["\x4A\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8F"],

        ["\xE7\xB6\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCB"],
        ["\x47\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9A"],

        ["\xE5\x8D\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF2"],
        ["\x4A\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x92"],

        ["\xE8\xA2\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],
        ["\x4A\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x96"],

        ["\xE5\x85\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x67"],
        ["\x4F\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB6"],

        ["\xE6\x8F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xFD"],
        ["\x4E\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x83"],

        ["\xE5\xAD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x41"],
        ["\x4A\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x98"],

        ["\xE5\xAD\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],
        ["\x4C\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xAB"],

        ["\xE5\xB0\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xEF"],
        ["\x4C\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8A"],

        ["\xE6\x90\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD8"],
        ["\x4B\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8D"],

        ["\xE6\x9D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x56"],
        ["\x45\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x91"],

        ["\xE9\x81\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x55"],
        ["\x54\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9C"],

        ["\xE4\xBB\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x55"],
        ["\x47\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x96"],

        ["\xE5\xA4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xFE"],
        ["\x45\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9A"],

        ["\xE5\xA4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAB"],
        ["\x45\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAA"],

        ["\xE6\xB1\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD2"],
        ["\x50\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB0"],

        ["\xE8\xA9\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE3"],
        ["\x55\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x91"],

        ["\xE5\x94\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x78"],
        ["\x54\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xBE"],

        ["\xE5\xA0\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB0"],
        ["\x53\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x95"],

        ["\xE5\xA6\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9E"],
        ["\x4D\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA5"],

        ["\xE6\x83\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB8"],
        ["\x54\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB0"],

        ["\xE6\x89\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xEA"],
        ["\x47\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x93"],

        ["\xE6\x9F\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCD"],
        ["\x55\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x81"],

        ["\xE8\x88\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDB"],
        ["\x54\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB5"],

        ["\xE6\xA5\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC5"],
        ["\x55\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x95"],

        ["\xE9\x99\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE8"],
        ["\x4F\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x80"],

        ["\xE9\xA7\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE5"],
        ["\x4D\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x84"],

        ["\xE9\xA8\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDA"],
        ["\x53\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA8"],

        ["\xE4\xBD\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x96"],
        ["\x46\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x93"],

        ["\xE5\xA0\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x71"],
        ["\x53\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x86"],

        ["\xE5\xAF\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x56"],
        ["\x46\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBE"],

        ["\xE8\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8E"],
        ["\x49\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x90"],

        ["\xE5\xB2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x62"],
        ["\x52\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB1"],

        ["\xE5\xB8\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x60"],
        ["\x49\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAF"],

        ["\xE5\xBE\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA3"],
        ["\x48\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x85"],

        ["\xE6\x80\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x81"],
        ["\x50\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA0"],

        ["\xE6\x85\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xFD"],
        ["\x48\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8B"],

        ["\xE6\x88\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x92"],
        ["\x50\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB4"],

        ["\xE6\x9B\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC3"],
        ["\x4B\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBF"],

        ["\xE6\xB3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF3"],
        ["\x46\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB0"],

        ["\xE6\xBB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA1"],
        ["\x4D\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9E"],

        ["\xE8\x83\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x63"],
        ["\x52\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8E"],

        ["\xE8\x85\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9A"],
        ["\x52\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBF"],

        ["\xE8\x8B\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD7"],
        ["\x52\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x94"],

        ["\xE8\xA2\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x54"],
        ["\x4A\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8B"],

        ["\xE8\xB2\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF4"],
        ["\x4A\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB8"],

        ["\xE9\x80\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x49"],
        ["\x4B\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x80"],

        ["\xE9\x80\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x77"],
        ["\x4F\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xAE"],

        ["\xE9\x9A\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x93"],
        ["\x4A\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8A"],

        ["\xE9\xBB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xDD"],
        ["\x51\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9B"],

        ["\xE9\xAF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD8"],
        ["\x50\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x9B"],

        ["\xE4\xBB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x9A"],
        ["\x45\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA3"],

        ["\xE5\x8F\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x78"],
        ["\x47\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB0"],

        ["\xE5\xA4\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5B"],
        ["\x45\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA7"],

        ["\xE7\xAC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7E"],
        ["\x46\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAC"],

        ["\xE9\x86\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6F"],
        ["\x51\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8D"],

        ["\xE9\xA1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xFE"],
        ["\x47\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8C"],

        ["\xE9\xB7\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7A"],
        ["\x4B\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB9"],

        ["\xE6\xBB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xA3"],
        ["\x47\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9D"],

        ["\xE7\x80\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAE"],
        ["\x52\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA7"],

        ["\xE5\x8D\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x96"],
        ["\x49\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x93"],

        ["\xE5\x95\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x83"],
        ["\x53\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x84"],

        ["\xE5\xAE\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6F"],
        ["\x48\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x85"],

        ["\xE6\x89\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD5"],
        ["\x55\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x98"],

        ["\xE6\x8A\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7E"],
        ["\x4E\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9E"],

        ["\xE6\x8B\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDB"],
        ["\x4B\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x93"],

        ["\xE6\xB2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x85"],
        ["\x45\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA2"],

        ["\xE6\xBF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD4"],
        ["\x4D\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAF"],

        ["\xE7\x90\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5C"],
        ["\x4E\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA2"],

        ["\xE8\xA8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB6"],
        ["\x4A\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x97"],

        ["\xE9\x90\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x88"],
        ["\x53\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB8"],

        ["\xE6\xBF\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBE"],
        ["\x50\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x81"],

        ["\xE8\xAB\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE1"],
        ["\x4F\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBE"],

        ["\xE8\x8C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF7"],
        ["\x4D\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB8"],

        ["\xE5\x87\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8A"],
        ["\x55\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA7"],

        ["\xE8\x9B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4E"],
        ["\x52\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB8"],

        ["\xE5\x8F\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x41"],
        ["\x4E\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAA"],

        ["\xE5\x8F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x71"],
        ["\x4F\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA9"],

        ["\xE4\xBD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xFE"],
        ["\x4E\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x86"],

        ["\xE9\x81\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA4"],
        ["\x46\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x94"],

        ["\xE8\xBE\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDF"],
        ["\x47\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB0"],

        ["\xE5\xA5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBB"],
        ["\x4E\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAA"],

        ["\xE8\x84\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB4"],
        ["\x4A\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB1"],

        ["\xE5\xB7\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x46"],
        ["\x4E\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBD"],

        ["\xE7\xAB\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC8"],
        ["\x51\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAA"],

        ["\xE8\xBE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7E"],
        ["\x54\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBF"],

        ["\xE6\xA3\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xEF"],
        ["\x4B\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9A"],

        ["\xE8\xB0\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x81"],
        ["\x45\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xB7"],

        ["\xE7\x8B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xFE"],
        ["\x52\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB8"],

        ["\xE9\xB1\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x60"],
        ["\x55\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x88"],

        ["\xE6\xA8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBE"],
        ["\x4B\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBD"],

        ["\xE8\xAA\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x83"],
        ["\x4B\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB0"],

        ["\xE4\xB8\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAB"],
        ["\x48\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB9"],

        ["\xE5\x8D\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE3"],
        ["\x48\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x98"],

        ["\xE5\x98\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x63"],
        ["\x50\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x86"],

        ["\xE5\x9D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC4"],
        ["\x51\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA6"],

        ["\xE6\x8B\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA1"],
        ["\x4A\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x85"],

        ["\xE6\x8E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7F"],
        ["\x4B\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA2"],

        ["\xE6\x97\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9D"],
        ["\x4D\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA6"],

        ["\xE6\xAD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x87"],
        ["\x54\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8E"],

        ["\xE6\xB7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA5"],
        ["\x4C\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA1"],

        ["\xE6\xB9\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF3"],
        ["\x53\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9B"],

        ["\xE7\x82\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x61"],
        ["\x48\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAD"],

        ["\xE7\x9F\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x82"],
        ["\x4A\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAD"],

        ["\xE7\xAB\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xEF"],
        ["\x48\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAF"],

        ["\xE7\xAE\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCA"],
        ["\x54\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAA"],

        ["\xE7\xB6\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA6"],
        ["\x54\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBB"],

        ["\xE8\x80\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB8"],
        ["\x55\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBD"],

        ["\xE8\x83\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9B"],
        ["\x4E\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x86"],

        ["\xE8\x9B\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD8"],
        ["\x53\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8B"],

        ["\xE8\xAA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA2"],
        ["\x4F\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x95"],

        ["\xE9\x8D\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC7"],
        ["\x48\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9B"],

        ["\xE5\x9B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF0"],
        ["\x47\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA3"],

        ["\xE5\xA3\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8E"],
        ["\x4E\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x87"],

        ["\xE5\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD4"],
        ["\x4A\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBE"],

        ["\xE6\x96\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x89"],
        ["\x49\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAD"],

        ["\xE6\x9A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6C"],
        ["\x4D\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x96"],

        ["\xE6\xAA\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF5"],
        ["\x4F\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x80"],

        ["\xE6\xAE\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xED"],
        ["\x47\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB5"],

        ["\xE7\x94\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7C"],
        ["\x45\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB7"],

        ["\xE8\xAB\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x63"],
        ["\x49\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x87"],

        ["\xE5\x80\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7D"],
        ["\x48\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA4"],

        ["\xE7\x9F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB0"],
        ["\x45\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA5"],

        ["\xE5\x9C\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC2"],
        ["\x45\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB0"],

        ["\xE5\xBC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x97"],
        ["\x55\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9B"],

        ["\xE6\x81\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCE"],
        ["\x4E\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA5"],

        ["\xE6\x99\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA8"],
        ["\x46\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xBA"],

        ["\xE6\xB1\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE8"],
        ["\x45\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA0"],

        ["\xE7\x97\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x89"],
        ["\x50\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB4"],

        ["\xE7\xA8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCF"],
        ["\x4D\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9A"],

        ["\xE7\xBD\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8C"],
        ["\x46\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAE"],

        ["\xE8\x87\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],
        ["\x4C\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB4"],

        ["\xE8\x9C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDC"],
        ["\x54\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x98"],

        ["\xE9\x81\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],
        ["\x4C\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x85"],

        ["\xE9\xA6\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDF"],
        ["\x52\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB3"],

        ["\xE7\xAF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA8"],
        ["\x49\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x89"],

        ["\xE7\x95\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x72"],
        ["\x4D\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9C"],

        ["\xE7\xAB\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF5"],
        ["\x45\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB9"],

        ["\xE7\xAD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x45"],
        ["\x4B\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x91"],

        ["\xE8\x93\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x94"],
        ["\x4C\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x84"],

        ["\xE9\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBB"],
        ["\x50\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x90"],

        ["\xE7\xA7\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9F"],
        ["\x4D\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA9"],

        ["\xE7\xAA\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB0"],
        ["\x4F\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x92"],

        ["\xE8\x8C\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x77"],
        ["\x49\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB6"],

        ["\xE5\xAB\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x67"],
        ["\x55\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA1"],

        ["\xE7\x9D\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAA"],
        ["\x47\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x80"],

        ["\xE4\xB8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5C"],
        ["\x45\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAD"],

        ["\xE4\xBB\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x69"],
        ["\x48\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB2"],

        ["\xE5\xAE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x64"],
        ["\x4D\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x99"],

        ["\xE5\xBF\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4F"],
        ["\x46\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA0"],

        ["\xE6\x8A\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x53"],
        ["\x4D\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBD"],

        ["\xE6\x98\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x98"],
        ["\x4C\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBC"],

        ["\xE6\x9F\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xEA"],
        ["\x4B\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB1"],

        ["\xE6\xB3\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x44"],
        ["\x49\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA8"],

        ["\xE8\x99\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCB"],
        ["\x4B\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAB"],

        ["\xE8\xA1\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE9"],
        ["\x52\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB7"],

        ["\xE8\xA8\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x66"],
        ["\x4F\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBB"],

        ["\xE9\x85\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x91"],
        ["\x55\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8E"],

        ["\xE9\x8B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC1"],
        ["\x48\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB3"],

        ["\xE9\xA7\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF5"],
        ["\x4D\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x90"],

        ["\xE6\xA8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8B"],
        ["\x53\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x97"],

        ["\xE7\x80\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDE"],
        ["\x4F\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA6"],

        ["\xE7\x8C\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC5"],
        ["\x49\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAA"],

        ["\xE8\x8B\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB0"],
        ["\x54\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA7"],

        ["\xE8\x91\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],
        ["\x4A\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x97"],

        ["\xE8\xB2\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],
        ["\x4C\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAF"],

        ["\xE4\xB8\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCE"],
        ["\x4B\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x81"],

        ["\xE5\x85\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF3"],
        ["\x4D\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x86"],

        ["\xE5\x87\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF9"],
        ["\x55\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8B"],

        ["\xE5\x96\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x58"],
        ["\x55\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8B"],

        ["\xE5\xAF\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x56"],
        ["\x55\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB5"],

        ["\xE5\xB8\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC7"],
        ["\x51\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x96"],

        ["\xE5\xB8\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC5"],
        ["\x4D\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB3"],

        ["\xE5\xBA\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x92"],
        ["\x4B\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x81"],

        ["\xE5\xBC\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE5"],
        ["\x51\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x94"],

        ["\xE5\xBC\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBA"],
        ["\x48\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB5"],

        ["\xE5\xBD\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x86"],
        ["\x4E\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAB"],

        ["\xE5\xBE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],
        ["\x4C\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB4"],

        ["\xE6\x87\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x53"],
        ["\x51\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB2"],

        ["\xE6\x8C\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDB"],
        ["\x4F\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x91"],

        ["\xE6\x9A\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC7"],
        ["\x4C\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA2"],

        ["\xE6\x9C\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5C"],
        ["\x47\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9D"],

        ["\xE6\xBD\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x93"],
        ["\x4C\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAE"],

        ["\xE7\x89\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDD"],
        ["\x55\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x92"],

        ["\xE7\x94\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x55"],
        ["\x45\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBA"],

        ["\xE7\x9C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5F"],
        ["\x4E\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBA"],

        ["\xE8\x81\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA8"],
        ["\x4D\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB4"],

        ["\xE8\x84\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE9"],
        ["\x55\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB9"],

        ["\xE8\x85\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB6"],
        ["\x4D\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB8"],

        ["\xE8\x9D\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6E"],
        ["\x4E\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB6"],

        ["\xE8\xAA\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x89"],
        ["\x46\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBF"],

        ["\xE8\xAB\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x70"],
        ["\x55\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9C"],

        ["\xE8\xB6\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],
        ["\x4A\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x85"],

        ["\xE8\xB7\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB4"],
        ["\x50\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB3"],

        ["\xE9\x8A\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x80"],
        ["\x4E\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9A"],

        ["\xE9\x95\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x83"],
        ["\x45\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x95\xB7"],

        ["\xE9\xA0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5B"],
        ["\x4D\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x82"],

        ["\xE9\xB3\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x79"],
        ["\x47\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA5"],

        ["\xE5\x8B\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xEF"],
        ["\x4E\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x85"],

        ["\xE6\x8D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x46"],
        ["\x55\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x97"],

        ["\xE7\x9B\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x74"],
        ["\x46\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB4"],

        ["\xE6\x9C\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF3"],
        ["\x55\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x95"],

        ["\xE6\xB2\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x8F"],
        ["\x4C\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x88"],

        ["\xE7\x8F\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5D"],
        ["\x4D\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8D"],

        ["\xE8\xB3\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4D"],
        ["\x4B\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x83"],

        ["\xE9\x8E\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x89"],
        ["\x4C\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAE"],

        ["\xE9\x99\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x61"],
        ["\x4E\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB3"],

        ["\xE6\xB4\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDC"],
        ["\x45\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA5"],

        ["\xE5\xA2\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x50"],
        ["\x51\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9C"],

        ["\xE6\xA4\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA0"],
        ["\x4B\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8E"],

        ["\xE6\xA7\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xFA"],
        ["\x4E\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8C"],

        ["\xE8\xBF\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD1"],
        ["\x49\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBD"],

        ["\xE9\x8E\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xFE"],
        ["\x54\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x9A"],

        ["\xE7\x97\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x47"],
        ["\x4C\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9B"],

        ["\xE9\x80\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE3"],
        ["\x45\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9A"],

        ["\xE5\xA1\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x57"],
        ["\x46\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9A"],

        ["\xE6\xA0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD1"],
        ["\x52\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x82"],

        ["\xE6\x8E\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCD"],
        ["\x54\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB4"],

        ["\xE6\xA7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5C"],
        ["\x4B\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBB"],

        ["\xE4\xBD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDF"],
        ["\x4E\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x83"],

        ["\xE6\xBC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x8A"],
        ["\x4E\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAC"],

        ["\xE6\x9F\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD8"],
        ["\x4F\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x98"],

        ["\xE8\xBE\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF5"],
        ["\x47\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBB"],

        ["\xE8\x94\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA1"],
        ["\x4F\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA6"],

        ["\xE7\xB6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC9"],
        ["\x4D\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB4"],

        ["\xE9\x8D\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAA"],
        ["\x54\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x94"],

        ["\xE6\xA4\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xBA"],
        ["\x4C\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBF"],

        ["\xE6\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x46"],
        ["\x54\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB0"],

        ["\xE5\x9D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x49"],
        ["\x49\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xAA"],

        ["\xE5\xA3\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9B"],
        ["\x58\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB7"],

        ["\xE5\xAC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xEA"],
        ["\x52\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAC"],

        ["\xE7\xB4\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x92"],
        ["\x55\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAC"],

        ["\xE7\x88\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x87"],
        ["\x4C\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAA"],

        ["\xE5\x90\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD3"],
        ["\x53\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8A"],

        ["\xE9\x87\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE3"],
        ["\x4C\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA3"],

        ["\xE9\xB6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7A"],
        ["\x47\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB4"],

        ["\xE4\xBA\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x52"],
        ["\x4E\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAD"],

        ["\xE4\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA4"],
        ["\x48\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8E"],

        ["\xE5\x81\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x70"],
        ["\x4E\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9C"],

        ["\xE5\x81\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x95"],
        ["\x4F\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB5"],

        ["\xE5\x89\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x79"],
        ["\x53\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x83"],

        ["\xE8\xB2\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB6"],
        ["\x46\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9E"],

        ["\xE5\x91\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x56"],
        ["\x4F\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x88"],

        ["\xE5\xA0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x61"],
        ["\x4B\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA4"],

        ["\xE5\xAE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE7"],
        ["\x45\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9A"],

        ["\xE5\xB8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9C"],
        ["\x48\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9D"],

        ["\xE5\xBA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x64"],
        ["\x4B\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x95"],

        ["\xE5\xBA\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE0"],
        ["\x48\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAD"],

        ["\xE5\xBB\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5B"],
        ["\x50\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB7"],

        ["\xE5\xBC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9B"],
        ["\x4C\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9F"],

        ["\xE6\x82\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE3"],
        ["\x4D\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8C"],

        ["\xE6\x8A\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x90"],
        ["\x4B\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB5"],

        ["\xE6\x8C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x87"],
        ["\x53\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBA"],

        ["\xE6\x8F\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB9"],
        ["\x49\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x90"],

        ["\xE6\xA2\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE4"],
        ["\x51\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAF"],

        ["\xE6\xB1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4D"],
        ["\x53\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x80"],

        ["\xE7\xA2\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x95"],
        ["\x51\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x87"],

        ["\xE7\xA6\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xA7"],
        ["\x4B\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8E"],

        ["\xE7\xA8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF4"],
        ["\x47\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8B"],

        ["\xE7\xB7\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x80"],
        ["\x4A\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA0"],

        ["\xE8\x89\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xFC"],
        ["\x4D\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x87"],

        ["\xE8\xA8\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC4"],
        ["\x4F\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x82"],

        ["\xE8\xAB\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x46"],
        ["\x52\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA6"],

        ["\xE8\xB9\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA7"],
        ["\x55\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x84"],

        ["\xE9\x80\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5E"],
        ["\x51\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x93"],

        ["\xE9\x82\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x81"],
        ["\x4D\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB8"],

        ["\xE9\x84\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x54"],
        ["\x51\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xAD"],

        ["\xE9\x87\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF4"],
        ["\x4F\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x98"],

        ["\xE9\xBC\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAA"],
        ["\x51\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x8E"],

        ["\xE6\xB3\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x56"],
        ["\x4E\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA5"],

        ["\xE6\x91\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xCB"],
        ["\x4D\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x98"],

        ["\xE6\x93\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x43"],
        ["\x55\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA2"],

        ["\xE6\x95\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF3"],
        ["\x4B\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB5"],

        ["\xE6\xBB\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB7"],
        ["\x4F\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB4"],

        ["\xE7\x9A\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xEF"],
        ["\x45\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x84"],

        ["\xE7\xAC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x41"],
        ["\x4F\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9B"],

        ["\xE9\x81\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCC"],
        ["\x49\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA9"],

        ["\xE9\x8F\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x41"],
        ["\x50\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x91"],

        ["\xE6\xBA\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x97"],
        ["\x54\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBA"],

        ["\xE5\x93\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x47"],
        ["\x47\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB2"],

        ["\xE5\xBE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF8"],
        ["\x48\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB9"],

        ["\xE6\x92\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7A"],
        ["\x4E\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA4"],

        ["\xE8\xBD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xEE"],
        ["\x54\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8D"],

        ["\xE8\xBF\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDF"],
        ["\x53\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAD"],

        ["\xE9\x89\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD7"],
        ["\x45\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x84"],

        ["\xE5\x85\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC9"],
        ["\x47\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB8"],

        ["\xE5\xA1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5E"],
        ["\x4F\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xAB"],

        ["\xE5\xA4\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x8A"],
        ["\x46\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA9"],

        ["\xE5\xB1\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDD"],
        ["\x48\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x95"],

        ["\xE5\xBA\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x54"],
        ["\x48\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x97"],

        ["\xE6\xB7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x91"],
        ["\x4A\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBB"],

        ["\xE7\xBA\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xFA"],
        ["\x55\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8F"],

        ["\xE7\x94\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA7"],
        ["\x52\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9C"],

        ["\xE8\xB2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],
        ["\x50\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBC"],

        ["\xE8\xBB\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x52"],
        ["\x47\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA2"],

        ["\xE9\xA1\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC1"],
        ["\x55\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9B"],

        ["\xE7\x82\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x88"],
        ["\x47\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB9"],

        ["\xE4\xBC\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD9"],
        ["\x48\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9D"],

        ["\xE6\xAE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x49"],
        ["\x48\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBF"],

        ["\xE6\xBE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x89"],
        ["\x55\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB1"],

        ["\xE7\x94\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x63"],
        ["\x45\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB0"],

        ["\xE9\x9B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x82"],
        ["\x45\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xBB"],

        ["\xE5\x85\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],
        ["\x50\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8E"],

        ["\xE5\x90\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB2"],
        ["\x4E\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x90"],

        ["\xE5\xA0\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF6"],
        ["\x54\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB5"],

        ["\xE5\xA1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6A"],
        ["\x48\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x97"],

        ["\xE5\xA6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7F"],
        ["\x53\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xAC"],

        ["\xE5\xB1\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xFB"],
        ["\x53\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA0"],

        ["\xE5\xBE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],
        ["\x4C\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x92"],

        ["\xE6\x96\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x83"],
        ["\x4E\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x97"],

        ["\xE6\x9D\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5D"],
        ["\x52\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9C"],

        ["\xE6\xB8\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD2"],
        ["\x45\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA1"],

        ["\xE7\x99\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE8"],
        ["\x46\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBB"],

        ["\xE8\x8F\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD4"],
        ["\x53\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9F"],

        ["\xE8\xB3\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC1"],
        ["\x52\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAD"],

        ["\xE9\x80\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF0"],
        ["\x48\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x94"],

        ["\xE9\x83\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4F"],
        ["\x45\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xBD"],

        ["\xE9\x8D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD3"],
        ["\x55\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8D"],

        ["\xE7\xA0\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x45"],
        ["\x4D\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA5"],

        ["\xE7\xA0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDF"],
        ["\x50\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBA"],

        ["\xE5\x8A\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],
        ["\x4A\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAA"],

        ["\xE5\xBA\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDE"],
        ["\x45\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA6"],

        ["\xE5\x9C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x84"],
        ["\x46\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9F"],

        ["\xE5\xA5\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x90"],
        ["\x4D\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB4"],

        ["\xE6\x80\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD6"],
        ["\x4C\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x92"],

        ["\xE5\x80\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x6A"],
        ["\x4B\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x92"],

        ["\xE5\x85\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4B"],
        ["\x49\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9A"],

        ["\xE5\x86\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDE"],
        ["\x4B\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAC"],

        ["\xE5\x87\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE6"],
        ["\x4B\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8D"],

        ["\xE5\x88\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],
        ["\x4C\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x80"],

        ["\xE5\x94\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAB"],
        ["\x4B\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x90"],

        ["\xE5\xA1\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCB"],
        ["\x4C\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x94"],

        ["\xE5\xA1\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF8"],
        ["\x52\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x98"],

        ["\xE5\xA5\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x83"],
        ["\x55\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x97"],

        ["\xE5\xAE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5C"],
        ["\x51\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x95"],

        ["\xE5\xB3\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6F"],
        ["\x45\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB6"],

        ["\xE5\xB6\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD1"],
        ["\x47\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8B"],

        ["\xE6\x82\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x45"],
        ["\x51\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBC"],

        ["\xE6\x8A\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x51"],
        ["\x47\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x95"],

        ["\xE6\x90\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8F"],
        ["\x52\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAD"],

        ["\xE6\x9D\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x57"],
        ["\x45\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB1"],

        ["\xE6\xA1\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDA"],
        ["\x4A\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x83"],

        ["\xE6\xA2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x49"],
        ["\x5C\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBC"],

        ["\xE6\xA3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA9"],
        ["\x4E\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9F"],

        ["\xE7\x9B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x65"],
        ["\x4D\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x97"],

        ["\xE6\xB7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE1"],
        ["\x55\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x98"],

        ["\xE6\xB9\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBD"],
        ["\x48\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAF"],

        ["\xE6\xB6\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x69"],
        ["\x5D\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9B"],

        ["\xE7\x81\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x65"],
        ["\x4B\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAF"],

        ["\xE7\x87\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF8"],
        ["\x4E\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x88"],

        ["\xE5\xBD\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5F"],
        ["\x46\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x93"],

        ["\xE7\x97\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x49"],
        ["\x55\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x98"],

        ["\xE7\xA5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x53"],
        ["\x55\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB7"],

        ["\xE7\xAD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA7"],
        ["\x46\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x89"],

        ["\xE7\xAD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD0"],
        ["\x49\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x94"],

        ["\xE7\xAD\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7C"],
        ["\x4B\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x92"],

        ["\xE7\xB3\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x84"],
        ["\x48\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x96"],

        ["\xE7\xB5\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x81"],
        ["\x48\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB1"],

        ["\xE5\x88\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xDD"],
        ["\x4C\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB0"],

        ["\xE8\x91\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x71"],
        ["\x50\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA3"],

        ["\xE8\x95\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF0"],
        ["\x54\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA9"],

        ["\xE8\x97\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x68"],
        ["\x45\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA4"],

        ["\xE8\xA8\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD2"],
        ["\x49\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8E"],

        ["\xE8\xAC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE2"],
        ["\x4F\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x84"],

        ["\xE8\xB1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x99"],
        ["\x4A\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x86"],

        ["\xE8\xB8\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7C"],
        ["\x4D\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8F"],

        ["\xE9\x80\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],
        ["\x4C\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x83"],

        ["\xE9\x80\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDA"],
        ["\x4B\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8F"],

        ["\xE9\x90\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCF"],
        ["\x52\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x99"],

        ["\xE9\x99\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB7"],
        ["\x4A\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB6"],

        ["\xE9\xA0\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xEB"],
        ["\x47\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAD"],

        ["\xE9\xA8\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5E"],
        ["\x4E\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB0"],

        ["\xE9\x97\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCC"],
        ["\x4B\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x98"],

        ["\xE5\x83\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xEC"],
        ["\x48\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8D"],

        ["\xE5\x8B\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE4"],
        ["\x45\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x95"],

        ["\xE5\x90\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6D"],
        ["\x46\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8C"],

        ["\xE5\xA0\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7F"],
        ["\x49\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x82"],

        ["\xE5\xB0\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAE"],
        ["\x48\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8E"],

        ["\xE6\x86\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC2"],
        ["\x53\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA7"],

        ["\xE6\x92\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xDB"],
        ["\x55\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9E"],

        ["\xE6\xB4\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x98"],
        ["\x4D\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9E"],

        ["\xE7\x9E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9B"],
        ["\x4F\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB3"],

        ["\xE7\xAB\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x50"],
        ["\x4D\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA5"],

        ["\xE8\x83\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAB"],
        ["\x4E\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB4"],

        ["\xE8\x90\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF7"],
        ["\x54\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x84"],

        ["\xE9\x81\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x50"],
        ["\x45\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x93"],

        ["\xE9\x8A\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC0"],
        ["\x48\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x85"],

        ["\xE5\xB3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x96"],
        ["\x4F\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA0"],

        ["\xE9\xB4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA1"],
        ["\x51\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x87"],

        ["\xE5\x8C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF1"],
        ["\x50\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBF"],

        ["\xE5\xBE\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE8"],
        ["\x47\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x97"],

        ["\xE5\xBE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x54"],
        ["\x46\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB3"],

        ["\xE6\xB6\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x50"],
        ["\x55\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9C"],

        ["\xE7\x89\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xA2"],
        ["\x46\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB9"],

        ["\xE7\x9D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],
        ["\x4A\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA3"],

        ["\xE7\xA6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD0"],
        ["\x53\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBF"],

        ["\xE7\xAF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD8"],
        ["\x4A\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA4"],

        ["\xE6\xAF\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x97"],
        ["\x4C\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x92"],

        ["\xE7\x8B\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDB"],
        ["\x4A\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAC"],

        ["\xE8\xAA\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],
        ["\x4A\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAD"],

        ["\xE6\xA0\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD3"],
        ["\x47\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x83"],

        ["\xE6\xA9\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD4"],
        ["\x55\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA1"],

        ["\xE5\x87\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCF"],
        ["\x50\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB8"],

        ["\xE7\xAA\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xFD"],
        ["\x4A\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x81"],

        ["\xE6\xA4\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA7"],
        ["\x54\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB4"],

        ["\xE5\xB1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA7"],
        ["\x4D\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8A"],

        ["\xE9\xB3\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC4"],
        ["\x54\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB6"],

        ["\xE8\x8B\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x5A"],
        ["\x4D\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xAB"],

        ["\xE5\xAF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x84"],
        ["\x4A\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x85"],

        ["\xE9\x85\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x73"],
        ["\x4F\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x89"],

        ["\xE7\x80\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5C"],
        ["\x53\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9E"],

        ["\xE5\x99\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF1"],
        ["\x55\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB8"],

        ["\xE5\xB1\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDD"],
        ["\x4F\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAF"],

        ["\xE6\x83\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x65"],
        ["\x4E\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x87"],

        ["\xE6\x95\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF2"],
        ["\x49\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA6"],

        ["\xE6\xB2\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x98"],
        ["\x55\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8C"],

        ["\xE8\xB1\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCF"],
        ["\x4C\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x9A"],

        ["\xE9\x81\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF8"],
        ["\x54\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x81"],

        ["\xE9\xA0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7A"],
        ["\x51\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x93"],

        ["\xE5\x91\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB0"],
        ["\x50\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x91"],

        ["\xE6\x9B\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x56"],
        ["\x4C\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x87"],

        ["\xE9\x88\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x63"],
        ["\x4E\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8D"],

        ["\xE5\xA5\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE6"],
        ["\x45\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x88"],

        ["\xE9\x82\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x46"],
        ["\x48\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA3"],

        ["\xE5\x86\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8E"],
        ["\x45\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x85"],

        ["\xE4\xB9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA9"],
        ["\x55\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8D"],

        ["\xE5\x87\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9E"],
        ["\x54\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAA"],

        ["\xE8\x96\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAD"],
        ["\x51\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x99"],

        ["\xE8\xAC\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF9"],
        ["\x52\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8E"],

        ["\xE7\x81\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x96"],
        ["\x4B\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x98"],

        ["\xE6\x8D\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xC0"],
        ["\x4F\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBA"],

        ["\xE9\x8D\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x48"],
        ["\x4B\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8B"],

        ["\xE6\xA5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x93"],
        ["\x4D\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA2"],

        ["\xE9\xA6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA1"],
        ["\x50\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB4"],

        ["\xE7\xB8\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x59"],
        ["\x48\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x84"],

        ["\xE7\x95\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDD"],
        ["\x50\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB7"],

        ["\xE5\x8D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x59"],
        ["\x45\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x97"],

        ["\xE6\xA5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xDF"],
        ["\x4A\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA0"],

        ["\xE8\xBB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB1"],
        ["\x4C\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9F"],

        ["\xE9\x9B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5A"],
        ["\x49\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA3"],

        ["\xE6\xB1\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5E"],
        ["\x55\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9D"],

        ["\xE4\xBA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x42"],
        ["\x45\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8C"],

        ["\xE5\xB0\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x86"],
        ["\x4A\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBC"],

        ["\xE5\xBC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE1"],
        ["\x50\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x90"],

        ["\xE8\xBF\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF6"],
        ["\x64\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA9"],

        ["\xE5\x8C\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCB"],
        ["\x4E\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x82"],

        ["\xE8\xB3\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9E"],
        ["\x53\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x91"],

        ["\xE8\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x42"],
        ["\x4A\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x89"],

        ["\xE8\x99\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB6"],
        ["\x51\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB9"],

        ["\xE5\xBB\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD9"],
        ["\x51\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBF"],

        ["\xE6\x97\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x62"],
        ["\x45\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA5"],

        ["\xE4\xB9\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x98"],
        ["\x4A\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB3"],

        ["\xE5\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x65"],
        ["\x46\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA5"],

        ["\xE5\xA6\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF8"],
        ["\x4B\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x82"],

        ["\xE5\xB0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC6"],
        ["\x4C\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBF"],

        ["\xE9\x9F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xDF"],
        ["\x4F\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAE"],

        ["\xE4\xBB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x55"],
        ["\x4A\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBB"],

        ["\xE5\xA6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x43"],
        ["\x50\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8A"],

        ["\xE5\xBF\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD7"],
        ["\x4B\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8D"],

        ["\xE8\xAA\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],
        ["\x4A\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8D"],

        ["\xE6\xBF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7E"],
        ["\x50\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA1"],

        ["\xE7\xA6\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xFA"],
        ["\x50\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB0"],

        ["\xE7\xA5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x89"],
        ["\x4F\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA2"],

        ["\xE5\xAF\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA9"],
        ["\x4F\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA7"],

        ["\xE8\x91\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4E"],
        ["\x54\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB1"],

        ["\xE7\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD0"],
        ["\x4F\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAB"],

        ["\xE7\x86\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD5"],
        ["\x47\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB1"],

        ["\xE5\xB9\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x60"],
        ["\x45\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB4"],

        ["\xE5\xBF\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAE"],
        ["\x4A\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB5"],

        ["\xE6\x8D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC0"],
        ["\x54\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBB"],

        ["\xE6\x92\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x48"],
        ["\x53\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9A"],

        ["\xE7\x87\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD5"],
        ["\x49\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x83"],

        ["\xE7\xB2\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF7"],
        ["\x4B\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x98"],

        ["\xE4\xB9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9F"],
        ["\x4B\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x83"],

        ["\xE5\xBB\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x64"],
        ["\x55\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBC"],

        ["\xE4\xB9\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD8"],
        ["\x45\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8B"],

        ["\xE5\x9F\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF4"],
        ["\x4D\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9C"],

        ["\xE5\x9A\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x90"],
        ["\x51\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA2"],

        ["\xE6\x82\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCD"],
        ["\x4B\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA9"],

        ["\xE6\xBF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCE"],
        ["\x4A\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x83"],

        ["\xE7\xB4\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE2"],
        ["\x49\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8D"],

        ["\xE8\x83\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4F"],
        ["\x47\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBD"],

        ["\xE8\x84\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB3"],
        ["\x4C\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB3"],

        ["\xE8\x86\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5F"],
        ["\x53\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBF"],

        ["\xE8\xBE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x45"],
        ["\x48\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB2"],

        ["\xE8\xA6\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xEB"],
        ["\x53\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x97"],

        ["\xE8\x9A\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA2"],
        ["\x55\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA4"],

        ["\xE5\xB7\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7D"],
        ["\x4E\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB4"],

        ["\xE6\x8A\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE3"],
        ["\x4E\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x8A"],

        ["\xE6\x92\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x62"],
        ["\x4E\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAD"],

        ["\xE8\xA6\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xFA"],
        ["\x4B\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x87"],

        ["\xE6\x9D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x80"],
        ["\x52\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB7"],

        ["\xE6\xB3\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xCA"],
        ["\x46\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA2"],

        ["\xE6\xB4\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],
        ["\x4A\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBE"],

        ["\xE7\x90\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9F"],
        ["\x52\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB6"],

        ["\xE7\xA0\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBE"],
        ["\x4A\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB4"],

        ["\xE5\xA9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCC"],
        ["\x4E\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x86"],

        ["\xE7\xBD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x79"],
        ["\x55\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB5"],

        ["\xE8\x8A\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x42"],
        ["\x54\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAD"],

        ["\xE9\xA6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x64"],
        ["\x46\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAC"],

        ["\xE4\xBF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE1"],
        ["\x4C\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB3"],

        ["\xE5\xBB\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC7"],
        ["\x4B\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x83"],

        ["\xE6\x8B\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE2"],
        ["\x4E\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9D"],

        ["\xE6\x8E\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xFA"],
        ["\x4C\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x92"],

        ["\xE6\x95\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8A"],
        ["\x4B\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x97"],

        ["\xE6\x9D\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],
        ["\x4C\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAF"],

        ["\xE7\x9B\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBA"],
        ["\x53\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x83"],

        ["\xE7\x89\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6F"],
        ["\x55\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8C"],

        ["\xE8\x83\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB2"],
        ["\x4A\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8C"],

        ["\xE8\x82\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],
        ["\x50\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xBA"],

        ["\xE8\xBC\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF4"],
        ["\x4E\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA9"],

        ["\xE9\x85\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF3"],
        ["\x47\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8D"],

        ["\xE5\x80\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC4"],
        ["\x4A\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8D"],

        ["\xE5\x9F\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAC"],
        ["\x4D\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB9"],

        ["\xE5\xAA\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x80"],
        ["\x4D\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x92"],

        ["\xE6\xA2\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x98"],
        ["\x47\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x85"],

        ["\xE6\xA5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB3"],
        ["\x52\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB3"],

        ["\xE7\x85\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xEA"],
        ["\x54\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA4"],

        ["\xE7\x8B\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD6"],
        ["\x54\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBD"],

        ["\xE8\xB2\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x74"],
        ["\x49\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB7"],

        ["\xE5\xA3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x75"],
        ["\x47\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB2"],

        ["\xE8\xB3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],
        ["\x4F\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA0"],

        ["\xE9\x99\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC3"],
        ["\x55\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAA"],

        ["\xE9\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCA"],
        ["\x4F\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x99"],

        ["\xE8\x9D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],
        ["\x63\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xBF"],

        ["\xE7\xA7\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8F"],
        ["\x50\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA4"],

        ["\xE7\x9F\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC9"],
        ["\x55\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA7"],

        ["\xE8\x90\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4A"],
        ["\x49\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA9"],

        ["\xE4\xBC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA6"],
        ["\x49\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xAF"],

        ["\xE5\x89\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x81"],
        ["\x54\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA5"],

        ["\xE5\x8D\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF6"],
        ["\x45\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9A"],

        ["\xE6\x8B\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBA"],
        ["\x4F\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8D"],

        ["\xE6\x9F\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x80"],
        ["\x49\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8F"],

        ["\xE6\xB3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB8"],
        ["\x4D\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8A"],

        ["\xE7\x99\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x59"],
        ["\x46\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBD"],

        ["\xE7\xAE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE0"],
        ["\x4E\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x94"],

        ["\xE7\xB2\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],
        ["\x4C\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x95"],

        ["\xE8\x88\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x87"],
        ["\x4B\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB6"],

        ["\xE8\x96\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x92"],
        ["\x4A\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x84"],

        ["\xE8\xBF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xEF"],
        ["\x49\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAB"],

        ["\xE6\x9B\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA6"],
        ["\x52\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9D"],

        ["\xE6\xBC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8E"],
        ["\x50\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA0"],

        ["\xE7\x88\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD9"],
        ["\x4A\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x86"],

        ["\xE7\xB8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE6"],
        ["\x52\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9B"],

        ["\xE8\x8E\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB3"],
        ["\x54\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAB"],

        ["\xE9\xA7\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE5"],
        ["\x55\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x81"],

        ["\xE9\xBA\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE0"],
        ["\x4A\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA6"],

        ["\xE5\x87\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB6"],
        ["\x4B\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBD"],

        ["\xE7\xAE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xFB"],
        ["\x4A\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB1"],

        ["\xE7\xA1\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBF"],
        ["\x52\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB2"],

        ["\xE7\xAE\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],
        ["\x50\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB8"],

        ["\xE8\x82\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x41"],
        ["\x4B\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x87"],

        ["\xE7\xAD\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9B"],
        ["\x4D\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x88"],

        ["\xE6\xAB\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC5"],
        ["\x51\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA8"],

        ["\xE5\xB9\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xDE"],
        ["\x48\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA1"],

        ["\xE8\x82\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x50"],
        ["\x4E\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8C"],

        ["\xE7\x95\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x8B"],
        ["\x47\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x91"],

        ["\xE7\x95\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xFE"],
        ["\x49\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA0"],

        ["\xE5\x85\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x48"],
        ["\x45\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAB"],

        ["\xE9\x89\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA8"],
        ["\x4E\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA2"],

        ["\xE6\xBA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xFA"],
        ["\x54\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8C"],

        ["\xE7\x99\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4B"],
        ["\x46\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBA"],

        ["\xE9\x86\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xFA"],
        ["\x51\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x97"],

        ["\xE9\xAB\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF6"],
        ["\x4C\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAA"],

        ["\xE4\xBC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF6"],
        ["\x50\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x90"],

        ["\xE7\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x82"],
        ["\x4F\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB0"],

        ["\xE6\x8A\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x85"],
        ["\x4A\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9C"],

        ["\xE7\xAD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF5"],
        ["\x52\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8F"],

        ["\xE9\x96\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x72"],
        ["\x51\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA5"],

        ["\xE9\xB3\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x95"],
        ["\x4D\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA9"],

        ["\xE5\x99\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x82"],
        ["\x55\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xBA"],

        ["\xE5\xA1\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6F"],
        ["\x4F\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x99"],

        ["\xE8\x9B\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC2"],
        ["\x55\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA4"],

        ["\xE9\x9A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD5"],
        ["\x4E\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBC"],

        ["\xE4\xBC\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC9"],
        ["\x49\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB4"],

        ["\xE5\x88\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5C"],
        ["\x49\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA4"],

        ["\xE5\x8D\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x90"],
        ["\x47\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8A"],

        ["\xE5\x8F\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF9"],
        ["\x47\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8D"],

        ["\xE5\x8F\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB2"],
        ["\x55\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9B"],

        ["\xE5\xB8\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x75"],
        ["\x4F\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x86"],

        ["\xE6\x90\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC8"],
        ["\x4D\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAC"],

        ["\xE6\x96\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE4"],
        ["\x52\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x91"],

        ["\xE6\x9D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB4"],
        ["\x46\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBF"],

        ["\xE6\xB0\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6E"],
        ["\x55\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBE"],

        ["\xE6\xB1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5E"],
        ["\x50\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x8E"],

        ["\xE7\x89\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBD"],
        ["\x4A\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x88"],

        ["\xE7\x8A\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA7"],
        ["\x4C\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAF"],

        ["\xE7\x8F\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x66"],
        ["\x50\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAD"],

        ["\xE7\x95\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDC"],
        ["\x4E\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x94"],

        ["\xE7\xB9\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x59"],
        ["\x47\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x81"],

        ["\xE8\x88\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x56"],
        ["\x49\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAC"],

        ["\xE8\x97\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF6"],
        ["\x4F\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA9"],

        ["\xE8\xB2\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],
        ["\x4A\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA9"],

        ["\xE7\xAF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE8"],
        ["\x49\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x84"],

        ["\xE9\x87\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x46"],
        ["\x53\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x86"],

        ["\xE7\x85\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA0"],
        ["\x54\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA9"],

        ["\xE9\xA0\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x57"],
        ["\x55\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x92"],

        ["\xE9\xA3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xB5"],
        ["\x46\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAF"],

        ["\xE6\x8C\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA8"],
        ["\x52\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBD"],

        ["\xE6\x99\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB6"],
        ["\x4C\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA9"],

        ["\xE7\x95\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB9"],
        ["\x48\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAA"],

        ["\xE7\x9B\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x90"],
        ["\x48\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA4"],

        ["\xE7\xA3\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x9C"],
        ["\x4B\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x90"],

        ["\xE8\x95\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF7"],
        ["\x52\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x83"],

        ["\xE8\x9B\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA5"],
        ["\x53\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAE"],

        ["\xE5\x8C\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xED"],
        ["\x55\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAA"],

        ["\xE5\x8D\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAD"],
        ["\x53\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x91"],

        ["\xE5\x90\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],
        ["\x4C\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA6"],

        ["\xE5\xA6\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA2"],
        ["\x51\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x83"],

        ["\xE5\xBA\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8D"],
        ["\x55\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x87"],

        ["\xE5\xBD\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x72"],
        ["\x47\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBC"],

        ["\xE6\x82\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x9D"],
        ["\x4C\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB2"],

        ["\xE6\x89\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAD"],
        ["\x50\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x89"],

        ["\xE6\x89\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],
        ["\x4C\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB9"],

        ["\xE6\x8A\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA6"],
        ["\x4F\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAB"],

        ["\xE6\x96\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x80"],
        ["\x4B\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x90"],

        ["\xE6\xAF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x4E"],
        ["\x47\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x94"],

        ["\xE6\xB3\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xFD"],
        ["\x51\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8C"],

        ["\xE7\x96\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x97"],
        ["\x4D\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB2"],

        ["\xE7\x9A\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xDA"],
        ["\x49\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAE"],

        ["\xE7\xA2\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7B"],
        ["\x51\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x91"],

        ["\xE7\xA7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],
        ["\x4C\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x98"],

        ["\xE7\xB7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7D"],
        ["\x53\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8B"],

        ["\xE7\xBD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA5"],
        ["\x55\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB7"],

        ["\xE8\x82\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7B"],
        ["\x49\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA5"],

        ["\xE8\xA2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8D"],
        ["\x4B\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAB"],

        ["\xE8\xAA\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF2"],
        ["\x55\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB9"],

        ["\xE8\xB2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD0"],
        ["\x46\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBB"],

        ["\xE9\x81\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC4"],
        ["\x4C\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBF"],

        ["\xE9\x9D\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xE1"],
        ["\x48\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9E"],

        ["\xE9\xA3\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8A"],
        ["\x48\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9B"],

        ["\xE6\xA8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4F"],
        ["\x49\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8B"],

        ["\xE7\xB0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAB"],
        ["\x51\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB8"],

        ["\xE5\x82\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAC"],
        ["\x46\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x99"],

        ["\xE5\xB0\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC8"],
        ["\x45\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBE"],

        ["\xE5\xBE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5D"],
        ["\x4B\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAE"],

        ["\xE6\x9E\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5E"],
        ["\x52\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x87"],

        ["\xE6\xAF\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD7"],
        ["\x53\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x98"],

        ["\xE7\x90\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA3"],
        ["\x52\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB5"],

        ["\xE7\x9C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBC"],
        ["\x52\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x89"],

        ["\xE7\xBE\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7D"],
        ["\x45\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8E"],

        ["\xE9\xBC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xFD"],
        ["\x4C\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBB"],

        ["\xE6\x9F\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD9"],
        ["\x52\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8A"],

        ["\xE7\xA8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x87"],
        ["\x50\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x97"],

        ["\xE5\x8C\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD1"],
        ["\x4F\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB9"],

        ["\xE7\x96\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA0"],
        ["\x4E\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8B"],

        ["\xE9\xAB\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9D"],
        ["\x50\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAD"],

        ["\xE5\xBD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xE1"],
        ["\x45\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA6"],

        ["\xE8\x86\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],
        ["\x50\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9D"],

        ["\xE8\x8F\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCC"],
        ["\x48\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB1"],

        ["\xE8\x82\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6A"],
        ["\x52\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x98"],

        ["\xE5\xBC\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE0"],
        ["\x52\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBC"],

        ["\xE5\xBF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCA"],
        ["\x47\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x85"],

        ["\xE7\x95\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9A"],
        ["\x55\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA2"],

        ["\xE7\xAD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC7"],
        ["\x4A\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x86"],

        ["\xE9\x80\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAC"],
        ["\x55\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBC"],

        ["\xE6\xA1\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x46"],
        ["\x50\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA7"],

        ["\xE5\xA7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB3"],
        ["\x4A\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAB"],

        ["\xE5\xAA\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x55"],
        ["\x48\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9B"],

        ["\xE7\xB4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB5"],
        ["\x4F\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x90"],

        ["\xE7\x99\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4B"],
        ["\x45\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBE"],

        ["\xE8\xAC\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA1"],
        ["\x55\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAC"],

        ["\xE4\xBF\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB1"],
        ["\x4D\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB5"],

        ["\xE5\xBD\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x59"],
        ["\x51\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAA"],

        ["\xE6\xA8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x66"],
        ["\x49\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x99"],

        ["\xE6\xB0\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA4"],
        ["\x4C\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB7"],

        ["\xE6\xBC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBC"],
        ["\x4F\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x82"],

        ["\xE7\x93\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x52"],
        ["\x54\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA2"],

        ["\xE7\xA5\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBF"],
        ["\x4D\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA8"],

        ["\xE8\xA1\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC0"],
        ["\x46\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA8"],

        ["\xE8\xA9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xFD"],
        ["\x49\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x95"],

        ["\xE8\xB1\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x93"],
        ["\x55\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB9"],

        ["\xE5\xBB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xAF"],
        ["\x55\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9F"],

        ["\xE6\x8F\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCF"],
        ["\x4B\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x8F"],

        ["\xE7\x97\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xBF"],
        ["\x49\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x85"],

        ["\xE7\xA7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBA"],
        ["\x4D\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x92"],

        ["\xE8\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xB8"],
        ["\x4A\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x97"],

        ["\xE9\x8C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF0"],
        ["\x53\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA8"],

        ["\xE9\x8B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBE"],
        ["\x55\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB2"],

        ["\xE8\x92\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x59"],
        ["\x52\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9C"],

        ["\xE8\x9B\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x66"],
        ["\x4E\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAD"],

        ["\xE9\xB0\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x6E"],
        ["\x54\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAD"],

        ["\xE5\x93\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD0"],
        ["\x45\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x81"],

        ["\xE5\xBD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x88"],
        ["\x4E\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAC"],

        ["\xE6\x96\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9D"],
        ["\x51\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8C"],

        ["\xE6\xB5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xEA"],
        ["\x45\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9C"],

        ["\xE7\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD1"],
        ["\x55\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x95"],

        ["\xE8\xB2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xA3"],
        ["\x4D\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA7"],

        ["\xE8\xB3\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD7"],
        ["\x50\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x93"],

        ["\xE9\xA0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAB"],
        ["\x53\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBB"],

        ["\xE6\x95\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x47"],
        ["\x46\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8F"],

        ["\xE7\x93\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD4"],
        ["\x4C\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB6"],

        ["\xE4\xB8\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAF"],
        ["\x46\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8D"],

        ["\xE4\xBB\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5D"],
        ["\x47\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x98"],

        ["\xE5\x9F\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7E"],
        ["\x51\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA0"],

        ["\xE5\xA4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x73"],
        ["\x45\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAB"],

        ["\xE5\xA9\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6F"],
        ["\x49\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA6"],

        ["\xE5\xAF\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAC"],
        ["\x45\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x8C"],

        ["\xE5\x86\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x78"],
        ["\x48\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA8"],

        ["\xE5\xB8\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6B"],
        ["\x47\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x83"],

        ["\xE5\xBA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x51"],
        ["\x45\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9C"],

        ["\xE6\x80\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF0"],
        ["\x4E\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x96"],

        ["\xE6\x89\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7A"],
        ["\x4D\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB6"],

        ["\xE6\x95\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x51"],
        ["\x49\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB7"],

        ["\xE6\x96\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC2"],
        ["\x51\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA7"],

        ["\xE6\x99\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF8"],
        ["\x49\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAE"],

        ["\xE6\xB5\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8C"],
        ["\x4A\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAE"],

        ["\xE7\x88\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCC"],
        ["\x45\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB6"],

        ["\xE7\xAC\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD9"],
        ["\x4F\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA6"],

        ["\xE8\x85\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x62"],
        ["\x4D\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x90"],

        ["\xE8\x86\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x91"],
        ["\x51\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9A"],

        ["\xE8\x8A\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBD"],
        ["\x4E\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x99"],

        ["\xE8\xAD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4F"],
        ["\x4E\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9C"],

        ["\xE8\xB2\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC8"],
        ["\x49\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA0"],

        ["\xE8\xB3\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xA7"],
        ["\x4F\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA6"],

        ["\xE8\xB5\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xEE"],
        ["\x50\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB4"],

        ["\xE9\x98\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x86"],
        ["\x47\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\x9C"],

        ["\xE9\x99\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8C"],
        ["\x4B\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x84"],

        ["\xE4\xBE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB9"],
        ["\x53\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAE"],

        ["\xE6\x92\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE1"],
        ["\x51\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAB"],

        ["\xE6\xAD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB1"],
        ["\x45\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA6"],

        ["\xE8\x88\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],
        ["\x4A\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9E"],

        ["\xE8\x91\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x47"],
        ["\x55\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA1"],

        ["\xE8\x95\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD3"],
        ["\x51\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAA"],

        ["\xE9\x83\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x95"],
        ["\x45\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA8"],

        ["\xE5\xB0\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x76"],
        ["\x4D\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x81"],

        ["\xE6\xA5\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x95"],
        ["\x52\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x93"],

        ["\xE9\xA2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE7"],
        ["\x47\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xA8"],

        ["\xE8\x91\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE0"],
        ["\x50\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xBA"],

        ["\xE8\x95\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x91"],
        ["\x54\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x97"],

        ["\xE4\xBC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x83"],
        ["\x4A\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8F"],

        ["\xE5\x89\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4E"],
        ["\x4B\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAF"],

        ["\xE5\xBE\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],
        ["\x4A\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA9"],

        ["\xE5\xB9\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],
        ["\x4A\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x85"],

        ["\xE6\x9C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD4"],
        ["\x47\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8D"],

        ["\xE7\xA6\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8B"],
        ["\x45\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8F"],

        ["\xE8\x85\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA0"],
        ["\x4C\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB9"],

        ["\xE8\xA4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x51"],
        ["\x4B\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x87"],

        ["\xE8\xA6\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF2"],
        ["\x4D\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x86"],

        ["\xE6\xB7\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xEA"],
        ["\x48\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB5"],

        ["\xE5\xBC\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAC"],
        ["\x54\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x97"],

        ["\xE6\x89\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x81"],
        ["\x49\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x95"],

        ["\xE6\xB2\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAA"],
        ["\x4E\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB8"],

        ["\xE4\xBB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE5"],
        ["\x4B\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8F"],

        ["\xE7\x89\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x52"],
        ["\x46\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA9"],

        ["\xE9\xAE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8D"],
        ["\x52\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x92"],

        ["\xE5\x88\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB4"],
        ["\x45\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x86"],

        ["\xE5\x90\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE5"],
        ["\x53\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBB"],

        ["\xE5\x99\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6D"],
        ["\x4E\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB4"],

        ["\xE5\xA2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x89"],
        ["\x52\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB3"],

        ["\xE6\x86\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xFC"],
        ["\x4F\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA4"],

        ["\xE6\x89\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB7"],
        ["\x54\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAE"],

        ["\xE7\x84\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4F"],
        ["\x54\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9A"],

        ["\xE5\xA5\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDD"],
        ["\x4E\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAE"],

        ["\xE7\xB2\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9E"],
        ["\x48\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x89"],

        ["\xE7\xB3\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x92"],
        ["\x54\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9E"],

        ["\xE7\xB4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF3"],
        ["\x4F\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9B"],

        ["\xE9\x9B\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x90"],
        ["\x4F\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB0"],

        ["\xE6\x96\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCA"],
        ["\x45\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x87"],

        ["\xE8\x81\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBB"],
        ["\x48\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9E"],

        ["\xE4\xB8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC5"],
        ["\x50\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x99"],

        ["\xE4\xBD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x94"],
        ["\x4B\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB5"],

        ["\xE5\x85\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x49"],
        ["\x46\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB5"],

        ["\xE5\xA1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9F"],
        ["\x53\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x80"],

        ["\xE5\xB9\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x7F"],
        ["\x4E\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA3"],

        ["\xE5\xB9\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x8D"],
        ["\x45\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB3"],

        ["\xE5\xBC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCD"],
        ["\x50\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8A"],

        ["\xE6\x9F\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7F"],
        ["\x4A\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x84"],

        ["\xE4\xB8\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7C"],
        ["\x48\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA6"],

        ["\xE8\x94\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD1"],
        ["\x54\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xBD"],

        ["\xE9\x96\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7D"],
        ["\x4B\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x89"],

        ["\xE9\x99\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x57"],
        ["\x51\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9B"],

        ["\xE7\xB1\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x6F"],
        ["\x46\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB3"],

        ["\xE9\xA0\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD9"],
        ["\x4C\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x81"],

        ["\xE5\x83\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x78"],
        ["\x55\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xBB"],

        ["\xE5\xA3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x95"],
        ["\x4B\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x81"],

        ["\xE7\x99\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7E"],
        ["\x53\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x96"],

        ["\xE7\xA2\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF8"],
        ["\x4D\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA7"],

        ["\xE5\x88\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xDD"],
        ["\x46\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA5"],

        ["\xE7\x9E\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x72"],
        ["\x55\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA5"],

        ["\xE8\x94\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6C"],
        ["\x55\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x91"],

        ["\xE7\xAE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9B"],
        ["\x55\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x86"],

        ["\xE5\x81\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x49"],
        ["\x50\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x8F"],

        ["\xE5\xA4\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6F"],
        ["\x47\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x89"],

        ["\xE7\x89\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x67"],
        ["\x47\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x87"],

        ["\xE7\xAF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xB6"],
        ["\x4F\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x87"],

        ["\xE7\xB7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x4E"],
        ["\x48\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA8"],

        ["\xE8\xBE\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xD5"],
        ["\x45\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBA"],

        ["\xE8\xBF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD6"],
        ["\x48\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x94"],

        ["\xE9\x81\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],
        ["\x50\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8D"],

        ["\xE4\xBE\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4C"],
        ["\x4B\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBF"],

        ["\xE5\x8B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCE"],
        ["\x48\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x89"],

        ["\xE5\xA8\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x9F"],
        ["\x54\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA9"],

        ["\xE5\xBC\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x47"],
        ["\x4B\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x81"],

        ["\xE9\x9E\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8B"],
        ["\x54\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAD"],

        ["\xE4\xBF\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAA"],
        ["\x45\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9D"],

        ["\xE8\x88\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x5B"],
        ["\x4E\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x97"],

        ["\xE9\x8B\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x63"],
        ["\x53\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAA"],

        ["\xE5\x9C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCF"],
        ["\x53\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x83"],

        ["\xE6\x8D\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x41"],
        ["\x4C\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x95"],

        ["\xE6\xAD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xD8"],
        ["\x47\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA9"],

        ["\xE7\x94\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x58"],
        ["\x4D\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAB"],

        ["\xE8\xA3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6A"],
        ["\x49\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9C"],

        ["\xE8\xBC\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],
        ["\x4A\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x94"],

        ["\xE7\xA9\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD4"],
        ["\x48\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x82"],

        ["\xE5\x8B\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE1"],
        ["\x4A\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9F"],

        ["\xE5\xA2\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xBE"],
        ["\x4E\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x93"],

        ["\xE6\x85\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE3"],
        ["\x52\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x95"],

        ["\xE6\x88\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x61"],
        ["\x51\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8A"],

        ["\xE6\x9A\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xFE"],
        ["\x4A\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAE"],

        ["\xE6\xAF\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x69"],
        ["\x49\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8D"],

        ["\xE7\xB0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],
        ["\x4F\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBF"],

        ["\xE8\x8F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6A"],
        ["\x51\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA9"],

        ["\xE5\x80\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x69"],
        ["\x55\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA3"],

        ["\xE4\xBF\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF9"],
        ["\x50\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB8"],

        ["\xE5\x8C\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xA8"],
        ["\x4A\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x85"],

        ["\xE5\x91\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x73"],
        ["\x50\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x86"],

        ["\xE5\xA0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB8"],
        ["\x49\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB1"],

        ["\xE5\xA5\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB2"],
        ["\x4D\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x89"],

        ["\xE5\xAE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x4D"],
        ["\x49\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9D"],

        ["\xE5\xB3\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xFE"],
        ["\x48\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB0"],

        ["\xE5\xB3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAC"],
        ["\x4A\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAF"],

        ["\xE5\xB4\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5F"],
        ["\x4F\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA9"],

        ["\xE5\xBA\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4F"],
        ["\x55\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x96"],

        ["\xE6\x8A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x86"],
        ["\x4C\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB1"],

        ["\xE6\x8D\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x85"],
        ["\x52\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA7"],

        ["\xE6\x94\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xAF"],
        ["\x48\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBE"],

        ["\xE6\x96\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xCD"],
        ["\x45\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB9"],

        ["\xE6\x9C\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC4"],
        ["\x4B\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8B"],

        ["\xE6\xB3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4A"],
        ["\x46\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x95"],

        ["\xE6\xB3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x87"],
        ["\x4E\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA1"],

        ["\xE7\x83\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x87"],
        ["\x55\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB9"],

        ["\xE7\xA0\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xC2"],
        ["\x4C\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB2"],

        ["\xE7\xB8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE4"],
        ["\x49\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAB"],

        ["\xE8\x83\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB6"],
        ["\x50\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9E"],

        ["\xE8\x8A\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x83"],
        ["\x46\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB3"],

        ["\xE8\x90\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDB"],
        ["\x50\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8C"],

        ["\xE8\x93\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x88"],
        ["\x50\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAC"],

        ["\xE8\x9C\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xCD"],
        ["\x4E\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x82"],

        ["\xE8\xA4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBA"],
        ["\x51\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x92"],

        ["\xE8\xA8\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],
        ["\x4A\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAA"],

        ["\xE8\xB1\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x48"],
        ["\x46\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8A"],

        ["\xE9\x82\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC5"],
        ["\x46\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA6"],

        ["\xE9\x8B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x49"],
        ["\x54\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x92"],

        ["\xE9\xA3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x49"],
        ["\x4D\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBD"],

        ["\xE9\xB3\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA6"],
        ["\x4E\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB3"],

        ["\xE9\xB5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8A"],
        ["\x51\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAC"],

        ["\xE4\xB9\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6C"],
        ["\x4F\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8F"],

        ["\xE4\xBA\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCE"],
        ["\x4C\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA1"],

        ["\xE5\x82\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE7"],
        ["\x4E\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x8D"],

        ["\xE5\x89\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x99"],
        ["\x51\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x96"],

        ["\xE5\x9D\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x55"],
        ["\x4C\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8A"],

        ["\xE5\xA6\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xEC"],
        ["\x50\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA8"],

        ["\xE5\xB8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x85"],
        ["\x4C\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xBD"],

        ["\xE5\xBF\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x45"],
        ["\x4C\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x98"],

        ["\xE5\xBF\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA3"],
        ["\x4E\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x99"],

        ["\xE6\x88\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDC"],
        ["\x47\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBF"],

        ["\xE6\x9A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB2"],
        ["\x4C\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB4"],

        ["\xE6\x9C\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBB"],
        ["\x47\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9B"],

        ["\xE6\x9F\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4A"],
        ["\x50\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x90"],

        ["\xE6\xA3\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x5A"],
        ["\x4B\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x92"],

        ["\xE5\x86\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8F"],
        ["\x4F\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x92"],

        ["\xE7\xB4\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x77"],
        ["\x48\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA1"],

        ["\xE8\x82\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xFB"],
        ["\x4C\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAA"],

        ["\xE8\x86\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xF6"],
        ["\x4E\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA8"],

        ["\xE8\xAC\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],
        ["\x4F\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x80"],

        ["\xE8\xB2\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x64"],
        ["\x50\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8C"],

        ["\xE8\xB2\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x72"],
        ["\x48\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBF"],

        ["\xE9\x89\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x83"],
        ["\x51\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xBE"],

        ["\xE9\x98\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBC"],
        ["\x47\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB2"],

        ["\xE5\x90\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE1"],
        ["\x53\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA0"],

        ["\xE9\xA0\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xB3"],
        ["\x4E\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAC"],

        ["\xE5\x8C\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x5A"],
        ["\x45\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x97"],

        ["\xE5\x83\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xBB"],
        ["\x4A\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x95"],

        ["\xE5\x8D\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC0"],
        ["\x51\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9C"],

        ["\xE5\xA2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xFC"],
        ["\x4A\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xA8"],

        ["\xE6\x92\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC7"],
        ["\x4E\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB2"],

        ["\xE6\x9C\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA2"],
        ["\x4E\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB4"],

        ["\xE7\x89\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x7B"],
        ["\x48\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA7"],

        ["\xE7\x9D\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x96"],
        ["\x4A\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA6"],

        ["\xE7\xA9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBE"],
        ["\x52\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x86"],

        ["\xE9\x87\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4A"],
        ["\x53\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA6"],

        ["\xE5\x8B\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB1"],
        ["\x54\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x83"],

        ["\xE6\xB2\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x75"],
        ["\x50\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA1"],

        ["\xE6\xAE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x42"],
        ["\x4F\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x86"],

        ["\xE5\xA0\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9D"],
        ["\x46\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x80"],

        ["\xE5\xB9\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x6B"],
        ["\x49\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8C"],

        ["\xE5\xA5\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x84"],
        ["\x52\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x94"],

        ["\xE6\x9C\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x66"],
        ["\x45\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAC"],

        ["\xE7\xBF\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF6"],
        ["\x51\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBB"],

        ["\xE5\x87\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE1"],
        ["\x4D\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA1"],

        ["\xE7\x9B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x57"],
        ["\x50\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x86"],

        ["\xE6\x91\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xD1"],
        ["\x48\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA9"],

        ["\xE7\xA3\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB4"],
        ["\x49\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA8"],

        ["\xE9\xAD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xE2"],
        ["\x4D\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x94"],

        ["\xE9\xBA\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA7"],
        ["\x48\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBB"],

        ["\xE5\x9F\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xAC"],
        ["\x4E\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8B"],

        ["\xE5\xA6\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xDC"],
        ["\x4B\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB9"],

        ["\xE6\x98\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9D"],
        ["\x55\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA7"],

        ["\xE6\x9E\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xD9"],
        ["\x49\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9A"],

        ["\xE6\xAF\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xF5"],
        ["\x49\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8E"],

        ["\xE5\x93\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF0"],
        ["\x55\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA9"],

        ["\xE6\xA7\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x81"],
        ["\x68\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x99"],

        ["\xE5\xB9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCA"],
        ["\x4C\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x95"],

        ["\xE8\x86\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8A"],
        ["\x4D\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9C"],

        ["\xE6\x9E\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x78"],
        ["\x4F\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x95"],

        ["\xE9\xAE\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCE"],
        ["\x55\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAA"],

        ["\xE6\x9F\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x54"],
        ["\x50\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBE"],

        ["\xE9\xB1\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC6"],
        ["\x53\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x92"],

        ["\xE6\xA1\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x88"],
        ["\x4D\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9D"],

        ["\xE4\xBA\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xFA"],
        ["\x4F\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA6"],

        ["\xE4\xBF\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x4A"],
        ["\x4B\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA3"],

        ["\xE5\x8F\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF5"],
        ["\x48\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x88"],

        ["\xE6\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE0"],
        ["\x51\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB9"],

        ["\xE6\x9C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x46"],
        ["\x47\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAB"],

        ["\xE6\xB2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xEC"],
        ["\x53\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAB"],

        ["\xE8\xBF\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xCD"],
        ["\x49\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x84"],

        ["\xE4\xBE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x75"],
        ["\x56\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAD"],

        ["\xE7\xB9\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9A"],
        ["\x4D\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAD"],

        ["\xE9\xBA\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xEA"],
        ["\x4E\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBF"],

        ["\xE4\xB8\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x4D"],
        ["\x45\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x87"],

        ["\xE6\x85\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDB"],
        ["\x4D\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA2"],

        ["\xE6\xBA\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5B"],
        ["\x47\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x80"],

        ["\xE6\xBC\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x6E"],
        ["\x4F\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAB"],

        ["\xE8\x94\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7B"],
        ["\x55\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x93"],

        ["\xE5\x91\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x7F"],
        ["\x47\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB3"],

        ["\xE6\x9C\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC6"],
        ["\x49\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAA"],

        ["\xE9\xAD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB4"],
        ["\x4D\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x85"],

        ["\xE5\xB7\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xE6"],
        ["\x4A\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB3"],

        ["\xE7\xAE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xCC"],
        ["\x4C\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x95"],

        ["\xE5\xB2\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD5"],
        ["\x50\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAC"],

        ["\xE5\xAF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x56"],
        ["\x4A\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x86"],

        ["\xE8\x9C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA1"],
        ["\x53\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9C"],

        ["\xE6\xB9\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x88"],
        ["\x4C\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8A"],

        ["\xE8\x93\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x9A"],
        ["\x4F\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x91"],

        ["\xE7\xA8\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xFA"],
        ["\x47\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x94"],

        ["\xE8\x84\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x79"],
        ["\x50\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x88"],

        ["\xE5\xA6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],
        ["\x4A\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x99"],

        ["\xE7\xB2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC9"],
        ["\x53\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8D"],

        ["\xE6\xB0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x56"],
        ["\x47\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x91"],

        ["\xE7\x9C\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x6A"],
        ["\x4E\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA0"],

        ["\xE5\x8B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xED"],
        ["\x46\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x99"],

        ["\xE5\xA4\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x8B"],
        ["\x4B\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA2"],

        ["\xE7\x84\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x5F"],
        ["\x47\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA1"],

        ["\xE7\x89\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xAF"],
        ["\x4A\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9F"],

        ["\xE7\x9F\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xED"],
        ["\x50\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9B"],

        ["\xE9\x9C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x48"],
        ["\x4E\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA7"],

        ["\xE9\xB5\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7E"],
        ["\x55\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA1"],

        ["\xE6\xA4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xFD"],
        ["\x4D\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8B"],

        ["\xE5\xA9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x54"],
        ["\x54\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBF"],

        ["\xE5\xA8\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x54"],
        ["\x4B\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x98"],

        ["\xE5\x86\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x67"],
        ["\x54\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA5"],

        ["\xE5\x90\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF3"],
        ["\x45\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8D"],

        ["\xE5\x91\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xB0"],
        ["\x49\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBD"],

        ["\xE6\x98\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA6"],
        ["\x45\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8E"],

        ["\xE7\x9B\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x84"],
        ["\x4B\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9F"],

        ["\xE8\xBF\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x58"],
        ["\x4E\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB7"],

        ["\xE9\x8A\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDC"],
        ["\x4D\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x98"],

        ["\xE9\xB3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x70"],
        ["\x4B\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB4"],

        ["\xE5\xA7\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8C"],
        ["\x55\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAA"],

        ["\xE7\x89\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xB7"],
        ["\x55\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9D"],

        ["\xE6\xBB\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE6"],
        ["\x4E\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x85"],

        ["\xE5\x85\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x56"],
        ["\x4B\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8D"],

        ["\xE6\xA3\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCA"],
        ["\x55\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x89"],

        ["\xE7\xB6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x9D"],
        ["\x48\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBF"],

        ["\xE7\xB7\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x6B"],
        ["\x55\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAC"],

        ["\xE9\x9D\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x91"],
        ["\x46\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA2"],

        ["\xE9\xBA\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5F"],
        ["\x55\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBA"],

        ["\xE6\x91\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF5"],
        ["\x55\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB8"],

        ["\xE6\xA8\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x64"],
        ["\x48\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA1"],

        ["\xE8\x8C\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x46"],
        ["\x46\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x82"],

        ["\xE5\xA6\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4D"],
        ["\x55\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x84"],

        ["\xE5\xAD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x83"],
        ["\x4F\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9F"],

        ["\xE6\xAF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE2"],
        ["\x46\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9B"],

        ["\xE7\x8C\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x51"],
        ["\x4A\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9B"],

        ["\xE7\x9B\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x80"],
        ["\x50\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB2"],

        ["\xE7\xB6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x53"],
        ["\x4A\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB2"],

        ["\xE8\x80\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xEC"],
        ["\x4F\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x97"],

        ["\xE8\x92\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x95"],
        ["\x50\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x99"],

        ["\xE5\x84\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBD"],
        ["\x54\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB2"],

        ["\xE6\x9C\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6C"],
        ["\x45\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA8"],

        ["\xE9\xBB\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xBC"],
        ["\x4D\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x99"],

        ["\xE7\x9B\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x75"],
        ["\x46\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAE"],

        ["\xE6\x9D\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA6"],
        ["\x51\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA2"],

        ["\xE5\x8B\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x97"],
        ["\x52\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBF"],

        ["\xE9\xA4\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBF"],
        ["\x50\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x85"],

        ["\xE5\xB0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAE"],
        ["\x53\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA4"],

        ["\xE6\x88\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x44"],
        ["\x4C\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBB"],

        ["\xE7\xB1\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF0"],
        ["\x4F\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xBE"],

        ["\xE8\xB2\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xEF"],
        ["\x4D\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB0"],

        ["\xE5\x95\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE4"],
        ["\x46\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8F"],

        ["\xE6\x82\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x54"],
        ["\x55\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB6"],

        ["\xE7\xB4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF9"],
        ["\x4C\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8B"],

        ["\xE9\x96\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xAA"],
        ["\x46\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x80"],

        ["\xE5\x8C\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x5B"],
        ["\x4F\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x81"],

        ["\xE4\xB9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x49"],
        ["\x47\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9F"],

        ["\xE5\x86\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x46"],
        ["\x51\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB6"],

        ["\xE5\xA4\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC8"],
        ["\x48\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9C"],

        ["\xE7\x88\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x96"],
        ["\x50\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBA"],

        ["\xE8\x80\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x99"],
        ["\x4E\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB6"],

        ["\xE9\x87\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x69"],
        ["\x45\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8E"],

        ["\xE5\xBC\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE6"],
        ["\x47\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA5"],

        ["\xE7\x9F\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xC1"],
        ["\x46\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA2"],

        ["\xE5\x8E\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x52"],
        ["\x53\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x84"],

        ["\xE5\xBD\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x5D"],
        ["\x49\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB9"],

        ["\xE7\xB4\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBD"],
        ["\x47\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x84"],

        ["\xE8\x96\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xE1"],
        ["\x46\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAC"],

        ["\xE8\xA8\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xAD"],
        ["\x4B\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB3"],

        ["\xE8\xBA\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA1"],
        ["\x4C\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8D"],

        ["\xE9\x9D\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC3"],
        ["\x48\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x96"],

        ["\xE6\x9F\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xEA"],
        ["\x46\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB3"],

        ["\xE8\x96\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB3"],
        ["\x62\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAE"],

        ["\xE9\x91\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x41"],
        ["\x52\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x93"],

        ["\xE6\x84\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x98"],
        ["\x50\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x89"],

        ["\xE6\x84\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC8"],
        ["\x53\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x88"],

        ["\xE6\xB2\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5C"],
        ["\x46\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB9"],

        ["\xE7\x99\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xAA"],
        ["\x53\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x92"],

        ["\xE8\xAB\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9C"],
        ["\x4E\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAD"],

        ["\xE8\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x93"],
        ["\x46\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB8"],

        ["\xE5\x94\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE0"],
        ["\x4B\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAF"],

        ["\xE4\xBD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE6"],
        ["\x4C\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x91"],

        ["\xE5\x84\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xDA"],
        ["\x47\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xAA"],

        ["\xE5\x8B\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x9C"],
        ["\x46\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x87"],

        ["\xE5\x8F\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xD4"],
        ["\x46\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8B"],

        ["\xE5\xAE\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7A"],
        ["\x4F\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA5"],

        ["\xE5\xB9\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5F"],
        ["\x52\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBD"],

        ["\xE6\x82\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD8"],
        ["\x4D\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA0"],

        ["\xE6\x86\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x7C"],
        ["\x50\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x82"],

        ["\xE6\x8F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF2"],
        ["\x4C\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x96"],

        ["\xE6\x9C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x85"],
        ["\x46\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x89"],

        ["\xE6\x9F\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xE1"],
        ["\x4E\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9A"],

        ["\xE6\xB9\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBD"],
        ["\x4F\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xA7"],

        ["\xE6\xB6\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7D"],
        ["\x4F\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8C"],

        ["\xE7\x8C\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],
        ["\x50\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB6"],

        ["\xE7\x8C\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDD"],
        ["\x53\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB7"],

        ["\xE7\x94\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x7C"],
        ["\x46\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB1"],

        ["\xE7\xA5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x8C"],
        ["\x48\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x90"],

        ["\xE8\xA3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xF8"],
        ["\x46\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x95"],

        ["\xE8\xAA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCB"],
        ["\x4A\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x98"],

        ["\xE9\x81\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x8B"],
        ["\x4A\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8A"],

        ["\xE9\x82\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x92"],
        ["\x4C\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x91"],

        ["\xE9\x83\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xB7"],
        ["\x4C\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB5"],

        ["\xE9\x9B\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x70"],
        ["\x45\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x84"],

        ["\xE8\x9E\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xC2"],
        ["\x48\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x8D"],

        ["\xE5\xA4\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xC3"],
        ["\x4A\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x95"],

        ["\xE4\xBA\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC2"],
        ["\x47\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x88"],

        ["\xE4\xBD\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC1"],
        ["\x49\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x99"],

        ["\xE4\xB8\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x89"],
        ["\x47\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8E"],

        ["\xE8\xAA\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x8C"],
        ["\x4D\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x89"],

        ["\xE8\xBC\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],
        ["\x50\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBF"],

        ["\xE9\xA0\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x4A"],
        ["\x4D\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x90"],

        ["\xE5\x82\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDA"],
        ["\x54\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAD"],

        ["\xE5\xB9\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xAF"],
        ["\x4D\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBC"],

        ["\xE5\xA6\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xD1"],
        ["\x53\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x96"],

        ["\xE5\xAE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x89"],
        ["\x48\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB9"],

        ["\xE5\xBA\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],
        ["\x4C\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB8"],

        ["\xE6\x8F\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x46"],
        ["\x4C\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9A"],

        ["\xE6\x8F\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x7E"],
        ["\x4F\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xBA"],

        ["\xE6\x93\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4E"],
        ["\x51\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x81"],

        ["\xE6\x9B\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xFE"],
        ["\x4B\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9C"],

        ["\xE6\xA5\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD7"],
        ["\x51\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x8A"],

        ["\xE6\xA7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x48"],
        ["\x48\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x98"],

        ["\xE6\xB4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDA"],
        ["\x45\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8B"],

        ["\xE6\xBA\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xBE"],
        ["\x48\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB6"],

        ["\xE7\x86\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9D"],
        ["\x52\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x94"],

        ["\xE7\x94\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xB6"],
        ["\x45\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA8"],

        ["\xE7\xAA\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA7"],
        ["\x49\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAF"],

        ["\xE7\xBE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xD1"],
        ["\x4A\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8A"],

        ["\xE8\x80\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA0"],
        ["\x52\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x80"],

        ["\xE8\x91\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF9"],
        ["\x45\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x89"],

        ["\xE8\x93\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x83"],
        ["\x50\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x89"],

        ["\xE8\xA6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x55"],
        ["\x46\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x81"],

        ["\xE8\xAC\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x7D"],
        ["\x4D\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA1"],

        ["\xE8\xB8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA8"],
        ["\x4C\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8A"],

        ["\xE9\x81\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x82"],
        ["\x68\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA5"],

        ["\xE9\x99\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xBF"],
        ["\x47\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBD"],

        ["\xE9\xA4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x79"],
        ["\x49\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8A"],

        ["\xE6\x85\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF4"],
        ["\x53\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xBE"],

        ["\xE6\x8A\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x66"],
        ["\x4D\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x91"],

        ["\xE6\xAC\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF6"],
        ["\x4B\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB2"],

        ["\xE6\xB2\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xD9"],
        ["\x55\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x83"],

        ["\xE6\xB5\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x7E"],
        ["\x4B\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB4"],

        ["\xE7\xBF\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x9C"],
        ["\x4D\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8C"],

        ["\xE7\xBF\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xB5"],
        ["\x4D\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBC"],

        ["\xE6\xB7\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x88"],
        ["\x4A\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x80"],

        ["\xE7\xBE\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xFA"],
        ["\x4D\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x85"],

        ["\xE8\x9E\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD6"],
        ["\x51\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBA"],

        ["\xE8\xA3\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x43"],
        ["\x4F\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB8"],

        ["\xE6\x9D\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x76"],
        ["\x46\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA5"],

        ["\xE8\x8E\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC9"],
        ["\x52\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB1"],

        ["\xE9\xA0\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],
        ["\x4A\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBC"],

        ["\xE9\x9B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xD6"],
        ["\x4B\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB7"],

        ["\xE6\xB4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x50"],
        ["\x54\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9B"],

        ["\xE7\xB5\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE7"],
        ["\x4C\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA1"],

        ["\xE8\x90\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xF2"],
        ["\x47\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBD"],

        ["\xE9\x85\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBD"],
        ["\x50\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAA"],

        ["\xE4\xB9\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xBF"],
        ["\x4B\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB1"],

        ["\xE5\x8D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF5"],
        ["\x4C\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB5"],

        ["\xE5\xB5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x8C"],
        ["\x49\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x90"],

        ["\xE6\xAC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDE"],
        ["\x4E\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x84"],

        ["\xE6\xBF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA3"],
        ["\x55\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAB"],

        ["\xE8\x97\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xED"],
        ["\x4E\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8D"],

        ["\xE8\x98\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA6"],
        ["\x4C\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAD"],

        ["\xE8\xA6\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD0"],
        ["\x4E\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA7"],

        ["\xE5\x88\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xBC"],
        ["\x45\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA9"],

        ["\xE5\x90\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC6"],
        ["\x50\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8F"],

        ["\xE5\xB1\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA2"],
        ["\x4C\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA5"],

        ["\xE6\x9D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x51"],
        ["\x4E\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8E"],

        ["\xE6\xA2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x58"],
        ["\x48\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA8"],

        ["\xE7\x90\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xEB"],
        ["\x45\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x86"],

        ["\xE7\x92\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8C"],
        ["\x52\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x83"],

        ["\xE7\x97\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x74"],
        ["\x51\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA2"],

        ["\xE8\xA3\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xA4"],
        ["\x49\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8F"],

        ["\xE8\xA3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4D"],
        ["\x54\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA1"],

        ["\xE9\x87\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x6C"],
        ["\x47\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8C"],

        ["\xE9\x9B\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x97"],
        ["\x49\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA2"],

        ["\xE9\x99\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x61"],
        ["\x49\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB8"],

        ["\xE5\xBE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x91"],
        ["\x49\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8B"],

        ["\xE7\x8E\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x83"],
        ["\x47\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x87"],

        ["\xE7\xAB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xDD"],
        ["\x45\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8B"],

        ["\xE8\x91\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x9F"],
        ["\x55\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8E"],

        ["\xE6\x8E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xE6"],
        ["\x55\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA0"],

        ["\xE7\x95\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF0"],
        ["\x4C\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA5"],

        ["\xE5\x8A\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x85"],
        ["\x51\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x89"],

        ["\xE6\xB5\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xFC"],
        ["\x46\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x81"],

        ["\xE6\xBA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xC4"],
        ["\x4D\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9C"],

        ["\xE7\x90\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF7"],
        ["\x50\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x89"],

        ["\xE7\x95\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xAB"],
        ["\x47\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x99"],

        ["\xE7\xA1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x84"],
        ["\x49\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAB"],

        ["\xE7\xB2\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xA9"],
        ["\x4C\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x92"],

        ["\xE9\x9A\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x5D"],
        ["\x46\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x86"],

        ["\xE7\xAB\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xE7"],
        ["\x49\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9C"],

        ["\xE9\xBE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xCA"],
        ["\x48\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x8D"],

        ["\xE4\xBE\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7C"],
        ["\x55\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB6"],

        ["\xE6\x85\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x49"],
        ["\x4C\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAE"],

        ["\xE6\x97\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCF"],
        ["\x4A\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x85"],

        ["\xE8\x99\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x50"],
        ["\x52\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9C"],

        ["\xE4\xBA\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB1"],
        ["\x4B\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x86"],

        ["\xE4\xBA\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x9C"],
        ["\x49\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAE"],

        ["\xE5\x83\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x82"],
        ["\x4D\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9A"],

        ["\xE4\xB8\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x83"],
        ["\x48\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA1"],

        ["\xE5\x87\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x44"],
        ["\x53\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8C"],

        ["\xE5\xAF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],
        ["\x4C\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAE"],

        ["\xE6\x96\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\x4E"],
        ["\x46\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x99"],

        ["\xE6\xA2\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x44"],
        ["\x4E\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x81"],

        ["\xE6\xB6\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x74"],
        ["\x4E\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xBC"],

        ["\xE7\x8C\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9D"],
        ["\x4E\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9F"],

        ["\xE7\x99\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB7"],
        ["\x4B\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x82"],

        ["\xE7\x9E\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7D"],
        ["\x52\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAD"],

        ["\xE7\xA8\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x96"],
        ["\x52\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9C"],

        ["\xE7\xB3\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xC5"],
        ["\x4E\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA7"],

        ["\xE8\x89\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xC4"],
        ["\x45\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAF"],

        ["\xE8\xAB\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x81"],
        ["\x51\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x92"],

        ["\xE9\x81\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6B"],
        ["\x52\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBC"],

        ["\xE9\x87\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xB5"],
        ["\x47\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8F"],

        ["\xE9\x99\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC7"],
        ["\x50\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB5"],

        ["\xE9\xA0\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xCD"],
        ["\x4A\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x98"],

        ["\xE5\x8A\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xF7"],
        ["\x45\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9B"],

        ["\xE7\xB7\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA5"],
        ["\x48\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x91"],

        ["\xE5\x80\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x51"],
        ["\x4D\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAB"],

        ["\xE5\x8E\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x55"],
        ["\x4F\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x98"],

        ["\xE6\x9E\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xA2"],
        ["\x45\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x97"],

        ["\xE6\xB7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC7"],
        ["\x52\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8B"],

        ["\xE7\x87\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],
        ["\x4A\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x90"],

        ["\xE7\x90\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x53"],
        ["\x54\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB3"],

        ["\xE8\x87\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xD0"],
        ["\x4C\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA8"],

        ["\xE8\xBC\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xB7"],
        ["\x48\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAA"],

        ["\xE9\x9A\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE0"],
        ["\x4C\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA3"],

        ["\xE9\xB1\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4C"],
        ["\x55\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x97"],

        ["\xE9\xBA\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9B"],
        ["\x51\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9F"],

        ["\xE7\x91\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x8C"],
        ["\x50\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA0"],

        ["\xE5\xA1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xEB"],
        ["\x4B\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x81"],

        ["\xE6\xB6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xDA"],
        ["\x4D\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x99"],

        ["\xE7\xB4\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x48"],
        ["\x51\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAF"],

        ["\xE9\xA1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x46\xBA"],
        ["\x46\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9E"],

        ["\xE4\xBB\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\xC3"],
        ["\x49\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA4"],

        ["\xE4\xBC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4A"],
        ["\x54\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB6"],

        ["\xE4\xBE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x46"],
        ["\x4A\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8B"],

        ["\xE5\x86\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xFC"],
        ["\x48\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB7"],

        ["\xE5\x8A\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x92"],
        ["\x4D\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB1"],

        ["\xE5\xB6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xE8"],
        ["\x4C\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBA"],

        ["\xE6\x80\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x9F"],
        ["\x50\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9C"],

        ["\xE7\x8E\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\xF9"],
        ["\x4A\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB2"],

        ["\xE7\xA4\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x58"],
        ["\x49\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBC"],

        ["\xE8\x8B\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x59"],
        ["\x55\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x93"],

        ["\xE9\x88\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\xAE"],
        ["\x45\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB4"],

        ["\xE9\x9A\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x45"],
        ["\x55\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB7"],

        ["\xE9\x9B\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x69"],
        ["\x50\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB6"],

        ["\xE9\x9C\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],
        ["\x4F\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8A"],

        ["\xE9\xBA\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xF3"],
        ["\x4C\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x97"],

        ["\xE9\xBD\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x80"],
        ["\x4C\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA2"],

        ["\xE6\x9A\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xCC"],
        ["\x50\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA6"],

        ["\xE6\xAD\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x55"],
        ["\x49\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB4"],

        ["\xE5\x88\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xB4"],
        ["\x4B\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x97"],

        ["\xE5\x8A\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x68"],
        ["\x4E\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA3"],

        ["\xE7\x83\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xD1"],
        ["\x4D\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x88"],

        ["\xE8\xA3\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x60"],
        ["\x4F\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x82"],

        ["\xE5\xBB\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDB"],
        ["\x4E\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x89"],

        ["\xE6\x81\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xCA"],
        ["\x4B\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8B"],

        ["\xE6\x86\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5B"],
        ["\x55\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x90"],

        ["\xE6\xBC\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE0"],
        ["\x54\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA3"],

        ["\xE7\x85\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],
        ["\x4C\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x89"],

        ["\xE7\xB0\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x70"],
        ["\x52\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBE"],

        ["\xE7\xB7\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x60"],
        ["\x48\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB4"],

        ["\xE8\x81\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCA"],
        ["\x53\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xAF"],

        ["\xE8\x93\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF4"],
        ["\x4B\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAE"],

        ["\xE9\x80\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x54"],
        ["\x47\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA3"],

        ["\xE9\x8C\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xE6"],
        ["\x4F\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAC"],

        ["\xE5\x91\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x50"],
        ["\x4B\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x82"],

        ["\xE9\xAD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF4"],
        ["\x51\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAF"],

        ["\xE6\xAB\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x86"],
        ["\x55\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x93"],

        ["\xE7\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x7D"],
        ["\x49\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x89"],

        ["\xE8\xB3\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xF8"],
        ["\x55\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x82"],

        ["\xE8\xB7\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x84"],
        ["\x47\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAF"],

        ["\xE9\x9C\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xC6"],
        ["\x4B\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB2"],

        ["\xE5\x8A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xA9"],
        ["\x48\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB4"],

        ["\xE5\xA9\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xF8"],
        ["\x50\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x81"],

        ["\xE5\xBB\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xA7"],
        ["\x4E\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8A"],

        ["\xE5\xBC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBF"],
        ["\x54\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x84"],

        ["\xE6\x9C\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x6E"],
        ["\x48\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x97"],

        ["\xE6\xA5\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xBA"],
        ["\x52\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBC"],

        ["\xE6\xA6\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC7"],
        ["\x55\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x94"],

        ["\xE6\xB5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x9D"],
        ["\x4A\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAA"],

        ["\xE6\xBC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xC4"],
        ["\x50\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8F"],

        ["\xE7\x89\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC4"],
        ["\x55\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA2"],

        ["\xE7\x8B\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6F"],
        ["\x50\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBC"],

        ["\xE7\xAF\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x44"],
        ["\x54\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xAD"],

        ["\xE8\x80\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x49\x85"],
        ["\x49\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x81"],

        ["\xE8\x81\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE4"],
        ["\x53\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBE"],

        ["\xE8\x9D\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA1"],
        ["\x52\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8B"],

        ["\xE9\x83\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x6E"],
        ["\x45\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8E"],

        ["\xE5\x85\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x46"],
        ["\x45\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAD"],

        ["\xE9\xBA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x9E"],
        ["\x51\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x93"],

        ["\xE7\xA6\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xAE"],
        ["\x50\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x84"],

        ["\xE8\x82\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x7F"],
        ["\x55\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8B"],

        ["\xE9\x8C\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\x86"],
        ["\x48\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB2"],

        ["\xE8\xAB\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x48\xF3"],
        ["\x48\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x96"],

        ["\xE5\x80\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xF9"],
        ["\x4F\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAD"],

        ["\xE5\x92\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x45\x7A"],
        ["\x45\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8C"],

        ["\xE8\xA9\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\x50"],
        ["\x47\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB1"],

        ["\xE6\xAD\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x8E"],
        ["\x55\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAA"],

        ["\xE8\xB3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x67"],
        ["\x50\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x84"],

        ["\xE8\x84\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xE3"],
        ["\x47\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x87"],

        ["\xE6\x83\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x78"],
        ["\x4E\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x91"],

        ["\xE6\x9E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD2"],
        ["\x4F\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA0"],

        ["\xE9\xB7\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xF1"],
        ["\x4B\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB2"],

        ["\xE4\xBA\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE8"],
        ["\x50\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x99"],

        ["\xE4\xBA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\xE4"],
        ["\x4B\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x98"],

        ["\xE9\xB0\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x93"],
        ["\x52\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x90"],

        ["\xE8\xA9\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xD3"],
        ["\x50\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAB"],

        ["\xE8\x97\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xBB"],
        ["\x4F\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x81"],

        ["\xE8\x95\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xDE"],
        ["\x50\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA8"],

        ["\xE6\xA4\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x68"],
        ["\x54\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x80"],

        ["\xE6\xB9\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x6B"],
        ["\x4D\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBE"],

        ["\xE7\xA2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5B"],
        ["\x54\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x97"],

        ["\xE8\x85\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xAF"],
        ["\x4C\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x95"],

        ["\xE5\xBC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x41"],
        ["\x56\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8C"],

        ["\xE4\xB8\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x42"],
        ["\x56\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x90"],

        ["\xE4\xB8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x43"],
        ["\x56\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x95"],

        ["\xE4\xB8\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x45"],
        ["\x56\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAA"],

        ["\xE4\xB8\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x46"],
        ["\x56\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB1"],

        ["\xE4\xB8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x47"],
        ["\x56\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB6"],

        ["\xE4\xB8\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC8"],
        ["\x54\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBC"],

        ["\xE4\xB8\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x48"],
        ["\x56\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBF"],

        ["\xE4\xB9\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x49"],
        ["\x56\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x82"],

        ["\xE4\xB9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4A"],
        ["\x56\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x96"],

        ["\xE4\xB9\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4B"],
        ["\x56\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x98"],

        ["\xE4\xBA\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4D"],
        ["\x56\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x82"],

        ["\xE4\xBA\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4E"],
        ["\x56\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x85"],

        ["\xE8\xB1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x55"],
        ["\x53\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAB"],

        ["\xE4\xBA\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4F"],
        ["\x56\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8A"],

        ["\xE8\x88\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDB"],
        ["\x61\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x92"],

        ["\xE5\xBC\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x51"],
        ["\x56\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8D"],

        ["\xE4\xBA\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x50"],
        ["\x56\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8E"],

        ["\xE4\xBA\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x52"],
        ["\x56\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9E"],

        ["\xE4\xBA\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x67"],
        ["\x51\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9F"],

        ["\xE4\xBA\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x53"],
        ["\x56\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA0"],

        ["\xE4\xBA\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x54"],
        ["\x56\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA2"],

        ["\xE4\xBA\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x55"],
        ["\x56\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB0"],

        ["\xE4\xBA\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x56"],
        ["\x56\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB3"],

        ["\xE4\xBA\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x57"],
        ["\x56\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB6"],

        ["\xE4\xBB\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x58"],
        ["\x56\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8E"],

        ["\xE4\xBB\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x59"],
        ["\x56\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8D"],

        ["\xE4\xBB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5A"],
        ["\x56\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x84"],

        ["\xE4\xBB\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5B"],
        ["\x56\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x86"],

        ["\xE4\xBB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5C"],
        ["\x56\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x82"],

        ["\xE4\xBB\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5E"],
        ["\x56\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x97"],

        ["\xE4\xBB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x5F"],
        ["\x56\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9E"],

        ["\xE4\xBB\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x60"],
        ["\x56\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAD"],

        ["\xE4\xBB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x61"],
        ["\x56\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9F"],

        ["\xE4\xBB\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x41"],
        ["\x53\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB7"],

        ["\xE4\xBC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x63"],
        ["\x56\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x89"],

        ["\xE4\xBD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x67"],
        ["\x56\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9A"],

        ["\xE4\xBC\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x68"],
        ["\x56\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB0"],

        ["\xE4\xBD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x6F"],
        ["\x56\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9B"],

        ["\xE4\xBD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x69"],
        ["\x56\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9D"],

        ["\xE4\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x6B"],
        ["\x56\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x97"],

        ["\xE4\xBD\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x6C"],
        ["\x56\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x87"],

        ["\xE4\xBD\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE2"],
        ["\x51\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB6"],

        ["\xE4\xBE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x72"],
        ["\x56\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x88"],

        ["\xE4\xBE\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x73"],
        ["\x56\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8F"],

        ["\xE4\xBE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x76"],
        ["\x56\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x98"],

        ["\xE4\xBD\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x77"],
        ["\x56\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBB"],

        ["\xE4\xBD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x79"],
        ["\x56\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA9"],

        ["\xE4\xBD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7A"],
        ["\x56\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB0"],

        ["\xE4\xBE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x8D"],
        ["\x4F\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x91"],

        ["\xE4\xBD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7C"],
        ["\x56\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAF"],

        ["\xE4\xBE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7D"],
        ["\x56\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x86"],

        ["\xE4\xBE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7E"],
        ["\x56\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x96"],

        ["\xE5\x84\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x90"],
        ["\x52\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x98"],

        ["\xE4\xBF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x7F"],
        ["\x56\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x94"],

        ["\xE4\xBF\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC4"],
        ["\x53\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9F"],

        ["\xE4\xBF\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x80"],
        ["\x56\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8E"],

        ["\xE4\xBF\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x81"],
        ["\x56\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x98"],

        ["\xE4\xBF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x82"],
        ["\x56\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9B"],

        ["\xE4\xBF\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x83"],
        ["\x56\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x91"],

        ["\xE4\xBF\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x84"],
        ["\x56\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9A"],

        ["\xE4\xBF\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x85"],
        ["\x56\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x90"],

        ["\xE4\xBF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x87"],
        ["\x56\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA4"],

        ["\xE4\xBF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x88"],
        ["\x56\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA5"],

        ["\xE5\x80\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x89"],
        ["\x56\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9A"],

        ["\xE5\x80\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8B"],
        ["\x56\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA8"],

        ["\xE5\x80\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8C"],
        ["\x56\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x94"],

        ["\xE5\x80\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8D"],
        ["\x56\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAA"],

        ["\xE5\x80\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8E"],
        ["\x56\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA5"],

        ["\xE5\x80\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x8F"],
        ["\x56\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x85"],

        ["\xE4\xBC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x64"],
        ["\x56\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9C"],

        ["\xE4\xBF\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF8"],
        ["\x51\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB6"],

        ["\xE5\x80\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x90"],
        ["\x56\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA1"],

        ["\xE5\x80\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x92"],
        ["\x56\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA9"],

        ["\xE5\x80\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x93"],
        ["\x56\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAC"],

        ["\xE4\xBF\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x95"],
        ["\x56\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBE"],

        ["\xE4\xBF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x96"],
        ["\x56\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAF"],

        ["\xE5\x80\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x97"],
        ["\x56\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x91"],

        ["\xE5\x80\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x99"],
        ["\x56\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x86"],

        ["\xE5\x81\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9A"],
        ["\x56\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x83"],

        ["\xE5\x81\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9B"],
        ["\x56\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x87"],

        ["\xE6\x9C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAC"],
        ["\x56\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x83"],

        ["\xE5\x81\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9C"],
        ["\x56\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x95"],

        ["\xE5\x81\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9D"],
        ["\x56\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x90"],

        ["\xE5\x81\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9E"],
        ["\x56\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x88"],

        ["\xE5\x81\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x9F"],
        ["\x56\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9A"],

        ["\xE5\x81\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA0"],
        ["\x56\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x96"],

        ["\xE5\x81\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA5"],
        ["\x56\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xAC"],

        ["\xE5\x81\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA6"],
        ["\x56\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB8"],

        ["\xE5\x82\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA7"],
        ["\x56\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x80"],

        ["\xE5\x82\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA9"],
        ["\x56\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x9A"],

        ["\xE5\x82\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAA"],
        ["\x56\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x85"],

        ["\xE5\x82\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAB"],
        ["\x56\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB4"],

        ["\xE5\x82\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAD"],
        ["\x56\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB2"],

        ["\xE5\x83\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAE"],
        ["\x56\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x89"],

        ["\xE5\x83\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xAF"],
        ["\x56\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8A"],

        ["\xE5\x82\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB0"],
        ["\x56\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB3"],

        ["\xE5\x83\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB1"],
        ["\x56\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x82"],

        ["\xE5\x83\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD4"],
        ["\x52\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x96"],

        ["\xE5\x83\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB3"],
        ["\x56\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9E"],

        ["\xE5\x83\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB4"],
        ["\x56\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA5"],

        ["\xE5\x83\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB6"],
        ["\x56\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAD"],

        ["\xE5\x83\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB7"],
        ["\x56\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA3"],

        ["\xE5\x83\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB8"],
        ["\x56\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAE"],

        ["\xE5\x83\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xB9"],
        ["\x56\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB9"],

        ["\xE5\x83\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBA"],
        ["\x56\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB5"],

        ["\xE5\x84\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBB"],
        ["\x56\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x89"],

        ["\xE5\x84\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBC"],
        ["\x56\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x81"],

        ["\xE5\x84\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBD"],
        ["\x56\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x82"],

        ["\xE5\x84\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC1"],
        ["\x56\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x96"],

        ["\xE5\x84\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBF"],
        ["\x56\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x95"],

        ["\xE5\x84\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC0"],
        ["\x56\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x94"],

        ["\xE5\x84\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xBE"],
        ["\x56\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9A"],

        ["\xE5\x84\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC2"],
        ["\x56\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xA1"],

        ["\xE5\x84\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC3"],
        ["\x56\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBA"],

        ["\xE5\x84\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC4"],
        ["\x56\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB7"],

        ["\xE5\x84\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC5"],
        ["\x56\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBC"],

        ["\xE5\x84\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC6"],
        ["\x56\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBB"],

        ["\xE5\x84\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC7"],
        ["\x56\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBF"],

        ["\xE5\x85\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xC8"],
        ["\x56\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x80"],

        ["\xE5\x85\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCB"],
        ["\x56\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x92"],

        ["\xE5\x85\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCA"],
        ["\x56\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8C"],

        ["\xE5\x85\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCC"],
        ["\x56\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x94"],

        ["\xE5\x85\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCD"],
        ["\x56\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA2"],

        ["\xE7\xAB\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],
        ["\x60\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB8"],

        ["\xE5\x85\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xCF"],
        ["\x56\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA9"],

        ["\xE5\x85\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD0"],
        ["\x56\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAA"],

        ["\xE5\x85\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD1"],
        ["\x56\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAE"],

        ["\xE5\x86\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD2"],
        ["\x56\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x80"],

        ["\xE5\x86\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD3"],
        ["\x56\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x82"],

        ["\xE5\x9B\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD4"],
        ["\x56\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x98"],

        ["\xE5\x86\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD5"],
        ["\x56\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8C"],

        ["\xE5\x86\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD6"],
        ["\x56\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x89"],

        ["\xE5\x86\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD7"],
        ["\x56\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8F"],

        ["\xE5\x86\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD8"],
        ["\x56\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x91"],

        ["\xE5\x86\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xD9"],
        ["\x56\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x93"],

        ["\xE5\x86\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDA"],
        ["\x56\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x95"],

        ["\xE5\x86\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDB"],
        ["\x56\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x96"],

        ["\xE5\x86\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDD"],
        ["\x56\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA4"],

        ["\xE5\x86\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDE"],
        ["\x56\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA6"],

        ["\xE5\x86\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xDF"],
        ["\x56\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA2"],

        ["\xE5\x86\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE0"],
        ["\x56\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA9"],

        ["\xE5\x86\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE1"],
        ["\x56\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAA"],

        ["\xE5\x86\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE2"],
        ["\x56\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAB"],

        ["\xE5\x86\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE3"],
        ["\x56\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB3"],

        ["\xE5\x86\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE4"],
        ["\x56\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB1"],

        ["\xE5\x86\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE5"],
        ["\x56\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB2"],

        ["\xE5\x86\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE6"],
        ["\x56\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB0"],

        ["\xE5\x86\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE7"],
        ["\x56\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB5"],

        ["\xE5\x86\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xE9"],
        ["\x56\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBD"],

        ["\xE5\x87\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xEA"],
        ["\x56\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x85"],

        ["\xE5\x87\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xEB"],
        ["\x56\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x89"],

        ["\xE5\x87\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xEC"],
        ["\x56\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9B"],

        ["\xE5\x87\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xED"],
        ["\x56\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA0"],

        ["\xE8\x99\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"],
        ["\x62\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x95"],

        ["\xE5\x87\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xEE"],
        ["\x56\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA9"],

        ["\xE5\x87\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF0"],
        ["\x56\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAD"],

        ["\xE5\x87\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF1"],
        ["\x56\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB0"],

        ["\xE5\x87\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF2"],
        ["\x56\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB5"],

        ["\xE5\x87\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF3"],
        ["\x56\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBE"],

        ["\xE5\x88\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF4"],
        ["\x56\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x84"],

        ["\xE5\x88\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF5"],
        ["\x56\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8B"],

        ["\xE5\x88\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF6"],
        ["\x56\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x94"],

        ["\xE5\x88\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE3"],
        ["\x54\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8E"],

        ["\xE5\x88\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF8"],
        ["\x56\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA7"],

        ["\xE5\x88\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xF9"],
        ["\x56\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAA"],

        ["\xE5\x88\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xFA"],
        ["\x56\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAE"],

        ["\xE5\x88\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xFB"],
        ["\x56\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB3"],

        ["\xE5\x88\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xFC"],
        ["\x56\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB9"],

        ["\xE5\x89\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x41"],
        ["\x57\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8F"],

        ["\xE5\x89\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xFD"],
        ["\x56\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x84"],

        ["\xE5\x89\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xFE"],
        ["\x56\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8B"],

        ["\xE5\x89\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xAE"],
        ["\x51\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8C"],

        ["\xE5\x89\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x42"],
        ["\x57\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9E"],

        ["\xE5\x89\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x43"],
        ["\x57\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x94"],

        ["\xE5\x89\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x45"],
        ["\x57\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAA"],

        ["\xE5\x89\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x47"],
        ["\x57\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB4"],

        ["\xE5\x89\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x48"],
        ["\x57\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA9"],

        ["\xE5\x89\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x46"],
        ["\x57\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB3"],

        ["\xE5\x89\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x49"],
        ["\x57\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBF"],

        ["\xE5\x89\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],
        ["\x57\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBD"],

        ["\xE5\x8A\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],
        ["\x57\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x8D"],

        ["\xE5\x8A\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x80"],
        ["\x55\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x94"],

        ["\xE5\x8A\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],
        ["\x57\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x92"],

        ["\xE5\x89\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x44"],
        ["\x57\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB1"],

        ["\xE5\x8A\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],
        ["\x57\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x88"],

        ["\xE5\x8A\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],
        ["\x57\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x91"],

        ["\xE8\xBE\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEC"],
        ["\x64\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA8"],

        ["\xE8\xBE\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xED"],
        ["\x64\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA7"],

        ["\xE5\x8A\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x51"],
        ["\x57\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAC"],

        ["\xE5\x8A\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x52"],
        ["\x57\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAD"],

        ["\xE5\x8A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x53"],
        ["\x57\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBC"],

        ["\xE5\x8A\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x54"],
        ["\x57\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB5"],

        ["\xE5\x8B\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x55"],
        ["\x57\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x81"],

        ["\xE5\x8B\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],
        ["\x57\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8D"],

        ["\xE5\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x92"],
        ["\x53\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x97"],

        ["\xE5\x8B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],
        ["\x57\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9E"],

        ["\xE5\x8B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],
        ["\x57\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA3"],

        ["\xE5\x8B\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],
        ["\x57\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA6"],

        ["\xE9\xA3\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDB"],
        ["\x66\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAD"],

        ["\xE5\x8B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],
        ["\x57\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA0"],

        ["\xE5\x8B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],
        ["\x57\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB3"],

        ["\xE5\x8B\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],
        ["\x57\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB5"],

        ["\xE5\x8B\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],
        ["\x57\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB8"],

        ["\xE5\x8B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],
        ["\x57\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB9"],

        ["\xE5\x8C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],
        ["\x57\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x86"],

        ["\xE5\x8C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],
        ["\x57\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x88"],

        ["\xE7\x94\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],
        ["\x57\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB8"],

        ["\xE5\x8C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],
        ["\x57\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8D"],

        ["\xE5\x8C\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],
        ["\x57\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x90"],

        ["\xE5\x8C\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],
        ["\x57\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8F"],

        ["\xE5\x8C\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],
        ["\x57\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x95"],

        ["\xE5\x8C\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],
        ["\x57\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9A"],

        ["\xE5\x8C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],
        ["\x57\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA3"],

        ["\xE5\x8C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],
        ["\x57\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAF"],

        ["\xE5\x8C\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],
        ["\x57\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB1"],

        ["\xE5\x8C\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],
        ["\x57\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB3"],

        ["\xE5\x8C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],
        ["\x57\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB8"],

        ["\xE5\x8D\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],
        ["\x57\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x80"],

        ["\xE5\x8D\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],
        ["\x57\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x86"],

        ["\xE5\x8D\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],
        ["\x57\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x85"],

        ["\xE4\xB8\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],
        ["\x57\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x97"],

        ["\xE5\x8D\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],
        ["\x57\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x89"],

        ["\xE5\x8D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],
        ["\x57\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8D"],

        ["\xE5\x87\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],
        ["\x57\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x96"],

        ["\xE5\x8D\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],
        ["\x57\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9E"],

        ["\xE5\x8D\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],
        ["\x57\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA9"],

        ["\xE5\x8D\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],
        ["\x57\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAE"],

        ["\xE5\xA4\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC8"],
        ["\x52\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x98"],

        ["\xE5\x8D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],
        ["\x57\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBB"],

        ["\xE5\x8D\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],
        ["\x57\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB7"],

        ["\xE5\x8E\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x7F"],
        ["\x57\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x82"],

        ["\xE5\x8E\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x81"],
        ["\x57\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x96"],

        ["\xE5\x8E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x82"],
        ["\x57\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA0"],

        ["\xE5\x8E\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x83"],
        ["\x57\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA6"],

        ["\xE5\x8E\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x84"],
        ["\x57\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA5"],

        ["\xE5\x8E\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x85"],
        ["\x57\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAE"],

        ["\xE5\x8E\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x86"],
        ["\x57\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB0"],

        ["\xE5\x8E\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x88"],
        ["\x57\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB6"],

        ["\xE5\x8F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x89"],
        ["\x57\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x83"],

        ["\xE7\xB0\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x8A"],
        ["\x57\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x92"],

        ["\xE9\x9B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x88"],
        ["\x66\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x99"],

        ["\xE5\x8F\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x8C"],
        ["\x57\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9F"],

        ["\xE6\x9B\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x8D"],
        ["\x57\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBC"],

        ["\xE7\x87\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x8F"],
        ["\x57\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAE"],

        ["\xE5\x8F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x90"],
        ["\x57\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAE"],

        ["\xE5\x8F\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x91"],
        ["\x57\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA8"],

        ["\xE5\x8F\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x92"],
        ["\x57\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAD"],

        ["\xE5\x8F\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x93"],
        ["\x57\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xBA"],

        ["\xE5\x90\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x94"],
        ["\x57\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x81"],

        ["\xE5\x90\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x95"],
        ["\x57\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBD"],

        ["\xE5\x91\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x96"],
        ["\x57\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x80"],

        ["\xE5\x90\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x97"],
        ["\x57\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAC"],

        ["\xE5\x90\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x98"],
        ["\x57\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAD"],

        ["\xE5\x90\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x99"],
        ["\x57\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBC"],

        ["\xE5\x90\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9A"],
        ["\x57\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAE"],

        ["\xE5\x90\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9B"],
        ["\x57\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB6"],

        ["\xE5\x90\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9C"],
        ["\x57\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA9"],

        ["\xE5\x90\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9D"],
        ["\x57\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9D"],

        ["\xE5\x91\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9E"],
        ["\x57\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8E"],

        ["\xE5\x92\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x9F"],
        ["\x57\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8F"],

        ["\xE5\x91\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA0"],
        ["\x57\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB5"],

        ["\xE5\x92\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA1"],
        ["\x57\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8E"],

        ["\xE5\x91\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA2"],
        ["\x57\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x9F"],

        ["\xE5\x91\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA3"],
        ["\x57\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB1"],

        ["\xE5\x91\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA4"],
        ["\x57\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB7"],

        ["\xE5\x91\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA5"],
        ["\x57\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB0"],

        ["\xE5\x92\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA6"],
        ["\x57\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x92"],

        ["\xE5\x91\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA7"],
        ["\x57\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBB"],

        ["\xE5\x92\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xA8"],
        ["\x57\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x80"],

        ["\xE5\x91\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAA"],
        ["\x57\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB6"],

        ["\xE5\x92\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAB"],
        ["\x57\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x84"],

        ["\xE5\x92\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAC"],
        ["\x57\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x90"],

        ["\xE5\x92\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAD"],
        ["\x57\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x86"],

        ["\xE5\x93\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xAF"],
        ["\x57\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x87"],

        ["\xE5\x92\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB2"],
        ["\x57\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA2"],

        ["\xE5\x92\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB3"],
        ["\x57\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB8"],

        ["\xE5\x92\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB4"],
        ["\x57\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA5"],

        ["\xE5\x92\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB5"],
        ["\x57\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAC"],

        ["\xE5\x93\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB6"],
        ["\x57\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x84"],

        ["\xE5\x93\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB8"],
        ["\x57\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x88"],

        ["\xE5\x92\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB9"],
        ["\x57\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA8"],

        ["\xE5\x92\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBA"],
        ["\x57\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAB"],

        ["\xE5\x93\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBB"],
        ["\x57\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x82"],

        ["\xE5\x92\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBC"],
        ["\x57\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA4"],

        ["\xE5\x92\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBE"],
        ["\x57\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBE"],

        ["\xE5\x92\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB0"],
        ["\x57\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBC"],

        ["\xE5\x93\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB7"],
        ["\x57\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x98"],

        ["\xE5\x93\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xBF"],
        ["\x57\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA5"],

        ["\xE5\x93\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC1"],
        ["\x57\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA6"],

        ["\xE5\x94\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC2"],
        ["\x57\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x8F"],

        ["\xE5\x94\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC3"],
        ["\x57\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x94"],

        ["\xE5\x93\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC4"],
        ["\x57\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBD"],

        ["\xE5\x93\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC5"],
        ["\x57\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAE"],

        ["\xE5\x93\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC6"],
        ["\x57\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAD"],

        ["\xE5\x93\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7C"],
        ["\x54\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBA"],

        ["\xE5\x93\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC7"],
        ["\x57\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA2"],

        ["\xE5\x94\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC8"],
        ["\x57\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB9"],

        ["\xE5\x95\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xC9"],
        ["\x57\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x80"],

        ["\xE5\x95\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCA"],
        ["\x57\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA3"],

        ["\xE5\x95\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCB"],
        ["\x57\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8C"],

        ["\xE5\x94\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCC"],
        ["\x57\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAE"],

        ["\xE5\x95\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCD"],
        ["\x57\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9C"],

        ["\xE5\x95\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCE"],
        ["\x57\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x85"],

        ["\xE5\x95\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xCF"],
        ["\x57\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x96"],

        ["\xE5\x95\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD0"],
        ["\x57\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x97"],

        ["\xE5\x94\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD1"],
        ["\x57\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB8"],

        ["\xE5\x94\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD2"],
        ["\x57\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB3"],

        ["\xE5\x95\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD3"],
        ["\x57\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9D"],

        ["\xE5\x96\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD4"],
        ["\x57\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x99"],

        ["\xE5\x96\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD5"],
        ["\x57\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x80"],

        ["\xE5\x92\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xB1"],
        ["\x57\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAF"],

        ["\xE5\x96\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD6"],
        ["\x57\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8A"],

        ["\xE5\x96\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD7"],
        ["\x57\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9F"],

        ["\xE5\x95\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD8"],
        ["\x57\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBB"],

        ["\xE5\x95\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xD9"],
        ["\x57\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBE"],

        ["\xE5\x96\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDA"],
        ["\x57\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x98"],

        ["\xE5\x96\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDB"],
        ["\x57\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9E"],

        ["\xE5\x96\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDC"],
        ["\x57\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAE"],

        ["\xE5\x95\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDD"],
        ["\x57\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBC"],

        ["\xE5\x96\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xDF"],
        ["\x57\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x83"],

        ["\xE5\x96\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE0"],
        ["\x57\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA9"],

        ["\xE5\x96\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE1"],
        ["\x57\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x87"],

        ["\xE5\x96\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE2"],
        ["\x57\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA8"],

        ["\xE5\x97\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA2"],
        ["\x52\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9A"],

        ["\xE5\x97\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE3"],
        ["\x57\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x85"],

        ["\xE5\x97\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE4"],
        ["\x57\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9F"],

        ["\xE5\x97\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE5"],
        ["\x57\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x84"],

        ["\xE5\x97\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE6"],
        ["\x57\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9C"],

        ["\xE5\x97\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE7"],
        ["\x57\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA4"],

        ["\xE5\x97\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE8"],
        ["\x57\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x94"],

        ["\xE5\x98\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xEA"],
        ["\x57\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x94"],

        ["\xE5\x97\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xEB"],
        ["\x57\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB7"],

        ["\xE5\x98\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xEC"],
        ["\x57\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x96"],

        ["\xE5\x97\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xED"],
        ["\x57\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBE"],

        ["\xE5\x97\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xEE"],
        ["\x57\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBD"],

        ["\xE5\x98\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xEF"],
        ["\x57\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x9B"],

        ["\xE5\x97\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xE9"],
        ["\x57\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB9"],

        ["\xE5\x99\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF0"],
        ["\x57\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8E"],

        ["\xE5\x99\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF1"],
        ["\x57\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x90"],

        ["\xE7\x87\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xFB"],
        ["\x57\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x9F"],

        ["\xE5\x98\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7F"],
        ["\x54\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB4"],

        ["\xE5\x98\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF2"],
        ["\x57\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB6"],

        ["\xE5\x98\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF3"],
        ["\x57\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB2"],

        ["\xE5\x98\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF4"],
        ["\x57\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB8"],

        ["\xE5\x99\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF5"],
        ["\x57\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAB"],

        ["\xE5\x99\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF6"],
        ["\x57\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA4"],

        ["\xE5\x98\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF8"],
        ["\x57\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xAF"],

        ["\xE5\x99\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF9"],
        ["\x57\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAC"],

        ["\xE5\x99\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xFA"],
        ["\x57\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAA"],

        ["\xE5\x9A\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xF7"],
        ["\x57\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x86"],

        ["\xE5\x9A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xFE"],
        ["\x57\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x80"],

        ["\xE5\x9A\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x41"],
        ["\x58\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8A"],

        ["\xE5\x9A\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x42"],
        ["\x58\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA0"],

        ["\xE5\x9A\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xFC"],
        ["\x57\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x94"],

        ["\xE5\x9A\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\xFD"],
        ["\x57\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8F"],

        ["\xE5\x9A\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x43"],
        ["\x58\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA5"],

        ["\xE5\x9A\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x44"],
        ["\x58\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAE"],

        ["\xE5\x9A\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x45"],
        ["\x58\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB6"],

        ["\xE5\x9A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x46"],
        ["\x58\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB4"],

        ["\xE5\x9B\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x48"],
        ["\x58\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x82"],

        ["\xE5\x9A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x49"],
        ["\x58\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xBC"],

        ["\xE5\x9B\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4A"],
        ["\x58\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x81"],

        ["\xE5\x9B\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4B"],
        ["\x58\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x83"],

        ["\xE5\x9B\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4C"],
        ["\x58\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x80"],

        ["\xE5\x9B\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x47"],
        ["\x58\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x88"],

        ["\xE5\x9B\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4D"],
        ["\x58\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8E"],

        ["\xE5\x9B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4F"],
        ["\x58\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x91"],

        ["\xE5\x9B\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x4E"],
        ["\x58\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x93"],

        ["\xE5\x9B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x50"],
        ["\x58\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x97"],

        ["\xE5\x9B\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x51"],
        ["\x58\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xAE"],

        ["\xE5\x9B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x52"],
        ["\x58\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB9"],

        ["\xE5\x9C\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x66"],
        ["\x52\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x80"],

        ["\xE5\x9B\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x53"],
        ["\x58\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBF"],

        ["\xE5\x9C\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x54"],
        ["\x58\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x84"],

        ["\xE5\x9C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x55"],
        ["\x58\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x89"],

        ["\xE5\x9C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x56"],
        ["\x58\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x88"],

        ["\xE5\x9C\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBD"],
        ["\x51\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8B"],

        ["\xE5\x9C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x57"],
        ["\x58\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8D"],

        ["\xE5\x9C\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE7"],
        ["\x54\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x93"],

        ["\xE5\x9C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x59"],
        ["\x58\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x98"],

        ["\xE5\x9C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5A"],
        ["\x58\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x96"],

        ["\xE5\x97\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x58"],
        ["\x58\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x87"],

        ["\xE5\x9C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5B"],
        ["\x58\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9C"],

        ["\xE5\x9C\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5C"],
        ["\x58\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA6"],

        ["\xE5\x9C\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD1"],
        ["\x51\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB7"],

        ["\xE5\x9C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5D"],
        ["\x58\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB8"],

        ["\xE5\x9D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5E"],
        ["\x58\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8E"],

        ["\xE5\x9C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x5F"],
        ["\x58\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xBB"],

        ["\xE5\x9D\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x61"],
        ["\x58\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x80"],

        ["\xE5\x9D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x62"],
        ["\x58\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8F"],

        ["\xE5\x9D\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x98"],
        ["\x53\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA9"],

        ["\xE5\x9F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x71"],
        ["\x58\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x80"],

        ["\xE5\x9E\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x64"],
        ["\x58\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x88"],

        ["\xE5\x9D\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x65"],
        ["\x58\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA1"],

        ["\xE5\x9D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x66"],
        ["\x58\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBF"],

        ["\xE5\x9E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x67"],
        ["\x58\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x89"],

        ["\xE5\x9E\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x68"],
        ["\x58\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x93"],

        ["\xE5\x9E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x69"],
        ["\x58\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA0"],

        ["\xE5\x9E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6B"],
        ["\x58\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB3"],

        ["\xE5\x9E\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6A"],
        ["\x58\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA4"],

        ["\xE5\x9E\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6D"],
        ["\x58\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAA"],

        ["\xE5\x9E\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xCD"],
        ["\x53\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB0"],

        ["\xE5\x9F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6E"],
        ["\x58\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x83"],

        ["\xE5\x9F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x6F"],
        ["\x58\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x86"],

        ["\xE5\x9F\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x72"],
        ["\x58\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x94"],

        ["\xE5\x9F\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x74"],
        ["\x58\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x92"],

        ["\xE5\x9F\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x75"],
        ["\x58\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x93"],

        ["\xE5\xA0\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x78"],
        ["\x58\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8A"],

        ["\xE5\x9F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x76"],
        ["\x58\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x96"],

        ["\xE5\x9F\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x79"],
        ["\x58\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA3"],

        ["\xE5\xA0\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7A"],
        ["\x58\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8B"],

        ["\xE5\xA0\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7B"],
        ["\x58\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x99"],

        ["\xE5\xA0\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA7"],
        ["\x53\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x9D"],

        ["\xE5\xA1\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x86"],
        ["\x58\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB2"],

        ["\xE5\xA0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7C"],
        ["\x58\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA1"],

        ["\xE5\xA1\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7E"],
        ["\x58\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA2"],

        ["\xE5\xA1\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7D"],
        ["\x58\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8B"],

        ["\xE5\xA1\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x83"],
        ["\x58\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB0"],

        ["\xE6\xAF\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x7F"],
        ["\x58\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x80"],

        ["\xE5\xA1\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x81"],
        ["\x58\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x92"],

        ["\xE5\xA0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x80"],
        ["\x58\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBD"],

        ["\xE5\xA1\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x84"],
        ["\x58\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB9"],

        ["\xE5\xA2\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x85"],
        ["\x58\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x85"],

        ["\xE5\xA2\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x8D"],
        ["\x58\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB9"],

        ["\xE5\xA2\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x87"],
        ["\x58\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9F"],

        ["\xE5\xA2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x88"],
        ["\x58\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAB"],

        ["\xE5\xA2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x8E"],
        ["\x58\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBA"],

        ["\xE5\xA3\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x95"],
        ["\x58\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9E"],

        ["\xE5\xA2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x52"],
        ["\x55\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBB"],

        ["\xE5\xA2\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x89"],
        ["\x58\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB8"],

        ["\xE5\xA2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x8B"],
        ["\x58\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAE"],

        ["\xE5\xA3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x8F"],
        ["\x58\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x85"],

        ["\xE5\xA3\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x90"],
        ["\x58\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x93"],

        ["\xE5\xA3\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x91"],
        ["\x58\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x91"],

        ["\xE5\xA3\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x92"],
        ["\x58\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x97"],

        ["\xE5\xA3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x93"],
        ["\x58\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x99"],

        ["\xE5\xA3\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x94"],
        ["\x58\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x98"],

        ["\xE5\xA3\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x99"],
        ["\x58\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA5"],

        ["\xE5\xA3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x96"],
        ["\x58\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9C"],

        ["\xE5\xA3\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x98"],
        ["\x58\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA4"],

        ["\xE5\xA3\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x97"],
        ["\x58\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9F"],

        ["\xE5\xA3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9A"],
        ["\x58\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAF"],

        ["\xE5\xA3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x77"],
        ["\x50\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBA"],

        ["\xE5\xA3\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9C"],
        ["\x58\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB9"],

        ["\xE5\xA3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9D"],
        ["\x58\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBB"],

        ["\xE5\xA3\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9E"],
        ["\x58\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBC"],

        ["\xE5\xA3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x75"],
        ["\x52\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBD"],

        ["\xE5\xA4\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\x9F"],
        ["\x58\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x82"],

        ["\xE5\xA4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA0"],
        ["\x58\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8A"],

        ["\xE5\xA4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA2"],
        ["\x58\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x90"],

        ["\xE5\xA4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA3"],
        ["\x58\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9B"],

        ["\xE6\xA2\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA4"],
        ["\x58\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA6"],

        ["\xE5\xA4\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA5"],
        ["\x58\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA5"],

        ["\xE5\xA4\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA6"],
        ["\x58\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAC"],

        ["\xE5\xA4\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA7"],
        ["\x58\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAD"],

        ["\xE5\xA4\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA8"],
        ["\x58\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB2"],

        ["\xE5\xA4\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xA9"],
        ["\x58\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB8"],

        ["\xE5\xA4\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAA"],
        ["\x58\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xBE"],

        ["\xE7\xAB\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],
        ["\x60\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x92"],

        ["\xE5\xA5\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAB"],
        ["\x58\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x95"],

        ["\xE5\xA5\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAC"],
        ["\x58\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x90"],

        ["\xE5\xA5\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8F"],
        ["\x51\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8E"],

        ["\xE5\xA5\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAE"],
        ["\x58\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9A"],

        ["\xE5\xA5\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xAF"],
        ["\x58\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x98"],

        ["\xE5\xA5\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB3"],
        ["\x58\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA2"],

        ["\xE5\xA5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB4"],
        ["\x58\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA0"],

        ["\xE5\xA5\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB5"],
        ["\x58\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA7"],

        ["\xE5\xA5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB6"],
        ["\x58\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAC"],

        ["\xE5\xA5\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB7"],
        ["\x58\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA9"],

        ["\xE5\xA5\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB8"],
        ["\x58\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB8"],

        ["\xE5\xA6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xB9"],
        ["\x58\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x81"],

        ["\xE5\xA6\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBC"],
        ["\x58\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9D"],

        ["\xE4\xBD\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x6D"],
        ["\x56\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9E"],

        ["\xE4\xBE\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x78"],
        ["\x56\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAB"],

        ["\xE5\xA6\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBD"],
        ["\x58\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA3"],

        ["\xE5\xA6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBF"],
        ["\x58\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB2"],

        ["\xE5\xA7\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC1"],
        ["\x58\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x86"],

        ["\xE5\xA7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC2"],
        ["\x58\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA8"],

        ["\xE5\xA7\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x84"],
        ["\x51\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9C"],

        ["\xE5\xA6\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBA"],
        ["\x58\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8D"],

        ["\xE5\xA7\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC3"],
        ["\x58\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x99"],

        ["\xE5\xA7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC4"],
        ["\x58\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9A"],

        ["\xE5\xA8\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC5"],
        ["\x58\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA5"],

        ["\xE5\xA8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC6"],
        ["\x58\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9F"],

        ["\xE5\xA8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC7"],
        ["\x58\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x91"],

        ["\xE5\xA8\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC8"],
        ["\x58\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9C"],

        ["\xE5\xA8\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCA"],
        ["\x58\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x89"],

        ["\xE5\xA8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xC9"],
        ["\x58\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9A"],

        ["\xE5\xA9\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCB"],
        ["\x58\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x80"],

        ["\xE5\xA9\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCC"],
        ["\x58\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAC"],

        ["\xE5\xA9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCD"],
        ["\x58\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x89"],

        ["\xE5\xA8\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCE"],
        ["\x58\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB5"],

        ["\xE5\xA8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xCF"],
        ["\x58\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB6"],

        ["\xE5\xA9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD0"],
        ["\x58\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA2"],

        ["\xE5\xA9\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD1"],
        ["\x58\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAA"],

        ["\xE5\xAA\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD2"],
        ["\x58\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9A"],

        ["\xE5\xAA\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD3"],
        ["\x58\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBC"],

        ["\xE5\xAA\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD4"],
        ["\x58\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBE"],

        ["\xE5\xAB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD6"],
        ["\x58\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8B"],

        ["\xE5\xAB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD7"],
        ["\x58\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x82"],

        ["\xE5\xAA\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD8"],
        ["\x58\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBD"],

        ["\xE5\xAB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD9"],
        ["\x58\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA3"],

        ["\xE5\xAB\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDA"],
        ["\x58\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x97"],

        ["\xE5\xAB\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDB"],
        ["\x58\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA6"],

        ["\xE5\xAB\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDC"],
        ["\x58\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA9"],

        ["\xE5\xAB\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDD"],
        ["\x58\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x96"],

        ["\xE5\xAB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDE"],
        ["\x58\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBA"],

        ["\xE5\xAB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xDF"],
        ["\x58\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBB"],

        ["\xE5\xAC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE0"],
        ["\x58\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8C"],

        ["\xE5\xAC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE1"],
        ["\x58\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8B"],

        ["\xE5\xAC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE2"],
        ["\x58\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x96"],

        ["\xE5\xAC\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE3"],
        ["\x58\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB2"],

        ["\xE5\xAB\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xD5"],
        ["\x58\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x90"],

        ["\xE5\xAC\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE4"],
        ["\x58\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAA"],

        ["\xE5\xAC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE5"],
        ["\x58\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB6"],

        ["\xE5\xAC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE6"],
        ["\x58\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xBE"],

        ["\xE5\xAD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE7"],
        ["\x58\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x83"],

        ["\xE5\xAD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE8"],
        ["\x58\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x85"],

        ["\xE5\xAD\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xE9"],
        ["\x58\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x80"],

        ["\xE5\xAD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xEA"],
        ["\x58\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x91"],

        ["\xE5\xAD\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xEB"],
        ["\x58\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x95"],

        ["\xE5\xAD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x58"],
        ["\x52\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9A"],

        ["\xE5\xAD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xEE"],
        ["\x58\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9B"],

        ["\xE5\xAD\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xEF"],
        ["\x58\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA5"],

        ["\xE5\xAD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF0"],
        ["\x58\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA9"],

        ["\xE5\xAD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF1"],
        ["\x58\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB0"],

        ["\xE5\xAD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF2"],
        ["\x58\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB3"],

        ["\xE5\xAD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF3"],
        ["\x58\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB5"],

        ["\xE5\xAD\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF4"],
        ["\x58\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB8"],

        ["\xE6\x96\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xED"],
        ["\x58\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x88"],

        ["\xE5\xAD\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF5"],
        ["\x58\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBA"],

        ["\xE5\xAE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF6"],
        ["\x58\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x80"],

        ["\xE5\xAE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF7"],
        ["\x58\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x83"],

        ["\xE5\xAE\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF8"],
        ["\x58\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA6"],

        ["\xE5\xAE\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xF9"],
        ["\x58\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB8"],

        ["\xE5\xAF\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xFA"],
        ["\x58\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x83"],

        ["\xE5\xAF\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xFB"],
        ["\x58\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x87"],

        ["\xE5\xAF\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xFD"],
        ["\x58\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x89"],

        ["\xE5\xAF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x44"],
        ["\x52\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x94"],

        ["\xE5\xAF\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x41"],
        ["\x59\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x90"],

        ["\xE5\xAF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x45"],
        ["\x59\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA4"],

        ["\xE5\xAF\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xFC"],
        ["\x51\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA6"],

        ["\xE5\xAF\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x46"],
        ["\x59\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA2"],

        ["\xE5\xAF\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x43"],
        ["\x59\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9E"],

        ["\xE5\xAF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x47"],
        ["\x59\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA5"],

        ["\xE5\xAF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x48"],
        ["\x59\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAB"],

        ["\xE5\xAF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x49"],
        ["\x59\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB0"],

        ["\xE5\xAF\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],
        ["\x59\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB6"],

        ["\xE5\xAF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],
        ["\x59\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB3"],

        ["\xE5\xB0\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],
        ["\x59\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x85"],

        ["\xE5\xB0\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],
        ["\x59\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x87"],

        ["\xE5\xB0\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],
        ["\x59\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x88"],

        ["\xE5\xB0\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],
        ["\x59\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8D"],

        ["\xE5\xB0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],
        ["\x59\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x93"],

        ["\xE5\xB0\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x52"],
        ["\x59\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA0"],

        ["\xE5\xB0\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x53"],
        ["\x59\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA2"],

        ["\xE5\xB0\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x54"],
        ["\x59\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA8"],

        ["\xE5\xB0\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x55"],
        ["\x59\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB8"],

        ["\xE5\xB0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5D"],
        ["\x51\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB9"],

        ["\xE5\xB1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x56"],
        ["\x59\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x81"],

        ["\xE5\xB1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],
        ["\x59\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x86"],

        ["\xE5\xB1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x58"],
        ["\x59\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8E"],

        ["\xE5\xB1\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],
        ["\x59\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x93"],

        ["\xE5\xB1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],
        ["\x59\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x90"],

        ["\xE5\xB1\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x43"],
        ["\x54\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8F"],

        ["\xE5\xAD\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],
        ["\x59\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB1"],

        ["\xE5\xB1\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],
        ["\x59\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAC"],

        ["\xE5\xB1\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],
        ["\x59\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAE"],

        ["\xE4\xB9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\x4C"],
        ["\x56\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xA2"],

        ["\xE5\xB1\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],
        ["\x59\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB6"],

        ["\xE5\xB1\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],
        ["\x59\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB9"],

        ["\xE5\xB2\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],
        ["\x59\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8C"],

        ["\xE5\xB2\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x5A"],
        ["\x52\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x91"],

        ["\xE5\xB2\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],
        ["\x59\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x94"],

        ["\xE5\xA6\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x58\xBB"],
        ["\x58\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9B"],

        ["\xE5\xB2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],
        ["\x59\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAB"],

        ["\xE5\xB2\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],
        ["\x59\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBB"],

        ["\xE5\xB2\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],
        ["\x59\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB6"],

        ["\xE5\xB2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],
        ["\x59\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBC"],

        ["\xE5\xB2\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],
        ["\x59\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB7"],

        ["\xE5\xB3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],
        ["\x59\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x85"],

        ["\xE5\xB2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],
        ["\x59\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBE"],

        ["\xE5\xB3\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],
        ["\x59\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x87"],

        ["\xE5\xB3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],
        ["\x59\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x99"],

        ["\xE5\xB3\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],
        ["\x59\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA9"],

        ["\xE5\xB3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],
        ["\x59\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBD"],

        ["\xE5\xB3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],
        ["\x59\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBA"],

        ["\xE5\xB3\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],
        ["\x59\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAD"],

        ["\xE5\xB6\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8C"],
        ["\x59\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8C"],

        ["\xE5\xB3\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],
        ["\x59\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAA"],

        ["\xE5\xB4\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],
        ["\x59\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8B"],

        ["\xE5\xB4\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],
        ["\x59\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x95"],

        ["\xE5\xB4\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF1"],
        ["\x54\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x97"],

        ["\xE5\xB5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x81"],
        ["\x59\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x9C"],

        ["\xE5\xB4\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],
        ["\x59\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9F"],

        ["\xE5\xB4\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],
        ["\x59\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9B"],

        ["\xE5\xB4\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],
        ["\x59\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x91"],

        ["\xE5\xB4\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4D"],
        ["\x51\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x94"],

        ["\xE5\xB4\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],
        ["\x59\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA2"],

        ["\xE5\xB4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],
        ["\x59\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9A"],

        ["\xE5\xB4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],
        ["\x59\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x99"],

        ["\xE5\xB4\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],
        ["\x59\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x98"],

        ["\xE5\xB5\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],
        ["\x59\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8C"],

        ["\xE5\xB5\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],
        ["\x59\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x92"],

        ["\xE5\xB5\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x82"],
        ["\x59\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8E"],

        ["\xE5\xB5\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x83"],
        ["\x59\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8B"],

        ["\xE5\xB5\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x85"],
        ["\x59\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAC"],

        ["\xE5\xB5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x86"],
        ["\x59\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB3"],

        ["\xE5\xB5\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x88"],
        ["\x59\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB6"],

        ["\xE5\xB6\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x89"],
        ["\x59\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x87"],

        ["\xE5\xB6\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8A"],
        ["\x59\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x84"],

        ["\xE5\xB6\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8B"],
        ["\x59\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x82"],

        ["\xE5\xB6\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8D"],
        ["\x59\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA2"],

        ["\xE5\xB6\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8E"],
        ["\x59\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x9D"],

        ["\xE5\xB6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x90"],
        ["\x59\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAC"],

        ["\xE5\xB6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x91"],
        ["\x59\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAE"],

        ["\xE5\xB6\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x84"],
        ["\x4F\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBD"],

        ["\xE5\xB6\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x8F"],
        ["\x59\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x90"],

        ["\xE5\xB6\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x92"],
        ["\x59\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB7"],

        ["\xE5\xB6\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x94"],
        ["\x59\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBC"],

        ["\xE5\xB7\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x96"],
        ["\x59\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x89"],

        ["\xE5\xB7\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x81"],
        ["\x52\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8D"],

        ["\xE5\xB7\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x98"],
        ["\x59\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x93"],

        ["\xE5\xB7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x99"],
        ["\x59\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x92"],

        ["\xE5\xB7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xDF"],
        ["\x51\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x96"],

        ["\xE5\xB7\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9A"],
        ["\x59\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9B"],

        ["\xE5\xB7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9B"],
        ["\x59\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAB"],

        ["\xE5\xB7\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],
        ["\x4A\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB2"],

        ["\xE5\xB7\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9C"],
        ["\x59\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB5"],

        ["\xE5\xB8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9D"],
        ["\x59\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8B"],

        ["\xE5\xB8\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9E"],
        ["\x59\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9A"],

        ["\xE5\xB8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\x9F"],
        ["\x59\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x99"],

        ["\xE5\xB8\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA0"],
        ["\x59\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x91"],

        ["\xE5\xB8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA1"],
        ["\x59\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9B"],

        ["\xE5\xB8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA2"],
        ["\x59\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB6"],

        ["\xE5\xB8\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBE"],
        ["\x54\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB7"],

        ["\xE5\xB9\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA3"],
        ["\x59\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x84"],

        ["\xE5\xB9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA4"],
        ["\x59\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x83"],

        ["\xE5\xB9\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA5"],
        ["\x59\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x80"],

        ["\xE5\xB9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA7"],
        ["\x59\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8E"],

        ["\xE5\xB9\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA8"],
        ["\x59\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x97"],

        ["\xE5\xB9\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA9"],
        ["\x59\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x94"],

        ["\xE5\xB9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x83"],
        ["\x54\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x9F"],

        ["\xE5\xB9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAA"],
        ["\x59\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA2"],

        ["\xE5\xB9\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAB"],
        ["\x59\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA4"],

        ["\xE5\xB9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA6"],
        ["\x59\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x87"],

        ["\xE5\xB9\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAC"],
        ["\x59\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB5"],

        ["\xE5\xB9\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAD"],
        ["\x59\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB6"],

        ["\xE5\xB9\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAE"],
        ["\x59\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBA"],

        ["\xE9\xBA\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],
        ["\x68\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBC"],

        ["\xE5\xB9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xAF"],
        ["\x59\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBF"],

        ["\xE5\xBA\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB0"],
        ["\x59\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA0"],

        ["\xE5\xBB\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB1"],
        ["\x59\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x81"],

        ["\xE5\xBB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB2"],
        ["\x59\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x82"],

        ["\xE5\xBB\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB3"],
        ["\x59\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x88"],

        ["\xE5\xBB\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB4"],
        ["\x59\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x90"],

        ["\xE5\xBB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB5"],
        ["\x59\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8F"],

        ["\xE5\xBB\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6C"],
        ["\x53\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x96"],

        ["\xE5\xBB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE9"],
        ["\x50\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA3"],

        ["\xE5\xBB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB6"],
        ["\x59\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9D"],

        ["\xE5\xBB\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB7"],
        ["\x59\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9A"],

        ["\xE5\xBB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB8"],
        ["\x59\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9B"],

        ["\xE5\xBB\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xB9"],
        ["\x59\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA2"],

        ["\xE5\xBB\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBA"],
        ["\x59\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA1"],

        ["\xE5\xBB\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBB"],
        ["\x59\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA8"],

        ["\xE5\xBB\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBC"],
        ["\x59\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA9"],

        ["\xE5\xBB\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBD"],
        ["\x59\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xAC"],

        ["\xE5\xBB\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBF"],
        ["\x59\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB1"],

        ["\xE5\xBB\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC0"],
        ["\x59\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB3"],

        ["\xE5\xBB\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xBE"],
        ["\x59\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB0"],

        ["\xE5\xBB\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"],
        ["\x59\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB4"],

        ["\xE5\xBB\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD6"],
        ["\x52\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB8"],

        ["\xE5\xBB\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x4B"],
        ["\x54\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBE"],

        ["\xE5\xBC\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC2"],
        ["\x59\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x83"],

        ["\xE5\xBC\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC3"],
        ["\x59\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x89"],

        ["\xE5\xBD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD6"],
        ["\x59\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9D"],

        ["\xE5\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD5"],
        ["\x59\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9C"],

        ["\xE5\xBC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC4"],
        ["\x59\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8B"],

        ["\xE5\xBC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC5"],
        ["\x59\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x91"],

        ["\xE5\xBC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC6"],
        ["\x59\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x96"],

        ["\xE5\xBC\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC8"],
        ["\x59\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA9"],

        ["\xE5\xBC\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xC9"],
        ["\x59\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAD"],

        ["\xE5\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCC"],
        ["\x59\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB8"],

        ["\xE5\xBD\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCE"],
        ["\x59\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x88"],

        ["\xE5\xBD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCF"],
        ["\x59\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8C"],

        ["\xE5\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD0"],
        ["\x59\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8E"],

        ["\xE5\xBC\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xCA"],
        ["\x59\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAF"],

        ["\xE5\xBD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD1"],
        ["\x59\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x91"],

        ["\xE5\xBD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD2"],
        ["\x59\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x96"],

        ["\xE5\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD3"],
        ["\x59\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x97"],

        ["\xE5\xBD\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD4"],
        ["\x59\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x99"],

        ["\xE5\xBD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],
        ["\x59\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA1"],

        ["\xE5\xBD\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x9C"],
        ["\x52\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAD"],

        ["\xE5\xBD\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],
        ["\x59\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB3"],

        ["\xE5\xBD\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDA"],
        ["\x59\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB7"],

        ["\xE5\xBE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDB"],
        ["\x59\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x83"],

        ["\xE5\xBE\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDC"],
        ["\x59\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x82"],

        ["\xE5\xBD\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDD"],
        ["\x59\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBF"],

        ["\xE5\xBE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDE"],
        ["\x59\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8A"],

        ["\xE5\xBE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xDF"],
        ["\x59\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x88"],

        ["\xE5\xBE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE1"],
        ["\x59\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x91"],

        ["\xE5\xBE\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"],
        ["\x59\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x87"],

        ["\xE5\xBE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE3"],
        ["\x59\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x9E"],

        ["\xE5\xBE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE2"],
        ["\x59\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x99"],

        ["\xE5\xBE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"],
        ["\x59\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x98"],

        ["\xE5\xBE\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE5"],
        ["\x59\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA0"],

        ["\xE5\xBE\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"],
        ["\x59\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA8"],

        ["\xE5\xBE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE7"],
        ["\x59\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAD"],

        ["\xE5\xBE\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xE9"],
        ["\x59\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBC"],

        ["\xE5\xBF\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEA"],
        ["\x59\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x96"],

        ["\xE5\xBF\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEB"],
        ["\x59\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBB"],

        ["\xE5\xBF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEC"],
        ["\x59\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA4"],

        ["\xE5\xBF\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xED"],
        ["\x59\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB8"],

        ["\xE5\xBF\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEE"],
        ["\x59\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB1"],

        ["\xE5\xBF\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF0"],
        ["\x59\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9D"],

        ["\xE6\x82\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x76"],
        ["\x52\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB3"],

        ["\xE5\xBF\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF2"],
        ["\x59\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBF"],

        ["\xE6\x80\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"],
        ["\x59\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA1"],

        ["\xE6\x81\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x43"],
        ["\x5A\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA0"],

        ["\xE6\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],
        ["\x59\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x99"],

        ["\xE6\x80\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF5"],
        ["\x59\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x90"],

        ["\xE6\x80\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF6"],
        ["\x59\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA9"],

        ["\xE6\x80\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF7"],
        ["\x59\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8E"],

        ["\xE6\x80\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF8"],
        ["\x59\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB1"],

        ["\xE6\x80\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xF9"],
        ["\x59\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9B"],

        ["\xE6\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFA"],
        ["\x59\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x95"],

        ["\xE6\x80\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFB"],
        ["\x59\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAB"],

        ["\xE6\x80\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFC"],
        ["\x59\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA6"],

        ["\xE6\x80\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFD"],
        ["\x59\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8F"],

        ["\xE6\x80\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xFE"],
        ["\x59\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xBA"],

        ["\xE6\x81\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x41"],
        ["\x5A\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9A"],

        ["\xE6\x81\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x42"],
        ["\x5A\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x81"],

        ["\xE6\x81\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x45"],
        ["\x5A\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAA"],

        ["\xE6\x81\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x46"],
        ["\x5A\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB7"],

        ["\xE6\x81\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x47"],
        ["\x5A\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9F"],

        ["\xE6\x81\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x48"],
        ["\x5A\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8A"],

        ["\xE6\x81\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x49"],
        ["\x5A\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x86"],

        ["\xE6\x81\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],
        ["\x5A\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8D"],

        ["\xE6\x81\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],
        ["\x5A\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA3"],

        ["\xE6\x81\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],
        ["\x5A\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x83"],

        ["\xE6\x81\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],
        ["\x5A\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA4"],

        ["\xE6\x81\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x56"],
        ["\x52\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x82"],

        ["\xE6\x81\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],
        ["\x5A\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAC"],

        ["\xE6\x81\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],
        ["\x5A\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAB"],

        ["\xE6\x81\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],
        ["\x5A\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x99"],

        ["\xE6\x82\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x52"],
        ["\x5A\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x81"],

        ["\xE6\x82\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x44"],
        ["\x55\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8D"],

        ["\xE6\x83\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x4A"],
        ["\x55\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA7"],

        ["\xE6\x82\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x53"],
        ["\x5A\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x83"],

        ["\xE6\x82\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x54"],
        ["\x5A\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9A"],

        ["\xE6\x82\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x55"],
        ["\x5A\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x84"],

        ["\xE6\x82\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x56"],
        ["\x5A\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9B"],

        ["\xE6\x82\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x58"],
        ["\x5A\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x96"],

        ["\xE6\x82\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],
        ["\x5A\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x97"],

        ["\xE6\x82\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],
        ["\x5A\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x92"],

        ["\xE6\x82\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],
        ["\x5A\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA7"],

        ["\xE6\x82\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],
        ["\x5A\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8B"],

        ["\xE6\x83\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],
        ["\x5A\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA1"],

        ["\xE6\x82\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],
        ["\x5A\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB8"],

        ["\xE6\x83\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],
        ["\x5A\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA0"],

        ["\xE6\x83\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],
        ["\x5A\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x93"],

        ["\xE6\x82\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xA3"],
        ["\x53\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB4"],

        ["\xE5\xBF\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xEF"],
        ["\x59\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB0"],

        ["\xE6\x82\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],
        ["\x5A\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBD"],

        ["\xE6\x83\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],
        ["\x5A\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x86"],

        ["\xE6\x82\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],
        ["\x5A\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB5"],

        ["\xE6\x83\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],
        ["\x5A\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x98"],

        ["\xE6\x85\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],
        ["\x5A\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8D"],

        ["\xE6\x84\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],
        ["\x5A\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x95"],

        ["\xE6\x84\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],
        ["\x5A\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x86"],

        ["\xE6\x83\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],
        ["\x5A\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB6"],

        ["\xE6\x83\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],
        ["\x5A\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB7"],

        ["\xE6\x84\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],
        ["\x5A\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x80"],

        ["\xE6\x83\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],
        ["\x5A\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB4"],

        ["\xE6\x83\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],
        ["\x5A\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBA"],

        ["\xE6\x84\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],
        ["\x5A\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x83"],

        ["\xE6\x84\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],
        ["\x5A\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA1"],

        ["\xE6\x83\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],
        ["\x5A\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBB"],

        ["\xE6\x83\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],
        ["\x5A\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB1"],

        ["\xE6\x84\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],
        ["\x5A\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8D"],

        ["\xE6\x84\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],
        ["\x5A\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8E"],

        ["\xE6\x85\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],
        ["\x5A\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x87"],

        ["\xE6\x84\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],
        ["\x5A\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBE"],

        ["\xE6\x84\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],
        ["\x5A\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA8"],

        ["\xE6\x84\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],
        ["\x5A\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA7"],

        ["\xE6\x85\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],
        ["\x5A\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8A"],

        ["\xE6\x84\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE3"],
        ["\x51\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBF"],

        ["\xE6\x84\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x7F"],
        ["\x5A\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBC"],

        ["\xE6\x84\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x80"],
        ["\x5A\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAC"],

        ["\xE6\x84\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x81"],
        ["\x5A\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB4"],

        ["\xE6\x84\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x84"],
        ["\x5A\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBD"],

        ["\xE6\x85\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x85"],
        ["\x5A\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x82"],

        ["\xE6\x85\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x86"],
        ["\x5A\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x84"],

        ["\xE6\x85\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x87"],
        ["\x5A\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB3"],

        ["\xE6\x85\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x89"],
        ["\x5A\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB7"],

        ["\xE6\x85\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8A"],
        ["\x5A\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x98"],

        ["\xE6\x85\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8B"],
        ["\x5A\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x99"],

        ["\xE6\x85\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8C"],
        ["\x5A\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9A"],

        ["\xE6\x85\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8D"],
        ["\x5A\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAB"],

        ["\xE6\x85\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8E"],
        ["\x5A\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB4"],

        ["\xE6\x85\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x8F"],
        ["\x5A\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAF"],

        ["\xE6\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x82"],
        ["\x5A\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA5"],

        ["\xE6\x85\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x90"],
        ["\x5A\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB1"],

        ["\xE6\x85\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x91"],
        ["\x5A\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9F"],

        ["\xE6\x85\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x83"],
        ["\x5A\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9D"],

        ["\xE6\x85\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x92"],
        ["\x5A\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x93"],

        ["\xE6\x85\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x93"],
        ["\x5A\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB5"],

        ["\xE6\x86\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x95"],
        ["\x5A\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x99"],

        ["\xE6\x86\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x96"],
        ["\x5A\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x96"],

        ["\xE6\x86\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x88"],
        ["\x5A\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x87"],

        ["\xE6\x86\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x97"],
        ["\x5A\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAC"],

        ["\xE6\x86\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x98"],
        ["\x5A\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x94"],

        ["\xE6\x86\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xCF"],
        ["\x55\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x9A"],

        ["\xE6\x86\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x99"],
        ["\x5A\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8A"],

        ["\xE6\x86\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9A"],
        ["\x5A\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x91"],

        ["\xE6\x86\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9B"],
        ["\x5A\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAB"],

        ["\xE6\x86\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9C"],
        ["\x5A\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAE"],

        ["\xE6\x87\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9D"],
        ["\x5A\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8C"],

        ["\xE6\x87\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9E"],
        ["\x5A\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8A"],

        ["\xE6\x87\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\x9F"],
        ["\x5A\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x89"],

        ["\xE6\x87\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAA"],
        ["\x5A\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB7"],

        ["\xE6\x87\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA0"],
        ["\x5A\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x88"],

        ["\xE6\x87\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"],
        ["\x5A\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x83"],

        ["\xE6\x87\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA2"],
        ["\x5A\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x86"],

        ["\xE6\x86\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA3"],
        ["\x5A\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBA"],

        ["\xE6\x87\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA4"],
        ["\x5A\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8B"],

        ["\xE7\xBD\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA5"],
        ["\x5A\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB9"],

        ["\xE6\x87\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA6"],
        ["\x5A\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8D"],

        ["\xE6\x87\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA7"],
        ["\x5A\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA6"],

        ["\xE6\x87\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA8"],
        ["\x5A\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA3"],

        ["\xE6\x87\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAB"],
        ["\x5A\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB6"],

        ["\xE6\x87\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAD"],
        ["\x5A\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBA"],

        ["\xE6\x87\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xA9"],
        ["\x5A\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB4"],

        ["\xE6\x87\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAE"],
        ["\x5A\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBF"],

        ["\xE6\x87\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAC"],
        ["\x5A\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBD"],

        ["\xE6\x87\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xAF"],
        ["\x5A\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBC"],

        ["\xE6\x87\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"],
        ["\x5A\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBE"],

        ["\xE6\x88\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB1"],
        ["\x5A\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x80"],

        ["\xE6\x88\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB2"],
        ["\x5A\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x88"],

        ["\xE6\x88\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB3"],
        ["\x5A\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x89"],

        ["\xE6\x88\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB4"],
        ["\x5A\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8D"],

        ["\xE6\x88\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x60"],
        ["\x54\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8C"],

        ["\xE6\x88\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB6"],
        ["\x5A\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x94"],

        ["\xE6\x88\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB7"],
        ["\x5A\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9B"],

        ["\xE6\x88\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB8"],
        ["\x5A\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9E"],

        ["\xE6\x88\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xB9"],
        ["\x5A\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA1"],

        ["\xE6\x88\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBA"],
        ["\x5A\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAA"],

        ["\xE6\x88\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBB"],
        ["\x5A\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAE"],

        ["\xE6\x88\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBC"],
        ["\x5A\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB0"],

        ["\xE6\x88\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBD"],
        ["\x5A\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB2"],

        ["\xE6\x88\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBE"],
        ["\x5A\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB3"],

        ["\xE6\x89\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xBF"],
        ["\x5A\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x81"],

        ["\xE6\x89\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC0"],
        ["\x5A\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8E"],

        ["\xE6\x89\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC1"],
        ["\x5A\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9E"],

        ["\xE6\x89\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC2"],
        ["\x5A\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA3"],

        ["\xE6\x89\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC3"],
        ["\x5A\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9B"],

        ["\xE6\x89\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC4"],
        ["\x5A\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA0"],

        ["\xE6\x89\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC5"],
        ["\x5A\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA8"],

        ["\xE6\x89\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC6"],
        ["\x5A\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBC"],

        ["\xE6\x8A\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC7"],
        ["\x5A\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x82"],

        ["\xE6\x8A\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC8"],
        ["\x5A\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x89"],

        ["\xE6\x89\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCA"],
        ["\x5A\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBE"],

        ["\xE6\x8A\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xC9"],
        ["\x5A\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x92"],

        ["\xE6\x8A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCB"],
        ["\x5A\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x93"],

        ["\xE6\x8A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCC"],
        ["\x5A\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x96"],

        ["\xE6\x8B\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD7"],
        ["\x5A\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x94"],

        ["\xE6\x8A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCD"],
        ["\x5A\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x83"],

        ["\xE6\x8A\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCE"],
        ["\x5A\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x94"],

        ["\xE6\x8B\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xCF"],
        ["\x5A\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x97"],

        ["\xE6\x8B\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"],
        ["\x5A\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x91"],

        ["\xE6\x8A\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD1"],
        ["\x5A\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBB"],

        ["\xE6\x8B\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD2"],
        ["\x5A\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8F"],

        ["\xE6\x8B\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE6"],
        ["\x5A\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBF"],

        ["\xE6\x8B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD4"],
        ["\x5A\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x86"],

        ["\xE6\x93\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],
        ["\x5B\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x94"],

        ["\xE6\x8B\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD5"],
        ["\x5A\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x88"],

        ["\xE6\x8B\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD6"],
        ["\x5A\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9C"],

        ["\xE6\x8B\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x45"],
        ["\x53\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8C"],

        ["\xE6\x8B\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD8"],
        ["\x5A\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8A"],

        ["\xE6\x8B\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD9"],
        ["\x5A\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x82"],

        ["\xE6\x8B\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDB"],
        ["\x5A\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x87"],

        ["\xE6\x8A\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDC"],
        ["\x5A\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9B"],

        ["\xE6\x8B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDD"],
        ["\x5A\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x89"],

        ["\xE6\x8C\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDE"],
        ["\x5A\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8C"],

        ["\xE6\x8B\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xDF"],
        ["\x5A\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAE"],

        ["\xE6\x8B\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE0"],
        ["\x5A\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB1"],

        ["\xE6\x8C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE1"],
        ["\x5A\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA7"],

        ["\xE6\x8C\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE2"],
        ["\x5A\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x82"],

        ["\xE6\x8C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE3"],
        ["\x5A\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x88"],

        ["\xE6\x8B\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE4"],
        ["\x5A\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAF"],

        ["\xE6\x8B\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE5"],
        ["\x5A\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB5"],

        ["\xE6\x8D\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE7"],
        ["\x5A\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x90"],

        ["\xE6\x8C\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE9"],
        ["\x5A\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBE"],

        ["\xE6\x8D\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xE8"],
        ["\x5A\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8D"],

        ["\xE6\x90\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x48"],
        ["\x5B\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x9C"],

        ["\xE6\x8D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEA"],
        ["\x5A\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8F"],

        ["\xE6\x8E\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEB"],
        ["\x5A\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x96"],

        ["\xE6\x8E\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEC"],
        ["\x5A\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8E"],

        ["\xE6\x8E\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xED"],
        ["\x5A\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x80"],

        ["\xE6\x8E\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEE"],
        ["\x5A\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAB"],

        ["\xE6\x8D\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xEF"],
        ["\x5A\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB6"],

        ["\xE6\x8E\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF0"],
        ["\x5A\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA3"],

        ["\xE6\x8E\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"],
        ["\x5A\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8F"],

        ["\xE6\x8E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF2"],
        ["\x5A\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x89"],

        ["\xE6\x8E\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF3"],
        ["\x5A\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9F"],

        ["\xE6\x8E\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF6"],
        ["\x5A\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB5"],

        ["\xE6\x8D\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF4"],
        ["\x5A\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAB"],

        ["\xE6\x8D\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF5"],
        ["\x5A\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA9"],

        ["\xE6\x8E\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF7"],
        ["\x5A\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBE"],

        ["\xE6\x8F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF8"],
        ["\x5A\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA9"],

        ["\xE6\x8F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xF9"],
        ["\x5A\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x80"],

        ["\xE6\x8F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFA"],
        ["\x5A\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x86"],

        ["\xE6\x8F\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFC"],
        ["\x5A\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA3"],

        ["\xE6\x8F\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFD"],
        ["\x5A\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x89"],

        ["\xE6\x8F\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xFE"],
        ["\x5A\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x92"],

        ["\xE6\x8F\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x41"],
        ["\x5B\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB6"],

        ["\xE6\x8F\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x42"],
        ["\x5B\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x84"],

        ["\xE6\x90\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],
        ["\x5B\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x96"],

        ["\xE6\x90\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x43"],
        ["\x5B\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB4"],

        ["\xE6\x90\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x44"],
        ["\x5B\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x86"],

        ["\xE6\x90\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x45"],
        ["\x5B\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x93"],

        ["\xE6\x90\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x46"],
        ["\x5B\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA6"],

        ["\xE6\x90\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x47"],
        ["\x5B\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB6"],

        ["\xE6\x94\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],
        ["\x5B\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9D"],

        ["\xE6\x90\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x49"],
        ["\x5B\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x97"],

        ["\xE6\x90\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],
        ["\x5B\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA8"],

        ["\xE6\x90\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],
        ["\x5B\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8F"],

        ["\xE6\x91\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],
        ["\x5B\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA7"],

        ["\xE6\x91\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],
        ["\x5B\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xAF"],

        ["\xE6\x91\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x51"],
        ["\x5B\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB6"],

        ["\xE6\x91\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],
        ["\x5B\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x8E"],

        ["\xE6\x94\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7F"],
        ["\x52\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAA"],

        ["\xE6\x92\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x55"],
        ["\x5B\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x95"],

        ["\xE6\x92\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],
        ["\x5B\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x93"],

        ["\xE6\x92\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x58"],
        ["\x5B\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA5"],

        ["\xE6\x92\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],
        ["\x5B\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA9"],

        ["\xE6\x92\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],
        ["\x5B\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x88"],

        ["\xE6\x92\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],
        ["\x5B\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBC"],

        ["\xE6\x93\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],
        ["\x5B\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x9A"],

        ["\xE6\x93\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],
        ["\x5B\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x92"],

        ["\xE6\x93\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],
        ["\x5B\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x85"],

        ["\xE6\x93\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],
        ["\x5B\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x87"],

        ["\xE6\x92\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x56"],
        ["\x5B\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBB"],

        ["\xE6\x93\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],
        ["\x5B\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x98"],

        ["\xE6\x93\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],
        ["\x5B\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x82"],

        ["\xE6\x93\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],
        ["\x5B\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB1"],

        ["\xE6\x93\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],
        ["\x5B\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA7"],

        ["\xE8\x88\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],
        ["\x57\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x89"],

        ["\xE6\x93\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],
        ["\x5B\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA0"],

        ["\xE6\x93\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],
        ["\x5B\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA1"],

        ["\xE6\x8A\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"],
        ["\x5A\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAC"],

        ["\xE6\x93\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],
        ["\x5B\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA3"],

        ["\xE6\x93\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],
        ["\x5B\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAF"],

        ["\xE6\x94\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],
        ["\x5B\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAC"],

        ["\xE6\x93\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],
        ["\x5B\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB6"],

        ["\xE6\x93\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],
        ["\x5B\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB4"],

        ["\xE6\x93\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],
        ["\x5B\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB2"],

        ["\xE6\x93\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],
        ["\x5B\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBA"],

        ["\xE6\x94\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],
        ["\x5B\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x80"],

        ["\xE6\x93\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],
        ["\x5B\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBD"],

        ["\xE6\x94\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],
        ["\x5B\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x98"],

        ["\xE6\x94\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],
        ["\x5B\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9C"],

        ["\xE6\x94\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],
        ["\x5B\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x85"],

        ["\xE6\x94\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],
        ["\x5B\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA4"],

        ["\xE6\x94\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],
        ["\x5B\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA3"],

        ["\xE6\x94\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],
        ["\x5B\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAB"],

        ["\xE6\x94\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],
        ["\x5B\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB4"],

        ["\xE6\x94\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],
        ["\x5B\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB5"],

        ["\xE6\x94\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],
        ["\x5B\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB7"],

        ["\xE6\x94\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],
        ["\x5B\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB6"],

        ["\xE6\x94\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],
        ["\x5B\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB8"],

        ["\xE7\x95\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],
        ["\x5B\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8B"],

        ["\xE6\x95\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],
        ["\x5B\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x88"],

        ["\xE6\x95\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x7F"],
        ["\x5B\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x96"],

        ["\xE6\x95\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x82"],
        ["\x5B\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x95"],

        ["\xE6\x95\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x80"],
        ["\x5B\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8D"],

        ["\xE6\x95\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x81"],
        ["\x5B\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x98"],

        ["\xE6\x95\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB1"],
        ["\x51\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9E"],

        ["\xE6\x95\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x83"],
        ["\x5B\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9D"],

        ["\xE6\x95\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x84"],
        ["\x5B\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB2"],

        ["\xE6\x95\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x85"],
        ["\x5B\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB8"],

        ["\xE6\x96\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x86"],
        ["\x5B\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x82"],

        ["\xE6\x96\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x87"],
        ["\x5B\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x83"],

        ["\xE8\xAE\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x88"],
        ["\x5B\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8A"],

        ["\xE6\x96\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x89"],
        ["\x5B\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9B"],

        ["\xE6\x96\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8A"],
        ["\x5B\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9F"],

        ["\xE6\x96\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8B"],
        ["\x5B\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAB"],

        ["\xE6\x96\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8C"],
        ["\x5B\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB7"],

        ["\xE6\x97\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8D"],
        ["\x5B\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x83"],

        ["\xE6\x97\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8E"],
        ["\x5B\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x86"],

        ["\xE6\x97\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x8F"],
        ["\x5B\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x81"],

        ["\xE6\x97\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x90"],
        ["\x5B\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x84"],

        ["\xE6\x97\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x91"],
        ["\x5B\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8C"],

        ["\xE6\x97\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x92"],
        ["\x5B\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x92"],

        ["\xE6\x97\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x65"],
        ["\x51\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x9B"],

        ["\xE6\x97\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x93"],
        ["\x5B\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x99"],

        ["\xE6\x97\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x95"],
        ["\x5B\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA0"],

        ["\xE6\x97\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x94"],
        ["\x5B\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA1"],

        ["\xE6\x97\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x96"],
        ["\x5B\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB1"],

        ["\xE6\x9D\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9A"],
        ["\x5B\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB2"],

        ["\xE6\x98\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8E"],
        ["\x52\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8A"],

        ["\xE6\x98\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9B"],
        ["\x5B\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x83"],

        ["\xE6\x97\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9C"],
        ["\x5B\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBB"],

        ["\xE6\x9D\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE0"],
        ["\x5B\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB3"],

        ["\xE6\x98\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9F"],
        ["\x5B\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB5"],

        ["\xE6\x98\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x93"],
        ["\x51\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB6"],

        ["\xE6\x98\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA2"],
        ["\x5B\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB4"],

        ["\xE6\x98\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA3"],
        ["\x5B\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9C"],

        ["\xE6\x99\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xEA"],
        ["\x51\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8F"],

        ["\xE6\x99\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA5"],
        ["\x5B\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x84"],

        ["\xE6\x99\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA6"],
        ["\x5B\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x89"],

        ["\xE6\x99\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x51"],
        ["\x52\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x81"],

        ["\xE6\x99\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xA9"],
        ["\x5B\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9E"],

        ["\xE6\x99\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAD"],
        ["\x5B\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9D"],

        ["\xE6\x99\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAA"],
        ["\x5B\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA4"],

        ["\xE6\x99\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xA0"],
        ["\x50\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA7"],

        ["\xE6\x99\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB2"],
        ["\x51\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA8"],

        ["\xE6\x99\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xCE"],
        ["\x4F\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9F"],

        ["\xE6\x99\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xAC"],
        ["\x5B\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA2"],

        ["\xE6\x99\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB0"],
        ["\x5B\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB0"],

        ["\xE6\x9A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB1"],
        ["\x5B\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x83"],

        ["\xE6\x9A\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB2"],
        ["\x5B\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x88"],

        ["\xE6\x9A\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xAB"],
        ["\x4F\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x8E"],

        ["\xE6\x9A\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xD1"],
        ["\x4E\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x89"],

        ["\xE6\x9A\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB3"],
        ["\x5B\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x84"],

        ["\xE6\x9A\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB5"],
        ["\x5B\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x98"],

        ["\xE6\x9A\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB7"],
        ["\x5B\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x9D"],

        ["\xE6\x9B\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBA"],
        ["\x5B\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x81"],

        ["\xE6\x9A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x43"],
        ["\x52\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB9"],

        ["\xE6\x9B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBC"],
        ["\x5B\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x89"],

        ["\xE6\x9A\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBD"],
        ["\x5B\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBE"],

        ["\xE6\x9A\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBE"],
        ["\x5B\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBC"],

        ["\xE6\x9B\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xB9"],
        ["\x5B\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x84"],

        ["\xE6\x9A\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xBF"],
        ["\x5B\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB8"],

        ["\xE6\x9B\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC0"],
        ["\x5B\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x96"],

        ["\xE6\x9B\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC1"],
        ["\x5B\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9A"],

        ["\xE6\x9B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCC"],
        ["\x51\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA0"],

        ["\xE6\x98\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\x9E"],
        ["\x5B\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBF"],

        ["\xE6\x9B\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC2"],
        ["\x5B\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA6"],

        ["\xE6\x9B\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC3"],
        ["\x5B\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA9"],

        ["\xE6\x9B\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC4"],
        ["\x5B\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB0"],

        ["\xE6\x9B\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC5"],
        ["\x5B\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB5"],

        ["\xE6\x9B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xC6"],
        ["\x5B\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB7"],

        ["\xE6\x9C\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xFD"],
        ["\x54\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8F"],

        ["\xE6\x9C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCA"],
        ["\x5B\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x96"],

        ["\xE6\x9C\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCB"],
        ["\x5B\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9E"],

        ["\xE6\x9C\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCD"],
        ["\x5B\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA6"],

        ["\xE6\x9C\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCE"],
        ["\x5B\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA7"],

        ["\xE9\x9C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCF"],
        ["\x5B\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB8"],

        ["\xE6\x9C\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD0"],
        ["\x5B\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAE"],

        ["\xE6\x9C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD1"],
        ["\x5B\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBF"],

        ["\xE6\x9C\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD2"],
        ["\x5B\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB6"],

        ["\xE6\x9D\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4F"],
        ["\x53\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x81"],

        ["\xE6\x9C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD4"],
        ["\x5B\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB8"],

        ["\xE6\x9C\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD3"],
        ["\x5B\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB7"],

        ["\xE6\x9D\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD5"],
        ["\x5B\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x86"],

        ["\xE6\x9D\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD6"],
        ["\x5B\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9E"],

        ["\xE6\x9D\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x80"],
        ["\x54\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA0"],

        ["\xE6\x9D\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"],
        ["\x5B\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x99"],

        ["\xE6\x9D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x91"],
        ["\x52\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA3"],

        ["\xE6\x9D\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xD9"],
        ["\x5B\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA4"],

        ["\xE6\x9E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDA"],
        ["\x5B\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x89"],

        ["\xE6\x9D\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDC"],
        ["\x5B\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB0"],

        ["\xE6\x9E\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDD"],
        ["\x5B\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA9"],

        ["\xE6\x9D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xDF"],
        ["\x54\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBC"],

        ["\xE6\x9D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDE"],
        ["\x5B\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAA"],

        ["\xE6\x9E\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF2"],
        ["\x54\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8C"],

        ["\xE6\x9E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDF"],
        ["\x5B\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8B"],

        ["\xE6\x9E\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE1"],
        ["\x5B\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA6"],

        ["\xE6\x9E\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE2"],
        ["\x5B\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA1"],

        ["\xE6\x9E\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xDB"],
        ["\x5B\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x85"],

        ["\xE6\x9E\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE4"],
        ["\x5B\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB7"],

        ["\xE6\x9F\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE5"],
        ["\x5B\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAF"],

        ["\xE6\x9E\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE6"],
        ["\x5B\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB4"],

        ["\xE6\x9F\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE7"],
        ["\x5B\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAC"],

        ["\xE6\x9E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC9"],
        ["\x54\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB3"],

        ["\xE6\x9F\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE8"],
        ["\x5B\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA9"],

        ["\xE6\x9E\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xE9"],
        ["\x5B\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB8"],

        ["\xE6\x9F\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xEB"],
        ["\x5B\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA4"],

        ["\xE6\x9F\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF3"],
        ["\x54\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9E"],

        ["\xE6\x9F\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xED"],
        ["\x5B\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9D"],

        ["\xE6\x9F\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xEE"],
        ["\x5B\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA2"],

        ["\xE6\x9F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xEF"],
        ["\x5B\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAE"],

        ["\xE6\x9E\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF2"],
        ["\x5B\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB9"],

        ["\xE6\x9F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF1"],
        ["\x5B\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8E"],

        ["\xE6\x9F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF4"],
        ["\x5B\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x86"],

        ["\xE6\x9F\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xEA"],
        ["\x5B\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA7"],

        ["\xE6\xAA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\x55"],
        ["\x4D\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9C"],

        ["\xE6\xA0\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF5"],
        ["\x5B\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9E"],

        ["\xE6\xA1\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF6"],
        ["\x5B\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x86"],

        ["\xE6\xA0\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xDE"],
        ["\x52\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA9"],

        ["\xE6\xA1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF8"],
        ["\x5B\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x80"],

        ["\xE6\xA1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xF7"],
        ["\x5B\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8D"],

        ["\xE6\xA0\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFA"],
        ["\x5B\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB2"],

        ["\xE6\xA1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFB"],
        ["\x5B\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8E"],

        ["\xE6\xA2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x61"],
        ["\x53\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB3"],

        ["\xE6\xA0\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xE2"],
        ["\x52\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAB"],

        ["\xE6\xA1\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFD"],
        ["\x5B\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x99"],

        ["\xE6\xA1\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFC"],
        ["\x5B\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA3"],

        ["\xE6\xA1\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x41"],
        ["\x5C\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB7"],

        ["\xE6\xA1\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x42"],
        ["\x5C\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBF"],

        ["\xE6\xA2\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x43"],
        ["\x5C\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9F"],

        ["\xE6\xA2\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x45"],
        ["\x5C\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8F"],

        ["\xE6\xA2\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x46"],
        ["\x5C\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAD"],

        ["\xE6\xA2\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x47"],
        ["\x5C\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x94"],

        ["\xE6\xA2\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x92"],
        ["\x4E\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9D"],

        ["\xE6\xA2\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBC"],
        ["\x53\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9B"],

        ["\xE6\xA2\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x48"],
        ["\x5C\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x83"],

        ["\xE6\xAA\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x5D"],
        ["\x54\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAE"],

        ["\xE6\xA2\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4A"],
        ["\x5C\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB9"],

        ["\xE6\xA1\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4B"],
        ["\x5C\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB4"],

        ["\xE6\xA2\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4C"],
        ["\x5C\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB5"],

        ["\xE6\xA2\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC6"],
        ["\x52\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA0"],

        ["\xE6\xA2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4D"],
        ["\x5C\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBA"],

        ["\xE6\xA4\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4E"],
        ["\x5C\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8F"],

        ["\xE6\xA2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xFE"],
        ["\x5B\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8D"],

        ["\xE6\xA1\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x44"],
        ["\x5C\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBE"],

        ["\xE6\xA4\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x4F"],
        ["\x5C\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x81"],

        ["\xE6\xA3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x50"],
        ["\x5C\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8A"],

        ["\xE6\xA4\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x51"],
        ["\x5C\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x88"],

        ["\xE6\xA3\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x52"],
        ["\x5C\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x98"],

        ["\xE6\xA4\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x61"],
        ["\x5C\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA2"],

        ["\xE6\xA4\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x53"],
        ["\x5C\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA6"],

        ["\xE6\xA3\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x54"],
        ["\x5C\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA1"],

        ["\xE6\xA4\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x55"],
        ["\x5C\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8C"],

        ["\xE6\xA3\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x56"],
        ["\x5C\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8D"],

        ["\xE6\xA3\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x57"],
        ["\x5C\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x94"],

        ["\xE6\xA3\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x58"],
        ["\x5C\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA7"],

        ["\xE6\xA3\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x59"],
        ["\x5C\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x95"],

        ["\xE6\xA4\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x69"],
        ["\x5C\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB6"],

        ["\xE6\xA4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5A"],
        ["\x5C\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x92"],

        ["\xE6\xA4\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5C"],
        ["\x5C\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x84"],

        ["\xE6\xA3\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC2"],
        ["\x54\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x97"],

        ["\xE6\xA3\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5D"],
        ["\x5C\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA3"],

        ["\xE6\xA4\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xFA"],
        ["\x53\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA5"],

        ["\xE6\xA3\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x94"],
        ["\x54\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB9"],

        ["\xE6\xA3\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5E"],
        ["\x5C\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA0"],

        ["\xE6\xA3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x5B"],
        ["\x5C\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAF"],

        ["\xE6\xA4\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x65"],
        ["\x5C\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA8"],

        ["\xE6\xA4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x62"],
        ["\x5C\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xAA"],

        ["\xE6\xA4\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x70"],
        ["\x53\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9A"],

        ["\xE6\xA4\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x64"],
        ["\x5C\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA3"],

        ["\xE6\xA4\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x63"],
        ["\x5C\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA1"],

        ["\xE6\xA3\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x60"],
        ["\x5C\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x86"],

        ["\xE6\xA5\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x67"],
        ["\x5C\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB9"],

        ["\xE6\xA5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x68"],
        ["\x5C\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB7"],

        ["\xE6\xA5\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE2"],
        ["\x54\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9C"],

        ["\xE6\xA5\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6A"],
        ["\x5C\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB8"],

        ["\xE6\xA5\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA2"],
        ["\x54\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAB"],

        ["\xE6\xA5\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6B"],
        ["\x5C\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x94"],

        ["\xE6\xA5\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x74"],
        ["\x5C\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBE"],

        ["\xE6\xA5\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xEF"],
        ["\x53\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAE"],

        ["\xE6\xA4\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xED"],
        ["\x52\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB9"],

        ["\xE6\xA5\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6D"],
        ["\x5C\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB4"],

        ["\xE6\xA4\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6F"],
        ["\x5C\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBD"],

        ["\xE6\xA5\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x70"],
        ["\x5C\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x99"],

        ["\xE6\xA4\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x71"],
        ["\x5C\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB0"],

        ["\xE6\xA5\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x7C"],
        ["\x52\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA1"],

        ["\xE6\xA5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x72"],
        ["\x5C\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9E"],

        ["\xE6\xA5\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x73"],
        ["\x5C\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9D"],

        ["\xE6\xA6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x75"],
        ["\x5C\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x81"],

        ["\xE6\xA5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x6C"],
        ["\x5C\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAA"],

        ["\xE6\xA6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x76"],
        ["\x5C\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB2"],

        ["\xE6\xA6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4A"],
        ["\x51\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xAE"],

        ["\xE6\xA7\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x8C"],
        ["\x54\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x90"],

        ["\xE6\xA6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x77"],
        ["\x5C\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBF"],

        ["\xE6\xA7\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7A"],
        ["\x5C\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x81"],

        ["\xE6\xA7\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7B"],
        ["\x5C\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x93"],

        ["\xE6\xA6\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7C"],
        ["\x5C\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBE"],

        ["\xE6\xA7\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7D"],
        ["\x5C\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8E"],

        ["\xE5\xAF\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7E"],
        ["\x5C\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA8"],

        ["\xE6\xA7\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x7F"],
        ["\x5C\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8A"],

        ["\xE6\xA7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x81"],
        ["\x5C\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9D"],

        ["\xE6\xA6\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x82"],
        ["\x5C\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBB"],

        ["\xE6\xA7\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x83"],
        ["\x5C\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x83"],

        ["\xE6\xA6\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8D"],
        ["\x53\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA7"],

        ["\xE6\xA8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x88"],
        ["\x5C\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAE"],

        ["\xE6\xA6\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x76"],
        ["\x54\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x91"],

        ["\xE6\xA6\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x84"],
        ["\x5C\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA0"],

        ["\xE6\xA6\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x85"],
        ["\x5C\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9C"],

        ["\xE6\xA6\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x86"],
        ["\x5C\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x95"],

        ["\xE6\xA6\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB2"],
        ["\x53\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB4"],

        ["\xE6\xA7\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x87"],
        ["\x5C\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9E"],

        ["\xE6\xA7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x89"],
        ["\x5C\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA8"],

        ["\xE6\xA8\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8A"],
        ["\x5C\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x82"],

        ["\xE6\xA8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8B"],
        ["\x5C\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9B"],

        ["\xE6\xA7\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8C"],
        ["\x5C\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBF"],

        ["\xE6\xAC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC1"],
        ["\x5C\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8A"],

        ["\xE6\xA7\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8D"],
        ["\x5C\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB9"],

        ["\xE6\xA7\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8E"],
        ["\x5C\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB2"],

        ["\xE6\xA7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x8F"],
        ["\x5C\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA7"],

        ["\xE6\xA8\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xBB"],
        ["\x53\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x85"],

        ["\xE6\xA6\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x80"],
        ["\x5C\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB1"],

        ["\xE6\xA8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x91"],
        ["\x5C\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9E"],

        ["\xE6\xA7\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x92"],
        ["\x5C\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAD"],

        ["\xE6\xA8\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x93"],
        ["\x5C\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x94"],

        ["\xE6\xA7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x94"],
        ["\x5C\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAB"],

        ["\xE6\xA8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x95"],
        ["\x5C\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8A"],

        ["\xE6\xA8\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x97"],
        ["\x5C\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x92"],

        ["\xE6\xAB\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB7"],
        ["\x5C\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x81"],

        ["\xE6\xA8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x98"],
        ["\x5C\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA3"],

        ["\xE6\xA8\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x99"],
        ["\x5C\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x93"],

        ["\xE6\xA9\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x9C"],
        ["\x5C\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x84"],

        ["\xE6\xA8\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x9D"],
        ["\x5C\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8C"],

        ["\xE6\xA9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA8"],
        ["\x5C\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB2"],

        ["\xE6\xA8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x9F"],
        ["\x5C\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB6"],

        ["\xE6\xA9\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA0"],
        ["\x5C\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB8"],

        ["\xE6\xA9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA1"],
        ["\x5C\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x87"],

        ["\xE6\xA9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA2"],
        ["\x5C\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA2"],

        ["\xE6\xA9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA3"],
        ["\x5C\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x99"],

        ["\xE6\xA9\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA4"],
        ["\x5C\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA6"],

        ["\xE6\xA9\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA5"],
        ["\x5C\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x88"],

        ["\xE6\xA8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xA7"],
        ["\x5C\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB8"],

        ["\xE6\xA8\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x96"],
        ["\x5C\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA2"],

        ["\xE6\xAA\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAA"],
        ["\x5C\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x90"],

        ["\xE6\xAA\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAB"],
        ["\x5C\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8D"],

        ["\xE6\xAA\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\x9E"],
        ["\x5C\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA0"],

        ["\xE6\xAA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAC"],
        ["\x5C\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x84"],

        ["\xE6\xAA\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAD"],
        ["\x5C\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA2"],

        ["\xE6\xAA\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xAE"],
        ["\x5C\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA3"],

        ["\xE6\xAA\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB0"],
        ["\x5C\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x97"],

        ["\xE8\x98\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBE"],
        ["\x5C\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x97"],

        ["\xE6\xAA\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB3"],
        ["\x5C\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xBB"],

        ["\xE6\xAB\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x8B"],
        ["\x52\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x83"],

        ["\xE6\xAB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB4"],
        ["\x5C\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x82"],

        ["\xE6\xAA\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB5"],
        ["\x5C\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB8"],

        ["\xE6\xAA\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB6"],
        ["\x5C\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB3"],

        ["\xE6\xAA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB1"],
        ["\x5C\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAC"],

        ["\xE6\xAB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB8"],
        ["\x5C\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9E"],

        ["\xE6\xAB\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBA"],
        ["\x5C\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x91"],

        ["\xE6\xAB\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x62"],
        ["\x53\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9F"],

        ["\xE6\xAA\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xB2"],
        ["\x5C\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAA"],

        ["\xE6\xAB\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBB"],
        ["\x5C\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9A"],

        ["\xE6\xAB\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBF"],
        ["\x5C\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xAA"],

        ["\xE6\xAB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xEE"],
        ["\x52\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBB"],

        ["\xE6\xAC\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC0"],
        ["\x5C\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x85"],

        ["\xE8\x98\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xBD"],
        ["\x5C\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x96"],

        ["\xE6\xAB\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC2"],
        ["\x5C\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBA"],

        ["\xE6\xAC\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC3"],
        ["\x5C\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x92"],

        ["\xE6\xAC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC4"],
        ["\x5C\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x96"],

        ["\xE9\xAC\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x86"],
        ["\x67\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB1"],

        ["\xE6\xAC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC5"],
        ["\x5C\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9F"],

        ["\xE6\xAC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC6"],
        ["\x5C\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB8"],

        ["\xE6\xAC\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC7"],
        ["\x5C\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB7"],

        ["\xE7\x9B\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC9"],
        ["\x5C\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9C"],

        ["\xE6\xAC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xC8"],
        ["\x5C\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB9"],

        ["\xE9\xA3\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCA"],
        ["\x5C\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAE"],

        ["\xE6\xAD\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCB"],
        ["\x5C\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x87"],

        ["\xE6\xAD\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCC"],
        ["\x5C\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x83"],

        ["\xE6\xAD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCD"],
        ["\x5C\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x89"],

        ["\xE6\xAD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCE"],
        ["\x5C\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x90"],

        ["\xE6\xAD\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xCF"],
        ["\x5C\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x99"],

        ["\xE6\xAD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD0"],
        ["\x5C\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x94"],

        ["\xE6\xAD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD1"],
        ["\x5C\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9B"],

        ["\xE6\xAD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD2"],
        ["\x5C\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9F"],

        ["\xE6\xAD\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD3"],
        ["\x5C\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA1"],

        ["\xE6\xAD\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD4"],
        ["\x5C\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB8"],

        ["\xE6\xAD\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD5"],
        ["\x5C\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB9"],

        ["\xE6\xAD\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD6"],
        ["\x5C\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBF"],

        ["\xE6\xAE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD7"],
        ["\x5C\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x80"],

        ["\xE6\xAE\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD8"],
        ["\x5C\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x84"],

        ["\xE6\xAE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xD9"],
        ["\x5C\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x83"],

        ["\xE6\xAE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDA"],
        ["\x5C\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8D"],

        ["\xE6\xAE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDB"],
        ["\x5C\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x98"],

        ["\xE6\xAE\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDC"],
        ["\x5C\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x95"],

        ["\xE6\xAE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDD"],
        ["\x5C\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x9E"],

        ["\xE6\xAE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDE"],
        ["\x5C\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xA4"],

        ["\xE6\xAE\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xDF"],
        ["\x5C\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAA"],

        ["\xE6\xAE\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE0"],
        ["\x5C\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAB"],

        ["\xE6\xAE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE1"],
        ["\x5C\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAF"],

        ["\xE6\xAE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE3"],
        ["\x5C\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB2"],

        ["\xE6\xAE\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE2"],
        ["\x5C\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB1"],

        ["\xE6\xAE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE4"],
        ["\x5C\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB3"],

        ["\xE6\xAE\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE5"],
        ["\x5C\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB7"],

        ["\xE6\xAE\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE6"],
        ["\x5C\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBC"],

        ["\xE6\xAF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE7"],
        ["\x5C\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x86"],

        ["\xE6\xAF\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE8"],
        ["\x5C\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8B"],

        ["\xE6\xAF\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xE9"],
        ["\x5C\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x93"],

        ["\xE6\xAF\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xEB"],
        ["\x5C\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9F"],

        ["\xE6\xAF\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xEC"],
        ["\x5C\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAC"],

        ["\xE6\xAF\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xED"],
        ["\x5C\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAB"],

        ["\xE6\xAF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xEE"],
        ["\x5C\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB3"],

        ["\xE6\xAF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xEF"],
        ["\x5C\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAF"],

        ["\xE9\xBA\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x51"],
        ["\x68\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBE"],

        ["\xE6\xB0\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF0"],
        ["\x5C\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x88"],

        ["\xE6\xB0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF1"],
        ["\x5C\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x93"],

        ["\xE6\xB0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF2"],
        ["\x5C\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x94"],

        ["\xE6\xB0\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF3"],
        ["\x5C\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x9B"],

        ["\xE6\xB0\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF4"],
        ["\x5C\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA4"],

        ["\xE6\xB0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF5"],
        ["\x5C\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA3"],

        ["\xE6\xB1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF7"],
        ["\x5C\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9E"],

        ["\xE6\xB1\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xF8"],
        ["\x5C\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x95"],

        ["\xE6\xB1\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xFA"],
        ["\x5C\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA2"],

        ["\xE6\xB1\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB4"],
        ["\x52\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAA"],

        ["\xE6\xB2\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xFB"],
        ["\x5C\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x82"],

        ["\xE6\xB2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C\xFC"],
        ["\x5C\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8D"],

        ["\xE6\xB2\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x41"],
        ["\x5D\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9A"],

        ["\xE6\xB2\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x42"],
        ["\x5D\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x81"],

        ["\xE6\xB2\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x43"],
        ["\x5D\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9B"],

        ["\xE6\xB1\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x44"],
        ["\x5D\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBE"],

        ["\xE6\xB1\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x45"],
        ["\x5D\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA8"],

        ["\xE6\xB1\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x46"],
        ["\x5D\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB3"],

        ["\xE6\xB2\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x47"],
        ["\x5D\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x92"],

        ["\xE6\xB2\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x48"],
        ["\x5D\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x90"],

        ["\xE6\xB3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x49"],
        ["\x5D\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x84"],

        ["\xE6\xB3\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4A"],
        ["\x5D\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB1"],

        ["\xE6\xB3\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD7"],
        ["\x54\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x93"],

        ["\xE6\xB2\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4B"],
        ["\x5D\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBD"],

        ["\xE6\xB3\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xC6"],
        ["\x55\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x97"],

        ["\xE6\xB3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4C"],
        ["\x5D\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x85"],

        ["\xE6\xB3\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4F"],
        ["\x5D\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9D"],

        ["\xE6\xB2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x4D"],
        ["\x5D\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAE"],

        ["\xE6\xB2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x50"],
        ["\x5D\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB1"],

        ["\xE6\xB2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x51"],
        ["\x5D\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBE"],

        ["\xE6\xB2\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x52"],
        ["\x5D\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBA"],

        ["\xE6\xB3\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x53"],
        ["\x5D\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9B"],

        ["\xE6\xB3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x54"],
        ["\x5D\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAF"],

        ["\xE6\xB3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x55"],
        ["\x5D\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x99"],

        ["\xE6\xB3\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x56"],
        ["\x5D\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAA"],

        ["\xE6\xB4\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x57"],
        ["\x5D\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9F"],

        ["\xE8\xA1\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],
        ["\x63\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8D"],

        ["\xE6\xB4\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x59"],
        ["\x5D\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB6"],

        ["\xE6\xB4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5A"],
        ["\x5D\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAB"],

        ["\xE6\xB4\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5B"],
        ["\x5D\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBD"],

        ["\xE6\xB4\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xBC"],
        ["\x50\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB8"],

        ["\xE6\xB4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB6"],
        ["\x52\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x99"],

        ["\xE6\xB4\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAC"],
        ["\x52\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB5"],

        ["\xE6\xB4\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5C"],
        ["\x5D\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB3"],

        ["\xE6\xB4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5D"],
        ["\x5D\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x92"],

        ["\xE6\xB4\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5E"],
        ["\x5D\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8C"],

        ["\xE6\xB5\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x5F"],
        ["\x5D\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA3"],

        ["\xE6\xB6\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x61"],
        ["\x5D\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x93"],

        ["\xE6\xB5\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x63"],
        ["\x5D\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA4"],

        ["\xE6\xB5\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x64"],
        ["\x5D\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9A"],

        ["\xE6\xB5\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x65"],
        ["\x5D\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB9"],

        ["\xE6\xB5\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x66"],
        ["\x5D\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x99"],

        ["\xE6\xB6\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x67"],
        ["\x5D\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8E"],

        ["\xE6\xB6\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x68"],
        ["\x5D\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x95"],

        ["\xE6\xBF\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD2"],
        ["\x51\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA4"],

        ["\xE6\xB6\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6A"],
        ["\x5D\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x85"],

        ["\xE6\xB7\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6C"],
        ["\x5D\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB9"],

        ["\xE6\xB8\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x64"],
        ["\x51\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x95"],

        ["\xE6\xB8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6D"],
        ["\x5D\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8A"],

        ["\xE6\xB6\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6F"],
        ["\x5D\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB5"],

        ["\xE6\xB7\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x71"],
        ["\x5D\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x87"],

        ["\xE6\xB7\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x70"],
        ["\x5D\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA6"],

        ["\xE6\xB6\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x73"],
        ["\x5D\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB8"],

        ["\xE6\xB7\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x75"],
        ["\x5D\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x86"],

        ["\xE6\xB7\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x76"],
        ["\x5D\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAC"],

        ["\xE6\xB7\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x77"],
        ["\x5D\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9E"],

        ["\xE6\xB7\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x78"],
        ["\x5D\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8C"],

        ["\xE6\xB7\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x79"],
        ["\x5D\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA8"],

        ["\xE6\xB7\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x7B"],
        ["\x5D\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x92"],

        ["\xE6\xB7\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x7C"],
        ["\x5D\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x85"],

        ["\xE6\xB7\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x7D"],
        ["\x5D\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBA"],

        ["\xE6\xB7\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x7E"],
        ["\x5D\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x99"],

        ["\xE6\xB7\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x81"],
        ["\x5D\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA4"],

        ["\xE6\xB7\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x82"],
        ["\x5D\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x95"],

        ["\xE6\xB7\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x83"],
        ["\x5D\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAA"],

        ["\xE6\xB7\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x84"],
        ["\x5D\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAE"],

        ["\xE6\xB8\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x85"],
        ["\x5D\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAD"],

        ["\xE6\xB9\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x86"],
        ["\x5D\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAE"],

        ["\xE6\xB8\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x6E"],
        ["\x5D\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAE"],

        ["\xE6\xB8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x87"],
        ["\x5D\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x99"],

        ["\xE6\xB9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x88"],
        ["\x5D\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB2"],

        ["\xE6\xB9\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x89"],
        ["\x5D\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9F"],

        ["\xE6\xB8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x8B"],
        ["\x5D\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBE"],

        ["\xE6\xB8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x8C"],
        ["\x5D\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA3"],

        ["\xE6\xB9\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x8D"],
        ["\x5D\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAB"],

        ["\xE6\xB8\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x8F"],
        ["\x5D\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAB"],

        ["\xE6\xB9\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x90"],
        ["\x5D\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB6"],

        ["\xE6\xB9\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x91"],
        ["\x5D\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8D"],

        ["\xE6\xB8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x92"],
        ["\x5D\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9F"],

        ["\xE6\xB9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x94"],
        ["\x5D\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x83"],

        ["\xE6\xB8\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x96"],
        ["\x5D\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBA"],

        ["\xE6\xB9\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x97"],
        ["\x5D\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8E"],

        ["\xE6\xB8\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x98"],
        ["\x5D\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA4"],

        ["\xE6\xBB\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB4"],
        ["\x5D\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBF"],

        ["\xE6\xB8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x99"],
        ["\x5D\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9D"],

        ["\xE6\xB8\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9A"],
        ["\x5D\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB8"],

        ["\xE6\xBA\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9B"],
        ["\x5D\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x82"],

        ["\xE6\xBA\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9C"],
        ["\x5D\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAA"],

        ["\xE6\xBA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9D"],
        ["\x5D\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x98"],

        ["\xE6\xBB\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xA9"],
        ["\x52\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x89"],

        ["\xE6\xBA\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9E"],
        ["\x5D\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB7"],

        ["\xE6\xBB\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4A"],
        ["\x52\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x93"],

        ["\xE6\xBA\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\x9F"],
        ["\x5D\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBD"],

        ["\xE6\xBA\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA0"],
        ["\x5D\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAF"],

        ["\xE6\xBB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA1"],
        ["\x5D\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x84"],

        ["\xE6\xBA\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA2"],
        ["\x5D\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB2"],

        ["\xE6\xBB\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA3"],
        ["\x5D\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x94"],

        ["\xE6\xBB\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA4"],
        ["\x5D\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x95"],

        ["\xE6\xBA\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA5"],
        ["\x5D\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8F"],

        ["\xE6\xBA\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x76"],
        ["\x53\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA5"],

        ["\xE6\xBB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA7"],
        ["\x5D\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x82"],

        ["\xE6\xBA\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA8"],
        ["\x5D\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9F"],

        ["\xE6\xBD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xA9"],
        ["\x5D\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x81"],

        ["\xE6\xBC\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x75"],
        ["\x55\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x91"],

        ["\xE7\x81\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xEA"],
        ["\x53\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8C"],

        ["\xE6\xBB\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAB"],
        ["\x5D\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAC"],

        ["\xE6\xBB\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAC"],
        ["\x5D\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB8"],

        ["\xE6\xBB\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAD"],
        ["\x5D\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBE"],

        ["\xE6\xBC\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAE"],
        ["\x5D\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBF"],

        ["\xE6\xBB\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xAF"],
        ["\x5D\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB2"],

        ["\xE6\xBC\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB0"],
        ["\x5D\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB1"],

        ["\xE6\xBB\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB1"],
        ["\x5D\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAF"],

        ["\xE6\xBC\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB2"],
        ["\x5D\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB2"],

        ["\xE6\xBB\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB3"],
        ["\x5D\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8C"],

        ["\xE6\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB5"],
        ["\x5D\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBE"],

        ["\xE6\xBC\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB6"],
        ["\x5D\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x93"],

        ["\xE6\xBB\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB7"],
        ["\x5D\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB7"],

        ["\xE6\xBE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB8"],
        ["\x5D\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x86"],

        ["\xE6\xBD\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xB9"],
        ["\x5D\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBA"],

        ["\xE6\xBD\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBA"],
        ["\x5D\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB8"],

        ["\xE6\xBE\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA0"],
        ["\x55\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x81"],

        ["\xE6\xBE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBB"],
        ["\x5D\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x80"],

        ["\xE6\xBD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBC"],
        ["\x5D\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAF"],

        ["\xE6\xBD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBD"],
        ["\x5D\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9B"],

        ["\xE6\xBF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE2"],
        ["\x5D\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB3"],

        ["\xE6\xBD\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBE"],
        ["\x5D\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAD"],

        ["\xE6\xBE\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC0"],
        ["\x5D\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x82"],

        ["\xE6\xBD\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC2"],
        ["\x5D\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBC"],

        ["\xE6\xBD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC3"],
        ["\x5D\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x98"],

        ["\xE6\xBE\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC5"],
        ["\x5D\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8E"],

        ["\xE6\xBE\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC6"],
        ["\x5D\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x91"],

        ["\xE6\xBF\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCF"],
        ["\x5D\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x82"],

        ["\xE6\xBD\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC7"],
        ["\x5D\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA6"],

        ["\xE6\xBE\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC8"],
        ["\x5D\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB3"],

        ["\xE6\xBE\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC9"],
        ["\x5D\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA3"],

        ["\xE6\xBE\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCB"],
        ["\x5D\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA1"],

        ["\xE6\xBE\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x4B"],
        ["\x4E\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA4"],

        ["\xE6\xBE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCC"],
        ["\x5D\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB9"],

        ["\xE6\xBF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xC4"],
        ["\x5D\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x86"],

        ["\xE6\xBE\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCE"],
        ["\x5D\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAA"],

        ["\xE6\xBF\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD0"],
        ["\x5D\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9F"],

        ["\xE6\xBF\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD1"],
        ["\x5D\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x95"],

        ["\xE6\xBF\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD2"],
        ["\x5D\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAC"],

        ["\xE6\xBF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD4"],
        ["\x5D\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x94"],

        ["\xE6\xBF\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD3"],
        ["\x5D\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x98"],

        ["\xE6\xBF\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x55"],
        ["\x50\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB1"],

        ["\xE6\xBF\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD6"],
        ["\x5D\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAE"],

        ["\xE6\xBF\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xCD"],
        ["\x5D\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9B"],

        ["\xE7\x80\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xD9"],
        ["\x5D\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x89"],

        ["\xE7\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDA"],
        ["\x5D\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8B"],

        ["\xE6\xBF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDB"],
        ["\x5D\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBA"],

        ["\xE7\x80\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDC"],
        ["\x5D\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x91"],

        ["\xE7\x80\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDD"],
        ["\x5D\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x81"],

        ["\xE7\x80\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDE"],
        ["\x5D\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8F"],

        ["\xE6\xBF\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x87"],
        ["\x51\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBE"],

        ["\xE7\x80\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xDF"],
        ["\x5D\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9B"],

        ["\xE7\x80\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE0"],
        ["\x5D\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9A"],

        ["\xE6\xBD\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xBF"],
        ["\x5D\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB4"],

        ["\xE7\x80\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xB0"],
        ["\x52\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9D"],

        ["\xE7\x80\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE4"],
        ["\x5D\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x98"],

        ["\xE7\x80\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE1"],
        ["\x5D\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9F"],

        ["\xE7\x80\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE5"],
        ["\x5D\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB0"],

        ["\xE7\x80\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE6"],
        ["\x5D\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBE"],

        ["\xE7\x80\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE7"],
        ["\x5D\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB2"],

        ["\xE7\x81\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE8"],
        ["\x5D\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x91"],

        ["\xE7\x81\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xE9"],
        ["\x5D\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA3"],

        ["\xE7\x82\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEB"],
        ["\x5D\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x99"],

        ["\xE7\x82\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xEE"],
        ["\x4F\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x92"],

        ["\xE7\x82\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEC"],
        ["\x5D\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAF"],

        ["\xE7\x83\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF7"],
        ["\x5D\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB1"],

        ["\xE7\x82\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEE"],
        ["\x5D\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAC"],

        ["\xE7\x82\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xEF"],
        ["\x5D\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB8"],

        ["\xE7\x82\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xCD"],
        ["\x52\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB3"],

        ["\xE7\x82\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF0"],
        ["\x5D\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAE"],

        ["\xE7\x83\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF1"],
        ["\x5D\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9F"],

        ["\xE7\x83\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF2"],
        ["\x5D\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8B"],

        ["\xE7\x83\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x8C"],
        ["\x53\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9D"],

        ["\xE7\x83\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF3"],
        ["\x5D\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x99"],

        ["\xE7\x84\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF4"],
        ["\x5D\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x89"],

        ["\xE7\x83\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF8"],
        ["\x5D\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xBD"],

        ["\xE7\x84\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xF9"],
        ["\x5D\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9C"],

        ["\xE7\x84\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xFA"],
        ["\x5D\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x99"],

        ["\xE7\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x57"],
        ["\x53\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA5"],

        ["\xE7\x85\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x85"],
        ["\x68\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x95"],

        ["\xE7\x86\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x45"],
        ["\x5E\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x88"],

        ["\xE7\x85\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D\xFE"],
        ["\x5D\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA6"],

        ["\xE7\x85\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x41"],
        ["\x5E\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA2"],

        ["\xE7\x85\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x42"],
        ["\x5E\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8C"],

        ["\xE7\x85\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x43"],
        ["\x5E\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x96"],

        ["\xE7\x85\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x44"],
        ["\x5E\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAC"],

        ["\xE7\x86\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x46"],
        ["\x5E\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8F"],

        ["\xE7\x87\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],
        ["\x5E\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBB"],

        ["\xE7\x86\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x47"],
        ["\x5E\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x84"],

        ["\xE7\x86\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x48"],
        ["\x5E\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x95"],

        ["\xE7\x86\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xBB"],
        ["\x54\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA8"],

        ["\xE7\x86\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],
        ["\x5E\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAC"],

        ["\xE7\x87\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x52"],
        ["\x5E\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x97"],

        ["\xE7\x86\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],
        ["\x5E\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB9"],

        ["\xE7\x86\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],
        ["\x5E\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xBE"],

        ["\xE7\x87\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],
        ["\x5E\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x92"],

        ["\xE7\x87\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],
        ["\x5E\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x89"],

        ["\xE7\x87\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x51"],
        ["\x5E\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x94"],

        ["\xE7\x87\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x53"],
        ["\x5E\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x8E"],

        ["\xE7\x87\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x55"],
        ["\x5E\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA0"],

        ["\xE7\x87\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x56"],
        ["\x5E\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAC"],

        ["\xE7\x87\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],
        ["\x5E\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA7"],

        ["\xE7\x87\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x54"],
        ["\x5E\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB5"],

        ["\xE7\x87\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x58"],
        ["\x5E\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBC"],

        ["\xE7\x87\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],
        ["\x5E\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB9"],

        ["\xE7\x87\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],
        ["\x5E\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBF"],

        ["\xE7\x88\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],
        ["\x5E\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x8D"],

        ["\xE7\x88\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],
        ["\x5E\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x90"],

        ["\xE7\x88\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7C"],
        ["\x53\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x9B"],

        ["\xE7\x88\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],
        ["\x5E\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xA8"],

        ["\xE7\x88\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],
        ["\x5E\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAD"],

        ["\xE7\x88\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],
        ["\x5E\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAC"],

        ["\xE7\x88\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],
        ["\x5E\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB0"],

        ["\xE7\x88\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],
        ["\x5E\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB2"],

        ["\xE7\x88\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],
        ["\x5E\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBB"],

        ["\xE7\x88\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],
        ["\x5E\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBC"],

        ["\xE7\x88\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],
        ["\x5E\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBF"],

        ["\xE7\x89\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],
        ["\x5E\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x80"],

        ["\xE7\x89\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],
        ["\x5E\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x86"],

        ["\xE7\x89\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],
        ["\x5E\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8B"],

        ["\xE7\x89\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],
        ["\x5E\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x98"],

        ["\xE7\x89\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],
        ["\x5E\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB4"],

        ["\xE7\x89\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],
        ["\x5E\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBE"],

        ["\xE7\x8A\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],
        ["\x5E\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x82"],

        ["\xE7\x8A\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],
        ["\x5E\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x81"],

        ["\xE7\x8A\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],
        ["\x5E\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x87"],

        ["\xE7\x8A\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],
        ["\x5E\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x92"],

        ["\xE7\x8A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],
        ["\x5E\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x96"],

        ["\xE7\x8A\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],
        ["\x5E\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA2"],

        ["\xE7\x8A\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],
        ["\x5E\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA7"],

        ["\xE7\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],
        ["\x5E\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB9"],

        ["\xE7\x8A\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],
        ["\x5E\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB2"],

        ["\xE7\x8B\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],
        ["\x5E\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x83"],

        ["\xE7\x8B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],
        ["\x5E\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x86"],

        ["\xE7\x8B\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],
        ["\x5E\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x84"],

        ["\xE7\x8B\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],
        ["\x5E\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x8E"],

        ["\xE7\x8B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],
        ["\x5E\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x92"],

        ["\xE7\x8B\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],
        ["\x5E\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA2"],

        ["\xE7\x8B\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],
        ["\x5E\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA0"],

        ["\xE7\x8B\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],
        ["\x5E\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA1"],

        ["\xE7\x8B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x7F"],
        ["\x5E\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB9"],

        ["\xE7\x8B\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x80"],
        ["\x5E\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB7"],

        ["\xE5\x80\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x56\xA1"],
        ["\x56\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8F"],

        ["\xE7\x8C\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x81"],
        ["\x5E\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x97"],

        ["\xE7\x8C\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x82"],
        ["\x5E\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x8A"],

        ["\xE7\x8C\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x83"],
        ["\x5E\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9C"],

        ["\xE7\x8C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x84"],
        ["\x5E\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x96"],

        ["\xE7\x8C\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x85"],
        ["\x5E\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9D"],

        ["\xE7\x8C\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x87"],
        ["\x5E\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB4"],

        ["\xE7\x8C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x89"],
        ["\x5E\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAF"],

        ["\xE7\x8C\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x88"],
        ["\x5E\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA9"],

        ["\xE7\x8C\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8B"],
        ["\x5E\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA5"],

        ["\xE7\x8C\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8C"],
        ["\x5E\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBE"],

        ["\xE7\x8D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8E"],
        ["\x5E\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8E"],

        ["\xE7\x8D\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8D"],
        ["\x5E\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8F"],

        ["\xE9\xBB\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x90"],
        ["\x5E\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x98"],

        ["\xE7\x8D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x8F"],
        ["\x5E\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x97"],

        ["\xE7\x8D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x91"],
        ["\x5E\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAA"],

        ["\xE7\x8D\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x92"],
        ["\x5E\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA8"],

        ["\xE7\x8D\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x93"],
        ["\x5E\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB0"],

        ["\xE7\x8D\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x95"],
        ["\x5E\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB8"],

        ["\xE7\x8D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x96"],
        ["\x5E\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB5"],

        ["\xE7\x8D\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x97"],
        ["\x5E\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBB"],

        ["\xE7\x8D\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCB"],
        ["\x51\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBA"],

        ["\xE7\x8F\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x98"],
        ["\x5E\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x88"],

        ["\xE7\x8E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x9A"],
        ["\x5E\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB3"],

        ["\xE7\x8F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x9B"],
        ["\x5E\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8E"],

        ["\xE7\x8E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x9C"],
        ["\x5E\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBB"],

        ["\xE7\x8F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\x9D"],
        ["\x5E\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x80"],

        ["\xE7\x8F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA0"],
        ["\x5E\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA5"],

        ["\xE7\x8F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA3"],
        ["\x5E\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAE"],

        ["\xE7\x8F\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA5"],
        ["\x5E\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x9E"],

        ["\xE7\x92\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC2"],
        ["\x5E\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA2"],

        ["\xE7\x90\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA9"],
        ["\x5E\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x85"],

        ["\xE7\x91\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBE"],
        ["\x5E\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAF"],

        ["\xE7\x90\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xAC"],
        ["\x5E\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA5"],

        ["\xE7\x8F\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA6"],
        ["\x5E\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB8"],

        ["\xE7\x90\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xAF"],
        ["\x5E\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB2"],

        ["\xE7\x90\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB0"],
        ["\x5E\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBA"],

        ["\xE7\x91\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB1"],
        ["\x5E\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x95"],

        ["\xE7\x90\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB2"],
        ["\x5E\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBF"],

        ["\xE7\x91\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB3"],
        ["\x5E\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9F"],

        ["\xE7\x91\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB4"],
        ["\x5E\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x99"],

        ["\xE7\x91\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB5"],
        ["\x5E\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x81"],

        ["\xE7\x91\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB6"],
        ["\x5E\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9C"],

        ["\xE7\x91\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB7"],
        ["\x5E\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA9"],

        ["\xE7\x91\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB8"],
        ["\x5E\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB0"],

        ["\xE7\x91\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xB9"],
        ["\x5E\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA3"],

        ["\xE7\x91\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBA"],
        ["\x5E\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAA"],

        ["\xE7\x91\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x83"],
        ["\x68\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB6"],

        ["\xE7\x91\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xBF"],
        ["\x5E\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xBE"],

        ["\xE7\x92\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],
        ["\x50\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x8B"],

        ["\xE7\x92\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC1"],
        ["\x5E\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9E"],

        ["\xE7\x92\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC3"],
        ["\x5E\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA7"],

        ["\xE7\x93\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC4"],
        ["\x5E\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8A"],

        ["\xE7\x93\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC5"],
        ["\x5E\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8F"],

        ["\xE7\x93\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC6"],
        ["\x5E\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x94"],

        ["\xE7\x8F\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xA4"],
        ["\x5E\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB1"],

        ["\xE7\x93\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC7"],
        ["\x5E\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA0"],

        ["\xE7\x93\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC8"],
        ["\x5E\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA3"],

        ["\xE7\x93\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xC9"],
        ["\x5E\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA7"],

        ["\xE7\x93\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCA"],
        ["\x5E\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA9"],

        ["\xE7\x93\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCB"],
        ["\x5E\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAE"],

        ["\xE7\x93\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCD"],
        ["\x5E\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB2"],

        ["\xE7\x93\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCC"],
        ["\x5E\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB0"],

        ["\xE7\x93\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCE"],
        ["\x5E\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB1"],

        ["\xE7\x93\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD0"],
        ["\x5E\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB8"],

        ["\xE7\x93\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xCF"],
        ["\x5E\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB7"],

        ["\xE7\x94\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD2"],
        ["\x5E\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x84"],

        ["\xE7\x94\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"],
        ["\x5E\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x83"],

        ["\xE7\x94\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD4"],
        ["\x5E\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x85"],

        ["\xE7\x94\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD6"],
        ["\x5E\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8C"],

        ["\xE7\x94\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD7"],
        ["\x5E\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8E"],

        ["\xE7\x94\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD5"],
        ["\x5E\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8D"],

        ["\xE7\x94\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE6"],
        ["\x53\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x95"],

        ["\xE7\x94\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"],
        ["\x5E\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x93"],

        ["\xE7\x94\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xD9"],
        ["\x5E\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9E"],

        ["\xE7\x94\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDA"],
        ["\x5E\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA6"],

        ["\xE7\x94\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDB"],
        ["\x5E\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAC"],

        ["\xE7\x94\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDC"],
        ["\x5E\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBC"],

        ["\xE7\x95\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDD"],
        ["\x5E\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x84"],

        ["\xE7\x95\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDE"],
        ["\x5E\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8D"],

        ["\xE7\x95\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xDF"],
        ["\x5E\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8A"],

        ["\xE7\x95\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE0"],
        ["\x5E\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x89"],

        ["\xE7\x95\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE2"],
        ["\x5E\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9B"],

        ["\xE7\x95\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE1"],
        ["\x5E\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x86"],

        ["\xE7\x95\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE3"],
        ["\x5E\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9A"],

        ["\xE7\x95\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xFD"],
        ["\x52\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA9"],

        ["\xE7\x95\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE4"],
        ["\x5E\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA4"],

        ["\xE7\x95\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE5"],
        ["\x5E\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA7"],

        ["\xE7\x95\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"],
        ["\x5E\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAB"],

        ["\xE7\x95\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE9"],
        ["\x5E\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAD"],

        ["\xE7\x95\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEA"],
        ["\x5E\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB8"],

        ["\xE7\x95\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEB"],
        ["\x5E\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB6"],

        ["\xE7\x96\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xED"],
        ["\x5E\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x86"],

        ["\xE7\x96\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEE"],
        ["\x5E\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x87"],

        ["\xE7\x95\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xE8"],
        ["\x5E\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB4"],

        ["\xE7\x96\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEF"],
        ["\x5E\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8A"],

        ["\xE7\x96\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF0"],
        ["\x5E\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x89"],

        ["\xE7\x96\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xEC"],
        ["\x5E\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x82"],

        ["\xE7\x96\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF1"],
        ["\x5E\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x94"],

        ["\xE7\x96\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF2"],
        ["\x5E\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9A"],

        ["\xE7\x96\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF3"],
        ["\x5E\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9D"],

        ["\xE7\x96\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF4"],
        ["\x5E\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA5"],

        ["\xE7\x96\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF5"],
        ["\x5E\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA3"],

        ["\xE7\x97\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"],
        ["\x5E\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x82"],

        ["\xE7\x96\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF7"],
        ["\x5E\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB3"],

        ["\xE7\x97\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"],
        ["\x5E\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x83"],

        ["\xE7\x96\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"],
        ["\x5E\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB5"],

        ["\xE7\x96\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFA"],
        ["\x5E\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBD"],

        ["\xE7\x96\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFB"],
        ["\x5E\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB8"],

        ["\xE7\x96\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFC"],
        ["\x5E\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBC"],

        ["\xE7\x96\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFD"],
        ["\x5E\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB1"],

        ["\xE7\x97\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E\xFE"],
        ["\x5E\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8D"],

        ["\xE7\x97\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x41"],
        ["\x5F\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8A"],

        ["\xE7\x97\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x42"],
        ["\x5F\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x92"],

        ["\xE7\x97\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x43"],
        ["\x5F\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x99"],

        ["\xE7\x97\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x44"],
        ["\x5F\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA3"],

        ["\xE7\x97\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x45"],
        ["\x5F\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9E"],

        ["\xE7\x97\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x46"],
        ["\x5F\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBE"],

        ["\xE7\x97\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x47"],
        ["\x5F\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBF"],

        ["\xE7\x97\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x48"],
        ["\x5F\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBC"],

        ["\xE7\x98\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x49"],
        ["\x5F\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x81"],

        ["\xE7\x97\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],
        ["\x5F\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB0"],

        ["\xE7\x97\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],
        ["\x5F\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBA"],

        ["\xE7\x97\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],
        ["\x5F\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB2"],

        ["\xE7\x97\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],
        ["\x5F\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB3"],

        ["\xE7\x98\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],
        ["\x5F\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8B"],

        ["\xE7\x98\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x4F"],
        ["\x52\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8D"],

        ["\xE7\x98\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],
        ["\x5F\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x89"],

        ["\xE7\x98\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],
        ["\x5F\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9F"],

        ["\xE7\x98\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x51"],
        ["\x5F\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA7"],

        ["\xE7\x98\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x52"],
        ["\x5F\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA0"],

        ["\xE7\x98\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x53"],
        ["\x5F\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA1"],

        ["\xE7\x98\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x54"],
        ["\x5F\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA2"],

        ["\xE7\x98\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x55"],
        ["\x5F\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA4"],

        ["\xE7\x98\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x56"],
        ["\x5F\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB4"],

        ["\xE7\x98\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],
        ["\x5F\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB0"],

        ["\xE7\x98\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x58"],
        ["\x5F\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xBB"],

        ["\xE7\x99\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],
        ["\x5F\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x87"],

        ["\xE7\x99\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],
        ["\x5F\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x88"],

        ["\xE7\x99\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],
        ["\x5F\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x86"],

        ["\xE7\x99\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],
        ["\x5F\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x9C"],

        ["\xE7\x99\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],
        ["\x5F\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x98"],

        ["\xE7\x99\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],
        ["\x5F\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA1"],

        ["\xE7\x99\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],
        ["\x5F\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA2"],

        ["\xE7\x99\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],
        ["\x5F\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA8"],

        ["\xE7\x99\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],
        ["\x5F\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA9"],

        ["\xE7\x99\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],
        ["\x5F\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAA"],

        ["\xE7\x99\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],
        ["\x5F\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA7"],

        ["\xE7\x99\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],
        ["\x5F\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAC"],

        ["\xE7\x99\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],
        ["\x5F\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB0"],

        ["\xE7\x99\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],
        ["\x5F\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB2"],

        ["\xE7\x99\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],
        ["\x5F\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB6"],

        ["\xE7\x99\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9A"],
        ["\x53\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB8"],

        ["\xE7\x99\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],
        ["\x5F\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBC"],

        ["\xE7\x9A\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],
        ["\x5F\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x80"],

        ["\xE7\x9A\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],
        ["\x5F\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x83"],

        ["\xE7\x9A\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],
        ["\x5F\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x88"],

        ["\xE7\x9A\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],
        ["\x5F\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8B"],

        ["\xE7\x9A\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x99"],
        ["\x52\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8E"],

        ["\xE7\x9A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x96"],
        ["\x53\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x96"],

        ["\xE7\x9A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x81"],
        ["\x4E\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x93"],

        ["\xE7\x9A\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],
        ["\x5F\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x99"],

        ["\xE7\x9A\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],
        ["\x5F\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9A"],

        ["\xE7\x9A\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],
        ["\x5F\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB0"],

        ["\xE7\x9A\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],
        ["\x5F\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB4"],

        ["\xE7\x9A\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],
        ["\x5F\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB8"],

        ["\xE7\x9A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],
        ["\x5F\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB9"],

        ["\xE7\x9A\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],
        ["\x5F\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBA"],

        ["\xE7\x9B\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],
        ["\x5F\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x82"],

        ["\xE7\x9B\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],
        ["\x5F\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8D"],

        ["\xE7\x9B\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],
        ["\x5F\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x96"],

        ["\xE7\x9B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],
        ["\x5F\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x92"],

        ["\xE7\x9B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],
        ["\x5F\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9E"],

        ["\xE7\x9B\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x7F"],
        ["\x5F\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA1"],

        ["\xE7\x9B\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x80"],
        ["\x5F\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA5"],

        ["\xE7\x9B\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF7"],
        ["\x53\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA7"],

        ["\xE7\x9B\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x81"],
        ["\x5F\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAA"],

        ["\xE8\x98\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x82"],
        ["\x5F\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAF"],

        ["\xE7\x9B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x83"],
        ["\x5F\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBB"],

        ["\xE7\x9C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x84"],
        ["\x5F\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x88"],

        ["\xE7\x9C\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x85"],
        ["\x5F\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x87"],

        ["\xE7\x9C\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x86"],
        ["\x5F\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x84"],

        ["\xE7\x9C\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x88"],
        ["\x5F\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA9"],

        ["\xE7\x9C\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x87"],
        ["\x5F\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA4"],

        ["\xE7\x9C\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCA"],
        ["\x51\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9E"],

        ["\xE7\x9C\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x89"],
        ["\x5F\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA5"],

        ["\xE7\x9C\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8A"],
        ["\x5F\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA6"],

        ["\xE7\x9C\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8B"],
        ["\x5F\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9B"],

        ["\xE7\x9C\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8C"],
        ["\x5F\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB7"],

        ["\xE7\x9C\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8D"],
        ["\x5F\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB8"],

        ["\xE7\x9D\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x8F"],
        ["\x5F\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x87"],

        ["\xE7\x9D\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x90"],
        ["\x5F\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9A"],

        ["\xE7\x9D\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x91"],
        ["\x5F\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA8"],

        ["\xE7\x9D\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x92"],
        ["\x5F\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xAB"],

        ["\xE7\x9D\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x93"],
        ["\x5F\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9B"],

        ["\xE7\x9D\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x94"],
        ["\x5F\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA5"],

        ["\xE7\x9D\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x95"],
        ["\x5F\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBF"],

        ["\xE7\x9D\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x96"],
        ["\x5F\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBE"],

        ["\xE7\x9D\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x97"],
        ["\x5F\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB9"],

        ["\xE7\x9E\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x98"],
        ["\x5F\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8E"],

        ["\xE7\x9E\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x99"],
        ["\x5F\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8B"],

        ["\xE7\x9E\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9A"],
        ["\x5F\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x91"],

        ["\xE7\x9E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9B"],
        ["\x5F\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA0"],

        ["\xE7\x9E\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9C"],
        ["\x5F\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9E"],

        ["\xE7\x9E\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9D"],
        ["\x5F\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB0"],

        ["\xE7\x9E\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9E"],
        ["\x5F\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB6"],

        ["\xE7\x9E\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\x9F"],
        ["\x5F\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB9"],

        ["\xE7\x9E\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA0"],
        ["\x5F\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBF"],

        ["\xE7\x9E\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA1"],
        ["\x5F\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBC"],

        ["\xE7\x9E\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA2"],
        ["\x5F\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBD"],

        ["\xE7\x9E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA3"],
        ["\x5F\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBB"],

        ["\xE7\x9F\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA4"],
        ["\x5F\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x87"],

        ["\xE7\x9F\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA5"],
        ["\x5F\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x8D"],

        ["\xE7\x9F\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x50"],
        ["\x53\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x97"],

        ["\xE7\x9F\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA6"],
        ["\x5F\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9A"],

        ["\xE7\x9F\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA7"],
        ["\x5F\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9C"],

        ["\xE7\x9F\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA8"],
        ["\x5F\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA3"],

        ["\xE7\x9F\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xA9"],
        ["\x5F\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAE"],

        ["\xE7\x9F\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAB"],
        ["\x5F\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xBC"],

        ["\xE7\xA0\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAC"],
        ["\x5F\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x8C"],

        ["\xE7\xA0\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xAD"],
        ["\x5F\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x92"],

        ["\xE7\xA4\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xB9"],
        ["\x51\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xA6"],

        ["\xE7\xA0\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB0"],
        ["\x5F\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA0"],

        ["\xE7\xA4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x4C"],
        ["\x51\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAA"],

        ["\xE7\xA1\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB1"],
        ["\x5F\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x85"],

        ["\xE7\xA2\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB5"],
        ["\x5F\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8E"],

        ["\xE7\xA1\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB4"],
        ["\x5F\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB4"],

        ["\xE7\xA2\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB7"],
        ["\x5F\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x86"],

        ["\xE7\xA1\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB9"],
        ["\x5F\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBC"],

        ["\xE7\xA2\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xB8"],
        ["\x5F\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9A"],

        ["\xE7\xA2\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBA"],
        ["\x5F\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8C"],

        ["\xE7\xA2\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBB"],
        ["\x5F\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA3"],

        ["\xE7\xA2\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBC"],
        ["\x5F\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xB5"],

        ["\xE7\xA2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBD"],
        ["\x5F\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAA"],

        ["\xE7\xA2\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBE"],
        ["\x5F\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAF"],

        ["\xE7\xA3\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xBF"],
        ["\x5F\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x91"],

        ["\xE7\xA3\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC0"],
        ["\x5F\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x86"],

        ["\xE7\xA3\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC1"],
        ["\x5F\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8B"],

        ["\xE7\xA3\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC2"],
        ["\x5F\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x94"],

        ["\xE7\xA2\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC3"],
        ["\x5F\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBE"],

        ["\xE7\xA2\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC4"],
        ["\x5F\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBC"],

        ["\xE7\xA3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC5"],
        ["\x5F\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x85"],

        ["\xE7\xA3\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC6"],
        ["\x5F\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8A"],

        ["\xE7\xA3\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC7"],
        ["\x5F\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAC"],

        ["\xE7\xA3\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC8"],
        ["\x5F\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA7"],

        ["\xE7\xA3\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xC9"],
        ["\x5F\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x9A"],

        ["\xE7\xA3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCA"],
        ["\x5F\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBD"],

        ["\xE7\xA3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCB"],
        ["\x5F\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB4"],

        ["\xE7\xA4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCC"],
        ["\x5F\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x87"],

        ["\xE7\xA4\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D\xF0"],
        ["\x4D\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x92"],

        ["\xE7\xA4\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCD"],
        ["\x5F\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x91"],

        ["\xE7\xA4\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCE"],
        ["\x5F\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x99"],

        ["\xE7\xA4\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xCF"],
        ["\x5F\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAC"],

        ["\xE7\xA4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD0"],
        ["\x5F\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAB"],

        ["\xE7\xA5\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD3"],
        ["\x5F\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x80"],

        ["\xE7\xA5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD4"],
        ["\x5F\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA0"],

        ["\xE7\xA5\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x65"],
        ["\x53\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x97"],

        ["\xE7\xA5\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"],
        ["\x5F\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9F"],

        ["\xE7\xA5\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD7"],
        ["\x5F\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9A"],

        ["\xE7\xA5\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xD8"],
        ["\x5F\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x95"],

        ["\xE7\xA5\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x5C"],
        ["\x55\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x93"],

        ["\xE7\xA5\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xD8"],
        ["\x52\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBA"],

        ["\xE7\xA5\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xDA"],
        ["\x5F\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBF"],

        ["\xE7\xA6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xDB"],
        ["\x5F\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8A"],

        ["\xE7\xA6\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xDE"],
        ["\x5F\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9D"],

        ["\xE7\xA6\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\xD7"],
        ["\x4F\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA7"],

        ["\xE9\xBD\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF5"],
        ["\x51\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8B"],

        ["\xE7\xA6\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE0"],
        ["\x5F\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAA"],

        ["\xE7\xA6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF5"],
        ["\x54\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAE"],

        ["\xE7\xA6\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE1"],
        ["\x5F\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB3"],

        ["\xE7\xA6\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6A"],
        ["\x53\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB9"],

        ["\xE7\xA6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE2"],
        ["\x5F\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBA"],

        ["\xE7\xA7\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE3"],
        ["\x5F\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x89"],

        ["\xE7\xA7\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE4"],
        ["\x5F\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x95"],

        ["\xE7\xA7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE5"],
        ["\x5F\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA7"],

        ["\xE7\xA7\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE6"],
        ["\x5F\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAC"],

        ["\xE7\xA7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xB5"],
        ["\x54\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA1"],

        ["\xE7\xA7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE7"],
        ["\x5F\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA3"],

        ["\xE7\xA8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE8"],
        ["\x5F\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x88"],

        ["\xE7\xA8\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xE9"],
        ["\x5F\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8D"],

        ["\xE7\xA8\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEA"],
        ["\x5F\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x98"],

        ["\xE7\xA8\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEB"],
        ["\x5F\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x99"],

        ["\xE7\xA8\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x66"],
        ["\x53\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xA0"],

        ["\xE7\xA8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEC"],
        ["\x5F\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9F"],

        ["\xE7\xA6\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xE7"],
        ["\x50\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x80"],

        ["\xE7\xA8\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xED"],
        ["\x5F\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB1"],

        ["\xE7\xA8\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF0"],
        ["\x5F\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBB"],

        ["\xE7\xA8\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEE"],
        ["\x5F\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBE"],

        ["\xE7\xA8\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xEF"],
        ["\x5F\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB7"],

        ["\xE7\xA9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF1"],
        ["\x5F\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x83"],

        ["\xE7\xA9\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF2"],
        ["\x5F\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x97"],

        ["\xE7\xA9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF3"],
        ["\x5F\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x89"],

        ["\xE7\xA9\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF5"],
        ["\x5F\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA1"],

        ["\xE7\xA9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF4"],
        ["\x5F\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA2"],

        ["\xE7\xA9\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF6"],
        ["\x5F\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA9"],

        ["\xE9\xBE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF7"],
        ["\x5F\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9D"],

        ["\xE7\xA9\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF8"],
        ["\x5F\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB0"],

        ["\xE7\xA9\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xF9"],
        ["\x5F\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB9"],

        ["\xE7\xA9\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xFA"],
        ["\x5F\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBD"],

        ["\xE7\xAA\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xFB"],
        ["\x5F\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x88"],

        ["\xE7\xAA\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x41"],
        ["\x60\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x97"],

        ["\xE7\xAA\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xFC"],
        ["\x5F\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x95"],

        ["\xE7\xAA\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xFD"],
        ["\x5F\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x98"],

        ["\xE7\xAA\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F\xFE"],
        ["\x5F\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x96"],

        ["\xE7\xAA\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x42"],
        ["\x60\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA9"],

        ["\xE7\xAB\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xF0"],
        ["\x52\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x88"],

        ["\xE7\xAA\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x43"],
        ["\x60\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB0"],

        ["\xE7\xAA\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x44"],
        ["\x60\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB6"],

        ["\xE7\xAB\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x48"],
        ["\x60\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x85"],

        ["\xE7\xAB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x49"],
        ["\x60\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x84"],

        ["\xE7\xAA\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x47"],
        ["\x60\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBF"],

        ["\xE9\x82\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x45"],
        ["\x60\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x83"],

        ["\xE7\xAB\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4A"],
        ["\x60\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x87"],

        ["\xE7\xAB\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],
        ["\x60\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8A"],

        ["\xE7\xAB\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],
        ["\x60\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8D"],

        ["\xE7\xAB\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],
        ["\x60\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8F"],

        ["\xE7\xAB\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],
        ["\x60\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x95"],

        ["\xE7\xAB\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x51"],
        ["\x60\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x93"],

        ["\xE7\xAB\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x52"],
        ["\x60\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x99"],

        ["\xE7\xAB\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x53"],
        ["\x60\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9A"],

        ["\xE7\xAB\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x54"],
        ["\x60\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9D"],

        ["\xE7\xAB\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x55"],
        ["\x60\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA1"],

        ["\xE7\xAB\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x56"],
        ["\x60\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA2"],

        ["\xE7\xAB\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],
        ["\x60\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA6"],

        ["\xE7\xAB\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5B"],
        ["\x60\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAD"],

        ["\xE7\xAB\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],
        ["\x60\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB0"],

        ["\xE7\xAC\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],
        ["\x60\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x82"],

        ["\xE7\xAC\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x5F"],
        ["\x60\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8F"],

        ["\xE7\xAC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],
        ["\x60\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8A"],

        ["\xE7\xAC\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],
        ["\x60\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x86"],

        ["\xE7\xAC\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],
        ["\x60\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB3"],

        ["\xE7\xAC\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xE7"],
        ["\x53\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x98"],

        ["\xE7\xAC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],
        ["\x60\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x99"],

        ["\xE7\xAC\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],
        ["\x60\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9E"],

        ["\xE7\xAC\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],
        ["\x60\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB5"],

        ["\xE7\xAC\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],
        ["\x60\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA8"],

        ["\xE7\xAC\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],
        ["\x60\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB6"],

        ["\xE7\xAD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],
        ["\x60\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x90"],

        ["\xE7\xAD\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6F"],
        ["\x60\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xBA"],

        ["\xE7\xAC\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD5"],
        ["\x54\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x84"],

        ["\xE7\xAD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],
        ["\x60\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8D"],

        ["\xE7\xAC\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],
        ["\x60\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8B"],

        ["\xE7\xAD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],
        ["\x60\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8C"],

        ["\xE7\xAD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],
        ["\x60\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x85"],

        ["\xE7\xAD\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],
        ["\x60\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB5"],

        ["\xE7\xAD\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x84"],
        ["\x54\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA5"],

        ["\xE7\xAD\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],
        ["\x60\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB4"],

        ["\xE7\xAD\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x48"],
        ["\x50\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA7"],

        ["\xE7\xAD\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],
        ["\x60\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB0"],

        ["\xE7\xAD\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],
        ["\x60\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB1"],

        ["\xE7\xAD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x4E"],
        ["\x53\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAC"],

        ["\xE7\xAD\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],
        ["\x60\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAE"],

        ["\xE7\xAE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],
        ["\x60\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9D"],

        ["\xE7\xAE\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],
        ["\x60\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x98"],

        ["\xE7\xAE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x76"],
        ["\x60\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9F"],

        ["\xE7\xAE\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],
        ["\x60\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8D"],

        ["\xE7\xAE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],
        ["\x60\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9C"],

        ["\xE7\xAE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],
        ["\x60\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9A"],

        ["\xE7\xAE\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA4"],
        ["\x55\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8B"],

        ["\xE7\xAE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],
        ["\x60\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x92"],

        ["\xE7\xAE\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],
        ["\x60\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8F"],

        ["\xE7\xAD\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],
        ["\x60\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x9D"],

        ["\xE7\xAE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],
        ["\x60\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x99"],

        ["\xE7\xAF\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],
        ["\x60\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8B"],

        ["\xE7\xAF\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xE8"],
        ["\x51\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x81"],

        ["\xE7\xAF\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7F"],
        ["\x60\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8C"],

        ["\xE7\xAF\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],
        ["\x60\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8F"],

        ["\xE7\xAE\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x80"],
        ["\x60\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB4"],

        ["\xE7\xAF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x81"],
        ["\x60\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x86"],

        ["\xE7\xAF\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x83"],
        ["\x60\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x9D"],

        ["\xE7\xAF\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x84"],
        ["\x60\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA9"],

        ["\xE7\xB0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x53"],
        ["\x4F\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x91"],

        ["\xE7\xB0\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x88"],
        ["\x60\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x94"],

        ["\xE7\xAF\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x85"],
        ["\x60\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA6"],

        ["\xE7\xAF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x87"],
        ["\x60\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA5"],

        ["\xE7\xB1\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\xEE"],
        ["\x4C\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA0"],

        ["\xE7\xB0\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x89"],
        ["\x60\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x80"],

        ["\xE7\xB0\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8B"],
        ["\x60\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x87"],

        ["\xE7\xB0\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8A"],
        ["\x60\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x93"],

        ["\xE7\xAF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8C"],
        ["\x60\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB3"],

        ["\xE7\xAF\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x86"],
        ["\x60\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB7"],

        ["\xE7\xB0\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x7C"],
        ["\x51\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x97"],

        ["\xE7\xB0\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8D"],
        ["\x60\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8D"],

        ["\xE7\xAF\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8E"],
        ["\x60\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB6"],

        ["\xE7\xB0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x8F"],
        ["\x60\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA3"],

        ["\xE7\xB0\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x90"],
        ["\x60\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA7"],

        ["\xE7\xB0\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x91"],
        ["\x60\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAA"],

        ["\xE7\xB0\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x92"],
        ["\x60\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x9F"],

        ["\xE7\xB0\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x93"],
        ["\x60\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB7"],

        ["\xE7\xB0\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x94"],
        ["\x60\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAB"],

        ["\xE7\xB0\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x95"],
        ["\x60\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBD"],

        ["\xE7\xB1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x97"],
        ["\x60\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8C"],

        ["\xE7\xB1\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x98"],
        ["\x60\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x83"],

        ["\xE7\xB1\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x99"],
        ["\x4F\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x94"],

        ["\xE7\xB1\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xF2"],
        ["\x51\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8F"],

        ["\xE7\xB1\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x96"],
        ["\x60\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x80"],

        ["\xE7\xB1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9A"],
        ["\x60\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x90"],

        ["\xE7\xB1\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9B"],
        ["\x60\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x98"],

        ["\xE7\xB1\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9C"],
        ["\x60\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x9F"],

        ["\xE7\xB1\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAA"],
        ["\x52\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA4"],

        ["\xE7\xB1\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x99"],
        ["\x60\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x96"],

        ["\xE7\xB1\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9D"],
        ["\x60\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA5"],

        ["\xE7\xB1\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9E"],
        ["\x60\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAC"],

        ["\xE7\xB1\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\x9F"],
        ["\x60\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB5"],

        ["\xE7\xB2\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA0"],
        ["\x60\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x83"],

        ["\xE7\xB2\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA1"],
        ["\x60\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x90"],

        ["\xE7\xB2\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA2"],
        ["\x60\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA4"],

        ["\xE7\xB2\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA6"],
        ["\x60\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAD"],

        ["\xE7\xB2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA3"],
        ["\x60\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA2"],

        ["\xE7\xB2\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA4"],
        ["\x60\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAB"],

        ["\xE7\xB2\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA5"],
        ["\x60\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA1"],

        ["\xE7\xB2\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA7"],
        ["\x60\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA8"],

        ["\xE7\xB2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA8"],
        ["\x60\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB3"],

        ["\xE7\xB2\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xA9"],
        ["\x60\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB2"],

        ["\xE7\xB2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAA"],
        ["\x60\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB1"],

        ["\xE7\xB2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAB"],
        ["\x60\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAE"],

        ["\xE7\xB2\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAC"],
        ["\x60\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB9"],

        ["\xE7\xB2\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAE"],
        ["\x60\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBD"],

        ["\xE7\xB3\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xBC"],
        ["\x51\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x80"],

        ["\xE7\xB3\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xAF"],
        ["\x60\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x85"],

        ["\xE7\xB3\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB0"],
        ["\x60\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x82"],

        ["\xE7\xB3\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB3"],
        ["\x60\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x98"],

        ["\xE7\xB3\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB1"],
        ["\x60\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x92"],

        ["\xE7\xB3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB4"],
        ["\x60\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9C"],

        ["\xE7\xB3\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB2"],
        ["\x60\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA2"],

        ["\xE9\xAC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x67\x88"],
        ["\x67\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBB"],

        ["\xE7\xB3\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB5"],
        ["\x60\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xAF"],

        ["\xE7\xB3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB6"],
        ["\x60\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB2"],

        ["\xE7\xB3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB7"],
        ["\x60\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB4"],

        ["\xE7\xB3\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB8"],
        ["\x60\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB6"],

        ["\xE7\xB3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xC2"],
        ["\x52\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBA"],

        ["\xE7\xB4\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xB9"],
        ["\x60\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x86"],

        ["\xE7\xB4\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBA"],
        ["\x60\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x82"],

        ["\xE7\xB4\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBB"],
        ["\x60\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9C"],

        ["\xE7\xB4\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBC"],
        ["\x60\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x95"],

        ["\xE7\xB4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBD"],
        ["\x60\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8A"],

        ["\xE7\xB5\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBE"],
        ["\x60\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x85"],

        ["\xE7\xB5\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xBF"],
        ["\x60\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8B"],

        ["\xE7\xB4\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC0"],
        ["\x60\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAE"],

        ["\xE7\xB4\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC1"],
        ["\x60\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB2"],

        ["\xE7\xB4\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC2"],
        ["\x60\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBF"],

        ["\xE7\xB4\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC3"],
        ["\x60\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB5"],

        ["\xE7\xB5\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC5"],
        ["\x60\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x86"],

        ["\xE7\xB5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"],
        ["\x60\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB3"],

        ["\xE7\xB5\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC8"],
        ["\x60\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x96"],

        ["\xE7\xB5\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xC9"],
        ["\x60\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8E"],

        ["\xE7\xB5\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x68"],
        ["\x52\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB2"],

        ["\xE7\xB5\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCA"],
        ["\x60\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA8"],

        ["\xE7\xB5\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCB"],
        ["\x60\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xAE"],

        ["\xE7\xB5\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCC"],
        ["\x60\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8F"],

        ["\xE7\xB5\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCD"],
        ["\x60\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA3"],

        ["\xE7\xB6\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCE"],
        ["\x60\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x93"],

        ["\xE7\xB6\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xCF"],
        ["\x60\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x89"],

        ["\xE7\xB5\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD0"],
        ["\x60\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9B"],

        ["\xE7\xB6\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x74"],
        ["\x53\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8F"],

        ["\xE7\xB5\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xED"],
        ["\x54\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBD"],

        ["\xE7\xB6\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xEB"],
        ["\x54\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9B"],

        ["\xE7\xB6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD3"],
        ["\x54\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBA"],

        ["\xE7\xB6\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"],
        ["\x60\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAE"],

        ["\xE7\xB6\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD2"],
        ["\x60\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA3"],

        ["\xE7\xB6\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD3"],
        ["\x60\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB5"],

        ["\xE7\xB7\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD5"],
        ["\x60\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x87"],

        ["\xE7\xB6\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD6"],
        ["\x60\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBD"],

        ["\xE7\xB6\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD7"],
        ["\x60\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAB"],

        ["\xE7\xB8\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF3"],
        ["\x60\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBD"],

        ["\xE7\xB6\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD8"],
        ["\x60\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA2"],

        ["\xE7\xB6\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xD9"],
        ["\x60\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAF"],

        ["\xE7\xB7\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE8"],
        ["\x60\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9C"],

        ["\xE7\xB6\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDB"],
        ["\x60\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB8"],

        ["\xE7\xB6\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDC"],
        ["\x60\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9F"],

        ["\xE7\xB6\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDD"],
        ["\x60\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB0"],

        ["\xE7\xB7\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDF"],
        ["\x60\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x98"],

        ["\xE7\xB7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE0"],
        ["\x60\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9D"],

        ["\xE7\xB7\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE2"],
        ["\x60\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA4"],

        ["\xE7\xB7\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE3"],
        ["\x60\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9E"],

        ["\xE7\xB7\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE4"],
        ["\x60\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xBB"],

        ["\xE7\xB7\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE6"],
        ["\x60\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB2"],

        ["\xE7\xB7\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE7"],
        ["\x60\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA1"],

        ["\xE7\xB8\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE9"],
        ["\x60\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x85"],

        ["\xE7\xB8\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEA"],
        ["\x60\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8A"],

        ["\xE7\xB8\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xA8"],
        ["\x55\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA3"],

        ["\xE7\xB8\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEB"],
        ["\x60\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA1"],

        ["\xE7\xB8\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEC"],
        ["\x60\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x92"],

        ["\xE7\xB8\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF2"],
        ["\x60\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB1"],

        ["\xE7\xB8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xED"],
        ["\x60\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9F"],

        ["\xE7\xB8\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEE"],
        ["\x60\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x89"],

        ["\xE7\xB8\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xE5"],
        ["\x60\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8B"],

        ["\xE7\xB8\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B\xCC"],
        ["\x5B\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA2"],

        ["\xE7\xB9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF0"],
        ["\x60\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x86"],

        ["\xE7\xB9\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF1"],
        ["\x60\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA6"],

        ["\xE7\xB8\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF5"],
        ["\x60\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBB"],

        ["\xE7\xB8\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF4"],
        ["\x60\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB5"],

        ["\xE7\xB8\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF6"],
        ["\x60\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB9"],

        ["\xE7\xB9\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF7"],
        ["\x60\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x83"],

        ["\xE7\xB8\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF8"],
        ["\x60\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB7"],

        ["\xE7\xB8\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xF9"],
        ["\x60\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB2"],

        ["\xE7\xB8\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xEF"],
        ["\x60\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBA"],

        ["\xE7\xB9\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x42"],
        ["\x61\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA7"],

        ["\xE7\xB9\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFA"],
        ["\x60\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9D"],

        ["\xE7\xB9\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFB"],
        ["\x60\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x96"],

        ["\xE7\xB9\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFC"],
        ["\x60\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9E"],

        ["\xE7\xB9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xFE"],
        ["\x60\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x99"],

        ["\xE7\xB9\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x41"],
        ["\x61\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9A"],

        ["\xE7\xB9\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x43"],
        ["\x61\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB9"],

        ["\xE7\xB9\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x44"],
        ["\x61\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAA"],

        ["\xE7\xB9\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x45"],
        ["\x61\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA9"],

        ["\xE7\xB9\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x46"],
        ["\x61\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBC"],

        ["\xE7\xB9\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x47"],
        ["\x61\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBB"],

        ["\xE7\xBA\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4B"],
        ["\x61\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x83"],

        ["\xE7\xB7\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x60\xDE"],
        ["\x60\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x95"],

        ["\xE7\xB9\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x48"],
        ["\x61\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBD"],

        ["\xE8\xBE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x49"],
        ["\x61\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAE"],

        ["\xE7\xB9\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4A"],
        ["\x61\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBF"],

        ["\xE7\xBA\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x78"],
        ["\x52\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x88"],

        ["\xE7\xBA\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4C"],
        ["\x61\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x89"],

        ["\xE7\xBA\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4E"],
        ["\x61\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8C"],

        ["\xE7\xBA\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4F"],
        ["\x61\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x92"],

        ["\xE7\xBA\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x73"],
        ["\x52\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x90"],

        ["\xE7\xBA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x50"],
        ["\x61\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x93"],

        ["\xE7\xBA\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x51"],
        ["\x61\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x94"],

        ["\xE7\xBA\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x52"],
        ["\x61\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x96"],

        ["\xE7\xBA\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x4D"],
        ["\x61\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8E"],

        ["\xE7\xBA\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x53"],
        ["\x61\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9B"],

        ["\xE7\xBA\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x9C"],
        ["\x53\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9C"],

        ["\xE7\xBC\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x54"],
        ["\x61\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB8"],

        ["\xE7\xBC\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x55"],
        ["\x61\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBA"],

        ["\xE7\xBD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x56"],
        ["\x61\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x85"],

        ["\xE7\xBD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x58"],
        ["\x61\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8C"],

        ["\xE7\xBD\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xCB"],
        ["\x54\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8D"],

        ["\xE7\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x59"],
        ["\x61\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8E"],

        ["\xE7\xBD\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6E"],
        ["\x51\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x90"],

        ["\xE7\xBD\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5A"],
        ["\x61\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x91"],

        ["\xE7\xBD\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5B"],
        ["\x61\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x95"],

        ["\xE7\xBD\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5C"],
        ["\x61\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x94"],

        ["\xE7\xBD\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5D"],
        ["\x61\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x98"],

        ["\xE7\xBD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5E"],
        ["\x61\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x9F"],

        ["\xE7\xBD\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x5F"],
        ["\x61\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA0"],

        ["\xE7\xBD\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x60"],
        ["\x61\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA8"],

        ["\xE7\xBD\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x62"],
        ["\x61\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA9"],

        ["\xE7\xBD\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x61"],
        ["\x61\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA7"],

        ["\xE7\xBD\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x63"],
        ["\x61\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB8"],

        ["\xE7\xBE\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x64"],
        ["\x61\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x82"],

        ["\xE7\xBE\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x65"],
        ["\x61\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x86"],

        ["\xE7\xBE\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x66"],
        ["\x61\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x83"],

        ["\xE7\xBE\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x68"],
        ["\x61\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x88"],

        ["\xE7\xBE\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x67"],
        ["\x61\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x87"],

        ["\xE7\xBE\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x69"],
        ["\x61\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8C"],

        ["\xE7\xBE\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6A"],
        ["\x61\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x94"],

        ["\xE7\xBE\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6B"],
        ["\x61\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9E"],

        ["\xE7\xBE\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6C"],
        ["\x61\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9D"],

        ["\xE7\xBE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6D"],
        ["\x61\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9A"],

        ["\xE7\xBE\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x6F"],
        ["\x61\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA3"],

        ["\xE7\xBE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x70"],
        ["\x61\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAF"],

        ["\xE7\xBE\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x72"],
        ["\x61\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB2"],

        ["\xE7\xBE\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x73"],
        ["\x61\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB9"],

        ["\xE7\xBE\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x71"],
        ["\x61\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAE"],

        ["\xE7\xBE\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x74"],
        ["\x61\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB6"],

        ["\xE7\xBE\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x75"],
        ["\x61\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB8"],

        ["\xE8\xAD\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x76"],
        ["\x61\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB1"],

        ["\xE7\xBF\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x78"],
        ["\x61\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x85"],

        ["\xE7\xBF\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x79"],
        ["\x61\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x86"],

        ["\xE7\xBF\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7A"],
        ["\x61\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8A"],

        ["\xE7\xBF\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7B"],
        ["\x61\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x95"],

        ["\xE7\xBF\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF9"],
        ["\x54\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x94"],

        ["\xE7\xBF\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7C"],
        ["\x61\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA1"],

        ["\xE7\xBF\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7D"],
        ["\x61\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA6"],

        ["\xE7\xBF\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7E"],
        ["\x61\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA9"],

        ["\xE7\xBF\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x7F"],
        ["\x61\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB3"],

        ["\xE7\xBF\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x80"],
        ["\x61\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB9"],

        ["\xE9\xA3\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\xDA"],
        ["\x66\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9C"],

        ["\xE8\x80\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xDC"],
        ["\x53\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x86"],

        ["\xE8\x80\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x81"],
        ["\x61\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x84"],

        ["\xE8\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x82"],
        ["\x61\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8B"],

        ["\xE8\x80\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x83"],
        ["\x61\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x92"],

        ["\xE8\x80\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE4"],
        ["\x54\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x98"],

        ["\xE8\x80\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x84"],
        ["\x61\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x99"],

        ["\xE8\x80\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x85"],
        ["\x61\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x9C"],

        ["\xE8\x80\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x86"],
        ["\x61\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA1"],

        ["\xE8\x80\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x87"],
        ["\x61\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA8"],

        ["\xE8\x80\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x88"],
        ["\x61\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBF"],

        ["\xE8\x80\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x89"],
        ["\x61\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBB"],

        ["\xE8\x81\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8A"],
        ["\x61\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x8A"],

        ["\xE8\x81\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8B"],
        ["\x61\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x86"],

        ["\xE8\x81\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8C"],
        ["\x61\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x92"],

        ["\xE8\x81\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8D"],
        ["\x61\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x98"],

        ["\xE8\x81\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x79"],
        ["\x54\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9A"],

        ["\xE8\x81\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8E"],
        ["\x61\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9F"],

        ["\xE8\x81\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x8F"],
        ["\x61\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA2"],

        ["\xE8\x81\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x90"],
        ["\x61\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA8"],

        ["\xE8\x81\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x91"],
        ["\x61\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB3"],

        ["\xE8\x81\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x92"],
        ["\x61\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB2"],

        ["\xE8\x81\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x93"],
        ["\x61\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB0"],

        ["\xE8\x81\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x94"],
        ["\x61\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB6"],

        ["\xE8\x81\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x95"],
        ["\x61\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB9"],

        ["\xE8\x81\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x96"],
        ["\x61\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBD"],

        ["\xE8\x81\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x97"],
        ["\x61\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBF"],

        ["\xE8\x82\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x98"],
        ["\x61\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x84"],

        ["\xE8\x82\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xB6"],
        ["\x53\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x86"],

        ["\xE8\x82\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x99"],
        ["\x61\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x85"],

        ["\xE8\x82\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x92"],
        ["\x52\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9B"],

        ["\xE8\x82\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9A"],
        ["\x61\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x93"],

        ["\xE8\x82\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9B"],
        ["\x61\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9A"],

        ["\xE8\x82\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9C"],
        ["\x61\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAD"],

        ["\xE5\x86\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9D"],
        ["\x61\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x90"],

        ["\xE8\x82\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9E"],
        ["\x61\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAC"],

        ["\xE8\x83\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\x9F"],
        ["\x61\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9B"],

        ["\xE8\x83\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA0"],
        ["\x61\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA5"],

        ["\xE8\x83\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA1"],
        ["\x61\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x99"],

        ["\xE8\x83\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA2"],
        ["\x61\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9D"],

        ["\xE8\x83\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA3"],
        ["\x61\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x84"],

        ["\xE8\x83\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA4"],
        ["\x61\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9A"],

        ["\xE8\x83\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x88"],
        ["\x52\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x96"],

        ["\xE8\x84\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA5"],
        ["\x61\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x89"],

        ["\xE8\x83\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA6"],
        ["\x61\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xAF"],

        ["\xE8\x83\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA7"],
        ["\x61\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB1"],

        ["\xE8\x84\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA8"],
        ["\x61\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9B"],

        ["\xE8\x84\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x96"],
        ["\x4C\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA9"],

        ["\xE8\x84\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xA9"],
        ["\x61\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA3"],

        ["\xE8\x84\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAA"],
        ["\x61\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xAF"],

        ["\xE8\x85\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAB"],
        ["\x61\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8B"],

        ["\xE9\x9A\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],
        ["\x66\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8B"],

        ["\xE8\x85\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAC"],
        ["\x61\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x86"],

        ["\xE8\x84\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAD"],
        ["\x61\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xBE"],

        ["\xE8\x85\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAE"],
        ["\x61\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x93"],

        ["\xE8\x85\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xAF"],
        ["\x61\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x91"],

        ["\xE8\x83\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB0"],
        ["\x61\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBC"],

        ["\xE8\x85\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB1"],
        ["\x61\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB1"],

        ["\xE8\x85\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB2"],
        ["\x61\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAE"],

        ["\xE8\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB3"],
        ["\x61\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA5"],

        ["\xE8\x85\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB5"],
        ["\x61\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA6"],

        ["\xE8\x85\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB6"],
        ["\x61\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB4"],

        ["\xE8\x86\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB7"],
        ["\x61\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x83"],

        ["\xE8\x86\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB8"],
        ["\x61\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x88"],

        ["\xE8\x86\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB9"],
        ["\x61\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8A"],

        ["\xE8\x86\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBA"],
        ["\x61\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x80"],

        ["\xE8\x86\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBB"],
        ["\x61\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x82"],

        ["\xE8\x86\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBC"],
        ["\x61\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA0"],

        ["\xE8\x86\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBD"],
        ["\x61\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x95"],

        ["\xE8\x86\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC1"],
        ["\x61\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA4"],

        ["\xE8\x86\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBE"],
        ["\x61\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA3"],

        ["\xE8\x85\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xB4"],
        ["\x61\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x9F"],

        ["\xE8\x86\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xBF"],
        ["\x61\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x93"],

        ["\xE8\x86\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC2"],
        ["\x61\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA9"],

        ["\xE8\x86\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC4"],
        ["\x61\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB0"],

        ["\xE8\x86\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC0"],
        ["\x61\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB5"],

        ["\xE8\x86\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC6"],
        ["\x61\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBE"],

        ["\xE8\x86\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC3"],
        ["\x61\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB8"],

        ["\xE8\x86\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC7"],
        ["\x61\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBD"],

        ["\xE8\x87\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC8"],
        ["\x61\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x80"],

        ["\xE8\x87\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC9"],
        ["\x61\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x82"],

        ["\xE8\x86\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCA"],
        ["\x61\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBA"],

        ["\xE8\x87\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCB"],
        ["\x61\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x89"],

        ["\xE8\x87\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCC"],
        ["\x61\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8D"],

        ["\xE8\x87\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCD"],
        ["\x61\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x91"],

        ["\xE8\x87\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCF"],
        ["\x61\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x99"],

        ["\xE8\x87\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xCE"],
        ["\x61\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x98"],

        ["\xE8\x87\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xC5"],
        ["\x61\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x88"],

        ["\xE8\x87\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD0"],
        ["\x61\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9A"],

        ["\xE8\x87\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD1"],
        ["\x61\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9F"],

        ["\xE8\x87\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD2"],
        ["\x61\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA0"],

        ["\xE8\x87\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x73"],
        ["\x51\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA7"],

        ["\xE8\x87\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD3"],
        ["\x61\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBA"],

        ["\xE8\x87\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD4"],
        ["\x61\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBB"],

        ["\xE8\x87\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD5"],
        ["\x61\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBE"],

        ["\xE8\x88\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD6"],
        ["\x61\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x81"],

        ["\xE8\x88\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD7"],
        ["\x61\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x82"],

        ["\xE8\x88\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD8"],
        ["\x61\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x85"],

        ["\xE8\x88\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x58"],
        ["\x53\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x87"],

        ["\xE8\x88\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBA"],
        ["\x62\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8A"],

        ["\xE8\x88\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xD9"],
        ["\x61\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8D"],

        ["\xE8\x88\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDA"],
        ["\x61\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x90"],

        ["\xE8\x88\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDC"],
        ["\x61\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x96"],

        ["\xE8\x88\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDD"],
        ["\x61\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA9"],

        ["\xE8\x88\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDE"],
        ["\x61\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAB"],

        ["\xE8\x88\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE0"],
        ["\x61\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB8"],

        ["\xE8\x88\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE1"],
        ["\x61\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB3"],

        ["\xE8\x89\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE2"],
        ["\x61\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x80"],

        ["\xE8\x89\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE3"],
        ["\x61\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x99"],

        ["\xE8\x89\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xAE"],
        ["\x54\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x98"],

        ["\xE8\x89\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE5"],
        ["\x61\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9D"],

        ["\xE8\x89\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE4"],
        ["\x61\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9A"],

        ["\xE8\x89\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE6"],
        ["\x61\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9F"],

        ["\xE8\x89\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE7"],
        ["\x61\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA4"],

        ["\xE8\x89\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE8"],
        ["\x61\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA2"],

        ["\xE8\x89\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xE9"],
        ["\x61\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA8"],

        ["\xE8\x89\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEA"],
        ["\x61\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAA"],

        ["\xE8\x89\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEB"],
        ["\x61\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAB"],

        ["\xE8\x88\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xDF"],
        ["\x61\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAE"],

        ["\xE8\x89\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEC"],
        ["\x61\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB1"],

        ["\xE8\x89\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xED"],
        ["\x61\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB7"],

        ["\xE8\x89\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xC5"],
        ["\x53\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB8"],

        ["\xE8\x89\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEE"],
        ["\x61\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBE"],

        ["\xE8\x8A\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xEF"],
        ["\x61\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8D"],

        ["\xE8\x8A\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF0"],
        ["\x61\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x92"],

        ["\xE8\x8A\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF1"],
        ["\x61\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAB"],

        ["\xE8\x8A\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF2"],
        ["\x61\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9F"],

        ["\xE8\x8A\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF3"],
        ["\x61\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBB"],

        ["\xE8\x8A\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF4"],
        ["\x61\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAC"],

        ["\xE8\x8B\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF5"],
        ["\x61\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA1"],

        ["\xE8\x8B\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF6"],
        ["\x61\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA3"],

        ["\xE8\x8B\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF7"],
        ["\x61\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9F"],

        ["\xE8\x8B\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xF9"],
        ["\x61\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x92"],

        ["\xE8\x8B\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFA"],
        ["\x61\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB4"],

        ["\xE8\x8B\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFB"],
        ["\x61\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB3"],

        ["\xE8\x8B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x44"],
        ["\x62\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBA"],

        ["\xE8\x8E\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],
        ["\x62\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x93"],

        ["\xE8\x8C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFC"],
        ["\x61\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x83"],

        ["\xE8\x8B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFD"],
        ["\x61\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBB"],

        ["\xE8\x8B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x61\xFE"],
        ["\x61\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB9"],

        ["\xE8\x8B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x41"],
        ["\x62\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9E"],

        ["\xE8\x8C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x42"],
        ["\x62\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x86"],

        ["\xE8\x8B\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x43"],
        ["\x62\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9C"],

        ["\xE8\x8C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x45"],
        ["\x62\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x89"],

        ["\xE8\x8B\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x46"],
        ["\x62\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x99"],

        ["\xE8\x8C\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x47"],
        ["\x62\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB5"],

        ["\xE8\x8C\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x49"],
        ["\x62\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB4"],

        ["\xE8\x8C\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],
        ["\x62\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x96"],

        ["\xE8\x8C\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x7B"],
        ["\x54\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB2"],

        ["\xE8\x8C\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],
        ["\x62\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB1"],

        ["\xE8\x8D\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],
        ["\x62\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x80"],

        ["\xE8\x8C\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],
        ["\x62\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB9"],

        ["\xE8\x8D\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],
        ["\x62\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x90"],

        ["\xE8\x8D\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],
        ["\x62\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x85"],

        ["\xE8\x8C\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],
        ["\x62\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAF"],

        ["\xE8\x8C\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x51"],
        ["\x62\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAB"],

        ["\xE8\x8C\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xF6"],
        ["\x53\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x97"],

        ["\xE8\x8C\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x52"],
        ["\x62\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x98"],

        ["\xE8\x8E\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],
        ["\x62\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x85"],

        ["\xE8\x8E\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x53"],
        ["\x62\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9A"],

        ["\xE8\x8E\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x54"],
        ["\x62\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAA"],

        ["\xE8\x8E\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x55"],
        ["\x62\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9F"],

        ["\xE8\x8E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x56"],
        ["\x62\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA2"],

        ["\xE8\x8E\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],
        ["\x62\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x96"],

        ["\xE8\x8C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x58"],
        ["\x62\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA3"],

        ["\xE8\x8E\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],
        ["\x62\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8E"],

        ["\xE8\x8E\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x86"],
        ["\x54\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x87"],

        ["\xE8\x8E\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],
        ["\x62\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8A"],

        ["\xE8\x8D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],
        ["\x62\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBC"],

        ["\xE8\x8E\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],
        ["\x62\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB5"],

        ["\xE8\x8D\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],
        ["\x62\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB3"],

        ["\xE8\x8D\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],
        ["\x62\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB5"],

        ["\xE8\x8E\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],
        ["\x62\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA0"],

        ["\xE8\x8E\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],
        ["\x62\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x89"],

        ["\xE8\x8E\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],
        ["\x62\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA8"],

        ["\xE8\x8F\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],
        ["\x62\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB4"],

        ["\xE8\x90\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],
        ["\x62\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x93"],

        ["\xE8\x8F\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xE9"],
        ["\x54\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAB"],

        ["\xE8\x8F\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],
        ["\x62\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8E"],

        ["\xE8\x8F\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],
        ["\x62\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBD"],

        ["\xE8\x90\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],
        ["\x62\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x83"],

        ["\xE8\x8F\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],
        ["\x62\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x98"],

        ["\xE8\x90\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],
        ["\x62\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8B"],

        ["\xE8\x8F\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],
        ["\x62\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x81"],

        ["\xE8\x8F\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],
        ["\x62\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB7"],

        ["\xE8\x90\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],
        ["\x62\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x87"],

        ["\xE8\x8F\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],
        ["\x62\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA0"],

        ["\xE8\x8F\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],
        ["\x62\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB2"],

        ["\xE8\x90\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],
        ["\x62\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8D"],

        ["\xE8\x90\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xD8"],
        ["\x54\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA2"],

        ["\xE8\x90\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],
        ["\x62\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA0"],

        ["\xE8\x8E\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],
        ["\x62\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xBD"],

        ["\xE8\x90\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x84"],
        ["\x62\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB8"],

        ["\xE8\x94\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9D"],
        ["\x62\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x86"],

        ["\xE8\x8F\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],
        ["\x62\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBB"],

        ["\xE8\x91\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x6C"],
        ["\x51\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAD"],

        ["\xE8\x90\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],
        ["\x62\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAA"],

        ["\xE8\x90\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],
        ["\x62\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBC"],

        ["\xE8\x95\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9F"],
        ["\x62\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x9A"],

        ["\xE8\x92\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],
        ["\x62\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x84"],

        ["\xE8\x91\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],
        ["\x62\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB7"],

        ["\xE8\x91\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],
        ["\x62\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAB"],

        ["\xE8\x92\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x90"],
        ["\x62\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xAD"],

        ["\xE8\x91\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7F"],
        ["\x62\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAE"],

        ["\xE8\x92\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x80"],
        ["\x62\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x82"],

        ["\xE8\x91\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x81"],
        ["\x62\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA9"],

        ["\xE8\x91\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x82"],
        ["\x62\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x86"],

        ["\xE8\x90\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B\x75"],
        ["\x4B\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAC"],

        ["\xE8\x91\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x83"],
        ["\x62\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAF"],

        ["\xE8\x91\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],
        ["\x62\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB9"],

        ["\xE8\x90\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x85"],
        ["\x62\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB5"],

        ["\xE8\x93\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x86"],
        ["\x62\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8A"],

        ["\xE8\x91\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],
        ["\x62\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA2"],

        ["\xE8\x92\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x87"],
        ["\x62\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB9"],

        ["\xE8\x92\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x88"],
        ["\x62\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBF"],

        ["\xE8\x92\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x89"],
        ["\x62\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9F"],

        ["\xE8\x93\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x94"],
        ["\x62\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x99"],

        ["\xE8\x93\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8B"],
        ["\x62\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8D"],

        ["\xE8\x92\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8C"],
        ["\x62\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBB"],

        ["\xE8\x93\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8D"],
        ["\x62\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9A"],

        ["\xE8\x93\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8E"],
        ["\x62\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x90"],

        ["\xE8\x93\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x8F"],
        ["\x62\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x81"],

        ["\xE8\x93\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x91"],
        ["\x62\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x86"],

        ["\xE8\x93\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x92"],
        ["\x62\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x96"],

        ["\xE8\x92\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x93"],
        ["\x62\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA1"],

        ["\xE8\x94\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA8"],
        ["\x54\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA1"],

        ["\xE8\x93\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x95"],
        ["\x62\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBF"],

        ["\xE8\x93\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x96"],
        ["\x62\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB4"],

        ["\xE8\x94\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x97"],
        ["\x62\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x97"],

        ["\xE8\x94\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x98"],
        ["\x62\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x98"],

        ["\xE8\x94\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x99"],
        ["\x62\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAC"],

        ["\xE8\x94\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9A"],
        ["\x62\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9F"],

        ["\xE8\x94\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9B"],
        ["\x62\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x95"],

        ["\xE8\x94\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\x9C"],
        ["\x62\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x94"],

        ["\xE8\x93\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x8B"],
        ["\x51\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBC"],

        ["\xE8\x95\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA0"],
        ["\x62\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x80"],

        ["\xE8\x95\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA2"],
        ["\x62\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA3"],

        ["\xE8\x95\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA3"],
        ["\x62\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x98"],

        ["\xE8\x95\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA4"],
        ["\x62\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x88"],

        ["\xE8\x95\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA5"],
        ["\x62\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x81"],

        ["\xE8\x98\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x96"],
        ["\x54\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x82"],

        ["\xE8\x95\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA7"],
        ["\x62\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8B"],

        ["\xE8\x95\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xA9"],
        ["\x62\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x95"],

        ["\xE8\x96\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAA"],
        ["\x62\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x80"],

        ["\xE8\x96\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAB"],
        ["\x62\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA4"],

        ["\xE8\x96\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAC"],
        ["\x62\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x88"],

        ["\xE8\x96\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAD"],
        ["\x62\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x91"],

        ["\xE8\x96\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAE"],
        ["\x62\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8A"],

        ["\xE8\x96\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xAF"],
        ["\x62\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA8"],

        ["\xE8\x95\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB0"],
        ["\x62\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAD"],

        ["\xE8\x96\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB1"],
        ["\x62\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x94"],

        ["\xE8\x96\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB2"],
        ["\x62\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9B"],

        ["\xE8\x97\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C\x95"],
        ["\x4C\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xAA"],

        ["\xE8\x96\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB4"],
        ["\x62\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x87"],

        ["\xE8\x96\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB5"],
        ["\x62\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9C"],

        ["\xE8\x95\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB6"],
        ["\x62\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xB7"],

        ["\xE8\x95\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB7"],
        ["\x62\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBE"],

        ["\xE8\x96\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xB8"],
        ["\x62\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x90"],

        ["\xE8\x97\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBC"],
        ["\x62\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x89"],

        ["\xE8\x96\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBD"],
        ["\x62\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xBA"],

        ["\xE8\x97\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBE"],
        ["\x62\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8F"],

        ["\xE8\x96\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xBF"],
        ["\x62\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB9"],

        ["\xE8\x97\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC0"],
        ["\x62\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x90"],

        ["\xE8\x97\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC1"],
        ["\x62\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x95"],

        ["\xE8\x97\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC2"],
        ["\x62\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9D"],

        ["\xE8\x97\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC3"],
        ["\x62\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA5"],

        ["\xE8\x97\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],
        ["\x62\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9C"],

        ["\xE8\x97\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC5"],
        ["\x62\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB9"],

        ["\xE8\x98\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC6"],
        ["\x62\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8A"],

        ["\xE8\x98\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC7"],
        ["\x62\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x93"],

        ["\xE8\x98\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC8"],
        ["\x62\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8B"],

        ["\xE8\x97\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xC9"],
        ["\x62\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBE"],

        ["\xE8\x97\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\xED"],
        ["\x53\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBA"],

        ["\xE8\x98\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\xDA"],
        ["\x4E\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x86"],

        ["\xE8\x98\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCA"],
        ["\x62\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA2"],

        ["\xE8\x98\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCB"],
        ["\x62\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x9A"],

        ["\xE8\x98\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCC"],
        ["\x62\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB0"],

        ["\xE8\x98\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCD"],
        ["\x62\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xBF"],

        ["\xE8\x99\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xCF"],
        ["\x62\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8D"],

        ["\xE4\xB9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"],
        ["\x62\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x95"],

        ["\xE8\x99\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xFB"],
        ["\x52\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x94"],

        ["\xE8\x99\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD2"],
        ["\x62\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9F"],

        ["\xE8\x99\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD3"],
        ["\x62\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xA7"],

        ["\xE8\x99\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD4"],
        ["\x62\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB1"],

        ["\xE8\x9A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD5"],
        ["\x62\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x93"],

        ["\xE8\x9A\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD6"],
        ["\x62\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA3"],

        ["\xE8\x9A\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD7"],
        ["\x62\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA9"],

        ["\xE8\x9A\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"],
        ["\x62\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAA"],

        ["\xE8\x9A\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xD8"],
        ["\x62\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8B"],

        ["\xE8\x9A\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDA"],
        ["\x62\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8C"],

        ["\xE8\x9A\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDB"],
        ["\x62\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB6"],

        ["\xE8\x9A\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDC"],
        ["\x62\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAF"],

        ["\xE8\x9B\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDD"],
        ["\x62\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x84"],

        ["\xE8\x9B\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDE"],
        ["\x62\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x86"],

        ["\xE8\x9A\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xDF"],
        ["\x62\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB0"],

        ["\xE8\x9B\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE0"],
        ["\x62\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x89"],

        ["\xE8\xA0\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x51"],
        ["\x53\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA3"],

        ["\xE8\x9A\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE3"],
        ["\x62\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAB"],

        ["\xE8\x9B\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"],
        ["\x62\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x94"],

        ["\xE8\x9B\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"],
        ["\x62\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9E"],

        ["\xE8\x9B\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE6"],
        ["\x62\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA9"],

        ["\xE8\x9B\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE7"],
        ["\x62\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAC"],

        ["\xE8\x9B\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE8"],
        ["\x62\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9F"],

        ["\xE8\x9B\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xE9"],
        ["\x62\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9B"],

        ["\xE8\x9B\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F\x74"],
        ["\x4F\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAF"],

        ["\xE8\x9C\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEA"],
        ["\x62\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x92"],

        ["\xE8\x9C\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEB"],
        ["\x62\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x86"],

        ["\xE8\x9C\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEC"],
        ["\x62\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x88"],

        ["\xE8\x9C\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xED"],
        ["\x62\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x80"],

        ["\xE8\x9C\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEE"],
        ["\x62\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x83"],

        ["\xE8\x9B\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xEF"],
        ["\x62\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBB"],

        ["\xE8\x9C\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF0"],
        ["\x62\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x91"],

        ["\xE8\x9C\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF1"],
        ["\x62\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x89"],

        ["\xE8\x9C\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF2"],
        ["\x62\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8D"],

        ["\xE8\x9B\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF3"],
        ["\x62\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB9"],

        ["\xE8\x9C\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF4"],
        ["\x62\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8A"],

        ["\xE8\x9C\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF5"],
        ["\x62\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB4"],

        ["\xE8\x9C\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF6"],
        ["\x62\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBF"],

        ["\xE8\x9C\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x6D"],
        ["\x52\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB7"],

        ["\xE8\x9C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF7"],
        ["\x62\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBB"],

        ["\xE8\x9C\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF8"],
        ["\x62\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA5"],

        ["\xE8\x9C\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xF9"],
        ["\x62\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA9"],

        ["\xE8\x9C\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFA"],
        ["\x62\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9A"],

        ["\xE8\x9D\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x46"],
        ["\x63\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA0"],

        ["\xE8\x9D\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFB"],
        ["\x62\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x9F"],

        ["\xE8\x9D\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFC"],
        ["\x62\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB8"],

        ["\xE8\x9D\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFD"],
        ["\x62\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8C"],

        ["\xE8\x9D\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x62\xFE"],
        ["\x62\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8E"],

        ["\xE8\x9D\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x41"],
        ["\x63\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB4"],

        ["\xE8\x9D\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x42"],
        ["\x63\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x97"],

        ["\xE8\x9D\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x43"],
        ["\x63\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA8"],

        ["\xE8\x9D\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x47"],
        ["\x63\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAE"],

        ["\xE8\x9D\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x48"],
        ["\x63\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x99"],

        ["\xE8\x9D\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x49"],
        ["\x63\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x93"],

        ["\xE8\x9D\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],
        ["\x63\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA3"],

        ["\xE8\x9D\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x45"],
        ["\x63\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAA"],

        ["\xE8\xA0\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\xBD"],
        ["\x55\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x85"],

        ["\xE8\x9E\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],
        ["\x63\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA2"],

        ["\xE8\x9E\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],
        ["\x63\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x9F"],

        ["\xE8\x9E\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x44"],
        ["\x63\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x82"],

        ["\xE8\x9E\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],
        ["\x63\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAF"],

        ["\xE8\x9F\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],
        ["\x63\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x8B"],

        ["\xE8\x9E\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x51"],
        ["\x63\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBD"],

        ["\xE8\x9F\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x52"],
        ["\x63\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x80"],

        ["\xE8\x9F\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x53"],
        ["\x63\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x90"],

        ["\xE9\x9B\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x54"],
        ["\x63\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x96"],

        ["\xE8\x9E\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x55"],
        ["\x63\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAB"],

        ["\xE8\x9F\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x56"],
        ["\x63\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x84"],

        ["\xE8\x9E\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],
        ["\x63\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xB3"],

        ["\xE8\x9F\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xF4"],
        ["\x54\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x87"],

        ["\xE8\x9F\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],
        ["\x63\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x86"],

        ["\xE8\x9E\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],
        ["\x63\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBB"],

        ["\xE8\x9F\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],
        ["\x63\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAF"],

        ["\xE8\x9F\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],
        ["\x63\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB2"],

        ["\xE8\x9F\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],
        ["\x63\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA0"],

        ["\xE8\xA0\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],
        ["\x63\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8F"],

        ["\xE8\xA0\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],
        ["\x63\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8D"],

        ["\xE8\x9F\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],
        ["\x63\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBE"],

        ["\xE8\x9F\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],
        ["\x63\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB6"],

        ["\xE8\x9F\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],
        ["\x63\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB7"],

        ["\xE8\xA0\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],
        ["\x63\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8E"],

        ["\xE8\x9F\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x58"],
        ["\x63\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x92"],

        ["\xE8\xA0\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],
        ["\x63\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x91"],

        ["\xE8\xA0\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],
        ["\x63\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x96"],

        ["\xE8\xA0\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],
        ["\x63\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x95"],

        ["\xE8\xA0\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],
        ["\x63\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA2"],

        ["\xE8\xA0\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],
        ["\x63\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA1"],

        ["\xE8\xA0\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],
        ["\x63\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB1"],

        ["\xE8\xA0\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],
        ["\x63\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB6"],

        ["\xE8\xA0\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],
        ["\x63\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB9"],

        ["\xE8\xA0\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],
        ["\x63\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA7"],

        ["\xE8\xA0\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],
        ["\x63\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xBB"],

        ["\xE8\xA1\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],
        ["\x63\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x84"],

        ["\xE8\xA1\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],
        ["\x63\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x82"],

        ["\xE8\xA1\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],
        ["\x63\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x92"],

        ["\xE8\xA1\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],
        ["\x63\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x99"],

        ["\xE8\xA1\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],
        ["\x63\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9E"],

        ["\xE8\xA1\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],
        ["\x63\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA2"],

        ["\xE8\xA1\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],
        ["\x63\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xAB"],

        ["\xE8\xA2\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],
        ["\x63\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x81"],

        ["\xE8\xA1\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],
        ["\x63\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBE"],

        ["\xE8\xA2\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],
        ["\x63\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x9E"],

        ["\xE8\xA1\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],
        ["\x63\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB5"],

        ["\xE8\xA1\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],
        ["\x63\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBD"],

        ["\xE8\xA2\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x85"],
        ["\x63\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB5"],

        ["\xE8\xA1\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],
        ["\x63\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB2"],

        ["\xE8\xA2\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],
        ["\x63\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x82"],

        ["\xE8\xA2\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],
        ["\x63\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x97"],

        ["\xE8\xA2\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],
        ["\x63\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x92"],

        ["\xE8\xA2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x7F"],
        ["\x63\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAE"],

        ["\xE8\xA2\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x80"],
        ["\x63\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x99"],

        ["\xE8\xA2\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x81"],
        ["\x63\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA2"],

        ["\xE8\xA2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x82"],
        ["\x63\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8D"],

        ["\xE8\xA2\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x83"],
        ["\x63\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA4"],

        ["\xE8\xA2\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC5"],
        ["\x54\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB0"],

        ["\xE8\xA2\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x84"],
        ["\x63\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBF"],

        ["\xE8\xA2\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x86"],
        ["\x63\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB1"],

        ["\xE8\xA3\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x87"],
        ["\x63\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x83"],

        ["\xE8\xA3\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x88"],
        ["\x63\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x84"],

        ["\xE8\xA3\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x89"],
        ["\x63\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x94"],

        ["\xE8\xA3\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8A"],
        ["\x63\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x98"],

        ["\xE8\xA3\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8B"],
        ["\x63\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x99"],

        ["\xE8\xA3\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8C"],
        ["\x63\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9D"],

        ["\xE8\xA3\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8D"],
        ["\x63\x8D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB9"],

        ["\xE8\xA4\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8E"],
        ["\x63\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x82"],

        ["\xE8\xA3\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x8F"],
        ["\x63\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBC"],

        ["\xE8\xA3\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x49"],
        ["\x53\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB4"],

        ["\xE8\xA3\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x91"],
        ["\x63\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA8"],

        ["\xE8\xA3\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x92"],
        ["\x63\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB2"],

        ["\xE8\xA4\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x93"],
        ["\x63\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x84"],

        ["\xE8\xA4\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x94"],
        ["\x63\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8C"],

        ["\xE8\xA4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x97"],
        ["\x63\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8A"],

        ["\xE8\xA4\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x98"],
        ["\x63\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x93"],

        ["\xE8\xA5\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9F"],
        ["\x63\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x83"],

        ["\xE8\xA4\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x99"],
        ["\x63\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9E"],

        ["\xE8\xA4\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9A"],
        ["\x63\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xA5"],

        ["\xE8\xA4\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x95"],
        ["\x63\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAA"],

        ["\xE8\xA4\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9B"],
        ["\x63\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAB"],

        ["\xE8\xA5\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9C"],
        ["\x63\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x81"],

        ["\xE8\xA5\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],
        ["\x50\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x84"],

        ["\xE8\xA4\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9D"],
        ["\x63\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xBB"],

        ["\xE8\xA4\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x9E"],
        ["\x63\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB6"],

        ["\xE8\xA4\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA0"],
        ["\x63\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB8"],

        ["\xE8\xA5\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA2"],
        ["\x63\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8C"],

        ["\xE8\xA4\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\x96"],
        ["\x63\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9D"],

        ["\xE8\xA5\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA3"],
        ["\x63\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA0"],

        ["\xE8\xA5\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA4"],
        ["\x63\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9E"],

        ["\xE8\xA5\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA5"],
        ["\x63\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA6"],

        ["\xE8\xA5\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA7"],
        ["\x63\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA4"],

        ["\xE8\xA5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA8"],
        ["\x63\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAD"],

        ["\xE8\xA5\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA6"],
        ["\x63\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAA"],

        ["\xE8\xA5\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xA9"],
        ["\x63\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAF"],

        ["\xE8\xA5\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAA"],
        ["\x63\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB4"],

        ["\xE8\xA5\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAB"],
        ["\x63\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB7"],

        ["\xE8\xA5\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAC"],
        ["\x63\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBE"],

        ["\xE8\xA6\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAD"],
        ["\x63\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x83"],

        ["\xE8\xA6\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAE"],
        ["\x63\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x88"],

        ["\xE8\xA6\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xAF"],
        ["\x63\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8A"],

        ["\xE8\xA6\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB0"],
        ["\x63\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x93"],

        ["\xE8\xA6\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB1"],
        ["\x63\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x98"],

        ["\xE8\xA6\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB2"],
        ["\x63\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA1"],

        ["\xE8\xA6\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB3"],
        ["\x63\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA9"],

        ["\xE8\xA6\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB4"],
        ["\x63\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA6"],

        ["\xE8\xA6\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB5"],
        ["\x63\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAC"],

        ["\xE8\xA6\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB6"],
        ["\x63\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAF"],

        ["\xE8\xA6\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB7"],
        ["\x63\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB2"],

        ["\xE8\xA6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB8"],
        ["\x63\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBA"],

        ["\xE8\xA6\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBA"],
        ["\x63\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBD"],

        ["\xE8\xA6\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xB9"],
        ["\x63\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBF"],

        ["\xE8\xA7\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBB"],
        ["\x63\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x80"],

        ["\xE8\xA7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBC"],
        ["\x63\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9A"],

        ["\xE8\xA7\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x60"],
        ["\x53\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9C"],

        ["\xE8\xA7\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBD"],
        ["\x63\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9D"],

        ["\xE8\xA7\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBE"],
        ["\x63\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA7"],

        ["\xE8\xA7\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xBF"],
        ["\x63\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB4"],

        ["\xE8\xA7\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC0"],
        ["\x63\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB8"],

        ["\xE8\xA8\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC1"],
        ["\x63\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x83"],

        ["\xE8\xA8\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC2"],
        ["\x63\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x96"],

        ["\xE8\xA8\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC3"],
        ["\x63\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x90"],

        ["\xE8\xA8\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC4"],
        ["\x63\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8C"],

        ["\xE8\xA8\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC6"],
        ["\x63\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9B"],

        ["\xE8\xA8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC7"],
        ["\x63\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9D"],

        ["\xE8\xA8\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC8"],
        ["\x63\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA5"],

        ["\xE8\xA8\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xC9"],
        ["\x63\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB6"],

        ["\xE8\xA9\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCA"],
        ["\x63\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x81"],

        ["\xE8\xA9\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCC"],
        ["\x63\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9B"],

        ["\xE8\xA9\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCD"],
        ["\x63\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x92"],

        ["\xE8\xA9\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCE"],
        ["\x63\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x86"],

        ["\xE8\xA9\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xCF"],
        ["\x63\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x88"],

        ["\xE8\xA9\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD0"],
        ["\x63\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xBC"],

        ["\xE8\xA9\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD1"],
        ["\x63\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAD"],

        ["\xE8\xA9\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD2"],
        ["\x63\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAC"],

        ["\xE8\xA9\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD3"],
        ["\x63\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA2"],

        ["\xE8\xAA\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD5"],
        ["\x63\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x85"],

        ["\xE8\xAA\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD6"],
        ["\x63\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x82"],

        ["\xE8\xAA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD7"],
        ["\x63\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x84"],

        ["\xE8\xAA\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD8"],
        ["\x63\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA8"],

        ["\xE8\xAA\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xD9"],
        ["\x63\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA1"],

        ["\xE8\xAA\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDA"],
        ["\x63\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x91"],

        ["\xE8\xAA\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDB"],
        ["\x63\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA5"],

        ["\xE8\xAA\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDC"],
        ["\x63\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA6"],

        ["\xE8\xAA\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDD"],
        ["\x63\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9A"],

        ["\xE8\xAA\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xDE"],
        ["\x63\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA3"],

        ["\xE8\xAB\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xB2"],
        ["\x50\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x84"],

        ["\xE8\xAB\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE2"],
        ["\x63\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8D"],

        ["\xE8\xAB\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE3"],
        ["\x63\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x82"],

        ["\xE8\xAB\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE4"],
        ["\x63\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9A"],

        ["\xE8\xAB\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x96"],
        ["\x4E\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAB"],

        ["\xE8\xAB\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE5"],
        ["\x63\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB3"],

        ["\xE8\xAB\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE6"],
        ["\x63\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA7"],

        ["\xE8\xAB\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE7"],
        ["\x63\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA4"],

        ["\xE8\xAB\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE8"],
        ["\x63\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB1"],

        ["\xE8\xAC\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xE9"],
        ["\x63\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x94"],

        ["\xE8\xAB\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xEA"],
        ["\x63\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA0"],

        ["\xE8\xAB\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xEB"],
        ["\x63\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA2"],

        ["\xE8\xAB\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF0"],
        ["\x63\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB7"],

        ["\xE8\xAB\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"],
        ["\x63\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9E"],

        ["\xE8\xAB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF2"],
        ["\x63\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9B"],

        ["\xE8\xAC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF3"],
        ["\x63\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8C"],

        ["\xE8\xAC\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF4"],
        ["\x63\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x87"],

        ["\xE8\xAC\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF5"],
        ["\x63\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9A"],

        ["\xE8\xAB\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xEC"],
        ["\x63\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA1"],

        ["\xE8\xAC\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF6"],
        ["\x63\xF6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x96"],

        ["\xE8\xAC\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF7"],
        ["\x63\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x90"],

        ["\xE8\xAC\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"],
        ["\x63\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x97"],

        ["\xE8\xAC\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xF9"],
        ["\x63\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA0"],

        ["\xE8\xAC\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFA"],
        ["\x63\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB3"],

        ["\xE9\x9E\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFC"],
        ["\x63\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAB"],

        ["\xE8\xAC\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFD"],
        ["\x63\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA6"],

        ["\xE8\xAC\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFE"],
        ["\x63\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAB"],

        ["\xE8\xAC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x41"],
        ["\x64\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xBE"],

        ["\xE8\xAC\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x81"],
        ["\x53\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA8"],

        ["\xE8\xAD\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x63\xFB"],
        ["\x63\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x81"],

        ["\xE8\xAD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x42"],
        ["\x64\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8C"],

        ["\xE8\xAD\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x43"],
        ["\x64\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8F"],

        ["\xE8\xAD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x44"],
        ["\x64\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8E"],

        ["\xE8\xAD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x46"],
        ["\x64\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x89"],

        ["\xE8\xAD\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x47"],
        ["\x64\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x96"],

        ["\xE8\xAD\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x48"],
        ["\x64\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9B"],

        ["\xE8\xAD\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x49"],
        ["\x64\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9A"],

        ["\xE8\xAD\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],
        ["\x64\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAB"],

        ["\xE8\xAD\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],
        ["\x64\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9F"],

        ["\xE8\xAD\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],
        ["\x64\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAC"],

        ["\xE8\xAD\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],
        ["\x64\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAF"],

        ["\xE8\xAD\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],
        ["\x64\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB4"],

        ["\xE8\xAD\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],
        ["\x64\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBD"],

        ["\xE8\xAE\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x51"],
        ["\x64\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x80"],

        ["\xE8\xAE\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x52"],
        ["\x64\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8C"],

        ["\xE8\xAE\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x53"],
        ["\x64\x53",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8E"],

        ["\xE8\xAE\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x55"],
        ["\x64\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x92"],

        ["\xE8\xAE\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x56"],
        ["\x64\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x93"],

        ["\xE8\xAE\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],
        ["\x64\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x96"],

        ["\xE8\xAE\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x54"],
        ["\x64\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x99"],

        ["\xE8\xAE\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x58"],
        ["\x64\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9A"],

        ["\xE8\xB0\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],
        ["\x64\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBA"],

        ["\xE8\xB1\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],
        ["\x64\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x81"],

        ["\xE8\xB0\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],
        ["\x64\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBF"],

        ["\xE8\xB1\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],
        ["\x64\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x88"],

        ["\xE8\xB1\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],
        ["\x64\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8C"],

        ["\xE8\xB1\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],
        ["\x64\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8E"],

        ["\xE8\xB1\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],
        ["\x64\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x90"],

        ["\xE8\xB1\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],
        ["\x64\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x95"],

        ["\xE8\xB1\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],
        ["\x64\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA2"],

        ["\xE8\xB1\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],
        ["\x64\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAC"],

        ["\xE8\xB1\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],
        ["\x64\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB8"],

        ["\xE8\xB1\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],
        ["\x64\x64",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBA"],

        ["\xE8\xB2\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],
        ["\x64\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x82"],

        ["\xE8\xB2\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],
        ["\x64\x67",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x89"],

        ["\xE8\xB2\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],
        ["\x64\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x85"],

        ["\xE8\xB2\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],
        ["\x64\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8A"],

        ["\xE8\xB2\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],
        ["\x64\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8D"],

        ["\xE8\xB2\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],
        ["\x64\x6B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8E"],

        ["\xE8\xB2\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],
        ["\x64\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x94"],

        ["\xE8\xB1\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],
        ["\x64\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBC"],

        ["\xE8\xB2\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],
        ["\x64\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x98"],

        ["\xE6\x88\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],
        ["\x64\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9D"],

        ["\xE8\xB2\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],
        ["\x64\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAD"],

        ["\xE8\xB2\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],
        ["\x64\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAA"],

        ["\xE8\xB2\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],
        ["\x64\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBD"],

        ["\xE8\xB2\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],
        ["\x64\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB2"],

        ["\xE8\xB2\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],
        ["\x64\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB3"],

        ["\xE8\xB2\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],
        ["\x64\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAE"],

        ["\xE8\xB2\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],
        ["\x64\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB6"],

        ["\xE8\xB3\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],
        ["\x64\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x88"],

        ["\xE8\xB3\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],
        ["\x64\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x81"],

        ["\xE8\xB3\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x66"],
        ["\x55\x66",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA4"],

        ["\xE8\xB3\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],
        ["\x64\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA3"],

        ["\xE8\xB3\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],
        ["\x64\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9A"],

        ["\xE8\xB3\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],
        ["\x64\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBD"],

        ["\xE8\xB3\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x7F"],
        ["\x64\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBA"],

        ["\xE8\xB3\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x80"],
        ["\x64\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBB"],

        ["\xE8\xB4\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x5A"],
        ["\x53\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x84"],

        ["\xE8\xB4\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x55\x74"],
        ["\x55\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x85"],

        ["\xE8\xB4\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x82"],
        ["\x64\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8A"],

        ["\xE8\xB4\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x81"],
        ["\x64\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x87"],

        ["\xE8\xB4\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x83"],
        ["\x64\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8F"],

        ["\xE8\xB4\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x84"],
        ["\x64\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8D"],

        ["\xE8\xB4\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x86"],
        ["\x64\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x90"],

        ["\xE9\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],
        ["\x68\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8E"],

        ["\xE8\xB4\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x87"],
        ["\x64\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x93"],

        ["\xE8\xB3\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],
        ["\x64\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8D"],

        ["\xE8\xB4\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x88"],
        ["\x64\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x94"],

        ["\xE8\xB4\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x89"],
        ["\x64\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x96"],

        ["\xE8\xB5\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x8A"],
        ["\x64\x8A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA7"],

        ["\xE8\xB5\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x8B"],
        ["\x64\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAD"],

        ["\xE8\xB5\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x8C"],
        ["\x64\x8C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB1"],

        ["\xE8\xB5\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xC9"],
        ["\x51\xC9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB3"],

        ["\xE8\xB6\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x8F"],
        ["\x64\x8F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x81"],

        ["\xE8\xB6\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xDE"],
        ["\x51\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x99"],

        ["\xE8\xB7\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x90"],
        ["\x64\x90",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x82"],

        ["\xE8\xB6\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x91"],
        ["\x64\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBE"],

        ["\xE8\xB6\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x92"],
        ["\x64\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBA"],

        ["\xE8\xB7\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x93"],
        ["\x64\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8F"],

        ["\xE8\xB7\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x94"],
        ["\x64\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9A"],

        ["\xE8\xB7\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x95"],
        ["\x64\x95",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x96"],

        ["\xE8\xB7\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x96"],
        ["\x64\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8C"],

        ["\xE8\xB7\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x97"],
        ["\x64\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9B"],

        ["\xE8\xB7\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x98"],
        ["\x64\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8B"],

        ["\xE8\xB7\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x99"],
        ["\x64\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAA"],

        ["\xE8\xB7\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9A"],
        ["\x64\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAB"],

        ["\xE8\xB7\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9B"],
        ["\x64\x9B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9F"],

        ["\xE8\xB7\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9C"],
        ["\x64\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA3"],

        ["\xE8\xB7\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9D"],
        ["\x64\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBC"],

        ["\xE8\xB8\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9E"],
        ["\x64\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x88"],

        ["\xE8\xB8\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA0"],
        ["\x64\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x89"],

        ["\xE8\xB7\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\x9F"],
        ["\x64\x9F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBF"],

        ["\xE8\xB8\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA1"],
        ["\x64\xA1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9D"],

        ["\xE8\xB8\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA2"],
        ["\x64\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9E"],

        ["\xE8\xB8\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA3"],
        ["\x64\xA3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x90"],

        ["\xE8\xB8\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA4"],
        ["\x64\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9F"],

        ["\xE8\xB9\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA5"],
        ["\x64\xA5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x82"],

        ["\xE8\xB8\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA6"],
        ["\x64\xA6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB5"],

        ["\xE8\xB8\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA7"],
        ["\x64\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB0"],

        ["\xE8\xB8\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA8"],
        ["\x64\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB4"],

        ["\xE8\xB9\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xA9"],
        ["\x64\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8A"],

        ["\xE8\xB9\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAA"],
        ["\x64\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x87"],

        ["\xE8\xB9\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAB"],
        ["\x64\xAB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x89"],

        ["\xE8\xB9\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAC"],
        ["\x64\xAC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8C"],

        ["\xE8\xB9\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAD"],
        ["\x64\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x90"],

        ["\xE8\xB9\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAE"],
        ["\x64\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x88"],

        ["\xE8\xB9\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xAF"],
        ["\x64\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x99"],

        ["\xE8\xB9\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB0"],
        ["\x64\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA4"],

        ["\xE8\xB9\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB1"],
        ["\x64\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA0"],

        ["\xE8\xB8\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xFC"],
        ["\x50\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xAA"],

        ["\xE8\xB9\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB3"],
        ["\x64\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA3"],

        ["\xE8\xB9\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB2"],
        ["\x64\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x95"],

        ["\xE8\xB9\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB4"],
        ["\x64\xB4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB6"],

        ["\xE8\xB9\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB5"],
        ["\x64\xB5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB2"],

        ["\xE8\xB9\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB7"],
        ["\x64\xB7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xBC"],

        ["\xE8\xBA\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB8"],
        ["\x64\xB8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x81"],

        ["\xE8\xBA\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB6"],
        ["\x64\xB6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x87"],

        ["\xE8\xBA\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xB9"],
        ["\x64\xB9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x85"],

        ["\xE8\xBA\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBA"],
        ["\x64\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x84"],

        ["\xE8\xBA\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBB"],
        ["\x64\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8B"],

        ["\xE8\xBA\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBC"],
        ["\x64\xBC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8A"],

        ["\xE8\xBA\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBD"],
        ["\x64\xBD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x93"],

        ["\xE8\xBA\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBE"],
        ["\x64\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x91"],

        ["\xE8\xBA\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xBF"],
        ["\x64\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x94"],

        ["\xE8\xBA\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC0"],
        ["\x64\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x99"],

        ["\xE8\xBA\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC2"],
        ["\x64\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAA"],

        ["\xE8\xBA\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC1"],
        ["\x64\xC1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xA1"],

        ["\xE8\xBA\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\x44"],
        ["\x50\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAC"],

        ["\xE8\xBA\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7A"],
        ["\x53\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB0"],

        ["\xE8\xBB\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC5"],
        ["\x64\xC5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x86"],

        ["\xE8\xBA\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC3"],
        ["\x64\xC3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB1"],

        ["\xE8\xBA\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC4"],
        ["\x64\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xBE"],

        ["\xE8\xBB\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC6"],
        ["\x64\xC6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x85"],

        ["\xE8\xBB\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC7"],
        ["\x64\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x88"],

        ["\xE8\xBB\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xC8"],
        ["\x64\xC8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8B"],

        ["\xE8\xBB\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCA"],
        ["\x64\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9B"],

        ["\xE8\xBB\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCB"],
        ["\x64\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA3"],

        ["\xE8\xBB\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCC"],
        ["\x64\xCC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBC"],

        ["\xE8\xBB\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCD"],
        ["\x64\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBB"],

        ["\xE8\xBB\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCE"],
        ["\x64\xCE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xAB"],

        ["\xE8\xBB\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xCF"],
        ["\x64\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBE"],

        ["\xE8\xBC\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"],
        ["\x64\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8A"],

        ["\xE8\xBC\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"],
        ["\x64\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x85"],

        ["\xE8\xBC\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD3"],
        ["\x64\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x95"],

        ["\xE8\xBC\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD4"],
        ["\x64\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x92"],

        ["\xE8\xBC\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD7"],
        ["\x64\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x99"],

        ["\xE8\xBC\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD5"],
        ["\x64\xD5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x93"],

        ["\xE8\xBC\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD6"],
        ["\x64\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9C"],

        ["\xE8\xBC\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD8"],
        ["\x64\xD8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9F"],

        ["\xE8\xBC\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x5B"],
        ["\x51\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9B"],

        ["\xE8\xBC\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD1"],
        ["\x64\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8C"],

        ["\xE8\xBC\xA6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xD9"],
        ["\x64\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA6"],

        ["\xE8\xBC\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDA"],
        ["\x64\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB3"],

        ["\xE8\xBC\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDB"],
        ["\x64\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBB"],

        ["\xE8\xBC\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDC"],
        ["\x64\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB9"],

        ["\xE8\xBD\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDD"],
        ["\x64\xDD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x85"],

        ["\xE8\xBD\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDE"],
        ["\x64\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x82"],

        ["\xE8\xBC\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xDF"],
        ["\x64\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBE"],

        ["\xE8\xBD\x8C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE2"],
        ["\x64\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8C"],

        ["\xE8\xBD\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE0"],
        ["\x64\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x89"],

        ["\xE8\xBD\x86",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE1"],
        ["\x64\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x86"],

        ["\xE8\xBD\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE3"],
        ["\x64\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8E"],

        ["\xE8\xBD\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"],
        ["\x64\xE4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x97"],

        ["\xE8\xBD\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"],
        ["\x64\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9C"],

        ["\xE8\xBD\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE6"],
        ["\x64\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA2"],

        ["\xE8\xBD\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE7"],
        ["\x64\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA3"],

        ["\xE8\xBD\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"],
        ["\x64\xE8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA4"],

        ["\xE8\xBE\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xE9"],
        ["\x64\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9C"],

        ["\xE8\xBE\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEA"],
        ["\x64\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9F"],

        ["\xE8\xBE\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEB"],
        ["\x64\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA3"],

        ["\xE8\xBE\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEE"],
        ["\x64\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAD"],

        ["\xE8\xBE\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xEF"],
        ["\x64\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAF"],

        ["\xE8\xBE\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF0"],
        ["\x64\xF0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB7"],

        ["\xE8\xBF\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF2"],
        ["\x64\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x9A"],

        ["\xE8\xBF\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF3"],
        ["\x64\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA5"],

        ["\xE8\xBF\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF4"],
        ["\x64\xF4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA2"],

        ["\xE8\xBF\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E\x9E"],
        ["\x4E\x9E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAA"],

        ["\xE8\xBF\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF5"],
        ["\x64\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAF"],

        ["\xE9\x82\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x86"],
        ["\x51\x86",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x87"],

        ["\xE8\xBF\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF7"],
        ["\x64\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB4"],

        ["\xE9\x80\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF8"],
        ["\x64\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x85"],

        ["\xE8\xBF\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xF9"],
        ["\x64\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB9"],

        ["\xE8\xBF\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xA9"],
        ["\x54\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBA"],

        ["\xE9\x80\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFB"],
        ["\x64\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x91"],

        ["\xE9\x80\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFC"],
        ["\x64\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x95"],

        ["\xE9\x80\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFE"],
        ["\x64\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA1"],

        ["\xE9\x80\x8D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x41"],
        ["\x65\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8D"],

        ["\xE9\x80\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x42"],
        ["\x65\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9E"],

        ["\xE9\x80\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x43"],
        ["\x65\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x96"],

        ["\xE9\x80\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x44"],
        ["\x65\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8B"],

        ["\xE9\x80\xA7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x45"],
        ["\x65\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA7"],

        ["\xE9\x80\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x46"],
        ["\x65\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB6"],

        ["\xE9\x80\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\x85"],
        ["\x54\x85",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB5"],

        ["\xE9\x80\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x47"],
        ["\x65\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB9"],

        ["\xE8\xBF\xB8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFA"],
        ["\x64\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB8"],

        ["\xE9\x81\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x48"],
        ["\x65\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8F"],

        ["\xE9\x81\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],
        ["\x65\x4A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x90"],

        ["\xE9\x81\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],
        ["\x65\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x91"],

        ["\xE9\x81\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],
        ["\x65\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x92"],

        ["\xE9\x80\x8E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x64\xFD"],
        ["\x64\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8E"],

        ["\xE9\x81\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],
        ["\x65\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x89"],

        ["\xE9\x80\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],
        ["\x65\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBE"],

        ["\xE9\x81\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],
        ["\x65\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x96"],

        ["\xE9\x81\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],
        ["\x65\x50",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x98"],

        ["\xE9\x81\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x51"],
        ["\x65\x51",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9E"],

        ["\xE9\x81\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x52"],
        ["\x65\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA8"],

        ["\xE9\x81\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x54"],
        ["\x65\x54",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAF"],

        ["\xE9\x81\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x55"],
        ["\x65\x55",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB6"],

        ["\xE9\x9A\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x56"],
        ["\x65\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA8"],

        ["\xE9\x81\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],
        ["\x65\x57",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB2"],

        ["\xE9\x82\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x58"],
        ["\x65\x58",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x82"],

        ["\xE9\x81\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],
        ["\x65\x59",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBD"],

        ["\xE9\x82\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x7B"],
        ["\x53\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x81"],

        ["\xE9\x82\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],
        ["\x65\x5B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x80"],

        ["\xE9\x82\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xEA"],
        ["\x50\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8A"],

        ["\xE9\x82\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],
        ["\x65\x5A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x89"],

        ["\xE9\x82\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],
        ["\x65\x5C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8F"],

        ["\xE9\x82\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xA8"],
        ["\x51\xA8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA8"],

        ["\xE9\x82\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],
        ["\x65\x5E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAF"],

        ["\xE9\x82\xB1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],
        ["\x65\x5F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB1"],

        ["\xE9\x82\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],
        ["\x65\x60",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB5"],

        ["\xE9\x83\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],
        ["\x65\x61",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA2"],

        ["\xE9\x83\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],
        ["\x65\x62",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA4"],

        ["\xE6\x89\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],
        ["\x65\x5D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x88"],

        ["\xE9\x83\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],
        ["\x65\x63",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9B"],

        ["\xE9\x84\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],
        ["\x65\x65",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x82"],

        ["\xE9\x84\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],
        ["\x65\x68",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x92"],

        ["\xE9\x84\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],
        ["\x65\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x99"],

        ["\xE9\x84\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],
        ["\x65\x6A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB2"],

        ["\xE9\x84\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],
        ["\x65\x6C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB0"],

        ["\xE9\x85\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],
        ["\x65\x6D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8A"],

        ["\xE9\x85\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],
        ["\x65\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x96"],

        ["\xE9\x85\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],
        ["\x65\x6F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x98"],

        ["\xE9\x85\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],
        ["\x65\x70",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA3"],

        ["\xE9\x85\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],
        ["\x65\x71",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA5"],

        ["\xE9\x85\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],
        ["\x65\x72",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA9"],

        ["\xE9\x85\xB3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],
        ["\x65\x73",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB3"],

        ["\xE9\x85\xB2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],
        ["\x65\x74",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB2"],

        ["\xE9\x86\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],
        ["\x65\x75",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8B"],

        ["\xE9\x86\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],
        ["\x65\x76",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x89"],

        ["\xE9\x86\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],
        ["\x65\x77",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x82"],

        ["\xE9\x86\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],
        ["\x65\x78",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA2"],

        ["\xE9\x86\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],
        ["\x65\x79",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAB"],

        ["\xE9\x86\xAF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],
        ["\x65\x7A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAF"],

        ["\xE9\x86\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],
        ["\x65\x7B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAA"],

        ["\xE9\x86\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],
        ["\x65\x7C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB5"],

        ["\xE9\x86\xB4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],
        ["\x65\x7D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB4"],

        ["\xE9\x86\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],
        ["\x65\x7E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xBA"],

        ["\xE9\x87\x80",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x7F"],
        ["\x65\x7F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x80"],

        ["\xE9\x87\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x80"],
        ["\x65\x80",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x81"],

        ["\xE9\x87\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x52"],
        ["\x52\x52",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x89"],

        ["\xE9\x87\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x81"],
        ["\x65\x81",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8B"],

        ["\xE9\x87\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x82"],
        ["\x65\x82",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x90"],

        ["\xE9\x87\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x87"],
        ["\x65\x87",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x96"],

        ["\xE9\x87\x9F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x88"],
        ["\x65\x88",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9F"],

        ["\xE9\x87\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x89"],
        ["\x65\x89",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA1"],

        ["\xE9\x87\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x84"],
        ["\x65\x84",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9B"],

        ["\xE9\x87\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xD0"],
        ["\x51\xD0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBC"],

        ["\xE9\x87\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x8B"],
        ["\x65\x8B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB5"],

        ["\xE9\x87\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x8E"],
        ["\x65\x8E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB6"],

        ["\xE9\x88\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x91"],
        ["\x65\x91",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x9E"],

        ["\xE9\x87\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x92"],
        ["\x65\x92",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBF"],

        ["\xE9\x88\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x94"],
        ["\x65\x94",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x94"],

        ["\xE9\x88\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x96"],
        ["\x65\x96",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xAC"],

        ["\xE9\x88\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x97"],
        ["\x65\x97",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x95"],

        ["\xE9\x88\x91",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x69"],
        ["\x52\x69",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x91"],

        ["\xE9\x89\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x93"],
        ["\x53\x93",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9E"],

        ["\xE9\x89\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x99"],
        ["\x65\x99",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x97"],

        ["\xE9\x89\x85",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x9A"],
        ["\x65\x9A",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x85"],

        ["\xE9\x89\x89",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x9C"],
        ["\x65\x9C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x89"],

        ["\xE9\x89\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x9D"],
        ["\x65\x9D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA4"],

        ["\xE9\x89\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA0"],
        ["\x65\xA0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x88"],

        ["\xE9\x8A\x95",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB1"],
        ["\x65\xB1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x95"],

        ["\xE9\x88\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA4"],
        ["\x65\xA4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBF"],

        ["\xE9\x89\x8B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA7"],
        ["\x65\xA7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8B"],

        ["\xE9\x89\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA2"],
        ["\x65\xA2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x90"],

        ["\xE9\x8A\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAA"],
        ["\x65\xAA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9C"],

        ["\xE9\x8A\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAE"],
        ["\x65\xAE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x96"],

        ["\xE9\x8A\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xAF"],
        ["\x65\xAF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x93"],

        ["\xE9\x8A\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB0"],
        ["\x65\xB0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9B"],

        ["\xE9\x89\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xA9"],
        ["\x65\xA9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9A"],

        ["\xE9\x8B\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB3"],
        ["\x65\xB3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8F"],

        ["\xE9\x8A\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBA"],
        ["\x65\xBA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB9"],

        ["\xE9\x8A\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBB"],
        ["\x65\xBB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB7"],

        ["\xE9\x8B\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xB2"],
        ["\x65\xB2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA9"],

        ["\xE9\x8C\x8F",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC0"],
        ["\x65\xC0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x8F"],

        ["\xE9\x8B\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC2"],
        ["\x65\xC2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBA"],

        ["\xE9\x8D\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC4"],
        ["\x65\xC4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x84"],

        ["\xE9\x8C\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\x83"],
        ["\x52\x83",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAE"],

        ["\xE9\x8C\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xC7"],
        ["\x65\xC7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x99"],

        ["\xE9\x8C\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCA"],
        ["\x65\xCA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA2"],

        ["\xE9\x8C\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCB"],
        ["\x65\xCB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9A"],

        ["\xE9\x8C\xA3",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCD"],
        ["\x65\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA3"],

        ["\xE9\x8C\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBE"],
        ["\x65\xBE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBA"],

        ["\xE9\x8C\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xBF"],
        ["\x65\xBF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB5"],

        ["\xE9\x8C\xBB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xCF"],
        ["\x65\xCF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBB"],

        ["\xE9\x8D\x9C",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x52\xAD"],
        ["\x52\xAD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9C"],

        ["\xE9\x8D\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"],
        ["\x65\xD1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA0"],

        ["\xE9\x8D\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"],
        ["\x65\xD2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBC"],

        ["\xE9\x8D\xAE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD3"],
        ["\x65\xD3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAE"],

        ["\xE9\x8D\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD4"],
        ["\x65\xD4",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x96"],

        ["\xE9\x8E\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD7"],
        ["\x65\xD7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB0"],

        ["\xE9\x8E\xAC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x53\x6E"],
        ["\x53\x6E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAC"],

        ["\xE9\x8E\xAD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD9"],
        ["\x65\xD9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAD"],

        ["\xE9\x8E\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDA"],
        ["\x65\xDA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x94"],

        ["\xE9\x8E\xB9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xD6"],
        ["\x65\xD6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB9"],

        ["\xE9\x8F\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDC"],
        ["\x65\xDC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x96"],

        ["\xE9\x8F\x97",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDE"],
        ["\x65\xDE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x97"],

        ["\xE9\x8F\xA8",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDF"],
        ["\x65\xDF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA8"],

        ["\xE9\x8F\xA5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE0"],
        ["\x65\xE0",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA5"],

        ["\xE9\x8F\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE1"],
        ["\x65\xE1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x98"],

        ["\xE9\x8F\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE2"],
        ["\x65\xE2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x83"],

        ["\xE9\x8F\x9D",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE3"],
        ["\x65\xE3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9D"],

        ["\xE9\x8F\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE5"],
        ["\x65\xE5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x90"],

        ["\xE9\x8F\x88",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xDB"],
        ["\x65\xDB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x88"],

        ["\xE9\x8F\xA4",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE6"],
        ["\x65\xE6",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA4"],

        ["\xE9\x90\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE7"],
        ["\x65\xE7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x9A"],

        ["\xE9\x90\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xE9"],
        ["\x65\xE9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x94"],

        ["\xE9\x90\x93",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xEA"],
        ["\x65\xEA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x93"],

        ["\xE9\x90\x83",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xEC"],
        ["\x65\xEC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x83"],

        ["\xE9\x90\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xED"],
        ["\x65\xED",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x87"],

        ["\xE9\x90\x90",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\xCD"],
        ["\x51\xCD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x90"],

        ["\xE9\x90\xB6",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xEE"],
        ["\x65\xEE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB6"],

        ["\xE9\x90\xAB",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xEF"],
        ["\x65\xEF",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xAB"],

        ["\xE9\x90\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x51\x56"],
        ["\x51\x56",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB5"],

        ["\xE9\x90\xA1",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xEB"],
        ["\x65\xEB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xA1"],

        ["\xE9\x90\xBA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF1"],
        ["\x65\xF1",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xBA"],

        ["\xE9\x91\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF2"],
        ["\x65\xF2",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x81"],

        ["\xE9\x91\x92",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF3"],
        ["\x65\xF3",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x92"],

        ["\xE9\x91\x84",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF5"],
        ["\x65\xF5",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x84"],

        ["\xE9\x91\x9B",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF7"],
        ["\x65\xF7",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9B"],

        ["\xE9\x91\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF9"],
        ["\x65\xF9",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA0"],

        ["\xE9\x91\xA2",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFA"],
        ["\x65\xFA",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA2"],

        ["\xE9\x91\x9E",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFB"],
        ["\x65\xFB",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9E"],

        ["\xE9\x91\xAA",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFC"],
        ["\x65\xFC",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAA"],

        ["\xE9\x88\xA9",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\x98"],
        ["\x65\x98",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xA9"],

        ["\xE9\x91\xB0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFE"],
        ["\x65\xFE",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB0"],

        ["\xE9\x91\xB5",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xFD"],
        ["\x65\xFD",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB5"],

        ["\xE9\x91\xB7",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x41"],
        ["\x66\x41",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB7"],

        ["\xE9\x91\xBD",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x43"],
        ["\x66\x43",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBD"],

        ["\xE9\x91\x9A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x65\xF8"],
        ["\x65\xF8",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9A"],

        ["\xE9\x91\xBC",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x44"],
        ["\x66\x44",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBC"],

        ["\xE9\x91\xBE",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x45"],
        ["\x66\x45",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBE"],

        ["\xE9\x92\x81",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x46"],
        ["\x66\x46",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x92\x81"],

        ["\xE9\x91\xBF",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x42"],
        ["\x66\x42",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBF"],

        ["\xE9\x96\x82",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x47"],
        ["\x66\x47",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x82"],

        ["\xE9\x96\x87",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x48"],
        ["\x66\x48",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x87"],

        ["\xE9\x96\x8A",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x49"],
        ["\x66\x49",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8A"],

        ["\xE9\x96\x94",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],
        ["\x66\x4B",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x94"],

        ["\xE9\x96\x96",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],
        ["\x66\x4C",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x96"],

        ["\xE9\x96\x98",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],
        ["\x66\x4D",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x98"],

        ["\xE9\x96\x99",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],
        ["\x66\x4E",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x99"],

        ["\xE9\x96\xA0",'cp00930','utf8',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],
        ["\x66\x4F",'utf8','cp00930',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA0"],

      