package SNMP::Insight::Meta::Attribute::Trait::MIBEntry;

#ABSTRACT: Attribute trait for attributes derived from MIBs

use Moose::Role;
use Moose::Util::TypeConstraints;

our $VERSION = '0.002';    #TRIAL VERSION:

Moose::Util::meta_attribute_alias('MIBEntry');

enum 'MIBEntryType', [qw(scalar table column)];

has oid => (
    is        => 'rw',
    isa       => 'Str',
    required  => 1,
    predicate => 'has_oid',
);

has munger => (
    is        => 'rw',
    isa       => 'CodeRef',
    required  => 0,
    predicate => 'has_munger',
);

has entry_type => (
    is       => 'rw',
    isa      => 'MIBEntryType',
    required => 1,
);

sub is_scalar {
    return $_[0]->entry_type eq 'scalar';
}

sub is_table {
    return $_[0]->entry_type eq 'table';
}

sub is_column {
    return $_[0]->entry_type eq 'column';
}

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

SNMP::Insight::Meta::Attribute::Trait::MIBEntry - Attribute trait for attributes derived from MIBs

=head1 VERSION

version 0.002

=head1 ATTRIBUTES

=head2 oid

The oid in the MIB.

=head2 munger

The code reference used, if present, to parse the value retrieved from the device.

=head2 entry_type

One of scalar, table, column.

=head1 METHODS

=head2 is_scalar

Return true if it's a scalar entry

=head2 is_table

Return true if it's a table entry

=head2 is_column

Return true if it's a column entry

=head1 AUTHOR

Gabriele Mambrini <g.mambrini@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
