package App::Manoc::Netwalker::Poller::Scoreboard;
#ABSTRACT: Mantains netwalker workers task status


use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use Moose::Util::TypeConstraints;

enum 'TaskStatus', [qw(DONE QUEUED RUNNING ERROR)];

has _status => (
    is      => 'ro',
    isa     => 'HashRef[HashRef[TaskStatus]]',
    default => sub { {} },
);

has _job => (
    is      => 'ro',
    isa     => 'HashRef[ArrayRef]',
    default => sub { {} },
);


sub get_device_status { shift->_get( 'device', @_ ) }


sub set_device_info { shift->_set( 'device', @_ ) }


sub device_status_list { shift->_status->{device} }


sub get_server_status { shift->_get( 'server', @_ ) }


sub set_server_info { shift->_set( 'server', @_ ) }


sub server_status_list { shift->_status->{server} }


sub get_job_info {
    my ( $self, $job_id ) = @_;

    return $self->_job->{$job_id};
}


sub delete_job_info {
    my ( $self, $job_id ) = @_;

    my $info = $self->_job->{$job_id};

    if ($info) {
        my ( $class, $id ) = @$info;
        delete $self->_status->{$class}->{$id};
        delete $self->_job->{$job_id};
    }
}

# private methods

sub _set {
    my ( $self, $class, $id, $value, $job_id ) = @_;

    defined($job_id) and $self->_job->{$job_id} = [ $class, $id ];
    return $self->_status->{$class}->{$id} = $value;

}

sub _get {
    my ( $self, $class, $id ) = @_;

    return $self->_status->{$class}->{$id};
}

no Moose;
__PACKAGE__->meta->make_immutable;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Netwalker::Poller::Scoreboard - Mantains netwalker workers task status

=head1 VERSION

version 2.99.4

=head1 DESCRIPTION

This class mantains netwalker workers task status.

Status is an an enumeration of C<qw(DONE QUEUED RUNNING ERROR)> and is
mantained for server and device tasks, indexed by their own id.

=head1 METHODS

=head2 get_device_status( $id )

=head2 set_device_info( $id, $status, $jobid )

=head2 device_status_list

=head2 get_server_status

=head2 set_server_info

=head2 server_status_list

=head2 get_job_info

=head2 delete_job_info

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
