package App::Manoc::DB::Search;
#ABSTRACT: Manoc internal search engine

use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use App::Manoc::DB::Search::Result;

has schema => (
    is       => 'ro',
    required => 1,
);

has _sources => (
    is      => 'ro',
    isa     => 'ArrayRef',
    lazy    => 1,
    builder => '_build_sources',
);

sub _build_sources {
    my ($self) = @_;

    my @sources;

    foreach my $name ( $self->schema->sources ) {
        $self->schema->source($name)->resultset->can('manoc_search') and
            push @sources, $name;
    }

    return \@sources;
}


sub search {
    my ( $self, $query ) = @_;

    my $result = App::Manoc::DB::Search::Result->new( { query => $query } );

    foreach my $source ( @{ $self->_sources } ) {
        $self->schema->source($source)->resultset->manoc_search( $query, $result );
    }

    return $result;
}

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::DB::Search - Manoc internal search engine

=head1 VERSION

version 2.99.4

=head1 METHODS

=head2 search($query)

Run a search using the query object C<$query>.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
