package App::Manoc::DB::Result::Group;
#ABSTRACT: A model object for user groups

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->table('groups');
__PACKAGE__->add_columns(
    id => {
        data_type         => 'int',
        is_nullable       => 0,
        is_auto_increment => 1,
    },
    name => {
        data_type   => 'varchar',
        size        => 255,
        is_nullable => 0
    },
    description => {
        data_type   => 'text',
        is_nullable => 1,
    },
);
__PACKAGE__->set_primary_key(qw(id));
__PACKAGE__->add_unique_constraint( ['name'] );

__PACKAGE__->has_many( map_user_role => 'App::Manoc::DB::Result::GroupRole', 'group_id' );
__PACKAGE__->many_to_many( roles => 'map_user_role', 'role' );

__PACKAGE__->has_many( map_user_group => 'App::Manoc::DB::Result::UserGroup', 'group_id' );
__PACKAGE__->many_to_many( users => 'map_user_group', 'user' );


1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::Group - A model object for user groups

=head1 VERSION

version 2.99.4

=head1 DESCRIPTION

This is an object that represents a row in the 'groups' table of your
application database.  It uses DBIx::Class (aka, DBIC) to do ORM.

=head1 NAME

Manoc:DB::Group - A model object representing a group of users
the system.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
