use strict;
use warnings;

package App::Embra::App;
$App::Embra::App::VERSION = '0.001'; # TRIAL
# ABSTRACT: App::Embra's App::Cmd

use App::Cmd::Setup -app;

use Log::Any::Adapter;
use Log::Any::Adapter::Dispatch;

sub global_opt_spec {
    return (
        [ 'debug|g', 'show debug messages' ],
    );
}

sub prepare_command {
    my $self = shift;
    my @res = $self->SUPER::prepare_command( @_ );
    my $min_level = 'info';
    if ( $self->global_options->debug ) {
        $min_level = 'debug';
    }
    Log::Any::Adapter->set( 'Dispatch',
        outputs => [
            [ 'Screen',  min_level => $min_level, newline => 1 ],
        ],
    );
    return @res;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::App - App::Embra's App::Cmd

=head1 VERSION

version 0.001

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
