#!/bin/perl
package SVGraph::world;
use strict;

#
# Hashes of countries and continents
#


our %countries = (
	LU => {name => 'Luxembourg',
		d => 'M413.519,90.071l0.136-0.348l-0.31-0.204l-0.017-0.327l0.213-0.322l0.245-0.147l0.142-0.08l0.225,0.072l0.062,0.301l0.41,0.312l0.466,0.096l-0.044,0.288l-0.248,0.144l0.074,0.353l-0.145-0.063l-0.568-0.011l-0.642-0.063z'},
	CH => {name => 'Switzerland',
		d => 'M421.683,94.397l0.193,0.336l-0.266,0.274l0.214,0.288l-0.09,0.192l0.622,0.062l0.008,0.144l0.55,0.242l0.579-0.332l0.215,0.117l-0.029,0.171l-0.126,0.309l0.112,0.212l-0.038,0.192l-0.315-0.051l-0.176-0.162l-0.283,0.091l-0.081,0.273     l0.244,0.131l-0.228,0.415l-0.244-0.333l-0.469,0.05l-0.071,0.122l-0.216,0.03l-0.23-0.142l-0.143-0.354l-0.371,0.081l0.019,0.333l-0.425,0.384l-0.018,0.535l-0.285,0.151l-0.385-0.312l0.098-0.182l-0.311-0.071l-0.534-0.363l-0.016-0.415l-0.777,0.404     l0.103,0.212l-0.349,0.432l-0.275,0.16l-0.629-0.168l-0.627,0.204l-0.599-0.062l-0.102-0.424l-0.312-0.806l-0.616,0.147l-0.854,0.668l-0.369-0.111l0.238-0.226l0.013-0.322l-0.08-0.137l0.089-0.294l0.718-0.418l-0.038-0.315l0.575-0.24l0.012-0.076l0.528-0.494     l0.173-0.035l-0.116-0.089l-0.153-0.028l0.221-0.302l0.446,0.007l-0.005,0.096l0.473,0.007l0.385-0.309l0.271,0.089l0.272-0.117l0.271,0.096l0.567-0.158l0.278,0.11l0.354-0.021l-0.179-0.199l0.709-0.199l0.017,0.151l0.199-0.014l0.149,0.089l0.852,0.007     l0.664,0.261z'},
	FR => {name => 'France',
		d => 'M421.394,104.558l0.104,0.175l0.04,0.256l-0.06,0.475l0.118,0.054l0.062,0.333l-0.076,0.795l-0.211,0.327l-0.118,0.724l-0.292,0.501l-0.298-0.043l-0.057-0.196l-0.41-0.076l-0.227-0.152l0.284-0.207l-0.07-0.076l-0.437-0.098l0.257-0.332     l-0.11-0.071l-0.291,0.071l-0.053-0.147l0.115-0.022l0.175-0.158l-0.094-0.153l-0.257-0.082l0.015-0.164l0.247-0.12l-0.284-0.218l0.241-0.284l0.6-0.305l0.27-0.022l0.04-0.125l0.292-0.043l0.195,0.104l0.096-0.142l-0.022-0.344l0.072-0.224l0.143-0.011z      M396.323,103.853l0.375-0.122l0.411-0.365l0.549-2.299l0.397-0.091l-0.21-0.29l-0.226,0.259l0.125-1.144l0.223-0.826l0.115,0.153l0.496,0.306l0.191,0.382l0.191,0.229l-0.281-0.673l-0.63-0.582l-0.242-0.233l0.024-0.249l0.359-0.477l-0.202-0.375l-0.2-0.274     l-0.326-0.216l-0.685-0.1l-0.515-0.571l-0.416-0.323l0.278-0.426l-0.233-0.181l-0.343-0.131l-0.511-0.142l-0.184-0.173l0.247-0.376l-0.329-0.173l-0.509,0.179l-0.489-0.249l-0.824-0.251l-0.619-0.181l-0.325,0.014l-0.215-0.25l-0.91,0.167l-0.059-0.25     l-0.265-0.125l-0.367-0.042l-0.056-0.104l0.861-0.083l-0.085-0.229l-0.526-0.104l0.442-0.104l0.086-0.205l-0.275,0.017l-0.263-0.021l-0.417,0.083l0.04-0.438l0.303,0.012l0.305-0.146l0.526-0.088l0.562-0.174l0.215,0.188l0.18-0.167l0.474,0.063l0.112-0.26     l0.272-0.059l0.764-0.078l0.393,0.366l0.275,0.26l0.342,0.083l0.652-0.271l0.317,0.167l0.276-0.127l0.457-0.124l0.029,0.23l0.591-0.065l0.3-0.103l-0.265-0.188l-0.028-0.251l0.056-0.345l-0.037-0.428l-0.131,0.021l-0.562-0.682l-0.11-0.407l0.927,0.126     l0.607-0.105l-0.084,0.397l0.248,0.419l0.342-0.146l1.241,0.104l0.501,0.146l0.079-0.014l0.525-0.093l0.662-0.27l-0.534-0.124l0.055-0.204l0.166-0.175l0.753-0.322l0.756-0.181l0.902-0.215l0.314-0.235l0.302-0.264l-0.053-0.775l0.135-0.542l0.521-0.25l0.46-0.16     l0.916-0.092l0.177-0.096l0.208,0.447l0.311,0.335l0.266,0.127l0.141-0.071l0.41-0.208l0.153,0.17l0.202,0.458l0.194,0.133l0.518-0.012l0.159,0.301l0.259-0.012l0.576,0.048l0.375,0.168l-0.159,0.241l0.091,0.175l-0.072,0.198l0.285,0.122l0.406-0.075l0.446-0.035     l0.193-0.313l0.245-0.072l-0.119,0.373l0.146,0.18l-0.039,0.228l0.529,0.048l0.341,0.192l0.371,0.204l0.127,0.228l0.694-0.174l0.079,0.114l0.642,0.063l0.568,0.011l0.145,0.063l0.428,0.319l0.337,0.277l0.395-0.055l0.045,0.145l0.689-0.062l0.072-0.048     l0.233,0.007l0.095,0.186l0.456,0.09l0.479-0.014l0.605,0.193l-0.954,0.806l-0.054,0.213l-0.054,0.358l-0.321,0.372l-0.075,0.295l0.091,0.076l-0.216,0.701l0.135,0.233l-0.385,0.309l-0.473-0.007l0.005-0.096L415.96,94.5l-0.221,0.302l0.153,0.028l0.116,0.089     l-0.173,0.035l-0.528,0.494l-0.012,0.076l-0.575,0.24l0.038,0.315l-0.718,0.418l-0.089,0.294l0.08,0.137l-0.013,0.322l-0.238,0.226l0.369,0.111l0.854-0.668l0.616-0.147l0.312,0.806l0.102,0.424l-0.624,0.301l0.532,0.344l0.025,0.292l0.43,0.192l-0.199,0.272     l-0.541,0.353l-0.183-0.111l-0.437,0.186l0.352,0.358l0.616,0.191l0.135,0.331l-0.175,0.01l-0.315,0.371l0.193,0.442l0.754,0.391l0.849-0.07l0.062,0.281l-0.146,0.469l-0.346,0.23l-0.221,0.215l-0.833,0.488l-0.889,0.659l-0.427,0.087l-0.318,0.043l-0.798,0.159     l-0.405-0.028l-0.471-0.156l-0.851-0.499l-0.315-0.085l-0.354,0.029l-0.231,0.072l-0.511-0.056l-0.752-0.313l-0.602,0.044l-0.731,0.345l-0.357,0.258l-0.555,0.559l-0.147,0.386l0.099,0.514l0.091,0.379l-0.334-0.091l-0.75,0.137l-0.039,0.136l-0.485-0.015     l-0.427-0.197l-0.395,0.167l-0.261-0.015l-0.036-0.152l-0.335-0.091l-0.206,0.03l-0.374,0.076l-0.187-0.076l-0.035-0.289l-0.091-0.213l-1.252-0.304h-0.355l0.017,0.319l-0.542-0.015l-0.337,0.061l-0.037-0.122l-0.767,0.03l-0.084-0.114l-0.028-0.038l-0.431-0.152     l-0.131,0.076l-0.262-0.03l-0.056,0.076l-0.507-0.395l-0.15,0.061l-1.088-0.334l-0.112,0.106l-0.15-0.03l-0.094-0.106l0.205-0.243l-0.058-0.122l-0.469,0.03l-0.472-0.243z'},
	KR => {name => 'Korea',
		d => 'M681.312,116.395l0.235-0.171l0.283-0.256l0.633-0.738l0.315-0.157l0.595,0.011l0.579,0.068l0.511,0.096l0.309-0.115l0.571-0.678l0.682,0.621l1.178,1.611l0.329,0.495l0.269,0.664l0.002,0.75l-0.034,0.947l-0.129,0.637l0.143,0.113     l0.5-0.043l-0.121,0.41l-0.282,0.523l-0.5,0.75l-0.316,0.312l-0.243,0.043l-0.567-0.211l-0.256,0.1l-0.607,0.58l-0.431-0.083l-0.289-0.225l-0.544,0.1l-0.526,0.199l-1.188,0.835l-0.462,0.043l-0.46,0.312l-0.055-0.564l-0.056-0.324l-0.163-0.705l-0.137-0.395     l0.167-0.453l0.499-0.468v-0.353l0.226-0.425l-0.044-0.141l-0.378-0.311l-0.095-0.296l0.015-0.467l-0.087-0.339l-0.289-0.126l-0.603-0.084l0.654-0.411l0.303-0.114l0.654,0.268l0.254-0.241l-0.029-0.283l-0.764-0.89l-0.113-0.311l-0.137-0.105z'},
	CY => {name => 'Cyprus',
		d => 'M475.646,121.847l-0.018,0.175l0.338,0.391l-0.295-0.009l-0.132,0.108l-0.104-0.059l-0.327-0.021l-0.121,0.33l-0.783,0.257l-0.384,0.046l-0.099,0.053v0.21l-0.217,0.006l-0.072-0.192l-0.402,0.023l-0.547-0.146l-0.191-0.087v-0.21     l-0.161-0.105l-0.122-0.403l0.082-0.035l0.12,0.1l0.147-0.006l0.405-0.304l0.253-0.006l0.328,0.092l0.077-0.086l0.088-0.286l-0.053-0.175l0.627,0.093l0.658,0.027l0.367-0.056l0.818-0.233l0.689-0.304l0.535-0.158l-0.475,0.295l-0.436,0.231l-0.596,0.444z'},
	JP => {name => 'Japan',
		d => 'M704.404,117.274l0.197-0.099l1.108-0.271l0.057,0.354l-0.481,0.284l-0.232,0.241l-0.068,0.453l0.139,0.367l0.291,0.056l0.221-0.114l0.418-0.354l0.24-0.085l1.656-0.697l0.389-0.213l0.46-0.326l0.349-0.638l0.76-0.412l0.347-0.327     l0.191-0.269l0.142-0.51l0.538-0.582l-0.01-0.142l0.344-0.567l0.159-0.468l0.139-0.609l-0.043-0.467l-0.33-0.198l-0.128-0.24l0.234-0.213l0.166-0.284l-0.155-1.023l0.544-0.343l0.176-0.242l0.327-0.328l0.192,0l0.21,0.355l0.199,0.227l0.303-0.058l0.799-0.257     l-0.169-0.526l-0.311-0.028l-0.36-0.312l0.694-0.415l0.441,0.156l0.336,0.227l0.025,0.199l-0.016,0.868l0.058,0.611l0.22,0.127l0.243,0.312l0.717,1.432l0.001,0.496l-0.246,0.709l-0.709,0.766l-0.226,0.439l0.064,0.368l-0.15,0.071l-0.737,0.285l-0.161,0.113     l-0.164,0.199l-0.174,0.453l0.02,0.396l0.094,0.254l0.131,0.792l-0.04,0.693l-0.686,0.751l-0.242,0.736l0.02,0.707l0.198,0.296l0.422,0.353l-0.617,0.298l-0.193,0.127l-0.166,0.17l-0.174,0.834l-1.081,0.439l-0.094-0.282l0.294-0.665l0.184-0.523l-0.198-0.126     l-0.514,0.241l-0.578,0.623l-0.476,0.001l-0.346,0.312l-0.066,0.748l-0.354,0.269l-0.188-0.028l-0.066-0.155l0.003-0.606l-0.149-0.155l-0.211,0.042l-0.309,0.156l-0.344,0.311l-0.325,0.523l-0.866-0.055l-0.505,0.057l-0.631,0.1l-0.458-0.549l-0.685-0.323     l-0.26,0.254l-0.067,0.184l-0.177,0.353l0.037,0.056l0.417,0.197l0.416,0.323l-0.293,0.198l-0.829,0.129l-0.433,0.241l-0.463,0.622l-0.522,0.847l-0.688-0.365l-0.565-0.21l-0.285-0.197l-0.014-0.169l-0.194-0.818l0.099-0.155l0.495-0.325l0.179-0.269l-0.067-0.282     l-0.18-0.042l-0.601,0.17l-0.341-0.028l-0.789-0.167l-0.475,0.128l-0.427,0.227l-0.437,0.184l-0.269-0.098l-0.256-0.027l-1.647,0.398l-0.814,0.298l-0.21-0.31l-0.452-0.042l-0.413,0.438l-0.006,0.635l-0.756-0.238l-0.579-0.055l-1.1,0.073l-0.267-0.14l0.072-0.339     l0.179-0.283l0.483,0.013l0.499-0.114l0.751-0.467l2.201-1.953l0.28-0.015l0.427-0.128l0.056,0.424l0.495-0.128l1.278-0.257l0.933-0.058l1.183-0.172l0.892-0.256l0.068,0.452l0.377,0.268l0.167-0.085l0.654-0.199l0.446-0.34l-0.003-0.353l0.114-0.467l0.465-0.51     l0.698-0.581l0.371-0.453l-0.062-1.117l0.182-0.213z M695.464,127.756l-0.292-0.197l-0.223-0.268l-0.101-0.381l-0.177-0.395l-0.492-0.535l0.731-0.382l0.287-0.269l0.456-0.593l0.409,0.253l0.615-0.015l0.483-0.185l0.311-0.339l0.451-0.311l0.454-0.029l0.316,0.169     l0.862,0.224l0.153,0.254l-0.1,0.127l-0.102,0.423l-0.292,0.24l-0.864,0.876l-0.181-0.211l-0.424-0.295l-0.467-0.042l-0.612,0.213l-0.193,0.184l-0.245,0.495l-0.165,0.508l-0.153,0.212l-0.448,0.269z M691.12,131.448l-0.366-0.042l-0.056-0.141l0.268-0.537     l0.128-0.593l-0.334-0.112l-0.239,0.198l-0.155,0.466l-0.381,0.452l-0.326-0.211l-0.059-0.211l0.322-0.466l0.032-0.296l-0.356-0.917l0.169-0.113l0.687-0.58l0.083-0.141l0.034-0.466l-0.532-0.789l-0.333-0.042l-0.162,0.269l-0.419,0.495l-0.249-0.112l-0.23-0.508     l-0.376-0.267l-0.261-0.366l0.41-0.325l0.733,0.083l0.706-0.171l0.315-0.466l0.241-0.283l0.484-0.058l0.478,0.056l0.249,0.38l0.27,0.168l0.43,0.084l0.628-0.213l0.225,0.395l-0.569,0.438l0.405,0.239l0.443,0.437l0.079,0.254l-0.596,0.58l-0.242,0.41l-0.104,0.367     l-0.085,0.621l-0.109,0.649l-0.242,0.353l-0.194,0.099l-0.165,0.071l-0.197,0.184l-0.479,0.678z M711.938,108.369l-0.222-0.241l-0.077-0.271l0.325-0.642l-0.055-0.342l-0.549-0.198l-0.168-0.171l-0.146-0.812l0.583-0.386l0.522-0.172l0.646-0.373l0.037-0.356     l-0.318-0.285l0.277-0.3l0.224-0.015l0.661,0.427l0.373,0.085l0.532-0.201l-0.004-1.186l0.455-0.187l0.45-0.244l0.074-0.743l0.007-0.844l-0.398-0.758l-0.098-0.473l0.166-0.216l0.618-0.346l0.063,0.072l0.507,0.43l0.904,0.816l1.07,0.842l1.083,0.684l0.627,0.285     l0.528,0.17l1.02,0.198l0.282,0.042l0.304-0.086l0.866-0.66l0.461-0.144l0.002,0.1l-0.308,0.358l-0.335,0.558l0.198,0.414l0.469,0.599l0.197,0.356l-0.561,0.272l-0.447,0.244l-0.534,0.158l-0.365,0.015l-0.488-0.199l-0.453,0.015l-0.363,0.144l-0.345,0.229     l-0.754,0.786l-0.396,0.5l-0.26,0.599l-0.4-0.07l-0.425-0.241l-2.031-0.965l-0.461-0.085l-0.72,0.044l-1.038,0.587l-0.153-0.299l-0.372-0.356l-0.339,0.029l-0.266,0.115l-0.439,0.272l0.049,0.299l1.16,0.497l0.56,0.298l0.302,0.27l-0.391,0.214l-0.303,0.029     l-0.305-0.128l-0.261,0.043l-0.324,0.314l-0.388,0.471l-0.347,0.114z'},
	BT => {name => 'Bhutan',
		d => 'M597.917,139.685l1.251-1.545l0.609-0.539l0.348-0.239l0.149-0.103l0.417-0.016l0.309,0.294l0.479,0.208l1.659,0.047l0.371,0.041l0.312,0.209l0.329,0.619l-0.07,0.156l0.042,0.24l0.326,0.294l0.313,0.069l0.258,0.238l0.017,0.282     l-0.217,0.58l-0.624,0.06l-1.036,0.062l-1.238-0.063l-0.335-0.125l-0.301-0.055l-0.531,0.313l-0.544,0.074l-0.085-0.021l-0.869-0.214l-0.559-0.081l-0.637-0.18l-0.235-0.493l0.092-0.113z'},
	EH => {name => 'Western Sahara',
		d => 'M362.764,152.723l0.072-0.625l0.395-0.876l0.52-0.552l0.488-0.566l0.244-0.509l1.175-2.559l0.238-0.241l1.404-1.175l0.345-0.495l0.051-0.918l0.305-1.088l0.651-1.075l0.399-0.34l0.404-0.198l0.838-0.51l0.361-0.495l0.334-0.777l0.428-0.851     l1.635-0.04l2.511,0l2.677-0.001l1.718,0.004l1.42-0.008l0.027,0.876l-0.03,1.752l0.002,0.65l-0.104,0.396l-0.56-0.011l-6.005-0.022l-0.557,0.074l-0.047,0.509l-0.07,2.261l-0.099,2.6l-0.144,0.128l-0.809,0.287l-0.726,0.315l-0.575,0.427l-0.249,0.383     l-0.01,0.707l0.164,1.539l0.051,1.102l-0.212-0.027l-0.732,0.033l-2.396-0.014l-5.055-0.056l-0.474-0.013z'},
	QA => {name => 'Qatar',
		d => 'M514.551,145.841l-0.374,0.027l-0.336-0.083l-0.008-0.615l-0.153-0.437l-0.108-0.791l0.187-0.607l0.188-0.11l-0.059-0.187l0.177-0.607l0.33-0.269l0.312,0.083l0.069,0.315l0.26,0.093l0.063,0.199l0.116,0.326l-0.106,0.42l0.031,0.708     l0.118,0.254l-0.104,0.381l-0.327,0.467l-0.275,0.433z'},
	AE => {name => 'United Arab Emirates',
		d => 'M514.177,145.868l0.374-0.027l0.008,0.288l0.361,0.14l0.153,0.128l0.186-0.093l-0.046,0.443l0.397,0.001l0.402,0.127l0.687-0.093l0.103-0.21l0.183-0.058l0.218,0.117l0.424-0.042l0.595,0.112l0.224-0.035l0.079-0.105l1.358,0.222l0.732-0.14     l-0.022-0.292l0.225,0.175l0.375-0.016l0.157-0.099l0.312-0.422l0.232-0.073l0.267-0.495l0.131-0.297l0.711-0.637l0.813-0.889l0.163,0.105l0.229-0.178l0.85-0.708l0.313-0.433l0.15,0.161l-0.248,0.42l-0.107,0.299l-0.004,0.176l0.099,0.064l0.121-0.024     l0.454,0.042l0.09,0.324l0.001,0.508l-0.003,0.358l-0.49,0.034l-0.401-0.083l-0.107,0.396l0.073,1.326l-0.199,0.34l-0.536,0.596l0.003,0.946l0.024,2.075l0.063,0.183l-0.152,0.057l-0.584,0.469l-0.839-0.108l-3.387-0.446l-3.362-0.375l-0.261-0.902l-0.548-1.154     l-1.043-2.198z'},
	TW => {name => 'Taiwan',
		d => 'M668.627,151.365l-0.102-0.056l-0.107-0.325l-0.922-1.212l-0.332-0.987l-0.03-0.438l0.156-0.749l0.546-0.792l1.312-1.852l0.259-0.184l0.425-0.128l0.229-0.184l0.358-0.227l0.228,0.127l0.554,0.394l-0.334,0.424l-0.084,0.142l0.023,0.31     l-0.067,0.622l-0.203,0.296l-0.182,0.354l-0.065,0.692l-0.1,0.494l-0.317,0.805l-0.473,0.707l-0.417,0.833l-0.014,0.353l-0.114,0.438l-0.228,0.142z'},
	ML => {name => 'Mali',
		d => 'M389.765,144.543l0.1,0.084l0.895,0.531l2.054,1.344l0.811,0.575l3.283,2.241l1.924,1.26l1.292,0.824l0.397,0.253l2.472,1.469l0.181,0.253l-0.096,0.396l0.082,0.183l0.393,0.28l1.111,1.039l0.229,0.027l0.47-0.314l0.588,0.562l0.375,0.167     l0.748,0.024l0.309,0.111l0.277,0.352l0.099,0.522l-0.161,0.679l0.146,0.564l2.176-0.408l0.064,1.017l0.034,2.203l0.001,0.96l-0.08,0.89l-0.145,0.919l-0.434,1.246l-0.596,0.794l-0.339,0.271l-0.29,0.129l-2.533,0.085l-1.808,0.124l-0.209,0.072l-0.562,0.427     l-0.579,0.272l-0.678-0.053l-0.581-0.081l-1.062-0.173l-0.36-0.059l-0.356-0.125l-0.37,0.073l-1.22,0.713l-0.947,0.458l-0.304,0.228l-0.314,0.793l-0.274-0.027l-0.324-0.182l-0.518-0.209l-0.272,0.101l-0.638,0.625l-0.492,0.667l-0.393,0.822l-0.174,0.227     l-0.45,0.102l-0.551-0.364l-0.293-0.281l-0.273,0.058l-0.397,0.384l-0.355,1.217l-0.292,1.047l-0.317,0.369l-0.543,0.271l-0.448,0.158l-0.257,0.016l-0.141,0.255l0.058,0.749l-0.133,0.876l-0.261,0.92l-0.172,0.326l-0.046,0.156l-0.08,0.043l-0.159,0.1     l-0.604,0.399l-0.352,0.059l-0.148-0.239l-0.117-0.381l-0.004-0.297l-0.147-0.211l-0.257-0.041l-0.239,0.114l-0.571,0.483l-0.362,0.469l-0.35,0.228l-0.455-0.436l-0.566-0.321l-0.352,0.059l-0.522,0.54l-0.559-0.901l-0.194-1.143l-0.349-0.718l-0.474-0.478     l-0.265-0.451l-0.271-0.832l-0.022-0.339l-0.246-0.281l-0.323-0.055l-0.684,0.428l-0.3,0.327l-0.43,0.243l-0.565-0.152l-0.356-0.153l-0.338-0.026l-0.475,0.413l-0.252,0.256l-0.536-0.265l-0.882-0.715l-0.18-0.183l-0.113-0.028l0.062-0.142l0.004-0.565     l-0.082-0.833l-0.265-0.337l-0.554-0.322l-0.181-0.197l-0.22-0.479l-0.144-0.663l-0.251-1.1l0.057-0.339l0.506-0.399l0.332-0.284l0.018-0.607l0.181-0.552l0.252-0.256l0.402-0.073l0.261,0.111l0.568,0.83l0.214,0.168l0.454,0.082l0.107-0.269l-0.055-0.296     l0.06-0.212l0.535,0.124l0.713,0.137l0.485,0.054l0.387-0.031l0.945-0.344l1.953-0.026l6.457-0.01l0.379-1.613l-0.724-0.787l-0.186-1.468l-0.202-2.386l-0.325-2.753l-0.178-1.736l-0.19-1.468l-0.908-7.962l-0.049-0.776l3.231-0.089l0.523-0.13z'},
	OM => {name => 'Oman',
		d => 'M525.37,142.384l0.312-0.429l0.155-0.17l0.084,0.833l-0.423,0.707l-0.118,0.156l-0.121,0.024l-0.099-0.064l0.004-0.176l0.107-0.299l0.248-0.42l-0.15-0.161z M525.923,144.712v0.22l0.456,0.762l0.408,0.465l0.782,0.634l0.677,0.394     l1.008,0.52l0.392,0.154l0.277,0.014l0.576-0.029l0.364,0.112l0.873,0.973l0.518,0.648l0.46,0.422l0.81,0.365l0.025,0.212l-0.67,1.06l-0.615,0.721l-0.883,0.807l-0.776,1.541l-0.242,0.142l-0.562-0.083l-0.235-0.084l-0.252,0.071l-0.278,0.509l-0.062,1.115     l0.001,0.791l0.134,0.621l-0.403,0.142l-1.046,0.073l-0.627,0.27l-0.367,0.283l-0.29,0.495l-0.131,0.551l-0.204,0.283l-0.444,0.255l-0.544,0.1l-0.292,0l-0.386-0.042l-0.326,0.029l-0.382,0.283l-0.22,0.297l-0.125,0.508l0.003,0.353l-0.091,0.311l-0.631,0.396     l-0.344,0.043l-0.776-0.21l-0.717,0.058l-0.896,0.27l-0.768,0.298l-0.283,0.099l-0.416,0.145l-0.241-0.306l-0.483-0.689l0.006-0.296l-0.127-0.253l-0.933-1.364l-0.604-0.971l-0.226-0.634l-0.092-0.663l1.691-0.815l2.35-1.213l5.346-2.982l-0.155-1.453     l-0.581-0.914l-0.063-0.183l-0.024-2.075l-0.003-0.946l0.536-0.596l0.199-0.34l-0.073-1.326l0.107-0.396l0.401,0.083l0.49-0.034z'},
	NE => {name => 'Niger',
		d => 'M405.733,173.04l-0.568-0.971l-0.562-0.025l-0.37,0.044l-0.516-0.181l-0.97-0.757l-0.114-0.226l0.335-0.439l-0.018-0.212l-0.179-0.268l-0.502-0.42l-0.389-0.266l-0.422-0.492l-0.426-0.93l-0.019-0.396l0.173-0.665l0.581,0.081l0.678,0.053     l0.579-0.272l0.562-0.427l0.209-0.072l1.808-0.124l2.533-0.085l0.29-0.129l0.339-0.271l0.596-0.794l0.434-1.246l0.145-0.919l0.08-0.89l-0.001-0.96l-0.034-2.203l-0.064-1.017l1.672-0.321l1.82-0.364l3.084-2.617l0.834-0.655l2.308-1.454l1.607-0.956l4.012-2.241     l1.632-0.843l0.265-0.186l0.832,0.137l1.646,0.442l1.008,0.333l0.258,0.182l1.192,0.911l0.231-0.157l1.519-0.729l0.364,2.145l0.169,1.298l0.42,1.028l0.554,0.802l0.703,0.604l-0.388,0.722l-0.265,0.99l-0.168,1.088l-0.084,0.989l0.022,0.537l-0.062,0.707     l-0.019,1.045l-0.034,1.088l-0.056,0.466l-2.43,2.613l-0.591,0.78l-0.87,1.333l-0.572,0.794l-0.007,0.678l0.123,0.719l0.014,0.269l-0.951,0.034l-0.437,0.2l-0.453,0.299l-0.761,0.697l-0.259,0.058l-0.609-0.208l-0.724-0.193l-0.884-0.221l-0.531-0.04l-0.709,0.047     l-0.628,0.103l-0.774,0.287l-0.403,0.327l-0.629,0.399l-0.273,0.059l-0.934,0.005l-0.965-0.277l-1.173-0.742l-0.354-0.083l-0.467,0.116l-1.337,0.544l-0.37,0.002l-0.209-0.098l-1.095-1.223l-0.821-0.277l-1.111-0.121l-1.174,0.108l-1.064,0.188l-0.676,0.4     l-0.687,1.614l-0.353,0.482l-0.158,0.849l-0.092,0.961l-0.902-0.503l-0.727-0.589l-0.339-0.28l-0.321,0.073l-0.577,0.3z'},
	TD => {name => 'Chad',
		d => 'M431.763,171.063l-0.351-0.407l-0.575-0.52l-0.173-0.394l-0.014-0.269l-0.123-0.719l0.007-0.678l0.572-0.794l0.87-1.333l0.591-0.78l2.43-2.613l0.056-0.466l0.034-1.088l0.019-1.045l0.062-0.707l-0.022-0.537l0.084-0.989l0.168-1.088     l0.265-0.99l0.388-0.722l-0.703-0.604l-0.554-0.802l-0.42-1.028l-0.169-1.298l-0.364-2.145l1.818-0.858l0.41-0.059l5.231,2.554l4.941,2.372l5.577,2.792l1.981,0.963l-0.02,1.045l-0.016,0.946l-0.036,0.636l0.085,2.5l-0.038,0.749l0.036,1.002l0.031,1.229     l-0.04,0.283l-0.839-0.009l-1.245,0.05l-0.229,0.143l-0.417,1.245l-0.583,0.809l-0.122,0.438l0.131,0.677l-0.149,0.212l-0.718,0.428l-0.053,0.24l0.342,0.662l-0.087,0.34l-0.542,0.596l-0.316,0.609l0.219,0.352l0.517-0.088l0.338,0.012l0.141,0.225l0.221,1.228     l0.137,0.522l0.155,0.295l0.444,0.407l0.266,0.465l0.026,0.367l-0.15,0.425l-0.559-0.208l-0.321-0.012l-0.322,0.086l-0.939,0.613l-0.372,0.228l-0.165,0.382l-0.005,0.41l-0.196,0.284l-2.649,2.275l-0.386,0.087l-2.181,0.055l-0.434,0.059l-0.209,0.199     l-0.117,0.806l-0.646,1.176l-0.258,0.143l-0.368,0.031l-0.881-0.009l-0.818,0.273l-0.754,0.386l-0.466,0.271l-0.224,0.03l-0.225-0.069l-0.494-0.661l-1.363,0.686l-0.449,0.158l-0.24-0.027l-0.096-0.084l-0.208-0.183l-0.382-1.057l-0.638-1.07l-1.343-1.179     l-1.088-1.067l0.323-0.539l0.29-0.312l0.24-0.1l0.481,0.082l1.187,0.191l0.674-0.032l0.225-0.143l-0.047-0.127l-0.208-0.21l-0.381-0.633l-0.205-0.578l-0.169-1.228l0.134-0.651l-0.119-1.2l-0.395-0.887l-0.923-1.238l-0.208-0.083l-0.627-0.109z'},
	VN => {name => 'Vietnam',
		d => 'M627.173,150.012l0.483-0.229l0.515-0.13l0.341,0.012l0.597,0.392l0.325,0.097l0.584-0.413l0.332-0.115l1.595-0.052l0.807-0.117l0.341-0.157l0.696-0.554l0.521-0.328l0.298-0.101l0.623,0.575l0.771,0.235l0.66,0.053l0.777-0.047l0.237,0.21     l0.056,0.38l-0.472,0.75l0.096,0.521l0.273,0.365l0.943,0.615l0.621,0.166l0.909,0.107l0.197,0.143l-0.19,0.132l-0.826,0.482l0.106,0.465l-0.203,0.212l-1.261-0.054l-0.136,0.198l0.057,0.395l-0.283,0.382l-0.585,0.792l-0.221,0.142l-0.533,0.241l-0.171,0.127     l-0.27,0.396l-0.303,0.932l-0.388,0.975l0.268,0.225l0.469,0.563l1.112,1.071l0.023,0.24l0.042,0.522l0.087,0.254l0.42,0.493l1.096,0.83l1.282,1.296l0.26,0.197l0.636,0.069l0.313,0.38l0.282,1.016l0.302,0.578l0.638,0.605l0.293,0.663l0.341,1.382l0.524,2.809     l-0.295,0.438l-0.235,0.495l0.05,0.819l-0.095,0.41l0.056,0.664l-0.027,0.099l-0.364,0.551l-0.447,0.439l-0.254,0.127l-0.509,0.1l-0.419,0.17l-0.501,0.354l-0.591,0.622l-0.579,0.354l-0.325,0.043l-0.512-0.197l-0.404-0.31l-0.179-0.141l-0.153,0.424l0.051,0.494     l0.048,0.353l-0.205,0.721l-0.388,0.424l-0.326,0.071l-0.235-0.07l-0.246,0.481l-0.427,0.326l-0.523,0.142l-0.417,0.213l-0.459,0.565l-0.196,0.269l-0.406,0.297l-0.264,0.099l-0.365-0.042l0.078-0.861l0.1-1.313l0.151-0.494l0.215-0.283l-0.02-0.353l-0.475-0.437     l-0.749-0.238l-0.091-0.066l0.3-0.289l0.646-0.229l0.915-0.528l0.599-0.229l0.497,0.011l0.688,0.194l0.17-0.27l-0.03-0.197l-0.568-0.435l-0.216-0.422l0.234-0.425l0.99-0.571l0.521-0.229l0.932-0.443l0.599-0.187l0.385-0.285l0.217-0.509l-0.054-1.073l0.05-0.424     l0.076-0.367l-0.455-1.014l-0.029-0.663l0.215-0.905l0.155-0.918l-0.064-0.578l-0.214-0.437l-0.529-0.477l-0.072-0.282l0.226-0.439l-0.136-0.395l-0.358-0.308l-0.685-0.391l-0.471-0.52l-0.57-0.914l-1.683-2.121l-0.698-0.772l-0.637-0.646l-0.632-0.476     l-1.234-0.741l-0.162-0.098l-0.043-0.494l0.277-0.369l0.311-0.101l0.476,0.068l0.287-0.058l0.261-0.185l0.255-0.326l-0.009-0.508l-0.87-0.968l-0.434-0.675l-0.262-0.083l-0.39,0.171l-0.509,0.483l-0.287,0.058l-0.47-0.195l-0.607-0.434l-0.334-0.689l-0.338-0.929     l-0.543-0.604l-0.613-0.575l-0.45-0.745z'},
	CU => {name => 'Cuba',
		d => 'M217.961,150.385l0.304-0.043l0.84-0.27l-0.17-0.254l-0.312-0.112l-0.369-0.056l-0.651,0.016l-0.497-0.042l-0.645,0.157l-1.193,0.92l-0.371,0.029l-0.653,0.001l-0.211,0.113l-0.189,0.452l-0.396,0.284l-0.32,0.043l-0.786,0.086l0.259-0.325     l0.473-0.312l-0.128-0.593l0.282-0.382l0.114-0.099l1.258-0.61l1.625-0.47l1.164-0.087l0.842-0.157l0.825,0.041l0.566-0.044l0.73,0.168l0.848,0.083l0.603,0.197l0.557,0.112l0.477,0.013l0.499,0.268l0.573,0.536l0.382,0.253l0.581,0.168l0.768,0.111l1.229,0.351     l1.02,0.492l0.453,0.31l0.374,0.55l0.33,0.141l0.479,0.041l1.704,0.519l1.018,0.167l0.327,0.239l-0.344,0.58l0.233,0.155l0.559,0.042l0.756-0.072l0.495,0.168l0.507,0.38l0.591,0.281l0.381,0.296l-0.233,0.085l-0.981,0.087l-1.15,0.398l-0.626,0.058l-1.054-0.209     l-0.9-0.041l-0.934,0.186l-0.943,0.115l-0.484,0.029l-0.449-0.07l0.353-0.382l0.728-0.623l0.173-0.396L229,154.204l-0.181-0.127l-0.622-0.14l-0.7,0.001l-0.603-0.112l-0.651-0.338l-0.141-0.748l-0.258-0.536l-0.218-0.155l-0.396-0.027l-1.005,0.044l-0.836-0.139     l-0.621-0.225l-0.956-0.493l-0.739-0.238l-0.615-0.069l-1.154-0.068l-0.489-0.098l-0.855-0.352z'},
	LA => {name => 'Laos',
		d => 'M634.036,168.444l0.808-0.64l0.121-0.438l-0.002-0.945l-0.157-0.507l-0.419-0.703l-0.979-1.279l-0.255-0.464l-0.107-0.366l-0.058-1.524l-0.435-0.632l-0.688-0.659l-0.285-0.535l-0.052-0.282l-0.266-0.153l-0.893-0.192l-0.403-0.012     l-0.286,0.453l-0.2,0.538l-0.543,0.257l-0.223,0.072l-0.59-0.265l-0.835-0.348l-0.346,0.03l-1.173,1.178l-0.37,0.411l-0.481-0.138l-0.145-0.324l0.027-0.494l0.117-0.438l0.528-1.569l0.085-0.41l-0.249-1.311l-0.045-0.113l-0.414,0.045l-0.489,0.2l-0.423,0.003     l-0.186-0.154l-0.066-0.367l0.106-0.805l-0.01-0.423l-0.118-0.168l-0.295-0.182l-0.541-0.166l0.193-0.185l0.582-0.455l0.442-0.581l0.53-0.61l0.502-0.355l0.178,0.196l0.321,0.21l0.769,0.08l0.266-0.213l0.109-0.339l-0.119-0.521l-0.228-0.366l-0.138-0.592     l0.043-0.325l0.24-0.241l0.679-0.314l0.45,0.745l0.613,0.575l0.543,0.604l0.338,0.929l0.334,0.689l0.607,0.434l0.47,0.195l0.287-0.058l0.509-0.483l0.39-0.171l0.262,0.083l0.434,0.675l0.87,0.968l0.009,0.508l-0.255,0.326l-0.261,0.185l-0.287,0.058l-0.476-0.068     l-0.311,0.101l-0.277,0.369l0.043,0.494l0.162,0.098l1.234,0.741l0.632,0.476l0.637,0.646l0.698,0.772l1.683,2.121l0.57,0.914l0.471,0.52l0.685,0.391l0.358,0.308l0.136,0.395l-0.226,0.439l0.072,0.282l0.529,0.477l0.214,0.437l0.064,0.578l-0.155,0.918     l-0.209,0.114l-0.975,0.429l-0.3,0.072l-0.373-0.351l-0.444-0.181l-0.476,0.186l-0.392,0.285l0.107,0.296l0.187,0.182l0.103,0.211l-0.095,0.24l-0.248,0.058l-0.469-0.251l-0.341-0.111l-0.736-0.165l-0.533-0.251z'},
	US => {name => 'United States',
		d => 'M60.074,72.607l-0.099,0.228l-0.491,0.472l-0.395,0.183l-0.462,0.062L58,73.461l-0.961-0.362l-0.153-0.197l0.169-0.289l0.54-0.274l0.341-0.32l0.716,0.364l0.3,0.091l0.465-0.26l0.215-0.213l0.064-0.366l0.485-0.047l1.107,0.135l0.536,0.334     l0.133,0.213l-0.756,0.062l-0.429,0l-0.59,0.184l-0.11,0.092z M40.092,77.571l-0.729-0.029l-0.097-0.24l0.011-0.3l0.802-0.243l0.326-0.211l0.593-0.423l0.448-0.137l0.646-0.077l1.427,0.253l0.711,0.24l-0.079,0.211l-0.303,0.046l-0.754-0.074l-0.496,0.031     l-1.077,0.183l-0.269,0.226l-1.161,0.543z M38.426,77.979l-0.515-0.209l-0.139-0.285l0.381-0.227l0.674,0.27l0.093,0.195l-0.122,0.15l-0.372,0.105z M37.896,78.449l-0.256,0.084l-0.558,0.151l-1.109-0.058l-0.387,0.135l-0.398,0.434l-0.31,0.15l-0.854-0.207     l-0.135-0.224l0.497-0.359l0.5-0.315l0.955-0.166l0.863-0.346l0.39,0.089l0.461,0.224l0.341,0.409z M29.628,81.29l-0.168-0.594l-0.324-0.476l0.839-0.136l0.424,0.088l0.436,0.238l-0.244,0.268l-0.26,0.06l-0.073,0.297l-0.22,0.09l-0.412,0.164z M27.543,81.591     l-0.39,0.031l-0.741,0.165l-0.311-0.133l-0.088-0.178l0.104-0.119l0.336-0.268l0.294-0.09l0.584,0.222l0.212,0.371z M54.394,157.986l-0.559-0.356l-0.044-0.884l-0.243-0.677l0.482-0.402l-0.035-0.2l-0.156-0.26l0.052-0.149l0.173-0.046l0.354,0.158l0.652,0.279     l0.593,0.425l-0.015,0.275l0.238,0.046l0.12,0.287l0.306,0.149l-0.062,0.161L56,156.933l-0.172,0.204l-0.766,0.195l-0.374,0.23l-0.295,0.425z M23.015,59.92l-1.613-0.646l-0.75-0.205l-0.792-0.062l-0.9,0.065l-0.291-0.095l-0.431-0.222l0.179-0.287l0.516-0.049     l1.135,0.221l0.579-0.001l0.543-0.081l0.538-0.001l0.828,0.285l1.725,0.362l0.429,0.237l0.046,0.111l-0.569-0.03l-0.646,0.033l-0.527,0.365z M99.855,70.993l0.467,0.929l-0.071,0.167l-0.879-0.272l-0.621-0.075l0.067,0.441l-0.056,0.228l-0.935-0.607L97.03,71.41     l0.396-0.458l0.263-0.153l0.612-0.078l0.784,0.38l0.771-0.108z M100.975,73.606l0.128,0.272l-0.086,0.273l-0.318,0.483l-0.559-0.815l-0.597-0.909l-0.04-0.228l0.095-0.213l0.407,0.029l0.568,0.197l0.402,0.91z M106.858,78.207l-1.872-1.166l-0.566-0.555     l0.01-0.467l-0.559-0.843l0.071-0.106l0.456,0.06l0.274,0.256l1.165,0.48l0.086,0.196l-0.059,0.136l-0.149,0.226l0.296,0.436l0.839,0.374l0.007,0.974z M140.191,127.819l-0.043-0.094l-0.198-0.36l-0.049-0.067l-0.032,0.042l-0.028,0.05l-0.04-0.092l0.002-0.664     l-0.331-0.604l-0.472-0.451l-0.661-0.451l-0.512-0.197l-0.114-0.052l-0.145,0.034l0.002,0.092l-0.088,0.025l-0.1-0.042l-0.146-0.143l0.076-0.076l-0.073-0.202l-0.228-0.252l-0.283-0.025l-0.312,0.084l-0.932-0.336l-0.286-0.328l-0.428-0.244l-0.383,0.042     l-0.932-0.16l-0.721,0.051l-0.12-0.185l-0.234-0.067l-0.046-0.177l0.094-0.117l-0.157-0.504l0.133-0.464l-0.227-0.096l-0.127,0.008l-0.249-0.134l0-0.101l0.075-0.093l-0.029-0.219l-0.347-0.185l-0.254-0.286l-0.415-0.219l-0.391-0.623l-0.202-0.076l-0.203-0.311     l-0.409-0.219l-0.156-0.529l-0.002-0.227l0.178,0.007l0.147-0.164l0.029-0.326l-0.208-0.251l-0.192-0.045l-0.22,0.037l-0.303-0.126l-0.535-0.514l0.078-0.21l-0.091-0.312l-0.129-0.067l-0.044-0.463l0.058-0.152l0.119-0.025l0.099,0.067l0.073,0.076l-0.086,0.101     l0.153,0.202l0.285,0.126l0.116,0.118l0.203,0.017l-0.385-0.564l-0.183-0.144l-0.021-0.236l-0.184-0.109l-0.051-0.344l-0.13,0.006l-0.011,0.144l0.048,0.446l-0.093,0.017l-0.293-0.194l-0.119,0.042l-0.516-0.404l-0.136-0.363l-0.377-0.514l-0.531-0.379     l-0.624-0.583l-0.123-0.142l0.114-0.101l-0.327-0.751l0.161-0.43l-0.254-0.479l-0.22-0.355l-0.738-0.782l-0.104-0.299l0.099-0.627l0.252-0.628l0.166-0.357l0.059-0.856l-0.215-0.785l-0.692-1.486l-0.153-0.916l0.096-0.287l0.231-0.244l0.402-0.201l0.365-0.717     l-0.365-0.573l-0.066-0.33l0.424-1.593l0.153-0.575l0.061-0.634l0.091-0.778l0.019-0.179l-0.153-0.16l0.08-0.231l-0.103-0.167l0.157-0.077l-0.03-0.186l-0.046-0.186l-0.031-0.103l-0.004-0.058l0.322,0.096l0.209-0.019l0.062-0.097l-0.211,0.006l-0.614-0.122     l0.062-0.707l-0.103-0.328l0.017-0.277l0.587-0.225l-0.345-0.019l-0.16-0.142h-0.129l-0.053,0.045l0.042,0.116l-0.12,0.052l-0.133-0.979l-0.927-1.463l-0.017-0.465l0.129-0.131l0.544,0.086l0.632,0.217l0.785,0.114l0.641,0.028l0.546-0.044l0.415,0.086     l0.547,0.318l0.039,0.435l-0.42,0.407l-0.413,0.347l0.532,0.146l0.184,0.188l0.251,0.169l0.029-0.228l0.161-0.232l0.393-0.305l0.21-0.581l0.102-0.465l-0.064-0.421l-0.356-0.958l-0.158-0.305l-0.655-0.516l0.194,0.013l2.579,0.001l1.335,0.022l4.588-0.025     l3.938,0.008l2.87-0.001l1.687,0.006l5.117-0.028l0.74,0.011l4.13,0.021l1.089-0.035l3.821,0.023l0.875-0.005l3.617-0.004l4.84,0.018l0.601-0.003l2.935,0.014l2.131-0.012l2.781,0.029l2.915-0.016l2.105,0.003l1.348-0.007l2.798,0.029l2.687-0.029l0.68,0.003     l-0.387-0.588l-0.131-0.347l0.501-0.036l0.896,0.748l0.279,0.371l0.468,0.46l0.833,0.451l0.518-0.076l1.425,0.208l0.02,0.185l0.271-0.012l0.338,0.48l0.16-0.247l0.502,0.013l0.241,0.271l0.469,0.086l0.064,0.185l0.506,0.098l0.573-0.141l0.219-0.06l0.412-0.191     l0.373-0.075l0.028,0.282l0.197,0.116l0.855-0.083l0.474,0.041l0.156,0.115l0.196,0.144l0.542-0.049l0.707,0.074l1.469-0.592l0.805-0.189l0.797,0.227l0.977,0.386l3.975,1.576l2.15,1.061l0.101,0.429l0.46,0.465l0.628-0.024l0.178,0.135l0.184,0.294l0.916,0.181     l0.307,0.235l-0.11,0.318l0.26,0.33l2.529,1.05l0.876,3.16l0.054,0.545l-0.028,0.746l-0.377,0.576l-0.294,0.544l-0.264,0.433l-0.414,0.294l-0.707,0.525l-0.044,0.218l0.012,0.33l0.371,0.427l0.497,0.169l0.573,0.068l0.524-0.117l0.925-0.506l0.939-0.478     l0.88-0.262l0.919-0.062l0.944-0.163l1.464-0.452l0.875-0.427l-0.047-0.362l-0.16-0.471l-0.018-0.319l0.162-0.375l0.47-0.203l0.93-0.091l1.123,0.01l1.305,0.138l1.156-0.197l0.44-0.275l0.163-0.512l0.146-0.434l0.545-0.164l1.754-0.814l0.534-0.305l0.968-0.523     l1.76-0.009l2.508,0.029l1.855,0.004l1.093,0.095l0.174-0.375l0.363-0.435l0.402-0.06l1.161,0.124l1.139-1.45l1.139-2.22l0.514-0.626l0.632-0.526l0.273,0.085l0.505,0.36l0.381,0.085l0.41-0.176l0.771,0.025l0.488,0.288l0.174,0.274l0.31,2.819l-0.077,0.229     l0.606,0.231h0.224l0.042,0.154l-0.143,0.069l0.02,0.256l-0.192,0.077l0.16,0.291l0.188-0.153l0.349,0.495l-0.268,0.281l0.299-0.04l0.171,0.093l-0.511,0.374l-0.509,0.093l-0.297-0.12l-0.013,0.253l-0.138,0.067l-0.077-0.107l-0.231-0.08l-0.277,0.133l-0.101,0.28     l-0.171-0.013l-0.15,0.16l-0.175-0.347l-0.746,0.28l-0.204-0.093l0.12,0.413l-0.666-0.213l0.199-0.48l-0.149-0.04l-0.364,0.52l-0.332,0.56l-0.342,0.333l-0.324-0.227l-0.249,0.439l-0.346-0.08l0.122-0.307l-0.325,0.253l0.165,0.16l-0.326,0.293l-0.318-0.133     l0.105-0.226l-0.654,0.253l0.065,0.359l-0.264,0.04l-0.161,0.373l-0.352,0.106l-0.333,0.679l-0.404,0.505l0.173,0.146l0.068,0.212l0.168,0.053l0.083-0.08l0.169,0.013l-0.122,0.146l-0.547,0.106l0.053,0.093l-0.392,0.292l-0.068,0.159l0.337,0.027l0.282,0.093     l0.599,0.704l0.055,0.398l0.399,0.106l0.691-0.239l-0.022-0.186l-0.14-0.027l-0.254-0.279l-0.097-0.04l-0.009-0.066h0.196l0.23,0.133l0.218,0.358l0.031,0.425l-1.599,0.292l-0.032-0.385l-0.124-0.066l-0.109,0.226l-0.164,0.04l-0.03,0.093l-0.105-0.106     l-0.159,0.266l-0.164,0.04l-0.294,0.04l-0.045-0.332l0.198-0.332l-0.443,0.119l-0.154-0.146l-0.082,0.252l-0.087,0.664l-1.429,0.132l-1.694,0.159l-1.182,0.345l-0.787,0.358l-0.097,0.212l-0.32,0.053l-0.144,0.172l-0.032-0.04l0.308-0.756l0.024-0.106     l-0.071,0.027l-0.41,0.994l-0.079-0.08l-0.406,0.292l0.218,0.318l0.553,0.093l-0.46,1.515l-0.302,0.429l-0.259-0.092l0.043,0.251l-0.062,0.185l-0.237,0.145l-0.462,0.501l-0.292,0.304l-0.167,0.026l-0.075-0.119l0.177-0.31l-0.113-0.178l-0.43,0.013l-0.447-0.343     l-0.148-0.053l-0.329-0.541l0.315-0.257l0.151-0.245l-0.271,0.119l-0.362,0.37l0.489,0.845l0.033,0.356l0.387,0.581l0.28,0.066l0.104,0.765l-0.101,0.238l-0.151,0.23l-0.125-0.013l-0.487,0.666l-0.396,0.798l0.034,0.053l-0.13,0.132l-0.107-0.125l-0.374,0.725     l0.026,0.125l-0.226,0.04l-0.137-0.263l0.342-0.864l0.195-0.29l0.247-0.119l0.061-0.237l-0.093-0.059l-0.374,0.119l0.226-0.383l-0.218,0.04l-0.176-0.093l0.012-0.191l0.242-0.04l-0.077-0.33l-0.439,0.296l-0.241-0.204l-0.157,0.053l-0.23-0.396l0.355-0.171     l0.357-0.053l-0.005-0.06l-0.604-0.316l-0.092,0.165h-0.072l0.107-0.323l0.089-0.02l0.21,0.159l0.131-0.06l-0.098-0.224l-0.353-0.066l-0.065-0.112l0.096-0.112l0.336,0.02l0.193-0.284l-0.281,0.046l-0.158-0.059l0.241-0.37l0.652-0.152l-0.328-0.06l0.146-0.409     l-0.28,0.093l-0.096,0.132l0.11,0.079l-0.315,0.191l-0.035-0.224l-0.093,0.053l0.051,0.224l-0.081,0.086l-0.051-0.158l-0.097-0.066l-0.103,0.416l-0.447-0.079l0.402,0.501l-0.294,0.666l0.07,0.237l0.272,0.488l-0.055,0.139l-0.466-0.317l-0.1-0.211l0.026,0.205     l0.174,0.218l0.421,0.237l0.132,0.508l-0.631-0.402l-0.354-0.007l-0.118-0.283l-0.155-0.053l0.066,0.25l-0.541-0.323l-0.33,0.04l0.015-0.29l0.427-0.323l-0.428,0.079l-0.19,0.468l0.204,0.231l0.457,0.046l0.202,0.25l0.954,0.297l-0.047,0.092l0.554,0.165     l0.158,0.132l-0.22,0.468l-0.227,0.06l-1.042-0.804l0.708,0.811l0.626,0.171l-0.248,0.092l0.323,0.079l-0.045,0.079l0.061,0.06l-0.034,0.25l-0.312-0.191l-0.071,0.073l0.104,0.211l-0.216,0.02l-0.656-0.56l-0.023,0.026l0.419,0.475l0.309,0.158l0.182-0.026     l0.191,0.21l0.018,0.31l-0.298,0.059l-0.492-0.534l-0.474-0.198l-0.199,0.16l0.046,0.044l0.44,0.145l0.488,0.382l-0.047,0.237l0.442-0.033l0.031-0.119l0.748,0.119l0.151,0.382l0.406,1.212l0.448,0.803l-0.14-0.092l-0.262-0.349l-0.059-0.132l-0.359-1.172     l-0.147-0.277l-0.056,0.31h0.135l0.034,0.198l-0.292-0.066l0.173,0.283l0.144,0.099l0.228,0.58l-0.144-0.053l-0.211-0.382l0.002,0.224l-0.52-0.303l-0.06,0.059l0.266,0.303l-0.247,0.119l-0.526-0.204l0.225,0.204l-0.375,0.211l-0.173-0.02l-0.251-0.21     l-0.024-0.217l0.083-0.158l-0.081-0.053l-0.091,0.204l0.044,0.23l0.116,0.211l-0.107,0.158l0.894,0.02l0.571-0.145l0.125,0.165l-0.113,0.191l-0.072,0.369l0.14,0.066l0.092-0.257l0.135-0.369l0.18-0.105l0.266,0.31l0.047,0.296l-0.166,0.25l-0.163-0.013     l-0.063-0.099l-0.316,0.474l-0.254,0.197l-0.483-0.053l-0.203-0.065l-0.147-0.066l-0.136-0.245l-0.151,0.014l0.141,0.244l-0.075,0.013l-0.538-0.125l-0.436-0.151l0.162,0.185l0.269,0.026l0.833,0.335l-0.034,0.119l-0.396,0.145l0.247,0.007l-0.19,0.25     l-0.281,0.138h-0.149l-0.481-0.375l0.242,0.395l0.43,0.164l0.302-0.171l0.292,0.026l0.11-0.204l0.04,0.178l0.217,0.04l0.048,0.079l-0.428,0.322l-0.013,0.085l-0.261,0.072l-1.498,0.214l-0.865,0.895l-0.487,0.609l-0.13,0.127l-0.935,0.143l-0.528,0.128     l-0.617,0.241l-0.678,0.539l-0.225,0.424l-0.096,0.354l-0.819,0.694l-0.693,0.383l-0.429,0.199l-0.797,0.086l-0.35,0.58l-0.177,0.198l-0.809,1.125l-0.273,0.781l-0.459,1.249l0.236,1.455l0.387,0.925l0.456,0.873l0.934,1.562l0.352,1.746l0.486,1.194l-0.075,0.092     l0.287,0.276l0.123,0.333l0.062,0.827l-0.301,1.536l-0.064,0.278l-0.31,0.415l0.108,0.424l-0.02,0.252l-0.393,0.551l-0.017-0.092l0.129-0.241l-0.025-0.138l-0.256,0.035l-0.38,0.137l-0.291-0.126l-0.509,0.138l-0.12-0.329l0.014-0.233l-0.567-1.068l-0.764-0.138     l-0.204-0.352l-0.113-0.819l-0.423-0.229l-0.144-0.702l-0.373,0.093l-0.608-1.08l-0.375-0.482h0.296l0.375-0.438l0.048-0.226l-0.167-0.226l-0.471,0.407l-0.277-0.208l0.126-0.573l0.147-0.758l0.158-1.043l-0.293-0.452l-0.258-0.169l-0.496-0.126l-0.832-0.987     l-0.875-0.804l-0.528-0.168l-0.43,0.072l-0.536,0.298l-0.456,0.354l-1.202,0.299l-0.273-0.213l-0.131-0.62l-0.253-0.254l-0.264-0.113l-0.752-0.069l-0.516-0.296l-0.22-0.233l-0.504,0.138l-1.052,0.115l-0.653-0.184l-0.047,0.298l-0.64,0.099h-0.183l-0.578-0.926     l-0.238,0.781l-0.447-0.135l-0.65,0.001l-1.328-0.04l-0.672,0.439l-0.39,0.055l-1-0.459l-0.096,0.009l-0.142,0.014l-0.362,0.528l0.201,0.229h0.303h0.211l0.537-0.207l0.406,0.092l0.676,0.482l-0.68,0.373l0.02,0.254l0.263,0.353l0.593,0.146l0.229,0.217     l0.35,0.334l-0.533,0.136l-0.503-0.084l-0.276-0.419l-0.79-0.271l-0.224-0.211l-0.265-0.056l-0.013,0.02l-0.209,0.32l0.209,0.154l0.248,0.183l-0.248,0.179l-0.069,0.05l-0.447-0.459l-0.476,0.192l-0.287,0.291l-1.025-0.472l-0.419-0.494l-1.16-0.642l-0.615,0.066     l0.554,0.393l-0.307,0.187l-1.17-0.083l-0.886-0.252l-0.896-0.168l-1.547,0.173l-0.632,0.328l-0.392-0.015l-0.433-0.031l-0.135-0.49l-0.333,0.057l-0.112,0.184l0.474,0.731l-0.877,0.64l-0.808,0.577l-0.915,0.317l-0.419,0.043l-0.414-0.056l-0.728-0.111     l-0.126,0.198l0.437,0.437l-0.239,0.396l-0.327,0.199l-0.631,0.114l-0.737,0.27l-0.268,0.17l0.558,0.352l0.111,0.169l-0.659,0.694l-0.154,0.297l-0.012,0.848l0.144,0.636l0.271,0.762l0.425,0.903l-0.347-0.119l-0.816-0.377l-0.296,0.001l-0.416,0.116l-0.264-0.069     l-1.029-0.56l-0.921-0.32l-0.375-0.365l-0.336-0.592l-0.332-0.932l-0.078-0.467l-0.268-0.253l-0.657-0.576l-0.845-1.042l-0.744-1.227l-0.663-1.029l-0.363-0.366l-0.412-0.252l-0.783-0.321l-0.475-0.082l-0.643,0.018l-0.468,0.201l-0.576,0.541l-0.418,0.413     l-0.283,0.37l-0.416,0.158l-0.501-0.011l-0.337-0.069l-1.104-0.503l-1.092-0.659l-0.445-0.549l-0.318-0.847l-0.284-0.678l-0.179-0.226l-0.708-0.491l-0.837-0.519l-0.766-0.632l-0.631-0.662l-0.209-0.112l-1.892-0.046l-1.858-0.003l-0.096,0.892l-0.213,0.101     l-1.867,0.011l-0.966-0.037l-1.544-0.02l-1.662-0.019l-0.338-0.055l-3.516-1.112l-2.811-0.933l-1.186-0.39l-0.267-0.154l-0.316-0.31l-2.381,0.084l-2.367,0.155l-0.34,0.017z M49.818,152.776l-0.122,0.086l-0.279,0.03l-0.111-0.131l-0.177-0.005l-0.324,0.051     l-0.304-0.39l-0.071-0.263l0.339-0.01l0.299-0.253l0.188,0.218l0.106,0.294l0.223,0.096l0.233,0.279z M52.785,154.312l-0.155-0.081l-0.085-0.356l-0.461-0.321l0.095-0.229l0.143-0.058l0.366,0.209l0.344,0.055l0.616,0.356l-0.005,0.172l-0.294,0.184l-0.563,0.069z      M111.683,77.224l-0.138,0.415l-0.45,0.067l-0.324,0.113l-0.295,0.247l-0.321-0.137l-0.185-0.21l0.087-0.443l0.086-0.443l-0.438-0.675l-0.463-0.319l-0.199-0.271l-1.281,0.055l-0.437,0.098l-0.153,0.161l-0.496,0.097l-0.019-0.193l-0.034-0.432l0.212-0.272     l0.184-0.212l-0.378-0.347l-0.641-0.438l-0.693-0.696l-0.723-0.317l-0.453-0.136l0.132-0.35l-0.569-0.592l-0.099-0.213l0.371-0.229l-0.068-0.122l-0.301-0.152l-0.445-0.076l-0.392-0.274l-0.237-0.259l-0.57-0.305l-1-0.411l-0.479-0.765l-0.217-0.583l-0.367-0.399     l-0.357,0.016l-0.101,0.814l0.42,0.873l0.104,0.306l-0.047,0.153l-0.701-0.136l-0.272-0.076l-0.511-0.504l-0.4-0.459l-0.537,0.139l-1.219-0.228l1.263,0.718l0.032,0.214l-1.62,0.171l-1.093-0.35l-1.388-0.948l-0.543-0.292l-0.664-0.043l-0.079,0l-0.933-0.213     l-1.3-0.536l0.928-0.248l0.135-0.169L90.8,67.129l-0.384-0.153l-0.792,0.156l-0.454,0.14l-0.656,0.017l-1.058-0.06l-1.068-0.245l0.027-0.247l-0.148-0.186l-0.325-0.108l-0.359,0.016l-0.47,0.202l-1.036,0.049l-1.465-0.122L80.46,66.64l-0.786-0.091l-0.248-0.108     l-0.651-0.387l-0.427-0.527l-0.301,0.218l-0.788,0.157l-0.89-0.293l-0.234-0.326l-0.417-0.139l-0.872-0.248l-1.538-0.23l-0.817-0.248l-0.671-0.342l-0.553,0.235l-0.675,0.079l0.06,0.437l-0.193,0.062l-0.389,0.25l-0.249,0.405l1.119,0.293l0.174,0.294     l-0.096,0.388l-0.428,0.449l-0.458,0.001l-0.804-0.214l-0.586-0.061l-0.568,0.094l-0.978,0.603l-1.066,0.217l-0.936,0.448l-1.035,0.448l-1.095,0.109l0.178-0.308l0.063-0.123l0.72-0.401l-0.093-0.385l-0.655-0.523l0.004-0.108L64.1,66.19l0.411-0.482l0.157-0.42     l0.736-0.312l0.87-0.235l1.165-0.018l1.085,0.123l0.239-0.156l-1.239-0.466l-0.971-0.389l-1.043,0.049l-0.226,0.219l-0.449,0.095l-0.573,0.438l-0.865,0.375l-1.019,0.282L61.553,65.9l-0.406,0.094l-0.298,0.14l0.131,0.325l-0.177,0.526l-0.563,0.34l-0.564,0.078     L59,67.544l-0.592,0.278l-0.681,0.601l-0.035,0.292l0.38,0.168l0.36,0.03l0.667,0.106l0.465,0.229l-0.075,0.184l-0.43,0.338l-0.625,0.2l-0.557,0.277l-0.423,0.398l-0.544,0.383l-0.675,0.093l-1.434,0.308l-0.678,0.397l-1.036,0.337l-0.7,0.367l0.52,0.5l-0.1,0.167     l-1.106,0.412l-0.897,0.153l-0.778,0.168L49.51,74.19l-1.214,0.456L48.1,74.828l-0.274,0.394l-0.753,0.439l-1.193,0.229l-1.234,0.184l-0.973-0.345l0.001-0.181l0.332-0.348l0.763-0.273l0.306-0.212l0.445-0.364l1.171-0.441l1.403,0.073l-0.12-0.212l0.02-0.516     l0.47-0.304l0.725-0.291l0.754-0.366l0.266-0.214l0.002-0.731l0.246-0.749l0.693-0.49l0.194-0.398l0.034-0.412l-0.633,0.122l-1.251,0.186l-0.676-0.029l-0.5-0.597l-0.266,0.062l-0.613,0.216l-0.136,0.23l0.239,0.352l0.021,0.352l-0.169,0.046L47,70.115     l-0.567-0.32l-0.487-0.397l-0.509-0.291l-0.56-0.03l-0.812-0.106l-0.91,0.094l0.028,0.138l-0.644,0.338l-1.175,0.14l-0.649-0.09l-0.064-0.123l-0.082-0.107l-0.125-1.028l0.3-0.508l-0.142-0.431l-0.864-1.002l-1.43,0.437l-0.738,0.078l-0.406,0.202l-1.091,0.094     l-0.4-0.23l-0.394-0.355l-0.466-0.325l-1.007-0.463l-0.179-0.28l0.292-0.171l0.337-0.437l0.704,0.139l1.312,0.309l0.69,0.03l0.238-0.234l-0.375-0.482l-0.458-0.264l-0.363,0l-0.541,0.22l-0.528-0.015l-1.342-0.513l-0.623-0.186l-0.197,0.016l-0.858-0.029     l-0.024-0.078l-0.623-0.985l0.79-0.19l0.071-0.456l0.495-0.221l0.102-0.299l0.227-0.347l0.893-0.491l0.337-0.38l0.386-0.301l0.527-0.476l0.39-0.175l0.719,0.109l0.98,0.268l0.485,0.094l0.752-0.144l0.427-0.254l0.675-0.429l1.252-0.257l0.774-0.033l0.955-0.049     l0.354-0.175l0.187-0.478l-0.259-0.669l-0.814-0.686l0.026-0.096l0.927-0.034l0.343-0.256l-0.25-0.384l-0.497-0.256l-0.367-0.08l-1.88,0.389L39.33,56.53l-0.534,0.289l-0.496,0.065l-1.907-0.333l-0.848-0.031L34.8,56.49l-1.27,0.162l-1.265-0.029l-1.349-0.174     l-0.53-0.207l-0.183-0.788l0.144-0.146l0.636-0.033l1.008-0.002l0.446-0.179l-1.057-0.241l-1.912-0.304L28.13,54.31l-1.285-0.208l0.219-0.114l0.781-0.262l1.568-0.214l1.325-0.328l0.958-0.214l1.058-0.361l0.953-0.23l1.399-0.281l1.513,0.128l-0.158,0.523     l0.023,0.277l1.051,0.161l1.359,0.095l1.074-0.019l0.657-0.099l0.784-0.246l0.55-0.295l0.262-0.083l0.752,0.064l0.751,0.113l1.021-0.051l0.2-0.327l0.007-0.18l-0.689-0.064l-1.946-0.292l-1.283-0.047l-0.312-0.755l-1.473-0.162l-0.96-0.031l-1.573-0.096     l-0.194-0.511l-0.484-0.312l-1.042-0.461l-0.512-0.148l-2.66-0.659l-2.008-0.545l0.317-0.167l0.812-0.402l0.086-0.485l2.136-0.054l0.99-0.069l1.829-0.288l0.784-0.354l0.452-0.623l0.788-0.575l0.616-0.525l0.818-0.41l0.742-0.224l1.066-0.104l1.133-0.241     l1.047-0.036l1.804,0.065l0.146-0.188l-0.156-0.205L44.47,42.83l0.018-0.206l1.936-0.089l1.143,0.032l0.974-0.054l1.344-0.14l1.098-0.416l0.918-0.417l0.957-0.019l0.282,0.051l0.675,0.241l0.156,0.172l-0.383,0.139l0.017,0.344l1.049,0.136l0.424,0.034     l0.536-0.293l0.297-0.208l1.419,0.187l1.534,0.049l1.062,0.049l0.715,0.033l0.711,0.257l0.359,0.274l0.783,0.358l0.494,0.085l0.421-0.086l1.292,0.117l1.124,0.015l1.556-0.054l1.449-0.088l1.213,0.1l1.377,0.254l0.883,0.118l3.424,0.13l1.279,0.168l0.743,0.169     l2.027-0.038l2.339-0.141l1.123,0.236l2.441,0.791l1.206,0.301l0.227,0.008l0.102,0.483l-0.003,2.855l0.039,2.259l0.052,2.335l0.129,2.796l-0.026,2.183l-0.043,4.334l0.026,2.167l0.089,1.046l0.196,0.279l0.84,0.074l2.424-0.122l0.739,0.059l0.332,0.388     l0.173,0.387l0.348,0.292l2.162,1.318l0.945,0.673l0.238-0.325l0.848-0.205l1.225-0.67l0.731-0.498l0.495-0.126l0.832,0.073l0.316,0.199l0.371,0.492l0.35,0.322l2.048,1.175l0.814,0.58l1.769,1.768l1.67,1.882l0.512,0.393l0.189,0.029l0.98,0.314l2.025,0.763     l0.402,0.255l-0.163,0.788l0.393,0.777z'},
	CN => {name => 'China',
		d => 'M643.755,159.873l-1.092-0.52l-0.637-0.337l-0.203-1.284l0.036-0.282l0.24-0.241l0.42-0.241l0.721-0.623l0.493,0.056l0.049-0.17l0.24-0.396l0.239,0.028l0.573,0.225l0.321-0.312l0.439-0.001l0.798-0.171l0.596,0.69l-0.163,0.17l-0.443,0.354     l-0.412,0.538l-0.285,0.734l0.14,0.296l-0.22,0.311l-0.292,0.085l-1.026,0.383l-0.532,0.707z M627.173,150.012l-0.679,0.314l-0.24,0.241l-0.043,0.325l0.138,0.592l0.228,0.366l0.119,0.521l-0.109,0.339l-0.266,0.213l-0.769-0.08l-0.321-0.21l-0.178-0.196     l-0.153-0.239l-0.111-0.38l-0.628,0.413l-0.647,0.159l-0.246-0.083l-0.378-0.266l-0.341-0.746l-0.291-0.379l-0.481,0.045l-0.507,0.003l-0.228-0.098l-0.117-0.352l0.729-1.584l-0.033-0.268l-0.521-0.096l-0.554,0.074l-0.202-0.324l-0.277-1.762l-0.156-0.126     l-0.479,0.017l-0.771,0.089l-0.819,0.442l-0.312,0.086l-0.216-0.069v-0.268l0.224-0.58l-0.163-0.705l-0.075-0.465l0.617-0.85l0.191-0.198l0.487-0.271l0.611-0.525l0.429-0.722l0.353-0.862l-0.02-0.875l-0.195-1.649l-0.146-0.14l-0.504,0.031l-0.287-0.041     l-0.217-0.309l-0.243-0.901l-0.397-0.435l-0.504-0.279l-0.277,0.044l-0.306,0.34l-0.001,0.127l-0.624-0.081l-0.73-0.179l-0.657-0.081l-0.3-0.055l-0.102-0.056l0.138-0.269l0.354-0.454l-0.046-0.38l-0.716-0.715l-0.455-0.392l-1.377,0.84l-0.377,0.044l-0.975-0.319     l-0.286-0.167l-0.355,0.087l-0.546,0.299l-1.105,0.726l-0.829,0.258l-0.543,0.37l-1.123,1.107l-0.397,0.27l-0.714,0.216l-0.784,0.033l-0.189,0.1l-0.329-0.619l-0.312-0.209l-0.371-0.041l-1.659-0.047L601,137.538l-0.309-0.294l-0.417,0.016l-0.149,0.103     l-0.348,0.239l-0.609,0.539l-1.251,1.545l-0.212-0.662l0.052-0.861l-0.139-0.183l-0.231-0.069l-0.471,0.102l-0.345,0.129l-0.655-0.159l-0.339,0.281l-0.341-0.116l-0.849,0.066l-0.319-0.364l-0.63-0.281h-0.407l-0.08,0.331l-0.271,0.083l-0.685-0.38l0.01,0.364     l-0.237,0.099l-0.141-0.463l-0.54-0.496l-0.365,0.066l-0.935-0.066l-0.014-0.265l0.175-0.396l-0.326-0.017l-0.333,0.248l-1.451-0.893l0.069-0.281l-0.178-0.38l-0.289-0.166l-0.71,0.116l-0.158,0.166l-0.657-0.794l-0.454-0.281l-0.15,0.132l-0.472-0.215     l-0.726-0.595l-0.867-0.264l-0.132-0.612l-1.079-0.199l-0.186,0.182l-0.275-0.066l-0.134,0.513l-0.276,0.314l-0.299-0.05l-0.24-0.43l-0.859-0.596l-0.154,0.066l-0.756-0.248l0.116-0.364l-1.078-0.579l-0.363,0.116l-0.772-0.843l-0.383-0.248l-0.477,0.314     l-0.198-0.066l-0.099-0.43l0.215-0.215l-0.272-0.364l0.104-0.446l-0.579-0.595l-0.157-0.694l0.785-0.198l0.033,0.364l0.337,0.264l0.368-0.049l0.376-0.281l0.578-0.364l-0.367-0.694l0.104-0.414l-0.68-0.099l-0.044-0.182l-0.092-0.078l-0.718-0.096l-0.294-0.221     l-0.037-0.552l-0.073-0.589l0.184-0.184l0.331-0.221l-0.221-0.258l-0.441-0.405l-0.81-0.11l-0.221-0.515l-0.441-1.03v-0.515l-0.502,0.152l-0.147-0.126l-0.305-0.111l-1.337-0.104l-0.565-0.436l-0.178-0.09l-0.104-0.199h-0.239l-0.52,0.196l-0.252-0.281     l-0.198-0.218l-0.301-0.07l0.312-0.516l-0.007-0.501l-0.213-0.247l-0.373-0.323l-0.625,0.009l-0.282,0.128l-0.004-0.456l-0.554-0.117l-0.296-0.047l-0.281,0.21l-0.105-0.112l-0.313-0.14l-0.048-0.088l-0.236-0.012l-0.01-0.269l0.574,0.059l0.192-0.145l0.354-0.136     l0.08-0.249l0.181-0.185l-0.2-0.163l0.152-0.36l-0.245-0.237l0.126-0.428l-0.049-0.123l-0.152-0.012l-0.028-0.246l0.009-0.284l-0.295-0.494l-0.273-0.154l-0.692-0.039l-0.22-0.06l-0.229,0.162l-0.463,0.045l-0.325-0.394l-0.077-0.305l0.207-0.223l-0.023-1.031     l0.011-0.069l0.139-0.739l0.129-0.213l0.274-0.186l1.422-0.704l1.737-0.734l0.359-0.03l0.06,0.071l0.183,0.567l0.344,0.055l0.507-0.145l0.885-0.132l0.268-0.243l0.463-0.784l0.467-0.472l0.238-0.03l1.248,0.235l0.459-0.017l0.478-0.102l0.646-0.345l0.638-0.701     l0.405-0.301l0.445-0.145l1.338-0.349l0.97-0.219l0.325-0.187l0.051-0.157l-0.031-0.194l-0.139-0.86l0.02-0.399l0.32-0.401l0.705-0.546l0.222-0.33l-0.119-0.47l-0.29-0.441l-0.345-0.627l-0.03-1.357l-0.483-0.141l-0.366,0.06l-0.232-0.185l0.068-0.215l0.215-0.302     l0.393-0.188l1.799-0.254l1.082-0.207l0.35-0.06l0.5,0.184l1.133,0.238l0.394-0.074l0.231-0.145l0.156-0.245l-0.126-0.286l-0.622-0.514l0.137-0.418l0.286-0.605l0.438-0.794l0.516-1.141l0.427-0.507l1.096,0.254l0.721,0.141l0.594,0.141l1.402,0.079l0.718-0.062     l0.417-0.103l0.444-0.392l0.157-0.39l-0.213-0.707l-0.097-0.75l0.34-0.581l0.428-0.277l1.199-0.093l0.289-0.06l0.306-0.219l0.035-0.478l0.011-0.275l0.279-0.262l0.542-0.148l0.551-0.034l0.228-0.014l0.569-0.003l0.244-0.074l0.062,0.145l0.131,0.405l0.24,0.563     l0.371,0.433l1.301,0.745l0.834,0.415l0.614,0.069l0.731,0.167l0.633,0.144l0.354,0.143l0.568,0.618l1.07,1.451l0.401,0.66l-0.215,0.447l-0.237,0.75l-0.214,0.389l-0.369,0.347l-0.035,0.129l0.105,0.43l0.233,0.229l0.724,0.312l1.062,0.181l1.505,0.021     l0.995,0.038l0.668,0.083l0.998,0.224l0.632,0.268l1.645,0.806l0.839,0.31l0.744,0.096l0.105,0.542l1.571,2.161l0.467,0.439l0.444,0.254l1.979,0.018l1.241,0.207l0.802,0.109l1.165,0.022l2.861-0.059l0.937,0.023l1.164,0.022l1.69,0.119l0.521,0.168l0.815,0.551     l1.006,0.365l1.599,0.433l0.929,0.123l0.663-0.061l0.61,0.067l0.253,0.297l0.433,0.197l0.481-0.017l0.686-0.289l1.44-0.534l0.303-0.101l0.736-0.274l0.816-0.289l1.204-0.349l1.339-0.007l1.514-0.065l0.987,0.08l0.651-0.061l1.941-0.737l0.265-0.172l1.111-1.046     l0.67-0.389l1.265-0.292l0.326-0.259l0.123-0.271l-0.188-0.228l-0.599-0.411l-0.389-0.569l-0.003-0.343l0.214-0.401l0.539-0.589l0.457-0.231l0.316-0.073l0.718,0.154l0.668,0.382l0.592,0.125l0.982-0.005l0.744-0.047l0.742-0.433l1.192-0.91l0.224,0.013     l0.438,0.012l0.624,0.054l0.896-0.134l0.638-0.248l0.347-0.188l0.241-0.216l0.312-0.82l0.363-0.333l0.47-0.204l0.464-0.045l0.483,0.127l0.353-0.189l0.831-0.278l0.539-0.146l0.937-0.221l0.854-0.033l0.432,0.099l1.074,0.008l0.464,0.127l0.414-0.218l0.107-0.217     l-0.048-0.273l-0.599-0.501l-0.879-0.99l-0.797-0.5l-0.538-0.199l-0.928-0.212l-0.438,0.002l-1.191,0.786l-0.292-0.07l-0.431-0.416l-0.317-0.085l-0.576,0.018l-0.754,0.062l-0.929,0.395l-0.342,0.045l-0.051-0.029l-0.269-0.836l0.381-0.58l1.224-1.959l0.687-1.207     l0.295-0.31l0.046,0.018l0.452,0.172l1.126,0.574l0.343-0.016l0.438-0.089l2.44-0.752l0.779-0.339l0.123-0.233l-0.056-0.306l-0.35-0.348l-0.062-0.146l0.103-0.249l0.422-0.426l0.416-0.543l0.667-0.779l0.599-0.545l1.371-0.608l0.167-0.794l-0.107-0.249     l-0.465-0.306l-0.558-0.026l-0.822,0.078l0.119-0.25l0.375-0.282l1.193-0.787l0.478-0.165l0.602-0.136l1.854-0.143l0.836-0.123l1.203-0.109l0.917-0.049l1.148,0.215l1.037,0.481l0.683,0.188l1.386-0.125l0.539,0.026l0.763,0.467l0.742,0.952l1.087,2.384     l0.94,1.588l0.927,1.903l0.436,0.389l0.507,0.2l1.247,0.341l1.523,0.253l2.659,0.839l0.205,0.144l0.297,0.866l0.44,1.283l0.261,0.446l0.68-0.033l0.649-0.018l1.657-0.052l0.604-0.22l0.953-0.308l1.357-0.31l1.181-0.208l0.902-0.034l0.246,0.114l0.064,0.259     l0.116,0.389l0.017,0.504l-0.566,0.407l-0.66,0.393l-0.291,0.707l-0.278,0.893l-0.538,1.066l-0.627,1.08l-0.329,0.432l-0.551,0.69l-0.47,0.347l-0.547-0.098l-0.679-0.225l-0.685-0.24l-0.396-0.041l-1.664,0.982l-0.048,0.557l0.332,0.897l0.062,0.656l-0.006,0.613     l-0.025,0.385l-0.097,0.128l0.112,0.299l-0.156,0.329l-0.511,0.43l-1.252,0.462l-0.111,0.058l-0.579-0.68l-0.247,0.001l-0.253,0.129l-0.383,0.358l-0.23,0.713l-0.955,0.532l-0.62,0.259l-0.538,0.017l-0.452-0.054l-0.333-0.126l-0.392,0.059l-0.273,0.243     l-0.025,0.342l0.508,0.765l0.046,0.113l-0.527,0.159l-0.975,0.048l-0.508-0.153l-0.493-0.253l-0.273-0.396l-0.448,0.017l-0.386,0.13l-0.686,1.027l-0.636,0.543l-1.032,0.545l-1.533,0.604l-0.52,0.329l-0.415,0.442l-0.379,0.528l-0.066-0.092l-0.417,0.171     l-1.222,0.13l-0.728,0.171l-2.248,0.925l-0.632,0.37l-0.566,0.469l-0.604,0.271l-0.336,0.015l0.13-0.255l0.862-0.682l0.33-0.354l-0.47-0.113l-0.37,0.072l-0.153-0.297l0.058-0.156l0.953-0.781l0.269-0.384l0.55-0.413l0.159-0.2l-0.057-0.298l-0.73-0.553     l-0.727-0.283l-0.131-0.014l-0.628,0.03l-0.166,0.015l-0.494,0.371l-1.146,1.183l-0.355,0.157l-0.643,0.086l-0.613,0.243l-0.36,0.199L665.49,112l-0.136,0.411l-0.131,0.255l-0.251,0.255l-0.437,0.128l-0.493-0.013l-0.326,0.27l-0.307,0.114l-0.455-0.565     l-0.355-0.014l-0.349,0.128l-0.396,0.638l-0.301,0.694l0.088,0.34l0.245,0.368l0.558,0.268l0.8,0.268l1.21-0.045l0.29,0.254l-0.019,0.538l-0.123,0.581l0.057,0.538l0.261,0.283l0.733,0.069l0.698-0.157l0.76-0.525l0.509-0.497l0.552-0.228l0.534-0.128l0.287,0.07     l0.895,0.621l0.543,0.197l1.023-0.087l0.361,0.027l0.471,0.141l0.274,0l-0.248,0.708l-0.057,0.552l-0.612-0.197l-0.297-0.084l-0.525,0.058l-1.677,0.555l-0.707,0.44l-0.072,0.735l-0.522,0.157l-0.146-0.113l-0.017-0.269l-0.127-0.084l-0.501,0.114l0.138,0.466     l-0.152,0.368l-0.485,0.496l-1.397,1.119l-0.126,0.226l0.039,0.55l0.62,0.225l0.712,0.492l0.785,0.521l0.391,0.535l0.424,1.241l0.668,0.647l0.175,0.437l-0.13,0.677l0.172,0.183l0.694,0.295l0.399,0.592l0.562,0.253l0.272,0.268l0.087,0.31l-0.049,0.155     l-0.789,0.369l0.088,0.07l0.425,0.31l0.314,0.79l-0.019,0.296l-0.141,0.184l-0.534,0.043l-0.651,0.213l-0.948,0.552l-0.849,0.213l-0.629,0.297l0.72,0.21l0.378,0.056l0.944-0.425l0.488-0.058l0.162,0.056l0.524,0.592l0.387,0.168l0.456,0.027l0.009,0.155     l-0.231,0.311l-0.382,0.227l-0.304,0.241l0.11,0.155l0.326-0.029l0.202,0.084l-0.184,0.325l-0.298,0.749l-0.192,0.649l0.028,0.353l-0.22,0.452l-0.209,0.127l-0.35-0.338l-0.146,0.142l-0.569,0.763l-0.401,0.622l-0.215,0.622l-0.127,0.296l-0.595,0.425     l-0.251,0.438l-0.254,0.184l-0.569,0.029l-0.382,0.227l0.279,0.719l-0.264,0.508l0.076,0.593l-0.093,0.269l-0.207,0.269l-0.532,0.199l-0.161,0.282l-0.174,0.396l-0.294,0.636l-0.626,0.354l-0.412,0.495l-0.492-0.14l-0.443-0.069l-0.142,0.113l-0.145,0.198     l0.118,0.833l-0.213,0.142l-0.772,0.651l-0.356,0.127l-0.628,0.171l-0.563,0.467l-0.571,0.213l-0.107,0.113l-0.008,0.48l-0.133,0.156l-0.568,0.058l-0.5,0.114l-0.341,0.438l-0.364-0.126l-0.52-0.168l-0.274,0.057l-0.315,0.326l-0.435,0.198l-0.643,0.1     l-0.047-0.465l-0.52,0.057l-0.699,0.213l-0.32,0.198l-0.285-0.042l-0.401-0.493l-0.163-0.155l-0.191,0.283l0.095,0.169l-0.045,0.212l-0.047,0.691l-0.209,0.297l-0.416,0.114l-0.501-0.182l-0.123,0.282l-0.001,0.24l-0.146,0.155l-0.615,0.058l-0.366,0.114     l-0.596,0.043l-0.463-0.211l-0.217,0.1l-0.439,0.48l-0.227,0.071l-0.774-0.041l-0.747,0.227l-0.406,0.326l-0.451-0.027l-0.277-0.084l-0.011,0.057l-0.069,0.353l-0.29,0.396l0.011,0.113l0.48,0.634l0.269,0.126l0.043,0.198l-0.36,0.269l-0.763,0.157l-0.481-0.719     l-0.241-0.691l0.012-0.395l0.396-0.777l-0.015-0.169l-0.587-0.253l-0.226,0.071l-0.206,0.297l-0.454,0.072l-0.676-0.21l-0.574-0.733l-0.196,0.085l-0.017,0.169l-0.159,0.396l-0.27,0.128l-0.332-0.056l-0.481,0.043l-0.055,0.038l-0.197-0.143l-0.909-0.107     l-0.621-0.166l-0.943-0.615l-0.273-0.365l-0.096-0.521l0.472-0.75l-0.056-0.38l-0.237-0.21l-0.777,0.047l-0.66-0.053l-0.771-0.235l-0.623-0.575l-0.298,0.101l-0.521,0.328l-0.696,0.554l-0.341,0.157l-0.807,0.117l-1.595,0.052l-0.332,0.115l-0.584,0.413     l-0.325-0.097l-0.597-0.392l-0.341-0.012l-0.515,0.13l-0.483,0.229z'},
	HT => {name => 'Haiti',
		d => 'M241.073,156.152l0.017,0.52l0.098,1.215l0.012,0.212l-0.379,0.455l-0.011,0.17l0.485,1.358l-0.669-0.577l-0.445-0.056l-0.761,0.143l-0.877-0.012l-0.666-0.14l-0.574-0.056l-0.474,0.1l-0.378,0.354l-0.135-0.042l-0.993-0.549l-0.171-0.325     l0.04-0.198l0.269-0.184l1.051,0.097l0.631,0.111l1.125,0.167l0.654,0.041l0.61-0.185l0.386-0.156l-0.198-0.155l-0.692-0.464l-0.136-0.296l0.184-0.707l-0.202-0.296l-0.394-0.154l-0.913-0.14l-0.305-0.211l0.04-0.184l0.119-0.085l0.344-0.1l0.724-0.058     l0.781,0.125l1.081,0.294l0.576,0.056l0.147-0.089z'},
	DO => {name => 'Dominican Republic',
		d => 'M241.295,160.082l-0.485-1.358l0.011-0.17l0.379-0.455l-0.012-0.212l-0.098-1.215l-0.017-0.52l0.503-0.279l0.393,0.14l0.342,0l0.384-0.17l0.369-0.043l0.14,0.198l0.177,0.112l1,0.309l0.657-0.072l0.213,0.395l0.335,0.338l0.528,0.324     l0.335,0.084l0.643,0.21l0.916,0.45l0.399,0.352l0.231,0.311l-0.191,0.17l-0.144,0.297l-0.314,0.368l-0.238-0.098l-0.476-0.592l-0.378-0.042l-0.788,0.058l-0.288-0.098l-0.373,0l-0.329,0.1l-0.763,0.539l-0.396-0.056l-0.319-0.494l-0.166-0.028l-0.155,0.057     l-0.658,0.326l-0.344,0.778l-0.41,0.65l-0.289-0.112l-0.325-0.551z'},
	PH => {name => 'Philippines',
		d => 'M668.053,167.796l-0.131-0.099l-0.74-0.732l-0.444-1.255l0.037-0.424l0.054-0.706l-0.292-0.465l0.18-0.382l0.978,0.704l0.202-0.424l0.023-0.41l-0.101-0.438l-0.026-0.579l0.145-0.438l0.025-0.664l0.082-0.861l0.074-0.636l0.38-0.862     l0.188-0.127l0.337-0.142l0.523,0.055l1.21,0.52l0.576,0.042l0.188-0.212l0.277-0.17l0.199,0.141l0.018,0.396l-0.266,0.438l-0.045,0.48l0.14,0.79l0.541,0.394l0.182,0.325l-0.427,1.271l-0.31,0.467l-0.834,0.608l-0.555,0.312l-0.082,0.099l0.003,0.268     l-0.078,0.565l-0.28,0.424l0.127,0.211l0.35,0.733l0.345,1.101l0.26,0.62l0.093,0.028l0.451,0.324l0.296,0.07l0.161-0.325l0.485-0.537l0.197-0.029l0.418,0.112l0.226,0.211l0.179,0.635l0.286,0.353l0.326,0.084l0.505-0.58l0.621,0.267l0.141,0.028l0.078,0.127     l-0.168,0.156l-0.378,0.156l-0.208,0.212l0.936,1.226l-0.315,0.184l-0.568-0.196l-0.404-0.098l-0.094-0.48l-0.229-0.31l-0.599-0.535l-0.753-0.577l-0.258,0l-0.099,0.226l0.371,0.776l-0.218,0.283l-0.727-0.775l-0.982-0.548l-0.309,0.015l-0.344,0.142l-0.182,0.255     l-0.14,0.071l-0.395,0.057l-0.322-0.225l-0.591-0.366l-0.195-0.423l0.64-0.608l0.323,0.211l0.358,0.084l0.4-0.199l-0.151-0.169l-0.713-0.295l-0.422-0.395l-0.522-0.168l-0.239,0.607z M669.676,172.974l-0.452-0.366l-0.349-0.408l-0.051-0.226l-0.364-1.114     l-0.459-0.521l0.685-0.058l0.868,0.012l0.314,0.169l0.274,0.451l0.028,0.861l-0.097,0.48l-0.214,0.283l-0.185,0.438z M679.073,175.368l-0.562-0.267l-0.178-0.254l-0.237-0.169l-0.064-0.127l0.139-0.339l-0.091-0.423l-0.55-0.352l-0.662-0.479l-0.147-0.466     l0.513-0.1l1.017-0.143l0.371,0.112l0.283,0.409l0.069,0.818l0.123,0.805l0.257,0.79l-0.112,0.127l-0.167,0.057z M671.406,176.824l0.022-0.353l0.186-1.342l0.061-1.172l0.482,0.395l0.576,0.281l0.366,0.028l0.634-0.185l0.027,0.438l-0.079,0.396l-0.24,0.269     l-0.184,0.198l-0.908,0.651l-0.943,0.397z M664.721,177.812l-0.366-0.027l0.127-0.297l0.202-0.099l0.314-0.396l0.265-0.523l0.082-0.607l0.138-0.509l0.326-0.184l0.14,0.183l-0.16,0.283l0.276,0.55l0.212,0.564l-0.108,0.113l-0.664,0.354l-0.406,0.368l-0.377,0.227     z M673.781,179.981l-0.385-0.366l-0.828-0.591l-0.206-0.38l0.099-0.368l0.565-0.213l0.22-0.269l0.487-1.822l0.438-0.185l0.271,0.028l0.113,0.126l0.049,0.282l-0.373,0.905l-0.089,0.226l-0.315,1.413l0.165,0.296l0.214,0.465l-0.213,0.41l-0.212,0.043z      M661.179,181.308l-0.317-0.042l0.215-0.48l0.343-0.467l0.35-0.34l0.592-0.354l0.636-0.496l0.933-1.089l0.11,0.55l-0.118,0.424l-0.267,0.297l-0.24,0.184l-0.516,0.213l-0.172,0.127l-0.244,0.622l-0.327,0.269l-0.591,0.171l-0.386,0.41z M680.678,185.402     l-0.201-0.098l-0.098-0.438l-0.361-0.748l-0.297-0.112l-0.381,0.608l-0.361,0.82l0.246,0.38l0.166,0.395l0.148,0.677l-0.158,0.495l-0.383,0.509l-0.305-0.253l-0.176-0.268l0.201-0.41l-0.076-0.325l-0.363-0.07l-0.361,0.665l-0.173-0.056l-1.114-0.619l-0.557-0.549     l-0.206-0.508l-0.037-0.635l0.466-0.905l-0.108-0.479l-0.466-0.409l-0.778-0.295l-0.292,0.043l-0.062,0.17l-0.129,0.226l-0.5,0.255l-0.661,0.058l-0.027-0.494l-0.174-0.24l-0.399,0.199l-0.504,0.961l-0.525,0.863l-0.219-0.084l-0.119-0.127l-0.034-0.197     l0.054-0.311l0.359-0.749l0.185-0.537l0.263-0.283l0.383-0.184l0.564-0.044l0.219-0.127l0.134-0.466l0.205-0.156l0.549-0.241l0.777-0.101l0.292,0.353l0.102,0.72l0.317-0.156l0.485-0.058l0.207-0.184l0.207-0.565l0.358-0.255l0.479,0.21l0.186,0.084l0.158-1.087     l0.29-0.015l0.264,0.465l0.315-0.481l0.205-0.142l0.392,0.098l0.133-0.227l-0.048-0.706l-0.172-0.564l0.146-0.353l0.413,0.549l0.711,0.803l0.229,0.48l0.083,0.324l-0.336,0.735l0.237,0.226l0.537-0.1l0.076,0.423l-0.114,0.424l0.056,0.692l0.207,0.437     l-0.002,0.438l-0.111,0.424l-0.283,0.579l-0.332,0.622z'},
	PR => {name => 'Puerto Rico',
		d => 'M251.898,160.229l-0.547-0.112l-0.073-0.212l0.051-0.551l-0.109-0.24l0.11-0.17l0.235-0.071l0.543,0.069l0.404-0.015l1.505,0.11l0.393,0.168l0.113,0.141l-0.188,0.354l-0.07,0.099l-0.283,0.227l-0.335,0.043l-0.739-0.083l-0.657,0.072     l-0.354,0.17z'},
	JM => {name => 'Jamaica',
		d => 'M228.82,160.519l-0.299-0.056l-0.693-0.224l-0.229-0.268l-0.47-0.366l-0.465-0.084l-0.142-0.211l0.53-0.284l0.704-0.072l1.364,0.251l0.97,0.351l0.651,0.267l0.279,0.282l-0.04,0.198l-0.332,0.071l-0.751-0.295l-0.543,0.058l-0.227,0.255     l-0.308,0.128z'},
	BF => {name => 'Burkina Faso',
		d => 'M400.72,175.499l-0.595-0.119l-0.161-0.032l-0.976,0.458l-1.429-0.006l-0.867-0.037l-2.119,0.041l-0.271,0.157l-0.125,0.34l0.261,1.934l0.02,0.41l-0.191,0.17l-0.63-0.434l-0.644-0.166l-0.769,0.075l-0.608,0.159l-0.446,0.257l-0.368,0.115     l-0.354-0.083l-0.452-0.223l-0.52-0.562l-0.15-0.465l-0.308-0.252l-0.545,0.003l-0.259-0.168l0.08-0.043l0.046-0.156l0.172-0.326l0.261-0.92l0.133-0.876l-0.058-0.749l0.141-0.255l0.257-0.016l0.448-0.158l0.543-0.271l0.317-0.369l0.292-1.047l0.355-1.217     l0.397-0.384l0.273-0.058l0.293,0.281l0.551,0.364l0.45-0.102l0.174-0.227l0.393-0.822l0.492-0.667l0.638-0.625l0.272-0.101l0.518,0.209l0.324,0.182l0.274,0.027l0.314-0.793l0.304-0.228l0.947-0.458l1.22-0.713l0.37-0.073l0.356,0.125l0.36,0.059l1.062,0.173     l-0.173,0.665l0.019,0.396l0.426,0.93l0.422,0.492l0.389,0.266l0.502,0.42l0.179,0.268l0.018,0.212l-0.335,0.439l0.114,0.226l0.97,0.757l0.516,0.181l0.37-0.044l0.562,0.025l0.568,0.971l0.131,0.367l-0.237,0.764l-0.415,0.468l-0.337,0.158l-0.739-0.095     l-0.418,0.045l-0.415,0.271l-0.366,0.553l-0.24,0.157l-0.062,0.142l-0.29-0.041l-0.611-0.166l-1.013-0.163z'},
	NI => {name => 'Nicaragua',
		d => 'M209.823,175.47l-0.388-0.645l-0.932-0.888l-1.003-1.085l-0.837-0.817l-0.723-0.464l-0.196-0.183l-0.023-0.226l0.625-0.03l1.001-0.125l0.29-0.143l0.293-0.412l0.005-0.961l0.882-0.034l0.513-0.583l0.725,0.42l1.207-0.997l0.503-0.794     l0.294-0.242l0.259,0.013l0.328,0.182l0.463,0.097l0.248-0.086l0.424-0.229l1.425-0.486l0.23,0.519l0.038,0.339l-0.057,0.509l-0.214,0.707l-0.543,0.806l-0.1,0.749l0.042,0.904l-0.245,1.13l-0.188,0.735l-0.101,1.385l0.031,0.55l0.184,0.466l0.188,0.363     l-0.281,0.274l-0.767-0.149l-0.241-0.46l-0.285,0.077l-0.394-0.107l-0.603,0.25l-1.651-0.599l-0.43,0.271z'},
	KH => {name => 'Cambodia',
		d => 'M634.036,168.444l0.533,0.251l0.736,0.165l0.341,0.111l0.469,0.251l0.248-0.058l0.095-0.24l-0.103-0.211l-0.187-0.182l-0.107-0.296l0.392-0.285l0.476-0.186l0.444,0.181l0.373,0.351l0.3-0.072l0.975-0.429l0.209-0.114l-0.215,0.905     l0.029,0.663l0.455,1.014l-0.076,0.367l-0.05,0.424l0.054,1.073l-0.217,0.509l-0.385,0.285l-0.599,0.187l-0.932,0.443l-0.521,0.229l-0.99,0.571l-0.234,0.425l0.216,0.422l0.568,0.435l0.03,0.197l-0.17,0.27l-0.688-0.194l-0.497-0.011l-0.599,0.229l-0.915,0.528     l-0.646,0.229l-0.3,0.289l-0.256-0.188l-0.248-0.268l-0.35-0.042l-0.382,0.142l-0.205-0.042l-0.293,0.043l-0.183-0.113l0.142-0.311l0.182-0.226l-0.04-0.254l-0.283-0.395l-0.277,0.043l-0.462,0.298l-0.339,0.015l-0.171-1.044l-0.649-1.488l0.146-0.176l-0.16-0.479     l-0.487-0.717l-0.219-0.648l-0.026-0.635l0.076-0.382l0.146-0.297l0.92-1.233l0.521-0.441l0.383-0.101l1.172-0.091l0.798,0.066l0.558-0.074l0.575,0.039l0.599,0.109l0.301,0.167z'},
	CR => {name => 'Costa Rica',
		d => 'M214.474,175.913l0.821,0.884l0.385,0.623l0.314,0.322l0.225,0.046l0.465,0.645l0.441,0.352l-0.014,0.006l-0.074,0.123l-0.478-0.184l-0.219,0.205l-0.014,0.321l0,0.58l0.507,0.307l-0.396,0.368l0.125,0.532l-0.374,0.369l0.243,0.184     l-0.204,0.609l0.003-0.466l-0.296-0.307l0.01-0.568l-0.377-0.148l-0.238-0.102l-0.111,0.082l0.325,0.41l0.084,0.225l-0.113,0.062l-0.726-0.299l-0.13-0.282l0.251-0.339l0.04-0.382l-0.182-0.338l-0.486-0.324l-0.695-0.287l-0.079-0.144l-0.689-0.103l-0.316-0.327     l0.007-0.421l-0.146-0.255l-0.249-0.098l-0.576-0.353l-0.416-0.266l0.225,0.512l0.086,0.222l0.422,0.044l0.181,0.266l-0.544,0.573l-0.144-0.262l-0.356-0.282l-0.561-0.211l-0.323-0.239l-0.147-0.24l-0.104-0.494l0.128-0.421l0.332-0.225l-0.008-0.389l-0.554-0.225     l0.363-0.123l-0.057-0.227l-0.238,0.017l0.43-0.271l1.651,0.599l0.603-0.25l0.394,0.107l0.285-0.077l0.241,0.46l0.767,0.149l0.281-0.274z'},
	CF => {name => 'Central African Republic',
		d => 'M436.304,195.359l-0.209-0.451l-0.194-0.804l-0.498-0.802l-1.217-1.236l-0.112-0.324l-0.064-0.791l-0.432-0.605l-0.4-0.661l-0.207-0.592l-0.273-1.185l-0.112-0.776l0.064-0.424l0.144-0.198l0.528-0.399l0.4-0.511l0.866-1.743l0.354-0.327     l0.208-0.114l0.096,0.084l0.24,0.027l0.449-0.158l1.363-0.686l0.494,0.661l0.225,0.069l0.224-0.03l0.466-0.271l0.754-0.386l0.818-0.273l0.881,0.009l0.368-0.031l0.258-0.143l0.646-1.176l0.117-0.806l0.209-0.199l0.434-0.059l2.181-0.055l0.386-0.087l2.649-2.275     l0.196-0.284l0.005-0.41l0.165-0.382l0.372-0.228l0.939-0.613l0.322-0.086l0.321,0.012l0.559,0.208l1.342,1.673l0.347,0.549l0.122,0.536l-0.416,1.472l0.01,0.664l0.158,0.211l0.802-0.019l0.272-0.001l0.207,0.126l0.252,0.493l0.223,0.225l0.797,0.447l0.799,0.235     l0.351,0.196l0.223,0.267l-0.148,0.481l0.173,0.395l0.445,0.351l0.558,0.378l0.717,0.434l0.207,0.168l0.206,0.366l0.059,0.72l0.285,0.436l0.367,0.224l0.814,0.165l0.558,0.477l0.157,0.352l-0.083,0.679l0.031,0.07l-0.496,0.145l-0.962,0.344l-0.319-0.026     l-0.287-0.167l-0.687-0.264l-1.15-0.361l-0.4,0.13l-0.082,0.551l-0.13,0.241l-0.256,0.058l-0.399-0.026l-0.862-0.207l-0.593,0.102l-0.93,0.373l-0.93,0.486l-0.271,0.016l-0.559-0.35l-0.383-0.153l-0.353,0.186l-0.677,1.36l-0.176,0.157l-0.591-0.067l-1.934-0.511     l-1.422-0.189l-0.512-0.322l-0.159-0.239l-0.334-0.394l-0.75-0.518l-0.432-0.167l-0.479,0.06l-0.529,0.3l-0.353,0.341l-0.785,0.979l-0.097,0.297l0.096,0.452l-0.017,0.353l-0.063,0.594l-0.16,0.058l-0.751,0.287l-0.895-0.093l-0.624-0.138l-0.367-0.054     l-0.975,0.175l-0.479,0.102l-0.255,0.228l-0.222,1.287l-0.158,0.523l-0.365,0.497l-0.303,0.312z'},
	SL => {name => 'Sierra Leone',
		d => 'M371.324,180.419l1.088-1.235l0.643-0.866l0.238-0.157l0.594,0.039l1.137-0.148l0.466,0.04l0.42,0.224l0.456,0.421l0.475,0.619l0.252,0.761l0.165,1.369l0.26,0.656l-0.259,0.502l-1.184,1.151l-0.63,0.724l-0.285,0.256l-0.061,0.103     l-0.631-0.523l-0.661-0.408l-0.483-0.196l-0.033-0.141l0.061-0.297l-0.05-0.184l-0.531-0.21l-0.792-0.549l-0.389-0.366l-0.375-0.465l0.494-0.241l0.174-0.227l-0.034-0.155l-0.484-0.211l-0.065-0.113l0.022-0.173z'},
	LK => {name => 'Sri Lanka',
		d => 'M579.606,186.906l-0.493-0.083l-0.265-0.197l-0.21-0.353l-0.246-0.621l-0.361-1.256l-0.034-0.649l0.005-0.763l-0.02-0.904l-0.24-0.696l0.188-0.513l-0.298-0.35l0.068-0.28l0.423,0.023l0.349-0.43l0.053-0.367l0.226-0.369l-0.152-0.537     l0.529,0.48l0.699,0.38l0.234,0.395l0.549,0.776l0.175,0.324l-0.099,0.339l0.024,0.141l0.592,0.338l0.266,0.733l0.798,1.368l0.136,0.508l-0.193,0.735l-0.397,0.679l-0.369,0.396l-0.514,0.425l-0.78,0.284l-0.642,0.043z'},
	PA => {name => 'Panama',
		d => 'M217.111,178.792l0.52,0.307l0.195,0.512l0.02,0.374l0.363,0.155l0.628,0.024l0.244-0.205l0.398,0.43l0.726,0.082l0.458-0.083l1.348-0.751l0.514-0.046l1.387-0.921l0.373,0.144l0.742,0.069l0.071,0.156l0.789-0.017l0.767,0.21l0.666,0.38     l0.644,0.563l0.406,0.666l0.084,0.327l0.228,0.149l0.509,1.038l-0.322,0.062l-0.094,0.43l-0.584,0.409l-0.085-0.307l-0.19-0.082l0.045,0.45l-0.228,0.082l-0.256,0.753l-0.378-0.825l-0.441-0.762l-0.137-0.452l0.179-0.24l0.22-0.085l0.786,0.125l-0.336-0.193     l-0.125-0.164l-0.096-0.471l-0.309,0.307l-0.439,0.041l-0.244-0.378l-0.031-0.269l-0.193-0.282l-0.132,0.151l-0.226-0.287l-0.11,0.102l-0.132-0.266l-0.456-0.192l-0.562-0.013l-0.499,0.241l-0.382,0.108l-0.07,0.359l0.081,0.234l-0.529,0.318l-0.374,0.184     l-0.335,0.029l-0.345,0.41l0.049,0.296l0.316,0.297l0.464,0.43l0.178,0.386l-0.011,0.146l-0.281,0.081l-0.243-0.042l-0.431,0.391l-0.568,0.105l-0.339-0.042l-0.189-0.146l0.108-0.164l-0.349-0.833l-0.244-0.353l-0.177,0.674l-0.812-0.409l-0.227-0.757     l-0.207,0.041l-0.96-0.123l-0.434-0.266l-0.599,0l-0.314,0.113l-0.361,0.495l0.204-0.609l-0.243-0.184l0.374-0.369l-0.125-0.532l0.396-0.368l-0.507-0.307l0-0.58l0.014-0.321l0.219-0.205l0.478,0.184l0.074-0.123z'},
	GY => {name => 'Guyana',
		d => 'M266.015,188.956l-0.503-0.647l-0.732-0.745l-0.324-0.521l0.071-0.212l0.395-0.539l-0.008-0.58l0.061-0.452l1.032-0.19l0.41-0.144l0.308-0.299l-0.141-0.282l-0.62-0.604l-0.074-0.212l0.101-0.255l1.655-1.239l0.061-0.41l-0.095-0.296     l0.072,0.049l0.496,0.338l0.856,0.521l0.695,0.521l0.587,0.663l0.128,0.409l-0.036,0.734l0.148,0.945l0.298-0.593l0.22-0.099l0.6,0.182l0.101,0.127l0.507,0.295l0.708,0.549l0.401,0.493l0.374,0.649l-0.015,0.339l-0.142,0.496l-0.082,0.862l-0.183,0.27     l-1.131,0.091l-0.169,0.17l0.078,0.777l-0.095,0.467l-0.328,0.694l0.571,0.831l0.532,0.675l0.561,0.067l0.185,0.295l0.246,0.832l0.49,1.127l0.332,0.563l-0.06,0.212l-0.943-0.022l-0.934,0.429l-1,0.331l-0.505,0.314l-0.694,0.513l-0.686,0.075l-0.613-0.392     l-1.103-0.897l-0.15-0.296l-0.008-0.396l0.072-0.354l-0.167-0.31l-0.281-0.394l-0.156-0.465l0.213-0.962l0.547-1.416l0.179-0.368l-0.435-0.958l-0.533-0.138l-0.304,0.001l0.452-1.09l-0.04-0.212l-0.26-0.111l-0.516-0.124l-0.302,0.058l-0.375,0.257z'},
	LR => {name => 'Liberia',
		d => 'M377.518,182.142l0.193-0.376l0.252-0.242l0.367-0.143l0.528-0.046l0.338,0.097l0.165,0.366l0.22,0.846l0.009,0.65l-0.044,0.283l0.277,0.323l0.404,0.322l0.321,0.026l0.756-0.922l0.143-0.086l0.337,0.097l0.339,0.224l-0.062,0.17l0.119,0.55     l-0.059,0.438l-0.501,0.865l0.05,0.183l0.194,0.183l0.369,0.097l0.592-0.032l1.264,1.334l0.131,0.282l-0.059,0.452l-0.247,0.849l-0.105,0.565l-0.041,0.919l-1.513-0.643l-1.221-0.619l-1.012-0.562l-0.403-0.423l-1.129-1.113l-1.111-0.76l-0.723-0.337l-0.901-0.535     l-0.66-0.548l0.061-0.103l0.285-0.256l0.63-0.724l1.184-1.151l0.259-0.502z'},
	CD => {name => 'Zaire',
		d => 'M429.505,210.684l0.484,0.336l0.177,0.013l0.443-0.271l0.327-0.581l1.495-0.532l0.054,0.424l0.042,0.664l0.147,0.211l0.57-0.328l0.554-0.399l0.931-0.811l0.364-0.229l1.025-0.938l0.086-0.706l-0.122-0.72l0.074-0.396l0.193-1.159     l0.343-0.751l0.47-0.836l0.41-0.454l0.809-0.599l0.525-0.229l0.459-0.427l0.139-0.523l0.169-0.708l0.115-0.61l0.254-1.342l0.196-2.021l0.156-0.764l0.094-0.551l0.349-0.821l0.558-0.837l0.398-1.203l0.031-0.156l-0.128-0.197l0.16-0.058l0.063-0.594l0.017-0.353     l-0.096-0.452l0.097-0.297l0.785-0.979l0.353-0.341l0.529-0.3l0.479-0.06l0.432,0.167l0.75,0.518l0.334,0.394l0.159,0.239l0.512,0.322l1.422,0.189l1.934,0.511l0.591,0.067l0.176-0.157l0.677-1.36l0.353-0.186l0.383,0.153l0.559,0.35l0.271-0.016l0.93-0.486     l0.93-0.373l0.593-0.102l0.862,0.207l0.399,0.026l0.256-0.058l0.13-0.241l0.082-0.551l0.4-0.13l1.15,0.361l0.687,0.264l0.287,0.167l0.319,0.026l0.962-0.344l0.496-0.145l0.143,0.239l0.795,0.772l0.348,0.493l0.525,0.477l0.366,0.195l0.352-0.016l0.258-0.242     l0.529-0.37l0.384,0.012l0.684,0.631l0.16-0.1l0.436-0.582l0.258-0.157l0.207,0.083l1.032,0.926l1.288,1.32l0.063,0.028l0.159,0.183l-0.018,0.424l-0.26,1.88l0.128,0.253l0.191,0.027l0.479,0.04l0.271,0.182l0.111,0.31l-0.191,0.453l-1.195,1.066l-1.241,0.996     l-0.255,0.284l-0.395,0.681l-0.217,1.02l-0.107,0.507l0.021,0.593l-0.025,0.734l0.057,0.748l-0.076,0.27l-0.188,0.298l-0.426,0.412l-0.301,0.171l-0.269,0.256l-0.122,0.425l-0.49,1.358l0.197,0.338l0.689,0.999l0.087,0.381l-0.04,0.438l0.014,0.636l0.237,0.634     l0.017,1.329l-0.064,0.762l0.425,1.439l-0.102,0.848l0.122,0.693l0.486,0.631l0.936,0.898l0.428,0.78l0.689,1.804l-0.563,0.068l-3.015,0.499l-0.347,0.214l-0.154,0.198l-0.797,1.276l-0.029,0.622l0.372,2.088l-0.377,1.175l-0.3,1.02l0.043,0.296l0.456,0.605     l0.837,0.843l0.445,0.279l0.515,0.012l0.448-0.455l0.362-0.186l0.136,0.183l0.032,0.791l0.028,1.427l-0.041,0.551l-0.371-0.012l-1.355-0.091l-0.348-0.21l-0.381-0.647l-0.561-0.731l-0.416-0.351l-0.477-0.252l-0.895-0.263l-0.38-0.28l-0.728-1.423l-0.212,0.354     l-0.522,0.682l-0.366,0.087l-0.325-0.111l-0.922-0.164l-0.925-0.249l-0.489-0.194l-0.58-1.014l-0.175,0.071l-1.146,0.289l-0.195-0.056l-0.172-0.352l-0.365-0.379l-0.678-0.096l-1.24-0.147l-0.991,0.146l-0.859,0.26l-0.61,0.004l-0.199-0.197l-0.007-0.254     l0.198-0.905l0.003-0.466l-0.306-0.62l-0.844-0.998l-0.117-0.211l-0.021-0.212l0.296-1.033l0.07-1.06l-0.109-0.607l-0.303-0.605l0.057-0.354l0.177-0.693l-0.052-0.183l-0.322-0.098l-1.231,0.093l-0.88,0.019l-0.212-0.168l0.055-0.48l-0.181-0.225l-2.016,0.082     l-0.112,0.001l-0.089,0.354l0.027,0.593l-0.286,0.892l-0.184,0.411l-0.993,0.006l-0.899-0.122l-1.021,0.246l-0.88,0.034l-0.292-0.168l-0.64-0.787l-0.597-1.07l-0.537-1.409l-0.059-0.579l-0.121-0.521l-0.082-0.127l-0.321-0.111l-0.385-0.012l-1.104-0.008     l-0.88,0.034l-0.624,0.003l-1.312-0.048l-0.945-0.052l-0.783,0.02l-0.432,0.03l-0.318,0.101l-0.896,0.062l-0.699,0.314l-0.56,0.06l-0.112-0.013l-0.322-0.922l0.012-0.053l0.74-0.3l-0.017-0.085l0.1-0.89l0.094-0.143l0.317-0.199l0.583-0.568z'},
	TZ => {name => 'Tanzania',
		d => 'M468.568,202.653l1.277-0.05h4.659l1.448-0.033l4.663,2.568l3.553,1.984l0.137,0.381l-0.116,0.552l0.07,0.239l2.427,1.752l1.067,0.807l-0.237,0.427l-0.419,1.329l-0.137,1.017l0.109,0.551l0.665,0.987l0.768,0.577l-0.024,0.282l-0.263,0.354     l-0.371,1.046l0.037,0.17l0.306,0.041l0.118,0.226l-0.172,0.692l-0.019,0.946l0.411,1.793l0.18,0.564l0.401,0.465l0.823,0.55l0.396,0.268l0.177,0.228l-1.157,0.836l-0.515,0.342l-1.218,0.402l-1.243,0.559l-0.448,0.031l-0.646-0.42l-0.276-0.083l-0.21,0.326     l-0.543,0.766l-0.396,0.144l-0.42-0.054l-0.964,0.006l-0.963,0.02l-0.512-0.294l-0.323-0.394l-0.229-0.083l-0.123,0.128l-0.643,0.356l-0.526,0.088l-1.019-0.149l-0.898-0.018l-0.196-0.559l-0.135-0.766l-0.053-0.584l-0.135-0.946l-0.448-0.841l-0.663-0.538     l-1.014-0.107l-0.223,0.016l-0.385-0.407l-0.732-0.349l-1.574-0.57l-1.269-0.6l-0.729-0.265l-0.263-0.21l-0.703-0.641l-0.689-1.804l-0.428-0.78l-0.936-0.898l-0.486-0.631l-0.122-0.693l0.102-0.848l-0.425-1.439l0.064-0.762l1.252-0.348l0.388-0.539l0.645-1.204     l0.687-0.853l0.346-0.271l0.044-0.212l-0.148-0.239l-0.273-0.125l-0.401-0.068l-0.211-0.211l0.158-0.976l0.304-0.016l0.396-0.158l0.142-0.17l0.104-0.481l-0.167-0.493l-0.364-0.888l-0.121-0.748z'},
	RW => {name => 'Rwanda',
		d => 'M464.786,206.235l-0.197-0.338l0.49-1.358l0.122-0.425l0.269-0.256l0.301-0.171l0.426-0.412l0.064,0.042l0.546,0.223l0.431-0.045l0.458-0.427l0.554-0.398l0.319-0.017l0.121,0.748l0.364,0.888l0.167,0.493l-0.104,0.481l-0.142,0.17     l-0.396,0.158l-0.304,0.016l-0.559,0.031l-0.508,0.159l-0.391,0.567l-0.158,0.085l-0.396,0.13l-0.789-0.32l-0.688-0.024z'},
	BI => {name => 'Burundi',
		d => 'M465.79,210.652l-0.017-1.329l-0.237-0.634l-0.014-0.636l0.04-0.438l-0.087-0.381l-0.689-0.999l0.688,0.024l0.789,0.32l0.396-0.13l0.158-0.085l0.391-0.567l0.508-0.159l0.559-0.031l-0.158,0.976l0.211,0.211l0.401,0.068l0.273,0.125     l0.148,0.239l-0.044,0.212l-0.346,0.271l-0.687,0.853l-0.645,1.204l-0.388,0.539l-1.252,0.348z'},
	AO => {name => 'Angola',
		d => 'M427.243,211.207l0.536-0.414l0.68-0.513l0.351-0.13l0.695,0.533l-0.583,0.568l-0.317,0.199l-0.094,0.143l-0.1,0.89l0.017,0.085l-0.74,0.3l0.143-0.625l-0.082-0.24l-0.505-0.796z M427.998,213.843l0.112,0.013l0.56-0.06l0.699-0.314     l0.896-0.062l0.318-0.101l0.432-0.03l0.783-0.02l0.945,0.052l1.312,0.048l0.624-0.003l0.88-0.034l1.104,0.008l0.385,0.012l0.321,0.111l0.082,0.127l0.121,0.521l0.059,0.579l0.537,1.409l0.597,1.07l0.64,0.787l0.292,0.168l0.88-0.034l1.021-0.246l0.899,0.122     l0.993-0.006l0.184-0.411l0.286-0.892l-0.027-0.593l0.089-0.354l0.112-0.001l2.016-0.082l0.181,0.225l-0.055,0.48l0.212,0.168l0.88-0.019l1.231-0.093l0.322,0.098l0.052,0.183l-0.177,0.693l-0.057,0.354l0.303,0.605l0.109,0.607l-0.07,1.06l-0.296,1.033     l0.021,0.212l0.117,0.211l0.844,0.998l0.306,0.62l-0.003,0.466l-0.198,0.905l0.007,0.254l0.199,0.197l0.61-0.004l0.859-0.26l0.991-0.146l1.24,0.147l-0.214,1.344l0.195,1.059l0.269,0.323l0.089,0.254l-0.132,0.368l-0.436,0.44l-0.124,0.594l-0.125,0.086     l-0.517-0.04l-3.408,0.091l-0.051,0.877l0.015,1.342l-0.024,3.249l0.017,0.848l0.023,0.594l0.099,0.438l0.308,0.394l0.471,0.436l1.354,1.391l0.611,0.632l-0.93,0.218l-1.96,0.379l-1.044,0.203l-0.717-0.08l-1.164,0.063l-0.408-0.083l-0.349-0.21l-2.024,0.026     l-0.697-0.024l-0.622-0.151l-0.401-0.322l-0.305-0.366l-0.408-0.096l-0.989-0.023l-2.59,0.016l-1.636-0.019l-0.631-0.011l-1.296-0.006l-2.201,0.013l-0.636-0.151l-0.463-0.309l-0.45-0.478l-0.294-0.083l-0.499,0.088l-0.591,0.286l-0.778,0.513l-0.758-0.462     l-0.352,0.144l-0.248,0.197l0.048-1.809l-0.017-0.805l-0.029-0.649l0.397-0.34l0.221-0.269l0.26-0.707l0.163-0.734l0.184-1.398l0.239-0.976l0.321-0.918l0.584-0.665l0.183-0.565l0.268-0.354l0.64-0.228l0.268-0.325l0.423-0.679l0.364-1.201l0.053-0.664     l-0.046-0.848l-0.191-0.959l-0.201-0.536l-0.492-0.705l-0.476-0.776l-0.268-0.775l0.139-0.495l0.476-0.382l0.158-0.156l0.107-0.424l-0.006-0.479l-0.199-0.579l-0.489-0.69l-0.441-0.733l-0.203-1.031l-0.181-0.423l-0.276-0.366l-0.666-0.974l-0.072-0.15z'},
	ZM => {name => 'Zambia',
		d => 'M452.198,239.34l-0.611-0.632l-1.354-1.391l-0.471-0.436l-0.308-0.394l-0.099-0.438l-0.023-0.594l-0.017-0.848l0.024-3.249l-0.015-1.342l0.051-0.877l3.408-0.091l0.517,0.04l0.125-0.086l0.124-0.594l0.436-0.44l0.132-0.368l-0.089-0.254     l-0.269-0.323l-0.195-1.059l0.214-1.344l0.678,0.096l0.365,0.379l0.172,0.352l0.195,0.056l1.146-0.289l0.175-0.071l0.58,1.014l0.489,0.194l0.925,0.249l0.922,0.164l0.325,0.111l0.366-0.087l0.522-0.682l0.212-0.354l0.728,1.423l0.38,0.28l0.895,0.263l0.477,0.252     l0.416,0.351l0.561,0.731l0.381,0.647l0.348,0.21l1.355,0.091l0.371,0.012l0.041-0.551l-0.028-1.427l-0.032-0.791l-0.136-0.183l-0.362,0.186l-0.448,0.455l-0.515-0.012l-0.445-0.279l-0.837-0.843l-0.456-0.605l-0.043-0.296l0.3-1.02l0.377-1.175l-0.372-2.088     l0.029-0.622l0.797-1.276l0.154-0.198l0.347-0.214l3.015-0.499l0.563-0.068l0.703,0.641l0.263,0.21l0.729,0.265l1.269,0.6l1.574,0.57l0.732,0.349l0.385,0.407l0.559,0.887l0.434,0.859l0.013,0.324l-0.183,0.27l-0.709,0.344l-0.011,0.127l0.04,0.594l-0.091,1.682     l0.08,0.353l0.216,0.168l0.511,0.266l0.072,0.197l-0.197,0.241l-0.472,0.258l-0.792,0.259l-0.146,0.34l-0.094,0.764l-0.3,0.807l0.2,0.479l0.261,0.408l0.394,0.125l-1.264,0.53l-1.696,0.575l-0.932,0.4l-2.165,0.578l-0.187,0.128l-0.009,0.495l0.152,0.465     l0.087,0.438l-0.505-0.096l-0.999,0.049l-0.794,0.259l-0.636,0.54l-0.312,0.539l-0.019,0.579l-0.168,0.199l-0.285,0.114l-0.999,0.062l-0.621,0.202l-0.306,0.341l-0.777,0.937l-0.562,0.738l-0.825,0.951l-0.354,0.045l-0.803-0.165l-0.421-0.309l-0.334,0.129     l-0.521,0.286l-0.404,0.017l-0.594-0.209l-0.264-0.097l-0.154-0.169l-0.163-0.027l-0.187-0.154l-0.456-0.393l-0.294-0.055l-1.089-0.093l-0.086-0.099l-0.165-0.056l-1.845,0.364z'},
	MW => {name => 'Malawi',
		d => 'M477.231,225.874l-0.224,1.184l-0.107,0.48l0.252,0.917l0.177,1.017l0.149,0.408l0.238,0.268l0.803,0.588l1.189,1.166l0.454,0.661l0.14,0.48l-0.155,2.346l-0.04,0.41l-0.214,0.213l-0.432,0.073l-0.322,0.017l-0.229,0.213l-0.076,0.622     l0.08,0.509l0.029,0.479l-0.096,0.283l-0.185-0.111l-0.562-0.463l-0.763-1.112l-0.484-0.548l-0.234-0.423l0.036-0.212l0.499-0.61l0.116-0.227l0.025-0.693l-0.1-0.96l-0.22-0.479l-0.261-0.056l-0.674,0.061l-0.702,0.132l-0.27-0.211l-0.343-0.407l-0.382-0.549     l-0.195-0.041l-0.394-0.125l-0.261-0.408l-0.2-0.479l0.3-0.807l0.094-0.764l0.146-0.34l0.792-0.259l0.472-0.258l0.197-0.241l-0.072-0.197l-0.511-0.266l-0.216-0.168l-0.08-0.353l0.091-1.682l-0.04-0.594l0.011-0.127l0.709-0.344l0.183-0.27l-0.013-0.324     l-0.434-0.859l-0.559-0.887l0.223-0.016l1.014,0.107l0.663,0.538l0.448,0.841l0.135,0.946l0.053,0.584l0.135,0.766l0.196,0.559z'},
	BO => {name => 'Bolivia',
		d => 'M245.934,224.314l0.939,0.136l1.122,0.304l0.355-0.03l0.946-0.824l0.336,0.026l0.48,0.025l0.415-0.243l1.471-1.109l0.874-0.485l0.36-0.158l0.934-0.076l1.283,0.021l0.045,0.748l-0.079,0.621l-0.064,0.622l0.036,0.818l0.141,0.635     l0.335,0.591l0.813,0.928l1.1,0.939l0.316,0.097l0.787,0.023l0.355-0.03l0.676,0.25l0.688,0.307l0.75,0.603l0.3,0.098l0.882,0.037l0.096,0.014l0.385,0.774l0.398,0.308l0.22,0.084l1.148-0.077l0.636,0.123l0.537,0.166l0.403,0.237l0.085,0.169l-0.038,0.565     l0.203,1.029l0.03,0.706l0.138,2.032l0.249,0.944l0.153,0.112l0.967,0.036l0.5,0.012l1.615,0.019l0.693,0.024l0.042,0.296l-0.261,0.835l0.067,0.563l0.436,0.407l0.73,0.362l0.316,0.479l0.307,0.774l0.022,0.494l-0.185,1.173l-0.238,0.834l-0.38,0.765l-0.421,0.666     l-0.089-0.084l-1.952-0.991l-0.352-0.054l-0.928,0.02l-0.843-0.01l-0.126,0.128l-1.076,0.204l-1.104,0.162l-0.784,0.202l-0.33,0.044l-0.332,0.383l-0.698,1.105l-0.278,0.341l-0.133,0.509l0.016,0.635l-0.385,1.188l-0.395,1.104l-0.149,0.325l-0.592-0.109     l-1.33-0.077l-0.686,0.004l-1.034,1.784l-0.416-1.084l-0.341-0.309l-0.37-0.195l-0.531-0.067l-0.527,0.045l-0.901,0.034l-0.615-0.194l-0.193-0.169l-0.322-0.181l-0.292,0.27l-2.026,2.087l-1.047,0.006l-0.272-0.182l-0.397-2.144l-0.278-0.973l-0.212-0.563     l-0.769-1.11l-0.249-0.676l0.04-0.354l0.437-1.555l-0.017-0.282l-0.761-0.744l-0.25-0.521l-0.193-1.213l-0.304-0.647l-0.555-0.745l-0.152-0.253l-0.018-0.142l-0.132-0.295l-0.049-0.48l0.12-0.227l0.723-0.61l0.285-0.439l-0.015-0.522l-0.604-1.168l-0.022-0.48     l0.159-0.34l0.21-0.368l-0.347-0.845l0.102-0.452l0.532-0.582l0.221-0.34l0.156-0.34l-0.236-0.902l-0.057-0.522l0.143-0.848l0.15-0.523l0.437-0.736l-0.08-0.24l-0.922-1.646l-1.109-1.843z'},
	MZ => {name => 'Mozambique',
		d => 'M473.575,260.04l-1.331,0.011l-0.192,0.058l-0.068-0.382l-0.261-0.889l0.071-0.495l-0.075-0.296l-0.095-0.324l0.03-0.806l0.057-1.301l-0.072-0.763l-0.147-0.678l-0.33-0.944l-0.441-0.689l-0.181-0.946l-0.295-1.199l-0.159-0.183l0.448-0.384     l0.396-0.412l1.68-1.706l0.114-0.227l-0.09-0.367l0.075-0.834l0.229-0.481l0.736-0.683l0.205-0.341l0.168-0.41l-0.594-0.845l-0.118-0.805l-0.113-0.494l0.128-0.283l0.448-0.596l0.201-0.411l-0.132-0.805l-0.086-1.144l-0.031-0.791l-0.178-0.818l-0.441-0.379     l-0.515-0.224l-1.167-0.347l-1.042-0.445l-0.658-0.223l-1.438-0.006l-0.137-0.14l-0.025-0.495l-0.011-0.212l-0.087-0.438l-0.152-0.465l0.009-0.495l0.187-0.128l2.165-0.578l0.932-0.4l1.696-0.575l1.264-0.53l0.195,0.041l0.382,0.549l0.343,0.407l0.27,0.211     l0.702-0.132l0.674-0.061l0.261,0.056l0.22,0.479l0.1,0.96l-0.025,0.693l-0.116,0.227l-0.499,0.61l-0.036,0.212l0.234,0.423l0.484,0.548l0.763,1.112l0.562,0.463l0.185,0.111l0.096-0.283l-0.029-0.479l-0.08-0.509l0.076-0.622l0.229-0.213l0.322-0.017l0.432-0.073     l0.214-0.213l0.04-0.41l0.155-2.346l-0.14-0.48l-0.454-0.661l-1.189-1.166l-0.803-0.588l-0.238-0.268l-0.149-0.408l-0.177-1.017l-0.252-0.917l0.107-0.48l0.224-1.184l0.898,0.018l1.019,0.149l0.526-0.088l0.643-0.356l0.123-0.128l0.229,0.083l0.323,0.394     l0.512,0.294l0.963-0.02l0.964-0.006l0.42,0.054l0.396-0.144l0.543-0.766l0.21-0.326l0.276,0.083l0.646,0.42l0.448-0.031l1.243-0.559l1.218-0.402l0.515-0.342l1.157-0.836l0.128,0.167l0.212,0.479l-0.185,0.579l-0.302,0.453l-0.198,0.255l0.181,0.451l0.129,0.72     l-0.012,0.466l0.182,1.115l-0.101,0.58l-0.258,0.325l0.374,0.705l0.154,0.494l-0.006,1.115l-0.004,0.819l0.043,0.184l0.185,0.127l0.327,0.084l0.015,0.269l-0.165,0.494l-0.563,0.58l0.184,0.381l-0.08,0.283l-0.418,0.565l-0.802,0.906l-0.512,0.622l-0.72,0.651     l-1.36,0.751l-1.48,0.653l-0.73,0.228l-1.308,0.582l-0.852,0.637l-1.286,1.443l-0.886,0.85l-1.193,0.878l-1.181,0.836l-0.268,0.128l-0.035,0.96l-0.083,0.495l0.058,0.127l0.719,0.535l0.188,0.381l-0.166,0.452l-0.085,0.184l0.461,1.511l0.071,0.564l0.06,0.155     l0.246,0.014l0.171-0.128l0.141-0.085l0.043,0.607l-0.234,2.218l-0.284,0.82l0.325,0.196l0.152,0.057l-0.025,0.325l-0.157,0.311l-0.516,0.566l-0.699,0.538l-0.664,0.34l-1.266,0.412l-0.796,0.312l-0.688,0.228l-0.895,0.524l-0.652,0.665l-0.337,0.51l0.292,0.338     l0.589,0.338l0.045,0.325l-0.149,1.022z'},
	MG => {name => 'Madagascar',
		d => 'M499.85,236.166l0.544-0.071l0.622-0.369l0.18,0.028l0.346,0.098l0.269-0.085l0.396-0.368l0.911-0.143l0.311,0.281l0.305-0.028l0.101-0.185l-0.171-0.366l0.771-0.539l0.423-0.198l0.322,0.226l0.389-0.213l-0.308-0.494l0.207-0.282     l0.505-0.425l0.229,0.296l0.229,0.056l0.558-0.594l-0.158-0.197l-0.253-0.409l0.094-0.297l0.243,0.014l0.27-0.071l0.172-0.34l-0.297-0.875l0.06-0.339l0.255-0.043l0.117,0.07l0.253,0.438l0.28,0.099l0.2-0.41l0.692-0.524l0.235-0.367l0.134-0.452l0.168-0.692     l-0.133-0.354l0.003-0.226l0.537-0.468l0.356,0.324l0.455,0.648l0.612,0.281l0.141,0.198l0.213,0.847l0.294,1.821l0.093,0.663l0.231,0.791l0.391,0.733l0.163,0.466l-0.038,0.367l-0.069,0.155l-0.058,0.099l-0.537,0.807l-0.22-0.127l-0.189-0.366l-0.555-0.748     l-0.297,0.143l-0.05,0.424l0.193,0.875l0.396,0.521l0.079,0.396l-0.307,0.636l-0.746,1.005l-0.045,0.452l0.041,0.89l-0.18,0.946l-0.709,2.12l-0.825,2.572l-1.254,3.788l-1.324,4.48l-0.518,1.568l-0.188,0.255l-0.508,0.637l-0.2,0.113l-1.369,0.102l-0.999,0.327     l-0.474,0.468l-0.813,0.086l-0.363-0.465l-0.196-0.142l-0.546-0.182l-0.37,0.071l-0.269-0.057l-0.863-0.718l-0.104-0.24l-0.02-0.565l-0.104-0.239l-0.46-0.366l-0.124-0.282l0.001-0.721l0.345-1.088l-0.094-0.325l-0.287-0.479l-0.62-0.931l-0.189-0.494l0.075-0.664     l0.391-1.37l0.228-0.213l0.474-0.185l0.768-1.371l0.686-1.174l0.104-0.325l0.151-1.103l-0.11-0.353l-0.278-0.226l-0.354-0.366l0.066-0.184l0.252-0.509l-0.521-0.861l-0.117-0.677l-0.069-0.494l-0.231-0.721l0.024-0.112l0.517-0.693l0.362-0.594l0.163-0.438     l0.007-1.073l0.484-0.016z'},
	ZW => {name => 'Zimbabwe',
		d => 'M468.138,234.908l0.011,0.212l0.025,0.495l0.137,0.14l1.438,0.006l0.658,0.223l1.042,0.445l1.167,0.347l0.515,0.224l0.441,0.379l0.178,0.818l0.031,0.791l0.086,1.144l0.132,0.805l-0.201,0.411l-0.448,0.596l-0.128,0.283l0.113,0.494     l0.118,0.805l0.594,0.845l-0.168,0.41l-0.205,0.341l-0.736,0.683l-0.229,0.481l-0.075,0.834l0.09,0.367l-0.114,0.227l-1.68,1.706l-0.396,0.412l-0.448,0.384l-0.342-0.225l-0.547-0.124l-0.442-0.025l-0.529,0.145l-0.31,0.016l-0.99-0.403l-0.597-0.139l-0.72-0.023     l-0.067-0.042l-0.186-0.098l-0.306-0.451l-0.479-0.35l-0.549-0.167l-0.938-0.136l-0.352-0.153l-0.524-0.873l-0.163-0.564l0.032-0.565l-0.127-0.239l-0.78,0.019l-0.201-0.098l-0.109-0.211l0.051-0.537l-0.106-0.169l-0.552-0.266l-0.533-0.223l-0.57-0.321     l-0.563-0.491l-0.377-0.662l-0.246-0.96l-0.469-0.604l-0.43-0.478l-0.267-0.451l0.103-0.227l0.594,0.209l0.404-0.017l0.521-0.286l0.334-0.129l0.421,0.309l0.803,0.165l0.354-0.045l0.825-0.951l0.562-0.738l0.777-0.937l0.306-0.341l0.621-0.202l0.999-0.062     l0.285-0.114l0.168-0.199l0.019-0.579l0.312-0.539l0.636-0.54l0.794-0.259l0.999-0.049l0.505,0.096z'},
	NA => {name => 'Namibia',
		d => 'M444.673,255.519l-0.006,3.434l0.031,1.894l0.025,2.246l-0.057,0.205l-0.454,0.318l-0.545,0.302l-0.581,0.498l-0.427,0.034l-0.581-0.166l-0.745-0.042l-0.892,0.048l-0.517-0.039l-0.296-0.212l-0.055-0.528l-0.042-0.345l-0.193-0.222     l-0.637-0.348l-0.329-0.127l-0.335,0.116l-0.109,0.217l-0.317,0.416l-0.584,0.27l-0.152,0.068l-0.458-0.491l-1.041-1.001l-0.458-0.606l-0.359-1.03l-0.345-0.72l-0.136-0.493l0.12-0.269l0.053-0.34l-0.458-0.719l-0.231-0.861l0.148-0.861l-0.002-0.48l-0.537-1.326     l-0.496-2.244l0.772-0.02l0.04-0.678l-0.077-0.749l-0.456-0.006l0.016-0.06l-0.099-0.522l-0.26-0.508l-1.018-1.283l-0.343-0.55l-1.102-2.158l-0.841-1.623l-0.9-1.509l-0.988-1.269l-0.511-1.044l-0.122-0.396l-0.045-0.551l0.015-0.578l0.248-0.197l0.352-0.144     l0.758,0.462l0.778-0.513l0.591-0.286l0.499-0.088l0.294,0.083l0.45,0.478l0.463,0.309l0.636,0.151l2.201-0.013l1.296,0.006l0.631,0.011l1.636,0.019l2.59-0.016l0.989,0.023l0.408,0.096l0.305,0.366l0.401,0.322l0.622,0.151l0.697,0.024l2.024-0.026l0.349,0.21     l0.408,0.083l1.164-0.063l0.717,0.08l1.044-0.203l1.96-0.379l0.93-0.218l1.845-0.364l0.165,0.056l0.086,0.099l1.089,0.093l0.294,0.055l0.456,0.393l-0.811,0.315l-0.891,0.02l-0.284,0.143l-0.993,0.938l-0.209,0.029l-0.62-0.773l-1.048,0.134l-2.962,0.47     l-1.183,0.021l0.005,1.215l-0.007,1.286l-0.025,0.876l-0.043,1.201l0.002,3.561l-0.586,0.046l-1.564,0.052l-0.146,0.028l-0.106,2.657l-0.009,1.201l0.013,1.624l0.007,0.806z'},
	CL => {name => 'Chile',
		d => 'M248.453,316.576l-0.306,0.101l-0.892-0.087l-0.538-0.293l-0.236-0.015l-0.311,0.163l-0.418,0.398l-0.498,0.192l-1.156,0.091l-0.349,0.09l-0.358,0.207l-0.267,0.621l-0.114,0.341l0.06,0.532l-0.163,0.622l-0.104,0.148l-0.453,0.031     l-0.534,0.104l-0.956-0.413l0.667-0.639l0.326-0.444l0.582-0.4l0.025-0.147l-0.372-0.177l-0.273-0.117l-1.353,0.534l-1.01-0.013l-0.545,0.163l-0.202-0.339l0.128-0.192l0.959-0.268l0.266,0.028l0.792-0.208l0.441-0.118l-0.605-0.162l-0.582,0.002l-0.77,0.001     l-0.014-0.413l0.265-0.31l-0.007-0.191l-0.446-0.073l-0.356-0.44l-0.66,0.384l-0.669-0.175l0.292-0.53l0.041-0.177l-0.378,0.045l-0.361,0.147l-0.416-0.396l-0.215-0.117l0.413-0.279l0.114-0.177l-0.091-0.278l-0.053-0.073l-0.351,0.03l-0.773-0.424l-0.135-0.059     l0.844-0.192l0.253-0.161l0.1-0.294l0.396-0.366l0.049-0.234l-0.641,0.06l-0.257,0.104l-0.312-0.073l-0.256-0.672l0.573-0.395l-0.565-0.378l-0.12-0.421l0.757-0.452l-0.14-0.421l-0.686,0.422l-0.091-1.523l0.399-0.596l-0.185-0.825l0.013-0.218l0.593,0.014     l0.41,0.245l0.711,0.071l0.171-0.246l0.002-0.159l-0.896-0.447l-0.867,0.146l-0.317-0.173l-0.536,0.059l-0.017-0.231l0.339-0.333l0.025-0.246l-0.067-0.087l0.186-0.202l0.536,0.014l0.229-0.377l0.01-0.216l-0.722-0.389l-0.354-0.129l-0.886,0.045l-0.332-0.101     l-0.024-0.49l-0.939,0.16l-0.115-0.101l0.122-0.145l1.032-0.521l0.251-0.116l0.4-0.404l0.266-0.389l0.833-0.06l0.268,0.201l0.059,0.346l-0.648,0.202l-0.323,0.274l0.11,0.505l0.117,0.058l0.191-0.102l0.268-0.39l0.183-0.087l0.242,0.101l-0.037,0.317l0.057,0.504     l0.886-0.996l0.161-0.678l0.056-0.647l0.237-0.375l0.079-0.058l0.631-0.217l-0.201-0.071l-0.438-0.143l-0.056-0.158l0.101-0.273l0.246-0.072l0.571-0.245l0.599-0.431l0.271-0.459l-0.061-0.229l-0.394-0.157l-0.662-0.399l-0.053-0.372l0.139-0.243l0.105-0.458     l-0.06-0.828l0.366-0.33l0.676-0.272l-0.431-0.585l-0.053-0.784l0.133-0.158l0.554-0.157l0.054-0.314l-0.116-0.285l-0.317-0.085l-0.272-0.198l0.233-0.329l0.087-0.313l-0.401-0.185l-0.274-0.014l-0.161,0.101l-0.476,0.414l-0.548,0.058l-0.087,0.001l-0.289-0.199     l-0.16-0.484l-0.399-0.726l-0.133-0.697l0.188-0.911l0.137-0.413l0.722-0.739l0.535-0.767l-0.006-0.326l-0.544-1.757l0.001-0.608l0.088-0.567l-0.076-0.438l-0.528-0.891l-0.04-0.298l0.236-0.198l0.499,0.098l0.182-0.085l0.2-0.142l0.097-0.143l0.41-1.288     l0.252-0.481l0.304-0.935l0.18-0.65l0.664-0.808l0.363-0.722l0.201-0.636l0.252-0.946l0.311-0.691l0.187-0.128l0.273-0.382l0.013-0.296l-0.312-0.847l0.082-0.184l0.455-0.452l0.206-0.339l0.028-0.24l-0.093-0.226l-0.166-0.805l-0.292-2.088l-0.098-0.86     l0.031-0.565l0.412-0.565l0.37-0.537l0.207-0.564l0.007-0.734l-0.339-0.521l-0.098-0.409l0.295-0.96l0.218-0.941l0.127-0.556l0.461-0.594l0.171-0.918l0.243-0.975l0.126-0.805l0.082-0.565l-0.063-1.087l0.422-0.664l0.211-0.494l-0.221-0.932l-0.048-0.833     l0.148-0.24l-0.022-0.917l0.229-0.607l-0.124-0.297l-0.365-0.084l0.06-0.324l-0.046-0.396l0.223-0.198l0.402-0.198l0.137-0.424l-0.008-0.819l0.093-0.593l0.182-0.918l-0.004-2.344l-0.172-2.074l-0.042-1.539l-0.194-0.974l-0.15-0.387l0.852-0.275l0.259-0.298     l0.228-0.933l0.15-0.199l0.586-0.187l0.152,0.253l0.555,0.745l0.304,0.647l0.193,1.213l0.25,0.521l0.761,0.744l0.017,0.282l-0.437,1.555l-0.04,0.354l0.249,0.676l0.769,1.11l0.212,0.563l0.278,0.973l0.397,2.144l0.272,0.182l1.047-0.006l0.107,0.056l0.212,0.14     l0.161,0.154l-0.093,0.636l-0.541,1.457l-0.36,0.256l-1.346,0.53l-0.819,0.372l-0.204,0.312l0.25,0.817l-0.421,0.722l-0.007,0.579l0.113,0.437l0.34,0.449l0.03,0.226l-0.273,0.369l-0.161,0.382l0.114,0.507l0.53,0.477l0.011,0.227l-0.152,0.311l-0.333,0.017     l-0.791,0.089l-0.329,0.835l-0.464,0.835l-0.608,0.694l-0.282,0.439l-0.823,1.839l0.167,1.466l0.054,0.762l-0.124,0.185l-0.492,0.271l-0.292,0.34l-0.388,1.201l-0.156,0.961l0.285,0.633l0.408,1.154l0.784,2.816l0.055,0.69l-0.075,0.41l-1.083,1.854l-0.319,0.595     l0.088,0.409l0.189,1.06l-0.078,0.325l-1.334,1.11l-0.231,0.312l-0.142,1.075l0.014,1.16l0.249,1.103l0.437,0.932l-0.202,0.143l-0.951,0.529l-0.126,0.17l-0.053,0.312l-0.511,2.427l-0.316,0.541l-0.1,0.37l0.123,1.835l0.231,0.867l0.012,0.427l-0.596,0.317     l-0.172,0.172l-0.106,0.271l0.094,1.226l0.125,0.128l0.555,0.111l0.088,0.655l-0.191,1.458l0.252,0.585l0.26,0.185l0.789,0.11l0.302,0.17l-0.007,0.186l-0.245,0.202l-0.322,0.13l-0.726,0.033l-0.757,0.146l0.176,0.171l0.586,0.298l0.552,0.385l0.017,0.216     l-0.767,0.794l-0.059,1.094l0.158,1.035l-0.216,0.896l-0.212,0.434l-0.226,0.262l-0.598,0.161l-0.28,0.219l-0.249,0.781l0.446,0.648l-0.069,0.188l-0.296,1.218l-0.307,0.263l-1.729,1.01l-0.271,0.292l-0.037,0.45l0.28,1.309l0.508,1.123l0.218,0.043l0.961-0.283     l0.654-0.121l0.187,0.248l0.231,2.285l0.778,0.568l0.669,0.041l1.41-0.052l2.827,0.132l0.841,0.217l1.385,0.36l0.286,0.039z M236.642,296.773l-0.394-0.113l-0.43-0.028l-0.21-0.171l-0.133-0.229l0.21-0.457l0.15-0.657l-0.087-0.514l0.011-0.414l0.364-0.728     l0.817-0.116l0.36,0.327l0.044,0.328l-0.688,0.443l-0.146,0.229l0.493,0.771l-0.194,1.058l-0.167,0.271z M238.177,317.937l-0.445-0.177l0.083-0.842l-0.849,0.075l-0.073-0.368l0.218-0.354l0.823,0.102l0.508-0.207l0.205,0.103l0.054,0.812l-0.267,0.34     l-0.257,0.518z M247.801,322.062l-1.033,0.102l-0.467-0.118l-0.55-0.237l-0.42,0.001l-0.481,0.104l-0.935,0.226l-0.496,0.03l0.125-0.343l0.202-0.312l-0.104-0.312l0.906-0.15l1.434,0.058l0.433,0.323l0.706-0.007l-0.622-0.689l-0.307-0.163l-0.56-0.117     l-0.178-0.089l-0.188,0.03l-0.338-0.341l-0.229-0.4l1.611-0.581l-0.044-0.296l-0.165-0.147l-1.819,0.285l-0.292-0.222l0.263-0.474l0.146-0.163l1.074-0.52l0.868-0.637l0.414,0.28l1.153,0.062l-0.008,1.144l-0.098,3.675z'},
	BW => {name => 'Botswana',
		d => 'M456.133,239.67l0.187,0.154l0.163,0.027l0.154,0.169l0.264,0.097l-0.103,0.227l0.267,0.451l0.43,0.478l0.469,0.604l0.246,0.96l0.377,0.662l0.563,0.491l0.57,0.321l0.533,0.223l0.552,0.266l0.106,0.169l-0.051,0.537l0.109,0.211l0.201,0.098     l0.78-0.019l0.127,0.239l-0.032,0.565l0.163,0.564l0.524,0.873l0.352,0.153l0.938,0.136l0.549,0.167l0.479,0.35l0.306,0.451l0.186,0.098l-0.317,0.411l-0.388,0.327l-0.507,0.243l-0.747,0.075l-0.304,0.115l-0.7,0.823l-0.586,0.583l-0.362,0.229l-0.747,0.357     l-0.388,0.355l-0.107,0.636l-0.222,0.666l-0.247,0.241l-0.634,0.357l-0.98,0.33l-0.249,0.214l-0.217,0.708l-0.345,0.963l-0.288,0.354l-0.237,0.129l-0.584,0.116l-0.43-0.026l-0.473,0.06l-0.511-0.011l-0.819-0.193l-0.744-0.32l-0.979-0.645l-0.545-0.039     l-0.333,0.186l-0.084,0.24l-0.585,1.134l-0.382,0.469l-0.651,0.625l-0.632,0.428l-0.8,0.372l-0.823,0.033l-0.854,0.047l-0.368-0.097l-0.11-0.183l0.003-0.48l0.243-0.609l0.166-0.538l-0.21-0.762l-0.547-0.943l-0.716-0.787l-0.528-0.067l-0.007-0.806l-0.013-1.624     l0.009-1.201l0.106-2.657l0.146-0.028l1.564-0.052l0.586-0.046l-0.002-3.561l0.043-1.201l0.025-0.876l0.007-1.286l-0.005-1.215l1.183-0.021l2.962-0.47l1.048-0.134l0.62,0.773l0.209-0.029l0.993-0.938l0.284-0.143l0.891-0.02l0.811-0.315z'},
	PY => {name => 'Paraguay',
		d => 'M279.288,257.295l0.02,0.239l-0.544,1.57l-0.375,0.468l-1.007,0.74l-0.301,0.27l-0.352,0.51l-0.609-0.363l-0.35-0.097l-0.235,0.029l-0.387,0.172l-0.745,0.131l-0.71,0.005l-0.564-0.096l-0.992-0.333l-0.607-0.025l-1.187,0.332l-0.19-0.056     l0.064-0.212l0.425-0.426l0.486-0.398l0.11-0.198l-0.21-0.619l0.048-0.227l0.625-0.851l0.617-1.203l0.018-0.268l-0.939-0.503l-0.65-0.18l-1.448-0.697l-1.632-1.106l-0.671-0.307l-1.173-0.204l-0.498-0.237l-0.835-0.588l-0.576-0.562l-1.271-1.376l-0.782-0.913     l-0.225-0.337l-0.19-0.056l0.149-0.325l0.395-1.104l0.385-1.188l-0.016-0.635l0.133-0.509l0.278-0.341l0.698-1.105l0.332-0.383l0.33-0.044l0.784-0.202l1.104-0.162l1.076-0.204l0.126-0.128l0.843,0.01l0.928-0.02l0.352,0.054l1.952,0.991l0.089,0.084l0.253,0.408     l0.084,0.663l0.521,0.872l0.104,0.959l-0.132,0.862l-0.086,0.721l-0.006,0.72l0.372,0.04l0.818,0.15l0.925,0.221l0.346-0.03l0.709-0.413l0.115-0.001l0.724,0.278l0.843,0.404l0.121,0.437l0.487,2.524l0.254,0.563l0.224,0.055l1.29-0.445l0.234,0.112l0.491,0.336     l0.019,0.141l-0.321,0.75l-0.298,0.835l-0.222,0.819l-0.027,0.777l0.063,0.423z'},
	ZA => {name => 'South Africa',
		d => 'M444.673,255.519l0.528,0.067l0.716,0.787l0.547,0.943l0.21,0.762l-0.166,0.538l-0.243,0.609l-0.003,0.48l0.11,0.183l0.368,0.097l0.854-0.047l0.823-0.033l0.8-0.372l0.632-0.428l0.651-0.625l0.382-0.469l0.585-1.134l0.084-0.24l0.333-0.186     l0.545,0.039l0.979,0.645l0.744,0.32l0.819,0.193l0.511,0.011l0.473-0.06l0.43,0.026l0.584-0.116l0.237-0.129l0.288-0.354l0.345-0.963l0.217-0.708l0.249-0.214l0.98-0.33l0.634-0.357l0.247-0.241l0.222-0.666l0.107-0.636l0.388-0.355l0.747-0.357l0.362-0.229     l0.586-0.583l0.7-0.823l0.304-0.115l0.747-0.075l0.507-0.243l0.388-0.327l0.317-0.411l0.067,0.042l0.72,0.023l0.597,0.139l0.99,0.403l0.31-0.016l0.529-0.145l0.442,0.025l0.547,0.124l0.342,0.225l0.159,0.183l0.295,1.199l0.181,0.946l0.441,0.689l0.33,0.944     l0.147,0.678l0.072,0.763l-0.057,1.301l-0.03,0.806l0.095,0.324l-1.449-0.585l-0.279,0.199l-0.657,0.979l-0.28,0.567l-0.005,0.325l0.39,0.676l0.307,0.465l0.458,0.322l0.671,0.109l0.595-0.004l0.076-0.594l0.064-0.198l0.312-0.186l0.131-0.015l0.192-0.058     l1.331-0.011l-0.182,1.195l-0.352,0.849l-0.182,0.184l-0.404,0.1l-0.093,0.24l0.199,0.536l-0.104,0.467l-0.248,0.354l-0.569,0.453l-0.923,0.581l-0.591,0.75l-1.383,1.98l-0.631,0.834l-1.242,1.373l-1.193,1.062l-0.829,0.863l-1.434,1.034l-1.379,1.091     l-0.552,0.382l-0.989,0.638l-0.676,0.298l-0.782,0.101l-0.98-0.012l-0.549,0.071l-0.132,0.354l0.013,0.127l-0.109,0.085l-0.449-0.098l-0.553-0.126l-0.303,0.015l-0.25,0.198l-0.272,0.312l-0.226,0.113l-0.36-0.056l-0.768-0.408l-0.759-0.168l-0.542-0.013     l-0.31,0.113l-0.38,0.27l-0.482-0.099l-0.645-0.21l-0.295,0.1l-0.638,0.043l-0.589,0.214l-0.729,0.538l-0.72,0.086l-0.44-0.013l-0.667-0.084l-0.738,0.072l-0.575,0.199l-0.827,0.82l-1.251-0.576l-0.092-0.509l-0.218-0.183l-0.479-0.056l-0.28,0.085l-0.257-0.479     l-0.343-0.056l-0.149,0.255l-0.035,0.197l-0.312-0.112l-0.119-0.226l0.267-0.495l0.103-0.424l-0.857-1.354l-0.323-0.282l-0.134-0.226l0.173-0.17l0.636-0.044l0.172-0.424l0.06-0.819l-0.163-0.663l-0.186-0.522l-0.61-1.143l-0.75-1.029l-0.472-0.903l-0.612-1.383     l-0.646-1.467l-0.573-0.818l-0.436-0.467l0.152-0.068l0.584-0.27l0.317-0.416l0.109-0.217l0.335-0.116l0.329,0.127l0.637,0.348l0.193,0.222l0.042,0.345l0.055,0.528l0.296,0.212l0.517,0.039l0.892-0.048l0.745,0.042l0.581,0.166l0.427-0.034l0.581-0.498     l0.545-0.302l0.454-0.318l0.057-0.205l-0.025-2.246l-0.031-1.894l0.006-3.434z M462.462,268.501l0.412-0.044l0.194-0.553l0.633-0.343l1.035-0.303l0.263-0.199l0.582-1.007l0.268-0.326l0.143-0.241l-0.104-0.226l-0.967-0.744l-0.33-0.337l-0.422-0.266l-0.308,0.086     l-0.995,0.359l-0.65,0.329l-0.513,0.567l-0.275,0.44l-0.691,0.611l0.12,0.409l0.582,0.858l0.285,0.366l0.739,0.561z M432.955,250.661l0.456,0.006l0.077,0.749l-0.04,0.678l-0.772,0.02l-0.078-0.354l-0.028-0.396l0.285-0.297l0.101-0.406z'},
	SZ => {name => 'Swaziland',
		d => 'M471.719,258.047l0.075,0.296l-0.071,0.495l0.261,0.889l0.068,0.382l-0.131,0.015l-0.312,0.186l-0.064,0.198l-0.076,0.594l-0.595,0.004l-0.671-0.109l-0.458-0.322l-0.307-0.465l-0.39-0.676l0.005-0.325l0.28-0.567l0.657-0.979l0.279-0.199     l1.449,0.585z'},
	LS => {name => 'Lesotho',
		d => 'M462.462,268.501l-0.739-0.561l-0.285-0.366l-0.582-0.858l-0.12-0.409l0.691-0.611l0.275-0.44l0.513-0.567l0.65-0.329l0.995-0.359l0.308-0.086l0.422,0.266l0.33,0.337l0.967,0.744l0.104,0.226l-0.143,0.241l-0.268,0.326l-0.582,1.007     l-0.263,0.199l-1.035,0.303l-0.633,0.343l-0.194,0.553l-0.412,0.044z'},
	NZ => {name => 'New Zealand',
		d => 'M790.15,283.022l0.738,0.197l0.008-0.227l-0.242-0.524l0.052-0.284l0.233,0.014l0.389,0.17l0.37,0.751l0.277,0.964l0.48,0.17l1.753,0.691l0.506,0.113l0.37-0.072l0.699-0.483l0.885-0.343l0.4,0.027l0.329,0.17l0.066,0.454l-0.022,0.198     l-0.402,1.236l-0.283,0.072l-0.761,0.058l-0.035,0.683l-0.124,0.156l-0.424,0.029l-0.746,0.016l-0.432,0.2l-0.271,0.284l0.041,0.384l0.254,0.525l-0.002,0.213l-0.151,0.199l-0.646,0.515l-0.898,1.129l-0.847,1.058l-0.756,0.587l-0.68,0.316l-0.337-0.171     l-0.47-0.313l-0.237-0.328l0.056-0.314l0.288-0.386l0.307-0.671l0.398-0.5l-0.031-0.343l-0.271-0.128l-0.761-0.582l-0.421-0.185l-0.593-0.184l-0.98-0.452l-0.306-0.256l-0.11-0.17l0.081-0.128l0.419-0.157l1.389-0.685l0.209-0.512l-0.078-0.695l0.087-0.312     l0.396-0.441l0.032-0.383l-0.482-0.837l0.081-0.567l-0.156-0.311l-0.479-0.655l-0.574-0.678l0.102-0.164l-0.145-0.304l-0.291-0.351l-0.336-0.188l-0.29-0.163l0.117,0.233l0.497,0.515l0.049,0.141h-0.169l-0.211-0.281l-0.525-0.631l-0.622-0.771l-0.518-0.561     l0.001-0.117l-0.268-0.257l0.04-0.141l0.013-0.14l-0.048-0.188l-0.197-0.396l-0.379-0.42l-0.347-0.257l0.163-0.046l0.205,0.093l0.358-0.047l0.131-0.093l0.084,0.28l-0.149,0.187l0.186,0.303l0.177,0.21l0.167,0.116l0.228,0.164l0.041-0.141l0.269,0.023     l0.519,0.257l0.42,0.117l0.274,0.07l0.128,0.257l-0.011,0.141l0.185,0.023l0.146-0.188l0.185,0.023l-0.022,0.164l0.227,0.351l0.249,0.187l0.233,0.28l-0.18,0.023l-0.076,0.164l0.093,0.163l-0.242-0.023l-0.175-0.047l0.143,0.117l0.251,0.188l0.23,0.233l0.352,0.28     l0.063,0.234l0.019,0.21l-0.261-0.047l0.096,0.164l0.239,0.351l0.256,0.188l-0.292,0.023h-0.226l-0.205-0.047l-0.006,0.141l0.306,0.14l0.324,0.164l-0.09,0.211l0.205,0.046l0.265-0.023h0.226l0.223,0.141l-0.114,0.07l-0.031,0.141l0.025,0.141l0.136,0.06z      M782.939,297.694l-0.088,0.158l-0.558,0.13l-0.309,0.288l-0.322,0.101l-0.246,0.244l-0.692-0.242l-0.16,0.086l0.15,0.216l0.429,0.415l-0.141,0.173l0.02,0.259l-0.064,0.431l-0.218-0.071l-0.976-0.099l0.418,0.229l0.449,0.244l-0.278,0.49l-0.427,0.896     l-0.212,0.549l-0.418,0.318l-0.673,0.349l-0.171,0.246l-0.259,0.145l-0.581,0.233l-0.593,0.406l-0.398,0.015l-1.156-0.258l-0.628,0.112l-0.585-0.442l-0.812-0.158l-0.373-0.066l-0.162-0.308l-0.467-0.098l-0.24,0.142l-0.062,0.168l-0.78,0.095l-0.214-0.166     l-0.515-0.095l-0.146-0.286l0.432-0.089l-0.223-0.216l0.328-0.116l0.322-0.001l-0.452-0.482l0.82,0.266l-0.464-0.576l0.121-0.145l0.946,0.156l0.082-0.13l-0.141-0.173l-0.201-0.216l-0.06-0.288l0.283-0.303l0.569-0.246l0.328-0.374l0.561-0.375l0.102-0.302     l0.998-0.575l1.106-0.275l0.713-0.331l0.544-0.36l0.377-0.101l0.685-0.575l0.066-0.272l0.48-0.302l0.373-0.015l0.787-0.331l0.664-0.402l0.126-0.215l-0.008-0.172l0.266-0.144l0.448-0.302l-0.109-0.501l0.076-0.214l0.166-0.44l0.306,0.048l0.066-0.152l0.58-0.259     l0.444-0.272l0.137-0.285l0.131-1.187l0.512-0.647l0.372,0.047l0.365,0.165l0.032,0.259l0.337,0.06l0.187,0.186l0.231,0.799l0.312,0.242l0.973-0.645l0.426-0.029l0.367,0.113l0.222,0.5l-0.197,0.399l0.299,0.429l0.066,0.271l-0.611,0.659l-0.261,0.401     l-0.476,0.358l-0.868,0.746l-0.578,0.359l-0.295,0.13l-0.236,0.258l-0.389,0.159l-0.271,0.258l0.416,0.407l0.428,0.047l0.421,0.289l-0.276,0.113l-0.484,0.07l-0.503-0.296l-0.488,0.131l-0.352,0.158z'},
	AR => {name => 'Argentina',
		d => 'M247.899,318.387l0.008-1.144l0.821,0.289l0.06,0.206l-0.354,0.312l-0.534,0.337z M248.453,316.576l-0.286-0.039l-1.385-0.36l-0.841-0.217l-2.827-0.132l-1.41,0.052l-0.669-0.041l-0.778-0.568l-0.231-2.285l-0.187-0.248l-0.654,0.121     l-0.961,0.283l-0.218-0.043l-0.508-1.123l-0.28-1.309l0.037-0.45l0.271-0.292l1.729-1.01l0.307-0.263l0.296-1.218l0.069-0.188l-0.446-0.648l0.249-0.781l0.28-0.219l0.598-0.161l0.226-0.262l0.212-0.434l0.216-0.896l-0.158-1.035l0.059-1.094l0.767-0.794     l-0.017-0.216l-0.552-0.385l-0.586-0.298l-0.176-0.171l0.757-0.146l0.726-0.033l0.322-0.13l0.245-0.202l0.007-0.186l-0.302-0.17l-0.789-0.11l-0.26-0.185l-0.252-0.585l0.191-1.458l-0.088-0.655l-0.555-0.111l-0.125-0.128l-0.094-1.226l0.106-0.271l0.172-0.172     l0.596-0.317l-0.012-0.427l-0.231-0.867l-0.123-1.835l0.1-0.37l0.316-0.541l0.511-2.427l0.053-0.312l0.126-0.17l0.951-0.529l0.202-0.143l-0.437-0.932l-0.249-1.103l-0.014-1.16l0.142-1.075l0.231-0.312l1.334-1.11l0.078-0.325l-0.189-1.06l-0.088-0.409     l0.319-0.595l1.083-1.854l0.075-0.41l-0.055-0.69l-0.784-2.816l-0.408-1.154l-0.285-0.633l0.156-0.961l0.388-1.201l0.292-0.34l0.492-0.271l0.124-0.185l-0.054-0.762l-0.167-1.466l0.823-1.839l0.282-0.439l0.608-0.694l0.464-0.835l0.329-0.835l0.791-0.089     l0.333-0.017l0.152-0.311l-0.011-0.227l-0.53-0.477l-0.114-0.507l0.161-0.382l0.273-0.369l-0.03-0.226l-0.34-0.449l-0.113-0.437l0.007-0.579l0.421-0.722l-0.25-0.817l0.204-0.312l0.819-0.372l1.346-0.53l0.36-0.256l0.541-1.457l0.093-0.636l-0.161-0.154     l-0.212-0.14l-0.107-0.056l2.026-2.087l0.292-0.27l0.322,0.181l0.193,0.169l0.615,0.194l0.901-0.034l0.527-0.045l0.531,0.067l0.37,0.195l0.341,0.309l0.416,1.084l1.034-1.784l0.686-0.004l1.33,0.077l0.592,0.109l0.19,0.056l0.225,0.337l0.782,0.913l1.271,1.376     l0.576,0.562l0.835,0.588l0.498,0.237l1.173,0.204l0.671,0.307l1.632,1.106l1.448,0.697l0.65,0.18l0.939,0.503l-0.018,0.268l-0.617,1.203l-0.625,0.851l-0.048,0.227l0.21,0.619l-0.11,0.198l-0.486,0.398l-0.425,0.426l-0.064,0.212l0.19,0.056l1.187-0.332     l0.607,0.025l0.992,0.333l0.564,0.096l0.71-0.005l0.745-0.131l0.387-0.172l0.235-0.029l0.35,0.097l0.609,0.363l0.352-0.51l0.301-0.27l1.007-0.74l0.375-0.468l0.544-1.57l-0.02-0.239l0.957-0.161l0.462-0.017l0.206,0.196l0.517,1.154l-0.094,1.638l-0.161,0.467     l-0.521,0.313l-1.754,0.744l-0.348,0.242l-1.633,1.448l-1.435,1.363l-1.805,1.816l-0.833,0.88l-0.214,0.27l-0.443,0.524l-0.065,0.452l-0.595,2.359l-0.103,0.522l0.049,0.847l0.168,0.986l-0.118,0.325l-0.48,0.524l-0.24,0.495l-0.011,0.522l0.194,0.577     l-0.054,0.338l-0.162,0.273l-0.26,0.325l0.015,0.226l0.924,0.831l0.68,0.281l0.715,0.281l0.283,0.169l0.281,0.325l-0.025,0.325l-0.362,0.523l-0.043,0.396l0.105,0.339l0.174,0.269l0.466,0.325l0.522,0.168l0.109,0.113l0.226,0.892l-0.308,0.481l-0.75,0.937     l-0.729,0.766l-0.313,0.737l-0.368,0.284l-0.832,0.342l-1.04,0.342l-1.92,0.401l-1.795,0.188l-1.361,0.116l-0.945,0.044l-1.175-0.11l-0.934-0.226l-0.128,0.199l0.036,0.808l0.322,0.312l0.308,0.184l-0.09,0.298l-0.381,0.624l-0.345,0.498l-0.069,0.385l0.392,0.682     l0.066,0.285l-0.208,0.214l-0.105,0.057l-1.251,0.473l-1.137,0.116l-0.814-0.069l-0.967-0.34l-1.47-0.396l-0.246,0.057l-0.23,0.271l0.041,0.598l0.429,0.684l0.037,0.398l-0.242,0.643l0.092,0.385l0.773,0.54l0.796,0.084l0.369-0.2l-0.387-0.398l0.872-0.188     l0.383-0.043l0.234,1.041l0.052,0.3l-0.144,0.157l-0.299,0.101l-0.448,0.072l-0.261-0.157l-0.104-0.299l-0.115-0.071l-1.046,0.073l-0.67,0.201l-0.212,0.101l0.151,0.214l0.591,0.07l0.47,0.113l0.452,0.113l0.06,0.028l-0.864,0.388l-0.776,0.287l-0.577,0.602     l0.003,0.414l0.161,0.787l-0.081,0.258l-0.815,0.817l0.022,0.215l0.423,0.371l-0.491,0.116l-1.194,0.088l-0.48,0.087l-0.632,0.246l-0.619,0.389l-0.56,0.548l-0.549,0.821l-0.052,0.389l0.061,0.375l0.312,0.591l0.48,0.446l0.98,0.633l0.657,0.244l0.97,0.143     l0.362,0.086l0.14,0.274l-0.151,0.796l-0.128,0.348l-0.342,0.464l-0.189,0.145l-1.08,0.524l-1.541,0.814l-0.712,0.698l-0.179,0.276l-0.093,0.45l0.111,0.523l-0.169,0.451l-0.239,0.32l-0.97,0.454l-0.969,0.25l-0.421,0.221l-0.323,0.396l-0.226,0.791l-0.054,0.514     l0.2,0.777l0.547,0.896l0.699,0.779l0.235,0.339l-0.101,0.032z M247.899,318.387l0.18,0.182l0.148,0.073l0.607-0.075l0.344,0.133l0.648,0.725l0.908,0.665l0.993,0.756l0.525,0.222l0.73,0.37l0.246,0.074l0.42-0.001l0.483,0.163l1.283,0.027l0.142-0.016     l-0.006,0.224l-0.19,0.209l-0.492,0.06l-1.198,0.092l-0.777,0.196h-0.364l-1.179-0.355l-0.753-0.088l-1.15-0.027l-0.814-0.014l-0.831,0.081l0.098-3.675z'},
	IS => {name => 'Iceland',
		d => 'M346.758,54.457l0.127-0.162l0.42-0.179l0.894,0.015l0.674-0.098l-0.354-0.227l-0.405-0.34l0.317-0.342l0.277,0l0.956,0.42l0.67,0.048l0.3-0.163l-0.191-0.26l-0.625-0.373l0.366-0.245l1.037,0.226l0.957,0.08l0.746,0.275l0.446,0.551     l-0.119,0.405l-0.441,0.292l0.922,0.806l0.553-0.356l0.352-0.13l0.63-0.114l0.49-0.179l0.061-0.21l-0.169-0.778l0.542-0.245l0.501,0.454l0.426,0.307l0.489,0.209l0.215,0.016l0.185-0.13l-0.264-0.454l0.243-0.163l0.27-0.033l0.817-0.164l0.683,0.438l0.536,0.242     l0.542,0.063l0.05-0.178l-0.358-0.535l1.006,0.145l1.439,0.079l0.787-0.115l0.427-0.229l-0.021-0.716l1.167,0.08l0.635,0.471l1.118,0.323l0.683,0.015l0.273,0.243l-0.252,0.552l0.786,0.29l1.674,0.159l0.127,0.145l0.143,0.548l-0.07,0.387l-0.152,0.256     l-0.152,0.256l-0.443,0.129l-0.815,0.018l-0.195,0.096l-0.04,0.431l-0.515,0.463l-0.497,0.16l-0.568-0.031l-0.422-0.159l-0.817,0.495l-0.539,0.144l-1.46,0.463l-0.853,0.113l-0.726,0.001l-0.771,0.097l-0.784,0.587l-0.473,0.127l-1.078,0.097l-0.709-0.03     l-1.316-0.171l-0.608-0.142l-1.283-0.489l-1.058-0.093l-0.443,0.064l-1.041-0.014l-1.834-0.124l-0.297-0.206l0.434-0.191l1.127-0.352l0.701-0.59l-0.818-0.015l-0.51-0.126l-0.428-0.398l-0.253-0.095l-0.358,0.081l-1.564,0.115l-0.557,0.033l-0.37-0.223     l0.141-0.192l0.388-0.129l0.669-0.097l0.794-0.017l0.729-0.114l1.049-0.098l0.376-0.194l0.178-0.322l-0.144-0.258l-0.358-0.177l-0.426-0.015l-0.478-0.145l-1.005-0.047l-0.821,0.099l-0.424,0.162l-0.676,0.082l-1.041-0.272l-0.16-0.21z'},
	EE => {name => 'Estonia',
		d => 'M462.829,67.958l0.145,0.053l0.16,0.131l-0.043,0.174l-0.175,0.044h-0.189h-0.116l-0.088,0.043l-0.058,0.131l-0.175,0.277l-0.219,0.204l-0.319,0.131l-0.204,0.131l-0.088,0.16l0.029,0.16l0.131,0.437l0.073,0.189l0.029,0.16l-0.175,0.131     v0.175l0.175,0.233l0.203,0.087l0.088,0.073v0.073l0.015,0.087l0.043,0.146l0.175,0.043l0.059,0.059l-0.175,0.073l-0.262,0.043l-0.16,0.058l-0.059,0.102l-0.087,0.116h-0.131L461.402,72l-0.015,0.087l-0.116,0.058l0.081,0.106l-0.125,0.025l-0.087-0.015     l-0.306-0.043l-0.16-0.058l-0.175-0.073l-0.204-0.044l-0.131,0.102l-0.204-0.029l-0.131,0.044l-0.16,0.087l-0.146,0.014l-0.146-0.087l-0.116-0.029h-0.175l-0.204-0.117l-0.116-0.174l-0.203-0.117l-0.146-0.043l-0.072-0.117h-0.189l-0.247-0.043l-0.204-0.117     h-0.029l-0.276-0.014l-0.102-0.102l-0.248-0.043l-0.116-0.102l-0.189-0.087v0.073l-0.116,0.087l-0.131-0.058l-0.015-0.073l-0.087-0.029h-0.103l-0.276,0.117l-0.102,0.029l-0.131,0.015l-0.219,0.015l-0.146,0.043l-0.262,0.029l-0.276,0.087l-0.116,0.102h-0.087     l0.156-0.19l-0.003-0.351l0.183-0.238l-0.368-0.21l-0.605,0.437l-0.334-0.251l-0.527-0.038l0.043-0.942l-0.396,0.188l-0.336-0.415l0.158-0.202l-0.209-0.254l0.265-0.074l-0.092-0.252l0.344-0.042l1.026-0.084l-0.006-0.132l0.561-0.108l0.133-0.188l0.436,0.101     l0.074-0.113l0.317,0.05l0.083-0.215l1.104,0.193l0.446-0.294l0.091,0.165l0.514-0.089l1.383,0.029l1.152,0.167l0.305,0.12l0.592-0.045l0.971,0.09l0.426-0.108l0.271-0.24l-0.006-0.009z'},
	LV => {name => 'Latvia',
		d => 'M461.353,72.251l0.37-0.004l-0.015,0.116v0.117l0.232,0.073l0.204,0.087l0.087,0.073l0.204,0.058l-0.015,0.087l-0.029,0.116l-0.015,0.087l-0.102,0.073l-0.087,0.015l-0.103,0.029l0.131,0.087l-0.072,0.131l0.029,0.117l-0.073,0.087     l-0.102,0.073l-0.044,0.102l0.204-0.059l0.146-0.015l0.131,0.073l0.087,0.014l0.073,0.044l-0.059,0.087l-0.043,0.073l0.116,0.102l0.131,0.058l0.029,0.16l0.146,0.102l0.16,0.043l-0.059,0.087l0.131,0.117l-0.015,0.189l0.088,0.233l-0.044,0.087l-0.015,0.117     l-0.061,0.042l-0.241,0.044l-0.24,0.051l-0.12,0.12l-0.223,0.034l-0.137,0.154l-0.137,0.085l-0.069,0.103l-0.068,0.206l-0.188,0.035l-0.239-0.035l-0.24-0.034l-0.325-0.034h-0.359l-0.172,0.068l-0.103,0.137l-0.223,0.085h-0.154l-0.103-0.017l-0.086,0.052     l-0.377-0.035l-0.273-0.068l-0.154-0.171l-0.138-0.154l-0.325-0.137l-0.497-0.223l-0.342-0.24l-0.377-0.034l-0.583-0.035l-0.325-0.12l-0.291-0.188l-0.086-0.257l-0.188,0.017l-0.171,0.068l-0.36,0.171l-0.394,0.017h-0.24l-0.273,0.085l-0.24-0.085l-0.309-0.103     l-0.6-0.017l-0.291,0.069l-0.359-0.069l-0.291-0.051l-0.154,0.034l-0.274,0.069l-0.103-0.052l-0.12-0.137h-0.154l-0.257,0.068h-0.188l-0.754-0.017l-0.445-0.085l-0.754,0.171l-0.599,0.154l-0.429,0.103l-0.257,0.137l-0.052,0.188l-0.526,0.026l-0.065-0.059     l0.073-0.837l0.035-0.302l0.127-0.167l0.672-0.379l0.034-0.717l0.267-0.162l0.267-0.273l0.217-0.203l0.296-0.026l1.056-0.199l0.166-0.046l0.162-0.066h0.29l0.049,0.237l0.657,0.388l0.422,0.162l0.23,0.473l0.091,0.15l0.441,0.196l0.785,0.059l0.868-0.244     l0.24-0.122l0.178-0.288l-0.052-0.394l-0.193-0.869l0.198-0.243l0.045-0.055h0.087l0.116-0.102l0.276-0.087l0.262-0.029l0.146-0.043l0.219-0.015l0.131-0.015l0.102-0.029l0.276-0.117h0.103l0.087,0.029l0.015,0.073l0.131,0.058l0.116-0.087v-0.073l0.189,0.087     l0.116,0.102l0.248,0.043l0.102,0.102l0.276,0.014h0.029l0.204,0.117l0.247,0.043h0.189l0.072,0.117l0.146,0.043l0.203,0.117l0.116,0.174l0.204,0.117h0.175l0.116,0.029l0.146,0.087l0.146-0.014l0.16-0.087l0.131-0.044l0.204,0.029l0.131-0.102l0.204,0.044     l0.175,0.073l0.16,0.058l0.306,0.043l0.087,0.015l0.125-0.025z'},
	LT => {name => 'Lithuania',
		d => 'M451.02,79.165l-0.029-0.038l-0.034-0.137l-0.018-0.171l0.068-0.206l0.068-0.154l0.224-0.12l-0.052-0.12l-0.018-0.137l-0.171-0.069l-0.188-0.034l-0.103-0.103l-0.086-0.137l-0.223,0.017h-0.257h-0.445l-0.223,0.051l-0.086-0.103     l-0.514-0.068l-0.257-0.069l-0.223-0.12h-0.24l-0.086-0.052l-0.051-0.154l-0.12,0.034l-0.353,0.096l-0.043-0.077l0.128-0.012l0.034-0.183l-0.439-0.646l-0.008-0.14l-0.042-0.727l-0.112-0.102l0.526-0.026l0.052-0.188l0.257-0.137l0.429-0.103l0.599-0.154     l0.754-0.171l0.445,0.085l0.754,0.017h0.188l0.257-0.068h0.154l0.12,0.137l0.103,0.052l0.274-0.069l0.154-0.034l0.291,0.051l0.359,0.069l0.291-0.069l0.6,0.017l0.309,0.103l0.24,0.085l0.273-0.085h0.24l0.394-0.017l0.36-0.171l0.171-0.068l0.188-0.017l0.086,0.257     l0.291,0.188l0.325,0.12l0.583,0.035l0.377,0.034l0.342,0.24l0.497,0.223l0.325,0.137l0.138,0.154l0.154,0.171l0.273,0.068l0.377,0.035l-0.017,0.171l-0.086,0.154l-0.034,0.12l-0.12,0.137l-0.086,0.137l0.343,0.034l0.274,0.052l0.085,0.051l-0.119,0.051h-0.086     l-0.103,0.154l-0.018,0.154l-0.171,0.017l-0.12-0.086l-0.12,0.051l-0.239-0.034l-0.154,0.034l-0.086,0.154l-0.103,0.154l-0.257,0.068h-0.429l-0.137,0.137l-0.12,0.12l-0.034,0.154l-0.086,0.171l0.103,0.171l-0.068,0.137l-0.239,0.154v0.137l-0.068,0.085     l-0.069,0.137l0.172,0.034h0.205l0.138,0.206l-0.086,0.188l-0.274,0.017l-0.223-0.068v-0.154l-0.034-0.085l-0.086-0.069l-0.171,0.051l-0.12,0.086l-0.291-0.034l-0.068,0.137l-0.24,0.12h-0.154l-0.188-0.034l-0.273,0.103l0.086,0.171l-0.069,0.12l-0.171,0.034     l-0.137-0.034l-0.206,0.051l-0.377,0.154h-0.291l-0.068-0.103l-0.12-0.051l-0.239,0.051l-0.377,0.017l-0.24,0.034l-0.291-0.034l-0.154,0.034l-0.093-0.035l-0.09-0.171l-0.016-0.029l-0.099-0.186l-0.284-0.487l-0.679-0.243l-0.04-0.014l-0.641,0.021z'},
	BY => {name => 'Belarus',
		d => 'M452.867,80.273l0.093,0.035l0.154-0.034l0.291,0.034l0.24-0.034l0.377-0.017l0.239-0.051l0.12,0.051l0.068,0.103h0.291l0.377-0.154l0.206-0.051l0.137,0.034l0.171-0.034l0.069-0.12l-0.086-0.171l0.273-0.103l0.188,0.034h0.154l0.24-0.12     l0.068-0.137l0.291,0.034l0.12-0.086l0.171-0.051l0.086,0.069l0.034,0.085v0.154l0.223,0.068l0.274-0.017l0.086-0.188l-0.138-0.206h-0.205l-0.172-0.034l0.069-0.137l0.068-0.085v-0.137l0.239-0.154l0.068-0.137l-0.103-0.171l0.086-0.171l0.034-0.154l0.12-0.12     l0.137-0.137h0.429l0.257-0.068l0.103-0.154l0.086-0.154l0.154-0.034l0.239,0.034l0.12-0.051l0.12,0.086l0.171-0.017l0.018-0.154l0.103-0.154h0.086l0.119-0.051l-0.085-0.051l-0.274-0.052l-0.343-0.034l0.086-0.137l0.12-0.137l0.034-0.12l0.086-0.154l0.017-0.171     l0.086-0.052l0.103,0.017h0.154l0.223-0.085l0.103-0.137l0.172-0.068h0.359l0.325,0.034l0.24,0.034l0.239,0.035l0.188-0.035l0.068-0.206l0.069-0.103l0.137-0.085l0.137-0.154l0.223-0.034l0.12-0.12l0.24-0.051l0.241-0.044l0.165,0.147l0.229,0.066l0.197-0.131     l0.181,0.016l0.312,0.033l0.132,0.148l0.082,0.148l0.197-0.033l0.214-0.065l0.361-0.049l0.312,0.049l0.296,0.065l0.147,0.017v0.115l-0.164,0.099l-0.017,0.099l0.065,0.148l0.164,0.148h0.197l0.214-0.197l0.279-0.016h0.165l0.147-0.099l0.23-0.083l0.131,0.049     l0.099,0.049l0.247-0.049l0.542,0.115l0.132,0.131l0.279,0.099l0.099,0.099l0.147,0.099l0.165,0.033l0.147-0.033l0.049,0.115l-0.065,0.115v0.083l-0.033,0.164l-0.131,0.165l0.197,0.247l0.147,0.099l0.05,0.164l-0.066,0.131h-0.114v0.083l-0.115,0.082l-0.099,0.049     l-0.033,0.165l-0.049,0.147l0.345,0.049l0.132,0.181l0.082,0.115l0.181-0.049l0.132,0.033l-0.099,0.115l-0.066,0.131l0.017,0.099l0.214,0.017l0.164,0.263l0.115,0.23l0.443,0.213l0.23,0.066l0.279,0.082l0.164,0.099l0.066,0.148l-0.099,0.197l-0.066,0.181     l0.182,0.066l0.361-0.066l0.378,0.066l0.361,0.099l0.263,0.066l-0.032,0.065l-0.066,0.049l-0.082,0.017l0.099,0.181l0.296,0.148l0.279,0.066l0.033,0.131l-0.065,0.164h-0.296l-0.148,0.083l-0.049,0.065l-0.444,0.247l-0.525,0.099l-0.51-0.016l-0.197-0.132     l-0.328-0.049l-0.362,0.017l-0.131,0.165l-0.099,0.131l0.017,0.164l0.279,0.263l0.296,0.164v0.165l-0.132,0.066l0.099,0.148l0.147,0.131l-0.082,0.099l0.033,0.164l0.033,0.23l-0.033,0.099l0.164,0.082l0.082,0.115l0.165,0.066l0.002,0.142l-0.519-0.005     l-0.522,0.056l-0.112,0.131l-0.205-0.056l-0.187-0.037l-0.336,0.075l-0.057,0.13l-0.111,0.112l-0.317,0.187l-0.188,0.261l-0.261,0.224l-0.057,0.206l0.243,0.205l0.056,0.149l-0.131,0.206l-0.261-0.019l-0.149-0.056l-0.149-0.206l-0.112-0.056l-0.187-0.075     l-0.224-0.037l-0.225,0.037l-0.242,0.075l-0.299,0.019l-0.149-0.131l-0.224,0.075l-0.188,0.093l-0.316,0.056l-0.188-0.056l-0.037-0.205l-0.112-0.131l-0.168-0.131l-0.13,0.038l-0.131,0.075h-0.168l-0.299,0.149l-0.131,0.149h-0.168l-0.094-0.187l-0.13-0.075     h-0.206l-0.224,0.112l-0.131-0.187l-0.224-0.093l-0.131,0.112l-0.354,0.056l-0.262-0.112h-0.112l-0.019,0.205l-0.168,0.093l-0.093-0.056l0.056-0.224l-0.243-0.038l-0.187-0.056l-0.541,0.112v-0.149h-0.187l0.019-0.224l-0.28-0.037l-0.242,0.075l-0.523-0.112     l-0.578-0.056l-0.075-0.056h-0.522l-0.205-0.168l-0.262,0.019l-0.522-0.093l-0.467,0.075h-0.485l-0.354-0.056l-0.355,0.056l-0.354,0.056l-0.485-0.038l-0.485,0.019l-0.205,0.187l-0.037,0.168l-0.374,0.168l-0.373,0.206l-0.112-0.112h-0.261l-0.374-0.019     l-0.037,0.131v0.045l-0.126-0.137l0.315-0.752l-0.013-0.25l-0.218-0.146l-0.149-0.176l-0.421-0.146l-0.289-0.012l0.128-0.292l0.291-0.328l0.571-0.244l0.44-0.03l0.263-0.208l0.023-0.236l-0.172-0.502l-0.615-1.5l-0.16-0.302z'},
	GB => {name => 'United Kingdom',
		d => 'M400.125,81.146l0.633,0.305l0.208,0.207l0.208,0.37l-0.038,0.193l-0.545,0.563l0.714,0.176l0.396-0.311l0.527-0.119l0.602,0.028l0.807,0.176l0.467,0.354l0.235,0.752l-0.077,0.221l-0.322,0.414l-1.068,0.473l-0.767,0.561l-0.96,0.237     l1.223,0.167l0.501,0.043l0.354-0.104l0.39,0.117l-0.066,0.516l-0.997,0.308l0.005,0.199l-0.479-0.084l-1.068,0.443l-0.879-0.142l-0.293-0.048l-1.119,0.211l-0.587-0.211l-0.598,0.112l-1.584,0.141l0.137,0.295l-0.907-0.168l-0.264,0.168l-0.911-0.337     l-0.334,0.143l-0.913,0.089l-0.093,0.569l-0.337,0.316l-0.37,0.042l-0.272-0.252l-0.53-0.172l-0.135,0.151l-0.527-0.077l-0.948,0.324l-0.701,0.552l-0.326-0.231l-0.775-0.147l1.2-0.472l0.492-0.476l0.447-0.097l0.468-0.388l0.118-0.485l0.242,0.063l0.367-0.211     l-0.008-0.274l1.013-0.105l0.76,0.119l0.927,0.007l0.073-0.338l0.308-0.142l0.321-0.556l-0.939,0.394l-0.725,0.016l-1.467-0.482l-1.866-0.055l-0.399-0.191l-0.156-0.162l0.417-0.325l0.983-0.194l0.721-0.237l0.38-0.384l0.066-0.827l-0.119-0.192l-0.713,0.046     l-0.34-0.044l0.288-0.355l0.387-0.223l0.802-0.253l1.394-0.062l0.922-0.076l-0.316-0.548l0.172-0.683l0.253-0.461l-0.045-0.312l-0.834,0.061l-0.484-0.296l-0.2-0.312l0.309-0.507l0.617-0.433l-0.347-0.104l-0.596-0.088l-0.735,0.3l-0.476,0.061l-0.753-0.222     l-0.088,0.194l-0.222,0.194l-0.672-0.103l-0.464-0.133l0.1-0.343l0.348-0.36l0.604-0.706l-0.293-0.134l-0.305-0.39l0.028-0.24l0.304-0.106l0.3-0.196l-0.194-0.496l-0.306,0.076l-0.636,0.453l-0.442,0.031l-0.526,0.287l-0.14-0.421l0.302-0.527l0.438-0.559     l0.065-0.257l-0.417-0.195l-0.196-0.045l-0.218,0.302l-0.394,0.257l-0.493-0.165l0.299-0.575l0.54-0.455l0.09-0.136l-0.225-0.575l0.366-0.092l0.225-0.197l-0.672-0.515l0.432-0.351l0.752,0.151l0.387-0.092l-0.645-0.759l0.975-0.169l-0.457-0.502l0.416-0.382     l0.924,0.365l0.824-0.093l0.686-0.139l0.867-0.047l0.612,0.014l0.303,0.259l-0.307,0.29l-1.726,0.704l-0.46,0.274l-0.218,0.441l0.222,0.182l0.784,0.029l0.877-0.078l0.685-0.001l0.53,0.075l1.563-0.064l0.458,0.378l-0.363,0.425l-0.212,0.323l0.098,0.112     l-0.565,0.66l-0.226,0.111l-0.339,0.437l-0.696,0.261l-0.382,0.038l0.451,0.186l0.508,0.167l-0.116,0.015l-0.272,0.19l-0.61,0.052l-0.275,0.196l-1.337-0.025l0.404,0.223h0.302l0.492,0.093l0.432-0.006l0.519-0.223l0.413-0.025l0.449,0.161l0.656,0.164     l0.673,0.566l0.496,0.228l0.118,0.165l-0.067,0.238l0.312,0.78l0.371,0.536l0.438,0.189l0.714,0.107l0.59,0.549l0.688,0.593l0.135,0.52l-0.188,0.49l0.257,0.124z M387.915,77.13l-0.128-0.325l0.149-0.335l0.38-0.089l0.079,0.501l-0.307,0.251l-0.173-0.003z      M386.786,80.184l-0.178-0.272l-0.967,0.072l0.123-0.256l-0.364-0.15l-0.26-0.257l-0.335-0.107l-0.253,0.364l-0.751,0.257l-0.778-0.192l-0.401-0.278l-0.101-0.278l0.86-0.278l-0.483-0.257l0.817-0.107l0.385-0.484l-0.029-0.235l0.449-0.09l0.508-0.15l0.781-0.077     l0.424,0.044l0.389,0.104l0.362-0.046l0.218,0.149l0.519,0.791l0.047,0.179l-0.081,0.298l0.308,0.446l-0.155,0.328l-0.402,0.328l-0.354,0.12l-0.299,0.038z'},
	KZ => {name => 'Kazakhstan',
		d => 'M578.943,106.217l-0.41-0.375l-0.466-0.098h-0.663l-0.196-0.27l-0.27-0.147l-0.147-0.344l-0.564,0.049l-0.981-0.246l-0.662,0.074l-1.35-0.024l-0.662-0.098l-0.712-0.221l-0.785,0.147h-0.761l-0.858,0.024l-0.441,0.27l-0.54-0.098     l-0.908-0.196l-0.735-0.246l-0.761-0.27l-0.589-0.074l-0.688,0.123l-0.466,0.368l-0.245,0.736l0.024,0.442l-0.344-0.123l-0.81-0.123l-0.688-0.196l-0.883-0.245l-0.883-0.147l-0.663,0.098l-0.736,0.123l-0.318,0.368l-0.393,0.442l0.044,0.273l-0.322,0.031     l-0.377,0.377l-0.283-0.126l-0.22,0.063l-0.346,0.283l-0.534,0.471l-0.755,0.189l-0.943,0.377l-0.282,0.188l-0.221,0.472l-0.439,0.188l-0.504,0.44l0.157,0.409l-0.125,0.188h-0.66l-0.44-0.346l0.062-0.283l-0.062-0.283l-0.44-0.314h-0.346l-1.006,0.094     l-0.691,0.032l-0.503-0.063l-0.346-1.069l-0.221-0.817h-1.006l-0.031-0.754l0.188-0.409l0.031-1.038l-0.66,0.314l-0.66-1.006l-0.597-0.22l-0.724-0.723l-1.1,0.409l-2.767-0.188l-2.578,0.346l-2.012-1.666l-5.722-2.986l-5.658,1.289l-0.056,8.174l-0.158-0.014     l-0.341,0.106l-0.489,0.043l-0.447-0.255l-0.638-0.703l-0.256-0.511l-0.617-0.383l-0.681-0.383l-0.512-0.234l-0.979,0.085l-1.277,0.298l-0.937,0.532l-0.529,0.453l0.092-0.399l-0.06-0.18l-0.12-0.12l0.14-0.26l0.2-0.2l0.14-0.32l0.04-0.3l0.18-0.2l-0.159-0.24     l-0.4-0.16l-0.459,0.06l-0.18-0.16l-0.3,0.06l-0.2,0.04l-0.199-0.18l-0.221-0.32l-0.319-0.28h-0.34l-0.359,0.02v-0.2l0.08-0.28l-0.2-0.379l-0.239-0.12l-0.2-0.24l-0.399-0.799l-0.08-0.28l-0.56-0.12l-0.699-0.08l-0.14-0.16l0.02-0.439l0.16-0.12l0.3-0.06     l0.399,0.02l0.34,0.02l0.479,0.14l0.539,0.18l0.18-0.08l0.36-0.08l-0.2-0.16l-0.26-0.12l-0.399-0.2l-0.2-0.24l0.26-0.36l0.28-0.04l0.08-0.26l0.18-0.299l0.12-0.14l0.26,0.04l0.319-0.08l0.16-0.1l0.339,0.12h0.24l1.119-0.04l0.999,0.14l0.499,0.02l-0.159-0.08     l-0.34-0.2l-0.479-0.12l-0.021-0.3l0.2-0.2l0.279-0.22l0.221-0.28l0.119-0.52l0.12-0.28l-0.16-0.24l-0.14-0.16l0.1-0.2l0.26-0.2l-0.119-0.12l-0.101-0.3l-0.359-0.12l-0.359-0.04l-0.68-0.1l-0.2,0.16l-0.199,0.08l-0.52,0.08l-0.46-0.12l-0.319-0.26l-0.26-0.06     l-0.68-0.12l-0.56,0.06l-0.659,0.319l-0.42,0.02l-0.799,0.5l-0.72,0.28l-0.499,0.06l-0.42-0.02l-0.279,0.24l-0.213,0.18l-0.616-0.19l-0.857-0.377l-0.068-0.308l0.343-0.103l0.309,0.103l0.445,0.103l0.138-0.103l-0.96-1.131l-0.343-0.514l-0.479-0.206l-0.515-0.445     l-0.514-0.034l-0.343,0.034l-0.583-0.206l-0.103,0.343l-0.514-0.514l0.068-0.309l-0.138-0.377l-1.37-0.343l0.65-1.165l0.446-0.274l0.239-0.206l-0.239-0.274l-0.343-0.171l0.205-1.303l0.823-0.137l0.343-0.549l0.103-0.308l0.411-0.069l0.514,0.24l0.48,0.548     l0.514,0.411h0.651l0.411-0.24l0.068-0.446l-0.171-0.411l-0.068-0.445l0.479-0.206l0.891-0.411l0.172-0.24l0.309-0.309l0.514-0.171l0.549-0.068l0.788-0.377l0.548-0.343l0.515-0.309l0.651,0.069h0.479l0.309,0.274l0.651-0.137l0.273-0.137l0.617-0.24l0.411,0.069     l0.411,0.514l0.788,0.035l0.617-0.069l0.96,0.171v0.343l0.582,0.206l0.789,0.343l0.411,0.274l0.068,0.583l0.274,0.137l0.239-0.274l-0.205-0.48l-0.034-0.24l0.72,0.068l0.582,0.548l0.686,0.137l0.411,0.24l0.686-0.171l0.274-0.274l0.377-0.343l0.514-0.377     l0.823,0.068l0.65,0.035l0.651,0.411l0.617-0.068l0.137-0.412l1.062-0.103l0.754,0.103l0.274,0.548l0.926,0.309l0.754,0.137l0.411,0.171l0.651-0.343l0.171-0.309h0.24l0.343,0.343l0.959,0.034l1.577-0.411l0.137-0.309l0.138-0.686l-0.24-0.24l-1.165-0.171     l-0.274-0.308l-0.651-0.069l-0.377-0.137l0.068-0.171l-0.377-0.137h-0.239l-0.164-0.274l0.467-0.067l0.735-0.368l0.588-0.147l0.331-0.294l-0.441-0.478l-0.146-0.257l0.662-0.515l0.698-0.184l1.103,0.147l0.515-0.073l0.11-0.257l-0.956-0.294l-1.065-0.11v-0.331     l0.294-0.074l-0.294-0.221l-0.074-0.441l0.185-0.515l0.33-0.074l1.066,0.147h0.515h0.772l0.368-0.184l1.396-0.405l1.029-0.037l0.735-0.11l1.545-0.11l0.588-0.073l0.331,0.073l0.221-0.331l0.625-0.331l1.177-0.037l2.021-0.405l1.876-0.073l0.625-0.074l0.367-0.368     V77.39l0.515-0.037l0.589-0.184l0.11-0.221l0.735-0.037l0.919,0.147l0.515,0.11l0.772,0.257l0.625-0.11l0.882-0.037l0.368,0.404l-0.037,0.331l0.147,0.221l0.515,0.22l-0.11,0.331l-0.147,0.257l0.073,0.331l-0.33,0.037l0.184,0.257l0.478,0.074l0.295-0.147     l0.44,0.11l0.368-0.147l0.367,0.074l0.331-0.221l0.294,0.11l0.295,0.368l0.367,0.221l0.147-0.147l0.184-0.147l0.478,0.037l0.405,0.294l0.478,0.11l0.441-0.221h0.367l-0.146,0.294l-0.441,0.184l-0.331,0.441l0.331,0.184l0.441-0.11l0.771-0.073l0.441,0.037     l0.552,0.184l0.294-0.294l0.772-0.441l1.103-0.257l0.956-0.515l0.772-0.221l0.515-0.22l0.809-0.074v0.441l-0.515,0.11l-0.11,0.368l1.104,0.588l0.809,0.294l1.287,0.772l1.066,1.029l1.69,2.133l0.846,0.882l1.104,1.434l0.515-0.257l0.331-0.257l0.367-0.515h0.92     l0.367,0.331v0.368h0.478l0.258,0.257l0.184,0.184h0.589h0.992l0.993-0.221l0.771-0.221l0.993-0.037l0.698,0.441l0.772,0.588l0.331,0.625l0.956,0.147l0.588,0.552l0.662,0.699l0.882,0.073l0.993,0.074l0.478-0.368l0.625-0.184l-0.073,0.331l0.441,0.331     l0.294,0.478h0.589l0.064,0.145l-0.551,0.034l-0.542,0.148l-0.279,0.262l-0.011,0.275l-0.035,0.478l-0.306,0.219l-0.289,0.06l-1.199,0.093l-0.428,0.277l-0.34,0.581l0.097,0.75l0.213,0.707l-0.157,0.39l-0.444,0.392l-0.417,0.103l-0.718,0.062l-1.402-0.079     l-0.594-0.141l-0.721-0.141l-1.096-0.254l-0.427,0.507l-0.516,1.141L584.2,97.43l-0.286,0.605l-0.137,0.418l0.622,0.514l0.126,0.286l-0.156,0.245l-0.231,0.145l-0.394,0.074l-1.133-0.238l-0.5-0.184l-0.35,0.06l-1.082,0.207l-1.799,0.254l-0.393,0.188     l-0.215,0.302l-0.068,0.215l0.232,0.185l0.366-0.06l0.483,0.141l0.03,1.357l0.345,0.627l0.29,0.441l0.119,0.47l-0.222,0.33l-0.705,0.546l-0.32,0.401l-0.02,0.399l0.139,0.86z'},
	IE => {name => 'Ireland',
		d => 'M386.786,80.184l-0.304,0.038l-0.223,0.09l0.241,0.252l0.361,0.771l0.287,1.213l-0.061,0.281l-0.359,0.341l-0.242,0.414l-0.145,0.473l-0.185,0.044l-0.284-0.058l-0.616,0.031l-0.15,0.212l-0.913,0.042l-0.84,0.132l-0.247,0.144l-0.661,0.286     l-0.903,0.498l-0.628,0.035l-0.879,0.283l-1.28,0.084l0.053-0.378l-0.089-0.441l-0.848,0.1l-0.171-0.487l0.734-0.254l-1.186-0.021l0.062-0.233l1.286,0.027l0.198-0.104l0.039-0.222l0.107-0.31l0.515-0.134l0.692-0.031l0.13-0.281l-1.07,0.099l0.387-0.437     l-0.187-0.159l0.481-0.468l0.694-0.011l0.163-0.089l-0.174-0.311l-0.348,0.177l-0.309-0.131l-0.319,0.03l-0.391-0.177l-0.414,0.001l-0.182,0.106L378,81.478l0.309-0.306l-0.29-0.142l0.759-0.126l-0.139-0.301l0.391-0.235l-0.481-0.214l-0.59,0.128L378,79.792     l0.38-0.268l0.215-0.16l0.928,0.187l0.336-0.075l0.527,0.038l1.102,0.123l-0.214-0.358L382.132,79l0.198-0.321h-1.373l0.154-0.15l0.569-0.107l0.061-0.29l0.291-0.479l0.505-0.181l0.804-0.169l0.22,0.302l0.354,0.149l0.156-0.031l0.029,0.235l-0.385,0.484     l-0.817,0.107l0.483,0.257l-0.86,0.278l0.101,0.278l0.401,0.278l0.778,0.192l0.751-0.257l0.253-0.364l0.335,0.107l0.26,0.257l0.364,0.15l-0.123,0.256l0.967-0.072l0.178,0.272z'},
	UA => {name => 'Ukraine',
		d => 'M452.998,85.535V85.49l0.037-0.131l0.374,0.019h0.261l0.112,0.112l0.373-0.206l0.374-0.168l0.037-0.168l0.205-0.187l0.485-0.019l0.485,0.038l0.354-0.056l0.355-0.056l0.354,0.056h0.485l0.467-0.075l0.522,0.093l0.262-0.019l0.205,0.168     h0.522l0.075,0.056l0.578,0.056l0.523,0.112l0.242-0.075l0.28,0.037l-0.019,0.224h0.187v0.149l0.541-0.112l0.187,0.056l0.243,0.038l-0.056,0.224l0.093,0.056l0.168-0.093l0.019-0.205h0.112l0.262,0.112l0.354-0.056l0.131-0.112l0.224,0.093l0.131,0.187     l0.224-0.112h0.206l0.13,0.075l0.094,0.187h0.168l0.131-0.149l0.299-0.149h0.168l0.131-0.075l0.13-0.038l0.168,0.131l0.112,0.131l0.037,0.205l0.188,0.056l0.316-0.056l0.188-0.093l0.224-0.075l0.149,0.131l0.299-0.019l0.242-0.075l0.225-0.037l0.224,0.037     l0.187,0.075l0.112,0.056l0.149,0.206l0.149,0.056l0.261,0.019l0.131-0.206l-0.056-0.149l-0.243-0.205l0.057-0.206l0.261-0.224l0.188-0.261l0.317-0.187l0.111-0.112l0.057-0.13l0.336-0.075l0.187,0.037l0.205,0.056l0.112-0.131l0.522-0.056l0.519,0.005     l0.357,0.089l0.469,0.022l0.313-0.156l0.179-0.291l0.134-0.268l0.536,0.246l0.536-0.022l0.67-0.223l0.692,0.112l0.514-0.134l0.201,0.268l0.312,0.134l0.246,0.335l0.134,0.201l0.246,0.156l0.312,0.156v0.268l-0.312-0.022l-0.312,0.134l0.134,0.291l0.111,0.357     l0.269,0.29h0.647l0.156,0.112l0.514-0.067l0.38,0.022v0.312h0.402v0.357l0.224,0.268l0.089,0.246l-0.089,0.179l0.089,0.224l0.179,0.089l0.291,0.29l0.268-0.179l0.47-0.067l0.268,0.067l0.469,0.291l0.201-0.067l0.179,0.022l0.179,0.156l0.425-0.112l0.312-0.112     h0.269l0.536-0.134l0.357-0.067l0.111,0.156l0.268,0.179v0.134l0.201,0.179l0.022,0.134l0.402,0.044l0.179,0.179l0.224,0.112l0.29-0.134l0.045-0.157l0.224-0.067l0.29,0.268l0.425,0.067l0.469,0.112l0.268,0.112l0.357-0.067l0.201,0.179l0.291,0.089l0.469,0.022     l0.111,0.224l0.357,0.156h0.269l0.134-0.044l0.201-0.089l0.156,0.089l-0.089,0.111l-0.022,0.179l0.111,0.089l0.09,0.179l-0.045,0.224l-0.201,0.089l-0.156,0.067l-0.357,0.201l-0.312,0.044l0.223,0.246l0.269,0.089l0.29,0.044l-0.134,0.156h-0.312h-0.246     l-0.045,0.179l-0.044,0.224l0.156,0.067l0.179,0.067l0.044,0.134l0.045,0.179l0.09,0.201l0.066,0.067l-0.156,0.491l-0.156,0.291v0.156l-0.335,0.134l-0.805-0.157l-0.736,0.045h-0.269l-0.022,0.179l-0.223,0.179l-0.38,0.134l-0.357,0.022l-0.224,0.089l-0.09,0.514     v0.224l-0.021,0.112l-0.012,0.126l-0.779,0.104l-0.971,0.06l-0.511,0.405l-0.729,0.189l-1.135,0.075l-1.119,0.248l-0.502,0.318l-0.463,0.059l-0.453-0.316l-0.369,0.621l-0.31,0.188l-0.477,0.044l-0.438-0.057l-0.959,0.031l-0.5,0.16l0.641,0.287l1.957,1.004     l0.053,0.172l-0.093,0.188l0.163,0.244l0.562,0.042l0.511-0.13l0.675-0.146l1.052,0.013l0.439,0.114l-0.235,0.259l-0.106,0.245l-0.228,0.144l-0.578,0.116l-0.31,0.029l-0.591-0.157l-0.473,0.044l-0.71,0.489l-1.007,0.045l-0.538,0.188l-0.527,0.488l-0.269,0.101     l-0.786-0.07l-0.588-0.171l0.364-0.746l-0.096-0.416l-0.264-0.287l-0.854-0.286l-0.193-0.014l-0.629,0.016l-0.151,0.043l-0.16-0.187l0.887-0.505l0.644-0.261l0.772-0.188l0.221-0.116l-0.246-0.46l-0.435-0.071l-0.799,0.044l-1.015,0.045l-0.698-0.1l-0.195-0.101     l-0.418-0.432l0.584-0.405l-0.528-0.605l-0.378,0.361l-0.541,0.001l-1.001,0.146l-0.565,0.131l-0.694,0.722l-1.003,0.867l-0.754,0.203l-0.223,0.044l-0.287,0.504l0.079,0.158l0.178,0.093l-0.706-0.131l-0.665,0.261h-0.457l-0.033,0.189l-0.609-0.047l-0.398-0.166     l-0.119-0.249l-0.15,0.02l0.055-0.077l0.102-0.025l0.126,0.013l0.113,0.013h0.189l0.088-0.114v-0.088l-0.063-0.113l0.025-0.113l0.126-0.063l0.051-0.063l0.075-0.013l0.089-0.025l0.088-0.063l0.089-0.088l0.024-0.126l-0.013-0.114l0.14-0.013l0.29-0.063     l0.075-0.076l-0.025-0.088l-0.062-0.088l0.126-0.114l0.037-0.063l-0.012-0.088l-0.114-0.113l0.051-0.101l-0.088-0.151l-0.063-0.101l0.202-0.151l0.239-0.025l0.126-0.088l0.113,0.025l0.013,0.088l-0.013,0.214l0.063,0.013h0.113V96.92l-0.013-0.063l0.101,0.038     l0.063,0.051l0.025-0.076l0.075-0.038l0.139-0.012v0.075l0.089,0.063h0.075l0.126,0.164l0.076-0.076l0.075-0.076l0.013-0.05l0.101-0.025h0.177l-0.037,0.189l0.176,0.025l0.038-0.038l0.038-0.038l0.139,0.013h0.227l0.038-0.025l0.075-0.076l-0.126-0.013     l-0.164-0.126l-0.101-0.051l-0.075-0.05l0.013-0.038l0.101-0.063l-0.025-0.113l0.038-0.101l-0.013-0.126l-0.051-0.139l-0.101-0.063l-0.177-0.076h-0.075l-0.151-0.126l-0.151-0.063l-0.151-0.038l0.051-0.151l0.037-0.088l-0.037-0.051l-0.127,0.038l-0.062-0.114     l0.113-0.038l-0.013-0.189l0.089-0.075l-0.025-0.101l-0.038-0.088h-0.113l-0.102,0.05l-0.088,0.051l-0.113-0.088l-0.089-0.101l-0.188-0.101l-0.139-0.025l-0.102-0.139l-0.05-0.139l0.177-0.139v-0.189l0.024-0.114l0.051-0.05l-0.126-0.063l0.164-0.151l-0.113-0.025     l-0.076-0.063l-0.062-0.126l-0.14-0.013l-0.062,0.101l-0.126-0.025l-0.215-0.025l-0.126-0.189l-0.05-0.189l-0.417-0.075l-0.277,0.012l-0.062,0.051l-0.076,0.101l-0.062-0.05v-0.076l-0.089-0.025l-0.101,0.038l0.038-0.05l0.088-0.101l-0.025-0.063h-0.113     l-0.177,0.038l-0.126-0.025l-0.101,0.013l-0.076-0.076l-0.05-0.063l-0.101-0.063l-0.151-0.013l-0.139-0.05l-0.14-0.126l-0.214-0.088l-0.038-0.013l-0.126,0.025l-0.05,0.025l-0.114-0.051l-0.088-0.025l-0.139,0.025l-0.177,0.051l-0.177-0.025l-0.062,0.038     l-0.126,0.114h-0.202l-0.265-0.038l-0.126,0.051l-0.315-0.114l-0.088,0.101l0.012,0.113h-0.126l-0.075-0.063l-0.126,0.114l-0.06,0.052l-0.634,0.08l-0.151,0.311l-0.278,0.178l-1.992,0.191l-0.186,0.215l-0.243,0.119l-0.339,0.06l-0.188-0.227l-0.327,0.004     l-0.025-0.231l-0.363,0.045l-1.115-0.066l-0.958-0.193l-0.241,0.107l-0.787-0.121l-0.136,0.085l-0.678-0.387l-0.554-0.2l-0.668-0.301l-0.166,0.015l1.047-1.471l0.653,0.018l-0.349-0.383l-0.044-0.552l0.082-0.306l1.509-1.218l0.599-0.398l0.286-0.181l0.429-0.013     l0.255-0.24l0.009-0.314l-0.328-0.302l0.085-0.133l0.298-0.048l-0.316-0.193l-0.816-0.835l0.074-0.242l-0.161-0.175z'},
	MN => {name => 'Mongolia',
		d => 'M660.044,89.132l-0.295,0.31l-0.687,1.207l-1.224,1.959l-0.381,0.58l0.269,0.836l0.051,0.029l0.342-0.045l0.929-0.395l0.754-0.062l0.576-0.018l0.317,0.085l0.431,0.416l0.292,0.07l1.191-0.786l0.438-0.002l0.928,0.212l0.538,0.199l0.797,0.5     l0.879,0.99l0.599,0.501l0.048,0.273l-0.107,0.217l-0.414,0.218l-0.464-0.127l-1.074-0.008l-0.432-0.099l-0.854,0.033l-0.937,0.221l-0.539,0.146l-0.831,0.278l-0.353,0.189l-0.483-0.127l-0.464,0.045l-0.47,0.204l-0.363,0.333l-0.312,0.82l-0.241,0.216     l-0.347,0.188l-0.638,0.248l-0.896,0.134l-0.624-0.054l-0.438-0.012l-0.224-0.013l-1.192,0.91l-0.742,0.433l-0.744,0.047l-0.982,0.005l-0.592-0.125l-0.668-0.382l-0.718-0.154l-0.316,0.073l-0.457,0.231l-0.539,0.589l-0.214,0.401l0.003,0.343l0.389,0.569     l0.599,0.411l0.188,0.228l-0.123,0.271l-0.326,0.259l-1.265,0.292l-0.67,0.389l-1.111,1.046l-0.265,0.172l-1.941,0.737l-0.651,0.061l-0.987-0.08l-1.514,0.065l-1.339,0.007l-1.204,0.349l-0.816,0.289l-0.736,0.274l-0.303,0.101l-1.44,0.534l-0.686,0.289     l-0.481,0.017l-0.433-0.197l-0.253-0.297l-0.61-0.067l-0.663,0.061l-0.929-0.123l-1.599-0.433l-1.006-0.365l-0.815-0.551l-0.521-0.168l-1.69-0.119l-1.164-0.022l-0.937-0.023l-2.861,0.059l-1.165-0.022l-0.802-0.109l-1.241-0.207l-1.979-0.018l-0.444-0.254     l-0.467-0.439l-1.571-2.161l-0.105-0.542l-0.744-0.096l-0.839-0.31l-1.645-0.806l-0.632-0.268l-0.998-0.224l-0.668-0.083l-0.995-0.038l-1.505-0.021l-1.062-0.181l-0.724-0.312l-0.233-0.229l-0.105-0.43l0.035-0.129l0.369-0.347l0.214-0.389l0.237-0.75l0.215-0.447     l-0.401-0.66l-1.07-1.451l-0.568-0.618l-0.354-0.143l-0.633-0.144l-0.731-0.167l-0.614-0.069l-0.834-0.415l-1.301-0.745l-0.371-0.433l-0.24-0.563l-0.131-0.405l-0.062-0.145l0.154-0.044l0.799-0.425l0.599-0.207l1.387-0.08l0.603-0.148l0.727-0.381l0.017-0.012     l0.971-0.692l0.787-0.398l1.143-0.341l1.512-0.476l0.84-0.18l0.953,0.097l0.932,0.156l1.842,0.122l0.831,0.083l0.694,0.755l0.393,0.406l0.699,0.113l1.458-0.008l0.719,0.083l0.85-0.004l0.875,0.068l0.312,0.114l0.576,0.186l0.562-0.018l0.755-0.28l0.31-0.162     l0.744-0.572l0.163-0.526l-0.116-0.204l-0.396-0.304l-0.409-0.86l0.098-0.293l0.905-0.839l1.269-0.96l0.84,0.201l1.028,0.098l1.036,0.185l1.748,0.328l0.702,0.231l0.989,0.317l0.767,0.143l0.145,0.204l0.004,0.541l0.182,0.481l0.408,0.451l0.421,0.333l1.643,0.531     l0.673,0.113l2.48-0.538l0.796-0.077l1.172,0.037l1.423,0.022l0.769,0.229l1.333,0.75l0.623,0.331l1.132,0.313l0.812,0.373l1.318,0.254l0.905,0.241l0.984,0.082l0.739,0.039l1.602-0.11l1.018-0.063l0.532-0.075l0.867-0.106l1.147-0.136l0.526-0.163l0.604-0.264     l0.447-0.394l0.755-0.498l1.165-0.487l0.333-0.002l0.609-0.047l0.74,0.156l0.751,0.506l0.34,0.129l0.86,0.169l1.228-0.297l0.622-0.018l0.431,0.168z'},
	BE => {name => 'Belgium',
		d => 'M406.183,86.551l1.051-0.494l0.485-0.089l0.574,0.087l0.465-0.016l0.209-0.147l0.477,0.098l0.407,0.042l0.52-0.034l-0.025-0.157l0.307,0.012h0.307l0.267-0.182l0.313,0.242l0.173-0.121l0.228,0.061l0.292,0.375l0.535-0.109l0.754,0.375     l-0.11,0.423l-0.172,0.097l0.001,0.338l0.672-0.024l0.344,0.177l0.282,0.365l0.038,0.468l-0.422,0.376l-0.225-0.072l-0.142,0.08l-0.245,0.147l-0.213,0.322l0.017,0.327l0.31,0.204l-0.136,0.348l-0.079-0.114l-0.694,0.174l-0.127-0.228l-0.371-0.204l-0.341-0.192     l-0.529-0.048l0.039-0.228l-0.146-0.18l0.119-0.373l-0.245,0.072l-0.193,0.313l-0.446,0.035l-0.406,0.075l-0.285-0.122l0.072-0.198l-0.091-0.175l0.159-0.241l-0.375-0.168l-0.576-0.048l-0.259,0.012l-0.159-0.301l-0.518,0.012l-0.194-0.133l-0.202-0.458     l-0.153-0.17l-0.41,0.208l-0.141,0.071l-0.266-0.127l-0.311-0.335l-0.208-0.447z'},
	SK => {name => 'Slovakia',
		d => 'M438.22,91.952l0.039-0.044l0.065-0.105l0.014-0.131l0.092-0.066l0.146-0.119l0.026-0.04l0.171-0.053l0.093-0.026l0.092,0.053l0.132,0.053h0.158l0.065-0.026h0.093l0.065,0.026l0.065,0.026l0.093-0.026l0.145-0.04h0.132l0.118-0.053     l0.079-0.053l0.066-0.026l0.105-0.026h0.039l0.053-0.079l0.04-0.092l0.079-0.079l0.092,0.026l0.105-0.04l0.145-0.066l0.053-0.105l0.053-0.079l0.026-0.132l0.026-0.092l0.053-0.092l0.118-0.013l0.105-0.013l0.132-0.079l0.119-0.053l0.118-0.092l0.053-0.079     l0.132-0.066l0.065-0.04L442,89.998l0.145,0.013l0.105,0.026l0.066-0.04l0.065-0.066l0.071,0.012l0.285,0.041l0.03,0.228l0.43-0.048l0.183-0.24l0.193,0.016l0.062-0.112l0.261-0.024l0.194,0.24l0.073,0.169l0.331-0.025l0.066,0.18l-0.026,0.083l0.003,0.204     l0.389-0.083l0.18,0.12l0.149-0.135l0.104-0.177l0.558-0.204l0.168,0.056l0.483-0.046l0.46,0.254l0.373-0.18l0.073-0.137l0.508,0.041l0.561-0.076l0.129,0.13l0.703,0.186l0.104,0.216l0.424,0.101l0.831,0.33l-1.047,1.471l-0.629,0.076l-0.437-0.143l-0.534-0.359     l-1.062,0.035l-0.717,0.047l-1.024,0.759L444.857,93l-0.59-0.072l-0.499,0.061l-0.761,0.134l-0.255,0.001l-0.334,0.568l-1.651-0.036l-0.414-0.027l-0.617-0.17l-0.399-0.172l-0.245,0.146l-0.761-0.547l-0.155-0.26l0.097-0.581l-0.053-0.093z'},
	HU => {name => 'Hungary',
		d => 'M442.391,98.111l-0.589,0.203l-0.433,0.031l-0.668,0.047l-0.58-0.098l-1.116-0.671l-1.412-0.612l-0.215-0.197l-0.364-0.333l-0.304-0.59l0.346-0.299l0.154-0.294l-0.204-0.188l0.04-0.375l0.409-0.062l0.157-0.206l-0.136-0.196l-0.452-0.063     l0.223-0.197h0.325l0.164,0.134l0.701-0.054l0.019-0.367l0.636-0.291l0.245-0.146l0.399,0.172l0.617,0.17l0.414,0.027l1.651,0.036l0.334-0.568l0.255-0.001l0.761-0.134l0.499-0.061l0.59,0.072l0.427-0.063l1.024-0.759l0.717-0.047l1.062-0.035l0.534,0.359     l0.437,0.143l0.629-0.076l0.166-0.015l0.668,0.301l0.554,0.2l0.678,0.387l-0.45,0.338l-1.125,0.267l-0.581,0.408l-0.968,1.451l-0.63,0.84l-0.753,0.567l-0.361,0.16l-0.724,0.047l-0.264,0.103l-0.176-0.002l-0.907-0.067l-0.889,0.077l-1.535,0.529z'},
	MD => {name => 'Moldova',
		d => 'M459.717,92.836l0.06-0.052l0.126-0.114l0.075,0.063h0.126l-0.012-0.113l0.088-0.101l0.315,0.114l0.126-0.051l0.265,0.038h0.202l0.126-0.114l0.062-0.038l0.177,0.025l0.177-0.051l0.139-0.025l0.088,0.025l0.114,0.051l0.05-0.025l0.126-0.025     l0.038,0.013l0.214,0.088l0.14,0.126l0.139,0.05l0.151,0.013l0.101,0.063l0.05,0.063l0.076,0.076l0.101-0.013l0.126,0.025l0.177-0.038h0.113l0.025,0.063l-0.088,0.101l-0.038,0.05l0.101-0.038l0.089,0.025v0.076l0.062,0.05l0.076-0.101l0.062-0.051l0.277-0.012     l0.417,0.075l0.05,0.189l0.126,0.189l0.215,0.025l0.126,0.025l0.062-0.101l0.14,0.013l0.062,0.126l0.076,0.063l0.113,0.025l-0.164,0.151l0.126,0.063l-0.051,0.05l-0.024,0.114v0.189l-0.177,0.139l0.05,0.139l0.102,0.139l0.139,0.025l0.188,0.101l0.089,0.101     l0.113,0.088l0.088-0.051l0.102-0.05h0.113l0.038,0.088l0.025,0.101l-0.089,0.075l0.013,0.189l-0.113,0.038l0.062,0.114l0.127-0.038l0.037,0.051l-0.037,0.088l-0.051,0.151l0.151,0.038l0.151,0.063l0.151,0.126h0.075l0.177,0.076l0.101,0.063l0.051,0.139     l0.013,0.126l-0.038,0.101l0.025,0.113l-0.101,0.063l-0.013,0.038l0.075,0.05l0.101,0.051l0.164,0.126l0.126,0.013l-0.075,0.076l-0.038,0.025h-0.227l-0.139-0.013l-0.038,0.038l-0.038,0.038l-0.176-0.025l0.037-0.189h-0.177l-0.101,0.025l-0.013,0.05l-0.075,0.076     l-0.076,0.076l-0.126-0.164h-0.075l-0.089-0.063v-0.075l-0.139,0.012l-0.075,0.038l-0.025,0.076l-0.063-0.051l-0.101-0.038l0.013,0.063v0.088h-0.113l-0.063-0.013l0.013-0.214l-0.013-0.088l-0.113-0.025l-0.126,0.088l-0.239,0.025l-0.202,0.151l0.063,0.101     l0.088,0.151l-0.051,0.101l0.114,0.113l0.012,0.088l-0.037,0.063l-0.126,0.114l0.062,0.088l0.025,0.088l-0.075,0.076l-0.29,0.063l-0.14,0.013l0.013,0.114l-0.024,0.126l-0.089,0.088l-0.088,0.063l-0.089,0.025l-0.075,0.013l-0.051,0.063l-0.126,0.063l-0.025,0.113     l0.063,0.113v0.088l-0.088,0.114h-0.189l-0.113-0.013l-0.126-0.013l-0.102,0.025l-0.055,0.077l-0.03,0.004l-0.062-0.237l-0.218-0.106l0.16-0.071l-0.021-0.267l-0.104-0.561l0.323-0.978l0.027-0.404l-0.353-0.856l-0.604-0.286l-1.037-1.119L460.567,93l-0.626-0.191     l-0.225,0.028z'},
	RO => {name => 'Romania',
		d => 'M445.722,97.573l0.176,0.002l0.264-0.103l0.724-0.047l0.361-0.16l0.753-0.567l0.63-0.84l0.968-1.451l0.581-0.408l1.125-0.267l0.45-0.338l0.136-0.085l0.787,0.121l0.241-0.107l0.958,0.193l1.115,0.066l0.363-0.045l0.025,0.231l0.327-0.004     l0.188,0.227l0.339-0.06l0.243-0.119l0.186-0.215l1.992-0.191l0.278-0.178l0.151-0.311l0.634-0.08l0.225-0.028L460.567,93l0.767,1.17l1.037,1.119l0.604,0.286l0.353,0.856l-0.027,0.404l-0.323,0.978l0.104,0.561l0.021,0.267l-0.16,0.071l0.218,0.106l0.062,0.237     l0.03-0.004l0.15-0.02l0.119,0.249l0.398,0.166l0.609,0.047l0.033-0.189h0.457l0.665-0.261l0.706,0.131l0.149,0.079l0.062,0.259l-0.293,0.446l-0.27,0.316l-0.436,0.044l-0.382,0.043l-0.382,0.245l-0.515,0.617l-0.252,0.645l-0.096,0.787l-0.044,0.223l-0.671-0.12     l-1.346-0.336l-0.514-0.226l-0.295-0.042l-0.671-0.369l-0.562-0.04l-0.618,0.218l-1.904,0.771l-0.38,0.059l-1.385-0.35l-0.3-0.013l-0.69,0.261l-0.34,0.031l-1.151-0.395l-0.506-0.002l-0.771,0.189l-0.266,0.023l-0.048-0.189l0.234-0.318l-0.352-0.106l-0.392-0.204     l-0.418-0.186l-0.146-0.33l0.32-0.201l0.351,0.012l-0.114-0.13l-0.625-0.248l-0.253,0.13l-0.215,0.283l-0.147,0.118l-0.414-0.239l-0.194-0.139l-0.594-0.059l-0.02-0.189h-0.234l-0.245-0.036l-0.052-0.165l0.178-0.094l0.271-0.071l-0.239-0.083l-0.183-0.059     l0.124-0.146l0.19-0.127l-0.069-0.142l-0.306-0.118l-0.555-0.141l-0.712-0.471l0.058-0.088l-0.104-0.119l0.075-0.356l-0.202-0.036l-0.19-0.237l-0.569-0.178l-0.054-0.309z'},
	IT => {name => 'Italy',
		d => 'M420.177,113.472l-0.274-0.042l-0.253-0.155l-0.367-0.325l-0.096-0.213l0.202-0.738l0.097-0.681l-0.046-0.583l-0.133-0.569l-0.503-0.44l-0.094-0.271l0.181-0.157l0.366-0.015l0.801-0.001l0.339-0.172l0.861-0.543l0.633,0.625l0.451,0.754     l-0.014,0.271l-0.204,0.285l-0.145,0.484l0.149,0.894l-0.11,0.525l-0.377,0.695l-0.405-0.198l-0.52,0.03l-0.143,0.1l-0.149,0.27l-0.248,0.17z M433.783,118.446l-0.712-0.084l-0.902-0.607l-0.772-0.239l-1.904-0.817l-0.833-0.126l-0.232-0.127l-0.173-0.283     l0.139-0.34l0.328-0.34l0.264-0.1l0.629,0.112l0.569-0.341l0.68,0.424l0.403,0.141l0.722-0.016l1.403-0.187l1.38-0.329l0.148,0.085l0.043,0.127l-0.112,0.127l-0.536,0.823l-0.153,0.497l0.009,0.382l0.411,0.509l-0.179,0.128l-0.43,0.567l-0.188,0.015z      M431.244,98.829l-0.281-0.329l-0.242-0.027l-0.281,0.196l-0.156-0.125l-0.47-0.071l-0.114,0.32l-0.458,0.054l-1.001,0.364l0.078-0.151l-0.452,0.133l-0.063,0.249l-0.157,0.044l-0.01,0.125l0.303,0.08l0.021,0.302l0.193,0.119l0.253,0.236l-0.104,0.213     l-0.449,0.254l0.016,0.272l0.143,0.554l0.783,0.814l2.008,0.889l0.29,0.357l0.134,0.558l0.274,0.557l0.395,0.585l0.694,0.57l0.254,0.274l0.446,0.195l0.041,0.21l0.408,0.167l1.17,0.255l1.254-0.105l0.388,0.141l0.024,0.212l-0.465,0.247l-0.258,0.294l0.262,0.213     l0.954,0.283l1.168,0.411l0.829,0.366l1.589,0.739l0.058,0.185l0.719,0.458l0.31,0.475l-0.198,0.435l-0.152,0.337l-0.455-0.281l-0.318-0.167l-0.109-0.486l-0.263-0.17l-0.512-0.099l-0.483-0.009l-0.439-0.236l0.086-0.217l-0.353-0.065l-0.301,0.098l-0.232,0.262     l-0.259,0.399l-0.273,0.208l0.043,0.271l-0.197,0.303l-0.007,0.298l0.76,0.342l0.611,0.271l-0.093,0.314l0.03,0.432l0.133,0.142l-0.191,0.238l-0.659-0.024l-0.41,0.219l-0.202,0.228l0.11,0.595l-0.536,0.303l-0.617,0.866l-0.595,0.048l-0.167-0.071l-0.184-0.14     l-0.002-0.508l0.364-0.141l0.317-0.542l-0.236-0.184l0.361-0.249l0.361,0.074l0.133-0.17l-0.077-0.34l-0.211-0.181l-0.206-0.924l-0.367-0.516l-0.15-0.607l-0.201-0.352l-0.334,0.058l-0.187,0.171l-0.899-0.496l-0.286-0.065l0.208-0.291l-0.092-0.398l-0.461-0.34     l-0.909,0.247l0.034-0.109l0.322-0.194l-0.276-0.27l-0.29-0.003l-0.42,0.19l-0.242-0.512l-0.198-0.207l-0.124-0.228l-0.663-0.241l-0.505-0.027l-0.654-0.127l-0.745-0.355l-0.548-0.441l-0.959-0.612l-1.036-0.826l-0.872-0.384l-0.805-0.67l-0.566-0.856     l-0.434-1.043l-0.347-0.443l-0.505-0.457l-0.483-0.243l-1.188-0.341l-0.579-0.142l-0.5,0.044l-1.078,0.647l-0.46,0.359l-0.646,0.173l-0.303,0.043l0.146-0.469l-0.062-0.281l-0.849,0.07l-0.754-0.391l-0.193-0.442l0.315-0.371l0.175-0.01l-0.135-0.331l-0.616-0.191     l-0.352-0.358l0.437-0.186l0.183,0.111l0.541-0.353l0.199-0.272l-0.43-0.192l-0.025-0.292l-0.532-0.344l0.624-0.301l0.599,0.062l0.627-0.204l0.629,0.168l0.275-0.16l0.349-0.432l-0.103-0.212l0.777-0.404l0.016,0.415l0.534,0.363l0.311,0.071l-0.098,0.182     l0.385,0.312l0.285-0.151l0.018-0.535l0.425-0.384l-0.019-0.333l0.371-0.081l0.143,0.354l0.23,0.142l0.216-0.03l0.071-0.122l0.469-0.05l0.244,0.333l0.228-0.415l-0.244-0.131l0.081-0.273l0.283-0.091l0.176,0.162l0.315,0.051l0.038-0.192l-0.112-0.212l0.126-0.309     l0.631,0.171l0.597,0.034l0.329-0.411l0.366-0.096l0.183,0.083l0.445-0.11l0.301,0.103l0.856-0.227l0.023,0.363l0.318,0.096l0.32,0.391l1.311,0.247l0.894,0.082l0.478,0.112l0.116,0.199l-0.614,0.303l0.098,0.151l0.297,0.002l0.187,0.185l-0.367,0.285l0.336,0.089     l-0.127,0.361l0.36,0.11l0.284,0.198l-0.056,0.214z'},
	SI => {name => 'Slovenia',
		d => 'M430.73,96.731l1.04,0.065l0.179,0.107l0.612-0.009l0.287,0.152l0.646-0.5l0.566-0.107l0.85,0.08l0.298-0.196l0.89,0.116l-0.082-0.393l0.693-0.157l0.304,0.59l0.364,0.333l-0.035-0.009l-0.1-0.073l-0.145-0.036h-0.172l-0.145,0.009     l-0.055,0.063v0.072l0.019,0.09l0.009,0.082l-0.063,0.009l-0.136-0.009l-0.108-0.036l-0.091,0.063l-0.045,0.082l-0.081,0.063l-0.082,0.045l-0.081,0.009l-0.163,0.036l-0.117,0.036l-0.108,0.036l-0.055,0.045l-0.153-0.009l-0.127,0.072l-0.063,0.054l-0.018,0.082     l0.036,0.072l0.081,0.054l0.063,0.055l0.045,0.045l0.019,0.063l0.018,0.09l-0.036,0.108l-0.018,0.063l-0.046,0.1h-0.108l-0.081-0.009l-0.091,0.027l-0.108,0.009l-0.117,0.054l-0.091,0.018l-0.081,0.027l-0.1,0.045l-0.055,0.063l-0.036,0.027l0.055,0.018     l0.063,0.009l0.026,0.027l0.037,0.072l-0.046,0.063l-0.027,0.009l-0.081,0.027l-0.009,0.045l0.045,0.081v0.072l0.045,0.1l-0.054,0.072l-0.063-0.018l-0.1,0.045l-0.117,0.018l-0.127-0.036l-0.063-0.027l-0.1-0.063h-0.099l-0.063-0.027l-0.118-0.045l-0.018,0.045     l-0.027,0.045l-0.1,0.027h-0.136l-0.054-0.045l-0.072-0.063l-0.127-0.018l-0.019-0.09l-0.026-0.018l-0.063-0.054l-0.055-0.027l-0.018-0.054l-0.01-0.054l-0.036-0.009l-0.063,0.018l-0.036,0.054l-0.009,0.027l-0.054,0.063l-0.019,0.018l-0.018,0.081l-0.063,0.045     l-0.046,0.018l-0.062,0.054l-0.036,0.009h-0.254l-0.108-0.027l-0.108,0.027l-0.145,0.009l-0.1-0.009l-0.1-0.036l-0.045-0.019h-0.055v0.037v0.036l-0.045,0.027l-0.045,0.018l-0.136-0.009l-0.027-0.036l-0.108,0.018l-0.019,0.018l-0.136,0.018l-0.063,0.018     l-0.126,0.018l-0.272-0.063l0.428-0.077l0.113-0.16l0.056-0.214l-0.284-0.198l-0.36-0.11l0.127-0.361l-0.336-0.089l0.367-0.285l-0.187-0.185l-0.297-0.002l-0.098-0.151l0.614-0.303l-0.116-0.199z'},
	HR => {name => 'Croatia',
		d => 'M439.573,104.709l-1.051-0.672l-0.185-0.222l-0.783-0.149l-0.203-0.159l-0.403-0.115l-0.683,0.177l-0.326-0.486l-1.112-0.627l-0.584-0.678l0.277,0.007l0.608,0.016l-0.583-0.221l-0.659-0.469l-0.183-0.407l0.086-0.452l-0.289-0.336     l-0.646-0.418l-0.378-0.126l-0.258,0.579l-0.142,0.116l0.03,0.15l-0.284,0.106l-0.154,0.248l-0.213,0.053l-0.496-0.647l-0.063-0.286l-0.259-0.612l0.065-0.012l0.272,0.063l0.126-0.018l0.063-0.018l0.136-0.018l0.019-0.018l0.108-0.018l0.027,0.036l0.136,0.009     l0.045-0.018l0.045-0.027v-0.036v-0.037h0.055l0.045,0.019l0.1,0.036l0.1,0.009l0.145-0.009l0.108-0.027l0.108,0.027h0.254l0.036-0.009l0.062-0.054l0.046-0.018l0.063-0.045l0.018-0.081l0.019-0.018l0.054-0.063l0.009-0.027l0.036-0.054l0.063-0.018l0.036,0.009     l0.01,0.054l0.018,0.054l0.055,0.027l0.063,0.054l0.026,0.018l0.019,0.09l0.127,0.018l0.072,0.063l0.054,0.045h0.136l0.1-0.027l0.027-0.045l0.018-0.045l0.118,0.045l0.063,0.027h0.099l0.1,0.063l0.063,0.027l0.127,0.036l0.117-0.018l0.1-0.045l0.063,0.018     l0.054-0.072l-0.045-0.1v-0.072l-0.045-0.081l0.009-0.045l0.081-0.027l0.027-0.009l0.046-0.063l-0.037-0.072l-0.026-0.027l-0.063-0.009l-0.055-0.018l0.036-0.027l0.055-0.063l0.1-0.045l0.081-0.027l0.091-0.018l0.117-0.054l0.108-0.009l0.091-0.027l0.081,0.009     h0.108l0.046-0.1l0.018-0.063l0.036-0.108l-0.018-0.09l-0.019-0.063l-0.045-0.045l-0.063-0.055l-0.081-0.054l-0.036-0.072l0.018-0.082l0.063-0.054l0.127-0.072l0.153,0.009l0.055-0.045l0.108-0.036l0.117-0.036l0.163-0.036l0.081-0.009l0.082-0.045l0.081-0.063     l0.045-0.082l0.091-0.063l0.108,0.036l0.136,0.009l0.063-0.009l-0.009-0.082l-0.019-0.09v-0.072l0.055-0.063l0.145-0.009h0.172l0.145,0.036l0.1,0.073l0.035,0.009l0.215,0.197l1.412,0.612l1.116,0.671l0.58,0.098l0.668-0.047l0.433-0.031l0.589-0.203l0.201,0.142     l0.056,0.089l0.022,0.112l-0.022,0.078l0.045,0.044l0.011,0.067l-0.078,0.056l-0.011,0.146l0.078,0.067l0.145-0.034l0.101,0.034l0.045,0.089l-0.078,0.011l-0.056-0.022l-0.022,0.078l0.033,0.1l-0.045,0.034l-0.044,0.022l0.066,0.111l0.168-0.022l0.033,0.078     l0.123,0.1h0.122h0.101l0.09,0.078l0.122,0.011h0.134l0.012,0.078l-0.033,0.056l-0.135-0.011l-0.089-0.034l-0.067,0.022l-0.078-0.011l-0.066-0.045l-0.056-0.011l-0.045,0.011l0.033,0.067l-0.101,0.089h-0.078v0.156l0.045,0.067l-0.033,0.078l0.022,0.078     l0.011,0.078l-0.089,0.033l-0.09-0.033l-0.056,0.067l0.078,0.089l-0.078,0.011l-0.189,0.022l-0.201-0.022l-0.145-0.123l0.056-0.101l-0.045-0.089l-0.123-0.011l-0.022-0.112l-0.145-0.056l-0.146-0.045l-0.101,0.089l-0.1-0.011l-0.156-0.078l-0.067-0.022h-0.146     l-0.156-0.045l-0.111,0.067l-0.134,0.045l-0.134-0.045l-0.111-0.067h-0.112l-0.122,0.089l-0.168,0.078l-0.156-0.067l-0.268-0.089l-0.179,0.011l-0.156,0.011l-0.189-0.056l-0.168-0.011l-0.156-0.089l-0.089,0.078l-0.111,0.022l-0.057-0.056l-0.234-0.078     l-0.156-0.056l-0.134-0.045l-0.089-0.011l-0.134,0.123l-0.112-0.011l-0.223-0.022l-0.168-0.033l-0.212,0.022l-0.101,0.111l-0.145,0.145l-0.123,0.201l-0.201-0.022l-0.256-0.134l-0.156-0.19l-0.101-0.111l-0.312-0.034l-0.123,0.044l-0.089,0.179l-0.045,0.167     l0.045,0.134v0.078l0.033,0.212l-0.123,0.067l0.022,0.089l0.134,0.078l0.09,0.089l0.122,0.034l0.101,0.033l0.179,0.179l0.146,0.234l0.089,0.134l0.022,0.123l0.156,0.111l-0.078,0.056l-0.012,0.1l0.022,0.146l0.168-0.011l0.089,0.111l0.056,0.123l0.112,0.111     l0.167,0.045l0.167,0.033l0.369,0.357l0.021,0.167l0.078,0.044l0.213,0.078l0.379,0.357l0.224,0.123l0.223,0.067l0.101,0.056v0.112l0.078,0.279l0.201,0.078l0.189,0.167l0.146,0.112l0.245,0.123l0.067,0.212l-0.284,0.083z M439.792,104.833l0.132-0.118     l0.134,0.011l0.123,0.034l0.045,0.078l0.066,0.089l0.146,0.089l0.179,0.078l0.212,0.011l0.312,0.257l0.045,0.067l0.134-0.033l0.123,0.022l0.089,0.034l0.062,0.063l0.005,0.004l-0.022,0.089l0.033,0.078l0.082,0.072l0.029,0.092l-0.002,0.1l-0.589-0.367     l-0.549-0.371l-0.789-0.378z'},
	CS => {name => 'Serbia',
		d => 'M451.009,101.725l-0.328,0.346l-0.383,0.374l-0.18,0.302l0.056,0.271l1.326,1.122l0.028,0.2l-0.302,0.302l-0.762,0.333l-0.246,0.301l-0.008,0.514l-0.013,0.208l-0.058-0.017l-0.072,0.029l-0.16,0.022l-0.145,0.021l-0.116,0.022l-0.058,0.015     l-0.102-0.051l-0.087,0.043l-0.088,0.021l-0.102-0.043l-0.064-0.021l-0.131,0.116l-0.087,0.08l-0.152-0.015l-0.196-0.007l-0.064,0.007l-0.175-0.043l-0.152,0.087l-0.151,0.102l-0.109,0.058l0.059,0.072l-0.029,0.058h-0.116l-0.094-0.109l-0.131-0.058l-0.087-0.073     l-0.08,0.065l-0.116,0.058l-0.246,0.058l-0.225,0.058l-0.088,0.058l-0.058,0.167l0.029,0.13l-0.029,0.072l-0.072,0.087h-0.188l-0.14-0.049l-0.018-0.109l-0.733-0.866l-0.382-0.369l-0.058-0.004l0.109-0.286v-0.067l-0.078-0.067h-0.101l-0.056-0.056l0.022-0.089     l0.111-0.033l0.146,0.011l0.167,0.033l0.057-0.033l0.021-0.067l0.09-0.044l0.134-0.022l0.089-0.011l-0.011-0.089l-0.101-0.101l-0.167-0.067l-0.134-0.045l-0.057-0.044l-0.111,0.022l-0.078-0.045l-0.033-0.067l-0.123-0.101l-0.078-0.1l-0.066-0.022l-0.067,0.044     l-0.078-0.011l-0.101-0.056l-0.279-0.078l-0.078-0.022l-0.056-0.033l-0.167-0.134l-0.101-0.146l-0.111-0.111l-0.168-0.078l-0.156-0.101l-0.223-0.056v-0.101l0.179-0.101l0.089-0.111l0.078-0.011l0.067,0.034l0.078,0.044l0.1,0.022l0.045-0.022l0.012-0.134     l0.011-0.19l-0.134-0.145l-0.179-0.19l-0.212-0.134l-0.101-0.145l0.101,0.022l0.101,0.011l0.145,0.056l0.224,0.044l0.134-0.078l0.089-0.056l0.067-0.078l-0.089-0.044l-0.135-0.022l-0.089-0.089l-0.123-0.078l-0.156-0.089l-0.033-0.101l-0.045-0.1l-0.212,0.011     l-0.167-0.056l-0.078-0.1l-0.022-0.134l0.078-0.067v-0.089l-0.033-0.1l0.056-0.056l0.066-0.078l0.156-0.156l0.156-0.223l0.034-0.167l0.056-0.1l-0.022-0.067l-0.123-0.022l-0.179-0.011h-0.156l-0.212,0.112l-0.078-0.089l0.056-0.067l0.09,0.033l0.089-0.033     l-0.011-0.078l-0.022-0.078l0.033-0.078l-0.045-0.067v-0.156h0.078l0.101-0.089l-0.033-0.067l0.045-0.011l0.056,0.011l0.066,0.045l0.078,0.011l0.067-0.022l0.089,0.034l0.135,0.011l0.033-0.056l-0.012-0.078h-0.134l-0.122-0.011l-0.09-0.078h-0.101h-0.122     l-0.123-0.1l-0.033-0.078l-0.168,0.022l-0.066-0.111l0.044-0.022l0.045-0.034l-0.033-0.1l0.022-0.078l0.056,0.022l0.078-0.011l-0.045-0.089l-0.101-0.034l-0.145,0.034l-0.078-0.067l0.011-0.146l0.078-0.056l-0.011-0.067l-0.045-0.044l0.022-0.078l-0.022-0.112     l-0.056-0.089l-0.201-0.142l1.535-0.529l0.889-0.077l0.907,0.067l0.054,0.309l0.569,0.178l0.19,0.237l0.202,0.036l-0.075,0.356l0.104,0.119l-0.058,0.088l0.712,0.471l0.555,0.141l0.306,0.118l0.069,0.142l-0.19,0.127l-0.124,0.146l0.183,0.059l0.239,0.083     l-0.271,0.071l-0.178,0.094l0.052,0.165l0.245,0.036h0.234l0.02,0.189l0.594,0.059l0.194,0.139l0.414,0.239l0.147-0.118l0.215-0.283l0.253-0.13l0.625,0.248l0.114,0.13l-0.351-0.012l-0.32,0.201l0.146,0.33l0.418,0.186zM443.617,107.095l-0.065-0.035l-0.435-0.156l-0.017-0.15l-0.501-0.485l-0.848-0.3l-0.033-0.021l0.002-0.1l-0.029-0.092l-0.082-0.072l-0.033-0.078l0.022-0.089l-0.005-0.004l0.183-0.108l0.09-0.089l-0.045-0.101l-0.078-0.089l-0.066-0.112     l-0.012-0.044l-0.011-0.145l-0.012-0.112l0.012-0.134l0.101-0.089l0.111-0.022l0.134-0.011l0.056-0.056l-0.011-0.1l-0.034-0.089l0.112-0.101l0.044-0.089l0.045-0.101l0.168-0.078l0.122-0.056l0.123,0.011l0.056,0.044l0.056,0.089l0.09,0.056h0.111l0.056-0.101     l-0.056-0.101l-0.123-0.167l-0.089-0.1l-0.012-0.078l0.078-0.056l0.112-0.033l0.066,0.044l0.112,0.022l0.156-0.056l0.056,0.033v0.101l0.223,0.056l0.156,0.101l0.168,0.078l0.111,0.111l0.101,0.146l0.167,0.134l0.056,0.033l0.078,0.022l0.279,0.078l0.101,0.056     l0.078,0.011l0.067-0.044l0.066,0.022l0.078,0.1l0.123,0.101l0.033,0.067l0.078,0.045l0.111-0.022l0.057,0.044l0.134,0.045l0.167,0.067l0.101,0.101l0.011,0.089l-0.089,0.011l-0.134,0.022l-0.09,0.044l-0.021,0.067l-0.057,0.033l-0.167-0.033l-0.146-0.011     l-0.111,0.033l-0.022,0.089l0.056,0.056h0.101l0.078,0.067v0.067l-0.109,0.286l-0.361-0.022l-0.727-0.11l-0.273,0.273l-0.279,0.515l0.133,0.427l-0.002,0.342z'},
	UZ => {name => 'Uzbekistan',
		d => 'M551.198,117.997l-0.351-0.48l-0.236-0.126l-1.217-0.05l-0.646-0.011l-0.096-0.016l0.091-0.726l-0.062-0.503l0.157-0.251l0.062-0.22l-0.503-0.094l-0.534-0.283l-0.566-0.189l-0.471,0.063l-0.378-0.251l-1.132-0.597l-0.565-0.22l-0.943-0.597     l-0.314,0.063l-1.006-0.503l-0.377-0.44l-1.194-0.597l-1.384-0.975v-0.283l-0.188-0.44l-0.283-0.188l-0.408-0.597l-0.126-0.566l-0.22-0.377l-0.881-0.251l-0.188,0.157l-0.439,0.063l-0.535-0.126l-0.439,0.032l-0.503,0.094l-0.314-0.157l-0.691-0.314l0.094-0.22     l0.157-0.188l-0.188-0.22l0.031-0.188l0.188-0.157l-0.439-0.283v-0.22l-0.032-0.22l-0.251-0.22l-0.534-0.094l-0.692-0.095l-0.22-0.314l-0.346-0.032l-0.629-0.377l-0.472-0.095l-0.188,0.063l-0.565,0.157l0.251,0.251l0.188,0.377l-0.597-0.283h-0.283l-0.126,0.126     l-0.22,0.346l-0.283,0.126h-0.629l-0.503,0.251l-0.503,0.409l-0.062,0.628l0.314,0.409l-0.126,0.314l-1.383,0.032l-1.03-0.063l0.056-8.174l5.658-1.289l5.722,2.986l2.012,1.666l2.578-0.346l2.767,0.188l1.1-0.409l0.724,0.723l0.597,0.22l0.66,1.006l0.66-0.314     l-0.031,1.038l-0.188,0.409l0.031,0.754h1.006l0.221,0.817l0.346,1.069l0.503,0.063l0.691-0.032l1.006-0.094h0.346l0.44,0.314l0.062,0.283l-0.062,0.283l0.44,0.346h0.66l0.125-0.188l-0.157-0.409l0.504-0.44l0.439-0.188l0.221-0.472l0.282-0.188l0.943-0.377     l0.755-0.189l0.534-0.471l0.346-0.283l0.22-0.063l0.283,0.126l0.377-0.377l0.322-0.031l0.349-0.126l0.441,0.246l-0.368,0.172l-0.368,0.171l-0.221,0.049l-0.073,0.196l-0.295,0.049l-0.294,0.172l-0.196,0.147l-0.441,0.295l-0.172,0.098l-0.024,0.123l0.294,0.049     l0.295,0.074l0.146,0.123l0.418-0.147l0.098,0.221l0.172,0.221l0.368,0.27h0.589h0.393l0.049-0.393l0.221,0.049l0.196-0.196l0.024-0.245l0.196,0.098l0.196,0.172l0.172,0.294l0.049,0.147l0.393,0.024l0.147-0.024l0.073,0.246l0.025,0.098l0.343-0.025l0.319,0.147     l0.245,0.196l0.516,0.074l0.466,0.024l0.172,0.123l-0.49,0.221l-0.197,0.147l-0.221,0.147l-0.49-0.024l-0.245-0.049l0.049,0.171v0.147h-0.319l-0.172,0.049l-0.343,0.196l-0.221,0.196l-0.271,0.049l-0.221,0.196l-0.245-0.147l-0.319-0.098l-0.294-0.098     l-0.221,0.025l-0.246,0.073l-0.318-0.073l-0.042,0.098l-0.345-0.005l-0.409,0.031l-0.188-0.283l-0.251-0.063l-0.126-0.188l0.251-0.126l0.409-0.346l0.188-0.22l-0.252-0.251l-0.439-0.377l-0.221,0.251l-0.471,0.346l-0.692,0.188l-0.22,0.157l-0.252-0.22     l-0.22-0.157h-0.346l0.031,0.22l-0.283,0.314l0.189,0.314l-0.032,0.346l-0.062,0.126l-0.472-0.095l-0.565,0.095l-0.503,0.094l0.251,0.125l0.534-0.031l0.126,0.094l-0.251,0.063l-0.188,0.063l-0.032,0.346h-0.188l-0.251,0.157l-0.063,0.409l-0.282,0.188     l-1.069-0.094l-0.629-0.126l-0.472,0.283l-0.125,0.471l0.251,0.283l0.346,0.188l0.157,0.157l0.44,0.032h0.346l0.126,0.22l-0.126,0.22l-0.031,0.472l0.126,0.409l0.471,0.314l0.126,0.283l-0.157,0.22l-0.503,0.346l-0.283,0.503l-0.377,0.377l0.063,0.377     l-0.375,0.843z'},
	BA => {name => 'Bosnia and Herzegovina',
		d => 'M439.792,104.833l-0.113-0.054l-0.105-0.07l0.284-0.083l-0.067-0.212l-0.245-0.123l-0.146-0.112l-0.189-0.167l-0.201-0.078l-0.078-0.279v-0.112l-0.101-0.056l-0.223-0.067l-0.224-0.123l-0.379-0.357l-0.213-0.078l-0.078-0.044l-0.021-0.167     l-0.369-0.357l-0.167-0.033l-0.167-0.045l-0.112-0.111l-0.056-0.123l-0.089-0.111l-0.168,0.011l-0.022-0.146l0.012-0.1l0.078-0.056l-0.156-0.111l-0.022-0.123l-0.089-0.134l-0.146-0.234l-0.179-0.179l-0.101-0.033l-0.122-0.034l-0.09-0.089l-0.134-0.078     l-0.022-0.089l0.123-0.067l-0.033-0.212v-0.078l-0.045-0.134l0.045-0.167l0.089-0.179l0.123-0.044l0.312,0.034l0.101,0.111l0.156,0.19l0.256,0.134l0.201,0.022l0.123-0.201l0.145-0.145l0.101-0.111l0.212-0.022l0.168,0.033l0.223,0.022l0.112,0.011l0.134-0.123     l0.089,0.011l0.134,0.045l0.156,0.056l0.234,0.078l0.057,0.056l0.111-0.022l0.089-0.078l0.156,0.089l0.168,0.011l0.189,0.056l0.156-0.011l0.179-0.011l0.268,0.089l0.156,0.067l0.168-0.078l0.122-0.089h0.112l0.111,0.067l0.134,0.045l0.134-0.045l0.111-0.067     l0.156,0.045h0.146l0.067,0.022l0.156,0.078l0.1,0.011l0.101-0.089l0.146,0.045l0.145,0.056l0.022,0.112l0.123,0.011l0.045,0.089l-0.056,0.101l0.145,0.123l0.201,0.022l0.189-0.022l0.078-0.011l0.212-0.112h0.156l0.179,0.011l0.123,0.022l0.022,0.067l-0.056,0.1     l-0.034,0.167l-0.156,0.223l-0.156,0.156l-0.066,0.078l-0.056,0.056l0.033,0.1v0.089l-0.078,0.067l0.022,0.134l0.078,0.1l0.167,0.056l0.212-0.011l0.045,0.1l0.033,0.101l0.156,0.089l0.123,0.078l0.089,0.089l0.135,0.022l0.089,0.044l-0.067,0.078l-0.089,0.056     l-0.134,0.078l-0.224-0.044l-0.145-0.056l-0.101-0.011l-0.101-0.022l0.101,0.145l0.212,0.134l0.179,0.19l0.134,0.145l-0.011,0.19l-0.012,0.134l-0.045,0.022l-0.1-0.022l-0.078-0.044l-0.067-0.034l-0.078,0.011l-0.089,0.111l-0.179,0.101l-0.056-0.033l-0.156,0.056     l-0.112-0.022l-0.066-0.044l-0.112,0.033l-0.078,0.056l0.012,0.078l0.089,0.1l0.123,0.167l0.056,0.101l-0.056,0.101h-0.111l-0.09-0.056l-0.056-0.089l-0.056-0.044l-0.123-0.011l-0.122,0.056l-0.168,0.078l-0.045,0.101l-0.044,0.089l-0.112,0.101l0.034,0.089     l0.011,0.1L442,104.458l-0.134,0.011l-0.111,0.022l-0.101,0.089l-0.012,0.134l0.012,0.112l0.011,0.145l0.012,0.044l0.066,0.112l0.078,0.089l0.045,0.101l-0.09,0.089l-0.183,0.108l-0.062-0.063l-0.089-0.034l-0.123-0.022l-0.134,0.033l-0.045-0.067l-0.312-0.257     l-0.212-0.011l-0.179-0.078l-0.146-0.089l-0.066-0.089l-0.045-0.078l-0.123-0.034l-0.134-0.011l-0.132,0.118z'},
	BG => {name => 'Bulgaria',
		d => 'M450.198,105.998l0.013-0.208l0.008-0.514l0.246-0.301l0.762-0.333l0.302-0.302l-0.028-0.2l-1.326-1.122l-0.056-0.271l0.18-0.302l0.383-0.374l0.328-0.346l0.392,0.204l0.352,0.106l-0.234,0.318l0.048,0.189l0.266-0.023l0.771-0.189     l0.506,0.002l1.151,0.395l0.34-0.031l0.69-0.261l0.3,0.013l1.385,0.35l0.38-0.059l1.904-0.771l0.618-0.218l0.562,0.04l0.671,0.369l0.295,0.042l0.514,0.226l1.346,0.336l0.671,0.12l-0.066,0.335l-0.077,0.258l-0.261,0.086l-0.313-0.028l-0.339,0.129l-0.327,0.73     l-0.039,0.586l-0.075,0.143l-0.404,0.115l-0.338,0.372l-0.017,0.257l0.252-0.036l0.255,0.224l0.033,0.154l0.391,0.375l0.01,0.223l-1.333-0.005l-0.527-0.111l-0.497,0.045l-0.629,0.374l-0.498,0.445l-0.363-0.026l-0.344,0.216l0.097,0.327l-0.086,0.257     l-1.117,0.277l-0.388,0.031l-0.619-0.21l-1.473-0.505l-0.584,0.06l-0.799,0.261l-1.855,0.195l-0.09,0.029l-0.047-0.199l0.104-0.3l0.006-0.499l-0.225-0.469l-0.358-0.383l-0.666-0.296l-0.134-0.213l0.007-0.106z'},
	ES => {name => 'Spain',
		d => 'M381.009,107l-0.121-0.278l0.138-0.4l0.343-0.5l-0.358-0.471l-0.304-0.428l-0.514-0.07l-0.164-0.1l-0.053-0.329l0.163-0.243l0.409-0.272l0.365-0.101l0.563-0.03l0.634-0.03l0.133-0.172l0.068-0.415l0.535-0.273l0.763,0.042l1.078,0.37     l0.763,0.07l0.756-0.087l0.577-0.173l0.508-0.144l0.354-0.001l0.629,0.285l0.694,0.156l0.939,0.084l1.538,0.04l0.583,0.027l0.957,0.141l0.491-0.158l0.419-0.229l0.531,0.027l0.891,0.47l0.67-0.016l0.335,0.062l0.472,0.243l0.469-0.03l0.058,0.122l-0.205,0.243     l0.094,0.106l0.15,0.03l0.112-0.106l1.088,0.334l0.15-0.061l0.507,0.395l0.056-0.076l0.262,0.03l0.131-0.076l0.431,0.152l0.028,0.038l0.084,0.114l0.767-0.03l0.037,0.122l0.337-0.061l0.542,0.015l-0.017-0.319h0.355l1.252,0.304l0.091,0.213l0.035,0.289     l0.187,0.076l0.374-0.076l0.206-0.03l0.335,0.091l0.036,0.152l0.261,0.015l0.395-0.167l0.427,0.197l0.485,0.015l0.039-0.136l0.75-0.137l0.334,0.091l-0.001,0.088l-0.001,0.463l0.156,0.1l-0.062,0.485l-1.112,0.528l-0.95,0.385l-0.267,0.328l-1.046,0.198     l-0.664,0.116l-0.96,0.301l-0.323,0.326l-0.053,0.2l0.261,0.128l-0.088,0.157l-0.628,0.143l-0.594,0.783l-0.886,0.787l-0.096,0.192l-0.18,0.361l-0.245,0.45l0.353,0.827l0.072,0.111l0.084,0.13l0.648,0.295l0.103,0.185l-0.621,0.327l-0.215,0.105l-0.515,0.252     l-0.286,0.479l-0.224,0.085l-0.461,0.926l0.155,0.322l-0.257,0.099l-0.992,0.049l-0.581,0.242l-0.425,0.327l-0.274,0.757l-0.663,0.496l-0.258-0.213l-0.599,0.028l-0.305,0.27h-0.342l-0.121-0.113l-3.282,0.042l-0.69,0.524l-1.021,0.17l-0.35,0.382l-0.028,0.283     l-0.083,0.085l-0.073-0.212l-0.068-0.014l0.005,0.241l-0.389,0.127l-0.421-0.142l-0.788-0.467l-0.224-0.382l0.036-0.262l-0.345-0.113l-0.125-0.213l0.175-0.163l-0.468-0.51l-0.702-0.284L385,117.498l-0.484-0.135l-0.586,0.039l0.008-0.018l0.304-0.951l0.242-0.37     l0.884-0.643l-0.408-0.31l-0.812-0.123l0.17-0.455l0.506-0.655l0.347-0.371l-0.163-0.198l-0.455-0.551l-0.488-0.494l0.288-0.129l0.482-0.045l0.458-0.229l0.043-0.199l-0.057-0.938l0.132-0.983l-0.072-0.456l0.051-0.442l0.084-0.072l1.234-0.506l0.288-0.216     l-0.062-0.242l-0.842-0.495l-0.15-0.242l-0.272-0.227l-0.335-0.055l-0.531,0.26L382.981,107l-0.531-0.439l-0.55,0.188L381.009,107z'},
	GE => {name => 'Georgia',
		d => 'M489.685,103.693l0.112-0.309l0.26-0.166l0.284,0.047l0.07,0.047l0.402,0.023l0.449,0.023l0.283,0.095l0.284,0.142l0.188,0.094l0.189,0.047h0.331h0.213l0.212,0.166l0.261,0.095l0.307,0.071l0.355,0.047h0.307l0.426-0.095h0.544l0.401,0.166     h0.189l0.283-0.047l0.354,0.166l0.095,0.142l0.284,0.213l0.52,0.118l0.354,0.071l0.236,0.118l0.308,0.119l-0.142,0.118l-0.048,0.118l0.261,0.118l0.212,0.071l0.261-0.118h0.283l0.166-0.166l0.094-0.095l0.213-0.071h0.354l0.261,0.071l0.188,0.142l0.142-0.166     l0.095-0.071h0.118l0.236,0.118l0.143,0.094h0.212l0.189,0.118l0.213,0.166h0.378l0.354,0.024l0.118,0.142l-0.118,0.189l-0.118,0.307l0.354,0.284l0.284,0.166l0.26,0.094l0.284,0.047l0.236-0.023l0.236,0.071l0.126,0.189l-0.268,0.189l-0.143,0.142l-0.095,0.071     l0.143,0.26l0.213,0.307l0.614,0.166l0.118,0.213l-0.095,0.331l-0.236,0.095l-0.236,0.047l-0.26-0.189l-0.143-0.071l-0.188-0.023l-0.284,0.047l-0.638-0.189l-0.189-0.213l-0.331-0.189l-0.473-0.024h-0.236l-0.418,0.308l-0.291,0.094l-0.378,0.047l-0.591,0.095     l-0.592-0.047l-0.401,0.118l-0.426,0.023l-0.308,0.095l-0.307-0.024l-0.377,0.108l-0.031-0.028l-1.326-1.018l-0.41-0.041l-0.761,0.36l-0.226,0.072l-0.491-0.068l-1.212-0.082l0.083-0.065l0.322-0.585l0.032-0.143l-0.064-0.728l-0.331-1.084l-0.206-0.399     l-0.639-0.513l-0.341-0.128l-0.916-0.155l-0.679-0.271l-0.341-0.243z'},
	KG => {name => 'Kyrgyzstan',
		d => 'M558.52,110.652l0.042-0.098l0.318,0.073l0.246-0.073l0.221-0.025l0.294,0.098l0.319,0.098l0.245,0.147l0.221-0.196l0.271-0.049l0.221-0.196l0.343-0.196l0.172-0.049h0.319v-0.147l-0.049-0.171l0.245,0.049l0.49,0.024l0.221-0.147     l0.197-0.147l0.49-0.221l-0.172-0.123l-0.466-0.024l-0.516-0.074l-0.245-0.196l-0.319-0.147l-0.343,0.025l-0.025-0.098l-0.073-0.246l-0.147,0.024l-0.393-0.024l-0.049-0.147l-0.172-0.294l-0.196-0.172l-0.196-0.098l-0.024,0.245l-0.196,0.196l-0.221-0.049     l-0.049,0.393h-0.393h-0.589l-0.368-0.27l-0.172-0.221l-0.098-0.221l-0.418,0.147l-0.146-0.123l-0.295-0.074l-0.294-0.049l0.024-0.123l0.172-0.098l0.441-0.295l0.196-0.147l0.294-0.172l0.295-0.049l0.073-0.196l0.221-0.049l0.368-0.171l0.368-0.172l-0.441-0.246     l-0.349,0.126l-0.044-0.273l0.393-0.442l0.318-0.368l0.736-0.123l0.663-0.098l0.883,0.147l0.883,0.245l0.688,0.196l0.81,0.123l0.344,0.123l-0.024-0.442l0.245-0.736l0.466-0.368l0.688-0.123l0.589,0.074l0.761,0.27l0.735,0.246l0.908,0.196l0.54,0.098l0.441-0.27     l0.858-0.024h0.761l0.785-0.147l0.712,0.221l0.662,0.098l1.35,0.024l0.662-0.074l0.981,0.246l0.564-0.049l0.147,0.344l0.27,0.147l0.196,0.27h0.663l0.466,0.098l0.41,0.375l0.031,0.194l-0.051,0.157l-0.325,0.187l-0.97,0.219l-1.338,0.349l-0.445,0.145     l-0.405,0.301l-0.638,0.701l-0.646,0.345l-0.478,0.102l-0.459,0.017l-1.248-0.235l-0.238,0.03l-0.467,0.472l-0.463,0.784l-0.268,0.243l-0.885,0.132l-0.507,0.145l-0.344-0.055l-0.183-0.567l-0.06-0.071l-0.359,0.03l-1.737,0.734l-1.422,0.704l-0.274,0.186     l-0.129,0.213l-0.139,0.739l-0.196-0.073l-0.344,0.098l-0.344,0.171h-0.539l-0.663-0.073l-0.834,0.221l-0.172,0.147h-0.196l-0.172-0.319l-0.368,0.024l-0.318,0.172l-0.074-0.221l-0.049-0.172l-0.122,0.024l-0.319-0.123l-0.049-0.147l-0.221-0.024l-0.442,0.123     l-0.343,0.049l0.024,0.221l-0.295,0.049l-0.393-0.074l-0.073-0.196l-0.147-0.123l-0.368-0.098l-0.49,0.147l-0.196-0.073l-0.688,0.024h-0.564l-0.589,0.024l-0.122-0.098l-0.049-0.147l-0.099-0.27l0.099-0.245l0.196-0.196l0.098,0.221l0.196-0.074l-0.049-0.196     l0.098-0.27h0.123l0.981-0.196l0.515,0.147l0.516,0.196l0.099,0.172h0.196l0.024-0.246l0.441-0.196l0.302-0.147z'},
	KP => {name => 'Korea',
		d => 'M685.343,114.455l-0.571,0.678l-0.309,0.115l-0.511-0.096l-0.579-0.068l-0.595-0.011l-0.315,0.157l-0.633,0.738l-0.283,0.256l-0.235,0.171l-0.268-0.206l-0.35,0.34l-0.319,0.199l-0.373-0.608l-0.398-0.112l-0.649,0.78l-0.195-0.382     l-0.232-0.254l-0.683-0.367l-0.169-0.453l0.095-0.312l0.429-0.411l0.754-0.229l0.056-0.269l-0.591-0.282l0.407-0.879l0.189-0.34l-0.199-0.269l-0.632-0.296l-0.139,0l-0.381,0.029l-0.312,0.143l-0.234-0.07l-0.52-0.368l-0.167-0.233l0.379-0.528l0.415-0.442     l0.52-0.329l1.533-0.604l1.032-0.545l0.636-0.543l0.686-1.027l0.386-0.13l0.448-0.017l0.273,0.396l0.493,0.253l0.508,0.153l0.975-0.048l0.527-0.159l-0.046-0.113l-0.508-0.765l0.025-0.342l0.273-0.243l0.392-0.059l0.333,0.126l0.452,0.054l0.538-0.017l0.62-0.259     l0.955-0.532l0.23-0.713l0.383-0.358l0.253-0.129l0.247-0.001l0.579,0.68l0.298,0.439l0.167,0.393l-1.356,0.923l-0.408,0.457l-0.112,0.414l0.09,0.427l-0.154,0.456l-0.187,0.868l-0.668,0.115l-0.36,0.229l-0.497,0.385l-0.766,0.641l-0.468,0.214l-0.678,0.03     l-0.577,0.199l-0.265,0.228l-0.248,0.312l-0.364,0.893l0.284,0.326l1.225,0.847l0.419,0.354z'},
	TM => {name => 'Turkmenistan',
		d => 'M536.625,121.017l-0.078-0.028l-0.15-0.692l-0.01-0.565l-0.038-0.848l-0.185-0.211l-0.787,0.075l-0.696-0.01l-0.655-0.506l-1.803-1.362l-0.597-0.336l-0.66-0.167l-0.5-0.054l-0.788-0.066l-0.822-0.335l-0.708-0.251l-0.402-0.437     l-1.055-0.107l-0.519-0.054l-0.343,0.129l-0.517,0.343l-0.333,0.03l-0.78-0.038l-0.609,0.032l-0.413,0.144l-0.476,0.328l-0.621,0.654l-0.466,0.3l-0.562,0.13l-0.441-0.025l-0.066-0.376l-0.128-0.681l-0.106-0.447l0.128-0.298v-0.383v-0.532l0.106-0.191     l0.106-0.298l0.085-0.234l-0.085-0.212l-0.256-0.128l-0.319-0.191l-0.213-0.255l-0.042-0.149h-0.171l-0.191-0.042l-0.361-0.106l-0.191,0.192l-0.086-0.234l0.086-0.106l0.148-0.255l0.128,0.106l0.383-0.042l0.426,0.085l0.128,0.021l0.043-0.128l-0.319-0.213     l-0.256-0.021l-0.085-0.277l0.17-0.255l0.213-0.191l-0.404-0.042l-0.319,0.085h-0.383l-0.319-0.085l-0.128,0.149l-0.17-0.255l-0.149-0.298v-0.34l-0.042-0.298l0.17-0.213l0.106-0.319l0.043-0.255l0.105-0.277l0.086-0.234l0.213,0.34l0.063,0.128l0.17,0.17     l0.405-0.085l0.383,0.128l0.106-0.149l-0.021-0.149h0.106l0.148,0.021l0.064,0.319l0.106,0.191l0.298-0.021l0.298-0.063l0.256-0.106l0.233,0.085l0.192,0.064l0.085-0.128l-0.149-0.191l-0.042-0.213l0.191-0.042l0.106,0.149l0.233,0.085l0.256-0.085l0.213-0.064     l0.021-0.234l-0.171-0.341l-0.34-0.234l-0.532-0.319l-0.426-0.213l-0.063-0.319l-0.043-0.34l-0.213-0.17v-0.213v-0.213l-0.085-0.127l-0.554-0.064l-0.617,0.085l-0.426,0.021l-0.446,0.127l-0.192,0.277l-0.085,0.298l0.128,0.192l-0.063,0.276l-0.086,0.405     l0.064,0.234l0.021,0.298l-0.256-0.553l-0.361-0.319l0.042-0.17l-0.063-0.191l-0.274-0.143l0.529-0.453l0.937-0.532l1.277-0.298l0.979-0.085l0.512,0.234l0.681,0.383l0.617,0.383l0.256,0.511l0.638,0.703l0.447,0.255l0.489-0.043l0.341-0.106l0.158,0.014     l1.03,0.063l1.383-0.032l0.126-0.314l-0.314-0.409l0.062-0.628l0.503-0.409l0.503-0.251h0.629l0.283-0.126l0.22-0.346l0.126-0.126h0.283l0.597,0.283l-0.188-0.377l-0.251-0.251l0.565-0.157l0.188-0.063l0.472,0.095l0.629,0.377l0.346,0.032l0.22,0.314l0.692,0.095     l0.534,0.094l0.251,0.22l0.032,0.22v0.22l0.439,0.283l-0.188,0.157l-0.031,0.188l0.188,0.22l-0.157,0.188l-0.094,0.22l0.691,0.314l0.314,0.157l0.503-0.094l0.439-0.032l0.535,0.126l0.439-0.063l0.188-0.157l0.881,0.251l0.22,0.377l0.126,0.566l0.408,0.597     l0.283,0.188l0.188,0.44v0.283l1.384,0.975l1.194,0.597l0.377,0.44l1.006,0.503l0.314-0.063l0.943,0.597l0.565,0.22l1.132,0.597l0.378,0.251l0.471-0.063l0.566,0.189l0.534,0.283l0.503,0.094l-0.062,0.22l-0.157,0.251l0.062,0.503l-0.091,0.726l-1.454-0.244     l-0.565-0.294l-0.445,0.356l-0.417,0.2l-1.135,0.205l-0.432,0.809l-0.203,0.991l-0.103,0.128l-0.508,0.243l-1.985,0.689l-0.568,0.159l-0.119,0.199l-0.001,0.466l-0.22,0.199l-0.636,0.3l-0.534,0.031l-0.573-0.082l-0.999-0.348l-0.937-0.193l-0.193-0.112z'},
	AL => {name => 'Albania',
		d => 'M445.294,112.196l-0.07-0.115l-0.138-0.469l-0.5-0.452l-0.966-0.541l0.024-0.141l0.23,0.062l0.023-0.237l-0.345-0.414l0.418-0.616l-0.182-0.22l0.188-0.563l-0.251-0.282l0.182-0.396l0.268-0.079l-0.027-0.45l-0.331-0.081l-0.2-0.107     l0.002-0.342l-0.133-0.427l0.279-0.515l0.273-0.273l0.727,0.11l0.361,0.022l0.058,0.004l0.382,0.369l0.733,0.866l0.018,0.109l0.035,0.218l-0.132,0.429l0.074,0.641l0.298,0.668l0.722,0.608l-0.09,0.029l-0.449,0.842l-0.402,0.386l-0.496,0.472l-0.583,0.884z'},
	MK => {name => 'Macedonia',
		d => 'M451.512,108.463l-0.507,0.16l-0.532,0.245l-0.622-0.054l-0.361-0.041l-0.365,0.159l-0.395,0.429l-0.606,0.146l-0.809,0.076l-0.722-0.608l-0.298-0.668l-0.074-0.641l0.132-0.429l-0.035-0.218l0.14,0.049h0.188l0.072-0.087l0.029-0.072     l-0.029-0.13l0.058-0.167l0.088-0.058l0.225-0.058l0.246-0.058l0.116-0.058l0.08-0.065l0.087,0.073l0.131,0.058l0.094,0.109h0.116l0.029-0.058l-0.059-0.072l0.109-0.058l0.151-0.102l0.152-0.087l0.175,0.043l0.064-0.007l0.196,0.007l0.152,0.015l0.087-0.08     l0.131-0.116l0.064,0.021l0.102,0.043l0.088-0.021l0.087-0.043l0.102,0.051l0.058-0.015l0.116-0.022l0.145-0.021l0.16-0.022l0.072-0.029l0.058,0.017l-0.007,0.106l0.134,0.213l0.666,0.296l0.358,0.383l0.225,0.469l-0.006,0.499l-0.104,0.3l0.047,0.199z'},
	PT => {name => 'Portugal',
		d => 'M383.93,117.402l-0.249,0.101l-0.517,0.291l-0.439,0.052l-0.548-0.178h-0.58l-0.28-0.073l-0.719,0.292l-0.058-0.177l0.389-1.012l-0.021-0.856l-0.182-0.115l0.244-0.542l-0.054-0.397l0.13-0.114l-0.144-0.141l-0.375,0.085l-0.476,0.097     l-0.108-0.449l0.48-0.052l0.283-0.22l-0.042-0.17l-0.178-0.226l-0.3,0.417l-0.413,0.136l-0.357-0.042l-0.059-0.188l0.198-0.397l0.138-0.616l-0.039-0.303l0.258-0.114l0.403-0.503l0.45-1.098l-0.12-0.115l0.612-1.783l-0.35-0.924l-0.007-0.42l-0.146-0.378     l0.255-0.271l0.891-0.251l0.55-0.188l0.531,0.439l1.822,0.047l0.531-0.26l0.335,0.055l0.272,0.227l0.15,0.242l0.842,0.495l0.062,0.242l-0.288,0.216l-1.234,0.506l-0.084,0.072l-0.051,0.442l0.072,0.456l-0.132,0.983l0.057,0.938l-0.043,0.199l-0.458,0.229     l-0.482,0.045l-0.288,0.129l0.488,0.494l0.455,0.551l0.163,0.198l-0.347,0.371l-0.506,0.655l-0.17,0.455l0.812,0.123l0.408,0.31l-0.884,0.643l-0.242,0.37l-0.304,0.951l-0.008,0.018z'},
	TR => {name => 'Turkey',
		d => 'M500.121,117.572l-0.407-0.016l-0.433,0.388l-0.164,0.126l-0.318-0.105l-0.102-0.269l0.03-0.259l-0.274-0.151l-0.366-0.082l-0.244,0.234l-0.343-0.023l-0.811-0.153l-0.364,0.032l-0.304-0.16l-0.437,0.094l-0.266,0.143l-0.23,0.043     l-0.064-0.245l-0.207-0.023l-0.24,0.292l-0.693,0.304l-1.185,0.224l-0.711-0.039l-0.747-0.123l-0.439,0.073l-1.498,0.673l-0.567,0.13l-1.104,0.176l-0.556-0.153l-1.532-0.444l-0.278,0.03l-0.929,0.373l-0.746,0.075l-0.575-0.025l-0.777-0.166l-0.222,0.001     l-0.142-0.035l-0.055,0.319l0.102,0.452l0.243,0.423l-0.627,0.127l-0.156,0.374l-0.2,0.169l-0.171-0.041l-0.114,0.127l-0.39-0.125l-0.311,0.001l-0.245-0.459l-0.119-0.093l0.097-0.175l0.242-0.197l0.617-0.403l0.021-0.175l-0.049-0.134l-0.279-0.28l-0.146-0.053     l-0.487,0.368l-0.23,0.041l-0.137,0.064l0.092,0.041l-0.118,0.216l-0.172,0.023l-0.063-0.047l-0.076,0.088l-0.297,0.058l-0.332-0.222l-0.447-0.198l-0.461-0.157l-0.395,0.046l-0.849,0.548l-0.337,0.286l0.006,0.204l-0.141,0.046l-0.122,0.07l-0.005,0.082     l-0.179-0.169l-0.604,0.206l-0.689,0.185l-0.594-0.013l-0.587-0.07l-0.678-0.267l-0.963-0.819l-1.181-0.479l-1.034-0.182l-0.692,0.072l-0.119,0.255l-0.097,0.609l-0.053,0.411l-0.173,0.156l-0.256,0l-0.253-0.155l-1.12,0.243l-0.423-0.027l-0.386-0.183     l-0.657-1.159l-0.42,0.354l-0.764-0.451l-0.451,0.057l-0.562,0.412l-0.227-0.382l0.066-0.127l0.242-0.17l-0.116-0.17l-0.989-0.012l-0.545-0.013l-0.088-0.269l0.571-0.199l-0.074-0.241l-0.284-0.198l-0.454-0.07l-0.084-0.297l0.041-0.34l0.087-0.284l-0.089-0.255     l-0.396-0.126l-0.627-0.353l-0.371,0.086l-0.265-0.084l-0.004-0.255l0.171-0.501l0.131,0.059l0.478,0.311l0.567-0.271l-0.396-0.283l0.021-0.124l-0.296-0.128l0.03-0.128l0.571-0.159l0.152-0.113l-0.068-0.142l-0.149-0.088l-0.337-0.035l0.01-0.187l0.18-0.07     l-0.163-0.164l-0.198-0.117l-0.009-0.152l-0.227-0.012l0.263-0.181l0.296-0.275l0.161-0.035l0.07-0.16l-0.341-0.042l-0.573,0.12l-0.905,0.164l-0.166-0.035l0.046-0.33l0.127-0.125l-0.003-0.199l-0.029-0.286l0.13-0.264l0.299,0.012l0.184-0.41l0.175-0.023     l0.63-0.422l0.514,0.012l0.133-0.129l0.479-0.047l0.128,0.211l0.268,0.102l0.169,0.028l0.529,0.022l0.147-0.129l-0.067-0.129l-0.269-0.129l0.286-0.094l0.324,0.036l0.117,0.082l-0.219,0.223l0.213-0.026l1.053-0.073l0.619,0.042l0.379,0.046l0.279,0.047     l0.155-0.176l-0.086-0.094l-0.468-0.035l-0.212-0.118l0.275-0.212l1.386-0.151l0.417-0.012l0.377-0.117l-0.442-0.012l-0.592,0.023h-0.215l-0.068-0.146l-0.611-0.382l0.325-0.528l0.926,0.14l1.244,0.048l0.264-0.117l1.086,0.321l1.051-0.031l0.414-0.243     l-0.041-0.27l0.624-0.244l0.455-0.214l1.218-0.573l0.598-0.215l1.039-0.23l0.889-0.073l0.758,0.07l0.905,0.126l0.798,0.041l0.753-0.372l0.216,0.527l0.416,0.298l0.278,0.099l0.592,0.013l0.622-0.144l0.453,0.74l0.492,0.255l0.574-0.172l0.391,0.056l0.968,0.582     l1.265,0.04l1.094,0.197l0.749-0.001l1.084-0.272l0.514-0.044l0.651,0.141l0.764,0.098l0.787-0.016l0.554-0.144l1.518-0.573l0.424-0.335l1.212,0.082l0.491,0.068l0.226-0.072l0.761-0.36l0.41,0.041l1.326,1.018l0.031,0.028l0.795,0.722l0.026,0.199l-0.421,0.813     l0.033,0.412l0.284,0.211l1.413,0.12l0.492,0.451l-0.072,0.211l-0.409-0.023l-0.231,0.141l-0.009,0.433l-0.584,0.267l-0.039,0.27l0.264,0.67l-0.122,0.375l0.224,0.492l0.09,0.117l0.106-0.105l0.288,0.203l0.039,0.207l-0.229,0.281l-0.287,0.535l-0.06,0.128     l0.213,0.14l0.424,0.111l-0.145,0.245l0.099,0.421l0.42,0.374l0.275,0.035l0.023,0.308z M462.617,106.804l0.241,0.211l-0.019,0.287l0.115,0.285l0.077,0.071l0.593,0.355l0.819,0.241l0.605,0.155l0.152,0.121L464.943,109l-0.304,0.166l-0.515-0.072l-0.94-0.246     l-0.326,0.07l-0.209,0.152l-1.019-0.012l-0.357,0.384l-0.109,0.273l-0.833,0.316l-0.612,0.282l-0.222,0.258l-0.307,0.152l-0.268,0.293l-0.255,0.082l0.164-0.258l0.019-0.141l-0.062-0.176l0.584-0.293l0.22-0.141l-0.226-0.191l-0.082,0.015l-0.653-0.056     l-0.229-0.148l0.326-0.546l0.387-0.558l0.678-0.631l-0.127-0.227l-0.427-0.197l-0.105,0l0.498-0.445l0.629-0.374l0.497-0.045l0.527,0.111l1.333,0.005z'},
	AZ => {name => 'Azerbaijan',
		d => 'M509.077,114.955l-0.72-0.317l-0.268,0.016l-0.356-0.433l-0.374-0.105l-0.13-0.363l0.532-0.27l0.095-0.222l-0.43-0.176l-0.027-0.188l0.63-0.129l0.094-0.155l-0.061-0.113l-0.487-0.21l-0.351-0.281l-0.306-0.166l-0.456,0.234l-1.058,0.492     l-0.374,0.445l-0.642,0.188l-0.254,0.255l-0.014-0.027l0.094-0.118l-0.094-0.213l-0.189-0.071l0.26-0.095l0.166-0.047l-0.261-0.189l-0.236-0.236l0.236-0.118l0.095-0.189l-0.283-0.047l-0.354-0.024l-0.284-0.118l-0.213-0.212l-0.236-0.024l-0.26-0.354     l-0.283-0.142l-0.048-0.094h0.166h0.378l0.165-0.236v-0.236l-0.213-0.024l-0.188-0.142l-0.544-0.331l-0.283-0.354l0.047-0.284l0.402-0.142l-0.119-0.236l-0.212-0.166l-0.426-0.071l-0.284-0.095l0.071-0.094l0.071-0.118l-0.284-0.095l-0.087-0.212l0.418-0.308     h0.236l0.473,0.024l0.331,0.189l0.189,0.213l0.638,0.189l0.284-0.047l0.188,0.023l0.143,0.071l0.26,0.189l0.236-0.047l0.236-0.095l0.095-0.331l-0.118-0.213l-0.614-0.166l-0.213-0.307l-0.143-0.26l0.095-0.071l0.143-0.142l0.268-0.189l0.229-0.023l0.023,0.166     l0.213-0.047h0.189l0.142,0.189l0.473,0.284l0.095,0.118h0.118l0.283,0.284v0.308l0.591,0.094l0.449,0.142l0.379-0.047l0.165-0.213l0.308-0.331l0.283-0.094l0.496-0.284l0.292-0.449l0.465,0.331l0.236,0.378l0.26,0.189l0.284,0.307l0.095,0.52l0.142,0.236     l0.283,0.26l0.284,0.165v0.166l0.449,0.236l0.473-0.047l0.378,0.071l0.284,0.166l0.236,0.189l0.095,0.189v0.142l-0.355-0.142l-0.401-0.047h-0.213l-0.26,0.047l-0.142,0.118l-0.402,0.071l-0.213,0.142l-0.047,0.189l-0.023,0.473l-0.118,0.26l-0.095,0.236     l-0.095,0.378l0.213,0.236l-0.023,0.189l-0.237-0.071l-0.094,0.095l-0.071,0.331l-0.071,0.26l-0.118-0.047l-0.094-0.236l-0.143-0.095l-0.165,0.095l-0.047,0.307l0.07,0.166l-0.118,0.118l-0.118,0.095l0.095,0.26l-0.363,0.91z M499.844,111.738l0.709,0.061     l0.142-0.047l0.26-0.071l0.236,0.236l0.071,0.166l0.378,0.142l0.213,0.071l0.308-0.118h0.52l-0.071,0.213l0.024,0.236l0.118,0.023l0.331,0.166l-0.071,0.236l0.421,0.763l-0.009,0.001l-0.253-0.133l-0.416,0.038l-0.512-0.025l-0.421-0.125l-0.335-0.211     l-0.294-0.402l-0.551-0.223l-0.281-0.417l-0.265-0.381l-0.252-0.197z'},
	GR => {name => 'Greece',
		d => 'M455.452,122.442l0.049-0.209l-0.057-0.128l-0.812-0.256l-0.691-0.006l-0.506-0.116l-0.484,0.017l-0.121-0.046l-0.103-0.093l0.139-0.56l0.315-0.005l-0.005-0.088l-0.009-0.122l0.069-0.07l0.083,0.157l0.021,0.146l0.303,0.021l0.172,0.055     l0.184-0.076l-0.014-0.082l0.108-0.029l0.157,0.105l-0.037,0.093l-0.099,0.006l-0.04,0.053l0.088,0.023l0.144,0.035l0.094,0.046l0.021,0.128l0.353,0.041l0.846-0.122l0.509,0.016l0.035,0.13l0.192,0.035l0.608,0.064l0.307,0.051l0.358-0.121l0.09,0.05     l-0.101,0.312l0.163,0.11h0.105l0.325-0.169l0.286-0.058l0.078,0.052l0.154-0.07l0.232-0.146l-0.083,0.187l0.015,0.186l-0.183,0.268l-0.582-0.046l-0.349,0.081l-0.335-0.017l-1.994,0.169z M445.294,112.196l0.583-0.884l0.496-0.472l0.402-0.386l0.449-0.842     l0.09-0.029l0.809-0.076l0.606-0.146l0.395-0.429l0.365-0.159l0.361,0.041l0.622,0.054l0.532-0.245l0.507-0.16l0.09-0.029l1.855-0.195l0.799-0.261l0.584-0.06l1.473,0.505l0.619,0.21l0.388-0.031l1.117-0.277l0.086-0.257l-0.097-0.327l0.344-0.216l0.363,0.026     l0.105,0l0.427,0.197l0.127,0.227l-0.678,0.631l-0.387,0.558l-0.326,0.546l-0.062-0.407l-0.794-0.056l-0.743-0.041l-0.566-0.125l-0.062-0.144l-0.459,0.186l-0.248,0.123l-0.403,0.012l-0.031-0.247l-0.335,0.029l-0.301,0.314l-0.431,0.186l-0.31,0.03l-0.306-0.159     l-0.252,0.07l-0.004,0.133l0.169,0.185l0.169,0.34l0.308,0.059l0.826,0.609l-0.166,0.07l-0.369-0.258l-0.015-0.105l-0.276-0.082l-0.331-0.105l-0.116,0.099l-0.211,0.007l0.069,0.129l-0.016,0.129l0.338,0.164l0.145-0.012l0.114,0.234l-0.03,0.129l-0.245,0.023     l-0.445-0.457l-0.341-0.141l-0.207-0.059l-0.128-0.012l0.003,0.094l-0.075,0.035l0.138,0.164l0.102,0.105l0.154,0.141l0.193,0.059l0.153,0.035l0.103,0.094l-0.093,0.058l-0.494-0.046l-0.253-0.035l0.035-0.176l-0.137-0.293l-0.164-0.188l-0.401-0.108l-0.472-0.373     l0.258-0.118l0.025-0.136l-0.053-0.122l-0.182-0.035l-0.153,0.199l-0.465,0.176l0.245,0.224l-0.25,0.371l-0.05,0.249l0.13,0.121l0.065,0.172l0.311,0.338l0.133,0.036l0.131,0.479l0.579,0.421l0.359,0.467l-0.172,0.14l-0.237,0.082l0.106-0.187l-0.121-0.187     l-0.142-0.128l-0.139-0.035l-0.151-0.047l-0.29,0.175l0.102,0.188l0.153,0.081l0.08,0.316l-0.193,0.187l-0.652,0.141l0.248,0.046l0.27,0.14l0.391,0.058l0.188,0.222l0.257-0.012l0.155,0.012l0.048,0.126l0.367,0.269l0.306,0.014l0.138,0.292l0.282,0.012h0.27     l0.348,0.303l0.015,0.128l-0.193,0.082l0.238,0.782l-0.153,0.175h-0.185l-0.226-0.385l-0.222-0.047l-0.207-0.278l-0.101-0.142h-0.17l-0.496,0.14l-0.479,0.105l-0.184,0.128l0.315,0.093l0.013,0.188l0.007,0.291l0.229,0.117l0.153-0.026l0.225-0.079l-0.021,0.198     l0.235,0.175l-0.519,0.093l0.002,0.117l-0.169,0.062l-0.309-0.086l0.121-0.21l-0.186-0.086l-0.508-0.056l-0.158-0.092l-0.008,0.206l0.194,0.453l0.193,0.17l-0.045,0.163l0.209,0.204l0.213,0.96l-0.688-0.31l-0.331,0.071l-0.298,0.439l-0.442-0.735l-0.46-0.367     l-0.452,0.44l-0.428-0.353l-0.127-0.297l0.212-0.425l-0.028-0.241l-0.215-0.269l-0.491-0.424l-0.167-0.226l0.017-0.17l0.471-0.61l0.609,0.098l0.425-0.298l0.202,0.042l1.668,0.663l0.337-0.1l0.483-0.355l-0.266-0.049l-0.27-0.056l-1.204-0.493l-1.127-0.083     l-0.367,0.058l-0.66,0.058l-0.427,0.143l-0.89-1.118l0.269-0.1l0.253,0.056l0.218-0.114l0.122-0.185l-0.339-0.24l-0.235,0.114l-0.496-0.042l-1.035-0.721l-0.199-0.325z'},
	AM => {name => 'Armenia',
		d => 'M504.136,113.458l-0.327,0.328l-0.377,0.03l-0.421-0.763l0.071-0.236l-0.331-0.166l-0.118-0.023l-0.024-0.236l0.071-0.213h-0.52l-0.308,0.118l-0.213-0.071l-0.378-0.142l-0.071-0.166l-0.236-0.236l-0.26,0.071l-0.142,0.047l-0.709-0.061     l-0.492-0.451l-1.413-0.12l-0.284-0.211l-0.033-0.412l0.421-0.813l-0.026-0.199l-0.795-0.722l0.377-0.108l0.307,0.024l0.308-0.095l0.426-0.023l0.401-0.118l0.592,0.047l0.591-0.095l0.378-0.047l0.291-0.094l0.087,0.212l0.284,0.095l-0.071,0.118l-0.071,0.094     l0.284,0.095l0.426,0.071l0.212,0.166l0.119,0.236l-0.402,0.142l-0.047,0.284l0.283,0.354l0.544,0.331l0.188,0.142l0.213,0.024v0.236l-0.165,0.236h-0.378h-0.166l0.048,0.094l0.283,0.142l0.26,0.354l0.236,0.024l0.213,0.212l0.284,0.118l0.354,0.024l0.283,0.047     l-0.095,0.189l-0.236,0.118l0.236,0.236l0.261,0.189l-0.166,0.047l-0.26,0.095l0.189,0.071l0.094,0.213l-0.094,0.118l0.014,0.027z'},
	TJ => {name => 'Tajikistan',
		d => 'M566.651,117.4l-0.565-0.153l-0.496-0.054l-0.264-0.151l-0.564,0.227l-0.974,0.147l-0.137-0.059l0.129-0.176l-0.198-0.077l-0.678,0.03l-0.739,0.315l-0.592,0.486l-0.589,0.064l-0.745,0.495l-0.351,0.03l-0.368-0.026l-0.128-0.084     l-0.164-0.409l-0.199-0.521l0.185-0.444l0.099-0.775l0.029-0.255l-0.17-0.187l-0.484,0.093l0.156-0.597l-0.576-0.45l-0.153-0.056l-0.384,0.016l-0.286,0.162l-0.134,0.363l-0.435,0.428l-0.049,0.425l0.006,0.255l-0.208,0.228l-0.442,0.158l-0.133-0.013     l-0.587-0.152l-0.292,0.058l-0.073,0.185l0.007,0.311l-0.3,0.313l-0.21,0.128l-0.381,0.016l-0.63-0.237l-0.325,0.001l-0.581,0.286l-0.58,0.343l-0.485,0.144l-0.245-0.041l-0.129-0.141l-0.04-0.055l0.375-0.843l-0.063-0.377l0.377-0.377l0.283-0.503l0.503-0.346     l0.157-0.22l-0.126-0.283l-0.471-0.314l-0.126-0.409l0.031-0.472l0.126-0.22l-0.126-0.22h-0.346l-0.44-0.032l-0.157-0.157l-0.346-0.188l-0.251-0.283l0.125-0.471l0.472-0.283l0.629,0.126l1.069,0.094l0.282-0.188l0.063-0.409l0.251-0.157h0.188l0.032-0.346     l0.188-0.063l0.251-0.063l-0.126-0.094l-0.534,0.031l-0.251-0.125l0.503-0.094l0.565-0.095l0.472,0.095l0.062-0.126l0.032-0.346l-0.189-0.314l0.283-0.314l-0.031-0.22h0.346l0.22,0.157l0.252,0.22l0.22-0.157l0.692-0.188l0.471-0.346l0.221-0.251l0.439,0.377     l0.252,0.251l-0.188,0.22l-0.409,0.346l-0.251,0.126l0.126,0.188l0.251,0.063l0.188,0.283l0.409-0.031l0.345,0.005l-0.302,0.147l-0.441,0.196l-0.024,0.246h-0.196l-0.099-0.172l-0.516-0.196l-0.515-0.147l-0.981,0.196h-0.123l-0.098,0.27l0.049,0.196l-0.196,0.074     l-0.098-0.221l-0.196,0.196l-0.099,0.245l0.099,0.27l0.049,0.147l0.122,0.098l0.589-0.024h0.564l0.688-0.024l0.196,0.073l0.49-0.147l0.368,0.098l0.147,0.123l0.073,0.196l0.393,0.074l0.295-0.049l-0.024-0.221l0.343-0.049l0.442-0.123l0.221,0.024l0.049,0.147     l0.319,0.123l0.122-0.024l0.049,0.172l0.074,0.221l0.318-0.172l0.368-0.024l0.172,0.319h0.196l0.172-0.147l0.834-0.221l0.663,0.073h0.539l0.344-0.171l0.344-0.098l0.196,0.073l-0.011,0.069l0.023,1.031l-0.207,0.223l0.077,0.305l0.325,0.394l0.463-0.045     l0.229-0.162l0.22,0.06l0.692,0.039l0.273,0.154l0.295,0.494l-0.009,0.284l0.028,0.246l0.152,0.012l0.049,0.123l-0.126,0.428l0.245,0.237l-0.152,0.36l0.2,0.163l-0.181,0.185l-0.08,0.249l-0.354,0.136z'},
	IR => {name => 'Iran',
		d => 'M500.121,117.572l-0.023-0.308l-0.275-0.035l-0.42-0.374l-0.099-0.421l0.145-0.245l-0.424-0.111l-0.213-0.14l0.06-0.128l0.287-0.535l0.229-0.281l-0.039-0.207l-0.288-0.203l-0.106,0.105l-0.09-0.117l-0.224-0.492l0.122-0.375l-0.264-0.67     l0.039-0.27l0.584-0.267l0.009-0.433l0.231-0.141l0.409,0.023l0.072-0.211l0.252,0.197l0.265,0.381l0.281,0.417l0.551,0.223l0.294,0.402l0.335,0.211l0.421,0.125l0.512,0.025l0.416-0.038l0.253,0.133l0.009-0.001l0.377-0.03l0.327-0.328l0.254-0.255l0.642-0.188     l0.374-0.445l1.058-0.492l0.456-0.234l0.306,0.166l0.351,0.281l0.487,0.21l0.061,0.113l-0.094,0.155l-0.63,0.129l0.027,0.188l0.43,0.176l-0.095,0.222l-0.532,0.27l0.13,0.363l0.374,0.105l0.356,0.433l0.268-0.016l0.72,0.317l0.015,0.007l-0.05,0.707l-0.143,0.581     l0.205,0.48l0.494,0.252l0.925,0.235l0.827,0.052l0.424,0.097l0.162,0.282l0.312,0.451l0.687,0.463l1.902,0.513l0.841,0.052l0.438-0.059l1.354-0.262l1.192-0.148l1.469-0.079l0.41-0.229l0.185-0.354l-0.131-0.905l0.015,0l0.441,0.025l0.562-0.13l0.466-0.3     l0.621-0.654l0.476-0.328l0.413-0.144l0.609-0.032l0.78,0.038l0.333-0.03l0.517-0.343l0.343-0.129l0.519,0.054l1.055,0.107l0.402,0.437l0.708,0.251l0.822,0.335l0.788,0.066l0.5,0.054l0.66,0.167l0.597,0.336l1.803,1.362l0.655,0.506l0.696,0.01l0.787-0.075     l0.185,0.211l0.038,0.848l0.01,0.565l0.15,0.692l0.078,0.028l-0.145,0.241l-0.084,0.339l-0.246,0.807l-0.49,1.272l-0.222,0.297l-0.596,0.384l-0.016,0.141l0.119,0.663l0.096,0.098l0.738,0.235l0.026,0.183l-0.661,0.935l-0.034,0.155l0.254,1.085l0.167,1.283     l0.143,0.775l0.191,0.21l0.209,0.041l1.198,0.275l0.401,0.167l0.144,0.366l0.046,0.437l-0.425,0.553l-0.853,0.795l-0.853,1.034l0.802,1.083l0.71,1.068l0.353,0.464l0.695,0.391l1.144,0.388l0.409,0.224l0.168,0.38l0.111,1.34l0.185,0.394l0.652,0.053l0.186,0.281     l-0.036,0.974l-0.188,0.255l-0.209,0.072l-1,0.077l-0.697,0.258l-0.794,0.47l-0.285,0.383l-0.31,0.792l-0.049,0.354l-0.182,0.954l-0.502,0.028l-1.079-0.153l-0.236-0.197l-0.605-0.253l-0.403-0.056l-1.43,0.003l-0.783-0.041l-0.602,0.072l-0.475-0.38l-0.163-0.126     l-0.835-0.026l-0.576,0.001l-0.465,0.014l-0.212-0.239l-0.756-0.125l-0.305-0.183l-0.162-0.014l-0.021-0.5l-0.295-0.128l-0.103-0.514l-0.292-0.349l-0.013-0.639l-0.309-0.493l-0.237,0.012l-0.035-0.181l-0.526-0.126l-0.807-0.013l-0.374,0.017l-0.209,0.222     l-0.329,0.018l-0.517,0.075l-0.188,0.364l-0.538,0.138l-0.383,0.443l-0.368,0.283l-0.253,0.043l-1.292-0.689l-0.958-0.104l-0.562-0.359l-1.088-0.317l-0.247-0.301l-0.324-0.282l-0.497-0.592l-0.997-0.436l-0.584-0.083l-0.194-0.028l-0.58-0.465l-0.596-1.058     l-0.635-1.114l-0.209-0.268l0.005-0.593l-0.767-0.761l-0.506-0.719l-0.921,0.143l-0.46-0.042l-0.13-0.126l-0.291-0.056l-0.191-0.268l-0.029-0.565l-0.448,0.1l-0.166,0.099l-0.32,0.678l-0.195,0.184l-0.355,0.012l-0.014-0.12l-0.351-0.224l-0.686-0.546l0.064-0.212     l-0.007-0.395l-0.164-0.465l-0.215-0.013l-0.551,0.003l-0.034-0.325l0.055-0.579l0.197-0.622l0.014-0.508l-0.112-0.239l-0.29-0.28l-0.774-0.603l-0.436-0.209l-1.242-0.925l-0.533-0.025l-0.321,0.115L503,127.106l0.033-0.819l-1.02-0.954l-0.312-0.351l-0.002-0.184     l0.133-0.875l0.235-0.763l1.142-0.98l-0.422-0.761l0.013-0.254l0.468-0.596l-1.067-0.107l-0.761-0.208l-0.065-0.198l-0.563-1.086l-0.69-1.397z'},
	AF => {name => 'Afghanistan',
		d => 'M535.734,133.791l0.853-1.034l0.853-0.795l0.425-0.553l-0.046-0.437l-0.144-0.366l-0.401-0.167l-1.198-0.275l-0.209-0.041l-0.191-0.21l-0.143-0.775l-0.167-1.283l-0.254-1.085l0.034-0.155l0.661-0.935l-0.026-0.183l-0.738-0.235     l-0.096-0.098l-0.119-0.663l0.016-0.141l0.596-0.384l0.222-0.297l0.49-1.272l0.246-0.807l0.084-0.339l0.145-0.241l0.193,0.112l0.937,0.193l0.999,0.348l0.573,0.082l0.534-0.031l0.636-0.3l0.22-0.199l0.001-0.466l0.119-0.199l0.568-0.159l1.985-0.689l0.508-0.243     l0.103-0.128l0.203-0.991l0.432-0.809l1.135-0.205l0.417-0.2l0.445-0.356l0.565,0.294l1.454,0.244l0.096,0.016l0.646,0.011l1.217,0.05l0.236,0.126l0.351,0.48l0.04,0.055l0.129,0.141l0.245,0.041l0.485-0.144l0.58-0.343l0.581-0.286l0.325-0.001l0.63,0.237     l0.381-0.016l0.21-0.128l0.3-0.313l-0.007-0.311l0.073-0.185l0.292-0.058l0.587,0.152l0.133,0.013l0.442-0.158l0.208-0.228l-0.006-0.255l0.049-0.425l0.435-0.428l0.134-0.363l0.286-0.162l0.384-0.016l0.153,0.056l0.576,0.45l-0.156,0.597l0.484-0.093l0.17,0.187     l-0.029,0.255l-0.099,0.775l-0.185,0.444l0.199,0.521l0.164,0.409l0.128,0.084l0.368,0.026l0.351-0.03l0.745-0.495l0.589-0.064l0.592-0.486l0.739-0.315l0.678-0.03l0.198,0.077l-0.129,0.176l0.137,0.059l0.974-0.147l0.564-0.227l0.264,0.151l0.496,0.054     l0.565,0.153l-0.192,0.145l-0.574-0.059l0.01,0.269l0.236,0.012l0.048,0.088l-0.148,0.142l-0.358,0.004l-0.455,0.297l-0.332-0.005l-0.338,0.179l-0.647-0.144l-1.345,0.012l-1.148,0.152l-0.53,0.292l-0.272,0.19l-0.559,0.395l-0.246-0.023l-0.258,0.214     l-0.464,0.413l0.01,0.32l0.411,0.271l0.01,0.336l0.232,0.171l-0.119,0.483l0.198,0.477l-0.324,0.426l-0.524,0.355l-0.4,0.341l-0.13,0.283l0.223,0.478l0.033,0.31l-0.289,0.255l-0.513,0.215l-0.698-0.039l-0.997-0.122l-0.355,0.129l0.35,0.336l0.365,0.407     l0.129,0.281l0.088,0.437l-0.199,0.255l-0.315,0.115l-0.513,0.031l-0.416,0.115l-0.292,0.228l-0.224,0.424l-0.288,0.834l-0.139,1.214l-0.021,0.084l-0.34,0.383l-0.237,0.086l-1.001-0.375l-0.562-0.025l-0.559,0.243l-0.362,0.271l-0.321,0.693l-0.254,0.086     l-0.516-0.082l-0.644-0.039l-0.283,0.072l-0.597,0.441l-0.412,0.369l-0.188,0.34l-0.232,0.876l-0.099,0.903l-0.069,0.184l-0.247,0.156l-1.066,0.274l-1.183,0.19l-0.964,0.175l-1.234,0.12l-1.005-0.135l-0.349,0.002l-1.187,0.218l-0.742-0.024l-0.541-0.039     l-0.854-0.235l-1.069-0.248l-0.63-0.194l-0.887-0.32z'},
	IQ => {name => 'Iraq',
		d => 'M486.696,126.295l5.257-2.711l0.589-2.701l-0.024-0.467l-0.187-0.508l0.009-0.255l0.23-0.355l0.31-0.214l0.866-0.174l0.457-0.371l0.944-0.883l-0.059-0.24l0.23-0.043l0.266-0.143l0.437-0.094l0.304,0.16l0.364-0.032l0.811,0.153l0.343,0.023     l0.244-0.234l0.366,0.082l0.274,0.151l-0.03,0.259l0.102,0.269l0.318,0.105l0.164-0.126l0.433-0.388l0.407,0.016l0.69,1.397l0.563,1.086l0.065,0.198l0.761,0.208l1.067,0.107l-0.468,0.596l-0.013,0.254l0.422,0.761l-1.142,0.98l-0.235,0.763l-0.133,0.875     l0.002,0.184l0.312,0.351l1.02,0.954L503,127.106l0.075,0.155l0.321-0.115l0.533,0.025l1.242,0.925l0.436,0.209l0.774,0.603l0.29,0.28l0.112,0.239l-0.014,0.508l-0.197,0.622l-0.055,0.579l0.034,0.325l0.551-0.003l0.215,0.013l0.164,0.465l0.007,0.395     l-0.064,0.212l0.686,0.546l0.351,0.224l0.014,0.12l-0.096,0.003l-0.664,0.101l-0.408-0.056l-0.157,0.057l-0.103,0.127l-1.271,0.044l-0.518,0.13l-0.343,0.693l-0.463,0.609l-0.521,0.568l-4.048-0.132l-1.557-0.697l-0.812-0.277l-0.118-0.253l-0.047-0.818     l0.118-0.396l-0.135-0.366l-0.973,0.048l-0.141-0.07l-0.399-0.633l-0.258-0.196l-2.44-1.101l-1.14-0.473l-2.034-0.934l-0.757-0.222l-1.129-0.459l-0.093-0.056l-0.093-0.056l-0.311-0.69l-0.87-1.632z'},
	SY => {name => 'Syria',
		d => 'M479.916,127.377l-0.082-0.085l0.047-0.122l-0.021-0.183l-0.201-0.128l-0.183-0.346l0.398-0.209l0.041-0.099l0.526-0.396l-0.048-0.058l-0.223-0.099l0.077-0.151l0.298-0.25l0.599-0.006l-0.14-0.146l-0.035-0.046l0.078-0.111l0.177-0.163     l0.169-0.116l0.299-0.239l-0.068-0.058l0.023-0.163l-0.09-0.047l-0.031-0.221l-0.241-0.157l-0.222-0.058l0.204-0.204l-0.125-0.052l-0.053-0.116l-0.12,0.058l-0.335,0.052l-0.388-0.023l-0.225-0.564l0.129-0.593l0.072-0.064l-0.1-0.507l-0.42-0.326l0.126-0.093     l0.036-0.152l0.117-0.128l-0.093-0.222l0.107-0.012l0.259-0.32l-0.061-0.112l0.311-0.001l0.39,0.125l0.114-0.127l0.171,0.041l0.2-0.169l0.156-0.374l0.627-0.127l-0.243-0.423l-0.102-0.452l0.055-0.319l0.142,0.035l0.222-0.001l0.777,0.166l0.575,0.025l0.746-0.075     l0.929-0.373l0.278-0.03l1.532,0.444l0.556,0.153l1.104-0.176l0.567-0.13l1.498-0.673l0.439-0.073l0.747,0.123l0.711,0.039l1.185-0.224l0.693-0.304l0.24-0.292l0.207,0.023l0.064,0.245l0.059,0.24l-0.944,0.883l-0.457,0.371l-0.866,0.174l-0.31,0.214l-0.23,0.355     l-0.009,0.255l0.187,0.508l0.024,0.467l-0.589,2.701l-5.257,2.711l-0.161,0.071l-2.96,1.541l-1.139,0.656l-0.253,0.016l-0.365-0.167l-1.902-1.034z'},
	TN => {name => 'Tunisia',
		d => 'M426.068,126.434l-0.093,0.981l0.064,0.564l-0.093,0.269l-0.802,0.428l-0.579,0.314l-1.473,1.138l-0.126,0.354l0.274,0.973l-0.147,0.537l-0.155,0.227l-0.864,0.598l-0.22,0.143l-0.564-1.536l-0.699-2.242l-0.323-0.464l-0.363-0.252     l-0.432-0.181l-0.484-0.831l-0.225-0.465l-0.363-0.28l-0.452-0.097l-0.336-0.774l-0.301-0.888l0.112-0.509l1-0.853l0.414-0.355l0.163-0.411l0.048-0.537l-0.052-0.594l-0.026-0.892l-0.012-1.429l0.114-0.439l0.685-0.627l0.012-0.184l0.508-0.185l0.633-0.455     l0.591-0.228l0.703-0.016l0.643,0.183l0.247,0.212l0.059,0.241l0.25,0.538l0.27,0.084l0.417-0.171l0.584-0.44l0.401-0.17l0.034,0.354l-0.265,0.567l-0.638,0.511l-0.275,0.468l0.005,0.283l0.202,0.438l0.508,0.466l0.351,0.127l0.303,0.848l-0.094,0.212     l-0.541,0.764l-0.59,0.34l-1.017,0.92l-0.216,0.339l0.287,0.451l0.587,0.55l0.528,0.295l0.284,0.056l0.396-0.227l0.316,0.084l0.244,0.635l0.582,0.239z'},
	DZ => {name => 'Algeria',
		d => 'M381.402,139.704l-0.027-0.876l0.069-2.006l0.037-0.382l0.686-0.314l1.512-0.998l0.963-0.542l1.265,0.078l0.397-0.059l0.181-0.693l0.864-0.033l0.777-0.174l0.527-0.229l0.524-0.356l0.484-0.652l1.109-0.332l1.52-0.701l0.129-0.227     l-0.296-0.62l-0.025-0.396l0.079-0.227l0.265-0.114l1.186-0.12l0.381-0.186l0.309-0.553l1.022,0.022l0.67-0.018l1.826,0.004l0.34-1.033l-0.07-0.211l-0.507-0.322L397,126.646l-0.158-0.465l0.016-1.271l0.022-0.833l-0.165-0.889l-0.189-0.211l-0.563-0.279     l-0.259-0.508l0.351,0l0.66-0.143l0.541-0.256l0.369-0.566l0.405-0.312l0.509-0.086l0.407-0.157l0.679-0.27l0.324,0.226l0.176,0.017l0.249,0.024l0.238-0.142l0.407-0.51l0.613-0.426l0.682-0.355l0.614-0.171l1.16-0.116l1.587-0.06l0.513-0.072l0.634-0.312     l0.578,0.211l0.564-0.072l0.585-0.313l0.343-0.1l0.939,0.012l0.513-0.015l0.307,0.056l0.221,0.042l0.322,0.113l0.816,0.168l0.529-0.015l0.772-0.171l0.705-0.2l0.612-0.554l0.994,0.508l0.339,0.099l0.312-0.143l0.314-0.241l0.228-0.156l0.528,0.042l0.388,0.197     l0.162,0.269l0.269,0.126l0.516-0.086l1.093-0.158l-0.012,0.184l-0.685,0.627l-0.114,0.439l0.012,1.429l0.026,0.892l0.052,0.594l-0.048,0.537l-0.163,0.411l-0.414,0.355l-1,0.853l-0.112,0.509l0.301,0.888l0.336,0.774l0.452,0.097l0.363,0.28l0.225,0.465     l0.484,0.831l0.432,0.181l0.363,0.252l0.323,0.464l0.699,2.242l0.564,1.536l-0.204,0.156l-0.241,0.383l0.88,1.605l0.147,0.833l0.052,0.691l-0.1,0.862l0.101,0.748l-0.16,0.622l-0.158,0.495l0.457,1.156l-0.061,0.664l-0.086,0.17l-0.666,0.47l-0.249,0.128     l-0.152,0.283l1.272,1.702l0.249,0.917l0.562,0.873l0.244,0.154l0.544-0.201l0.702,0.165l1.028,0.347l0.178,0.168l0.86,1.506l0.098,0.07l-0.265,0.186l-1.632,0.843l-4.012,2.241l-1.607,0.956l-2.308,1.454l-0.834,0.655l-3.084,2.617l-1.82,0.364l-1.672,0.321     l-2.176,0.408l-0.146-0.564l0.161-0.679l-0.099-0.522l-0.277-0.352l-0.309-0.111l-0.748-0.024l-0.375-0.167l-0.588-0.562l-0.47,0.314l-0.229-0.027l-1.111-1.039l-0.393-0.28l-0.082-0.183l0.096-0.396l-0.181-0.253l-2.472-1.469l-0.397-0.253l-1.292-0.824     l-1.924-1.26l-3.283-2.241l-0.811-0.575l-2.054-1.344l-0.895-0.531l-0.1-0.084l-1.414-0.91l-4.12-2.42l-2.829-1.509z'},
	MA => {name => 'Morocco',
		d => 'M395.704,122.189l0.259,0.508l0.563,0.279l0.189,0.211l0.165,0.889l-0.022,0.833l-0.016,1.271l0.158,0.465l0.598,0.788l0.507,0.322l0.07,0.211l-0.34,1.033l-1.826-0.004l-0.67,0.018l-1.022-0.022l-0.309,0.553l-0.381,0.186l-1.186,0.12     l-0.265,0.114l-0.079,0.227l0.025,0.396l0.296,0.62l-0.129,0.227l-1.52,0.701l-1.109,0.332l-0.484,0.652l-0.524,0.356l-0.527,0.229l-0.777,0.174l-0.864,0.033l-0.181,0.693l-0.397,0.059l-1.265-0.078l-0.963,0.542l-1.512,0.998l-0.686,0.314l-0.037,0.382     l-0.069,2.006l-1.42,0.008l-1.718-0.004l-2.677,0.001l-2.511,0l-1.635,0.04l0.141-0.28l0.431-0.411l0.427-0.085l1.296-0.285l1.143-0.455l0.453-0.312l1.147-0.85l1.149-0.878l1.043-1.104l0.46-0.693l0.133-0.509l-0.05-0.494l-0.427-0.776l-0.09-0.678l0.099-0.508     l0.396-0.636l0.706-0.863l0.211-0.65l-0.063-0.367l0.071-0.353l1.285-1.203l0.724-0.481l0.916-0.327l1.266-0.469l0.73-0.397l0.558-0.552l0.537-0.736l0.466-0.905l0.829-1.925l0.269-0.128l0.54-0.171l0.19,0.127l0.684,0.848l0.138,0.099l1.148,0.507l0.661-0.001     l0.595,0.042l1.304-0.074l0.522-0.228l0.437-0.27l0.398,0.551l0.256,0.099l0.798,0.097l0.361,0z'},
	LB => {name => 'Lebanon',
		d => 'M480.248,123.437l0.388,0.023l0.335-0.052l0.12-0.058l0.053,0.116l0.125,0.052l-0.204,0.204l0.222,0.058l0.241,0.157l0.031,0.221l0.09,0.047l-0.023,0.163l0.068,0.058l-0.299,0.239l-0.169,0.116l-0.177,0.163l-0.078,0.111l0.035,0.046     l0.14,0.146l-0.599,0.006l-0.298,0.25l-0.077,0.151l0.223,0.099l0.048,0.058l-0.526,0.396l-0.041,0.099l-0.398,0.209l-0.07-0.023l-0.088,0.041l-0.067,0.193l-0.009,0.167l-0.355,0.07l-0.07-0.099l-0.151-0.022l-0.372,0.051l0.26-0.291l0.097-0.361l0.169-0.227     l0.328-0.681l-0.017-0.232h0.181l0.138-0.192l0.072-0.32l0.018-0.32l0.409-0.431l0.232-0.07l0.116-0.174l-0.048-0.157z'},
	MX => {name => 'Mexico',
		d => 'M184.444,142.729l-0.367,0.82l-0.518,0.821l-0.186,0.763l-0.179,1.159l0.017,1.851l-0.133,1.187l-0.016,1.13l0.564,1.737l0.275,0.805l0.624,0.945l0.76,0.903l0.191,0.452l0.481,0.521l0.529,0.974l0.729,1.228l0.375,0.296l0.677,0.069     l0.436-0.015l0.577,0.154l0.593,0.451l0.503,0.508l0.773,0.069l1.016-0.242l1.55-0.456l1.396-0.3l0.803-0.157l-0.02,0.542l0.838,0.223l0.264-0.286l0.293-0.199l-0.104-0.247l-0.393-0.175l1.073-0.62l0.633-0.62l0.086-0.827l0.498-0.429l-0.094-0.477l0.092-1.145     l0.254-0.699l0.625-0.334l0.164-0.043l0.757-0.198l0.701-0.1l1.088-0.229l1.016-0.37l0.594-0.058l0.499,0.056l1.139,0.181l0.502-0.194l0.378,0.093l0.62,0.507l0.047,0.297l-0.079,0.424l-0.298,0.382l-0.541,0.496l-0.433,0.425l-0.317,0.445l-0.02,0.7l-0.254,0.297     l-0.188,0.354l0.155,0.155l0.337-0.138l-0.101,0.652l-0.262,1.196L205.356,159l-0.062,0.24l-0.34-0.534l-0.167-0.452l-0.072-0.155l-0.386,0.34l-0.02,0.549l-0.437,0.016l-0.178,0.447l-0.599,0.857l-0.386-0.27l-0.278,0.095l0.025,0.329l-2.332-0.006l-1.792-0.005     l-0.04,1.24l-0.999,0.032l0.396,0.223l0.495,0.541l0.624,0.231l0.359,0.69l0.532,0.223l-0.211,0.683l-1.762-0.007l-1.06,0.007l-1.076,1.812l0.305,0.397l-0.207,0.238l0.054,0.553l0.044,0.454l-0.704-0.555l-0.952-0.888l-0.956-0.761l-1.069-0.859l-0.534-0.352     l-0.053-0.071l-0.639-0.252l-1.048-0.21l-0.657,0.044l-0.817,0.397l-1.1,0.567l-0.756,0.256l-0.931-0.069l-0.724-0.21l-0.48-0.197l-1.305-0.195l-0.588-0.267l-0.644-0.422l-0.935-0.521l-0.785-0.267l-1.711-0.392l-0.963-0.365l-0.722-0.366l-1.074-0.436     l-0.592-0.352l-1.123-1l-0.207-0.07l-0.606,0.058l-0.689-0.14l-1.835-0.575l-0.565-0.536l-0.503-0.634l-0.495-0.395l-1.049-0.577l-0.619-0.267l-0.5-0.494l-0.742-0.987l-0.363-0.55l-0.038-0.113l0.15-0.155l0.504-0.086l0.18-0.17l0.047-0.184l-0.331-0.367     l0.457-0.679l0.041-0.381l-0.172-0.466l-0.744-0.959l0.121-0.297l0.146-0.17l-0.07-0.268l-0.665-0.62l-1.495-1.777l-0.546-0.493l-0.963-1.058l-0.474-0.522l-0.815-0.578l-0.322-0.197l-0.158-0.268l-0.058-0.48l-0.144-0.183l-0.329-0.197l-0.609-0.197l-0.408-0.31     l-0.366-0.522l-0.271-0.028l-0.414,0.114l-0.238-0.155l-0.163-0.367l-0.005-0.325l0.459-0.736l-0.126-0.339l-0.751-0.62l-0.439,0.255l-0.375-0.621l-0.118-0.353l-0.359-0.211l-0.61-0.168l-0.319-0.296l-0.125-0.254l0.05-0.381l0.084-0.269l-0.185-0.226     l-0.561-0.21l-0.46-0.098l-0.46-0.253l-0.935-0.86l-0.478-0.706l-0.281-0.551l-0.646-0.832l-0.736-1.073l-0.184-0.423l-0.38-0.678l-0.242-0.338l-0.152-0.452l0.042-0.509l0.032-0.311l-0.56-0.239l-0.795-0.196l-0.06-0.452l-0.128-0.155l-0.458-0.183l-0.289,0.326     l-0.251,0.043l-1.43-0.647l-0.285,1.004l-0.045,0.438l0.033,0.084l0.265,0.339l0.264,0.296l0.028,1.046l0.088,0.509l0.51,0.677l0.143,0.169l0.643,0.267l0.601,0.536l0.525,0.663l0.602,1.214l0.44,0.282l0.328,0.042l0.237,0.169l0.325,1.398l0.102,0.169     l0.246,0.155l0.497,0.056l0.133,0.056l0.215,0.438l0.161,0.65l0.445,0.79l0.49-0.071l0.223-0.142l0.245,0.452l0.344,1.469l0.531,1.059l0.649,1.2l0.069,0.593l-0.014,0.522l0.26,0.353l0.378,0.154l0.389-0.17l0.234-0.198l0.588,0.804l0.258,0.579l0.464,0.253     l0.281,0.014l0.133,0.311l-0.196,0.537l-0.136,0.127l-0.691,0.595l-0.254-0.042l-0.251-0.409l-0.24-0.734l-0.617-0.578l-0.625-0.309l-0.516-0.479l-0.834-0.507l-1.143-0.986l-0.416-0.451l-0.162-0.269l0.216-0.989l-0.035-0.254l-0.488-1.002l-0.238-0.381     l-0.327-0.282l-0.44-0.098l-0.5-0.31l-0.675-0.677l-0.305,0.142l-0.363-0.056l-1.262-0.746l-0.722-0.31l-0.896-0.973l-0.139-0.127l-0.246-0.254l0.679,0.15l0.599,0.013l0.588-0.284l0.244-0.326l0.093-0.636l-0.01-0.184l-0.458-0.635l-0.466-0.452l-1.1-0.888     l-0.986-0.493l-0.402-0.338l-0.203-0.522l-0.272-0.649l-0.091-0.155l-0.447-0.126l-0.15-0.353l-0.026-0.594l-0.203-0.395l-0.623-0.734l-0.434-0.706l-0.003-0.254l0.212-0.382l-0.777-0.62l-0.254-0.325l-0.22-0.485l0.34-0.017l2.367-0.155l2.381-0.084l0.316,0.31     l0.267,0.154l1.186,0.39l2.811,0.933l3.516,1.112l0.338,0.055l1.662,0.019l1.544,0.02l0.966,0.037l1.867-0.011l0.213-0.101l0.096-0.892l1.858,0.003l1.892,0.046l0.209,0.112l0.631,0.662l0.766,0.632l0.837,0.519l0.708,0.491l0.179,0.226l0.284,0.678l0.318,0.847     l0.445,0.549l1.092,0.659l1.104,0.503l0.337,0.069l0.501,0.011l0.416-0.158l0.283-0.37l0.418-0.413l0.576-0.541l0.468-0.201l0.643-0.018l0.475,0.082l0.783,0.321l0.412,0.252l0.363,0.366l0.663,1.029l0.744,1.227l0.845,1.042l0.657,0.576l0.268,0.253l0.078,0.467     l0.332,0.932l0.336,0.592l0.375,0.365l0.921,0.32l1.029,0.56l0.264,0.069l0.416-0.116l0.296-0.001l0.816,0.377l0.347,0.119z'},
	KW => {name => 'Kuwait',
		d => 'M507.047,133.665l0.055,0.197l0.134,0.691l-0.336-0.028l-0.513,0.513l0.421,0.194l0.418-0.206l0.306,0.021l0.698,1.84l-0.644,0.044l-1.07-0.05l-0.185-0.239l-0.334-0.619l-0.408-0.054l-1.657-0.259l0.521-0.568l0.463-0.609l0.343-0.693     l0.518-0.13l1.271-0.044z'},
	CZ => {name => 'Czech Republic',
		d => 'M431.57,91.965l-0.447-0.633l-0.207-0.036l-0.165-0.18l-0.219,0.084L430.349,91l-0.431-0.17l-0.573-0.515l-0.188,0.072l-0.478-0.265l-0.244-0.173l-0.036-0.233l-0.159-0.085l0.08-0.406l0.155-0.25l-0.413-0.098l-0.258-0.378l-0.037-0.056     l0.243-0.168l0.26-0.181l0.293,0.033l0.422-0.201h0.442l0.078-0.181l0.382-0.012l0.097-0.229l0.358-0.061l0.176,0.072l0.112-0.217l0.735-0.024l0.124-0.169l0.524-0.048l0.284-0.097l0.254-0.084l-0.282-0.218l0.436-0.072l0.308,0.121l0.031,0.278l0.344,0.072     l0.142-0.115h0.375l0.024-0.151l-0.062-0.073l0.063-0.084l0.361-0.018l0.211,0.091l0.093,0.26l0.363,0.163l0.201,0.025l0.568,0.054l0.132,0.181l0.278-0.037l-0.005,0.169l0.466-0.066l0.061-0.066l0.257,0.024l0.199,0.181l-0.099,0.121l-0.208,0.024l-0.224,0.211     l0.55,0.247l0.296,0.38l0.318,0.072l0.22-0.187l0.41-0.12l-0.282-0.302l0.003-0.145l0.286,0.024l0.509,0.193l0.258,0.121l0.709-0.005l-0.181,0.283l0.329-0.084l-0.001,0.253l0.013,0.221l0.293,0.013l0.368-0.161l0.311,0.181l0.802,0.132l-0.02,0.249l0.188,0.208     l0.382,0.096l0.105,0.331l-0.071-0.012l-0.065,0.066l-0.066,0.04l-0.105-0.026L442,89.998l-0.119,0.013l-0.065,0.04l-0.132,0.066l-0.053,0.079l-0.118,0.092l-0.119,0.053l-0.132,0.079l-0.105,0.013l-0.118,0.013l-0.053,0.092l-0.026,0.092l-0.026,0.132     l-0.053,0.079l-0.053,0.105l-0.145,0.066l-0.105,0.04l-0.092-0.026l-0.079,0.079l-0.04,0.092l-0.053,0.079h-0.039l-0.105,0.026l-0.066,0.026l-0.079,0.053l-0.118,0.053h-0.132l-0.145,0.04l-0.093,0.026l-0.065-0.026l-0.065-0.026h-0.093l-0.065,0.026h-0.158     l-0.132-0.053l-0.092-0.053l-0.093,0.026l-0.171,0.053l-0.026,0.04l-0.146,0.119l-0.092,0.066l-0.014,0.131l-0.065,0.105l-0.039,0.044l-0.055-0.095l-0.545-0.2l-1.332,0.181l-1.019-0.227l-1.374-0.341l-0.746,0.773l-0.598,0.163l-0.483-0.099l-0.354-0.129     l-0.145-0.014z'},
	MM => {name => 'Burma',
		d => 'M606.155,150.953l0.595,0.152l0.255,0.14l0.25-0.129l0.273-0.368l0.015-0.678l-0.152-0.93l0.228-0.185l0.401-0.144l0.191-0.354l-0.146-1.594l0.133-0.283l0.811,0.32l0.391,0.11l0.309,0.013l0.17-0.128l1.148-2.25v-0.324l-0.192-0.408     l0.045-0.212l0.938-1.134l0.136-0.382l-0.057-0.761l0.197-0.354l1.446-0.883l0.719-0.512l0.312-0.129l0.558,0.082l0.853,0.221l0.295-0.058l-0.184-0.718l0.072-0.283l0.596-0.582l0.112-0.24l0.018-0.508l0.001-0.127l0.306-0.34l0.277-0.044l0.504,0.279l0.397,0.435     l0.243,0.901l0.217,0.309l0.287,0.041l0.504-0.031l0.146,0.14l0.195,1.649l0.02,0.875l-0.353,0.862l-0.429,0.722l-0.611,0.525l-0.487,0.271l-0.191,0.198l-0.617,0.85l0.075,0.465l0.163,0.705l-0.224,0.58v0.268l0.216,0.069l0.312-0.086l0.819-0.442l0.771-0.089     l0.479-0.017l0.156,0.126l0.277,1.762l0.202,0.324l0.554-0.074l0.521,0.096l0.033,0.268l-0.729,1.584l0.117,0.352l0.228,0.098l0.507-0.003l0.481-0.045l0.291,0.379l0.341,0.746l0.378,0.266l0.246,0.083l0.647-0.159l0.628-0.413l0.111,0.38l0.153,0.239     l-0.502,0.355l-0.53,0.61l-0.442,0.581l-0.582,0.455l-0.193,0.185l-0.08,0.085l-0.158,0.071l-0.645,0.06l-0.436,0.172l-0.528,0.342l-0.394,0.595l-1.078,0.316l-0.62,0.018l-0.474-0.082l-0.362,0.411l-0.143,0.368l-0.036,0.819l-0.114,0.509l0.064,0.409     l-0.086,0.24l-0.163,0.001l-0.588,0.131l0.739,0.884l0.069,0.183l0.112,0.875l0.254,0.14l1.091,0.953l0.148,0.324l0.646,1.041l0.163,0.338l-0.194,0.241l-0.451,0.229l-0.128,0.226l0.231,1.185l-0.171,0.198l-0.812,0.428l0.178,0.38l0.6,1.436l0.54,0.477     l0.606,0.604l0.203,0.479l0.088,0.663l-0.086,0.636l0.006,0.254l0.488,1.183l0.586,1.225l-0.077,0.297l-1.011,1.559l-1.01,1.7l-0.098,0.374l-0.359-0.181l-0.075-0.805l0.461-0.665l0.174-0.495l0.122-0.777l0.287-0.466l-0.512-0.027l-0.104-0.084l-0.004-0.282     l0.195-0.509l-0.177-1.524l-0.246-0.832l-0.639-1.185l-0.488-1.312l-0.347-0.846l-0.179-0.875l-0.174-1.736l-0.117-0.677l-0.034-0.564l-0.051-0.212l-0.344-0.084l-0.148-0.098l-0.304-0.917l-0.516-0.677l-0.226-0.225l-0.247,0.029l-0.081,0.988l-0.158,0.424     l-0.43,0.41l-0.59,0.284l-1.089,0.511l-0.359,0.622l-0.298,0.297l-0.196,0.142l-0.237-0.282l-0.007-0.438l-0.212,0.015l-0.338,0.354l-0.321-0.013l-0.166-0.211l0.147-0.495l-0.001-0.113l-0.621,0.171l-0.276,0.127l-0.247,0.283l-0.355-0.126l-0.002-0.466     l0.553-1.54l0.162-0.791l0.001-0.889l-0.101-1.059l-0.384-0.973l-0.431-1.072l-0.196-0.296l-0.281,0.537l-0.32-0.126l-0.526-0.366l0.482-0.17l0.312-0.015l-0.149-0.479l-0.054-0.268l-0.684-0.775l-0.182-0.183l-0.19-0.028l-0.407,0.1l-0.38-0.267l0.086-0.438     l-0.026-0.141l-0.209-0.112l-0.365,0.043l-0.577-0.465l-0.504-0.606l-0.117-0.244l0.252-0.341l0.801-0.527l-0.194-1.607z'},
	BD => {name => 'Bangladesh',
		d => 'M605.297,153.429l-0.126-0.264l-0.269-0.55l-0.223-1.213l-0.611-1.41l-0.357-0.395l-0.73,0.354l-0.393,0l-0.034-0.084l-0.242-0.211l-0.356-0.592l-0.124-0.042l-0.152,0.127l-0.026,0.537l0.374,0.79l-0.006,0.424l-0.143,0.169l-0.455,0.086     l-0.235,0.537l-0.261,0.1l-0.255-0.437l-0.311-0.395l-0.073-0.057l-0.163,0.669l-0.28,0.249l-0.203,0.043l-0.271-0.536l-0.495,0.636l-0.359-0.265l-0.147-0.532l-0.402-1.775l-0.325-1.409l-0.352-0.45l-0.04-0.254l0.505-0.765l0.029-0.269l-0.193-0.21l-1.042-0.431     l-0.339-0.323l0.548-0.61l0.4-0.299l0.502-0.13l0.382-0.101l0.047-0.155l-0.126-0.112l-1.224-0.938l-0.494-0.237l-0.083-0.155l0.124-0.283l0.555-0.525l0.234-0.171l1.252,0.303l0.339,0.266l0.372,0.266l0.489-0.06l0.417,0.054l0.129,0.324l0.053,0.479l0.079,0.719     l0.095,0.099l0.537,0.109l0.547,0.053l0.916-0.062l0.559-0.003l2.473,0.198l0.111,0.098l0.057,0.127l-0.012,0.79l-0.159,0.34l-0.938,0.767l-0.498,0.13l-0.651,0.356l-0.131,0.283l0.009,0.522l0.001,0.381l0.23,0.281l0.249,0.267l0.529,0.448l0.224-0.354     l0.395-1.159l0.281-0.115l0.4-0.044l0.064,0.578l0.627,2.479l0.037,0.466l0.194,1.607l-0.801,0.527l-0.252,0.341z'},
	TH => {name => 'Thailand',
		d => 'M627.408,186.411l-0.086,0.337l-0.495,0.35l-0.11,0.575l-0.644,0.089l-0.05-0.478l-0.309-0.163l-0.279,0.28l-0.244,0.394l-0.204-0.083l-0.118-0.239l0.213-0.398l-0.041-0.21l-0.055-0.226l-0.261-0.238l-0.447-0.119l-0.106-0.466     l-0.571,0.013l-0.448,0.17l0.013-0.104l0.128-0.297l-0.15-0.183l-0.411,0.212l-0.301-0.07l-0.38-0.38l-0.116-0.508l0.064-0.282l-0.151-0.438l-0.229-0.169l-0.388,0.043l-0.39-0.719l-0.209-0.508l-0.3-0.324l-0.311-0.155l-0.456-0.395l-0.343,0.1l-0.218,0.142     l-0.216-0.381l-0.04-0.607l0.163-0.749l0.559-1.738l0.29-0.848l-0.087-0.044l0.098-0.374l1.01-1.7l1.011-1.559l0.077-0.297l-0.586-1.225l-0.488-1.183l-0.006-0.254l0.086-0.636l-0.088-0.663l-0.203-0.479l-0.606-0.604l-0.54-0.477l-0.6-1.436l-0.178-0.38     l0.812-0.428l0.171-0.198l-0.231-1.185l0.128-0.226l0.451-0.229l0.194-0.241l-0.163-0.338l-0.646-1.041l-0.148-0.324l-1.091-0.953l-0.254-0.14l-0.112-0.875l-0.069-0.183l-0.739-0.884l0.588-0.131l0.163-0.001l0.086-0.24l-0.064-0.409l0.114-0.509l0.036-0.819     l0.143-0.368l0.362-0.411l0.474,0.082l0.62-0.018l1.078-0.316l0.394-0.595l0.528-0.342l0.436-0.172l0.645-0.06l0.158-0.071l0.08-0.085l0.541,0.166l0.295,0.182l0.118,0.168l0.01,0.423l-0.106,0.805l0.066,0.367l0.186,0.154l0.423-0.003l0.489-0.2l0.414-0.045     l0.045,0.113l0.249,1.311l-0.085,0.41l-0.528,1.569l-0.117,0.438l-0.027,0.494l0.145,0.324l0.481,0.138l0.37-0.411l1.173-1.178l0.346-0.03l0.835,0.348l0.59,0.265l0.223-0.072l0.543-0.257l0.2-0.538l0.286-0.453l0.403,0.012l0.893,0.192l0.266,0.153l0.052,0.282     l0.285,0.535l0.688,0.659l0.435,0.632l0.058,1.524l0.107,0.366l0.255,0.464l0.979,1.279l0.419,0.703l0.157,0.507l0.002,0.945l-0.121,0.438l-0.808,0.64l-0.301-0.167l-0.599-0.109l-0.575-0.039l-0.558,0.074l-0.798-0.066l-1.172,0.091l-0.383,0.101l-0.521,0.441     l-0.92,1.233l-0.146,0.297l-0.076,0.382l0.026,0.635l0.219,0.648l0.487,0.717l0.16,0.479l-0.146,0.176l-0.026-0.063l-0.286-0.183l-0.458-0.084l-0.9-0.887l-0.434-0.154l-0.304-0.014l-0.572,0.227l-0.391-0.112l-0.29-0.141l-0.337-0.014v-0.282l0.19-1.243     l-0.107-0.184l-0.719-0.055l-0.248-0.084l-0.521,0.043l-0.443,0.212l-0.244,0.297l0.207,0.593l-0.103,0.339l-0.318,0.707l0.083,0.579l0.054,0.41l-0.293,0.664l-0.583,1.187l-0.7,1.682l-0.255,1.314l0.104,1.171l0.172,0.296l0.229,0.169l0.55-0.072l0.396-0.142     l0.252,0.07l0.135,0.353l0.009,0.325l-0.08,0.466l0.141,0.282l0.178,0.211l0.271-0.094l0.17,0.46l0.209,0.974l-0.032,0.254l0.127,0.737l0.434,0.871l0.167,0.155l0.801,0.281l0.539,0.112l0.467-0.058l0.294,0.197l0.266,0.612l0.664,0.544l0.212,0.145z'},
	BZ => {name => 'Belize',
		d => 'M204.31,158.989l-0.175,0.412l0.612-0.173l0.026,0.429l-0.419,1.241l0.178,0.269l-0.237,0.795l0.189,0.318l-0.092,0.397l-0.358,0.875l-0.3,0.35l-0.36,0.032l-0.054,0.286l-0.388,0.238l0,0.286l-0.69,0.016l0.215-4.297l-0.025-0.329     l0.278-0.095l0.386,0.27l0.599-0.857l0.178-0.447l0.437-0.016z'},
	GT => {name => 'Guatemala',
		d => 'M200.276,169.481l-0.151-0.056l-0.928-0.342l-0.614,0.032l-0.766-0.032l-0.608-0.239l-0.909-0.656l-0.513-0.419l-0.044-0.454l-0.054-0.553l0.207-0.238l-0.305-0.397l1.076-1.812l1.06-0.007l1.762,0.007l0.211-0.683l-0.532-0.223l-0.359-0.69     l-0.624-0.231l-0.495-0.541l-0.396-0.223l0.999-0.032l0.04-1.24l1.792,0.005l2.332,0.006l-0.215,4.297l0.69-0.016l0.303,0.095l0.311,0.302l0.14-0.191l-0.066-0.381l0.336,0.157l0.458,0.367l-1.507,1.208l-0.499,0.238l-0.177,0.493l0.162,0.604l-0.438,0.302     l-0.467,0.048l-0.043,0.254l0.164,0.159l-0.351,0.111l-0.184,0.302l-0.22-0.016l-0.565,0.461l-0.012,0.223z'},
	HN => {name => 'Honduras',
		d => 'M204.413,165.093l0.312-0.03l0.612-0.27l0.639-0.058l0.743,0.126l0.478,0.069l1.443,0.04l0.699-0.228l0.379-0.199l0.567,0.267l0.788-0.03l0.763-0.101l0.63-0.001l0.5,0.126l0.564,0.253l-0.038,0.353l-0.102,0.226l0.228,0.282l0.787,0.238     l0.557,0.069l0.244,0.524l-1.425,0.486l-0.424,0.229l-0.248,0.086l-0.463-0.097l-0.328-0.182l-0.259-0.013l-0.294,0.242l-0.503,0.794l-1.207,0.997l-0.725-0.42l-0.513,0.583l-0.882,0.034l-0.005,0.961l-0.293,0.412l-0.29,0.143l-1.001,0.125l-0.311-0.661     l-0.025-0.085l-0.478-0.3l0.085-0.731l-0.128-0.175h-0.272l-0.541-0.276l-0.433,0.34l-0.365-0.016l-0.066-0.271l-0.565-0.35l-0.409-0.08l-0.208-0.418l-0.677-0.17l0.438-0.302l-0.162-0.604l0.177-0.493l0.499-0.238l1.507-1.208z'},
	SV => {name => 'El Salvador',
		d => 'M205.532,170.085l0.035,0.076l-0.203,0.057l0.01,0.265l-0.237,0.334l-0.68-0.046l-0.853-0.139l-1.697-0.505l-1.305-0.435l-0.325-0.21l0.012-0.223l0.565-0.461l0.22,0.016l0.184-0.302l0.351-0.111l-0.164-0.159l0.043-0.254l0.467-0.048     l0.677,0.17l0.208,0.418l0.409,0.08l0.565,0.35l0.066,0.271l0.365,0.016l0.433-0.34l0.541,0.276h0.272l0.128,0.175l-0.085,0.731z'},
	CO => {name => 'Colombia',
		d => 'M242.38,173.617l-0.128-0.105l-0.84,0.171l-0.534,0.156l-0.414,0.2l-0.056,0.288l0.048,0.497l-0.129,0.396l-0.227-0.027l-0.381,0.059l-0.99,1.758l-0.172,0.722l-0.241,0.722l-0.709,1.191l0.402,0.025l0.234-0.1l0.384-0.017l0.31,0.606     l0.855,1.45l0.103,0.395l-0.226,1.132l0.099,0.353l0.401,0.309l0.429,0.548l0.397,0.252l0.496-0.017l1.163-0.12l1.167-0.05l0.521,0.181l0.64,0.321l0.188,0.253l0.847,0.998l0.554,0.576l0.144,0l0.522-0.13l0.76-0.174l1.99-0.224l0.644,0.081l-0.409,0.525     l-0.085,1.004l-0.379,0.511l-0.147,0.326l0.026,0.254l0.035,0.438l0.048,0.367l0.162,0.804l0.447,0.789l0.256,0.437l0.486,0.647l0.121,0.282l-0.731,0.612l-0.479,0.526l0.51,0.491l0.797,1.182l-0.52,0.286l-0.834,0.57l-0.412,0.158l-0.463,0.017l-2.812-0.082     l-0.64-0.024l-0.042,0.325l-0.013,1.031l0.178,0.154l0.896,0.122l0.177,0.084l0.293,0.408l0.052,0.367l-0.384-0.04l-0.417-0.11l-0.687,0.032l-0.493,0.187l-0.111,0.085l-0.001,1.071l0,0.554l0.192,0.197l0.688,0.363l0.192,0.183l-0.031,0.777l0.399,0.562     l0.031,0.212l-0.326,1.428l-0.706,4.411l-0.073,0.382l-0.133,0.198l-0.156-0.14l-0.575-0.703l-0.237-0.126l-0.161,0.058l-0.448,0.031l1.155-1.956l0.035-0.198l-0.127-0.069l-1.299-0.84l-0.509-0.209l-0.708,0.442l-0.397-0.182l-0.523-0.421l-0.452,0.427     l-0.337,0.157l-0.496,0.031l-1.038-0.008l-0.573-0.152l-0.092-0.281l0.004-0.396l-0.173-0.296l-0.479-0.039l-0.366-0.14l-0.078-0.282l-0.251-0.761l-0.988-0.672l-0.526-0.364l-0.208-0.62l-0.208-0.324l-0.513-0.435l-0.897-0.418l-0.927-0.107l-0.081-0.112     l-0.269-0.162l-0.197-0.118l-0.709-0.631l-0.128-0.056l-0.89,0.401l-0.67,0.061l-0.977-0.277l-0.355-0.309l-0.166-0.493l-0.227-0.225l-1.432-0.656l-1.496-0.803l0.033-0.068l-0.117-0.311l-0.181-0.282l0.108-0.212l0.509-0.114l0.465,0.112l0.186-0.325     l-0.348-0.564l0.086-0.424l0.314-0.227l0.878-0.058l0.193,0.042l0.41-0.227l0.445-0.679l0.45-0.961l0.651-1.061l-0.122-0.268l-0.56-0.408l-0.071-0.184l0.306-0.721l0.089-0.523l-0.149-0.861l-0.371-0.86l0.085-0.254l0.49-0.143l0.135-0.212l-0.088-0.198     l-0.565-0.479l-0.042-0.226l0.103-0.198l0.242-0.326l0.036-0.254l-0.173-0.282l-0.739-0.719l-0.364-0.396l0.256-0.753l0.228-0.082l-0.045-0.45l0.19,0.082l0.085,0.307l0.584-0.409l0.094-0.43l0.322-0.062l-0.509-1.038l-0.228-0.149l-0.084-0.327l0.142,0.075     l0.42,0.338l0.397,0.507l0.22,0.508l0.235,0.197l0.199-0.17l0.147-0.241l-0.332-0.776l0.02-0.212l0.176-0.297l0.445-0.34l0.399-0.297l0.501-0.736l0.327-0.156l0.684-0.101l0.217-0.382l-0.104-0.381l0.174-0.777l0.067-0.65l0.207-0.48l0.498-0.439l0.429-0.283     l0.592-0.242h0.113l0.374,0.206l0.22,0.443l0.281-0.34l0.031-0.438l0.199-0.551l0.22-0.071l0.267,0.126l0.855,0.041l0.562-0.001l0.623-0.27l0.237-0.254l0.476-0.298l0.848-0.256l0.435-0.396l0.278-0.551l0.333-0.255l0.469-0.17l0.58,0.013l0.526,0.338l0.155,0.126     l0.155,0.339l-0.285,0.332z'},
	BJ => {name => 'Benin',
		d => 'M408.6,174.04l-0.062,0.777l0.164,0.762l0.388,0.718l-0.316,0.962l-0.19,0.566l-0.223,0.298l-0.656,0.414l-0.095,0.34l0.116,0.592l-0.078,0.368l-0.433,0.13l-0.257,0.03l-0.237,0.397l0.002,0.381l0.003,0.48l-0.012,0.876l-0.09,0.989     l0.217,1.439l-0.121,1.188l0.006,0.234l-0.333,0.015l-1.232,0.144l-0.669,0.052l-0.106-0.205l-0.295-1.072l0.188-0.708l0.026-0.833l-0.036-0.537l-0.135-0.974l-0.006-0.862l-0.035-0.522l0.013-0.579l-0.442-1.311l-0.164-0.691l-0.403-0.323l-0.468-0.294     l-0.18-0.395l0.141-0.594l0.046-0.424l0.062-0.142l0.24-0.157l0.366-0.553l0.415-0.271l0.418-0.045l0.739,0.095l0.337-0.158l0.415-0.468l0.237-0.764l-0.131-0.367l0.577-0.3l0.321-0.073l0.339,0.28l0.727,0.589l0.902,0.503z'},
	GH => {name => 'Ghana',
		d => 'M394.266,178.814l0.191-0.17l-0.02-0.41l-0.261-1.934l0.125-0.34l0.271-0.157l2.119-0.041l0.867,0.037l1.429,0.006l0.976-0.458l0.161,0.032l0.595,0.119l-0.25,0.849l0.05,0.254l0.633,0.915l0.244,0.451l-0.188,0.721l0.02,0.396l0.265,1.114     l0.181,0.592l0.503,0.788l0.032,0.155l-0.286,0.242l-0.174,0.382l0.01,1.314l-0.011,0.72l0.021,0.551l0.18,0.479l0.468,0.577l0.752,0.608l-0.503,0.682l-0.304,0.099l-0.593-0.013l-0.992,0.144l-0.463,0.185l-0.188,0.098l-0.898,0.469l-1.263,0.398l-0.942,0.412     l-0.958,0.567l-0.578-0.324l-0.945-0.436l-0.074-0.124l-0.066-0.741l-0.554-1.155l-0.263-0.747l-0.103-0.706l0.327-1.005l0.437-1.274l0.521-0.851l0.203-0.595l-0.334-1.438l-0.189-1.285l-0.178-0.154z'},
	TG => {name => 'Togo',
		d => 'M400.72,175.499l1.013,0.163l0.611,0.166l0.29,0.041l-0.046,0.424l-0.141,0.594l0.18,0.395l0.468,0.294l0.403,0.323l0.164,0.691l0.442,1.311l-0.013,0.579l0.035,0.522l0.006,0.862l0.135,0.974l0.036,0.537l-0.026,0.833l-0.188,0.708     l0.295,1.072l0.106,0.205l-0.452,0.035l-0.479,0.128l-0.368,0.212l-0.023,0.04l-0.752-0.608l-0.468-0.577l-0.18-0.479l-0.021-0.551l0.011-0.72l-0.01-1.314l0.174-0.382l0.286-0.242l-0.032-0.155l-0.503-0.788l-0.181-0.592l-0.265-1.114l-0.02-0.396l0.188-0.721     l-0.244-0.451l-0.633-0.915l-0.05-0.254l0.25-0.849z'},
	CI => {name => 'Ivory Coast',
		d => 'M383.772,190.418l0.041-0.919l0.105-0.565l0.247-0.849l0.059-0.452l-0.131-0.282l-1.264-1.334l-0.592,0.032l-0.369-0.097l-0.194-0.183l-0.05-0.183l0.501-0.865l0.059-0.438l-0.119-0.55l0.062-0.17l0.047-0.099l0.602-0.554l0.188-0.354     l-0.179-0.21l-0.296-0.549l0.03-0.127l0.158-0.199l0.304-0.03l0.548,0.223l0.304,0.012l0.19-0.143l-0.051-0.226l-0.648-0.561l-0.309-0.351l0.332-0.37l0.125-0.283l-0.197-0.31l-0.695-0.405l-0.214-0.409l0.264-0.623l0.379-0.397l0.522-0.54l0.352-0.059     l0.566,0.321l0.455,0.436l0.35-0.228l0.362-0.469l0.571-0.483l0.239-0.114l0.257,0.041l0.147,0.211l0.004,0.297l0.117,0.381l0.148,0.239l0.352-0.059l0.604-0.399l0.159-0.1l0.259,0.168l0.545-0.003l0.308,0.252l0.15,0.465l0.52,0.562l0.452,0.223l0.354,0.083     l0.368-0.115l0.446-0.257l0.608-0.159l0.769-0.075l0.644,0.166l0.63,0.434l0.178,0.154l0.189,1.285l0.334,1.438l-0.203,0.595l-0.521,0.851l-0.437,1.274l-0.327,1.005l0.103,0.706l0.263,0.747l0.554,1.155l0.066,0.741l-0.119-0.201l-0.289-0.197l-0.208,0.015     l-0.143,0.24l-0.096,0.042l-0.48-0.027l-0.705-0.167l-0.608-0.083l-2.352,0.062l-1.279,0.243l-0.575,0.199l-1.07,0.369l-1.739,0.781l-0.701,0.425l-0.256-0.013l-0.075-0.032z'},
	MY => {name => 'Malaysia',
		d => 'M627.408,186.411l0.035,0.024l0.523,0.098l1.061,1.198l0.693,0.916l0.506,0.762l0.081,0.579l-0.023,0.805l-0.134,0.862l0.07,1.073l-0.07,0.636l0.097,0.494l0.196,0.381l0.53,0.493l0.338,0.536l0.705,1.608l0.062,0.127l-0.366-0.069     l-0.895-0.055l-0.401,0.142l-0.175-0.07l-0.521-0.437l-0.885-0.605l-0.6-0.337l-1.231-0.675l-1.02-0.732l-0.217-0.254l-0.16-0.988l-0.438-0.691l-0.895-0.817l-0.195-0.663l0.039-0.494l0.03-0.283l-0.107-0.409l-0.399-0.634l-0.347-1.849l-0.188-0.72l0.043-0.362     l0.448-0.17l0.571-0.013l0.106,0.466l0.447,0.119l0.261,0.238l0.055,0.226l0.041,0.21l-0.213,0.398l0.118,0.239l0.204,0.083l0.244-0.394l0.279-0.28l0.309,0.163l0.05,0.478l0.644-0.089l0.11-0.575l0.495-0.35l0.086-0.337z M643.95,196.042l0.081,0.044l0.375,0.408     l0.397,0.141l0.861,0.083l0.413,0.168l0.761,0.436l0.335,0.042l0.337-0.1l-0.503-0.535l0.169-0.551l0.365-0.608l0.528-1.258l0.584-0.27l1.481-0.342l1.018-0.299l0.428-0.326l0.524-1.021l0.523-0.323l0.87-1.117l0.22-0.212l0.244-0.147l0.112-0.068l0.084,0.126     l0.062,0.37l0.234-0.012l0.111,0.259l0.309,0.271l0.383-0.271l1.234-0.42l-0.025-0.086l-0.197-0.197l0.013-0.247l0.024-0.111l-0.148-0.444l-0.11-0.174l0.167-0.042l0.188,0.143l0.085-0.016l0.449-0.084l0.161-0.283l-0.036-0.24l-0.478-0.366l0.197-0.396     l0.436-0.071l0.511,0.041l0.154-0.605l0.408-0.313l0.284-0.48l0.531-0.58l0.498-1.032l0.075-0.17l0.322,0.465l0.33,0.098l0.315-0.424l0.305,0.494l0.351,0.282l0.402,0.211l0.075,0.338l-0.182,0.354l-0.234,0.452l0.037,0.198l0.631-0.128l0.472-0.128l0.115,0.226     l-0.349,0.495l0.742-0.1l0.357-0.085l0.269,0.056l1.035,0.662l0.345,0.14l0.1,0.24l-0.158,0.269l-0.201,0.155l-0.44,0.143l-0.594,0.029l-0.683-0.083l-0.355,0.311l0.096,0.254l0.888,0.69l-0.161,0.311l-0.458,0.199l-0.646,0.1l-0.518,0.114l-0.067,0.15     l-0.182-0.09l-0.753-0.292l-0.446-0.04l-0.624,0.018l-0.651-0.081l-0.748-0.081l-0.464,0.017l-0.247,0.157l-0.381,0.638l-0.119,0.565l0.106,0.988l-0.22,0.383l-0.646,0.244l-0.218,0.34l0.076,0.748l-0.928,1.785l-0.387,0.299l-0.864,0.175l-0.465,0.172     l-0.467,0.356l-0.287,0.03l-0.559-0.152l-0.524-0.223l-0.557-0.251l-0.431-0.11l-0.479,0.074l-0.531,0.441l-0.403,0.525l-0.528,0.342l-0.399,0.172l-0.543-0.11l-0.526-0.223l-0.255,0.001l-0.928,0.416l-0.446-0.28l-0.304-0.083l-1-0.983l-0.253-0.295l-0.288-0.792     z'},
	SR => {name => 'Suriname',
		d => 'M274.556,195.884l0.06-0.212l-0.332-0.563l-0.49-1.127l-0.246-0.832l-0.185-0.295l-0.561-0.067l-0.532-0.675l-0.571-0.831l0.328-0.694l0.095-0.467l-0.078-0.777l0.169-0.17l1.131-0.091l0.183-0.27l0.082-0.862l0.142-0.496l0.015-0.339     l0.326-0.312l0.382-0.057l1.392,0.463l0.465,0.042l0.083-0.41l0.141-0.085l0.337,0.027l0.833,0.012l0.863-0.03l0.723,0.069l0.63,0.182l0.999,0.427l-0.647,0.876l-0.391,0.751l-0.137,0.594l0.094,0.381l0.134,0.635l0.086,0.664l0.521,0.844l0.029,0.438     l-0.424,1.472l-0.489,0.963l-1.05-0.488l-0.319,0.001l-0.534,0.385l-0.398,0.059l-0.418-0.139l-0.642-0.124l-0.172,0.156l-0.2,0.326l0.611,1.014l-0.528-0.054l-1.108-0.276l-0.4-0.04z'},
	GF => {name => 'French Guiana',
		d => 'M285.859,190.719l0.015,0.422l-1.102,1.646l-0.427,0.765l-0.439,0.992l-0.464,0.681l-0.299,0.214l-0.56-0.025l-1.11-0.389l-0.882,0.613l-0.225-0.069l-0.649-0.505l0.489-0.963l0.424-1.472l-0.029-0.438l-0.521-0.844l-0.086-0.664     l-0.134-0.635l-0.094-0.381l0.137-0.594l0.391-0.751l0.647-0.876l0.218,0.093l1.033,0.294l0.55,0.196l0.799,0.549l1.264,1.084l0.545,0.564l0.317,0.465l0.193,0.028z'},
	CG => {name => 'Congo',
		d => 'M429.505,210.684l-0.695-0.533l-0.351,0.13l-0.68,0.513l-0.536,0.414l-0.112-0.177l-0.392-0.86l-1.381-1.344l0.184-0.295l0.413-0.229l0.803,0.307l0.343-0.681l-0.052-0.296l-0.274-0.253l-0.39-0.521l-0.116-0.366l0.058-0.495l0.127-0.1     l0.909-0.146l0.604-0.243l0.125-0.213l0.167-0.807l0.174-0.185l0.239-0.029l0.193,0.14l0.341,0.479l0.405,0.521l0.386,0.195l0.287-0.016l0.188-0.228l0.362-0.482l0.29,0.253l0.167,0.578l0.146,0.112l0.304,0.068l0.255-0.114l0.184-0.68l0.243-1.089l0.131-1.229     l0.229-1.047l-0.114-0.338l-0.161-0.127l-0.384-0.082l-0.528-0.208l-0.242-0.31l-0.132-0.437l0.008-0.109l0.021-0.3l0.157-0.284l0.492-0.398l0.556-0.441l0.094-0.354l-0.389-0.902l-0.369-0.322l-0.592-0.067l-0.939,0.5l-0.463-0.025l-0.146-0.253l-0.068-0.734     l0.077-0.679l0.396-0.468l0.56,0.109l0.863,0.023l0.878-0.076l0.271,0.055l0.479,0.04l0.56,0.124l0.576,0.194l0.864,0.334l0.863,0.292l0.271-0.086l-0.1-0.861l0.159-0.185l0.303-0.312l0.365-0.497l0.158-0.523l0.222-1.287l0.255-0.228l0.479-0.102l0.975-0.175     l0.367,0.054l0.624,0.138l0.895,0.093l0.751-0.287l0.128,0.197l-0.031,0.156l-0.398,1.203l-0.558,0.837l-0.349,0.821l-0.094,0.551l-0.156,0.764l-0.196,2.021l-0.254,1.342l-0.115,0.61l-0.169,0.708l-0.139,0.523l-0.459,0.427l-0.525,0.229l-0.809,0.599     l-0.41,0.454l-0.47,0.836l-0.343,0.751l-0.193,1.159l-0.074,0.396l0.122,0.72l-0.086,0.706l-1.025,0.938l-0.364,0.229l-0.931,0.811l-0.554,0.399l-0.57,0.328l-0.147-0.211l-0.042-0.664l-0.054-0.424l-1.495,0.532l-0.327,0.581l-0.443,0.271l-0.177-0.013     l-0.484-0.336z'},
	GA => {name => 'Gabon',
		d => 'M425.506,195.522l0.045-0.495l0.88,0.093l1.773,0.088l0.831,0.038l1.022,0.149l-0.396,0.468l-0.077,0.679l0.068,0.734l0.146,0.253l0.463,0.025l0.939-0.5l0.592,0.067l0.369,0.322l0.389,0.902l-0.094,0.354l-0.556,0.441l-0.492,0.398     l-0.157,0.284l-0.021,0.3l-0.008,0.109l0.132,0.437l0.242,0.31l0.528,0.208l0.384,0.082l0.161,0.127l0.114,0.338l-0.229,1.047l-0.131,1.229l-0.243,1.089l-0.184,0.68l-0.255,0.114l-0.304-0.068l-0.146-0.112l-0.167-0.578l-0.29-0.253l-0.362,0.482l-0.188,0.228     l-0.287,0.016l-0.386-0.195l-0.405-0.521l-0.341-0.479l-0.193-0.14l-0.239,0.029l-0.174,0.185l-0.167,0.807l-0.125,0.213l-0.604,0.243l-0.909,0.146l-0.127,0.1l-0.058,0.495l0.116,0.366l0.39,0.521l0.274,0.253l0.052,0.296l-0.343,0.681l-0.803-0.307l-0.413,0.229     l-0.184,0.295l-0.038-0.037l-0.563-0.493l-0.532-0.55l-0.259-0.466l-1.318-1.169l0.286-0.312l-0.369-0.281l-0.528-0.056l-0.918-1.438l0.382-0.297l0.111-0.1l-0.321-0.395l-0.464-0.14l-0.29-0.564l-0.369-0.451l0.319-0.17l0.541-0.411l0.223-0.396l0.291-0.976     l0.089-0.295l0.415,0.07l0.495,0.013l-0.064-0.211l-0.56-0.352l-0.561-0.451l0.208-0.042l0.271-0.128l0.142-0.617l0.83-0.043l0.927,0.008l1.245,0.021l0.575-0.032l-0.001-0.155l-0.02-0.551l-0.026-1.836z'},
	GQ => {name => 'Equatorial Guinea',
		d => 'M422.536,195.513l1.005-0.007l1.965,0.017l0.026,1.836l0.02,0.551l0.001,0.155l-0.575,0.032l-1.245-0.021l-0.927-0.008l-0.83,0.043l0.033-0.146l-0.049-0.297l-0.144-0.084l-0.416-0.098l0.287-0.467l0.447-0.523l0.335-0.58l0.066-0.403z      M419.636,193.273l-0.484-0.049l-0.049-0.218l0.049-0.291l0.242-0.097l0.024-0.146v-0.291l0.17-0.097l0.169-0.121l0.219,0.048l0.218,0.048l0.097,0.194l-0.193,0.169l-0.146,0.243l-0.17,0.339l-0.146,0.267z'},
	EC => {name => 'Ecuador',
		d => 'M222.291,207.801l0.188-0.126l0.264-0.312l0.585-1.061l0.038-0.269l-0.209-0.733l0.058-0.391l-0.478,0.617l-0.732,0.623l-0.333-0.098l-0.601-0.324l-0.408-0.408l0.389-0.283l0.1-0.24l-0.167-0.579l0.005-0.438l0.133-0.466l-0.109-0.282     l-0.362-0.649l0.193-0.17l0.48-0.198l0.721-0.454l-0.319-0.395l0-0.226l0.175-0.354l0.497-0.462l0.157-0.146l0.14-0.848l-0.116-0.452l-0.082-0.184l0.11-0.226l0.686-0.101l0.891-0.341l0.396-0.241l0.474-0.382l0.09-0.186l1.496,0.803l1.432,0.656l0.227,0.225     l0.166,0.493l0.355,0.309l0.977,0.277l0.67-0.061l0.89-0.401l0.128,0.056l0.709,0.631l0.197,0.118l0.269,0.162l0.081,0.112l0.387,0.76l0.321,0.789l-0.08,0.255l-0.352,0.384l-0.547,1.147l-0.533,0.779l-0.71,0.725l-1.001,0.755l-0.336,0.087l-1.028,0.303     l-0.901,0.358l-0.809,0.499l-0.59,0.653l-0.284,0.51l-0.987,2.506l-0.267,0.312l-0.242,0.072l-0.398-0.068l-0.398-0.491l-0.191-0.479l-0.312-0.252l-0.815,0.005l-0.444-0.11l-0.105-0.197l-0.097-0.494l0.233-0.34l0.029-0.495l0.005-0.569z'},
	PE => {name => 'Peru',
		d => 'M245.934,224.314l1.109,1.843l0.922,1.646l0.08,0.24l-0.437,0.736l-0.15,0.523l-0.143,0.848l0.057,0.522l0.236,0.902l-0.156,0.34l-0.221,0.34l-0.532,0.582l-0.102,0.452l0.347,0.845l-0.21,0.368l-0.159,0.34l0.022,0.48l0.604,1.168     l0.015,0.522l-0.285,0.439l-0.723,0.61l-0.12,0.227l0.049,0.48l0.132,0.295l0.018,0.142l-0.586,0.187l-0.15,0.199l-0.228,0.933l-0.259,0.298l-0.852,0.275l-0.201-0.517l-0.289-0.31l-1.422-0.618l-0.313-0.239l-0.233-0.678l-0.315-0.38l-0.559-0.225l-0.504-0.281     l-0.489-0.254l-0.616-0.309l-0.873-0.464l-0.673-0.366l-0.866-0.379l-0.838-0.337l-1.271-0.845l-1.354-0.985l-1.232-1.099l-0.594-0.705l-0.42-0.677l0.008-0.438l0-0.903l-0.269-0.606l-0.781-1.043l-1.389-2.778l-0.285-0.268l-0.467-0.211l-0.074-0.085l0.055-0.536     l-0.02-0.396l-0.149-0.396l-1.208-2.199l-0.997-1.961l-0.688-1.27l-1.365-1.917l-0.272-0.353l-0.598-0.973l-0.462-0.423l-0.75-0.437l-0.914-0.365l-0.61-0.365l0.119-0.17l0.181-0.113l0.609-0.029l0.144-0.41l-0.118-0.282l-0.592-0.874l-0.353-0.437l-0.258-0.72     l0.01-0.24l0.244-0.523l0.582-0.622l1.02-0.878l0.47-0.198l0.317-0.214l-0.005,0.569l-0.029,0.495l-0.233,0.34l0.097,0.494l0.105,0.197l0.444,0.11l0.815-0.005l0.312,0.252l0.191,0.479l0.398,0.491l0.398,0.068l0.242-0.072l0.267-0.312l0.987-2.506l0.284-0.51     l0.59-0.653l0.809-0.499l0.901-0.358l1.028-0.303l0.336-0.087l1.001-0.755l0.71-0.725l0.533-0.779l0.547-1.147l0.352-0.384l0.08-0.255l-0.321-0.789l-0.387-0.76l0.927,0.107l0.897,0.418l0.513,0.435l0.208,0.324l0.208,0.62l0.526,0.364l0.988,0.672l0.251,0.761     l0.078,0.282l0.366,0.14l0.479,0.039l0.173,0.296l-0.004,0.396l0.092,0.281l0.573,0.152l1.038,0.008l0.496-0.031l0.337-0.157l0.452-0.427l0.523,0.421l0.397,0.182l0.708-0.442l0.509,0.209l1.299,0.84l0.127,0.069l-0.035,0.198l-1.155,1.956l0.448-0.031     l0.161-0.058l0.237,0.126l0.575,0.703l0.156,0.14l0.136,0.324l-0.341,0.186l-0.793-0.235l-0.493-0.096l-0.322,0.072l-0.604,0.441l-0.371,0.115l-0.669-0.066l-1.895,0.773l-0.701,0.442l-0.372,0.172l-0.599,1.415l-0.319,0.511l-0.021,0.155l0.277,0.86l0.012,0.112     l-0.625,0.498l-0.62,0.328l-0.349,0.342l-0.247,0.622l0.106,0.564l0.619,0.957l1.333,2.166l0.106,0.127l-0.247,0.495l-0.208,0.312l1.085,0.12l0.415,0.04l0.312,0.182l0.241,0.323l0.096,0.663l1.843,0.032l0.762-0.499l0.648-0.484l0.326-0.114l-0.059,1.511     l-0.098,1.173l0.108,0.353l0.317,0.337l0.285,0.068l0.358-0.072l0.786-0.259l0.42-0.045z'},
	BR => {name => 'Brazil',
		d => 'M279.288,257.295l-0.063-0.423l0.027-0.777l0.222-0.819l0.298-0.835l0.321-0.75l-0.019-0.141l-0.491-0.336l-0.234-0.112l-1.29,0.445l-0.224-0.055l-0.254-0.563l-0.487-2.524l-0.121-0.437l-0.843-0.404l-0.724-0.278l-0.115,0.001     l-0.709,0.413l-0.346,0.03l-0.925-0.221l-0.818-0.15l-0.372-0.04l0.006-0.72l0.086-0.721l0.132-0.862l-0.104-0.959l-0.521-0.872l-0.084-0.663l-0.253-0.408l0.421-0.666l0.38-0.765l0.238-0.834l0.185-1.173l-0.022-0.494l-0.307-0.774l-0.316-0.479l-0.73-0.362     l-0.436-0.407l-0.067-0.563l0.261-0.835l-0.042-0.296l-0.693-0.024l-1.615-0.019l-0.5-0.012l-0.967-0.036l-0.153-0.112l-0.249-0.944l-0.138-2.032l-0.03-0.706l-0.203-1.029l0.038-0.565l-0.085-0.169l-0.403-0.237l-0.537-0.166l-0.636-0.123l-1.148,0.077     l-0.22-0.084l-0.398-0.308l-0.385-0.774l-0.096-0.014l-0.882-0.037l-0.3-0.098l-0.75-0.603l-0.688-0.307l-0.676-0.25l-0.355,0.03l-0.787-0.023l-0.316-0.097l-1.1-0.939l-0.813-0.928l-0.335-0.591l-0.141-0.635l-0.036-0.818l0.064-0.622l0.079-0.621l-0.045-0.748     l-1.283-0.021l-0.934,0.076l-0.36,0.158l-0.874,0.485l-1.471,1.109l-0.415,0.243l-0.48-0.025l-0.336-0.026l-0.946,0.824l-0.355,0.03l-1.122-0.304l-0.939-0.136l-0.42,0.045l-0.786,0.259l-0.358,0.072l-0.285-0.068l-0.317-0.337l-0.108-0.353l0.098-1.173     l0.059-1.511l-0.326,0.114l-0.648,0.484l-0.762,0.499l-1.843-0.032l-0.096-0.663l-0.241-0.323l-0.312-0.182l-0.415-0.04l-1.085-0.12l0.208-0.312l0.247-0.495l-0.106-0.127l-1.333-2.166l-0.619-0.957l-0.106-0.564l0.247-0.622l0.349-0.342l0.62-0.328l0.625-0.498     l-0.012-0.112l-0.277-0.86l0.021-0.155l0.319-0.511l0.599-1.415l0.372-0.172l0.701-0.442l1.895-0.773l0.669,0.066l0.371-0.115l0.604-0.441l0.322-0.072l0.493,0.096l0.793,0.235l0.341-0.186l-0.136-0.324l0.133-0.198l0.073-0.382l0.706-4.411l0.326-1.428     l-0.031-0.212l-0.399-0.562l0.031-0.777l-0.192-0.183l-0.688-0.363l-0.192-0.197l0-0.554l0.001-1.071l0.111-0.085l0.493-0.187l0.687-0.032l0.417,0.11l0.384,0.04l-0.052-0.367l-0.293-0.408l-0.177-0.084l-0.896-0.122l-0.178-0.154l0.013-1.031l0.042-0.325     l0.64,0.024l2.812,0.082l0.463-0.017l0.412-0.158l0.834-0.57l0.52-0.286l0.148,0.168l0.138,0.437l0.161,0.861l0.088,0.452l0.199,0.437l0.432,0.054l0.694,0.546l0.482,0.223l0.414-0.073l0.757-0.697l0.083,0.183l0.186,0.776l0.271-0.016l0.645-0.739l0.74-0.654     l0.554-0.286l0.652-0.173l0.235-0.213l0.259-0.666l0.203-0.199l0.652-0.131l0.569-0.272l0.265-0.27l-0.15-0.253l-0.434-0.125l-0.96-0.051l-0.166-0.239l-0.079-0.55l-0.302-1.524l-0.391-0.69l-0.616-0.688l0.041-0.184l0.159-0.029l0.309,0.125l0.896,0.461     l0.385,0.04l1.149-0.035l0.344,0.224l0.628,0.618l0.348-0.115l0.232-1.117l0.284-0.115l0.465,0.054l0.557-0.074l0.807-0.23l1.74-0.9l0.592-0.385l0.163-0.326l-0.103-0.169l0.375-0.257l0.302-0.058l0.516,0.124l0.26,0.111l0.04,0.212l-0.452,1.09l0.304-0.001     l0.533,0.138l0.435,0.958l-0.179,0.368l-0.547,1.416l-0.213,0.962l0.156,0.465l0.281,0.394l0.167,0.31l-0.072,0.354l0.008,0.396l0.15,0.296l1.103,0.897l0.613,0.392l0.686-0.075l0.694-0.513l0.505-0.314l1-0.331l0.934-0.429l0.943,0.022l0.4,0.04l1.108,0.276     l0.528,0.054l-0.611-1.014l0.2-0.326l0.172-0.156l0.642,0.124l0.418,0.139l0.398-0.059l0.534-0.385l0.319-0.001l1.05,0.488l0.649,0.505l0.225,0.069l0.882-0.613l1.11,0.389l0.56,0.025l0.299-0.214l0.464-0.681l0.439-0.992l0.427-0.765l1.102-1.646l-0.015-0.422     l0.409-0.241l0.276,0.141l0.235,0.423l0.164,0.791l0.414,1.34l0.108,0.607l0.472,1.383l0.296,0.55l0.324,0.324l0.978,0.21l0.196,0.338l0.038,0.551l-0.045,0.254l-0.524,0.354l-0.933,1.414l-0.238,0.325l-0.51,0.411l-0.41,0.231l-0.244,0.138l-0.798,0.778     l-0.544,0.947l-0.419,1.018l-0.402,0.453l0.271,0.112l0.512-0.072l0.497-0.198l1.202-0.709l0.112-0.028l0.299,0.889l0.442,0.818l0.255,0.112l0.287,0.07l1.135-0.031l0.592-0.058l0.737-0.298l-0.277,0.679l-0.017,0.584l0.448-0.557l1.254-1.006l0.289-0.156     l0.306-0.382l0.499-0.933l0.272-0.396l0.256-0.099l1.006-0.003l0.352-0.198h0.175l0.687,0.549l0.654,0.267l0.32-0.028l0.814,0.28l1.069,0.45l0.334,0.281l0.269,0.593l0.08,0.028l0.176-0.015l0.402-0.354l0.319,0.042l0.302,0.254l0.538,0.789l0.205,0.396     l-0.13,0.254l-0.308,0.41l-0.116,0.424l0.091,0.466l0.171,0.396l0.825-0.821l0.369-0.156l0.609-0.156l0.995-0.454l0.224-0.028l0.367,0.069l0.764,0.38l0.907,0.436l0.462,0.098l1.117,0.167l1.118,0.083l0.464-0.058l0.48-0.029l0.577-0.171l0.416-0.016l1.131,0.351     l0.731,0.408l0.762,0.479l0.586,0.437l1.595,1.395l0.742,0.662l0.821,0.605l0.41,0.338l0.477,0.196l0.734,0.168l1.247,0.097l0.912,0.04l0.445,0.197l0.265,0.465l0.087,0.607l0.592,2.004l0.268,1.143l0.062,0.988l-0.076,0.579l-0.179,0.904l-0.243,0.848     l-0.559,1.301l-0.518,0.849l-1.347,1.175l-1.388,1.288l-0.44,0.198l-0.354,0.043l-0.39,0.637l-0.094,0.396l-0.012,0.353l-0.504,1.074l-0.6,0.976l-0.8,1.104l-0.266,0.212l-0.194,0.015l-0.079-0.423l-0.278-0.296l-0.367-0.084l-0.064,0.79l-0.538,1.64l-0.049,0.734     l-0.077,0.607l0.318,2.738l0.078,0.988l-0.577,2.543l-0.039,0.663l0.14,0.649l0.043,0.085l-0.759,0.495l-0.404,0.51l-0.261,0.791l-0.04,0.367l0.245,1.468l-0.106,0.367l-0.214,0.283l-0.676,0.608l-0.752,1.498l-1.01,1.4l-0.201,0.537l-0.055,0.311l0.144,0.945     l-1.203,0.37l-0.544,0.283l-0.355,0.368l-0.084,0.466l0.021,0.367l-0.401,0.114l-0.864-0.041l-0.979,0.172l-0.654,0.001l-0.764-0.055l-0.465-0.112l-0.922,0.072l-0.736,0.002l-0.214,0.607l-0.295,0.198l-0.795,0.312l-0.481,0.453l-0.21,0.354l-0.747-0.267     l-0.35,0.071l-0.563,0.255l-1.864,1.232l-0.528,0.396l-0.725,0.383l-0.616,0.438l-0.532,0.679l-0.486,0.241l-0.567,0.072l-0.278-0.014l0.006,0.24l0.336,0.225l0.12,0.536l-0.111,0.537l-0.099,0.282l-0.282,0.156l-0.084,0.155l0.384,0.648l0.036,1.186l0.05,1.045     l-0.057,0.311l-0.11,0.594l-0.198,0.621l-0.464,0.735l-0.566,0.495l-0.788,0.524l-0.866,1.046l-0.208,0.396l-0.476,1.145l-0.499,0.933l-0.75,1.004l-0.69,0.623l-0.801,0.78l0.321-0.808l0.436-0.594l0.629-0.566l0.605-1.158l-0.06-0.254l-0.356,0.142l-0.397-0.014     l-0.633-0.21l-0.075,0.155l0.002,0.297l-0.401,1.215l-0.349,0.48l-0.661,0.438l-0.317,0.283l-0.225,0.424l-0.013,0.354l-0.448,1.709l-0.481,0.763l-0.787,0.934l-1.076,0.979l-0.101-0.313l-0.258-0.746l0.103-0.269l0.634-0.766l0.017-0.269l-0.333-0.379     l-0.163-0.027l-0.131-0.197l-0.853-1.109l-0.474-0.435l-0.999-0.587l-0.55-0.194l-0.617-0.194l-0.432-0.576l-0.365-0.393l-0.693,0.427l-0.27,0.016l-0.232-0.38l-0.59-0.814l-0.379-0.407l-0.47-0.364l-0.266-0.098l-0.25,0.101l-1.042,0.246l-0.55,0.003l0.214-0.27     l0.833-0.88l1.805-1.816l1.435-1.363l1.633-1.448l0.348-0.242l1.754-0.744l0.521-0.313l0.161-0.467l0.094-1.638l-0.517-1.154l-0.206-0.196l-0.462,0.017l-0.957,0.161z M288.966,203.943l-0.558-0.125l-0.301-0.536l-0.078-0.382l0.16-0.197l-0.094-0.636l0.048-0.381     l0.208-1.018l0.176-0.099l0.479-0.058l0.879,0.097l1.007,0.11l0.479-0.199l0.368,0.028l0.479,0.168l0.479,0.083l0.319,0.155l-0.335,0.538l-0.193,0.946l-0.257,0.494l-0.289,0.312l-0.561,0.326l-0.464,0.171l-0.527,0.015l-0.783,0.016l-0.641,0.171z'},
	PG => {name => 'Papua New Guinea',
		d => 'M732.92,214.323l-0.164-0.24l-0.225-0.197l-0.379-0.126l-0.416,0.198l-0.399-0.38l-0.287-0.184l-0.659-0.238l-0.243-0.239l0.156-0.255l0.29,0.027l0.731-0.058l0.538,0.126l0.743,0.083l0.523-0.058l0.258-0.185l0.232-0.509l0.056,0.099     l0.351,0.395l0.286,0.184l0.241,0.014l0.961-0.2l0.366-0.227l0.361-0.722l0.241-0.212l0.653-0.029l0.263-0.128l0.04-0.282l-0.064-0.565l-0.043-0.536l0.495,0.196l0.404,0.056l0.324-0.354l0.318,0.578l0.077,0.353l-0.196,0.495l-0.099,0.184l-0.509,0.044     l-0.159,0.226l0.061,0.17l0.437,0.479l-0.308,0.354l-0.264,0.113l-0.742-0.083l-0.416,0.001l-0.091,0.269l-0.408,0.495l-0.275,0.156l-0.973,0.426l-0.484,0.143l-0.798,0.029l-0.807,0.115z M713.795,220.696l0.031-3.438l-0.046-0.805l-0.431-1.368l0.44-0.822     l-0.169-7.966l2.581,0.802l0.85,0.337l1.04,0.295l1.254,0.378l0.848,0.507l0.613,0.323l0.597,0.084l0.38-0.058l0.26,0.508l0.274,0.254l0.635,0.352l0.687,0.395l0.779,0.718l-0.3,0.947l0.033,0.226l0.305,0.226l0.665,0.111l1.887,0.787l0.354,0.027l0.72,0.183     l0.181,0.254l0.413,0.535l0.211,0.579l-0.166,0.113l-1.114,0.073l-0.563,0.156l-0.098,0.155l0.047,0.339l0.589,0.987l0.5,0.521l1.464,1l0.218,0.847l0.725,1.044l0.288,0.141l0.304-0.015l0.712-0.086l0.338,0.013l0.087,0.198l-0.354,0.551l0.218,0.212l0.401,0.141     l0.423,0.041l0.63,0.168l0.096,0.127l-0.031,0.142l-0.648,0.213l0.287,0.24l1.064,0.28l0.538,0.295l0.235,0.763l-0.064,0.226l-1.094-0.012l-0.215-0.154l-0.146-0.466l-0.126-0.099l-1.011-0.111l-1.063-0.266l-0.644-0.126l-0.752,0.016l-0.774-0.026l-0.573-0.211     l-0.494-0.352l-0.223-0.522l-0.24-0.268l-0.726-0.31l-0.472-0.338l-0.135-0.197l-1.089-1.608l-0.613-0.817l-0.454-0.056l-1.524-0.336l-0.671-0.31l-0.55-0.055l-0.415,0.185l-0.394,0.071l-0.78-0.45l0.282,0.762l-0.027,0.212l-0.249,0.071l-0.382-0.126l-0.311,0.1     l0.296,0.395l-0.116,0.113l-1.037,0.045l-1.125-0.182l-0.478,0.029l0.237,0.127l0.24,0.154l0.642,0.169l0.662,0.352l0.404,0.338l0.219,0.395l-0.411,0.199l-0.739,0.425l-0.458,0.213l-0.668-0.097l-1.801-0.039l-1.219-0.092z'},
	AU => {name => 'Australia',
		d => 'M726.605,297.247l-0.479-0.229l-1.179-0.471l-0.543-0.371l-0.508-0.715l-0.477-0.558l-0.216-0.414l0.264-0.044l0.169,0.1l0.421,0.171l0.129-0.143l-0.209-0.387l-0.703-0.699l-0.617-0.713l-0.149-0.257l-0.375-0.956l-0.008-0.67l0.177-0.044     l1.004,0.312l1.476,0.354l1.089,0.369l0.797-0.03l0.463-0.144l0.382-0.115l0.373-0.058l0.684,0.027l0.306-0.301l0.716-0.244l0.475,0.385l-0.009,0.1l0.128,0.8l-0.009,0.686l-0.751,1.503l-0.124,0.758l-0.245,0.315l-0.943,0.26l-0.553,0.388l-0.49,0.689     l-0.189,0.272l-0.274,0.072z M716.883,224.344l0.682,0.394l0.233,0.509l0.047,0.649l0.118,0.678l0.256,0.197l0.42,0.013l0.102,0.24l-0.45,0.919l0.715,0.338l0.175,0.282l0.147,0.593l0.08,1.3l0.144,0.621l0.456,1.157l0.293,0.268l0.422,0.014l0.328-0.312     l0.384-0.185l0.32,0.663l0.363,0.127l0.563,0.408l0.385,0.154l0.144,0.155l0.002,0.41l0.083,0.96l0.275,0.776l-0.046,1.06l0.279,0.24l0.93,1.325l0.276,0.706l0.055,0.777l-0.209,0.876l0.403,0.649l0.275,0.833l0.204,0.353l1.395,0.803l0.285,0.154l0.744,0.111     l0.402,0.649l0.843,0.535l0.483,0.169l1.141,0.068l0.117,0.197L731,245.42l-0.273,0.565l0.309,0.424l0.879,0.479l0.22,0.564l0.469,1.342l0.211,0.748l0.112,0.396l0.252,0.311l0.771,0.352l-0.021-0.127l-0.141-0.777l0.913,0.507l0.567,0.154l0.184,0.127     l0.136,0.296l0.106,1.752l0.884,0.762l0.573,0.323l0.604,0.154l0.287,0.296l0.244,0.579l0.229,0.424l0.545,0.168l0.176,0.297l0.007,0.269l0.19,0.536l0.106,0.113l0.506,0.126l0.156,0.112l0.162,0.354l0.366,1.327l0.026,0.876l0.013,0.862l-0.132,0.41l-0.181,0.325     l0.778,1.271l0.223,0.48l0.181,0.833l0.034,0.749l-0.293,0.708l-0.353,1.668l-0.585,1.755l0.137,0.791l-0.065,0.806l-0.306,0.778l-0.661,0.977l-0.203,0.665l-0.598,0.821l-0.45,0.185l-0.465,0.1l-0.423,0.468l-0.466,0.68l-0.328,1.527l-0.477,0.638l-0.34,0.495     l0.014,0.65l-0.208,0.539l-0.331,0.312l-0.601,0.341l-0.27,0.326l-0.3,1.021l-0.169,1.049l-0.079,0.937l0.021,0.666l-0.283,0.64l-0.322,0.354l-0.463,0.3l-0.754,0.101l-1.158,0.087l-0.82,0.03l-0.527,0.157l-0.516,0.299l-1.529,0.94l-0.443,0.129l-0.214,0.284     l-0.346,0.071l-0.528,0.059l-0.286-0.014l0.295,0.368l0.209,0.27l-1.315-0.665l-0.885-0.353l0.003-0.469l-0.073-0.156l-0.56-0.467l-0.628-0.368l-0.421-0.014l-0.485,0.172l-0.335,0.242l0.748,0.467l-0.97,0.243l-0.929,0.428l-0.953,0.442l-0.222,0.028     l-0.604-0.226l-0.886-0.438l-0.67-0.226l-1.086-0.311l-0.51-0.041l-0.239,0.156l-0.044,0.113l-0.716-0.169l-0.751-0.353l-0.522-0.298l-0.896-0.82l-0.526-0.34l-0.422-0.879l0.09-1.035l-0.082-0.411l-0.184-0.495l-0.664-0.736l-0.141-0.523l-0.029-0.425     l-0.534-0.014l-0.786,0.398l-0.597,0.114l-0.34,0.058l-0.178-0.07l-0.167-0.17l0.517-0.454l0.233-0.567l0.073-0.821l-0.253-0.324l-0.536-0.593l-0.247-0.353l-0.485,0.735l-0.443,1.431l-0.19,0.113l-0.796,0.002l-0.199,0.156l-0.196,0.015l-0.255,0.028l0.198-0.396     l0.081-0.396l0.079-0.1l0.634,0.041l0.242-0.142l0.126-0.255l-0.105-1.004l0.454-0.835l0.328-0.453l0.091-0.396l0.018-0.409l0.151-0.128l0.245-0.015l0.218-0.354l-0.052-0.227l-0.323-0.494l-0.338-0.494l-0.107,0.707l-0.288,0.255l-0.518,0.299l-0.311,0.467     l-0.086,0.155l-0.189,0.467l-0.281,0.326l-0.747,0.242l-0.735,0.481l-0.653,0.567l-0.36,0.693l-0.514,0.808l-0.41-0.339l-0.38-1.328l-0.263-0.579l-0.19-0.325l-0.688-0.79l-0.297-0.734l-0.176-0.212l-0.704,0.072l-0.235-0.099l-0.139-0.24l-0.085-0.269l0.334-0.34     l-0.047-0.297l-0.346-0.395l-0.543-0.494l-0.266-0.098l-0.83,0.157l-0.486-0.07l-0.95-0.549l-0.274-0.014l-0.438,0.17l-0.433-0.027l-0.421-0.183l-0.662-0.521l-0.921-0.437l-0.218,0.001l-0.723,0.213l-1.282,0.088l-0.669,0.001l-1.764,0.061l-0.611,0.129     l-0.656,0.213l-0.989,0.44l-0.972,0.256l-1.039,0.257l-1.503,0.088l-0.794-0.013l-0.383,0.044l-0.927,0.284l-0.993,0.469l-0.773,0.397l-0.538,0.143l-0.431,0.085l-0.361,0.199l-0.615,0.693l-0.774,1.02l-0.588,0.284l-0.766-0.013l-0.547-0.013l-0.927,0.143     l-0.4,0.185l-0.663-0.395l-0.294-0.084l-0.734,0.016l-1.572,0.173l-0.938,0.157l-0.459-0.041l-0.672,0.044l-0.398,0.227l-0.583,0.793l-0.344,0.128l-0.958-0.125l-0.158,0.057l-0.57,0.708l-0.465,0.368l-0.919,0.271l-0.586,0.086l-1.516-0.082l-0.638-0.055     l-0.688-0.197l-0.633-0.366l-0.778-0.677l-0.74-0.353l-0.374-0.041l-0.151-0.07l-0.19-1.229l0.055-0.255l0.489,0.112l0.45-0.086l0.332-0.425l0.197-0.467l0.267-1.357l-0.043-1.215l-0.156-0.622l-0.258-0.593l-1.117-1.906l-0.208-0.635l-0.144-0.834l0.027-0.989     l-0.16-0.692l-0.467-1.072l-0.663-0.945l-0.603-0.734l-0.214-0.254l0.128-0.904l-0.215-0.536l-0.733-1.115l-0.972-1.018l-0.273-0.583l0.126-0.233l0.188,0.187l0.152,0.443l0.183,0.163l0.235,0.35l0.327,0.188l0.354,0.023l-0.348-1.144l-0.437-0.396l-0.226-0.326     l0.08-0.304l0.748,0.84l0.495,0.979l0.477,0.065l-0.099-0.555l0.289-0.039l0.004-0.564l-0.282-0.48l-1.03-1.368l-0.354-0.691l-0.119-0.579l-0.038-0.734l0.355-0.595l0.323-0.523l0.21-0.664l-0.083-1.031l-0.254-0.635l0.033-0.368l0.438-0.692l0.109-0.325     l0.064-0.156l0.271,0.649l0.011,0.424l0.105,0.184l0.35,0.027l0.171-0.113l0.187-0.565l0.141-0.48l0.765-0.468l1.22-0.624l0.484-0.326l0.676-0.581l0.585-0.467l0.632-0.327l0.79-0.114l0.697-0.016l0.7-0.002l0.431-0.043l0.352-0.185l0.474-0.453l0.494-0.128     l0.929-0.072l0.279-0.143l0.291-0.551l0.158-0.1l0.444,0.027l0.877,0.224l0.626-0.043l0.911-0.299l1.084-0.469l0.359-0.213l0.716-0.665l0.427-0.58l0.29-0.622l0.132-0.297l0.41-0.369l0.968-0.651l0.079-0.17l-0.067-0.409l-0.242-0.805l-0.016-0.495l1.063-1.118     l0.387-0.692l0.291,0.169l0.341,0.437l0.619,1.355l0.262,0.253l0.177-0.579l0.021-0.466l0.436,0.238l0.272,0.07l0.189-0.607l-0.06-0.142l-0.563-0.238l-0.175-0.24l0.007-0.565l0.044-0.112l0.897,0.04l0.661,0.253l0.642-0.029l0.334-0.029l0.289,0.074l-0.699-0.455     l-0.431-0.141l0.128-0.537l-0.07-0.296l0.135-0.509l0.422-0.354l0.165-0.07l0.732,0.394l0.202-0.043l-0.112-0.452l0.11-0.48l0.146-0.367l-0.041-0.522l0.358-0.171l0.4-0.113l0.813,0.04l0.529-1.088l0.371-0.298l0.35,0.169l0.268,0.451l0.265-0.552l0.222-0.227     l0.197-0.48l0.695,0.62l0.513,0.084l0.293,0.211l0.331,0.536l0.632,0.592l0.122,0.706l-0.072,0.594l0.181,0.197l0.256-0.283l0.462-0.679l0.155-0.128l1.16,0.082l0.479,0.155l0.637,0.492l0.332,0.141l0.156-0.48l0.302-0.297l0.022-0.24l-0.266-0.324l-0.601-0.395     l-0.079-0.184l0.008-0.24l0.145-0.099l0.604-0.538l0.007-0.452l0.191-0.213l0.518-0.283l0.268-0.241l0.151-0.269l-0.094-0.184l0.003-0.296l0.512-0.863l0.121-0.057l0.317-0.029l0.397-0.029l0.248-0.17l-0.205-0.409l0.377-0.396l0.344-0.071l0.793,0.366     l0.616-0.072l1.291-0.088l0.512-0.128l0.232-0.17l0.04-0.057l-0.077-0.197l-0.2-0.734l-0.248-0.282l-0.471-0.268l-0.374,0.086l-0.244-0.141l0.035-0.212l0.367-0.143l0.396-0.043l0.617,0.521l0.255,0.099l0.34-0.1l0.364,0.31l0.676,0.465l0.36,0.154l1.297,0.294     l0.591,0.084l0.413-0.143l0.372,0.014l0.396,0.606l0.419,0.112l0.141-0.029l0.562-0.438l0.454,0.027l0.652,0.38l0.331,0.479l0.46-0.143l0.122-0.791l0.181-0.085l0.455,0.465l0.337,0.099l0.152,0.154l-0.436,0.411l-0.126,0.424l-0.176,0.212l-0.011,0.438     l-0.12,0.255l-0.513,0.015l-0.51,0.228l-0.396,0.34l-0.004,0.551l0.301,0.353l-0.187,0.692l-0.381,0.58l-0.559,0.481l-0.155,0.48l0.063,0.17l0.469,0.437l1.038,0.619l0.81,0.677l0.508,0.606l0.246,0.099l0.349-0.114l0.264,0.027l0.782,0.352l0.742,0.465     l0.434,0.451l0.679,0.535l0.335,0.127l0.442,0.027l0.784,0.182l0.25,0.184l0.218,0.621l0.167,0.169l0.507,0.31l0.76,0.423l0.537,0.154l0.422-0.072l0.414-0.17l0.603-0.199l0.208-0.156l0.736-1.344l0.403-1.131l0.194-1.314l0.259-0.721l0.43-0.679l-0.131-0.424     l-0.409-0.621l0.022-0.311l0.236-0.637l0.187-0.48l-0.164-0.282l-0.183-0.395l0.088-0.692l0.104-1.004l0.225-0.297l0.329-0.156l0.158-0.311l-0.534-0.521l0.033-0.198l0.576-0.947l0.312-0.934l0.072-0.833l0.191-0.241l0.279-0.297z'},
	UY => {name => 'Uruguay',
		d => 'M270.934,276.123l0.054-0.338l-0.194-0.577l0.011-0.522l0.24-0.495l0.48-0.524l0.118-0.325l-0.168-0.986l-0.049-0.847l0.103-0.522l0.595-2.359l0.065-0.452l0.443-0.524l0.55-0.003l1.042-0.246l0.25-0.101l0.266,0.098l0.47,0.364l0.379,0.407     l0.59,0.814l0.232,0.38l0.27-0.016l0.693-0.427l0.365,0.393l0.432,0.576l0.617,0.194l0.55,0.194l0.999,0.587l0.474,0.435l0.853,1.109l0.131,0.197l0.163,0.027l0.333,0.379l-0.017,0.269l-0.634,0.766l-0.103,0.269l0.258,0.746l0.101,0.313l-0.059,0.053     l-0.803,1.103l-0.625,0.552l-0.775,0.454l-0.441,0.156l-0.818,0.1l-0.874-0.337l-0.551,0.044l-0.551,0.114l-0.64,0.283l-0.38-0.042l-0.846-0.676l-0.637-0.252l-0.76-0.154l-0.469,0.128l-0.507,0.072l-0.327-0.127l-0.548-0.563l-0.354-0.159z'},
	DK => {name => 'Denmark',
		d => 'M418.763,73.869l0.391-0.499l0.389-0.262l0.283,0.081l0.663-0.062l0.762-0.075l0.324-0.137l0.891-0.787l0.979-0.2l0.224,0.025l0.198-0.219l0.175,0.032l-0.349,0.531l0.11,0.106l0.026,0.481l-0.288,0.156l-0.17,0.368l-1.675,0.069     l-0.376-0.106l-0.428,0.031l-0.14-0.062l-0.239,0.081l-0.275,0.031l-0.153,0.417l-0.249,0.218l-0.353,0.118l-0.08,0.112l-0.229-0.155l-0.411-0.292z M421.68,78.002l-1.839,0.129l-0.116-0.016l0.064-0.404l-0.19-0.638l-0.174,0.015l-0.36-0.293l-0.233,0.184     l-0.398-0.172l0.2-0.355l0.434-0.293l-0.007-0.181l-0.445-0.541l0.018-0.256l0.131-0.498l0.279-0.106l0.318,0.15l0.495,0.12l0.43-0.574l0.299-0.091l0.296,0.437l0.391-0.046l0.022-0.528l0.107-0.363l1.032-0.017l0.848,0.089l0.03,0.544l0.187,0.301l1.138,0.058     l0.14,0.166l-0.307,0.604l-0.565,0.142l-0.119-0.261l-0.331,0.031l-0.263,0.136l0.121,0.278l-0.184,0.414l-0.312,0.077l-0.069,0.244l-0.635,0.035l0.157,0.229l-0.291,0.094l-0.191,0.24l-0.061,0.285l0.003,0.21l-0.215,0.338l0.166,0.084z M427.177,77.967     l-0.139-0.149l-0.312-0.344l-0.405,0.031l-0.665-0.059l-0.123-0.329l-0.285-0.66l0.433-0.091l0.603-0.467l0.356,0.495l0.521,0.179l0.2-0.271l0.078-0.586l0.333-0.046l0.459,0.044l0.056,0.571l-0.134,0.36l-0.144,0.09l-0.413,0.286l0.603,0.299l-0.285,0.166     l-0.499,0.39l-0.238,0.09z'},
	DE => {name => 'Germany',
		d => 'M417.259,94.301l-0.135-0.233l0.216-0.701l-0.091-0.076l0.075-0.295l0.321-0.372l0.054-0.358l0.054-0.213l0.954-0.806l-0.605-0.193l-0.479,0.014l-0.456-0.09l-0.095-0.186l-0.233-0.007l-0.072,0.048l-0.689,0.062l-0.045-0.145l-0.395,0.055     l-0.337-0.277l-0.428-0.319l-0.074-0.353l0.248-0.144l0.044-0.288l-0.466-0.096l-0.41-0.312l-0.062-0.301l0.422-0.376l-0.038-0.468l-0.282-0.365l-0.344-0.177l0.165-0.278l-0.143-0.217l-0.182-0.037l0.08-0.097l0.235-0.133l0.236-0.133l-0.193-0.121l0.201-0.275     l0.095-0.148l-0.152-0.292l-0.082-0.265l-0.376-0.182l0.07-0.182l0.341-0.078l0.175-0.092l0.378,0.134l0.664-0.151l0.32-0.152l0.128-0.376l0.412-0.207l0.003-0.328l-0.16-0.17l-0.188,0.061l-0.44-0.134l0.029-0.184l0.113-0.181l0.571,0.036l0.084-0.401     l0.345-0.361l-0.151-0.438l0.066-0.147l-0.465-0.192l0.126-0.43l0.285-0.181l0.371-0.028l1.12-0.062l0.293-0.012l0.095,0.16l0.195,0.271l-0.155,0.158l0.324,0.113l0.148-0.068l0.042-0.192l-0.159-0.204l0.259,0.012l0.437,0.169l-0.163-0.362l0.247-0.419     l0.687,0.113l0.614-0.091l-0.596-0.17l-0.084-0.227l0.282-0.102l-0.252-0.114l-0.12-0.147l0.166-0.08l0.068-0.136l-0.675,0.08l-0.06-0.182l0.664-0.125l0.218-0.193l-0.464-0.42l-0.324-0.341l0.045-0.28l0.116,0.016l1.839-0.129l0.254,0.13l0.565,0.341l0.271,0.297     l-0.02,0.228l-0.252,0.175l0.445-0.05l0.171,0.216l0.157-0.078l0.283,0.021l0.235,0.156l0.45,0.073l0.866-0.121l0.077,0.208l-0.07,0.149l-0.057,0.125l-0.665,0.295l0.316,0.193l0.649-0.136l0.113,0.182l0.457-0.006l0.349-0.391l1.059-0.136l0.602-0.234     l0.757-0.266l0.249,0.113l0.396-0.17l0.184,0.182l0.085,0.159l0.634,0.29l0.182,0.074l0.526-0.12l0.156,0.12l0.059,0.34l0.036,0.227l0.154,0.102l0.354,0.125l0.372-0.022l0.028,0.13l0.201,0.025l0.319,0.835l-0.219,0.52l-0.391,0.147l-0.051,0.328l0.391,0.102     l0.683,0.429l-0.217,0.395l0.094,0.18l0.312,0.146l-0.021,0.304l0.131,0.102l-0.118,0.292l-0.214,0.124l-0.007,0.191l0.325,0.27l-0.114,0.258l0.468,0.188l0.281,0.485l-0.435,0.698l-0.142,0.115l-0.344-0.072l-0.031-0.278l-0.308-0.121l-0.436,0.072l0.282,0.218     l-0.254,0.084l-0.284,0.097l-0.524,0.048l-0.124,0.169l-0.735,0.024l-0.112,0.217l-0.176-0.072l-0.358,0.061l-0.097,0.229l-0.382,0.012l-0.078,0.181h-0.442l-0.422,0.201l-0.293-0.033l-0.26,0.181l-0.243,0.168l0.037,0.056l0.258,0.378l0.413,0.098l-0.155,0.25     l-0.08,0.406l0.159,0.085l0.036,0.233l0.244,0.173l0.478,0.265l0.188-0.072l0.573,0.515l0.431,0.17l0.184,0.201l0.219-0.084l0.165,0.18l0.207,0.036l0.447,0.633l-0.682,0.26l-0.437-0.151l-0.132,0.027l-0.039,0.337l-0.162,0.172l-0.968,0.295l-0.364,0.227     l0.538,0.571l-0.197,0.295l0.334,0.014l0.056,0.158l-0.098,0.343l-0.082,0.055l-0.441-0.178l0.049-0.165l-0.146-0.117l-0.564,0.062l-0.195-0.138l-0.433,0.035l-0.092,0.178l-1.25,0.035l-0.125,0.171l-0.319,0.014l-0.044,0.13L425.4,94.7l-0.594,0.021l-0.059-0.144     l-0.093-0.145l-0.493-0.089l-0.262,0.055l-0.237-0.041l0.032,0.274l-0.452,0.343h-0.215l0.078-0.195l-0.26-0.039l0.011-0.165l-0.194-0.048l-0.104-0.137l-0.249-0.007l-0.096-0.11l-0.164,0.137l-0.368-0.014l-0.664-0.261l-0.852-0.007l-0.149-0.089l-0.199,0.014     l-0.017-0.151l-0.709,0.199l0.179,0.199l-0.354,0.021l-0.278-0.11l-0.567,0.158l-0.271-0.096l-0.272,0.117l-0.271-0.089z M432.012,80.473l-0.171-0.038l-0.088-0.049l-0.447,0.08l-0.111-0.264l0.002-0.213l0.647,0.281l0.168,0.203z'},
	PL => {name => 'Poland',
		d => 'M450.734,91.05l-0.831-0.33l-0.424-0.101l-0.104-0.216l-0.703-0.186l-0.129-0.13l-0.561,0.076l-0.508-0.041l-0.073,0.137l-0.373,0.18l-0.46-0.254l-0.483,0.046l-0.168-0.056l-0.558,0.204l-0.104,0.177l-0.149,0.135l-0.18-0.12l-0.389,0.083     l-0.003-0.204l0.026-0.083l-0.066-0.18l-0.331,0.025l-0.073-0.169l-0.194-0.24l-0.261,0.024l-0.062,0.112l-0.193-0.016l-0.183,0.24l-0.43,0.048l-0.03-0.228l-0.285-0.041l-0.105-0.331l-0.382-0.096l-0.188-0.208l0.02-0.249l-0.802-0.132l-0.311-0.181l-0.368,0.161     l-0.293-0.013l-0.013-0.221l0.001-0.253l-0.329,0.084l0.181-0.283l-0.709,0.005l-0.258-0.121l-0.509-0.193l-0.286-0.024l-0.003,0.145l0.282,0.302l-0.41,0.12l-0.22,0.187l-0.318-0.072l-0.296-0.38l-0.55-0.247l0.224-0.211l0.208-0.024l0.099-0.121l-0.199-0.181     l-0.257-0.024l-0.061,0.066l-0.466,0.066l0.005-0.169l-0.278,0.037l-0.132-0.181l-0.568-0.054l-0.201-0.025l-0.363-0.163l-0.093-0.26l-0.211-0.091l-0.361,0.018l-0.063,0.084l0.062,0.073l-0.024,0.151h-0.375l0.435-0.698l-0.281-0.485l-0.468-0.188l0.114-0.258     l-0.325-0.27l0.007-0.191l0.214-0.124l0.118-0.292l-0.131-0.102l0.021-0.304l-0.312-0.146l-0.094-0.18l0.217-0.395l-0.683-0.429l-0.391-0.102l0.051-0.328l0.391-0.147l0.219-0.52l-0.319-0.835l0.34,0.043l0.23,0.125l-0.093-0.193l0.156-0.153l-0.019-0.147     l-0.166-0.13l-0.021-0.129l-0.012-0.075l0.93-0.154l0.431-0.051l0.516-0.152l1.304-0.128l0.48-0.158l0.797-0.479l1.117-0.298l1.515-0.303l1.382-0.086l1.067,0.417l-0.882-0.294l-0.054,0.147l0.256,0.172l0.132,0.466l0.355,0.135l0.648,0.061l0.645-0.11     l1.063-0.409l0.054,0.004l-0.978,0.417l-0.19,0.11l-0.004,0.123l0.218,0.012l0.286-0.123l0.613-0.208l0.543-0.253l0.842,0.006l2.246,0.115l2.96-0.101l0.641-0.021l0.04,0.014l0.679,0.243l0.284,0.487l0.099,0.186l0.016,0.029l0.09,0.171l0.16,0.302l0.615,1.5     l0.172,0.502l-0.023,0.236l-0.263,0.208l-0.44,0.03l-0.571,0.244l-0.291,0.328l-0.128,0.292l0.289,0.012l0.421,0.146l0.149,0.176l0.218,0.146l0.013,0.25l-0.315,0.752l0.126,0.137l0.161,0.175l-0.074,0.242l0.816,0.835l0.316,0.193l-0.298,0.048l-0.085,0.133     l0.328,0.302l-0.009,0.314l-0.255,0.24l-0.429,0.013l-0.286,0.181l-0.599,0.398l-1.509,1.218l-0.082,0.306l0.044,0.552l0.349,0.383l-0.653-0.018z M431.844,80.27l0.232,0.024l0.069,0.208l-0.134-0.029l-0.168-0.203z M432.739,80.361l-0.03,0.129l-0.278-0.024     l-0.191,0.03l-0.046-0.208l0.174-0.012h0.266l0.106,0.085z'},
	NL => {name => 'Netherlands',
		d => 'M416.488,81.945l0.151,0.438l-0.345,0.361l-0.084,0.401l-0.571-0.036l-0.113,0.181l-0.029,0.184l0.44,0.134l0.188-0.061l0.16,0.17l-0.003,0.328l-0.412,0.207l-0.128,0.376l-0.32,0.152l-0.664,0.151l-0.378-0.134l-0.175,0.092l-0.341,0.078     l-0.07,0.182l0.376,0.182l0.082,0.265l0.152,0.292l-0.095,0.148l-0.201,0.275l0.193,0.121l-0.236,0.133l-0.235,0.133l-0.08,0.097l0.182,0.037l0.143,0.217l-0.165,0.278l-0.672,0.024l-0.001-0.338l0.172-0.097l0.11-0.423l-0.754-0.375l-0.535,0.109l-0.292-0.375     l-0.228-0.061l-0.173,0.121l-0.313-0.242l-0.267,0.182h-0.307l-0.307-0.012l0.025,0.157l-0.52,0.034l-0.407-0.042l-0.477-0.098l-0.07-0.162l-0.496-0.264l0.795-0.472l0.858-0.621l0.273-0.354l0.563-1.167l0.173-0.104l0.644-0.12l0.367,0.251l0.136,0.268     l-0.28,0.203l-0.228-0.056l0.066,0.496l-0.191,0.124l1.163,0.225l0.225-0.236l0.406-0.113l0.134-0.417l-0.458-0.022l-0.123-0.124l-0.02-0.203l0.236-0.158l-0.171-0.023l-0.558-0.067l0.072-0.328l-0.034-0.13l-0.023-0.034l0.128-0.283l0.572-0.198l0.709-0.238     l0.654,0.03l1.089-0.151l0.245,0.275l0.329,0.045l0.076,0.181l0.259,0z'},
	AT => {name => 'Austria',
		d => 'M421.683,94.397l0.368,0.014l0.164-0.137l0.096,0.11l0.249,0.007l0.104,0.137l0.194,0.048l-0.011,0.165l0.26,0.039l-0.078,0.195h0.215l0.452-0.343l-0.032-0.274l0.237,0.041l0.262-0.055l0.493,0.089l0.093,0.145l0.059,0.144L425.4,94.7     l0.377-0.103l0.044-0.13l0.319-0.014l0.125-0.171l1.25-0.035l0.092-0.178l0.433-0.035l0.195,0.138l0.564-0.062l0.146,0.117l-0.049,0.165l0.441,0.178l0.082-0.055l0.098-0.343l-0.056-0.158l-0.334-0.014l0.197-0.295l-0.538-0.571l0.364-0.227l0.968-0.295     l0.162-0.172l0.039-0.337l0.132-0.027l0.437,0.151l0.682-0.26l0.145,0.014l0.354,0.129l0.483,0.099l0.598-0.163l0.746-0.773l1.374,0.341l1.019,0.227l1.332-0.181l0.545,0.2l0.055,0.095l0.053,0.093l-0.097,0.581l0.155,0.26l0.761,0.547l-0.636,0.291l-0.019,0.367     l-0.701,0.054l-0.164-0.134h-0.325l-0.223,0.197l0.452,0.063l0.136,0.196l-0.157,0.206l-0.409,0.062l-0.04,0.375l0.204,0.188l-0.154,0.294l-0.346,0.299l-0.693,0.157l0.082,0.393l-0.89-0.116l-0.298,0.196l-0.85-0.08l-0.566,0.107l-0.646,0.5l-0.287-0.152     l-0.612,0.009l-0.179-0.107l-1.04-0.065l-0.478-0.112l-0.894-0.082l-1.311-0.247l-0.32-0.391l-0.318-0.096l-0.023-0.363l-0.856,0.227l-0.301-0.103l-0.445,0.11l-0.183-0.083l-0.366,0.096l-0.329,0.411l-0.597-0.034l-0.631-0.171l0.029-0.171l-0.215-0.117     l-0.579,0.332l-0.55-0.242l-0.008-0.144l-0.622-0.062l0.09-0.192l-0.214-0.288l0.266-0.274l-0.193-0.336z'},
	NG => {name => 'Nigeria',
		d => 'M431.763,171.063l-0.067,0.354l0.091,0.72l0.108,0.508l0.225,0.168l0.562,0.11l0.144,0.183l0.077,0.353l-0.089,1.116l-0.146,0.227l-0.274,0.171l-0.885,0.217l-0.291,0.256l-0.664,1.275l-0.503,1.203l-0.243,1.004l-0.354,0.129l-0.369,0.03     l-0.129,0.354l-0.146,1.229l-0.192,0.312l-0.385,0.045l-0.257,0.284l-0.417,0.836l-0.944,2.223l-0.304,0.624l-0.352,0.496l-0.368,0.355l-0.239,0.114l-0.145-0.056l-0.722-0.97l-0.145-0.14l-1.104-0.05l-0.272,0.03l-1.31,1.265l-0.941,0.839l-0.495,0.526     l0.02,0.974l-0.189,0.552l-0.376,0.686l-0.188-0.119l-0.224-0.042l-0.176-0.127l-0.145,0.212l0.144,0.296l-0.063,0.127l-0.353,0.198l-0.56,0.03l-0.977,0.101l-0.607-0.267l-0.288,0.043l-0.271,0.368l-0.177,0.113l-0.432-0.07l-1.247-0.011l-0.528-0.225     l-0.543-0.451l-0.416-0.72l-0.192-0.649l0.048-0.254l0.208-0.254l-0.144-0.296l-0.513-0.069l-0.128-0.254l-0.464-0.55l-0.561-0.465l-0.608-0.253l-0.641-0.253l-0.272-0.31l-0.513,0.072l-0.24,0.297l-0.336,0.071l-0.881,0.044l-0.659,0.03l-0.006-0.234l0.121-1.188     l-0.217-1.439l0.09-0.989l0.012-0.876l-0.003-0.48l-0.002-0.381l0.237-0.397l0.257-0.03l0.433-0.13l0.078-0.368l-0.116-0.592l0.095-0.34l0.656-0.414l0.223-0.298l0.19-0.566l0.316-0.962l-0.388-0.718l-0.164-0.762l0.062-0.777l0.092-0.961l0.158-0.849l0.353-0.482     l0.687-1.614l0.676-0.4l1.064-0.188l1.174-0.108l1.111,0.121l0.821,0.277l1.095,1.223l0.209,0.098l0.37-0.002l1.337-0.544l0.467-0.116l0.354,0.083l1.173,0.742l0.965,0.277l0.934-0.005l0.273-0.059l0.629-0.399l0.403-0.327l0.774-0.287l0.628-0.103l0.709-0.047     l0.531,0.04l0.884,0.221l0.724,0.193l0.609,0.208l0.259-0.058l0.761-0.697l0.453-0.299l0.437-0.2l0.951-0.034l0.173,0.394l0.575,0.52l0.351,0.407z'},
	CM => {name => 'Cameroon',
		d => 'M425.506,195.522l-1.965-0.017l-1.005,0.007l0.029-0.176l-0.208-0.536l0.271-0.989l-0.159-0.72l-0.191-0.522l-0.399-0.649l0.433-0.396l-0.287-0.367l-0.24-0.056l-0.576,0.058l-0.559-0.268l-0.176-0.324l-0.063-0.537l-0.111-0.211     l-0.527-0.14l-0.101-0.064l0.376-0.686l0.189-0.552l-0.02-0.974l0.495-0.526l0.941-0.839l1.31-1.265l0.272-0.03l1.104,0.05l0.145,0.14l0.722,0.97l0.145,0.056l0.239-0.114l0.368-0.355l0.352-0.496l0.304-0.624l0.944-2.223l0.417-0.836l0.257-0.284l0.385-0.045     l0.192-0.312l0.146-1.229l0.129-0.354l0.369-0.03l0.354-0.129l0.243-1.004l0.503-1.203l0.664-1.275l0.291-0.256l0.885-0.217l0.274-0.171l0.146-0.227l0.089-1.116l-0.077-0.353l-0.144-0.183l-0.562-0.11l-0.225-0.168l-0.108-0.508l-0.091-0.72l0.067-0.354     l0.627,0.109l0.208,0.083l0.923,1.238l0.395,0.887l0.119,1.2l-0.134,0.651l0.169,1.228l0.205,0.578l0.381,0.633l0.208,0.21l0.047,0.127l-0.225,0.143l-0.674,0.032l-1.187-0.191l-0.481-0.082l-0.24,0.1l-0.29,0.312l-0.323,0.539l1.088,1.067l1.343,1.179l0.638,1.07     l0.382,1.057l0.208,0.183l-0.208,0.114l-0.354,0.327l-0.866,1.743l-0.4,0.511l-0.528,0.399l-0.144,0.198l-0.064,0.424l0.112,0.776l0.273,1.185l0.207,0.592l0.4,0.661l0.432,0.605l0.064,0.791l0.112,0.324l1.217,1.236l0.498,0.802l0.194,0.804l0.209,0.451     l-0.159,0.185l0.1,0.861l-0.271,0.086l-0.863-0.292l-0.864-0.334l-0.576-0.194l-0.56-0.124l-0.479-0.04l-0.271-0.055l-0.878,0.076l-0.863-0.023l-0.56-0.109l-1.022-0.149l-0.831-0.038l-1.773-0.088l-0.88-0.093l-0.045,0.495z'},
	PK => {name => 'Pakistan',
		d => 'M551.793,147.278l-0.788-0.111l-0.458-0.253l-0.379-0.367l-0.248-1.101l-0.112-0.141l-0.342-0.141l-0.662-0.083l-0.105-0.07l-0.014-0.268l0.116-0.466l-0.178-0.451l-0.418-0.38l-0.294-0.013l-1.181,0.412l-1.229,0.087l-0.81,0.143     l-0.947,0.073l-0.415-0.083l-0.263-0.226l-0.135-0.197l-0.909,0.143l-0.548,0.382l-0.856,0.016l-1.264-0.011l-0.691,0.128l-0.723,0.115l-0.541,0.03l0.182-0.954l0.049-0.354l0.31-0.792l0.285-0.383l0.794-0.47l0.697-0.258l1-0.077l0.209-0.072l0.188-0.255     l0.036-0.974l-0.186-0.281l-0.652-0.053l-0.185-0.394l-0.111-1.34l-0.168-0.38l-0.409-0.224l-1.144-0.388l-0.695-0.391l-0.353-0.464l-0.71-1.068l-0.802-1.083l0.887,0.32l0.63,0.194l1.069,0.248l0.854,0.235l0.541,0.039l0.742,0.024l1.187-0.218l0.349-0.002     l1.005,0.135l1.234-0.12l0.964-0.175l1.183-0.19l1.066-0.274l0.247-0.156l0.069-0.184l0.099-0.903l0.232-0.876l0.188-0.34l0.412-0.369l0.597-0.441l0.283-0.072l0.644,0.039l0.516,0.082l0.254-0.086l0.321-0.693l0.362-0.271l0.559-0.243l0.562,0.025l1.001,0.375     l0.237-0.086l0.34-0.383l0.021-0.084l0.139-1.214l0.288-0.834l0.224-0.424l0.292-0.228l0.416-0.115l0.513-0.031l0.315-0.115l0.199-0.255l-0.088-0.437l-0.129-0.281L556.193,125l-0.35-0.336l0.355-0.129l0.997,0.122l0.698,0.039l0.513-0.215l0.289-0.255     l-0.033-0.31l-0.223-0.478l0.13-0.283l0.4-0.341l0.524-0.355l0.324-0.426l-0.198-0.477l0.119-0.483l-0.232-0.171l-0.01-0.336l-0.411-0.271l-0.01-0.32l0.464-0.413l0.258-0.214l0.246,0.023l0.559-0.395l0.272-0.19l0.53-0.292l1.148-0.152l1.345-0.012l0.647,0.144     l0.338-0.179l0.332,0.005l0.455-0.297l0.358-0.004l0.148-0.142l0.313,0.14l0.105,0.112l0.281-0.21l0.296,0.047l0.554,0.117l0.004,0.456l0.282-0.128l0.625-0.009l0.373,0.323l0.213,0.247l0.007,0.501l-0.312,0.516l0.301,0.07l0.198,0.218l0.252,0.281l0.52-0.196     h0.239l0.104,0.199l0.178,0.09l0.565,0.436l1.337,0.104l0.305,0.111l0.147,0.126l-0.207,0.084l-0.688,0.37l-0.411,0.232l-0.155,0.43l-0.071,0.479l-0.234,0.116l-0.125-0.179l-0.621-0.102l-0.438,0.132l-0.271,0.298l-0.262-0.116l-0.557,0.265l-0.928-0.149     l-0.568-0.138l-1.708-0.325l-0.894,0.265l-0.38,0.611l0.09,0.166h0.336l0.047,0.314l-0.202,0.149l0.101,0.199l0.598-0.017l-0.002,0.347l-0.384,0.099l-0.139,0.413l0.389,0.232l-0.116,0.479l-0.215,0.132l0.089,0.248l0.606,0.298l-0.003,0.532l0.782-0.003     l-0.039,0.43l0.188,0.248l0.702-0.05l0.668,0.377l0.012,0.211l-0.2,0.255l-0.504,0.2l-0.643,0.196l-0.517,0.248l0.032,0.366l0.188,0.377l-0.237,0.977l-1.512,1.503l0.261,0.38l-0.358,0.281l-0.609,0.133l-0.353,0.467l-0.509,1.216l-0.478,0.547l-1.193,0.496     l-0.177,0.364l-0.277,0.481l-0.563,0.61l-0.076,0.38l-0.71,0.259l-0.734-0.011l-0.895,0.314l-0.361-0.094l-0.158-0.518l-0.207-0.132l-0.404,0.083l-0.535,0.463l-0.144,0.446l-0.979,0.893l-0.186,0.543l-0.079,0.269l0.116,0.38l0.541,0.163l0.504,0.085l0.425,0.014     l-0.114,0.689l-0.154,0.735l0.412,0.411l0.33,0.099l0.537-0.099l0.112,0.441l0.216,0.507l0.654,1.333l-0.232,0.149l0.241,0.463l-0.317,0.066l-0.15,0.248l-0.55,0.083l-0.145-0.335l-0.183-0.062l-0.78,0.215l-0.2,0.331l-0.735-0.099l-0.229-0.149l-0.835-0.021     l-0.835-0.009l-0.259-0.052l0.015,0.728l-0.866,0.017l-0.296,0.431l-0.37,0.036z'},
	IN => {name => 'India',
		d => 'M606.155,150.953l-0.037-0.466l-0.627-2.479l-0.064-0.578l-0.4,0.044l-0.281,0.115l-0.395,1.159l-0.224,0.354l-0.529-0.448l-0.249-0.267l-0.23-0.281l-0.001-0.381l-0.009-0.522l0.131-0.283l0.651-0.356l0.498-0.13l0.938-0.767l0.159-0.34     l0.012-0.79l-0.057-0.127l-0.111-0.098l-2.473-0.198l-0.559,0.003l-0.916,0.062l-0.547-0.053l-0.537-0.109l-0.095-0.099l-0.079-0.719l-0.053-0.479l-0.129-0.324l-0.417-0.054l-0.489,0.06l-0.372-0.266l-0.339-0.266l-1.252-0.303l-0.234,0.171l-0.555,0.525     l-0.124,0.283l0.083,0.155l0.494,0.237l1.224,0.938l0.126,0.112l-0.047,0.155l-0.382,0.101l-0.502,0.13l-0.4,0.299l-0.548,0.61l0.339,0.323l1.042,0.431l0.193,0.21l-0.029,0.269l-0.505,0.765l0.04,0.254l0.352,0.45l0.325,1.409l0.402,1.775l0.147,0.532     l-0.172,0.322l0.068,0.183l-0.321,0.071l-0.35-0.056l-0.148-0.706l-0.198-0.084l-0.253,0.354l-0.171,0.354l-0.172,0.057l-0.115-0.099l-0.28-0.592l-0.152-0.169l-0.412,0.537l-0.504,0.298l-0.992,0.397l-0.571,0.213l-0.264,0.226l-0.05,0.113l0.106,0.579     l0.183,0.409l-0.336,0.495l-0.305,0.332l-0.013,0.257l-0.548,0.415l-0.593,0.467l-0.467,0.185l-0.432,0.057l-0.746,0.206l-0.591,0.362l-0.459,0.58l-0.551,0.552l-0.88,1.061l-0.611,0.552l-0.673,0.276l-0.675,0.829l-0.676,0.467l-0.728,0.368l-0.452,0.241     l-0.427,0.312l-0.192,0.509l-0.073,0.466l-0.341,0.41l-0.649,0.298l-0.428,0.058l-0.506-0.098l-0.258,0.269l-0.366,0.887l-0.277,0.23l-0.505-0.253l-0.614,0.142l-0.354,0.283l-0.304,0.565l-0.165,0.48l-0.005,0.508l0.166,1.539l0.018,0.805l-0.208,0.495     l0.227,0.324l0.315,0.423l-0.015,0.508l-0.199,0.607l-0.669,1.611l-0.341,0.834l-0.13,0.636l0.047,0.649l0.21,1.764l-0.081,0.24l-0.643,0.001l-0.433-0.013l-0.186,0.142l-0.334,0.961l-0.324,0.594l0.025,0.127l0.493,0.352l-0.805,0.327l-0.306,0.015l-0.77,0.284     l-0.295,0.41l-0.101,0.692l-0.157,0.255l-0.367,0.283l-0.526,0.255l-0.099,0.057l-0.066,0.042l-0.231,0.156h-0.145l-0.174-0.056l-1.417-1.451l-0.092-0.395l-0.276-0.522l-0.34-1.397l-0.689-1.792l-0.94-1.933l-0.979-1.508l-0.554-1.722l-0.507-1.792l-0.738-1.636     l-0.82-1.42l-0.424-0.737l-0.598-1.439l-0.363-1.157l-0.767-3.274l-0.469-2.695l-0.157-1.566l-0.051-0.24l0.232-0.565l0.546-0.834l0.007-0.311l-0.404-0.281l-0.367-0.437l-0.113-0.635l-0.108-0.917l0.065-0.622l-0.837,0.03l-0.19,0.212l-0.235,0.424l0.009,0.183     l0.276,0.254l0.074,0.183l-0.073,0.438l-0.301,0.438l-0.503,0.368l-0.812,0.369l-0.504,0.114l-0.617,0.255l-0.377,0.015l-0.861-0.281l-0.572-0.38l-1.018-1l-1.391-1.268l-0.516-0.705l0.267-0.043l1.062,0.125l0.615-0.086l0.443-0.142l0.461-0.283l0.521-0.608     l-0.067-0.24l-0.156,0.071l-0.587,0.114l-0.847-0.026l-0.607-0.112l-0.632-0.132l-0.5-0.218l-0.203-0.07l-0.929-0.661l-0.668-0.775l-0.057-0.197l0.37-0.036l0.296-0.431l0.866-0.017l-0.015-0.728l0.259,0.052l0.835,0.009l0.835,0.021l0.229,0.149l0.735,0.099     l0.2-0.331l0.78-0.215l0.183,0.062l0.145,0.335l0.55-0.083l0.15-0.248l0.317-0.066l-0.241-0.463l0.232-0.149l-0.654-1.333l-0.216-0.507l-0.112-0.441L557,143.058l-0.33-0.099l-0.412-0.411l0.154-0.735l0.114-0.689l-0.425-0.014l-0.504-0.085l-0.541-0.163     l-0.116-0.38l0.079-0.269l0.186-0.543l0.979-0.893l0.144-0.446l0.535-0.463l0.404-0.083l0.207,0.132l0.158,0.518l0.361,0.094l0.895-0.314l0.734,0.011l0.71-0.259l0.076-0.38l0.563-0.61l0.277-0.481l0.177-0.364l1.193-0.496l0.478-0.547l0.509-1.216l0.353-0.467     l0.609-0.133l0.358-0.281l-0.261-0.38l1.512-1.503l0.237-0.977l-0.188-0.377l-0.032-0.366l0.517-0.248l0.643-0.196l0.504-0.2l0.2-0.255l-0.012-0.211l-0.668-0.377l-0.702,0.05l-0.188-0.248l0.039-0.43l-0.782,0.003l0.003-0.532l-0.606-0.298l-0.089-0.248     l0.215-0.132l0.116-0.479l-0.389-0.232l0.139-0.413l0.384-0.099l0.002-0.347l-0.598,0.017l-0.101-0.199l0.202-0.149l-0.047-0.314h-0.336l-0.09-0.166l0.38-0.611l0.894-0.265l1.708,0.325l0.568,0.138l0.928,0.149l0.557-0.265l0.262,0.116l0.271-0.298l0.438-0.132     l0.621,0.102l0.125,0.179l0.234-0.116l0.071-0.479l0.155-0.43l0.411-0.232l0.688-0.37l0.207-0.084l0.502-0.152v0.515l0.441,1.03l0.221,0.515l0.81,0.11l0.441,0.405l0.221,0.258l-0.331,0.221l-0.184,0.184l0.073,0.589l0.037,0.552l0.294,0.221l0.718,0.096     l0.092,0.078l0.044,0.182l0.68,0.099l-0.104,0.414l0.367,0.694l-0.578,0.364l-0.376,0.281l-0.368,0.049l-0.337-0.264l-0.033-0.364l-0.785,0.198l0.157,0.694l0.579,0.595l-0.104,0.446l0.272,0.364l-0.215,0.215l0.099,0.43l0.198,0.066l0.477-0.314l0.383,0.248     l0.772,0.843l0.363-0.116l1.078,0.579l-0.116,0.364l0.756,0.248l0.154-0.066l0.859,0.596l-1.07,0.909l-0.281,0.116l0.008,0.364l-0.221,0.265l0.04,0.396l-0.309,0.397l-0.218,0.43l0.039,0.248l0.63,0.38l0.466-0.083l0.665,0.479l0.704,0.149l0.305,0.529     l1.242,0.678l0.231-0.166l1.027,0.595l0.538-0.066l0.182,0.397l0.835,0.166l0.304,0.198l0.15-0.066l0.087-0.215h0.503l0.482,0.265l0.582-0.347l0.494,0.298l0.643,0.066l0.142,0.231l-0.101,0.446l0.663,0.149l0.286,0.281l0.618,0.265l0.584-0.281l0.313,0.066     l-0.034,0.331l0.312,0.248l0.379-0.231l0.721,0.148l0.847,0.364l0.606-0.297l0.268,0.364l0.399,0.116l0.357-0.132l0.271,0.083l0.687-0.132l0.336,0.05l0.311-0.694l-0.429-0.827l0.07-0.876l0.318-0.761l-0.037-0.022l0.345-0.129l0.471-0.102l0.231,0.069     l0.139,0.183l-0.052,0.861l0.212,0.662l-0.092,0.113l0.235,0.493l0.637,0.18l0.559,0.081l0.869,0.214l0.085,0.021l0.544-0.074l0.531-0.313l0.301,0.055l0.335,0.125l1.238,0.063l1.036-0.062l0.624-0.06l0.217-0.58l-0.017-0.282l-0.258-0.238l-0.313-0.069     l-0.326-0.294l-0.042-0.24l0.07-0.156l0.189-0.1l0.784-0.033l0.714-0.216l0.397-0.27l1.123-1.107l0.543-0.37l0.829-0.258l1.105-0.726l0.546-0.299l0.355-0.087l0.286,0.167l0.975,0.319l0.377-0.044l1.377-0.84l0.455,0.392l0.716,0.715l0.046,0.38l-0.354,0.454     l-0.138,0.269l0.102,0.056l0.3,0.055l0.657,0.081l0.73,0.179l0.624,0.081l-0.018,0.508l-0.112,0.24l-0.596,0.582l-0.072,0.283l0.184,0.718l-0.295,0.058l-0.853-0.221l-0.558-0.082l-0.312,0.129l-0.719,0.512l-1.446,0.883l-0.197,0.354l0.057,0.761l-0.136,0.382     l-0.938,1.134l-0.045,0.212l0.192,0.408v0.324l-1.148,2.25l-0.17,0.128l-0.309-0.013l-0.391-0.11l-0.811-0.32l-0.133,0.283l0.146,1.594l-0.191,0.354l-0.401,0.144l-0.228,0.185l0.152,0.93l-0.015,0.678l-0.273,0.368l-0.25,0.129l-0.255-0.14l-0.595-0.152z'},
	JO => {name => 'Jordan',
		d => 'M478.516,135.173l0.052-0.292l-0.049-0.169l-0.197-0.107l0.107-0.175l0.292-0.919l-0.015-0.818l0.517-1.09l0.3-0.891l-0.004-0.409l0.133-0.283l0.07-0.749l0.033-0.847l0.062-0.174l0.026-0.278l-0.065-0.411l0.037-0.119l0.102-0.063     l1.902,1.034l0.365,0.167l0.253-0.016l1.139-0.656l2.96-1.541l0.161-0.071l0.87,1.632l0.311,0.69l0.093,0.056l-0.46,0.44l-0.257,0.171l-0.97,0.26l-2.586,0.622l-0.646,0.229l1.146,1.32l0.698,0.885l-0.765,0.724l-0.456,0.37l-0.24,0.072l-1.249,0.332l-0.462,0.61     l-0.975,0.782l-2.079-0.299l-0.154-0.017z'},
	LY => {name => 'Libya',
		d => 'M456.028,151.46l-0.021,1.003l0.033,3.078l-0.088,0.17l-1.561-0.019l-0.52-0.011l-0.073,1.13l-1.981-0.963l-5.577-2.792l-4.941-2.372l-5.231-2.554l-0.41,0.059l-1.818,0.858l-1.519,0.729l-0.231,0.157l-1.192-0.911l-0.258-0.182     l-1.008-0.333l-1.646-0.442l-0.832-0.137l-0.098-0.07l-0.86-1.506l-0.178-0.168l-1.028-0.347l-0.702-0.165l-0.544,0.201l-0.244-0.154l-0.562-0.873l-0.249-0.917l-1.272-1.702l0.152-0.283l0.249-0.128l0.666-0.47l0.086-0.17l0.061-0.664l-0.457-1.156l0.158-0.495     l0.16-0.622l-0.101-0.748l0.1-0.862l-0.052-0.691l-0.147-0.833l-0.88-1.605l0.241-0.383l0.204-0.156l0.22-0.143l0.864-0.598l0.155-0.227l0.147-0.537l-0.274-0.973l0.126-0.354l1.473-1.138l0.579-0.314l0.802-0.428l0.093-0.269l-0.064-0.564l0.093-0.981l1.436,0.59     l0.995,0.309l0.521,0.013l0.863-0.129l0.604,0.027l1.552,0.223l0.614,0.479l0.794,0.224l0.486-0.001l0.342,0.197l0.173,0.226l0.26,0.819l0.39,0.564l0.688,0.591l0.378,0.126l0.678,0.14l1.031,0.083l0.447,0.07l0.973,0.224l0.639,0.224l0.552,0.281l1.289,0.788     l0.84,0.464l0.465,0.013l0.441-0.128l0.758-0.411l0.706-0.623l0.3-0.523v-0.254l-0.276-0.621l-0.112-0.579l0.044-0.41l0.237-0.537l0.661-0.58l0.333-0.198l0.554-0.241l0.644-0.298l1.376-0.413l1.205,0.054l0.728,0.154l0.844,0.365l0.188,0.169l0.043,0.508     l0.281,0.253l0.301,0.014l0.945,0.125l0.712,0.309l0.45,0.027l1.286,0.04l0.302,0.197l0.068,0.381l0.276,0.296l-0.099,0.208l-0.369,0.228l-0.21,0.34l0.354,1.283l-0.231,0.425l-0.322,0.553l-0.056,0.311l0.185,0.945l0.388,0.916l0.042,0.367l-0.015,0.988     l-0.019,3.869l-0.016,1.468l-0.008,2.048l-0.001,0.692l0.045,2.81l-0.021,1.342l0.011,2.612z'},
	IL => {name => 'Israel',
		d => 'M478.212,134.714l-0.834-1.746l-0.796-1.944l-0.124-0.289l0.109-0.066l0.679-0.851l0.219-0.438l0.183-0.507l0.171-0.566l0.188-0.822l0.116,0.018l0.137-0.093l0.006-0.204l0.028-0.315l0.372-0.051l0.151,0.022l0.07,0.099l0.355-0.07     l0.009-0.167l0.067-0.193l0.088-0.041l0.07,0.023l0.183,0.346l0.201,0.128l0.021,0.183l-0.047,0.122l0.082,0.085l-0.102,0.063l-0.037,0.119l0.065,0.411l-0.026,0.278l-0.062,0.174l-0.033,0.847l-0.07,0.749l-0.133,0.283l0.004,0.409l-0.3,0.891l-0.517,1.09     l0.015,0.818l-0.292,0.919l-0.107,0.175l-0.067,0.068l-0.042,0.042z'},
	SA => {name => 'Saudi Arabia',
		d => 'M495.751,163.817l-0.03-0.184l-0.112-0.537l-0.508-0.945l-0.73-0.987l-0.438-0.493l-0.846-0.69l-0.51-0.875l-0.814-1.876l-0.474-0.889l-0.28-0.409l-0.794-0.507l-1.271-0.689l-0.527-0.634l-0.8-1.17l-0.081-0.96l-0.061-0.776l-0.002-0.89     l-0.104-0.381l-0.312-0.663l-0.944-1.65l-0.357-0.494l-0.758-0.62l-0.459-0.225l-0.499-0.126l-0.308-0.282l-0.483-0.578l0.149-0.692l-0.111-0.437l-0.474-0.818l-0.747-1.072l-0.793-0.902l-1.069-1.494l-0.525-0.931l-0.352-0.479l-0.722-0.761l-0.524-0.056     l-0.248,0l0.077-0.296l0.193-0.283l0.311-1.314l0.104-0.583l0.154,0.017l2.079,0.299l0.975-0.782l0.462-0.61l1.249-0.332l0.24-0.072l0.456-0.37l0.765-0.724l-0.698-0.885l-1.146-1.32l0.646-0.229l2.586-0.622l0.97-0.26l0.257-0.171l0.46-0.44l0.093,0.056     l1.129,0.459l0.757,0.222l2.034,0.934l1.14,0.473l2.44,1.101l0.258,0.196l0.399,0.633l0.141,0.07l0.973-0.048l0.135,0.366l-0.118,0.396l0.047,0.818l0.118,0.253l0.812,0.277l1.557,0.697l4.048,0.132l1.657,0.259l0.408,0.054l0.334,0.619l0.185,0.239l1.07,0.05     l0.644-0.044l0.043,0.121l0.277,0.648l0.365,0.494l0.178,0.663l0.052,0.113l0.615-0.029l0.248,0.126l-0.204,0.237l0.194,0.187l0.184,0.282l0.234,0.067l0.234,0.27l0.886,0.168l0.423,0.437l-0.07,0.28l-0.235,0.035l-0.111,0.25l0.316,0.381l-0.188,0.593     l-0.122,0.198l0.165,0.268l0.302,0.666l0.149-0.117l0.372,0.282l0.105,0.616l0.422,0.696l-0.028,0.423l0.222,0.268l0.16,0.197l0.287,0.084l0.136-0.007l0.336,0.083l1.043,2.198l0.548,1.154l0.261,0.902l3.362,0.375l3.387,0.446l0.839,0.108l0.584-0.469     l0.152-0.057l0.581,0.914l0.155,1.453l-5.346,2.982l-2.35,1.213l-1.691,0.815l-0.169,0.085l-1.148,0.346l-3.097,1.035l-4.618,1.566l-0.484,0.229l-0.041,0.127l-0.383,0.397l-1.907,2.271l-2.042,2.667l-1.302-2.703l-1.211-2.45l-0.452-0.012l-0.715,0.047     l-0.446-0.125l-0.671-0.151l-0.216,0.1l-0.174,0.185l-0.11,0.495l0.041,0.678l-0.113,0.565l-0.692,0.563z'},
	EG => {name => 'Egypt',
		d => 'M476.458,130.735l0.124,0.289l0.796,1.944l0.834,1.746l-0.38,0.381l-0.479,1.145l-0.334,1.413l-0.171,0.593l-0.18,0.156l-0.407-0.07l-0.448-0.521l-0.782-0.676l-0.386-0.494l-0.338-0.988l-0.521-0.45l-0.289-0.621l-0.17-0.479l-0.198-0.353     l-0.466,0.17l-0.267,0.523l0.604,1.34l0.131,0.381l0.634,0.86l0.933,1.042l0.473,1.199l0.526,0.973l0.277,0.818l0.391,0.465l0.912,1.735l1.072,1.904l0.428,0.705l0.586,0.549l0.451,0.352l0.151,0.183l-0.241,0.17l-0.285,0.1l-0.043,0.155l0.238,1.087l0.252,0.467     l0.127,0.238l0.812,0.591l0.397,0.168l0.406,0.521l0.416,0.38l0.311,0.56l-10.382-0.006l-2.138-0.001l-2.774,0.002l-2.513,0.015l-2.268-0.029l-1.664,0.01l-1.241,0.007l-1.614-0.019l-0.914,0.005l-0.819,0.089l-0.011-2.612l0.021-1.342l-0.045-2.81l0.001-0.692     l0.008-2.048l0.016-1.468l0.019-3.869l0.015-0.988l-0.042-0.367l-0.388-0.916l-0.185-0.945l0.056-0.311l0.322-0.553l0.231-0.425l-0.354-1.283l0.21-0.34l0.369-0.228l0.099-0.208l0.337,0.168l0.553-0.015l0.628-0.1l0.786-0.001l1.513,0.293l0.587,0.115l0.779,0.122     l0.721,0.154l0.348,0.409l0.4,0l0.928,0.083l0.998,0.394l0.628,0.069l0.245-0.127l0.72-0.538l0.925-0.397l0.837-0.186l0.78-0.27l0.375-0.072l0.346,0.056l0.535-0.001l0.723,0.126l0.202,0.465l0.596,0.366l0.518-0.156l0.64,0.267l0.382,0.027l0.561-0.401     l0.241,0.179l0.277,0.056l0.674,0.13l0.338-0.062l0.46-0.165l0.51-0.308z'},
	NP => {name => 'Nepal',
		d => 'M580.625,132.873l0.24,0.43l0.299,0.05l0.276-0.314l0.134-0.513l0.275,0.066l0.186-0.182l1.079,0.199l0.132,0.612l0.867,0.264l0.726,0.595l0.472,0.215l0.15-0.132l0.454,0.281l0.657,0.794l0.158-0.166l0.71-0.116l0.289,0.166l0.178,0.38     l-0.069,0.281l1.451,0.893l0.333-0.248l0.326,0.017l-0.175,0.396l0.014,0.265l0.935,0.066l0.365-0.066l0.54,0.496l0.141,0.463l0.237-0.099l-0.01-0.364l0.685,0.38l0.271-0.083l0.08-0.331h0.407l0.63,0.281l0.319,0.364l0.849-0.066l0.341,0.116l0.339-0.281     l0.655,0.159l0.037,0.022l-0.318,0.761l-0.07,0.876l0.429,0.827l-0.311,0.694l-0.336-0.05l-0.687,0.132l-0.271-0.083l-0.357,0.132l-0.399-0.116l-0.268-0.364l-0.606,0.297l-0.847-0.364l-0.721-0.148l-0.379,0.231l-0.312-0.248l0.034-0.331l-0.313-0.066     l-0.584,0.281l-0.618-0.265l-0.286-0.281l-0.663-0.149l0.101-0.446l-0.142-0.231l-0.643-0.066l-0.494-0.298l-0.582,0.347l-0.482-0.265h-0.503l-0.087,0.215l-0.15,0.066l-0.304-0.198l-0.835-0.166l-0.182-0.397l-0.538,0.066l-1.027-0.595l-0.231,0.166l-1.242-0.678     l-0.305-0.529l-0.704-0.149l-0.665-0.479l-0.466,0.083l-0.63-0.38l-0.039-0.248l0.218-0.43l0.309-0.397l-0.04-0.396l0.221-0.265l-0.008-0.364l0.281-0.116l1.07-0.909z'},
	MR => {name => 'Mauritania',
		d => 'M374.125,167.166l-1.41-0.924l-0.661-0.604l-0.537-0.788l-0.292-0.662l-0.15-0.183l-0.312-0.154l-0.567-0.053l-0.655-0.307l-0.695-0.561l-0.604-0.194l-0.567-0.025l-1.209,0.12l-1.821,0.194l-0.523,0.417l0.06-0.502l0.563-1.301l0.188-0.819     l0.13-1.13l-0.162-1.101l-0.3-0.791l-0.624-0.747l0.267-0.283l0.182-0.424l0.067-0.975l-0.065-0.537l-0.174-0.353l-0.808-0.817l-0.297-0.112l-0.393,0.438l-0.055-0.197l-0.013-0.381l0.08-0.689l0.474,0.013l5.055,0.056l2.396,0.014l0.732-0.033l0.212,0.027     l-0.051-1.102l-0.164-1.539l0.01-0.707l0.249-0.383l0.575-0.427l0.726-0.315l0.809-0.287l0.144-0.128l0.099-2.6l0.07-2.261l0.047-0.509l0.557-0.074l6.005,0.022l0.56,0.011l0.104-0.396l-0.002-0.65l0.03-1.752l2.829,1.509l4.12,2.42l1.414,0.91l-0.523,0.13     l-3.231,0.089l0.049,0.776l0.908,7.962l0.19,1.468l0.178,1.736l0.325,2.753l0.202,2.386l0.186,1.468l0.724,0.787l-0.379,1.613l-6.457,0.01l-1.953,0.026l-0.945,0.344l-0.387,0.031l-0.485-0.054l-0.713-0.137l-0.535-0.124l-0.06,0.212l0.055,0.296l-0.107,0.269     l-0.454-0.082l-0.214-0.168l-0.568-0.83l-0.261-0.111l-0.402,0.073l-0.252,0.256l-0.181,0.552l-0.018,0.607l-0.332,0.284z'},
	SD => {name => 'Sudan',
		d => 'M476.114,191.139l-0.563,0.54l-0.626,0.314l-0.367,0.016l-0.303-0.196l-0.303-0.097l-0.88,0.132l-0.881,0.33l-0.911,0.048l-0.942-0.234l-0.495-0.011l-0.464,0.087l-0.496,0.229l-1.288-1.32l-1.032-0.926l-0.207-0.083l-0.258,0.157     l-0.436,0.582l-0.16,0.1l-0.684-0.631l-0.384-0.012l-0.529,0.37l-0.258,0.242l-0.352,0.016l-0.366-0.195l-0.525-0.477l-0.348-0.493l-0.795-0.772l-0.143-0.239l-0.031-0.07l0.083-0.679l-0.157-0.352l-0.558-0.477l-0.814-0.165l-0.367-0.224l-0.285-0.436     l-0.059-0.72l-0.206-0.366l-0.207-0.168l-0.717-0.434l-0.558-0.378l-0.445-0.351l-0.173-0.395l0.148-0.481l-0.223-0.267l-0.351-0.196l-0.799-0.235l-0.797-0.447l-0.223-0.225l-0.252-0.493l-0.207-0.126l-0.272,0.001l-0.802,0.019l-0.158-0.211l-0.01-0.664     l0.416-1.472l-0.122-0.536l-0.347-0.549l-1.342-1.673l0.15-0.425l-0.026-0.367l-0.266-0.465l-0.444-0.407l-0.155-0.295l-0.137-0.522l-0.221-1.228l-0.141-0.225l-0.338-0.012l-0.517,0.088l-0.219-0.352l0.316-0.609l0.542-0.596l0.087-0.34l-0.342-0.662l0.053-0.24     l0.718-0.428l0.149-0.212l-0.131-0.677l0.122-0.438l0.583-0.809l0.417-1.245l0.229-0.143l1.245-0.05l0.839,0.009l0.04-0.283l-0.031-1.229l-0.036-1.002l0.038-0.749l-0.085-2.5l0.036-0.636l0.016-0.946l0.02-1.045l0.073-1.13l0.52,0.011l1.561,0.019l0.088-0.17     l-0.033-3.078l0.021-1.003l0.819-0.089l0.914-0.005l1.614,0.019l1.241-0.007l1.664-0.01l2.268,0.029l2.513-0.015l2.774-0.002l2.138,0.001l10.382,0.006l0.229,0.414l0.499,1.115l0.281,3.501l0.319,1.637l0.182,0.211l0.625,0.394l0.595,0.366l0.617,0.507     l0.491,0.197l0.254,0.223l-0.238,0.199l-0.277,0.327l-0.306,0.566l-0.369,0.242l-0.511,0.172l-0.427,0.116l-0.153,0.142l-0.235,0.496l-0.348,0.171l-0.73,0.033l-0.204,0.552l-0.038,0.452l-0.202,0.862l-0.242,0.722l-0.541,1.302l-0.068,0.495l0.092,0.903     l-0.013,0.679l-0.001,0.083l-0.148,0.947l-0.398,1.231l-0.214,1.061l-1.04,0.331l-0.414,0.37l-0.693,1.134l-0.154,0.34l-0.191,1.088l-0.141,1.074l-0.197,0.185l-0.274,0.044l-0.431-0.096l-0.259,0.072l-0.163,0.114l-0.187,1.103l-0.115,0.933l-0.2,1.272     l0.039,0.522l-0.229,1.159l-0.469,0.299l-0.288-0.012l-0.928-0.122l-0.321,0.03l-0.188,0.806l-0.054,0.466l0.094,0.141l0.479,0.11l0.734,0.123l0.334,0.167l0.805,0.913l1.06,1.067l0.751,1.464l0.345,0.732l0.348,0.421l0.462,0.28l0.415,0.097l0.269,0.309     l0.117,0.988l-0.034,0.17l-0.018,0.141l-0.079-0.028l-0.464,0.017l-1.009,0.133l-0.832,0.005l-0.671-0.052l-0.291,0.327l-0.678,0.795z'},
	YE => {name => 'Yemen',
		d => 'M518.402,163.079l-0.282,0.097l-0.538,0.27l-0.656,0.566l-0.265,0.297l-0.166,0.508l-0.062,0.41l-0.41,0.326l-1.418,0.652l-2.27,0.641l-1.285,0.412l-0.843,0.312l-0.356,0.297l-0.473,0.622l-0.436,0.269l-0.506,0.114l-0.593-0.069     l-0.521,0.072l-0.83,0.439l-0.65,0.396l-0.956,0.397l-0.752,0.199l-1.16,0.003l-0.562-0.013l-0.297,0.128l-0.386,0.312l-0.272,0.297l-0.45,0.312l-0.511,0.241l-0.389,0.043l-0.239-0.042l-0.535,0.411l-0.839,0.058l-0.494-0.112l-0.623-0.437l-0.17-0.155     l-0.317-0.437l-0.084-0.254l0.18-0.721l-0.081-0.635l-0.312-0.507l-0.341-1.171l-0.572-1.919l-0.072-0.438l0.268-0.707l-0.124-0.748l0.692-0.563l0.113-0.565l-0.041-0.678l0.11-0.495l0.174-0.185l0.216-0.1l0.671,0.151l0.446,0.125l0.715-0.047l0.452,0.012     l1.211,2.45l1.302,2.703l2.042-2.667l1.907-2.271l0.383-0.397l0.041-0.127l0.484-0.229l4.618-1.566l3.097-1.035l1.148-0.346l0.169-0.085l0.092,0.663l0.226,0.634l0.604,0.971l0.933,1.364l0.127,0.253l-0.006,0.296l0.483,0.689l0.241,0.306z'},
	ER => {name => 'Eritrea',
		d => 'M494.64,172.627l-0.261-0.166l-0.476-0.633l-0.475-0.159l-0.437-0.911l-1.267-0.792l-0.277-0.594l-0.673-0.673l-0.594-0.119l-0.871-0.554l-0.555,0.079l-0.158-0.158l-0.237,0.04l-0.277-0.198l-0.356,0.159l-0.476,0.079l-0.277-0.436     l-0.158,0.237l-0.436,0.198l-0.792,0.079l-0.554-0.594h-0.238l-0.396-0.317l-0.832,1.663l-0.436-0.871l-0.475,0.079l-0.277,0.356l-0.396-0.08l-0.349,0.041l0.013-0.679l-0.092-0.903l0.068-0.495l0.541-1.302l0.242-0.722l0.202-0.862l0.038-0.452l0.204-0.552     l0.73-0.033l0.348-0.171l0.235-0.496l0.153-0.142l0.427-0.116l0.511-0.172l0.369-0.242l0.306-0.566l0.277-0.327l0.238-0.199l0.098,0.129l0.718,2.102l0.442,1.623l0.689,1.919l0.618,0.832l0.205-0.212l-0.072-0.479l0.093-0.226l0.31,0.253l0.4,0.677l0.384,0.395     l0.534-0.043l0.242,0.014l1.338,1.282l0.809,0.916l0.124,0.099l0.706,0.055l0.618,0.874l0.021,0.24l-0.025,0.198l0.118,0.212l0.507,0.182l0.915,0.869l-0.075,0.094l-0.529,0.78l-0.331-0.182l-0.396-0.125l-0.214,0.114l-0.055,0.085z'},
	SN => {name => 'Senegal',
		d => 'M370.147,172.035l-2.301-0.043l-1.045,0.006l-0.505,0.384l-0.51,0.187l-0.74-0.024l-0.819,0.047l-0.463,0.139l-0.009-0.003l-0.278-0.226l-0.169-0.409l0.104-0.424l-0.095-0.55l-0.018-0.198l0.001-0.046l1.695,0.014v-0.434h0.155l0.341-0.016     l0.186-0.077l0.248,0.062l0.294-0.046l0.124-0.093l0.016-0.263l0.077-0.078l0.14-0.016l0.155,0.155l0.232,0.124l0.356,0.108l0.046,0.108l0.139,0.047l0.217-0.031l0.263,0.108l0.186,0.17h0.434l0.186-0.108l0.263-0.108h0.279l0.108-0.124l0.016-0.124l-0.155-0.217     l-0.202-0.077l-0.201,0.031l-0.294,0.093l-0.108,0.093l-0.248,0.062l-0.279-0.186l-0.031-0.186l-0.186-0.108l-0.17-0.015l-0.186,0.124l-0.139-0.108l-0.108-0.217l-0.155-0.108l-0.201,0.031l-0.17-0.062l-0.387,0.17l-0.108-0.108l-0.155,0.046l-0.202,0.124     l-0.093,0.294h-1.664l-0.007-0.067l-0.028-0.269l-0.377-0.268l-0.068-0.155l-0.057-0.367l-0.386-0.635l-0.399-0.494l-0.379-0.31l-0.472-0.183l0.54-0.34l0.723-0.75l0.588-1.004l0.334-0.82l0.099-0.826l0.523-0.417l1.821-0.194l1.209-0.12l0.567,0.025l0.604,0.194     l0.695,0.561l0.655,0.307l0.567,0.053l0.312,0.154l0.15,0.183l0.292,0.662l0.537,0.788l0.661,0.604l1.41,0.924l-0.506,0.399l-0.057,0.339l0.251,1.1l0.144,0.663l0.22,0.479l0.181,0.197l0.554,0.322l0.265,0.337l0.082,0.833l-0.004,0.565l-0.062,0.142l-0.146-0.042     l-0.963,0.091l-0.658,0.074l-0.725-0.081l-0.503-0.209l-0.795-0.32l-1.255-0.021z'},
	ET => {name => 'Ethiopia',
		d => 'M495.973,175.881l-0.363,0.807l0.083,0.409l0.428,0.732l0.587,0.844l0.732,0.801l0.596,0.547l0.634,0.321l0.54,0.209l4.26,1.443l1.447,0.472l1.875-0.04l0.236,0.154l-4.087,4.205l-1.562,1.69l-0.813,0.909l-0.8,0.004l-1.693-0.046     l-0.626,0.088l-0.562,0.215l-0.388,0.214l-0.502,0.497l-0.294,0.426l-0.337,0.115l-1.216,0.078l-0.305,0.101l-0.453,0.511l-1.103-0.106l-0.461-0.181l-0.46-0.336l-0.271-0.098l-0.852,0.358l-0.675,0.343l-0.258,0.199l-0.71,0.753l-0.16,0.114l-0.847-0.094     l-0.67-0.193l-1.373-0.133l-0.335-0.041l-2.353-1.525l-0.604-0.293l-0.749-0.193l-1.054-0.149l-0.319-0.069l0.018-0.141l0.034-0.17l-0.117-0.988l-0.269-0.309l-0.415-0.097l-0.462-0.28l-0.348-0.421l-0.345-0.732l-0.751-1.464l-1.06-1.067l-0.805-0.913     l-0.334-0.167l-0.734-0.123l-0.479-0.11l-0.094-0.141l0.054-0.466l0.188-0.806l0.321-0.03l0.928,0.122l0.288,0.012l0.469-0.299l0.229-1.159l-0.039-0.522l0.2-1.272l0.115-0.933l0.187-1.103l0.163-0.114l0.259-0.072l0.431,0.096l0.274-0.044l0.197-0.185     l0.141-1.074l0.191-1.088l0.154-0.34l0.693-1.134l0.414-0.37l1.04-0.331l0.214-1.061l0.398-1.231l0.148-0.947l0.001-0.083l0.349-0.041l0.396,0.08l0.277-0.356l0.475-0.079l0.436,0.871l0.832-1.663l0.396,0.317h0.238l0.554,0.594l0.792-0.079l0.436-0.198     l0.158-0.237l0.277,0.436l0.476-0.079l0.356-0.159l0.277,0.198l0.237-0.04l0.158,0.158l0.555-0.079l0.871,0.554l0.594,0.119l0.673,0.673l0.277,0.594l1.267,0.792l0.437,0.911l0.475,0.159l0.476,0.633l0.261,0.166l-0.594,0.921l-0.488,0.61l-0.105,0.254     l-0.029,0.396l0.202,1.157l0.5-0.074l0.892-0.246l0.4,0.04l0.556,0.195z'},
	GM => {name => 'Gambia',
		d => 'M364.011,169.929h1.664l0.093-0.294l0.202-0.124l0.155-0.046l0.108,0.108l0.387-0.17l0.17,0.062l0.201-0.031l0.155,0.108l0.108,0.217l0.139,0.108l0.186-0.124l0.17,0.015l0.186,0.108l0.031,0.186l0.279,0.186l0.248-0.062l0.108-0.093     l0.294-0.093l0.201-0.031l0.202,0.077l0.155,0.217l-0.016,0.124l-0.108,0.124h-0.279l-0.263,0.108l-0.186,0.108h-0.434l-0.186-0.17l-0.263-0.108l-0.217,0.031l-0.139-0.047l-0.046-0.108l-0.356-0.108l-0.232-0.124l-0.155-0.155l-0.14,0.016l-0.077,0.078     l-0.016,0.263l-0.124,0.093l-0.294,0.046l-0.248-0.062l-0.186,0.077l-0.341,0.016h-0.155v0.434l-1.695-0.014l0.019-0.477l0.173-0.198l0.434-0.058l0.093-0.155l-0.006-0.059z'},
	DJ => {name => 'Djibouti',
		d => 'M495.973,175.881l-0.556-0.195l-0.4-0.04l-0.892,0.246l-0.5,0.074l-0.202-1.157l0.029-0.396l0.105-0.254l0.488-0.61l0.594-0.921l0.055-0.085l0.214-0.114l0.396,0.125l0.331,0.182l0.529-0.78l0.075-0.094l0.627,0.596l0.285,0.465l0.036,0.282     l-0.118,0.113l-0.361,0.185l-0.438,0.1l-0.56,0.312l-0.566,0.467l0.253,0.127l0.645-0.058l0.321,0.013l0.434,0.124l-0.114,0.26l-0.37,0.468l-0.34,0.567z'},
	GW => {name => 'Guinea-Bissau',
		d => 'M363.763,172.732l0.463-0.139l0.819-0.047l0.74,0.024l0.51-0.187l0.505-0.384l1.045-0.006l2.301,0.043l-0.111,0.792l0.115,0.847l-0.186,0.312l-0.333,0.186l-0.513,0.031l-0.401,0.017l-0.381,0.186l-0.789,0.64l-0.321,0.372l-0.047-0.126     l-0.192,0l-0.501-0.14l-0.165-0.254l0.121-0.41l0.33-0.438l0.253-0.212l-0.131-0.141l-0.372-0.112l-0.498,0.015l-0.415,0.17h-0.161l-0.616-0.281l-0.36-0.296l-0.069-0.24l-0.323-0.084l-0.316-0.137z'},
	GN => {name => 'Guinea',
		d => 'M383.005,177.596l-0.379,0.397l-0.264,0.623l0.214,0.409l0.695,0.405l0.197,0.31l-0.125,0.283l-0.332,0.37l0.309,0.351l0.648,0.561l0.051,0.226l-0.19,0.143l-0.304-0.012l-0.548-0.223l-0.304,0.03l-0.158,0.199l-0.03,0.127l0.296,0.549     l0.179,0.21l-0.188,0.354l-0.602,0.554l-0.047,0.099l-0.339-0.224l-0.337-0.097l-0.143,0.086l-0.756,0.922l-0.321-0.026l-0.404-0.322l-0.277-0.323l0.044-0.283l-0.009-0.65l-0.22-0.846l-0.165-0.366l-0.338-0.097l-0.528,0.046l-0.367,0.143l-0.252,0.242     l-0.193,0.376l-0.26-0.656l-0.165-1.369l-0.252-0.761l-0.475-0.619l-0.456-0.421l-0.42-0.224l-0.466-0.04l-1.137,0.148l-0.594-0.039l-0.238,0.157l-0.643,0.866l-1.088,1.235l0.051-0.392l-0.312-0.55l-0.764-0.775l-0.122-0.649l-0.84-0.366l-0.908-0.563     l-0.277-0.296l0.09-0.396l-0.053-0.311l-0.547-0.041l-0.323-0.098l-0.115-0.155l0.059-0.311l-0.038-0.1l0.321-0.372l0.789-0.64l0.381-0.186l0.401-0.017l0.513-0.031l0.333-0.186l0.186-0.312l-0.115-0.847l0.111-0.792l1.255,0.021l0.795,0.32l0.503,0.209     l0.725,0.081l0.658-0.074l0.963-0.091l0.146,0.042l0.113,0.028l0.18,0.183l0.882,0.715l0.536,0.265l0.252-0.256l0.475-0.413l0.338,0.026l0.356,0.153l0.565,0.152l0.43-0.243l0.3-0.327l0.684-0.428l0.323,0.055l0.246,0.281l0.022,0.339l0.271,0.832l0.265,0.451     l0.474,0.478l0.349,0.718l0.194,1.143l0.559,0.901z'},
	VE => {name => 'Venezuela',
		d => 'M266.015,188.956l0.103,0.169l-0.163,0.326l-0.592,0.385l-1.74,0.9l-0.807,0.23l-0.557,0.074l-0.465-0.054l-0.284,0.115l-0.232,1.117l-0.348,0.115l-0.628-0.618l-0.344-0.224l-1.149,0.035l-0.385-0.04l-0.896-0.461l-0.309-0.125     l-0.159,0.029l-0.041,0.184l0.616,0.688l0.391,0.69l0.302,1.524l0.079,0.55l0.166,0.239l0.96,0.051l0.434,0.125l0.15,0.253l-0.265,0.27l-0.569,0.272l-0.652,0.131l-0.203,0.199l-0.259,0.666l-0.235,0.213l-0.652,0.173l-0.554,0.286l-0.74,0.654l-0.645,0.739     l-0.271,0.016l-0.186-0.776l-0.083-0.183l-0.757,0.697l-0.414,0.073l-0.482-0.223l-0.694-0.546l-0.432-0.054l-0.199-0.437l-0.088-0.452l-0.161-0.861l-0.138-0.437l-0.148-0.168l-0.797-1.182l-0.51-0.491l0.479-0.526l0.731-0.612l-0.121-0.282l-0.486-0.647     l-0.256-0.437l-0.447-0.789l-0.162-0.804l-0.048-0.367l-0.035-0.438l-0.026-0.254l0.147-0.326l0.379-0.511l0.085-1.004l0.409-0.525l-0.644-0.081l-1.99,0.224l-0.76,0.174l-0.522,0.13l-0.144,0l-0.554-0.576l-0.847-0.998l-0.188-0.253l-0.64-0.321l-0.521-0.181     l-1.167,0.05l-1.163,0.12l-0.496,0.017l-0.397-0.252l-0.429-0.548l-0.401-0.309l-0.099-0.353l0.226-1.132l-0.103-0.395l-0.855-1.45l-0.31-0.606l-0.384,0.017l-0.234,0.1l-0.402-0.025l0.709-1.191l0.241-0.722l0.172-0.722l0.99-1.758l0.381-0.059l0.227,0.027     l0.129-0.396l-0.048-0.497l0.056-0.288l0.414-0.2l0.534-0.156l0.84-0.171l0.128,0.105l-0.9,0.151l-0.731,0.312l-0.145,0.212l0.19,0.607l0.142,0.407l0.224,0.126l-0.043,0.145l0.153,0.579l-0.135,0.367l-0.327,0.364l-0.348,0.824l-0.137,0.368l0.253,0.479     l0.288,0.253l0.25,0.72l0.341,0.353l0.523-0.114l0.184-0.156l0.419-0.255l0.12-0.142l0.066-0.523l-0.167-0.649l-0.21-0.282l-0.438-0.804l-0.136-0.135l-0.118-0.395l-0.247-0.18l0.239-0.099l0.095-0.251l-0.204-0.144l1-0.379l1.085-0.327l0.998-0.272l0.086-0.225     l0.69-0.086l0.143-0.008l-0.042-0.157l-0.055-0.198l-0.125-0.036l-0.039-0.108l-0.128-0.072l-0.226,0.071l-0.156,0.027l-0.229-0.012l-0.315-0.55l0.109-0.254l0.337-0.213l0.367-0.043l0.09,0.112l0.14,0.368l0.186,0.162l-0.001,0.148l0.026,0.193l0.068,0.09     l0.004,0.198l0.253,0.258l0.329-0.02l0.699,0.111l0.455,0.07l0.593,0.196l0.323,0.254l0.393,0.564l0.156,0.635l0.358,0.324l0.359,0.084l1.02-0.129l0.928-0.059l0.59-0.058l0.799-0.059l0.714,0.125l0.4,0.479l0.267,0.169l0.578,0.253l0.49,0.14l1.094,0.04     l0.382-0.057l0.388-0.227l1.042-0.807l0.47-0.185l0.453,0.042l0.959-0.073l1.152-0.073l0.919,0.055l0.248,0.112l-0.056,0.141l-0.294,0.185l-0.854-0.041l-0.433,0.015l-0.083,0.212l0.059,0.184l0.593,0.253l0.609,0.535l0.195,0.649l0.246-0.523l0.185-0.142     l0.415,0.253l0.483,0.027l0.374,0.098l0.258,0.338l0.918,0.394l0.464,0.295l-0.729,0.496l-0.161,0.65l-0.214,0.226l-1.055,0.417l0.5,0.064l0.598,0.098l0.368-0.029l0.33-0.142l0.929-0.03l0.725,0.083l0.84,0.274l0.095,0.296l-0.061,0.41l-1.655,1.239l-0.101,0.255     l0.074,0.212l0.62,0.604l0.141,0.282l-0.308,0.299l-0.41,0.144l-1.032,0.19l-0.061,0.452l0.008,0.58l-0.395,0.539l-0.071,0.212l0.324,0.521l0.732,0.745l0.503,0.647z'},
	SO => {name => 'Somalia',
		d => 'M493.044,204.258l-1.223-1.771l-0.027-0.932l-0.03-1.43l-0.042-2.045l-0.003-1.017v-0.438l0.016-0.848l0.004-1.215l0.002-0.508l1.649-2.467l0.453-0.511l0.305-0.101l1.216-0.078l0.337-0.115l0.294-0.426l0.502-0.497l0.388-0.214l0.562-0.215     l0.626-0.088l1.693,0.046l0.8-0.004l0.813-0.909l1.562-1.69l4.087-4.205l-0.236-0.154l-1.875,0.04l-1.447-0.472l-4.26-1.443l-0.54-0.209l-0.634-0.321l-0.596-0.547l-0.732-0.801l-0.587-0.844l-0.428-0.732l-0.083-0.409l0.363-0.807l0.34-0.567l0.37-0.468     l0.114-0.26l0.154,0.044l0.935,1.142l0.586,0.62l0.243,0.381l0.265,0.211l0.372-0.071l0.417-0.001l0.465,0.027l0.372-0.071l0.572-0.27l0.836-0.425l0.585-0.157l0.397,0.098l0.76,0.267l0.549-0.072l0.56-0.326l0.779-0.566l0.247-0.127l0.447,0.041l0.479,0.098     l0.419-0.043l1.195-0.482l0.288,0.027l0.682,0.196l0.74-0.03l0.764-0.185l0.964-0.327l0.9-0.666l0.47-0.382l0.604,0.154l0.391,0.211l0.08,0.014l0.147,0.268l-0.414,0.919l0.021,0.564l0.132,0.621l-0.165,0.452l-0.375,0.509l-0.028,0.678l-0.047,0.833l-0.163,0.509     l-1.264,2.262l-0.842,0.792l-0.122,0.311l0.102,0.353l-0.893,1.569l-0.834,1.272l-0.214,0.947l-0.351,0.636l-0.712,1.117l-0.874,1.188l-1.159,1.498l-0.384,0.439l-2.274,2.504l-1.82,1.557l-2.164,1.121l-0.593,0.382l-1.28,1.09l-1.74,1.755l-0.06,0.061l-1.055,1.1     l-1.235,1.569l-0.615,0.835l0.1,0.353l-0.094,0.276z'},
	TT => {name => 'Trinidad',
		d => 'M264.768,176.039l-0.128,0.225l-0.115,0.067l-0.029,0.135l0.039,0.25l-0.058,0.086l0.125,0.376l-0.039,0.424l-0.453,0.154l-0.135-0.01l-0.144,0.039l-0.482-0.039l-0.192,0.039l-0.087-0.048h-0.356l-0.02-0.058l0.039-0.067l0.202-0.029     l0.222-0.135l0.019-0.087l0.106,0.02l0.154,0.01l0.135-0.145l-0.096-0.279l0.048-0.125l0.029-0.183l-0.067-0.125l-0.097-0.135l-0.279-0.048l0.116-0.096l0.164-0.019l0.231-0.029l0.115-0.087l0.385,0.02l0.106-0.039l0.299-0.067l0.244,0.006z'},
	BN => {name => 'Brunei',
		d => 'M654.075,190.187l0.206-0.125l0.63-0.114l0.656-0.938l0.241-0.07l-0.069,0.268l0.122,0.087l0.187-0.046l0.11,0.174l0.148,0.444l-0.024,0.111l-0.013,0.247l0.197,0.197l0.025,0.086l-1.234,0.42l-0.383,0.271l-0.309-0.271l-0.111-0.259     l-0.234,0.012l-0.062-0.37l-0.084-0.126z'},
	KE => {name => 'Kenya',
		d => 'M493.044,204.258l-0.602,0.389l-0.557,0.171l-0.385-0.112l-0.086,0.777l-0.282,0.367l-0.67,0.115l-0.394,0.382l-0.088,0.48l0.006,0.353l-0.356,0.622l-0.964,1.358l0.092,0.536l-0.337,0.65l-0.25,0.255l-0.334,0.1l-0.084,0.152l-1.067-0.807     l-2.427-1.752l-0.07-0.239l0.116-0.552l-0.137-0.381l-3.553-1.984l-4.663-2.568l-1.448,0.033l1.144-2.479l0.105-0.229l0.656-0.835l0.985-0.938l0.477-0.525l0.43-0.695l0.143-0.566l-0.048-0.664l-0.223-0.606l-0.224-0.352l-0.732-1.069l-0.174-0.465l-0.027-0.861     l-0.126-0.226l-0.477-0.463l-0.3-0.493l0.678-0.795l0.291-0.327l0.671,0.052l0.832-0.005l1.009-0.133l0.464-0.017l0.079,0.028l0.319,0.069l1.054,0.149l0.749,0.193l0.604,0.293l2.353,1.525l0.335,0.041l1.373,0.133l0.67,0.193l0.847,0.094l0.16-0.114l0.71-0.753     l0.258-0.199l0.675-0.343l0.852-0.358l0.271,0.098l0.46,0.336l0.461,0.181l1.103,0.106l-1.649,2.467l-0.002,0.508l-0.004,1.215l-0.016,0.848v0.438l0.003,1.017l0.042,2.045l0.03,1.43l0.027,0.932l1.223,1.771z'},
	UG => {name => 'Uganda',
		d => 'M466.196,203.275l0.188-0.298l0.076-0.27l-0.057-0.748l0.025-0.734l-0.021-0.593l0.107-0.507l0.217-1.02l0.395-0.681l0.255-0.284l1.241-0.996l1.195-1.066l0.191-0.453l-0.111-0.31l-0.271-0.182l-0.479-0.04l-0.191-0.027l-0.128-0.253     l0.26-1.88l0.018-0.424l-0.159-0.183l-0.063-0.028l0.496-0.229l0.464-0.087l0.495,0.011l0.942,0.234l0.911-0.048l0.881-0.33l0.88-0.132l0.303,0.097l0.303,0.196l0.367-0.016l0.626-0.314l0.563-0.54l0.3,0.493l0.477,0.463l0.126,0.226l0.027,0.861l0.174,0.465     l0.732,1.069l0.224,0.352l0.223,0.606l0.048,0.664l-0.143,0.566l-0.43,0.695l-0.477,0.525l-0.985,0.938l-0.656,0.835l-0.105,0.229l-1.144,2.479h-4.659l-1.277,0.05l-0.319,0.017l-0.554,0.398l-0.458,0.427l-0.431,0.045l-0.546-0.223l-0.064-0.042z'},
	ID => {name => 'Indonesia',
		d => 'M713.621,206.298l0.169,7.966l-0.44,0.822l0.431,1.368l0.046,0.805l-0.031,3.438l-0.515-0.512l-0.927-0.888l-0.716-0.902l-0.406-0.056l-0.776,0.101l-0.739,0.143l-0.434-0.013l0.091-0.382l0.435-0.65l0.006-0.283l-0.561-0.521l-0.565-0.775     l0.028-0.226l0.442,0.111l0.236-0.042l0.135-0.113l-0.467-0.409l-0.595-0.408l-0.287-0.381l-0.275-0.648l-1.053-1.693l-0.508-0.394l-0.467-0.282l-0.604-0.196l-1.983-0.603l-1.26-0.379l-0.613-0.069l-0.705-0.238l-0.63-0.323l0.072-0.34l-0.098-0.268l-0.193-0.028     l-0.617,0.101l-0.389-0.07l-0.412-0.196l-0.408-0.395l-0.209-0.579l0.133-0.494l-0.155-0.226l-0.187,0.113l-0.234,0.396l-0.122,0.664l-0.251,0.608l-0.334,0.269l-0.696,0.354l-0.155-0.169l-0.331-0.677l0.022-0.155l0.384-0.27l-0.152-0.424l-0.173-0.239     l-0.564-0.395l-0.707-0.394l-0.338-0.056l-0.059-0.212l0.038-0.226l0.413-0.044l0.388,0.084l0.603,0.239l0.158-0.029l0.368-0.34l0.525-0.41l0.146,0.056l0.3,0.269l1.021-0.045l0.139-0.128l0.09-0.522l-0.063-0.409l-0.238,0.028l-0.345,0.199l-0.604,0.071     l-0.656-0.041l-0.766,0.044l-1.026-0.082l-0.411-0.31l-0.135-0.197l-0.148-0.664l-0.202-0.338l-0.42-0.155l-1.249-0.124l0.265-0.297l0.058-0.255l0.004-0.593l0.463-0.029l0.92-0.411l0.49-0.383l0.444-0.283l0.352,0.027l0.4,0.069l1.494,0.646l0.515,0.169     l0.913,0.153l0.382,0.705l0.138,0.396l-0.283,0.749l-0.067,0.381l0.221,0.381l0.115,0.494l0.115,0.48l0.215,0.521l0.186,0.197l0.197,0.127l0.226-0.65l0.085,0.113l0.087,0.141l0.309,1.073l0.169,0.169l0.234,0.183l0.294,0.112l0.354,0.056l0.58-0.198l0.504-0.439     l1.192-1.853l0.352-0.015l1.078-0.215l0.378-0.142l0.045-0.085l0.014-0.509l0.219-0.17l1.1-0.609l0.335-0.043l1.732,0.759l2.129,0.941l1.54,0.52l1.299,0.404z M691.208,208.707l-0.388-0.069l-0.693-0.38l-0.852-0.647l-0.295-0.141l-0.414,0.028l-0.059,0.1     l0.024,0.452l-0.206,0.028l-1.014-0.407l-0.258-0.353l-0.582,0.199l-0.289,0.269l-0.326,0.185l-0.186-0.184l-0.312-0.451l-0.245-0.451l0.246-0.198l0.303-0.029l0.274,0.056l1.104,0.04l0.574,0.31l0.319-0.015l0.544-0.326l0.414-0.015l0.534,0.126l0.857,0.21     l0.499,0.395l0.293,0.395l0.179,0.621l-0.049,0.254z M682.045,208.699l-0.419-0.056l-0.715-0.493l-0.232-0.451l0.146-0.283l0.603-0.1l0.766-0.044l0.246,0.126l0.256,0.311l0.313,0.197l0.108,0.226l-0.067,0.226l-0.125,0.057l-0.879,0.285z M707.635,219.095     l-1.11-0.209l0.589-1.032l0.56-0.708l0.407-0.269l0.427-0.072l0.527,0.338l0.198,0.24l-0.11,0.184l-0.324,0.637l-0.256,0.17l-0.638,0.693l-0.27,0.028z M673.797,218.703l-0.562,0.257l0.034,0.233l-0.886,0.326l-0.582,0.274l-0.339-0.041l-0.453,0.325l-0.504-0.069     l-0.427-0.112l-0.378,0.255l-0.3,0.058l-0.358-0.07l-0.58-0.196l-1.046-0.04l-0.316,0.043l-0.211-0.564l0.027-0.24l0.383-0.198l0.672-0.199l0.528-0.016l1.142,0.407l0.445,0.324l0.338,0.013l0.326-0.297l0.464-0.016l0.429-0.071l0.414,0.187l0.467-0.116     l-0.072-0.222l0.421-0.187l0.404-0.233l0.094-0.151l-0.076-0.117l-0.184,0.023l0.116-0.198l0.16,0.012l0.22,0.094l0.177,0.221l0.013,0.304z M662.661,219.065l-0.312-0.099l-0.203-0.127l-0.062-0.169l0.03-0.212l0.256-0.198l0.315-0.036l0.17,0.092l0.053,0.212     l0.182,0.098l0.305-0.145l0.34,0.105l0.104,0.151l-0.012,0.451l0.183-0.148l0.163-0.304l0.318-0.029l0.229,0.226l0.021,0.424l0.181-0.036l0.062,0.104l-0.025,0.397l-0.316-0.211l-0.311-0.058l-0.141,0.058l0.072,0.155l-0.852,0.157l-0.143-0.091l0.097-0.268     l-0.085-0.059l-0.308,0.269l-0.229,0.256l-0.296-0.046l-0.63,0.225l-0.624,0.199l-0.357-0.051l-0.31,0.123l-0.392-0.07l-0.103-0.07l-0.202-0.123l-0.063-0.279l0.143-0.261l-0.08-0.253l0.193-0.115l0.23-0.113l0.233-0.156l0.224,0.07l0.61,0.013l0.4,0.104     l0.089,0.28l0.291,0.109l0.294,0.056l0.189-0.259l0.29-0.012l0.051-0.187l-0.263-0.15z M656.294,219.602l-0.393-0.282l-0.855-0.449l-0.118-0.269l0.417-0.001l0.514-0.185l0.462-0.029l0.925,0.521l-0.338,0.17l-0.232,0.1l-0.381,0.425z M631.053,200.125     l-0.061,0.225l-0.413,0.439l-0.204,0.41l-0.381,0.354l0.164,0.353l0.162,0.169l0.806,0.493l0.832,0.055l0.241,0.112l0.151,0.381l0.128,0.763l-0.007,0.409l0.267,0.423l0.212,0.127l0.544,0.041l-0.45,0.933l0.151,0.212l0.703-0.453l0.824,0.252l0.177,0.042     l0.265,0.254l0.144,0.438l0.698,0.676l-0.515,1.979l-0.04,0.452l0.23,0.946l-0.021,0.438l0.021,0.664l-0.002,0.268l-0.149,1.06l-0.087,0.156l-0.107,0.07l-0.367-0.253l-0.381-0.522l-0.261-0.084l-0.262,0.481l-0.081,0.268l-1.043-0.619l-0.219,0.086l0.394,0.747     l-0.163,0.213l-0.204-0.197l-1.343-1.424l-0.775-0.761l-1.011-0.859l-1.348-0.958l-0.391-0.451l-0.199-0.493l-0.191-0.339l-1.003-0.633l-0.697-0.677l-1.186-1.509l-0.074-0.353l0.039-0.339l-0.324-0.875l-0.841-1.467l-0.667-1.044l-0.612-0.775l-0.369-0.301     l-0.287-0.234l-0.64-0.295l-0.254-0.748l-0.688-1.806l0.067-0.24l-0.107-0.311l-0.157-0.197l-0.662-0.507l-0.711-0.394l-0.539-0.21l-0.317-0.099l-0.119-0.353l-0.077-0.734l-0.18-0.409l-0.386-0.479l-0.818-0.831l-0.368-0.423l-0.725,0.128l-0.613-0.676     l-0.646-0.606l-0.593-0.69l-0.562-0.945l-0.229-0.635l-0.032-0.367l0.057-0.198l0.149-0.113l0.401-0.043l0.364,0.098l0.25,0.126l0.632,0.563l0.361,0.155l0.922,0.153l0.335,0.027l0.548-0.1l0.454-0.142l0.4-0.015l0.323,0.31l0.919,1.156l0.513,0.31l0.058,0.155     l-0.12,0.537l1.066,0.916l0.749,0.493l1.175,0.689l0.678,0.323l0.139,0.169l0.03,0.593l-0.02,0.155l0.573,0.055l0.745,0.944l0.612,0.55l0.271-0.015l0.004-0.198l-0.123-0.226l0.069-0.24l0.507,0.21l0.479,0.804l0.441,0.38l0.446,0.056l0.429,0.197l0.314,0.366     l0.28,0.734l0.316,0.437l0.431,0.268l0.511,0.126l0.767,0.083l0.431,0.154l0.494,0.38l0.576,0.606l-0.019,0.071z M684.201,200.125l-0.007-0.172l-0.414-1.058l0.18-0.551l-0.078-0.141l-0.141-0.296l0.036-0.325l0.286-0.89l0.514-0.82l0.263,0.367l0.152,0.353     l-0.054,0.283l-0.246,0.396l-0.361,0.763l0.061,0.325l0.19,0.141l0.097-0.141l0.436-0.411l0.135-0.522l0.179-0.142l0.806-0.412l0.141,0.141l-0.052,0.254l0.104,0.55l-0.354,0.212l-0.467,0.354l-0.162,0.311l0.159,0.099l0.446,0.126l0.398,0.211l-0.016,0.141     l0.159,0.353l-0.688-0.154l-0.431-0.154l-0.367-0.042l-0.304,0.156l-0.08,0.438l0.049,0.258l0.131,0.688l0.341,0.62l0.405,0.438l0.196,0.282l-0.156,0.212l-0.26-0.211l-0.664-0.648l-0.55-0.733l-0.002-0.396l-0.011-0.251z M637.361,207.144l-0.863-0.394     l-0.377-0.239l-0.205-0.367l-0.045-0.367l-0.156-0.395l-0.507-0.395l-0.291-0.099l-0.446,0.029l-0.116-0.141l0.271-0.65l0.234-0.24l0.509,0.55l0.148-0.467l0.313-0.269l0.072,0.395l0.312,0.89l0.648,0.817l0.698,0.31l-0.265,0.184l-0.118,0.283l0.183,0.564z      M634.321,215.345l-0.091-0.187l0.316-0.023l0.402,0.093l0.369-0.129l0.068-0.524l0.018-0.14l0.309,0.057l-0.043-0.5l0.222-0.235l0.093-0.277l0.202,0.121l0.631,0.112l0.474-0.047l0.237,0.443l0.524-0.089l0.158-0.297l0.022-0.244l0.259,0.116l0.618,0.168     l0.411,0.438l0.338-0.046l0.204,0.271l0.446-0.029l0.453-0.185l0.302,0.211l0.369,0.522l0.179,0.521l0.884,0.041l0.462,0.188l0.49-0.077l1.435,0.124l0.479-0.029l0.34-0.17l0.213-0.65l0.271-0.269l0.447-0.015l0.223,0.211l0.289,0.494l0.633,0.125l0.53,0.027     l0.774,0.083l0.796,0.153l0.289,0.24l0.293,0.288l-0.08,0.445l0.275,0.466l0.119,0.099l0.877,0.352l0.422,0.069l0.658,0.013l0.45-0.185l0.415-0.015l0.628,0.238l0.048,0.197l-0.255,0.425l-0.152,0.494l0.578,0.776l-0.499-0.211l-0.802-0.196l-0.599-0.253     l-0.891-0.309l-0.528,0.001l-0.589,0.256l-0.348,0.057l-0.714-0.098l-1.454-0.138l-1.47-0.138l-0.805-0.253l-0.839-0.479l-1.099-0.336l-1.125-0.267l-0.948-0.04l-0.556,0.298l-0.445,0.043l-0.957-0.153l-0.805-0.492l-0.357-0.07l-1.606-0.066l-0.363-0.155     l0.055-0.141l0.448-0.468l-0.402-0.267l-0.551-0.099l-0.506-0.14l-0.307-0.027l-1.261-0.121z M675.004,223.092l0.249-0.494l0.023-0.537l0.113-0.312l0.674-0.481l1.447-0.624l0.662-0.454l0.36-0.607l0.466-0.157l1.578-0.102l0.91-0.214l0.541-0.044l0.869-0.143     l0.118,0.07l0.099,0.197l-0.237,0.212l-0.36,0.256l-1.609,0.61l-1.369,0.44l-0.713,0.256l-0.606,0.354l-1.09,0.963l-0.653,0.481l-0.439,0.086l-0.552,0.228l-0.48,0.015z M667.866,223.149l-0.217-0.069l-0.917-0.605l-0.8-0.45l-0.347-0.099l-0.493-0.126     l-0.292-0.197l0.108-0.212l0.371-0.142l0.992-0.03l0.502-0.114l0.35,0.296l1.147,0.746l0.265,0.381l-0.125,0.325l-0.246,0.24l-0.299,0.057z M661.819,191.241l-0.041,0.09l0.319,0.691l-0.23,0.142l-0.546,0.043l-0.579,0.086l0.198,0.226l0.115,0.296l-0.169,0.226     l0.216,0.211l0.235,0.112l0.546,0.832l0.536,0.747l0.043,0.198l-0.338,0.721l0.075,0.226l0.406,0.465l0.743,0.45l0.6,0.493l0.551,0.761l-0.465,0.17l-0.75-0.026l-0.797-0.238l-0.337,0.1l-0.387,0.467l-0.354,0.918l-0.08,0.476l-0.046,0.272l0.132,0.649     l0.116,0.424l-0.133,0.848h-0.256l-0.466-0.154l-1.037,0.963l-0.433,0.65l-0.751,0.608l0.443,0.381l0.06,0.396l0.17,0.296l-0.685,0.058l0.452,0.578l0.009,0.212l-0.103,0.227l-0.547,0.665l-0.206,0.396l-0.127,0.354l-0.529,0.594l-1.294,0.61l-0.607,0.284     l-0.292,0.198l-0.194-0.311l0.024-0.424l-0.33-0.804l-0.306-0.381l-0.265-0.184l-0.286,0.029l-0.503,0.523l-0.302,0.029l-0.328-0.508l-0.313-0.197l-0.437-0.112l-0.387-0.451l-0.342-0.154l-0.35,0.806l-0.135,0.198l-0.381,0.058l-0.356-0.112l-0.442,0.128     l-0.318,0.354l-0.364,0.071l-0.059-0.551l0.034-0.311l-0.314-1.03l-0.336,0.396l-1.42,0.44l-0.321-0.408l-0.639,0.015l-0.281,0.156l-0.303,0.029l-0.058-0.649l-0.022-0.65l-0.267-1.411l-0.012-0.48l-0.352-0.747l-0.406-0.409l-0.79-0.422l-0.146-0.141l0.555-0.354     l-0.531-0.38l-0.258-0.296l0.188-0.735l-0.074-0.128l-0.278-0.478l-0.352-0.296l0.065-0.466l-0.125-0.593l0.182-0.65l0.133-0.353l0.424-0.58l0.303-0.806l0.318,0.028l0.204,0.11l0.288,0.792l0.253,0.295l1,0.983l0.304,0.083l0.446,0.28l0.928-0.416l0.255-0.001     l0.526,0.223l0.543,0.11l0.399-0.172l0.528-0.342l0.403-0.525l0.531-0.441l0.479-0.074l0.431,0.11l0.557,0.251l0.524,0.223l0.559,0.152l0.287-0.03l0.467-0.356l0.465-0.172l0.864-0.175l0.387-0.299l0.928-1.785l-0.076-0.748l0.218-0.34l0.646-0.244l0.22-0.383     l-0.106-0.988l0.119-0.565l0.381-0.638l0.247-0.157l0.464-0.017l0.748,0.081l0.651,0.081l0.624-0.018l0.446,0.04l0.753,0.292l0.182,0.09z M666.561,200.125l0.012-0.049l0.48-1.188l0.434-0.41l0.289-0.142l0.429,0.338l0.29-0.311l0.162-0.325l0.293-0.481     l0.496-0.058l0.605,0.14l0.729,0.535l0.447,0.027l0.863-0.044l0.478,0.168l0.749,0.267l0.577-0.227l1.853,0.081l0.72-0.128l0.627-0.354l0.211-0.283l-0.156-0.268l0.196-0.283l0.388-0.241l0.295-0.41l0.289-0.057l0.075,0.24l-0.073,0.537l-0.117,0.311l-0.081,0.127     l-0.082,0.127l-0.969,1.259l-0.416,0.396l-0.464,0.1l-1.23,0.229l-0.495-0.069l-0.591-0.422l-1.149-0.068l-1.151,0.059l-0.878-0.041l-1.039,0.045l-0.575-0.083l-0.671,0.029l-0.415,0.1l-0.433,0.368l-0.259,0.461l-0.154,0.274l-0.187,0.721l0.068,0.48l0.263,0.494     l0.194,0.183l0.403,0.226l0.259,0.196l0.221,0.607l0.179,0.154l0.226,0.042l0.815,0.026l0.249-0.269l0.652-0.976l0.385,0.056l0.307,0.183l0.496,0.041l0.363-0.227l0.669-0.156l0.62-0.143l0.268-0.298l0.271-0.057l0.466,0.196l0.131,0.212l-0.083,0.734     l-0.469-0.267l-0.544-0.042l-0.361,0.298l-0.389,0.523l-0.438,0.425l-1.059,0.439l-0.214,0.325l-0.143,0.029l-0.241-0.042l-0.468-0.126l-0.03,0.056l0.025,0.312l0.212,0.126l0.676,0.578l0.467,0.521l0.854,1.24l-0.097,0.325l-0.156,0.679l0.102,0.409l0.447,0.535     l0.555,0.438l0.062,0.226l-0.045,0.282l-0.436-0.056l-0.652,0.059l-0.412,0.297l-0.224,0.692l-0.498-0.026l-0.461-0.183l-0.107-0.17l0.052-0.649l0.204-0.58l-0.978-0.845l-0.417-0.31l-0.174-0.269l0.036-0.24l0.284-0.396l0.116-0.579l-0.165-0.494l-0.737-0.055     l-0.503,0.213l-0.494,0.396l0.16,0.353l0.143,0.932l-0.068,0.509l-0.236,1.145l0.363,0.903l-0.01,0.311l-0.377,0.636l-0.019,0.227l0.275,0.564l-0.726,0.171l-0.513,0.241l-0.476,0.071l-0.245-0.324l-0.16-0.522l0.156-0.325l0.181-0.466l0.069-0.876l0.06-1.073     l-0.125-0.509l0.029-0.339l-0.213-0.395l-0.311-0.127l-0.391,0.171l-0.574,0.029l0.011-0.41l-0.25-1.284l0.131-0.311l0.491-0.524l0.469-0.777l0.161-0.48l-0.089-0.918l-0.006-0.254l0.087-0.452l0.339-0.721l0.447-0.058l-0.043-0.861l0.254-1.053z'},
	GL => {name => 'Greenland',
		d => 'M341.05,41.069l2.084,0.272l0.344,0.361l-0.869,0.174l-0.541,0.139l-1.678,0.106l-1.159,0.037l-0.689,0.156l-0.372,0.224l-0.308,0.6l-0.361,0.376l1.05,0.39l0.971,0.168l2.117,0.064l0.601-0.001l1.775-0.242l1.93-0.038l0.866,0.135     l0.933,0.219l0.417,0.135l0.284-0.018l1.001-0.002l1.277,0.032l0.615,0.05l-1.277,0.626l-1.583,0.457l-1.976,0.523l-0.556-0.016l-0.695-0.116l-0.951,0.671l-1.061,0.503l-1.246,0.452l-1.125,0.296l-0.211,0.056l-2.212,0.054l-0.525,0.134l-0.502,0.001     l-0.982,0.201l-0.665,0.167l-0.528,0.051l-0.946-0.413l-0.375,0.05l-0.69,0.913l-0.958,0.118l-0.631-0.065l-0.743-0.197l-0.622-0.463l-0.854-0.43l-0.647-0.215h-0.109l0.008,0.2l0.707,1.043l-0.192,0.249l-0.319,0.017l-0.69,0.249l-0.84,0.249l-0.573,0.38     l-1,0.906l-0.657,0.657l-1.051,0.851l-0.776,0.262l-1.034,0.083l-1.023-0.275l-0.148,0.554l-0.438,0.569l-0.783,0.277l-0.992-0.095l-0.616,0.05l-1.18,0.439l0.942-1.723l-0.121,0.017l-0.795-0.015l-1.055-0.177l0.26,0.423l-0.026,0.455l-0.386,0.407l-0.794,0.39     l-1.16,0.164l-0.973,0.002l-1.255,0.083l0.467,0.403l0.212,0.403l-0.09,0.387l-0.379,0.097l-0.321-0.063l-0.47,0.033l-1.792-0.157l0.517,0.32l0.765,0.462l0.295,0.351l-0.01,0.224l-0.26,0.176l-1.197,0.034l-1.051,0.129l0.844,0.413l0.47,0.126l0.448,0.222     l0.389,0.333l-0.554,0.461l-0.285,0.111l-0.599-0.094l-0.478,0.096l0.345,0.474l-0.009,0.127L308.501,60l-0.486-0.125l-0.583-0.062l0.026,0.158l0.255,0.457l-0.101,0.347l-0.288,0l-0.656-0.093l-0.089-0.016l-0.979,0.112l-1.081,0.018l0.682,0.487l1.108,0.391     l0.331,0.204l-0.077,1.035l-0.382,0.938l-0.427,0.094l-0.815-0.061l0.489,0.591l-0.016,0.498l0.156,0.233l-0.068,0.373l-0.316,0.062l-0.495-0.03l-0.771,0.079l0.762,0.386l0.427,0.603l-0.117,0.447l-0.287,0.031l-0.967-0.26l-1.052-0.508l-0.498,0.294     l-0.425,0.602l-0.635-0.599l0.158-0.573l-0.387-0.201l-1.124-0.184l-0.577-0.309l0.04-0.187l0.253-0.249l0.066-0.218l-0.325-0.28l-0.366-0.186l-0.668,0.359l-0.276,0.016l-0.3,0.141l-0.444-0.046l-0.98,0.064l-0.417,0.017l-0.571,0.296l-0.476,0.28l-0.426-0.403     l-0.104-0.357l-0.222-0.217l-0.513-0.233l-0.817-0.232l-0.772-0.389l-0.517-0.781l0.07-0.737l-0.199-0.156l-0.434-0.094l-0.467,0.048l-0.97-0.266l-0.108-0.094l-0.138-0.236l0.14-0.457l0.459-0.395l0.071-0.269l-0.258-0.062l-0.551-0.031l-0.542-0.094     l-0.278-0.221l-0.058-0.633l-0.458-0.126l-0.616,0.049l-0.589-0.57l0.023-0.191l0.198-0.254l0.618-0.367l1.22-0.337l0.405-0.304l0.476-0.128l0.051-0.383l-0.277-0.287l-0.473,0.097l-0.921,0.082l-0.493,0.097l-0.635,0.416l-0.538,0.129l-0.63,0.304l-0.339-0.318     l0.038-0.623l-0.114-0.784l-0.206-0.451l0.015-0.355l-0.243-0.323l-0.504,0.082l-0.271-0.032l-0.666-0.355l-0.594-0.485l-0.013-0.357l0.842-0.538l0.265,0.019l-0.556-0.189l-1.083,0.064l-0.103-0.284l0.383-0.176l0.677-0.03l0.586-0.052l0.456-0.087l0.322-0.672     l-1.208-0.047l-0.572,0.05l-0.362-0.032l-0.29-0.163l-0.116-0.197l0.223-0.28l0.218-0.008l0.18-0.16l0.427-0.055l-0.375-0.188l-0.552,0.073l-0.22-0.248l0.057-0.188l0.073-0.132l0.259,0l0.309-0.099l0.827-0.25l1.218,0.081l0.854,0.163l0.776,0.032l0.378,0.131     l0.927,0.146l1.027,0.097l-0.031-0.363l0.299-0.545l-0.298-0.182l-1.02-0.263l-1.356-0.312l-0.903-0.164l-1.592-0.33l-0.354-0.116l0.336-0.35l0.788-0.001l1.462,0.363l1.034,0.048l0.463-0.067l0.114-0.067l0.088-0.6l0.088-0.301l0.595-0.034l0.528,0.116     l0.227-0.101l-0.027-0.351l-0.195-0.184l-0.891-0.317l0.162-0.437l0.528-0.455l-0.258-0.286l-1.21-0.167l-1.154,0.002l-1.178-0.286l-1.649-0.49l-0.78-0.101l-0.903-0.05l-0.76-0.34l-0.811-0.477l0.156-0.035l0.323-0.155l0.605-0.001l0.572-0.019l2.085,0.305     l0.716,0.033l1.249,0.306l1.451,0.458l0.729,0.169l0.056-0.307l-0.311-0.426l-0.86-0.546l-0.172-0.446l-0.603-0.446l-0.485-0.051l-0.677-0.24l0.361-0.277l0.542-0.139L285.644,41l-0.704-0.241l-1.101-0.015l-0.625-0.086l-1.132-0.327l-0.88,0.608l-0.324,0.156     l-0.274,0.294l-0.875,0.243l-1.402-0.066l-1.031-0.343l-0.306-0.242l-0.027-0.294l0.438-0.313l0.293-0.645l-0.152-1.259l0.582-0.054l0.691,0.192l0.372-0.124l0.151-0.334l-0.383-0.369l-0.933-0.545l-0.452-0.141l-0.946-0.796l-0.895-0.925l-1.105-1.289     l-0.578-0.485l-1.855-0.379l-0.667-0.255l-0.291-0.202l-0.052-0.701l-0.904-0.406l-0.962-0.109l-1.589-0.165l-1.928-0.425l-1.903-0.333l-2.133-0.183l-0.997-0.054l-1.632-0.035l-0.785,0.189l-1.043,0.096l-0.806,0.188l-1.419,0.152l-1.228-0.166l-1.46-0.296     l0.319,0.747l-0.051,0.093l-1.051-0.017l-1.294-0.184l-3.168-0.611l1.538-0.566l0.463-0.114l-0.092-0.226l-0.423-0.169l-1.067-0.017l-2.21-0.015l-0.812-0.074l-0.629-0.018l-1.238-0.434l-0.87-0.208l0.587-0.306l1.257-0.041l3.036,0.147l2.025,0.034l1.343,0.017     l2.117-0.157l1.055-0.212l0.292-0.096l0.054-0.345l-0.627-0.287l-0.82-0.21l-1.217,0.156l-1.11,0.252l-1.31,0.021l-1.138-0.113l-0.753,0.078l-0.879,0.098l-0.68-0.056l-0.857-0.19l-0.664-0.365l-0.816-0.191l-0.662-0.057l-0.726,0.059l-0.486-0.076l-1.416-0.481     l-0.044-0.35l0.36-0.45l0.81-0.119l1.235-0.1l1.517-0.14l2.074-0.161l1.29-0.081l0.951-0.396l1.089-0.259l0.843-0.081l2.478-0.005l1.101-0.101l1.942,0.036l0.402-0.139l0.31-0.199l0.609-0.16l0.202-0.658l0.276-0.501l0.116-0.101l-0.89-0.228l-1.947-0.039     l-1.155,0.194l-0.959-0.125l-1.243-0.383l0.595-0.781l1.38-0.332l2.845-0.359l1.407-0.225l1.962-0.249l2.112-0.162l1.163,0.087l1.213-0.07l1.319-0.07l0.345-0.181l0.011-0.226l-0.357-0.753l-0.022-0.208l0.522-0.14l1.886-0.05l1.526,0.205l2.141,0.41l1.296,0.226     l0.802,0.181l0.823-0.275l-1.657-0.525l-0.697-0.509l0.167-0.047l2.2-0.122l1.166-0.12l1.854-0.216l2.52-0.195l0.73,0.069l1.064,0.116l0.232,1.738l0.913-0.162l0.539-0.322l0.432-1l1.003,0.021l2.004,0.323l1.858,0.414l1.529,0.25l0.205-0.3l-0.644-0.3     l-0.816-0.537l-0.894-0.4l0.295-0.287l0.742,0.022l1.758,0.02l1.136,0.212l2.754,0.373l1.284,0.279l2.109,0.322l1.878,0.274l1.872,0.204l0.8-0.209l0.816-1.483l-0.326-0.191l-1.292-0.334l-1.176-0.533l0.708-0.247l2.404-0.005l2.962-0.328l1.329-0.077l1.527,0.17     l2.221,0.488l1.567,0.167l2.005,0.142l0.3-0.761l-0.3-0.472l2.646-0.206l2.021-0.08l2.589,0.095l1.989,0.146l1.886-0.18l2.367-0.207l2.043-0.005l1.859,0.223l1.825-0.055l1.315,0.072l0.619,0.099l0.55-0.102l1.946,0.146l1.707,0.046l1.673,0.096l2.438,0.761     l1.368,0.241l1.345-0.076l1.118,0.168l2.594,0.237l0.445,0.408l-0.304,0.12l-0.492,0.192l-1.683,0.146l-2.303,0.124l-1.152,0.121l-1.233,0.05l-1.469-0.068l-2.831-0.064l-2.22-0.066l-1.389,0.168l-1.614,0.027l-1.933,0.027l-1.16,0.026l-1.485,0.168l-0.444,0.118     l-1.322,0.213l-0.335,0.464l0.743,0.251l2.551-0.281l1.367-0.072l3.912,0.038l2.223-0.12l2.331-0.005l0.997-0.025l0.93,0.067l1.77,0.434l0.671,0.09l1.087-0.186l1.663-0.21l1.536-0.281l1.964-0.144l0.59,0.462l-0.566,0.482l-2.316,0.639l-0.973,0.338l-1.281,0.734     l0.12,0.307l0.319,0.152l0.796-0.089l0.477-0.044l1.616-0.553l1.766-0.537l1.413-0.385l1.706-0.32l0.775-0.207l1.662-0.163l1.618,0.111l1.391,0.065l1.497-0.3l0.703-0.324l1.129-0.234l2.148-0.004l1.672,0.112l1.097,0.044l1.197,0.136l1.135,0.228l1.107,0.112     l0.316,0.25l-0.181,0.273l-1.97,0.252l-1.491,0.138l-1.245,0.494l-0.557,0.289l-1.604,0.355l-1.57,0.548l-1.063,0.089l-0.918-0.042l-1.592,0.047l-2.213-0.039l-1.491,0.198l-0.731,0.217l-0.495,0.535l0.166,0.322l1.949-0.305l1.581-0.046l1.856,0.101l0.003,0.42     l-0.743,0.241l-2.388,0.124l-0.463,0.14l-0.213,0.199l-0.156,0.595l-0.471,0.71l-0.678,0.158l-1.06-0.077l-0.742,0.041l-0.837,0.9l-0.987,1.087l-0.15,0.347l0.454,0.307l0.403,0.095l0.602-0.481l0.743-0.368l0.856-0.041l2.345,0.266l0.353,0.096l0.262,0.288     l-0.059,0.211l-1.234-0.074l-0.673-0.018l-0.512,0.097l-0.136,0.191l0.29,0.286l1.756,0.188l0.557,0.132l1.802-0.137l0.526,0.208l0.214,0.323l-0.049,0.436l-0.256,0.133l-1.835-0.186l-1.653-0.054l-0.781-0.074l-1.295,0.078l-1.382,0.475l-0.823-0.13l-0.49-0.15     l-1.06,0.04l-0.283,0.377l1.393,0.599l1.187,0.222l1.298,0.128l1.665,0.072l0.696,0.148l0.551,0.482l0.272,0.444l0.014,0.554l-0.434,0.405l-0.384,0.074l-1.292-0.181l-0.82-0.109l-0.372,0.111l0.023,0.55l0.118,0.236l0.426,0.162l0.618,0.089l0.723,0.215     l0.914,0.142l0.752,0.16l0.383,0.376l-0.338,0.233l-0.832,0.145l-0.647,0.126l-1.747-0.032l-1.176-0.087l-1.624-0.086l-0.592,0.448l0.551,0.195l1.396,0.051l1.052,0.158l0.724,0.248l0.088,0.319l-0.035,0.549l-0.13-0.005l-1.092-0.045l-1.247,0.108l-0.596,0.266     l-1.246,0.02l-1.225-0.139l-1.497-0.404l-0.922-0.478l-0.373-0.07l-1.094,0.286L345,36.811l-1.084,0.09l-0.589,0.178l-1.451-0.033l-0.913-0.087l-0.969,0.143l-0.395,0.125l-0.174,0.283l0.006,0.141l0.354,0.527l0.71,0.245l1.284,0.05l1.515,0.26l1.567-0.056     l1.323,0.54l0.758,0.226l0.482,0.226l1.196,0.329l1.252,0.38l0.376,0.276l0.483,0.898l0.892-0.208l0.278-0.139l0.397,0.207l0.298,0.43l0.071,0.344l0.198,1.164l-0.169,0.205l-0.371,0.12l-0.541-0.101l-0.546-0.119l-0.917,0.002l-1.041,0.036l-1.488-0.27     l-0.637-0.409l-0.415-0.634l-0.354-0.274l-1.17-0.566l-0.84-0.292l-0.748-0.137l-1.095-0.084l-0.521,0.14l-0.962,0.105z M351.365,40.026l-1.527-0.537l-0.96-0.225l-0.712-0.156l-0.159-0.069l-0.314-0.419l1.483-0.038l0.893,0.139l1.064,0.26l0.819,0.296     l0.162,0.488l-0.215,0.209l-0.533,0.053z M281.574,46.135l-0.568-0.133l-0.707-0.318l-0.801-0.183l-0.197-0.101l-0.25-0.218l-0.08-0.844l0.287-0.34l0.368-0.018l0.646,0.135l1.157,0.066l1.287,0.27l0.748,0.269l0.595,0.1l0.777,0.217l0.603,0.335l-0.144,0.202     l-0.112,0.034l-0.543,0.051l-0.774,0.035l-0.77,0.186l-1.009,0.153l-0.511,0.102z'},
	CA => {name => 'Canada',
		d => 'M105.98,81.688l-0.952-0.826l-0.198-0.342l-0.024-0.476l0.095-0.104l0.408,0.044l0.312-0.045l0.781,0.177l0.658-0.076l0.28,0.119l0.138,0.163l-0.234,0.224l-0.173,0.565l-0.028,0.312l-0.581,0.075l-0.483,0.19z M125.24,92.375l-1.312-0.288     l-1.345-0.434l-0.218-0.174l0.061-0.189l0.376-0.466l-1.023,0.002l-0.413,0.248l-0.299-0.072l-0.416-0.188l0.166-0.452l-0.487-0.334l-0.269-0.014l-0.735-0.086l-0.226-0.262l0.317-0.292l-0.976-0.524l-0.556,0.118l-0.386-0.102l-0.852-0.511l-1.277-0.863     l-0.219-0.235l0.02-0.117l0.962-0.12l0.337,0.043l1.979,0.598l0.981,0.204l1.772,0.202l0.385,0.263l0.618,0.526l0.426,0.642l0.433,0.422l0.362,0.189l1.587,0.536l0.316,0.203l0.48,0.756l0.116,0.407l-0.279,0.349l-0.407,0.016z M271.379,92.089l-1.202-0.23     l0.641-0.743l0.358-0.161l0.279,0.058l0.292,0l0.355-0.263l-0.697-0.653l0.079-0.219L272,89.003l1.121-1.35l1.454-1.31l0.725-0.442l0.496-0.192l1.315-0.194l0.198,0.073l0.11,0.221l-0.299,0.221l-0.582,0.03l-0.242,0.133l0.349,0.44l-0.755,0.78l-1.226,1.438     l-0.271,0.526l0.113,0.291h0.11l0.428-0.176l0.483-0.555l0.458-0.191l1.115,0.305l-0.896,0.687l0.261,0.203l0.229,0.072l1.423,0.565l0.758-0.03l0.325-0.408l0.309-0.059l0.718,0.057l0.826,0.202l0.616,0.231l-0.297,0.292l-0.373,0.233l-0.708,0.467l0.339,0.333     l0.477,0.362l0.26,0.014l0.417-0.161l0.464-0.132l0.278,0.116l0.02,0.16l-0.254,0.262l-0.404,0.248l-0.892,0.104L280.84,93l0.273,0.362l0.124,0.405l0.28,0.231l0.183-0.203l0.309-0.262l0.527,0.159l-0.099,0.449l0.149,0.275l0.716,0.028l0.085-0.015l0.015,0.203     l-0.168,0.304l-0.25,0.652l-0.34,0.651l-0.222-0.072l-0.71-0.128l-0.301-0.144l-0.042-0.651l-0.601,0.406l-0.374,0.015l-0.095-0.274l0.497-0.652l0.011-0.333l-0.421-0.478l-0.279-0.072l-0.388,0.392l-0.423,0.291l-0.365,0.146l-0.435,0.204l-0.552,0.536     l-0.496,0.334l-0.881-0.042l-0.222-0.217l0.165-0.145l1.229-0.408l0.466-0.522l0.632-0.363l-0.699-0.129l-0.601-0.057l-0.322,0.464l-0.412,0.015l-0.13-0.159l0.04-0.493l-0.757,0.016l-0.148,0.29l-0.41,0.218l-1.052,0.045l-0.709-0.057l-1.139-0.186l-1.012-0.085     l-1.355,0.061l-1.014,0.147l-0.145-0.188l-0.215-0.463l0.187-0.175l0.561-0.334l0.734-0.408l0.502-0.161l0.636-0.335z M265.435,98.655l-0.469-0.057l-0.497-0.273l-0.356-0.562l0.062-0.635l0.742-0.738l0.932-1.043l0.816,0.432l-0.375,0.435l-0.112,0.462     l-0.233,0.333l-0.262,0.116l-0.58,0.319l-0.244,0.448l0.522,0.244l0.168-0.029l0.279-0.26l0.42-0.362l0.617-0.319l0.309,0.057l0.495,0.461l-0.177,0.347l-0.246,0.159l-1.134,0.42l-0.682,0.044z M211.34,59.677l-0.68-0.046l0.068-0.872l-0.375-0.333l-0.958,0.161     l-2.375,0.29l0.107-0.461l0.56-0.303l1.644-0.561l-0.302-0.478l-0.102-0.415l0.106-0.417l0.398-0.835l0.434-0.566l0.254-0.648l0.331-0.471l1.11,0.566l-0.312,0.518l0.791,0.386l0.527,0.047l0.402-0.469l0.67,0.112l0.806,0.289l0.917,0.514l0.582,0.255l2.168,0.492     l0.442,0.271l0.176,0.255l-0.09,0.925l0.539,0.047l0.57-0.065l0.934,0.046l0.701,0.142l1.019,0.427l-0.419,0.096l-0.269,0.127l-0.46,0.271l-0.949-0.046l-0.623-0.125l-1.328-0.125l-0.438-0.126L217.259,58l-0.528-0.301l-1.017-0.237l-0.528,0.017l-0.203,0.271     l0.174,0.588l-0.126,0.096l-1.314,0.161l-0.673,0.493l-0.588,0.302l-1.116,0.287z M200.125,19.1l-0.862-0.015l-1.085-0.195l-0.308-0.664l0.819-0.304l0.77-0.072l0.666-0.024l3.475-0.125l1.263-0.12l1.374-0.026l1.714,0.324l0.397-0.094l0.397-0.377l1.303-0.287     l1.759-0.099l1.975,0.209l0.746-0.001l2.562,0.137l2.621,0.324l1.424,0.09l1.461,0.161l0.448-0.165l-1.433-0.42l-1.67-0.352l-0.816-0.429l0.293-0.242l1.361-0.148l1.101-0.246l1.431-0.101l2.382-0.201l1.666,0.119l1.944,0.191l1.009,0.265l1.19,0.456l0.354,0.047     l0.273-0.362l-0.959-0.508l-0.828-0.292l0.499-0.248l1.45,0.121l1.832,0.168l1.653,0.07l1.639,0.46l0.378,0.023l0.062-0.195l-0.301-0.539l1.781-0.004l1.408,0.046l0.832,0.269l0.831,0.34l0.618-0.001l-0.044-0.268l-0.331-0.467l1.075-0.077l3.691,0.386     l2.726,0.288l1.937-0.077l2.987,0.018l0.967,0.047l0.757,0.12l0.126,0l1.419,0.094l1.089,0.191l0.744,0.095l1.685,0.044l1.357,0.357l-0.385,0.358l-1.237,0.121l-1.206,0.356l-1.849,0.191l-0.978-0.045l-2.191-0.159l-2.284,0.005l-0.776,0.142l-1.915,0.168     l-0.597,0.465l0.75,0.366l0.761,0.044l1.03-0.048l1.705-0.279l0.79,0.021l0.808,0.434l-0.168,0.114l-1.246,0.139l-1.38,0.207l-1.174,0.295l-2.098,0.518l-1.316,0.224l-1.19,0.355l-0.924,0.286l-2.252,0.005l0.65,0.906l-0.449,0.193l-2.297,0.455l-0.768-0.019     l-1.587-0.037l-1.462-0.218l-2.386-0.164l-0.66,0.33l2.591,0.695l-0.662,0.141l-0.967-0.038l-1.297,0.022l-1.068,0.022l-2.58-0.214l-2.009,0.063l-0.134,0.66l1.257-0.105l1.065,0.018l2.312,0.292l0.557,0.157l0.12,0.67l-0.33,0.197l-1.031,0.12l-0.515,0.705     l-1.073,0.021l-0.448-0.058l-0.402,0.176l0.297,0.253l0.759,0.25l-0.328,0.136l-1.615,0.08l-0.867-0.037l-1.71-0.171l-0.422,0.078l0.41,0.791l-0.08,0.231l-0.649,0.289l-0.767,0.155l-1.52-0.112l-2.039-0.111l-1.43-0.227l-1.008,0.079l-1.219,0.5l1.031,0.112     l0.368,0.057l2.154,0.11l1.759,0.13l1.534,0.168l2.001,0.034l0.66,0.34l0.045,0.359l-0.907,0.398l-2.685,0.268l-0.927,0.115l-1.054,0.227l-1.115,0.077l-0.467-0.28l-0.797-0.638l-0.56,0.039l-0.631,0.001l-1.453-0.318l-0.001,0.17l0.331,0.508l-1.477-0.016     l-1.5-0.129l-0.875-0.319l-1.033-0.471l-0.388,0.058l0.527,0.717l-0.24,0.17l-0.821,0.133l-1.72-0.109l-2.276-0.033l-0.972-0.073l-1.382-0.394l-0.642-0.131l-0.282,0.453l-0.619,0.152l-1.843-0.316l0.161-0.586l0.219-0.228l1.525-0.117l0.61-0.249l0.961-0.173     l1.179,0.036l0.499-0.172l-1.073-0.4l-1.043-0.651l0.052-0.154l0.479-0.117l1.316,0.036l1.743,0.093l0.888,0.21l1.108,0.517l1.35,0.323l1.085,0.093l1.667-0.022l0.829-0.136l0.086-0.268l0.514-0.304l-3.019,0.001l-1.025-0.171l-0.156-0.85l0.211-0.154l-1.74-0.153     l-1.963-0.152l-0.274,0l-0.631,0.114l0.204-0.758l1.159-0.551l1.104-0.16l1.837-0.003l1.164,0.037l1.37,0.076l2.023,0.311l1.342,0.115l0.486-0.158l1.132-0.041l-3.399-0.802l-1.742-0.313l-3.555-1.27l-0.406,0.242l-1.398-0.878l0.025-0.258l0.313-0.108     l1.747,0.104l1.905-0.004l2.019,0.06l1.6,0.382l2.535,0.784l1.448-0.043l0.833,0.095l-1.387-0.555l-2.015-0.317l1.208-0.743l1.456-0.329l1.731-0.025l1.529-0.222l2.042-0.07l1.157-0.112l1.414-0.051l-1.778-0.479l-1.425-0.153l-2.501,0.027l-1.243,0.248     l-1.305,0.158l-1.425,0.202l-1.447,0.047l-0.586,0.067l-1.532-0.438l-0.214,0.111l-0.543,0.156l-2.16-0.018l-1.58,0.365l0.311-0.828l0.98-0.292l0.007-0.202l-0.606-0.247l-1.375-0.156l-1.39,0.003l-4.189,0.505l-2.031,0.672l-0.408-0.11l-0.569-0.251l0.395-0.133     l0.678-0.023l-0.117-0.316l-0.698-0.398l-1.216-0.056l-0.216-0.003z M200.125,20.844l0.899-0.096l0.832,0.196l0.339,0.5l0.511,0.495l0.427,0.063l1.141,0.041l-0.081-0.236l0.056-0.411l0.438-0.109l0.718,0.194l0.718,0.322l0.374,0.3l-0.066,0.171l0.056,0.826     l0.764,0.442l0.953-0.017l1.276-0.074l1.646,0.504l-1.123-0.264l-1.528,0.34l-1.599,0.221l-0.83,0.377l-0.287,0.197l-0.265,0.315l-0.448,0.021l-1.493-0.41l-0.656,0.335l0.465,0.43l-0.029,0.235l-0.412,0.196l-0.392,0.04l-1.086-0.31l-0.944-0.311l-0.26,0.645     l-0.117,0.068l-0.083,0.049l-0.888,0.041l-1.74-0.094l-1.458-0.153l-0.888-0.154l-0.494,0.021l-3.115-1.31l-0.191-0.276l1.971-0.241l3.32,0.093l0.889,0.097l1.573,0.1l-2.485-0.693l-3.019-0.213l-1.103,0.122l-1.43-0.017l-0.597,0.18l-1.008,0.022l-0.606-0.198     l-1.066-0.517l-1.425-0.479l-0.341-0.355l1.971,0.124l2.278-0.175l-1.255-0.249l-0.756-0.351l0.38-0.305l0.729-0.132l0.769-0.023l0.921,0.042l0.156-0.219l-1.799-0.793l1.053-0.114l1.213-0.182l1.13,0.087l0.584-0.046l0.145-0.18l-0.514-0.475l1.362,0.134     l0.941,0.066l0.83,0.202l1.589,0.869l0.653,0.264l0.772,0.24l0.674-0.001l0.36-0.039z M179.067,27.216l-1.156-0.056l-0.604-0.173l-0.926-0.638l-0.621-0.193l-3.102-0.091l-1.487,0.081l-0.622,0.001l-1.444-0.056l-0.767-0.154l-1.019-0.37l-0.161-0.234l0.335-0.138     l0.802-0.001l1.687,0.232l0.867-0.021l-0.031-0.235l-0.252-0.275l-1.344-0.49l-0.579-0.098l-1.075-0.077l-1.392-0.196l0.065-0.397l2.246-0.124l2.392,0.155l0.77,0.376l0.999,0.453l1.979,0.193l2.189,0.114l1.178,0.233l0.604,0.254l1.123,0.721l0.581,0.446     l0.168,0.426l-0.481,0.194l-0.919,0.137z M185.907,26.758l-1.078-0.037L184,26.529l-1.029-0.484l-1.144-0.76l-0.03-0.216l0.239-0.099l2.296-0.044l1.816,0.311l3.101,0.542l-0.047,0.351l-0.254,0.331l-0.436,0.04l-1.563,0.177l-1.043,0.08z M156.886,26.865     l-1.573,0.646l-0.558,0.27l-1.85,0.042l-1.019,0.079l-1.898-0.15l-0.577-0.114l-0.302-0.423l0.334-0.291l1.365-0.177l0.899,0.056l2.351-0.102l0.496,0l2.331,0.163z M132.902,31.305l-0.53-0.186l-0.95-0.466l-0.424-0.112l-0.33,0.057l-0.56,0.207l-1.269,0.059     l-0.786-0.279l-0.283-0.319l0.23-0.264l1.13-0.097l0.503-0.133l0.771-0.134l0.977-0.399l0.848-0.211l0.726-0.172l0.548-0.344l1.083-0.231l1.277-0.079l2.532-0.158l1.68,0.016l0.888-0.29l1.038-0.079l1.503,0.438l-0.756,0.097l-0.852,0.231l-0.22,0.268l0.12,0.266     l0.469,0.474l-0.777,0.001l-0.912,0.115l-0.918,0.662l-1-0.017l-0.867-0.981l-0.694-0.15l-0.379,0.02l-0.229,0.285l-0.588,0.342l-0.63,0.623l-0.595,0.151l-0.284,0.375l-0.705,0.356l-0.787,0.058z M191.827,30.313l-1.266-0.054l-2.278-0.165l-0.426,0.058     l-0.332-0.094l-0.896-0.489l-1.185-0.414l0.192-0.229l2.433-0.042l1.542,0.263l1.472,0.054h0.171l0.89,0.358l-0.179,0.246l0.123,0.32l-0.263,0.188z M144.688,31.739l-2.222-0.395l-0.325-0.674l0.503-0.057l0.595-0.17l0.945-0.096l0.953-0.133l1.279-0.059     l0.522,0.187l0.65,0.374l0.659,0.186l1.55-0.209l0.617,0.149l1.624,0.762l1.016,0.351l0.897,0.036l0.96-0.058l1.418,0.09l0.591-0.02l1.116-0.169l0.092-0.297l-0.557-0.559l-0.941-0.391l-1.347-0.354l0.96-0.322l0.524-0.379l0.569-0.152l1.097-0.116l0.507,0.17     l0.773,0.678l-0.017,0.413l0.518,0.654l0.565,0.111l0.9,0.036l1.805,0.406l-0.334-0.465l0.151-0.28l0.409-0.076l1.495,0.24l0.932,0.39l-0.292,0.409l0.039,0.5l-0.358,0.461l-0.573,0.277l-0.755,0.111l-0.782,0.001l-1.682,0.095l-1.156-0.071l-1.757-0.18     l-0.622-0.017l-1.129,0.277l-1.132,0.202l-0.76,0.182l-0.977,0.254l-1.625,0.292l-1.338,0.2L149.23,34.5l-0.748-0.07l-1.445-0.286l-0.276-0.378l0.648-0.128l1.219-0.038l0.738-0.146l0.852-0.075l1.166-0.057l0.622,0.017l1.09-0.149l0.483-0.553l-2.768-0.087     l-0.925-0.054l-1.564,0.28l-1.625,0.168l-1.292,0.04l-0.795,0.093l-1.681-0.347l-0.479,0.167l-0.92,0.075l-0.979-0.127l-0.854-0.33l0.023-0.111l0.863-0.427l1.098-0.058l2.047-0.022l0.96-0.159z M178.479,33.234l-0.984-0.219l-0.193-0.294l0.764-0.389l0.433-0.112     l0.088-0.167l-0.447-0.333l-1.161-0.054l-2.13,0.227l-0.939,0.076l-0.331,0.019l-0.854-0.276l0.039-0.335l0.739-0.02l0.542-0.244l0.587-0.057l-0.466-0.598l0.176-0.245l0.132-0.226l0.49,0.018l0.859,0.224l1.942,0.746l0.426,0.186l0.46-0.094l-0.101-0.243     l-0.959-0.486l-0.371-0.131l-0.407-0.357l0.436-0.095l0.956-0.059l0.713,0.131l1.033,0.262l0.572,0.168l0.27,0.018l0.162-0.452l0.478-0.133l0.73,0.112l0.717,0.168l0.327,0.168l0.367,0.75l-0.034,0.616l-0.247,0.242l-0.831,0.335l-0.017,0.352l0.35,0.625     l-0.361,0.147l-1.648-0.089l-0.862,0.112l-1.446,0.003z M200.125,30.572l-0.895,0.045l-0.853,0.17l-0.37,0.467l1.133,0.054l0.984-0.038l0.046-0.001l0.847,0.11l0.463,0.129l0.498,0.463l0.727,0.424l0.621,0.091l0.213-0.074l0.043-0.314l0.286-0.056l1.075-0.002     l0.883-0.187l0.766,0.11l0.835,0.239l0.665,0.257l0.976,0.053l0.775-0.463l1.393-0.281l1.704-0.114l1.951-0.246l1.533,0.053l2.59,0.014l0.381,0.037l0.79,0.314l0.911,0.239l1.418,0.146l0.653,0.128l0.21,0.037l0.361,0.166l0.181,0.257l-0.4,0.148l-1.833,0.407     l-0.135,0.255l0.469,0.666l-2.486,0.076l-0.592,0.02l-0.651,0.091l-0.768-0.053l-0.846-0.16l-0.405-0.125l-0.306-0.667l-0.833-0.218l-0.366,0.129l0.072,0.723l-0.536,0.127l-0.747-0.053l-0.91,0.109l-0.728-0.017l-0.495,0.001l-1.342-0.213l-0.593-0.197     l-0.495-0.017l-0.209,0.433l-1.801,0.111l-0.831,0.074l-1.453-0.069l-0.404-0.251l-0.144-0.686l-1.237,0.129l-0.389,0.181l-0.326,0.325l-0.955,0.2l-1.011-0.034l-0.112-0.027l-0.704-0.169l-1.186-0.575l-0.675,0.489l-1.131-0.07l-0.666-0.688l-0.442-0.717     l0.587-0.481l0.019-0.371l-0.292-0.316l-1.249-0.651l-0.617-0.299l-0.047-0.338l0.636-0.133l1.226-0.078l2.472-0.023l0.763,0.093l1.118,0.261l0.188,0.04l0.872,0.184l-0.613,0.189l-0.259,0.013z M128.19,41.985l-0.926-0.016l-1.059-0.102l-0.362-0.466     l-0.549-0.467l-0.432-0.259l-1.123-0.363l-1.36-0.067l-0.951-0.138l-0.469-0.19l-0.168-0.174l0.537-0.106l0.589-0.298l0.481-0.211l0.08-0.386l-0.437-0.809l0.552-0.001l0.468-0.177l0.307-0.372l1.104-0.533l0.526-0.588l-0.121-0.32l-0.271-0.16l-1.229-0.677     l-0.375-0.448l0.869-0.001l0.823-0.056l1.455,0.051l0.97,0.016l1.515-0.092l1.284-0.146l1.242-0.074l0.495,0.125l3.242,0.801l0.918,0.088l0.708-0.055l1.316-0.127l1.223,0.016l0.771,0.07l1.35,0.373l2.389,0.815l-0.242,0.143l-0.432,0.036l-0.26,0.072     l-1.609,0.322l-1.073,0.144l-1.829,0.428l-1.069,0.319l-1.604,0.725l-1.025,0.563l-0.549,0.089l-0.974,0.124l0.066,0.924l-0.271,0.504l-0.662,0.278l-1.215,0.124l-1.213-0.067l-0.521,0.485l-0.898,0.312z M190.483,39.666l-1.146-0.208l-0.146-0.524l-0.941-0.806     l-0.207-0.582l0.058-0.389l0.27-0.657l0.377-0.321l1.256,0.033l-0.089-0.16l-0.416-0.266l-0.185-0.286l0.211-0.09l0.234-0.072l2.154-0.058l1.215,0.087l1.464,0.248l1.282,0.051l1.316-0.146l1.051,0.016l0.694,0.105l0.639,0.213l-0.007,0.089l-0.224,0.179     l-0.824,0.428l-0.874,0.746l-1.513,0.92l-1.386,0.073l-2.379-0.154l-1.269,0.055l1.392,0.717l-0.188,0.315l-0.855,0.369l-0.964,0.072z M181.204,41.523l-0.491-0.085l-1.101-0.552l-0.952-0.641l-1.014-0.468l-0.978-0.225l-1.438-0.12l-0.55-0.174l-2.255-1.066     l0.866-0.654l0.653,0.14l1.032,0.474l1.063,0.227l0.46,0.052l0.615-0.283l0.908-0.619l0.415-0.036l0.018-0.212l-1.062-0.565l-1.068-0.424l-0.177-0.231l0.132-0.107l1.683,0.086l0.711-0.215l0.42,0l0.996,0.39l0.56,0.035l0.58-0.055l0.435-0.25l1.232-0.127     l1.354,0.069l0.912,0.23l-0.324,0.268l-0.58,0.125l-0.323,0.338l-1.55,0.375l-0.392,0.16l-0.069,0.194l0.253,0.247l0.506,0.105l0.692-0.089l1.08,0.174l0.868,0.245l0.391,0.017l0.564,0.262l0.186,0.438l-0.681,0.352l-0.156,0.35l-0.271,0.68l-0.457,0.366     l-0.508,0.14l-0.658,0.019l-0.582-0.103l-0.773-0.346l-0.653-0.103l0.013,0.208l1.054,0.553l-0.817,0.399l-0.77,0.036z M243.524,60.394l-0.234-0.208l-1.199-0.235l-0.673-0.331l-0.154-0.269l0.346-0.064l0.616-0.461l-1.378-0.521l-1.132-0.125l-0.76-0.349     l-0.929-0.731l-0.035-0.511l-1.115-0.062l-1.311-0.366l-0.675-0.031l0.284,0.767l-0.155,0.096l-0.409-0.015l-1.704-0.332l-0.309,0.033l-0.325,0.304l-0.441,0.288l-1.312,0.082l-1.349-0.173l-1.343-0.189l-0.813-0.254l-0.052-0.319l0.196-0.4l0.382-0.354     l1.066-0.163l0.192-0.178l-0.128-0.516l0.206-0.033l1.357,0.11l1.408,0.175l0.517,0.144l0.962,0.626l0.051-0.386l-0.154-0.193l0.077-0.194l0.585-0.033l0.977-0.099l0.652-0.163l0.649-0.114l0.515,0.063l0.785,0.031l0.166-0.275l-1.138-0.825l-0.773-0.356     l-0.119-0.228l0.167-0.163l0.586-0.066l0.72-0.246l1.409-0.591l0.361-0.541l0.771-0.46l0.493-0.379l-0.109-0.593l-0.899-0.841l-0.407-0.496l-0.541-0.364l-0.414,0.001l-1.258-0.33l-1.041-0.481l-0.244-0.467l-0.527-0.384l-0.442,0.202l-0.551,0.202l-0.825-0.015     l-0.293,0.117l-0.62,0.018l-1.255,0.169l-0.214-0.667l1.032-0.052l1.23-0.103l0.163-0.269l-1.604-0.618l-1.552-0.67l-0.879-0.015l-0.567-0.185l-0.169-0.542l-0.677-0.339l-0.45-0.05l-0.918-0.306l-0.687-0.341l-0.385-0.119l-0.611,0.155l-0.81-0.187l-1.177-0.238     l-0.489-0.085l-0.379,0.138l0.529,0.307l0.453,0.05l2.838,0.712l0.438,0.271l0.069,0.306l-0.505,0.221l-0.669,0.069l-0.541-0.033l-0.757-0.049l-0.818-0.252l-1.153-0.27l-0.667-0.066l-0.323,0.17l0.044,0.204l0.426,0.236l0.259,0.438l-1.703-0.553l-0.47-0.05     l-0.396,0.119l-0.63,0.153l-0.767-0.218l-0.693-0.117l-0.859,0.12l-1.474-0.184l-1.995-0.167l-1.321,0.037l-1.146-0.032l-0.862-0.186l-0.003-0.597l-0.363-0.153l-0.904-0.049l-0.396,0.342l-0.623,0.086l-1.214-0.049l-1.076-0.168l-1.303-0.477l-0.415-0.376     l0.123-0.275l0.868-0.07l1.131,0.067l1.212,0.101l0.879-0.019l0.312-0.19l-0.934-0.463l-0.8-0.275l-0.905-0.102l-1.106-0.119l-0.752,0.036l-0.539-0.017l-1.249-0.223l0.114-0.416l0.292-0.557l0.34-0.14l0.646-0.054l0.081-0.227l-1.082-0.4l-0.044-0.175l0.449-0.79     l1.197-0.919l0.565-0.284l0.918-0.321l0.74-0.374l0.423-0.037l0.37-0.178l0.698-0.001l0.481-0.125l0.71-0.09l1.436-0.109l1.348,0.033l0.857,0.194l-0.92,0.393l-0.815,0.48l-1.394,0.639l-0.43,0.529l0.169,0.369l1.256,0.541l-0.444,0.298l-0.076,0.402l0.257,0.313     l0.862,0.554l1.559,0.621l-0.096,0.121l-1.272,0.331l-0.072,0.31l0.959,0.033l1.504,0.101l0.654-0.639l-0.103-0.415l-0.343-0.277l-0.724-0.103l-0.422-0.138l-0.884-0.538l0.101-0.157l0.506-0.245l0.473-0.193l1.001,0.12l0.837-0.071l-1.204-0.47l-0.703-0.034     l-0.793-0.279l-0.056-0.193l0.053-0.545l0.886-0.319l1.207,0.086l1.509-0.056l-0.939-0.281l-1.233-0.351l0.793-0.303l1.288-0.198l1.044-0.126l1.688-0.323l1.114,0.016l0.642,0.052l0.833,0.141l0.782,0.478l1.536,0.97l0.058,0.141l-0.583,0.687l-0.709,0.632     l0.038,0.733l0.364,0.086l0.65,0.033l1.088-0.315l0.284-0.455l0.595-0.088l0.791,0.034l0.454,0.174l-0.006,0.262l0.16,0.47l0.875,0.189l0.196-0.122l-0.204-0.854l0.218-0.123l0.456-0.474l1.038-0.265l0.98-0.054l0.748,0.034l0.98,0.174l1.172,0.138l1.151-0.09     l0.688,0.139l0.327,0.262l0.621,0.331l0.574,0.191L235.438,40l0,0.191l-0.531,0.088l-0.484,0.279l-0.818,0.262l-0.148,0.225l0.45,0.259l0.427,0.068l0.897-0.417l0.652-0.174l0.502,0.051l0.476,0.242l0.365,0.466l0.516,0.413l0.342-0.242l1.304-0.798l1.935,0.256     l0.915,0.361l-0.051,0.069l-0.638,0.346l-0.708,0.517l1.167-0.054l0.455-0.173l1.078-0.105l0.033,0.704l0.797,0.324l0.523-0.069l0.831-0.207l1.316-0.088l0.816,0.221l0.566,0.273l-0.162,0.154l-0.461,0.223l-1.87,0.43l-0.238,0.272l0.523,0.253l0.456-0.068     l0.747-0.171l1.235-0.122l0.406-0.29l0.361-0.103l0.479,0.067l0.51,0.187l0.544,0.339l0.636,0.522l-1.019,0.002l-1.2,0.053l-0.424,0.135l0.059,0.269l0.372,0.134l1.333,0.065l0.938,0.183l0.543,0.217l0.233,0.301l-0.37,0.034l-0.748,0.001l-1.011-0.082     l-0.875-0.216l-0.824-0.065l-0.316,0.185l1.23,0.583l-0.216,0.201l-1.552,0.12l0.245,0.283l0.437,0.166l0.551,0.032l1.331,0.364l1.312,0.347l0.247,0.182l0.039,0.282l0.351,0.38l0.75-0.217l0.536,0.049l1.413,0.295l0.298-0.067l0.649-0.15l0.61,0.032l0.752,0.379     l0.862,0.477l0.376,0.346l-0.685,0.1l-0.801,0.117l-0.027,0.444l0.795-0.001l1.405-0.052l0.51-0.132l0.895,0.048l-0.386,0.559l0.918,0.179l0.514-0.001l0.943-0.379l0.685,0.343l1.089,0.407l0.194,0.098l-0.275,0.229l-0.254,0.099l-0.103,0.326l-0.819,0.05     l-0.718-0.21l-0.247-0.048l-0.794,0.213l0.968,0.454l0.279,0.162l0.057,0.276l-1.057,0.197l-0.356,0.228l-0.312,0.292l-0.372-0.113l-0.819-0.583l-0.29,1.103l0.354,0.903l-0.419,0.065l-0.677-0.257l-0.751-0.176l-0.205-0.177l-0.018-0.243l-0.315-0.274     l-0.93,0.276l-0.743-0.613l0.051-0.292l0.27-0.374l-0.304-0.129l-0.224-0.016l-0.992-0.08l-0.718-0.292l-1.17-0.617l-0.769-0.292l-0.762-0.048l-0.452,0.23l-0.645,0.083L250,52.592l0.281,0.179l1.05,0.682l-0.321,0.114l-0.686,0.05l-0.359-0.259L249.277,53     l-0.646-0.21l0.275,0.488l0.859,0.972l0.604,0.015l0.587,0.08l0.5,0.581l0.612,0.805l0.513,0.432l0.615-0.321l0.285,0.047l0.592,0.399l0.585,0.271l1.38,0.396l-0.634,0.113l-0.213,0.208l0.254,0.19l0.568,0.286l0.962,0.444l0.324,0.237l0.242,0.682l-0.112,0.428     l-1.302-1.155l-0.554-0.237l-0.027,0.238l0.118,0.27l1.055,1.281l-0.01,0.3l-0.926-0.125l0.053,0.205l0.432,0.409l0.378,0.519l-0.563-0.172l-0.615-0.313l-0.889-0.693l-0.145-0.031l-0.719,0.064l-0.91-0.188l-1.44-0.662l-0.319-0.285l-1.062-0.665l0.187,0.777     l-1.22-0.473l-0.567-0.158l-0.872-0.03l0.095,0.222l0.799,0.696l0.853,0.426l1.842,0.645l1.296,0.644l0.774,0.549l0.442,0.486l0.429,0.689l-1.833-0.341l-1.524-0.421l-1.251-0.28l-1.444-0.107l-1.092-0.25l-0.898-0.644l-1.146-0.14l-0.638-0.204l-0.635-0.141     l-0.058,0.145z M146.194,38.698l0.818-0.037l0.78-0.125l1.138-0.548l0.895-0.019l1.723,0.243l0.939,0.262l-0.188,0.877l0.515-0.071l0.66-0.019l0.792-0.229l0.599-0.141l0.758,0.016l0.334-0.071l-0.989-0.965l0.156-0.036l1.38,0.138l1.208,0.245l0.675,0.245     l0.259,0.245l0.194,0.508l0.965,1.063l0.638,0.346l1.045-0.315l0.14-0.261l-1.243-1.361l-0.439-1.321l0.228-0.354l1.91,0.262l1.775,0.156l2.031,0.719l0.36,0.175l0.3,0.316l0.16,0.701l0.511,0.645l0.352,0.26l0.856,0.606l0.048,0.19l-0.178,0.243l-0.333,0.605     l0.179,0.31l0.224,0.12l1.4,0.649l0.509,0.171l1.151,0.254l1.513,0.1l2.056,0.576l1.012,0.39l0.364,0.793l-0.168,0.101l-1.071-0.082l-0.811-0.234l-0.945-0.234l-0.551,0.169l-0.665,0.204l-1.021,0.036l-0.256,0.118l0.208,0.689l1.087-0.069l0.614-0.152     l0.676-0.119l0.876,0.536l-0.01,0.235l-0.526,0.151l-0.517,0.252l-0.583,0.102l-1.417,0.12l-1.049-0.015l-1.194-0.082l-1.594-0.248l-2.278-0.499l-0.553-0.217l-0.436-0.335l-0.482-0.033l-0.581,0.102l-0.402,0.37l-1.114,0.505l-1.055,0.019l-1.411,0.103     l-1.253,0.42l-2.753,0.356l-1.42,0.019l-1.205,0.086l-1.984-0.063l-0.483,0.101l-0.916-0.015l-1-0.282l-0.061-0.468l0.198-0.101l0.002-0.302l-0.395-0.2l-0.462-0.1l-3.146-0.112l-1.258-0.115l-0.864-0.167l-0.801-0.2l-0.753-0.504l-1.274-0.554l0.303-0.069     l0.531-0.222l1.572-0.054l0.603-0.188l0.558,0.016l0.91-0.019l0.904-0.087l1.716,0.031l0.935-0.002l2.14,0.047l1.09-0.002l1.711-0.038l0.415-0.154l-0.681-0.221l-2.312-0.492l-1.942-0.202l-4.059-0.061l-1.569-0.014l-1.694,0.055l-0.955,0.053l-0.604,0.001     l-1.651-0.529l0.011-0.207l0.28-0.069l0.823-0.053l1.315-0.209l0.996,0.032l1.78-0.141l0.931-0.105l0.5-0.277l-0.392-0.346l-2.023,0.073l-1.578,0.159l-0.393-0.051l-0.554-0.189l-0.677-0.346l-0.65-0.19l-0.692,0.054l-0.709-0.242l-0.039-0.279l1.304-0.981     l2.62-0.848l0.909-0.143l0.373-0.177l1.297-0.267l1.324-0.162l0.701-0.267l1.113-0.091l1.026,0.246l-0.07,0.212l-0.548,0.354l-0.021,0.81z M251.273,99.526l-0.188,0.153l-0.16-0.291l0.192-0.077l-0.02-0.256l0.143-0.069l-0.042-0.154h-0.224l-0.606-0.231     l0.077-0.229l-0.31-2.819l-0.174-0.274l-0.488-0.288l-0.771-0.025l-0.41,0.176l-0.381-0.085l-0.505-0.36l-0.273-0.085l-0.632,0.526l-0.514,0.626l-1.139,2.22l-1.139,1.45l-1.161-0.124l-0.402,0.06l-0.363,0.435l-0.174,0.375l-1.093-0.095l-1.855-0.004     l-2.508-0.029l-1.76,0.009l-0.968,0.523l-0.534,0.305l-1.754,0.814l-0.545,0.164l-0.146,0.434l-0.163,0.512l-0.44,0.275l-1.156,0.197l-1.305-0.138l-1.123-0.01l-0.93,0.091l-0.47,0.203l-0.162,0.375l0.018,0.319l0.16,0.471l0.047,0.362l-0.875,0.427l-1.464,0.452     l-0.944,0.163l-0.919,0.062l-0.88,0.262l-0.939,0.478l-0.925,0.506l-0.524,0.117l-0.573-0.068l-0.497-0.169l-0.371-0.427l-0.012-0.33l0.044-0.218l0.707-0.525l0.414-0.294l0.264-0.433l0.294-0.544l0.377-0.576l0.028-0.746l-0.054-0.545l-0.876-3.16l-2.529-1.05     l-0.26-0.33l0.11-0.318l-0.307-0.235l-0.916-0.181l-0.184-0.294l-0.178-0.135l-0.628,0.024l-0.46-0.465l-0.101-0.429l-2.15-1.061l-3.975-1.576l-0.977-0.386l-0.797-0.227l-0.805,0.189l-1.469,0.592l-0.707-0.074l-0.542,0.049l-0.196-0.144l-0.156-0.115     l-0.474-0.041l-0.855,0.083l-0.197-0.116l-0.028-0.282l-0.373,0.075l-0.412,0.191l-0.219,0.06l-0.573,0.141l-0.506-0.098l-0.064-0.185l-0.469-0.086l-0.241-0.271l-0.502-0.013l-0.16,0.247l-0.338-0.48l-0.271,0.012l-0.02-0.185l-1.425-0.208l-0.518,0.076     l-0.833-0.451l-0.468-0.46l-0.279-0.371l-0.896-0.748l-0.501,0.036l0.131,0.347l0.387,0.588l-0.68-0.003l-2.687,0.029l-2.798-0.029l-1.348,0.007l-2.105-0.003l-2.915,0.016l-2.781-0.029l-2.131,0.012l-2.935-0.014l-0.601,0.003l-4.84-0.018l-3.617,0.004     l-0.875,0.005l-3.821-0.023l-1.089,0.035l-4.13-0.021l-0.74-0.011l-5.117,0.028l-1.687-0.006l-2.87,0.001l-3.938-0.008l-4.588,0.025l-1.335-0.022l-2.579-0.001l-0.194-0.013l-0.187-0.151l-0.509-0.305l-0.071-0.437l0.074-0.346l-0.708,0.25l-0.373-0.029     l-0.331-0.305l-0.162-0.496l-0.125-0.189l-0.385,0.088l-0.23,0.205l-0.483,0.059l-0.721-0.495l-0.119-0.425l-0.201-0.821l-1.051,0.104l-1.01-0.277l-0.487-0.087l-0.173-0.087l-0.143-0.396l-0.438-0.352l-0.591,0.222l-1.236,0.046l-0.461-0.117l-0.383-0.249     l-0.106-0.25l0.257-0.648l0.458-0.222l-0.227-0.294l-1.24-0.086l0.617-0.518l0.398-0.281l0.547-0.149l0.605-0.508l-0.874,0.006l-0.621,0.149l-0.362-0.043L116,83.422l-0.039-0.978l-0.789,0.002l-1.015-1.066l0.132-0.238l0.034-0.53l-0.547,0.056l-0.83,0.492     l-1.266-0.934l-0.384-0.521l-0.204-0.402l-0.068-0.432l0.419-0.404l0.161-0.254l0.436-0.3l-0.358-0.689l-0.393-0.777l0.163-0.788l-0.402-0.255l-2.025-0.763l-0.98-0.314l-0.189-0.029l-0.512-0.393l-1.67-1.882l-1.769-1.768l-0.814-0.58l-2.048-1.175l-0.35-0.322     l-0.371-0.492l-0.316-0.199l-0.832-0.073l-0.495,0.126l-0.731,0.498l-1.225,0.67l-0.848,0.205l-0.238,0.325l-0.945-0.673l-2.162-1.318l-0.348-0.292l-0.173-0.387l-0.332-0.388l-0.739-0.059l-2.424,0.122l-0.84-0.074l-0.196-0.279l-0.089-1.046l-0.026-2.167     l0.043-4.334l0.026-2.183l-0.129-2.796l-0.052-2.335l-0.039-2.259l0.003-2.855l-0.102-0.483l0.71,0.024l0.9-0.086l0.964,0.116l2.012,0.451l1.601,0.518l1.214,0.266l1.04,0.115l0.731,0.032l1.619,0.164l0.888,0.232l0.429,0.149l0.254-0.034l-0.452-0.601l-0.357-0.2     l-0.345-0.15l-0.064-0.419l1.344-0.423l0.745,0.066l0.578-0.068l0.15-0.102l1.736,0.148l0.771-0.001l1.125-0.373l0.309-0.186l0.442,0l0.656-0.221l0.759-0.069l0.866-0.086l0.734-0.086l0.469-0.239l0.392-0.188l0.771-0.104l1.045-0.002l0.872,0.123l-0.445,0.404     l-0.352,0.119l-1.101,0.137l-1.092,0.373l-1.244,0.171l-1.22,0.271l-0.699,0.522l-1.767,0.255l-0.681,0.487l0.846,0.266l1.441,0.748l-0.219-0.55l0.168-0.351l1.196-0.253l0.39-0.235l0.726-0.421l1.727-0.053l0.96-0.372l1.158-0.389l2.066-0.173l0.643-0.338     l0.921-0.272l0.821-0.189l0.476-0.239l-0.178-0.272l-0.702-0.392l-0.655-0.444l0.899,0.101l0.764,0.272l0.701,0.306l0.412,0.324l0.376,0.476l0.449,0.523l0.393,0.235l1.246,0.486l0.186,0.067l1.154,0.216l0.394-0.018l0.199-0.151l-0.511-0.639l0.07-0.27     l0.548-0.035l0.334-0.136l0.627-0.103l0.383,0.354l0.059,0.421l-0.205,0.287l0.833,0.133l0.938-0.069l1.136-0.457l0.536-0.49l0.479-0.069l1.131,0.015l1.536,0.267l1.745,0.435l1.396,0.334l2.095,0.349l1.024,0.216l0.619,0.066l1.572,0.282l1.121,0.065l1.144,0.148     l1.096,0.032l1.4-0.086l0.899,0.099l1.008,0.282l0.982,0.349l0.434,0.249l0.191,0.333l-0.524,0.134l-0.935-0.032l-0.566,0.051l-0.849,0.135l-0.354,0.714l3.323,0.358l1.726,0.079l1.749,0.014l0.868-0.068l0.738-0.051l0.94-0.167l0.895-0.118l0.938-0.101     l0.886,0.032l1.432,0.477l1.452,0.179l0.42,0.115l1.225,0.443l-0.013,0.312l-0.504,0.083l-0.35,0.247l0.305,0.147l1.823,0.979l-0.162-0.392l-0.024-0.312l0.456-0.05l0.617-0.132l-0.062-0.181l-0.972-0.656l-0.128-0.198l-0.145-0.445l0.121-0.745l0.35-0.034     l1.944-0.136l0.928-0.151l0.207-0.299l0.459-0.217l0.613-0.035l1.098,0.281l1.528,0.279l0.968,0.064l0.969-0.102l0.612,0.414l0.248,0.082l0.962,0.213l1.211,0.13l0.678,0.081l1.146-0.002l0.879-0.2l1.755-0.02l1.876,0.029l1.07-0.052l1.18-0.267l0.959,0.478     l0.95,0.296l0.522-0.018l0.243-0.314l-0.017-0.513l-0.666-0.231l-0.732-0.131l-1.377-0.064l0.089-0.449l1.193-0.085l0.575,0.065l0.804,0.214l0.871,0.198l0.858,0.048l0.498,0.198l0.088,0.183l-0.095,0.132l-0.287,0.86l0.179,0.51l0.304,0.164l0.177,0.065     l0.792,0.097l0.951,0.311l-0.071-0.559l-0.466-0.989l0.137-0.48l0.258-0.266l0.712,0.015l0.811-0.035l1.229-0.85l0.492-0.051l0.479-0.001l0.517-0.151l0.033-0.133l-0.15-0.367l-0.375-0.35l-0.307,0.001l-0.81,0.185l-0.988-0.082l0.535-0.52l0.806-0.069     l0.435-0.168l0.572-0.001l0.739,0.4l0.464,0.167l0.065-0.268l-0.081-0.956l-0.744,0.069l-0.897-0.032l-0.68-0.116l-0.859-0.318l-0.725,0.085l-1.245-0.183l-0.861-0.234l-0.956-0.218l-0.657-0.338l-0.092-0.136l-0.022-0.324l0.33-0.137l0.842-0.463l-0.486-0.221     l-1.188-0.375l0.09-0.207l0.58-0.604l0.593-0.294l0.387-0.035l1.032,0.257l0.139-0.035l0.173-0.346l-0.709-0.362l-0.201-0.277l0.23-0.035l0.551-0.331l0.367-0.035l1.841-0.021l0.559,0.086l0.728,0.189l1.26,0.449l0.432,0.328l0.195,0.38l-0.246,0.603l1.261,0.53     l0.809,0.495l1.134,0.493l-0.377,0.341l-0.985,0.036l-0.474,0.273l-0.416,0.557l0.471,0.067l1.071,0.233l0.805,0.049l0.387-0.136l0.597-0.001l1.477,0.351l-0.335,0.353l-0.563,0.219l0.092,0.151l0.796,0.467l0.358,0.601l0.025,0.833l0.303-0.063l0.021-0.004     l0.411-0.067l0.608-0.367l0.655-1.137l0.668-0.42l0.523,0.016l0.731,0.284l1.064,0.55l0.473,0.383l0.209,0.45l-0.159,0.433l-0.336,0.034l-0.796-0.098l-0.202,0.299l-0.043,0.415l0.35,0.396l1.146,0.659l0.61,0.493l0.463,0.279l0.595-0.166l0.896-0.167l0.369-0.132     l0.208-0.66l0.764-0.398l0.599-0.416l0.249-0.664l0.363-0.75l0.237-0.184l1.394,0.081l0.329-0.067l0.134-0.518l-0.985-0.333l-0.918-0.35l0.088-0.891l0.595-0.271l0.787,0.032l0.42-0.068l0.571,0.016l3.459,0.616l1.325,0.669l0.506-0.001l0.553-0.068l0.454,0.201     l0.244,1.036l-0.474,0.268l-0.431,0.101l-0.243-0.05l-0.718-0.532l-0.263,0l-0.799,0.269l0.123,0.316l0.309,0.515l0.699,0.729l0.855,0.528l1.108,0.576l0.024,0.313l-0.478,0.642l-0.439,0.181l-1.407,0.772l-0.674,0.083l-1.123,0.509l-0.763-0.276l-1.654-0.962     l-0.586-0.262l-0.497-0.048l-0.684,0.281l1.364,0.521l1.483,0.896l-0.708,0.067l-0.691-0.081l-1.288,0.084l-0.375-0.129l-0.596-0.62l-1.147-0.014l-1.857,0.118l-0.253,0.229l0.614,0.244l1.311,0.421l-0.159,0.195l-0.611,0.327l-2.045,1.106l-0.657,0.179     l-0.527,0.001l-0.859-0.241l-0.816-0.484l-0.225-0.081l-1.189-0.225l-0.736-0.259l-0.598-0.112l-0.947,0.014l-0.289,0.004l-1.214,0.174l1.503,0.278l1.136,0.21l1.751,0.774l1.629,0.433l1.233,0.126l1.02,0.031l-0.618,1.091l-1.237,0.705l-0.856,0.432l-0.728,0.161     l-0.829,0.049l-0.928-0.126l-1.062-0.38l-0.048,0.351l-0.025,0.287l0.321,0.572l-0.02,0.159l-0.741,0.031l-0.058,0.002l-1.365-0.108l-1.649-0.41l-0.884-0.078l-2.962-0.322l2.146,0.864l1.576,0.156l1.367,0.267l0.562,0.205l0.33,0.268l-0.011,0.19l-0.642,0.333     l-1.106,0.207l-1.429-0.076l-0.511-0.062l-0.367,0.269l1.254,0.423l-0.469,0.426l-1.06,0.316l-1.454,0.662l-0.421,0.252l0.218,0.704l-0.313,0.235l-0.909,0.205l-0.31,0.282l-0.529,0.64l-0.276,0.296l-0.241,0.669l-0.274,0.543l-0.323,0.666l0.056,0.416     l-0.161,0.554l0.123,0.875l0.136,0.536l0.598,0.366l0.25,0.015l0.257,0.091l0.664,0.014l1.164-0.094l0.276,0.045l0.367,0.29l0.413,0.763l0.813,1.157l0.22,0.668l-0.132,0.91l0.673,0.014l1.874-0.428l1.261-0.033l0.723,0.074l0.535,0.157l1.062,0.311l2.129,0.435     l1.896,0.903l0.993,0.933l3.5,0.67l0.644,0.225l0.982,0.403l0.986,0.253l0.553,0.104l0.702-0.091l0.453,0.044l0.828-0.077l1.245,0.163l1.407,0.207l0.401,0.194l-0.297,0.702l-0.142,0.85l0.154,0.283l0.307,0.342l0.07,0.416l-0.115,1.025l-0.309,0.593l0.022,0.208     l0.604,0.266l0.481,0.339l0.264,0.354l0.046,0.488l-0.076,0.354l0.97,0.116l0.963,0.47l0.676,0.588l0.392,0.588l0.078,0.162l0.64,0.014l0.726,0.41l0.907,0.601l-0.349-0.66l-0.22-0.279l0.134-0.338l0.573-0.414l0.365,0.176l0.381,0.456l0.262,0.353l0.165-0.354     l0.107-0.545l-0.215-0.456l0.541-0.532l0.139-0.546l-0.183-0.517l-0.337-0.458l-0.261-0.754l-0.004-0.548l-0.205-0.593l-0.218-0.43l0.615-0.016l-0.097-0.476l-0.296-0.252l-0.657-0.163l-0.375-0.282l-0.326-0.923l1.252-0.271l0.872-0.241l0.625-0.271l1.758-0.949     l0.629-0.302l1.043-0.935l0.434-0.544l0.237-0.665l0.054-0.529l-0.257-1.045l-0.246-0.531l-0.239-0.319l-0.938-0.729l-0.467-0.274l-1.105-0.532l-0.363-0.122l-0.453-0.274l-0.151-0.046l-0.293-0.351l0.08-0.107l0.868-0.522l0.553-0.875l0.293-0.416l0.25-0.092     l0.447-0.017l0.295-0.277l-0.106-0.523l-0.18-0.355l-0.316-0.402l-0.048-0.202l0.258-0.357l0.005-0.264l-1.751-0.105l1.084-0.92l0.503-0.704l0.007-0.125l-0.316-0.203l-0.609-0.265l-0.244-0.266l-0.043-0.533l0.305-0.425l0.554-0.315l0.57-0.19l0.827,0.062     l1.781,0.374l1.097,0.234l0.753,0.077l1.44,0.013l1.08-0.144l0.86-0.222l0.21-0.047l0.179-0.063l0.589,0.078l0.991,0.407l0.254,0.125l0.754,0.454l0.918,0.375l0.796,0.437l-0.294,0.391l0.406,0.233l1.698,0.496l1.958,0.354l0.725-0.033l0.368-0.203l0.339,0.295     l-0.013,0.404l-0.577,0.343l-0.123,0.45l0.438,1.327l0.136,0.722l0.23,0.414l-0.049,0.353l-0.248,0.169l-0.445-0.014l-0.347-0.015l-0.138,0.674l0.375,0.274l1.137-0.415l0.366-0.047l0.781-0.047l0.286,0.015l0.677,0.32l0.378,0.351l0.004,0.259l-0.081,0.123     l0.277,0.32l0.516-0.184l0.306-0.046l1.173-0.079l0.636-0.184l0.436-0.383l0.333-0.551l0.326,0.015l0.194,0.122l0.693,0.717l0.042-0.062l0.108-0.764l0.317-0.583l0.475-0.262l0.539-0.385l-0.651-0.505l0.008-0.308l0.272-0.139l0.98-0.094l0.193-0.139l0.512-0.665     l0.667,0.37l0.607,0.599l0.785,0.506l0.596,0.797l1.045,0.764l0.264,0.352l-0.344,0.291l0.095,0.335l0.573-0.031l0.365,0.777l0.182,0.183l0.324,0.121l0.743,0.136l0.281,0.258l0.133,0.38l-0.379,0.092l-0.416,0.168l0.411,0.318l0.397,0.227l0.77,0.196l0.279,0.227     l0.034,0.424l-0.056,0.076l-0.409,0.106l-0.676-0.029l-0.745-0.12l-0.316,0.061l0.091,0.166l0.273,0.181l0.189,0.241l0.333,0.513l0.411,0.226l0.634,0.029l0.462,0.18l0.838,0.496l0.899,0.435l0.246,0.33l-0.035,0.195l-0.447,0.781l0.508,0.059l0.663-0.166     l0.786-0.077l0.79,0.164l0.574,0.194l1.162,0.49l0.981,0.132l1.517,0.295l-0.184,0.253l-0.718,0.21l-0.736,0.21l-0.663,0.046l-0.834,0.24l-0.583,0.402l-0.65,0.225l-1.032,0.061l-0.286,0.075l-0.324,0.268l0.029,0.371l-0.271,0.535l1.175-0.343l0.542-0.09     l0.649-0.105l1.201-0.774l1.251-0.478l1.146-0.106l0.662,0.237l0.35,0.341l-0.398,0.446l0.036,0.119l0.307,0.296l0.616-0.224l0.455-0.164l0.655,0.192l1.051,0.487l0.226,0.251l0.022,0.178l-0.299,0.43l-0.05,0.355l-0.406,0.444l1.001,0.929l-0.365,0.37     l-0.795,0.282l-1.078,0.621l-0.662,0.281l-1.097,0.046l-0.823,0.119l-1.548,0.077l-0.433,0.413l-0.916,0.795l-0.686,0.427l-0.612,0.294l-0.938,0.222l-1.494,0.172l-1.845,0.127l-1.452-0.07l-2.031-0.084l-0.355,0.03l-1.073,0.075l-1.058-0.012l-1.873-0.099     l-0.917-0.027l-1.758,0.106l-0.547,0.206l-0.523,0.294l-0.537,0.585l-0.205,0.554l-0.287,0.335l-0.591,0.19l-1.07,0.104l-0.537,0.147l-1.098,0.555l-0.774,0.54l-0.794,0.612l-0.325,0.363l-0.33,0.233l-0.868,0.843l-0.485,0.566l-0.418,0.276l-0.46,0.58     l-0.518,0.968l0.749-0.737l0.375-0.131l0.688-0.479l1.059-0.944l1.097-0.785l2.028-0.948l1.245-0.395l1.797-0.512l1.065-0.235l1.03-0.235l1.473-0.148l0.922,0.056l0.895,0.289l0.509,0.29l0.136,0.189l0.144,0.464l-0.125,0.218l-0.326,0.219l-1.059,0.292     l-0.753,0.452l-0.581,0.044l-0.845-0.23l-0.726,0.045l-0.645,0.19l0.279,0.08l1.13,0.229l0.17,0.122l0.256,0.444l0.074,0.095l1.299-0.485l-0.028,0.216l0.479-0.148l0.372,0.162l-0.36,0.229l-0.231,0.256l0.112,0.27l-0.163,0.014l-0.074,0.229l-0.91,0.444     l1.216,0.013l0.077,0.188l-0.187,0.282l0.091,0.43l0.118-0.081l0.239,0.134l-0.063,0.134l0.048,0.202l0.351,0.457l0.009,0.147l0.824,0.054l0.154,0.094l0.04-0.067l0.727,0.147l-0.315,0.134l-0.373-0.013l-0.047,0.134l0.525,0.147l0.211,0.241l0.569-0.081     l0.135,0.134l0.212-0.014l0.134,0.174l0.418-0.04l-0.075-0.107l0.843,0.067l0.241,0.107l-0.207,0.201l0.242-0.107l0.26,0.027l0.245-0.013l0.696-0.362l0.303-0.081l0.104,0.362l0.377,0.161l0.538-0.121l0.488,0.416l-0.405,0.254l0.089,0.107l0.825,0.027     l0.164,0.174l-0.521,0.121l-0.161-0.121l-0.3,0.134l0.118,0.094h-0.515l-0.23-0.04l0.109,0.161l-0.45,0.04l0.056,0.107l-0.443,0.014l-0.128,0.147l-0.45,0.04l-0.368,0.253l-0.09-0.106l-0.706,0.28l-0.046,0.053l-0.529,0.133l-0.119-0.267l-0.274,0.106     l-0.163,0.267l-0.188-0.187l-0.068,0.253l-0.218,0.08l-0.094,0.187h-0.513l-0.081-0.08l-0.169-0.053l0.032-0.347l-0.242,0.36l-0.202,0.12l-0.131-0.253l-0.354,0.027l0.043,0.24l-0.233,0.04l0.312,0.08l0.033,0.213l-0.103,0.12l-0.174-0.067l-0.768,0.453     l0.127,0.16l-0.235,0.12l-0.194,0.053l0.015,0.213l-0.161-0.12l0.083,0.173l-0.217,0.08l-0.14-0.107l0.096,0.253l-0.222,0.066l-0.146-0.08h-0.148l-0.064,0.133l-0.156-0.106l-0.243,0.227l-0.086,0.292l-0.201-0.226l-0.344,0.133l-0.154-0.187l-0.349-0.479     l-0.138,0.24l-0.419-0.866l0.456-0.773l0.284-0.16l0.035-0.12l-0.35,0.12l-0.357,0.267l-0.076-0.106l0.924-0.507l0.125,0.146l0.195-0.093l-0.258-0.107l1.103-0.52l1.109-0.562l0.658-0.361l0.336,0.094l-0.067,0.428l0.179-0.054l0.258,0.281l-0.044-0.201     l-0.017-0.174l0.632-0.214l0.73-0.134l0.192,0.067l0.202-0.081l-0.152-0.094l-0.653-0.053l-0.595,0.053l-0.42-0.053l-0.804-0.014l-0.306,0.027l-0.251,0.081l-0.246,0.094l0.033-0.214l1.128-0.563l0.054-0.201l0.252-0.08l-0.052-0.174l-0.523,0.281l0.097-0.134     l-0.502-0.51l0.309,0.443l-0.36,0.482l-0.328,0.013l-1.974,0.817l-0.284,0.08l-0.362-0.201l-0.227-0.067l0.23,0.201l-0.788,0.401l-0.219-0.174l-1.019-0.054l-0.124,0.147l-0.38-0.241z M186.193,47.833l-0.713-0.032l-0.922-0.181l-0.882-0.065l-1.25-0.314     l-0.973-0.182l-0.604-0.049l-1.083-0.199l0.43-0.335l1.542-0.405l0.385-0.186l0.115-0.673l0.305-0.236l0.831-0.069l0.743,0.184l1.436,0.603l1.287,0.4l0.074,0.285l0.315,0.284l1.094,0.516l-0.288,0.117l-1.263,0.486l-0.578,0.051z M231.09,50.646l-1.319-0.03     l-0.449-0.147l-0.232-0.247l-0.173-0.478l0.3-0.43l0.708-0.664l0.662-0.267l1.359-0.168l0.911,0.197l0.79,0.314l-0.021,0.464l-0.039,0.727l-0.362,0.265l-1.025,0.348l-1.108,0.117z'},
	RU => {name => 'Russia',
		d => 'M444.972,79.145l0.47-0.218l0.307-0.093l-0.294-0.024l-0.419,0.061l-0.15-0.135l-0.125,0.184l-0.108-0.012l0.066-0.491l0.177-0.218l0.41,0.009l1.489,0.062l0.417,0.014l0.339-0.075l0.121-0.253l-0.175-0.288l0.246-0.05l-0.068-0.122     l-0.068-0.123l0.353-0.096l0.12-0.034l0.051,0.154l0.086,0.052h0.24l0.223,0.12l0.257,0.069l0.514,0.068l0.086,0.103l0.223-0.051h0.445h0.257l0.223-0.017l0.086,0.137l0.103,0.103l0.188,0.034l0.171,0.069l0.018,0.137l0.052,0.12l-0.224,0.12l-0.068,0.154     l-0.068,0.206l0.018,0.171l0.034,0.137l0.029,0.038l-2.96,0.101l-2.246-0.115l-0.842-0.006z M717.633,81.109l0.42,0.443l0.429,0.62l0.183,0.457l0.01,0.767l-0.244,0.442l-0.197,0.78l-0.002,0.764l0.29,0.777l0.592,0.849l0.65,1.446l0.899,1.614l1.115,1.679     l-1.26-0.677l-0.832-0.39l-0.99-0.056l-0.268,0.088l-0.396,0.204l-0.462,1.045l-0.266,1.101l-0.082,0.579l0.277,0.982l0.183,0.216l0.659,0.908l0.54,0.201l0.463,0.648l-0.314,1.246l-0.664-1.258l-0.866-0.301l-0.224,0.029l-0.415,0.303l-0.311,0.534l-0.643,0.907     l-0.422-0.5l-0.19-0.929l0.637-1.146l-0.395-0.884l0.175-0.454l0.502-0.63l-0.131-0.723l-0.196-0.376l-0.27-0.55l-0.062-0.235l0.403-0.302l0.284-0.915l0.075-0.784l0.005-1.326l0.15-1.302l-0.09-0.732l-0.213-0.469l-0.83-0.85l-0.1-0.897l0.114-0.192l0.359-0.722     l0.065-0.738l-0.336-0.457l0.172-0.237l0.374-0.03l0.62-0.031l1.023-0.534z M471.158,84.281l-0.002-0.142l-0.165-0.066l-0.082-0.115l-0.164-0.082l0.033-0.099l-0.033-0.23l-0.033-0.164l0.082-0.099l-0.147-0.131l-0.099-0.148l0.132-0.066v-0.165l-0.296-0.164     l-0.279-0.263l-0.017-0.164l0.099-0.131l0.131-0.165l0.362-0.017l0.328,0.049l0.197,0.132l0.51,0.016l0.525-0.099l0.444-0.247l0.049-0.065l0.148-0.083h0.296l0.065-0.164l-0.033-0.131l-0.279-0.066l-0.296-0.148l-0.099-0.181l0.082-0.017l0.066-0.049l0.032-0.065     l-0.263-0.066l-0.361-0.099l-0.378-0.066l-0.361,0.066l-0.182-0.066l0.066-0.181l0.099-0.197l-0.066-0.148l-0.164-0.099l-0.279-0.082l-0.23-0.066l-0.443-0.213l-0.115-0.23l-0.164-0.263l-0.214-0.017l-0.017-0.099l0.066-0.131l0.099-0.115l-0.132-0.033     l-0.181,0.049l-0.082-0.115l-0.132-0.181l-0.345-0.049l0.049-0.147l0.033-0.165l0.099-0.049l0.115-0.082v-0.083h0.114l0.066-0.131l-0.05-0.164l-0.147-0.099l-0.197-0.247l0.131-0.165l0.033-0.164v-0.083l0.065-0.115l-0.049-0.115l-0.147,0.033l-0.165-0.033     l-0.147-0.099l-0.099-0.099l-0.279-0.099l-0.132-0.131l-0.542-0.115l-0.247,0.049l-0.099-0.049l-0.131-0.049l-0.23,0.083l-0.147,0.099h-0.165l-0.279,0.016l-0.214,0.197h-0.197l-0.164-0.148l-0.065-0.148l0.017-0.099l0.164-0.099v-0.115l-0.147-0.017l-0.296-0.065     l-0.312-0.049l-0.361,0.049l-0.214,0.065l-0.197,0.033l-0.082-0.148l-0.132-0.148l-0.312-0.033l-0.181-0.016l-0.197,0.131l-0.229-0.066l-0.165-0.147l0.061-0.042l0.015-0.117l0.044-0.087l-0.088-0.233l0.015-0.189l-0.131-0.117l0.059-0.087l-0.16-0.043     l-0.146-0.102l-0.029-0.16l-0.131-0.058l-0.116-0.102l0.043-0.073l0.059-0.087l-0.073-0.044l-0.087-0.014l-0.131-0.073l-0.146,0.015l-0.204,0.059l0.044-0.102l0.102-0.073l0.073-0.087l-0.029-0.117l0.072-0.131l-0.131-0.087l0.103-0.029l0.087-0.015l0.102-0.073     l0.015-0.087l0.029-0.116l0.015-0.087l-0.204-0.058l-0.087-0.073l-0.204-0.087l-0.232-0.073v-0.117l0.015-0.116l-0.37,0.004l-0.081-0.106l0.116-0.058L461.402,72l0.029-0.117h0.131l0.087-0.116l0.059-0.102l0.16-0.058l0.262-0.043l0.175-0.073l-0.059-0.059     l-0.175-0.043l-0.043-0.146l-0.015-0.087v-0.073l-0.088-0.073l-0.203-0.087l-0.175-0.233v-0.175l0.175-0.131l-0.029-0.16l-0.073-0.189l-0.131-0.437l-0.029-0.16l0.088-0.16l0.204-0.131l0.319-0.131l0.219-0.204l0.175-0.277l0.058-0.131l0.088-0.043h0.116h0.189     l0.175-0.044l0.043-0.174l-0.16-0.131l-0.145-0.053l-0.089-0.13l-0.17-0.038l0.1-0.253l0.339-0.038l0.153,0.165l0.229,0.063l0.188-0.088l-0.094-0.139l0.301-0.154l0.485,0.199l0.296-0.062l0.312-0.338l0.311-0.185l0.75,0.106l0.781,0.275l0.439,0l0.363-0.154     l-0.386-0.399l-0.59-0.323l-0.393-0.03l-1.204,0.08l-0.616-0.091l-0.271-0.108l-0.299-0.309l0.258-0.434l-0.065-0.201l-0.199,0.044l0.174-0.285l1.946-1.145l1.983-1.195l1.385-0.758l0.591-0.536l0.43-0.536l0.105-0.409l-0.161-0.346l-0.436-0.392l-0.703-0.265     l-1.357-0.499l-0.439-0.33l0.327-0.191l0.542-0.415l0.057-0.254l-0.151-0.253l-1.286-1.395l-0.37-0.509l0.029-0.37l0.187-0.403l0.44-0.535l0.196-0.356l-0.772-1.195l-1.402-1.394l0.328-0.296l1.303-0.777l0.421-0.364l-0.543-0.392l-0.964-0.506l-0.872-0.194     l-0.563-0.212l-0.116-0.529l0.258-0.465l0.024-0.283l0.689-0.303l1.013-0.672l1.023-0.49l0.77-0.121l0.824-0.021l0.514-0.204l0.404-0.288l0.617-0.051l1.002-0.254l0.643-0.237l0.01,0.151l0.255,0.386l0.358,0.284l0.543,0.2l0.919,0.082l0.602,0.1l0.078,0.602     l0.695-0.319l0.421,0.049l1.083,0.048l0.875,0.015l0.522,0.032l1.116-0.002l1.293,0.281l2.728,0.512l0.984,0.364l1.595,0.86l0.583,0.214l1.48,0.246l1.296,0.212l2.018,0.623l0.328,0.279l-0.051,0.444l0.147,0.295l0.426,0.294l0.104,0.294l-0.24,0.344l-0.69,0.491     l-1.092,0.54l-0.816,0.262l-1.75,0.36l-0.907,0.083l-1.631-0.013l-1.391-0.192l-2.038-0.175l-1.63-0.192l-1.342-0.339l-2.256-0.485l-1.114-0.112l-0.476-0.048l-0.621-0.473l-0.371-0.163l-0.771-0.13l-0.943,0.117l0.307,0.163l0.149,0.065l0.73,0.538l0.482,0.146     l1.109,0.601l0.832,0.291l0.921,0.161l0.634,0.242l0.405,0.453l-0.002,0.405l-0.276,0.291l-0.684,0.195l0.086,0.113l0.208,0.531l0.771,0.943l0.093,0.494l0.155,0.207l0.438,0.174l1.203,0.078l0.872,0.125l0.499,0.619l0.401,0.095l1.26,0.077l0.575,0.126     l0.364,0.079l0.402-0.128l0.785-0.097l0.243-0.302l-0.001-0.318l-0.387-0.397l-0.471-0.079l-0.455,0.096l-0.447-0.031l-0.589-0.206l-0.952-0.795l0.701-0.674l0.484-0.001l1.116,0.479l1.441,0.333l2.09,0.427l0.952,0.078l0.834-0.146l0.723,0.174l0.261-0.224     l0.05-0.415l-0.214-0.239l-0.858-0.656l-0.348-0.628l0.285-0.323l0.19-0.049l1.432-0.423l1.495-0.359l0.599-0.244l1.133-0.717l0.172-0.049l0.462,0.064l1.829,0.29l1.41,0.533l0.341-0.001l0.052-0.065l0.154-0.503l0.581-0.767l-0.048-0.653l-0.317-0.408     l-0.847-0.163l-0.3-0.229l1.139-1.005l0.101-0.247l-0.205-0.594l-0.771-0.512l0.069-0.315l0.353-0.051l1.458,0.23l2.025-0.12l0.631,0.132l0.664,0.611l0.616,0.445l0.433,0.461l-1.045,0.051l-1.559,0.085l-0.822,0.215l-0.492,0.51l0.191,0.18l0.952,0.293     l0.732,0.555l0.804,0.194l0.723,0.097l1.268-0.133l1.33-0.084l0.301-0.164l0.257-0.491l0.291-0.591l0.284-0.412l1.232-0.2l1.223-0.414l0.988-0.216l1.924-0.483l1.429-0.251l1.537-0.318l0.921-0.3l0.205,0.464l0.278,0.083l0.571-0.117l0.487-0.266l0.148-0.465     l0.386-0.167l0.718-0.135l0.859,0.065l-0.18,0.399l-0.058,0.597l-0.858,0.084l-0.178,0.149l0.002,0.215l0.687,0.197l0.507-0.083l1.169-0.167l0.436-0.001l0.161,0.198l0.23,0.049l0.278-0.133l0.264-0.216l0.29-0.431l0.464-0.183l0.861-0.118l1.049-0.068     l0.768,0.032l1.075,0.23l0.755-0.018l0.36-0.083l0.963-0.467l1-0.285l0.803-0.052l0.952,0.182l0.326,0.166l-0.631,0.45l0.129,0.232l0.217,0.099l0.632,0.131l0.579-0.018l0.288-0.232l0.074-0.398l0.342-0.084l0.962,0.065l0.543-0.184l0.395-0.316l0.115-0.417     l-1.37-1.033l0.405-0.168l0.66-0.37l0.403-0.068l0.609,0.016l2.171,0.063l1.272,0.199l1.241,0.149l1.135,0.199l2.111,0.515l1.071,0.098l1.712,0.414l1.02,0.248l1.305,0.53l1.455,0.611l0.864,0.379l0.376,0.049l0.229-0.1l1.145-1.047l0.236-0.3l-0.927,0.035     l-0.4-0.049l-0.564-0.232l-0.365-0.433l0.027-0.652l-0.727-0.283l-1.987-0.147l-0.19-0.268l0.064-0.168l0.305-0.303l0.693-0.255l0.236-0.153l0.085-0.187l-0.052-0.833l-0.251-0.238l-1.135-0.066l-0.232-0.29l0.328-0.532l0.359-0.241l0.391-0.035l1.482-0.416     l1.098-0.485l0.521-0.416l0.581-0.608l0.544-1.22l0.637-0.421l0.374,0.069l1.562,0.155l1.613-0.125l1.605-0.091l0.695,0.069l1.066-0.055l0.574,0.122l0.309,0.279l-0.018,0.332l-0.423,0.836l-0.348,0.348l-1.334,0.833l-0.223,0.345l0.752,0.342l0.931,0.667     l0.277,0.342l0.21,0.818l-0.174,0.222l-0.575,0.375l0.254,1.179l-0.058,1.305l0.263,0.583l0.45,0.381l1.027,0.264l0.19,0.166l-0.001,0.133l-0.485,0.481l-0.417,0.826l-0.333,0.33l-0.784,0.462l-1.232,0.625l-0.63,0.198l-0.55,0.263l0.321,0.522l-0.433,0.115     L558,52.195l-1.599-0.372l-0.731-0.08l-0.97,0.034l-0.601,0.115l0.195,0.31l0.583,0.276l0.738,0.21l1.569,0.208l1.133,0.079l0.613-0.05l1.188,0.144l0.922-0.034l0.472-0.358l0.303-0.358l1.352-0.328l1.166-0.492l0.268-0.278l0.386-0.606l0.818-0.313l0.864-0.626     l0.064-0.362l-0.225-0.561l-0.609-0.545l0.244-0.548l0.237-0.1l0.677-0.151l1.38-0.152l1.757-0.003l0.74,0.231l0.842,0.463l0.151,0.778l-0.34,1.023l0.302,0.279l0.92,0.212l1.298,0.047l0.864-0.149l0.129-0.296l-0.514-0.18l-0.797-0.18l-0.571,0.034l-0.457-0.098     l0.068-0.379l1.03-0.382l0.065-0.249l-0.218-0.148l-0.166-0.331l-0.441-0.763l-0.511-0.266l-0.836-0.098l-1.093-0.231l-0.801-0.116l-1.288-0.165l-0.91,0.186l-0.638,0.101l-1.297-0.181l-0.896,0.019l-0.015-0.267l-0.564-1.071l0.305-0.657l0.736-0.697l0.282-0.46     l-0.134-0.221l-1.092-1.042l-0.949-0.514l-0.12-0.189l0.833-0.554l1.213-0.106l0.998-0.262l0.744-0.348l0.172-0.226l0.169-0.644l-0.13-0.663l0.23,0.069l0.64,0.051l0.466,0.086l0.108,0.471l-0.186,0.54l-0.636,0.608l-0.167,0.554l0.14,0.448l0.373,0.274     l0.485,0.274l1.384,0.134l1.574,0.169l1.632,0.083l0.819,0.409l0.321,0.017l0.799-0.036l-0.527-0.89l-0.521-0.274l-1.893-0.1l-0.931-0.067l-0.576-0.154l-0.609-0.448l0.275-0.329l1.374-0.054l0.444,0.172l1.145,0.084l0.747-0.157l-0.09-0.728l0.408-0.088     l0.84-0.105l1.278-0.02l1.067,0.207l1.413,0.379l1.088,0.535l1.326,0.343l0.547,0.085l1.822,0.014l0.727-0.174l0.138,0.345l-0.781,0.38l-0.696,0.259l-0.248,0.771l-0.129,0.972l0.333,0.136l0.68-0.785l0.387-0.292l0.285,0.051l0.604,0.528l-0.088,0.749     l0.743-0.205l0.681-0.273l-0.044-0.306l-0.191-0.119l-0.147-0.358l-0.748-0.821l0.188-0.223l0.686-0.759l-0.797-0.448l-0.772-0.258l-0.93-0.241l-0.257-0.382l-0.655-0.051l-0.979-0.242l-1.34-0.207l-0.307-0.296l0.062-0.577l-0.096-0.386l-0.811-0.667l0.081-0.247     l0.266-0.16l0.484-0.125l2.31-0.11l2.54-0.022l2.125-0.128l1.421-0.162l0.475,0.317l0.382,0.052l0.844-0.267l1.056-0.286l1.413-0.109l0.589,0.194l-0.957,0.338l-0.451,0.407l1.737-0.233l0.521-0.107l0.955-0.374l0.27-0.284l-0.334-0.444l-0.326-0.177l-0.925-0.266     l-0.365-0.303l-0.002-0.232l0.324-0.539l1.176-0.397l0.966-0.22l3.028-0.903l0.889-0.094l0.248-0.036l0.522-0.076l1.899-0.096l1.663-0.114l2.302-0.244l2.048-0.263l1.595-0.43l0.855-0.243l1.763,0.034l1.065-0.002l0.383,0.185l-0.351,0.409l1.504,0.108     l1.018-0.039l1.261-0.188l1.345-0.225l0.95-0.039l0.982,0.166l0.687,0.073l0.693-0.206l0.12-0.335l-0.133-0.167l0.466-0.337l0.942-0.077l0.939,0.036l1.243-0.377l-0.618-0.506l0.122-0.34l1.165-0.438l1.554-0.383l2.23-0.406l1.229-0.077l0.993,0.056l1.486-0.003     l0.86,0.265l0.045,0.266l-1.528,0.401l-0.66,0.342l0.488,0.15l1.83-0.117l1.588,0.148l2.039-0.079l0.177,0.113l-0.375,0.283l-1.187,0.453l-0.296,0.3l1.971-0.004l0.833-0.02l0.234,0.093l1.052-0.545l1.366-0.002l1.771-0.097l0.631,0.13l1.35-0.021l1.954,0.165     l1.4,0.259l1.181,0.427l0.52,0.445l0.726-0.001l0.854-0.076l0.422,0.5l-1.354,0.832l0.241,0.128l0.896,0.365l-2.329,0.859l-1.035,0.235l-1.166,0.11l-3.404,1.061l-3.018,0.965l-0.793,0.285l-2.388,0.375l-2.35,0.586l-2.065,1.126l0.715,0.017l1.081-0.247     l0.922-0.458l1.663-0.161l1.231-0.02l2.101-0.268l1.879-0.286l0.879-0.107l1.004-0.284l-0.094-0.389l-0.492-0.123l-0.034-0.071l0.281-0.249l0.581-0.214l0.873,0.211l0.603,0.389l0.621,0.052l0.593,0.193l0.737,0.052l0.853-0.055l1.155-0.268l0.499,0.07l0.192,0.3     l0.009,0.512l0.522,0.404l1.422-0.778l1.66-0.021l1.506-0.145l2.354,0.014l1.919,0.155l0.854,0.034l1.204,0.033l-0.271,0.74l0.354,0.333l2.043,0.154l0.848,0.121l0.698,0.069l1.035,0.103l2.49-0.145l1.209-0.02l1.42,0.348l1.405-0.932l-0.161-0.352l-0.038-0.229     l-0.034-0.105l1.806-0.48l0.521-0.019l0.802,0.104l1.148,0.298l0.851,0.281l1.711,0.032l1.354-0.073l1.384,0.033l1.323,0.431l0.409,0.181l0.058,0.386l-0.52,0.088l-0.268,0.036l-1.905,0.406l-2.438,0.737l-0.233,0.227l0.253,0.069l1.033,0.067l0.957,0.016     l0.659,0.155l0.659,0.293l1.014,0.396l0.583,0.172l0.78,0.481l1.27,0.805l1.814,0.801l1.351,0.305l0.612-0.018l0.795-0.394l0.843-0.72l1.093-1.051l0.601-0.329l0.29,0.017l0.236,0.465l0.772,0.308l1.346,0.29l1.105,0.135l0.848-0.087l1.973-0.468l0.778-0.07     l0.813,0.067l1.196,0.239l1.921,0.734l0.315-0.052l0.186-0.069l0.491-0.258l0.221-0.258l-0.137-0.051l0.013-0.189l0.726-0.312l0.509-0.018l0.5,0.257l0.575,0.188l1.302,0.032l0.181-0.5l-0.194-0.466l0.15-0.363l0.093-0.521l-1.131,0.159l-0.643,0.001l-0.179-0.104     l0.442-0.296l0.318-0.087l0.986-0.089l1.021-0.02l0.832-0.141l1.566-0.648l0.254,0l1.76,0.241l1.561,0.137l2.036,0.188l0.997,0.068l0.654,0.103l2.307,0.065l-1.732,0.628l0.865,0.051l1.011-0.089l0.335,0.138l-0.305,0.381l-0.926,0.192l-0.846,0.261l-0.177,0.293     l0.664,0.033l0.52-0.122l0.916-0.14l0.978-0.33l1.62-0.799l2.766,0.012l1.196,0.067l0.903,0.172l0.946,0.137l0.205,0.19l0.221,0.104l-2.247,0.59l0.559,0.137l1.674,0.289l2.174,0.202l0.946,0.204l0.801,0.375l0.367,0.427l0.564,0.357l0.522,0.152l1.459-0.037     l1.364-0.105l1.138-0.139l2.518-0.329l2.208-0.107l3.008,0.131l1.515,0.134l0.734,0.118l1.168,0.424l0.655,0.169l0.525,0.338l0.361,0.39l-0.123,0.491l-0.286,0.521l0.509,0.25l0.764,0.065l0.835,0.015l0.643,0.083l-0.017,0.685l0.419,0.416l0.686-0.168     l0.545-0.435l1.211-0.387l0.348-0.067l0.35,0.049l1.696-0.02l1.521-0.288l0.736,0.032l0.588,0.434l0.707,0.116l1.541,0.014l2.176,0.062l0.869-0.118l1.378-0.504l0.406,0.2l0.93,0.533l0.396,0.216l1.095,0.265l0.875,0.332l0.282,0.398l0.612,0.148l1.556-0.136     l1.653-0.319l0.16-0.25l-0.248-0.333l-0.805-0.833l-0.833-0.115l0.4-0.336l0.479-0.571l1.89,0.098l1.214,0.082l1.135,0.065l1.221,0.166l0.222,0.318l1.396-0.153l2.084-0.054l2.304,0.013l1.292,0.148l0.786,0.199l1.185,0.199l1.391,0.098l0.751,0.182l1.302,0.332     l0.747,0.065l0.703,0.182l1.145,0.505v2.126v2.222v2.222v1.292v0.157v0.576v0.219l-1.083,0.371l-0.651,0.03l-0.645,0.37l-0.56,0.065l-1.044,0.065l-0.355-0.079l-0.928-0.052l-0.118-0.343l-0.271-0.211l-0.501,0.027l0.241-0.185l-0.938,0.324l-0.846,0.02     l-0.337-0.211l-0.478-0.079l0.424,0.501l-0.569,0.29l0.32,0.103l0.942,0.205l0.634-0.36l0.395,0.041l0.335,0.079v0.477l0.248,0.206l0.76,0.269l1.059-0.228l-0.439,0.322l0.741-0.243l0.065,0.336l0.247,0.206l0.187,0.363l0.068,0.189l-0.722,0.522l0.593-0.064     l0.349,0.172l0.473,0.503l0.501,0.157l0.145,0.251l-0.162,0.456l0.792-0.111l-0.125,0.393l0.023,0.25l-0.43,0.299l-0.691,0.205l-0.635-0.046l-0.448-0.14l-1.243-0.154l-0.889-0.077l-0.347-0.14l0.123-0.267l-0.493-0.046l-0.304,0.032l-0.559,0.55l-0.069,0.11     l-3.06,0.913l-1.155,0.174l-0.245,0l-0.43,0.203l-0.219,0.188l-0.719,0.22l-0.991,0.033l-0.308,0.11l-0.48,0.405l-0.462,0.203l-0.946,0.033l-0.854,0.622l-0.24,0.279l-1.67,0.452l-0.392,0.449l-1.229,0.25l-0.406,0.14l-0.151,0.293l0.01,0.292l-0.473,0.292     l-0.406,0.016l-0.586-0.306l-0.183-0.262l-0.169-0.37l-0.67-0.308l-1.074-0.044l-1.021,0.048l-1.159,0.172l-1.301,0.188l-0.523,0.217l-1.333,0.756l-0.536,0.277l-0.184-0.138l0.575-1.293l-0.55,0.094l-0.392-0.097l-0.811,0.531l-0.67,0.186l-0.401,0.155     l-0.114,0.506l-0.66,0.154l-0.317-0.168l-0.253-0.49l-0.483-0.261l-1.024,0.636l0.261-0.204l-0.557,0.062l-0.283,0.092l-0.628,0.522l-0.141,0.261l0.126,0.229l0.344,0.152l-0.932,0.521l-0.182,0.199l0.342,0.167l-0.647,0.352l-0.88,0.55l-0.626,0.503l-0.298,0.35     l-0.01,0.531l0.421,0.317l0.477,0.09l1.382-0.048l0.562,0.166l0.11,0.167l-0.436,0.394l-0.752,0.455l-0.181,0.302l0.224,0.512l0.292,0.452l0.786,0.089l0.165,0.391l-0.014,0.616l-0.349,0.361l-0.528,0.061l-0.481-0.209l-0.017-0.21l0.388-0.527l-0.444-0.014     l-0.454,0.242l-1.014,0.843l-0.56,0.675l-0.237,0.599l0.321,0.672l0.647,0.311l0.154,0.237l-0.294,0.387l-0.688,0.313l-0.956,0.031l-0.664-0.088l-0.344,0.001l-0.619,0.179l-0.837,0.476l-0.214,0.149l-0.525,0.504l-0.137,0.341l0.111,0.281l0.492,0.398     l0.038,0.221l-0.056,0.133l-0.679,0.238l-0.604,0.016L753.44,82.4l-0.727,0.296l-0.065,0.251l0.067,0.28l-0.161,0.854l-0.293,0.412l-0.8,0.78l-1.53,0.971l-0.854,0.5l-0.285,0.103l-0.295-0.614l-0.198-0.821l-0.25-0.69l-0.064-0.794l-0.351-0.75l-0.305-0.383     l-0.214-0.915l-0.514-1.36l-0.008-0.578l-0.154-0.563l-0.017-0.327l-0.105-0.193l-0.262-0.817l-0.026-0.792l0.116-0.808l0.271-1.396l0.167-0.226l1.185-0.86l0.716-0.424l0.57-0.695l0.14-0.227l-0.085-0.318l-0.139-0.166l1.632-0.367l1.001-0.305l0.811-0.32     l1.729-0.884l0.641-0.412l0.431-0.428l0.14-0.335l1.784-0.889l0.872-0.445l1.535-0.861l0.368-0.293l0.26-0.433l1.252-0.435l2.106-0.514l0.257-0.434l0.773-0.528l0.086-0.233l-0.568-0.216l0.814-0.904l-0.036-0.483l0.183-0.391l0.598-0.204l1.729-0.082l0.513-0.063     l-0.485-0.328l-2.065-0.215l-0.71,0.095l-1.062,0.174l-0.777,0.189l0.042,0.328l-0.664,0.923l0.125,0.202l-0.04,0.14l-0.662,0.11l-0.479,0.11l-1.555,0.718l-1.979,1.042l-1.169,0.342l-0.249-0.062l0.156-0.325l0.352-0.465l-0.933-0.076l-0.16-0.263l0.252-0.451     l0.442-0.467l0.207-0.328l-0.069-0.202l-0.339-0.031l-1.136,0.454l-0.496,0.032l-0.277-0.358l-0.589-0.17l-1.606,0.144l-1.312,0.111l-0.956,0.08l-0.606,0.157l-0.894,0.359l-0.093,0.436l0.082,0.186l-1.262,0.53l-0.408,0.233l0.149,0.495l-1.294,0.357     l-1.019,0.434l-0.84,0.479l-0.496,0.461l-0.332,0.46l0.004,0.383l0.527,0.213l1.269,0.043l0.278,0.275l0.062,0.122l-1.152,0.139l-1.028,0.262l-1.045-0.059l-0.698-0.136l-0.382,0.031l-0.311,0.107l-0.721,0.398l-0.695-0.35l-1.112,0.383l-0.747,0.139l-0.487-0.09     l-0.284-0.137l0.108-0.29l0.748-0.124l0.868-0.124l0.164-0.046l-0.741-0.64L736.444,68l-1.06,0.017l-0.854,0.155l-0.353-0.061l-0.868-0.458l-0.775-0.029l-0.745,0.047l-0.704,0.246l0.042,0.398l-0.26,0.229l-0.477,0.215l-0.695-0.243l-0.408-0.122l-1.26,0.063     l-0.784,0.093l-0.651-0.075l-0.887-0.136l-0.563,0.078l-0.067,0.122l-0.147,0.474l-0.677,0.017l-0.311-0.137l-0.038-0.382l-0.203-0.259l-1.241,0.094l-1.014-0.059l-1.257,0.033l-1.158,0.063l-0.836-0.029l-0.18,0.016l-1.085,0.292l-0.964,0.444l-0.74,0.474     l-0.536,0.504l-0.789,0.245l-0.904,0.336l-0.194,0.152l-1.047,1.17l-1.634,0.684l-0.949,0.471l-1.157,0.711l-1.653,1.253l-0.828,0.572l-1.573,0.873l-0.893,0.376l-1.889,0.871l-0.632,0.388l-0.203,0.298l0.018,0.357l0.428,0.281l0.485,0.043l0.918,0.013     l1.046-0.15l0.656,0.043l-0.329,1.261l0.016,0.415l0.303,0.103l0.63-0.09l0.601-0.371l0.761,0.117l-0.127,0.148L705.293,81l-0.112,0.222l0.373,0.073l1.645-0.018l0.566-0.238l0.39-0.519l0.017-0.638l0.763,0.014l0.647-0.001l0.726,0.014l0.951,0.265l0.658,0.354     l0.486,0.591l0.847,0.575l0.426,0.176l0.506,0.324l-0.07,0.148l-0.581,0.355l0.453,0.221l0.13,0.309l-0.336,0.723l0.491,0.117l0.215,0.235l-0.291,0.515l-0.348,0.397l-0.532,0.559l-0.724,1.364l-0.181,0.688l0.057,0.219l0.24,0.701l-0.188,0.917l-0.098,0.741     l-0.403,1.408l-0.146,0.493l-1.928,1.538l-0.371,0.435l-0.217,0.65l-0.587,0.42l-0.741,0.579l-0.241,0.361l-0.574,0.981l-0.587,0.606l-0.941,0.778l-1.784,1.512l-0.464,0.474l-0.235,0.458l-0.323,0.33l-0.758,0.388l-0.618,0.416l-0.574,0.702l-0.431,0.458     l-0.875,0.673l-0.955,0.487l-1.838,0.475l-0.798,0.244l-0.278-0.427l-0.519-0.085l-0.243,0.043l-0.337-0.185l-0.337-0.513l-0.663,0.272l-0.464,0.101l0.424-0.586l-0.624,0.173l-0.506,0.486l-0.649,0.543l-1.326,1.001l-0.072,0.049l-0.167-0.393l-0.298-0.439     l0.111-0.058l1.252-0.462l0.511-0.43l0.156-0.329l-0.112-0.299l0.097-0.128l0.025-0.385l0.006-0.613l-0.062-0.656l-0.332-0.897l0.048-0.557l1.664-0.982l0.396,0.041l0.685,0.24l0.679,0.225l0.547,0.098l0.47-0.347l0.551-0.69l0.329-0.432l0.627-1.08l0.538-1.066     l0.278-0.893l0.291-0.707l0.66-0.393l0.566-0.407l-0.017-0.504l-0.116-0.389l-0.064-0.259l-0.246-0.114l-0.902,0.034l-1.181,0.208l-1.357,0.31l-0.953,0.308l-0.604,0.22l-1.657,0.052l-0.649,0.018l-0.68,0.033l-0.261-0.446l-0.44-1.283l-0.297-0.866l-0.205-0.144     l-2.659-0.839l-1.523-0.253l-1.247-0.341l-0.507-0.2l-0.436-0.389l-0.927-1.903l-0.94-1.588l-1.087-2.384l-0.742-0.952l-0.763-0.467l-0.539-0.026l-1.386,0.125l-0.683-0.188l-1.037-0.481l-1.148-0.215l-0.917,0.049l-1.203,0.109l-0.836,0.123l-1.854,0.143     l-0.602,0.136l-0.478,0.165l-1.193,0.787l-0.375,0.282l-0.119,0.25l0.822-0.078l0.558,0.026l0.465,0.306l0.107,0.249l-0.167,0.794l-1.371,0.608l-0.599,0.545l-0.667,0.779l-0.416,0.543l-0.422,0.426l-0.103,0.249l0.062,0.146l0.35,0.348l0.056,0.306l-0.123,0.233     l-0.779,0.339l-2.44,0.752l-0.438,0.089l-0.343,0.016l-1.126-0.574l-0.452-0.172l-0.046-0.018l-0.431-0.168l-0.622,0.018l-1.228,0.297l-0.86-0.169l-0.34-0.129l-0.751-0.506l-0.74-0.156l-0.609,0.047l-0.333,0.002l-1.165,0.487l-0.755,0.498l-0.447,0.394     l-0.604,0.264l-0.526,0.163l-1.147,0.136l-0.867,0.106l-0.532,0.075l-1.018,0.063l-1.602,0.11l-0.739-0.039l-0.984-0.082l-0.905-0.241l-1.318-0.254l-0.812-0.373l-1.132-0.313l-0.623-0.331l-1.333-0.75l-0.769-0.229l-1.423-0.022l-1.172-0.037l-0.796,0.077     l-2.48,0.538l-0.673-0.113l-1.643-0.531l-0.421-0.333l-0.408-0.451l-0.182-0.481l-0.004-0.541l-0.145-0.204l-0.767-0.143l-0.989-0.317l-0.702-0.231l-1.748-0.328l-1.036-0.185l-1.028-0.098l-0.84-0.201l-1.269,0.96l-0.905,0.839l-0.098,0.293l0.409,0.86     l0.396,0.304l0.116,0.204l-0.163,0.526l-0.744,0.572l-0.31,0.162l-0.755,0.28l-0.562,0.018l-0.576-0.186l-0.312-0.114l-0.875-0.068l-0.85,0.004l-0.719-0.083l-1.458,0.008l-0.699-0.113l-0.393-0.406l-0.694-0.755l-0.831-0.083l-1.842-0.122l-0.932-0.156     l-0.953-0.097l-0.84,0.18l-1.512,0.476l-1.143,0.341l-0.787,0.398l-0.971,0.692l-0.017,0.012l-0.727,0.381l-0.603,0.148l-1.387,0.08l-0.599,0.207l-0.799,0.425l-0.154,0.044l-0.244,0.074l-0.569,0.003l-0.228,0.014l-0.064-0.145h-0.589l-0.294-0.478l-0.441-0.331     l0.073-0.331l-0.625,0.184l-0.478,0.368l-0.993-0.074l-0.882-0.073l-0.662-0.699l-0.588-0.552l-0.956-0.147l-0.331-0.625l-0.772-0.588l-0.698-0.441l-0.993,0.037l-0.771,0.221l-0.993,0.221h-0.992h-0.589l-0.184-0.184l-0.258-0.257h-0.478v-0.368l-0.367-0.331     h-0.92l-0.367,0.515l-0.331,0.257l-0.515,0.257l-1.104-1.434l-0.846-0.882l-1.69-2.133l-1.066-1.029l-1.287-0.772l-0.809-0.294l-1.104-0.588l0.11-0.368l0.515-0.11v-0.441l-0.809,0.074l-0.515,0.22l-0.772,0.221l-0.956,0.515l-1.103,0.257l-0.772,0.441     l-0.294,0.294l-0.552-0.184l-0.441-0.037l-0.771,0.073l-0.441,0.11l-0.331-0.184l0.331-0.441l0.441-0.184l0.146-0.294h-0.367l-0.441,0.221l-0.478-0.11l-0.405-0.294l-0.478-0.037l-0.184,0.147l-0.147,0.147l-0.367-0.221l-0.295-0.368l-0.294-0.11l-0.331,0.221     l-0.367-0.074l-0.368,0.147l-0.44-0.11l-0.295,0.147l-0.478-0.074l-0.184-0.257l0.33-0.037l-0.073-0.331l0.147-0.257l0.11-0.331l-0.515-0.22l-0.147-0.221l0.037-0.331l-0.368-0.404l-0.882,0.037l-0.625,0.11l-0.772-0.257l-0.515-0.11l-0.919-0.147l-0.735,0.037     l-0.11,0.221l-0.589,0.184l-0.515,0.037v0.294l-0.367,0.368l-0.625,0.074l-1.876,0.073l-2.021,0.405l-1.177,0.037l-0.625,0.331l-0.221,0.331l-0.331-0.073l-0.588,0.073l-1.545,0.11l-0.735,0.11l-1.029,0.037l-1.396,0.405l-0.368,0.184h-0.772h-0.515L537.304,80     l-0.33,0.074l-0.185,0.515l0.074,0.441l0.294,0.221l-0.294,0.074v0.331l1.065,0.11l0.956,0.294l-0.11,0.257l-0.515,0.073l-1.103-0.147l-0.698,0.184l-0.662,0.515l0.146,0.257l0.441,0.478l-0.331,0.294l-0.588,0.147l-0.735,0.368l-0.467,0.067l0.164,0.274h0.239     l0.377,0.137l-0.068,0.171l0.377,0.137l0.651,0.069l0.274,0.308l1.165,0.171l0.24,0.24l-0.138,0.686l-0.137,0.309l-1.577,0.411l-0.959-0.034l-0.343-0.343h-0.24l-0.171,0.309l-0.651,0.343l-0.411-0.171l-0.754-0.137l-0.926-0.309l-0.274-0.548l-0.754-0.103     l-1.062,0.103l-0.137,0.412l-0.617,0.068l-0.651-0.411l-0.65-0.035l-0.823-0.068l-0.514,0.377l-0.377,0.343l-0.274,0.274l-0.686,0.171l-0.411-0.24l-0.686-0.137l-0.582-0.548l-0.72-0.068l0.034,0.24l0.205,0.48l-0.239,0.274l-0.274-0.137l-0.068-0.583     l-0.411-0.274l-0.789-0.343l-0.582-0.206v-0.343l-0.96-0.171l-0.617,0.069l-0.788-0.035l-0.411-0.514l-0.411-0.069l-0.617,0.24l-0.273,0.137l-0.651,0.137l-0.309-0.274h-0.479l-0.651-0.069l-0.515,0.309l-0.548,0.343l-0.788,0.377l-0.549,0.068l-0.514,0.171     l-0.309,0.309l-0.172,0.24L509.58,87.5l-0.479,0.206l0.068,0.445l0.171,0.411l-0.068,0.446l-0.411,0.24h-0.651l-0.514-0.411l-0.48-0.548l-0.514-0.24l-0.411,0.069l-0.103,0.308l-0.343,0.549l-0.823,0.137l-0.205,1.303l0.343,0.171l0.239,0.274l-0.239,0.206     l-0.446,0.274l-0.65,1.165l1.37,0.343l0.138,0.377l-0.068,0.309l0.514,0.514l0.103-0.343l0.583,0.206l0.343-0.034l0.514,0.034l0.515,0.445l0.479,0.206l0.343,0.514l0.96,1.131l-0.138,0.103l-0.445-0.103l-0.309-0.103l-0.343,0.103l0.068,0.308l0.857,0.377     l0.616,0.19l-0.167,0.2l-0.399,0.28l-0.38,0.12h-0.12v0.14v0.22l-0.14,0.08l-0.3-0.2l-0.34,0.2l-0.399,0.26l-0.64,0.12l-0.319,0.08l-0.26-0.08l-0.181-0.08l-0.1,0.04l-0.06,0.16l0.12,0.26l-0.221,0.2l-0.18,0.3l-0.18,0.319l-0.319,0.42l-0.18,0.28l-0.32,0.16     l-0.34,0.24l-0.14,0.32l0.08,0.2l0.34,0.2l0.319,0.04l0.18,0.3l0.24,0.04l0.239,0.34l0.28,0.419l-0.06,0.38l-0.101,0.2l0.061,0.16l0.1-0.2l0.1-0.34l0.12-0.22l0.16-0.02l-0.141,0.439l-0.22,0.36l0.061,0.4l0.12,0.1l-0.16,0.2l-0.04,0.4l0.38,0.24l0.119,0.1     l0.12,0.52l0.28,0.06l0.359,0.42l0.2,0.28l0.439,0.419l0.18,0.36l0.359,0.06l0.047,0.146l-0.292,0.449l-0.496,0.284l-0.283,0.094l-0.308,0.331l-0.165,0.213l-0.379,0.047l-0.449-0.142l-0.591-0.094v-0.308l-0.283-0.284h-0.118l-0.095-0.118l-0.473-0.284     l-0.142-0.189H504.5l-0.213,0.047L504.264,107l-0.229,0.023l-0.126-0.189l-0.236-0.071l-0.236,0.023l-0.284-0.047l-0.26-0.094l-0.284-0.166l-0.354-0.284l0.118-0.307l0.118-0.189l-0.118-0.142l-0.354-0.024h-0.378l-0.213-0.166l-0.189-0.118h-0.212l-0.143-0.094     l-0.236-0.118h-0.118l-0.095,0.071l-0.142,0.166l-0.188-0.142l-0.261-0.071h-0.354l-0.213,0.071l-0.094,0.095l-0.166,0.166h-0.283l-0.261,0.118l-0.212-0.071l-0.261-0.118l0.048-0.118l0.142-0.118l-0.308-0.119l-0.236-0.118l-0.354-0.071l-0.52-0.118l-0.284-0.213     l-0.095-0.142l-0.354-0.166l-0.283,0.047h-0.189l-0.401-0.166h-0.544l-0.426,0.095h-0.307l-0.355-0.047l-0.307-0.071l-0.261-0.095l-0.212-0.166h-0.213h-0.331l-0.189-0.047l-0.188-0.094l-0.284-0.142l-0.283-0.095l-0.449-0.023l-0.402-0.023l-0.07-0.047     l-0.284-0.047l-0.26,0.166l-0.112,0.309l-1.421-1.012l-1.188-0.842l-0.817-0.385l-0.62-0.084l-0.373-0.157l-0.509-0.5l-0.236-0.057l-0.338,0.159l-0.329-0.042l-0.347-0.515l-0.795-0.674l0.595-0.188l0.519-0.001l0.445-0.073l0.1-0.519l0.359-0.476L485,97.85     l0.526-0.03l0.516-0.131l-0.432-0.532l-0.654-0.273l-0.474-0.36l0.243-0.116l0.367-0.03l0.82-0.117l0.715-0.348l1.244-0.436l-0.196-0.375l-0.076-0.058l-0.799,0.088l-1.312,0.175l0.012-0.126l0.021-0.112v-0.224l0.09-0.514l0.224-0.089l0.357-0.022l0.38-0.134     l0.223-0.179l0.022-0.179h0.269l0.736-0.045l0.805,0.157l0.335-0.134v-0.156l0.156-0.291l0.156-0.491l-0.066-0.067l-0.09-0.201l-0.045-0.179l-0.044-0.134l-0.179-0.067l-0.156-0.067l0.044-0.224l0.045-0.179h0.246h0.312l0.134-0.156l-0.29-0.044l-0.269-0.089     l-0.223-0.246l0.312-0.044l0.357-0.201l0.156-0.067l0.201-0.089l0.045-0.224l-0.09-0.179l-0.111-0.089l0.022-0.179l0.089-0.111l-0.156-0.089l-0.201,0.089l-0.134,0.044h-0.269l-0.357-0.156l-0.111-0.224l-0.469-0.022l-0.291-0.089l-0.201-0.179l-0.357,0.067     l-0.268-0.112l-0.469-0.112l-0.425-0.067l-0.29-0.268l-0.224,0.067l-0.045,0.157l-0.29,0.134l-0.224-0.112l-0.179-0.179l-0.402-0.044l-0.022-0.134l-0.201-0.179v-0.134l-0.268-0.179l-0.111-0.156l-0.357,0.067l-0.536,0.134h-0.269l-0.312,0.112l-0.425,0.112     l-0.179-0.156l-0.179-0.022l-0.201,0.067l-0.469-0.291l-0.268-0.067l-0.47,0.067l-0.268,0.179l-0.291-0.29l-0.179-0.089l-0.089-0.224l0.089-0.179l-0.089-0.246l-0.224-0.268v-0.357h-0.402v-0.312l-0.38-0.022l-0.514,0.067l-0.156-0.112h-0.647l-0.269-0.29     l-0.111-0.357l-0.134-0.291l0.312-0.134l0.312,0.022v-0.268l-0.312-0.156l-0.246-0.156l-0.134-0.201l-0.246-0.335l-0.312-0.134l-0.201-0.268l-0.514,0.134l-0.692-0.112l-0.67,0.223l-0.536,0.022l-0.536-0.246l-0.134,0.268l-0.179,0.291l-0.313,0.156l-0.469-0.022     l-0.357-0.089z M527.156,37.071l-0.59-0.14l-0.955-0.21l-1.128-0.139l-0.739,0.054l-0.959,0.037l-0.732,0.143l-0.411-0.105l-1.025-0.476l0.737-0.303l1.21-0.429l0.654-0.09l1.549-0.002l0.135-0.357l-0.728-0.338l0.351-0.269l0.419-0.144l0.676-0.02l0.852-0.181     l-0.25-0.161l-0.526-0.233l1.539-0.895l0.513-0.129l0.226,0.073l0.892,0.017l0.981-0.535l0.863-0.333l1.02-0.261l0.975-0.15l1.305-0.113l1.274,0.053l0.738-0.15l0.786-0.615l0.273,0.018l0.873-0.132l1.722,0.276l0.471-0.038l1.93-0.321l0.958-0.039l2.184-0.247     l1.864-0.116l0.771-0.564l0.376-0.152l2.511-0.137l1.965-0.079l0.471,0.131l0.442,0.225l0.154,0.357l-0.812,0.47l-0.541,0.169l-1.346,0.319l-2.609,0.433l-4.329,0.49l-2.187,0.281l-2.122,0.299l-1.842,0.316l-2.102,0.242l-0.941,0.203l-0.288,0.274l0.644,0.216     l-0.422,0.217l-0.943,0.361l-0.527,0.037l-2.047-0.068l-0.432,0.18l-0.119,0.233l0.621,0.249l-0.331,0.233l-1.206,0.448l-0.402-0.142l-0.752-0.087l-0.592,0.304l0.877,0.283l0.052,0.319l-1.094,0.657l-0.822,0.284z M517.491,38.443l1.041-0.37l0.512-0.299     l0.428-0.212l1.426-0.021l1.316-0.249l0.987-0.02l1.412-0.091l0.551,0.069l0.988,0.227l-0.063,0.176l-0.463,0.528l-0.302,0.158l-0.697,0.071l-0.443,0.228l-0.233,0.385l0.006,0.818l0.445,1.039l0.957,0.826l0.505,0.308l0.775,0.307l1.162,0.392l-0.028,0.282     l-2.62-0.089l-0.844,0.053l-0.917,0.326l-0.596,0.086l-0.676-0.494l-0.382-0.034l-1.091,0.088l-0.673-0.102l-0.031-0.359l1.347-0.362l0.073-0.24l-0.102-0.017l-0.944-0.273l-1.442-0.411l-1.519-0.17l-0.33,0.156l-0.624,0.122l-0.681-0.033l-0.625-0.396     l-0.114-0.415l0.229-0.312l0.39-0.209l0.344-0.036l0.318,0.104l0.65,0.016l0.518-0.192l1.121-0.768l0.243-0.35l-0.322,0l-0.981-0.243z M0.125,56.089v-0.562v-0.576v-0.157v-1.292V51.28v-2.222v-2.12l2.917,0.61l1.693,0.598l0.933,0.181l3.819,0.99l1.059,0.395     l0.204,0.149l0.074,0.214l0.445,0.429l0.406,0.789l-0.209,0.428l1.034,0.8l0.982,0.26l-0.02-0.18l0.297-0.148l-0.051-0.196l-0.638-0.392l0.016-0.542l0.077-0.296l1.026-0.183l0.984,0.278l0.573,0.098l0.767,0.064l1.003-0.117l0.933,0.13l0.93,0.425l0.694,0.359     l1.676,0.684l0.32,0.081l0.584,0.179l0.43,0.211l0.09,0.13l-0.343,0.033l-1.026-0.096l-0.364,0.034l-0.808,0.798l-1.539-0.468l0.138,0.178l0.438,0.227l0.465,0.324l-1.177-0.111l-1.008,0.05l-1.202-0.387l-0.708-0.096l0.135,0.129l0.289,0.259h0.084l0.561,0.259     l0.205,0.307l0.131,0.453l-0.056,0.339l-0.814,0.05l-0.805,0.065l-0.189,0.161l0.5,0.865l-0.115,0.272l-1.04-0.078l-0.397,0.081l-1.193-0.174l-0.264-0.352l-1.795-0.51l-0.253,0.273L9.85,55.79l-0.276-0.161l-0.265-0.403l0.174-0.178l-0.321-0.42l-0.87-0.339     l-0.565-0.063l-0.762,0.034l-0.858,0.229l-1.343,0.084L3.57,54.443l0.059-0.325l-0.155-0.325l-0.618-0.487L1.958,53.43l-0.45,0.409l-0.655,1.228l-0.166,0.715l-0.562,0.307z'},
	NO => {name => 'Norway',
		d => 'M449.401,22.792l-1.596-0.014l-2.019-0.016l-1.739,0.063l-0.764,0.061l-1.972-0.316l0.812-0.456l0.826-0.172l0.735-0.453l1.148-0.588l1.354,0.691l0.998,0.105l1.116-0.088l0.9,0.084l0.704,0.341l0.865-0.323l0.53-0.454l0.868-0.306     l-0.311,0.823l0.086,0.32l0.851-0.001l0.991-0.495l1.061-0.261l0.803,0.128l0.559,0.472l0.705,0.041l2.007-0.111l1.543,0.189l0.551,0.376l-0.507,0.201l-2.004,0.622l-1.623,0.38l-1.069,0.062l-0.976,0.14l-1.324,0.366l-6.271-0.097l-0.033-0.377l1.492-0.26     l0.702-0.677z M430.027,22.752l0.068,0.697l0.252,0.119l1.694,0.155l0.221-0.377l0.13-0.418l0.573-0.141l0.523-0.041l0.949,0.477l1.192,0.771l0.798,0.235l0.568-0.218l-0.222-0.296l-0.46-0.356l-0.327-0.477l-0.04-0.22l0.91-0.407l1.001,0.103l0.485,0.18     l1.278,0.018l0.586,0.179l-0.08,0.419l-0.169,0.298l0.104,0.159l0.549,0.118l0.743-0.338l0.44-0.1l0.662,0.396l0.678,0.335l0.785,0.156l0.948,0.117l1.672,0.429l0.498,0.234l-1.305,0.277l-1.981,0.218l-0.696,0.293l-0.731,1.144l-0.885,0.885l-1.243,0.117     l-0.766,0.535l-0.455,0.589l-0.029,0.378l-0.786,0.209l-0.556-0.018l-1.593-0.355l-1.883-0.507l-1.365-0.568l0.651-0.364l1.565-0.041l1.788-0.137l0.944-0.386l-0.652-0.249l-1.822,0.139l-1.566,0.118l-1.694,0.042l-0.502-0.519l0.959-0.06l1.371-0.215l2.149-0.314     l1.547-0.45l-2.525-0.405l-0.881-0.292l-0.589,0.138l-1.036,0.646l-1.069,0.293l-0.562,0.059l-1.236-0.172l-0.338-0.174l-1.05-0.368l-0.807-0.233l-0.698-0.41l1.698-0.396l-0.817-0.571l-1.359,0.319l-0.467-0.078l-0.924-0.751l0.812-0.36l0.516-0.021l1.075-0.122     l1.017,0.038l0.577-0.061l1.188-0.042z M425.42,68.82l-0.148-0.21l-0.629,0.132l-0.134-0.026l-0.249-0.237l-0.239-0.343l0.188-0.158l-0.143-0.291l-0.361,0.185l-0.062,0.29l0.113,0.237l-0.147,0.105l-0.339,0.316l-0.086,0.185l-0.521,0.105l-0.533-0.131     l-0.781,0.342l0.057,0.131l-0.502,0.289l-0.498,0.263l-1.658,0.813L418.697,71l-0.274,0.052h-0.271l-2.111,0.209l-0.188-0.236l-0.33-0.131l-0.183,0.209L414.976,71l0.384-0.184l-0.935-0.236l-0.794-0.341l-0.574-0.052l-0.479-0.578l0.292-0.368l-0.126-0.21     l0.34,0.026l0.085,0.316l0.284-0.21l0.667,0.263l-0.244-0.197l0.127-0.145l0.5-0.092l-0.479,0.026l-0.245,0.105l-0.263-0.184l-0.111-0.132l0.579-0.276l0.455-0.185l-0.482,0.066l-0.317-0.132l0.441-0.237l0.083-0.237l-0.661,0.475l-0.036-0.264l-0.265-0.171     l0.005,0.211l0.076,0.171l-0.419,0.158h-0.41l0.014-0.277l-0.15,0.264l-0.235-0.079l-0.2-0.448l0.658-0.449l0.08,0.436l0.068-0.317l0.438,0.158l0.211-0.092l-0.166-0.106l0.674-0.079l0.479-0.251l-0.611,0.159h-0.48l-0.335-0.159l0.196-0.132l0.387-0.146     l0.196-0.471l-0.821-0.014l-0.546,0.094l-0.406-0.309l0.368-0.14l0.643-0.404l-0.212-0.186l-0.445,0.063l-0.399-0.062l-0.211-0.217l0.284-0.482l0.619-0.265l-0.595-0.248l-0.225-0.374l0.272-0.188l-0.089-0.687l0.106-0.094l0.594-0.063l0.392-0.045l0.455,0.044     l0.082-0.11l-0.255-0.134l-0.425-0.118l-0.228-0.17l0.098-0.188l0.211-0.125l0.575-0.064l0.511-0.346l0.567,0.109l0.498-0.111l0.179-0.55l0.835,0.093l0.668,0.125l0.571-0.252l-0.989-0.234l-0.266-0.314l0.236-0.143l1.151,0.014l0.851-0.08l0.538,0.219l0.06-0.473     l0.477-0.27l0.297-0.333l0.78-0.175l0.438,0.189l0.138,0.079l0.5-0.476l0.869-0.413l0.084-0.429l0.437-0.398l1.497-0.735l0.335-0.192l0.235-0.048l0.481,0.175l0.335-0.001l0.319-0.224l-0.225-0.223l0.141-0.128l0.488-0.224l0.457-0.305l0.481-0.483l0.245,0.064     l0.676-0.017l-0.067-0.612l-0.471-0.112l0.434-0.405l0.511-0.648l0.841,0.063l0.047-0.341l0.096-0.228l0.954-0.116l-0.396-0.357l-0.327-0.097l-0.193-0.146l0.164-0.245l0.313-0.246l0.464,0.048l0.888-0.067l-0.543-0.522l0.249-0.082l0.435-0.034l0.707-0.263     l0.592-0.067l0.308-0.208l-0.358-0.064l-0.105-0.187l0.289-0.1l0.616-0.33l0.557,0.032l0.351,0.098l0.434-0.264l0.369-0.031l0.035-0.176l-0.421-0.321l0.627-0.232l0.146-0.275l0.336,0.01l0.359,0.297l0.397,0.082l0.526-0.381l-0.281-0.656l0.438,0.065l0.698-0.058     l0.207-0.174l-0.604-0.315l0.411-0.224l0.816-0.251l0.093-0.257l0.261-0.194l0.73-0.135l0.074,0.067l0.274-0.051l0.102-0.067l0.492-0.67l0.521,0.25l0.96-0.153l0.411,0.133l0.265,0.1l0.646,0.065l0.536-0.419l0.747-0.84l0.286-0.085l0.16,0.168l-0.178,0.286     l-0.182,0.587l0.791-0.454l0.403-0.572l0.819-0.085l0.688-0.439l0.437,0.117l0.665,0.353l0.567-0.643l0.318-0.272l0.976,0.1l1.019,0.506l0.197-0.152l0.479-0.595l0.709-0.444l0.283-0.052l0.562,0.067l0.338-0.308l0.469-0.291l0.619-0.189l1.2-0.173l0.984,0.015     l-1.337,0.755l-0.24,0.273l-0.107,0.646l0.42,0.084l0.691-0.579l1.53-0.941l0.764-0.275l0.028,0.257l-0.004,0.905l0.704-0.172l0.438-0.239l0.855-0.874l0.959-0.104l0.586-0.001l0.216,0.154l-0.383,0.257l-0.335,0.257l0.074,0.239l-0.319,0.41l0.921,0.118     l0.221-0.443l0.902-0.651l0.421,0.017l1.682,0.561l0.667,0.135l0.935,0.015l0.649,0.237l0.1,0.272l-1.216,0.393l-1.148,0.036l-2.233-0.047l0.193,0.084l0.585,0.304l1.058,0.284l0.383,0.302l0.728-0.052l0.679-0.102l0.831,0.032l0.708,0.25l-0.404,0.288     l-0.514,0.204l-0.824,0.021l-0.77,0.121l-1.023,0.49l-1.013,0.672l-0.689,0.303l-0.001-0.2l0.096-0.367l0.874-0.923l-0.044-0.268l-0.88-0.348l-0.672-0.114l-1.125-0.431l-0.556,0.003l-0.555,0.07l-2.004,0.095l-0.865,0.374l-0.567,0.422l-0.26,0.437l-0.079,0.501     l-0.188,0.5l-1.25,0.472l-0.582,0.368l-0.31-0.148l-1.288-0.492l-1.657,0.225l-1.411-0.042l-0.536-0.13l-0.861-0.595l-0.994-0.612l-0.486-0.082l-0.355,0.103l-1.012,0.656l-0.114-0.063l-0.41-0.031l-0.865,0.038l-0.281,1.066l-0.164,0.449l-0.271,0.25     l-0.323-0.015l-0.67-0.129l-0.972-0.144l-1.731-0.389l-0.168,0.183l-0.021,0.663l-0.083,0.199l-0.318,0.299l-0.695,0.004l-0.871-0.095l-0.279-0.015l-0.465,0.167l-1.484,1.176l0.05,0.213l0.171,0.507l-0.188,0.345l-0.615,0.346l-1.325,0.919l-0.687,0.442     l-0.981,0.021l-0.121,0.244l-0.06,0.971l-0.32,0.598l-0.383,0.469l-0.574,0.499l-0.495,0.545l0.339,0.125l0.381,0.269l0.252,0.587l-0.17,0.176l-0.44,0.177l-0.733,0.036l-0.932-0.027l-0.618,0.114l-0.613,0.257l-0.617,0.479l-0.389,0.492l-0.077,0.664     l-0.349,1.093l0.65,0.729l-0.335,1.171l0.582,0.39l0.715,0.186l0.297,0.243l-0.432,0.67l-0.941,0.16l0.571,0.735l0.26,0.427l-0.249,0.346l-0.029,0.532l-0.769,0.384l-0.414,0.013l-0.117,0.423l-0.506,0.224l0.22,0.831l-0.324,0.737l-0.41,0.013l-0.15-0.342     l-0.293-0.132z'},
	FI => {name => 'Finland',
		d => 'M464.349,47.431l-0.024,0.283l-0.258,0.465l0.116,0.529l0.563,0.212l0.872,0.194l0.964,0.506l0.543,0.392l-0.421,0.364l-1.303,0.777l-0.328,0.296l1.402,1.394l0.772,1.195l-0.196,0.356l-0.44,0.535l-0.187,0.403l-0.029,0.37l0.37,0.509     l1.286,1.395l0.151,0.253l-0.057,0.254l-0.542,0.415l-0.327,0.191l0.439,0.33l1.357,0.499l0.703,0.265l0.436,0.392l0.161,0.346l-0.105,0.409l-0.43,0.536l-0.591,0.536l-1.385,0.758l-1.983,1.195l-1.946,1.145l-0.174,0.285l-0.935,0.206l-1.195,0.188l-0.149,0.181     l-0.506-0.217l-0.518,0.146l-0.052,0.134l-0.688-0.07l-0.193-0.108l0.057-0.387l-0.241,0.527l-0.268,0.14l-0.633,0.047l-0.328,0.03l-0.1,0.267l-0.589-0.326l-0.29,0.275l-0.676,0.064l-0.34,0.178l-0.052-0.127l-0.504,0.108l-0.504,0.108l-0.211,0.266l-0.311-0.152     l-0.672,0.126l-0.04-0.114l-0.658,0.215l-0.547,0.013l-0.482,0.025l-0.487-0.253l-0.223-0.274l0.273-0.34l-0.846,0.017l-0.517,0.177l0.065-0.382l-0.446,0.076l-0.644-0.271l-0.409-0.061l-0.415-0.231l-0.26-0.403l-0.036-0.714l0.158-0.374l0.05-0.436l0.09-0.234     l-0.347-0.483l-0.431-0.375l0.3-0.658l-0.02-0.392l-0.305-0.204l-0.37-0.093l0.062-0.299l0.295-0.331l0.637-0.285l0.144-0.189l-0.113-0.331l0.382-0.143l0.633,0.125l0.274,0.063l0.483-0.222l0.303-0.427l0.104-0.459l0.207-0.27l0.301,0.316l0.27,0l1.678-1.114     l1.142-0.654l0.835-0.576l1.026-0.401l0.874,0.03l0.06-0.304l-0.13-0.144l-0.357-0.16l0.119-0.371l0.146-0.387l-0.329-0.274l-1.139-0.095l-0.836-0.451l-0.594-0.024l-0.113-0.234l-0.327-0.307l-0.208-0.535l0.5-0.8l-0.028-0.392l-0.405-0.685l-0.507-0.637     l0.004-0.526l0.062-0.413l-0.77-0.558l-0.508-0.229l-1.583-0.207l-1.085-0.292l-1.286-0.658l-0.616-0.463l-0.146-0.033l1.012-0.656l0.355-0.103l0.486,0.082l0.994,0.612l0.861,0.595l0.536,0.13l1.411,0.042l1.657-0.225l1.288,0.492l0.31,0.148l0.582-0.368     l1.25-0.472l0.188-0.5l0.079-0.501l0.26-0.437l0.567-0.422l0.865-0.374l2.004-0.095l0.555-0.07l0.556-0.003l1.125,0.431l0.672,0.114l0.88,0.348l0.044,0.268l-0.874,0.923l-0.096,0.367l0.001,0.2z'},
	SE => {name => 'Sweden',
		d => 'M453.795,53.873l-0.23-0.004l-0.975,0.164l-0.447,0.098l-0.902-0.387l-0.339-0.178l-0.347,0.114l-0.641,0.374l-0.542,0.599l-0.309,0.146l-0.658,0.018l-0.545,0.355l0.325,0.241l0.146,0.192l-0.355,0.273l-0.907,0.401l0.317,0.271     l0.385,0.159l0.33,0.302l-0.749,0.367l-0.405,0.43l-0.368,0.461l-1.591,0.669l-0.699,0.286l-0.456-0.205l-0.326,0.08l-0.538,0.539l-0.646,0.144l-0.663,0.348l-0.217,0.284l-0.191,0.142l-0.746,0.033l-0.221-0.031l0.151,0.535l-0.484,0.425L439,61.33l0.216,0.533     l0.243,0.25l-0.244,0.955l-0.498,0.063l-0.217,0.204l0.189,0.757l-0.009,0.544l0.381,0.444l-0.287,0.175l0.926,0.082l0.225,0.187l0.499-0.082l0.652,0.594l0.428,0.314l0.86,0.163l0.198,0.406l0.32,0.139l0.014,0.335h-0.391l-0.508,0.323l-0.861,0.3l-0.492,0.162     l-0.521-0.012l-0.146-0.115l-0.805-0.115l-0.66-0.173l-0.634-0.069l-0.137,0.104l-0.446-0.115l-0.257,0.3l0.819-0.069l0.497,0.265l0.591,0.046l0.205,0.208l0.481,0.069l0.021-0.127l0.616,0.069l0.258-0.196l0.297,0.011l0.481-0.104l0.226,0.081l0.026-0.15h0.164     l0.214,0.15l-0.029,0.081l-0.722,0.023l0.219,0.288l-0.792,0.265l-0.168,0.288l-0.386,0.08l-0.089-0.092l0.042-0.161l-0.014-0.276l-0.258,0.023l-0.091,0.46l-0.501,0.333l-0.248,0.058l-0.36-0.069l-0.005,0.218l-1.418,0.035l0.156,0.458l0.513,0.258l0.066,0.609     l-0.109,0.33l-0.281,0.051l-0.308-0.064l0.038,0.429l0.29,0.081l-0.126,0.268l0.24,0.228l-0.365,0.364l-0.222,0.455l-0.041,0.56l-0.766,1.043l-0.58,0.71l-0.165-0.062l-0.442-0.236l-0.614,0.193l-1.262-0.089l-0.106,0.311l-0.252-0.083l-0.518,0.264l-0.295,0.517     l0.356,0.336l-0.376,0.374l-0.48-0.129l-0.173-0.037l-1.158,0.269l-1.11-0.116l-0.001-0.142l0.19-0.078l-0.062-0.181l0.281-0.297l-0.638-0.53l-0.413-0.479l-0.22-0.272l0.529-0.116l-0.082-0.312l0.421,0.077l0.147-0.245l-0.19-0.234l-0.285,0.013l-0.292-0.377     l-0.527-0.221l-0.63-0.99h-0.286l0.011-0.408l-0.256-0.364l-0.348-0.298l0.221-0.484l0.206-0.341l-0.418-0.154l-0.405,0.102l-0.055-0.288l-0.412,0.051l-0.18-1.207l-0.225-0.131l0.311-0.355l0.293,0.132l0.15,0.342l0.41-0.013l0.324-0.737l-0.22-0.831l0.506-0.224     l0.117-0.423l0.414-0.013l0.769-0.384l0.029-0.532l0.249-0.346l-0.26-0.427l-0.571-0.735l0.941-0.16l0.432-0.67l-0.297-0.243l-0.715-0.186l-0.582-0.39l0.335-1.171l-0.65-0.729l0.349-1.093l0.077-0.664l0.389-0.492l0.617-0.479l0.613-0.257l0.618-0.114     l0.932,0.027l0.733-0.036l0.44-0.177l0.17-0.176l-0.252-0.587l-0.381-0.269l-0.339-0.125l0.495-0.545l0.574-0.499l0.383-0.469l0.32-0.598l0.06-0.971l0.121-0.244l0.981-0.021l0.687-0.442l1.325-0.919l0.615-0.346l0.188-0.345l-0.171-0.507l-0.05-0.213l1.484-1.176     l0.465-0.167l0.279,0.015l0.871,0.095l0.695-0.004l0.318-0.299l0.083-0.199l0.021-0.663l0.168-0.183l1.731,0.389l0.972,0.144l0.67,0.129l0.323,0.015l0.271-0.25l0.164-0.449l0.281-1.066l0.865-0.038l0.41,0.031l0.114,0.063l0.146,0.033l0.616,0.463l1.286,0.658     l1.085,0.292l1.583,0.207l0.508,0.229l0.77,0.558l-0.062,0.413l-0.004,0.526l0.507,0.637l0.405,0.685l0.028,0.392l-0.5,0.8l0.208,0.535l0.327,0.307l0.113,0.234z'},
	AQ => {name => 'Antarctica',
		d => 'M238.107,361.753l0.515-0.688h0.859l1.202-0.515l-0.171-0.858l-3.091,0.344l-2.061,0.515l-1.545-0.344l-0.515-0.858l1.374-0.515l1.202-0.172l3.091-0.172l1.374-0.515l-0.172-1.03l0.859-0.516v-1.374l-1.326-1.054l0.982-0.491l1.202-0.344     l1.545-0.172l0.858,0.344l0.858,0.858l1.03,1.374l1.374,1.202l1.03,1.373l-0.515,2.061l-1.545,0.516l-1.545,0.858l-3.434,0.172h-3.435z M172.686,360.379l3.091-0.687h3.262h5.495l2.919,1.202l-2.748,0.687l-3.759-0.337l-5.169-0.35l-3.091-0.516z M65.13,371.085     l1.194-0.265l1.393,0.133l0.796,0.464h-1.99l-1.393-0.332z M277.944,379.954l0.515-1.202l2.404-1.03l2.748-0.172l2.061-0.171l1.545-0.859l0.343-1.545l1.374-0.687l3.091-0.688h4.464h2.404l3.434,0.688l0.687,1.889v1.202l-2.061,1.201l-11.848,1.03l-11.161,0.344z      M36.004,376.434l1.202-0.858l2.061-0.343l4.121,0.515l4.293,1.374l-0.887,0.482l-2.719,0.204l-4.293-0.515l-3.777-0.859z M777.843,385.46l3.823,0.391l0.899,0.029l0.322,0.234l1.202,0.294l2.329,0.088l2.126-0.003l5.218,0.329l3.046,0.348l1.144-0.059     l0.762,0.029l1.411,0.37v2.175v2.223v2.222v2.223v2.222v1.551h-0.041h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223     h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223     h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.182h-0.041h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222     h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222     h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222     h-2.223h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.222h-2.223h-2.182h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222     h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222     h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222     h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222     h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222h-2.223h-2.222h-2.222     h-2.222h-2.222h-2.222h-2.222h-2.222h-2.222H9.014H6.792H4.569H2.347H0.125v-1.544v-2.222v-2.223v-2.222v-2.223v-2.223l3.941,0.297h10.131l7.898,0.516l6.868,0.172l8.586,0.858l6.353,0.515l8.757,0.172l4.808-0.172l6.525-0.172l2.404,0.344l3.606-0.858     l16.312,0.344l4.638-0.013l1.143-0.467l-14.366-0.551l-9.616-0.688h-2.232l-3.091-0.172l-0.858-0.171l-1.545-0.344l-0.498-0.455l0.155-1.434l0.687-0.858l1.889-0.688l-3.263-0.687l-2.232-0.344l-0.953-0.503l1.589-0.521l-2.891-0.6l-3.074-0.208l-0.104-0.261     l2.857-0.312h2.748l6.525,0.343h3.434l2.576,0.344l4.636-1.202l2.404-0.687l-2.748-1.03l-3.778-0.858l-4.391-0.405l-2.649-0.625l-3.262-0.172h-2.919l-2.919-0.858l2.576-0.516l1.28-0.342l-1.28-0.517l-2.919,0.516H52.66l-1.717-0.344L49.054,373l0.343-1.202     l1.956-0.07l1.65-0.273h4.98l4.626,0.493l3.272,0.709l1.374,0.172l4.465-0.858l4.089,0.243v-0.729l0.066-0.597l-2.255-0.73l-2.93-0.075l-2.576-0.344l2.404-0.687l4.121,0.171l1.717-0.343l3.091-0.516l3.09-0.343l5.667-0.688l4.465-0.343l3.949-0.516l4.464-0.515     l2.748,0.343h5.667l4.464,0.258l4.121-0.515l7.898,0.343l7.555-0.687l3.091,0.172l1.545-0.688l1.545,0.516l5.323-0.172l0.121-0.87l1.758-0.293l1.433,0.325l0.586,0.554l-0.423,0.813l2.364,0.329l1.38-0.264l-0.006-0.938l1.438-0.267l1.48,0.267l0.212,1.036     l-1.009,0.423l0.521,0.781l3.024-0.351l1.889,0.343l3.434,0.172l2.576-0.687l3.778,0.086l4.868,0.33l2.344,0.013l1.449,0.109l0.693-0.53l-0.611-0.285l-2.202-0.122l1.305-0.285l0.041-0.408l-0.367-0.245l-1.386,0.123l-0.693,0.04l-0.856-0.979l-2.178-0.337     l-0.676-0.193l-0.182-0.665l4.056,0.462l3.874-0.245l-1.224-0.489l-6.035-0.163l-0.774-0.082l-0.653-0.489v-0.815l2.301,0.105l0.839,0.67l5.301-0.204l7.253,0.736l2.404-0.172l3.262-0.172l4.464,0.172l3.263,0.172l2.061-0.516l0.687-0.687h1.202l0.344,1.03     l2.576,0.343l2.404-0.343l0.858,0.515l3.435,0.688l3.777,0.343l2.061,0.172l1.03-0.515l0.687-1.202l2.747-0.172l1.03,0.515l1.717,0.688l3.091-0.172l3.434,0.258l4.121-0.344l4.979-0.516l5.495-0.858l3.091-0.515l1.202-0.688v-1.373l-1.374-1.202l-0.859-1.545     l-1.202-0.688l-0.344-1.03l1.202-1.03l1.717-0.343l0.858-1.202l-0.343-0.858l-0.172-1.03l-1.202-0.516l0.344-1.545l1.889-0.172l2.404-1.374l1.545-0.515l0.859-0.859l1.03-0.687l2.919-1.202l3.606-0.515l2.404-1.202l2.404-0.172l2.232-1.03l1.545-0.343l0.343,1.03     l-1.374,0.515l-1.03,0.344l-1.202,0.515h-0.858h-1.202l-2.919,1.202l-1.03,0.687l-1.717,1.374l-0.172,1.202l-0.687,0.687l-1.374-0.344h-1.03l-1.202,0.516l-1.202,0.687l-1.03,0.688l-0.687,1.201l0.515,0.688l0.687,0.687l1.374,0.344h1.545l0.858,0.515l0.687,1.202     l1.545,1.546l0.687,0.858l1.03,0.687l0.687,1.374l0.858,1.373l0.344,1.546l-0.344,0.858l-0.858,1.717l-2.919,1.889l-1.202,0.172l-1.03,0.858l-1.717,1.03l-3.263,0.344l-4.979,0.858l-2.404,0.344l-2.919,0.687l-7.377-0.141l-4.556-0.316l-0.773-0.401l-1.717-0.344     l-1.717-0.343h-1.374l-0.859,0.515l0.515,0.858l2.061,0.688l4.121,1.202l4.995,0.04l1.202,0.759l-3.278,0.574l-5.667-0.343l-4.979-0.516l-3.097-0.285l-2.151,0.253l0.823,0.696l1.164,0.538l3.262,0.172h2.232l1.374,0.343l-0.249,0.402l-0.782,0.113l-2.232,0.515     l-5.151-0.171l-1.374-0.172l-2.232-1.202h-2.404l0.128,0.917l2.62,1.144l1.03,0.172l1.202-0.172l1.374,0.344h2.404l4.98-0.516l3.09,0.687l0.385,0.431l-0.041,0.6l-2.061,0.172l-3.263,0.172l-2.608-0.185l3.811,0.871l3.656-0.238l1.324,0.41l2.576,0.687     l6.869,0.859l8.585,0.858l10.646,1.373l6.525,0.516l2.061,0.858l0.687,1.03l3.091-0.344l5.323-1.545l6.525-0.687l2.455-0.066l6.474-0.105l9.788-0.344l1.889,0.344l2.576-1.202l8.414-1.03l11.333-0.172l8.929-0.858l1.202-0.858l-1.202-0.516l-0.271-1.07     l-1.184-0.338l-5.071,0.035l-2.232,0.172l-4.808-0.344h-3.091v-1.202l3.263-1.545l3.949-1.202l2.404-0.172l4.121-1.03l9.444-1.202l5.323-0.858h6.525l4.979-0.516l2.747-2.061l6.039-1.541l-1.23-0.52l-2.576,0.516l-2.061-0.344l1.545-1.03l1.545-0.343l2.48-0.249     l0.696-0.742l3.85-0.742l1.577-0.418l0.603-0.557l-1.716-0.881l-0.093-0.604l1.252-0.231l0.464,0.742l1.017-0.097l2.061-0.858l1.03-0.343l0.858,0.171l1.203,1.544l2.403-0.342l0.242-0.91l0.96-0.807l1.889-0.516l1.374,0.516l-1.162,0.574l-0.139,0.604l3.189-0.319     l4.808,0.258l3.263-0.172l1.03,0.858l1.545-0.344l1.717-0.515l5.839-0.858l7.212-1.03l4.292-0.858h2.061l2.061,1.373l1.718,0.344l1.889-0.344l1.545-0.858l7.556-0.344l3.434-0.171l4.293,0.171l6.697,0.945h2.575l4.293-0.516l6.01-0.687l5.151-0.688l2.404-0.515     l2.231-0.344l0.615-0.959l1.148-0.835l1.671-0.095l0.938,0.965l1.294,0.409l1.732,1.052l1.009,0.139l1.009-0.661l1.322-0.174l0.209,0.522l-0.835,0.312l0.661,0.244l0.8,0.278l0.383-0.383l0.313-0.383l0.312,0.209l-0.174,0.348v0.521l0.592-0.174l1.913-0.557     l0.418-1.704l5.102-1.137l1.374-0.687l3.605-0.172l1.363-0.646l2.758-0.126l0.21-0.27l-0.165-0.297l0.692-0.23l1.221,0.165l0.197,0.593l0.66,0.231l2.165-0.536l1.265-0.223l-0.726-0.297l-0.561-0.264l0.099-0.362l1.451-0.1l1.562,0.215l0.647,0.28l0.692-0.132     l-0.066-0.33l-0.527-0.33v-0.561l0.297-0.23l0.846-0.242l4.292-0.858l2.92-0.172l3.058,0.115l2.296,1.076l1.316,0.023l0.741,0.144l0.023,0.383l-0.908,0.096l-0.168,0.454l1.723,0.216l4.892,0.646l5.571,0.453l1.546,0.172l1.717-0.172l7.556,0.688h5.323     l0.687,0.687l0.2,1.075l-0.73,1.232l-0.672,0.439l-0.425,1.113l-0.73,0.319l-0.905-0.402l-0.83,0.402l-0.73,0.959l1.507,0.457l0.594,0.045l0.959-0.593l0.411,0.365l-0.867,1.05l-1.215,0.062l-1.717,1.374v0.858l1.889,0.688h2.919l1.718-0.859l1.889-1.545     l1.717-1.717l1.374-0.688l4.121-1.03l2.231-0.687l3.263-0.344l2.061-1.03l1.03-1.03l3.435-1.03l2.403-0.687l2.061-0.687l2.061-0.172l6.182-0.687l3.778,0.171l1.204-0.542l0.169-0.659l0.54-0.759l0.49-0.101l0.471,0.776l0.305,0.775l4.892-0.35h5.838l4.979-0.172     l3.091,0.344l2.112-0.214l1.328,0.085l1.018,0.594l1.188-0.764l2.714-1.046l1.866-0.226l0.664-0.028l0.594-0.028l0.777-0.057l1.512,0.311l1.166-0.172l3.606,0.687l3.777,0.344h1.03l1.064,0.573l0.745,0.088l2.149-0.088l1.271-0.263l1.315-0.438l-0.192-0.216     l0.28-0.53l1.447-0.131l0.921-0.088l0.786,0.062l2.195-0.501l2.097,0.501l0.688,0.687l0.373,0.435l1.842-0.131l0.921-0.044l0.985,0.255l1.889,0.688l2.919,0.515l2.919-0.343l4.121-0.258l2.232-0.344h2.404l3.521,0.315l0.702-0.755l2.158-0.162l0.863,1.133     l4.909,0.323l0.917-1.133l1.889-0.593l5.988,0.013l0.756-0.283l1.996,0.108l-0.432-1.403l0.054-0.809l1.232-0.36l0.872,1.277l-0.647,1.079l0.805,0.219l2.81,0.482l5.262,0.376l5.494,0.344l2.278,0.583l1.283,0.14l1.396-0.167l2.204,0.446l1.961-0.167l0.719,0.278     l-0.435,0.431l-0.151,0.351l0.293,0.123l2.081,0.331l1.078,0.484l2.706-0.134l0.377,0.595l1.038,0.227l4.808,0.515l-0.123,0.536l0.567,0.236l2.695-0.095l3.214,0.181l-0.329-0.984l0.71-0.095l0.804,0.426l0.331,0.709l1.135,0.284l2.672,0.519l2.576-0.343     l4.017,0.999l1.626,0.495l1.672,0.871l1.626,0.023l0.504,0.187l0.532-0.021l0.754-0.047l0.777,0.047l0.896,0.589l0.541,0.118l0.542,0.07l0.142-0.259h0.471l1.484-0.048l1.416,0.237l5.951,0.535l0.729,0.516l1.733,0.323l2.979,0.944l0.43-0.335l0.551,0.191     l0.454,0.67l-0.741,0.215l-1.124,0.167l-0.216,0.359l0.168,0.263l0.55-0.048l-0.024,0.67l-0.43-0.048l-0.096,0.287l-0.312,0.071l-0.598,0.622l-0.526,0.12l-0.55,0.287l-0.168,0.669l-1.603,0.096l-1.339-0.239l-1.794,0.359l-2.153,0.425l-2.629,0.764l1.271,1.103     l-1.907,0.212l-1.23-0.255l-0.763,0.212l-0.043,0.637l-2.374,0.169l0.136,0.514l0.924,0.632l-0.127,0.763l-0.382,0.085l-0.466,0.467l0.551,0.466l0.085,0.764l-0.764,0.424l0.637,0.254h0.763l0.764,0.255l0.339,0.509l0.17,0.721l1.284-0.187l0.836,0.907     l2.035,0.297l0.339,0.339l2.672,0.552h-4.113l-2.799,0.138l-2.332,0.541l-1.823-0.085l-0.806,0.212l-1.611,0.339l-1.326-0.32l-0.546,0.426l1.116,0.529l-0.503,0.447l-0.669,0.195l-1.117,0.753l-2.623,0.642l0.475,0.391l2.205-0.111h0.53l0.809,0.307l0.168,0.363     l0.499,0.18l0.422,0.183l0.111,0.894l0.209,0.502l3.195,0.279l2.874,0.948l3.662,0.801l5.151,1.202l1.456,0.062l1.015,0.17l-0.146,0.234l-1.67,0.264l-0.47,0.264l1.173,0.088l2.198-0.293l1.988,0.166z'},
);

our %slovakia = (
	BA => {
			name => 'Bratislavsky kraj',
			d =>'M 118.45601,382.21594 C 120.60557,380.68783 125.96337,380.65246 129.63892,381.38757 C 131.80305,381.8204 133.95602,381.80176 136.26583,381.80176 C 138.33674,381.80176 140.40765,381.80176 142.47856,381.80176 C 143.90207,381.80176 146.10763,383.95157 147.44874,384.28685 C 148.05193,384.43764 149.83558,390.52076 149.93383,390.91376 C 150.42897,392.8943 151.0071,393.64375 152.41892,395.05558 C 154.03938,396.67603 154.47577,397.53364 156.14656,398.36903 C 156.20988,398.40069 156.5359,404.06822 156.56074,404.16758 C 156.98256,405.85485 160.13253,407.32518 161.11674,408.30939 C 161.93801,409.13066 162.52317,412.69256 162.77347,413.69376 C 163.28566,415.74254 163.86003,416.38328 164.4302,418.66394 C 164.88172,420.47005 164.4302,423.00396 164.4302,424.87667 C 164.4302,426.33327 161.55813,426.93397 160.70256,427.36176 C 158.31214,428.55697 161.66216,431.50358 158.21747,431.50358 C 155.92911,431.50358 153.96809,431.97154 152.41892,432.74612 C 151.56146,433.17486 150.94793,436.28802 150.34801,436.88794 C 148.79975,438.43621 147.03456,437.11465 147.03456,440.2014 C 147.03456,442.13943 143.60246,441.44394 142.06438,441.44394 C 141.41881,441.44394 139.30976,444.61274 138.75092,445.17158 C 138.13197,445.79053 138.75092,450.40018 138.75092,451.38431 C 138.75092,453.04678 135.2677,451.71361 133.78074,450.97013 C 132.12807,450.14379 130.92907,449.45265 129.63892,448.48504 C 128.05099,447.29408 127.54528,446.78284 126.73965,445.17158 C 126.08697,443.86622 126.73965,440.45676 126.73965,438.95885 C 126.73965,436.73295 125.20682,436.18348 124.25456,435.23122 C 122.53964,433.5163 121.27213,433.07715 120.11274,431.91776 C 118.94007,430.74509 118.25671,429.44824 117.62765,428.19012 C 116.84287,426.62056 115.795,425.76738 115.14256,424.46249 C 114.23172,422.64082 113.90001,422.02228 113.90001,419.49231 C 113.90001,417.05325 113.79453,415.55371 113.07165,414.10794 C 112.26243,412.4895 111.07193,410.66508 110.58656,408.72358 C 109.87186,405.8648 110.57256,405.81731 108.10146,404.58176 C 106.60322,403.83263 107.2731,400.18632 107.2731,399.19739 C 107.2731,397.60171 108.94636,395.40364 109.34401,393.81303 C 109.75801,392.15703 111.34947,391.39339 112.24328,390.49958 C 113.84957,388.89329 114.12091,389.2018 114.72837,386.77194 C 115.38727,384.13635 114.47755,383.29513 115.97092,381.80176 C 116.91082,380.86186 116.20382,381.31506 118.45601,382.21594 z'},
	
	TR => {
			name => 'Trnavsky kraj',
			d =>'M 123.84038,366.89121 C 124.66403,366.06755 127.96929,365.24739 129.22474,363.99194 C 129.84369,363.37299 129.22474,358.76334 129.22474,357.77921 C 129.22474,355.49317 131.35896,354.64119 132.53819,354.05157 C 133.22094,353.7102 135.02654,351.14578 135.43747,350.32393 C 136.25744,348.684 139.54666,349.08139 141.23601,349.08139 C 143.60722,349.08139 144.66694,348.66721 147.03456,348.66721 C 150.25086,348.66721 153.95378,351.44461 155.3182,352.80903 C 156.51877,354.0096 157.6029,355.09373 158.63165,356.12248 C 160.21767,357.7085 162.11269,356.87183 163.18765,359.02175 C 163.96777,360.58199 163.60183,362.96705 163.60183,364.8203 C 163.60183,366.91762 164.01602,368.25117 164.01602,370.61885 C 164.01602,373.05881 167.35153,373.9323 169.40038,373.9323 C 171.28088,373.9323 173.12158,372.69136 174.78474,372.27557 C 176.59085,371.82405 179.12476,372.27557 180.99747,372.27557 C 183.43506,372.27557 184.93168,373.31051 185.96765,374.34648 C 186.9381,375.31692 189.58021,375.14608 191.35202,375.58903 C 193.15812,376.04055 195.69204,375.58903 197.56475,375.58903 C 199.77372,375.58903 201.98269,375.58903 204.19166,375.58903 C 206.21695,375.58903 202.62669,378.776 202.12075,378.90248 C 200.41446,379.32905 198.13737,379.3806 196.73638,379.73085 C 195.43579,380.05599 193.72874,382.32431 193.00875,383.0443 C 191.58348,384.46956 191.7662,386.62727 191.7662,388.84285 C 191.7662,391.78656 191.87675,392.00448 193.83711,392.98467 C 195.66822,393.90022 198.94787,395.12587 200.46402,395.88394 C 201.44512,396.37449 199.4592,397.71713 197.97893,399.19739 C 196.69044,400.48588 196.22529,401.46212 195.49384,402.92503 C 194.73346,404.44579 195.49384,408.17323 195.49384,409.96612 C 195.49384,411.62859 192.92386,412.2068 192.18038,413.69376 C 191.13934,415.77583 192.1997,417.93219 192.59456,419.90649 C 192.98586,421.86295 193.42293,423.16702 193.42293,425.70503 C 193.42293,427.94533 191.94968,428.49773 190.93784,429.84685 C 189.91528,431.21026 187.44923,430.61133 186.38184,432.74612 C 185.60172,434.30636 185.96765,436.69142 185.96765,438.54467 C 185.96765,440.62667 190.6172,440.68453 190.94419,441.99247 C 191.4703,444.09693 190.07766,446.40776 192.18038,446.82831 C 193.08795,447.00982 192.59456,452.10454 192.59456,453.04104 C 192.59456,455.11194 192.59456,457.18285 192.59456,459.25376 C 192.59456,461.79206 191.7621,462.05052 189.69529,462.56722 C 186.80915,463.28875 187.2102,464.2049 187.2102,467.12322 C 187.2102,467.90911 183.35659,470.56265 183.06838,470.85086 C 181.80294,472.1163 182.06409,473.92605 180.99747,474.99267 C 179.43476,476.55538 179.55092,477.47777 176.85565,477.47777 C 173.39618,477.47777 175.21468,480.59201 172.29965,479.13449 C 171.01716,478.49324 170.75516,476.88455 168.15783,476.23522 C 165.07384,475.46422 164.06339,476.74415 162.77347,474.16431 C 161.85964,472.33665 161.47671,471.65211 159.8742,470.85086 C 158.4461,470.13681 158.18967,468.25457 157.80329,466.70904 C 157.5044,465.51348 155.18061,464.08636 154.48983,463.39558 C 153.14768,462.05342 152.92225,460.99963 151.59056,459.66795 C 150.39738,458.47477 149.51877,458.00945 148.69129,456.35449 C 148.35335,455.67861 145.29782,455.78028 144.54947,454.28358 C 143.70739,452.59942 142.58889,452.21267 140.40765,452.21267 C 138.91613,452.21267 137.92256,450.11934 137.92256,448.48504 C 137.92256,445.95506 140.06262,442.75645 141.37831,441.44076 C 142.28203,440.53705 144.69012,441.92691 146.07185,441.58148 C 147.37778,441.25499 147.10219,438.27271 147.72698,437.43966 C 148.93121,435.83401 149.97265,437.97521 150.7622,434.81703 C 151.35303,432.4537 150.28711,433.38541 152.83152,432.74931 C 154.9368,432.22299 157.29144,431.50358 159.46001,431.50358 C 160.58271,431.50358 160.42591,429.27103 160.42591,428.19331 C 160.42591,426.69995 164.4302,425.54166 164.4302,424.04831 C 164.4302,421.9774 164.4302,419.90649 164.4302,417.83558 C 164.4302,416.20289 162.83378,414.08204 162.49523,412.72786 C 161.99037,410.70839 162.13779,410.08822 161.11674,408.72358 C 159.99987,407.23087 160.42774,407.59896 158.21747,405.41012 C 156.8031,404.00947 156.00903,403.08515 156.00903,400.57589 C 156.00903,398.00489 155.27497,398.28258 154.48983,396.7123 C 153.76622,395.26508 152.31043,394.42441 151.59056,392.98467 C 150.88907,391.58168 149.71788,390.48185 149.10547,389.25703 C 148.36248,387.77105 148.4373,385.4356 147.86292,384.28685 C 147.07953,382.72006 143.8205,382.12969 142.89274,381.66581 C 141.17431,380.80659 139.43023,381.80494 137.50996,381.80494 C 135.43905,381.80494 133.36814,381.25163 131.29723,381.25163 C 129.22633,381.25163 125.21887,380.97499 123.14796,380.97499 C 121.07705,380.97499 120.66604,382.08159 118.59513,382.08159 C 115.71043,382.08159 115.97092,378.59126 115.97092,376.00321 C 115.97092,373.43581 117.72009,374.01274 119.69856,373.51812 C 120.93341,373.20941 119.38844,370.35972 120.52692,369.79048 C 122.45963,368.82413 122.01792,369.32116 123.84038,366.89121 z'},
	
	NT => {
			name => 'Nitriansky kraj',
			d =>'M 208.87167,365.4372 C 209.3323,366.25754 209.70163,367.8661 209.70163,369.58697 C 209.70163,370.36486 212.07631,372.15756 212.46814,372.35348 C 213.87952,373.05917 214.94752,373.66495 216.34125,374.01339 C 217.7819,374.37355 218.75577,374.56669 220.49102,374.56669 C 221.49387,374.56669 221.32098,376.99081 221.32098,377.88651 C 221.32098,379.26976 221.32098,380.65302 221.32098,382.03627 C 221.32098,383.85798 222.14795,384.51123 222.42758,385.90939 C 222.80293,387.78616 223.96571,387.78506 225.19409,388.39925 C 226.252,388.92821 228.14782,389.55266 229.06721,389.78251 C 230.37433,390.10929 231.78268,390.53054 233.21698,390.88911 C 233.86146,391.05023 236.28163,390.33581 237.36675,390.33581 C 238.75,390.33581 240.13326,390.33581 241.51652,390.33581 C 243.81638,390.33581 244.00638,390.6348 244.00638,392.82567 C 244.00638,394.30114 244.00638,395.77662 244.00638,397.25209 C 244.00638,398.69545 244.47504,400.23337 244.83633,401.67851 C 245.2949,403.51279 246.70949,405.39313 247.32619,406.93488 C 248.06406,408.77956 247.86177,409.27312 249.5394,410.53135 C 250.70777,411.40763 252.82914,411.63194 254.24247,411.91461 C 255.89092,412.24429 257.52052,412.19126 259.22219,412.19126 C 261.29021,412.19126 262.45862,412.14956 264.20192,413.02121 C 265.9214,413.88095 267.79838,413.62272 267.79838,415.51107 C 267.79838,416.77943 266.47225,418.60239 266.13847,419.93749 C 265.81905,421.2152 266.13847,423.03501 266.13847,424.36391 C 266.13847,425.74717 266.13847,427.13042 266.13847,428.51368 C 266.13847,429.23242 269.37227,430.01376 270.01159,430.17359 C 271.33202,430.50369 273.04004,430.72689 274.71466,430.72689 C 276.63304,430.72689 278.24675,430.84912 279.97104,431.28019 C 281.70043,431.71254 283.11025,432.7572 284.95076,433.4934 C 286.51459,434.11893 286.12679,434.80618 285.78071,436.53656 C 285.5323,437.7786 284.44545,438.42513 283.84415,439.02643 C 282.80564,440.06494 282.10416,440.84651 281.63094,441.79294 C 281.10987,442.83509 281.35429,444.42818 281.35429,445.66605 C 281.35429,447.41406 281.95012,448.70922 279.97104,448.70922 C 278.78085,448.70922 277.45143,449.26252 275.82127,449.26252 C 274.43801,449.26252 273.05476,449.26252 271.6715,449.26252 C 270.05474,449.26252 269.12015,449.55454 268.07503,449.81582 C 267.64277,449.92389 267.79838,452.99364 267.79838,453.68894 C 267.79838,455.26233 267.37504,456.32549 266.69178,457.00875 C 266.00231,457.69822 264.43465,457.60597 263.64861,458.39201 C 263.23519,458.80544 263.64861,461.88443 263.64861,462.54178 C 263.64861,463.98535 263.602,465.3985 263.92527,466.69155 C 264.06884,467.26584 266.46084,469.48092 266.96843,469.73471 C 268.68568,470.59334 268.87327,468.9638 269.73494,471.11797 C 270.24754,472.39946 269.43377,474.21016 269.18164,474.71443 C 268.75297,475.57177 266.29103,475.36792 265.58517,475.54439 C 264.18065,475.89552 263.16354,476.08063 261.98871,476.37434 C 260.73794,476.68703 260.35305,477.98575 259.7755,479.14085 C 259.28637,480.11911 257.68215,480.49414 256.45568,480.80076 C 254.97628,481.17061 254.00336,482.45128 252.85922,482.73732 C 251.56914,483.05984 250.15052,483.01397 248.70945,483.01397 C 247.41237,483.01397 246.07382,483.56727 244.83633,483.56727 C 243.33034,483.56727 242.00067,483.84392 240.40991,483.84392 C 238.84222,483.84392 237.27453,483.84392 235.70684,483.84392 C 233.82624,483.84392 231.89515,483.77631 230.17382,484.12057 C 228.73267,484.4088 227.38241,485.24585 226.3007,486.05713 C 225.39328,486.7377 223.10538,486.61044 221.87428,486.61044 C 220.4607,486.61044 219.04099,486.62713 218.00116,486.88709 C 216.7218,487.20693 214.89121,486.88709 213.57474,486.88709 C 212.13693,486.88709 210.45479,486.86789 209.42497,486.61044 C 208.19301,486.30244 207.61437,485.81197 206.38181,485.50383 C 205.23796,485.21787 204.38846,484.39723 202.78535,484.39723 C 201.30987,484.39723 199.8344,484.39723 198.35893,484.39723 C 196.87767,484.39723 195.31259,484.39802 194.20916,484.67388 C 192.87797,485.00667 192.13949,485.22718 190.61269,485.22718 C 189.22944,485.22718 187.84618,485.22718 186.46292,485.22718 C 184.71631,485.22718 183.65395,485.00908 182.31315,484.67388 C 180.74316,484.28138 179.82189,484.39583 178.99334,483.56727 C 178.0711,482.64503 177.25721,482.38445 176.50348,481.63071 C 175.61222,480.73945 175.31131,479.85672 174.56692,478.8642 C 173.19698,477.03761 176.16848,477.20429 177.05678,477.20429 C 178.3459,477.20429 179.44354,477.03073 180.09994,476.37434 C 180.94519,475.52909 180.4941,473.76697 181.20655,473.05453 C 181.98985,472.27123 183.25375,471.28398 183.97306,470.56466 C 184.81831,469.71942 185.19718,469.0639 185.90962,468.35145 C 186.57681,467.68427 186.46292,466.07447 186.46292,464.75499 C 186.46292,463.69021 187.82353,462.96808 188.67613,462.54178 C 190.28489,461.7374 191.24546,463.05385 191.71929,461.15852 C 191.97647,460.12984 191.68779,458.24137 191.99595,457.00875 C 192.29754,455.80237 191.99595,454.10985 191.99595,452.85899 C 191.99595,451.47573 191.99595,450.09247 191.99595,448.70922 C 191.99595,447.18469 191.75844,446.37593 191.44265,445.11275 C 191.14775,443.93317 190.61269,443.55753 190.61269,441.79294 C 190.61269,441.78834 188.60552,441.16903 188.39948,440.96299 C 187.48422,440.04773 185.89318,440.10016 185.35631,439.02643 C 184.93694,438.18767 186.18627,434.78669 186.18627,433.21675 C 186.18627,431.39403 186.93594,431.64608 188.39948,431.28019 C 189.05897,431.11532 191.05496,430.28462 191.44264,429.89693 C 192.27096,429.06861 191.90392,427.86777 192.2726,427.13042 C 192.73868,426.19825 193.10255,423.73949 193.10255,422.42735 C 193.10255,421.0441 192.2726,419.66084 192.2726,418.27758 C 192.2726,416.89433 192.2726,415.51107 192.2726,414.12782 C 192.2726,412.46989 193.69138,412.70902 194.4858,411.9146 C 195.41686,410.98355 195.03911,410.60277 195.03911,408.59479 C 195.03911,407.21153 195.03911,405.82828 195.03911,404.44502 C 195.03911,402.85759 196.26562,402.26865 196.69901,401.40186 C 197.20143,400.39702 197.16188,399.55574 197.80562,398.912 C 198.64638,398.07124 199.36066,398.01513 200.01883,396.69879 C 200.49198,395.7525 198.81106,395.40327 198.08227,395.03888 C 197.14142,394.56845 195.30308,394.06426 194.48581,393.65562 C 193.37021,393.09782 193.9625,392.00322 192.8259,391.71907 C 191.96351,391.50347 191.44265,389.91674 191.44265,388.95255 C 191.44265,387.5693 191.44265,386.18604 191.44265,384.80279 C 191.44265,383.23819 193.63542,383.46041 194.20916,382.31292 C 194.74571,381.23983 194.26046,380.36354 195.31576,380.09972 C 196.54139,379.79331 197.86588,379.808 198.91223,379.54641 C 200.20918,379.22217 200.56835,378.71646 202.23204,378.71646 C 202.94964,378.71646 203.98289,376.87467 204.1686,376.50325 C 204.61511,375.61024 204.44525,373.93362 204.44525,372.63013 C 204.44525,372.03394 205.5766,370.36743 205.82851,369.86362 C 206.42942,368.6618 207.1327,368.79662 207.48842,367.37376 C 207.6777,366.61661 208.26055,366.04832 208.87167,365.4372 z'},
	
	TE => {
			name => 'Trenciansky kraj',
			d =>'M 163.50087,350.77469 C 164.12163,350.77469 166.46666,350.77469 167.92729,350.77469 C 169.63207,350.77469 170.72406,351.02108 171.80041,349.94473 C 172.64565,349.09949 172.19457,347.61401 172.90701,346.90157 C 173.56647,346.24212 176.30453,347.17822 177.05678,347.17822 C 178.53225,347.17822 180.00773,347.17822 181.4832,347.17822 C 182.92033,347.17822 184.61086,347.1571 185.63297,346.90157 C 185.77656,346.86567 185.63297,343.12657 185.63297,342.7518 C 185.63297,342.19827 187.83669,341.37803 188.12283,341.09189 C 189.43808,339.77664 187.54797,338.87868 190.33604,338.87868 C 191.8713,338.87868 193.33892,339.43199 195.03911,339.43199 C 196.16344,339.43199 197.82553,338.86873 198.35893,338.60203 C 199.52539,338.0188 198.329,335.89538 198.91223,334.72891 C 199.37228,333.80881 200.01883,333.87028 200.01883,331.68575 C 200.01883,330.3025 200.01883,328.91924 200.01883,327.53598 C 200.01883,326.86939 203.82349,326.0837 204.1686,326.15272 C 205.43319,326.40564 206.74728,327.53598 208.04172,327.53598 C 210.13593,327.53598 208.16917,325.55593 207.76507,323.93951 C 207.21802,321.75133 208.65825,321.77966 209.97828,321.44965 C 210.9481,321.2072 211.95744,320.23681 211.91484,320.0664 C 211.58,318.72705 211.63818,317.66671 211.63818,316.19328 C 211.63818,314.81003 211.63818,313.42677 211.63818,312.04351 C 211.63818,310.56804 211.63818,309.09257 211.63818,307.6171 C 211.63818,306.42093 213.4109,305.44485 214.68135,305.12723 C 216.62292,304.64184 216.34125,304.91438 216.34125,302.63737 C 216.34125,300.83298 215.85513,299.99239 217.44786,299.59421 C 218.65424,299.29261 220.34676,299.59421 221.59763,299.59421 C 223.26393,299.59421 224.35759,299.31919 225.47075,299.04091 C 225.92257,298.92795 227.31233,296.92267 227.68396,296.55105 C 228.62842,295.60658 229.62295,295.72109 231.28042,295.72109 C 232.96855,295.72109 234.04693,295.2835 234.04693,297.10435 C 234.04693,298.4876 234.04693,299.87086 234.04693,301.25412 C 234.04693,302.21675 236.27501,303.05607 236.81345,303.19068 C 237.84841,303.44942 236.57296,306.36584 236.53679,306.51049 C 236.05569,308.43491 236.48742,308.67433 237.36675,309.55365 C 238.27838,310.46529 239.14666,310.54277 240.40991,311.49021 C 241.60588,312.38719 241.51652,312.39983 241.51652,314.53338 C 241.51652,314.98384 245.08876,315.56476 245.38963,315.63998 C 246.79567,315.99149 247.82361,316.52306 248.15615,317.85319 C 248.49168,319.19533 248.4328,320.77149 248.4328,322.27961 C 248.4328,323.88734 248.9861,325.39852 248.9861,326.98268 C 248.9861,328.36594 248.9861,329.74919 248.9861,331.13245 C 248.9861,333.21017 248.15615,333.22217 248.15615,334.72891 C 248.15615,336.39911 246.67276,335.73539 248.15615,337.21878 C 249.29441,338.35704 249.9031,338.78388 251.19931,339.43199 C 252.80381,340.23423 253.86974,337.88638 255.62573,338.32538 C 257.43466,338.77761 256.73233,341.51459 256.73233,343.58175 C 256.73233,345.53125 256.70182,346.32538 257.83894,347.17822 C 258.9301,347.99659 259.87077,349.21006 260.8821,350.22138 C 261.96986,351.30914 261.71206,352.69629 261.71206,354.37115 C 261.71206,356.01797 261.98167,357.39672 262.54201,358.79757 C 262.99629,359.93328 264.29399,360.18083 265.58517,360.18083 C 267.23381,360.18083 264.99805,362.80596 264.75522,363.77729 C 264.61127,364.35309 265.12892,363.66575 264.75522,365.16055 C 264.43228,366.45232 263.84295,366.86161 262.81866,367.37376 C 261.51131,368.02743 260.87704,368.34457 259.49885,369.03367 C 258.53657,369.5148 258.62507,371.14551 258.39224,372.07683 C 257.96878,373.77066 257.51765,373.89738 256.17903,374.56669 C 255.16041,375.076 253.26124,374.78065 252.58256,375.11999 C 251.66028,375.58113 251.02563,377.68055 250.64601,378.43981 C 250.05275,379.62632 250.84838,381.63153 250.36936,382.58958 C 250.04153,383.24523 247.19843,382.86623 246.49624,382.86623 C 244.93457,382.86623 243.67575,382.89321 242.62312,383.41953 C 240.97635,384.24292 241.51652,383.77051 241.51652,386.18604 C 241.51652,387.69884 239.85661,387.62595 239.85661,389.22921 C 239.85661,390.18502 238.37909,389.19395 237.64339,389.78251 C 236.26014,390.88911 233.77028,391.16577 232.38702,391.16577 C 231.00377,391.16577 229.34386,389.78251 227.96061,389.78251 C 226.19992,389.78251 225.62671,389.03054 224.36414,388.39925 C 223.34829,387.89133 223.90748,387.94258 223.25754,387.29264 C 222.73591,386.77101 221.4452,385.72468 221.87427,385.07943 C 222.67851,383.86998 221.30682,381.1497 221.04432,380.09972 C 220.74273,378.89333 221.04432,376.37086 221.04432,375.12 C 221.04432,374.72392 218.59755,374.58823 217.44786,374.01339 C 216.72582,373.65237 215.44684,374.11949 214.68135,373.73674 C 213.75,373.27106 212.40476,372.06098 211.36154,371.80017 C 210.15607,371.49881 209.94952,369.71091 209.14832,369.31032 C 209.09456,369.28344 209.17584,365.49225 209.14832,365.4372 C 208.72372,364.588 207.6079,369.03366 206.65846,369.03366 C 205.44997,369.03366 205.75769,370.21109 205.2752,370.69357 C 204.7772,371.19158 204.62086,373.86425 204.44525,374.56669 C 203.90221,376.73885 204.03935,375.39664 201.67874,375.39664 C 200.29548,375.39664 198.91223,375.39664 197.52897,375.39664 C 196.14572,375.39664 194.76246,375.39664 193.3792,375.39664 C 191.99595,375.39664 190.61269,375.39664 189.22944,375.39664 C 188.06479,375.39664 186.54607,374.88492 185.90962,374.56669 C 184.90656,374.06516 184.31306,372.80013 183.41976,372.35348 C 182.52675,371.90697 180.85013,372.07683 179.54664,372.07683 C 178.47485,372.07683 178.40384,372.07683 176.50348,372.07683 C 175.10051,372.07683 173.92353,372.63013 172.35371,372.63013 C 170.66092,372.63013 170.58098,373.46009 168.75724,373.46009 C 167.34367,373.46009 165.92396,373.44339 164.88413,373.18343 C 164.10964,372.98981 164.61032,371.25256 164.33083,370.69357 C 163.89487,369.82166 163.50087,367.82098 163.50087,366.82046 C 163.50087,365.49892 164.00324,363.85022 163.77752,362.94734 C 163.4549,361.65688 163.50087,360.57304 163.50087,359.07422 C 163.50087,357.95824 160.54147,357.49808 159.90441,356.86101 C 158.77174,355.72835 159.05565,355.33473 157.41454,354.92445 C 156.36278,354.66151 155.99442,353.39373 155.75464,352.43459 C 155.36472,350.87494 157.35482,351.05134 158.52115,351.05134 C 160.19377,351.05134 161.87519,351.18111 163.50087,350.77469 z'},
	
	BB => {
			name => 'Banskobystricky kraj',
			d =>'M 381.72189,347.04178 C 381.72189,348.74204 378.41659,348.38498 377.39643,349.74519 C 376.79997,350.54047 374.97429,351.49695 374.15233,351.90792 C 373.18343,352.39238 372.24864,353.81162 371.71926,354.341 C 370.79526,355.26499 369.55653,357.65977 369.55653,358.9368 C 369.55653,361.27976 369.82687,364.16339 369.82687,366.50635 C 369.82687,368.04876 371.78938,368.46886 372.53028,369.20977 C 373.2567,369.93619 375.71358,370.12556 376.5854,370.56147 C 377.65491,371.09623 378.27421,373.12805 378.74813,374.07591 C 379.23263,375.0449 379.075,376.62204 379.55916,377.59035 C 380.11492,378.70187 381.28946,379.8073 382.26257,381.10478 C 383.24667,382.41692 383.50932,383.65871 383.88462,385.1599 C 384.23641,386.56708 384.4253,387.62708 384.4253,389.21502 C 384.4253,391.10741 384.4253,392.9998 384.4253,394.89219 C 384.4253,396.51424 384.4253,398.13628 384.4253,399.75833 C 384.4253,401.15449 385.36631,401.38038 386.85837,401.38038 C 388.46095,401.38038 388.37744,400.39234 389.83213,400.02867 C 391.01099,399.73396 392.66491,400.02867 393.88725,400.02867 C 395.75096,400.02867 396.26387,399.97223 397.13134,400.8397 C 397.53534,401.24369 397.13134,404.25246 397.13134,404.89482 C 397.13134,406.79257 397.00349,407.1854 396.04998,408.13891 C 395.10254,409.08635 396.08424,409.69243 395.23895,411.383 C 394.71766,412.42558 393.03861,413.97006 392.2652,414.35676 C 391.82941,414.57466 390.43837,416.25724 390.37281,416.51949 C 390.04024,417.84978 389.54306,418.16026 388.75076,418.95256 C 388.38352,419.31981 385.07756,419.14652 384.69564,419.2229 C 383.24868,419.5123 381.74224,419.15023 380.37018,419.49324 C 378.73686,419.90157 378.20745,419.35122 378.20745,421.38563 C 378.20745,423.27604 378.09317,423.44176 376.5854,423.81871 C 375.31867,424.13539 374.5525,424.49991 373.88199,425.17041 C 372.91672,426.13569 372.53028,426.6487 372.53028,428.41451 C 372.53028,429.84443 370.58983,429.79025 369.55653,430.3069 C 368.25526,430.95753 367.46507,431.02289 366.58278,432.19929 C 365.66023,433.42935 365.61859,434.51518 364.69039,435.44338 C 363.54605,436.58772 363.06513,436.93106 361.44629,437.33577 C 360.17131,437.65451 358.46838,437.60715 357.39117,437.87645 C 355.82968,438.26683 355.65361,439.15074 354.41742,439.76884 C 353.215,440.37005 352.01566,438.97347 351.44366,438.68748 C 350.23824,438.08476 350.04676,437.39206 348.74025,437.06543 C 347.75393,436.81885 346.27128,435.13714 345.7665,434.63236 C 344.95208,433.81794 343.8807,433.28724 343.06308,432.46963 C 342.32671,431.73325 341.23897,431.69274 340.08933,431.11792 C 338.5917,430.3691 337.87463,429.12159 337.38592,428.14417 C 336.76616,426.90464 336.60173,426.53554 335.49353,425.98144 C 334.26307,425.3662 332.2435,425.71109 330.89773,425.71109 C 329.45247,425.71109 327.91124,425.71428 326.84261,425.98144 C 325.78039,426.24699 325.42022,428.15656 325.22056,428.95519 C 324.72043,430.95573 325.65842,431.03416 323.86885,431.92894 C 322.64992,432.53841 321.73764,433.53523 320.62476,434.09167 C 319.34982,434.72914 319.27305,435.12645 319.27305,436.79509 C 319.27305,438.23691 319.27305,439.67873 319.27305,441.12055 C 319.27305,442.58498 318.60461,443.53879 318.19169,444.36464 C 318.13772,444.47257 313.99063,444.5363 313.59589,444.63498 C 312.41702,444.9297 310.7631,444.63498 309.54077,444.63498 C 308.05794,444.63498 306.54147,444.64009 305.21531,444.90533 C 303.14674,445.31904 302.95763,445.09522 301.97121,447.06806 C 301.58475,447.84097 299.73898,448.23438 298.99746,448.41976 C 297.72264,448.73847 296.35284,448.6901 294.94234,448.6901 C 293.59063,448.6901 292.23892,448.6901 290.88722,448.6901 C 289.3395,448.6901 288.64781,448.41976 287.10244,448.41976 C 285.75073,448.41976 284.39903,448.41976 283.04732,448.41976 C 281.34983,448.41976 281.42528,449.48152 281.42528,447.60874 C 281.42528,446.20448 280.84258,445.34371 281.15493,444.09431 C 281.39276,443.14297 282.11224,441.36865 282.50664,440.57986 C 282.86856,439.85603 284.08454,438.97989 284.66937,438.68748 C 285.48407,438.28012 285.77989,436.67846 286.02107,435.71372 C 286.3547,434.37921 285.15221,434.30418 284.39903,433.55099 C 283.80725,432.95922 282.45049,432.57672 281.69561,432.19929 C 280.609,431.65598 280.151,431.13728 278.9922,430.84758 C 277.66746,430.51639 277.68961,430.84758 275.74811,430.84758 C 274.36677,430.84758 272.97944,430.83127 271.96333,430.57724 C 270.78446,430.28253 269.13055,429.49587 267.90821,429.49587 C 266.42054,429.49587 267.35234,429.75103 266.55651,428.95519 C 266.15251,428.5512 266.01582,425.54243 266.01582,424.90008 C 266.01582,423.54837 265.74548,423.00768 265.74548,421.65598 C 265.74548,419.54507 266.33274,419.84763 266.82685,417.87119 C 267.0475,416.98858 266.89225,415.37272 267.36753,414.89744 C 268.13746,414.12751 265.1637,414.31567 264.39377,413.54574 C 263.63364,412.7856 263.24067,413.20366 262.50138,412.46437 C 261.86919,411.83218 259.68126,412.11104 258.44626,412.19403 C 254.42322,412.46437 255.89431,412.19403 254.66149,412.19403 C 252.99538,412.19403 251.68212,410.57058 250.60637,410.30164 C 249.83509,410.10882 248.3021,408.47366 247.63261,408.13891 C 246.45786,407.55153 247.92843,407.35336 246.82159,406.24652 C 246.27764,405.70257 244.65886,403.19895 244.65886,402.1914 C 244.65886,400.8397 244.65886,399.48799 244.65886,398.13628 C 244.65886,396.78458 244.65886,395.43287 244.65886,394.08116 C 244.65886,392.55229 243.9666,391.98668 243.30715,391.10741 C 242.63726,390.21422 240.9671,390.11732 240.06306,389.7557 C 238.65507,389.19251 240.02915,389.0125 240.60374,387.86331 C 241.07977,386.91126 240.5031,386.3735 240.87408,384.88956 C 241.24876,383.39083 241.71472,382.99717 243.30715,382.99717 C 244.65886,382.99717 246.01057,382.99717 247.36227,382.99717 C 249.30699,382.99717 249.97579,383.08706 250.87671,382.18615 C 251.32156,381.74129 250.87671,378.60484 250.87671,377.86069 C 250.87671,376.25722 251.188,375.65701 251.95807,374.88693 C 252.59231,374.2527 255.06946,374.61659 256.01319,374.61659 C 257.28656,374.61659 257.93571,373.77544 258.71661,372.99454 C 259.54936,372.16179 259.52763,370.77625 259.52763,369.48011 C 259.52763,368.26849 260.85747,367.79594 261.69036,367.58772 C 263.18479,367.21411 263.68182,366.91494 264.39377,365.96567 C 265.24835,364.82624 265.29384,364.61396 267.09719,364.61396 C 268.64552,364.61396 269.4845,364.80528 270.88196,365.15465 C 272.04191,365.44463 273.62128,367.31738 274.93708,367.31738 C 276.28879,367.31738 277.37015,365.42499 278.72186,365.42499 C 280.29645,365.42499 280.24695,364.52727 281.15493,364.07329 C 282.07568,363.61291 283.04732,362.81728 283.04732,361.64021 C 283.04732,360.2885 283.04732,358.9368 283.04732,357.58509 C 283.04732,356.08683 283.08584,354.80465 283.588,353.80031 C 284.22918,352.51796 283.45778,353.08943 284.93971,352.71895 C 286.21453,352.40024 288.93603,351.90792 290.34654,351.90792 C 291.77791,351.90792 293.02294,351.91468 294.13131,351.63758 C 295.45408,351.30689 296.59027,352.49678 297.37541,351.90793 C 298.19554,351.29283 300.6399,351.63759 301.70087,351.63759 C 303.14269,351.63759 302.96246,349.7452 304.40428,349.7452 C 304.77518,349.7452 306.93773,347.9224 307.10769,347.58246 C 307.69492,346.40801 308.61111,346.07905 309.27042,345.41973 C 310.20719,344.48297 310.84396,344.14774 312.24418,343.79769 C 313.79954,343.40885 314.92322,343.58629 316.56964,343.257 C 318.02306,342.96632 319.51937,343.3306 320.8951,342.98666 C 322.40313,342.60966 323.44963,342.44598 324.95022,342.44598 C 326.07082,342.44598 326.66687,343.25701 328.19431,343.25701 C 329.70073,343.25701 333.30818,343.52169 334.41217,343.79769 C 336.00137,344.19499 334.95285,343.7095 334.95285,345.41973 C 334.95285,346.41863 335.47927,348.65671 336.03421,348.93418 C 337.0443,349.43922 339.6961,348.66383 340.90036,348.66383 C 342.5224,348.66383 345.22581,348.66383 346.84786,348.66383 C 348.58233,348.66383 349.50322,348.39349 351.17332,348.39349 C 352.52503,348.39349 353.87674,348.39349 355.22844,348.39349 C 356.58015,348.39349 357.93186,348.39349 359.28356,348.39349 C 360.74974,348.39349 362.33848,348.12315 364.1497,348.12315 C 366.04209,348.12315 367.93448,348.12315 369.82687,348.12315 C 371.26869,348.12315 372.71051,348.12315 374.15233,348.12315 C 375.44905,348.12315 376.47086,347.6111 377.66677,347.31212 C 378.91532,346.99998 380.30686,347.04178 381.72189,347.04178 z'},
	
	ZI => {
			name => 'Zilinsky kraj',
			d =>'M 236.54862,287.02602 C 237.81613,286.84726 239.20576,287.03758 240.3334,286.75568 C 241.4699,286.47155 240.04927,284.37774 240.3334,283.24124 C 240.66908,281.89849 241.694,282.15987 243.30715,282.15987 C 245.32126,282.15987 244.9292,281.59685 244.9292,279.7268 C 244.9292,277.92816 244.60172,277.17285 246.28091,276.75305 C 247.72997,276.39078 249.08612,276.79518 250.33603,276.48271 C 251.25736,276.25237 251.47347,275.18457 252.7691,274.86066 C 254.11308,274.52467 255.95737,274.86066 257.3649,274.86066 C 258.80672,274.86066 260.24854,274.86066 261.69036,274.86066 C 263.12473,274.86066 264.35106,275.14168 265.47514,274.86066 C 267.13831,274.44487 267.67901,274.00849 268.44889,273.23861 C 269.12474,272.56276 269.12474,271.21105 269.8006,270.5352 C 270.62343,269.71236 273.43542,270.5352 274.66674,270.5352 C 276.06435,270.5352 277.48324,270.49589 278.72186,270.80554 C 279.99917,271.12487 279.53288,272.60934 279.53288,274.04964 C 279.53288,275.58157 279.53288,277.1135 279.53288,278.64544 C 279.53288,280.07681 279.52613,281.32185 279.80323,282.43022 C 280.1014,283.62291 281.09622,284.74585 281.42527,285.40397 C 281.8896,286.33262 283.60662,286.21965 284.66937,286.48533 C 285.93492,286.80172 286.88107,286.97068 288.18381,287.29636 C 289.80297,287.70115 290.96449,288.10738 292.77961,288.10738 C 294.44642,288.10738 294.95958,287.8198 295.75336,287.02602 C 296.73009,286.04929 296.50107,285.11655 296.83473,283.78192 C 297.25698,282.0929 297.57957,282.43022 299.53814,282.43022 C 300.47767,282.43022 300.07882,279.58028 300.07882,278.64544 C 300.07882,277.29373 300.07882,275.94202 300.07882,274.59032 C 300.07882,272.93956 301.13355,272.70459 302.24155,272.42759 C 303.25929,272.17315 303.96862,271.38755 305.21531,271.07588 C 306.39417,270.78117 308.04809,271.07588 309.27042,271.07588 C 310.75692,271.07588 310.84952,270.16633 311.16281,268.91315 C 311.41269,267.91365 312.12975,266.97928 312.51452,266.20974 C 312.56456,266.10966 315.55038,265.87729 315.75862,265.66906 C 317.13164,264.29604 315.18195,263.50633 317.92135,263.50633 C 319.80347,263.50633 320.35442,263.12794 320.35442,265.12837 C 320.35442,266.92805 320.85206,267.2911 322.51715,267.2911 C 323.51482,267.2911 323.59851,269.89083 323.59851,270.80554 C 323.59851,272.11812 324.69216,272.72249 325.22056,273.77929 C 325.69593,274.73004 325.79204,276.06523 326.03158,277.02339 C 326.23938,277.85459 328.07646,278.45134 329.00534,278.91578 C 330.09132,279.45877 330.80963,280.24014 331.43841,281.07851 C 332.40075,282.36164 332.63238,282.29053 334.68251,282.70056 C 336.27099,283.01825 335.93317,283.64808 336.30455,285.13363 C 336.41786,285.58686 339.73607,286.34403 340.08933,286.48533 C 341.24124,286.9461 342.34249,289.09879 343.06309,289.45909 C 343.20559,289.53034 344.61204,290.39426 344.68513,290.54045 C 345.16694,291.50406 345.7665,292.77964 345.7665,294.32523 C 345.7665,295.91341 346.30718,296.89131 346.30718,298.65069 C 346.30718,300.0024 346.30718,301.35411 346.30718,302.70581 C 346.30718,304.1931 346.03632,305.14096 345.7665,306.22025 C 345.35136,307.88078 346.21179,308.55793 346.84786,309.194 C 347.76364,310.10977 347.97646,310.48993 349.28093,310.81605 C 350.95892,311.23555 351.26921,311.7842 351.71401,310.00503 C 352.17994,308.14131 352.91037,307.51446 354.41742,306.76093 C 355.40883,306.26522 358.05781,306.79242 359.01322,307.03127 C 359.76612,307.2195 359.5539,308.87643 359.5539,310.27537 C 359.5539,312.02795 360.09459,313.58602 360.09459,315.41185 C 360.09459,318.50469 361.71663,321.11742 361.71663,324.33311 C 361.71663,326.07269 361.77688,328.41761 361.44629,329.73994 C 361.24479,330.54594 359.81922,330.07912 359.01322,330.28062 C 357.77687,330.58971 359.04247,332.92554 358.47254,334.0654 C 357.77837,335.45373 356.47812,334.74387 356.03947,336.49847 C 355.77358,337.56202 358.30302,336.54888 359.28356,337.03915 C 360.862,337.82837 360.63527,337.4626 360.63527,339.74257 C 360.63527,341.18509 360.90561,342.32018 360.90561,343.79769 C 360.90561,345.58839 360.79668,346.33968 359.82424,347.31212 C 358.98006,348.15631 357.6407,348.12835 356.58015,348.39349 C 355.4202,348.68348 354.11117,348.66383 352.79537,348.66383 C 351.16663,348.66383 349.38048,348.93417 347.65889,348.93417 C 345.85661,348.93417 344.05434,348.93417 342.25206,348.93417 C 340.17944,348.93417 338.10683,348.93417 336.03421,348.93417 C 334.43363,348.93417 336.40928,345.7948 335.49353,344.87905 C 334.64416,344.02968 332.78693,343.65534 331.43841,343.257 C 329.45656,342.67159 328.57975,343.91279 327.92397,343.257 C 327.0201,342.35313 324.73296,342.44598 323.32817,342.44598 C 321.61601,342.44598 319.90385,342.44598 318.19169,342.44598 C 316.78743,342.44598 315.38597,342.40397 314.13657,342.71632 C 312.72894,343.06823 311.85948,343.85486 310.89247,344.33837 C 309.63762,344.96579 308.87176,345.34873 307.64838,345.96042 C 306.81481,346.3772 305.82302,348.05612 305.21531,348.66383 C 304.2212,349.65793 304.38228,349.75619 302.78223,350.55622 C 301.45147,351.2216 301.48415,351.63758 299.53814,351.63758 C 298.01316,351.63758 296.69691,351.61002 295.48302,351.36724 C 294.14032,351.0987 292.91555,351.0969 291.69824,351.0969 C 290.11712,351.0969 288.53457,351.00921 287.10244,351.36724 C 285.8178,351.6884 284.69725,352.93352 284.12869,354.07066 C 283.40584,355.51635 283.04732,356.70316 283.04732,358.39612 C 283.04732,359.79373 283.08663,361.21262 282.77698,362.45123 C 282.54381,363.38393 280.56915,364.78296 280.07357,365.15465 C 279.14849,365.84846 277.39544,366.29728 276.55913,366.50635 C 275.2793,366.82631 273.2657,367.04704 274.93708,367.04704 C 275.99677,367.04704 270.81546,364.93527 269.53026,364.61397 C 268.46993,364.34889 267.68623,365.15465 266.01582,365.15465 C 264.16614,365.15465 264.5466,363.69122 264.93445,362.72158 C 265.55322,361.17467 265.09191,360.44596 264.39377,359.74782 C 263.23606,358.59011 262.90346,359.74095 261.9607,357.85543 C 261.46918,356.8724 261.42726,355.72166 261.14968,354.61134 C 260.85496,353.43247 261.14968,351.77856 261.14968,350.55622 C 261.14968,350.25758 259.07971,349.11572 258.71661,348.93417 C 257.67123,348.41148 257.36625,347.58788 257.09456,346.5011 C 256.78311,345.25529 256.28353,344.7513 256.28353,342.98666 C 256.28353,341.69527 256.23376,340.08417 256.01319,339.20188 C 255.76158,338.19541 253.42914,339.00704 253.03944,339.20188 C 251.77962,339.83179 250.43942,340.2197 250.06569,339.47223 C 249.77412,338.88909 248.12995,337.53649 248.1733,335.41711 C 248.19216,334.49528 248.44363,333.46239 248.44363,332.17301 C 248.44363,330.8213 249.79534,329.19926 249.79534,327.84755 C 249.79534,326.49584 248.95849,325.14389 248.98432,323.79243 C 249.03082,321.35936 247.72592,321.08902 247.63261,319.73731 C 247.51737,318.06797 247.30719,317.46443 246.82159,316.49322 C 246.38573,315.6215 245.22593,316.24927 244.65886,315.6822 C 243.94332,314.96666 242.61775,315.76067 241.95546,315.1415 C 240.27787,313.57316 241.41062,312.69187 241.14442,311.62708 C 240.98214,310.97795 238.06916,309.41359 237.62999,309.194 C 236.9566,308.85731 236.36396,307.47298 236.00794,306.76093 C 235.53688,305.81882 237.27873,305.89659 237.35965,304.05752 C 237.41554,302.7874 234.69093,303.11493 234.38589,301.89479 C 234.08951,300.70928 234.06665,296.83303 233.84521,295.94728 C 233.63697,295.11434 232.42001,294.25174 231.95282,293.78455 C 231.54882,293.38055 231.95282,290.37178 231.95282,289.72943 C 231.95282,288.40653 233.06351,288.07805 233.84521,287.29636 C 234.48559,286.65598 235.66058,287.20363 236.54862,287.02602 z'},
	
	KE => {
			name => 'Kosicky kraj',
			d =>'M 390.64315,334.60608 C 391.4877,334.60084 393.60831,335.41539 394.96861,335.68745 C 396.78289,336.0503 397.91885,336.35742 399.56441,336.76881 C 401.24828,337.18978 402.06992,337.8864 403.07885,338.39086 C 404.38947,339.04617 404.89188,339.74257 406.59329,339.74257 C 407.94499,339.74257 409.2967,339.74257 410.64841,339.74257 C 411.89029,339.74257 412.5477,338.38395 413.35182,337.57984 C 414.65419,336.27747 414.05322,335.87743 415.51455,335.14677 C 416.60592,334.60108 418.54136,335.43037 419.56967,335.68745 C 420.97196,336.03802 422.84184,336.07716 423.89513,336.49847 C 425.56618,337.16689 426.16835,336.39974 426.59854,338.12052 C 426.84823,339.11928 428.74889,339.20188 429.84264,339.20188 C 431.28446,339.20188 432.72628,339.20188 434.1681,339.20188 C 435.07797,339.20188 435.24946,341.61468 435.24946,342.44598 C 435.24946,343.24277 438.28185,343.87993 439.03424,344.06803 C 440.24694,344.3712 441.39062,344.79229 442.81902,345.14939 C 444.32193,345.52512 444.82377,346.0166 445.79277,346.5011 C 446.6448,346.92711 448.87019,346.5011 449.84789,346.5011 C 451.3227,346.5011 452.63909,347.35601 453.63267,347.85281 C 455.06216,348.56755 454.98438,348.94134 454.98438,350.82656 C 454.98438,352.50975 455.22781,353.96303 455.52506,355.15202 C 455.83894,356.40755 456.52404,357.04441 457.95813,357.04441 C 459.51448,357.04441 459.9091,356.44514 460.66154,355.6927 C 461.53016,354.82408 461.90615,354.12421 463.09461,353.52997 C 463.79174,353.18141 464.29199,351.44389 464.44632,350.82656 C 464.73042,349.69016 464.84726,348.40263 465.25734,347.58246 C 465.94594,346.20527 468.12455,346.5011 469.5828,346.5011 C 471.4703,346.5011 473.14256,347.04178 474.98963,347.04178 C 476.68038,347.04178 478.06963,347.20351 479.58543,347.58246 C 480.88745,347.90797 482.07323,348.82636 483.37021,349.47485 C 484.30553,349.94251 484.52746,351.94113 484.72192,352.71895 C 485.12713,354.33982 485.15396,354.69219 486.6143,355.42236 C 488.30911,356.26976 488.66367,357.04441 490.66942,357.04441 C 492.4601,357.04441 493.58575,354.91039 495.26523,354.07066 C 496.40194,353.5023 496.68001,351.05187 496.88727,350.01554 C 497.08983,349.00274 497.9856,347.83584 498.77966,347.04178 C 499.63046,346.19098 500.12793,344.88249 500.94239,344.06803 C 501.96674,343.04368 503.69345,342.04844 504.72717,341.63496 C 506.51802,340.91862 508.54671,342.58984 510.134,342.98666 C 511.60134,343.3535 513.05652,344.5831 514.18912,345.14939 C 515.33699,345.72333 517.05166,346.23076 518.51458,346.23076 C 519.9564,346.23076 521.12788,345.69008 522.5697,345.69008 C 524.19174,345.69008 526.08413,345.14939 527.70618,345.14939 C 529.46202,345.14939 530.50816,346.37718 530.95027,344.60871 C 531.24602,343.42574 532.62559,342.12237 533.11301,341.63496 C 534.14804,340.59992 535.44546,340.03806 536.62744,339.74257 C 538.0454,339.38808 539.76878,339.44654 540.9529,339.74257 C 542.28444,340.07545 542.62856,341.2015 543.11563,342.17564 C 543.71334,343.37106 545.30735,343.53459 546.35973,343.79769 C 547.8106,344.1604 548.84622,343.52735 550.14451,343.52735 C 551.86951,343.52735 551.27409,345.22684 550.95553,346.5011 C 550.61124,347.87825 550.38624,348.4507 549.87416,349.47485 C 549.44815,350.32688 549.87416,352.55227 549.87416,353.52997 C 549.87416,354.97179 549.87416,356.41361 549.87416,357.85543 C 549.87416,359.34218 549.81293,360.85461 550.14451,362.18089 C 550.56535,363.86426 549.64067,364.46037 548.7928,364.88431 C 547.54395,365.50873 547.03349,365.56226 546.08939,366.50635 C 545.12863,367.46711 544.38272,368.6103 543.92666,369.75045 C 543.4078,371.0476 542.62066,370.78611 541.49358,371.91318 C 540.54224,372.86452 540.06595,373.61116 539.06051,374.61659 C 537.98094,375.69616 537.87683,376.42497 536.62744,377.04966 C 535.79533,377.46572 534.93143,379.01602 534.46471,379.48274 C 533.36575,380.5817 533.65369,382.2662 533.65369,383.8082 C 533.65369,385.34013 533.65369,386.87206 533.65369,388.404 C 533.65369,390.02605 533.65369,391.64809 533.65369,393.27014 C 533.65369,394.71196 533.65369,396.15378 533.65369,397.5956 C 533.65369,398.94731 533.65369,400.29901 533.65369,401.65072 C 533.65369,403.54629 532.38632,404.06271 531.22062,404.35413 C 529.97109,404.66652 528.19932,404.35413 526.89516,404.35413 C 525.56858,404.35413 523.72829,403.31138 522.5697,402.73209 C 521.58316,402.23882 519.4002,403.05136 518.51458,403.27277 C 517.03974,403.64148 518.40264,408.30207 516.89253,408.67959 C 515.80829,408.95065 513.2565,408.53085 512.56707,409.22028 C 511.36141,410.42595 510.48774,410.75892 509.32297,411.92369 C 508.70104,412.54562 505.68054,411.92369 504.72717,411.92369 C 503.06311,411.92369 501.57208,413.23831 500.9424,412.46437 C 499.81295,411.07618 499.51869,410.22965 498.50932,409.22028 C 497.71062,408.42157 497.08495,407.79591 496.34659,407.05755 C 495.36726,406.07821 494.64624,405.89788 493.91352,405.16516 C 493.20191,404.45355 492.73266,403.49336 491.75079,403.00243 C 490.66204,402.45805 492.40983,399.87669 491.75079,399.21765 C 490.77442,398.24128 488.50669,397.94589 488.50669,396.51423 C 488.50669,395.35978 486.58705,395.86453 486.34396,394.89219 C 486.05753,393.74647 485.07654,392.90677 484.18123,392.45912 C 482.60917,391.67308 482.02549,390.57605 481.20748,389.48536 C 480.38045,388.38266 479.84974,387.85728 478.77441,386.78195 C 477.9243,385.93184 476.23017,385.70058 474.98963,385.70058 C 473.41646,385.70058 472.68552,385.97093 471.20485,385.97093 C 469.86195,385.97093 468.59702,386.24127 467.14973,386.24127 C 465.50073,386.24127 464.24756,386.69647 462.82427,387.05229 C 461.31199,387.43036 460.52313,387.22369 459.30984,388.13366 C 458.21447,388.95518 457.55389,390.56418 457.14711,391.37775 C 456.96671,391.73855 454.46151,393.13052 453.90301,393.27014 C 452.80233,393.54531 450.61911,393.9659 449.84789,394.35151 C 448.9541,394.79841 446.79026,395.16253 445.79277,395.16253 C 444.2969,395.16253 442.82128,395.23068 441.46731,394.89219 C 440.15396,394.56385 439.39162,393.89786 438.7639,393.27014 C 437.90407,392.41031 437.32429,391.60414 436.33083,391.10741 C 435.51642,390.70021 434.70294,389.74987 434.1681,389.21502 C 433.35083,388.39775 432.25206,387.56932 431.46468,386.78195 C 430.34084,385.6581 428.60386,385.97093 427.13922,385.97093 C 425.73033,385.97093 425.10648,385.22489 423.89513,384.61922 C 422.07233,383.70782 422.09563,382.18615 420.11035,382.18615 C 418.62329,382.18615 417.20048,382.17337 415.78489,382.45649 C 414.36807,382.73985 412.99511,383.62422 412.00011,384.61922 C 410.88105,385.73828 410.74623,386.47248 409.2967,387.05229 C 407.8333,387.63765 407.37829,387.86332 405.51192,387.86332 C 403.99345,387.86332 402.72533,388.44559 401.72714,388.94468 C 400.354,389.63125 400.18084,389.64731 399.83475,391.37775 C 399.60027,392.55017 399.50434,394.32146 399.29407,395.16253 C 399.26704,395.27066 397.53449,397.05806 397.13134,397.5956 C 396.17015,398.87719 395.72811,399.59104 395.23895,400.56936 C 395.03204,400.98317 391.91221,400.29901 391.45417,400.29901 C 390.07284,400.29901 388.68551,400.31533 387.6694,400.56936 C 386.68338,400.81586 386.68358,401.42408 385.77701,401.65072 C 384.85561,401.88107 384.69565,400.06577 384.69565,399.21765 C 384.69565,397.86594 384.4253,395.97355 384.4253,394.62185 C 384.4253,393.27014 384.15496,392.45912 384.15496,391.10741 C 384.15496,389.7557 383.88462,388.13366 383.88462,386.78195 C 383.88462,385.40061 383.59796,384.01329 383.34394,382.99717 C 383.18962,382.37992 381.81804,380.78241 381.45155,380.29376 C 380.78723,379.408 380.23656,378.67481 379.8295,377.86069 C 379.31064,376.82298 379.05367,376.10909 378.74813,374.88693 C 378.47895,373.81019 377.79212,372.9749 377.39643,372.18352 C 376.74554,370.88175 376.4631,370.0578 375.2337,369.75045 C 374.18544,369.48838 373.27792,368.50222 372.53028,368.1284 C 371.4073,367.56691 370.90942,367.31975 370.36755,366.23601 C 369.93123,365.36337 370.09721,363.72499 370.09721,362.45123 C 370.09721,361.09953 370.09721,359.74782 370.09721,358.39612 C 370.09721,357.04441 370.90823,356.50372 370.90823,355.15202 C 370.90823,354.14249 372.57595,352.56847 373.34131,352.44861 C 375.26454,352.14743 374.38937,351.2404 374.96336,351.0969 C 376.54506,350.70147 376.45989,350.21346 377.93711,349.47485 C 378.7773,349.05476 380.11138,348.11738 381.18121,347.58246 C 382.4491,346.94852 381.92109,346.37304 382.53291,345.14939 C 383.00057,344.21408 383.53858,342.86772 383.88462,342.17564 C 384.45003,341.04481 384.4253,339.1148 384.4253,337.85018 C 384.4253,336.40124 385.11593,335.38755 385.50667,334.60608 C 385.94842,333.72258 387.7698,334.0654 389.0211,334.0654 C 389.59103,334.0654 390.10247,334.42586 390.64315,334.60608 z'},
	
	PR => {
			name => 'Presovsky kraj',
			d =>'M 367.12346,302.70581 C 366.2064,302.06564 367.62219,300.17019 367.93448,298.92103 C 368.23214,297.7304 370.38069,298.11001 371.44892,298.11001 C 372.59553,298.11001 372.40453,295.22434 372.53028,294.59557 C 372.71493,293.67232 375.1648,293.78455 376.04472,293.78455 C 377.72189,293.78455 378.4541,292.99722 379.28882,292.1625 C 380.53235,290.91897 381.07313,290.9054 382.53291,290.54045 C 382.60447,290.52256 384.37856,291.08114 385.50667,291.08114 C 386.76042,291.08114 386.6637,288.61574 386.85837,287.83704 C 387.36998,285.7906 387.05672,285.67431 389.29144,285.67431 C 390.64315,285.67431 391.99486,285.67431 393.34656,285.67431 C 394.96861,285.67431 396.59066,285.67431 398.21271,285.67431 C 399.56441,285.67431 400.91612,285.67431 402.26783,285.67431 C 403.70965,285.67431 405.15147,285.67431 406.59329,285.67431 C 408.07412,285.67431 409.60217,285.73311 410.91875,285.40397 C 412.10388,285.10769 412.32223,284.36632 413.8925,284.05226 C 415.49913,283.73094 416.48809,284.6742 417.40694,285.13363 C 418.27726,285.56879 418.59466,287.45145 418.75864,288.10738 C 418.88961,288.63126 421.12004,289.55842 421.46206,289.72943 C 422.52106,290.25893 424.09572,290.10007 424.97649,290.54045 C 426.1858,291.14511 427.29065,291.08114 428.76127,291.08114 C 429.7103,291.08114 430.79834,293.52689 431.19434,294.05489 C 431.63053,294.63648 434.1974,294.88057 434.70878,295.13626 C 436.0413,295.80252 437.87583,294.72094 438.7639,294.05489 C 439.90834,293.19656 440.52413,292.69715 441.19697,291.35148 C 441.69366,290.3581 442.27408,290.13387 442.81902,290.27011 C 443.70754,290.49224 443.63004,288.59144 443.63004,287.83704 C 443.63004,286.28173 444.17072,284.07701 444.17072,282.70055 C 444.17072,281.23825 446.69693,282.43022 448.22584,282.43022 C 449.72279,282.43022 451.44123,282.70056 453.09199,282.70056 C 454.49701,282.70056 456.14078,282.6818 457.14711,282.43022 C 457.89095,282.24426 458.61423,280.34649 458.76915,279.7268 C 459.18511,278.06296 459.71371,278.10476 461.47257,278.10476 C 463.3549,278.10476 464.54499,278.34076 466.06837,278.64544 C 468.1695,279.06566 468.36166,278.776 469.5828,279.99714 C 470.52037,280.93471 469.84847,281.75202 471.20485,282.43022 C 472.33492,282.99525 473.77352,283.27514 474.71929,283.51158 C 475.96817,283.8238 477.75488,283.51158 479.04475,283.51158 C 480.48657,283.51158 481.92839,283.51158 483.37021,283.51158 C 484.99226,283.51158 486.6143,283.51158 488.23635,283.51158 C 489.88839,283.51158 491.37521,283.06479 492.83215,282.70056 C 494.19342,282.36024 495.66941,282.43022 497.15761,282.43022 C 498.79819,282.43022 499.93116,282.77069 500.67205,283.51158 C 501.77167,284.6112 500.46222,285.68944 502.56444,286.21499 C 503.74331,286.50971 505.39722,286.21499 506.61956,286.21499 C 508.15149,286.21499 509.68343,286.21499 511.21536,286.21499 C 512.9768,286.21499 513.08958,286.73751 513.91877,287.5667 C 514.72182,288.36975 515.02504,289.23856 515.54082,290.27011 C 516.22,291.62848 516.20702,291.62182 518.24423,291.62182 C 518.99362,291.62182 519.05526,294.07291 519.05526,294.86591 C 519.05526,296.82361 519.29582,297.26921 520.40696,298.38035 C 521.6246,299.59799 522.02901,298.38214 522.02901,300.81342 C 522.02901,302.49484 522.27073,303.45958 522.84004,304.5982 C 523.65733,306.23278 523.45279,306.49059 525.54345,306.49059 C 526.89516,306.49059 528.24686,306.49059 529.59857,306.49059 C 531.1639,306.49059 532.53315,306.60618 533.38335,307.03127 C 534.15659,307.4179 533.51556,309.26011 535.00539,310.00503 C 535.6865,310.34558 538.0965,309.73469 539.06051,309.73469 C 540.92849,309.73469 541.52989,309.77099 542.57495,310.81605 C 543.40092,311.64202 542.96012,313.09361 543.65632,313.7898 C 544.72034,314.85383 546.13493,314.58944 547.17075,314.33049 C 548.70303,313.94742 550.28792,314.43805 551.22587,315.14151 C 552.24009,315.90218 552.91839,317.49227 554.46997,318.65595 C 555.42298,319.3707 557.59889,318.81991 558.25474,318.65595 C 559.50427,318.34357 561.27604,318.65595 562.5802,318.65595 C 563.93191,318.65595 562.5802,321.35936 562.5802,322.71107 C 562.5802,324.06277 562.5802,325.41448 562.5802,326.76619 C 562.5802,328.11789 562.5802,329.4696 562.5802,330.8213 C 562.5802,332.14997 562.54346,333.67168 562.30986,334.60608 C 562.22473,334.94662 559.81286,335.85458 559.60645,335.95779 C 558.58895,336.46654 557.88377,337.08947 556.90304,337.57984 C 555.49467,338.28402 555.1629,337.81602 554.46997,339.20188 C 554.01949,340.10285 553.89356,341.50751 553.65894,342.44598 C 553.33649,343.73579 552.53501,345.29726 551.49621,344.33837 C 550.32473,343.257 548.61257,344.33837 547.17075,344.33837 C 545.97729,344.33837 544.82279,343.16439 543.92666,342.71632 C 542.95242,342.2292 542.92934,341.17833 542.3046,340.55359 C 541.57409,339.82308 540.25829,339.74257 538.79017,339.74257 C 537.4615,339.74257 535.12878,340.31999 534.19437,340.55359 C 533.27304,340.78392 533.05693,341.85173 531.7613,342.17564 C 530.96101,342.37571 530.95824,345.13347 530.67993,345.69008 C 530.44411,346.16172 527.17226,345.01253 526.62481,345.14939 C 525.3756,345.4617 523.81808,345.17522 522.84004,345.41973 C 521.66117,345.71445 520.00725,346.5011 518.78492,346.5011 C 517.43321,346.5011 516.0815,345.41973 514.7298,345.41973 C 512.81043,345.41973 512.91275,345.02973 512.29673,343.79769 C 512.06382,343.33188 509.66373,342.8867 509.32297,342.71632 C 508.26858,342.18913 507.50699,341.9244 506.34922,341.63496 C 505.00823,341.29971 503.79657,341.93519 502.83478,342.17564 C 501.19029,342.58676 502.17604,342.64789 500.40171,343.79769 C 499.48593,344.39113 499.87348,345.81902 499.05001,346.23076 C 498.26422,346.62365 497.93142,348.70106 497.42796,349.20452 C 496.87315,349.75932 495.53557,350.87207 495.53557,351.90792 C 495.53557,353.15689 494.57908,354.14339 493.64318,354.61134 C 492.55767,355.15409 493.0028,356.39348 491.48045,356.77406 C 490.30159,357.06878 487.5663,355.96304 486.34396,355.96304 C 485.58632,355.96304 484.5923,354.09286 484.45157,353.52997 C 484.22799,352.63565 484.40685,351.59286 483.9109,351.0969 C 483.20945,350.39546 482.56071,350.28739 481.74817,349.47485 C 481.15639,348.88308 478.71826,347.9599 477.96338,347.58246 C 476.84433,347.02294 476.26192,346.77144 474.71929,346.77144 C 473.36758,346.77144 472.01588,346.77144 470.66417,346.77144 C 469.31246,346.77144 467.96076,346.77144 466.60905,346.77144 C 464.86946,346.77144 464.987,347.51505 464.987,349.20451 C 464.987,349.92637 464.52344,351.56046 464.17598,351.90792 C 463.33112,352.75278 462.49713,354.12747 461.74291,354.88168 C 460.93252,355.69208 460.95054,357.02575 459.30984,356.77406 C 458.05903,356.58219 458.18139,357.04441 456.60643,357.04441 C 455.59892,357.04441 455.70529,355.24213 455.25472,354.341 C 454.82871,353.48897 454.44369,350.99324 454.44369,350.01554 C 454.44369,348.76091 453.19082,348.22198 452.5513,347.58246 C 451.75462,346.78579 450.35157,347.04178 449.03687,347.04178 C 447.71997,347.04178 446.76353,346.47345 445.79277,346.23076 C 444.4749,345.90129 443.79545,345.69008 442.27833,345.69008 C 441.12516,345.69008 439.62546,344.38891 439.03424,343.79769 C 438.38618,343.14962 436.57437,342.98666 435.24946,342.98666 C 434.64863,342.98666 434.8417,340.54908 434.70878,340.28325 C 434.21583,339.29735 432.68671,339.94807 431.73502,339.47223 C 430.84921,339.02932 428.17543,338.12052 427.13922,338.12052 C 426.49128,338.12052 425.37874,336.83477 424.70615,336.49847 C 423.388,335.83939 423.22043,335.41711 421.19172,335.41711 C 419.84001,335.41711 418.4883,335.41711 417.1366,335.41711 C 415.59866,335.41711 415.27833,336.76029 414.16284,337.03916 C 413.49104,337.20711 412.12143,338.26954 411.72977,338.6612 C 411.08297,339.308 408.86215,339.74257 407.94499,339.74257 C 406.6536,339.74257 405.0425,338.61143 404.16021,338.39086 C 402.91059,338.07845 402.04195,337.59095 400.91612,337.3095 C 399.73847,337.01508 398.35701,336.6067 397.13134,335.68745 C 396.07099,334.89218 393.58283,335.14677 392.2652,335.14677 C 390.91349,335.14677 389.56179,334.33575 388.21008,334.33575 C 387.09691,334.33575 386.27595,334.22144 385.50666,334.60608 C 384.86596,334.92643 384.96598,339.32673 384.96598,340.01291 C 384.96598,341.84346 384.53289,342.33839 383.61428,343.257 C 382.7415,344.12978 382.45204,346.31163 381.72189,347.04178 C 380.93326,347.83041 379.7828,346.78312 378.74813,347.04178 C 377.47268,347.36065 376.14235,347.58246 374.96336,347.58246 C 373.61165,347.58246 372.25994,347.58246 370.90824,347.58246 C 369.55653,347.58246 368.20482,347.58246 366.85312,347.58246 C 365.50141,347.58246 364.1497,347.58246 362.798,347.58246 C 361.44629,347.58246 360.09459,347.58246 358.74288,347.58246 C 358.26056,347.58246 360.92475,346.42191 361.17595,345.14939 C 361.58421,343.08133 359.82405,341.63536 360.36493,340.55359 C 361.10796,339.06752 359.76172,337.90213 358.47254,337.57984 C 357.21204,337.26471 357.05168,337.00459 356.03947,336.49848 C 354.76806,335.86278 358.07141,333.92585 358.2022,333.79506 C 359.13478,332.86249 357.93186,332.49647 357.93186,330.8213 C 357.93186,329.39992 359.90954,330.2593 360.90561,330.01028 C 362.03653,329.72755 361.71663,327.53884 361.71663,326.49584 C 361.71663,325.14414 361.71663,323.79243 361.71663,322.44073 C 361.71663,320.90876 361.21158,320.4205 360.90561,319.19663 C 360.50898,317.6101 360.58068,316.92473 360.09459,315.95253 C 359.57573,314.91482 360.12978,313.9306 359.82424,312.70844 C 359.4033,311.02467 359.18165,310.37728 359.82424,309.73469 C 360.22824,309.33069 363.23701,309.73469 363.87936,309.73469 C 365.29341,309.73469 366.02873,308.85136 366.58278,308.11264 C 367.22904,307.25095 367.12346,305.69564 367.12346,304.32786 C 367.12346,303.40888 368.21553,302.35963 367.66414,301.62445 C 367.3938,301.26399 366.85311,302.34536 367.12346,302.70581 z'},
);

our %continents = (
	europe => ['AL', 'AD', 'AT', 'BY', 'BE', 'BA', 'BG', 'CY', 'CZ', 'CS', 'DK', 'EE', 'FI', 'FR', 'DE', 'GR', 'GB', 'HU', 'HR', 'IS', 'IE', 'IT', 'LV', 'LI', 'LT', 'LU', , 'MK', 'MT', 'MD', 'MC', 'NL', 'NO', 'PL', 'PT', 'RO', 'SM', 'SI', 'SK', 'ES', 'SE', 'CH', 'TR', 'UA', 'VA', ],
	africa => ['DZ', 'AO', 'BJ', 'BW', 'BF', 'BI', 'CM', 'CD', 'CV', 'CF', 'CG', 'TD', 'KM', 'DJ', 'EG', 'GQ', 'ER', 'ET', 'GA', 'GH', 'GN', 'KE', 'LS', 'LR', 'LY', 'MG', 'MW', 'ML', 'MR', 'MU', 'MA', 'MZ', 'NA', 'NE', 'NG', 'RW', 'ST', 'SN', 'SC', 'SL', 'SO', 'ZA', 'SD', 'SZ', 'TZ', 'TG', 'TN', 'UG', 'ZM', 'ZW', ],
	america => ['AR', 'BO', 'BR', 'CL', 'CO', 'EC', 'GF', 'GY', 'PY', 'PE', 'SR', 'UY', 'VE', 'AG', 'BS', 'BB', 'BZ', 'CA', 'CR', 'CU', 'DM', 'DO', 'SV', 'GL', 'GD', 'GT', 'HT', 'HN', 'JM', 'MX', 'NI', 'PA', 'KN', 'LC', 'TT', 'US', ],
	asia => ['AF', 'AM', 'AZ', 'BH', 'BD', 'BT', 'KH', 'CN', 'GE', 'HK', 'IN', 'ID', 'IR', 'IQ', 'IL', 'JP', 'JO', 'KW', 'KG', 'LA', 'LB', 'MY', 'MV', 'RU', 'MN', 'MM', 'NP', 'OM', 'PK', 'PH', 'QA', 'SA', 'SG', 'LK', 'SY', 'TW', 'TJ', 'TH', 'TR', 'TM', 'AE', 'UZ', 'YE', 'KZ'],
	oceania => ['AU', 'FJ', 'KI', 'MH', 'FM', 'NR', 'PW', 'PG', 'AS', 'SB', 'TO', 'TV', 'VU', ],
	slovakia => ['BA','BB','TR','TE','KE','PR','ZI','NT']);

1;
