package Ithumb::XS;

=encoding UTF-8

=head1 NAME

Ithumb::XS - Fast, small and simple image thumbnailazer, based on Imlib2 library.

=head1 DESCRIPTION

Ithumb::XS is a very small (one function) and fast and simple Perl-XS module
for creation a thumbnails, using Imlib2 library.

=head1 MAINTAINERS

Peter P. Neuromantic <p.brovchenko@protonmail.com>

=cut

use 5.020001;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

our @EXPORT_OK = qw( create_thumbnail );

our $VERSION = 'v0.2.0';

require XSLoader;
XSLoader::load('Ithumb::XS', $VERSION);

1;

__END__

=head1 SYNOPSIS

  use Ithumb::XS ();

  Ithumb::XS::create_thumbnail({
      width     => 800,
      height    => 600,
      src_image => 'source_image.jpg',
      dst_image => 'destination_result_image.jpg'
  });

OO-interface:

  use Ithumb::XS;

  my $ithumb = Ithumb::XS->new;
  $ithumb->convert({
      width     => 800,
      height    => 600,
      src_image => 'source_image.jpg',
      dst_image => 'destination_result_image.jpg'
  });

=head1 METHODS

=head2 create_thumbnail($);

Creates a small copy (with cropping) of the image.

=over 12

=item C<$width> - destination width

=item C<$height> - destination height

=item C<$src_image> - path to the source image

=item C<$dst_image> - path to the destionation result image
  
=back

=head1 LICENSE

BSD 3-Clause License

Copyright (c) 2018, 2019 Peter P. Neuromantic <p.brovchenko@protonmail.com>
All rights reserved.

See LICENSE file for more details.

=cut
