package PROP::ResultSet::ObjectTest;

use strict;
use base qw/Test::Unit::TestCase/;
use PROP::DBH;
use PROP::TestCommon;
use PROP::Util;
use PROP::Link;
use PROP::Query::Link;
use PROP::ResultSet::Link;
use PROP::Conditions::Foreign;
use Data::Dumper;

sub new {
    my ($invocant, @args) = @_;
    my $self = $invocant->SUPER::new(@args);

    return $self;
}

sub set_up {
    my ($self) = @_;

    drop_tables();
    create_tables();
}

sub tear_down {
    my ($self) = @_;

#    drop_tables();
}

sub test_simple_lookup {
    my ($self) = @_;

    my ($f, $b, $fz, $links) = populate_database();

    # NEW

    my $fc1 = new PROP::Conditions::Foreign($links->[0], 'children', [], []);
    my $lqs1 = new PROP::Query::Link($fc1, ['l.biz_id']);

#    my $lqs1 = new PROP::Query::Link($links->[0], 'children', undef, ['l.biz_id']);

    my $fc2 = new PROP::Conditions::Foreign($links->[1], 'children', [], []);
    my $lqs2 = new PROP::Query::Link($fc2, ['l.fizz_id']);

#    my $lqs2 = new PROP::Query::Link($links->[1], 'children', undef, ['l.fizz_id']);

    my $rqs = new PROP::Query::Object('Dummy::Foo',
					    new PROP::Conditions::Local([], []),
					    [], [], [$lqs1, $lqs2], 5000);
    my $result_set = $rqs->execute();

    my $result;
    my $i = 0;

    while($result = $result_set->get_next_result()) {
	my @bars = $result->get_children($links->[0]->get_table_name());
	my @fizzes = $result->get_children($links->[1]->get_table_name());

	$self->assert_equals(scalar(@$b)  / scalar(@$f), scalar(@bars));
	$self->assert_equals(scalar(@$fz) / scalar(@$f), scalar(@fizzes));

	for(my $j = 0; $j < 4; ++$j) {
	    $self->assert_equals($i,      $bars[$j]->get_contextual_value('c1'));
	    $self->assert_equals($i * $j, $bars[$j]->get_contextual_value('c2'));
	    $self->assert_equals('meh',   $bars[$j]->get_contextual_value('c3'));

	    $self->assert_equals(2 * $i, $fizzes[$j]->get_contextual_value('c1'));
	    $self->assert_equals(2 * $i * $j, $fizzes[$j]->get_contextual_value('c2'));
	    $self->assert_equals('bleh', $fizzes[$j]->get_contextual_value('c3'));
	}

	++$i;
    }
}

sub test_conditional_lookup {
    my ($self) = @_;
    my ($f, $b, $fz, $links) = populate_database();

    my $link_conditions =
	new PROP::Conditions::Local(['p.foo % ?'], [2]);

    # NEW

    my $fc = new PROP::Conditions::Foreign($links->[0], 'children', ['p.foo % ?'], [2]);
    my $lq = new PROP::Query::Link($fc, ['l.biz_id']);

#    my $lq = new PROP::Query::Link($links->[0], 'children', $link_conditions, ['l.biz_id']);

    my $object_conditions = new PROP::Conditions::Local(['o.foo % ?'], [2]);
    my $oq = new PROP::Query::Object('Dummy::Foo', $object_conditions, [], [], [$lq], 5000);

    my $result_set = $oq->execute();
    my $result;

    foreach my $pk_value (1,3) {
	$result = $result_set->get_next_result();
	$self->assert_equals($pk_value, $result->get_pk_value());	

	my $i = 0;
	foreach ($result->get_children('LinkFooToBiz')) {
	    $self->assert_equals($pk_value, $_->get_contextual_value('foo_id'));
	    $self->assert_equals($pk_value - 1, $_->get_contextual_value('c1'));
	    $self->assert_equals(($pk_value - 1) * $i, $_->get_contextual_value('c2'));
	    $self->assert_equals('meh', $_->get_contextual_value('c3'));
	    ++$i;
	}
    }
}

sub test_conditional_lookup_with_foreign {
    my ($self) = @_;
    my ($f, $b, $fz, $links) = populate_database();

    $links->[0]->delete(2, 3);

    my $fc = new PROP::Conditions::Foreign($links->[0], 'children',
						  ['c.boz = ?'], [3]);

    my $oq = new PROP::Query::Object('Dummy::Foo',
				     new PROP::Conditions::Local([], []),
				     [$fc], ['foo'], [], 5000);
    my $rs = $oq->execute();

    my $result = $rs->get_next_result();
    $self->assert_equals(1, $result->get_pk_value());

    $result = $rs->get_next_result();
    $self->assert_equals(3, $result->get_pk_value());

    $result = $rs->get_next_result();
    $self->assert_equals(4, $result->get_pk_value());

    $self->assert_null($rs->get_next_result());
}

sub test_limited_object_query {
    my ($self) = @_;
    my ($f, $b, $fz, $links) = populate_database();

    my $qo = new PROP::Query::Object('Dummy::Fizz',
				     new PROP::Conditions::Local([], []),
				     [], [], [], 5000, 7);

    my $rso = new PROP::ResultSet::Object($qo);
    my @results = $rso->get_all_results();
    $self->assert_equals(7, scalar(@results));

    $qo = new PROP::Query::Object('Dummy::Fizz',
				  new PROP::Conditions::Local([], []),
				  [], [], [], 5000, [4, 5]);

    $rso = new PROP::ResultSet::Object($qo);
    @results = $rso->get_all_results();
    $self->assert_equals(5, scalar(@results));

    my $i = 5;
    while(@results) {
	my $result = shift(@results);
	$self->assert_equals($i, $result->get_pk_value());
	$i++;
    }
}

1;

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
