use strict;
use warnings;
use Test::More;
use lib qw(./lib ./blib/lib);
require './t/600-lhost-code';

my $enginename = 'EZweb';
my $samplepath = sprintf("./set-of-emails/private/lhost-%s", lc $enginename);
my $enginetest = Sisimai::Lhost::Code->maketest;
my $isexpected = [
    { 'n' => '01001', 'r' => qr/userunknown/ },
    { 'n' => '01002', 'r' => qr/filtered/    },
    { 'n' => '01003', 'r' => qr/userunknown/ },
    { 'n' => '01004', 'r' => qr/userunknown/ },
    { 'n' => '01005', 'r' => qr/suspend/     },
    { 'n' => '01006', 'r' => qr/filtered/    },
    { 'n' => '01007', 'r' => qr/suspend/     },
    { 'n' => '01008', 'r' => qr/filtered/    },
    { 'n' => '01009', 'r' => qr/filtered/    },
    { 'n' => '01010', 'r' => qr/filtered/    },
    { 'n' => '01011', 'r' => qr/filtered/    },
    { 'n' => '01012', 'r' => qr/filtered/    },
    { 'n' => '01013', 'r' => qr/expired/     },
    { 'n' => '01014', 'r' => qr/filtered/    },
    { 'n' => '01015', 'r' => qr/suspend/     },
    { 'n' => '01016', 'r' => qr/filtered/    },
    { 'n' => '01017', 'r' => qr/filtered/    },
    { 'n' => '01018', 'r' => qr/filtered/    },
    { 'n' => '01019', 'r' => qr/suspend/     },
    { 'n' => '01020', 'r' => qr/filtered/    },
    { 'n' => '01021', 'r' => qr/filtered/    },
    { 'n' => '01022', 'r' => qr/filtered/    },
    { 'n' => '01023', 'r' => qr/suspend/     },
    { 'n' => '01024', 'r' => qr/filtered/    },
    { 'n' => '01025', 'r' => qr/filtered/    },
    { 'n' => '01026', 'r' => qr/filtered/    },
    { 'n' => '01027', 'r' => qr/filtered/    },
    { 'n' => '01028', 'r' => qr/filtered/    },
    { 'n' => '01029', 'r' => qr/suspend/     },
    { 'n' => '01030', 'r' => qr/filtered/    },
    { 'n' => '01031', 'r' => qr/suspend/     },
    { 'n' => '01032', 'r' => qr/filtered/    },
    { 'n' => '01033', 'r' => qr/mailboxfull/ },
    { 'n' => '01034', 'r' => qr/filtered/    },
    { 'n' => '01035', 'r' => qr/suspend/     },
    { 'n' => '01036', 'r' => qr/mailboxfull/ },
    { 'n' => '01037', 'r' => qr/userunknown/ },
    { 'n' => '01038', 'r' => qr/suspend/     },
    { 'n' => '01039', 'r' => qr/suspend/     },
    { 'n' => '01040', 'r' => qr/suspend/     },
    { 'n' => '01041', 'r' => qr/suspend/     },
    { 'n' => '01042', 'r' => qr/suspend/     },
    { 'n' => '01043', 'r' => qr/suspend/     },
    { 'n' => '01044', 'r' => qr/userunknown/ },
    { 'n' => '01045', 'r' => qr/filtered/    },
    { 'n' => '01046', 'r' => qr/filtered/    },
    { 'n' => '01047', 'r' => qr/filtered/    },
    { 'n' => '01048', 'r' => qr/suspend/     },
    { 'n' => '01049', 'r' => qr/filtered/    },
    { 'n' => '01050', 'r' => qr/suspend/     },
    { 'n' => '01051', 'r' => qr/filtered/    },
    { 'n' => '01052', 'r' => qr/suspend/     },
    { 'n' => '01053', 'r' => qr/filtered/    },
    { 'n' => '01054', 'r' => qr/suspend/     },
    { 'n' => '01055', 'r' => qr/filtered/    },
    { 'n' => '01056', 'r' => qr/userunknown/ },
    { 'n' => '01057', 'r' => qr/filtered/    },
    { 'n' => '01058', 'r' => qr/suspend/     },
    { 'n' => '01059', 'r' => qr/suspend/     },
    { 'n' => '01060', 'r' => qr/filtered/    },
    { 'n' => '01061', 'r' => qr/suspend/     },
    { 'n' => '01062', 'r' => qr/filtered/    },
    { 'n' => '01063', 'r' => qr/userunknown/ },
    { 'n' => '01064', 'r' => qr/filtered/    },
    { 'n' => '01065', 'r' => qr/suspend/     },
    { 'n' => '01066', 'r' => qr/filtered/    },
    { 'n' => '01067', 'r' => qr/filtered/    },
    { 'n' => '01068', 'r' => qr/suspend/     },
    { 'n' => '01069', 'r' => qr/suspend/     },
    { 'n' => '01070', 'r' => qr/suspend/     },
    { 'n' => '01071', 'r' => qr/filtered/    },
    { 'n' => '01072', 'r' => qr/suspend/     },
    { 'n' => '01073', 'r' => qr/filtered/    },
    { 'n' => '01074', 'r' => qr/filtered/    },
    { 'n' => '01075', 'r' => qr/suspend/     },
    { 'n' => '01076', 'r' => qr/filtered/    },
    { 'n' => '01077', 'r' => qr/expired/     },
    { 'n' => '01078', 'r' => qr/filtered/    },
    { 'n' => '01079', 'r' => qr/filtered/    },
    { 'n' => '01080', 'r' => qr/filtered/    },
    { 'n' => '01081', 'r' => qr/filtered/    },
    { 'n' => '01082', 'r' => qr/filtered/    },
    { 'n' => '01083', 'r' => qr/filtered/    },
    { 'n' => '01084', 'r' => qr/filtered/    },
    { 'n' => '01085', 'r' => qr/expired/     },
    { 'n' => '01086', 'r' => qr/filtered/    },
    { 'n' => '01087', 'r' => qr/filtered/    },
    { 'n' => '01088', 'r' => qr/(?:mailboxfull|suspend)/ },
    { 'n' => '01089', 'r' => qr/filtered/    },
    { 'n' => '01090', 'r' => qr/suspend/     },
    { 'n' => '01091', 'r' => qr/filtered/    },
    { 'n' => '01092', 'r' => qr/filtered/    },
    { 'n' => '01093', 'r' => qr/suspend/     },
    { 'n' => '01094', 'r' => qr/userunknown/ },
    { 'n' => '01095', 'r' => qr/filtered/    },
    { 'n' => '01096', 'r' => qr/filtered/    },
    { 'n' => '01097', 'r' => qr/filtered/    },
    { 'n' => '01098', 'r' => qr/suspend/     },
    { 'n' => '01099', 'r' => qr/filtered/    },
    { 'n' => '01100', 'r' => qr/filtered/    },
    { 'n' => '01101', 'r' => qr/filtered/    },
    { 'n' => '01102', 'r' => qr/suspend/     },
    { 'n' => '01103', 'r' => qr/userunknown/ },
    { 'n' => '01104', 'r' => qr/filtered/    },
    { 'n' => '01105', 'r' => qr/filtered/    },
    { 'n' => '01106', 'r' => qr/userunknown/ },
    { 'n' => '01107', 'r' => qr/filtered/    },
    { 'n' => '01108', 'r' => qr/userunknown/ },
    { 'n' => '01109', 'r' => qr/userunknown/ },
    { 'n' => '01110', 'r' => qr/filtered/    },
    { 'n' => '01111', 'r' => qr/suspend/     },
    { 'n' => '01112', 'r' => qr/suspend/     },
    { 'n' => '01113', 'r' => qr/suspend/     },
    { 'n' => '01114', 'r' => qr/filtered/    },
    { 'n' => '01115', 'r' => qr/suspend/     },
    { 'n' => '01116', 'r' => qr/filtered/    },
    { 'n' => '01117', 'r' => qr/(?:filtered|suspend)/ },
    { 'n' => '01118', 'r' => qr/suspend/     },
    { 'n' => '01119', 'r' => qr/filtered/    },
    { 'n' => '01120', 'r' => qr/userunknown/ },
    { 'n' => '01121', 'r' => qr/blocked/     },
];

plan 'skip_all', sprintf("%s not found", $samplepath) unless -d $samplepath;
$enginetest->($enginename, $isexpected, 1, 0);
done_testing;

