package Microsoft::AdCenter::V6::ReportingService::AdDynamicTextPerformanceReportColumn;
# Copyright (C) 2012 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V6::ReportingService::AdDynamicTextPerformanceReportColumn - Represents "AdDynamicTextPerformanceReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountName
    AccountNumber
    AdDistribution
    AdGroupId
    AdGroupName
    AdId
    AdTitle
    AdType
    AverageCpc
    AverageCpm
    AveragePosition
    Clicks
    ConversionRate
    Conversions
    CostPerConversion
    Ctr
    CurrencyCode
    DestinationUrl
    Impressions
    Keyword
    LanguageAndRegion
    Param1
    Param2
    Param3
    PricingModel
    Spend
    TimePeriod

=cut

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdDistribution {
    return 'AdDistribution';
}

sub AdGroupId {
    return 'AdGroupId';
}

sub AdGroupName {
    return 'AdGroupName';
}

sub AdId {
    return 'AdId';
}

sub AdTitle {
    return 'AdTitle';
}

sub AdType {
    return 'AdType';
}

sub AverageCpc {
    return 'AverageCpc';
}

sub AverageCpm {
    return 'AverageCpm';
}

sub AveragePosition {
    return 'AveragePosition';
}

sub Clicks {
    return 'Clicks';
}

sub ConversionRate {
    return 'ConversionRate';
}

sub Conversions {
    return 'Conversions';
}

sub CostPerConversion {
    return 'CostPerConversion';
}

sub Ctr {
    return 'Ctr';
}

sub CurrencyCode {
    return 'CurrencyCode';
}

sub DestinationUrl {
    return 'DestinationUrl';
}

sub Impressions {
    return 'Impressions';
}

sub Keyword {
    return 'Keyword';
}

sub LanguageAndRegion {
    return 'LanguageAndRegion';
}

sub Param1 {
    return 'Param1';
}

sub Param2 {
    return 'Param2';
}

sub Param3 {
    return 'Param3';
}

sub PricingModel {
    return 'PricingModel';
}

sub Spend {
    return 'Spend';
}

sub TimePeriod {
    return 'TimePeriod';
}

1;
