/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.util;

import java.util.Iterator;
import java.util.List;
import opennlp.common.synsem.Category;
import opennlp.common.unify.ModFcn;
import opennlp.common.unify.Substitution;
import opennlp.common.unify.UnifyFailure;
import opennlp.common.unify.Variable;

public class CatList {
    private Category[] _list;

    public CatList() {
        this._list = new Category[0];
    }

    public CatList(Category c) {
        this._list = new Category[1];
        this._list[0] = c;
    }

    public CatList(Category[] list) {
        this._list = list;
    }

    public CatList(List cats) {
        this._list = new Category[cats.size()];
        int index = 0;
        Iterator i = cats.iterator();
        while (i.hasNext()) {
            this._list[index++] = (Category)i.next();
        }
    }

    public Category get(int i) {
        return this._list[i];
    }

    public void set(int i, Category c) {
        this._list[i] = c;
    }

    public Category getLast() {
        return this._list[this._list.length - 1];
    }

    public void add(Category c) {
        Category[] $list = new Category[this._list.length + 1];
        int last = CatList.insert(this._list, $list, 0);
        $list[last] = c;
        this._list = $list;
    }

    public void add(CatList cl) {
        Category[] $list = new Category[this._list.length + cl._list.length];
        int last = CatList.insert(this._list, $list, 0);
        CatList.insert(cl._list, $list, last);
        this._list = $list;
    }

    public void addFront(Category c) {
        Category[] $list = new Category[this._list.length + 1];
        $list[0] = c;
        CatList.insert(this._list, $list, 1);
        this._list = $list;
    }

    public int size() {
        return this._list.length;
    }

    public CatList copy() {
        Category[] $list = new Category[this._list.length];
        int i = 0;
        while (i < $list.length) {
            $list[i] = this._list[i].copy();
            ++i;
        }
        return new CatList($list);
    }

    public CatList copyWithout(int indexToRemove) {
        Category[] $list = new Category[this._list.length - 1];
        int index = 0;
        int i = 0;
        while (i < this._list.length) {
            if (i != indexToRemove) {
                $list[index++] = this._list[i].copy();
            }
            ++i;
        }
        return new CatList($list);
    }

    public CatList subList(int from) {
        return this.subList(from, this._list.length);
    }

    public CatList subList(int from, int upto) {
        Category[] $list = new Category[upto - from];
        int index = 0;
        int i = from;
        while (i < upto) {
            $list[index++] = this._list[i];
            ++i;
        }
        return new CatList($list);
    }

    public boolean occurs(Variable v) {
        int i = 0;
        while (i < this._list.length) {
            if (this._list[i].occurs(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CatList fill(Substitution s) throws UnifyFailure {
        Category[] $list = new Category[this._list.length];
        int i = 0;
        while (i < this._list.length) {
            $list[i] = (Category)this._list[i].fill(s);
            ++i;
        }
        return new CatList($list);
    }

    public void deepMap(ModFcn mf) {
        int i = 0;
        while (i < this._list.length) {
            this._list[i].deepMap(mf);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(10);
        sb.append(this._list[0].toString());
        int i = 1;
        while (i < this._list.length) {
            sb.append(',').append(this._list[i].toString());
            ++i;
        }
        return sb.toString();
    }

    private static int insert(Category[] a, Category[] b, int pos) {
        int i = 0;
        while (i < a.length) {
            b[pos++] = a[i];
            ++i;
        }
        return pos;
    }
}

